// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateConfigurationItemsToApplication = "AssociateConfigurationItemsToApplication"

// AssociateConfigurationItemsToApplicationRequest generates a "aws/request.Request" representing the
// client's request for the AssociateConfigurationItemsToApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateConfigurationItemsToApplication for more information on using the AssociateConfigurationItemsToApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateConfigurationItemsToApplicationRequest method.
//    req, resp := client.AssociateConfigurationItemsToApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/AssociateConfigurationItemsToApplication
func (c *ApplicationDiscoveryService) AssociateConfigurationItemsToApplicationRequest(input *AssociateConfigurationItemsToApplicationInput) (req *request.Request, output *AssociateConfigurationItemsToApplicationOutput) {
	op := &request.Operation{
		Name:       opAssociateConfigurationItemsToApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateConfigurationItemsToApplicationInput{}
	}

	output = &AssociateConfigurationItemsToApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateConfigurationItemsToApplication API operation for AWS Application Discovery Service.
//
// Associates one or more configuration items with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation AssociateConfigurationItemsToApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/AssociateConfigurationItemsToApplication
func (c *ApplicationDiscoveryService) AssociateConfigurationItemsToApplication(input *AssociateConfigurationItemsToApplicationInput) (*AssociateConfigurationItemsToApplicationOutput, error) {
	req, out := c.AssociateConfigurationItemsToApplicationRequest(input)
	return out, req.Send()
}

// AssociateConfigurationItemsToApplicationWithContext is the same as AssociateConfigurationItemsToApplication with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateConfigurationItemsToApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) AssociateConfigurationItemsToApplicationWithContext(ctx aws.Context, input *AssociateConfigurationItemsToApplicationInput, opts ...request.Option) (*AssociateConfigurationItemsToApplicationOutput, error) {
	req, out := c.AssociateConfigurationItemsToApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteImportData = "BatchDeleteImportData"

// BatchDeleteImportDataRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteImportData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteImportData for more information on using the BatchDeleteImportData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteImportDataRequest method.
//    req, resp := client.BatchDeleteImportDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/BatchDeleteImportData
func (c *ApplicationDiscoveryService) BatchDeleteImportDataRequest(input *BatchDeleteImportDataInput) (req *request.Request, output *BatchDeleteImportDataOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteImportData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteImportDataInput{}
	}

	output = &BatchDeleteImportDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteImportData API operation for AWS Application Discovery Service.
//
// Deletes one or more import tasks, each identified by their import ID. Each
// import task has a number of records that can identify servers or applications.
//
// AWS Application Discovery Service has built-in matching logic that will identify
// when discovered servers match existing entries that you've previously discovered,
// the information for the already-existing discovered server is updated. When
// you delete an import task that contains records that were used to match,
// the information in those matched records that comes from the deleted records
// will also be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation BatchDeleteImportData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/BatchDeleteImportData
func (c *ApplicationDiscoveryService) BatchDeleteImportData(input *BatchDeleteImportDataInput) (*BatchDeleteImportDataOutput, error) {
	req, out := c.BatchDeleteImportDataRequest(input)
	return out, req.Send()
}

// BatchDeleteImportDataWithContext is the same as BatchDeleteImportData with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteImportData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) BatchDeleteImportDataWithContext(ctx aws.Context, input *BatchDeleteImportDataInput, opts ...request.Option) (*BatchDeleteImportDataOutput, error) {
	req, out := c.BatchDeleteImportDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/CreateApplication
func (c *ApplicationDiscoveryService) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWS Application Discovery Service.
//
// Creates an application with the given name and description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation CreateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/CreateApplication
func (c *ApplicationDiscoveryService) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/CreateTags
func (c *ApplicationDiscoveryService) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for AWS Application Discovery Service.
//
// Creates one or more tags for configuration items. Tags are metadata that
// help you categorize IT assets. This API accepts a list of multiple configuration
// items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation CreateTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/CreateTags
func (c *ApplicationDiscoveryService) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplications = "DeleteApplications"

// DeleteApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplications for more information on using the DeleteApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationsRequest method.
//    req, resp := client.DeleteApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DeleteApplications
func (c *ApplicationDiscoveryService) DeleteApplicationsRequest(input *DeleteApplicationsInput) (req *request.Request, output *DeleteApplicationsOutput) {
	op := &request.Operation{
		Name:       opDeleteApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationsInput{}
	}

	output = &DeleteApplicationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplications API operation for AWS Application Discovery Service.
//
// Deletes a list of applications and their associations with configuration
// items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DeleteApplications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DeleteApplications
func (c *ApplicationDiscoveryService) DeleteApplications(input *DeleteApplicationsInput) (*DeleteApplicationsOutput, error) {
	req, out := c.DeleteApplicationsRequest(input)
	return out, req.Send()
}

// DeleteApplicationsWithContext is the same as DeleteApplications with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DeleteApplicationsWithContext(ctx aws.Context, input *DeleteApplicationsInput, opts ...request.Option) (*DeleteApplicationsOutput, error) {
	req, out := c.DeleteApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DeleteTags
func (c *ApplicationDiscoveryService) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for AWS Application Discovery Service.
//
// Deletes the association between configuration items and one or more tags.
// This API accepts a list of multiple configuration items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DeleteTags
func (c *ApplicationDiscoveryService) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAgents = "DescribeAgents"

// DescribeAgentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAgents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAgents for more information on using the DescribeAgents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAgentsRequest method.
//    req, resp := client.DescribeAgentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeAgents
func (c *ApplicationDiscoveryService) DescribeAgentsRequest(input *DescribeAgentsInput) (req *request.Request, output *DescribeAgentsOutput) {
	op := &request.Operation{
		Name:       opDescribeAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgentsInput{}
	}

	output = &DescribeAgentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAgents API operation for AWS Application Discovery Service.
//
// Lists agents or connectors as specified by ID or other filters. All agents/connectors
// associated with your user account can be listed if you call DescribeAgents
// as is without passing any parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeAgents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeAgents
func (c *ApplicationDiscoveryService) DescribeAgents(input *DescribeAgentsInput) (*DescribeAgentsOutput, error) {
	req, out := c.DescribeAgentsRequest(input)
	return out, req.Send()
}

// DescribeAgentsWithContext is the same as DescribeAgents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAgents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeAgentsWithContext(ctx aws.Context, input *DescribeAgentsInput, opts ...request.Option) (*DescribeAgentsOutput, error) {
	req, out := c.DescribeAgentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurations = "DescribeConfigurations"

// DescribeConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurations for more information on using the DescribeConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationsRequest method.
//    req, resp := client.DescribeConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeConfigurations
func (c *ApplicationDiscoveryService) DescribeConfigurationsRequest(input *DescribeConfigurationsInput) (req *request.Request, output *DescribeConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationsInput{}
	}

	output = &DescribeConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurations API operation for AWS Application Discovery Service.
//
// Retrieves attributes for a list of configuration item IDs.
//
// All of the supplied IDs must be for the same asset type from one of the following:
//
// server
//
// application
//
// process
//
// connection
//
// Output fields are specific to the asset type specified. For example, the
// output for a server configuration item includes a list of attributes about
// the server, such as host name, operating system, number of network cards,
// etc.
//
// For a complete list of outputs for each asset type, see Using the DescribeConfigurations
// Action (http://docs.aws.amazon.com/application-discovery/latest/APIReference/discovery-api-queries.html#DescribeConfigurations).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeConfigurations
func (c *ApplicationDiscoveryService) DescribeConfigurations(input *DescribeConfigurationsInput) (*DescribeConfigurationsOutput, error) {
	req, out := c.DescribeConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeConfigurationsWithContext is the same as DescribeConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeConfigurationsWithContext(ctx aws.Context, input *DescribeConfigurationsInput, opts ...request.Option) (*DescribeConfigurationsOutput, error) {
	req, out := c.DescribeConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContinuousExports = "DescribeContinuousExports"

// DescribeContinuousExportsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContinuousExports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContinuousExports for more information on using the DescribeContinuousExports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeContinuousExportsRequest method.
//    req, resp := client.DescribeContinuousExportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeContinuousExports
func (c *ApplicationDiscoveryService) DescribeContinuousExportsRequest(input *DescribeContinuousExportsInput) (req *request.Request, output *DescribeContinuousExportsOutput) {
	op := &request.Operation{
		Name:       opDescribeContinuousExports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeContinuousExportsInput{}
	}

	output = &DescribeContinuousExportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContinuousExports API operation for AWS Application Discovery Service.
//
// Lists exports as specified by ID. All continuous exports associated with
// your user account can be listed if you call DescribeContinuousExports as
// is without passing any parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeContinuousExports for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This operation is not permitted.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeContinuousExports
func (c *ApplicationDiscoveryService) DescribeContinuousExports(input *DescribeContinuousExportsInput) (*DescribeContinuousExportsOutput, error) {
	req, out := c.DescribeContinuousExportsRequest(input)
	return out, req.Send()
}

// DescribeContinuousExportsWithContext is the same as DescribeContinuousExports with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContinuousExports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeContinuousExportsWithContext(ctx aws.Context, input *DescribeContinuousExportsInput, opts ...request.Option) (*DescribeContinuousExportsOutput, error) {
	req, out := c.DescribeContinuousExportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeContinuousExportsPages iterates over the pages of a DescribeContinuousExports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeContinuousExports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeContinuousExports operation.
//    pageNum := 0
//    err := client.DescribeContinuousExportsPages(params,
//        func(page *DescribeContinuousExportsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationDiscoveryService) DescribeContinuousExportsPages(input *DescribeContinuousExportsInput, fn func(*DescribeContinuousExportsOutput, bool) bool) error {
	return c.DescribeContinuousExportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeContinuousExportsPagesWithContext same as DescribeContinuousExportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeContinuousExportsPagesWithContext(ctx aws.Context, input *DescribeContinuousExportsInput, fn func(*DescribeContinuousExportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeContinuousExportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeContinuousExportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeContinuousExportsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeExportConfigurations = "DescribeExportConfigurations"

// DescribeExportConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExportConfigurations for more information on using the DescribeExportConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExportConfigurationsRequest method.
//    req, resp := client.DescribeExportConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeExportConfigurations
//
// Deprecated: DescribeExportConfigurations has been deprecated
func (c *ApplicationDiscoveryService) DescribeExportConfigurationsRequest(input *DescribeExportConfigurationsInput) (req *request.Request, output *DescribeExportConfigurationsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeExportConfigurations, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeExportConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportConfigurationsInput{}
	}

	output = &DescribeExportConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportConfigurations API operation for AWS Application Discovery Service.
//
// DescribeExportConfigurations is deprecated.
//
// Use instead DescribeExportTasks (http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeExportConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeExportConfigurations
//
// Deprecated: DescribeExportConfigurations has been deprecated
func (c *ApplicationDiscoveryService) DescribeExportConfigurations(input *DescribeExportConfigurationsInput) (*DescribeExportConfigurationsOutput, error) {
	req, out := c.DescribeExportConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeExportConfigurationsWithContext is the same as DescribeExportConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExportConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: DescribeExportConfigurationsWithContext has been deprecated
func (c *ApplicationDiscoveryService) DescribeExportConfigurationsWithContext(ctx aws.Context, input *DescribeExportConfigurationsInput, opts ...request.Option) (*DescribeExportConfigurationsOutput, error) {
	req, out := c.DescribeExportConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExportTasks = "DescribeExportTasks"

// DescribeExportTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExportTasks for more information on using the DescribeExportTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExportTasksRequest method.
//    req, resp := client.DescribeExportTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeExportTasks
func (c *ApplicationDiscoveryService) DescribeExportTasksRequest(input *DescribeExportTasksInput) (req *request.Request, output *DescribeExportTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeExportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportTasksInput{}
	}

	output = &DescribeExportTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportTasks API operation for AWS Application Discovery Service.
//
// Retrieve status of one or more export tasks. You can retrieve the status
// of up to 100 export tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeExportTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeExportTasks
func (c *ApplicationDiscoveryService) DescribeExportTasks(input *DescribeExportTasksInput) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	return out, req.Send()
}

// DescribeExportTasksWithContext is the same as DescribeExportTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExportTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeExportTasksWithContext(ctx aws.Context, input *DescribeExportTasksInput, opts ...request.Option) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImportTasks = "DescribeImportTasks"

// DescribeImportTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImportTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImportTasks for more information on using the DescribeImportTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImportTasksRequest method.
//    req, resp := client.DescribeImportTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeImportTasks
func (c *ApplicationDiscoveryService) DescribeImportTasksRequest(input *DescribeImportTasksInput) (req *request.Request, output *DescribeImportTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeImportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImportTasksInput{}
	}

	output = &DescribeImportTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImportTasks API operation for AWS Application Discovery Service.
//
// Returns an array of import tasks for your account, including status information,
// times, IDs, the Amazon S3 Object URL for the import file, and more.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeImportTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeImportTasks
func (c *ApplicationDiscoveryService) DescribeImportTasks(input *DescribeImportTasksInput) (*DescribeImportTasksOutput, error) {
	req, out := c.DescribeImportTasksRequest(input)
	return out, req.Send()
}

// DescribeImportTasksWithContext is the same as DescribeImportTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImportTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeImportTasksWithContext(ctx aws.Context, input *DescribeImportTasksInput, opts ...request.Option) (*DescribeImportTasksOutput, error) {
	req, out := c.DescribeImportTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImportTasksPages iterates over the pages of a DescribeImportTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImportTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeImportTasks operation.
//    pageNum := 0
//    err := client.DescribeImportTasksPages(params,
//        func(page *DescribeImportTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationDiscoveryService) DescribeImportTasksPages(input *DescribeImportTasksInput, fn func(*DescribeImportTasksOutput, bool) bool) error {
	return c.DescribeImportTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImportTasksPagesWithContext same as DescribeImportTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeImportTasksPagesWithContext(ctx aws.Context, input *DescribeImportTasksInput, fn func(*DescribeImportTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImportTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImportTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeImportTasksOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeTags
func (c *ApplicationDiscoveryService) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for AWS Application Discovery Service.
//
// Retrieves a list of configuration items that have tags as specified by the
// key-value pairs, name and value, passed to the optional parameter filters.
//
// There are three valid tag filter names:
//
//    * tagKey
//
//    * tagValue
//
//    * configurationId
//
// Also, all configuration items associated with your user account that have
// tags can be listed if you call DescribeTags as is without passing any parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeTags
func (c *ApplicationDiscoveryService) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateConfigurationItemsFromApplication = "DisassociateConfigurationItemsFromApplication"

// DisassociateConfigurationItemsFromApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateConfigurationItemsFromApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateConfigurationItemsFromApplication for more information on using the DisassociateConfigurationItemsFromApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateConfigurationItemsFromApplicationRequest method.
//    req, resp := client.DisassociateConfigurationItemsFromApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DisassociateConfigurationItemsFromApplication
func (c *ApplicationDiscoveryService) DisassociateConfigurationItemsFromApplicationRequest(input *DisassociateConfigurationItemsFromApplicationInput) (req *request.Request, output *DisassociateConfigurationItemsFromApplicationOutput) {
	op := &request.Operation{
		Name:       opDisassociateConfigurationItemsFromApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConfigurationItemsFromApplicationInput{}
	}

	output = &DisassociateConfigurationItemsFromApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateConfigurationItemsFromApplication API operation for AWS Application Discovery Service.
//
// Disassociates one or more configuration items from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation DisassociateConfigurationItemsFromApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DisassociateConfigurationItemsFromApplication
func (c *ApplicationDiscoveryService) DisassociateConfigurationItemsFromApplication(input *DisassociateConfigurationItemsFromApplicationInput) (*DisassociateConfigurationItemsFromApplicationOutput, error) {
	req, out := c.DisassociateConfigurationItemsFromApplicationRequest(input)
	return out, req.Send()
}

// DisassociateConfigurationItemsFromApplicationWithContext is the same as DisassociateConfigurationItemsFromApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateConfigurationItemsFromApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) DisassociateConfigurationItemsFromApplicationWithContext(ctx aws.Context, input *DisassociateConfigurationItemsFromApplicationInput, opts ...request.Option) (*DisassociateConfigurationItemsFromApplicationOutput, error) {
	req, out := c.DisassociateConfigurationItemsFromApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportConfigurations = "ExportConfigurations"

// ExportConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ExportConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportConfigurations for more information on using the ExportConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportConfigurationsRequest method.
//    req, resp := client.ExportConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ExportConfigurations
//
// Deprecated: ExportConfigurations has been deprecated
func (c *ApplicationDiscoveryService) ExportConfigurationsRequest(input *ExportConfigurationsInput) (req *request.Request, output *ExportConfigurationsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ExportConfigurations, has been deprecated")
	}
	op := &request.Operation{
		Name:       opExportConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportConfigurationsInput{}
	}

	output = &ExportConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportConfigurations API operation for AWS Application Discovery Service.
//
// Deprecated. Use StartExportTask instead.
//
// Exports all discovered configuration data to an Amazon S3 bucket or an application
// that enables you to view and evaluate the data. Data includes tags and tag
// associations, processes, connections, servers, and system performance. This
// API returns an export ID that you can query using the DescribeExportConfigurations
// API. The system imposes a limit of two configuration exports in six hours.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation ExportConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ExportConfigurations
//
// Deprecated: ExportConfigurations has been deprecated
func (c *ApplicationDiscoveryService) ExportConfigurations(input *ExportConfigurationsInput) (*ExportConfigurationsOutput, error) {
	req, out := c.ExportConfigurationsRequest(input)
	return out, req.Send()
}

// ExportConfigurationsWithContext is the same as ExportConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ExportConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: ExportConfigurationsWithContext has been deprecated
func (c *ApplicationDiscoveryService) ExportConfigurationsWithContext(ctx aws.Context, input *ExportConfigurationsInput, opts ...request.Option) (*ExportConfigurationsOutput, error) {
	req, out := c.ExportConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiscoverySummary = "GetDiscoverySummary"

// GetDiscoverySummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetDiscoverySummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiscoverySummary for more information on using the GetDiscoverySummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiscoverySummaryRequest method.
//    req, resp := client.GetDiscoverySummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/GetDiscoverySummary
func (c *ApplicationDiscoveryService) GetDiscoverySummaryRequest(input *GetDiscoverySummaryInput) (req *request.Request, output *GetDiscoverySummaryOutput) {
	op := &request.Operation{
		Name:       opGetDiscoverySummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiscoverySummaryInput{}
	}

	output = &GetDiscoverySummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiscoverySummary API operation for AWS Application Discovery Service.
//
// Retrieves a short summary of discovered assets.
//
// This API operation takes no request parameters and is called as is at the
// command prompt as shown in the example.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation GetDiscoverySummary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/GetDiscoverySummary
func (c *ApplicationDiscoveryService) GetDiscoverySummary(input *GetDiscoverySummaryInput) (*GetDiscoverySummaryOutput, error) {
	req, out := c.GetDiscoverySummaryRequest(input)
	return out, req.Send()
}

// GetDiscoverySummaryWithContext is the same as GetDiscoverySummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiscoverySummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) GetDiscoverySummaryWithContext(ctx aws.Context, input *GetDiscoverySummaryInput, opts ...request.Option) (*GetDiscoverySummaryOutput, error) {
	req, out := c.GetDiscoverySummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConfigurations = "ListConfigurations"

// ListConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurations for more information on using the ListConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationsRequest method.
//    req, resp := client.ListConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ListConfigurations
func (c *ApplicationDiscoveryService) ListConfigurationsRequest(input *ListConfigurationsInput) (req *request.Request, output *ListConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListConfigurationsInput{}
	}

	output = &ListConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurations API operation for AWS Application Discovery Service.
//
// Retrieves a list of configuration items as specified by the value passed
// to the required paramater configurationType. Optional filtering may be applied
// to refine search results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation ListConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ListConfigurations
func (c *ApplicationDiscoveryService) ListConfigurations(input *ListConfigurationsInput) (*ListConfigurationsOutput, error) {
	req, out := c.ListConfigurationsRequest(input)
	return out, req.Send()
}

// ListConfigurationsWithContext is the same as ListConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) ListConfigurationsWithContext(ctx aws.Context, input *ListConfigurationsInput, opts ...request.Option) (*ListConfigurationsOutput, error) {
	req, out := c.ListConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListServerNeighbors = "ListServerNeighbors"

// ListServerNeighborsRequest generates a "aws/request.Request" representing the
// client's request for the ListServerNeighbors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServerNeighbors for more information on using the ListServerNeighbors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServerNeighborsRequest method.
//    req, resp := client.ListServerNeighborsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ListServerNeighbors
func (c *ApplicationDiscoveryService) ListServerNeighborsRequest(input *ListServerNeighborsInput) (req *request.Request, output *ListServerNeighborsOutput) {
	op := &request.Operation{
		Name:       opListServerNeighbors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListServerNeighborsInput{}
	}

	output = &ListServerNeighborsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServerNeighbors API operation for AWS Application Discovery Service.
//
// Retrieves a list of servers that are one network hop away from a specified
// server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation ListServerNeighbors for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ListServerNeighbors
func (c *ApplicationDiscoveryService) ListServerNeighbors(input *ListServerNeighborsInput) (*ListServerNeighborsOutput, error) {
	req, out := c.ListServerNeighborsRequest(input)
	return out, req.Send()
}

// ListServerNeighborsWithContext is the same as ListServerNeighbors with the addition of
// the ability to pass a context and additional request options.
//
// See ListServerNeighbors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) ListServerNeighborsWithContext(ctx aws.Context, input *ListServerNeighborsInput, opts ...request.Option) (*ListServerNeighborsOutput, error) {
	req, out := c.ListServerNeighborsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartContinuousExport = "StartContinuousExport"

// StartContinuousExportRequest generates a "aws/request.Request" representing the
// client's request for the StartContinuousExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartContinuousExport for more information on using the StartContinuousExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartContinuousExportRequest method.
//    req, resp := client.StartContinuousExportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartContinuousExport
func (c *ApplicationDiscoveryService) StartContinuousExportRequest(input *StartContinuousExportInput) (req *request.Request, output *StartContinuousExportOutput) {
	op := &request.Operation{
		Name:       opStartContinuousExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartContinuousExportInput{}
	}

	output = &StartContinuousExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartContinuousExport API operation for AWS Application Discovery Service.
//
// Start the continuous flow of agent's discovered data into Amazon Athena.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StartContinuousExport for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConflictErrorException "ConflictErrorException"
//
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This operation is not permitted.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   This issue occurs when the same clientRequestToken is used with the StartImportTask
//   action, but with different parameters. For example, you use the same request
//   token but have two different import URLs, you can encounter this issue. If
//   the import tasks are meant to be different, use a different clientRequestToken,
//   and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartContinuousExport
func (c *ApplicationDiscoveryService) StartContinuousExport(input *StartContinuousExportInput) (*StartContinuousExportOutput, error) {
	req, out := c.StartContinuousExportRequest(input)
	return out, req.Send()
}

// StartContinuousExportWithContext is the same as StartContinuousExport with the addition of
// the ability to pass a context and additional request options.
//
// See StartContinuousExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) StartContinuousExportWithContext(ctx aws.Context, input *StartContinuousExportInput, opts ...request.Option) (*StartContinuousExportOutput, error) {
	req, out := c.StartContinuousExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDataCollectionByAgentIds = "StartDataCollectionByAgentIds"

// StartDataCollectionByAgentIdsRequest generates a "aws/request.Request" representing the
// client's request for the StartDataCollectionByAgentIds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDataCollectionByAgentIds for more information on using the StartDataCollectionByAgentIds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDataCollectionByAgentIdsRequest method.
//    req, resp := client.StartDataCollectionByAgentIdsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartDataCollectionByAgentIds
func (c *ApplicationDiscoveryService) StartDataCollectionByAgentIdsRequest(input *StartDataCollectionByAgentIdsInput) (req *request.Request, output *StartDataCollectionByAgentIdsOutput) {
	op := &request.Operation{
		Name:       opStartDataCollectionByAgentIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDataCollectionByAgentIdsInput{}
	}

	output = &StartDataCollectionByAgentIdsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDataCollectionByAgentIds API operation for AWS Application Discovery Service.
//
// Instructs the specified agents or connectors to start collecting data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StartDataCollectionByAgentIds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartDataCollectionByAgentIds
func (c *ApplicationDiscoveryService) StartDataCollectionByAgentIds(input *StartDataCollectionByAgentIdsInput) (*StartDataCollectionByAgentIdsOutput, error) {
	req, out := c.StartDataCollectionByAgentIdsRequest(input)
	return out, req.Send()
}

// StartDataCollectionByAgentIdsWithContext is the same as StartDataCollectionByAgentIds with the addition of
// the ability to pass a context and additional request options.
//
// See StartDataCollectionByAgentIds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) StartDataCollectionByAgentIdsWithContext(ctx aws.Context, input *StartDataCollectionByAgentIdsInput, opts ...request.Option) (*StartDataCollectionByAgentIdsOutput, error) {
	req, out := c.StartDataCollectionByAgentIdsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExportTask = "StartExportTask"

// StartExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartExportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExportTask for more information on using the StartExportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartExportTaskRequest method.
//    req, resp := client.StartExportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartExportTask
func (c *ApplicationDiscoveryService) StartExportTaskRequest(input *StartExportTaskInput) (req *request.Request, output *StartExportTaskOutput) {
	op := &request.Operation{
		Name:       opStartExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExportTaskInput{}
	}

	output = &StartExportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExportTask API operation for AWS Application Discovery Service.
//
// Begins the export of discovered data to an S3 bucket.
//
// If you specify agentIds in a filter, the task exports up to 72 hours of detailed
// data collected by the identified Application Discovery Agent, including network,
// process, and performance details. A time range for exported agent data may
// be set by using startTime and endTime. Export of detailed agent data is limited
// to five concurrently running exports.
//
// If you do not include an agentIds filter, summary data is exported that includes
// both AWS Agentless Discovery Connector data and summary data from AWS Discovery
// Agents. Export of summary data is limited to two exports per day.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StartExportTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartExportTask
func (c *ApplicationDiscoveryService) StartExportTask(input *StartExportTaskInput) (*StartExportTaskOutput, error) {
	req, out := c.StartExportTaskRequest(input)
	return out, req.Send()
}

// StartExportTaskWithContext is the same as StartExportTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartExportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) StartExportTaskWithContext(ctx aws.Context, input *StartExportTaskInput, opts ...request.Option) (*StartExportTaskOutput, error) {
	req, out := c.StartExportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartImportTask = "StartImportTask"

// StartImportTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartImportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartImportTask for more information on using the StartImportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartImportTaskRequest method.
//    req, resp := client.StartImportTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartImportTask
func (c *ApplicationDiscoveryService) StartImportTaskRequest(input *StartImportTaskInput) (req *request.Request, output *StartImportTaskOutput) {
	op := &request.Operation{
		Name:       opStartImportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartImportTaskInput{}
	}

	output = &StartImportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartImportTask API operation for AWS Application Discovery Service.
//
// Starts an import task, which allows you to import details of your on-premises
// environment directly into AWS without having to use the Application Discovery
// Service (ADS) tools such as the Discovery Connector or Discovery Agent. This
// gives you the option to perform migration assessment and planning directly
// from your imported data, including the ability to group your devices as applications
// and track their migration status.
//
// To start an import request, do this:
//
// Download the specially formatted comma separated value (CSV) import template,
// which you can find here: https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv
// (https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv).
//
// Fill out the template with your server and application data.
//
// Upload your import file to an Amazon S3 bucket, and make a note of it's Object
// URL. Your import file must be in the CSV format.
//
// Use the console or the StartImportTask command with the AWS CLI or one of
// the AWS SDKs to import the records from your file.
//
// For more information, including step-by-step procedures, see Migration Hub
// Import (https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html)
// in the AWS Application Discovery Service User Guide.
//
// There are limits to the number of import tasks you can create (and delete)
// in an AWS account. For more information, see AWS Application Discovery Service
// Limits (https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html)
// in the AWS Application Discovery Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StartImportTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   This issue occurs when the same clientRequestToken is used with the StartImportTask
//   action, but with different parameters. For example, you use the same request
//   token but have two different import URLs, you can encounter this issue. If
//   the import tasks are meant to be different, use a different clientRequestToken,
//   and try again.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartImportTask
func (c *ApplicationDiscoveryService) StartImportTask(input *StartImportTaskInput) (*StartImportTaskOutput, error) {
	req, out := c.StartImportTaskRequest(input)
	return out, req.Send()
}

// StartImportTaskWithContext is the same as StartImportTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartImportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) StartImportTaskWithContext(ctx aws.Context, input *StartImportTaskInput, opts ...request.Option) (*StartImportTaskOutput, error) {
	req, out := c.StartImportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopContinuousExport = "StopContinuousExport"

// StopContinuousExportRequest generates a "aws/request.Request" representing the
// client's request for the StopContinuousExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopContinuousExport for more information on using the StopContinuousExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopContinuousExportRequest method.
//    req, resp := client.StopContinuousExportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StopContinuousExport
func (c *ApplicationDiscoveryService) StopContinuousExportRequest(input *StopContinuousExportInput) (req *request.Request, output *StopContinuousExportOutput) {
	op := &request.Operation{
		Name:       opStopContinuousExport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopContinuousExportInput{}
	}

	output = &StopContinuousExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopContinuousExport API operation for AWS Application Discovery Service.
//
// Stop the continuous flow of agent's discovered data into Amazon Athena.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StopContinuousExport for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This operation is not permitted.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified configuration ID was not located. Verify the configuration
//   ID and try again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   This issue occurs when the same clientRequestToken is used with the StartImportTask
//   action, but with different parameters. For example, you use the same request
//   token but have two different import URLs, you can encounter this issue. If
//   the import tasks are meant to be different, use a different clientRequestToken,
//   and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StopContinuousExport
func (c *ApplicationDiscoveryService) StopContinuousExport(input *StopContinuousExportInput) (*StopContinuousExportOutput, error) {
	req, out := c.StopContinuousExportRequest(input)
	return out, req.Send()
}

// StopContinuousExportWithContext is the same as StopContinuousExport with the addition of
// the ability to pass a context and additional request options.
//
// See StopContinuousExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) StopContinuousExportWithContext(ctx aws.Context, input *StopContinuousExportInput, opts ...request.Option) (*StopContinuousExportOutput, error) {
	req, out := c.StopContinuousExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDataCollectionByAgentIds = "StopDataCollectionByAgentIds"

// StopDataCollectionByAgentIdsRequest generates a "aws/request.Request" representing the
// client's request for the StopDataCollectionByAgentIds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDataCollectionByAgentIds for more information on using the StopDataCollectionByAgentIds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDataCollectionByAgentIdsRequest method.
//    req, resp := client.StopDataCollectionByAgentIdsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StopDataCollectionByAgentIds
func (c *ApplicationDiscoveryService) StopDataCollectionByAgentIdsRequest(input *StopDataCollectionByAgentIdsInput) (req *request.Request, output *StopDataCollectionByAgentIdsOutput) {
	op := &request.Operation{
		Name:       opStopDataCollectionByAgentIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDataCollectionByAgentIdsInput{}
	}

	output = &StopDataCollectionByAgentIdsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDataCollectionByAgentIds API operation for AWS Application Discovery Service.
//
// Instructs the specified agents or connectors to stop collecting data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation StopDataCollectionByAgentIds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StopDataCollectionByAgentIds
func (c *ApplicationDiscoveryService) StopDataCollectionByAgentIds(input *StopDataCollectionByAgentIdsInput) (*StopDataCollectionByAgentIdsOutput, error) {
	req, out := c.StopDataCollectionByAgentIdsRequest(input)
	return out, req.Send()
}

// StopDataCollectionByAgentIdsWithContext is the same as StopDataCollectionByAgentIds with the addition of
// the ability to pass a context and additional request options.
//
// See StopDataCollectionByAgentIds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) StopDataCollectionByAgentIdsWithContext(ctx aws.Context, input *StopDataCollectionByAgentIdsInput, opts ...request.Option) (*StopDataCollectionByAgentIdsOutput, error) {
	req, out := c.StopDataCollectionByAgentIdsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/UpdateApplication
func (c *ApplicationDiscoveryService) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateApplication API operation for AWS Application Discovery Service.
//
// Updates metadata about an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Application Discovery Service's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAuthorizationErrorException "AuthorizationErrorException"
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters are not valid. Verify the parameters and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value of one or more parameters are either invalid or out of range. Verify
//   the parameter values and try again.
//
//   * ErrCodeServerInternalErrorException "ServerInternalErrorException"
//   The server experienced an internal error. Try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/UpdateApplication
func (c *ApplicationDiscoveryService) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApplicationDiscoveryService) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Information about agents or connectors that were instructed to start collecting
// data. Information includes the agent/connector ID, a description of the operation,
// and whether the agent/connector configuration was updated.
type AgentConfigurationStatus struct {
	_ struct{} `type:"structure"`

	// The agent/connector ID.
	AgentId *string `locationName:"agentId" type:"string"`

	// A description of the operation performed.
	Description *string `locationName:"description" type:"string"`

	// Information about the status of the StartDataCollection and StopDataCollection
	// operations. The system has recorded the data collection operation. The agent/connector
	// receives this command the next time it polls for a new command.
	OperationSucceeded *bool `locationName:"operationSucceeded" type:"boolean"`
}

// String returns the string representation
func (s AgentConfigurationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentConfigurationStatus) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AgentConfigurationStatus) SetAgentId(v string) *AgentConfigurationStatus {
	s.AgentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentConfigurationStatus) SetDescription(v string) *AgentConfigurationStatus {
	s.Description = &v
	return s
}

// SetOperationSucceeded sets the OperationSucceeded field's value.
func (s *AgentConfigurationStatus) SetOperationSucceeded(v bool) *AgentConfigurationStatus {
	s.OperationSucceeded = &v
	return s
}

// Information about agents or connectors associated with the user’s AWS account.
// Information includes agent or connector IDs, IP addresses, media access control
// (MAC) addresses, agent or connector health, hostname where the agent or connector
// resides, and agent version for each agent.
type AgentInfo struct {
	_ struct{} `type:"structure"`

	// The agent or connector ID.
	AgentId *string `locationName:"agentId" type:"string"`

	// Network details about the host where the agent or connector resides.
	AgentNetworkInfoList []*AgentNetworkInfo `locationName:"agentNetworkInfoList" type:"list"`

	// Type of agent.
	AgentType *string `locationName:"agentType" type:"string"`

	// Status of the collection process for an agent or connector.
	CollectionStatus *string `locationName:"collectionStatus" type:"string"`

	// The ID of the connector.
	ConnectorId *string `locationName:"connectorId" type:"string"`

	// The health of the agent or connector.
	Health *string `locationName:"health" type:"string" enum:"AgentStatus"`

	// The name of the host where the agent or connector resides. The host can be
	// a server or virtual machine.
	HostName *string `locationName:"hostName" type:"string"`

	// Time since agent or connector health was reported.
	LastHealthPingTime *string `locationName:"lastHealthPingTime" type:"string"`

	// Agent's first registration timestamp in UTC.
	RegisteredTime *string `locationName:"registeredTime" type:"string"`

	// The agent or connector version.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s AgentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentInfo) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AgentInfo) SetAgentId(v string) *AgentInfo {
	s.AgentId = &v
	return s
}

// SetAgentNetworkInfoList sets the AgentNetworkInfoList field's value.
func (s *AgentInfo) SetAgentNetworkInfoList(v []*AgentNetworkInfo) *AgentInfo {
	s.AgentNetworkInfoList = v
	return s
}

// SetAgentType sets the AgentType field's value.
func (s *AgentInfo) SetAgentType(v string) *AgentInfo {
	s.AgentType = &v
	return s
}

// SetCollectionStatus sets the CollectionStatus field's value.
func (s *AgentInfo) SetCollectionStatus(v string) *AgentInfo {
	s.CollectionStatus = &v
	return s
}

// SetConnectorId sets the ConnectorId field's value.
func (s *AgentInfo) SetConnectorId(v string) *AgentInfo {
	s.ConnectorId = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *AgentInfo) SetHealth(v string) *AgentInfo {
	s.Health = &v
	return s
}

// SetHostName sets the HostName field's value.
func (s *AgentInfo) SetHostName(v string) *AgentInfo {
	s.HostName = &v
	return s
}

// SetLastHealthPingTime sets the LastHealthPingTime field's value.
func (s *AgentInfo) SetLastHealthPingTime(v string) *AgentInfo {
	s.LastHealthPingTime = &v
	return s
}

// SetRegisteredTime sets the RegisteredTime field's value.
func (s *AgentInfo) SetRegisteredTime(v string) *AgentInfo {
	s.RegisteredTime = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AgentInfo) SetVersion(v string) *AgentInfo {
	s.Version = &v
	return s
}

// Network details about the host where the agent/connector resides.
type AgentNetworkInfo struct {
	_ struct{} `type:"structure"`

	// The IP address for the host where the agent/connector resides.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// The MAC address for the host where the agent/connector resides.
	MacAddress *string `locationName:"macAddress" type:"string"`
}

// String returns the string representation
func (s AgentNetworkInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentNetworkInfo) GoString() string {
	return s.String()
}

// SetIpAddress sets the IpAddress field's value.
func (s *AgentNetworkInfo) SetIpAddress(v string) *AgentNetworkInfo {
	s.IpAddress = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *AgentNetworkInfo) SetMacAddress(v string) *AgentNetworkInfo {
	s.MacAddress = &v
	return s
}

type AssociateConfigurationItemsToApplicationInput struct {
	_ struct{} `type:"structure"`

	// The configuration ID of an application with which items are to be associated.
	//
	// ApplicationConfigurationId is a required field
	ApplicationConfigurationId *string `locationName:"applicationConfigurationId" type:"string" required:"true"`

	// The ID of each configuration item to be associated with an application.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s AssociateConfigurationItemsToApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateConfigurationItemsToApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateConfigurationItemsToApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateConfigurationItemsToApplicationInput"}
	if s.ApplicationConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationConfigurationId"))
	}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationConfigurationId sets the ApplicationConfigurationId field's value.
func (s *AssociateConfigurationItemsToApplicationInput) SetApplicationConfigurationId(v string) *AssociateConfigurationItemsToApplicationInput {
	s.ApplicationConfigurationId = &v
	return s
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *AssociateConfigurationItemsToApplicationInput) SetConfigurationIds(v []*string) *AssociateConfigurationItemsToApplicationInput {
	s.ConfigurationIds = v
	return s
}

type AssociateConfigurationItemsToApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateConfigurationItemsToApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateConfigurationItemsToApplicationOutput) GoString() string {
	return s.String()
}

// Error messages returned for each import task that you deleted as a response
// for this command.
type BatchDeleteImportDataError struct {
	_ struct{} `type:"structure"`

	// The type of error that occurred for a specific import task.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"BatchDeleteImportDataErrorCode"`

	// The description of the error that occurred for a specific import task.
	ErrorDescription *string `locationName:"errorDescription" type:"string"`

	// The unique import ID associated with the error that occurred.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`
}

// String returns the string representation
func (s BatchDeleteImportDataError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteImportDataError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchDeleteImportDataError) SetErrorCode(v string) *BatchDeleteImportDataError {
	s.ErrorCode = &v
	return s
}

// SetErrorDescription sets the ErrorDescription field's value.
func (s *BatchDeleteImportDataError) SetErrorDescription(v string) *BatchDeleteImportDataError {
	s.ErrorDescription = &v
	return s
}

// SetImportTaskId sets the ImportTaskId field's value.
func (s *BatchDeleteImportDataError) SetImportTaskId(v string) *BatchDeleteImportDataError {
	s.ImportTaskId = &v
	return s
}

type BatchDeleteImportDataInput struct {
	_ struct{} `type:"structure"`

	// The IDs for the import tasks that you want to delete.
	//
	// ImportTaskIds is a required field
	ImportTaskIds []*string `locationName:"importTaskIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteImportDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteImportDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteImportDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteImportDataInput"}
	if s.ImportTaskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportTaskIds"))
	}
	if s.ImportTaskIds != nil && len(s.ImportTaskIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImportTaskIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImportTaskIds sets the ImportTaskIds field's value.
func (s *BatchDeleteImportDataInput) SetImportTaskIds(v []*string) *BatchDeleteImportDataInput {
	s.ImportTaskIds = v
	return s
}

type BatchDeleteImportDataOutput struct {
	_ struct{} `type:"structure"`

	// Error messages returned for each import task that you deleted as a response
	// for this command.
	Errors []*BatchDeleteImportDataError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchDeleteImportDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteImportDataOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteImportDataOutput) SetErrors(v []*BatchDeleteImportDataError) *BatchDeleteImportDataOutput {
	s.Errors = v
	return s
}

// Tags for a configuration item. Tags are metadata that help you categorize
// IT assets.
type ConfigurationTag struct {
	_ struct{} `type:"structure"`

	// The configuration ID for the item to tag. You can specify a list of keys
	// and values.
	ConfigurationId *string `locationName:"configurationId" type:"string"`

	// A type of IT asset to tag.
	ConfigurationType *string `locationName:"configurationType" type:"string" enum:"ConfigurationItemType"`

	// A type of tag on which to filter. For example, serverType.
	Key *string `locationName:"key" type:"string"`

	// The time the configuration tag was created in Coordinated Universal Time
	// (UTC).
	TimeOfCreation *time.Time `locationName:"timeOfCreation" type:"timestamp"`

	// A value on which to filter. For example key = serverType and value = web
	// server.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ConfigurationTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationTag) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *ConfigurationTag) SetConfigurationId(v string) *ConfigurationTag {
	s.ConfigurationId = &v
	return s
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *ConfigurationTag) SetConfigurationType(v string) *ConfigurationTag {
	s.ConfigurationType = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ConfigurationTag) SetKey(v string) *ConfigurationTag {
	s.Key = &v
	return s
}

// SetTimeOfCreation sets the TimeOfCreation field's value.
func (s *ConfigurationTag) SetTimeOfCreation(v time.Time) *ConfigurationTag {
	s.TimeOfCreation = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConfigurationTag) SetValue(v string) *ConfigurationTag {
	s.Value = &v
	return s
}

// A list of continuous export descriptions.
type ContinuousExportDescription struct {
	_ struct{} `type:"structure"`

	// The type of data collector used to gather this data (currently only offered
	// for AGENT).
	DataSource *string `locationName:"dataSource" type:"string" enum:"DataSource"`

	// The unique ID assigned to this export.
	ExportId *string `locationName:"exportId" type:"string"`

	// The name of the s3 bucket where the export data parquet files are stored.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// An object which describes how the data is stored.
	//
	//    * databaseName - the name of the Glue database used to store the schema.
	SchemaStorageConfig map[string]*string `locationName:"schemaStorageConfig" type:"map"`

	// The timestamp representing when the continuous export was started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Describes the status of the export. Can be one of the following values:
	//
	//    * START_IN_PROGRESS - setting up resources to start continuous export.
	//
	//    * START_FAILED - an error occurred setting up continuous export. To recover,
	//    call start-continuous-export again.
	//
	//    * ACTIVE - data is being exported to the customer bucket.
	//
	//    * ERROR - an error occurred during export. To fix the issue, call stop-continuous-export
	//    and start-continuous-export.
	//
	//    * STOP_IN_PROGRESS - stopping the export.
	//
	//    * STOP_FAILED - an error occurred stopping the export. To recover, call
	//    stop-continuous-export again.
	//
	//    * INACTIVE - the continuous export has been stopped. Data is no longer
	//    being exported to the customer bucket.
	Status *string `locationName:"status" type:"string" enum:"ContinuousExportStatus"`

	// Contains information about any errors that have occurred. This data type
	// can have the following values:
	//
	//    * ACCESS_DENIED - You don’t have permission to start Data Exploration
	//    in Amazon Athena. Contact your AWS administrator for help. For more information,
	//    see Setting Up AWS Application Discovery Service (http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html)
	//    in the Application Discovery Service User Guide.
	//
	//    * DELIVERY_STREAM_LIMIT_FAILURE - You reached the limit for Amazon Kinesis
	//    Data Firehose delivery streams. Reduce the number of streams or request
	//    a limit increase and try again. For more information, see Kinesis Data
	//    Streams Limits (http://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html)
	//    in the Amazon Kinesis Data Streams Developer Guide.
	//
	//    * FIREHOSE_ROLE_MISSING - The Data Exploration feature is in an error
	//    state because your IAM User is missing the AWSApplicationDiscoveryServiceFirehose
	//    role. Turn on Data Exploration in Amazon Athena and try again. For more
	//    information, see Step 3: Provide Application Discovery Service Access
	//    to Non-Administrator Users by Attaching Policies (http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html#setting-up-user-policy)
	//    in the Application Discovery Service User Guide.
	//
	//    * FIREHOSE_STREAM_DOES_NOT_EXIST - The Data Exploration feature is in
	//    an error state because your IAM User is missing one or more of the Kinesis
	//    data delivery streams.
	//
	//    * INTERNAL_FAILURE - The Data Exploration feature is in an error state
	//    because of an internal failure. Try again later. If this problem persists,
	//    contact AWS Support.
	//
	//    * S3_BUCKET_LIMIT_FAILURE - You reached the limit for Amazon S3 buckets.
	//    Reduce the number of Amazon S3 buckets or request a limit increase and
	//    try again. For more information, see Bucket Restrictions and Limitations
	//    (http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html)
	//    in the Amazon Simple Storage Service Developer Guide.
	//
	//    * S3_NOT_SIGNED_UP - Your account is not signed up for the Amazon S3 service.
	//    You must sign up before you can use Amazon S3. You can sign up at the
	//    following URL: https://aws.amazon.com/s3 (https://aws.amazon.com/s3).
	StatusDetail *string `locationName:"statusDetail" min:"1" type:"string"`

	// The timestamp that represents when this continuous export was stopped.
	StopTime *time.Time `locationName:"stopTime" type:"timestamp"`
}

// String returns the string representation
func (s ContinuousExportDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinuousExportDescription) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *ContinuousExportDescription) SetDataSource(v string) *ContinuousExportDescription {
	s.DataSource = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *ContinuousExportDescription) SetExportId(v string) *ContinuousExportDescription {
	s.ExportId = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *ContinuousExportDescription) SetS3Bucket(v string) *ContinuousExportDescription {
	s.S3Bucket = &v
	return s
}

// SetSchemaStorageConfig sets the SchemaStorageConfig field's value.
func (s *ContinuousExportDescription) SetSchemaStorageConfig(v map[string]*string) *ContinuousExportDescription {
	s.SchemaStorageConfig = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ContinuousExportDescription) SetStartTime(v time.Time) *ContinuousExportDescription {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ContinuousExportDescription) SetStatus(v string) *ContinuousExportDescription {
	s.Status = &v
	return s
}

// SetStatusDetail sets the StatusDetail field's value.
func (s *ContinuousExportDescription) SetStatusDetail(v string) *ContinuousExportDescription {
	s.StatusDetail = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *ContinuousExportDescription) SetStopTime(v time.Time) *ContinuousExportDescription {
	s.StopTime = &v
	return s
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Description of the application to be created.
	Description *string `locationName:"description" type:"string"`

	// Name of the application to be created.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInput) SetDescription(v string) *CreateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInput) SetName(v string) *CreateApplicationInput {
	s.Name = &v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of an application to be created.
	ConfigurationId *string `locationName:"configurationId" type:"string"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *CreateApplicationOutput) SetConfigurationId(v string) *CreateApplicationOutput {
	s.ConfigurationId = &v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration items that you want to tag.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`

	// Tags that you want to associate with one or more configuration items. Specify
	// the tags that you want to create in a key-value format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *CreateTagsInput) SetConfigurationIds(v []*string) *CreateTagsInput {
	s.ConfigurationIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

// Inventory data for installed discovery agents.
type CustomerAgentInfo struct {
	_ struct{} `type:"structure"`

	// Number of active discovery agents.
	//
	// ActiveAgents is a required field
	ActiveAgents *int64 `locationName:"activeAgents" type:"integer" required:"true"`

	// Number of blacklisted discovery agents.
	//
	// BlackListedAgents is a required field
	BlackListedAgents *int64 `locationName:"blackListedAgents" type:"integer" required:"true"`

	// Number of healthy discovery agents
	//
	// HealthyAgents is a required field
	HealthyAgents *int64 `locationName:"healthyAgents" type:"integer" required:"true"`

	// Number of discovery agents with status SHUTDOWN.
	//
	// ShutdownAgents is a required field
	ShutdownAgents *int64 `locationName:"shutdownAgents" type:"integer" required:"true"`

	// Total number of discovery agents.
	//
	// TotalAgents is a required field
	TotalAgents *int64 `locationName:"totalAgents" type:"integer" required:"true"`

	// Number of unhealthy discovery agents.
	//
	// UnhealthyAgents is a required field
	UnhealthyAgents *int64 `locationName:"unhealthyAgents" type:"integer" required:"true"`

	// Number of unknown discovery agents.
	//
	// UnknownAgents is a required field
	UnknownAgents *int64 `locationName:"unknownAgents" type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomerAgentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomerAgentInfo) GoString() string {
	return s.String()
}

// SetActiveAgents sets the ActiveAgents field's value.
func (s *CustomerAgentInfo) SetActiveAgents(v int64) *CustomerAgentInfo {
	s.ActiveAgents = &v
	return s
}

// SetBlackListedAgents sets the BlackListedAgents field's value.
func (s *CustomerAgentInfo) SetBlackListedAgents(v int64) *CustomerAgentInfo {
	s.BlackListedAgents = &v
	return s
}

// SetHealthyAgents sets the HealthyAgents field's value.
func (s *CustomerAgentInfo) SetHealthyAgents(v int64) *CustomerAgentInfo {
	s.HealthyAgents = &v
	return s
}

// SetShutdownAgents sets the ShutdownAgents field's value.
func (s *CustomerAgentInfo) SetShutdownAgents(v int64) *CustomerAgentInfo {
	s.ShutdownAgents = &v
	return s
}

// SetTotalAgents sets the TotalAgents field's value.
func (s *CustomerAgentInfo) SetTotalAgents(v int64) *CustomerAgentInfo {
	s.TotalAgents = &v
	return s
}

// SetUnhealthyAgents sets the UnhealthyAgents field's value.
func (s *CustomerAgentInfo) SetUnhealthyAgents(v int64) *CustomerAgentInfo {
	s.UnhealthyAgents = &v
	return s
}

// SetUnknownAgents sets the UnknownAgents field's value.
func (s *CustomerAgentInfo) SetUnknownAgents(v int64) *CustomerAgentInfo {
	s.UnknownAgents = &v
	return s
}

// Inventory data for installed discovery connectors.
type CustomerConnectorInfo struct {
	_ struct{} `type:"structure"`

	// Number of active discovery connectors.
	//
	// ActiveConnectors is a required field
	ActiveConnectors *int64 `locationName:"activeConnectors" type:"integer" required:"true"`

	// Number of blacklisted discovery connectors.
	//
	// BlackListedConnectors is a required field
	BlackListedConnectors *int64 `locationName:"blackListedConnectors" type:"integer" required:"true"`

	// Number of healthy discovery connectors.
	//
	// HealthyConnectors is a required field
	HealthyConnectors *int64 `locationName:"healthyConnectors" type:"integer" required:"true"`

	// Number of discovery connectors with status SHUTDOWN,
	//
	// ShutdownConnectors is a required field
	ShutdownConnectors *int64 `locationName:"shutdownConnectors" type:"integer" required:"true"`

	// Total number of discovery connectors.
	//
	// TotalConnectors is a required field
	TotalConnectors *int64 `locationName:"totalConnectors" type:"integer" required:"true"`

	// Number of unhealthy discovery connectors.
	//
	// UnhealthyConnectors is a required field
	UnhealthyConnectors *int64 `locationName:"unhealthyConnectors" type:"integer" required:"true"`

	// Number of unknown discovery connectors.
	//
	// UnknownConnectors is a required field
	UnknownConnectors *int64 `locationName:"unknownConnectors" type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomerConnectorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomerConnectorInfo) GoString() string {
	return s.String()
}

// SetActiveConnectors sets the ActiveConnectors field's value.
func (s *CustomerConnectorInfo) SetActiveConnectors(v int64) *CustomerConnectorInfo {
	s.ActiveConnectors = &v
	return s
}

// SetBlackListedConnectors sets the BlackListedConnectors field's value.
func (s *CustomerConnectorInfo) SetBlackListedConnectors(v int64) *CustomerConnectorInfo {
	s.BlackListedConnectors = &v
	return s
}

// SetHealthyConnectors sets the HealthyConnectors field's value.
func (s *CustomerConnectorInfo) SetHealthyConnectors(v int64) *CustomerConnectorInfo {
	s.HealthyConnectors = &v
	return s
}

// SetShutdownConnectors sets the ShutdownConnectors field's value.
func (s *CustomerConnectorInfo) SetShutdownConnectors(v int64) *CustomerConnectorInfo {
	s.ShutdownConnectors = &v
	return s
}

// SetTotalConnectors sets the TotalConnectors field's value.
func (s *CustomerConnectorInfo) SetTotalConnectors(v int64) *CustomerConnectorInfo {
	s.TotalConnectors = &v
	return s
}

// SetUnhealthyConnectors sets the UnhealthyConnectors field's value.
func (s *CustomerConnectorInfo) SetUnhealthyConnectors(v int64) *CustomerConnectorInfo {
	s.UnhealthyConnectors = &v
	return s
}

// SetUnknownConnectors sets the UnknownConnectors field's value.
func (s *CustomerConnectorInfo) SetUnknownConnectors(v int64) *CustomerConnectorInfo {
	s.UnknownConnectors = &v
	return s
}

type DeleteApplicationsInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of an application to be deleted.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *DeleteApplicationsInput) SetConfigurationIds(v []*string) *DeleteApplicationsInput {
	s.ConfigurationIds = v
	return s
}

type DeleteApplicationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationsOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration items with tags that you want to delete.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`

	// Tags that you want to delete from one or more configuration items. Specify
	// the tags that you want to delete in a key-value format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *DeleteTagsInput) SetConfigurationIds(v []*string) *DeleteTagsInput {
	s.ConfigurationIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeleteTagsInput) SetTags(v []*Tag) *DeleteTagsInput {
	s.Tags = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeAgentsInput struct {
	_ struct{} `type:"structure"`

	// The agent or the Connector IDs for which you want information. If you specify
	// no IDs, the system returns information about all agents/Connectors associated
	// with your AWS user account.
	AgentIds []*string `locationName:"agentIds" type:"list"`

	// You can filter the request using various logical operators and a key-value
	// format. For example:
	//
	// {"key": "collectionStatus", "value": "STARTED"}
	Filters []*Filter `locationName:"filters" type:"list"`

	// The total number of agents/Connectors to return in a single page of output.
	// The maximum value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Token to retrieve the next set of results. For example, if you previously
	// specified 100 IDs for DescribeAgentsRequest$agentIds but set DescribeAgentsRequest$maxResults
	// to 10, you received a set of 10 results along with a token. Use that token
	// in this query to get the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAgentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAgentsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentIds sets the AgentIds field's value.
func (s *DescribeAgentsInput) SetAgentIds(v []*string) *DescribeAgentsInput {
	s.AgentIds = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAgentsInput) SetFilters(v []*Filter) *DescribeAgentsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAgentsInput) SetMaxResults(v int64) *DescribeAgentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAgentsInput) SetNextToken(v string) *DescribeAgentsInput {
	s.NextToken = &v
	return s
}

type DescribeAgentsOutput struct {
	_ struct{} `type:"structure"`

	// Lists agents or the Connector by ID or lists all agents/Connectors associated
	// with your user account if you did not specify an agent/Connector ID. The
	// output includes agent/Connector IDs, IP addresses, media access control (MAC)
	// addresses, agent/Connector health, host name where the agent/Connector resides,
	// and the version number of each agent/Connector.
	AgentsInfo []*AgentInfo `locationName:"agentsInfo" type:"list"`

	// Token to retrieve the next set of results. For example, if you specified
	// 100 IDs for DescribeAgentsRequest$agentIds but set DescribeAgentsRequest$maxResults
	// to 10, you received a set of 10 results along with this token. Use this token
	// in the next query to retrieve the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentsOutput) GoString() string {
	return s.String()
}

// SetAgentsInfo sets the AgentsInfo field's value.
func (s *DescribeAgentsOutput) SetAgentsInfo(v []*AgentInfo) *DescribeAgentsOutput {
	s.AgentsInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAgentsOutput) SetNextToken(v string) *DescribeAgentsOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// One or more configuration IDs.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationsInput"}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *DescribeConfigurationsInput) SetConfigurationIds(v []*string) *DescribeConfigurationsInput {
	s.ConfigurationIds = v
	return s
}

type DescribeConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A key in the response map. The value is an array of data.
	Configurations []map[string]*string `locationName:"configurations" type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationsOutput) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *DescribeConfigurationsOutput) SetConfigurations(v []map[string]*string) *DescribeConfigurationsOutput {
	s.Configurations = v
	return s
}

type DescribeContinuousExportsInput struct {
	_ struct{} `type:"structure"`

	// The unique IDs assigned to the exports.
	ExportIds []*string `locationName:"exportIds" type:"list"`

	// A number between 1 and 100 specifying the maximum number of continuous export
	// descriptions returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token from the previous call to DescribeExportTasks.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeContinuousExportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContinuousExportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContinuousExportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeContinuousExportsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportIds sets the ExportIds field's value.
func (s *DescribeContinuousExportsInput) SetExportIds(v []*string) *DescribeContinuousExportsInput {
	s.ExportIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeContinuousExportsInput) SetMaxResults(v int64) *DescribeContinuousExportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeContinuousExportsInput) SetNextToken(v string) *DescribeContinuousExportsInput {
	s.NextToken = &v
	return s
}

type DescribeContinuousExportsOutput struct {
	_ struct{} `type:"structure"`

	// A list of continuous export descriptions.
	Descriptions []*ContinuousExportDescription `locationName:"descriptions" type:"list"`

	// The token from the previous call to DescribeExportTasks.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeContinuousExportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContinuousExportsOutput) GoString() string {
	return s.String()
}

// SetDescriptions sets the Descriptions field's value.
func (s *DescribeContinuousExportsOutput) SetDescriptions(v []*ContinuousExportDescription) *DescribeContinuousExportsOutput {
	s.Descriptions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeContinuousExportsOutput) SetNextToken(v string) *DescribeContinuousExportsOutput {
	s.NextToken = &v
	return s
}

type DescribeExportConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A list of continuous export ids to search for.
	ExportIds []*string `locationName:"exportIds" type:"list"`

	// A number between 1 and 100 specifying the maximum number of continuous export
	// descriptions returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token from the previous call to describe-export-tasks.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportConfigurationsInput) GoString() string {
	return s.String()
}

// SetExportIds sets the ExportIds field's value.
func (s *DescribeExportConfigurationsInput) SetExportIds(v []*string) *DescribeExportConfigurationsInput {
	s.ExportIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeExportConfigurationsInput) SetMaxResults(v int64) *DescribeExportConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeExportConfigurationsInput) SetNextToken(v string) *DescribeExportConfigurationsInput {
	s.NextToken = &v
	return s
}

type DescribeExportConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	ExportsInfo []*ExportInfo `locationName:"exportsInfo" type:"list"`

	// The token from the previous call to describe-export-tasks.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportConfigurationsOutput) GoString() string {
	return s.String()
}

// SetExportsInfo sets the ExportsInfo field's value.
func (s *DescribeExportConfigurationsOutput) SetExportsInfo(v []*ExportInfo) *DescribeExportConfigurationsOutput {
	s.ExportsInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeExportConfigurationsOutput) SetNextToken(v string) *DescribeExportConfigurationsOutput {
	s.NextToken = &v
	return s
}

type DescribeExportTasksInput struct {
	_ struct{} `type:"structure"`

	// One or more unique identifiers used to query the status of an export request.
	ExportIds []*string `locationName:"exportIds" type:"list"`

	// One or more filters.
	//
	//    * AgentId - ID of the agent whose collected data will be exported
	Filters []*ExportFilter `locationName:"filters" type:"list"`

	// The maximum number of volume results returned by DescribeExportTasks in paginated
	// output. When this parameter is used, DescribeExportTasks only returns maxResults
	// results in a single page along with a nextToken response element.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeExportTasks
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExportTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExportTasksInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportIds sets the ExportIds field's value.
func (s *DescribeExportTasksInput) SetExportIds(v []*string) *DescribeExportTasksInput {
	s.ExportIds = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeExportTasksInput) SetFilters(v []*ExportFilter) *DescribeExportTasksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeExportTasksInput) SetMaxResults(v int64) *DescribeExportTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeExportTasksInput) SetNextToken(v string) *DescribeExportTasksInput {
	s.NextToken = &v
	return s
}

type DescribeExportTasksOutput struct {
	_ struct{} `type:"structure"`

	// Contains one or more sets of export request details. When the status of a
	// request is SUCCEEDED, the response includes a URL for an Amazon S3 bucket
	// where you can view the data in a CSV file.
	ExportsInfo []*ExportInfo `locationName:"exportsInfo" type:"list"`

	// The nextToken value to include in a future DescribeExportTasks request. When
	// the results of a DescribeExportTasks request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeExportTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksOutput) GoString() string {
	return s.String()
}

// SetExportsInfo sets the ExportsInfo field's value.
func (s *DescribeExportTasksOutput) SetExportsInfo(v []*ExportInfo) *DescribeExportTasksOutput {
	s.ExportsInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeExportTasksOutput) SetNextToken(v string) *DescribeExportTasksOutput {
	s.NextToken = &v
	return s
}

type DescribeImportTasksInput struct {
	_ struct{} `type:"structure"`

	// An array of name-value pairs that you provide to filter the results for the
	// DescribeImportTask request to a specific subset of results. Currently, wildcard
	// values aren't supported for filters.
	Filters []*ImportTaskFilter `locationName:"filters" type:"list"`

	// The maximum number of results that you want this request to return, up to
	// 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token to request a specific page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeImportTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImportTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImportTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeImportTasksInput) SetFilters(v []*ImportTaskFilter) *DescribeImportTasksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImportTasksInput) SetMaxResults(v int64) *DescribeImportTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImportTasksInput) SetNextToken(v string) *DescribeImportTasksInput {
	s.NextToken = &v
	return s
}

type DescribeImportTasksOutput struct {
	_ struct{} `type:"structure"`

	// The token to request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A returned array of import tasks that match any applied filters, up to the
	// specified number of maximum results.
	Tasks []*ImportTask `locationName:"tasks" type:"list"`
}

// String returns the string representation
func (s DescribeImportTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImportTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImportTasksOutput) SetNextToken(v string) *DescribeImportTasksOutput {
	s.NextToken = &v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *DescribeImportTasksOutput) SetTasks(v []*ImportTask) *DescribeImportTasksOutput {
	s.Tasks = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// You can filter the list using a key-value format. You can separate these
	// items by using logical operators. Allowed filters include tagKey, tagValue,
	// and configurationId.
	Filters []*TagFilter `locationName:"filters" type:"list"`

	// The total number of items to return in a single page of output. The maximum
	// value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeTagsInput) SetFilters(v []*TagFilter) *DescribeTagsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeTagsInput) SetMaxResults(v int64) *DescribeTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTagsInput) SetNextToken(v string) *DescribeTagsInput {
	s.NextToken = &v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The call returns a token. Use this token to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Depending on the input, this is a list of configuration items tagged with
	// a specific tag, or a list of tags for a specific configuration item.
	Tags []*ConfigurationTag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTagsOutput) SetNextToken(v string) *DescribeTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeTagsOutput) SetTags(v []*ConfigurationTag) *DescribeTagsOutput {
	s.Tags = v
	return s
}

type DisassociateConfigurationItemsFromApplicationInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of an application from which each item is disassociated.
	//
	// ApplicationConfigurationId is a required field
	ApplicationConfigurationId *string `locationName:"applicationConfigurationId" type:"string" required:"true"`

	// Configuration ID of each item to be disassociated from an application.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []*string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DisassociateConfigurationItemsFromApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConfigurationItemsFromApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConfigurationItemsFromApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateConfigurationItemsFromApplicationInput"}
	if s.ApplicationConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationConfigurationId"))
	}
	if s.ConfigurationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationConfigurationId sets the ApplicationConfigurationId field's value.
func (s *DisassociateConfigurationItemsFromApplicationInput) SetApplicationConfigurationId(v string) *DisassociateConfigurationItemsFromApplicationInput {
	s.ApplicationConfigurationId = &v
	return s
}

// SetConfigurationIds sets the ConfigurationIds field's value.
func (s *DisassociateConfigurationItemsFromApplicationInput) SetConfigurationIds(v []*string) *DisassociateConfigurationItemsFromApplicationInput {
	s.ConfigurationIds = v
	return s
}

type DisassociateConfigurationItemsFromApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateConfigurationItemsFromApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConfigurationItemsFromApplicationOutput) GoString() string {
	return s.String()
}

type ExportConfigurationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExportConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportConfigurationsInput) GoString() string {
	return s.String()
}

type ExportConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you can use to query the export status.
	ExportId *string `locationName:"exportId" type:"string"`
}

// String returns the string representation
func (s ExportConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportConfigurationsOutput) GoString() string {
	return s.String()
}

// SetExportId sets the ExportId field's value.
func (s *ExportConfigurationsOutput) SetExportId(v string) *ExportConfigurationsOutput {
	s.ExportId = &v
	return s
}

// Used to select which agent's data is to be exported. A single agent ID may
// be selected for export using the StartExportTask (http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html)
// action.
type ExportFilter struct {
	_ struct{} `type:"structure"`

	// Supported condition: EQUALS
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true"`

	// A single ExportFilter name. Supported filters: agentId.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A single agentId for a Discovery Agent. An agentId can be found using the
	// DescribeAgents (http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html)
	// action. Typically an ADS agentId is in the form o-0123456789abcdef0.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation
func (s ExportFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportFilter"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *ExportFilter) SetCondition(v string) *ExportFilter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *ExportFilter) SetName(v string) *ExportFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExportFilter) SetValues(v []*string) *ExportFilter {
	s.Values = v
	return s
}

// Information regarding the export status of discovered data. The value is
// an array of objects.
type ExportInfo struct {
	_ struct{} `type:"structure"`

	// A URL for an Amazon S3 bucket where you can review the exported data. The
	// URL is displayed only if the export succeeded.
	ConfigurationsDownloadUrl *string `locationName:"configurationsDownloadUrl" type:"string"`

	// A unique identifier used to query an export.
	//
	// ExportId is a required field
	ExportId *string `locationName:"exportId" type:"string" required:"true"`

	// The time that the data export was initiated.
	//
	// ExportRequestTime is a required field
	ExportRequestTime *time.Time `locationName:"exportRequestTime" type:"timestamp" required:"true"`

	// The status of the data export job.
	//
	// ExportStatus is a required field
	ExportStatus *string `locationName:"exportStatus" type:"string" required:"true" enum:"ExportStatus"`

	// If true, the export of agent information exceeded the size limit for a single
	// export and the exported data is incomplete for the requested time range.
	// To address this, select a smaller time range for the export by using startDate
	// and endDate.
	IsTruncated *bool `locationName:"isTruncated" type:"boolean"`

	// The endTime used in the StartExportTask request. If no endTime was requested,
	// this result does not appear in ExportInfo.
	RequestedEndTime *time.Time `locationName:"requestedEndTime" type:"timestamp"`

	// The value of startTime parameter in the StartExportTask request. If no startTime
	// was requested, this result does not appear in ExportInfo.
	RequestedStartTime *time.Time `locationName:"requestedStartTime" type:"timestamp"`

	// A status message provided for API callers.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`
}

// String returns the string representation
func (s ExportInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportInfo) GoString() string {
	return s.String()
}

// SetConfigurationsDownloadUrl sets the ConfigurationsDownloadUrl field's value.
func (s *ExportInfo) SetConfigurationsDownloadUrl(v string) *ExportInfo {
	s.ConfigurationsDownloadUrl = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *ExportInfo) SetExportId(v string) *ExportInfo {
	s.ExportId = &v
	return s
}

// SetExportRequestTime sets the ExportRequestTime field's value.
func (s *ExportInfo) SetExportRequestTime(v time.Time) *ExportInfo {
	s.ExportRequestTime = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *ExportInfo) SetExportStatus(v string) *ExportInfo {
	s.ExportStatus = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ExportInfo) SetIsTruncated(v bool) *ExportInfo {
	s.IsTruncated = &v
	return s
}

// SetRequestedEndTime sets the RequestedEndTime field's value.
func (s *ExportInfo) SetRequestedEndTime(v time.Time) *ExportInfo {
	s.RequestedEndTime = &v
	return s
}

// SetRequestedStartTime sets the RequestedStartTime field's value.
func (s *ExportInfo) SetRequestedStartTime(v time.Time) *ExportInfo {
	s.RequestedStartTime = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ExportInfo) SetStatusMessage(v string) *ExportInfo {
	s.StatusMessage = &v
	return s
}

// A filter that can use conditional operators.
//
// For more information about filters, see Querying Discovered Configuration
// Items (http://docs.aws.amazon.com/application-discovery/latest/APIReference/discovery-api-queries.html).
type Filter struct {
	_ struct{} `type:"structure"`

	// A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
	// CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes
	// all filters as though concatenated by AND. If you specify multiple values
	// for a particular filter, the system differentiates the values using OR. Calling
	// either DescribeConfigurations or ListConfigurations returns attributes of
	// matching configuration items.
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A string value on which to filter. For example, if you choose the destinationServer.osVersion
	// filter name, you could specify Ubuntu for the value.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *Filter) SetCondition(v string) *Filter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type GetDiscoverySummaryInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetDiscoverySummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiscoverySummaryInput) GoString() string {
	return s.String()
}

type GetDiscoverySummaryOutput struct {
	_ struct{} `type:"structure"`

	// Details about discovered agents, including agent status and health.
	AgentSummary *CustomerAgentInfo `locationName:"agentSummary" type:"structure"`

	// The number of applications discovered.
	Applications *int64 `locationName:"applications" type:"long"`

	// Details about discovered connectors, including connector status and health.
	ConnectorSummary *CustomerConnectorInfo `locationName:"connectorSummary" type:"structure"`

	// The number of servers discovered.
	Servers *int64 `locationName:"servers" type:"long"`

	// The number of servers mapped to applications.
	ServersMappedToApplications *int64 `locationName:"serversMappedToApplications" type:"long"`

	// The number of servers mapped to tags.
	ServersMappedtoTags *int64 `locationName:"serversMappedtoTags" type:"long"`
}

// String returns the string representation
func (s GetDiscoverySummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiscoverySummaryOutput) GoString() string {
	return s.String()
}

// SetAgentSummary sets the AgentSummary field's value.
func (s *GetDiscoverySummaryOutput) SetAgentSummary(v *CustomerAgentInfo) *GetDiscoverySummaryOutput {
	s.AgentSummary = v
	return s
}

// SetApplications sets the Applications field's value.
func (s *GetDiscoverySummaryOutput) SetApplications(v int64) *GetDiscoverySummaryOutput {
	s.Applications = &v
	return s
}

// SetConnectorSummary sets the ConnectorSummary field's value.
func (s *GetDiscoverySummaryOutput) SetConnectorSummary(v *CustomerConnectorInfo) *GetDiscoverySummaryOutput {
	s.ConnectorSummary = v
	return s
}

// SetServers sets the Servers field's value.
func (s *GetDiscoverySummaryOutput) SetServers(v int64) *GetDiscoverySummaryOutput {
	s.Servers = &v
	return s
}

// SetServersMappedToApplications sets the ServersMappedToApplications field's value.
func (s *GetDiscoverySummaryOutput) SetServersMappedToApplications(v int64) *GetDiscoverySummaryOutput {
	s.ServersMappedToApplications = &v
	return s
}

// SetServersMappedtoTags sets the ServersMappedtoTags field's value.
func (s *GetDiscoverySummaryOutput) SetServersMappedtoTags(v int64) *GetDiscoverySummaryOutput {
	s.ServersMappedtoTags = &v
	return s
}

// An array of information related to the import task request that includes
// status information, times, IDs, the Amazon S3 Object URL for the import file,
// and more.
type ImportTask struct {
	_ struct{} `type:"structure"`

	// The total number of application records in the import file that failed to
	// be imported.
	ApplicationImportFailure *int64 `locationName:"applicationImportFailure" type:"integer"`

	// The total number of application records in the import file that were successfully
	// imported.
	ApplicationImportSuccess *int64 `locationName:"applicationImportSuccess" type:"integer"`

	// A unique token used to prevent the same import request from occurring more
	// than once. If you didn't provide a token, a token was automatically generated
	// when the import task request was sent.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// A link to a compressed archive folder (in the ZIP format) that contains an
	// error log and a file of failed records. You can use these two files to quickly
	// identify records that failed, why they failed, and correct those records.
	// Afterward, you can upload the corrected file to your Amazon S3 bucket and
	// create another import task request.
	//
	// This field also includes authorization information so you can confirm the
	// authenticity of the compressed archive before you download it.
	//
	// If some records failed to be imported we recommend that you correct the records
	// in the failed entries file and then imports that failed entries file. This
	// prevents you frmo having to correct and update the larger original file and
	// attempt importing it again.
	ErrorsAndFailedEntriesZip *string `locationName:"errorsAndFailedEntriesZip" type:"string"`

	// The time that the import task request finished, presented in the Unix time
	// stamp format.
	ImportCompletionTime *time.Time `locationName:"importCompletionTime" type:"timestamp"`

	// The time that the import task request was deleted, presented in the Unix
	// time stamp format.
	ImportDeletedTime *time.Time `locationName:"importDeletedTime" type:"timestamp"`

	// The time that the import task request was made, presented in the Unix time
	// stamp format.
	ImportRequestTime *time.Time `locationName:"importRequestTime" type:"timestamp"`

	// The unique ID for a specific import task. These IDs aren't globally unique,
	// but they are unique within an AWS account.
	ImportTaskId *string `locationName:"importTaskId" type:"string"`

	// The URL for your import file that you've uploaded to Amazon S3.
	ImportUrl *string `locationName:"importUrl" min:"1" type:"string"`

	// A descriptive name for an import task. You can use this name to filter future
	// requests related to this import task, such as identifying applications and
	// servers that were included in this import task. We recommend that you use
	// a meaningful name for each import task.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The total number of server records in the import file that failed to be imported.
	ServerImportFailure *int64 `locationName:"serverImportFailure" type:"integer"`

	// The total number of server records in the import file that were successfully
	// imported.
	ServerImportSuccess *int64 `locationName:"serverImportSuccess" type:"integer"`

	// The status of the import task. An import can have the status of IMPORT_COMPLETE
	// and still have some records fail to import from the overall request. More
	// information can be found in the downloadable archive defined in the errorsAndFailedEntriesZip
	// field, or in the Migration Hub management console.
	Status *string `locationName:"status" type:"string" enum:"ImportStatus"`
}

// String returns the string representation
func (s ImportTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportTask) GoString() string {
	return s.String()
}

// SetApplicationImportFailure sets the ApplicationImportFailure field's value.
func (s *ImportTask) SetApplicationImportFailure(v int64) *ImportTask {
	s.ApplicationImportFailure = &v
	return s
}

// SetApplicationImportSuccess sets the ApplicationImportSuccess field's value.
func (s *ImportTask) SetApplicationImportSuccess(v int64) *ImportTask {
	s.ApplicationImportSuccess = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *ImportTask) SetClientRequestToken(v string) *ImportTask {
	s.ClientRequestToken = &v
	return s
}

// SetErrorsAndFailedEntriesZip sets the ErrorsAndFailedEntriesZip field's value.
func (s *ImportTask) SetErrorsAndFailedEntriesZip(v string) *ImportTask {
	s.ErrorsAndFailedEntriesZip = &v
	return s
}

// SetImportCompletionTime sets the ImportCompletionTime field's value.
func (s *ImportTask) SetImportCompletionTime(v time.Time) *ImportTask {
	s.ImportCompletionTime = &v
	return s
}

// SetImportDeletedTime sets the ImportDeletedTime field's value.
func (s *ImportTask) SetImportDeletedTime(v time.Time) *ImportTask {
	s.ImportDeletedTime = &v
	return s
}

// SetImportRequestTime sets the ImportRequestTime field's value.
func (s *ImportTask) SetImportRequestTime(v time.Time) *ImportTask {
	s.ImportRequestTime = &v
	return s
}

// SetImportTaskId sets the ImportTaskId field's value.
func (s *ImportTask) SetImportTaskId(v string) *ImportTask {
	s.ImportTaskId = &v
	return s
}

// SetImportUrl sets the ImportUrl field's value.
func (s *ImportTask) SetImportUrl(v string) *ImportTask {
	s.ImportUrl = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportTask) SetName(v string) *ImportTask {
	s.Name = &v
	return s
}

// SetServerImportFailure sets the ServerImportFailure field's value.
func (s *ImportTask) SetServerImportFailure(v int64) *ImportTask {
	s.ServerImportFailure = &v
	return s
}

// SetServerImportSuccess sets the ServerImportSuccess field's value.
func (s *ImportTask) SetServerImportSuccess(v int64) *ImportTask {
	s.ServerImportSuccess = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportTask) SetStatus(v string) *ImportTask {
	s.Status = &v
	return s
}

// A name-values pair of elements you can use to filter the results when querying
// your import tasks. Currently, wildcards are not supported for filters.
//
// When filtering by import status, all other filter values are ignored.
type ImportTaskFilter struct {
	_ struct{} `type:"structure"`

	// The name, status, or import task ID for a specific import task.
	Name *string `locationName:"name" type:"string" enum:"ImportTaskFilterName"`

	// An array of strings that you can provide to match against a specific name,
	// status, or import task ID to filter the results for your import task queries.
	Values []*string `locationName:"values" min:"1" type:"list"`
}

// String returns the string representation
func (s ImportTaskFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportTaskFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportTaskFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportTaskFilter"}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ImportTaskFilter) SetName(v string) *ImportTaskFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ImportTaskFilter) SetValues(v []*string) *ImportTaskFilter {
	s.Values = v
	return s
}

type ListConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A valid configuration identified by Application Discovery Service.
	//
	// ConfigurationType is a required field
	ConfigurationType *string `locationName:"configurationType" type:"string" required:"true" enum:"ConfigurationItemType"`

	// You can filter the request using various logical operators and a key-value
	// format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	//
	// For a complete list of filter options and guidance about using them with
	// this action, see Querying Discovered Configuration Items (http://docs.aws.amazon.com/application-discovery/latest/APIReference/discovery-api-queries.html#ListConfigurations).
	Filters []*Filter `locationName:"filters" type:"list"`

	// The total number of items to return. The maximum value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Token to retrieve the next set of results. For example, if a previous call
	// to ListConfigurations returned 100 items, but you set ListConfigurationsRequest$maxResults
	// to 10, you received a set of 10 results along with a token. Use that token
	// in this query to get the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Certain filter criteria return output that can be sorted in ascending or
	// descending order. For a list of output characteristics for each filter, see
	// Using the ListConfigurations Action (http://docs.aws.amazon.com/application-discovery/latest/APIReference/discovery-api-queries.html#ListConfigurations).
	OrderBy []*OrderByElement `locationName:"orderBy" type:"list"`
}

// String returns the string representation
func (s ListConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfigurationsInput"}
	if s.ConfigurationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationType"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OrderBy != nil {
		for i, v := range s.OrderBy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrderBy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *ListConfigurationsInput) SetConfigurationType(v string) *ListConfigurationsInput {
	s.ConfigurationType = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListConfigurationsInput) SetFilters(v []*Filter) *ListConfigurationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigurationsInput) SetMaxResults(v int64) *ListConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsInput) SetNextToken(v string) *ListConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *ListConfigurationsInput) SetOrderBy(v []*OrderByElement) *ListConfigurationsInput {
	s.OrderBy = v
	return s
}

type ListConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns configuration details, including the configuration ID, attribute
	// names, and attribute values.
	Configurations []map[string]*string `locationName:"configurations" type:"list"`

	// Token to retrieve the next set of results. For example, if your call to ListConfigurations
	// returned 100 items, but you set ListConfigurationsRequest$maxResults to 10,
	// you received a set of 10 results along with this token. Use this token in
	// the next query to retrieve the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationsOutput) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *ListConfigurationsOutput) SetConfigurations(v []map[string]*string) *ListConfigurationsOutput {
	s.Configurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationsOutput) SetNextToken(v string) *ListConfigurationsOutput {
	s.NextToken = &v
	return s
}

type ListServerNeighborsInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of the server for which neighbors are being listed.
	//
	// ConfigurationId is a required field
	ConfigurationId *string `locationName:"configurationId" type:"string" required:"true"`

	// Maximum number of results to return in a single page of output.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// List of configuration IDs to test for one-hop-away.
	NeighborConfigurationIds []*string `locationName:"neighborConfigurationIds" type:"list"`

	// Token to retrieve the next set of results. For example, if you previously
	// specified 100 IDs for ListServerNeighborsRequest$neighborConfigurationIds
	// but set ListServerNeighborsRequest$maxResults to 10, you received a set of
	// 10 results along with a token. Use that token in this query to get the next
	// set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Flag to indicate if port and protocol information is needed as part of the
	// response.
	PortInformationNeeded *bool `locationName:"portInformationNeeded" type:"boolean"`
}

// String returns the string representation
func (s ListServerNeighborsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServerNeighborsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServerNeighborsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServerNeighborsInput"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *ListServerNeighborsInput) SetConfigurationId(v string) *ListServerNeighborsInput {
	s.ConfigurationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServerNeighborsInput) SetMaxResults(v int64) *ListServerNeighborsInput {
	s.MaxResults = &v
	return s
}

// SetNeighborConfigurationIds sets the NeighborConfigurationIds field's value.
func (s *ListServerNeighborsInput) SetNeighborConfigurationIds(v []*string) *ListServerNeighborsInput {
	s.NeighborConfigurationIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServerNeighborsInput) SetNextToken(v string) *ListServerNeighborsInput {
	s.NextToken = &v
	return s
}

// SetPortInformationNeeded sets the PortInformationNeeded field's value.
func (s *ListServerNeighborsInput) SetPortInformationNeeded(v bool) *ListServerNeighborsInput {
	s.PortInformationNeeded = &v
	return s
}

type ListServerNeighborsOutput struct {
	_ struct{} `type:"structure"`

	// Count of distinct servers that are one hop away from the given server.
	KnownDependencyCount *int64 `locationName:"knownDependencyCount" type:"long"`

	// List of distinct servers that are one hop away from the given server.
	//
	// Neighbors is a required field
	Neighbors []*NeighborConnectionDetail `locationName:"neighbors" type:"list" required:"true"`

	// Token to retrieve the next set of results. For example, if you specified
	// 100 IDs for ListServerNeighborsRequest$neighborConfigurationIds but set ListServerNeighborsRequest$maxResults
	// to 10, you received a set of 10 results along with this token. Use this token
	// in the next query to retrieve the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListServerNeighborsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServerNeighborsOutput) GoString() string {
	return s.String()
}

// SetKnownDependencyCount sets the KnownDependencyCount field's value.
func (s *ListServerNeighborsOutput) SetKnownDependencyCount(v int64) *ListServerNeighborsOutput {
	s.KnownDependencyCount = &v
	return s
}

// SetNeighbors sets the Neighbors field's value.
func (s *ListServerNeighborsOutput) SetNeighbors(v []*NeighborConnectionDetail) *ListServerNeighborsOutput {
	s.Neighbors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServerNeighborsOutput) SetNextToken(v string) *ListServerNeighborsOutput {
	s.NextToken = &v
	return s
}

// Details about neighboring servers.
type NeighborConnectionDetail struct {
	_ struct{} `type:"structure"`

	// The number of open network connections with the neighboring server.
	//
	// ConnectionsCount is a required field
	ConnectionsCount *int64 `locationName:"connectionsCount" type:"long" required:"true"`

	// The destination network port for the connection.
	DestinationPort *int64 `locationName:"destinationPort" type:"integer"`

	// The ID of the server that accepted the network connection.
	//
	// DestinationServerId is a required field
	DestinationServerId *string `locationName:"destinationServerId" type:"string" required:"true"`

	// The ID of the server that opened the network connection.
	//
	// SourceServerId is a required field
	SourceServerId *string `locationName:"sourceServerId" type:"string" required:"true"`

	// The network protocol used for the connection.
	TransportProtocol *string `locationName:"transportProtocol" type:"string"`
}

// String returns the string representation
func (s NeighborConnectionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NeighborConnectionDetail) GoString() string {
	return s.String()
}

// SetConnectionsCount sets the ConnectionsCount field's value.
func (s *NeighborConnectionDetail) SetConnectionsCount(v int64) *NeighborConnectionDetail {
	s.ConnectionsCount = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *NeighborConnectionDetail) SetDestinationPort(v int64) *NeighborConnectionDetail {
	s.DestinationPort = &v
	return s
}

// SetDestinationServerId sets the DestinationServerId field's value.
func (s *NeighborConnectionDetail) SetDestinationServerId(v string) *NeighborConnectionDetail {
	s.DestinationServerId = &v
	return s
}

// SetSourceServerId sets the SourceServerId field's value.
func (s *NeighborConnectionDetail) SetSourceServerId(v string) *NeighborConnectionDetail {
	s.SourceServerId = &v
	return s
}

// SetTransportProtocol sets the TransportProtocol field's value.
func (s *NeighborConnectionDetail) SetTransportProtocol(v string) *NeighborConnectionDetail {
	s.TransportProtocol = &v
	return s
}

// A field and direction for ordered output.
type OrderByElement struct {
	_ struct{} `type:"structure"`

	// The field on which to order.
	//
	// FieldName is a required field
	FieldName *string `locationName:"fieldName" type:"string" required:"true"`

	// Ordering direction.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"orderString"`
}

// String returns the string representation
func (s OrderByElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderByElement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrderByElement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrderByElement"}
	if s.FieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldName sets the FieldName field's value.
func (s *OrderByElement) SetFieldName(v string) *OrderByElement {
	s.FieldName = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *OrderByElement) SetSortOrder(v string) *OrderByElement {
	s.SortOrder = &v
	return s
}

type StartContinuousExportInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartContinuousExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartContinuousExportInput) GoString() string {
	return s.String()
}

type StartContinuousExportOutput struct {
	_ struct{} `type:"structure"`

	// The type of data collector used to gather this data (currently only offered
	// for AGENT).
	DataSource *string `locationName:"dataSource" type:"string" enum:"DataSource"`

	// The unique ID assigned to this export.
	ExportId *string `locationName:"exportId" type:"string"`

	// The name of the s3 bucket where the export data parquet files are stored.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// A dictionary which describes how the data is stored.
	//
	//    * databaseName - the name of the Glue database used to store the schema.
	SchemaStorageConfig map[string]*string `locationName:"schemaStorageConfig" type:"map"`

	// The timestamp representing when the continuous export was started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation
func (s StartContinuousExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartContinuousExportOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *StartContinuousExportOutput) SetDataSource(v string) *StartContinuousExportOutput {
	s.DataSource = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *StartContinuousExportOutput) SetExportId(v string) *StartContinuousExportOutput {
	s.ExportId = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *StartContinuousExportOutput) SetS3Bucket(v string) *StartContinuousExportOutput {
	s.S3Bucket = &v
	return s
}

// SetSchemaStorageConfig sets the SchemaStorageConfig field's value.
func (s *StartContinuousExportOutput) SetSchemaStorageConfig(v map[string]*string) *StartContinuousExportOutput {
	s.SchemaStorageConfig = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StartContinuousExportOutput) SetStartTime(v time.Time) *StartContinuousExportOutput {
	s.StartTime = &v
	return s
}

type StartDataCollectionByAgentIdsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the agents or connectors from which to start collecting data.
	// If you send a request to an agent/connector ID that you do not have permission
	// to contact, according to your AWS account, the service does not throw an
	// exception. Instead, it returns the error in the Description field. If you
	// send a request to multiple agents/connectors and you do not have permission
	// to contact some of those agents/connectors, the system does not throw an
	// exception. Instead, the system shows Failed in the Description field.
	//
	// AgentIds is a required field
	AgentIds []*string `locationName:"agentIds" type:"list" required:"true"`
}

// String returns the string representation
func (s StartDataCollectionByAgentIdsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataCollectionByAgentIdsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDataCollectionByAgentIdsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDataCollectionByAgentIdsInput"}
	if s.AgentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentIds sets the AgentIds field's value.
func (s *StartDataCollectionByAgentIdsInput) SetAgentIds(v []*string) *StartDataCollectionByAgentIdsInput {
	s.AgentIds = v
	return s
}

type StartDataCollectionByAgentIdsOutput struct {
	_ struct{} `type:"structure"`

	// Information about agents or the connector that were instructed to start collecting
	// data. Information includes the agent/connector ID, a description of the operation
	// performed, and whether the agent/connector configuration was updated.
	AgentsConfigurationStatus []*AgentConfigurationStatus `locationName:"agentsConfigurationStatus" type:"list"`
}

// String returns the string representation
func (s StartDataCollectionByAgentIdsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataCollectionByAgentIdsOutput) GoString() string {
	return s.String()
}

// SetAgentsConfigurationStatus sets the AgentsConfigurationStatus field's value.
func (s *StartDataCollectionByAgentIdsOutput) SetAgentsConfigurationStatus(v []*AgentConfigurationStatus) *StartDataCollectionByAgentIdsOutput {
	s.AgentsConfigurationStatus = v
	return s
}

type StartExportTaskInput struct {
	_ struct{} `type:"structure"`

	// The end timestamp for exported data from the single Application Discovery
	// Agent selected in the filters. If no value is specified, exported data includes
	// the most recent data collected by the agent.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The file format for the returned export data. Default value is CSV. Note:TheGRAPHMLoption
	// has been deprecated.
	ExportDataFormat []*string `locationName:"exportDataFormat" type:"list"`

	// If a filter is present, it selects the single agentId of the Application
	// Discovery Agent for which data is exported. The agentId can be found in the
	// results of the DescribeAgents API or CLI. If no filter is present, startTime
	// and endTime are ignored and exported data includes both Agentless Discovery
	// Connector data and summary data from Application Discovery agents.
	Filters []*ExportFilter `locationName:"filters" type:"list"`

	// The start timestamp for exported data from the single Application Discovery
	// Agent selected in the filters. If no value is specified, data is exported
	// starting from the first data collected by the agent.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation
func (s StartExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartExportTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartExportTaskInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *StartExportTaskInput) SetEndTime(v time.Time) *StartExportTaskInput {
	s.EndTime = &v
	return s
}

// SetExportDataFormat sets the ExportDataFormat field's value.
func (s *StartExportTaskInput) SetExportDataFormat(v []*string) *StartExportTaskInput {
	s.ExportDataFormat = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *StartExportTaskInput) SetFilters(v []*ExportFilter) *StartExportTaskInput {
	s.Filters = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StartExportTaskInput) SetStartTime(v time.Time) *StartExportTaskInput {
	s.StartTime = &v
	return s
}

type StartExportTaskOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier used to query the status of an export request.
	ExportId *string `locationName:"exportId" type:"string"`
}

// String returns the string representation
func (s StartExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExportTaskOutput) GoString() string {
	return s.String()
}

// SetExportId sets the ExportId field's value.
func (s *StartExportTaskOutput) SetExportId(v string) *StartExportTaskOutput {
	s.ExportId = &v
	return s
}

type StartImportTaskInput struct {
	_ struct{} `type:"structure"`

	// Optional. A unique token that you can provide to prevent the same import
	// request from occurring more than once. If you don't provide a token, a token
	// is automatically generated.
	//
	// Sending more than one StartImportTask request with the same client request
	// token will return information about the original import task with that client
	// request token.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The URL for your import file that you've uploaded to Amazon S3.
	//
	// If you're using the AWS CLI, this URL is structured as follows: s3://BucketName/ImportFileName.CSV
	//
	// ImportUrl is a required field
	ImportUrl *string `locationName:"importUrl" min:"1" type:"string" required:"true"`

	// A descriptive name for this request. You can use this name to filter future
	// requests related to this import task, such as identifying applications and
	// servers that were included in this import task. We recommend that you use
	// a meaningful name for each import task.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartImportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartImportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImportTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartImportTaskInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ImportUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportUrl"))
	}
	if s.ImportUrl != nil && len(*s.ImportUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImportUrl", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartImportTaskInput) SetClientRequestToken(v string) *StartImportTaskInput {
	s.ClientRequestToken = &v
	return s
}

// SetImportUrl sets the ImportUrl field's value.
func (s *StartImportTaskInput) SetImportUrl(v string) *StartImportTaskInput {
	s.ImportUrl = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartImportTaskInput) SetName(v string) *StartImportTaskInput {
	s.Name = &v
	return s
}

type StartImportTaskOutput struct {
	_ struct{} `type:"structure"`

	// An array of information related to the import task request including status
	// information, times, IDs, the Amazon S3 Object URL for the import file, and
	// more.
	Task *ImportTask `locationName:"task" type:"structure"`
}

// String returns the string representation
func (s StartImportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartImportTaskOutput) GoString() string {
	return s.String()
}

// SetTask sets the Task field's value.
func (s *StartImportTaskOutput) SetTask(v *ImportTask) *StartImportTaskOutput {
	s.Task = v
	return s
}

type StopContinuousExportInput struct {
	_ struct{} `type:"structure"`

	// The unique ID assigned to this export.
	//
	// ExportId is a required field
	ExportId *string `locationName:"exportId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopContinuousExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopContinuousExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopContinuousExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopContinuousExportInput"}
	if s.ExportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportId sets the ExportId field's value.
func (s *StopContinuousExportInput) SetExportId(v string) *StopContinuousExportInput {
	s.ExportId = &v
	return s
}

type StopContinuousExportOutput struct {
	_ struct{} `type:"structure"`

	// Timestamp that represents when this continuous export started collecting
	// data.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Timestamp that represents when this continuous export was stopped.
	StopTime *time.Time `locationName:"stopTime" type:"timestamp"`
}

// String returns the string representation
func (s StopContinuousExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopContinuousExportOutput) GoString() string {
	return s.String()
}

// SetStartTime sets the StartTime field's value.
func (s *StopContinuousExportOutput) SetStartTime(v time.Time) *StopContinuousExportOutput {
	s.StartTime = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *StopContinuousExportOutput) SetStopTime(v time.Time) *StopContinuousExportOutput {
	s.StopTime = &v
	return s
}

type StopDataCollectionByAgentIdsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the agents or connectors from which to stop collecting data.
	//
	// AgentIds is a required field
	AgentIds []*string `locationName:"agentIds" type:"list" required:"true"`
}

// String returns the string representation
func (s StopDataCollectionByAgentIdsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataCollectionByAgentIdsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDataCollectionByAgentIdsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDataCollectionByAgentIdsInput"}
	if s.AgentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentIds sets the AgentIds field's value.
func (s *StopDataCollectionByAgentIdsInput) SetAgentIds(v []*string) *StopDataCollectionByAgentIdsInput {
	s.AgentIds = v
	return s
}

type StopDataCollectionByAgentIdsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the agents or connector that were instructed to stop collecting
	// data. Information includes the agent/connector ID, a description of the operation
	// performed, and whether the agent/connector configuration was updated.
	AgentsConfigurationStatus []*AgentConfigurationStatus `locationName:"agentsConfigurationStatus" type:"list"`
}

// String returns the string representation
func (s StopDataCollectionByAgentIdsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataCollectionByAgentIdsOutput) GoString() string {
	return s.String()
}

// SetAgentsConfigurationStatus sets the AgentsConfigurationStatus field's value.
func (s *StopDataCollectionByAgentIdsOutput) SetAgentsConfigurationStatus(v []*AgentConfigurationStatus) *StopDataCollectionByAgentIdsOutput {
	s.AgentsConfigurationStatus = v
	return s
}

// Metadata that help you categorize IT assets.
type Tag struct {
	_ struct{} `type:"structure"`

	// The type of tag on which to filter.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// A value for a tag key on which to filter.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The tag filter. Valid names are: tagKey, tagValue, configurationId.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// A name of the tag filter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Values for the tag filter.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *TagFilter) SetName(v string) *TagFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilter) SetValues(v []*string) *TagFilter {
	s.Values = v
	return s
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of the application to be updated.
	//
	// ConfigurationId is a required field
	ConfigurationId *string `locationName:"configurationId" type:"string" required:"true"`

	// New description of the application to be updated.
	Description *string `locationName:"description" type:"string"`

	// New name of the application to be updated.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *UpdateApplicationInput) SetConfigurationId(v string) *UpdateApplicationInput {
	s.ConfigurationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationInput) SetDescription(v string) *UpdateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApplicationInput) SetName(v string) *UpdateApplicationInput {
	s.Name = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

const (
	// AgentStatusHealthy is a AgentStatus enum value
	AgentStatusHealthy = "HEALTHY"

	// AgentStatusUnhealthy is a AgentStatus enum value
	AgentStatusUnhealthy = "UNHEALTHY"

	// AgentStatusRunning is a AgentStatus enum value
	AgentStatusRunning = "RUNNING"

	// AgentStatusUnknown is a AgentStatus enum value
	AgentStatusUnknown = "UNKNOWN"

	// AgentStatusBlacklisted is a AgentStatus enum value
	AgentStatusBlacklisted = "BLACKLISTED"

	// AgentStatusShutdown is a AgentStatus enum value
	AgentStatusShutdown = "SHUTDOWN"
)

const (
	// BatchDeleteImportDataErrorCodeNotFound is a BatchDeleteImportDataErrorCode enum value
	BatchDeleteImportDataErrorCodeNotFound = "NOT_FOUND"

	// BatchDeleteImportDataErrorCodeInternalServerError is a BatchDeleteImportDataErrorCode enum value
	BatchDeleteImportDataErrorCodeInternalServerError = "INTERNAL_SERVER_ERROR"
)

const (
	// ConfigurationItemTypeServer is a ConfigurationItemType enum value
	ConfigurationItemTypeServer = "SERVER"

	// ConfigurationItemTypeProcess is a ConfigurationItemType enum value
	ConfigurationItemTypeProcess = "PROCESS"

	// ConfigurationItemTypeConnection is a ConfigurationItemType enum value
	ConfigurationItemTypeConnection = "CONNECTION"

	// ConfigurationItemTypeApplication is a ConfigurationItemType enum value
	ConfigurationItemTypeApplication = "APPLICATION"
)

const (
	// ContinuousExportStatusStartInProgress is a ContinuousExportStatus enum value
	ContinuousExportStatusStartInProgress = "START_IN_PROGRESS"

	// ContinuousExportStatusStartFailed is a ContinuousExportStatus enum value
	ContinuousExportStatusStartFailed = "START_FAILED"

	// ContinuousExportStatusActive is a ContinuousExportStatus enum value
	ContinuousExportStatusActive = "ACTIVE"

	// ContinuousExportStatusError is a ContinuousExportStatus enum value
	ContinuousExportStatusError = "ERROR"

	// ContinuousExportStatusStopInProgress is a ContinuousExportStatus enum value
	ContinuousExportStatusStopInProgress = "STOP_IN_PROGRESS"

	// ContinuousExportStatusStopFailed is a ContinuousExportStatus enum value
	ContinuousExportStatusStopFailed = "STOP_FAILED"

	// ContinuousExportStatusInactive is a ContinuousExportStatus enum value
	ContinuousExportStatusInactive = "INACTIVE"
)

const (
	// DataSourceAgent is a DataSource enum value
	DataSourceAgent = "AGENT"
)

const (
	// ExportDataFormatCsv is a ExportDataFormat enum value
	ExportDataFormatCsv = "CSV"

	// ExportDataFormatGraphml is a ExportDataFormat enum value
	ExportDataFormatGraphml = "GRAPHML"
)

const (
	// ExportStatusFailed is a ExportStatus enum value
	ExportStatusFailed = "FAILED"

	// ExportStatusSucceeded is a ExportStatus enum value
	ExportStatusSucceeded = "SUCCEEDED"

	// ExportStatusInProgress is a ExportStatus enum value
	ExportStatusInProgress = "IN_PROGRESS"
)

const (
	// ImportStatusImportInProgress is a ImportStatus enum value
	ImportStatusImportInProgress = "IMPORT_IN_PROGRESS"

	// ImportStatusImportComplete is a ImportStatus enum value
	ImportStatusImportComplete = "IMPORT_COMPLETE"

	// ImportStatusImportFailed is a ImportStatus enum value
	ImportStatusImportFailed = "IMPORT_FAILED"

	// ImportStatusImportFailedServerLimitExceeded is a ImportStatus enum value
	ImportStatusImportFailedServerLimitExceeded = "IMPORT_FAILED_SERVER_LIMIT_EXCEEDED"

	// ImportStatusImportFailedRecordLimitExceeded is a ImportStatus enum value
	ImportStatusImportFailedRecordLimitExceeded = "IMPORT_FAILED_RECORD_LIMIT_EXCEEDED"

	// ImportStatusDeleteInProgress is a ImportStatus enum value
	ImportStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// ImportStatusDeleteComplete is a ImportStatus enum value
	ImportStatusDeleteComplete = "DELETE_COMPLETE"

	// ImportStatusDeleteFailed is a ImportStatus enum value
	ImportStatusDeleteFailed = "DELETE_FAILED"

	// ImportStatusDeleteFailedLimitExceeded is a ImportStatus enum value
	ImportStatusDeleteFailedLimitExceeded = "DELETE_FAILED_LIMIT_EXCEEDED"
)

const (
	// ImportTaskFilterNameImportTaskId is a ImportTaskFilterName enum value
	ImportTaskFilterNameImportTaskId = "IMPORT_TASK_ID"

	// ImportTaskFilterNameStatus is a ImportTaskFilterName enum value
	ImportTaskFilterNameStatus = "STATUS"

	// ImportTaskFilterNameName is a ImportTaskFilterName enum value
	ImportTaskFilterNameName = "NAME"
)

const (
	// OrderStringAsc is a orderString enum value
	OrderStringAsc = "ASC"

	// OrderStringDesc is a orderString enum value
	OrderStringDesc = "DESC"
)
