// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateBackup = "CreateBackup"

// CreateBackupRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackup for more information on using the CreateBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBackupRequest method.
//    req, resp := client.CreateBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateBackup
func (c *FSx) CreateBackupRequest(input *CreateBackupInput) (req *request.Request, output *CreateBackupOutput) {
	op := &request.Operation{
		Name:       opCreateBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBackupInput{}
	}

	output = &CreateBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackup API operation for Amazon FSx.
//
// Creates a backup of an existing Amazon FSx for Windows File Server file system.
// Creating regular backups for your file system is a best practice that complements
// the replication that Amazon FSx for Windows File Server performs for your
// file system. It also enables you to restore from user modification of data.
//
// If a backup with the specified client request token exists, and the parameters
// match, this operation returns the description of the existing backup. If
// a backup specified client request token exists, and the parameters don't
// match, this operation returns IncompatibleParameterError. If a backup with
// the specified client request token doesn't exist, CreateBackup does the following:
//
//    * Creates a new Amazon FSx backup with an assigned ID, and an initial
//    lifecycle state of CREATING.
//
//    * Returns the description of the backup.
//
// By using the idempotent operation, you can retry a CreateBackup operation
// without the risk of creating an extra backup. This approach can be useful
// when an initial call fails in a way that makes it unclear whether a backup
// was created. If you use the same client request token and the initial call
// created a backup, the operation returns a successful result because all the
// parameters are the same.
//
// The CreateFileSystem operation returns while the backup's lifecycle state
// is still CREATING. You can check the file system creation status by calling
// the DescribeBackups operation, which returns the backup state along with
// other information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation CreateBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeFileSystemNotFound "FileSystemNotFound"
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * ErrCodeBackupInProgress "BackupInProgress"
//   Another backup is already under way. Wait for completion before initiating
//   additional backups of this file system.
//
//   * ErrCodeIncompatibleParameterError "IncompatibleParameterError"
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * ErrCodeServiceLimitExceeded "ServiceLimitExceeded"
//   An error indicating that a particular service limit was exceeded. You can
//   increase some service limits by contacting AWS Support.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateBackup
func (c *FSx) CreateBackup(input *CreateBackupInput) (*CreateBackupOutput, error) {
	req, out := c.CreateBackupRequest(input)
	return out, req.Send()
}

// CreateBackupWithContext is the same as CreateBackup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) CreateBackupWithContext(ctx aws.Context, input *CreateBackupInput, opts ...request.Option) (*CreateBackupOutput, error) {
	req, out := c.CreateBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFileSystem = "CreateFileSystem"

// CreateFileSystemRequest generates a "aws/request.Request" representing the
// client's request for the CreateFileSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFileSystem for more information on using the CreateFileSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFileSystemRequest method.
//    req, resp := client.CreateFileSystemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystem
func (c *FSx) CreateFileSystemRequest(input *CreateFileSystemInput) (req *request.Request, output *CreateFileSystemOutput) {
	op := &request.Operation{
		Name:       opCreateFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFileSystemInput{}
	}

	output = &CreateFileSystemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFileSystem API operation for Amazon FSx.
//
// Creates a new, empty Amazon FSx file system.
//
// If a file system with the specified client request token exists and the parameters
// match, CreateFileSystem returns the description of the existing file system.
// If a file system specified client request token exists and the parameters
// don't match, this call returns IncompatibleParameterError. If a file system
// with the specified client request token doesn't exist, CreateFileSystem does
// the following:
//
//    * Creates a new, empty Amazon FSx file system with an assigned ID, and
//    an initial lifecycle state of CREATING.
//
//    * Returns the description of the file system.
//
// This operation requires a client request token in the request that Amazon
// FSx uses to ensure idempotent creation. This means that calling the operation
// multiple times with the same client request token has no effect. By using
// the idempotent operation, you can retry a CreateFileSystem operation without
// the risk of creating an extra file system. This approach can be useful when
// an initial call fails in a way that makes it unclear whether a file system
// was created. Examples are if a transport level timeout occurred, or your
// connection was reset. If you use the same client request token and the initial
// call created a file system, the client receives success as long as the parameters
// are the same.
//
// The CreateFileSystem call returns while the file system's lifecycle state
// is still CREATING. You can check the file-system creation status by calling
// the DescribeFileSystems operation, which returns the file system state along
// with other information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation CreateFileSystem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeActiveDirectoryError "ActiveDirectoryError"
//   An Active Directory error.
//
//   * ErrCodeIncompatibleParameterError "IncompatibleParameterError"
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * ErrCodeInvalidImportPath "InvalidImportPath"
//   The path provided for data repository import isn't valid.
//
//   * ErrCodeInvalidExportPath "InvalidExportPath"
//   The path provided for data repository export isn't valid.
//
//   * ErrCodeInvalidNetworkSettings "InvalidNetworkSettings"
//   One or more network settings specified in the request are invalid. InvalidVpcId
//   means that the ID passed for the virtual private cloud (VPC) is invalid.
//   InvalidSubnetIds returns the list of IDs for subnets that are either invalid
//   or not part of the VPC specified. InvalidSecurityGroupIds returns the list
//   of IDs for security groups that are either invalid or not part of the VPC
//   specified.
//
//   * ErrCodeServiceLimitExceeded "ServiceLimitExceeded"
//   An error indicating that a particular service limit was exceeded. You can
//   increase some service limits by contacting AWS Support.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
//   * ErrCodeMissingFileSystemConfiguration "MissingFileSystemConfiguration"
//   File system configuration is required for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystem
func (c *FSx) CreateFileSystem(input *CreateFileSystemInput) (*CreateFileSystemOutput, error) {
	req, out := c.CreateFileSystemRequest(input)
	return out, req.Send()
}

// CreateFileSystemWithContext is the same as CreateFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) CreateFileSystemWithContext(ctx aws.Context, input *CreateFileSystemInput, opts ...request.Option) (*CreateFileSystemOutput, error) {
	req, out := c.CreateFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFileSystemFromBackup = "CreateFileSystemFromBackup"

// CreateFileSystemFromBackupRequest generates a "aws/request.Request" representing the
// client's request for the CreateFileSystemFromBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFileSystemFromBackup for more information on using the CreateFileSystemFromBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFileSystemFromBackupRequest method.
//    req, resp := client.CreateFileSystemFromBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystemFromBackup
func (c *FSx) CreateFileSystemFromBackupRequest(input *CreateFileSystemFromBackupInput) (req *request.Request, output *CreateFileSystemFromBackupOutput) {
	op := &request.Operation{
		Name:       opCreateFileSystemFromBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFileSystemFromBackupInput{}
	}

	output = &CreateFileSystemFromBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFileSystemFromBackup API operation for Amazon FSx.
//
// Creates a new Amazon FSx file system from an existing Amazon FSx for Windows
// File Server backup.
//
// If a file system with the specified client request token exists and the parameters
// match, this call returns the description of the existing file system. If
// a client request token specified by the file system exists and the parameters
// don't match, this call returns IncompatibleParameterError. If a file system
// with the specified client request token doesn't exist, this operation does
// the following:
//
//    * Creates a new Amazon FSx file system from backup with an assigned ID,
//    and an initial lifecycle state of CREATING.
//
//    * Returns the description of the file system.
//
// Parameters like Active Directory, default share name, automatic backup, and
// backup settings default to the parameters of the file system that was backed
// up, unless overridden. You can explicitly supply other settings.
//
// By using the idempotent operation, you can retry a CreateFileSystemFromBackup
// call without the risk of creating an extra file system. This approach can
// be useful when an initial call fails in a way that makes it unclear whether
// a file system was created. Examples are if a transport level timeout occurred,
// or your connection was reset. If you use the same client request token and
// the initial call created a file system, the client receives success as long
// as the parameters are the same.
//
// The CreateFileSystemFromBackup call returns while the file system's lifecycle
// state is still CREATING. You can check the file-system creation status by
// calling the DescribeFileSystems operation, which returns the file system
// state along with other information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation CreateFileSystemFromBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeActiveDirectoryError "ActiveDirectoryError"
//   An Active Directory error.
//
//   * ErrCodeIncompatibleParameterError "IncompatibleParameterError"
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * ErrCodeInvalidNetworkSettings "InvalidNetworkSettings"
//   One or more network settings specified in the request are invalid. InvalidVpcId
//   means that the ID passed for the virtual private cloud (VPC) is invalid.
//   InvalidSubnetIds returns the list of IDs for subnets that are either invalid
//   or not part of the VPC specified. InvalidSecurityGroupIds returns the list
//   of IDs for security groups that are either invalid or not part of the VPC
//   specified.
//
//   * ErrCodeServiceLimitExceeded "ServiceLimitExceeded"
//   An error indicating that a particular service limit was exceeded. You can
//   increase some service limits by contacting AWS Support.
//
//   * ErrCodeBackupNotFound "BackupNotFound"
//   No Amazon FSx backups were found based upon the supplied parameters.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
//   * ErrCodeMissingFileSystemConfiguration "MissingFileSystemConfiguration"
//   File system configuration is required for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystemFromBackup
func (c *FSx) CreateFileSystemFromBackup(input *CreateFileSystemFromBackupInput) (*CreateFileSystemFromBackupOutput, error) {
	req, out := c.CreateFileSystemFromBackupRequest(input)
	return out, req.Send()
}

// CreateFileSystemFromBackupWithContext is the same as CreateFileSystemFromBackup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFileSystemFromBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) CreateFileSystemFromBackupWithContext(ctx aws.Context, input *CreateFileSystemFromBackupInput, opts ...request.Option) (*CreateFileSystemFromBackupOutput, error) {
	req, out := c.CreateFileSystemFromBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackup = "DeleteBackup"

// DeleteBackupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackup for more information on using the DeleteBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBackupRequest method.
//    req, resp := client.DeleteBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteBackup
func (c *FSx) DeleteBackupRequest(input *DeleteBackupInput) (req *request.Request, output *DeleteBackupOutput) {
	op := &request.Operation{
		Name:       opDeleteBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBackupInput{}
	}

	output = &DeleteBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBackup API operation for Amazon FSx.
//
// Deletes an Amazon FSx for Windows File Server backup, deleting its contents.
// After deletion, the backup no longer exists, and its data is gone.
//
// The DeleteBackup call returns instantly. The backup will not show up in later
// DescribeBackups calls.
//
// The data in a deleted backup is also deleted and can't be recovered by any
// means.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation DeleteBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeBackupInProgress "BackupInProgress"
//   Another backup is already under way. Wait for completion before initiating
//   additional backups of this file system.
//
//   * ErrCodeBackupNotFound "BackupNotFound"
//   No Amazon FSx backups were found based upon the supplied parameters.
//
//   * ErrCodeBackupRestoring "BackupRestoring"
//   You can't delete a backup while it's being used to restore a file system.
//
//   * ErrCodeIncompatibleParameterError "IncompatibleParameterError"
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteBackup
func (c *FSx) DeleteBackup(input *DeleteBackupInput) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	return out, req.Send()
}

// DeleteBackupWithContext is the same as DeleteBackup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DeleteBackupWithContext(ctx aws.Context, input *DeleteBackupInput, opts ...request.Option) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFileSystem = "DeleteFileSystem"

// DeleteFileSystemRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFileSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFileSystem for more information on using the DeleteFileSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFileSystemRequest method.
//    req, resp := client.DeleteFileSystemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystem
func (c *FSx) DeleteFileSystemRequest(input *DeleteFileSystemInput) (req *request.Request, output *DeleteFileSystemOutput) {
	op := &request.Operation{
		Name:       opDeleteFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFileSystemInput{}
	}

	output = &DeleteFileSystemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFileSystem API operation for Amazon FSx.
//
// Deletes a file system, deleting its contents. After deletion, the file system
// no longer exists, and its data is gone. Any existing automatic backups will
// also be deleted.
//
// By default, when you delete an Amazon FSx for Windows File Server file system,
// a final backup is created upon deletion. This final backup is not subject
// to the file system's retention policy, and must be manually deleted.
//
// The DeleteFileSystem action returns while the file system has the DELETING
// status. You can check the file system deletion status by calling the DescribeFileSystems
// action, which returns a list of file systems in your account. If you pass
// the file system ID for a deleted file system, the DescribeFileSystems returns
// a FileSystemNotFound error.
//
// The data in a deleted file system is also deleted and can't be recovered
// by any means.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation DeleteFileSystem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeIncompatibleParameterError "IncompatibleParameterError"
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * ErrCodeFileSystemNotFound "FileSystemNotFound"
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * ErrCodeServiceLimitExceeded "ServiceLimitExceeded"
//   An error indicating that a particular service limit was exceeded. You can
//   increase some service limits by contacting AWS Support.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystem
func (c *FSx) DeleteFileSystem(input *DeleteFileSystemInput) (*DeleteFileSystemOutput, error) {
	req, out := c.DeleteFileSystemRequest(input)
	return out, req.Send()
}

// DeleteFileSystemWithContext is the same as DeleteFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DeleteFileSystemWithContext(ctx aws.Context, input *DeleteFileSystemInput, opts ...request.Option) (*DeleteFileSystemOutput, error) {
	req, out := c.DeleteFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackups = "DescribeBackups"

// DescribeBackupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBackups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBackups for more information on using the DescribeBackups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBackupsRequest method.
//    req, resp := client.DescribeBackupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups
func (c *FSx) DescribeBackupsRequest(input *DescribeBackupsInput) (req *request.Request, output *DescribeBackupsOutput) {
	op := &request.Operation{
		Name:       opDescribeBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeBackupsInput{}
	}

	output = &DescribeBackupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBackups API operation for Amazon FSx.
//
// Returns the description of specific Amazon FSx for Windows File Server backups,
// if a BackupIds value is provided for that backup. Otherwise, it returns all
// backups owned by your AWS account in the AWS Region of the endpoint that
// you're calling.
//
// When retrieving all backups, you can optionally specify the MaxResults parameter
// to limit the number of backups in a response. If more backups remain, Amazon
// FSx returns a NextToken value in the response. In this case, send a later
// request with the NextToken request parameter set to the value of NextToken
// from the last response.
//
// This action is used in an iterative process to retrieve a list of your backups.
// DescribeBackups is called first without a NextTokenvalue. Then the action
// continues to be called with the NextToken parameter set to the value of the
// last NextToken value until a response has no NextToken.
//
// When using this action, keep the following in mind:
//
//    * The implementation might return fewer than MaxResults file system descriptions
//    while still including a NextToken value.
//
//    * The order of backups returned in the response of one DescribeBackups
//    call and the order of backups returned across the responses of a multi-call
//    iteration is unspecified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation DescribeBackups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeFileSystemNotFound "FileSystemNotFound"
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * ErrCodeBackupNotFound "BackupNotFound"
//   No Amazon FSx backups were found based upon the supplied parameters.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups
func (c *FSx) DescribeBackups(input *DescribeBackupsInput) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	return out, req.Send()
}

// DescribeBackupsWithContext is the same as DescribeBackups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeBackupsWithContext(ctx aws.Context, input *DescribeBackupsInput, opts ...request.Option) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeBackupsPages iterates over the pages of a DescribeBackups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeBackups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeBackups operation.
//    pageNum := 0
//    err := client.DescribeBackupsPages(params,
//        func(page *DescribeBackupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FSx) DescribeBackupsPages(input *DescribeBackupsInput, fn func(*DescribeBackupsOutput, bool) bool) error {
	return c.DescribeBackupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeBackupsPagesWithContext same as DescribeBackupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeBackupsPagesWithContext(ctx aws.Context, input *DescribeBackupsInput, fn func(*DescribeBackupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeBackupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBackupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeBackupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeFileSystems = "DescribeFileSystems"

// DescribeFileSystemsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFileSystems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFileSystems for more information on using the DescribeFileSystems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFileSystemsRequest method.
//    req, resp := client.DescribeFileSystemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems
func (c *FSx) DescribeFileSystemsRequest(input *DescribeFileSystemsInput) (req *request.Request, output *DescribeFileSystemsOutput) {
	op := &request.Operation{
		Name:       opDescribeFileSystems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFileSystemsInput{}
	}

	output = &DescribeFileSystemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFileSystems API operation for Amazon FSx.
//
// Returns the description of specific Amazon FSx file systems, if a FileSystemIds
// value is provided for that file system. Otherwise, it returns descriptions
// of all file systems owned by your AWS account in the AWS Region of the endpoint
// that you're calling.
//
// When retrieving all file system descriptions, you can optionally specify
// the MaxResults parameter to limit the number of descriptions in a response.
// If more file system descriptions remain, Amazon FSx returns a NextToken value
// in the response. In this case, send a later request with the NextToken request
// parameter set to the value of NextToken from the last response.
//
// This action is used in an iterative process to retrieve a list of your file
// system descriptions. DescribeFileSystems is called first without a NextTokenvalue.
// Then the action continues to be called with the NextToken parameter set to
// the value of the last NextToken value until a response has no NextToken.
//
// When using this action, keep the following in mind:
//
//    * The implementation might return fewer than MaxResults file system descriptions
//    while still including a NextToken value.
//
//    * The order of file systems returned in the response of one DescribeFileSystems
//    call and the order of file systems returned across the responses of a
//    multicall iteration is unspecified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation DescribeFileSystems for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeFileSystemNotFound "FileSystemNotFound"
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems
func (c *FSx) DescribeFileSystems(input *DescribeFileSystemsInput) (*DescribeFileSystemsOutput, error) {
	req, out := c.DescribeFileSystemsRequest(input)
	return out, req.Send()
}

// DescribeFileSystemsWithContext is the same as DescribeFileSystems with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFileSystems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeFileSystemsWithContext(ctx aws.Context, input *DescribeFileSystemsInput, opts ...request.Option) (*DescribeFileSystemsOutput, error) {
	req, out := c.DescribeFileSystemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFileSystemsPages iterates over the pages of a DescribeFileSystems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFileSystems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeFileSystems operation.
//    pageNum := 0
//    err := client.DescribeFileSystemsPages(params,
//        func(page *DescribeFileSystemsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FSx) DescribeFileSystemsPages(input *DescribeFileSystemsInput, fn func(*DescribeFileSystemsOutput, bool) bool) error {
	return c.DescribeFileSystemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFileSystemsPagesWithContext same as DescribeFileSystemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeFileSystemsPagesWithContext(ctx aws.Context, input *DescribeFileSystemsInput, fn func(*DescribeFileSystemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFileSystemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFileSystemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeFileSystemsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/ListTagsForResource
func (c *FSx) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon FSx.
//
// Lists tags for an Amazon FSx file systems and backups in the case of Amazon
// FSx for Windows File Server.
//
// When retrieving all tags, you can optionally specify the MaxResults parameter
// to limit the number of tags in a response. If more tags remain, Amazon FSx
// returns a NextToken value in the response. In this case, send a later request
// with the NextToken request parameter set to the value of NextToken from the
// last response.
//
// This action is used in an iterative process to retrieve a list of your tags.
// ListTagsForResource is called first without a NextTokenvalue. Then the action
// continues to be called with the NextToken parameter set to the value of the
// last NextToken value until a response has no NextToken.
//
// When using this action, keep the following in mind:
//
//    * The implementation might return fewer than MaxResults file system descriptions
//    while still including a NextToken value.
//
//    * The order of tags returned in the response of one ListTagsForResource
//    call and the order of tags returned across the responses of a multi-call
//    iteration is unspecified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   The resource specified by the Amazon Resource Name (ARN) can't be found.
//
//   * ErrCodeNotServiceResourceError "NotServiceResourceError"
//   The resource specified for the tagging operation is not a resource type owned
//   by Amazon FSx. Use the API of the relevant service to perform the operation.
//
//   * ErrCodeResourceDoesNotSupportTagging "ResourceDoesNotSupportTagging"
//   The resource specified does not support tagging.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/ListTagsForResource
func (c *FSx) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/TagResource
func (c *FSx) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon FSx.
//
// Tags an Amazon FSx resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   The resource specified by the Amazon Resource Name (ARN) can't be found.
//
//   * ErrCodeNotServiceResourceError "NotServiceResourceError"
//   The resource specified for the tagging operation is not a resource type owned
//   by Amazon FSx. Use the API of the relevant service to perform the operation.
//
//   * ErrCodeResourceDoesNotSupportTagging "ResourceDoesNotSupportTagging"
//   The resource specified does not support tagging.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/TagResource
func (c *FSx) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UntagResource
func (c *FSx) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon FSx.
//
// This action removes a tag from an Amazon FSx resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   The resource specified by the Amazon Resource Name (ARN) can't be found.
//
//   * ErrCodeNotServiceResourceError "NotServiceResourceError"
//   The resource specified for the tagging operation is not a resource type owned
//   by Amazon FSx. Use the API of the relevant service to perform the operation.
//
//   * ErrCodeResourceDoesNotSupportTagging "ResourceDoesNotSupportTagging"
//   The resource specified does not support tagging.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UntagResource
func (c *FSx) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFileSystem = "UpdateFileSystem"

// UpdateFileSystemRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFileSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFileSystem for more information on using the UpdateFileSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFileSystemRequest method.
//    req, resp := client.UpdateFileSystemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UpdateFileSystem
func (c *FSx) UpdateFileSystemRequest(input *UpdateFileSystemInput) (req *request.Request, output *UpdateFileSystemOutput) {
	op := &request.Operation{
		Name:       opUpdateFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFileSystemInput{}
	}

	output = &UpdateFileSystemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFileSystem API operation for Amazon FSx.
//
// Updates a file system configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation UpdateFileSystem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequest "BadRequest"
//   A generic error indicating a failure with a client request.
//
//   * ErrCodeIncompatibleParameterError "IncompatibleParameterError"
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   A generic error indicating a server-side failure.
//
//   * ErrCodeFileSystemNotFound "FileSystemNotFound"
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * ErrCodeMissingFileSystemConfiguration "MissingFileSystemConfiguration"
//   File system configuration is required for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UpdateFileSystem
func (c *FSx) UpdateFileSystem(input *UpdateFileSystemInput) (*UpdateFileSystemOutput, error) {
	req, out := c.UpdateFileSystemRequest(input)
	return out, req.Send()
}

// UpdateFileSystemWithContext is the same as UpdateFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) UpdateFileSystemWithContext(ctx aws.Context, input *UpdateFileSystemInput, opts ...request.Option) (*UpdateFileSystemOutput, error) {
	req, out := c.UpdateFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A backup of an Amazon FSx for Windows File Server file system. You can create
// a new file system from a backup to protect against data loss.
type Backup struct {
	_ struct{} `type:"structure"`

	// The ID of the backup.
	//
	// BackupId is a required field
	BackupId *string `min:"12" type:"string" required:"true"`

	// The time when a particular backup was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Details explaining any failures that occur when creating a backup.
	FailureDetails *BackupFailureDetails `type:"structure"`

	// Metadata of the file system associated with the backup. This metadata is
	// persisted even if the file system is deleted.
	//
	// FileSystem is a required field
	FileSystem *FileSystem `type:"structure" required:"true"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt this
	// backup's data.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the backup.
	//
	// Lifecycle is a required field
	Lifecycle *string `type:"string" required:"true" enum:"BackupLifecycle"`

	// The current percent of progress of an asynchronous task.
	ProgressPercent *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for the backup resource.
	ResourceARN *string `min:"8" type:"string"`

	// Tags associated with a particular file system.
	Tags []*Tag `min:"1" type:"list"`

	// The type of the backup.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"BackupType"`
}

// String returns the string representation
func (s Backup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Backup) GoString() string {
	return s.String()
}

// SetBackupId sets the BackupId field's value.
func (s *Backup) SetBackupId(v string) *Backup {
	s.BackupId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Backup) SetCreationTime(v time.Time) *Backup {
	s.CreationTime = &v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *Backup) SetFailureDetails(v *BackupFailureDetails) *Backup {
	s.FailureDetails = v
	return s
}

// SetFileSystem sets the FileSystem field's value.
func (s *Backup) SetFileSystem(v *FileSystem) *Backup {
	s.FileSystem = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Backup) SetKmsKeyId(v string) *Backup {
	s.KmsKeyId = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *Backup) SetLifecycle(v string) *Backup {
	s.Lifecycle = &v
	return s
}

// SetProgressPercent sets the ProgressPercent field's value.
func (s *Backup) SetProgressPercent(v int64) *Backup {
	s.ProgressPercent = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *Backup) SetResourceARN(v string) *Backup {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Backup) SetTags(v []*Tag) *Backup {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Backup) SetType(v string) *Backup {
	s.Type = &v
	return s
}

// If backup creation fails, this structure contains the details of that failure.
type BackupFailureDetails struct {
	_ struct{} `type:"structure"`

	// A message describing the backup creation failure.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BackupFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupFailureDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *BackupFailureDetails) SetMessage(v string) *BackupFailureDetails {
	s.Message = &v
	return s
}

// The request object for the CreateBackup operation.
type CreateBackupInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent creation. This string is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the file system to back up.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The tags to apply to the backup at backup creation. The key value of the
	// Name tag appears in the console as the backup name.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackupInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateBackupInput) SetClientRequestToken(v string) *CreateBackupInput {
	s.ClientRequestToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateBackupInput) SetFileSystemId(v string) *CreateBackupInput {
	s.FileSystemId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBackupInput) SetTags(v []*Tag) *CreateBackupInput {
	s.Tags = v
	return s
}

// The response object for the CreateBackup operation.
type CreateBackupOutput struct {
	_ struct{} `type:"structure"`

	// A description of the backup.
	Backup *Backup `type:"structure"`
}

// String returns the string representation
func (s CreateBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBackupOutput) GoString() string {
	return s.String()
}

// SetBackup sets the Backup field's value.
func (s *CreateBackupOutput) SetBackup(v *Backup) *CreateBackupOutput {
	s.Backup = v
	return s
}

// The request object for the CreateFileSystemFromBackup operation.
type CreateFileSystemFromBackupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup.
	//
	// BackupId is a required field
	BackupId *string `min:"12" type:"string" required:"true"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent creation. This string is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A list of IDs for the security groups that apply to the specified network
	// interfaces created for file system access. These security groups apply to
	// all network interfaces. This value isn't returned in later describe requests.
	SecurityGroupIds []*string `type:"list"`

	// A list of IDs for the subnets that the file system will be accessible from.
	// Currently, you can specify only one subnet. The file server is also launched
	// in that subnet's Availability Zone.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The tags to be applied to the file system at file system creation. The key
	// value of the Name tag appears in the console as the file system name.
	Tags []*Tag `min:"1" type:"list"`

	// The configuration for this Microsoft Windows file system.
	WindowsConfiguration *CreateFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateFileSystemFromBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemFromBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemFromBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemFromBackupInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}
	if s.BackupId != nil && len(*s.BackupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("BackupId", 12))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *CreateFileSystemFromBackupInput) SetBackupId(v string) *CreateFileSystemFromBackupInput {
	s.BackupId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateFileSystemFromBackupInput) SetClientRequestToken(v string) *CreateFileSystemFromBackupInput {
	s.ClientRequestToken = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateFileSystemFromBackupInput) SetSecurityGroupIds(v []*string) *CreateFileSystemFromBackupInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateFileSystemFromBackupInput) SetSubnetIds(v []*string) *CreateFileSystemFromBackupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFileSystemFromBackupInput) SetTags(v []*Tag) *CreateFileSystemFromBackupInput {
	s.Tags = v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *CreateFileSystemFromBackupInput) SetWindowsConfiguration(v *CreateFileSystemWindowsConfiguration) *CreateFileSystemFromBackupInput {
	s.WindowsConfiguration = v
	return s
}

// The response object for the CreateFileSystemFromBackup operation.
type CreateFileSystemFromBackupOutput struct {
	_ struct{} `type:"structure"`

	// A description of the file system.
	FileSystem *FileSystem `type:"structure"`
}

// String returns the string representation
func (s CreateFileSystemFromBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemFromBackupOutput) GoString() string {
	return s.String()
}

// SetFileSystem sets the FileSystem field's value.
func (s *CreateFileSystemFromBackupOutput) SetFileSystem(v *FileSystem) *CreateFileSystemFromBackupOutput {
	s.FileSystem = v
	return s
}

// The request object for the CreateFileSystem operation.
type CreateFileSystemInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent creation. This string is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The type of file system.
	//
	// FileSystemType is a required field
	FileSystemType *string `type:"string" required:"true" enum:"FileSystemType"`

	// The ID of your AWS Key Management Service (AWS KMS) key. This ID is used
	// to encrypt the data in your file system at rest. For more information, see
	// Encrypt (https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html)
	// in the AWS Key Management Service API Reference.
	KmsKeyId *string `min:"1" type:"string"`

	// The configuration object for Lustre file systems used in the CreateFileSystem
	// operation.
	LustreConfiguration *CreateFileSystemLustreConfiguration `type:"structure"`

	// A list of IDs for the security groups that apply to the specified network
	// interfaces created for file system access. These security groups will apply
	// to all network interfaces. This list isn't returned in later describe requests.
	SecurityGroupIds []*string `type:"list"`

	// The storage capacity of the file system.
	//
	// For Windows file systems, the storage capacity has a minimum of 300 GiB,
	// and a maximum of 65,536 GiB.
	//
	// For Lustre file systems, the storage capacity has a minimum of 3,600 GiB.
	// Storage capacity is provisioned in increments of 3,600 GiB.
	//
	// StorageCapacity is a required field
	StorageCapacity *int64 `min:"1" type:"integer" required:"true"`

	// A list of IDs for the subnets that the file system will be accessible from.
	// File systems support only one subnet. The file server is also launched in
	// that subnet's Availability Zone.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The tags to be applied to the file system at file system creation. The key
	// value of the Name tag appears in the console as the file system name.
	Tags []*Tag `min:"1" type:"list"`

	// The configuration for this Microsoft Windows file system.
	WindowsConfiguration *CreateFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FileSystemType == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemType"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.StorageCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageCapacity"))
	}
	if s.StorageCapacity != nil && *s.StorageCapacity < 1 {
		invalidParams.Add(request.NewErrParamMinValue("StorageCapacity", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.LustreConfiguration != nil {
		if err := s.LustreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateFileSystemInput) SetClientRequestToken(v string) *CreateFileSystemInput {
	s.ClientRequestToken = &v
	return s
}

// SetFileSystemType sets the FileSystemType field's value.
func (s *CreateFileSystemInput) SetFileSystemType(v string) *CreateFileSystemInput {
	s.FileSystemType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateFileSystemInput) SetKmsKeyId(v string) *CreateFileSystemInput {
	s.KmsKeyId = &v
	return s
}

// SetLustreConfiguration sets the LustreConfiguration field's value.
func (s *CreateFileSystemInput) SetLustreConfiguration(v *CreateFileSystemLustreConfiguration) *CreateFileSystemInput {
	s.LustreConfiguration = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateFileSystemInput) SetSecurityGroupIds(v []*string) *CreateFileSystemInput {
	s.SecurityGroupIds = v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *CreateFileSystemInput) SetStorageCapacity(v int64) *CreateFileSystemInput {
	s.StorageCapacity = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateFileSystemInput) SetSubnetIds(v []*string) *CreateFileSystemInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFileSystemInput) SetTags(v []*Tag) *CreateFileSystemInput {
	s.Tags = v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *CreateFileSystemInput) SetWindowsConfiguration(v *CreateFileSystemWindowsConfiguration) *CreateFileSystemInput {
	s.WindowsConfiguration = v
	return s
}

// The configuration object for Lustre file systems used in the CreateFileSystem
// operation.
type CreateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// (Optional) The path in Amazon S3 where the root of your Amazon FSx file system
	// is exported. The path must use the same Amazon S3 bucket as specified in
	// ImportPath. You can provide an optional prefix to which new and changed data
	// is to be exported from your Amazon FSx for Lustre file system. If an ExportPath
	// value is not provided, Amazon FSx sets a default export path, s3://import-bucket/FSxLustre[creation-timestamp].
	// The timestamp is in UTC format, for example s3://import-bucket/FSxLustre20181105T222312Z.
	//
	// The Amazon S3 export bucket must be the same as the import bucket specified
	// by ImportPath. If you only specify a bucket name, such as s3://import-bucket,
	// you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping
	// means that the input data in S3 is overwritten on export. If you provide
	// a custom prefix in the export path, such as s3://import-bucket/[custom-optional-prefix],
	// Amazon FSx exports the contents of your file system to that export prefix
	// in the Amazon S3 bucket.
	ExportPath *string `min:"3" type:"string"`

	// (Optional) The path to the Amazon S3 bucket (including the optional prefix)
	// that you're using as the data repository for your Amazon FSx for Lustre file
	// system. The root of your FSx for Lustre file system will be mapped to the
	// root of the Amazon S3 bucket you select. An example is s3://import-bucket/optional-prefix.
	// If you specify a prefix after the Amazon S3 bucket name, only object keys
	// with that prefix are loaded into the file system.
	ImportPath *string `min:"3" type:"string"`

	// (Optional) For files imported from a data repository, this value determines
	// the stripe count and maximum amount of data per file (in MiB) stored on a
	// single physical disk. The maximum number of disks that a single file can
	// be striped across is limited by the total number of disks that make up the
	// file system.
	//
	// The chunk size default is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemLustreConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemLustreConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemLustreConfiguration"}
	if s.ExportPath != nil && len(*s.ExportPath) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ExportPath", 3))
	}
	if s.ImportPath != nil && len(*s.ImportPath) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ImportPath", 3))
	}
	if s.ImportedFileChunkSize != nil && *s.ImportedFileChunkSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ImportedFileChunkSize", 1))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportPath sets the ExportPath field's value.
func (s *CreateFileSystemLustreConfiguration) SetExportPath(v string) *CreateFileSystemLustreConfiguration {
	s.ExportPath = &v
	return s
}

// SetImportPath sets the ImportPath field's value.
func (s *CreateFileSystemLustreConfiguration) SetImportPath(v string) *CreateFileSystemLustreConfiguration {
	s.ImportPath = &v
	return s
}

// SetImportedFileChunkSize sets the ImportedFileChunkSize field's value.
func (s *CreateFileSystemLustreConfiguration) SetImportedFileChunkSize(v int64) *CreateFileSystemLustreConfiguration {
	s.ImportedFileChunkSize = &v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *CreateFileSystemLustreConfiguration) SetWeeklyMaintenanceStartTime(v string) *CreateFileSystemLustreConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The response object for the CreateFileSystem operation.
type CreateFileSystemOutput struct {
	_ struct{} `type:"structure"`

	// A description of the file system.
	FileSystem *FileSystem `type:"structure"`
}

// String returns the string representation
func (s CreateFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemOutput) GoString() string {
	return s.String()
}

// SetFileSystem sets the FileSystem field's value.
func (s *CreateFileSystemOutput) SetFileSystem(v *FileSystem) *CreateFileSystemOutput {
	s.FileSystem = v
	return s
}

// The configuration object for the Microsoft Windows file system used in CreateFileSystem
// and CreateFileSystemFromBackup operations.
type CreateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing Microsoft Active Directory instance that the file
	// system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. The default is to retain
	// backups for 7 days. Setting this value to 0 disables the creation of automatic
	// backups. The maximum retention period for backups is 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags on the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags on
	// the file system are copied to all automatic backups and any user-initiated
	// backups where the user doesn't specify any tags. If this value is true, and
	// you specify one or more tags, only the specified tags are copied to backups.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second.
	//
	// ThroughputCapacity is a required field
	ThroughputCapacity *int64 `min:"8" type:"integer" required:"true"`

	// The preferred start time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemWindowsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemWindowsConfiguration"}
	if s.ActiveDirectoryId != nil && len(*s.ActiveDirectoryId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("ActiveDirectoryId", 12))
	}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.ThroughputCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ThroughputCapacity"))
	}
	if s.ThroughputCapacity != nil && *s.ThroughputCapacity < 8 {
		invalidParams.Add(request.NewErrParamMinValue("ThroughputCapacity", 8))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActiveDirectoryId sets the ActiveDirectoryId field's value.
func (s *CreateFileSystemWindowsConfiguration) SetActiveDirectoryId(v string) *CreateFileSystemWindowsConfiguration {
	s.ActiveDirectoryId = &v
	return s
}

// SetAutomaticBackupRetentionDays sets the AutomaticBackupRetentionDays field's value.
func (s *CreateFileSystemWindowsConfiguration) SetAutomaticBackupRetentionDays(v int64) *CreateFileSystemWindowsConfiguration {
	s.AutomaticBackupRetentionDays = &v
	return s
}

// SetCopyTagsToBackups sets the CopyTagsToBackups field's value.
func (s *CreateFileSystemWindowsConfiguration) SetCopyTagsToBackups(v bool) *CreateFileSystemWindowsConfiguration {
	s.CopyTagsToBackups = &v
	return s
}

// SetDailyAutomaticBackupStartTime sets the DailyAutomaticBackupStartTime field's value.
func (s *CreateFileSystemWindowsConfiguration) SetDailyAutomaticBackupStartTime(v string) *CreateFileSystemWindowsConfiguration {
	s.DailyAutomaticBackupStartTime = &v
	return s
}

// SetThroughputCapacity sets the ThroughputCapacity field's value.
func (s *CreateFileSystemWindowsConfiguration) SetThroughputCapacity(v int64) *CreateFileSystemWindowsConfiguration {
	s.ThroughputCapacity = &v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *CreateFileSystemWindowsConfiguration) SetWeeklyMaintenanceStartTime(v string) *CreateFileSystemWindowsConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The data repository configuration object for Lustre file systems returned
// in the response of the CreateFileSystem operation.
type DataRepositoryConfiguration struct {
	_ struct{} `type:"structure"`

	// The export path to the Amazon S3 bucket (and prefix) that you are using to
	// store new and changed Lustre file system files in S3.
	ExportPath *string `min:"3" type:"string"`

	// The import path to the Amazon S3 bucket (and optional prefix) that you're
	// using as the data repository for your FSx for Lustre file system, for example
	// s3://import-bucket/optional-prefix. If a prefix is specified after the Amazon
	// S3 bucket name, only object keys with that prefix are loaded into the file
	// system.
	ImportPath *string `min:"3" type:"string"`

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across
	// is limited by the total number of disks that make up the file system.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DataRepositoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRepositoryConfiguration) GoString() string {
	return s.String()
}

// SetExportPath sets the ExportPath field's value.
func (s *DataRepositoryConfiguration) SetExportPath(v string) *DataRepositoryConfiguration {
	s.ExportPath = &v
	return s
}

// SetImportPath sets the ImportPath field's value.
func (s *DataRepositoryConfiguration) SetImportPath(v string) *DataRepositoryConfiguration {
	s.ImportPath = &v
	return s
}

// SetImportedFileChunkSize sets the ImportedFileChunkSize field's value.
func (s *DataRepositoryConfiguration) SetImportedFileChunkSize(v int64) *DataRepositoryConfiguration {
	s.ImportedFileChunkSize = &v
	return s
}

// The request object for DeleteBackup operation.
type DeleteBackupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup you want to delete.
	//
	// BackupId is a required field
	BackupId *string `min:"12" type:"string" required:"true"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent deletion. This is automatically filled on your behalf when
	// using the AWS CLI or SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}
	if s.BackupId != nil && len(*s.BackupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("BackupId", 12))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *DeleteBackupInput) SetBackupId(v string) *DeleteBackupInput {
	s.BackupId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteBackupInput) SetClientRequestToken(v string) *DeleteBackupInput {
	s.ClientRequestToken = &v
	return s
}

// The response object for DeleteBackup operation.
type DeleteBackupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup deleted.
	BackupId *string `min:"12" type:"string"`

	// The lifecycle of the backup. Should be DELETED.
	Lifecycle *string `type:"string" enum:"BackupLifecycle"`
}

// String returns the string representation
func (s DeleteBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBackupOutput) GoString() string {
	return s.String()
}

// SetBackupId sets the BackupId field's value.
func (s *DeleteBackupOutput) SetBackupId(v string) *DeleteBackupOutput {
	s.BackupId = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *DeleteBackupOutput) SetLifecycle(v string) *DeleteBackupOutput {
	s.Lifecycle = &v
	return s
}

// The request object for DeleteFileSystem operation.
type DeleteFileSystemInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent deletion. This is automatically filled on your behalf when
	// using the AWS CLI or SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the file system you want to delete.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The configuration object for the Microsoft Windows file system used in the
	// DeleteFileSystem operation.
	WindowsConfiguration *DeleteFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s DeleteFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFileSystemInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteFileSystemInput) SetClientRequestToken(v string) *DeleteFileSystemInput {
	s.ClientRequestToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DeleteFileSystemInput) SetFileSystemId(v string) *DeleteFileSystemInput {
	s.FileSystemId = &v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *DeleteFileSystemInput) SetWindowsConfiguration(v *DeleteFileSystemWindowsConfiguration) *DeleteFileSystemInput {
	s.WindowsConfiguration = v
	return s
}

// The response object for the DeleteFileSystem operation.
type DeleteFileSystemOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the file system being deleted.
	FileSystemId *string `min:"11" type:"string"`

	// The file system lifecycle for the deletion request. Should be DELETING.
	Lifecycle *string `type:"string" enum:"FileSystemLifecycle"`

	// The response object for the Microsoft Windows file system used in the DeleteFileSystem
	// operation.
	WindowsResponse *DeleteFileSystemWindowsResponse `type:"structure"`
}

// String returns the string representation
func (s DeleteFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileSystemOutput) GoString() string {
	return s.String()
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DeleteFileSystemOutput) SetFileSystemId(v string) *DeleteFileSystemOutput {
	s.FileSystemId = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *DeleteFileSystemOutput) SetLifecycle(v string) *DeleteFileSystemOutput {
	s.Lifecycle = &v
	return s
}

// SetWindowsResponse sets the WindowsResponse field's value.
func (s *DeleteFileSystemOutput) SetWindowsResponse(v *DeleteFileSystemWindowsResponse) *DeleteFileSystemOutput {
	s.WindowsResponse = v
	return s
}

// The configuration object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// A set of tags for your final backup.
	FinalBackupTags []*Tag `min:"1" type:"list"`

	// By default, Amazon FSx for Windows takes a final backup on your behalf when
	// the DeleteFileSystem operation is invoked. Doing this helps protect you from
	// data loss, and we highly recommend taking the final backup. If you want to
	// skip this backup, use this flag to do so.
	SkipFinalBackup *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileSystemWindowsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemWindowsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFileSystemWindowsConfiguration"}
	if s.FinalBackupTags != nil && len(s.FinalBackupTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FinalBackupTags", 1))
	}
	if s.FinalBackupTags != nil {
		for i, v := range s.FinalBackupTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FinalBackupTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFinalBackupTags sets the FinalBackupTags field's value.
func (s *DeleteFileSystemWindowsConfiguration) SetFinalBackupTags(v []*Tag) *DeleteFileSystemWindowsConfiguration {
	s.FinalBackupTags = v
	return s
}

// SetSkipFinalBackup sets the SkipFinalBackup field's value.
func (s *DeleteFileSystemWindowsConfiguration) SetSkipFinalBackup(v bool) *DeleteFileSystemWindowsConfiguration {
	s.SkipFinalBackup = &v
	return s
}

// The response object for the Microsoft Windows file system used in the DeleteFileSystem
// operation.
type DeleteFileSystemWindowsResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the final backup for this file system.
	FinalBackupId *string `min:"12" type:"string"`

	// The set of tags applied to the final backup.
	FinalBackupTags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileSystemWindowsResponse) GoString() string {
	return s.String()
}

// SetFinalBackupId sets the FinalBackupId field's value.
func (s *DeleteFileSystemWindowsResponse) SetFinalBackupId(v string) *DeleteFileSystemWindowsResponse {
	s.FinalBackupId = &v
	return s
}

// SetFinalBackupTags sets the FinalBackupTags field's value.
func (s *DeleteFileSystemWindowsResponse) SetFinalBackupTags(v []*Tag) *DeleteFileSystemWindowsResponse {
	s.FinalBackupTags = v
	return s
}

// The request object for DescribeBackups operation.
type DescribeBackupsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) IDs of the backups you want to retrieve (String). This overrides
	// any filters. If any IDs are not found, BackupNotFound will be thrown.
	BackupIds []*string `type:"list"`

	// (Optional) Filters structure. Supported names are file-system-id and backup-type.
	Filters []*Filter `type:"list"`

	// (Optional) Maximum number of backups to return in the response (integer).
	// This parameter value must be greater than 0. The number of items that Amazon
	// FSx returns is the minimum of the MaxResults parameter specified in the request
	// and the service's internal maximum number of items per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Opaque pagination token returned from a previous DescribeBackups
	// operation (String). If a token present, the action continues the list from
	// where the returning call left off.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupIds sets the BackupIds field's value.
func (s *DescribeBackupsInput) SetBackupIds(v []*string) *DescribeBackupsInput {
	s.BackupIds = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeBackupsInput) SetFilters(v []*Filter) *DescribeBackupsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBackupsInput) SetMaxResults(v int64) *DescribeBackupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBackupsInput) SetNextToken(v string) *DescribeBackupsInput {
	s.NextToken = &v
	return s
}

// Response object for DescribeBackups operation.
type DescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	// Any array of backups.
	Backups []*Backup `type:"list"`

	// This is present if there are more backups than returned in the response (String).
	// You can use the NextToken value in the later request to fetch the backups.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetBackups sets the Backups field's value.
func (s *DescribeBackupsOutput) SetBackups(v []*Backup) *DescribeBackupsOutput {
	s.Backups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBackupsOutput) SetNextToken(v string) *DescribeBackupsOutput {
	s.NextToken = &v
	return s
}

// The request object for DescribeFileSystems operation.
type DescribeFileSystemsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) IDs of the file systems whose descriptions you want to retrieve
	// (String).
	FileSystemIds []*string `type:"list"`

	// (Optional) Maximum number of file systems to return in the response (integer).
	// This parameter value must be greater than 0. The number of items that Amazon
	// FSx returns is the minimum of the MaxResults parameter specified in the request
	// and the service's internal maximum number of items per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Opaque pagination token returned from a previous DescribeFileSystems
	// operation (String). If a token present, the action continues the list from
	// where the returning call left off.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFileSystemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFileSystemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFileSystemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFileSystemsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemIds sets the FileSystemIds field's value.
func (s *DescribeFileSystemsInput) SetFileSystemIds(v []*string) *DescribeFileSystemsInput {
	s.FileSystemIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeFileSystemsInput) SetMaxResults(v int64) *DescribeFileSystemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFileSystemsInput) SetNextToken(v string) *DescribeFileSystemsInput {
	s.NextToken = &v
	return s
}

// The response object for DescribeFileSystems operation.
type DescribeFileSystemsOutput struct {
	_ struct{} `type:"structure"`

	// An array of file system descriptions.
	FileSystems []*FileSystem `type:"list"`

	// Present if there are more file systems than returned in the response (String).
	// You can use the NextToken value in the later request to fetch the descriptions.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFileSystemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFileSystemsOutput) GoString() string {
	return s.String()
}

// SetFileSystems sets the FileSystems field's value.
func (s *DescribeFileSystemsOutput) SetFileSystems(v []*FileSystem) *DescribeFileSystemsOutput {
	s.FileSystems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFileSystemsOutput) SetNextToken(v string) *DescribeFileSystemsOutput {
	s.NextToken = &v
	return s
}

// A description of a specific Amazon FSx file system.
type FileSystem struct {
	_ struct{} `type:"structure"`

	// The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	CreationTime *time.Time `type:"timestamp"`

	// The DNS name for the file system.
	DNSName *string `min:"16" type:"string"`

	// Structure providing details of any failures that occur when creating the
	// file system has failed.
	FailureDetails *FileSystemFailureDetails `type:"structure"`

	// The eight-digit ID of the file system that was automatically assigned by
	// Amazon FSx.
	FileSystemId *string `min:"11" type:"string"`

	// Type of file system. Currently the only supported type is WINDOWS.
	FileSystemType *string `type:"string" enum:"FileSystemType"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the
	// file system's data for an Amazon FSx for Windows File Server file system.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the file system.
	Lifecycle *string `type:"string" enum:"FileSystemLifecycle"`

	// The configuration for the Amazon FSx for Lustre file system.
	LustreConfiguration *LustreFileSystemConfiguration `type:"structure"`

	// The IDs of the elastic network interface from which a specific file system
	// is accessible. The elastic network interface is automatically created in
	// the same VPC that the Amazon FSx file system was created in. For more information,
	// see Elastic Network Interfaces (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html)
	// in the Amazon EC2 User Guide.
	//
	// For an Amazon FSx for Windows File Server file system, you can have one network
	// interface Id. For an Amazon FSx for Lustre file system, you can have more
	// than one.
	NetworkInterfaceIds []*string `type:"list"`

	// The AWS account that created the file system. If the file system was created
	// by an IAM user, the AWS account to which the IAM user belongs is the owner.
	OwnerId *string `min:"12" type:"string"`

	// The resource ARN of the file system.
	ResourceARN *string `min:"8" type:"string"`

	// The storage capacity of the file system in gigabytes.
	StorageCapacity *int64 `min:"1" type:"integer"`

	// The IDs of the subnets to contain the endpoint for the file system. One and
	// only one is supported. The file system is launched in the Availability Zone
	// associated with this subnet.
	SubnetIds []*string `type:"list"`

	// The tags to associate with the file system. For more information, see Tagging
	// Your Amazon EC2 Resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
	// in the Amazon EC2 User Guide.
	Tags []*Tag `min:"1" type:"list"`

	// The ID of the primary VPC for the file system.
	VpcId *string `min:"12" type:"string"`

	// The configuration for this Microsoft Windows file system.
	WindowsConfiguration *WindowsFileSystemConfiguration `type:"structure"`
}

// String returns the string representation
func (s FileSystem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileSystem) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *FileSystem) SetCreationTime(v time.Time) *FileSystem {
	s.CreationTime = &v
	return s
}

// SetDNSName sets the DNSName field's value.
func (s *FileSystem) SetDNSName(v string) *FileSystem {
	s.DNSName = &v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *FileSystem) SetFailureDetails(v *FileSystemFailureDetails) *FileSystem {
	s.FailureDetails = v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *FileSystem) SetFileSystemId(v string) *FileSystem {
	s.FileSystemId = &v
	return s
}

// SetFileSystemType sets the FileSystemType field's value.
func (s *FileSystem) SetFileSystemType(v string) *FileSystem {
	s.FileSystemType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *FileSystem) SetKmsKeyId(v string) *FileSystem {
	s.KmsKeyId = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *FileSystem) SetLifecycle(v string) *FileSystem {
	s.Lifecycle = &v
	return s
}

// SetLustreConfiguration sets the LustreConfiguration field's value.
func (s *FileSystem) SetLustreConfiguration(v *LustreFileSystemConfiguration) *FileSystem {
	s.LustreConfiguration = v
	return s
}

// SetNetworkInterfaceIds sets the NetworkInterfaceIds field's value.
func (s *FileSystem) SetNetworkInterfaceIds(v []*string) *FileSystem {
	s.NetworkInterfaceIds = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *FileSystem) SetOwnerId(v string) *FileSystem {
	s.OwnerId = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *FileSystem) SetResourceARN(v string) *FileSystem {
	s.ResourceARN = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *FileSystem) SetStorageCapacity(v int64) *FileSystem {
	s.StorageCapacity = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *FileSystem) SetSubnetIds(v []*string) *FileSystem {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *FileSystem) SetTags(v []*Tag) *FileSystem {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *FileSystem) SetVpcId(v string) *FileSystem {
	s.VpcId = &v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *FileSystem) SetWindowsConfiguration(v *WindowsFileSystemConfiguration) *FileSystem {
	s.WindowsConfiguration = v
	return s
}

// Structure providing details of any failures that occur when creating the
// file system has failed.
type FileSystemFailureDetails struct {
	_ struct{} `type:"structure"`

	// Message describing the failures that occurred during file system creation.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FileSystemFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileSystemFailureDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *FileSystemFailureDetails) SetMessage(v string) *FileSystemFailureDetails {
	s.Message = &v
	return s
}

// A filter used to restrict the results of describe calls. You can use multiple
// filters to return results that meet all applied filter requirements.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name for this filter.
	Name *string `type:"string" enum:"FilterName"`

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// The request object for ListTagsForResource operation.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Maximum number of tags to return in the response (integer). This
	// parameter value must be greater than 0. The number of items that Amazon FSx
	// returns is the minimum of the MaxResults parameter specified in the request
	// and the service's internal maximum number of items per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Opaque pagination token returned from a previous ListTagsForResource
	// operation (String). If a token present, the action continues the list from
	// where the returning call left off.
	NextToken *string `min:"1" type:"string"`

	// The ARN of the Amazon FSx resource that will have its tags listed.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

// The response object for ListTagsForResource operation.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// This is present if there are more tags than returned in the response (String).
	// You can use the NextToken value in the later request to fetch the tags.
	NextToken *string `min:"1" type:"string"`

	// A list of tags on the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The configuration for the Amazon FSx for Lustre file system.
type LustreFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The data repository configuration object for Lustre file systems returned
	// in the response of the CreateFileSystem operation.
	DataRepositoryConfiguration *DataRepositoryConfiguration `type:"structure"`

	// The UTC time that you want to begin your weekly maintenance window.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s LustreFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LustreFileSystemConfiguration) GoString() string {
	return s.String()
}

// SetDataRepositoryConfiguration sets the DataRepositoryConfiguration field's value.
func (s *LustreFileSystemConfiguration) SetDataRepositoryConfiguration(v *DataRepositoryConfiguration) *LustreFileSystemConfiguration {
	s.DataRepositoryConfiguration = v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *LustreFileSystemConfiguration) SetWeeklyMaintenanceStartTime(v string) *LustreFileSystemConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// Specifies a key-value pair for a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// A value that specifies the TagKey, the name of the tag. Tag keys must be
	// unique for the resource to which they are attached.
	Key *string `min:"1" type:"string"`

	// A value that specifies the TagValue, the value assigned to the corresponding
	// tag key. Tag values can be null and don't have to be unique in a tag set.
	// For example, you can have a key-value pair in a tag set of finances : April
	// and also of payroll : April.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The request object for the TagResource operation.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to
	// tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`

	// A list of tags for the resource. If a tag with a given key already exists,
	// the value is replaced by the one specified in this parameter.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 8))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

// The response object for the TagResource operation.
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request object for UntagResource action.
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon FSx resource to untag.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`

	// A list of keys of tags on the resource to untag. In case the tag key doesn't
	// exist, the call will still succeed to be idempotent.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 8))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// The response object for UntagResource action.
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The request object for the UpdateFileSystem operation.
type UpdateFileSystemInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent updates. This string is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The globally unique ID of the file system, assigned by Amazon FSx.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The configuration object for Amazon FSx for Lustre file systems used in the
	// UpdateFileSystem operation.
	LustreConfiguration *UpdateFileSystemLustreConfiguration `type:"structure"`

	// The configuration for this Microsoft Windows file system. The only supported
	// options are for backup and maintenance.
	WindowsConfiguration *UpdateFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFileSystemInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.LustreConfiguration != nil {
		if err := s.LustreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateFileSystemInput) SetClientRequestToken(v string) *UpdateFileSystemInput {
	s.ClientRequestToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *UpdateFileSystemInput) SetFileSystemId(v string) *UpdateFileSystemInput {
	s.FileSystemId = &v
	return s
}

// SetLustreConfiguration sets the LustreConfiguration field's value.
func (s *UpdateFileSystemInput) SetLustreConfiguration(v *UpdateFileSystemLustreConfiguration) *UpdateFileSystemInput {
	s.LustreConfiguration = v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *UpdateFileSystemInput) SetWindowsConfiguration(v *UpdateFileSystemWindowsConfiguration) *UpdateFileSystemInput {
	s.WindowsConfiguration = v
	return s
}

// The configuration object for Amazon FSx for Lustre file systems used in the
// UpdateFileSystem operation.
type UpdateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFileSystemLustreConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemLustreConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFileSystemLustreConfiguration"}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *UpdateFileSystemLustreConfiguration) SetWeeklyMaintenanceStartTime(v string) *UpdateFileSystemLustreConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The response object for the UpdateFileSystem operation.
type UpdateFileSystemOutput struct {
	_ struct{} `type:"structure"`

	// A description of the file system.
	FileSystem *FileSystem `type:"structure"`
}

// String returns the string representation
func (s UpdateFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFileSystemOutput) GoString() string {
	return s.String()
}

// SetFileSystem sets the FileSystem field's value.
func (s *UpdateFileSystemOutput) SetFileSystem(v *FileSystem) *UpdateFileSystemOutput {
	s.FileSystem = v
	return s
}

// The configuration object for the Microsoft Windows file system used in the
// UpdateFileSystem operation.
type UpdateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFileSystemWindowsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFileSystemWindowsConfiguration"}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticBackupRetentionDays sets the AutomaticBackupRetentionDays field's value.
func (s *UpdateFileSystemWindowsConfiguration) SetAutomaticBackupRetentionDays(v int64) *UpdateFileSystemWindowsConfiguration {
	s.AutomaticBackupRetentionDays = &v
	return s
}

// SetDailyAutomaticBackupStartTime sets the DailyAutomaticBackupStartTime field's value.
func (s *UpdateFileSystemWindowsConfiguration) SetDailyAutomaticBackupStartTime(v string) *UpdateFileSystemWindowsConfiguration {
	s.DailyAutomaticBackupStartTime = &v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *UpdateFileSystemWindowsConfiguration) SetWeeklyMaintenanceStartTime(v string) *UpdateFileSystemWindowsConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The configuration for this Microsoft Windows file system.
type WindowsFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing Microsoft Active Directory instance that the file
	// system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags on the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags on
	// the file system are copied to all automatic backups and any user-initiated
	// backups where the user doesn't specify any tags. If this value is true, and
	// you specify one or more tags, only the specified tags are copied to backups.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The list of maintenance operations in progress for this file system.
	MaintenanceOperationsInProgress []*string `type:"list"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second.
	ThroughputCapacity *int64 `min:"8" type:"integer"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s WindowsFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WindowsFileSystemConfiguration) GoString() string {
	return s.String()
}

// SetActiveDirectoryId sets the ActiveDirectoryId field's value.
func (s *WindowsFileSystemConfiguration) SetActiveDirectoryId(v string) *WindowsFileSystemConfiguration {
	s.ActiveDirectoryId = &v
	return s
}

// SetAutomaticBackupRetentionDays sets the AutomaticBackupRetentionDays field's value.
func (s *WindowsFileSystemConfiguration) SetAutomaticBackupRetentionDays(v int64) *WindowsFileSystemConfiguration {
	s.AutomaticBackupRetentionDays = &v
	return s
}

// SetCopyTagsToBackups sets the CopyTagsToBackups field's value.
func (s *WindowsFileSystemConfiguration) SetCopyTagsToBackups(v bool) *WindowsFileSystemConfiguration {
	s.CopyTagsToBackups = &v
	return s
}

// SetDailyAutomaticBackupStartTime sets the DailyAutomaticBackupStartTime field's value.
func (s *WindowsFileSystemConfiguration) SetDailyAutomaticBackupStartTime(v string) *WindowsFileSystemConfiguration {
	s.DailyAutomaticBackupStartTime = &v
	return s
}

// SetMaintenanceOperationsInProgress sets the MaintenanceOperationsInProgress field's value.
func (s *WindowsFileSystemConfiguration) SetMaintenanceOperationsInProgress(v []*string) *WindowsFileSystemConfiguration {
	s.MaintenanceOperationsInProgress = v
	return s
}

// SetThroughputCapacity sets the ThroughputCapacity field's value.
func (s *WindowsFileSystemConfiguration) SetThroughputCapacity(v int64) *WindowsFileSystemConfiguration {
	s.ThroughputCapacity = &v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *WindowsFileSystemConfiguration) SetWeeklyMaintenanceStartTime(v string) *WindowsFileSystemConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The type of error relating to Microsoft Active Directory. NOT_FOUND means
// that no directory was found by specifying the given directory. INCOMPATIBLE_MODE
// means that the directory specified is not a Microsoft AD directory. WRONG_VPC
// means that the specified directory isn't accessible from the specified VPC.
// WRONG_STAGE means that the specified directory isn't currently in the ACTIVE
// state.
const (
	// ActiveDirectoryErrorTypeDomainNotFound is a ActiveDirectoryErrorType enum value
	ActiveDirectoryErrorTypeDomainNotFound = "DOMAIN_NOT_FOUND"

	// ActiveDirectoryErrorTypeIncompatibleDomainMode is a ActiveDirectoryErrorType enum value
	ActiveDirectoryErrorTypeIncompatibleDomainMode = "INCOMPATIBLE_DOMAIN_MODE"

	// ActiveDirectoryErrorTypeWrongVpc is a ActiveDirectoryErrorType enum value
	ActiveDirectoryErrorTypeWrongVpc = "WRONG_VPC"

	// ActiveDirectoryErrorTypeInvalidDomainStage is a ActiveDirectoryErrorType enum value
	ActiveDirectoryErrorTypeInvalidDomainStage = "INVALID_DOMAIN_STAGE"
)

// The lifecycle status of the backup.
const (
	// BackupLifecycleAvailable is a BackupLifecycle enum value
	BackupLifecycleAvailable = "AVAILABLE"

	// BackupLifecycleCreating is a BackupLifecycle enum value
	BackupLifecycleCreating = "CREATING"

	// BackupLifecycleDeleted is a BackupLifecycle enum value
	BackupLifecycleDeleted = "DELETED"

	// BackupLifecycleFailed is a BackupLifecycle enum value
	BackupLifecycleFailed = "FAILED"
)

// The type of the backup.
const (
	// BackupTypeAutomatic is a BackupType enum value
	BackupTypeAutomatic = "AUTOMATIC"

	// BackupTypeUserInitiated is a BackupType enum value
	BackupTypeUserInitiated = "USER_INITIATED"
)

// The lifecycle status of the file system.
const (
	// FileSystemLifecycleAvailable is a FileSystemLifecycle enum value
	FileSystemLifecycleAvailable = "AVAILABLE"

	// FileSystemLifecycleCreating is a FileSystemLifecycle enum value
	FileSystemLifecycleCreating = "CREATING"

	// FileSystemLifecycleFailed is a FileSystemLifecycle enum value
	FileSystemLifecycleFailed = "FAILED"

	// FileSystemLifecycleDeleting is a FileSystemLifecycle enum value
	FileSystemLifecycleDeleting = "DELETING"
)

// An enumeration specifying the currently ongoing maintenance operation.
const (
	// FileSystemMaintenanceOperationPatching is a FileSystemMaintenanceOperation enum value
	FileSystemMaintenanceOperationPatching = "PATCHING"

	// FileSystemMaintenanceOperationBackingUp is a FileSystemMaintenanceOperation enum value
	FileSystemMaintenanceOperationBackingUp = "BACKING_UP"
)

// The type of file system.
const (
	// FileSystemTypeWindows is a FileSystemType enum value
	FileSystemTypeWindows = "WINDOWS"

	// FileSystemTypeLustre is a FileSystemType enum value
	FileSystemTypeLustre = "LUSTRE"
)

// The name for a filter.
const (
	// FilterNameFileSystemId is a FilterName enum value
	FilterNameFileSystemId = "file-system-id"

	// FilterNameBackupType is a FilterName enum value
	FilterNameBackupType = "backup-type"
)

// The types of limits on your service utilization. Limits include file system
// count, total throughput capacity, total storage, and total user-initiated
// backups. These limits apply for a specific account in a specific AWS Region.
// You can increase some of them by contacting AWS Support.
const (
	// ServiceLimitFileSystemCount is a ServiceLimit enum value
	ServiceLimitFileSystemCount = "FILE_SYSTEM_COUNT"

	// ServiceLimitTotalThroughputCapacity is a ServiceLimit enum value
	ServiceLimitTotalThroughputCapacity = "TOTAL_THROUGHPUT_CAPACITY"

	// ServiceLimitTotalStorage is a ServiceLimit enum value
	ServiceLimitTotalStorage = "TOTAL_STORAGE"

	// ServiceLimitTotalUserInitiatedBackups is a ServiceLimit enum value
	ServiceLimitTotalUserInitiatedBackups = "TOTAL_USER_INITIATED_BACKUPS"
)
