// +build tools

// Official workaround to track tool dependencies with go modules:
// https://github.com/golang/go/wiki/Modules#how-can-i-track-tool-dependencies-for-a-module

package tools

import (
	// Makefile
	"github.com/jteeuwen/go-bindata/go-bindata"
	"github.com/openshift/library-go/alpha-build-machinery/make/targets/openshift"

	// required by hack/codegen/update-generated.sh
	_ "k8s.io/code-generator"
	_ "k8s.io/code-generator/cmd/client-gen"
	_ "k8s.io/code-generator/cmd/deepcopy-gen"
	_ "k8s.io/code-generator/cmd/defaulter-gen"
	_ "k8s.io/code-generator/cmd/informer-gen"
	_ "k8s.io/code-generator/cmd/lister-gen"

	// required by hack/codegen/update-crd.sh
	_ "github.com/openshift/crd-schema-gen/cmd/crd-schema-gen"
)
