// Generated by running
//  go generate github.com/gonum/matrix
// DO NOT EDIT.

// Copyright ©2015 The gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Package cmat128 provides implementations of complex128 matrix structures and
// linear algebra operations on them.
//
// Overview
//
// This section provides a quick overview of the cmat128 package. The following
// sections provide more in depth commentary.
//
// cmat128 provides:
//  - Interfaces for a complex Matrix
//
// BLAS and LAPACK
//
// BLAS and LAPACK are the standard APIs for linear algebra routines. Many
// operations in cmat128 are implemented using calls to the wrapper functions
// in gonum/blas/cblas128 and gonum/lapack/clapack128. By default, cblas128 and
// clapack128 call the native Go implementations of the routines. Alternatively,
// it is possible to use C-based implementations of the APIs through the respective
// cgo packages and "Use" functions. The Go implementation of LAPACK makes calls
// through cblas128, so if a cgo BLAS implementation is registered, the clapack128
// calls will be partially executed in Go and partially executed in C.
//
// Type Switching
//
// The Matrix abstraction enables efficiency as well as interoperability. Go's
// type reflection capabilities are used to choose the most efficient routine
// given the specific concrete types. For example, in
//  c.Mul(a, b)
// if a and b both implement RawMatrixer, that is, they can be represented as a
// cblas128.General, cblas128.Gemm (general matrix multiplication) is called, while
// instead if b is a RawSymmetricer cblas128.Symm is used (general-symmetric
// multiplication), and if b is a *Vector cblas128.Gemv is used.
//
// There are many possible type combinations and special cases. No specific guarantees
// are made about the performance of any method, and in particular, note that an
// abstract matrix type may be copied into a concrete type of the corresponding
// value. If there are specific special cases that are needed, please submit a
// pull-request or file an issue.
//
// Invariants
//
// Matrix input arguments to functions are never directly modified. If an operation
// changes Matrix data, the mutated matrix will be the receiver of a function.
//
// For convenience, a matrix may be used as both a receiver and as an input, e.g.
//  a.Pow(a, 6)
//  v.SolveVec(a.T(), v)
// though in many cases this will cause an allocation (see Element Aliasing).
// An exception to this rule is Copy, which does not allow a.Copy(a.T()).
//
// Element Aliasing
//
// Most methods in cmat128 modify receiver data. It is forbidden for the modified
// data region of the receiver to overlap the used data area of the input
// arguments. The exception to this rule is when the method receiver is equal to one
// of the input arguments, as in the a.Pow(a, 6) call above, or its implicit transpose.
//
// This prohibition is to help avoid subtle mistakes when the method needs to read
// from and write to the same data region. There are ways to make mistakes using the
// cmat128 API, and cmat128 functions will detect and complain about those.
// There are many ways to make mistakes by excursion from the cmat128 API via
// interaction with raw matrix values.
//
// If you need to read the rest of this section to understand the behavior of
// your program, you are being clever. Don't be clever. If you must be clever,
// cblas128 and clapack128 may be used to call the behavior directly.
//
// cmat128 will use the following rules to detect overlap between the receiver and one
// of the inputs:
//  - the input implements one of the Raw methods, and
//  - the Raw type matches that of the receiver or
//    one is a RawMatrixer and the other is a RawVectorer, and
//  - the address ranges of the backing data slices overlap, and
//  - the strides differ or there is an overlap in the used data elements.
// If such an overlap is detected, the method will panic.
//
// The following cases will not panic:
//  - the data slices do not overlap,
//  - there is pointer identity between the receiver and input values after
//    the value has been untransposed if necessary.
//
// cmat128 will not attempt to detect element overlap if the input does not implement a
// Raw method, or if the Raw method differs from that of the receiver except when a
// conversion has occurred through a cmat128 API function. Method behavior is undefined
// if there is undetected overlap.
//
package cmat128
