// Code generated by protoc-gen-go.
// source: google.golang.org/appengine/internal/search/search.proto
// DO NOT EDIT!

/*
Package search is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/appengine/internal/search/search.proto

It has these top-level messages:
	Scope
	Entry
	AccessControlList
	FieldValue
	Field
	FieldTypes
	IndexShardSettings
	FacetValue
	Facet
	DocumentMetadata
	Document
	SearchServiceError
	RequestStatus
	IndexSpec
	IndexMetadata
	IndexDocumentParams
	IndexDocumentRequest
	IndexDocumentResponse
	DeleteDocumentParams
	DeleteDocumentRequest
	DeleteDocumentResponse
	ListDocumentsParams
	ListDocumentsRequest
	ListDocumentsResponse
	ListIndexesParams
	ListIndexesRequest
	ListIndexesResponse
	DeleteSchemaParams
	DeleteSchemaRequest
	DeleteSchemaResponse
	SortSpec
	ScorerSpec
	FieldSpec
	FacetRange
	FacetRequestParam
	FacetAutoDetectParam
	FacetRequest
	FacetRefinement
	SearchParams
	SearchRequest
	FacetResultValue
	FacetResult
	SearchResult
	SearchResponse
*/
package search

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type Scope_Type int32

const (
	Scope_USER_BY_CANONICAL_ID    Scope_Type = 1
	Scope_USER_BY_EMAIL           Scope_Type = 2
	Scope_GROUP_BY_CANONICAL_ID   Scope_Type = 3
	Scope_GROUP_BY_EMAIL          Scope_Type = 4
	Scope_GROUP_BY_DOMAIN         Scope_Type = 5
	Scope_ALL_USERS               Scope_Type = 6
	Scope_ALL_AUTHENTICATED_USERS Scope_Type = 7
)

var Scope_Type_name = map[int32]string{
	1: "USER_BY_CANONICAL_ID",
	2: "USER_BY_EMAIL",
	3: "GROUP_BY_CANONICAL_ID",
	4: "GROUP_BY_EMAIL",
	5: "GROUP_BY_DOMAIN",
	6: "ALL_USERS",
	7: "ALL_AUTHENTICATED_USERS",
}
var Scope_Type_value = map[string]int32{
	"USER_BY_CANONICAL_ID":    1,
	"USER_BY_EMAIL":           2,
	"GROUP_BY_CANONICAL_ID":   3,
	"GROUP_BY_EMAIL":          4,
	"GROUP_BY_DOMAIN":         5,
	"ALL_USERS":               6,
	"ALL_AUTHENTICATED_USERS": 7,
}

func (x Scope_Type) Enum() *Scope_Type {
	p := new(Scope_Type)
	*p = x
	return p
}
func (x Scope_Type) String() string {
	return proto.EnumName(Scope_Type_name, int32(x))
}
func (x *Scope_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Scope_Type_value, data, "Scope_Type")
	if err != nil {
		return err
	}
	*x = Scope_Type(value)
	return nil
}

type Entry_Permission int32

const (
	Entry_READ         Entry_Permission = 1
	Entry_WRITE        Entry_Permission = 2
	Entry_FULL_CONTROL Entry_Permission = 3
)

var Entry_Permission_name = map[int32]string{
	1: "READ",
	2: "WRITE",
	3: "FULL_CONTROL",
}
var Entry_Permission_value = map[string]int32{
	"READ":         1,
	"WRITE":        2,
	"FULL_CONTROL": 3,
}

func (x Entry_Permission) Enum() *Entry_Permission {
	p := new(Entry_Permission)
	*p = x
	return p
}
func (x Entry_Permission) String() string {
	return proto.EnumName(Entry_Permission_name, int32(x))
}
func (x *Entry_Permission) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Entry_Permission_value, data, "Entry_Permission")
	if err != nil {
		return err
	}
	*x = Entry_Permission(value)
	return nil
}

type FieldValue_ContentType int32

const (
	FieldValue_TEXT   FieldValue_ContentType = 0
	FieldValue_HTML   FieldValue_ContentType = 1
	FieldValue_ATOM   FieldValue_ContentType = 2
	FieldValue_DATE   FieldValue_ContentType = 3
	FieldValue_NUMBER FieldValue_ContentType = 4
	FieldValue_GEO    FieldValue_ContentType = 5
)

var FieldValue_ContentType_name = map[int32]string{
	0: "TEXT",
	1: "HTML",
	2: "ATOM",
	3: "DATE",
	4: "NUMBER",
	5: "GEO",
}
var FieldValue_ContentType_value = map[string]int32{
	"TEXT":   0,
	"HTML":   1,
	"ATOM":   2,
	"DATE":   3,
	"NUMBER": 4,
	"GEO":    5,
}

func (x FieldValue_ContentType) Enum() *FieldValue_ContentType {
	p := new(FieldValue_ContentType)
	*p = x
	return p
}
func (x FieldValue_ContentType) String() string {
	return proto.EnumName(FieldValue_ContentType_name, int32(x))
}
func (x *FieldValue_ContentType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FieldValue_ContentType_value, data, "FieldValue_ContentType")
	if err != nil {
		return err
	}
	*x = FieldValue_ContentType(value)
	return nil
}

type FacetValue_ContentType int32

const (
	FacetValue_ATOM   FacetValue_ContentType = 2
	FacetValue_NUMBER FacetValue_ContentType = 4
)

var FacetValue_ContentType_name = map[int32]string{
	2: "ATOM",
	4: "NUMBER",
}
var FacetValue_ContentType_value = map[string]int32{
	"ATOM":   2,
	"NUMBER": 4,
}

func (x FacetValue_ContentType) Enum() *FacetValue_ContentType {
	p := new(FacetValue_ContentType)
	*p = x
	return p
}
func (x FacetValue_ContentType) String() string {
	return proto.EnumName(FacetValue_ContentType_name, int32(x))
}
func (x *FacetValue_ContentType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FacetValue_ContentType_value, data, "FacetValue_ContentType")
	if err != nil {
		return err
	}
	*x = FacetValue_ContentType(value)
	return nil
}

type Document_Storage int32

const (
	Document_DISK Document_Storage = 0
)

var Document_Storage_name = map[int32]string{
	0: "DISK",
}
var Document_Storage_value = map[string]int32{
	"DISK": 0,
}

func (x Document_Storage) Enum() *Document_Storage {
	p := new(Document_Storage)
	*p = x
	return p
}
func (x Document_Storage) String() string {
	return proto.EnumName(Document_Storage_name, int32(x))
}
func (x *Document_Storage) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Document_Storage_value, data, "Document_Storage")
	if err != nil {
		return err
	}
	*x = Document_Storage(value)
	return nil
}

type SearchServiceError_ErrorCode int32

const (
	SearchServiceError_OK                     SearchServiceError_ErrorCode = 0
	SearchServiceError_INVALID_REQUEST        SearchServiceError_ErrorCode = 1
	SearchServiceError_TRANSIENT_ERROR        SearchServiceError_ErrorCode = 2
	SearchServiceError_INTERNAL_ERROR         SearchServiceError_ErrorCode = 3
	SearchServiceError_PERMISSION_DENIED      SearchServiceError_ErrorCode = 4
	SearchServiceError_TIMEOUT                SearchServiceError_ErrorCode = 5
	SearchServiceError_CONCURRENT_TRANSACTION SearchServiceError_ErrorCode = 6
)

var SearchServiceError_ErrorCode_name = map[int32]string{
	0: "OK",
	1: "INVALID_REQUEST",
	2: "TRANSIENT_ERROR",
	3: "INTERNAL_ERROR",
	4: "PERMISSION_DENIED",
	5: "TIMEOUT",
	6: "CONCURRENT_TRANSACTION",
}
var SearchServiceError_ErrorCode_value = map[string]int32{
	"OK":                     0,
	"INVALID_REQUEST":        1,
	"TRANSIENT_ERROR":        2,
	"INTERNAL_ERROR":         3,
	"PERMISSION_DENIED":      4,
	"TIMEOUT":                5,
	"CONCURRENT_TRANSACTION": 6,
}

func (x SearchServiceError_ErrorCode) Enum() *SearchServiceError_ErrorCode {
	p := new(SearchServiceError_ErrorCode)
	*p = x
	return p
}
func (x SearchServiceError_ErrorCode) String() string {
	return proto.EnumName(SearchServiceError_ErrorCode_name, int32(x))
}
func (x *SearchServiceError_ErrorCode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SearchServiceError_ErrorCode_value, data, "SearchServiceError_ErrorCode")
	if err != nil {
		return err
	}
	*x = SearchServiceError_ErrorCode(value)
	return nil
}

type IndexSpec_Consistency int32

const (
	IndexSpec_GLOBAL       IndexSpec_Consistency = 0
	IndexSpec_PER_DOCUMENT IndexSpec_Consistency = 1
)

var IndexSpec_Consistency_name = map[int32]string{
	0: "GLOBAL",
	1: "PER_DOCUMENT",
}
var IndexSpec_Consistency_value = map[string]int32{
	"GLOBAL":       0,
	"PER_DOCUMENT": 1,
}

func (x IndexSpec_Consistency) Enum() *IndexSpec_Consistency {
	p := new(IndexSpec_Consistency)
	*p = x
	return p
}
func (x IndexSpec_Consistency) String() string {
	return proto.EnumName(IndexSpec_Consistency_name, int32(x))
}
func (x *IndexSpec_Consistency) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexSpec_Consistency_value, data, "IndexSpec_Consistency")
	if err != nil {
		return err
	}
	*x = IndexSpec_Consistency(value)
	return nil
}

type IndexSpec_Source int32

const (
	IndexSpec_SEARCH        IndexSpec_Source = 0
	IndexSpec_DATASTORE     IndexSpec_Source = 1
	IndexSpec_CLOUD_STORAGE IndexSpec_Source = 2
)

var IndexSpec_Source_name = map[int32]string{
	0: "SEARCH",
	1: "DATASTORE",
	2: "CLOUD_STORAGE",
}
var IndexSpec_Source_value = map[string]int32{
	"SEARCH":        0,
	"DATASTORE":     1,
	"CLOUD_STORAGE": 2,
}

func (x IndexSpec_Source) Enum() *IndexSpec_Source {
	p := new(IndexSpec_Source)
	*p = x
	return p
}
func (x IndexSpec_Source) String() string {
	return proto.EnumName(IndexSpec_Source_name, int32(x))
}
func (x *IndexSpec_Source) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexSpec_Source_value, data, "IndexSpec_Source")
	if err != nil {
		return err
	}
	*x = IndexSpec_Source(value)
	return nil
}

type IndexSpec_Mode int32

const (
	IndexSpec_PRIORITY   IndexSpec_Mode = 0
	IndexSpec_BACKGROUND IndexSpec_Mode = 1
)

var IndexSpec_Mode_name = map[int32]string{
	0: "PRIORITY",
	1: "BACKGROUND",
}
var IndexSpec_Mode_value = map[string]int32{
	"PRIORITY":   0,
	"BACKGROUND": 1,
}

func (x IndexSpec_Mode) Enum() *IndexSpec_Mode {
	p := new(IndexSpec_Mode)
	*p = x
	return p
}
func (x IndexSpec_Mode) String() string {
	return proto.EnumName(IndexSpec_Mode_name, int32(x))
}
func (x *IndexSpec_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexSpec_Mode_value, data, "IndexSpec_Mode")
	if err != nil {
		return err
	}
	*x = IndexSpec_Mode(value)
	return nil
}

type IndexDocumentParams_Freshness int32

const (
	IndexDocumentParams_SYNCHRONOUSLY   IndexDocumentParams_Freshness = 0
	IndexDocumentParams_WHEN_CONVENIENT IndexDocumentParams_Freshness = 1
)

var IndexDocumentParams_Freshness_name = map[int32]string{
	0: "SYNCHRONOUSLY",
	1: "WHEN_CONVENIENT",
}
var IndexDocumentParams_Freshness_value = map[string]int32{
	"SYNCHRONOUSLY":   0,
	"WHEN_CONVENIENT": 1,
}

func (x IndexDocumentParams_Freshness) Enum() *IndexDocumentParams_Freshness {
	p := new(IndexDocumentParams_Freshness)
	*p = x
	return p
}
func (x IndexDocumentParams_Freshness) String() string {
	return proto.EnumName(IndexDocumentParams_Freshness_name, int32(x))
}
func (x *IndexDocumentParams_Freshness) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexDocumentParams_Freshness_value, data, "IndexDocumentParams_Freshness")
	if err != nil {
		return err
	}
	*x = IndexDocumentParams_Freshness(value)
	return nil
}

type ScorerSpec_Scorer int32

const (
	ScorerSpec_RESCORING_MATCH_SCORER ScorerSpec_Scorer = 0
	ScorerSpec_MATCH_SCORER           ScorerSpec_Scorer = 2
)

var ScorerSpec_Scorer_name = map[int32]string{
	0: "RESCORING_MATCH_SCORER",
	2: "MATCH_SCORER",
}
var ScorerSpec_Scorer_value = map[string]int32{
	"RESCORING_MATCH_SCORER": 0,
	"MATCH_SCORER":           2,
}

func (x ScorerSpec_Scorer) Enum() *ScorerSpec_Scorer {
	p := new(ScorerSpec_Scorer)
	*p = x
	return p
}
func (x ScorerSpec_Scorer) String() string {
	return proto.EnumName(ScorerSpec_Scorer_name, int32(x))
}
func (x *ScorerSpec_Scorer) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ScorerSpec_Scorer_value, data, "ScorerSpec_Scorer")
	if err != nil {
		return err
	}
	*x = ScorerSpec_Scorer(value)
	return nil
}

type SearchParams_CursorType int32

const (
	SearchParams_NONE       SearchParams_CursorType = 0
	SearchParams_SINGLE     SearchParams_CursorType = 1
	SearchParams_PER_RESULT SearchParams_CursorType = 2
)

var SearchParams_CursorType_name = map[int32]string{
	0: "NONE",
	1: "SINGLE",
	2: "PER_RESULT",
}
var SearchParams_CursorType_value = map[string]int32{
	"NONE":       0,
	"SINGLE":     1,
	"PER_RESULT": 2,
}

func (x SearchParams_CursorType) Enum() *SearchParams_CursorType {
	p := new(SearchParams_CursorType)
	*p = x
	return p
}
func (x SearchParams_CursorType) String() string {
	return proto.EnumName(SearchParams_CursorType_name, int32(x))
}
func (x *SearchParams_CursorType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SearchParams_CursorType_value, data, "SearchParams_CursorType")
	if err != nil {
		return err
	}
	*x = SearchParams_CursorType(value)
	return nil
}

type SearchParams_ParsingMode int32

const (
	SearchParams_STRICT  SearchParams_ParsingMode = 0
	SearchParams_RELAXED SearchParams_ParsingMode = 1
)

var SearchParams_ParsingMode_name = map[int32]string{
	0: "STRICT",
	1: "RELAXED",
}
var SearchParams_ParsingMode_value = map[string]int32{
	"STRICT":  0,
	"RELAXED": 1,
}

func (x SearchParams_ParsingMode) Enum() *SearchParams_ParsingMode {
	p := new(SearchParams_ParsingMode)
	*p = x
	return p
}
func (x SearchParams_ParsingMode) String() string {
	return proto.EnumName(SearchParams_ParsingMode_name, int32(x))
}
func (x *SearchParams_ParsingMode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SearchParams_ParsingMode_value, data, "SearchParams_ParsingMode")
	if err != nil {
		return err
	}
	*x = SearchParams_ParsingMode(value)
	return nil
}

type Scope struct {
	Type             *Scope_Type `protobuf:"varint,1,opt,name=type,enum=search.Scope_Type" json:"type,omitempty"`
	Value            *string     `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Scope) Reset()         { *m = Scope{} }
func (m *Scope) String() string { return proto.CompactTextString(m) }
func (*Scope) ProtoMessage()    {}

func (m *Scope) GetType() Scope_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Scope_USER_BY_CANONICAL_ID
}

func (m *Scope) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type Entry struct {
	Scope            *Scope            `protobuf:"bytes,1,opt,name=scope" json:"scope,omitempty"`
	Permission       *Entry_Permission `protobuf:"varint,2,opt,name=permission,enum=search.Entry_Permission" json:"permission,omitempty"`
	DisplayName      *string           `protobuf:"bytes,3,opt,name=display_name" json:"display_name,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Entry) Reset()         { *m = Entry{} }
func (m *Entry) String() string { return proto.CompactTextString(m) }
func (*Entry) ProtoMessage()    {}

func (m *Entry) GetScope() *Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *Entry) GetPermission() Entry_Permission {
	if m != nil && m.Permission != nil {
		return *m.Permission
	}
	return Entry_READ
}

func (m *Entry) GetDisplayName() string {
	if m != nil && m.DisplayName != nil {
		return *m.DisplayName
	}
	return ""
}

type AccessControlList struct {
	Owner            *string  `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Entries          []*Entry `protobuf:"bytes,2,rep,name=entries" json:"entries,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *AccessControlList) Reset()         { *m = AccessControlList{} }
func (m *AccessControlList) String() string { return proto.CompactTextString(m) }
func (*AccessControlList) ProtoMessage()    {}

func (m *AccessControlList) GetOwner() string {
	if m != nil && m.Owner != nil {
		return *m.Owner
	}
	return ""
}

func (m *AccessControlList) GetEntries() []*Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type FieldValue struct {
	Type             *FieldValue_ContentType `protobuf:"varint,1,opt,name=type,enum=search.FieldValue_ContentType,def=0" json:"type,omitempty"`
	Language         *string                 `protobuf:"bytes,2,opt,name=language,def=en" json:"language,omitempty"`
	StringValue      *string                 `protobuf:"bytes,3,opt,name=string_value" json:"string_value,omitempty"`
	Geo              *FieldValue_Geo         `protobuf:"group,4,opt,name=Geo" json:"geo,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *FieldValue) Reset()         { *m = FieldValue{} }
func (m *FieldValue) String() string { return proto.CompactTextString(m) }
func (*FieldValue) ProtoMessage()    {}

const Default_FieldValue_Type FieldValue_ContentType = FieldValue_TEXT
const Default_FieldValue_Language string = "en"

func (m *FieldValue) GetType() FieldValue_ContentType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Default_FieldValue_Type
}

func (m *FieldValue) GetLanguage() string {
	if m != nil && m.Language != nil {
		return *m.Language
	}
	return Default_FieldValue_Language
}

func (m *FieldValue) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

func (m *FieldValue) GetGeo() *FieldValue_Geo {
	if m != nil {
		return m.Geo
	}
	return nil
}

type FieldValue_Geo struct {
	Lat              *float64 `protobuf:"fixed64,5,req,name=lat" json:"lat,omitempty"`
	Lng              *float64 `protobuf:"fixed64,6,req,name=lng" json:"lng,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *FieldValue_Geo) Reset()         { *m = FieldValue_Geo{} }
func (m *FieldValue_Geo) String() string { return proto.CompactTextString(m) }
func (*FieldValue_Geo) ProtoMessage()    {}

func (m *FieldValue_Geo) GetLat() float64 {
	if m != nil && m.Lat != nil {
		return *m.Lat
	}
	return 0
}

func (m *FieldValue_Geo) GetLng() float64 {
	if m != nil && m.Lng != nil {
		return *m.Lng
	}
	return 0
}

type Field struct {
	Name             *string     `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *FieldValue `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Field) Reset()         { *m = Field{} }
func (m *Field) String() string { return proto.CompactTextString(m) }
func (*Field) ProtoMessage()    {}

func (m *Field) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Field) GetValue() *FieldValue {
	if m != nil {
		return m.Value
	}
	return nil
}

type FieldTypes struct {
	Name             *string                  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type             []FieldValue_ContentType `protobuf:"varint,2,rep,name=type,enum=search.FieldValue_ContentType" json:"type,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *FieldTypes) Reset()         { *m = FieldTypes{} }
func (m *FieldTypes) String() string { return proto.CompactTextString(m) }
func (*FieldTypes) ProtoMessage()    {}

func (m *FieldTypes) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FieldTypes) GetType() []FieldValue_ContentType {
	if m != nil {
		return m.Type
	}
	return nil
}

type IndexShardSettings struct {
	PrevNumShards            []int32 `protobuf:"varint,1,rep,name=prev_num_shards" json:"prev_num_shards,omitempty"`
	NumShards                *int32  `protobuf:"varint,2,req,name=num_shards,def=1" json:"num_shards,omitempty"`
	PrevNumShardsSearchFalse []int32 `protobuf:"varint,3,rep,name=prev_num_shards_search_false" json:"prev_num_shards_search_false,omitempty"`
	LocalReplica             *string `protobuf:"bytes,4,opt,name=local_replica,def=" json:"local_replica,omitempty"`
	XXX_unrecognized         []byte  `json:"-"`
}

func (m *IndexShardSettings) Reset()         { *m = IndexShardSettings{} }
func (m *IndexShardSettings) String() string { return proto.CompactTextString(m) }
func (*IndexShardSettings) ProtoMessage()    {}

const Default_IndexShardSettings_NumShards int32 = 1

func (m *IndexShardSettings) GetPrevNumShards() []int32 {
	if m != nil {
		return m.PrevNumShards
	}
	return nil
}

func (m *IndexShardSettings) GetNumShards() int32 {
	if m != nil && m.NumShards != nil {
		return *m.NumShards
	}
	return Default_IndexShardSettings_NumShards
}

func (m *IndexShardSettings) GetPrevNumShardsSearchFalse() []int32 {
	if m != nil {
		return m.PrevNumShardsSearchFalse
	}
	return nil
}

func (m *IndexShardSettings) GetLocalReplica() string {
	if m != nil && m.LocalReplica != nil {
		return *m.LocalReplica
	}
	return ""
}

type FacetValue struct {
	Type             *FacetValue_ContentType `protobuf:"varint,1,opt,name=type,enum=search.FacetValue_ContentType,def=2" json:"type,omitempty"`
	StringValue      *string                 `protobuf:"bytes,3,opt,name=string_value" json:"string_value,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *FacetValue) Reset()         { *m = FacetValue{} }
func (m *FacetValue) String() string { return proto.CompactTextString(m) }
func (*FacetValue) ProtoMessage()    {}

const Default_FacetValue_Type FacetValue_ContentType = FacetValue_ATOM

func (m *FacetValue) GetType() FacetValue_ContentType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Default_FacetValue_Type
}

func (m *FacetValue) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

type Facet struct {
	Name             *string     `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *FacetValue `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Facet) Reset()         { *m = Facet{} }
func (m *Facet) String() string { return proto.CompactTextString(m) }
func (*Facet) ProtoMessage()    {}

func (m *Facet) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Facet) GetValue() *FacetValue {
	if m != nil {
		return m.Value
	}
	return nil
}

type DocumentMetadata struct {
	Version            *int64 `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	CommittedStVersion *int64 `protobuf:"varint,2,opt,name=committed_st_version" json:"committed_st_version,omitempty"`
	XXX_unrecognized   []byte `json:"-"`
}

func (m *DocumentMetadata) Reset()         { *m = DocumentMetadata{} }
func (m *DocumentMetadata) String() string { return proto.CompactTextString(m) }
func (*DocumentMetadata) ProtoMessage()    {}

func (m *DocumentMetadata) GetVersion() int64 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

func (m *DocumentMetadata) GetCommittedStVersion() int64 {
	if m != nil && m.CommittedStVersion != nil {
		return *m.CommittedStVersion
	}
	return 0
}

type Document struct {
	Id               *string           `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Language         *string           `protobuf:"bytes,2,opt,name=language,def=en" json:"language,omitempty"`
	Field            []*Field          `protobuf:"bytes,3,rep,name=field" json:"field,omitempty"`
	OrderId          *int32            `protobuf:"varint,4,opt,name=order_id" json:"order_id,omitempty"`
	Storage          *Document_Storage `protobuf:"varint,5,opt,name=storage,enum=search.Document_Storage,def=0" json:"storage,omitempty"`
	Facet            []*Facet          `protobuf:"bytes,8,rep,name=facet" json:"facet,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Document) Reset()         { *m = Document{} }
func (m *Document) String() string { return proto.CompactTextString(m) }
func (*Document) ProtoMessage()    {}

const Default_Document_Language string = "en"
const Default_Document_Storage Document_Storage = Document_DISK

func (m *Document) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *Document) GetLanguage() string {
	if m != nil && m.Language != nil {
		return *m.Language
	}
	return Default_Document_Language
}

func (m *Document) GetField() []*Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *Document) GetOrderId() int32 {
	if m != nil && m.OrderId != nil {
		return *m.OrderId
	}
	return 0
}

func (m *Document) GetStorage() Document_Storage {
	if m != nil && m.Storage != nil {
		return *m.Storage
	}
	return Default_Document_Storage
}

func (m *Document) GetFacet() []*Facet {
	if m != nil {
		return m.Facet
	}
	return nil
}

type SearchServiceError struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *SearchServiceError) Reset()         { *m = SearchServiceError{} }
func (m *SearchServiceError) String() string { return proto.CompactTextString(m) }
func (*SearchServiceError) ProtoMessage()    {}

type RequestStatus struct {
	Code             *SearchServiceError_ErrorCode `protobuf:"varint,1,req,name=code,enum=search.SearchServiceError_ErrorCode" json:"code,omitempty"`
	ErrorDetail      *string                       `protobuf:"bytes,2,opt,name=error_detail" json:"error_detail,omitempty"`
	CanonicalCode    *int32                        `protobuf:"varint,3,opt,name=canonical_code" json:"canonical_code,omitempty"`
	XXX_unrecognized []byte                        `json:"-"`
}

func (m *RequestStatus) Reset()         { *m = RequestStatus{} }
func (m *RequestStatus) String() string { return proto.CompactTextString(m) }
func (*RequestStatus) ProtoMessage()    {}

func (m *RequestStatus) GetCode() SearchServiceError_ErrorCode {
	if m != nil && m.Code != nil {
		return *m.Code
	}
	return SearchServiceError_OK
}

func (m *RequestStatus) GetErrorDetail() string {
	if m != nil && m.ErrorDetail != nil {
		return *m.ErrorDetail
	}
	return ""
}

func (m *RequestStatus) GetCanonicalCode() int32 {
	if m != nil && m.CanonicalCode != nil {
		return *m.CanonicalCode
	}
	return 0
}

type IndexSpec struct {
	Name             *string                `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Consistency      *IndexSpec_Consistency `protobuf:"varint,2,opt,name=consistency,enum=search.IndexSpec_Consistency,def=1" json:"consistency,omitempty"`
	Namespace        *string                `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	Version          *int32                 `protobuf:"varint,4,opt,name=version" json:"version,omitempty"`
	Source           *IndexSpec_Source      `protobuf:"varint,5,opt,name=source,enum=search.IndexSpec_Source,def=0" json:"source,omitempty"`
	Mode             *IndexSpec_Mode        `protobuf:"varint,6,opt,name=mode,enum=search.IndexSpec_Mode,def=0" json:"mode,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *IndexSpec) Reset()         { *m = IndexSpec{} }
func (m *IndexSpec) String() string { return proto.CompactTextString(m) }
func (*IndexSpec) ProtoMessage()    {}

const Default_IndexSpec_Consistency IndexSpec_Consistency = IndexSpec_PER_DOCUMENT
const Default_IndexSpec_Source IndexSpec_Source = IndexSpec_SEARCH
const Default_IndexSpec_Mode IndexSpec_Mode = IndexSpec_PRIORITY

func (m *IndexSpec) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *IndexSpec) GetConsistency() IndexSpec_Consistency {
	if m != nil && m.Consistency != nil {
		return *m.Consistency
	}
	return Default_IndexSpec_Consistency
}

func (m *IndexSpec) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *IndexSpec) GetVersion() int32 {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return 0
}

func (m *IndexSpec) GetSource() IndexSpec_Source {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return Default_IndexSpec_Source
}

func (m *IndexSpec) GetMode() IndexSpec_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return Default_IndexSpec_Mode
}

type IndexMetadata struct {
	IndexSpec        *IndexSpec             `protobuf:"bytes,1,req,name=index_spec" json:"index_spec,omitempty"`
	Field            []*FieldTypes          `protobuf:"bytes,2,rep,name=field" json:"field,omitempty"`
	Storage          *IndexMetadata_Storage `protobuf:"bytes,3,opt,name=storage" json:"storage,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *IndexMetadata) Reset()         { *m = IndexMetadata{} }
func (m *IndexMetadata) String() string { return proto.CompactTextString(m) }
func (*IndexMetadata) ProtoMessage()    {}

func (m *IndexMetadata) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

func (m *IndexMetadata) GetField() []*FieldTypes {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *IndexMetadata) GetStorage() *IndexMetadata_Storage {
	if m != nil {
		return m.Storage
	}
	return nil
}

type IndexMetadata_Storage struct {
	AmountUsed       *int64 `protobuf:"varint,1,opt,name=amount_used" json:"amount_used,omitempty"`
	Limit            *int64 `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *IndexMetadata_Storage) Reset()         { *m = IndexMetadata_Storage{} }
func (m *IndexMetadata_Storage) String() string { return proto.CompactTextString(m) }
func (*IndexMetadata_Storage) ProtoMessage()    {}

func (m *IndexMetadata_Storage) GetAmountUsed() int64 {
	if m != nil && m.AmountUsed != nil {
		return *m.AmountUsed
	}
	return 0
}

func (m *IndexMetadata_Storage) GetLimit() int64 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return 0
}

type IndexDocumentParams struct {
	Document         []*Document                    `protobuf:"bytes,1,rep,name=document" json:"document,omitempty"`
	Freshness        *IndexDocumentParams_Freshness `protobuf:"varint,2,opt,name=freshness,enum=search.IndexDocumentParams_Freshness,def=0" json:"freshness,omitempty"`
	IndexSpec        *IndexSpec                     `protobuf:"bytes,3,req,name=index_spec" json:"index_spec,omitempty"`
	XXX_unrecognized []byte                         `json:"-"`
}

func (m *IndexDocumentParams) Reset()         { *m = IndexDocumentParams{} }
func (m *IndexDocumentParams) String() string { return proto.CompactTextString(m) }
func (*IndexDocumentParams) ProtoMessage()    {}

const Default_IndexDocumentParams_Freshness IndexDocumentParams_Freshness = IndexDocumentParams_SYNCHRONOUSLY

func (m *IndexDocumentParams) GetDocument() []*Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *IndexDocumentParams) GetFreshness() IndexDocumentParams_Freshness {
	if m != nil && m.Freshness != nil {
		return *m.Freshness
	}
	return Default_IndexDocumentParams_Freshness
}

func (m *IndexDocumentParams) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

type IndexDocumentRequest struct {
	Params           *IndexDocumentParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte               `protobuf:"bytes,3,opt,name=app_id" json:"app_id,omitempty"`
	XXX_unrecognized []byte               `json:"-"`
}

func (m *IndexDocumentRequest) Reset()         { *m = IndexDocumentRequest{} }
func (m *IndexDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*IndexDocumentRequest) ProtoMessage()    {}

func (m *IndexDocumentRequest) GetParams() *IndexDocumentParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *IndexDocumentRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type IndexDocumentResponse struct {
	Status           []*RequestStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
	DocId            []string         `protobuf:"bytes,2,rep,name=doc_id" json:"doc_id,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *IndexDocumentResponse) Reset()         { *m = IndexDocumentResponse{} }
func (m *IndexDocumentResponse) String() string { return proto.CompactTextString(m) }
func (*IndexDocumentResponse) ProtoMessage()    {}

func (m *IndexDocumentResponse) GetStatus() []*RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *IndexDocumentResponse) GetDocId() []string {
	if m != nil {
		return m.DocId
	}
	return nil
}

type DeleteDocumentParams struct {
	DocId            []string   `protobuf:"bytes,1,rep,name=doc_id" json:"doc_id,omitempty"`
	IndexSpec        *IndexSpec `protobuf:"bytes,2,req,name=index_spec" json:"index_spec,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *DeleteDocumentParams) Reset()         { *m = DeleteDocumentParams{} }
func (m *DeleteDocumentParams) String() string { return proto.CompactTextString(m) }
func (*DeleteDocumentParams) ProtoMessage()    {}

func (m *DeleteDocumentParams) GetDocId() []string {
	if m != nil {
		return m.DocId
	}
	return nil
}

func (m *DeleteDocumentParams) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

type DeleteDocumentRequest struct {
	Params           *DeleteDocumentParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte                `protobuf:"bytes,3,opt,name=app_id" json:"app_id,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *DeleteDocumentRequest) Reset()         { *m = DeleteDocumentRequest{} }
func (m *DeleteDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDocumentRequest) ProtoMessage()    {}

func (m *DeleteDocumentRequest) GetParams() *DeleteDocumentParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *DeleteDocumentRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type DeleteDocumentResponse struct {
	Status           []*RequestStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *DeleteDocumentResponse) Reset()         { *m = DeleteDocumentResponse{} }
func (m *DeleteDocumentResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteDocumentResponse) ProtoMessage()    {}

func (m *DeleteDocumentResponse) GetStatus() []*RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type ListDocumentsParams struct {
	IndexSpec        *IndexSpec `protobuf:"bytes,1,req,name=index_spec" json:"index_spec,omitempty"`
	StartDocId       *string    `protobuf:"bytes,2,opt,name=start_doc_id" json:"start_doc_id,omitempty"`
	IncludeStartDoc  *bool      `protobuf:"varint,3,opt,name=include_start_doc,def=1" json:"include_start_doc,omitempty"`
	Limit            *int32     `protobuf:"varint,4,opt,name=limit,def=100" json:"limit,omitempty"`
	KeysOnly         *bool      `protobuf:"varint,5,opt,name=keys_only" json:"keys_only,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ListDocumentsParams) Reset()         { *m = ListDocumentsParams{} }
func (m *ListDocumentsParams) String() string { return proto.CompactTextString(m) }
func (*ListDocumentsParams) ProtoMessage()    {}

const Default_ListDocumentsParams_IncludeStartDoc bool = true
const Default_ListDocumentsParams_Limit int32 = 100

func (m *ListDocumentsParams) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

func (m *ListDocumentsParams) GetStartDocId() string {
	if m != nil && m.StartDocId != nil {
		return *m.StartDocId
	}
	return ""
}

func (m *ListDocumentsParams) GetIncludeStartDoc() bool {
	if m != nil && m.IncludeStartDoc != nil {
		return *m.IncludeStartDoc
	}
	return Default_ListDocumentsParams_IncludeStartDoc
}

func (m *ListDocumentsParams) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return Default_ListDocumentsParams_Limit
}

func (m *ListDocumentsParams) GetKeysOnly() bool {
	if m != nil && m.KeysOnly != nil {
		return *m.KeysOnly
	}
	return false
}

type ListDocumentsRequest struct {
	Params           *ListDocumentsParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte               `protobuf:"bytes,2,opt,name=app_id" json:"app_id,omitempty"`
	XXX_unrecognized []byte               `json:"-"`
}

func (m *ListDocumentsRequest) Reset()         { *m = ListDocumentsRequest{} }
func (m *ListDocumentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDocumentsRequest) ProtoMessage()    {}

func (m *ListDocumentsRequest) GetParams() *ListDocumentsParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *ListDocumentsRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type ListDocumentsResponse struct {
	Status           *RequestStatus `protobuf:"bytes,1,req,name=status" json:"status,omitempty"`
	Document         []*Document    `protobuf:"bytes,2,rep,name=document" json:"document,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *ListDocumentsResponse) Reset()         { *m = ListDocumentsResponse{} }
func (m *ListDocumentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDocumentsResponse) ProtoMessage()    {}

func (m *ListDocumentsResponse) GetStatus() *RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ListDocumentsResponse) GetDocument() []*Document {
	if m != nil {
		return m.Document
	}
	return nil
}

type ListIndexesParams struct {
	FetchSchema       *bool             `protobuf:"varint,1,opt,name=fetch_schema" json:"fetch_schema,omitempty"`
	Limit             *int32            `protobuf:"varint,2,opt,name=limit,def=20" json:"limit,omitempty"`
	Namespace         *string           `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	StartIndexName    *string           `protobuf:"bytes,4,opt,name=start_index_name" json:"start_index_name,omitempty"`
	IncludeStartIndex *bool             `protobuf:"varint,5,opt,name=include_start_index,def=1" json:"include_start_index,omitempty"`
	IndexNamePrefix   *string           `protobuf:"bytes,6,opt,name=index_name_prefix" json:"index_name_prefix,omitempty"`
	Offset            *int32            `protobuf:"varint,7,opt,name=offset" json:"offset,omitempty"`
	Source            *IndexSpec_Source `protobuf:"varint,8,opt,name=source,enum=search.IndexSpec_Source,def=0" json:"source,omitempty"`
	XXX_unrecognized  []byte            `json:"-"`
}

func (m *ListIndexesParams) Reset()         { *m = ListIndexesParams{} }
func (m *ListIndexesParams) String() string { return proto.CompactTextString(m) }
func (*ListIndexesParams) ProtoMessage()    {}

const Default_ListIndexesParams_Limit int32 = 20
const Default_ListIndexesParams_IncludeStartIndex bool = true
const Default_ListIndexesParams_Source IndexSpec_Source = IndexSpec_SEARCH

func (m *ListIndexesParams) GetFetchSchema() bool {
	if m != nil && m.FetchSchema != nil {
		return *m.FetchSchema
	}
	return false
}

func (m *ListIndexesParams) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return Default_ListIndexesParams_Limit
}

func (m *ListIndexesParams) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ListIndexesParams) GetStartIndexName() string {
	if m != nil && m.StartIndexName != nil {
		return *m.StartIndexName
	}
	return ""
}

func (m *ListIndexesParams) GetIncludeStartIndex() bool {
	if m != nil && m.IncludeStartIndex != nil {
		return *m.IncludeStartIndex
	}
	return Default_ListIndexesParams_IncludeStartIndex
}

func (m *ListIndexesParams) GetIndexNamePrefix() string {
	if m != nil && m.IndexNamePrefix != nil {
		return *m.IndexNamePrefix
	}
	return ""
}

func (m *ListIndexesParams) GetOffset() int32 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return 0
}

func (m *ListIndexesParams) GetSource() IndexSpec_Source {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return Default_ListIndexesParams_Source
}

type ListIndexesRequest struct {
	Params           *ListIndexesParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte             `protobuf:"bytes,3,opt,name=app_id" json:"app_id,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *ListIndexesRequest) Reset()         { *m = ListIndexesRequest{} }
func (m *ListIndexesRequest) String() string { return proto.CompactTextString(m) }
func (*ListIndexesRequest) ProtoMessage()    {}

func (m *ListIndexesRequest) GetParams() *ListIndexesParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *ListIndexesRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type ListIndexesResponse struct {
	Status           *RequestStatus   `protobuf:"bytes,1,req,name=status" json:"status,omitempty"`
	IndexMetadata    []*IndexMetadata `protobuf:"bytes,2,rep,name=index_metadata" json:"index_metadata,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ListIndexesResponse) Reset()         { *m = ListIndexesResponse{} }
func (m *ListIndexesResponse) String() string { return proto.CompactTextString(m) }
func (*ListIndexesResponse) ProtoMessage()    {}

func (m *ListIndexesResponse) GetStatus() *RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ListIndexesResponse) GetIndexMetadata() []*IndexMetadata {
	if m != nil {
		return m.IndexMetadata
	}
	return nil
}

type DeleteSchemaParams struct {
	Source           *IndexSpec_Source `protobuf:"varint,1,opt,name=source,enum=search.IndexSpec_Source,def=0" json:"source,omitempty"`
	IndexSpec        []*IndexSpec      `protobuf:"bytes,2,rep,name=index_spec" json:"index_spec,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *DeleteSchemaParams) Reset()         { *m = DeleteSchemaParams{} }
func (m *DeleteSchemaParams) String() string { return proto.CompactTextString(m) }
func (*DeleteSchemaParams) ProtoMessage()    {}

const Default_DeleteSchemaParams_Source IndexSpec_Source = IndexSpec_SEARCH

func (m *DeleteSchemaParams) GetSource() IndexSpec_Source {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return Default_DeleteSchemaParams_Source
}

func (m *DeleteSchemaParams) GetIndexSpec() []*IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

type DeleteSchemaRequest struct {
	Params           *DeleteSchemaParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte              `protobuf:"bytes,3,opt,name=app_id" json:"app_id,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *DeleteSchemaRequest) Reset()         { *m = DeleteSchemaRequest{} }
func (m *DeleteSchemaRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSchemaRequest) ProtoMessage()    {}

func (m *DeleteSchemaRequest) GetParams() *DeleteSchemaParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *DeleteSchemaRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type DeleteSchemaResponse struct {
	Status           []*RequestStatus `protobuf:"bytes,1,rep,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *DeleteSchemaResponse) Reset()         { *m = DeleteSchemaResponse{} }
func (m *DeleteSchemaResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteSchemaResponse) ProtoMessage()    {}

func (m *DeleteSchemaResponse) GetStatus() []*RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type SortSpec struct {
	SortExpression      *string  `protobuf:"bytes,1,req,name=sort_expression" json:"sort_expression,omitempty"`
	SortDescending      *bool    `protobuf:"varint,2,opt,name=sort_descending,def=1" json:"sort_descending,omitempty"`
	DefaultValueText    *string  `protobuf:"bytes,4,opt,name=default_value_text" json:"default_value_text,omitempty"`
	DefaultValueNumeric *float64 `protobuf:"fixed64,5,opt,name=default_value_numeric" json:"default_value_numeric,omitempty"`
	XXX_unrecognized    []byte   `json:"-"`
}

func (m *SortSpec) Reset()         { *m = SortSpec{} }
func (m *SortSpec) String() string { return proto.CompactTextString(m) }
func (*SortSpec) ProtoMessage()    {}

const Default_SortSpec_SortDescending bool = true

func (m *SortSpec) GetSortExpression() string {
	if m != nil && m.SortExpression != nil {
		return *m.SortExpression
	}
	return ""
}

func (m *SortSpec) GetSortDescending() bool {
	if m != nil && m.SortDescending != nil {
		return *m.SortDescending
	}
	return Default_SortSpec_SortDescending
}

func (m *SortSpec) GetDefaultValueText() string {
	if m != nil && m.DefaultValueText != nil {
		return *m.DefaultValueText
	}
	return ""
}

func (m *SortSpec) GetDefaultValueNumeric() float64 {
	if m != nil && m.DefaultValueNumeric != nil {
		return *m.DefaultValueNumeric
	}
	return 0
}

type ScorerSpec struct {
	Scorer                *ScorerSpec_Scorer `protobuf:"varint,1,opt,name=scorer,enum=search.ScorerSpec_Scorer,def=2" json:"scorer,omitempty"`
	Limit                 *int32             `protobuf:"varint,2,opt,name=limit,def=1000" json:"limit,omitempty"`
	MatchScorerParameters *string            `protobuf:"bytes,9,opt,name=match_scorer_parameters" json:"match_scorer_parameters,omitempty"`
	XXX_unrecognized      []byte             `json:"-"`
}

func (m *ScorerSpec) Reset()         { *m = ScorerSpec{} }
func (m *ScorerSpec) String() string { return proto.CompactTextString(m) }
func (*ScorerSpec) ProtoMessage()    {}

const Default_ScorerSpec_Scorer ScorerSpec_Scorer = ScorerSpec_MATCH_SCORER
const Default_ScorerSpec_Limit int32 = 1000

func (m *ScorerSpec) GetScorer() ScorerSpec_Scorer {
	if m != nil && m.Scorer != nil {
		return *m.Scorer
	}
	return Default_ScorerSpec_Scorer
}

func (m *ScorerSpec) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return Default_ScorerSpec_Limit
}

func (m *ScorerSpec) GetMatchScorerParameters() string {
	if m != nil && m.MatchScorerParameters != nil {
		return *m.MatchScorerParameters
	}
	return ""
}

type FieldSpec struct {
	Name             []string                `protobuf:"bytes,1,rep,name=name" json:"name,omitempty"`
	Expression       []*FieldSpec_Expression `protobuf:"group,2,rep,name=Expression" json:"expression,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *FieldSpec) Reset()         { *m = FieldSpec{} }
func (m *FieldSpec) String() string { return proto.CompactTextString(m) }
func (*FieldSpec) ProtoMessage()    {}

func (m *FieldSpec) GetName() []string {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FieldSpec) GetExpression() []*FieldSpec_Expression {
	if m != nil {
		return m.Expression
	}
	return nil
}

type FieldSpec_Expression struct {
	Name             *string `protobuf:"bytes,3,req,name=name" json:"name,omitempty"`
	Expression       *string `protobuf:"bytes,4,req,name=expression" json:"expression,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FieldSpec_Expression) Reset()         { *m = FieldSpec_Expression{} }
func (m *FieldSpec_Expression) String() string { return proto.CompactTextString(m) }
func (*FieldSpec_Expression) ProtoMessage()    {}

func (m *FieldSpec_Expression) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FieldSpec_Expression) GetExpression() string {
	if m != nil && m.Expression != nil {
		return *m.Expression
	}
	return ""
}

type FacetRange struct {
	Name             *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Start            *string `protobuf:"bytes,2,opt,name=start" json:"start,omitempty"`
	End              *string `protobuf:"bytes,3,opt,name=end" json:"end,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FacetRange) Reset()         { *m = FacetRange{} }
func (m *FacetRange) String() string { return proto.CompactTextString(m) }
func (*FacetRange) ProtoMessage()    {}

func (m *FacetRange) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetRange) GetStart() string {
	if m != nil && m.Start != nil {
		return *m.Start
	}
	return ""
}

func (m *FacetRange) GetEnd() string {
	if m != nil && m.End != nil {
		return *m.End
	}
	return ""
}

type FacetRequestParam struct {
	ValueLimit       *int32        `protobuf:"varint,1,opt,name=value_limit" json:"value_limit,omitempty"`
	Range            []*FacetRange `protobuf:"bytes,2,rep,name=range" json:"range,omitempty"`
	ValueConstraint  []string      `protobuf:"bytes,3,rep,name=value_constraint" json:"value_constraint,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *FacetRequestParam) Reset()         { *m = FacetRequestParam{} }
func (m *FacetRequestParam) String() string { return proto.CompactTextString(m) }
func (*FacetRequestParam) ProtoMessage()    {}

func (m *FacetRequestParam) GetValueLimit() int32 {
	if m != nil && m.ValueLimit != nil {
		return *m.ValueLimit
	}
	return 0
}

func (m *FacetRequestParam) GetRange() []*FacetRange {
	if m != nil {
		return m.Range
	}
	return nil
}

func (m *FacetRequestParam) GetValueConstraint() []string {
	if m != nil {
		return m.ValueConstraint
	}
	return nil
}

type FacetAutoDetectParam struct {
	ValueLimit       *int32 `protobuf:"varint,1,opt,name=value_limit,def=10" json:"value_limit,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *FacetAutoDetectParam) Reset()         { *m = FacetAutoDetectParam{} }
func (m *FacetAutoDetectParam) String() string { return proto.CompactTextString(m) }
func (*FacetAutoDetectParam) ProtoMessage()    {}

const Default_FacetAutoDetectParam_ValueLimit int32 = 10

func (m *FacetAutoDetectParam) GetValueLimit() int32 {
	if m != nil && m.ValueLimit != nil {
		return *m.ValueLimit
	}
	return Default_FacetAutoDetectParam_ValueLimit
}

type FacetRequest struct {
	Name             *string            `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Params           *FacetRequestParam `protobuf:"bytes,2,opt,name=params" json:"params,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *FacetRequest) Reset()         { *m = FacetRequest{} }
func (m *FacetRequest) String() string { return proto.CompactTextString(m) }
func (*FacetRequest) ProtoMessage()    {}

func (m *FacetRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetRequest) GetParams() *FacetRequestParam {
	if m != nil {
		return m.Params
	}
	return nil
}

type FacetRefinement struct {
	Name             *string                `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *string                `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	Range            *FacetRefinement_Range `protobuf:"bytes,3,opt,name=range" json:"range,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *FacetRefinement) Reset()         { *m = FacetRefinement{} }
func (m *FacetRefinement) String() string { return proto.CompactTextString(m) }
func (*FacetRefinement) ProtoMessage()    {}

func (m *FacetRefinement) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetRefinement) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *FacetRefinement) GetRange() *FacetRefinement_Range {
	if m != nil {
		return m.Range
	}
	return nil
}

type FacetRefinement_Range struct {
	Start            *string `protobuf:"bytes,1,opt,name=start" json:"start,omitempty"`
	End              *string `protobuf:"bytes,2,opt,name=end" json:"end,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FacetRefinement_Range) Reset()         { *m = FacetRefinement_Range{} }
func (m *FacetRefinement_Range) String() string { return proto.CompactTextString(m) }
func (*FacetRefinement_Range) ProtoMessage()    {}

func (m *FacetRefinement_Range) GetStart() string {
	if m != nil && m.Start != nil {
		return *m.Start
	}
	return ""
}

func (m *FacetRefinement_Range) GetEnd() string {
	if m != nil && m.End != nil {
		return *m.End
	}
	return ""
}

type SearchParams struct {
	IndexSpec              *IndexSpec                `protobuf:"bytes,1,req,name=index_spec" json:"index_spec,omitempty"`
	Query                  *string                   `protobuf:"bytes,2,req,name=query" json:"query,omitempty"`
	Cursor                 *string                   `protobuf:"bytes,4,opt,name=cursor" json:"cursor,omitempty"`
	Offset                 *int32                    `protobuf:"varint,11,opt,name=offset" json:"offset,omitempty"`
	CursorType             *SearchParams_CursorType  `protobuf:"varint,5,opt,name=cursor_type,enum=search.SearchParams_CursorType,def=0" json:"cursor_type,omitempty"`
	Limit                  *int32                    `protobuf:"varint,6,opt,name=limit,def=20" json:"limit,omitempty"`
	MatchedCountAccuracy   *int32                    `protobuf:"varint,7,opt,name=matched_count_accuracy" json:"matched_count_accuracy,omitempty"`
	SortSpec               []*SortSpec               `protobuf:"bytes,8,rep,name=sort_spec" json:"sort_spec,omitempty"`
	ScorerSpec             *ScorerSpec               `protobuf:"bytes,9,opt,name=scorer_spec" json:"scorer_spec,omitempty"`
	FieldSpec              *FieldSpec                `protobuf:"bytes,10,opt,name=field_spec" json:"field_spec,omitempty"`
	KeysOnly               *bool                     `protobuf:"varint,12,opt,name=keys_only" json:"keys_only,omitempty"`
	ParsingMode            *SearchParams_ParsingMode `protobuf:"varint,13,opt,name=parsing_mode,enum=search.SearchParams_ParsingMode,def=0" json:"parsing_mode,omitempty"`
	AutoDiscoverFacetCount *int32                    `protobuf:"varint,15,opt,name=auto_discover_facet_count,def=0" json:"auto_discover_facet_count,omitempty"`
	IncludeFacet           []*FacetRequest           `protobuf:"bytes,16,rep,name=include_facet" json:"include_facet,omitempty"`
	FacetRefinement        []*FacetRefinement        `protobuf:"bytes,17,rep,name=facet_refinement" json:"facet_refinement,omitempty"`
	FacetAutoDetectParam   *FacetAutoDetectParam     `protobuf:"bytes,18,opt,name=facet_auto_detect_param" json:"facet_auto_detect_param,omitempty"`
	FacetDepth             *int32                    `protobuf:"varint,19,opt,name=facet_depth,def=1000" json:"facet_depth,omitempty"`
	XXX_unrecognized       []byte                    `json:"-"`
}

func (m *SearchParams) Reset()         { *m = SearchParams{} }
func (m *SearchParams) String() string { return proto.CompactTextString(m) }
func (*SearchParams) ProtoMessage()    {}

const Default_SearchParams_CursorType SearchParams_CursorType = SearchParams_NONE
const Default_SearchParams_Limit int32 = 20
const Default_SearchParams_ParsingMode SearchParams_ParsingMode = SearchParams_STRICT
const Default_SearchParams_AutoDiscoverFacetCount int32 = 0
const Default_SearchParams_FacetDepth int32 = 1000

func (m *SearchParams) GetIndexSpec() *IndexSpec {
	if m != nil {
		return m.IndexSpec
	}
	return nil
}

func (m *SearchParams) GetQuery() string {
	if m != nil && m.Query != nil {
		return *m.Query
	}
	return ""
}

func (m *SearchParams) GetCursor() string {
	if m != nil && m.Cursor != nil {
		return *m.Cursor
	}
	return ""
}

func (m *SearchParams) GetOffset() int32 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return 0
}

func (m *SearchParams) GetCursorType() SearchParams_CursorType {
	if m != nil && m.CursorType != nil {
		return *m.CursorType
	}
	return Default_SearchParams_CursorType
}

func (m *SearchParams) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return Default_SearchParams_Limit
}

func (m *SearchParams) GetMatchedCountAccuracy() int32 {
	if m != nil && m.MatchedCountAccuracy != nil {
		return *m.MatchedCountAccuracy
	}
	return 0
}

func (m *SearchParams) GetSortSpec() []*SortSpec {
	if m != nil {
		return m.SortSpec
	}
	return nil
}

func (m *SearchParams) GetScorerSpec() *ScorerSpec {
	if m != nil {
		return m.ScorerSpec
	}
	return nil
}

func (m *SearchParams) GetFieldSpec() *FieldSpec {
	if m != nil {
		return m.FieldSpec
	}
	return nil
}

func (m *SearchParams) GetKeysOnly() bool {
	if m != nil && m.KeysOnly != nil {
		return *m.KeysOnly
	}
	return false
}

func (m *SearchParams) GetParsingMode() SearchParams_ParsingMode {
	if m != nil && m.ParsingMode != nil {
		return *m.ParsingMode
	}
	return Default_SearchParams_ParsingMode
}

func (m *SearchParams) GetAutoDiscoverFacetCount() int32 {
	if m != nil && m.AutoDiscoverFacetCount != nil {
		return *m.AutoDiscoverFacetCount
	}
	return Default_SearchParams_AutoDiscoverFacetCount
}

func (m *SearchParams) GetIncludeFacet() []*FacetRequest {
	if m != nil {
		return m.IncludeFacet
	}
	return nil
}

func (m *SearchParams) GetFacetRefinement() []*FacetRefinement {
	if m != nil {
		return m.FacetRefinement
	}
	return nil
}

func (m *SearchParams) GetFacetAutoDetectParam() *FacetAutoDetectParam {
	if m != nil {
		return m.FacetAutoDetectParam
	}
	return nil
}

func (m *SearchParams) GetFacetDepth() int32 {
	if m != nil && m.FacetDepth != nil {
		return *m.FacetDepth
	}
	return Default_SearchParams_FacetDepth
}

type SearchRequest struct {
	Params           *SearchParams `protobuf:"bytes,1,req,name=params" json:"params,omitempty"`
	AppId            []byte        `protobuf:"bytes,3,opt,name=app_id" json:"app_id,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *SearchRequest) Reset()         { *m = SearchRequest{} }
func (m *SearchRequest) String() string { return proto.CompactTextString(m) }
func (*SearchRequest) ProtoMessage()    {}

func (m *SearchRequest) GetParams() *SearchParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *SearchRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type FacetResultValue struct {
	Name             *string          `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Count            *int32           `protobuf:"varint,2,req,name=count" json:"count,omitempty"`
	Refinement       *FacetRefinement `protobuf:"bytes,3,req,name=refinement" json:"refinement,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *FacetResultValue) Reset()         { *m = FacetResultValue{} }
func (m *FacetResultValue) String() string { return proto.CompactTextString(m) }
func (*FacetResultValue) ProtoMessage()    {}

func (m *FacetResultValue) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetResultValue) GetCount() int32 {
	if m != nil && m.Count != nil {
		return *m.Count
	}
	return 0
}

func (m *FacetResultValue) GetRefinement() *FacetRefinement {
	if m != nil {
		return m.Refinement
	}
	return nil
}

type FacetResult struct {
	Name             *string             `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            []*FacetResultValue `protobuf:"bytes,2,rep,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *FacetResult) Reset()         { *m = FacetResult{} }
func (m *FacetResult) String() string { return proto.CompactTextString(m) }
func (*FacetResult) ProtoMessage()    {}

func (m *FacetResult) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FacetResult) GetValue() []*FacetResultValue {
	if m != nil {
		return m.Value
	}
	return nil
}

type SearchResult struct {
	Document         *Document `protobuf:"bytes,1,req,name=document" json:"document,omitempty"`
	Expression       []*Field  `protobuf:"bytes,4,rep,name=expression" json:"expression,omitempty"`
	Score            []float64 `protobuf:"fixed64,2,rep,name=score" json:"score,omitempty"`
	Cursor           *string   `protobuf:"bytes,3,opt,name=cursor" json:"cursor,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *SearchResult) Reset()         { *m = SearchResult{} }
func (m *SearchResult) String() string { return proto.CompactTextString(m) }
func (*SearchResult) ProtoMessage()    {}

func (m *SearchResult) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *SearchResult) GetExpression() []*Field {
	if m != nil {
		return m.Expression
	}
	return nil
}

func (m *SearchResult) GetScore() []float64 {
	if m != nil {
		return m.Score
	}
	return nil
}

func (m *SearchResult) GetCursor() string {
	if m != nil && m.Cursor != nil {
		return *m.Cursor
	}
	return ""
}

type SearchResponse struct {
	Result           []*SearchResult           `protobuf:"bytes,1,rep,name=result" json:"result,omitempty"`
	MatchedCount     *int64                    `protobuf:"varint,2,req,name=matched_count" json:"matched_count,omitempty"`
	Status           *RequestStatus            `protobuf:"bytes,3,req,name=status" json:"status,omitempty"`
	Cursor           *string                   `protobuf:"bytes,4,opt,name=cursor" json:"cursor,omitempty"`
	FacetResult      []*FacetResult            `protobuf:"bytes,5,rep,name=facet_result" json:"facet_result,omitempty"`
	XXX_extensions   map[int32]proto.Extension `json:"-"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *SearchResponse) Reset()         { *m = SearchResponse{} }
func (m *SearchResponse) String() string { return proto.CompactTextString(m) }
func (*SearchResponse) ProtoMessage()    {}

var extRange_SearchResponse = []proto.ExtensionRange{
	{1000, 9999},
}

func (*SearchResponse) ExtensionRangeArray() []proto.ExtensionRange {
	return extRange_SearchResponse
}
func (m *SearchResponse) ExtensionMap() map[int32]proto.Extension {
	if m.XXX_extensions == nil {
		m.XXX_extensions = make(map[int32]proto.Extension)
	}
	return m.XXX_extensions
}

func (m *SearchResponse) GetResult() []*SearchResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *SearchResponse) GetMatchedCount() int64 {
	if m != nil && m.MatchedCount != nil {
		return *m.MatchedCount
	}
	return 0
}

func (m *SearchResponse) GetStatus() *RequestStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *SearchResponse) GetCursor() string {
	if m != nil && m.Cursor != nil {
		return *m.Cursor
	}
	return ""
}

func (m *SearchResponse) GetFacetResult() []*FacetResult {
	if m != nil {
		return m.FacetResult
	}
	return nil
}

func init() {
}
