// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

package number

import "golang.org/x/text/internal/stringset"

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "31"

var numSysData = []systemData{ // 58 elements
	0:  {id: 0x0, digitSize: 0x1, zero: [4]uint8{0x30, 0x0, 0x0, 0x0}},
	1:  {id: 0x1, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9e, 0xa5, 0x90}},
	2:  {id: 0x2, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x9c, 0xb0}},
	3:  {id: 0x3, digitSize: 0x2, zero: [4]uint8{0xd9, 0xa0, 0x0, 0x0}},
	4:  {id: 0x4, digitSize: 0x2, zero: [4]uint8{0xdb, 0xb0, 0x0, 0x0}},
	5:  {id: 0x5, digitSize: 0x3, zero: [4]uint8{0xe1, 0xad, 0x90, 0x0}},
	6:  {id: 0x6, digitSize: 0x3, zero: [4]uint8{0xe0, 0xa7, 0xa6, 0x0}},
	7:  {id: 0x7, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0xb1, 0x90}},
	8:  {id: 0x8, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x81, 0xa6}},
	9:  {id: 0x9, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x84, 0xb6}},
	10: {id: 0xa, digitSize: 0x3, zero: [4]uint8{0xea, 0xa9, 0x90, 0x0}},
	11: {id: 0xb, digitSize: 0x3, zero: [4]uint8{0xe0, 0xa5, 0xa6, 0x0}},
	12: {id: 0xc, digitSize: 0x3, zero: [4]uint8{0xef, 0xbc, 0x90, 0x0}},
	13: {id: 0xd, digitSize: 0x3, zero: [4]uint8{0xe0, 0xab, 0xa6, 0x0}},
	14: {id: 0xe, digitSize: 0x3, zero: [4]uint8{0xe0, 0xa9, 0xa6, 0x0}},
	15: {id: 0xf, digitSize: 0x4, zero: [4]uint8{0xf0, 0x96, 0xad, 0x90}},
	16: {id: 0x10, digitSize: 0x3, zero: [4]uint8{0xea, 0xa7, 0x90, 0x0}},
	17: {id: 0x11, digitSize: 0x3, zero: [4]uint8{0xea, 0xa4, 0x80, 0x0}},
	18: {id: 0x12, digitSize: 0x3, zero: [4]uint8{0xe1, 0x9f, 0xa0, 0x0}},
	19: {id: 0x13, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb3, 0xa6, 0x0}},
	20: {id: 0x14, digitSize: 0x3, zero: [4]uint8{0xe1, 0xaa, 0x80, 0x0}},
	21: {id: 0x15, digitSize: 0x3, zero: [4]uint8{0xe1, 0xaa, 0x90, 0x0}},
	22: {id: 0x16, digitSize: 0x3, zero: [4]uint8{0xe0, 0xbb, 0x90, 0x0}},
	23: {id: 0x17, digitSize: 0x3, zero: [4]uint8{0xe1, 0xb1, 0x80, 0x0}},
	24: {id: 0x18, digitSize: 0x3, zero: [4]uint8{0xe1, 0xa5, 0x86, 0x0}},
	25: {id: 0x19, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0x8e}},
	26: {id: 0x1a, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0x98}},
	27: {id: 0x1b, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0xb6}},
	28: {id: 0x1c, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0xac}},
	29: {id: 0x1d, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0xa2}},
	30: {id: 0x1e, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb5, 0xa6, 0x0}},
	31: {id: 0x1f, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x99, 0x90}},
	32: {id: 0x20, digitSize: 0x3, zero: [4]uint8{0xe1, 0xa0, 0x90, 0x0}},
	33: {id: 0x21, digitSize: 0x4, zero: [4]uint8{0xf0, 0x96, 0xa9, 0xa0}},
	34: {id: 0x22, digitSize: 0x3, zero: [4]uint8{0xea, 0xaf, 0xb0, 0x0}},
	35: {id: 0x23, digitSize: 0x3, zero: [4]uint8{0xe1, 0x81, 0x80, 0x0}},
	36: {id: 0x24, digitSize: 0x3, zero: [4]uint8{0xe1, 0x82, 0x90, 0x0}},
	37: {id: 0x25, digitSize: 0x3, zero: [4]uint8{0xea, 0xa7, 0xb0, 0x0}},
	38: {id: 0x26, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x91, 0x90}},
	39: {id: 0x27, digitSize: 0x2, zero: [4]uint8{0xdf, 0x80, 0x0, 0x0}},
	40: {id: 0x28, digitSize: 0x3, zero: [4]uint8{0xe1, 0xb1, 0x90, 0x0}},
	41: {id: 0x29, digitSize: 0x3, zero: [4]uint8{0xe0, 0xad, 0xa6, 0x0}},
	42: {id: 0x2a, digitSize: 0x4, zero: [4]uint8{0xf0, 0x90, 0x92, 0xa0}},
	43: {id: 0x2b, digitSize: 0x3, zero: [4]uint8{0xea, 0xa3, 0x90, 0x0}},
	44: {id: 0x2c, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x87, 0x90}},
	45: {id: 0x2d, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x8b, 0xb0}},
	46: {id: 0x2e, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb7, 0xa6, 0x0}},
	47: {id: 0x2f, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x83, 0xb0}},
	48: {id: 0x30, digitSize: 0x3, zero: [4]uint8{0xe1, 0xae, 0xb0, 0x0}},
	49: {id: 0x31, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x9b, 0x80}},
	50: {id: 0x32, digitSize: 0x3, zero: [4]uint8{0xe1, 0xa7, 0x90, 0x0}},
	51: {id: 0x33, digitSize: 0x3, zero: [4]uint8{0xe0, 0xaf, 0xa6, 0x0}},
	52: {id: 0x34, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb1, 0xa6, 0x0}},
	53: {id: 0x35, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb9, 0x90, 0x0}},
	54: {id: 0x36, digitSize: 0x3, zero: [4]uint8{0xe0, 0xbc, 0xa0, 0x0}},
	55: {id: 0x37, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x93, 0x90}},
	56: {id: 0x38, digitSize: 0x3, zero: [4]uint8{0xea, 0x98, 0xa0, 0x0}},
	57: {id: 0x39, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0xa3, 0xa0}},
} // Size: 372 bytes

const (
	numAdlm     = 0x1
	numAhom     = 0x2
	numArab     = 0x3
	numArabext  = 0x4
	numArmn     = 0x3a
	numArmnlow  = 0x3b
	numBali     = 0x5
	numBeng     = 0x6
	numBhks     = 0x7
	numBrah     = 0x8
	numCakm     = 0x9
	numCham     = 0xa
	numCyrl     = 0x3c
	numDeva     = 0xb
	numEthi     = 0x3d
	numFullwide = 0xc
	numGeor     = 0x3e
	numGrek     = 0x3f
	numGreklow  = 0x40
	numGujr     = 0xd
	numGuru     = 0xe
	numHanidays = 0x41
	numHanidec  = 0x42
	numHans     = 0x43
	numHansfin  = 0x44
	numHant     = 0x45
	numHantfin  = 0x46
	numHebr     = 0x47
	numHmng     = 0xf
	numJava     = 0x10
	numJpan     = 0x48
	numJpanfin  = 0x49
	numKali     = 0x11
	numKhmr     = 0x12
	numKnda     = 0x13
	numLana     = 0x14
	numLanatham = 0x15
	numLaoo     = 0x16
	numLatn     = 0x0
	numLepc     = 0x17
	numLimb     = 0x18
	numMathbold = 0x19
	numMathdbl  = 0x1a
	numMathmono = 0x1b
	numMathsanb = 0x1c
	numMathsans = 0x1d
	numMlym     = 0x1e
	numModi     = 0x1f
	numMong     = 0x20
	numMroo     = 0x21
	numMtei     = 0x22
	numMymr     = 0x23
	numMymrshan = 0x24
	numMymrtlng = 0x25
	numNewa     = 0x26
	numNkoo     = 0x27
	numOlck     = 0x28
	numOrya     = 0x29
	numOsma     = 0x2a
	numRoman    = 0x4a
	numRomanlow = 0x4b
	numSaur     = 0x2b
	numShrd     = 0x2c
	numSind     = 0x2d
	numSinh     = 0x2e
	numSora     = 0x2f
	numSund     = 0x30
	numTakr     = 0x31
	numTalu     = 0x32
	numTaml     = 0x4c
	numTamldec  = 0x33
	numTelu     = 0x34
	numThai     = 0x35
	numTibt     = 0x36
	numTirh     = 0x37
	numVaii     = 0x38
	numWara     = 0x39
	numNumberSystems
)

var systemMap = map[string]system{
	"adlm":     numAdlm,
	"ahom":     numAhom,
	"arab":     numArab,
	"arabext":  numArabext,
	"armn":     numArmn,
	"armnlow":  numArmnlow,
	"bali":     numBali,
	"beng":     numBeng,
	"bhks":     numBhks,
	"brah":     numBrah,
	"cakm":     numCakm,
	"cham":     numCham,
	"cyrl":     numCyrl,
	"deva":     numDeva,
	"ethi":     numEthi,
	"fullwide": numFullwide,
	"geor":     numGeor,
	"grek":     numGrek,
	"greklow":  numGreklow,
	"gujr":     numGujr,
	"guru":     numGuru,
	"hanidays": numHanidays,
	"hanidec":  numHanidec,
	"hans":     numHans,
	"hansfin":  numHansfin,
	"hant":     numHant,
	"hantfin":  numHantfin,
	"hebr":     numHebr,
	"hmng":     numHmng,
	"java":     numJava,
	"jpan":     numJpan,
	"jpanfin":  numJpanfin,
	"kali":     numKali,
	"khmr":     numKhmr,
	"knda":     numKnda,
	"lana":     numLana,
	"lanatham": numLanatham,
	"laoo":     numLaoo,
	"latn":     numLatn,
	"lepc":     numLepc,
	"limb":     numLimb,
	"mathbold": numMathbold,
	"mathdbl":  numMathdbl,
	"mathmono": numMathmono,
	"mathsanb": numMathsanb,
	"mathsans": numMathsans,
	"mlym":     numMlym,
	"modi":     numModi,
	"mong":     numMong,
	"mroo":     numMroo,
	"mtei":     numMtei,
	"mymr":     numMymr,
	"mymrshan": numMymrshan,
	"mymrtlng": numMymrtlng,
	"newa":     numNewa,
	"nkoo":     numNkoo,
	"olck":     numOlck,
	"orya":     numOrya,
	"osma":     numOsma,
	"roman":    numRoman,
	"romanlow": numRomanlow,
	"saur":     numSaur,
	"shrd":     numShrd,
	"sind":     numSind,
	"sinh":     numSinh,
	"sora":     numSora,
	"sund":     numSund,
	"takr":     numTakr,
	"talu":     numTalu,
	"taml":     numTaml,
	"tamldec":  numTamldec,
	"telu":     numTelu,
	"thai":     numThai,
	"tibt":     numTibt,
	"tirh":     numTirh,
	"vaii":     numVaii,
	"wara":     numWara,
}

var symIndex = [][12]uint8{ // 71 elements
	0:  [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	1:  [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	2:  [12]uint8{0x0, 0x1, 0x2, 0xd, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9, 0x10, 0xb},
	3:  [12]uint8{0x1, 0x0, 0x2, 0xd, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9, 0x10, 0xb},
	4:  [12]uint8{0x0, 0x1, 0x2, 0x11, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9, 0x10, 0xb},
	5:  [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x12, 0xb},
	6:  [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	7:  [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x13, 0x8, 0x9, 0xa, 0xb},
	8:  [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x14, 0xb},
	9:  [12]uint8{0x0, 0x1, 0x2, 0x3, 0xe, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	10: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0x0},
	11: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x13, 0x8, 0x9, 0xa, 0xb},
	12: [12]uint8{0x0, 0x15, 0x2, 0x3, 0x4, 0x5, 0x6, 0x13, 0x8, 0x9, 0xa, 0xb},
	13: [12]uint8{0x0, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	14: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x16, 0xb},
	15: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x17, 0x7, 0x8, 0x9, 0xa, 0xb},
	16: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x17, 0x7, 0x8, 0x9, 0xa, 0xb},
	17: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0x0},
	18: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x18, 0x7, 0x8, 0x9, 0xa, 0xb},
	19: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x19, 0x1a, 0xa, 0xb},
	20: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	21: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x18, 0x7, 0x8, 0x9, 0xa, 0xb},
	22: [12]uint8{0x0, 0x1, 0x2, 0x3, 0xe, 0x1c, 0x6, 0x7, 0x8, 0x9, 0x1d, 0xb},
	23: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x6, 0x7, 0x8, 0x9, 0x1e, 0x0},
	24: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x1b, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	25: [12]uint8{0x0, 0x15, 0x2, 0x3, 0x4, 0x1b, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	26: [12]uint8{0x0, 0x1, 0x2, 0x3, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	27: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1f, 0xb},
	28: [12]uint8{0x0, 0x15, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	29: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x20, 0xb},
	30: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x21, 0xb},
	31: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x1b, 0x18, 0x13, 0x8, 0x9, 0x22, 0xb},
	32: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x18, 0x7, 0x8, 0x9, 0x22, 0xb},
	33: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x23, 0xb},
	34: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x24, 0xb},
	35: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x25, 0xb},
	36: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x26, 0xb},
	37: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x27, 0xb},
	38: [12]uint8{0x1, 0x0, 0x2, 0x3, 0xe, 0x1c, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	39: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x28, 0xb},
	40: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x29, 0xb},
	41: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x2a, 0x13, 0x8, 0x9, 0x22, 0xb},
	42: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0x0},
	43: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x17, 0x7, 0x8, 0x9, 0xa, 0xb},
	44: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x1b, 0x17, 0x7, 0x8, 0x9, 0xa, 0xb},
	45: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x2b, 0x0},
	46: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x2c, 0xb},
	47: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x2d, 0xb},
	48: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x2e, 0x7, 0x8, 0x9, 0xa, 0xb},
	49: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x2f, 0xb},
	50: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x30, 0xb},
	51: [12]uint8{0x1, 0x15, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	52: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x31, 0xb},
	53: [12]uint8{0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x7, 0x39, 0x9, 0xa, 0xb},
	54: [12]uint8{0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x7, 0x39, 0x9, 0x3a, 0xb},
	55: [12]uint8{0x32, 0x33, 0x34, 0x11, 0x36, 0x37, 0x38, 0x7, 0x39, 0x9, 0xa, 0xb},
	56: [12]uint8{0x32, 0x33, 0x34, 0x11, 0x36, 0x3b, 0x38, 0x7, 0x39, 0x9, 0xa, 0xb},
	57: [12]uint8{0x32, 0xc, 0x34, 0x35, 0x36, 0x3c, 0x38, 0x7, 0x39, 0x9, 0xa, 0x0},
	58: [12]uint8{0x32, 0x33, 0x34, 0x35, 0x36, 0x3c, 0x38, 0x7, 0x3d, 0x9, 0x22, 0xb},
	59: [12]uint8{0x32, 0x33, 0x34, 0x11, 0x3e, 0x3f, 0x40, 0x7, 0x39, 0x9, 0xa, 0x32},
	60: [12]uint8{0x32, 0x33, 0x34, 0x41, 0xe, 0x1c, 0x40, 0x7, 0x39, 0x9, 0x1d, 0xb},
	61: [12]uint8{0x32, 0x33, 0x34, 0x11, 0xe, 0x1c, 0x40, 0x7, 0x39, 0x9, 0xa, 0x32},
	62: [12]uint8{0x1, 0xc, 0x34, 0x11, 0x3e, 0x42, 0x40, 0x7, 0x39, 0x9, 0xa, 0x0},
	63: [12]uint8{0x32, 0x1, 0x34, 0x11, 0x4, 0x5, 0x40, 0x7, 0x39, 0x9, 0xa, 0x32},
	64: [12]uint8{0x32, 0x33, 0x34, 0x11, 0x3e, 0x42, 0x40, 0x7, 0x39, 0x9, 0x22, 0xb},
	65: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x3e, 0x3f, 0x40, 0x7, 0x8, 0x9, 0xa, 0x32},
	66: [12]uint8{0x32, 0x33, 0x34, 0x11, 0x4, 0x5, 0x40, 0x7, 0x39, 0x9, 0x2f, 0x32},
	67: [12]uint8{0x32, 0x33, 0x34, 0x11, 0x4, 0x5, 0x40, 0x7, 0x39, 0x9, 0x30, 0x32},
	68: [12]uint8{0x0, 0x1, 0x43, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x26, 0xb},
	69: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x44, 0xb},
	70: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x45, 0x46, 0xb},
} // Size: 876 bytes

var symData = stringset.Set{
	Data: "" + // Size: 580 bytes
		".,;%+-E×‰∞NaN:\u00a0\u200e%\u200e\u200e+\u200e-ليس\u00a0رقمًا٪ND·Терхьаш" +
		"\u00a0дац’mnne×10^0/00INF−\u200e−ناعددepälukuՈչԹარ\u00a0არის\u00a0რიცხვი" +
		"сан\u00a0емес¤¤¤сан\u00a0эмесບໍ່\u200bແມ່ນ\u200bໂຕ\u200bເລກNSဂဏန်းမဟုတ်" +
		"သောННне\u00a0числочыыһыла\u00a0буотах·10^epilohosan\u00a0dälTFЕhaqiqiy" +
		"\u00a0son\u00a0emasҳақиқий\u00a0сон\u00a0эмас非數值٫٬؛٪\u061c\u061c+\u061c-" +
		"اس؉ليس\u00a0رقم\u200f−\u061c−؉\u200f\u200e+\u200e\u200e-\u200e×۱۰^" +
		"\u200e٪\u200e−\u200e၊ཨང་མེན་གྲངས་མེདཨང་མད",
	Index: []uint16{ // 72 elements
		// Entry 0 - 3F
		0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
		0x0009, 0x000c, 0x000f, 0x0012, 0x0013, 0x0015, 0x001c, 0x0020,
		0x0024, 0x0036, 0x0038, 0x003a, 0x003c, 0x0052, 0x0055, 0x0058,
		0x0059, 0x005e, 0x0062, 0x0065, 0x0068, 0x006e, 0x0078, 0x0080,
		0x0086, 0x00ae, 0x00be, 0x00c4, 0x00d4, 0x0101, 0x0103, 0x012a,
		0x012e, 0x013e, 0x015a, 0x015f, 0x0166, 0x016f, 0x0171, 0x0173,
		0x0185, 0x01a5, 0x01ae, 0x01b0, 0x01b2, 0x01b4, 0x01b8, 0x01bb,
		0x01be, 0x01c2, 0x01c4, 0x01d2, 0x01d8, 0x01dd, 0x01e2, 0x01e9,
		// Entry 40 - 7F
		0x01f0, 0x01f7, 0x01fc, 0x0205, 0x0208, 0x021d, 0x0235, 0x0244,
	},
} // Size: 764 bytes

// langToDefaults maps a compact language index to the default numbering system
// and default symbol set
var langToDefaults = [754]uint8{
	// Entry 0 - 3F
	0x80, 0x06, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x83, 0x02, 0x02, 0x02,
	0x02, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02,
	0x02, 0x04, 0x02, 0x04, 0x02, 0x02, 0x02, 0x03,
	0x02, 0x00, 0x85, 0x00, 0x00, 0x00, 0x86, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00,
	// Entry 40 - 7F
	0x00, 0x00, 0x89, 0x00, 0x00, 0x8a, 0x00, 0x00,
	0x8c, 0x01, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x08, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x8e, 0x09, 0x09, 0x90,
	0x01, 0x01, 0x01, 0x93, 0x00, 0x0a, 0x0a, 0x0a,
	0x00, 0x00, 0x0b, 0x07, 0x0b, 0x0c, 0x0b, 0x0b,
	0x0c, 0x0b, 0x0d, 0x0d, 0x0b, 0x0b, 0x01, 0x01,
	0x00, 0x01, 0x01, 0x95, 0x00, 0x00, 0x00, 0x0e,
	// Entry 80 - BF
	0x0e, 0x0e, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x0b, 0x10, 0x00, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00,
	0x00, 0x00, 0x00, 0x0b, 0x00, 0x0a, 0x00, 0x00,
	0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry C0 - FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00,
	0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x14, 0x14,
	0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06,
	0x01, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x00,
	// Entry 100 - 13F
	0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
	0x06, 0x00, 0x00, 0x06, 0x06, 0x15, 0x15, 0x06,
	0x06, 0x01, 0x01, 0x97, 0x16, 0x16, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x17, 0x17, 0x00, 0x00, 0x18,
	0x18, 0x18, 0x9a, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 140 - 17F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x9d,
	0x00, 0x06, 0x06, 0x19, 0x19, 0x19, 0x19, 0xa0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1a, 0x1a, 0x00, 0x00,
	0x06, 0x06, 0x06, 0x0b, 0x0b, 0x01, 0x01, 0x1b,
	0x1b, 0x0a, 0x0a, 0xa2, 0x00, 0x00, 0x00, 0x06,
	// Entry 180 - 1BF
	0x06, 0x06, 0x1c, 0x06, 0x06, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x1d,
	0x1d, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x01, 0x0d, 0x0d, 0x00, 0x00, 0x1e,
	0x1e, 0x06, 0x06, 0x1f, 0x1f, 0x00, 0x00, 0x06,
	0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xa5, 0x1a, 0x00, 0x00, 0x01, 0x01, 0x20, 0x20,
	0x00, 0x00, 0x00, 0x21, 0x21, 0x00, 0x00, 0x06,
	// Entry 1C0 - 1FF
	0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x22, 0x22, 0xa7, 0x00, 0x00, 0x15,
	0x15, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x23,
	0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x0d,
	0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0xa9, 0x00, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0xaa, 0x24,
	0xac, 0x00, 0x00, 0x00, 0x00, 0xad, 0x14, 0x14,
	// Entry 200 - 23F
	0x00, 0x00, 0x06, 0x06, 0x06, 0xb0, 0x00, 0x00,
	0xb1, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x01, 0x01, 0x14, 0x14, 0x06, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x25, 0x25, 0x25, 0xb4,
	0xb6, 0x1a, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
	0x01, 0xb8, 0x26, 0x06, 0x01, 0x06, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 240 - 27F
	0x00, 0x06, 0x00, 0x00, 0x19, 0x19, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x00, 0x00, 0x27, 0x27, 0x27,
	0x27, 0x27, 0x27, 0x27, 0x06, 0x06, 0x00, 0x00,
	0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29,
	0x29, 0x29, 0x29, 0x06, 0x06, 0x0d, 0x0d, 0x06,
	0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2a, 0x2a,
	0x2b, 0x2b, 0x2c, 0x2c, 0x00, 0x00, 0x00, 0x2d,
	0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 280 - 2BF
	0x00, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x00, 0x00, 0x00, 0xba, 0x20, 0x20, 0x20, 0x00,
	0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x2e, 0x00,
	0x2f, 0x2f, 0x06, 0x06, 0x06, 0x00, 0x0d, 0x0d,
	0x01, 0x01, 0x00, 0x00, 0x30, 0x30, 0xbd, 0xbf,
	// Entry 2C0 - 2FF
	0x1a, 0xc0, 0xc2, 0x26, 0xc4, 0x32, 0x31, 0x31,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x34, 0x34, 0x01, 0x01, 0xc6, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x34,
	0x00, 0x00,
} // Size: 754 bytes

// langToAlt is a list of numbering system and symbol set pairs, sorted and
// marked by compact language index.
var langToAlt = []altSymData{ // 73 elements
	1:  {compactTag: 0x0, system: 0x3, symIndex: 0x35},
	2:  {compactTag: 0x0, system: 0x4, symIndex: 0x3b},
	3:  {compactTag: 0xc, system: 0x3, symIndex: 0x36},
	4:  {compactTag: 0xc, system: 0x0, symIndex: 0x2},
	5:  {compactTag: 0x2a, system: 0x6, symIndex: 0x0},
	6:  {compactTag: 0x2e, system: 0x0, symIndex: 0x5},
	7:  {compactTag: 0x2e, system: 0x3, symIndex: 0x37},
	8:  {compactTag: 0x2e, system: 0x4, symIndex: 0x3b},
	9:  {compactTag: 0x42, system: 0x6, symIndex: 0x0},
	10: {compactTag: 0x45, system: 0x0, symIndex: 0x0},
	11: {compactTag: 0x45, system: 0x36, symIndex: 0x45},
	12: {compactTag: 0x48, system: 0x0, symIndex: 0x1},
	13: {compactTag: 0x48, system: 0x3, symIndex: 0x35},
	14: {compactTag: 0x5c, system: 0x3, symIndex: 0x37},
	15: {compactTag: 0x5c, system: 0x0, symIndex: 0x9},
	16: {compactTag: 0x5f, system: 0x0, symIndex: 0x1},
	17: {compactTag: 0x5f, system: 0x3, symIndex: 0x35},
	18: {compactTag: 0x5f, system: 0x4, symIndex: 0x3b},
	19: {compactTag: 0x63, system: 0x0, symIndex: 0x0},
	20: {compactTag: 0x63, system: 0x3, symIndex: 0x35},
	21: {compactTag: 0x7b, system: 0x36, symIndex: 0x46},
	22: {compactTag: 0x7b, system: 0x0, symIndex: 0x0},
	23: {compactTag: 0x113, system: 0x4, symIndex: 0x3c},
	24: {compactTag: 0x113, system: 0x0, symIndex: 0x16},
	25: {compactTag: 0x113, system: 0x3, symIndex: 0x37},
	26: {compactTag: 0x122, system: 0x0, symIndex: 0x1},
	27: {compactTag: 0x122, system: 0x3, symIndex: 0x38},
	28: {compactTag: 0x122, system: 0x4, symIndex: 0x3d},
	29: {compactTag: 0x157, system: 0x0, symIndex: 0x0},
	30: {compactTag: 0x157, system: 0x3, symIndex: 0x37},
	31: {compactTag: 0x157, system: 0x4, symIndex: 0x3b},
	32: {compactTag: 0x15f, system: 0x0, symIndex: 0x0},
	33: {compactTag: 0x15f, system: 0x3, symIndex: 0x35},
	34: {compactTag: 0x17b, system: 0x0, symIndex: 0x0},
	35: {compactTag: 0x17b, system: 0x3, symIndex: 0x35},
	36: {compactTag: 0x17b, system: 0x4, symIndex: 0x3b},
	37: {compactTag: 0x1b0, system: 0x4, symIndex: 0x3b},
	38: {compactTag: 0x1b0, system: 0x0, symIndex: 0x1a},
	39: {compactTag: 0x1cc, system: 0x4, symIndex: 0x3b},
	40: {compactTag: 0x1cc, system: 0x0, symIndex: 0x0},
	41: {compactTag: 0x1ec, system: 0xb, symIndex: 0x0},
	42: {compactTag: 0x1f6, system: 0x23, symIndex: 0x44},
	43: {compactTag: 0x1f6, system: 0x0, symIndex: 0x24},
	44: {compactTag: 0x1f8, system: 0x4, symIndex: 0x3b},
	45: {compactTag: 0x1fd, system: 0x0, symIndex: 0x14},
	46: {compactTag: 0x1fd, system: 0x3, symIndex: 0x39},
	47: {compactTag: 0x1fd, system: 0x4, symIndex: 0x3e},
	48: {compactTag: 0x205, system: 0xb, symIndex: 0x0},
	49: {compactTag: 0x208, system: 0x0, symIndex: 0x6},
	50: {compactTag: 0x208, system: 0x3, symIndex: 0x35},
	51: {compactTag: 0x208, system: 0x4, symIndex: 0x3b},
	52: {compactTag: 0x227, system: 0x0, symIndex: 0x0},
	53: {compactTag: 0x227, system: 0x4, symIndex: 0x3f},
	54: {compactTag: 0x228, system: 0x4, symIndex: 0x3b},
	55: {compactTag: 0x228, system: 0x0, symIndex: 0x1a},
	56: {compactTag: 0x231, system: 0x4, symIndex: 0x3b},
	57: {compactTag: 0x231, system: 0x0, symIndex: 0x26},
	58: {compactTag: 0x293, system: 0x0, symIndex: 0x20},
	59: {compactTag: 0x293, system: 0x3, symIndex: 0x3a},
	60: {compactTag: 0x293, system: 0x4, symIndex: 0x40},
	61: {compactTag: 0x2be, system: 0x0, symIndex: 0x1a},
	62: {compactTag: 0x2be, system: 0x4, symIndex: 0x41},
	63: {compactTag: 0x2bf, system: 0x4, symIndex: 0x41},
	64: {compactTag: 0x2c1, system: 0x0, symIndex: 0x31},
	65: {compactTag: 0x2c1, system: 0x4, symIndex: 0x42},
	66: {compactTag: 0x2c2, system: 0x4, symIndex: 0x3b},
	67: {compactTag: 0x2c2, system: 0x0, symIndex: 0x26},
	68: {compactTag: 0x2c4, system: 0x0, symIndex: 0x32},
	69: {compactTag: 0x2c4, system: 0x4, symIndex: 0x43},
	70: {compactTag: 0x2e6, system: 0x0, symIndex: 0x0},
	71: {compactTag: 0x2e6, system: 0x3, symIndex: 0x35},
	72: {compactTag: 0x2e6, system: 0x4, symIndex: 0x3b},
} // Size: 316 bytes

var tagToDecimal = []uint8{ // 754 elements
	// Entry 0 - 3F
	0x01, 0x01, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 40 - 7F
	0x01, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01,
	// Entry 80 - BF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry C0 - FF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 100 - 13F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 140 - 17F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05,
	0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 180 - 1BF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05,
	0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 1C0 - 1FF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x05, 0x05, 0x01, 0x01, 0x05, 0x05, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 200 - 23F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x05,
	0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 240 - 27F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 280 - 2BF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 2C0 - 2FF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01,
} // Size: 778 bytes

var tagToScientific = []uint8{ // 754 elements
	// Entry 0 - 3F
	0x02, 0x02, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 40 - 7F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 80 - BF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry C0 - FF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 100 - 13F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 140 - 17F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0d,
	0x0d, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0d, 0x0d,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 180 - 1BF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 1C0 - 1FF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x0e, 0x0e, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x0d, 0x0d, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 200 - 23F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0d,
	0x02, 0x02, 0x0d, 0x0d, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 240 - 27F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0e, 0x0e,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 280 - 2BF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 2C0 - 2FF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02,
} // Size: 778 bytes

var tagToPercent = []uint8{ // 754 elements
	// Entry 0 - 3F
	0x04, 0x04, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	// Entry 40 - 7F
	0x04, 0x04, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04,
	0x03, 0x03, 0x06, 0x06, 0x03, 0x04, 0x04, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03,
	0x04, 0x03, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x07, 0x07, 0x04, 0x04, 0x04,
	// Entry 80 - BF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x03, 0x04, 0x03, 0x04, 0x04,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	// Entry C0 - FF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04,
	0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03,
	// Entry 100 - 13F
	0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x0b,
	0x0b, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x03, 0x03, 0x04, 0x04, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	// Entry 140 - 17F
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06,
	0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06,
	0x04, 0x04, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	// Entry 180 - 1BF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06,
	0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03,
	// Entry 1C0 - 1FF
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03,
	// Entry 200 - 23F
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x06,
	0x04, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	// Entry 240 - 27F
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x04, 0x04, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03,
	0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	// Entry 280 - 2BF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x04,
	0x04, 0x04, 0x0f, 0x0f, 0x0f, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06,
	// Entry 2C0 - 2FF
	0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04,
} // Size: 778 bytes

var formats = []Pattern{Pattern{Affix: "",
	Offset:         0x0,
	NegOffset:      0x0,
	FormatWidth:    0x0,
	RoundIncrement: 0x0,
	PadRune:        0,
	DigitShift:     0x0,
	GroupingSize: [2]uint8{0x0,
		0x0},
	Flags:                0x0,
	MinIntegerDigits:     0x0,
	MaxIntegerDigits:     0x0,
	MinFractionDigits:    0x0,
	MaxFractionDigits:    0x0,
	MinSignificantDigits: 0x0,
	MaxSignificantDigits: 0x0,
	MinExponentDigits:    0x0},
	Pattern{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x9,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x0,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x3,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x3,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x0,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x0,
		MaxIntegerDigits:     0x1,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x1},
	Pattern{Affix: "\x00\x03\u00a0%",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x7,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x2,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "\x00\x01%",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x6,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x2,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0xc,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x0,
		GroupingSize: [2]uint8{0x3,
			0x2},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x3,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "\x00\x01%",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x9,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x2,
		GroupingSize: [2]uint8{0x3,
			0x2},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "\x00\x03\u00a0%",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0xa,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x2,
		GroupingSize: [2]uint8{0x3,
			0x2},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x9,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x0,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x6,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0xd,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x0,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x4,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x6,
		MaxFractionDigits:    0x6,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x3},
	Pattern{Affix: "\x00\x01%",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x3,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x2,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "\x03%\u00a0\x00",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x7,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x2,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "\x03%\u00a0\x00\x04%\u00a0-\x00",
		Offset:         0x0,
		NegOffset:      0x5,
		FormatWidth:    0x7,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x2,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "\x01[\x01]",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x5,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x0,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x0,
		MaxIntegerDigits:     0x1,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x1},
	Pattern{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x1,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x0,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x0,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Pattern{Affix: "\x01%\x00",
		Offset:         0x0,
		NegOffset:      0x0,
		FormatWidth:    0x6,
		RoundIncrement: 0x0,
		PadRune:        0,
		DigitShift:     0x2,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0}}

// Total table size 7101 bytes (6KiB); checksum: 5190D0B3
