// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1beta1/video_intelligence.proto

/*
Package videointelligence is a generated protocol buffer package.

It is generated from these files:
	google/cloud/videointelligence/v1beta1/video_intelligence.proto

It has these top-level messages:
	AnnotateVideoRequest
	VideoContext
	VideoSegment
	LabelLocation
	LabelAnnotation
	SafeSearchAnnotation
	BoundingBox
	FaceLocation
	FaceAnnotation
	VideoAnnotationResults
	AnnotateVideoResponse
	VideoAnnotationProgress
	AnnotateVideoProgress
*/
package videointelligence

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 2
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 3
	// Safe search detection.
	Feature_SAFE_SEARCH_DETECTION Feature = 4
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "FACE_DETECTION",
	3: "SHOT_CHANGE_DETECTION",
	4: "SAFE_SEARCH_DETECTION",
}
var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":   0,
	"LABEL_DETECTION":       1,
	"FACE_DETECTION":        2,
	"SHOT_CHANGE_DETECTION": 3,
	"SAFE_SEARCH_DETECTION": 4,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}
func (Feature) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Label level (scope).
type LabelLevel int32

const (
	// Unspecified.
	LabelLevel_LABEL_LEVEL_UNSPECIFIED LabelLevel = 0
	// Video-level. Corresponds to the whole video.
	LabelLevel_VIDEO_LEVEL LabelLevel = 1
	// Segment-level. Corresponds to one of `AnnotateSpec.segments`.
	LabelLevel_SEGMENT_LEVEL LabelLevel = 2
	// Shot-level. Corresponds to a single shot (i.e. a series of frames
	// without a major camera position or background change).
	LabelLevel_SHOT_LEVEL LabelLevel = 3
	// Frame-level. Corresponds to a single video frame.
	LabelLevel_FRAME_LEVEL LabelLevel = 4
)

var LabelLevel_name = map[int32]string{
	0: "LABEL_LEVEL_UNSPECIFIED",
	1: "VIDEO_LEVEL",
	2: "SEGMENT_LEVEL",
	3: "SHOT_LEVEL",
	4: "FRAME_LEVEL",
}
var LabelLevel_value = map[string]int32{
	"LABEL_LEVEL_UNSPECIFIED": 0,
	"VIDEO_LEVEL":             1,
	"SEGMENT_LEVEL":           2,
	"SHOT_LEVEL":              3,
	"FRAME_LEVEL":             4,
}

func (x LabelLevel) String() string {
	return proto.EnumName(LabelLevel_name, int32(x))
}
func (LabelLevel) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}
var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "UNKNOWN",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"UNKNOWN":       0,
	"VERY_UNLIKELY": 1,
	"UNLIKELY":      2,
	"POSSIBLE":      3,
	"LIKELY":        4,
	"VERY_LIKELY":   5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	// A video URI may include wildcards in `object-id`, and thus identify
	// multiple videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// The video data bytes. Encoding: base64. If unset, the input video(s)
	// should be specified via `input_uri`. If set, `input_uri` should be unset.
	InputContent string `protobuf:"bytes,6,opt,name=input_content,json=inputContent" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,enum=google.cloud.videointelligence.v1beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId" json:"location_id,omitempty"`
}

func (m *AnnotateVideoRequest) Reset()                    { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()               {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() string {
	if m != nil {
		return m.InputContent
	}
	return ""
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video
	// is treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments" json:"segments,omitempty"`
	// If label detection has been requested, what labels should be detected
	// in addition to video-level labels or segment-level labels. If unspecified,
	// defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,2,opt,name=label_detection_mode,json=labelDetectionMode,enum=google.cloud.videointelligence.v1beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	StationaryCamera bool `protobuf:"varint,3,opt,name=stationary_camera,json=stationaryCamera" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "latest" and "stable" (the default).
	LabelDetectionModel string `protobuf:"bytes,4,opt,name=label_detection_model,json=labelDetectionModel" json:"label_detection_model,omitempty"`
	// Model to use for face detection.
	// Supported values: "latest" and "stable" (the default).
	FaceDetectionModel string `protobuf:"bytes,5,opt,name=face_detection_model,json=faceDetectionModel" json:"face_detection_model,omitempty"`
	// Model to use for shot change detection.
	// Supported values: "latest" and "stable" (the default).
	ShotChangeDetectionModel string `protobuf:"bytes,6,opt,name=shot_change_detection_model,json=shotChangeDetectionModel" json:"shot_change_detection_model,omitempty"`
	// Model to use for safe search detection.
	// Supported values: "latest" and "stable" (the default).
	SafeSearchDetectionModel string `protobuf:"bytes,7,opt,name=safe_search_detection_model,json=safeSearchDetectionModel" json:"safe_search_detection_model,omitempty"`
}

func (m *VideoContext) Reset()                    { *m = VideoContext{} }
func (m *VideoContext) String() string            { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()               {}
func (*VideoContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *VideoContext) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *VideoContext) GetLabelDetectionModel() string {
	if m != nil {
		return m.LabelDetectionModel
	}
	return ""
}

func (m *VideoContext) GetFaceDetectionModel() string {
	if m != nil {
		return m.FaceDetectionModel
	}
	return ""
}

func (m *VideoContext) GetShotChangeDetectionModel() string {
	if m != nil {
		return m.ShotChangeDetectionModel
	}
	return ""
}

func (m *VideoContext) GetSafeSearchDetectionModel() string {
	if m != nil {
		return m.SafeSearchDetectionModel
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	// Start offset in microseconds (inclusive). Unset means 0.
	StartTimeOffset int64 `protobuf:"varint,1,opt,name=start_time_offset,json=startTimeOffset" json:"start_time_offset,omitempty"`
	// End offset in microseconds (inclusive). Unset means 0.
	EndTimeOffset int64 `protobuf:"varint,2,opt,name=end_time_offset,json=endTimeOffset" json:"end_time_offset,omitempty"`
}

func (m *VideoSegment) Reset()                    { *m = VideoSegment{} }
func (m *VideoSegment) String() string            { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()               {}
func (*VideoSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *VideoSegment) GetStartTimeOffset() int64 {
	if m != nil {
		return m.StartTimeOffset
	}
	return 0
}

func (m *VideoSegment) GetEndTimeOffset() int64 {
	if m != nil {
		return m.EndTimeOffset
	}
	return 0
}

// Label location.
type LabelLocation struct {
	// Video segment. Set to [-1, -1] for video-level labels.
	// Set to [timestamp, timestamp] for frame-level labels.
	// Otherwise, corresponds to one of `AnnotateSpec.segments`
	// (if specified) or to shot boundaries (if requested).
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
	// Label level.
	Level LabelLevel `protobuf:"varint,3,opt,name=level,enum=google.cloud.videointelligence.v1beta1.LabelLevel" json:"level,omitempty"`
}

func (m *LabelLocation) Reset()                    { *m = LabelLocation{} }
func (m *LabelLocation) String() string            { return proto.CompactTextString(m) }
func (*LabelLocation) ProtoMessage()               {}
func (*LabelLocation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *LabelLocation) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelLocation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *LabelLocation) GetLevel() LabelLevel {
	if m != nil {
		return m.Level
	}
	return LabelLevel_LABEL_LEVEL_UNSPECIFIED
}

// Label annotation.
type LabelAnnotation struct {
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// Where the label was detected and with what confidence.
	Locations []*LabelLocation `protobuf:"bytes,3,rep,name=locations" json:"locations,omitempty"`
}

func (m *LabelAnnotation) Reset()                    { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string            { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()               {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *LabelAnnotation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *LabelAnnotation) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *LabelAnnotation) GetLocations() []*LabelLocation {
	if m != nil {
		return m.Locations
	}
	return nil
}

// Safe search annotation (based on per-frame visual signals only).
// If no unsafe content has been detected in a frame, no annotations
// are present for that frame. If only some types of unsafe content
// have been detected in a frame, the likelihood is set to `UNKNOWN`
// for all other types of unsafe content.
type SafeSearchAnnotation struct {
	// Likelihood of adult content.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"adult,omitempty"`
	// Likelihood that an obvious modification was made to the original
	// version to make it appear funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"spoof,omitempty"`
	// Likelihood of medical content.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"medical,omitempty"`
	// Likelihood of violent content.
	Violent Likelihood `protobuf:"varint,4,opt,name=violent,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"violent,omitempty"`
	// Likelihood of racy content.
	Racy Likelihood `protobuf:"varint,5,opt,name=racy,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"racy,omitempty"`
	// Video time offset in microseconds.
	TimeOffset int64 `protobuf:"varint,6,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
}

func (m *SafeSearchAnnotation) Reset()                    { *m = SafeSearchAnnotation{} }
func (m *SafeSearchAnnotation) String() string            { return proto.CompactTextString(m) }
func (*SafeSearchAnnotation) ProtoMessage()               {}
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *SafeSearchAnnotation) GetAdult() Likelihood {
	if m != nil {
		return m.Adult
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetSpoof() Likelihood {
	if m != nil {
		return m.Spoof
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetMedical() Likelihood {
	if m != nil {
		return m.Medical
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetViolent() Likelihood {
	if m != nil {
		return m.Violent
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetRacy() Likelihood {
	if m != nil {
		return m.Racy
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetTimeOffset() int64 {
	if m != nil {
		return m.TimeOffset
	}
	return 0
}

// Bounding box.
type BoundingBox struct {
	// Left X coordinate.
	Left int32 `protobuf:"varint,1,opt,name=left" json:"left,omitempty"`
	// Right X coordinate.
	Right int32 `protobuf:"varint,2,opt,name=right" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom int32 `protobuf:"varint,3,opt,name=bottom" json:"bottom,omitempty"`
	// Top Y coordinate.
	Top int32 `protobuf:"varint,4,opt,name=top" json:"top,omitempty"`
}

func (m *BoundingBox) Reset()                    { *m = BoundingBox{} }
func (m *BoundingBox) String() string            { return proto.CompactTextString(m) }
func (*BoundingBox) ProtoMessage()               {}
func (*BoundingBox) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *BoundingBox) GetLeft() int32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *BoundingBox) GetRight() int32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *BoundingBox) GetBottom() int32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

func (m *BoundingBox) GetTop() int32 {
	if m != nil {
		return m.Top
	}
	return 0
}

// Face location.
type FaceLocation struct {
	// Bounding box in a frame.
	BoundingBox *BoundingBox `protobuf:"bytes,1,opt,name=bounding_box,json=boundingBox" json:"bounding_box,omitempty"`
	// Video time offset in microseconds.
	TimeOffset int64 `protobuf:"varint,2,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
}

func (m *FaceLocation) Reset()                    { *m = FaceLocation{} }
func (m *FaceLocation) String() string            { return proto.CompactTextString(m) }
func (*FaceLocation) ProtoMessage()               {}
func (*FaceLocation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *FaceLocation) GetBoundingBox() *BoundingBox {
	if m != nil {
		return m.BoundingBox
	}
	return nil
}

func (m *FaceLocation) GetTimeOffset() int64 {
	if m != nil {
		return m.TimeOffset
	}
	return 0
}

// Face annotation.
type FaceAnnotation struct {
	// Thumbnail of a representative face view (in JPEG format). Encoding: base64.
	Thumbnail string `protobuf:"bytes,1,opt,name=thumbnail" json:"thumbnail,omitempty"`
	// All locations where a face was detected.
	// Faces are detected and tracked on a per-video basis
	// (as opposed to across multiple videos).
	Segments []*VideoSegment `protobuf:"bytes,2,rep,name=segments" json:"segments,omitempty"`
	// Face locations at one frame per second.
	Locations []*FaceLocation `protobuf:"bytes,3,rep,name=locations" json:"locations,omitempty"`
}

func (m *FaceAnnotation) Reset()                    { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string            { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()               {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *FaceAnnotation) GetThumbnail() string {
	if m != nil {
		return m.Thumbnail
	}
	return ""
}

func (m *FaceAnnotation) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceAnnotation) GetLocations() []*FaceLocation {
	if m != nil {
		return m.Locations
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// Label annotations. There is exactly one element for each unique label.
	LabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=label_annotations,json=labelAnnotations" json:"label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,3,rep,name=face_annotations,json=faceAnnotations" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,4,rep,name=shot_annotations,json=shotAnnotations" json:"shot_annotations,omitempty"`
	// Safe search annotations.
	SafeSearchAnnotations []*SafeSearchAnnotation `protobuf:"bytes,6,rep,name=safe_search_annotations,json=safeSearchAnnotations" json:"safe_search_annotations,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error *google_rpc.Status `protobuf:"bytes,5,opt,name=error" json:"error,omitempty"`
}

func (m *VideoAnnotationResults) Reset()                    { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string            { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()               {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetSafeSearchAnnotations() []*SafeSearchAnnotation {
	if m != nil {
		return m.SafeSearchAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *google_rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults" json:"annotation_results,omitempty"`
}

func (m *AnnotateVideoResponse) Reset()                    { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()               {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far.
	// Guaranteed to be 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *google_protobuf3.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime *google_protobuf3.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *VideoAnnotationProgress) Reset()                    { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string            { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()               {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress" json:"annotation_progress,omitempty"`
}

func (m *AnnotateVideoProgress) Reset()                    { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()               {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

func init() {
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1beta1.VideoContext")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1beta1.VideoSegment")
	proto.RegisterType((*LabelLocation)(nil), "google.cloud.videointelligence.v1beta1.LabelLocation")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1beta1.LabelAnnotation")
	proto.RegisterType((*SafeSearchAnnotation)(nil), "google.cloud.videointelligence.v1beta1.SafeSearchAnnotation")
	proto.RegisterType((*BoundingBox)(nil), "google.cloud.videointelligence.v1beta1.BoundingBox")
	proto.RegisterType((*FaceLocation)(nil), "google.cloud.videointelligence.v1beta1.FaceLocation")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.videointelligence.v1beta1.FaceAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1beta1.AnnotateVideoProgress")
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.LabelLevel", LabelLevel_name, LabelLevel_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.Likelihood", Likelihood_name, Likelihood_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for VideoIntelligenceService service

type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.videointelligence.v1beta1.VideoIntelligenceService/AnnotateVideo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for VideoIntelligenceService service

type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*google_longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1beta1/video_intelligence.proto",
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1beta1/video_intelligence.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1503 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xcb, 0x6f, 0x1b, 0x45,
	0x18, 0xef, 0xfa, 0x91, 0xc4, 0x9f, 0x93, 0xd8, 0x99, 0x24, 0x8d, 0x49, 0x1b, 0x1a, 0xb9, 0xa8,
	0x0a, 0x41, 0xb2, 0xa9, 0xcb, 0x43, 0xb4, 0x40, 0xe5, 0x38, 0xeb, 0xc6, 0xaa, 0x63, 0x47, 0xeb,
	0x24, 0x55, 0xb9, 0xac, 0xd6, 0xbb, 0x63, 0x67, 0xc5, 0x7a, 0x67, 0xd9, 0x9d, 0x8d, 0xda, 0x23,
	0x1c, 0x40, 0x1c, 0x11, 0xff, 0x05, 0x12, 0xf0, 0x2f, 0x70, 0xe5, 0xc4, 0x01, 0x2e, 0x9c, 0xb8,
	0xf0, 0x7f, 0x80, 0xe6, 0xb1, 0xf6, 0xda, 0x0e, 0xd4, 0x0e, 0xdc, 0x3c, 0xdf, 0xe3, 0xf7, 0xbd,
	0x67, 0xbe, 0x35, 0x3c, 0xee, 0x13, 0xd2, 0x77, 0x70, 0xd9, 0x74, 0x48, 0x68, 0x95, 0x2f, 0x6d,
	0x0b, 0x13, 0xdb, 0xa5, 0xd8, 0x71, 0xec, 0x3e, 0x76, 0x4d, 0x5c, 0xbe, 0xbc, 0xdf, 0xc5, 0xd4,
	0xb8, 0x2f, 0x38, 0x7a, 0x9c, 0x55, 0xf2, 0x7c, 0x42, 0x09, 0xba, 0x27, 0x00, 0x4a, 0x1c, 0xa0,
	0x34, 0x05, 0x50, 0x92, 0x00, 0xdb, 0xb7, 0xa5, 0x21, 0xc3, 0xb3, 0xcb, 0x86, 0xeb, 0x12, 0x6a,
	0x50, 0x9b, 0xb8, 0x81, 0x40, 0xd9, 0xbe, 0x2b, 0xb9, 0x0e, 0x71, 0xfb, 0x7e, 0xe8, 0xba, 0xb6,
	0xdb, 0x2f, 0x13, 0x0f, 0xfb, 0x63, 0x42, 0x77, 0xa4, 0x10, 0x3f, 0x75, 0xc3, 0x5e, 0x99, 0xda,
	0x03, 0x1c, 0x50, 0x63, 0xe0, 0x49, 0x81, 0x2d, 0x29, 0xe0, 0x7b, 0x66, 0x39, 0xa0, 0x06, 0x0d,
	0xa5, 0x66, 0xf1, 0xa7, 0x04, 0x6c, 0x54, 0x85, 0x51, 0x7c, 0xce, 0x5c, 0xd4, 0xf0, 0x67, 0x21,
	0x0e, 0x28, 0xba, 0x05, 0x19, 0xdb, 0xf5, 0x42, 0xaa, 0x87, 0xbe, 0x5d, 0x50, 0x76, 0x95, 0xbd,
	0x8c, 0xb6, 0xc4, 0x09, 0x67, 0xbe, 0x8d, 0xee, 0xc2, 0x8a, 0x60, 0x9a, 0xc4, 0xa5, 0xd8, 0xa5,
	0x85, 0x05, 0x2e, 0xb0, 0xcc, 0x89, 0x35, 0x41, 0x43, 0x4f, 0x61, 0xa9, 0x87, 0x0d, 0x1a, 0xfa,
	0x38, 0x28, 0x24, 0x76, 0x93, 0x7b, 0xab, 0x95, 0x72, 0x69, 0xb6, 0x94, 0x94, 0xea, 0x42, 0x4f,
	0x1b, 0x02, 0xa0, 0xe7, 0xb0, 0x22, 0x12, 0xcd, 0x2d, 0xbe, 0xa0, 0x85, 0xe4, 0xae, 0xb2, 0x97,
	0xad, 0xbc, 0x33, 0x2b, 0x22, 0x8f, 0xad, 0x26, 0x74, 0xb5, 0xe5, 0xcb, 0xd8, 0x09, 0xed, 0x00,
	0x90, 0x90, 0x46, 0xa1, 0xa6, 0x78, 0x24, 0x19, 0x41, 0x61, 0xb1, 0xde, 0x81, 0xac, 0x43, 0x4c,
	0x9e, 0x6e, 0xdd, 0xb6, 0x0a, 0x69, 0xce, 0x87, 0x88, 0xd4, 0xb0, 0x8a, 0x7f, 0x24, 0x61, 0x39,
	0x0e, 0x8f, 0x4e, 0x60, 0x29, 0xc0, 0xfd, 0x01, 0x76, 0x69, 0x50, 0x50, 0x76, 0x93, 0x73, 0xbb,
	0xd9, 0x11, 0xca, 0xda, 0x10, 0x05, 0x39, 0xb0, 0xe1, 0x18, 0x5d, 0xec, 0xe8, 0x16, 0xa6, 0xd8,
	0xe4, 0xae, 0x0c, 0x88, 0x85, 0x0b, 0x89, 0x5d, 0x65, 0x6f, 0xb5, 0xf2, 0x70, 0x56, 0xf4, 0x26,
	0xc3, 0x38, 0x8c, 0x20, 0x8e, 0x89, 0x85, 0x35, 0xe4, 0x4c, 0xd1, 0xd0, 0x5b, 0xb0, 0x16, 0x88,
	0x26, 0x34, 0xfc, 0x97, 0xba, 0x69, 0x0c, 0xb0, 0x6f, 0xf0, 0x7c, 0x2f, 0x69, 0xf9, 0x11, 0xa3,
	0xc6, 0xe9, 0xa8, 0x02, 0x9b, 0x57, 0xb9, 0xe6, 0xc8, 0x44, 0xae, 0x4f, 0xe3, 0x3b, 0xe8, 0x6d,
	0xd8, 0xe8, 0x19, 0x26, 0x9e, 0x52, 0x11, 0xb9, 0x45, 0x8c, 0x37, 0xa1, 0xf1, 0x11, 0xdc, 0x0a,
	0x2e, 0x08, 0xd5, 0xcd, 0x0b, 0xc3, 0xed, 0x4f, 0x2b, 0x8a, 0xf6, 0x2b, 0x30, 0x91, 0x1a, 0x97,
	0xb8, 0x42, 0xdd, 0xe8, 0x61, 0x3d, 0xc0, 0x86, 0x6f, 0x5e, 0x4c, 0xa9, 0x2f, 0x4a, 0x75, 0xa3,
	0x87, 0x3b, 0x5c, 0x62, 0x5c, 0xbd, 0xd8, 0x95, 0x05, 0x96, 0x85, 0x41, 0xfb, 0x3c, 0x41, 0x3e,
	0xd5, 0xd9, 0x98, 0xe9, 0xa4, 0xd7, 0x0b, 0x30, 0xe5, 0x33, 0x92, 0xd4, 0x72, 0x9c, 0x71, 0x6a,
	0x0f, 0x70, 0x9b, 0x93, 0xd1, 0x3d, 0xc8, 0x61, 0xd7, 0x1a, 0x93, 0x4c, 0x70, 0xc9, 0x15, 0xec,
	0x5a, 0x23, 0xb9, 0xe2, 0xcf, 0x0a, 0xac, 0xf0, 0xfa, 0x34, 0x65, 0x67, 0xa1, 0x16, 0x2c, 0xca,
	0x06, 0xe0, 0xd8, 0xd7, 0xed, 0xa2, 0x08, 0x04, 0xbd, 0x0e, 0x60, 0x12, 0xb7, 0x67, 0x5b, 0x4c,
	0x96, 0x3b, 0x91, 0xd0, 0x62, 0x14, 0x74, 0x04, 0x69, 0x07, 0x5f, 0x62, 0x87, 0x97, 0x7a, 0xb5,
	0x52, 0x99, 0xab, 0xab, 0x9a, 0x4c, 0x53, 0x13, 0x00, 0xc5, 0xef, 0x15, 0xc8, 0x71, 0x6a, 0x75,
	0x78, 0x9d, 0xa1, 0x5d, 0xc8, 0x5a, 0x38, 0x30, 0x7d, 0xdb, 0x63, 0x47, 0x79, 0xa3, 0xc4, 0x49,
	0xec, 0x52, 0x71, 0x0c, 0xb7, 0x1f, 0x1a, 0x7d, 0xac, 0x9b, 0x51, 0x77, 0x67, 0xb4, 0xe5, 0x88,
	0x58, 0x63, 0xbd, 0xd9, 0x81, 0x4c, 0x34, 0x7a, 0x41, 0x21, 0xc9, 0x87, 0xeb, 0xdd, 0xf9, 0x1c,
	0x95, 0xda, 0xda, 0x08, 0xa7, 0xf8, 0x63, 0x12, 0x36, 0x3a, 0xc3, 0xe2, 0xc7, 0x9c, 0x3e, 0x82,
	0xb4, 0x61, 0x85, 0x8e, 0x28, 0xc0, 0x3c, 0x29, 0xb1, 0x3f, 0xc5, 0x8e, 0x7d, 0x41, 0x88, 0xa5,
	0x09, 0x00, 0x86, 0x14, 0x78, 0x84, 0xf4, 0xe4, 0xc8, 0x5e, 0x0b, 0x89, 0x03, 0xa0, 0x26, 0x2c,
	0x0e, 0xb0, 0x65, 0x9b, 0xc6, 0xfc, 0x85, 0x1a, 0x61, 0x45, 0x10, 0x0c, 0xed, 0xd2, 0x26, 0x0e,
	0x6b, 0xb2, 0xd4, 0xf5, 0xd1, 0x24, 0x04, 0xaa, 0x43, 0xca, 0x37, 0xcc, 0x97, 0x7c, 0x90, 0xaf,
	0x07, 0xc5, 0xf5, 0xd9, 0x9d, 0x1b, 0x1f, 0x98, 0x05, 0x3e, 0x30, 0x40, 0x47, 0xd3, 0x62, 0x40,
	0xf6, 0x80, 0x84, 0xae, 0x65, 0xbb, 0xfd, 0x03, 0xf2, 0x02, 0x21, 0x48, 0x39, 0xb8, 0x27, 0xca,
	0x94, 0xd6, 0xf8, 0x6f, 0xb4, 0x01, 0x69, 0xdf, 0xee, 0x5f, 0x88, 0x71, 0x4b, 0x6b, 0xe2, 0x80,
	0x6e, 0xc2, 0x42, 0x97, 0x50, 0x4a, 0x06, 0x3c, 0x79, 0x69, 0x4d, 0x9e, 0x50, 0x1e, 0x92, 0x94,
	0x78, 0x3c, 0x07, 0x69, 0x8d, 0xfd, 0x2c, 0x7e, 0xa5, 0xc0, 0x72, 0xdd, 0x30, 0xf1, 0x70, 0x1e,
	0xcf, 0x61, 0xb9, 0x2b, 0x6d, 0xea, 0x5d, 0xf2, 0x42, 0x0e, 0xe5, 0x83, 0x59, 0x83, 0x8c, 0xf9,
	0xab, 0x65, 0xbb, 0x31, 0xe7, 0x27, 0x82, 0x4d, 0x4c, 0x05, 0xfb, 0x9b, 0x02, 0xab, 0xcc, 0x93,
	0x58, 0x63, 0xde, 0x86, 0x0c, 0xbd, 0x08, 0x07, 0x5d, 0xd7, 0xb0, 0x1d, 0x39, 0x4b, 0x23, 0xc2,
	0xd8, 0x03, 0x94, 0xf8, 0x5f, 0x1e, 0x20, 0x6d, 0x7a, 0xec, 0x66, 0x86, 0x8c, 0x27, 0x31, 0x3e,
	0x75, 0x7f, 0x25, 0xe1, 0x26, 0x37, 0x37, 0x8a, 0x4b, 0xc3, 0x41, 0xe8, 0xd0, 0xe0, 0xdf, 0x97,
	0x0f, 0x0b, 0xd6, 0xc4, 0x8b, 0x13, 0x5b, 0x96, 0x64, 0x98, 0xef, 0xcf, 0x75, 0x15, 0xc4, 0xec,
	0xe6, 0x9d, 0x71, 0x42, 0x80, 0x0c, 0xc8, 0xf3, 0x37, 0x2a, 0x6e, 0x44, 0x04, 0xfe, 0xde, 0x3c,
	0x81, 0xc7, 0x6c, 0xe4, 0x7a, 0x63, 0xe7, 0x00, 0xe9, 0x90, 0xe7, 0x8f, 0x5a, 0xdc, 0x44, 0xea,
	0x3f, 0x94, 0x2b, 0xc7, 0xd0, 0xe2, 0x06, 0x28, 0x6c, 0xc5, 0x9f, 0xbd, 0xb8, 0x9d, 0x05, 0x6e,
	0xe7, 0xc3, 0x59, 0xed, 0x5c, 0x75, 0x3b, 0x6a, 0x9b, 0xc1, 0x15, 0xd4, 0x00, 0xed, 0x41, 0x1a,
	0xfb, 0x3e, 0xf1, 0xf9, 0x2d, 0x90, 0xad, 0xa0, 0xc8, 0x86, 0xef, 0x99, 0xa5, 0x0e, 0xdf, 0x3d,
	0x35, 0x21, 0x50, 0xfc, 0x52, 0x81, 0xcd, 0x89, 0xe5, 0x33, 0xf0, 0x88, 0x1b, 0x60, 0x34, 0x00,
	0x34, 0xf2, 0x56, 0xf7, 0x45, 0x5b, 0xc8, 0x65, 0xea, 0xe3, 0xb9, 0x92, 0x33, 0xd5, 0x5c, 0xda,
	0x9a, 0x31, 0x49, 0x2a, 0xfe, 0xae, 0xc0, 0xd6, 0x84, 0xf4, 0x89, 0x4f, 0xfa, 0x3e, 0x0e, 0x5e,
	0xd1, 0x8b, 0x6f, 0x42, 0xde, 0x93, 0x82, 0xba, 0x87, 0x7d, 0x93, 0xdd, 0xa3, 0xe2, 0xbe, 0xc9,
	0x45, 0xf4, 0x13, 0x41, 0x46, 0x1f, 0x00, 0x8c, 0x96, 0x06, 0xb9, 0xbe, 0x6e, 0x47, 0xa1, 0x44,
	0x8b, 0x7b, 0xe9, 0x34, 0x5a, 0xdc, 0xb5, 0xcc, 0x70, 0x93, 0x40, 0x8f, 0x20, 0x1b, 0x7a, 0x96,
	0x41, 0xb1, 0xd0, 0x4d, 0xbd, 0x52, 0x17, 0x84, 0x38, 0x23, 0x14, 0xbf, 0x9e, 0x4c, 0xf2, 0x30,
	0x32, 0x0f, 0xd6, 0x63, 0x49, 0x8e, 0xfc, 0x95, 0x59, 0x7e, 0x7c, 0xcd, 0x2c, 0x47, 0xe8, 0x5a,
	0xac, 0x80, 0x11, 0x6d, 0xff, 0x73, 0x05, 0x16, 0xe5, 0x6e, 0x8f, 0xb6, 0x60, 0xbd, 0xae, 0x56,
	0x4f, 0xcf, 0x34, 0x55, 0x3f, 0x6b, 0x75, 0x4e, 0xd4, 0x5a, 0xa3, 0xde, 0x50, 0x0f, 0xf3, 0x37,
	0xd0, 0x3a, 0xe4, 0x9a, 0xd5, 0x03, 0xb5, 0xa9, 0x1f, 0xaa, 0xa7, 0x6a, 0xed, 0xb4, 0xd1, 0x6e,
	0xe5, 0x15, 0x84, 0x60, 0xb5, 0x5e, 0xad, 0xa9, 0x31, 0x5a, 0x02, 0xbd, 0x06, 0x9b, 0x9d, 0xa3,
	0xf6, 0xa9, 0x5e, 0x3b, 0xaa, 0xb6, 0x9e, 0xc4, 0x59, 0x49, 0xce, 0xaa, 0xd6, 0x55, 0xbd, 0xa3,
	0x56, 0xb5, 0xda, 0x51, 0x8c, 0x95, 0xda, 0x77, 0x01, 0x46, 0x1b, 0x0b, 0xba, 0x05, 0x5b, 0xc2,
	0x58, 0x53, 0x3d, 0x57, 0x9b, 0x13, 0x9e, 0xe4, 0x20, 0x7b, 0xde, 0x38, 0x54, 0xdb, 0x82, 0x99,
	0x57, 0xd0, 0x1a, 0xac, 0x74, 0xd4, 0x27, 0xc7, 0x6a, 0xeb, 0x54, 0x92, 0x12, 0x68, 0x15, 0x80,
	0x3b, 0x21, 0xce, 0x49, 0xa6, 0x53, 0xd7, 0xaa, 0xc7, 0xaa, 0x24, 0xa4, 0xf6, 0x7d, 0x40, 0xd3,
	0x7b, 0x37, 0x7a, 0x03, 0x76, 0x27, 0x82, 0xd4, 0x8f, 0xdb, 0x87, 0x93, 0xa9, 0x58, 0x81, 0x0c,
	0x07, 0x67, 0xac, 0xbc, 0xc2, 0x6c, 0x09, 0x6c, 0x7e, 0x4e, 0xb0, 0x14, 0x72, 0x76, 0xb5, 0x75,
	0xa8, 0xc7, 0x18, 0xc9, 0x7d, 0x0c, 0x30, 0x7a, 0x53, 0x51, 0x16, 0x16, 0xcf, 0x5a, 0x4f, 0x5b,
	0xed, 0x67, 0xad, 0xfc, 0x0d, 0x16, 0xc2, 0xb9, 0xaa, 0x3d, 0xd7, 0xcf, 0x5a, 0xcd, 0xc6, 0x53,
	0xb5, 0xf9, 0x3c, 0xaf, 0xa0, 0x65, 0x58, 0x1a, 0x9e, 0x12, 0xec, 0x74, 0xd2, 0xee, 0x74, 0x1a,
	0x07, 0x4d, 0x35, 0x9f, 0x44, 0x00, 0x0b, 0x92, 0x93, 0xe2, 0xe9, 0x60, 0xaa, 0x92, 0x90, 0xae,
	0xfc, 0xa0, 0x40, 0x81, 0x97, 0xbf, 0x11, 0x6b, 0x8c, 0x0e, 0xf6, 0x2f, 0x6d, 0x13, 0xa3, 0x6f,
	0x14, 0x58, 0x19, 0xeb, 0x3b, 0x34, 0xf3, 0x6d, 0x73, 0xd5, 0x07, 0xe9, 0xf6, 0x4e, 0xa4, 0x1d,
	0xfb, 0x12, 0x2e, 0xb5, 0xa3, 0x2f, 0xe1, 0xe2, 0xdd, 0x2f, 0x7e, 0xfd, 0xf3, 0xdb, 0xc4, 0x4e,
	0xb1, 0x30, 0xfe, 0x61, 0x1e, 0x3c, 0x94, 0x6d, 0x88, 0x1f, 0x2a, 0xfb, 0x07, 0xbf, 0x28, 0xb0,
	0x6f, 0x92, 0xc1, 0x8c, 0x7e, 0x1c, 0xec, 0xfc, 0x53, 0x70, 0x27, 0x6c, 0xe4, 0x4e, 0x94, 0x4f,
	0x9e, 0x49, 0xa0, 0x3e, 0x61, 0x4b, 0x6a, 0x89, 0xf8, 0xfd, 0x72, 0x1f, 0xbb, 0x7c, 0x20, 0xcb,
	0x82, 0x65, 0x78, 0x76, 0xf0, 0xaa, 0xbf, 0x10, 0x1e, 0x4d, 0x71, 0xbe, 0x4b, 0xdc, 0x7b, 0x22,
	0x90, 0x6b, 0xdc, 0xc5, 0x29, 0x3f, 0x4a, 0xe7, 0xf7, 0x0f, 0x98, 0x6a, 0x77, 0x81, 0x1b, 0x7b,
	0xf0, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1d, 0xe8, 0xc8, 0xa8, 0xae, 0x10, 0x00, 0x00,
}
