// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/cloudprofiler/v2/profiler.proto

/*
Package cloudprofiler is a generated protocol buffer package.

It is generated from these files:
	google/devtools/cloudprofiler/v2/profiler.proto

It has these top-level messages:
	CreateProfileRequest
	UpdateProfileRequest
	Profile
	Deployment
*/
package cloudprofiler

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/duration"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// ProfileType is type of profiling data.
// NOTE: the enumeration member names are used (in lowercase) as unique string
// identifiers of profile types, so they must not be renamed.
type ProfileType int32

const (
	// Unspecified profile type.
	ProfileType_PROFILE_TYPE_UNSPECIFIED ProfileType = 0
	// Thread CPU time sampling.
	ProfileType_CPU ProfileType = 1
	// Wallclock time sampling. More expensive as stops all threads.
	ProfileType_WALL ProfileType = 2
	// Heap allocation sampling.
	ProfileType_HEAP ProfileType = 3
	// Single-shot collection of all thread stacks.
	ProfileType_THREADS ProfileType = 4
	// Synchronization contention profile.
	ProfileType_CONTENTION ProfileType = 5
)

var ProfileType_name = map[int32]string{
	0: "PROFILE_TYPE_UNSPECIFIED",
	1: "CPU",
	2: "WALL",
	3: "HEAP",
	4: "THREADS",
	5: "CONTENTION",
}
var ProfileType_value = map[string]int32{
	"PROFILE_TYPE_UNSPECIFIED": 0,
	"CPU":        1,
	"WALL":       2,
	"HEAP":       3,
	"THREADS":    4,
	"CONTENTION": 5,
}

func (x ProfileType) String() string {
	return proto.EnumName(ProfileType_name, int32(x))
}
func (ProfileType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// CreateProfileRequest describes a profile resource creation request.
// Deployment field must be populated for both online and offline modes.
// For the online mode, profile field is not set and the profile_type specifies
// the list of profile types supported by the agent. The creation call will hang
// until a profile of one of these types needs to be collected. For offline
// mode, profile field must be set, profile_type must be empty, and deployment
// field must be identical to the deployment in the profile.
type CreateProfileRequest struct {
	// Deployment details.
	Deployment *Deployment `protobuf:"bytes,1,opt,name=deployment" json:"deployment,omitempty"`
	// Online mode: One or more profile types that the agent is capable of
	// providing.
	ProfileType []ProfileType `protobuf:"varint,2,rep,packed,name=profile_type,json=profileType,enum=google.devtools.cloudprofiler.v2.ProfileType" json:"profile_type,omitempty"`
	// Offline mode: Contents of the profile to create.
	Profile *Profile `protobuf:"bytes,3,opt,name=profile" json:"profile,omitempty"`
}

func (m *CreateProfileRequest) Reset()                    { *m = CreateProfileRequest{} }
func (m *CreateProfileRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateProfileRequest) ProtoMessage()               {}
func (*CreateProfileRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *CreateProfileRequest) GetDeployment() *Deployment {
	if m != nil {
		return m.Deployment
	}
	return nil
}

func (m *CreateProfileRequest) GetProfileType() []ProfileType {
	if m != nil {
		return m.ProfileType
	}
	return nil
}

func (m *CreateProfileRequest) GetProfile() *Profile {
	if m != nil {
		return m.Profile
	}
	return nil
}

// UpdateProfileRequest contains the profile to update.
type UpdateProfileRequest struct {
	// Profile to update
	Profile *Profile `protobuf:"bytes,1,opt,name=profile" json:"profile,omitempty"`
}

func (m *UpdateProfileRequest) Reset()                    { *m = UpdateProfileRequest{} }
func (m *UpdateProfileRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateProfileRequest) ProtoMessage()               {}
func (*UpdateProfileRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *UpdateProfileRequest) GetProfile() *Profile {
	if m != nil {
		return m.Profile
	}
	return nil
}

// Profile resource.
type Profile struct {
	// Opaque, server-assigned, unique ID for this profile.
	// Output only.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Type of profile.
	// Input (for the offline mode) or output (for the online mode).
	ProfileType ProfileType `protobuf:"varint,2,opt,name=profile_type,json=profileType,enum=google.devtools.cloudprofiler.v2.ProfileType" json:"profile_type,omitempty"`
	// Deployment this profile corresponds to.
	Deployment *Deployment `protobuf:"bytes,3,opt,name=deployment" json:"deployment,omitempty"`
	// Duration of the profiling session.
	// Input (for the offline mode) or output (for the online mode).
	// The field represents requested profiling duration. It may slightly differ
	// from the effective profiling duration, which is recorded in the profile
	// data, in case the profiling can't be stopped immediately (e.g. in case
	// stopping the profiling is handled asynchronously).
	Duration *google_protobuf1.Duration `protobuf:"bytes,4,opt,name=duration" json:"duration,omitempty"`
	// Profile bytes, as a gzip compressed serialized proto, the format is
	// https://github.com/google/pprof/blob/master/proto/profile.proto.
	ProfileBytes []byte `protobuf:"bytes,5,opt,name=profile_bytes,json=profileBytes,proto3" json:"profile_bytes,omitempty"`
	// Labels associated to this specific profile. These labels will get merged
	// with the deployment labels for the final data set.
	// See documentation on deployment labels for validation rules and limits.
	// Input only, will not be populated on responses.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Profile) Reset()                    { *m = Profile{} }
func (m *Profile) String() string            { return proto.CompactTextString(m) }
func (*Profile) ProtoMessage()               {}
func (*Profile) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Profile) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Profile) GetProfileType() ProfileType {
	if m != nil {
		return m.ProfileType
	}
	return ProfileType_PROFILE_TYPE_UNSPECIFIED
}

func (m *Profile) GetDeployment() *Deployment {
	if m != nil {
		return m.Deployment
	}
	return nil
}

func (m *Profile) GetDuration() *google_protobuf1.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *Profile) GetProfileBytes() []byte {
	if m != nil {
		return m.ProfileBytes
	}
	return nil
}

func (m *Profile) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Deployment contains the deployment identification information.
type Deployment struct {
	// Project ID is the ID of a cloud project.
	// Validation regex: `^[a-z][-a-z0-9:.]{4,61}[a-z0-9]$`.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Target is the service name used to group related deployments:
	// * Service name for GAE Flex / Standard.
	// * Cluster and container name for GKE.
	// * User-specified string for direct GCE profiling (e.g. Java).
	// * Job name for Dataflow.
	// Validation regex: `^[a-z]([-a-z0-9_.]{0,253}[a-z0-9])?$`.
	Target string `protobuf:"bytes,2,opt,name=target" json:"target,omitempty"`
	// Labels identify the deployment within the user universe and same target.
	// Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
	// Value for an individual label must be <= 512 bytes, the total
	// size of all label names and values must be <= 1024 bytes.
	//
	// Either "zone" or "region" label must be present describing the deployment
	// location. An example of a zone is "us-central1-a", an example of a region
	// is "us-central1" or "us-central".
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Deployment) Reset()                    { *m = Deployment{} }
func (m *Deployment) String() string            { return proto.CompactTextString(m) }
func (*Deployment) ProtoMessage()               {}
func (*Deployment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Deployment) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Deployment) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *Deployment) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateProfileRequest)(nil), "google.devtools.cloudprofiler.v2.CreateProfileRequest")
	proto.RegisterType((*UpdateProfileRequest)(nil), "google.devtools.cloudprofiler.v2.UpdateProfileRequest")
	proto.RegisterType((*Profile)(nil), "google.devtools.cloudprofiler.v2.Profile")
	proto.RegisterType((*Deployment)(nil), "google.devtools.cloudprofiler.v2.Deployment")
	proto.RegisterEnum("google.devtools.cloudprofiler.v2.ProfileType", ProfileType_name, ProfileType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ProfilerService service

type ProfilerServiceClient interface {
	// CreateProfile creates a new profile resource.
	//
	// In the online creation mode:
	// * The server ensures that the new profiles are created at a constant rate
	//   per deployment, so the creation request may hang for some time until the
	//   next profile session is available.
	// * The request may fail with ABORTED error if the creation is not
	//   available within ~1m, the response will indicate the duration of the
	//   backoff the client should take before attempting creating a profile
	//   again. The backoff duration is returned in google.rpc.RetryInfo extension
	//   on the response status. To a gRPC client, the extension will be return as
	//   a binary-serialized proto in the trailing metadata item named
	//   "google.rpc.retryinfo-bin".
	//
	// In the offline creation mode:
	// * The client provides the profile to create along with the profile bytes,
	//   the server records it.
	CreateProfile(ctx context.Context, in *CreateProfileRequest, opts ...grpc.CallOption) (*Profile, error)
	// UpdateProfile updates the profile bytes and labels on the profile resource
	// created in the online mode.
	UpdateProfile(ctx context.Context, in *UpdateProfileRequest, opts ...grpc.CallOption) (*Profile, error)
}

type profilerServiceClient struct {
	cc *grpc.ClientConn
}

func NewProfilerServiceClient(cc *grpc.ClientConn) ProfilerServiceClient {
	return &profilerServiceClient{cc}
}

func (c *profilerServiceClient) CreateProfile(ctx context.Context, in *CreateProfileRequest, opts ...grpc.CallOption) (*Profile, error) {
	out := new(Profile)
	err := grpc.Invoke(ctx, "/google.devtools.cloudprofiler.v2.ProfilerService/CreateProfile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *profilerServiceClient) UpdateProfile(ctx context.Context, in *UpdateProfileRequest, opts ...grpc.CallOption) (*Profile, error) {
	out := new(Profile)
	err := grpc.Invoke(ctx, "/google.devtools.cloudprofiler.v2.ProfilerService/UpdateProfile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ProfilerService service

type ProfilerServiceServer interface {
	// CreateProfile creates a new profile resource.
	//
	// In the online creation mode:
	// * The server ensures that the new profiles are created at a constant rate
	//   per deployment, so the creation request may hang for some time until the
	//   next profile session is available.
	// * The request may fail with ABORTED error if the creation is not
	//   available within ~1m, the response will indicate the duration of the
	//   backoff the client should take before attempting creating a profile
	//   again. The backoff duration is returned in google.rpc.RetryInfo extension
	//   on the response status. To a gRPC client, the extension will be return as
	//   a binary-serialized proto in the trailing metadata item named
	//   "google.rpc.retryinfo-bin".
	//
	// In the offline creation mode:
	// * The client provides the profile to create along with the profile bytes,
	//   the server records it.
	CreateProfile(context.Context, *CreateProfileRequest) (*Profile, error)
	// UpdateProfile updates the profile bytes and labels on the profile resource
	// created in the online mode.
	UpdateProfile(context.Context, *UpdateProfileRequest) (*Profile, error)
}

func RegisterProfilerServiceServer(s *grpc.Server, srv ProfilerServiceServer) {
	s.RegisterService(&_ProfilerService_serviceDesc, srv)
}

func _ProfilerService_CreateProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfilerServiceServer).CreateProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudprofiler.v2.ProfilerService/CreateProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfilerServiceServer).CreateProfile(ctx, req.(*CreateProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProfilerService_UpdateProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProfilerServiceServer).UpdateProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudprofiler.v2.ProfilerService/UpdateProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProfilerServiceServer).UpdateProfile(ctx, req.(*UpdateProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProfilerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudprofiler.v2.ProfilerService",
	HandlerType: (*ProfilerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateProfile",
			Handler:    _ProfilerService_CreateProfile_Handler,
		},
		{
			MethodName: "UpdateProfile",
			Handler:    _ProfilerService_UpdateProfile_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/cloudprofiler/v2/profiler.proto",
}

func init() { proto.RegisterFile("google/devtools/cloudprofiler/v2/profiler.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 576 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0x51, 0x8f, 0xd2, 0x40,
	0x10, 0xb6, 0x57, 0x0e, 0x8e, 0xe9, 0xdd, 0xd9, 0x6c, 0x88, 0xa9, 0xe4, 0x34, 0x04, 0x5f, 0xd0,
	0x68, 0x9b, 0xd4, 0x9c, 0x39, 0xf5, 0x89, 0x83, 0x5e, 0x8e, 0x84, 0x83, 0x66, 0x81, 0x18, 0xf5,
	0x81, 0x14, 0xba, 0xd7, 0x54, 0x7b, 0xdd, 0xba, 0x5d, 0x48, 0xfa, 0x7b, 0xfc, 0x43, 0xfe, 0x1d,
	0xe3, 0x8b, 0xa1, 0xdd, 0x72, 0x10, 0x31, 0x70, 0x9e, 0x6f, 0x33, 0xb3, 0xf3, 0x7d, 0xb3, 0xf3,
	0xed, 0xce, 0x80, 0xe1, 0x51, 0xea, 0x05, 0xc4, 0x70, 0xc9, 0x9c, 0x53, 0x1a, 0xc4, 0xc6, 0x34,
	0xa0, 0x33, 0x37, 0x62, 0xf4, 0xda, 0x0f, 0x08, 0x33, 0xe6, 0xa6, 0x91, 0xdb, 0x7a, 0xc4, 0x28,
	0xa7, 0xa8, 0x96, 0x01, 0xf4, 0x1c, 0xa0, 0xaf, 0x01, 0xf4, 0xb9, 0x59, 0x3d, 0x11, 0x94, 0x4e,
	0xe4, 0x1b, 0x4e, 0x18, 0x52, 0xee, 0x70, 0x9f, 0x86, 0x71, 0x86, 0xaf, 0x3e, 0x15, 0xa7, 0xa9,
	0x37, 0x99, 0x5d, 0x1b, 0xee, 0x8c, 0xa5, 0x09, 0xd9, 0x79, 0xfd, 0x97, 0x04, 0x95, 0x16, 0x23,
	0x0e, 0x27, 0x76, 0xc6, 0x89, 0xc9, 0xb7, 0x19, 0x89, 0x39, 0xea, 0x02, 0xb8, 0x24, 0x0a, 0x68,
	0x72, 0x43, 0x42, 0xae, 0x49, 0x35, 0xa9, 0xa1, 0x98, 0x2f, 0xf5, 0x6d, 0xb7, 0xd1, 0xdb, 0x4b,
	0x0c, 0x5e, 0xc1, 0x23, 0x1b, 0x0e, 0x45, 0xd6, 0x98, 0x27, 0x11, 0xd1, 0xf6, 0x6a, 0x72, 0xe3,
	0xd8, 0x7c, 0xb5, 0x9d, 0x4f, 0xdc, 0x6a, 0x98, 0x44, 0x04, 0x2b, 0xd1, 0xad, 0x83, 0x5a, 0x50,
	0x12, 0xae, 0x26, 0xa7, 0x97, 0x7b, 0xbe, 0x33, 0x19, 0xce, 0x91, 0xf5, 0xcf, 0x50, 0x19, 0x45,
	0xee, 0x9f, 0xcd, 0xaf, 0x90, 0x4b, 0xff, 0x4c, 0xfe, 0x5d, 0x86, 0x92, 0x08, 0x22, 0x04, 0x85,
	0xd0, 0xb9, 0xc9, 0xd8, 0xca, 0x38, 0xb5, 0x37, 0x68, 0x22, 0xdd, 0x53, 0x93, 0xf5, 0x37, 0x93,
	0xef, 0xf9, 0x66, 0xa7, 0x70, 0x90, 0x7f, 0x16, 0xad, 0x90, 0x72, 0x3d, 0xce, 0xb9, 0xf2, 0xdf,
	0xa4, 0xb7, 0x45, 0x02, 0x5e, 0xa6, 0xa2, 0x67, 0x70, 0x94, 0xb7, 0x35, 0x49, 0x38, 0x89, 0xb5,
	0xfd, 0x9a, 0xd4, 0x38, 0xc4, 0x79, 0xaf, 0xe7, 0x8b, 0x18, 0xba, 0x82, 0x62, 0xe0, 0x4c, 0x48,
	0x10, 0x6b, 0xc5, 0x9a, 0xdc, 0x50, 0xcc, 0xd3, 0x9d, 0xbb, 0xd6, 0xbb, 0x29, 0xce, 0x0a, 0x39,
	0x4b, 0xb0, 0x20, 0xa9, 0xbe, 0x05, 0x65, 0x25, 0x8c, 0x54, 0x90, 0xbf, 0x92, 0x44, 0x88, 0xbd,
	0x30, 0x51, 0x05, 0xf6, 0xe7, 0x4e, 0x30, 0xcb, 0x44, 0x2e, 0xe3, 0xcc, 0x79, 0xb7, 0x77, 0x26,
	0xd5, 0x7f, 0x48, 0x00, 0xb7, 0x02, 0xa0, 0x27, 0x00, 0x11, 0xa3, 0x5f, 0xc8, 0x94, 0x8f, 0x7d,
	0x57, 0x30, 0x94, 0x45, 0xa4, 0xe3, 0xa2, 0x47, 0x50, 0xe4, 0x0e, 0xf3, 0x08, 0x17, 0x44, 0xc2,
	0x43, 0xf6, 0xb2, 0x1f, 0x39, 0xed, 0xe7, 0xec, 0x2e, 0xaa, 0xff, 0xe7, 0x96, 0x5e, 0x10, 0x50,
	0x56, 0xbe, 0x08, 0x3a, 0x01, 0xcd, 0xc6, 0xfd, 0x8b, 0x4e, 0xd7, 0x1a, 0x0f, 0x3f, 0xda, 0xd6,
	0x78, 0xd4, 0x1b, 0xd8, 0x56, 0xab, 0x73, 0xd1, 0xb1, 0xda, 0xea, 0x03, 0x54, 0x02, 0xb9, 0x65,
	0x8f, 0x54, 0x09, 0x1d, 0x40, 0xe1, 0x43, 0xb3, 0xdb, 0x55, 0xf7, 0x16, 0xd6, 0xa5, 0xd5, 0xb4,
	0x55, 0x19, 0x29, 0x50, 0x1a, 0x5e, 0x62, 0xab, 0xd9, 0x1e, 0xa8, 0x05, 0x74, 0x0c, 0xd0, 0xea,
	0xf7, 0x86, 0x56, 0x6f, 0xd8, 0xe9, 0xf7, 0xd4, 0x7d, 0xf3, 0xa7, 0x04, 0x0f, 0x45, 0x1d, 0x36,
	0x20, 0x6c, 0xee, 0x4f, 0x09, 0x62, 0x70, 0xb4, 0xb6, 0x4d, 0xd0, 0x9b, 0xed, 0x42, 0x6c, 0x5a,
	0x3f, 0xd5, 0xdd, 0x07, 0x6e, 0x51, 0x73, 0x6d, 0x88, 0x77, 0xa9, 0xb9, 0x69, 0xea, 0xef, 0x50,
	0xf3, 0xbc, 0xff, 0xe9, 0x4a, 0xe4, 0x7a, 0x34, 0x70, 0x42, 0x4f, 0xa7, 0xcc, 0x33, 0x3c, 0x12,
	0xa6, 0x83, 0x21, 0x96, 0xbc, 0x13, 0xf9, 0xf1, 0xdf, 0x17, 0xfd, 0xfb, 0xb5, 0xc0, 0xa4, 0x98,
	0x22, 0x5f, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x6c, 0x53, 0xd3, 0x90, 0x21, 0x06, 0x00, 0x00,
}
