// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/vision/v1/web_detection.proto

package vision

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Relevant information for the image from the Internet.
type WebDetection struct {
	// Deduced entities from similar images on the Internet.
	WebEntities []*WebDetection_WebEntity `protobuf:"bytes,1,rep,name=web_entities,json=webEntities" json:"web_entities,omitempty"`
	// Fully matching images from the Internet.
	// They're definite neardups and most often a copy of the query image with
	// merely a size change.
	FullMatchingImages []*WebDetection_WebImage `protobuf:"bytes,2,rep,name=full_matching_images,json=fullMatchingImages" json:"full_matching_images,omitempty"`
	// Partial matching images from the Internet.
	// Those images are similar enough to share some key-point features. For
	// example an original image will likely have partial matching for its crops.
	PartialMatchingImages []*WebDetection_WebImage `protobuf:"bytes,3,rep,name=partial_matching_images,json=partialMatchingImages" json:"partial_matching_images,omitempty"`
	// Web pages containing the matching images from the Internet.
	PagesWithMatchingImages []*WebDetection_WebPage `protobuf:"bytes,4,rep,name=pages_with_matching_images,json=pagesWithMatchingImages" json:"pages_with_matching_images,omitempty"`
}

func (m *WebDetection) Reset()                    { *m = WebDetection{} }
func (m *WebDetection) String() string            { return proto.CompactTextString(m) }
func (*WebDetection) ProtoMessage()               {}
func (*WebDetection) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *WebDetection) GetWebEntities() []*WebDetection_WebEntity {
	if m != nil {
		return m.WebEntities
	}
	return nil
}

func (m *WebDetection) GetFullMatchingImages() []*WebDetection_WebImage {
	if m != nil {
		return m.FullMatchingImages
	}
	return nil
}

func (m *WebDetection) GetPartialMatchingImages() []*WebDetection_WebImage {
	if m != nil {
		return m.PartialMatchingImages
	}
	return nil
}

func (m *WebDetection) GetPagesWithMatchingImages() []*WebDetection_WebPage {
	if m != nil {
		return m.PagesWithMatchingImages
	}
	return nil
}

// Entity deduced from similar images on the Internet.
type WebDetection_WebEntity struct {
	// Opaque entity ID.
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId" json:"entity_id,omitempty"`
	// Overall relevancy score for the entity.
	// Not normalized and not comparable across different image queries.
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
	// Canonical description of the entity, in English.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
}

func (m *WebDetection_WebEntity) Reset()                    { *m = WebDetection_WebEntity{} }
func (m *WebDetection_WebEntity) String() string            { return proto.CompactTextString(m) }
func (*WebDetection_WebEntity) ProtoMessage()               {}
func (*WebDetection_WebEntity) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 0} }

func (m *WebDetection_WebEntity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *WebDetection_WebEntity) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *WebDetection_WebEntity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Metadata for online images.
type WebDetection_WebImage struct {
	// The result image URL.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	// Overall relevancy score for the image.
	// Not normalized and not comparable across different image queries.
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
}

func (m *WebDetection_WebImage) Reset()                    { *m = WebDetection_WebImage{} }
func (m *WebDetection_WebImage) String() string            { return proto.CompactTextString(m) }
func (*WebDetection_WebImage) ProtoMessage()               {}
func (*WebDetection_WebImage) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 1} }

func (m *WebDetection_WebImage) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *WebDetection_WebImage) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

// Metadata for web pages.
type WebDetection_WebPage struct {
	// The result web page URL.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	// Overall relevancy score for the web page.
	// Not normalized and not comparable across different image queries.
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
}

func (m *WebDetection_WebPage) Reset()                    { *m = WebDetection_WebPage{} }
func (m *WebDetection_WebPage) String() string            { return proto.CompactTextString(m) }
func (*WebDetection_WebPage) ProtoMessage()               {}
func (*WebDetection_WebPage) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 2} }

func (m *WebDetection_WebPage) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *WebDetection_WebPage) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func init() {
	proto.RegisterType((*WebDetection)(nil), "google.cloud.vision.v1.WebDetection")
	proto.RegisterType((*WebDetection_WebEntity)(nil), "google.cloud.vision.v1.WebDetection.WebEntity")
	proto.RegisterType((*WebDetection_WebImage)(nil), "google.cloud.vision.v1.WebDetection.WebImage")
	proto.RegisterType((*WebDetection_WebPage)(nil), "google.cloud.vision.v1.WebDetection.WebPage")
}

func init() { proto.RegisterFile("google/cloud/vision/v1/web_detection.proto", fileDescriptor3) }

var fileDescriptor3 = []byte{
	// 383 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x93, 0x41, 0x4f, 0xea, 0x40,
	0x14, 0x85, 0x53, 0xca, 0x7b, 0x0f, 0x06, 0x16, 0xcf, 0x09, 0x4a, 0x53, 0x5d, 0x34, 0xae, 0x88,
	0xd1, 0x69, 0xc0, 0xa5, 0xae, 0x88, 0x2e, 0x58, 0x98, 0x60, 0x37, 0x24, 0x6e, 0xea, 0xd0, 0x8e,
	0xc3, 0x4d, 0xca, 0x4c, 0xd3, 0x19, 0x20, 0xfc, 0x58, 0xff, 0x87, 0x4b, 0x33, 0xd3, 0x62, 0x10,
	0x30, 0x21, 0xee, 0xee, 0xdc, 0x9e, 0xf3, 0x9d, 0xf6, 0xf6, 0x0e, 0xba, 0xe2, 0x52, 0xf2, 0x8c,
	0x85, 0x49, 0x26, 0x17, 0x69, 0xb8, 0x04, 0x05, 0x52, 0x84, 0xcb, 0x7e, 0xb8, 0x62, 0xd3, 0x38,
	0x65, 0x9a, 0x25, 0x1a, 0xa4, 0x20, 0x79, 0x21, 0xb5, 0xc4, 0x67, 0xa5, 0x96, 0x58, 0x2d, 0x29,
	0xb5, 0x64, 0xd9, 0xf7, 0x2f, 0x2a, 0x06, 0xcd, 0x21, 0xa4, 0x42, 0x48, 0x4d, 0x8d, 0x49, 0x95,
	0xae, 0xcb, 0xf7, 0x3a, 0x6a, 0x4f, 0xd8, 0xf4, 0x61, 0x03, 0xc3, 0xcf, 0xa8, 0x6d, 0xe8, 0x4c,
	0x68, 0xd0, 0xc0, 0x94, 0xe7, 0x04, 0x6e, 0xaf, 0x35, 0x20, 0xe4, 0x30, 0x9d, 0x6c, 0x7b, 0xcd,
	0xe1, 0xd1, 0xf8, 0xd6, 0x51, 0x6b, 0x55, 0x95, 0xc0, 0x14, 0x8e, 0x51, 0xe7, 0x6d, 0x91, 0x65,
	0xf1, 0x9c, 0xea, 0x64, 0x06, 0x82, 0xc7, 0x30, 0xa7, 0x9c, 0x29, 0xaf, 0x66, 0xd1, 0x37, 0xc7,
	0xa2, 0x47, 0xc6, 0x15, 0x61, 0x83, 0x7a, 0xaa, 0x48, 0xb6, 0xa5, 0x30, 0x43, 0xdd, 0x9c, 0x16,
	0x1a, 0xe8, 0x7e, 0x86, 0xfb, 0x9b, 0x8c, 0xd3, 0x8a, 0xb6, 0x13, 0x03, 0xc8, 0xcf, 0x4d, 0x11,
	0xaf, 0x40, 0xcf, 0xf6, 0x92, 0xea, 0x36, 0xe9, 0xfa, 0xd8, 0xa4, 0xb1, 0x09, 0xea, 0x5a, 0xde,
	0x04, 0xf4, 0xec, 0x7b, 0x94, 0xff, 0x8a, 0x9a, 0x5f, 0xc3, 0xc4, 0xe7, 0xa8, 0x69, 0x7f, 0xc7,
	0x3a, 0x86, 0xd4, 0x73, 0x02, 0xa7, 0xd7, 0x8c, 0x1a, 0x65, 0x63, 0x94, 0xe2, 0x0e, 0xfa, 0xa3,
	0x12, 0x59, 0x30, 0xaf, 0x16, 0x38, 0xbd, 0x5a, 0x54, 0x1e, 0x70, 0x80, 0x5a, 0x29, 0x53, 0x49,
	0x01, 0xb9, 0xc9, 0xf3, 0x5c, 0x6b, 0xda, 0x6e, 0xf9, 0x03, 0xd4, 0xd8, 0x7c, 0x2f, 0xfe, 0x8f,
	0xdc, 0x45, 0x91, 0x55, 0x68, 0x53, 0x1e, 0xa6, 0xfa, 0x7d, 0xf4, 0xaf, 0x7a, 0xf3, 0x63, 0x2d,
	0xc3, 0x02, 0xf9, 0x89, 0x9c, 0xff, 0x30, 0x94, 0xe1, 0xc9, 0xf6, 0x54, 0xc6, 0x66, 0x21, 0xc7,
	0xce, 0xcb, 0x7d, 0x25, 0xe6, 0x32, 0xa3, 0x82, 0x13, 0x59, 0xf0, 0x90, 0x33, 0x61, 0xd7, 0x35,
	0x2c, 0x1f, 0xd1, 0x1c, 0xd4, 0xee, 0x9d, 0xb8, 0x2b, 0xab, 0x0f, 0xc7, 0x99, 0xfe, 0xb5, 0xda,
	0xdb, 0xcf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x66, 0xd9, 0xde, 0x3f, 0x3e, 0x03, 0x00, 0x00,
}
