// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	operatorv1 "github.com/openshift/api/operator/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeEtcds implements EtcdInterface
type FakeEtcds struct {
	Fake *FakeOperatorV1
}

var etcdsResource = schema.GroupVersionResource{Group: "operator.openshift.io", Version: "v1", Resource: "etcds"}

var etcdsKind = schema.GroupVersionKind{Group: "operator.openshift.io", Version: "v1", Kind: "Etcd"}

// Get takes name of the etcd, and returns the corresponding etcd object, and an error if there is any.
func (c *FakeEtcds) Get(ctx context.Context, name string, options v1.GetOptions) (result *operatorv1.Etcd, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(etcdsResource, name), &operatorv1.Etcd{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operatorv1.Etcd), err
}

// List takes label and field selectors, and returns the list of Etcds that match those selectors.
func (c *FakeEtcds) List(ctx context.Context, opts v1.ListOptions) (result *operatorv1.EtcdList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(etcdsResource, etcdsKind, opts), &operatorv1.EtcdList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &operatorv1.EtcdList{ListMeta: obj.(*operatorv1.EtcdList).ListMeta}
	for _, item := range obj.(*operatorv1.EtcdList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested etcds.
func (c *FakeEtcds) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(etcdsResource, opts))
}

// Create takes the representation of a etcd and creates it.  Returns the server's representation of the etcd, and an error, if there is any.
func (c *FakeEtcds) Create(ctx context.Context, etcd *operatorv1.Etcd, opts v1.CreateOptions) (result *operatorv1.Etcd, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(etcdsResource, etcd), &operatorv1.Etcd{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operatorv1.Etcd), err
}

// Update takes the representation of a etcd and updates it. Returns the server's representation of the etcd, and an error, if there is any.
func (c *FakeEtcds) Update(ctx context.Context, etcd *operatorv1.Etcd, opts v1.UpdateOptions) (result *operatorv1.Etcd, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(etcdsResource, etcd), &operatorv1.Etcd{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operatorv1.Etcd), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeEtcds) UpdateStatus(ctx context.Context, etcd *operatorv1.Etcd, opts v1.UpdateOptions) (*operatorv1.Etcd, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(etcdsResource, "status", etcd), &operatorv1.Etcd{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operatorv1.Etcd), err
}

// Delete takes name of the etcd and deletes it. Returns an error if one occurs.
func (c *FakeEtcds) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(etcdsResource, name), &operatorv1.Etcd{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeEtcds) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(etcdsResource, listOpts)

	_, err := c.Fake.Invokes(action, &operatorv1.EtcdList{})
	return err
}

// Patch applies the patch and returns the patched etcd.
func (c *FakeEtcds) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *operatorv1.Etcd, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(etcdsResource, name, pt, data, subresources...), &operatorv1.Etcd{})
	if obj == nil {
		return nil, err
	}
	return obj.(*operatorv1.Etcd), err
}
