// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/spanner/v1/spanner.proto

package spanner

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf4 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf1 "github.com/golang/protobuf/ptypes/struct"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Mode in which the query must be processed.
type ExecuteSqlRequest_QueryMode int32

const (
	// The default mode where only the query result, without any information
	// about the query plan is returned.
	ExecuteSqlRequest_NORMAL ExecuteSqlRequest_QueryMode = 0
	// This mode returns only the query plan, without any result rows or
	// execution statistics information.
	ExecuteSqlRequest_PLAN ExecuteSqlRequest_QueryMode = 1
	// This mode returns both the query plan and the execution statistics along
	// with the result rows.
	ExecuteSqlRequest_PROFILE ExecuteSqlRequest_QueryMode = 2
)

var ExecuteSqlRequest_QueryMode_name = map[int32]string{
	0: "NORMAL",
	1: "PLAN",
	2: "PROFILE",
}
var ExecuteSqlRequest_QueryMode_value = map[string]int32{
	"NORMAL":  0,
	"PLAN":    1,
	"PROFILE": 2,
}

func (x ExecuteSqlRequest_QueryMode) String() string {
	return proto.EnumName(ExecuteSqlRequest_QueryMode_name, int32(x))
}
func (ExecuteSqlRequest_QueryMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor4, []int{4, 0}
}

// The request for [CreateSession][google.spanner.v1.Spanner.CreateSession].
type CreateSessionRequest struct {
	// Required. The database in which the new session is created.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
}

func (m *CreateSessionRequest) Reset()                    { *m = CreateSessionRequest{} }
func (m *CreateSessionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateSessionRequest) ProtoMessage()               {}
func (*CreateSessionRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{0} }

func (m *CreateSessionRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

// A session in the Cloud Spanner API.
type Session struct {
	// Required. The name of the session.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *Session) Reset()                    { *m = Session{} }
func (m *Session) String() string            { return proto.CompactTextString(m) }
func (*Session) ProtoMessage()               {}
func (*Session) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{1} }

func (m *Session) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [GetSession][google.spanner.v1.Spanner.GetSession].
type GetSessionRequest struct {
	// Required. The name of the session to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetSessionRequest) Reset()                    { *m = GetSessionRequest{} }
func (m *GetSessionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSessionRequest) ProtoMessage()               {}
func (*GetSessionRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{2} }

func (m *GetSessionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [DeleteSession][google.spanner.v1.Spanner.DeleteSession].
type DeleteSessionRequest struct {
	// Required. The name of the session to delete.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteSessionRequest) Reset()                    { *m = DeleteSessionRequest{} }
func (m *DeleteSessionRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSessionRequest) ProtoMessage()               {}
func (*DeleteSessionRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{3} }

func (m *DeleteSessionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql].
type ExecuteSqlRequest struct {
	// Required. The session in which the SQL query should be performed.
	Session string `protobuf:"bytes,1,opt,name=session" json:"session,omitempty"`
	// The transaction to use. If none is provided, the default is a
	// temporary read-only transaction with strong concurrency.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction" json:"transaction,omitempty"`
	// Required. The SQL query string.
	Sql string `protobuf:"bytes,3,opt,name=sql" json:"sql,omitempty"`
	// The SQL query string can contain parameter placeholders. A parameter
	// placeholder consists of `'@'` followed by the parameter
	// name. Parameter names consist of any combination of letters,
	// numbers, and underscores.
	//
	// Parameters can appear anywhere that a literal value is expected.  The same
	// parameter name can be used more than once, for example:
	//   `"WHERE id > @msg_id AND id < @msg_id + 100"`
	//
	// It is an error to execute an SQL query with unbound parameters.
	//
	// Parameter values are specified using `params`, which is a JSON
	// object whose keys are parameter names, and whose values are the
	// corresponding parameter values.
	Params *google_protobuf1.Struct `protobuf:"bytes,4,opt,name=params" json:"params,omitempty"`
	// It is not always possible for Cloud Spanner to infer the right SQL type
	// from a JSON value.  For example, values of type `BYTES` and values
	// of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
	//
	// In these cases, `param_types` can be used to specify the exact
	// SQL type for some or all of the SQL query parameters. See the
	// definition of [Type][google.spanner.v1.Type] for more information
	// about SQL types.
	ParamTypes map[string]*Type `protobuf:"bytes,5,rep,name=param_types,json=paramTypes" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// If this request is resuming a previously interrupted SQL query
	// execution, `resume_token` should be copied from the last
	// [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
	// enables the new SQL query execution to resume where the last one left
	// off. The rest of the request parameters must exactly match the
	// request that yielded this token.
	ResumeToken []byte `protobuf:"bytes,6,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// Used to control the amount of debugging information returned in
	// [ResultSetStats][google.spanner.v1.ResultSetStats].
	QueryMode ExecuteSqlRequest_QueryMode `protobuf:"varint,7,opt,name=query_mode,json=queryMode,enum=google.spanner.v1.ExecuteSqlRequest_QueryMode" json:"query_mode,omitempty"`
}

func (m *ExecuteSqlRequest) Reset()                    { *m = ExecuteSqlRequest{} }
func (m *ExecuteSqlRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteSqlRequest) ProtoMessage()               {}
func (*ExecuteSqlRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{4} }

func (m *ExecuteSqlRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *ExecuteSqlRequest) GetTransaction() *TransactionSelector {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *ExecuteSqlRequest) GetSql() string {
	if m != nil {
		return m.Sql
	}
	return ""
}

func (m *ExecuteSqlRequest) GetParams() *google_protobuf1.Struct {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *ExecuteSqlRequest) GetParamTypes() map[string]*Type {
	if m != nil {
		return m.ParamTypes
	}
	return nil
}

func (m *ExecuteSqlRequest) GetResumeToken() []byte {
	if m != nil {
		return m.ResumeToken
	}
	return nil
}

func (m *ExecuteSqlRequest) GetQueryMode() ExecuteSqlRequest_QueryMode {
	if m != nil {
		return m.QueryMode
	}
	return ExecuteSqlRequest_NORMAL
}

// The request for [Read][google.spanner.v1.Spanner.Read] and
// [StreamingRead][google.spanner.v1.Spanner.StreamingRead].
type ReadRequest struct {
	// Required. The session in which the read should be performed.
	Session string `protobuf:"bytes,1,opt,name=session" json:"session,omitempty"`
	// The transaction to use. If none is provided, the default is a
	// temporary read-only transaction with strong concurrency.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction" json:"transaction,omitempty"`
	// Required. The name of the table in the database to be read.
	Table string `protobuf:"bytes,3,opt,name=table" json:"table,omitempty"`
	// If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
	// used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
	// and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
	Index string `protobuf:"bytes,4,opt,name=index" json:"index,omitempty"`
	// The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
	// this request.
	Columns []string `protobuf:"bytes,5,rep,name=columns" json:"columns,omitempty"`
	// Required. `key_set` identifies the rows to be yielded. `key_set` names the
	// primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
	// is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
	// index keys in [index][google.spanner.v1.ReadRequest.index].
	//
	// Rows are yielded in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty)
	// or index key order (if [index][google.spanner.v1.ReadRequest.index] is non-empty).
	//
	// It is not an error for the `key_set` to name rows that do not
	// exist in the database. Read yields nothing for nonexistent rows.
	KeySet *KeySet `protobuf:"bytes,6,opt,name=key_set,json=keySet" json:"key_set,omitempty"`
	// If greater than zero, only the first `limit` rows are yielded. If `limit`
	// is zero, the default is no limit.
	Limit int64 `protobuf:"varint,8,opt,name=limit" json:"limit,omitempty"`
	// If this request is resuming a previously interrupted read,
	// `resume_token` should be copied from the last
	// [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
	// enables the new read to resume where the last read left off. The
	// rest of the request parameters must exactly match the request
	// that yielded this token.
	ResumeToken []byte `protobuf:"bytes,9,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
}

func (m *ReadRequest) Reset()                    { *m = ReadRequest{} }
func (m *ReadRequest) String() string            { return proto.CompactTextString(m) }
func (*ReadRequest) ProtoMessage()               {}
func (*ReadRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{5} }

func (m *ReadRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *ReadRequest) GetTransaction() *TransactionSelector {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *ReadRequest) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *ReadRequest) GetIndex() string {
	if m != nil {
		return m.Index
	}
	return ""
}

func (m *ReadRequest) GetColumns() []string {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *ReadRequest) GetKeySet() *KeySet {
	if m != nil {
		return m.KeySet
	}
	return nil
}

func (m *ReadRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ReadRequest) GetResumeToken() []byte {
	if m != nil {
		return m.ResumeToken
	}
	return nil
}

// The request for [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction].
type BeginTransactionRequest struct {
	// Required. The session in which the transaction runs.
	Session string `protobuf:"bytes,1,opt,name=session" json:"session,omitempty"`
	// Required. Options for the new transaction.
	Options *TransactionOptions `protobuf:"bytes,2,opt,name=options" json:"options,omitempty"`
}

func (m *BeginTransactionRequest) Reset()                    { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()               {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{6} }

func (m *BeginTransactionRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *BeginTransactionRequest) GetOptions() *TransactionOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// The request for [Commit][google.spanner.v1.Spanner.Commit].
type CommitRequest struct {
	// Required. The session in which the transaction to be committed is running.
	Session string `protobuf:"bytes,1,opt,name=session" json:"session,omitempty"`
	// Required. The transaction in which to commit.
	//
	// Types that are valid to be assigned to Transaction:
	//	*CommitRequest_TransactionId
	//	*CommitRequest_SingleUseTransaction
	Transaction isCommitRequest_Transaction `protobuf_oneof:"transaction"`
	// The mutations to be executed when this transaction commits. All
	// mutations are applied atomically, in the order they appear in
	// this list.
	Mutations []*Mutation `protobuf:"bytes,4,rep,name=mutations" json:"mutations,omitempty"`
}

func (m *CommitRequest) Reset()                    { *m = CommitRequest{} }
func (m *CommitRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()               {}
func (*CommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{7} }

type isCommitRequest_Transaction interface {
	isCommitRequest_Transaction()
}

type CommitRequest_TransactionId struct {
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3,oneof"`
}
type CommitRequest_SingleUseTransaction struct {
	SingleUseTransaction *TransactionOptions `protobuf:"bytes,3,opt,name=single_use_transaction,json=singleUseTransaction,oneof"`
}

func (*CommitRequest_TransactionId) isCommitRequest_Transaction()        {}
func (*CommitRequest_SingleUseTransaction) isCommitRequest_Transaction() {}

func (m *CommitRequest) GetTransaction() isCommitRequest_Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *CommitRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *CommitRequest) GetTransactionId() []byte {
	if x, ok := m.GetTransaction().(*CommitRequest_TransactionId); ok {
		return x.TransactionId
	}
	return nil
}

func (m *CommitRequest) GetSingleUseTransaction() *TransactionOptions {
	if x, ok := m.GetTransaction().(*CommitRequest_SingleUseTransaction); ok {
		return x.SingleUseTransaction
	}
	return nil
}

func (m *CommitRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommitRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommitRequest_OneofMarshaler, _CommitRequest_OneofUnmarshaler, _CommitRequest_OneofSizer, []interface{}{
		(*CommitRequest_TransactionId)(nil),
		(*CommitRequest_SingleUseTransaction)(nil),
	}
}

func _CommitRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommitRequest)
	// transaction
	switch x := m.Transaction.(type) {
	case *CommitRequest_TransactionId:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.TransactionId)
	case *CommitRequest_SingleUseTransaction:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SingleUseTransaction); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CommitRequest.Transaction has unexpected type %T", x)
	}
	return nil
}

func _CommitRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommitRequest)
	switch tag {
	case 2: // transaction.transaction_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Transaction = &CommitRequest_TransactionId{x}
		return true, err
	case 3: // transaction.single_use_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionOptions)
		err := b.DecodeMessage(msg)
		m.Transaction = &CommitRequest_SingleUseTransaction{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CommitRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommitRequest)
	// transaction
	switch x := m.Transaction.(type) {
	case *CommitRequest_TransactionId:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.TransactionId)))
		n += len(x.TransactionId)
	case *CommitRequest_SingleUseTransaction:
		s := proto.Size(x.SingleUseTransaction)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Commit][google.spanner.v1.Spanner.Commit].
type CommitResponse struct {
	// The Cloud Spanner timestamp at which the transaction committed.
	CommitTimestamp *google_protobuf3.Timestamp `protobuf:"bytes,1,opt,name=commit_timestamp,json=commitTimestamp" json:"commit_timestamp,omitempty"`
}

func (m *CommitResponse) Reset()                    { *m = CommitResponse{} }
func (m *CommitResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()               {}
func (*CommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{8} }

func (m *CommitResponse) GetCommitTimestamp() *google_protobuf3.Timestamp {
	if m != nil {
		return m.CommitTimestamp
	}
	return nil
}

// The request for [Rollback][google.spanner.v1.Spanner.Rollback].
type RollbackRequest struct {
	// Required. The session in which the transaction to roll back is running.
	Session string `protobuf:"bytes,1,opt,name=session" json:"session,omitempty"`
	// Required. The transaction to roll back.
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (m *RollbackRequest) Reset()                    { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()               {}
func (*RollbackRequest) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{9} }

func (m *RollbackRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *RollbackRequest) GetTransactionId() []byte {
	if m != nil {
		return m.TransactionId
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateSessionRequest)(nil), "google.spanner.v1.CreateSessionRequest")
	proto.RegisterType((*Session)(nil), "google.spanner.v1.Session")
	proto.RegisterType((*GetSessionRequest)(nil), "google.spanner.v1.GetSessionRequest")
	proto.RegisterType((*DeleteSessionRequest)(nil), "google.spanner.v1.DeleteSessionRequest")
	proto.RegisterType((*ExecuteSqlRequest)(nil), "google.spanner.v1.ExecuteSqlRequest")
	proto.RegisterType((*ReadRequest)(nil), "google.spanner.v1.ReadRequest")
	proto.RegisterType((*BeginTransactionRequest)(nil), "google.spanner.v1.BeginTransactionRequest")
	proto.RegisterType((*CommitRequest)(nil), "google.spanner.v1.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "google.spanner.v1.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "google.spanner.v1.RollbackRequest")
	proto.RegisterEnum("google.spanner.v1.ExecuteSqlRequest_QueryMode", ExecuteSqlRequest_QueryMode_name, ExecuteSqlRequest_QueryMode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Spanner service

type SpannerClient interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Cloud Spanner limits the number of sessions that can exist at any given
	// time; thus, it is a good idea to delete idle and/or unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner can delete sessions for which no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, e.g., `"SELECT 1"`.
	CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Gets a session. Returns `NOT_FOUND` if the session does not exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Ends a session, releasing server resources associated with it.
	DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
	// Executes an SQL query, returning all rows in a single reply. This
	// method cannot be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Queries inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] instead.
	ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the result
	// set as a stream. Unlike [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there
	// is no limit on the size of the returned result set. However, no
	// individual row in the result set can exceed 100 MiB, and no
	// column value can exceed 10 MiB.
	ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error)
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be used to
	// return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set as a
	// stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no limit on the
	// size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error)
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read], [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
	// the transaction from the beginning, re-using the same session.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It is a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and
	// ultimately decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction is not
	// found. `Rollback` never returns `ABORTED`.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
}

type spannerClient struct {
	cc *grpc.ClientConn
}

func NewSpannerClient(cc *grpc.ClientConn) SpannerClient {
	return &spannerClient{cc}
}

func (c *spannerClient) CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := grpc.Invoke(ctx, "/google.spanner.v1.Spanner/CreateSession", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := grpc.Invoke(ctx, "/google.spanner.v1.Spanner/GetSession", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.spanner.v1.Spanner/DeleteSession", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := grpc.Invoke(ctx, "/google.spanner.v1.Spanner/ExecuteSql", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Spanner_serviceDesc.Streams[0], c.cc, "/google.spanner.v1.Spanner/ExecuteStreamingSql", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerExecuteStreamingSqlClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_ExecuteStreamingSqlClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerExecuteStreamingSqlClient struct {
	grpc.ClientStream
}

func (x *spannerExecuteStreamingSqlClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := grpc.Invoke(ctx, "/google.spanner.v1.Spanner/Read", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Spanner_serviceDesc.Streams[1], c.cc, "/google.spanner.v1.Spanner/StreamingRead", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerStreamingReadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_StreamingReadClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerStreamingReadClient struct {
	grpc.ClientStream
}

func (x *spannerStreamingReadClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error) {
	out := new(Transaction)
	err := grpc.Invoke(ctx, "/google.spanner.v1.Spanner/BeginTransaction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := grpc.Invoke(ctx, "/google.spanner.v1.Spanner/Commit", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.spanner.v1.Spanner/Rollback", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Spanner service

type SpannerServer interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Cloud Spanner limits the number of sessions that can exist at any given
	// time; thus, it is a good idea to delete idle and/or unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner can delete sessions for which no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, e.g., `"SELECT 1"`.
	CreateSession(context.Context, *CreateSessionRequest) (*Session, error)
	// Gets a session. Returns `NOT_FOUND` if the session does not exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(context.Context, *GetSessionRequest) (*Session, error)
	// Ends a session, releasing server resources associated with it.
	DeleteSession(context.Context, *DeleteSessionRequest) (*google_protobuf4.Empty, error)
	// Executes an SQL query, returning all rows in a single reply. This
	// method cannot be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Queries inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] instead.
	ExecuteSql(context.Context, *ExecuteSqlRequest) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the result
	// set as a stream. Unlike [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there
	// is no limit on the size of the returned result set. However, no
	// individual row in the result set can exceed 100 MiB, and no
	// column value can exceed 10 MiB.
	ExecuteStreamingSql(*ExecuteSqlRequest, Spanner_ExecuteStreamingSqlServer) error
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be used to
	// return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(context.Context, *ReadRequest) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set as a
	// stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no limit on the
	// size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(*ReadRequest, Spanner_StreamingReadServer) error
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read], [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
	// the transaction from the beginning, re-using the same session.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It is a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and
	// ultimately decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction is not
	// found. `Rollback` never returns `ABORTED`.
	Rollback(context.Context, *RollbackRequest) (*google_protobuf4.Empty, error)
}

func RegisterSpannerServer(s *grpc.Server, srv SpannerServer) {
	s.RegisterService(&_Spanner_serviceDesc, srv)
}

func _Spanner_CreateSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).CreateSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/CreateSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).CreateSession(ctx, req.(*CreateSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_GetSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).GetSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/GetSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).GetSession(ctx, req.(*GetSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_DeleteSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).DeleteSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/DeleteSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).DeleteSession(ctx, req.(*DeleteSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteSql_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteSqlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ExecuteSql(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/ExecuteSql",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ExecuteSql(ctx, req.(*ExecuteSqlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteStreamingSql_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExecuteSqlRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).ExecuteStreamingSql(m, &spannerExecuteStreamingSqlServer{stream})
}

type Spanner_ExecuteStreamingSqlServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerExecuteStreamingSqlServer struct {
	grpc.ServerStream
}

func (x *spannerExecuteStreamingSqlServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_Read_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Read(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Read",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Read(ctx, req.(*ReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_StreamingRead_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).StreamingRead(m, &spannerStreamingReadServer{stream})
}

type Spanner_StreamingReadServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerStreamingReadServer struct {
	grpc.ServerStream
}

func (x *spannerStreamingReadServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Spanner_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.v1.Spanner",
	HandlerType: (*SpannerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSession",
			Handler:    _Spanner_CreateSession_Handler,
		},
		{
			MethodName: "GetSession",
			Handler:    _Spanner_GetSession_Handler,
		},
		{
			MethodName: "DeleteSession",
			Handler:    _Spanner_DeleteSession_Handler,
		},
		{
			MethodName: "ExecuteSql",
			Handler:    _Spanner_ExecuteSql_Handler,
		},
		{
			MethodName: "Read",
			Handler:    _Spanner_Read_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Spanner_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Spanner_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Spanner_Rollback_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ExecuteStreamingSql",
			Handler:       _Spanner_ExecuteStreamingSql_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamingRead",
			Handler:       _Spanner_StreamingRead_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/spanner/v1/spanner.proto",
}

func init() { proto.RegisterFile("google/spanner/v1/spanner.proto", fileDescriptor4) }

var fileDescriptor4 = []byte{
	// 1202 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x97, 0xcd, 0x6f, 0x1b, 0xc5,
	0x1b, 0xc7, 0xbb, 0x4e, 0x6a, 0xc7, 0x8f, 0x93, 0xd6, 0x9d, 0x5f, 0xda, 0xf8, 0xe7, 0x96, 0xd6,
	0xdd, 0x52, 0x6a, 0x59, 0xc2, 0x4b, 0x0d, 0x87, 0x62, 0x40, 0xb4, 0x6e, 0xdd, 0x36, 0x6a, 0x5e,
	0x9c, 0xb5, 0xdb, 0x4a, 0x95, 0x90, 0x35, 0xb6, 0x1f, 0xcc, 0xe2, 0x7d, 0xcb, 0xce, 0x6c, 0x54,
	0xab, 0xea, 0x85, 0x2b, 0x17, 0x5e, 0x0e, 0x70, 0xe0, 0x06, 0x27, 0xc4, 0x9d, 0x1b, 0xff, 0x04,
	0xff, 0x02, 0x17, 0xfe, 0x06, 0x2e, 0x68, 0x66, 0x77, 0x9d, 0x8d, 0x77, 0x9b, 0xa4, 0x04, 0x71,
	0xca, 0xbc, 0x7c, 0x9f, 0x79, 0x3e, 0xf3, 0x9d, 0xd9, 0x79, 0x1c, 0xb8, 0x32, 0x76, 0x9c, 0xb1,
	0x89, 0x1a, 0x73, 0xa9, 0x6d, 0xa3, 0xa7, 0xed, 0xdd, 0x8c, 0x9a, 0x75, 0xd7, 0x73, 0xb8, 0x43,
	0xce, 0x05, 0x82, 0x7a, 0x34, 0xba, 0x77, 0xb3, 0x7c, 0x29, 0x8c, 0xa1, 0xae, 0xa1, 0x51, 0xdb,
	0x76, 0x38, 0xe5, 0x86, 0x63, 0xb3, 0x20, 0xa0, 0x7c, 0x3e, 0x3e, 0xeb, 0xf3, 0xcf, 0xc2, 0xe1,
	0x8b, 0xe1, 0xb0, 0xec, 0x0d, 0xfc, 0x4f, 0x35, 0xb4, 0x5c, 0x3e, 0x0d, 0x27, 0x2f, 0xcd, 0x4f,
	0x32, 0xee, 0xf9, 0x43, 0x1e, 0xce, 0x5e, 0x99, 0x9f, 0xe5, 0x86, 0x85, 0x8c, 0x53, 0xcb, 0x9d,
	0x0b, 0x8f, 0x6d, 0x62, 0x82, 0xd3, 0x08, 0xa8, 0x92, 0x9c, 0xb5, 0xfc, 0x80, 0x39, 0x54, 0xa8,
	0x49, 0x85, 0x87, 0xcc, 0x37, 0x79, 0x9f, 0x61, 0x04, 0x71, 0x2d, 0xa9, 0xe1, 0x1e, 0xb5, 0x19,
	0x1d, 0xc6, 0x16, 0x4a, 0x01, 0xe1, 0x53, 0x17, 0x83, 0x59, 0xb5, 0x01, 0xab, 0x77, 0x3d, 0xa4,
	0x1c, 0xbb, 0xc8, 0x98, 0xe1, 0xd8, 0x3a, 0xee, 0xfa, 0xc8, 0x38, 0x29, 0xc3, 0xd2, 0x88, 0x72,
	0x3a, 0xa0, 0x0c, 0x4b, 0x4a, 0x45, 0xa9, 0xe6, 0xf5, 0x59, 0x5f, 0x7d, 0x03, 0x72, 0xa1, 0x9a,
	0x10, 0x58, 0xb4, 0xa9, 0x15, 0x49, 0x64, 0x5b, 0xbd, 0x01, 0xe7, 0x1e, 0x20, 0x9f, 0x5b, 0x2f,
	0x4d, 0x58, 0x83, 0xd5, 0x7b, 0x68, 0x62, 0x22, 0x77, 0x9a, 0xf6, 0xcb, 0x45, 0x38, 0xd7, 0x7e,
	0x8e, 0x43, 0x9f, 0x63, 0x77, 0xd7, 0x8c, 0x94, 0x25, 0xc8, 0xb1, 0x20, 0x36, 0x14, 0x47, 0x5d,
	0xf2, 0x10, 0x0a, 0x31, 0x2b, 0x4a, 0x99, 0x8a, 0x52, 0x2d, 0x34, 0xde, 0xaa, 0x27, 0x2e, 0x4e,
	0xbd, 0xb7, 0xaf, 0xea, 0xa2, 0x89, 0x43, 0xee, 0x78, 0x7a, 0x3c, 0x94, 0x14, 0x61, 0x81, 0xed,
	0x9a, 0xa5, 0x05, 0xb9, 0xbe, 0x68, 0x12, 0x0d, 0xb2, 0x2e, 0xf5, 0xa8, 0xc5, 0x4a, 0x8b, 0x72,
	0xd9, 0xb5, 0x68, 0xd9, 0xe8, 0x32, 0xd4, 0xbb, 0xf2, 0xaa, 0xe8, 0xa1, 0x8c, 0x3c, 0x86, 0x82,
	0x6c, 0xf5, 0x85, 0xf1, 0xac, 0x74, 0xba, 0xb2, 0x50, 0x2d, 0x34, 0xde, 0x4b, 0x81, 0x49, 0xec,
	0xb0, 0xde, 0x11, 0x71, 0x3d, 0x11, 0xd6, 0xb6, 0xb9, 0x37, 0xd5, 0xc1, 0x9d, 0x0d, 0x90, 0xab,
	0xb0, 0x2c, 0xae, 0x84, 0x85, 0x7d, 0xee, 0x4c, 0xd0, 0x2e, 0x65, 0x2b, 0x4a, 0x75, 0x59, 0x2f,
	0x04, 0x63, 0x3d, 0x31, 0x44, 0x36, 0x01, 0x76, 0x7d, 0xf4, 0xa6, 0x7d, 0xcb, 0x19, 0x61, 0x29,
	0x57, 0x51, 0xaa, 0x67, 0x1a, 0xf5, 0x63, 0x25, 0xde, 0x11, 0x61, 0x9b, 0xce, 0x08, 0xf5, 0xfc,
	0x6e, 0xd4, 0x2c, 0x3f, 0x81, 0xb3, 0x73, 0x40, 0xc2, 0x9e, 0x09, 0x4e, 0x43, 0xfb, 0x45, 0x93,
	0xbc, 0x0d, 0xa7, 0xf7, 0xa8, 0xe9, 0x63, 0x68, 0xfa, 0x5a, 0x9a, 0xe9, 0x53, 0x17, 0xf5, 0x40,
	0xd5, 0xcc, 0xdc, 0x52, 0xd4, 0x3a, 0xe4, 0x67, 0xf9, 0x08, 0x40, 0x76, 0x6b, 0x5b, 0xdf, 0xbc,
	0xb3, 0x51, 0x3c, 0x45, 0x96, 0x60, 0xb1, 0xb3, 0x71, 0x67, 0xab, 0xa8, 0x90, 0x02, 0xe4, 0x3a,
	0xfa, 0xf6, 0xfd, 0xf5, 0x8d, 0x76, 0x31, 0xa3, 0xfe, 0x94, 0x81, 0x82, 0x8e, 0x74, 0xf4, 0x5f,
	0xde, 0x83, 0x55, 0x38, 0xcd, 0xe9, 0xc0, 0xc4, 0xf0, 0x26, 0x04, 0x1d, 0x31, 0x6a, 0xd8, 0x23,
	0x7c, 0x2e, 0xaf, 0x42, 0x5e, 0x0f, 0x3a, 0x82, 0x67, 0xe8, 0x98, 0xbe, 0x65, 0x07, 0x87, 0x9d,
	0xd7, 0xa3, 0x2e, 0x69, 0x40, 0x6e, 0x82, 0x53, 0xf1, 0x0d, 0xcb, 0xe3, 0x2a, 0x34, 0xfe, 0x9f,
	0xc2, 0xf2, 0x08, 0xa7, 0x5d, 0xe4, 0x7a, 0x76, 0x22, 0xff, 0x8a, 0x1c, 0xa6, 0x61, 0x19, 0xbc,
	0xb4, 0x54, 0x51, 0xaa, 0x0b, 0x7a, 0xd0, 0x49, 0x9c, 0x7e, 0x3e, 0x71, 0xfa, 0x2a, 0x87, 0xb5,
	0x16, 0x8e, 0x0d, 0x3b, 0xb6, 0xb7, 0xa3, 0x1d, 0xfb, 0x18, 0x72, 0x8e, 0x2b, 0x1f, 0xcf, 0xd0,
	0xad, 0xeb, 0x87, 0xbb, 0xb5, 0x1d, 0x88, 0xf5, 0x28, 0x4a, 0xfd, 0x4b, 0x81, 0x95, 0xbb, 0x8e,
	0x65, 0x19, 0xfc, 0xe8, 0x64, 0x37, 0xe0, 0x4c, 0xcc, 0xe3, 0xbe, 0x31, 0x92, 0x39, 0x97, 0x1f,
	0x9e, 0xd2, 0x57, 0x62, 0xe3, 0xeb, 0x23, 0xf2, 0x09, 0x5c, 0x60, 0x86, 0x3d, 0x36, 0xb1, 0xef,
	0x33, 0xec, 0xc7, 0x8f, 0x74, 0xe1, 0x35, 0x20, 0x1f, 0x9e, 0xd2, 0x57, 0x83, 0x65, 0x1e, 0x33,
	0x8c, 0x4d, 0x93, 0xf7, 0x21, 0x1f, 0xbd, 0xbf, 0xe2, 0xab, 0x16, 0xdf, 0xe7, 0xc5, 0x94, 0x15,
	0x37, 0x43, 0x8d, 0xbe, 0xaf, 0x6e, 0xad, 0x1c, 0xb8, 0x61, 0xea, 0x53, 0x38, 0x13, 0x6d, 0x9e,
	0xb9, 0x8e, 0xcd, 0x90, 0xb4, 0xa1, 0x38, 0x94, 0x23, 0xfd, 0x59, 0x8d, 0x90, 0x36, 0x14, 0x1a,
	0xe5, 0xc4, 0xc3, 0xd1, 0x8b, 0x14, 0xfa, 0xd9, 0x20, 0x66, 0x36, 0xa0, 0xea, 0x70, 0x56, 0x77,
	0x4c, 0x73, 0x40, 0x87, 0x93, 0xa3, 0x7d, 0xbd, 0x9e, 0xee, 0xeb, 0x9c, 0xab, 0x8d, 0x3f, 0x97,
	0x21, 0xd7, 0x0d, 0xb6, 0x47, 0xbe, 0x17, 0xc7, 0x16, 0x2f, 0x05, 0xe4, 0x46, 0x8a, 0x03, 0x69,
	0xc5, 0xa2, 0x5c, 0x4e, 0x11, 0x86, 0x12, 0xb5, 0xf5, 0xc5, 0xef, 0x7f, 0x7c, 0x9b, 0xf9, 0x50,
	0x6d, 0x8a, 0xc2, 0xf3, 0x22, 0xaa, 0x21, 0x1f, 0xb9, 0x9e, 0xf3, 0x39, 0x0e, 0x39, 0xd3, 0x6a,
	0x9a, 0x61, 0x33, 0x4e, 0xed, 0x21, 0x8a, 0x76, 0x34, 0xcf, 0xb4, 0xda, 0x4b, 0x2d, 0xdc, 0x0c,
	0x23, 0x5f, 0x29, 0x00, 0xfb, 0x25, 0x85, 0xbc, 0x99, 0x92, 0x2e, 0x51, 0x71, 0x0e, 0x85, 0xba,
	0x2d, 0xa1, 0x9a, 0xe4, 0x96, 0x84, 0x12, 0x05, 0xe6, 0x18, 0x40, 0x33, 0x1e, 0xad, 0xf6, 0x92,
	0x7c, 0xa3, 0xc0, 0xca, 0x81, 0xe2, 0x95, 0xea, 0x56, 0x5a, 0x79, 0x2b, 0x5f, 0x48, 0x9c, 0x7a,
	0x5b, 0xfc, 0xec, 0x88, 0xa0, 0x6a, 0xff, 0x1c, 0xea, 0x47, 0x05, 0x60, 0xff, 0x25, 0x4f, 0xf5,
	0x29, 0xf1, 0xd0, 0x97, 0x2f, 0xa5, 0xa8, 0x74, 0xf9, 0x4b, 0xa3, 0x8b, 0x5c, 0xdd, 0x91, 0x50,
	0x8f, 0xd4, 0xfb, 0x12, 0x2a, 0x4c, 0xf6, 0x9a, 0x5c, 0x4d, 0x9c, 0x25, 0x6d, 0x2a, 0x35, 0xf2,
	0x9b, 0x02, 0xff, 0x8b, 0x30, 0xb8, 0x87, 0xd4, 0x32, 0xec, 0xf1, 0xf1, 0x71, 0xaf, 0xa5, 0xa8,
	0x3a, 0xd4, 0xe3, 0x06, 0x35, 0xf7, 0xa9, 0x9f, 0x49, 0xea, 0x9e, 0xba, 0xfd, 0x6f, 0x50, 0xc7,
	0x18, 0x9b, 0x4a, 0xed, 0x1d, 0x85, 0x7c, 0xad, 0xc0, 0xa2, 0xa8, 0x3e, 0xe4, 0x72, 0xaa, 0x75,
	0xb3, 0xb2, 0x74, 0x84, 0xb5, 0x8f, 0x24, 0x64, 0x5b, 0xbd, 0x7d, 0x12, 0x48, 0x0f, 0xe9, 0x48,
	0x98, 0xfa, 0x8b, 0x02, 0x2b, 0x33, 0xd2, 0x63, 0xc1, 0x1d, 0xcb, 0xc8, 0x9e, 0x64, 0xdc, 0x52,
	0xd7, 0x4f, 0xc2, 0xc8, 0xe2, 0x5c, 0x81, 0x85, 0xbf, 0x2a, 0x50, 0x9c, 0x2f, 0x4d, 0xa4, 0x96,
	0x42, 0xf4, 0x8a, 0xfa, 0x55, 0xbe, 0x7c, 0xf8, 0x7b, 0xaf, 0x3e, 0x95, 0xe0, 0x3b, 0xea, 0xc6,
	0x49, 0xc0, 0x07, 0x73, 0xc9, 0x85, 0xd1, 0x3f, 0x28, 0x90, 0x0d, 0x1e, 0x78, 0x52, 0x49, 0x7b,
	0x1f, 0xe3, 0x85, 0xaf, 0x7c, 0xf5, 0x10, 0x45, 0x50, 0x1d, 0xd4, 0x4d, 0x09, 0xfa, 0x40, 0x6d,
	0x9d, 0x04, 0x34, 0xa8, 0x15, 0x02, 0xef, 0x3b, 0x05, 0x96, 0xa2, 0x32, 0x41, 0xd4, 0xb4, 0x2b,
	0x70, 0xb0, 0x86, 0xbc, 0xf2, 0x35, 0xda, 0x96, 0x5c, 0xeb, 0xea, 0xbd, 0x13, 0xdd, 0xce, 0x30,
	0x59, 0x53, 0xa9, 0xb5, 0x5e, 0xc0, 0xf9, 0xa1, 0x63, 0x25, 0x89, 0x5a, 0xcb, 0x61, 0x05, 0xea,
	0x08, 0x80, 0x8e, 0xf2, 0xec, 0x56, 0x28, 0x19, 0x3b, 0x26, 0xb5, 0xc7, 0x75, 0xc7, 0x1b, 0x6b,
	0x63, 0xb4, 0x25, 0x9e, 0x16, 0x4c, 0x51, 0xd7, 0x60, 0xb1, 0xff, 0x67, 0x3e, 0x08, 0x9b, 0x3f,
	0x67, 0xd6, 0x1e, 0x04, 0xa1, 0x77, 0x4d, 0xc7, 0x1f, 0xd5, 0xc3, 0x75, 0xeb, 0x4f, 0x6e, 0x0e,
	0xb2, 0x32, 0xfc, 0xdd, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0x1c, 0x21, 0x25, 0x65, 0x5b, 0x0e,
	0x00, 0x00,
}
