/*
Copyright 2019 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/cluster-resource-override-admission-operator/pkg/apis/autoscaling/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterResourceOverrideLister helps list ClusterResourceOverrides.
type ClusterResourceOverrideLister interface {
	// List lists all ClusterResourceOverrides in the indexer.
	List(selector labels.Selector) (ret []*v1.ClusterResourceOverride, err error)
	// Get retrieves the ClusterResourceOverride from the index for a given name.
	Get(name string) (*v1.ClusterResourceOverride, error)
	ClusterResourceOverrideListerExpansion
}

// clusterResourceOverrideLister implements the ClusterResourceOverrideLister interface.
type clusterResourceOverrideLister struct {
	indexer cache.Indexer
}

// NewClusterResourceOverrideLister returns a new ClusterResourceOverrideLister.
func NewClusterResourceOverrideLister(indexer cache.Indexer) ClusterResourceOverrideLister {
	return &clusterResourceOverrideLister{indexer: indexer}
}

// List lists all ClusterResourceOverrides in the indexer.
func (s *clusterResourceOverrideLister) List(selector labels.Selector) (ret []*v1.ClusterResourceOverride, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterResourceOverride))
	})
	return ret, err
}

// Get retrieves the ClusterResourceOverride from the index for a given name.
func (s *clusterResourceOverrideLister) Get(name string) (*v1.ClusterResourceOverride, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("clusterresourceoverride"), name)
	}
	return obj.(*v1.ClusterResourceOverride), nil
}
