/*
Copyright 2019 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/cluster-resource-override-admission-operator/pkg/apis/autoscaling/v1"
	scheme "github.com/openshift/cluster-resource-override-admission-operator/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterResourceOverridesGetter has a method to return a ClusterResourceOverrideInterface.
// A group's client should implement this interface.
type ClusterResourceOverridesGetter interface {
	ClusterResourceOverrides() ClusterResourceOverrideInterface
}

// ClusterResourceOverrideInterface has methods to work with ClusterResourceOverride resources.
type ClusterResourceOverrideInterface interface {
	Create(*v1.ClusterResourceOverride) (*v1.ClusterResourceOverride, error)
	Update(*v1.ClusterResourceOverride) (*v1.ClusterResourceOverride, error)
	UpdateStatus(*v1.ClusterResourceOverride) (*v1.ClusterResourceOverride, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ClusterResourceOverride, error)
	List(opts metav1.ListOptions) (*v1.ClusterResourceOverrideList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ClusterResourceOverride, err error)
	ClusterResourceOverrideExpansion
}

// clusterResourceOverrides implements ClusterResourceOverrideInterface
type clusterResourceOverrides struct {
	client rest.Interface
}

// newClusterResourceOverrides returns a ClusterResourceOverrides
func newClusterResourceOverrides(c *AutoscalingV1Client) *clusterResourceOverrides {
	return &clusterResourceOverrides{
		client: c.RESTClient(),
	}
}

// Get takes name of the clusterResourceOverride, and returns the corresponding clusterResourceOverride object, and an error if there is any.
func (c *clusterResourceOverrides) Get(name string, options metav1.GetOptions) (result *v1.ClusterResourceOverride, err error) {
	result = &v1.ClusterResourceOverride{}
	err = c.client.Get().
		Resource("clusterresourceoverrides").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterResourceOverrides that match those selectors.
func (c *clusterResourceOverrides) List(opts metav1.ListOptions) (result *v1.ClusterResourceOverrideList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ClusterResourceOverrideList{}
	err = c.client.Get().
		Resource("clusterresourceoverrides").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterResourceOverrides.
func (c *clusterResourceOverrides) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("clusterresourceoverrides").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a clusterResourceOverride and creates it.  Returns the server's representation of the clusterResourceOverride, and an error, if there is any.
func (c *clusterResourceOverrides) Create(clusterResourceOverride *v1.ClusterResourceOverride) (result *v1.ClusterResourceOverride, err error) {
	result = &v1.ClusterResourceOverride{}
	err = c.client.Post().
		Resource("clusterresourceoverrides").
		Body(clusterResourceOverride).
		Do().
		Into(result)
	return
}

// Update takes the representation of a clusterResourceOverride and updates it. Returns the server's representation of the clusterResourceOverride, and an error, if there is any.
func (c *clusterResourceOverrides) Update(clusterResourceOverride *v1.ClusterResourceOverride) (result *v1.ClusterResourceOverride, err error) {
	result = &v1.ClusterResourceOverride{}
	err = c.client.Put().
		Resource("clusterresourceoverrides").
		Name(clusterResourceOverride.Name).
		Body(clusterResourceOverride).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *clusterResourceOverrides) UpdateStatus(clusterResourceOverride *v1.ClusterResourceOverride) (result *v1.ClusterResourceOverride, err error) {
	result = &v1.ClusterResourceOverride{}
	err = c.client.Put().
		Resource("clusterresourceoverrides").
		Name(clusterResourceOverride.Name).
		SubResource("status").
		Body(clusterResourceOverride).
		Do().
		Into(result)
	return
}

// Delete takes name of the clusterResourceOverride and deletes it. Returns an error if one occurs.
func (c *clusterResourceOverrides) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("clusterresourceoverrides").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterResourceOverrides) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("clusterresourceoverrides").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched clusterResourceOverride.
func (c *clusterResourceOverrides) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ClusterResourceOverride, err error) {
	result = &v1.ClusterResourceOverride{}
	err = c.client.Patch(pt).
		Resource("clusterresourceoverrides").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
