This document is auto-generated by `make gen-doc`

## CertificateSigningRequests

collects anonymized CertificateSigningRequests.
Collects CSRs which werent Verified, or when Now < ValidBefore or Now > ValidAfter

The Kubernetes api https://github.com/kubernetes/client-go/blob/master/kubernetes/typed/certificates/v1beta1/certificatesigningrequest.go#L78
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#certificatesigningrequestlist-v1beta1certificates

Location in archive: config/certificatesigningrequests/


## ClusterAuthentication

fetches the cluster Authentication - the Authentication with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/authentication.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#authentication-v1operator-openshift-io

Location in archive: config/authentication/
See: docs/insights-archive-sample/config/authentication


## ClusterFeatureGates

fetches the cluster FeatureGate - the FeatureGate with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/featuregate.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#featuregate-v1-config-openshift-io

Location in archive: config/featuregate/
See: docs/insights-archive-sample/config/featuregate


## ClusterID

stores ClusterID from ClusterVersion version
This method uses data already collected by Get ClusterVersion. In particular field .Spec.ClusterID
The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/clusterversion.go#L50
Response see https://github.com/openshift/api/blob/master/config/v1/types_cluster_version.go#L38

Location in archive: config/id/
See: docs/insights-archive-sample/config/id


## ClusterImagePruner

fetches the image pruner configuration

Location in archive: config/imagepruner/


## ClusterImageRegistry

fetches the cluster Image Registry configuration

Location in archive: config/imageregistry/


## ClusterInfrastructure

fetches the cluster Infrastructure - the Infrastructure with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/infrastructure.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#infrastructure-v1-config-openshift-io

Location in archive: config/infrastructure/
See: docs/insights-archive-sample/config/infrastructure


## ClusterIngress

fetches the cluster Ingress - the Ingress with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/ingress.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#ingress-v1-config-openshift-io

Location in archive: config/ingress/
See: docs/insights-archive-sample/config/ingress


## ClusterNetwork

fetches the cluster Network - the Network with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/network.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#network-v1-config-openshift-io

Location in archive: config/network/
See: docs/insights-archive-sample/config/network


## ClusterOAuth

fetches the cluster OAuth - the OAuth with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/oauth.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#oauth-v1-config-openshift-io

Location in archive: config/oauth/
See: docs/insights-archive-sample/config/oauth


## ClusterOperators

collects all ClusterOperators.
It finds unhealthy Pods for unhealthy operators

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/clusteroperator.go#L62
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#clusteroperatorlist-v1config-openshift-io

Location of operators in archive: config/clusteroperator/
See: docs/insights-archive-sample/config/clusteroperator
Location of pods in archive: config/pod/


Output raw size: 245

### Examples

#### ClusterOperators
[{"Name":"config/clusteroperator/","Captured":"0001-01-01T00:00:00Z","Fingerprint":"","Item":{"metadata":{"creationTimestamp":null},"spec":{},"status":{"conditions":[{"type":"Degraded","status":"","lastTransitionTime":null}],"extension":null}}}]

## ClusterProxy

fetches the cluster Proxy - the Proxy with name cluster.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/proxy.go#L30
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#proxy-v1-config-openshift-io

Location in archive: config/proxy/
See: docs/insights-archive-sample/config/proxy


## ClusterVersion

fetches the ClusterVersion - the ClusterVersion with name version.

The Kubernetes api https://github.com/openshift/client-go/blob/master/config/clientset/versioned/typed/config/v1/clusterversion.go#L50
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#clusterversion-v1config-openshift-io

Location in archive: config/version/
See: docs/insights-archive-sample/config/version


## ConfigMaps

fetches the ConfigMaps from namespace openshift-config.

Anonymization: If the content of ConfigMap contains a parseable PEM structure (like certificate) it removes the inside of PEM blocks.
For ConfigMap of type BinaryData it is encoded as standard base64.
In the archive under configmaps we store name of ConfigMap and then each ConfigMap Key. For example config/configmaps/CONFIGMAPNAME/CONFIGMAPKEY1

The Kubernetes api https://github.com/kubernetes/client-go/blob/master/kubernetes/typed/core/v1/configmap.go#L80
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#configmaplist-v1core

Location in archive: config/configmaps/
See: docs/insights-archive-sample/config/configmaps


## MostRecentMetrics

gathers cluster Federated Monitoring metrics.

The GET REST query to URL /federate
Gathered metrics:
  ALERTS
  etcd_object_counts
  cluster_installer

Location in archive: config/metrics/
See: docs/insights-archive-sample/config/metrics


Output raw size: 108

### Examples

#### MostRecentMetrics
[{"Name":"config/metrics","Captured":"0001-01-01T00:00:00Z","Fingerprint":"","Item":"SGVsbG8sIGNsaWVudAo="}]

## UnhealthyNodes

collects all unhealthy Nodes.

The node is unhealthy when:
the operator.Status.Conditions.Condition Type
  is OperatorDegrated and Status is True or
     OperatorAvailable and Status is False

The Kubernetes api https://github.com/kubernetes/client-go/blob/master/kubernetes/typed/core/v1/node.go#L78
Response see https://docs.openshift.com/container-platform/4.3/rest_api/index.html#nodelist-v1core

Location in archive: config/node/


Output raw size: 491

### Examples

#### UnhealthyNodes
[{"Name":"config/node/","Captured":"0001-01-01T00:00:00Z","Fingerprint":"","Item":{"metadata":{"creationTimestamp":null},"spec":{},"status":{"conditions":[{"type":"Ready","status":"False","lastHeartbeatTime":null,"lastTransitionTime":null}],"daemonEndpoints":{"kubeletEndpoint":{"Port":0}},"nodeInfo":{"machineID":"","systemUUID":"","bootID":"","kernelVersion":"","osImage":"","containerRuntimeVersion":"","kubeletVersion":"","kubeProxyVersion":"","operatingSystem":"","architecture":""}}}}]

