// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package neptune

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddRoleToDBCluster = "AddRoleToDBCluster"

// AddRoleToDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the AddRoleToDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddRoleToDBCluster for more information on using the AddRoleToDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddRoleToDBClusterRequest method.
//    req, resp := client.AddRoleToDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddRoleToDBCluster
func (c *Neptune) AddRoleToDBClusterRequest(input *AddRoleToDBClusterInput) (req *request.Request, output *AddRoleToDBClusterOutput) {
	op := &request.Operation{
		Name:       opAddRoleToDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddRoleToDBClusterInput{}
	}

	output = &AddRoleToDBClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddRoleToDBCluster API operation for Amazon Neptune.
//
// Associates an Identity and Access Management (IAM) role from an Neptune DB
// cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation AddRoleToDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeDBClusterRoleAlreadyExistsFault "DBClusterRoleAlreadyExists"
//   The specified IAM role Amazon Resource Name (ARN) is already associated with
//   the specified DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeDBClusterRoleQuotaExceededFault "DBClusterRoleQuotaExceeded"
//   You have exceeded the maximum number of IAM roles that can be associated
//   with the specified DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddRoleToDBCluster
func (c *Neptune) AddRoleToDBCluster(input *AddRoleToDBClusterInput) (*AddRoleToDBClusterOutput, error) {
	req, out := c.AddRoleToDBClusterRequest(input)
	return out, req.Send()
}

// AddRoleToDBClusterWithContext is the same as AddRoleToDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See AddRoleToDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) AddRoleToDBClusterWithContext(ctx aws.Context, input *AddRoleToDBClusterInput, opts ...request.Option) (*AddRoleToDBClusterOutput, error) {
	req, out := c.AddRoleToDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddSourceIdentifierToSubscription = "AddSourceIdentifierToSubscription"

// AddSourceIdentifierToSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the AddSourceIdentifierToSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddSourceIdentifierToSubscription for more information on using the AddSourceIdentifierToSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddSourceIdentifierToSubscriptionRequest method.
//    req, resp := client.AddSourceIdentifierToSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddSourceIdentifierToSubscription
func (c *Neptune) AddSourceIdentifierToSubscriptionRequest(input *AddSourceIdentifierToSubscriptionInput) (req *request.Request, output *AddSourceIdentifierToSubscriptionOutput) {
	op := &request.Operation{
		Name:       opAddSourceIdentifierToSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddSourceIdentifierToSubscriptionInput{}
	}

	output = &AddSourceIdentifierToSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddSourceIdentifierToSubscription API operation for Amazon Neptune.
//
// Adds a source identifier to an existing event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation AddSourceIdentifierToSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The designated subscription could not be found.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The source could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddSourceIdentifierToSubscription
func (c *Neptune) AddSourceIdentifierToSubscription(input *AddSourceIdentifierToSubscriptionInput) (*AddSourceIdentifierToSubscriptionOutput, error) {
	req, out := c.AddSourceIdentifierToSubscriptionRequest(input)
	return out, req.Send()
}

// AddSourceIdentifierToSubscriptionWithContext is the same as AddSourceIdentifierToSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See AddSourceIdentifierToSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) AddSourceIdentifierToSubscriptionWithContext(ctx aws.Context, input *AddSourceIdentifierToSubscriptionInput, opts ...request.Option) (*AddSourceIdentifierToSubscriptionOutput, error) {
	req, out := c.AddSourceIdentifierToSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddTagsToResource
func (c *Neptune) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToResource API operation for Amazon Neptune.
//
// Adds metadata tags to an Amazon Neptune resource. These tags can also be
// used with cost allocation reporting to track cost associated with Amazon
// Neptune resources, or used in a Condition statement in an IAM policy for
// Amazon Neptune.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/AddTagsToResource
func (c *Neptune) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplyPendingMaintenanceAction = "ApplyPendingMaintenanceAction"

// ApplyPendingMaintenanceActionRequest generates a "aws/request.Request" representing the
// client's request for the ApplyPendingMaintenanceAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplyPendingMaintenanceAction for more information on using the ApplyPendingMaintenanceAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplyPendingMaintenanceActionRequest method.
//    req, resp := client.ApplyPendingMaintenanceActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ApplyPendingMaintenanceAction
func (c *Neptune) ApplyPendingMaintenanceActionRequest(input *ApplyPendingMaintenanceActionInput) (req *request.Request, output *ApplyPendingMaintenanceActionOutput) {
	op := &request.Operation{
		Name:       opApplyPendingMaintenanceAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplyPendingMaintenanceActionInput{}
	}

	output = &ApplyPendingMaintenanceActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplyPendingMaintenanceAction API operation for Amazon Neptune.
//
// Applies a pending maintenance action to a resource (for example, to a DB
// instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ApplyPendingMaintenanceAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ApplyPendingMaintenanceAction
func (c *Neptune) ApplyPendingMaintenanceAction(input *ApplyPendingMaintenanceActionInput) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	return out, req.Send()
}

// ApplyPendingMaintenanceActionWithContext is the same as ApplyPendingMaintenanceAction with the addition of
// the ability to pass a context and additional request options.
//
// See ApplyPendingMaintenanceAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ApplyPendingMaintenanceActionWithContext(ctx aws.Context, input *ApplyPendingMaintenanceActionInput, opts ...request.Option) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBClusterParameterGroup = "CopyDBClusterParameterGroup"

// CopyDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBClusterParameterGroup for more information on using the CopyDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBClusterParameterGroupRequest method.
//    req, resp := client.CopyDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterParameterGroup
func (c *Neptune) CopyDBClusterParameterGroupRequest(input *CopyDBClusterParameterGroupInput) (req *request.Request, output *CopyDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCopyDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterParameterGroupInput{}
	}

	output = &CopyDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBClusterParameterGroup API operation for Amazon Neptune.
//
// Copies the specified DB cluster parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CopyDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB parameter
//   groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterParameterGroup
func (c *Neptune) CopyDBClusterParameterGroup(input *CopyDBClusterParameterGroupInput) (*CopyDBClusterParameterGroupOutput, error) {
	req, out := c.CopyDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// CopyDBClusterParameterGroupWithContext is the same as CopyDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CopyDBClusterParameterGroupWithContext(ctx aws.Context, input *CopyDBClusterParameterGroupInput, opts ...request.Option) (*CopyDBClusterParameterGroupOutput, error) {
	req, out := c.CopyDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBClusterSnapshot = "CopyDBClusterSnapshot"

// CopyDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBClusterSnapshot for more information on using the CopyDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBClusterSnapshotRequest method.
//    req, resp := client.CopyDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterSnapshot
func (c *Neptune) CopyDBClusterSnapshotRequest(input *CopyDBClusterSnapshotInput) (req *request.Request, output *CopyDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterSnapshotInput{}
	}

	output = &CopyDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBClusterSnapshot API operation for Amazon Neptune.
//
// Copies a snapshot of a DB cluster.
//
// To copy a DB cluster snapshot from a shared manual DB cluster snapshot, SourceDBClusterSnapshotIdentifier
// must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.
//
// You can't copy from one AWS Region to another.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CopyDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   User already has a DB cluster snapshot with the given identifier.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBClusterSnapshot
func (c *Neptune) CopyDBClusterSnapshot(input *CopyDBClusterSnapshotInput) (*CopyDBClusterSnapshotOutput, error) {
	req, out := c.CopyDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// CopyDBClusterSnapshotWithContext is the same as CopyDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CopyDBClusterSnapshotWithContext(ctx aws.Context, input *CopyDBClusterSnapshotInput, opts ...request.Option) (*CopyDBClusterSnapshotOutput, error) {
	req, out := c.CopyDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBParameterGroup = "CopyDBParameterGroup"

// CopyDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBParameterGroup for more information on using the CopyDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBParameterGroupRequest method.
//    req, resp := client.CopyDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBParameterGroup
func (c *Neptune) CopyDBParameterGroupRequest(input *CopyDBParameterGroupInput) (req *request.Request, output *CopyDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCopyDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBParameterGroupInput{}
	}

	output = &CopyDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBParameterGroup API operation for Amazon Neptune.
//
// Copies the specified DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CopyDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB parameter
//   groups.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CopyDBParameterGroup
func (c *Neptune) CopyDBParameterGroup(input *CopyDBParameterGroupInput) (*CopyDBParameterGroupOutput, error) {
	req, out := c.CopyDBParameterGroupRequest(input)
	return out, req.Send()
}

// CopyDBParameterGroupWithContext is the same as CopyDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CopyDBParameterGroupWithContext(ctx aws.Context, input *CopyDBParameterGroupInput, opts ...request.Option) (*CopyDBParameterGroupOutput, error) {
	req, out := c.CopyDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBCluster = "CreateDBCluster"

// CreateDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBCluster for more information on using the CreateDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterRequest method.
//    req, resp := client.CreateDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBCluster
func (c *Neptune) CreateDBClusterRequest(input *CreateDBClusterInput) (req *request.Request, output *CreateDBClusterOutput) {
	op := &request.Operation{
		Name:       opCreateDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterInput{}
	}

	output = &CreateDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBCluster API operation for Amazon Neptune.
//
// Creates a new Amazon Neptune DB cluster.
//
// You can use the ReplicationSourceIdentifier parameter to create the DB cluster
// as a Read Replica of another DB cluster or Amazon Neptune DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CreateDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   User already has a DB cluster with the given identifier.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You may be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   User attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName does not refer to an existing DB Cluster parameter
//   group.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBCluster
func (c *Neptune) CreateDBCluster(input *CreateDBClusterInput) (*CreateDBClusterOutput, error) {
	req, out := c.CreateDBClusterRequest(input)
	return out, req.Send()
}

// CreateDBClusterWithContext is the same as CreateDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CreateDBClusterWithContext(ctx aws.Context, input *CreateDBClusterInput, opts ...request.Option) (*CreateDBClusterOutput, error) {
	req, out := c.CreateDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBClusterParameterGroup = "CreateDBClusterParameterGroup"

// CreateDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBClusterParameterGroup for more information on using the CreateDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterParameterGroupRequest method.
//    req, resp := client.CreateDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterParameterGroup
func (c *Neptune) CreateDBClusterParameterGroupRequest(input *CreateDBClusterParameterGroupInput) (req *request.Request, output *CreateDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterParameterGroupInput{}
	}

	output = &CreateDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBClusterParameterGroup API operation for Amazon Neptune.
//
// Creates a new DB cluster parameter group.
//
// Parameters in a DB cluster parameter group apply to all of the instances
// in a DB cluster.
//
// A DB cluster parameter group is initially created with the default parameters
// for the database engine used by instances in the DB cluster. To provide custom
// values for any of the parameters, you must modify the group after creating
// it using ModifyDBClusterParameterGroup. Once you've created a DB cluster
// parameter group, you need to associate it with your DB cluster using ModifyDBCluster.
// When you associate a new DB cluster parameter group with a running DB cluster,
// you need to reboot the DB instances in the DB cluster without failover for
// the new DB cluster parameter group and associated settings to take effect.
//
// After you create a DB cluster parameter group, you should wait at least 5
// minutes before creating your first DB cluster that uses that DB cluster parameter
// group as the default parameter group. This allows Amazon Neptune to fully
// complete the create action before the DB cluster parameter group is used
// as the default for a new DB cluster. This is especially important for parameters
// that are critical when creating the default database for a DB cluster, such
// as the character set for the default database defined by the character_set_database
// parameter. You can use the Parameter Groups option of the Amazon Neptune
// console (https://console.aws.amazon.com/rds/) or the DescribeDBClusterParameters
// command to verify that your DB cluster parameter group has been created or
// modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CreateDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB parameter
//   groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterParameterGroup
func (c *Neptune) CreateDBClusterParameterGroup(input *CreateDBClusterParameterGroupInput) (*CreateDBClusterParameterGroupOutput, error) {
	req, out := c.CreateDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// CreateDBClusterParameterGroupWithContext is the same as CreateDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CreateDBClusterParameterGroupWithContext(ctx aws.Context, input *CreateDBClusterParameterGroupInput, opts ...request.Option) (*CreateDBClusterParameterGroupOutput, error) {
	req, out := c.CreateDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBClusterSnapshot = "CreateDBClusterSnapshot"

// CreateDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBClusterSnapshot for more information on using the CreateDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterSnapshotRequest method.
//    req, resp := client.CreateDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterSnapshot
func (c *Neptune) CreateDBClusterSnapshotRequest(input *CreateDBClusterSnapshotInput) (req *request.Request, output *CreateDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterSnapshotInput{}
	}

	output = &CreateDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBClusterSnapshot API operation for Amazon Neptune.
//
// Creates a snapshot of a DB cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CreateDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   User already has a DB cluster snapshot with the given identifier.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBClusterSnapshot
func (c *Neptune) CreateDBClusterSnapshot(input *CreateDBClusterSnapshotInput) (*CreateDBClusterSnapshotOutput, error) {
	req, out := c.CreateDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// CreateDBClusterSnapshotWithContext is the same as CreateDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CreateDBClusterSnapshotWithContext(ctx aws.Context, input *CreateDBClusterSnapshotInput, opts ...request.Option) (*CreateDBClusterSnapshotOutput, error) {
	req, out := c.CreateDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBInstance = "CreateDBInstance"

// CreateDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBInstance for more information on using the CreateDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBInstanceRequest method.
//    req, resp := client.CreateDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBInstance
func (c *Neptune) CreateDBInstanceRequest(input *CreateDBInstanceInput) (req *request.Request, output *CreateDBInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceInput{}
	}

	output = &CreateDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBInstance API operation for Amazon Neptune.
//
// Creates a new DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CreateDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   User already has a DB instance with the given identifier.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   Specified DB instance class is not available in the specified Availability
//   Zone.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB instances.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The designated option group could not be found.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   StorageType specified cannot be associated with the DB Instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   Specified CIDRIP or EC2 security group is not authorized for the specified
//   DB security group.
//
//   Neptune may not also be authorized via IAM to perform necessary actions on
//   your behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain does not refer to an existing Active Directory Domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBInstance
func (c *Neptune) CreateDBInstance(input *CreateDBInstanceInput) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	return out, req.Send()
}

// CreateDBInstanceWithContext is the same as CreateDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CreateDBInstanceWithContext(ctx aws.Context, input *CreateDBInstanceInput, opts ...request.Option) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBParameterGroup = "CreateDBParameterGroup"

// CreateDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBParameterGroup for more information on using the CreateDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBParameterGroupRequest method.
//    req, resp := client.CreateDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBParameterGroup
func (c *Neptune) CreateDBParameterGroupRequest(input *CreateDBParameterGroupInput) (req *request.Request, output *CreateDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBParameterGroupInput{}
	}

	output = &CreateDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBParameterGroup API operation for Amazon Neptune.
//
// Creates a new DB parameter group.
//
// A DB parameter group is initially created with the default parameters for
// the database engine used by the DB instance. To provide custom values for
// any of the parameters, you must modify the group after creating it using
// ModifyDBParameterGroup. Once you've created a DB parameter group, you need
// to associate it with your DB instance using ModifyDBInstance. When you associate
// a new DB parameter group with a running DB instance, you need to reboot the
// DB instance without failover for the new DB parameter group and associated
// settings to take effect.
//
// After you create a DB parameter group, you should wait at least 5 minutes
// before creating your first DB instance that uses that DB parameter group
// as the default parameter group. This allows Amazon Neptune to fully complete
// the create action before the parameter group is used as the default for a
// new DB instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon Neptune console or
// the DescribeDBParameters command to verify that your DB parameter group has
// been created or modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CreateDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB parameter
//   groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBParameterGroup
func (c *Neptune) CreateDBParameterGroup(input *CreateDBParameterGroupInput) (*CreateDBParameterGroupOutput, error) {
	req, out := c.CreateDBParameterGroupRequest(input)
	return out, req.Send()
}

// CreateDBParameterGroupWithContext is the same as CreateDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CreateDBParameterGroupWithContext(ctx aws.Context, input *CreateDBParameterGroupInput, opts ...request.Option) (*CreateDBParameterGroupOutput, error) {
	req, out := c.CreateDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBSubnetGroup = "CreateDBSubnetGroup"

// CreateDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBSubnetGroup for more information on using the CreateDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBSubnetGroupRequest method.
//    req, resp := client.CreateDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBSubnetGroup
func (c *Neptune) CreateDBSubnetGroupRequest(input *CreateDBSubnetGroupInput) (req *request.Request, output *CreateDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSubnetGroupInput{}
	}

	output = &CreateDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBSubnetGroup API operation for Amazon Neptune.
//
// Creates a new DB subnet group. DB subnet groups must contain at least one
// subnet in at least two AZs in the AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CreateDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupAlreadyExistsFault "DBSubnetGroupAlreadyExists"
//   DBSubnetGroupName is already used by an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupQuotaExceededFault "DBSubnetGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB subnet groups.
//
//   * ErrCodeDBSubnetQuotaExceededFault "DBSubnetQuotaExceededFault"
//   Request would result in user exceeding the allowed number of subnets in a
//   DB subnet groups.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateDBSubnetGroup
func (c *Neptune) CreateDBSubnetGroup(input *CreateDBSubnetGroupInput) (*CreateDBSubnetGroupOutput, error) {
	req, out := c.CreateDBSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateDBSubnetGroupWithContext is the same as CreateDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CreateDBSubnetGroupWithContext(ctx aws.Context, input *CreateDBSubnetGroupInput, opts ...request.Option) (*CreateDBSubnetGroupOutput, error) {
	req, out := c.CreateDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventSubscription for more information on using the CreateEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventSubscriptionRequest method.
//    req, resp := client.CreateEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateEventSubscription
func (c *Neptune) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	output = &CreateEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSubscription API operation for Amazon Neptune.
//
// Creates an event notification subscription. This action requires a topic
// ARN (Amazon Resource Name) created by either the Neptune console, the SNS
// console, or the SNS API. To obtain an ARN with SNS, you must create a topic
// in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS
// console.
//
// You can specify the type of source (SourceType) you want to be notified of,
// provide a list of Neptune sources (SourceIds) that triggers the events, and
// provide a list of event categories (EventCategories) for events you want
// to be notified of. For example, you can specify SourceType = db-instance,
// SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability,
// Backup.
//
// If you specify both the SourceType and SourceIds, such as SourceType = db-instance
// and SourceIdentifier = myDBInstance1, you are notified of all the db-instance
// events for the specified source. If you specify a SourceType but do not specify
// a SourceIdentifier, you receive notice of the events for that source type
// for all your Neptune sources. If you do not specify either the SourceType
// nor the SourceIdentifier, you are notified of events generated from all Neptune
// sources belonging to your customer account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation CreateEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEventSubscriptionQuotaExceededFault "EventSubscriptionQuotaExceeded"
//   You have exceeded the number of events you can subscribe to.
//
//   * ErrCodeSubscriptionAlreadyExistFault "SubscriptionAlreadyExist"
//   This subscription already exists.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopic"
//   The SNS topic is invalid.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorization"
//   There is no SNS authorization.
//
//   * ErrCodeSNSTopicArnNotFoundFault "SNSTopicArnNotFound"
//   The ARN of the SNS topic could not be found.
//
//   * ErrCodeSubscriptionCategoryNotFoundFault "SubscriptionCategoryNotFound"
//   The designated subscription category could not be found.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The source could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/CreateEventSubscription
func (c *Neptune) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	return out, req.Send()
}

// CreateEventSubscriptionWithContext is the same as CreateEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) CreateEventSubscriptionWithContext(ctx aws.Context, input *CreateEventSubscriptionInput, opts ...request.Option) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBCluster = "DeleteDBCluster"

// DeleteDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBCluster for more information on using the DeleteDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterRequest method.
//    req, resp := client.DeleteDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBCluster
func (c *Neptune) DeleteDBClusterRequest(input *DeleteDBClusterInput) (req *request.Request, output *DeleteDBClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterInput{}
	}

	output = &DeleteDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBCluster API operation for Amazon Neptune.
//
// The DeleteDBCluster action deletes a previously provisioned DB cluster. When
// you delete a DB cluster, all automated backups for that DB cluster are deleted
// and can't be recovered. Manual DB cluster snapshots of the specified DB cluster
// are not deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DeleteDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   User already has a DB cluster snapshot with the given identifier.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBCluster
func (c *Neptune) DeleteDBCluster(input *DeleteDBClusterInput) (*DeleteDBClusterOutput, error) {
	req, out := c.DeleteDBClusterRequest(input)
	return out, req.Send()
}

// DeleteDBClusterWithContext is the same as DeleteDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DeleteDBClusterWithContext(ctx aws.Context, input *DeleteDBClusterInput, opts ...request.Option) (*DeleteDBClusterOutput, error) {
	req, out := c.DeleteDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBClusterParameterGroup = "DeleteDBClusterParameterGroup"

// DeleteDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBClusterParameterGroup for more information on using the DeleteDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterParameterGroupRequest method.
//    req, resp := client.DeleteDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterParameterGroup
func (c *Neptune) DeleteDBClusterParameterGroupRequest(input *DeleteDBClusterParameterGroupInput) (req *request.Request, output *DeleteDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterParameterGroupInput{}
	}

	output = &DeleteDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBClusterParameterGroup API operation for Amazon Neptune.
//
// Deletes a specified DB cluster parameter group. The DB cluster parameter
// group to be deleted can't be associated with any DB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DeleteDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterParameterGroup
func (c *Neptune) DeleteDBClusterParameterGroup(input *DeleteDBClusterParameterGroupInput) (*DeleteDBClusterParameterGroupOutput, error) {
	req, out := c.DeleteDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteDBClusterParameterGroupWithContext is the same as DeleteDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DeleteDBClusterParameterGroupWithContext(ctx aws.Context, input *DeleteDBClusterParameterGroupInput, opts ...request.Option) (*DeleteDBClusterParameterGroupOutput, error) {
	req, out := c.DeleteDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBClusterSnapshot = "DeleteDBClusterSnapshot"

// DeleteDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBClusterSnapshot for more information on using the DeleteDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterSnapshotRequest method.
//    req, resp := client.DeleteDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterSnapshot
func (c *Neptune) DeleteDBClusterSnapshotRequest(input *DeleteDBClusterSnapshotInput) (req *request.Request, output *DeleteDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterSnapshotInput{}
	}

	output = &DeleteDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBClusterSnapshot API operation for Amazon Neptune.
//
// Deletes a DB cluster snapshot. If the snapshot is being copied, the copy
// operation is terminated.
//
// The DB cluster snapshot must be in the available state to be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DeleteDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBClusterSnapshot
func (c *Neptune) DeleteDBClusterSnapshot(input *DeleteDBClusterSnapshotInput) (*DeleteDBClusterSnapshotOutput, error) {
	req, out := c.DeleteDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// DeleteDBClusterSnapshotWithContext is the same as DeleteDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DeleteDBClusterSnapshotWithContext(ctx aws.Context, input *DeleteDBClusterSnapshotInput, opts ...request.Option) (*DeleteDBClusterSnapshotOutput, error) {
	req, out := c.DeleteDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBInstance = "DeleteDBInstance"

// DeleteDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBInstance for more information on using the DeleteDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBInstanceRequest method.
//    req, resp := client.DeleteDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBInstance
func (c *Neptune) DeleteDBInstanceRequest(input *DeleteDBInstanceInput) (req *request.Request, output *DeleteDBInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBInstanceInput{}
	}

	output = &DeleteDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBInstance API operation for Amazon Neptune.
//
// The DeleteDBInstance action deletes a previously provisioned DB instance.
// When you delete a DB instance, all automated backups for that instance are
// deleted and can't be recovered. Manual DB snapshots of the DB instance to
// be deleted by DeleteDBInstance are not deleted.
//
// If you request a final DB snapshot the status of the Amazon Neptune DB instance
// is deleting until the DB snapshot is created. The API action DescribeDBInstance
// is used to monitor the status of this operation. The action can't be canceled
// or reverted once submitted.
//
// Note that when a DB instance is in a failure state and has a status of failed,
// incompatible-restore, or incompatible-network, you can only delete it when
// the SkipFinalSnapshot parameter is set to true.
//
// If the specified DB instance is part of a DB cluster, you can't delete the
// DB instance if both of the following conditions are true:
//
//    * The DB instance is the only instance in the DB cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DeleteDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already used by an existing snapshot.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBInstance
func (c *Neptune) DeleteDBInstance(input *DeleteDBInstanceInput) (*DeleteDBInstanceOutput, error) {
	req, out := c.DeleteDBInstanceRequest(input)
	return out, req.Send()
}

// DeleteDBInstanceWithContext is the same as DeleteDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DeleteDBInstanceWithContext(ctx aws.Context, input *DeleteDBInstanceInput, opts ...request.Option) (*DeleteDBInstanceOutput, error) {
	req, out := c.DeleteDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBParameterGroup = "DeleteDBParameterGroup"

// DeleteDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBParameterGroup for more information on using the DeleteDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBParameterGroupRequest method.
//    req, resp := client.DeleteDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBParameterGroup
func (c *Neptune) DeleteDBParameterGroupRequest(input *DeleteDBParameterGroupInput) (req *request.Request, output *DeleteDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBParameterGroupInput{}
	}

	output = &DeleteDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBParameterGroup API operation for Amazon Neptune.
//
// Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted
// can't be associated with any DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DeleteDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBParameterGroup
func (c *Neptune) DeleteDBParameterGroup(input *DeleteDBParameterGroupInput) (*DeleteDBParameterGroupOutput, error) {
	req, out := c.DeleteDBParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteDBParameterGroupWithContext is the same as DeleteDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DeleteDBParameterGroupWithContext(ctx aws.Context, input *DeleteDBParameterGroupInput, opts ...request.Option) (*DeleteDBParameterGroupOutput, error) {
	req, out := c.DeleteDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBSubnetGroup = "DeleteDBSubnetGroup"

// DeleteDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBSubnetGroup for more information on using the DeleteDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBSubnetGroupRequest method.
//    req, resp := client.DeleteDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroup
func (c *Neptune) DeleteDBSubnetGroupRequest(input *DeleteDBSubnetGroupInput) (req *request.Request, output *DeleteDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSubnetGroupInput{}
	}

	output = &DeleteDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBSubnetGroup API operation for Amazon Neptune.
//
// Deletes a DB subnet group.
//
// The specified database subnet group must not be associated with any DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DeleteDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidDBSubnetStateFault "InvalidDBSubnetStateFault"
//   The DB subnet is not in the available state.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroup
func (c *Neptune) DeleteDBSubnetGroup(input *DeleteDBSubnetGroupInput) (*DeleteDBSubnetGroupOutput, error) {
	req, out := c.DeleteDBSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteDBSubnetGroupWithContext is the same as DeleteDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DeleteDBSubnetGroupWithContext(ctx aws.Context, input *DeleteDBSubnetGroupInput, opts ...request.Option) (*DeleteDBSubnetGroupOutput, error) {
	req, out := c.DeleteDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventSubscription for more information on using the DeleteEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventSubscriptionRequest method.
//    req, resp := client.DeleteEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteEventSubscription
func (c *Neptune) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	output = &DeleteEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventSubscription API operation for Amazon Neptune.
//
// Deletes an event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DeleteEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The designated subscription could not be found.
//
//   * ErrCodeInvalidEventSubscriptionStateFault "InvalidEventSubscriptionState"
//   The event subscription is in an invalid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteEventSubscription
func (c *Neptune) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteEventSubscriptionWithContext is the same as DeleteEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DeleteEventSubscriptionWithContext(ctx aws.Context, input *DeleteEventSubscriptionInput, opts ...request.Option) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterParameterGroups = "DescribeDBClusterParameterGroups"

// DescribeDBClusterParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterParameterGroups for more information on using the DescribeDBClusterParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterParameterGroupsRequest method.
//    req, resp := client.DescribeDBClusterParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups
func (c *Neptune) DescribeDBClusterParameterGroupsRequest(input *DescribeDBClusterParameterGroupsInput) (req *request.Request, output *DescribeDBClusterParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterParameterGroupsInput{}
	}

	output = &DescribeDBClusterParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterParameterGroups API operation for Amazon Neptune.
//
// Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName
// parameter is specified, the list will contain only the description of the
// specified DB cluster parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBClusterParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameterGroups
func (c *Neptune) DescribeDBClusterParameterGroups(input *DescribeDBClusterParameterGroupsInput) (*DescribeDBClusterParameterGroupsOutput, error) {
	req, out := c.DescribeDBClusterParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBClusterParameterGroupsWithContext is the same as DescribeDBClusterParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBClusterParameterGroupsWithContext(ctx aws.Context, input *DescribeDBClusterParameterGroupsInput, opts ...request.Option) (*DescribeDBClusterParameterGroupsOutput, error) {
	req, out := c.DescribeDBClusterParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterParameters = "DescribeDBClusterParameters"

// DescribeDBClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterParameters for more information on using the DescribeDBClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterParametersRequest method.
//    req, resp := client.DescribeDBClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameters
func (c *Neptune) DescribeDBClusterParametersRequest(input *DescribeDBClusterParametersInput) (req *request.Request, output *DescribeDBClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterParametersInput{}
	}

	output = &DescribeDBClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterParameters API operation for Amazon Neptune.
//
// Returns the detailed parameter list for a particular DB cluster parameter
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBClusterParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterParameters
func (c *Neptune) DescribeDBClusterParameters(input *DescribeDBClusterParametersInput) (*DescribeDBClusterParametersOutput, error) {
	req, out := c.DescribeDBClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeDBClusterParametersWithContext is the same as DescribeDBClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBClusterParametersWithContext(ctx aws.Context, input *DescribeDBClusterParametersInput, opts ...request.Option) (*DescribeDBClusterParametersOutput, error) {
	req, out := c.DescribeDBClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterSnapshotAttributes = "DescribeDBClusterSnapshotAttributes"

// DescribeDBClusterSnapshotAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterSnapshotAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterSnapshotAttributes for more information on using the DescribeDBClusterSnapshotAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterSnapshotAttributesRequest method.
//    req, resp := client.DescribeDBClusterSnapshotAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshotAttributes
func (c *Neptune) DescribeDBClusterSnapshotAttributesRequest(input *DescribeDBClusterSnapshotAttributesInput) (req *request.Request, output *DescribeDBClusterSnapshotAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterSnapshotAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotAttributesInput{}
	}

	output = &DescribeDBClusterSnapshotAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterSnapshotAttributes API operation for Amazon Neptune.
//
// Returns a list of DB cluster snapshot attribute names and values for a manual
// DB cluster snapshot.
//
// When sharing snapshots with other AWS accounts, DescribeDBClusterSnapshotAttributes
// returns the restore attribute and a list of IDs for the AWS accounts that
// are authorized to copy or restore the manual DB cluster snapshot. If all
// is included in the list of values for the restore attribute, then the manual
// DB cluster snapshot is public and can be copied or restored by all AWS accounts.
//
// To add or remove access for an AWS account to copy or restore a manual DB
// cluster snapshot, or to make the manual DB cluster snapshot public or private,
// use the ModifyDBClusterSnapshotAttribute API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBClusterSnapshotAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshotAttributes
func (c *Neptune) DescribeDBClusterSnapshotAttributes(input *DescribeDBClusterSnapshotAttributesInput) (*DescribeDBClusterSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBClusterSnapshotAttributesRequest(input)
	return out, req.Send()
}

// DescribeDBClusterSnapshotAttributesWithContext is the same as DescribeDBClusterSnapshotAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterSnapshotAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBClusterSnapshotAttributesWithContext(ctx aws.Context, input *DescribeDBClusterSnapshotAttributesInput, opts ...request.Option) (*DescribeDBClusterSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBClusterSnapshotAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterSnapshots = "DescribeDBClusterSnapshots"

// DescribeDBClusterSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterSnapshots for more information on using the DescribeDBClusterSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterSnapshotsRequest method.
//    req, resp := client.DescribeDBClusterSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots
func (c *Neptune) DescribeDBClusterSnapshotsRequest(input *DescribeDBClusterSnapshotsInput) (req *request.Request, output *DescribeDBClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotsInput{}
	}

	output = &DescribeDBClusterSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterSnapshots API operation for Amazon Neptune.
//
// Returns information about DB cluster snapshots. This API action supports
// pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBClusterSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusterSnapshots
func (c *Neptune) DescribeDBClusterSnapshots(input *DescribeDBClusterSnapshotsInput) (*DescribeDBClusterSnapshotsOutput, error) {
	req, out := c.DescribeDBClusterSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeDBClusterSnapshotsWithContext is the same as DescribeDBClusterSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBClusterSnapshotsWithContext(ctx aws.Context, input *DescribeDBClusterSnapshotsInput, opts ...request.Option) (*DescribeDBClusterSnapshotsOutput, error) {
	req, out := c.DescribeDBClusterSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusters = "DescribeDBClusters"

// DescribeDBClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusters for more information on using the DescribeDBClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClustersRequest method.
//    req, resp := client.DescribeDBClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters
func (c *Neptune) DescribeDBClustersRequest(input *DescribeDBClustersInput) (req *request.Request, output *DescribeDBClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClustersInput{}
	}

	output = &DescribeDBClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusters API operation for Amazon Neptune.
//
// Returns information about provisioned DB clusters. This API supports pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBClusters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBClusters
func (c *Neptune) DescribeDBClusters(input *DescribeDBClustersInput) (*DescribeDBClustersOutput, error) {
	req, out := c.DescribeDBClustersRequest(input)
	return out, req.Send()
}

// DescribeDBClustersWithContext is the same as DescribeDBClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBClustersWithContext(ctx aws.Context, input *DescribeDBClustersInput, opts ...request.Option) (*DescribeDBClustersOutput, error) {
	req, out := c.DescribeDBClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBEngineVersions = "DescribeDBEngineVersions"

// DescribeDBEngineVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBEngineVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBEngineVersions for more information on using the DescribeDBEngineVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBEngineVersionsRequest method.
//    req, resp := client.DescribeDBEngineVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions
func (c *Neptune) DescribeDBEngineVersionsRequest(input *DescribeDBEngineVersionsInput) (req *request.Request, output *DescribeDBEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBEngineVersionsInput{}
	}

	output = &DescribeDBEngineVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBEngineVersions API operation for Amazon Neptune.
//
// Returns a list of the available DB engines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBEngineVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBEngineVersions
func (c *Neptune) DescribeDBEngineVersions(input *DescribeDBEngineVersionsInput) (*DescribeDBEngineVersionsOutput, error) {
	req, out := c.DescribeDBEngineVersionsRequest(input)
	return out, req.Send()
}

// DescribeDBEngineVersionsWithContext is the same as DescribeDBEngineVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBEngineVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBEngineVersionsWithContext(ctx aws.Context, input *DescribeDBEngineVersionsInput, opts ...request.Option) (*DescribeDBEngineVersionsOutput, error) {
	req, out := c.DescribeDBEngineVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBEngineVersionsPages iterates over the pages of a DescribeDBEngineVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBEngineVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBEngineVersions operation.
//    pageNum := 0
//    err := client.DescribeDBEngineVersionsPages(params,
//        func(page *DescribeDBEngineVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Neptune) DescribeDBEngineVersionsPages(input *DescribeDBEngineVersionsInput, fn func(*DescribeDBEngineVersionsOutput, bool) bool) error {
	return c.DescribeDBEngineVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBEngineVersionsPagesWithContext same as DescribeDBEngineVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBEngineVersionsPagesWithContext(ctx aws.Context, input *DescribeDBEngineVersionsInput, fn func(*DescribeDBEngineVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBEngineVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBEngineVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBEngineVersionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBInstances = "DescribeDBInstances"

// DescribeDBInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBInstances for more information on using the DescribeDBInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBInstancesRequest method.
//    req, resp := client.DescribeDBInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances
func (c *Neptune) DescribeDBInstancesRequest(input *DescribeDBInstancesInput) (req *request.Request, output *DescribeDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBInstancesInput{}
	}

	output = &DescribeDBInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBInstances API operation for Amazon Neptune.
//
// Returns information about provisioned instances. This API supports pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBInstances
func (c *Neptune) DescribeDBInstances(input *DescribeDBInstancesInput) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	return out, req.Send()
}

// DescribeDBInstancesWithContext is the same as DescribeDBInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBInstancesWithContext(ctx aws.Context, input *DescribeDBInstancesInput, opts ...request.Option) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBInstancesPages iterates over the pages of a DescribeDBInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBInstances operation.
//    pageNum := 0
//    err := client.DescribeDBInstancesPages(params,
//        func(page *DescribeDBInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Neptune) DescribeDBInstancesPages(input *DescribeDBInstancesInput, fn func(*DescribeDBInstancesOutput, bool) bool) error {
	return c.DescribeDBInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBInstancesPagesWithContext same as DescribeDBInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBInstancesPagesWithContext(ctx aws.Context, input *DescribeDBInstancesInput, fn func(*DescribeDBInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBParameterGroups = "DescribeDBParameterGroups"

// DescribeDBParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBParameterGroups for more information on using the DescribeDBParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBParameterGroupsRequest method.
//    req, resp := client.DescribeDBParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups
func (c *Neptune) DescribeDBParameterGroupsRequest(input *DescribeDBParameterGroupsInput) (req *request.Request, output *DescribeDBParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBParameterGroupsInput{}
	}

	output = &DescribeDBParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBParameterGroups API operation for Amazon Neptune.
//
// Returns a list of DBParameterGroup descriptions. If a DBParameterGroupName
// is specified, the list will contain only the description of the specified
// DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameterGroups
func (c *Neptune) DescribeDBParameterGroups(input *DescribeDBParameterGroupsInput) (*DescribeDBParameterGroupsOutput, error) {
	req, out := c.DescribeDBParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBParameterGroupsWithContext is the same as DescribeDBParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBParameterGroupsWithContext(ctx aws.Context, input *DescribeDBParameterGroupsInput, opts ...request.Option) (*DescribeDBParameterGroupsOutput, error) {
	req, out := c.DescribeDBParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBParameterGroupsPages iterates over the pages of a DescribeDBParameterGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBParameterGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBParameterGroups operation.
//    pageNum := 0
//    err := client.DescribeDBParameterGroupsPages(params,
//        func(page *DescribeDBParameterGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Neptune) DescribeDBParameterGroupsPages(input *DescribeDBParameterGroupsInput, fn func(*DescribeDBParameterGroupsOutput, bool) bool) error {
	return c.DescribeDBParameterGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBParameterGroupsPagesWithContext same as DescribeDBParameterGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBParameterGroupsPagesWithContext(ctx aws.Context, input *DescribeDBParameterGroupsInput, fn func(*DescribeDBParameterGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBParameterGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBParameterGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBParameterGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBParameters = "DescribeDBParameters"

// DescribeDBParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBParameters for more information on using the DescribeDBParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBParametersRequest method.
//    req, resp := client.DescribeDBParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters
func (c *Neptune) DescribeDBParametersRequest(input *DescribeDBParametersInput) (req *request.Request, output *DescribeDBParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBParametersInput{}
	}

	output = &DescribeDBParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBParameters API operation for Amazon Neptune.
//
// Returns the detailed parameter list for a particular DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBParameters
func (c *Neptune) DescribeDBParameters(input *DescribeDBParametersInput) (*DescribeDBParametersOutput, error) {
	req, out := c.DescribeDBParametersRequest(input)
	return out, req.Send()
}

// DescribeDBParametersWithContext is the same as DescribeDBParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBParametersWithContext(ctx aws.Context, input *DescribeDBParametersInput, opts ...request.Option) (*DescribeDBParametersOutput, error) {
	req, out := c.DescribeDBParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBParametersPages iterates over the pages of a DescribeDBParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBParameters operation.
//    pageNum := 0
//    err := client.DescribeDBParametersPages(params,
//        func(page *DescribeDBParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Neptune) DescribeDBParametersPages(input *DescribeDBParametersInput, fn func(*DescribeDBParametersOutput, bool) bool) error {
	return c.DescribeDBParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBParametersPagesWithContext same as DescribeDBParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBParametersPagesWithContext(ctx aws.Context, input *DescribeDBParametersInput, fn func(*DescribeDBParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBParametersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBSubnetGroups = "DescribeDBSubnetGroups"

// DescribeDBSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSubnetGroups for more information on using the DescribeDBSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSubnetGroupsRequest method.
//    req, resp := client.DescribeDBSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups
func (c *Neptune) DescribeDBSubnetGroupsRequest(input *DescribeDBSubnetGroupsInput) (req *request.Request, output *DescribeDBSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSubnetGroupsInput{}
	}

	output = &DescribeDBSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSubnetGroups API operation for Amazon Neptune.
//
// Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified,
// the list will contain only the descriptions of the specified DBSubnetGroup.
//
// For an overview of CIDR ranges, go to the Wikipedia Tutorial (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeDBSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeDBSubnetGroups
func (c *Neptune) DescribeDBSubnetGroups(input *DescribeDBSubnetGroupsInput) (*DescribeDBSubnetGroupsOutput, error) {
	req, out := c.DescribeDBSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBSubnetGroupsWithContext is the same as DescribeDBSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBSubnetGroupsWithContext(ctx aws.Context, input *DescribeDBSubnetGroupsInput, opts ...request.Option) (*DescribeDBSubnetGroupsOutput, error) {
	req, out := c.DescribeDBSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBSubnetGroupsPages iterates over the pages of a DescribeDBSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBSubnetGroups operation.
//    pageNum := 0
//    err := client.DescribeDBSubnetGroupsPages(params,
//        func(page *DescribeDBSubnetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Neptune) DescribeDBSubnetGroupsPages(input *DescribeDBSubnetGroupsInput, fn func(*DescribeDBSubnetGroupsOutput, bool) bool) error {
	return c.DescribeDBSubnetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBSubnetGroupsPagesWithContext same as DescribeDBSubnetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeDBSubnetGroupsPagesWithContext(ctx aws.Context, input *DescribeDBSubnetGroupsInput, fn func(*DescribeDBSubnetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBSubnetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBSubnetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBSubnetGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEngineDefaultClusterParameters = "DescribeEngineDefaultClusterParameters"

// DescribeEngineDefaultClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineDefaultClusterParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineDefaultClusterParameters for more information on using the DescribeEngineDefaultClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEngineDefaultClusterParametersRequest method.
//    req, resp := client.DescribeEngineDefaultClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultClusterParameters
func (c *Neptune) DescribeEngineDefaultClusterParametersRequest(input *DescribeEngineDefaultClusterParametersInput) (req *request.Request, output *DescribeEngineDefaultClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEngineDefaultClusterParametersInput{}
	}

	output = &DescribeEngineDefaultClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineDefaultClusterParameters API operation for Amazon Neptune.
//
// Returns the default engine and system parameter information for the cluster
// database engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeEngineDefaultClusterParameters for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultClusterParameters
func (c *Neptune) DescribeEngineDefaultClusterParameters(input *DescribeEngineDefaultClusterParametersInput) (*DescribeEngineDefaultClusterParametersOutput, error) {
	req, out := c.DescribeEngineDefaultClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeEngineDefaultClusterParametersWithContext is the same as DescribeEngineDefaultClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineDefaultClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeEngineDefaultClusterParametersWithContext(ctx aws.Context, input *DescribeEngineDefaultClusterParametersInput, opts ...request.Option) (*DescribeEngineDefaultClusterParametersOutput, error) {
	req, out := c.DescribeEngineDefaultClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEngineDefaultParameters = "DescribeEngineDefaultParameters"

// DescribeEngineDefaultParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineDefaultParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineDefaultParameters for more information on using the DescribeEngineDefaultParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEngineDefaultParametersRequest method.
//    req, resp := client.DescribeEngineDefaultParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters
func (c *Neptune) DescribeEngineDefaultParametersRequest(input *DescribeEngineDefaultParametersInput) (req *request.Request, output *DescribeEngineDefaultParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"EngineDefaults.Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEngineDefaultParametersInput{}
	}

	output = &DescribeEngineDefaultParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineDefaultParameters API operation for Amazon Neptune.
//
// Returns the default engine and system parameter information for the specified
// database engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeEngineDefaultParameters for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEngineDefaultParameters
func (c *Neptune) DescribeEngineDefaultParameters(input *DescribeEngineDefaultParametersInput) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	return out, req.Send()
}

// DescribeEngineDefaultParametersWithContext is the same as DescribeEngineDefaultParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineDefaultParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeEngineDefaultParametersWithContext(ctx aws.Context, input *DescribeEngineDefaultParametersInput, opts ...request.Option) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEngineDefaultParametersPages iterates over the pages of a DescribeEngineDefaultParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEngineDefaultParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEngineDefaultParameters operation.
//    pageNum := 0
//    err := client.DescribeEngineDefaultParametersPages(params,
//        func(page *DescribeEngineDefaultParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Neptune) DescribeEngineDefaultParametersPages(input *DescribeEngineDefaultParametersInput, fn func(*DescribeEngineDefaultParametersOutput, bool) bool) error {
	return c.DescribeEngineDefaultParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEngineDefaultParametersPagesWithContext same as DescribeEngineDefaultParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeEngineDefaultParametersPagesWithContext(ctx aws.Context, input *DescribeEngineDefaultParametersInput, fn func(*DescribeEngineDefaultParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEngineDefaultParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEngineDefaultParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEngineDefaultParametersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventCategories for more information on using the DescribeEventCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventCategoriesRequest method.
//    req, resp := client.DescribeEventCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventCategories
func (c *Neptune) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	output = &DescribeEventCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventCategories API operation for Amazon Neptune.
//
// Displays a list of categories for all event source types, or, if specified,
// for a specified source type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeEventCategories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventCategories
func (c *Neptune) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	return out, req.Send()
}

// DescribeEventCategoriesWithContext is the same as DescribeEventCategories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeEventCategoriesWithContext(ctx aws.Context, input *DescribeEventCategoriesInput, opts ...request.Option) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventSubscriptions for more information on using the DescribeEventSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventSubscriptionsRequest method.
//    req, resp := client.DescribeEventSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions
func (c *Neptune) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	output = &DescribeEventSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSubscriptions API operation for Amazon Neptune.
//
// Lists all the subscription descriptions for a customer account. The description
// for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType,
// SourceID, CreationTime, and Status.
//
// If you specify a SubscriptionName, lists the description for that subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeEventSubscriptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The designated subscription could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEventSubscriptions
func (c *Neptune) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeEventSubscriptionsWithContext is the same as DescribeEventSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeEventSubscriptionsWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, opts ...request.Option) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventSubscriptionsPages iterates over the pages of a DescribeEventSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEventSubscriptions operation.
//    pageNum := 0
//    err := client.DescribeEventSubscriptionsPages(params,
//        func(page *DescribeEventSubscriptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Neptune) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool) error {
	return c.DescribeEventSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventSubscriptionsPagesWithContext same as DescribeEventSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeEventSubscriptionsPagesWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEventSubscriptionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents
func (c *Neptune) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for Amazon Neptune.
//
// Returns events related to DB instances, DB security groups, DB snapshots,
// and DB parameter groups for the past 14 days. Events specific to a particular
// DB instance, DB security group, database snapshot, or DB parameter group
// can be obtained by providing the name as a parameter. By default, the past
// hour of events are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeEvents
func (c *Neptune) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Neptune) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeOrderableDBInstanceOptions = "DescribeOrderableDBInstanceOptions"

// DescribeOrderableDBInstanceOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableDBInstanceOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrderableDBInstanceOptions for more information on using the DescribeOrderableDBInstanceOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrderableDBInstanceOptionsRequest method.
//    req, resp := client.DescribeOrderableDBInstanceOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions
func (c *Neptune) DescribeOrderableDBInstanceOptionsRequest(input *DescribeOrderableDBInstanceOptionsInput) (req *request.Request, output *DescribeOrderableDBInstanceOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableDBInstanceOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableDBInstanceOptionsInput{}
	}

	output = &DescribeOrderableDBInstanceOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrderableDBInstanceOptions API operation for Amazon Neptune.
//
// Returns a list of orderable DB instance options for the specified engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeOrderableDBInstanceOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeOrderableDBInstanceOptions
func (c *Neptune) DescribeOrderableDBInstanceOptions(input *DescribeOrderableDBInstanceOptionsInput) (*DescribeOrderableDBInstanceOptionsOutput, error) {
	req, out := c.DescribeOrderableDBInstanceOptionsRequest(input)
	return out, req.Send()
}

// DescribeOrderableDBInstanceOptionsWithContext is the same as DescribeOrderableDBInstanceOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrderableDBInstanceOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeOrderableDBInstanceOptionsWithContext(ctx aws.Context, input *DescribeOrderableDBInstanceOptionsInput, opts ...request.Option) (*DescribeOrderableDBInstanceOptionsOutput, error) {
	req, out := c.DescribeOrderableDBInstanceOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrderableDBInstanceOptionsPages iterates over the pages of a DescribeOrderableDBInstanceOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrderableDBInstanceOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrderableDBInstanceOptions operation.
//    pageNum := 0
//    err := client.DescribeOrderableDBInstanceOptionsPages(params,
//        func(page *DescribeOrderableDBInstanceOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Neptune) DescribeOrderableDBInstanceOptionsPages(input *DescribeOrderableDBInstanceOptionsInput, fn func(*DescribeOrderableDBInstanceOptionsOutput, bool) bool) error {
	return c.DescribeOrderableDBInstanceOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrderableDBInstanceOptionsPagesWithContext same as DescribeOrderableDBInstanceOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeOrderableDBInstanceOptionsPagesWithContext(ctx aws.Context, input *DescribeOrderableDBInstanceOptionsInput, fn func(*DescribeOrderableDBInstanceOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrderableDBInstanceOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrderableDBInstanceOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeOrderableDBInstanceOptionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribePendingMaintenanceActions = "DescribePendingMaintenanceActions"

// DescribePendingMaintenanceActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePendingMaintenanceActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePendingMaintenanceActions for more information on using the DescribePendingMaintenanceActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePendingMaintenanceActionsRequest method.
//    req, resp := client.DescribePendingMaintenanceActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions
func (c *Neptune) DescribePendingMaintenanceActionsRequest(input *DescribePendingMaintenanceActionsInput) (req *request.Request, output *DescribePendingMaintenanceActionsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingMaintenanceActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePendingMaintenanceActionsInput{}
	}

	output = &DescribePendingMaintenanceActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePendingMaintenanceActions API operation for Amazon Neptune.
//
// Returns a list of resources (for example, DB instances) that have at least
// one pending maintenance action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribePendingMaintenanceActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribePendingMaintenanceActions
func (c *Neptune) DescribePendingMaintenanceActions(input *DescribePendingMaintenanceActionsInput) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	return out, req.Send()
}

// DescribePendingMaintenanceActionsWithContext is the same as DescribePendingMaintenanceActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePendingMaintenanceActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribePendingMaintenanceActionsWithContext(ctx aws.Context, input *DescribePendingMaintenanceActionsInput, opts ...request.Option) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeValidDBInstanceModifications = "DescribeValidDBInstanceModifications"

// DescribeValidDBInstanceModificationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeValidDBInstanceModifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeValidDBInstanceModifications for more information on using the DescribeValidDBInstanceModifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeValidDBInstanceModificationsRequest method.
//    req, resp := client.DescribeValidDBInstanceModificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeValidDBInstanceModifications
func (c *Neptune) DescribeValidDBInstanceModificationsRequest(input *DescribeValidDBInstanceModificationsInput) (req *request.Request, output *DescribeValidDBInstanceModificationsOutput) {
	op := &request.Operation{
		Name:       opDescribeValidDBInstanceModifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeValidDBInstanceModificationsInput{}
	}

	output = &DescribeValidDBInstanceModificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeValidDBInstanceModifications API operation for Amazon Neptune.
//
// You can call DescribeValidDBInstanceModifications to learn what modifications
// you can make to your DB instance. You can use this information when you call
// ModifyDBInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation DescribeValidDBInstanceModifications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DescribeValidDBInstanceModifications
func (c *Neptune) DescribeValidDBInstanceModifications(input *DescribeValidDBInstanceModificationsInput) (*DescribeValidDBInstanceModificationsOutput, error) {
	req, out := c.DescribeValidDBInstanceModificationsRequest(input)
	return out, req.Send()
}

// DescribeValidDBInstanceModificationsWithContext is the same as DescribeValidDBInstanceModifications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeValidDBInstanceModifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) DescribeValidDBInstanceModificationsWithContext(ctx aws.Context, input *DescribeValidDBInstanceModificationsInput, opts ...request.Option) (*DescribeValidDBInstanceModificationsOutput, error) {
	req, out := c.DescribeValidDBInstanceModificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opFailoverDBCluster = "FailoverDBCluster"

// FailoverDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the FailoverDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FailoverDBCluster for more information on using the FailoverDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FailoverDBClusterRequest method.
//    req, resp := client.FailoverDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverDBCluster
func (c *Neptune) FailoverDBClusterRequest(input *FailoverDBClusterInput) (req *request.Request, output *FailoverDBClusterOutput) {
	op := &request.Operation{
		Name:       opFailoverDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &FailoverDBClusterInput{}
	}

	output = &FailoverDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// FailoverDBCluster API operation for Amazon Neptune.
//
// Forces a failover for a DB cluster.
//
// A failover for a DB cluster promotes one of the Read Replicas (read-only
// instances) in the DB cluster to be the primary instance (the cluster writer).
//
// Amazon Neptune will automatically fail over to a Read Replica, if one exists,
// when the primary instance fails. You can force a failover when you want to
// simulate a failure of a primary instance for testing. Because each instance
// in a DB cluster has its own endpoint address, you will need to clean up and
// re-establish any existing connections that use those endpoint addresses when
// the failover is complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation FailoverDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/FailoverDBCluster
func (c *Neptune) FailoverDBCluster(input *FailoverDBClusterInput) (*FailoverDBClusterOutput, error) {
	req, out := c.FailoverDBClusterRequest(input)
	return out, req.Send()
}

// FailoverDBClusterWithContext is the same as FailoverDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See FailoverDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) FailoverDBClusterWithContext(ctx aws.Context, input *FailoverDBClusterInput, opts ...request.Option) (*FailoverDBClusterOutput, error) {
	req, out := c.FailoverDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ListTagsForResource
func (c *Neptune) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Neptune.
//
// Lists all tags on an Amazon Neptune resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ListTagsForResource
func (c *Neptune) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBCluster = "ModifyDBCluster"

// ModifyDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBCluster for more information on using the ModifyDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterRequest method.
//    req, resp := client.ModifyDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBCluster
func (c *Neptune) ModifyDBClusterRequest(input *ModifyDBClusterInput) (req *request.Request, output *ModifyDBClusterOutput) {
	op := &request.Operation{
		Name:       opModifyDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterInput{}
	}

	output = &ModifyDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBCluster API operation for Amazon Neptune.
//
// Modify a setting for a DB cluster. You can change one or more database configuration
// parameters by specifying these parameters and the new values in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ModifyDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName does not refer to an existing DB Cluster parameter
//   group.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group does not allow deletion.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   User already has a DB cluster with the given identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBCluster
func (c *Neptune) ModifyDBCluster(input *ModifyDBClusterInput) (*ModifyDBClusterOutput, error) {
	req, out := c.ModifyDBClusterRequest(input)
	return out, req.Send()
}

// ModifyDBClusterWithContext is the same as ModifyDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ModifyDBClusterWithContext(ctx aws.Context, input *ModifyDBClusterInput, opts ...request.Option) (*ModifyDBClusterOutput, error) {
	req, out := c.ModifyDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBClusterParameterGroup = "ModifyDBClusterParameterGroup"

// ModifyDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBClusterParameterGroup for more information on using the ModifyDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterParameterGroupRequest method.
//    req, resp := client.ModifyDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterParameterGroup
func (c *Neptune) ModifyDBClusterParameterGroupRequest(input *ModifyDBClusterParameterGroupInput) (req *request.Request, output *ResetDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opModifyDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterParameterGroupInput{}
	}

	output = &ResetDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBClusterParameterGroup API operation for Amazon Neptune.
//
// Modifies the parameters of a DB cluster parameter group. To modify more than
// one parameter, submit a list of the following: ParameterName, ParameterValue,
// and ApplyMethod. A maximum of 20 parameters can be modified in a single request.
//
// Changes to dynamic parameters are applied immediately. Changes to static
// parameters require a reboot without failover to the DB cluster associated
// with the parameter group before the change can take effect.
//
// After you create a DB cluster parameter group, you should wait at least 5
// minutes before creating your first DB cluster that uses that DB cluster parameter
// group as the default parameter group. This allows Amazon Neptune to fully
// complete the create action before the parameter group is used as the default
// for a new DB cluster. This is especially important for parameters that are
// critical when creating the default database for a DB cluster, such as the
// character set for the default database defined by the character_set_database
// parameter. You can use the Parameter Groups option of the Amazon Neptune
// console or the DescribeDBClusterParameters command to verify that your DB
// cluster parameter group has been created or modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ModifyDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterParameterGroup
func (c *Neptune) ModifyDBClusterParameterGroup(input *ModifyDBClusterParameterGroupInput) (*ResetDBClusterParameterGroupOutput, error) {
	req, out := c.ModifyDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ModifyDBClusterParameterGroupWithContext is the same as ModifyDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ModifyDBClusterParameterGroupWithContext(ctx aws.Context, input *ModifyDBClusterParameterGroupInput, opts ...request.Option) (*ResetDBClusterParameterGroupOutput, error) {
	req, out := c.ModifyDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBClusterSnapshotAttribute = "ModifyDBClusterSnapshotAttribute"

// ModifyDBClusterSnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBClusterSnapshotAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBClusterSnapshotAttribute for more information on using the ModifyDBClusterSnapshotAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterSnapshotAttributeRequest method.
//    req, resp := client.ModifyDBClusterSnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterSnapshotAttribute
func (c *Neptune) ModifyDBClusterSnapshotAttributeRequest(input *ModifyDBClusterSnapshotAttributeInput) (req *request.Request, output *ModifyDBClusterSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyDBClusterSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterSnapshotAttributeInput{}
	}

	output = &ModifyDBClusterSnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBClusterSnapshotAttribute API operation for Amazon Neptune.
//
// Adds an attribute and values to, or removes an attribute and values from,
// a manual DB cluster snapshot.
//
// To share a manual DB cluster snapshot with other AWS accounts, specify restore
// as the AttributeName and use the ValuesToAdd parameter to add a list of IDs
// of the AWS accounts that are authorized to restore the manual DB cluster
// snapshot. Use the value all to make the manual DB cluster snapshot public,
// which means that it can be copied or restored by all AWS accounts. Do not
// add the all value for any manual DB cluster snapshots that contain private
// information that you don't want available to all AWS accounts. If a manual
// DB cluster snapshot is encrypted, it can be shared, but only by specifying
// a list of authorized AWS account IDs for the ValuesToAdd parameter. You can't
// use all as a value for that parameter in this case.
//
// To view which AWS accounts have access to copy or restore a manual DB cluster
// snapshot, or whether a manual DB cluster snapshot public or private, use
// the DescribeDBClusterSnapshotAttributes API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ModifyDBClusterSnapshotAttribute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeSharedSnapshotQuotaExceededFault "SharedSnapshotQuotaExceeded"
//   You have exceeded the maximum number of accounts that you can share a manual
//   DB snapshot with.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBClusterSnapshotAttribute
func (c *Neptune) ModifyDBClusterSnapshotAttribute(input *ModifyDBClusterSnapshotAttributeInput) (*ModifyDBClusterSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBClusterSnapshotAttributeRequest(input)
	return out, req.Send()
}

// ModifyDBClusterSnapshotAttributeWithContext is the same as ModifyDBClusterSnapshotAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBClusterSnapshotAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ModifyDBClusterSnapshotAttributeWithContext(ctx aws.Context, input *ModifyDBClusterSnapshotAttributeInput, opts ...request.Option) (*ModifyDBClusterSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBClusterSnapshotAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBInstance = "ModifyDBInstance"

// ModifyDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBInstance for more information on using the ModifyDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBInstanceRequest method.
//    req, resp := client.ModifyDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBInstance
func (c *Neptune) ModifyDBInstanceRequest(input *ModifyDBInstanceInput) (req *request.Request, output *ModifyDBInstanceOutput) {
	op := &request.Operation{
		Name:       opModifyDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBInstanceInput{}
	}

	output = &ModifyDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBInstance API operation for Amazon Neptune.
//
// Modifies settings for a DB instance. You can change one or more database
// configuration parameters by specifying these parameters and the new values
// in the request. To learn what modifications you can make to your DB instance,
// call DescribeValidDBInstanceModifications before you call ModifyDBInstance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ModifyDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group does not allow deletion.
//
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   User already has a DB instance with the given identifier.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   Specified DB instance class is not available in the specified Availability
//   Zone.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The designated option group could not be found.
//
//   * ErrCodeDBUpgradeDependencyFailureFault "DBUpgradeDependencyFailure"
//   The DB upgrade failed because a resource the DB depends on could not be modified.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   StorageType specified cannot be associated with the DB Instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   Specified CIDRIP or EC2 security group is not authorized for the specified
//   DB security group.
//
//   Neptune may not also be authorized via IAM to perform necessary actions on
//   your behalf.
//
//   * ErrCodeCertificateNotFoundFault "CertificateNotFound"
//   CertificateIdentifier does not refer to an existing certificate.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain does not refer to an existing Active Directory Domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBInstance
func (c *Neptune) ModifyDBInstance(input *ModifyDBInstanceInput) (*ModifyDBInstanceOutput, error) {
	req, out := c.ModifyDBInstanceRequest(input)
	return out, req.Send()
}

// ModifyDBInstanceWithContext is the same as ModifyDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ModifyDBInstanceWithContext(ctx aws.Context, input *ModifyDBInstanceInput, opts ...request.Option) (*ModifyDBInstanceOutput, error) {
	req, out := c.ModifyDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBParameterGroup = "ModifyDBParameterGroup"

// ModifyDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBParameterGroup for more information on using the ModifyDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBParameterGroupRequest method.
//    req, resp := client.ModifyDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBParameterGroup
func (c *Neptune) ModifyDBParameterGroupRequest(input *ModifyDBParameterGroupInput) (req *request.Request, output *ResetDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opModifyDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBParameterGroupInput{}
	}

	output = &ResetDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBParameterGroup API operation for Amazon Neptune.
//
// Modifies the parameters of a DB parameter group. To modify more than one
// parameter, submit a list of the following: ParameterName, ParameterValue,
// and ApplyMethod. A maximum of 20 parameters can be modified in a single request.
//
// Changes to dynamic parameters are applied immediately. Changes to static
// parameters require a reboot without failover to the DB instance associated
// with the parameter group before the change can take effect.
//
// After you modify a DB parameter group, you should wait at least 5 minutes
// before creating your first DB instance that uses that DB parameter group
// as the default parameter group. This allows Amazon Neptune to fully complete
// the modify action before the parameter group is used as the default for a
// new DB instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon Neptune console or
// the DescribeDBParameters command to verify that your DB parameter group has
// been created or modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ModifyDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBParameterGroup
func (c *Neptune) ModifyDBParameterGroup(input *ModifyDBParameterGroupInput) (*ResetDBParameterGroupOutput, error) {
	req, out := c.ModifyDBParameterGroupRequest(input)
	return out, req.Send()
}

// ModifyDBParameterGroupWithContext is the same as ModifyDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ModifyDBParameterGroupWithContext(ctx aws.Context, input *ModifyDBParameterGroupInput, opts ...request.Option) (*ResetDBParameterGroupOutput, error) {
	req, out := c.ModifyDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBSubnetGroup = "ModifyDBSubnetGroup"

// ModifyDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBSubnetGroup for more information on using the ModifyDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBSubnetGroupRequest method.
//    req, resp := client.ModifyDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBSubnetGroup
func (c *Neptune) ModifyDBSubnetGroupRequest(input *ModifyDBSubnetGroupInput) (req *request.Request, output *ModifyDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSubnetGroupInput{}
	}

	output = &ModifyDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBSubnetGroup API operation for Amazon Neptune.
//
// Modifies an existing DB subnet group. DB subnet groups must contain at least
// one subnet in at least two AZs in the AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ModifyDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetQuotaExceededFault "DBSubnetQuotaExceededFault"
//   Request would result in user exceeding the allowed number of subnets in a
//   DB subnet groups.
//
//   * ErrCodeSubnetAlreadyInUse "SubnetAlreadyInUse"
//   The DB subnet is already in use in the Availability Zone.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyDBSubnetGroup
func (c *Neptune) ModifyDBSubnetGroup(input *ModifyDBSubnetGroupInput) (*ModifyDBSubnetGroupOutput, error) {
	req, out := c.ModifyDBSubnetGroupRequest(input)
	return out, req.Send()
}

// ModifyDBSubnetGroupWithContext is the same as ModifyDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ModifyDBSubnetGroupWithContext(ctx aws.Context, input *ModifyDBSubnetGroupInput, opts ...request.Option) (*ModifyDBSubnetGroupOutput, error) {
	req, out := c.ModifyDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEventSubscription for more information on using the ModifyEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyEventSubscriptionRequest method.
//    req, resp := client.ModifyEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyEventSubscription
func (c *Neptune) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	output = &ModifyEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEventSubscription API operation for Amazon Neptune.
//
// Modifies an existing event notification subscription. Note that you can't
// modify the source identifiers using this call; to change source identifiers
// for a subscription, use the AddSourceIdentifierToSubscription and RemoveSourceIdentifierFromSubscription
// calls.
//
// You can see a list of the event categories for a given SourceType by using
// the DescribeEventCategories action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ModifyEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEventSubscriptionQuotaExceededFault "EventSubscriptionQuotaExceeded"
//   You have exceeded the number of events you can subscribe to.
//
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The designated subscription could not be found.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopic"
//   The SNS topic is invalid.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorization"
//   There is no SNS authorization.
//
//   * ErrCodeSNSTopicArnNotFoundFault "SNSTopicArnNotFound"
//   The ARN of the SNS topic could not be found.
//
//   * ErrCodeSubscriptionCategoryNotFoundFault "SubscriptionCategoryNotFound"
//   The designated subscription category could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ModifyEventSubscription
func (c *Neptune) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	return out, req.Send()
}

// ModifyEventSubscriptionWithContext is the same as ModifyEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ModifyEventSubscriptionWithContext(ctx aws.Context, input *ModifyEventSubscriptionInput, opts ...request.Option) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPromoteReadReplicaDBCluster = "PromoteReadReplicaDBCluster"

// PromoteReadReplicaDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the PromoteReadReplicaDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PromoteReadReplicaDBCluster for more information on using the PromoteReadReplicaDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PromoteReadReplicaDBClusterRequest method.
//    req, resp := client.PromoteReadReplicaDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/PromoteReadReplicaDBCluster
func (c *Neptune) PromoteReadReplicaDBClusterRequest(input *PromoteReadReplicaDBClusterInput) (req *request.Request, output *PromoteReadReplicaDBClusterOutput) {
	op := &request.Operation{
		Name:       opPromoteReadReplicaDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PromoteReadReplicaDBClusterInput{}
	}

	output = &PromoteReadReplicaDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PromoteReadReplicaDBCluster API operation for Amazon Neptune.
//
// Not supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation PromoteReadReplicaDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/PromoteReadReplicaDBCluster
func (c *Neptune) PromoteReadReplicaDBCluster(input *PromoteReadReplicaDBClusterInput) (*PromoteReadReplicaDBClusterOutput, error) {
	req, out := c.PromoteReadReplicaDBClusterRequest(input)
	return out, req.Send()
}

// PromoteReadReplicaDBClusterWithContext is the same as PromoteReadReplicaDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See PromoteReadReplicaDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) PromoteReadReplicaDBClusterWithContext(ctx aws.Context, input *PromoteReadReplicaDBClusterInput, opts ...request.Option) (*PromoteReadReplicaDBClusterOutput, error) {
	req, out := c.PromoteReadReplicaDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootDBInstance = "RebootDBInstance"

// RebootDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootDBInstance for more information on using the RebootDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootDBInstanceRequest method.
//    req, resp := client.RebootDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RebootDBInstance
func (c *Neptune) RebootDBInstanceRequest(input *RebootDBInstanceInput) (req *request.Request, output *RebootDBInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootDBInstanceInput{}
	}

	output = &RebootDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootDBInstance API operation for Amazon Neptune.
//
// You might need to reboot your DB instance, usually for maintenance reasons.
// For example, if you make certain modifications, or if you change the DB parameter
// group associated with the DB instance, you must reboot the instance for the
// changes to take effect.
//
// Rebooting a DB instance restarts the database engine service. Rebooting a
// DB instance results in a momentary outage, during which the DB instance status
// is set to rebooting.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation RebootDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RebootDBInstance
func (c *Neptune) RebootDBInstance(input *RebootDBInstanceInput) (*RebootDBInstanceOutput, error) {
	req, out := c.RebootDBInstanceRequest(input)
	return out, req.Send()
}

// RebootDBInstanceWithContext is the same as RebootDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) RebootDBInstanceWithContext(ctx aws.Context, input *RebootDBInstanceInput, opts ...request.Option) (*RebootDBInstanceOutput, error) {
	req, out := c.RebootDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveRoleFromDBCluster = "RemoveRoleFromDBCluster"

// RemoveRoleFromDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the RemoveRoleFromDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveRoleFromDBCluster for more information on using the RemoveRoleFromDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveRoleFromDBClusterRequest method.
//    req, resp := client.RemoveRoleFromDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveRoleFromDBCluster
func (c *Neptune) RemoveRoleFromDBClusterRequest(input *RemoveRoleFromDBClusterInput) (req *request.Request, output *RemoveRoleFromDBClusterOutput) {
	op := &request.Operation{
		Name:       opRemoveRoleFromDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRoleFromDBClusterInput{}
	}

	output = &RemoveRoleFromDBClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveRoleFromDBCluster API operation for Amazon Neptune.
//
// Disassociates an Identity and Access Management (IAM) role from a DB cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation RemoveRoleFromDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeDBClusterRoleNotFoundFault "DBClusterRoleNotFound"
//   The specified IAM role Amazon Resource Name (ARN) is not associated with
//   the specified DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveRoleFromDBCluster
func (c *Neptune) RemoveRoleFromDBCluster(input *RemoveRoleFromDBClusterInput) (*RemoveRoleFromDBClusterOutput, error) {
	req, out := c.RemoveRoleFromDBClusterRequest(input)
	return out, req.Send()
}

// RemoveRoleFromDBClusterWithContext is the same as RemoveRoleFromDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveRoleFromDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) RemoveRoleFromDBClusterWithContext(ctx aws.Context, input *RemoveRoleFromDBClusterInput, opts ...request.Option) (*RemoveRoleFromDBClusterOutput, error) {
	req, out := c.RemoveRoleFromDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveSourceIdentifierFromSubscription = "RemoveSourceIdentifierFromSubscription"

// RemoveSourceIdentifierFromSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the RemoveSourceIdentifierFromSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveSourceIdentifierFromSubscription for more information on using the RemoveSourceIdentifierFromSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveSourceIdentifierFromSubscriptionRequest method.
//    req, resp := client.RemoveSourceIdentifierFromSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveSourceIdentifierFromSubscription
func (c *Neptune) RemoveSourceIdentifierFromSubscriptionRequest(input *RemoveSourceIdentifierFromSubscriptionInput) (req *request.Request, output *RemoveSourceIdentifierFromSubscriptionOutput) {
	op := &request.Operation{
		Name:       opRemoveSourceIdentifierFromSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveSourceIdentifierFromSubscriptionInput{}
	}

	output = &RemoveSourceIdentifierFromSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveSourceIdentifierFromSubscription API operation for Amazon Neptune.
//
// Removes a source identifier from an existing event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation RemoveSourceIdentifierFromSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The designated subscription could not be found.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The source could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveSourceIdentifierFromSubscription
func (c *Neptune) RemoveSourceIdentifierFromSubscription(input *RemoveSourceIdentifierFromSubscriptionInput) (*RemoveSourceIdentifierFromSubscriptionOutput, error) {
	req, out := c.RemoveSourceIdentifierFromSubscriptionRequest(input)
	return out, req.Send()
}

// RemoveSourceIdentifierFromSubscriptionWithContext is the same as RemoveSourceIdentifierFromSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveSourceIdentifierFromSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) RemoveSourceIdentifierFromSubscriptionWithContext(ctx aws.Context, input *RemoveSourceIdentifierFromSubscriptionInput, opts ...request.Option) (*RemoveSourceIdentifierFromSubscriptionOutput, error) {
	req, out := c.RemoveSourceIdentifierFromSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveTagsFromResource
func (c *Neptune) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromResource API operation for Amazon Neptune.
//
// Removes metadata tags from an Amazon Neptune resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RemoveTagsFromResource
func (c *Neptune) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDBClusterParameterGroup = "ResetDBClusterParameterGroup"

// ResetDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDBClusterParameterGroup for more information on using the ResetDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDBClusterParameterGroupRequest method.
//    req, resp := client.ResetDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBClusterParameterGroup
func (c *Neptune) ResetDBClusterParameterGroupRequest(input *ResetDBClusterParameterGroupInput) (req *request.Request, output *ResetDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opResetDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDBClusterParameterGroupInput{}
	}

	output = &ResetDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDBClusterParameterGroup API operation for Amazon Neptune.
//
// Modifies the parameters of a DB cluster parameter group to the default value.
// To reset specific parameters submit a list of the following: ParameterName
// and ApplyMethod. To reset the entire DB cluster parameter group, specify
// the DBClusterParameterGroupName and ResetAllParameters parameters.
//
// When resetting the entire group, dynamic parameters are updated immediately
// and static parameters are set to pending-reboot to take effect on the next
// DB instance restart or RebootDBInstance request. You must call RebootDBInstance
// for every DB instance in your DB cluster that you want the updated static
// parameter to apply to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ResetDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBClusterParameterGroup
func (c *Neptune) ResetDBClusterParameterGroup(input *ResetDBClusterParameterGroupInput) (*ResetDBClusterParameterGroupOutput, error) {
	req, out := c.ResetDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ResetDBClusterParameterGroupWithContext is the same as ResetDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ResetDBClusterParameterGroupWithContext(ctx aws.Context, input *ResetDBClusterParameterGroupInput, opts ...request.Option) (*ResetDBClusterParameterGroupOutput, error) {
	req, out := c.ResetDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDBParameterGroup = "ResetDBParameterGroup"

// ResetDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDBParameterGroup for more information on using the ResetDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDBParameterGroupRequest method.
//    req, resp := client.ResetDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBParameterGroup
func (c *Neptune) ResetDBParameterGroupRequest(input *ResetDBParameterGroupInput) (req *request.Request, output *ResetDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opResetDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDBParameterGroupInput{}
	}

	output = &ResetDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDBParameterGroup API operation for Amazon Neptune.
//
// Modifies the parameters of a DB parameter group to the engine/system default
// value. To reset specific parameters, provide a list of the following: ParameterName
// and ApplyMethod. To reset the entire DB parameter group, specify the DBParameterGroup
// name and ResetAllParameters parameters. When resetting the entire group,
// dynamic parameters are updated immediately and static parameters are set
// to pending-reboot to take effect on the next DB instance restart or RebootDBInstance
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation ResetDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/ResetDBParameterGroup
func (c *Neptune) ResetDBParameterGroup(input *ResetDBParameterGroupInput) (*ResetDBParameterGroupOutput, error) {
	req, out := c.ResetDBParameterGroupRequest(input)
	return out, req.Send()
}

// ResetDBParameterGroupWithContext is the same as ResetDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) ResetDBParameterGroupWithContext(ctx aws.Context, input *ResetDBParameterGroupInput, opts ...request.Option) (*ResetDBParameterGroupOutput, error) {
	req, out := c.ResetDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterFromSnapshot = "RestoreDBClusterFromSnapshot"

// RestoreDBClusterFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterFromSnapshot for more information on using the RestoreDBClusterFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterFromSnapshotRequest method.
//    req, resp := client.RestoreDBClusterFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterFromSnapshot
func (c *Neptune) RestoreDBClusterFromSnapshotRequest(input *RestoreDBClusterFromSnapshotInput) (req *request.Request, output *RestoreDBClusterFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterFromSnapshotInput{}
	}

	output = &RestoreDBClusterFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterFromSnapshot API operation for Amazon Neptune.
//
// Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
//
// If a DB snapshot is specified, the target DB cluster is created from the
// source DB snapshot with a default configuration and default security group.
//
// If a DB cluster snapshot is specified, the target DB cluster is created from
// the source DB cluster restore point with the same configuration as the original
// source DB cluster, except that the new DB cluster is created with the default
// security group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation RestoreDBClusterFromSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   User already has a DB cluster with the given identifier.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   User attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
//   * ErrCodeInsufficientDBClusterCapacityFault "InsufficientDBClusterCapacityFault"
//   The DB cluster does not have enough capacity for the current operation.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You may be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot does not allow deletion.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from vpc backup to non-vpc DB instance.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The designated option group could not be found.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName does not refer to an existing DB Cluster parameter
//   group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterFromSnapshot
func (c *Neptune) RestoreDBClusterFromSnapshot(input *RestoreDBClusterFromSnapshotInput) (*RestoreDBClusterFromSnapshotOutput, error) {
	req, out := c.RestoreDBClusterFromSnapshotRequest(input)
	return out, req.Send()
}

// RestoreDBClusterFromSnapshotWithContext is the same as RestoreDBClusterFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) RestoreDBClusterFromSnapshotWithContext(ctx aws.Context, input *RestoreDBClusterFromSnapshotInput, opts ...request.Option) (*RestoreDBClusterFromSnapshotOutput, error) {
	req, out := c.RestoreDBClusterFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterToPointInTime = "RestoreDBClusterToPointInTime"

// RestoreDBClusterToPointInTimeRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterToPointInTime operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterToPointInTime for more information on using the RestoreDBClusterToPointInTime
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterToPointInTimeRequest method.
//    req, resp := client.RestoreDBClusterToPointInTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterToPointInTime
func (c *Neptune) RestoreDBClusterToPointInTimeRequest(input *RestoreDBClusterToPointInTimeInput) (req *request.Request, output *RestoreDBClusterToPointInTimeOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterToPointInTimeInput{}
	}

	output = &RestoreDBClusterToPointInTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterToPointInTime API operation for Amazon Neptune.
//
// Restores a DB cluster to an arbitrary point in time. Users can restore to
// any point in time before LatestRestorableTime for up to BackupRetentionPeriod
// days. The target DB cluster is created from the source DB cluster with the
// same configuration as the original DB cluster, except that the new DB cluster
// is created with the default DB security group.
//
// This action only restores the DB cluster, not the DB instances for that DB
// cluster. You must invoke the CreateDBInstance action to create DB instances
// for the restored DB cluster, specifying the identifier of the restored DB
// cluster in DBClusterIdentifier. You can create DB instances only after the
// RestoreDBClusterToPointInTime action has completed and the DB cluster is
// available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Neptune's
// API operation RestoreDBClusterToPointInTime for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   User already has a DB cluster with the given identifier.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   User attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeInsufficientDBClusterCapacityFault "InsufficientDBClusterCapacityFault"
//   The DB cluster does not have enough capacity for the current operation.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You may be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot does not allow deletion.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from vpc backup to non-vpc DB instance.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The designated option group could not be found.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName does not refer to an existing DB Cluster parameter
//   group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/RestoreDBClusterToPointInTime
func (c *Neptune) RestoreDBClusterToPointInTime(input *RestoreDBClusterToPointInTimeInput) (*RestoreDBClusterToPointInTimeOutput, error) {
	req, out := c.RestoreDBClusterToPointInTimeRequest(input)
	return out, req.Send()
}

// RestoreDBClusterToPointInTimeWithContext is the same as RestoreDBClusterToPointInTime with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterToPointInTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Neptune) RestoreDBClusterToPointInTimeWithContext(ctx aws.Context, input *RestoreDBClusterToPointInTimeInput, opts ...request.Option) (*RestoreDBClusterToPointInTimeOutput, error) {
	req, out := c.RestoreDBClusterToPointInTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddRoleToDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster to associate the IAM role with.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with the Neptune
	// DB cluster, for example arn:aws:iam::123456789012:role/NeptuneAccessRole.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddRoleToDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddRoleToDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddRoleToDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *AddRoleToDBClusterInput) SetDBClusterIdentifier(v string) *AddRoleToDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AddRoleToDBClusterInput) SetRoleArn(v string) *AddRoleToDBClusterInput {
	s.RoleArn = &v
	return s
}

type AddRoleToDBClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddRoleToDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToDBClusterOutput) GoString() string {
	return s.String()
}

type AddSourceIdentifierToSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the event source to be added.
	//
	// Constraints:
	//
	//    * If the source type is a DB instance, then a DBInstanceIdentifier must
	//    be supplied.
	//
	//    * If the source type is a DB security group, a DBSecurityGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB parameter group, a DBParameterGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB snapshot, a DBSnapshotIdentifier must be
	//    supplied.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `type:"string" required:"true"`

	// The name of the event notification subscription you want to add a source
	// identifier to.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddSourceIdentifierToSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddSourceIdentifierToSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddSourceIdentifierToSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddSourceIdentifierToSubscriptionInput"}
	if s.SourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceIdentifier"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *AddSourceIdentifierToSubscriptionInput) SetSourceIdentifier(v string) *AddSourceIdentifierToSubscriptionInput {
	s.SourceIdentifier = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *AddSourceIdentifierToSubscriptionInput) SetSubscriptionName(v string) *AddSourceIdentifierToSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type AddSourceIdentifierToSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s AddSourceIdentifierToSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddSourceIdentifierToSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *AddSourceIdentifierToSubscriptionOutput) SetEventSubscription(v *EventSubscription) *AddSourceIdentifierToSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Neptune resource that the tags are added to. This value is an
	// Amazon Resource Name (ARN). For information about creating an ARN, see  Constructing
	// an Amazon Resource Name (ARN) (https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tags to be assigned to the Amazon Neptune resource.
	//
	// Tags is a required field
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *AddTagsToResourceInput) SetResourceName(v string) *AddTagsToResourceInput {
	s.ResourceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

type ApplyPendingMaintenanceActionInput struct {
	_ struct{} `type:"structure"`

	// The pending maintenance action to apply to this resource.
	//
	// Valid values: system-update, db-upgrade
	//
	// ApplyAction is a required field
	ApplyAction *string `type:"string" required:"true"`

	// A value that specifies the type of opt-in request, or undoes an opt-in request.
	// An opt-in request of type immediate can't be undone.
	//
	// Valid values:
	//
	//    * immediate - Apply the maintenance action immediately.
	//
	//    * next-maintenance - Apply the maintenance action during the next maintenance
	//    window for the resource.
	//
	//    * undo-opt-in - Cancel any existing next-maintenance opt-in requests.
	//
	// OptInType is a required field
	OptInType *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the resource that the pending maintenance
	// action applies to. For information about creating an ARN, see  Constructing
	// an Amazon Resource Name (ARN) (https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyPendingMaintenanceActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplyPendingMaintenanceActionInput"}
	if s.ApplyAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyAction"))
	}
	if s.OptInType == nil {
		invalidParams.Add(request.NewErrParamRequired("OptInType"))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyAction sets the ApplyAction field's value.
func (s *ApplyPendingMaintenanceActionInput) SetApplyAction(v string) *ApplyPendingMaintenanceActionInput {
	s.ApplyAction = &v
	return s
}

// SetOptInType sets the OptInType field's value.
func (s *ApplyPendingMaintenanceActionInput) SetOptInType(v string) *ApplyPendingMaintenanceActionInput {
	s.OptInType = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ApplyPendingMaintenanceActionInput) SetResourceIdentifier(v string) *ApplyPendingMaintenanceActionInput {
	s.ResourceIdentifier = &v
	return s
}

type ApplyPendingMaintenanceActionOutput struct {
	_ struct{} `type:"structure"`

	// Describes the pending maintenance actions for a resource.
	ResourcePendingMaintenanceActions *ResourcePendingMaintenanceActions `type:"structure"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionOutput) GoString() string {
	return s.String()
}

// SetResourcePendingMaintenanceActions sets the ResourcePendingMaintenanceActions field's value.
func (s *ApplyPendingMaintenanceActionOutput) SetResourcePendingMaintenanceActions(v *ResourcePendingMaintenanceActions) *ApplyPendingMaintenanceActionOutput {
	s.ResourcePendingMaintenanceActions = v
	return s
}

// Specifies an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

// Specifies a character set.
type CharacterSet struct {
	_ struct{} `type:"structure"`

	// The description of the character set.
	CharacterSetDescription *string `type:"string"`

	// The name of the character set.
	CharacterSetName *string `type:"string"`
}

// String returns the string representation
func (s CharacterSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CharacterSet) GoString() string {
	return s.String()
}

// SetCharacterSetDescription sets the CharacterSetDescription field's value.
func (s *CharacterSet) SetCharacterSetDescription(v string) *CharacterSet {
	s.CharacterSetDescription = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *CharacterSet) SetCharacterSetName(v string) *CharacterSet {
	s.CharacterSetName = &v
	return s
}

// The configuration setting for the log types to be enabled for export to CloudWatch
// Logs for a specific DB instance or DB cluster.
type CloudwatchLogsExportConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of log types to disable.
	DisableLogTypes []*string `type:"list"`

	// The list of log types to enable.
	EnableLogTypes []*string `type:"list"`
}

// String returns the string representation
func (s CloudwatchLogsExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchLogsExportConfiguration) GoString() string {
	return s.String()
}

// SetDisableLogTypes sets the DisableLogTypes field's value.
func (s *CloudwatchLogsExportConfiguration) SetDisableLogTypes(v []*string) *CloudwatchLogsExportConfiguration {
	s.DisableLogTypes = v
	return s
}

// SetEnableLogTypes sets the EnableLogTypes field's value.
func (s *CloudwatchLogsExportConfiguration) SetEnableLogTypes(v []*string) *CloudwatchLogsExportConfiguration {
	s.EnableLogTypes = v
	return s
}

type CopyDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter
	// group. For information about creating an ARN, see  Constructing an Amazon
	// Resource Name (ARN) (https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
	//
	// Constraints:
	//
	//    * Must specify a valid DB cluster parameter group.
	//
	//    * If the source DB cluster parameter group is in the same AWS Region as
	//    the copy, specify a valid DB parameter group identifier, for example my-db-cluster-param-group,
	//    or a valid ARN.
	//
	//    * If the source DB parameter group is in a different AWS Region than the
	//    copy, specify a valid DB cluster parameter group ARN, for example arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1.
	//
	// SourceDBClusterParameterGroupIdentifier is a required field
	SourceDBClusterParameterGroupIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the copied DB cluster parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A description for the copied DB cluster parameter group.
	//
	// TargetDBClusterParameterGroupDescription is a required field
	TargetDBClusterParameterGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank
	//
	//    * Must contain from 1 to 255 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-cluster-param-group1
	//
	// TargetDBClusterParameterGroupIdentifier is a required field
	TargetDBClusterParameterGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBClusterParameterGroupInput"}
	if s.SourceDBClusterParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterParameterGroupIdentifier"))
	}
	if s.TargetDBClusterParameterGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterParameterGroupDescription"))
	}
	if s.TargetDBClusterParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterParameterGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceDBClusterParameterGroupIdentifier sets the SourceDBClusterParameterGroupIdentifier field's value.
func (s *CopyDBClusterParameterGroupInput) SetSourceDBClusterParameterGroupIdentifier(v string) *CopyDBClusterParameterGroupInput {
	s.SourceDBClusterParameterGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBClusterParameterGroupInput) SetTags(v []*Tag) *CopyDBClusterParameterGroupInput {
	s.Tags = v
	return s
}

// SetTargetDBClusterParameterGroupDescription sets the TargetDBClusterParameterGroupDescription field's value.
func (s *CopyDBClusterParameterGroupInput) SetTargetDBClusterParameterGroupDescription(v string) *CopyDBClusterParameterGroupInput {
	s.TargetDBClusterParameterGroupDescription = &v
	return s
}

// SetTargetDBClusterParameterGroupIdentifier sets the TargetDBClusterParameterGroupIdentifier field's value.
func (s *CopyDBClusterParameterGroupInput) SetTargetDBClusterParameterGroupIdentifier(v string) *CopyDBClusterParameterGroupInput {
	s.TargetDBClusterParameterGroupIdentifier = &v
	return s
}

type CopyDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB cluster parameter group.
	//
	// This data type is used as a response element in the DescribeDBClusterParameterGroups
	// action.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *CopyDBClusterParameterGroupOutput) SetDBClusterParameterGroup(v *DBClusterParameterGroup) *CopyDBClusterParameterGroupOutput {
	s.DBClusterParameterGroup = v
	return s
}

type CopyDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// True to copy all tags from the source DB cluster snapshot to the target DB
	// cluster snapshot, and otherwise false. The default is false.
	CopyTags *bool `type:"boolean"`

	// The AWS AWS KMS key ID for an encrypted DB cluster snapshot. The KMS key
	// ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key
	// alias for the KMS encryption key.
	//
	// If you copy an unencrypted DB cluster snapshot and specify a value for the
	// KmsKeyId parameter, Amazon Neptune encrypts the target DB cluster snapshot
	// using the specified KMS encryption key.
	//
	// If you copy an encrypted DB cluster snapshot from your AWS account, you can
	// specify a value for KmsKeyId to encrypt the copy with a new KMS encryption
	// key. If you don't specify a value for KmsKeyId, then the copy of the DB cluster
	// snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
	//
	// If you copy an encrypted DB cluster snapshot that is shared from another
	// AWS account, then you must specify a value for KmsKeyId.
	//
	// KMS encryption keys are specific to the AWS Region that they are created
	// in, and you can't use encryption keys from one AWS Region in another AWS
	// Region.
	KmsKeyId *string `type:"string"`

	// Not currently supported.
	PreSignedUrl *string `type:"string"`

	// The identifier of the DB cluster snapshot to copy. This parameter is not
	// case-sensitive.
	//
	// You can't copy from one AWS Region to another.
	//
	// Constraints:
	//
	//    * Must specify a valid system snapshot in the "available" state.
	//
	//    * Specify a valid DB snapshot identifier.
	//
	// Example: my-cluster-snapshot1
	//
	// SourceDBClusterSnapshotIdentifier is a required field
	SourceDBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to assign to the new DB cluster snapshot copy.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the new DB cluster snapshot to create from the source DB
	// cluster snapshot. This parameter is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster-snapshot2
	//
	// TargetDBClusterSnapshotIdentifier is a required field
	TargetDBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBClusterSnapshotInput"}
	if s.SourceDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterSnapshotIdentifier"))
	}
	if s.TargetDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyTags sets the CopyTags field's value.
func (s *CopyDBClusterSnapshotInput) SetCopyTags(v bool) *CopyDBClusterSnapshotInput {
	s.CopyTags = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopyDBClusterSnapshotInput) SetKmsKeyId(v string) *CopyDBClusterSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CopyDBClusterSnapshotInput) SetPreSignedUrl(v string) *CopyDBClusterSnapshotInput {
	s.PreSignedUrl = &v
	return s
}

// SetSourceDBClusterSnapshotIdentifier sets the SourceDBClusterSnapshotIdentifier field's value.
func (s *CopyDBClusterSnapshotInput) SetSourceDBClusterSnapshotIdentifier(v string) *CopyDBClusterSnapshotInput {
	s.SourceDBClusterSnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBClusterSnapshotInput) SetTags(v []*Tag) *CopyDBClusterSnapshotInput {
	s.Tags = v
	return s
}

// SetTargetDBClusterSnapshotIdentifier sets the TargetDBClusterSnapshotIdentifier field's value.
func (s *CopyDBClusterSnapshotInput) SetTargetDBClusterSnapshotIdentifier(v string) *CopyDBClusterSnapshotInput {
	s.TargetDBClusterSnapshotIdentifier = &v
	return s
}

type CopyDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon Neptune DB cluster snapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *CopyDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *CopyDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

type CopyDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or ARN for the source DB parameter group. For information
	// about creating an ARN, see  Constructing an Amazon Resource Name (ARN) (https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
	//
	// Constraints:
	//
	//    * Must specify a valid DB parameter group.
	//
	//    * Must specify a valid DB parameter group identifier, for example my-db-param-group,
	//    or a valid ARN.
	//
	// SourceDBParameterGroupIdentifier is a required field
	SourceDBParameterGroupIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the copied DB parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A description for the copied DB parameter group.
	//
	// TargetDBParameterGroupDescription is a required field
	TargetDBParameterGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied DB parameter group.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank.
	//
	//    * Must contain from 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-db-parameter-group
	//
	// TargetDBParameterGroupIdentifier is a required field
	TargetDBParameterGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBParameterGroupInput"}
	if s.SourceDBParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBParameterGroupIdentifier"))
	}
	if s.TargetDBParameterGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBParameterGroupDescription"))
	}
	if s.TargetDBParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBParameterGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceDBParameterGroupIdentifier sets the SourceDBParameterGroupIdentifier field's value.
func (s *CopyDBParameterGroupInput) SetSourceDBParameterGroupIdentifier(v string) *CopyDBParameterGroupInput {
	s.SourceDBParameterGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBParameterGroupInput) SetTags(v []*Tag) *CopyDBParameterGroupInput {
	s.Tags = v
	return s
}

// SetTargetDBParameterGroupDescription sets the TargetDBParameterGroupDescription field's value.
func (s *CopyDBParameterGroupInput) SetTargetDBParameterGroupDescription(v string) *CopyDBParameterGroupInput {
	s.TargetDBParameterGroupDescription = &v
	return s
}

// SetTargetDBParameterGroupIdentifier sets the TargetDBParameterGroupIdentifier field's value.
func (s *CopyDBParameterGroupInput) SetTargetDBParameterGroupIdentifier(v string) *CopyDBParameterGroupInput {
	s.TargetDBParameterGroupIdentifier = &v
	return s
}

type CopyDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB parameter group.
	//
	// This data type is used as a response element in the DescribeDBParameterGroups
	// action.
	DBParameterGroup *DBParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CopyDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBParameterGroup sets the DBParameterGroup field's value.
func (s *CopyDBParameterGroupOutput) SetDBParameterGroup(v *DBParameterGroup) *CopyDBParameterGroupOutput {
	s.DBParameterGroup = v
	return s
}

type CreateDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A list of EC2 Availability Zones that instances in the DB cluster can be
	// created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The number of days for which automated backups are retained. You must specify
	// a minimum value of 1.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 1 to 35
	BackupRetentionPeriod *int64 `type:"integer"`

	// A value that indicates that the DB cluster should be associated with the
	// specified CharacterSet.
	CharacterSetName *string `type:"string"`

	// The DB cluster identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to associate with this DB cluster.
	// If this argument is omitted, the default is used.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBClusterParameterGroup.
	DBClusterParameterGroupName *string `type:"string"`

	// A DB subnet group to associate with this DB cluster.
	//
	// Constraints: Must match the name of an existing DBSubnetGroup. Must not be
	// default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// The name for your database of up to 64 alpha-numeric characters. If you do
	// not provide a name, Amazon Neptune will not create a database in the DB cluster
	// you are creating.
	DatabaseName *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts, and otherwise false.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The name of the database engine to be used for this DB cluster.
	//
	// Valid Values: neptune
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version number of the database engine to use.
	//
	// Example: 1.0.1
	EngineVersion *string `type:"string"`

	// The AWS KMS key identifier for an encrypted DB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KMS encryption key.
	//
	// If an encryption key is not specified in KmsKeyId:
	//
	//    * If ReplicationSourceIdentifier identifies an encrypted source, then
	//    Amazon Neptune will use the encryption key used to encrypt the source.
	//    Otherwise, Amazon Neptune will use your default encryption key.
	//
	//    * If the StorageEncrypted parameter is true and ReplicationSourceIdentifier
	//    is not specified, then Amazon Neptune will use your default encryption
	//    key.
	//
	// AWS KMS creates the default encryption key for your AWS account. Your AWS
	// account has a different default encryption key for each AWS Region.
	//
	// If you create a Read Replica of an encrypted DB cluster in another AWS Region,
	// you must set KmsKeyId to a KMS key ID that is valid in the destination AWS
	// Region. This key is used to encrypt the Read Replica in that AWS Region.
	KmsKeyId *string `type:"string"`

	// The password for the master database user. This password can contain any
	// printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain from 8 to 41 characters.
	MasterUserPassword *string `type:"string"`

	// The name of the master user for the DB cluster.
	//
	// Constraints:
	//
	//    * Must be 1 to 16 letters or numbers.
	//
	//    * First character must be a letter.
	//
	//    * Cannot be a reserved word for the chosen database engine.
	MasterUsername *string `type:"string"`

	// A value that indicates that the DB cluster should be associated with the
	// specified option group.
	//
	// Permanent options can't be removed from an option group. The option group
	// can't be removed from a DB cluster once it is associated with a DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the instances in the DB cluster accept connections.
	//
	// Default: 8182
	Port *int64 `type:"integer"`

	// This parameter is not currently supported.
	PreSignedUrl *string `type:"string"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled using the BackupRetentionPeriod parameter.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region. To see the time blocks available, see  Adjusting
	// the Preferred Maintenance Window (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon Neptune User Guide.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Must be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week. To see
	// the time blocks available, see  Adjusting the Preferred Maintenance Window
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon Neptune User Guide.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) of the source DB instance or DB cluster if
	// this DB cluster is created as a Read Replica.
	ReplicationSourceIdentifier *string `type:"string"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// The tags to assign to the new DB cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of EC2 VPC security groups to associate with this DB cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *CreateDBClusterInput) SetAvailabilityZones(v []*string) *CreateDBClusterInput {
	s.AvailabilityZones = v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *CreateDBClusterInput) SetBackupRetentionPeriod(v int64) *CreateDBClusterInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *CreateDBClusterInput) SetCharacterSetName(v string) *CreateDBClusterInput {
	s.CharacterSetName = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterInput) SetDBClusterIdentifier(v string) *CreateDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *CreateDBClusterInput) SetDBClusterParameterGroupName(v string) *CreateDBClusterInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBClusterInput) SetDBSubnetGroupName(v string) *CreateDBClusterInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateDBClusterInput) SetDatabaseName(v string) *CreateDBClusterInput {
	s.DatabaseName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *CreateDBClusterInput) SetEnableIAMDatabaseAuthentication(v bool) *CreateDBClusterInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateDBClusterInput) SetEngine(v string) *CreateDBClusterInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDBClusterInput) SetEngineVersion(v string) *CreateDBClusterInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDBClusterInput) SetKmsKeyId(v string) *CreateDBClusterInput {
	s.KmsKeyId = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateDBClusterInput) SetMasterUserPassword(v string) *CreateDBClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateDBClusterInput) SetMasterUsername(v string) *CreateDBClusterInput {
	s.MasterUsername = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateDBClusterInput) SetOptionGroupName(v string) *CreateDBClusterInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateDBClusterInput) SetPort(v int64) *CreateDBClusterInput {
	s.Port = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CreateDBClusterInput) SetPreSignedUrl(v string) *CreateDBClusterInput {
	s.PreSignedUrl = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateDBClusterInput) SetPreferredBackupWindow(v string) *CreateDBClusterInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateDBClusterInput) SetPreferredMaintenanceWindow(v string) *CreateDBClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationSourceIdentifier sets the ReplicationSourceIdentifier field's value.
func (s *CreateDBClusterInput) SetReplicationSourceIdentifier(v string) *CreateDBClusterInput {
	s.ReplicationSourceIdentifier = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *CreateDBClusterInput) SetStorageEncrypted(v bool) *CreateDBClusterInput {
	s.StorageEncrypted = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterInput) SetTags(v []*Tag) *CreateDBClusterInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDBClusterInput) SetVpcSecurityGroupIds(v []*string) *CreateDBClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB cluster.
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *CreateDBClusterOutput) SetDBCluster(v *DBCluster) *CreateDBClusterOutput {
	s.DBCluster = v
	return s
}

type CreateDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Must match the name of an existing DBClusterParameterGroup.
	//
	// This value is stored as a lowercase string.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// The DB cluster parameter group family name. A DB cluster parameter group
	// can be associated with one and only one DB cluster parameter group family,
	// and can be applied only to a DB cluster running a database engine and engine
	// version compatible with that DB cluster parameter group family.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The description for the DB cluster parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The tags to be assigned to the new DB cluster parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *CreateDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *CreateDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *CreateDBClusterParameterGroupInput) SetDBParameterGroupFamily(v string) *CreateDBClusterParameterGroupInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDBClusterParameterGroupInput) SetDescription(v string) *CreateDBClusterParameterGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterParameterGroupInput) SetTags(v []*Tag) *CreateDBClusterParameterGroupInput {
	s.Tags = v
	return s
}

type CreateDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB cluster parameter group.
	//
	// This data type is used as a response element in the DescribeDBClusterParameterGroups
	// action.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *CreateDBClusterParameterGroupOutput) SetDBClusterParameterGroup(v *DBClusterParameterGroup) *CreateDBClusterParameterGroupOutput {
	s.DBClusterParameterGroup = v
	return s
}

type CreateDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster to create a snapshot for. This parameter
	// is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBCluster.
	//
	// Example: my-cluster1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the DB cluster snapshot. This parameter is stored as a
	// lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1-snapshot1
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the DB cluster snapshot.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterSnapshotInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterSnapshotInput) SetDBClusterIdentifier(v string) *CreateDBClusterSnapshotInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *CreateDBClusterSnapshotInput) SetDBClusterSnapshotIdentifier(v string) *CreateDBClusterSnapshotInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterSnapshotInput) SetTags(v []*Tag) *CreateDBClusterSnapshotInput {
	s.Tags = v
	return s
}

type CreateDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon Neptune DB cluster snapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *CreateDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *CreateDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

type CreateDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gibibytes) to allocate for the DB instance.
	//
	// Type: Integer
	//
	// Not applicable. Neptune cluster volumes automatically grow as the amount
	// of data in your database increases, though you are only charged for the space
	// that you use in a Neptune cluster volume.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that minor engine upgrades are applied automatically to the DB
	// instance during the maintenance window.
	//
	// Default: true
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The EC2 Availability Zone that the DB instance is created in
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's AWS
	// Region.
	//
	// Example: us-east-1d
	//
	// Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ
	// parameter is set to true. The specified Availability Zone must be in the
	// same AWS Region as the current endpoint.
	AvailabilityZone *string `type:"string"`

	// The number of days for which automated backups are retained.
	//
	// Not applicable. The retention period for automated backups is managed by
	// the DB cluster. For more information, see CreateDBCluster.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 0 to 35
	//
	//    * Cannot be set to 0 if the DB instance is a source to Read Replicas
	BackupRetentionPeriod *int64 `type:"integer"`

	// Indicates that the DB instance should be associated with the specified CharacterSet.
	//
	// Not applicable. The character set is managed by the DB cluster. For more
	// information, see CreateDBCluster.
	CharacterSetName *string `type:"string"`

	// True to copy all tags from the DB instance to snapshots of the DB instance,
	// and otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The identifier of the DB cluster that the instance will belong to.
	//
	// For information on creating a DB cluster, see CreateDBCluster.
	//
	// Type: String
	DBClusterIdentifier *string `type:"string"`

	// The compute and memory capacity of the DB instance, for example, db.m4.large.
	// Not all DB instance classes are available in all AWS Regions.
	//
	// DBInstanceClass is a required field
	DBInstanceClass *string `type:"string" required:"true"`

	// The DB instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: mydbinstance
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// Not supported.
	DBName *string `type:"string"`

	// The name of the DB parameter group to associate with this DB instance. If
	// this argument is omitted, the default DBParameterGroup for the specified
	// engine is used.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBParameterGroupName *string `type:"string"`

	// A list of DB security groups to associate with this DB instance.
	//
	// Default: The default DB security group for the database engine.
	DBSecurityGroups []*string `locationNameList:"DBSecurityGroupName" type:"list"`

	// A DB subnet group to associate with this DB instance.
	//
	// If there is no DB subnet group, then it is a non-VPC DB instance.
	DBSubnetGroupName *string `type:"string"`

	// Specify the Active Directory Domain to create the instance in.
	Domain *string `type:"string"`

	// Specify the name of the IAM role to be used when making API calls to the
	// Directory Service.
	DomainIAMRoleName *string `type:"string"`

	// The list of log types that need to be enabled for exporting to CloudWatch
	// Logs.
	EnableCloudwatchLogsExports []*string `type:"list"`

	// True to enable AWS Identity and Access Management (IAM) authentication for
	// Neptune.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// True to enable Performance Insights for the DB instance, and otherwise false.
	EnablePerformanceInsights *bool `type:"boolean"`

	// The name of the database engine to be used for this instance.
	//
	// Valid Values: neptune
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version number of the database engine to use.
	EngineVersion *string `type:"string"`

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance.
	Iops *int64 `type:"integer"`

	// The AWS KMS key identifier for an encrypted DB instance.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a DB instance with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB instance, then you can
	// use the KMS key alias instead of the ARN for the KM encryption key.
	//
	// Not applicable. The KMS key identifier is managed by the DB cluster. For
	// more information, see CreateDBCluster.
	//
	// If the StorageEncrypted parameter is true, and you do not specify a value
	// for the KmsKeyId parameter, then Amazon Neptune will use your default encryption
	// key. AWS KMS creates the default encryption key for your AWS account. Your
	// AWS account has a different default encryption key for each AWS Region.
	KmsKeyId *string `type:"string"`

	// License model information for this DB instance.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// The password for the master user. The password can include any printable
	// ASCII character except "/", """, or "@".
	//
	// Not used.
	MasterUserPassword *string `type:"string"`

	// The name for the master user. Not used.
	MasterUsername *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 0.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits Neptune to send enhanced monitoring
	// metrics to Amazon CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment. You can't set the
	// AvailabilityZone parameter if the MultiAZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// Indicates that the DB instance should be associated with the specified option
	// group.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// can't be removed from an option group, and that option group can't be removed
	// from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The AWS KMS key identifier for encryption of Performance Insights data. The
	// KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the
	// KMS key alias for the KMS encryption key.
	PerformanceInsightsKMSKeyId *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	// Not applicable. The port is managed by the DB cluster. For more information,
	// see CreateDBCluster.
	//
	// Default: 8182
	//
	// Type: Integer
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created.
	//
	// Not applicable. The daily time range for creating automated backups is managed
	// by the DB cluster. For more information, see CreateDBCluster.
	PreferredBackupWindow *string `type:"string"`

	// The time range each week during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which an Read Replica is promoted to
	// the primary instance after a failure of the existing primary instance.
	//
	// Default: 1
	//
	// Valid Values: 0 - 15
	PromotionTier *int64 `type:"integer"`

	// This flag should no longer be used.
	//
	// Deprecated: PubliclyAccessible has been deprecated
	PubliclyAccessible *bool `deprecated:"true" type:"boolean"`

	// Specifies whether the DB instance is encrypted.
	//
	// Not applicable. The encryption for DB instances is managed by the DB cluster.
	// For more information, see CreateDBCluster.
	//
	// Default: false
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type to be associated with the DB instance.
	//
	// Not applicable. Storage is managed by the DB Cluster.
	StorageType *string `type:"string"`

	// The tags to assign to the new instance.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The ARN from the key store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the key store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`

	// The time zone of the DB instance.
	Timezone *string `type:"string"`

	// A list of EC2 VPC security groups to associate with this DB instance.
	//
	// Not applicable. The associated list of EC2 VPC security groups is managed
	// by the DB cluster. For more information, see CreateDBCluster.
	//
	// Default: The default EC2 VPC security group for the DB subnet group's VPC.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBInstanceInput"}
	if s.DBInstanceClass == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceClass"))
	}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *CreateDBInstanceInput) SetAllocatedStorage(v int64) *CreateDBInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateDBInstanceInput) SetAutoMinorVersionUpgrade(v bool) *CreateDBInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDBInstanceInput) SetAvailabilityZone(v string) *CreateDBInstanceInput {
	s.AvailabilityZone = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *CreateDBInstanceInput) SetBackupRetentionPeriod(v int64) *CreateDBInstanceInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *CreateDBInstanceInput) SetCharacterSetName(v string) *CreateDBInstanceInput {
	s.CharacterSetName = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *CreateDBInstanceInput) SetCopyTagsToSnapshot(v bool) *CreateDBInstanceInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBInstanceInput) SetDBClusterIdentifier(v string) *CreateDBInstanceInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *CreateDBInstanceInput) SetDBInstanceClass(v string) *CreateDBInstanceInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *CreateDBInstanceInput) SetDBInstanceIdentifier(v string) *CreateDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *CreateDBInstanceInput) SetDBName(v string) *CreateDBInstanceInput {
	s.DBName = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *CreateDBInstanceInput) SetDBParameterGroupName(v string) *CreateDBInstanceInput {
	s.DBParameterGroupName = &v
	return s
}

// SetDBSecurityGroups sets the DBSecurityGroups field's value.
func (s *CreateDBInstanceInput) SetDBSecurityGroups(v []*string) *CreateDBInstanceInput {
	s.DBSecurityGroups = v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBInstanceInput) SetDBSubnetGroupName(v string) *CreateDBInstanceInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDBInstanceInput) SetDomain(v string) *CreateDBInstanceInput {
	s.Domain = &v
	return s
}

// SetDomainIAMRoleName sets the DomainIAMRoleName field's value.
func (s *CreateDBInstanceInput) SetDomainIAMRoleName(v string) *CreateDBInstanceInput {
	s.DomainIAMRoleName = &v
	return s
}

// SetEnableCloudwatchLogsExports sets the EnableCloudwatchLogsExports field's value.
func (s *CreateDBInstanceInput) SetEnableCloudwatchLogsExports(v []*string) *CreateDBInstanceInput {
	s.EnableCloudwatchLogsExports = v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *CreateDBInstanceInput) SetEnableIAMDatabaseAuthentication(v bool) *CreateDBInstanceInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEnablePerformanceInsights sets the EnablePerformanceInsights field's value.
func (s *CreateDBInstanceInput) SetEnablePerformanceInsights(v bool) *CreateDBInstanceInput {
	s.EnablePerformanceInsights = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateDBInstanceInput) SetEngine(v string) *CreateDBInstanceInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDBInstanceInput) SetEngineVersion(v string) *CreateDBInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *CreateDBInstanceInput) SetIops(v int64) *CreateDBInstanceInput {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDBInstanceInput) SetKmsKeyId(v string) *CreateDBInstanceInput {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *CreateDBInstanceInput) SetLicenseModel(v string) *CreateDBInstanceInput {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateDBInstanceInput) SetMasterUserPassword(v string) *CreateDBInstanceInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateDBInstanceInput) SetMasterUsername(v string) *CreateDBInstanceInput {
	s.MasterUsername = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *CreateDBInstanceInput) SetMonitoringInterval(v int64) *CreateDBInstanceInput {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *CreateDBInstanceInput) SetMonitoringRoleArn(v string) *CreateDBInstanceInput {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *CreateDBInstanceInput) SetMultiAZ(v bool) *CreateDBInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateDBInstanceInput) SetOptionGroupName(v string) *CreateDBInstanceInput {
	s.OptionGroupName = &v
	return s
}

// SetPerformanceInsightsKMSKeyId sets the PerformanceInsightsKMSKeyId field's value.
func (s *CreateDBInstanceInput) SetPerformanceInsightsKMSKeyId(v string) *CreateDBInstanceInput {
	s.PerformanceInsightsKMSKeyId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateDBInstanceInput) SetPort(v int64) *CreateDBInstanceInput {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateDBInstanceInput) SetPreferredBackupWindow(v string) *CreateDBInstanceInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateDBInstanceInput) SetPreferredMaintenanceWindow(v string) *CreateDBInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *CreateDBInstanceInput) SetPromotionTier(v int64) *CreateDBInstanceInput {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateDBInstanceInput) SetPubliclyAccessible(v bool) *CreateDBInstanceInput {
	s.PubliclyAccessible = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *CreateDBInstanceInput) SetStorageEncrypted(v bool) *CreateDBInstanceInput {
	s.StorageEncrypted = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *CreateDBInstanceInput) SetStorageType(v string) *CreateDBInstanceInput {
	s.StorageType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBInstanceInput) SetTags(v []*Tag) *CreateDBInstanceInput {
	s.Tags = v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *CreateDBInstanceInput) SetTdeCredentialArn(v string) *CreateDBInstanceInput {
	s.TdeCredentialArn = &v
	return s
}

// SetTdeCredentialPassword sets the TdeCredentialPassword field's value.
func (s *CreateDBInstanceInput) SetTdeCredentialPassword(v string) *CreateDBInstanceInput {
	s.TdeCredentialPassword = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *CreateDBInstanceInput) SetTimezone(v string) *CreateDBInstanceInput {
	s.Timezone = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDBInstanceInput) SetVpcSecurityGroupIds(v []*string) *CreateDBInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB instance.
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s CreateDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *CreateDBInstanceOutput) SetDBInstance(v *DBInstance) *CreateDBInstanceOutput {
	s.DBInstance = v
	return s
}

type CreateDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The DB parameter group family name. A DB parameter group can be associated
	// with one and only one DB parameter group family, and can be applied only
	// to a DB instance running a database engine and engine version compatible
	// with that DB parameter group family.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// This value is stored as a lowercase string.
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`

	// The description for the DB parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The tags to be assigned to the new DB parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBParameterGroupInput"}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *CreateDBParameterGroupInput) SetDBParameterGroupFamily(v string) *CreateDBParameterGroupInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *CreateDBParameterGroupInput) SetDBParameterGroupName(v string) *CreateDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDBParameterGroupInput) SetDescription(v string) *CreateDBParameterGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBParameterGroupInput) SetTags(v []*Tag) *CreateDBParameterGroupInput {
	s.Tags = v
	return s
}

type CreateDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB parameter group.
	//
	// This data type is used as a response element in the DescribeDBParameterGroups
	// action.
	DBParameterGroup *DBParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBParameterGroup sets the DBParameterGroup field's value.
func (s *CreateDBParameterGroupOutput) SetDBParameterGroup(v *DBParameterGroup) *CreateDBParameterGroupOutput {
	s.DBParameterGroup = v
	return s
}

type CreateDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB subnet group.
	//
	// DBSubnetGroupDescription is a required field
	DBSubnetGroupDescription *string `type:"string" required:"true"`

	// The name for the DB subnet group. This value is stored as a lowercase string.
	//
	// Constraints: Must contain no more than 255 letters, numbers, periods, underscores,
	// spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 Subnet IDs for the DB subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	// The tags to be assigned to the new DB subnet group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBSubnetGroupInput"}
	if s.DBSubnetGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupDescription"))
	}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *CreateDBSubnetGroupInput) SetDBSubnetGroupDescription(v string) *CreateDBSubnetGroupInput {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBSubnetGroupInput) SetDBSubnetGroupName(v string) *CreateDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateDBSubnetGroupInput) SetSubnetIds(v []*string) *CreateDBSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBSubnetGroupInput) SetTags(v []*Tag) *CreateDBSubnetGroupInput {
	s.Tags = v
	return s
}

type CreateDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB subnet group.
	//
	// This data type is used as a response element in the DescribeDBSubnetGroups
	// action.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *CreateDBSubnetGroupOutput) SetDBSubnetGroup(v *DBSubnetGroup) *CreateDBSubnetGroupOutput {
	s.DBSubnetGroup = v
	return s
}

type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription, set to false to
	// create the subscription but not active it.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a SourceType that you want to subscribe to.
	// You can see a list of the categories for a given SourceType by using the
	// DescribeEventCategories action.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) of the SNS topic created for event notification.
	// The ARN is created by Amazon SNS when you create a topic and subscribe to
	// it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// The list of identifiers of the event sources for which events are returned.
	// If not specified, then all sources are included in the response. An identifier
	// must begin with a letter and must contain only ASCII letters, digits, and
	// hyphens; it can't end with a hyphen or contain two consecutive hyphens.
	//
	// Constraints:
	//
	//    * If SourceIds are supplied, SourceType must also be provided.
	//
	//    * If the source type is a DB instance, then a DBInstanceIdentifier must
	//    be supplied.
	//
	//    * If the source type is a DB security group, a DBSecurityGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB parameter group, a DBParameterGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB snapshot, a DBSnapshotIdentifier must be
	//    supplied.
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that is generating the events. For example, if you want
	// to be notified of events generated by a DB instance, you would set this parameter
	// to db-instance. if this value is not specified, all events are returned.
	//
	// Valid values: db-instance | db-cluster | db-parameter-group | db-security-group
	// | db-snapshot | db-cluster-snapshot
	SourceType *string `type:"string"`

	// The name of the subscription.
	//
	// Constraints: The name must be less than 255 characters.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// The tags to be applied to the new event subscription.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSubscriptionInput) SetEnabled(v bool) *CreateEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *CreateEventSubscriptionInput) SetEventCategories(v []*string) *CreateEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateEventSubscriptionInput) SetSnsTopicArn(v string) *CreateEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *CreateEventSubscriptionInput) SetSourceIds(v []*string) *CreateEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateEventSubscriptionInput) SetSourceType(v string) *CreateEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *CreateEventSubscriptionInput) SetSubscriptionName(v string) *CreateEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventSubscriptionInput) SetTags(v []*Tag) *CreateEventSubscriptionInput {
	s.Tags = v
	return s
}

type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *CreateEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *CreateEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// Contains the details of an Amazon Neptune DB cluster.
//
// This data type is used as a response element in the DescribeDBClusters action.
type DBCluster struct {
	_ struct{} `type:"structure"`

	// AllocatedStorage always returns 1, because Neptune DB cluster storage size
	// is not fixed, but instead automatically adjusts as needed.
	AllocatedStorage *int64 `type:"integer"`

	// Provides a list of the AWS Identity and Access Management (IAM) roles that
	// are associated with the DB cluster. IAM roles that are associated with a
	// DB cluster grant permission for the DB cluster to access other AWS services
	// on your behalf.
	AssociatedRoles []*DBClusterRole `locationNameList:"DBClusterRole" type:"list"`

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// can be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// If present, specifies the name of the character set that this cluster is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Identifies the clone group to which the DB cluster is associated.
	CloneGroupId *string `type:"string"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) for the DB cluster.
	DBClusterArn *string `type:"string"`

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// Provides the list of instances that make up the DB cluster.
	DBClusterMembers []*DBClusterMember `locationNameList:"DBClusterMember" type:"list"`

	// Provides the list of option group memberships for this DB cluster.
	DBClusterOptionGroupMemberships []*DBClusterOptionGroupStatus `locationNameList:"DBClusterOptionGroup" type:"list"`

	// Specifies the name of the DB cluster parameter group for the DB cluster.
	DBClusterParameterGroup *string `type:"string"`

	// Specifies information on the subnet group associated with the DB cluster,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string `type:"string"`

	// Contains the name of the initial database of this DB cluster that was provided
	// at create time, if one was specified when the DB cluster was created. This
	// same name is returned for the life of the DB cluster.
	DatabaseName *string `type:"string"`

	// The AWS Region-unique, immutable identifier for the DB cluster. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// cluster is accessed.
	DbClusterResourceId *string `type:"string"`

	// Specifies the earliest time to which a database can be restored with point-in-time
	// restore.
	EarliestRestorableTime *time.Time `type:"timestamp"`

	// Specifies the connection endpoint for the primary instance of the DB cluster.
	Endpoint *string `type:"string"`

	// Provides the name of the database engine to be used for this DB cluster.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// Contains the master username for the DB cluster.
	MasterUsername *string `type:"string"`

	// Specifies whether the DB cluster has instances in multiple Availability Zones.
	MultiAZ *bool `type:"boolean"`

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// Contains one or more identifiers of the Read Replicas associated with this
	// DB cluster.
	ReadReplicaIdentifiers []*string `locationNameList:"ReadReplicaIdentifier" type:"list"`

	// The reader endpoint for the DB cluster. The reader endpoint for a DB cluster
	// load-balances connections across the Read Replicas that are available in
	// a DB cluster. As clients request new connections to the reader endpoint,
	// Neptune distributes the connection requests among the Read Replicas in the
	// DB cluster. This functionality can help balance your read workload across
	// multiple Read Replicas in your DB cluster.
	//
	// If a failover occurs, and the Read Replica that you are connected to is promoted
	// to be the primary instance, your connection is dropped. To continue sending
	// your read workload to other Read Replicas in the cluster, you can then reconnect
	// to the reader endpoint.
	ReaderEndpoint *string `type:"string"`

	// Not supported by Neptune.
	ReplicationSourceIdentifier *string `type:"string"`

	// Specifies the current state of this DB cluster.
	Status *string `type:"string"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBCluster) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBCluster) SetAllocatedStorage(v int64) *DBCluster {
	s.AllocatedStorage = &v
	return s
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *DBCluster) SetAssociatedRoles(v []*DBClusterRole) *DBCluster {
	s.AssociatedRoles = v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DBCluster) SetAvailabilityZones(v []*string) *DBCluster {
	s.AvailabilityZones = v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *DBCluster) SetBackupRetentionPeriod(v int64) *DBCluster {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *DBCluster) SetCharacterSetName(v string) *DBCluster {
	s.CharacterSetName = &v
	return s
}

// SetCloneGroupId sets the CloneGroupId field's value.
func (s *DBCluster) SetCloneGroupId(v string) *DBCluster {
	s.CloneGroupId = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *DBCluster) SetClusterCreateTime(v time.Time) *DBCluster {
	s.ClusterCreateTime = &v
	return s
}

// SetDBClusterArn sets the DBClusterArn field's value.
func (s *DBCluster) SetDBClusterArn(v string) *DBCluster {
	s.DBClusterArn = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBCluster) SetDBClusterIdentifier(v string) *DBCluster {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterMembers sets the DBClusterMembers field's value.
func (s *DBCluster) SetDBClusterMembers(v []*DBClusterMember) *DBCluster {
	s.DBClusterMembers = v
	return s
}

// SetDBClusterOptionGroupMemberships sets the DBClusterOptionGroupMemberships field's value.
func (s *DBCluster) SetDBClusterOptionGroupMemberships(v []*DBClusterOptionGroupStatus) *DBCluster {
	s.DBClusterOptionGroupMemberships = v
	return s
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *DBCluster) SetDBClusterParameterGroup(v string) *DBCluster {
	s.DBClusterParameterGroup = &v
	return s
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *DBCluster) SetDBSubnetGroup(v string) *DBCluster {
	s.DBSubnetGroup = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DBCluster) SetDatabaseName(v string) *DBCluster {
	s.DatabaseName = &v
	return s
}

// SetDbClusterResourceId sets the DbClusterResourceId field's value.
func (s *DBCluster) SetDbClusterResourceId(v string) *DBCluster {
	s.DbClusterResourceId = &v
	return s
}

// SetEarliestRestorableTime sets the EarliestRestorableTime field's value.
func (s *DBCluster) SetEarliestRestorableTime(v time.Time) *DBCluster {
	s.EarliestRestorableTime = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBCluster) SetEndpoint(v string) *DBCluster {
	s.Endpoint = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBCluster) SetEngine(v string) *DBCluster {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBCluster) SetEngineVersion(v string) *DBCluster {
	s.EngineVersion = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DBCluster) SetHostedZoneId(v string) *DBCluster {
	s.HostedZoneId = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBCluster) SetIAMDatabaseAuthenticationEnabled(v bool) *DBCluster {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBCluster) SetKmsKeyId(v string) *DBCluster {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *DBCluster) SetLatestRestorableTime(v time.Time) *DBCluster {
	s.LatestRestorableTime = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBCluster) SetMasterUsername(v string) *DBCluster {
	s.MasterUsername = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *DBCluster) SetMultiAZ(v bool) *DBCluster {
	s.MultiAZ = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBCluster) SetPercentProgress(v string) *DBCluster {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBCluster) SetPort(v int64) *DBCluster {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *DBCluster) SetPreferredBackupWindow(v string) *DBCluster {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *DBCluster) SetPreferredMaintenanceWindow(v string) *DBCluster {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReadReplicaIdentifiers sets the ReadReplicaIdentifiers field's value.
func (s *DBCluster) SetReadReplicaIdentifiers(v []*string) *DBCluster {
	s.ReadReplicaIdentifiers = v
	return s
}

// SetReaderEndpoint sets the ReaderEndpoint field's value.
func (s *DBCluster) SetReaderEndpoint(v string) *DBCluster {
	s.ReaderEndpoint = &v
	return s
}

// SetReplicationSourceIdentifier sets the ReplicationSourceIdentifier field's value.
func (s *DBCluster) SetReplicationSourceIdentifier(v string) *DBCluster {
	s.ReplicationSourceIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBCluster) SetStatus(v string) *DBCluster {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBCluster) SetStorageEncrypted(v bool) *DBCluster {
	s.StorageEncrypted = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *DBCluster) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *DBCluster {
	s.VpcSecurityGroups = v
	return s
}

// Contains information about an instance that is part of a DB cluster.
type DBClusterMember struct {
	_ struct{} `type:"structure"`

	// Specifies the status of the DB cluster parameter group for this member of
	// the DB cluster.
	DBClusterParameterGroupStatus *string `type:"string"`

	// Specifies the instance identifier for this member of the DB cluster.
	DBInstanceIdentifier *string `type:"string"`

	// Value that is true if the cluster member is the primary instance for the
	// DB cluster and false otherwise.
	IsClusterWriter *bool `type:"boolean"`

	// A value that specifies the order in which a Read Replica is promoted to the
	// primary instance after a failure of the existing primary instance.
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation
func (s DBClusterMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterMember) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupStatus sets the DBClusterParameterGroupStatus field's value.
func (s *DBClusterMember) SetDBClusterParameterGroupStatus(v string) *DBClusterMember {
	s.DBClusterParameterGroupStatus = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBClusterMember) SetDBInstanceIdentifier(v string) *DBClusterMember {
	s.DBInstanceIdentifier = &v
	return s
}

// SetIsClusterWriter sets the IsClusterWriter field's value.
func (s *DBClusterMember) SetIsClusterWriter(v bool) *DBClusterMember {
	s.IsClusterWriter = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *DBClusterMember) SetPromotionTier(v int64) *DBClusterMember {
	s.PromotionTier = &v
	return s
}

// Contains status information for a DB cluster option group.
type DBClusterOptionGroupStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB cluster option group.
	DBClusterOptionGroupName *string `type:"string"`

	// Specifies the status of the DB cluster option group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterOptionGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterOptionGroupStatus) GoString() string {
	return s.String()
}

// SetDBClusterOptionGroupName sets the DBClusterOptionGroupName field's value.
func (s *DBClusterOptionGroupStatus) SetDBClusterOptionGroupName(v string) *DBClusterOptionGroupStatus {
	s.DBClusterOptionGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterOptionGroupStatus) SetStatus(v string) *DBClusterOptionGroupStatus {
	s.Status = &v
	return s
}

// Contains the details of an Amazon Neptune DB cluster parameter group.
//
// This data type is used as a response element in the DescribeDBClusterParameterGroups
// action.
type DBClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB cluster parameter group.
	DBClusterParameterGroupArn *string `type:"string"`

	// Provides the name of the DB cluster parameter group.
	DBClusterParameterGroupName *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB cluster parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the customer-specified description for this DB cluster parameter
	// group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterParameterGroup) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupArn sets the DBClusterParameterGroupArn field's value.
func (s *DBClusterParameterGroup) SetDBClusterParameterGroupArn(v string) *DBClusterParameterGroup {
	s.DBClusterParameterGroupArn = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DBClusterParameterGroup) SetDBClusterParameterGroupName(v string) *DBClusterParameterGroup {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBClusterParameterGroup) SetDBParameterGroupFamily(v string) *DBClusterParameterGroup {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DBClusterParameterGroup) SetDescription(v string) *DBClusterParameterGroup {
	s.Description = &v
	return s
}

// Describes an AWS Identity and Access Management (IAM) role that is associated
// with a DB cluster.
type DBClusterRole struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB cluster.
	RoleArn *string `type:"string"`

	// Describes the state of association between the IAM role and the DB cluster.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - the IAM role ARN is associated with the DB cluster and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - the IAM role ARN is being associated with the DB cluster.
	//
	//    * INVALID - the IAM role ARN is associated with the DB cluster, but the
	//    DB cluster is unable to assume the IAM role in order to access other AWS
	//    services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterRole) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *DBClusterRole) SetRoleArn(v string) *DBClusterRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterRole) SetStatus(v string) *DBClusterRole {
	s.Status = &v
	return s
}

// Contains the details for an Amazon Neptune DB cluster snapshot
//
// This data type is used as a response element in the DescribeDBClusterSnapshots
// action.
type DBClusterSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// snapshot can be restored in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// Specifies the DB cluster identifier of the DB cluster that this DB cluster
	// snapshot was created from.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB cluster snapshot.
	DBClusterSnapshotArn *string `type:"string"`

	// Specifies the identifier for the DB cluster snapshot.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Provides the version of the database engine for this DB cluster snapshot.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB cluster snapshot.
	KmsKeyId *string `type:"string"`

	// Provides the license model information for this DB cluster snapshot.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB cluster snapshot.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the DB cluster was listening on at the time of the
	// snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp"`

	// Provides the type of the DB cluster snapshot.
	SnapshotType *string `type:"string"`

	// If the DB cluster snapshot was copied from a source DB cluster snapshot,
	// the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise,
	// a null value.
	SourceDBClusterSnapshotArn *string `type:"string"`

	// Specifies the status of this DB cluster snapshot.
	Status *string `type:"string"`

	// Specifies whether the DB cluster snapshot is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides the VPC ID associated with the DB cluster snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshot) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBClusterSnapshot) SetAllocatedStorage(v int64) *DBClusterSnapshot {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DBClusterSnapshot) SetAvailabilityZones(v []*string) *DBClusterSnapshot {
	s.AvailabilityZones = v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *DBClusterSnapshot) SetClusterCreateTime(v time.Time) *DBClusterSnapshot {
	s.ClusterCreateTime = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBClusterSnapshot) SetDBClusterIdentifier(v string) *DBClusterSnapshot {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotArn sets the DBClusterSnapshotArn field's value.
func (s *DBClusterSnapshot) SetDBClusterSnapshotArn(v string) *DBClusterSnapshot {
	s.DBClusterSnapshotArn = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DBClusterSnapshot) SetDBClusterSnapshotIdentifier(v string) *DBClusterSnapshot {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBClusterSnapshot) SetEngine(v string) *DBClusterSnapshot {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBClusterSnapshot) SetEngineVersion(v string) *DBClusterSnapshot {
	s.EngineVersion = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBClusterSnapshot) SetIAMDatabaseAuthenticationEnabled(v bool) *DBClusterSnapshot {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBClusterSnapshot) SetKmsKeyId(v string) *DBClusterSnapshot {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DBClusterSnapshot) SetLicenseModel(v string) *DBClusterSnapshot {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBClusterSnapshot) SetMasterUsername(v string) *DBClusterSnapshot {
	s.MasterUsername = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBClusterSnapshot) SetPercentProgress(v int64) *DBClusterSnapshot {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBClusterSnapshot) SetPort(v int64) *DBClusterSnapshot {
	s.Port = &v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *DBClusterSnapshot) SetSnapshotCreateTime(v time.Time) *DBClusterSnapshot {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DBClusterSnapshot) SetSnapshotType(v string) *DBClusterSnapshot {
	s.SnapshotType = &v
	return s
}

// SetSourceDBClusterSnapshotArn sets the SourceDBClusterSnapshotArn field's value.
func (s *DBClusterSnapshot) SetSourceDBClusterSnapshotArn(v string) *DBClusterSnapshot {
	s.SourceDBClusterSnapshotArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterSnapshot) SetStatus(v string) *DBClusterSnapshot {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBClusterSnapshot) SetStorageEncrypted(v bool) *DBClusterSnapshot {
	s.StorageEncrypted = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBClusterSnapshot) SetVpcId(v string) *DBClusterSnapshot {
	s.VpcId = &v
	return s
}

// Contains the name and values of a manual DB cluster snapshot attribute.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to restore a manual DB cluster snapshot. For more information, see the ModifyDBClusterSnapshotAttribute
// API action.
type DBClusterSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB cluster snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual DB cluster snapshot. For more information,
	// see the ModifyDBClusterSnapshotAttribute API action.
	AttributeName *string `type:"string"`

	// The value(s) for the manual DB cluster snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual DB cluster snapshot. If a value of all is in the list, then the manual
	// DB cluster snapshot is public and available for any AWS account to copy or
	// restore.
	AttributeValues []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBClusterSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshotAttribute) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *DBClusterSnapshotAttribute) SetAttributeName(v string) *DBClusterSnapshotAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeValues sets the AttributeValues field's value.
func (s *DBClusterSnapshotAttribute) SetAttributeValues(v []*string) *DBClusterSnapshotAttribute {
	s.AttributeValues = v
	return s
}

// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
// API action.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to copy or restore a manual DB cluster snapshot. For more information, see
// the ModifyDBClusterSnapshotAttribute API action.
type DBClusterSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the manual DB cluster snapshot.
	DBClusterSnapshotAttributes []*DBClusterSnapshotAttribute `locationNameList:"DBClusterSnapshotAttribute" type:"list"`

	// The identifier of the manual DB cluster snapshot that the attributes apply
	// to.
	DBClusterSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshotAttributesResult) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributes sets the DBClusterSnapshotAttributes field's value.
func (s *DBClusterSnapshotAttributesResult) SetDBClusterSnapshotAttributes(v []*DBClusterSnapshotAttribute) *DBClusterSnapshotAttributesResult {
	s.DBClusterSnapshotAttributes = v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DBClusterSnapshotAttributesResult) SetDBClusterSnapshotIdentifier(v string) *DBClusterSnapshotAttributesResult {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
type DBEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the database engine.
	DBEngineDescription *string `type:"string"`

	// The description of the database engine version.
	DBEngineVersionDescription *string `type:"string"`

	// The name of the DB parameter group family for the database engine.
	DBParameterGroupFamily *string `type:"string"`

	// The default character set for new instances of this engine version, if the
	// CharacterSetName parameter of the CreateDBInstance API is not specified.
	DefaultCharacterSet *CharacterSet `type:"structure"`

	// The name of the database engine.
	Engine *string `type:"string"`

	// The version number of the database engine.
	EngineVersion *string `type:"string"`

	// The types of logs that the database engine has available for export to CloudWatch
	// Logs.
	ExportableLogTypes []*string `type:"list"`

	// A list of the character sets supported by this engine for the CharacterSetName
	// parameter of the CreateDBInstance action.
	SupportedCharacterSets []*CharacterSet `locationNameList:"CharacterSet" type:"list"`

	// A list of the time zones supported by this engine for the Timezone parameter
	// of the CreateDBInstance action.
	SupportedTimezones []*Timezone `locationNameList:"Timezone" type:"list"`

	// A value that indicates whether the engine version supports exporting the
	// log types specified by ExportableLogTypes to CloudWatch Logs.
	SupportsLogExportsToCloudwatchLogs *bool `type:"boolean"`

	// Indicates whether the database engine version supports read replicas.
	SupportsReadReplica *bool `type:"boolean"`

	// A list of engine versions that this database engine version can be upgraded
	// to.
	ValidUpgradeTarget []*UpgradeTarget `locationNameList:"UpgradeTarget" type:"list"`
}

// String returns the string representation
func (s DBEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBEngineVersion) GoString() string {
	return s.String()
}

// SetDBEngineDescription sets the DBEngineDescription field's value.
func (s *DBEngineVersion) SetDBEngineDescription(v string) *DBEngineVersion {
	s.DBEngineDescription = &v
	return s
}

// SetDBEngineVersionDescription sets the DBEngineVersionDescription field's value.
func (s *DBEngineVersion) SetDBEngineVersionDescription(v string) *DBEngineVersion {
	s.DBEngineVersionDescription = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBEngineVersion) SetDBParameterGroupFamily(v string) *DBEngineVersion {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDefaultCharacterSet sets the DefaultCharacterSet field's value.
func (s *DBEngineVersion) SetDefaultCharacterSet(v *CharacterSet) *DBEngineVersion {
	s.DefaultCharacterSet = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBEngineVersion) SetEngine(v string) *DBEngineVersion {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBEngineVersion) SetEngineVersion(v string) *DBEngineVersion {
	s.EngineVersion = &v
	return s
}

// SetExportableLogTypes sets the ExportableLogTypes field's value.
func (s *DBEngineVersion) SetExportableLogTypes(v []*string) *DBEngineVersion {
	s.ExportableLogTypes = v
	return s
}

// SetSupportedCharacterSets sets the SupportedCharacterSets field's value.
func (s *DBEngineVersion) SetSupportedCharacterSets(v []*CharacterSet) *DBEngineVersion {
	s.SupportedCharacterSets = v
	return s
}

// SetSupportedTimezones sets the SupportedTimezones field's value.
func (s *DBEngineVersion) SetSupportedTimezones(v []*Timezone) *DBEngineVersion {
	s.SupportedTimezones = v
	return s
}

// SetSupportsLogExportsToCloudwatchLogs sets the SupportsLogExportsToCloudwatchLogs field's value.
func (s *DBEngineVersion) SetSupportsLogExportsToCloudwatchLogs(v bool) *DBEngineVersion {
	s.SupportsLogExportsToCloudwatchLogs = &v
	return s
}

// SetSupportsReadReplica sets the SupportsReadReplica field's value.
func (s *DBEngineVersion) SetSupportsReadReplica(v bool) *DBEngineVersion {
	s.SupportsReadReplica = &v
	return s
}

// SetValidUpgradeTarget sets the ValidUpgradeTarget field's value.
func (s *DBEngineVersion) SetValidUpgradeTarget(v []*UpgradeTarget) *DBEngineVersion {
	s.ValidUpgradeTarget = v
	return s
}

// Contains the details of an Amazon Neptune DB instance.
//
// This data type is used as a response element in the DescribeDBInstances action.
type DBInstance struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size specified in gibibytes.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies the name of the Availability Zone the DB instance is located in.
	AvailabilityZone *string `type:"string"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// If present, specifies the name of the character set that this instance is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Specifies whether tags are copied from the DB instance to snapshots of the
	// DB instance.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB instance.
	DBInstanceArn *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// Specifies the current state of this database.
	DBInstanceStatus *string `type:"string"`

	// The database name.
	DBName *string `type:"string"`

	// Provides the list of DB parameter groups applied to this DB instance.
	DBParameterGroups []*DBParameterGroupStatus `locationNameList:"DBParameterGroup" type:"list"`

	// Provides List of DB security group elements containing only DBSecurityGroup.Name
	// and DBSecurityGroup.Status subelements.
	DBSecurityGroups []*DBSecurityGroupMembership `locationNameList:"DBSecurityGroup" type:"list"`

	// Specifies information on the subnet group associated with the DB instance,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// The AWS Region-unique, immutable identifier for the DB instance. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// instance is accessed.
	DbiResourceId *string `type:"string"`

	// Not supported
	DomainMemberships []*DomainMembership `locationNameList:"DomainMembership" type:"list"`

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs.
	EnabledCloudwatchLogsExports []*string `type:"list"`

	// Specifies the connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// Provides the name of the database engine to be used for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that
	// receives the Enhanced Monitoring metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string `type:"string"`

	// True if AWS Identity and Access Management (IAM) authentication is enabled,
	// and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *time.Time `type:"timestamp"`

	// Specifies the Provisioned IOPS (I/O operations per second) value.
	Iops *int64 `type:"integer"`

	// Not supported: The encryption for DB instances is managed by the DB cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// License model information for this DB instance.
	LicenseModel *string `type:"string"`

	// Contains the master username for the DB instance.
	MasterUsername *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance.
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits Neptune to send Enhanced Monitoring
	// metrics to Amazon CloudWatch Logs.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Provides the list of option group memberships for this DB instance.
	OptionGroupMemberships []*OptionGroupMembership `locationNameList:"OptionGroupMembership" type:"list"`

	// Specifies that changes to the DB instance are pending. This element is only
	// included when changes are pending. Specific changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// True if Performance Insights is enabled for the DB instance, and otherwise
	// false.
	PerformanceInsightsEnabled *bool `type:"boolean"`

	// The AWS KMS key identifier for encryption of Performance Insights data. The
	// KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the
	// KMS key alias for the KMS encryption key.
	PerformanceInsightsKMSKeyId *string `type:"string"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which a Read Replica is promoted to the
	// primary instance after a failure of the existing primary instance.
	PromotionTier *int64 `type:"integer"`

	// This flag should no longer be used.
	//
	// Deprecated: PubliclyAccessible has been deprecated
	PubliclyAccessible *bool `deprecated:"true" type:"boolean"`

	// Contains one or more identifiers of DB clusters that are Read Replicas of
	// this DB instance.
	ReadReplicaDBClusterIdentifiers []*string `locationNameList:"ReadReplicaDBClusterIdentifier" type:"list"`

	// Contains one or more identifiers of the Read Replicas associated with this
	// DB instance.
	ReadReplicaDBInstanceIdentifiers []*string `locationNameList:"ReadReplicaDBInstanceIdentifier" type:"list"`

	// Contains the identifier of the source DB instance if this DB instance is
	// a Read Replica.
	ReadReplicaSourceDBInstanceIdentifier *string `type:"string"`

	// If present, specifies the name of the secondary Availability Zone for a DB
	// instance with multi-AZ support.
	SecondaryAvailabilityZone *string `type:"string"`

	// The status of a Read Replica. If the instance is not a Read Replica, this
	// is blank.
	StatusInfos []*DBInstanceStatusInfo `locationNameList:"DBInstanceStatusInfo" type:"list"`

	// Not supported: The encryption for DB instances is managed by the DB cluster.
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type associated with DB instance.
	StorageType *string `type:"string"`

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// Not supported.
	Timezone *string `type:"string"`

	// Provides a list of VPC security group elements that the DB instance belongs
	// to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstance) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBInstance) SetAllocatedStorage(v int64) *DBInstance {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *DBInstance) SetAutoMinorVersionUpgrade(v bool) *DBInstance {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DBInstance) SetAvailabilityZone(v string) *DBInstance {
	s.AvailabilityZone = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *DBInstance) SetBackupRetentionPeriod(v int64) *DBInstance {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *DBInstance) SetCACertificateIdentifier(v string) *DBInstance {
	s.CACertificateIdentifier = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *DBInstance) SetCharacterSetName(v string) *DBInstance {
	s.CharacterSetName = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *DBInstance) SetCopyTagsToSnapshot(v bool) *DBInstance {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBInstance) SetDBClusterIdentifier(v string) *DBInstance {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceArn sets the DBInstanceArn field's value.
func (s *DBInstance) SetDBInstanceArn(v string) *DBInstance {
	s.DBInstanceArn = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *DBInstance) SetDBInstanceClass(v string) *DBInstance {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBInstance) SetDBInstanceIdentifier(v string) *DBInstance {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBInstanceStatus sets the DBInstanceStatus field's value.
func (s *DBInstance) SetDBInstanceStatus(v string) *DBInstance {
	s.DBInstanceStatus = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *DBInstance) SetDBName(v string) *DBInstance {
	s.DBName = &v
	return s
}

// SetDBParameterGroups sets the DBParameterGroups field's value.
func (s *DBInstance) SetDBParameterGroups(v []*DBParameterGroupStatus) *DBInstance {
	s.DBParameterGroups = v
	return s
}

// SetDBSecurityGroups sets the DBSecurityGroups field's value.
func (s *DBInstance) SetDBSecurityGroups(v []*DBSecurityGroupMembership) *DBInstance {
	s.DBSecurityGroups = v
	return s
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *DBInstance) SetDBSubnetGroup(v *DBSubnetGroup) *DBInstance {
	s.DBSubnetGroup = v
	return s
}

// SetDbInstancePort sets the DbInstancePort field's value.
func (s *DBInstance) SetDbInstancePort(v int64) *DBInstance {
	s.DbInstancePort = &v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *DBInstance) SetDbiResourceId(v string) *DBInstance {
	s.DbiResourceId = &v
	return s
}

// SetDomainMemberships sets the DomainMemberships field's value.
func (s *DBInstance) SetDomainMemberships(v []*DomainMembership) *DBInstance {
	s.DomainMemberships = v
	return s
}

// SetEnabledCloudwatchLogsExports sets the EnabledCloudwatchLogsExports field's value.
func (s *DBInstance) SetEnabledCloudwatchLogsExports(v []*string) *DBInstance {
	s.EnabledCloudwatchLogsExports = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBInstance) SetEndpoint(v *Endpoint) *DBInstance {
	s.Endpoint = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBInstance) SetEngine(v string) *DBInstance {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBInstance) SetEngineVersion(v string) *DBInstance {
	s.EngineVersion = &v
	return s
}

// SetEnhancedMonitoringResourceArn sets the EnhancedMonitoringResourceArn field's value.
func (s *DBInstance) SetEnhancedMonitoringResourceArn(v string) *DBInstance {
	s.EnhancedMonitoringResourceArn = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBInstance) SetIAMDatabaseAuthenticationEnabled(v bool) *DBInstance {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *DBInstance) SetInstanceCreateTime(v time.Time) *DBInstance {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *DBInstance) SetIops(v int64) *DBInstance {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBInstance) SetKmsKeyId(v string) *DBInstance {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *DBInstance) SetLatestRestorableTime(v time.Time) *DBInstance {
	s.LatestRestorableTime = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DBInstance) SetLicenseModel(v string) *DBInstance {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBInstance) SetMasterUsername(v string) *DBInstance {
	s.MasterUsername = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *DBInstance) SetMonitoringInterval(v int64) *DBInstance {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *DBInstance) SetMonitoringRoleArn(v string) *DBInstance {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *DBInstance) SetMultiAZ(v bool) *DBInstance {
	s.MultiAZ = &v
	return s
}

// SetOptionGroupMemberships sets the OptionGroupMemberships field's value.
func (s *DBInstance) SetOptionGroupMemberships(v []*OptionGroupMembership) *DBInstance {
	s.OptionGroupMemberships = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *DBInstance) SetPendingModifiedValues(v *PendingModifiedValues) *DBInstance {
	s.PendingModifiedValues = v
	return s
}

// SetPerformanceInsightsEnabled sets the PerformanceInsightsEnabled field's value.
func (s *DBInstance) SetPerformanceInsightsEnabled(v bool) *DBInstance {
	s.PerformanceInsightsEnabled = &v
	return s
}

// SetPerformanceInsightsKMSKeyId sets the PerformanceInsightsKMSKeyId field's value.
func (s *DBInstance) SetPerformanceInsightsKMSKeyId(v string) *DBInstance {
	s.PerformanceInsightsKMSKeyId = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *DBInstance) SetPreferredBackupWindow(v string) *DBInstance {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *DBInstance) SetPreferredMaintenanceWindow(v string) *DBInstance {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *DBInstance) SetPromotionTier(v int64) *DBInstance {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *DBInstance) SetPubliclyAccessible(v bool) *DBInstance {
	s.PubliclyAccessible = &v
	return s
}

// SetReadReplicaDBClusterIdentifiers sets the ReadReplicaDBClusterIdentifiers field's value.
func (s *DBInstance) SetReadReplicaDBClusterIdentifiers(v []*string) *DBInstance {
	s.ReadReplicaDBClusterIdentifiers = v
	return s
}

// SetReadReplicaDBInstanceIdentifiers sets the ReadReplicaDBInstanceIdentifiers field's value.
func (s *DBInstance) SetReadReplicaDBInstanceIdentifiers(v []*string) *DBInstance {
	s.ReadReplicaDBInstanceIdentifiers = v
	return s
}

// SetReadReplicaSourceDBInstanceIdentifier sets the ReadReplicaSourceDBInstanceIdentifier field's value.
func (s *DBInstance) SetReadReplicaSourceDBInstanceIdentifier(v string) *DBInstance {
	s.ReadReplicaSourceDBInstanceIdentifier = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *DBInstance) SetSecondaryAvailabilityZone(v string) *DBInstance {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetStatusInfos sets the StatusInfos field's value.
func (s *DBInstance) SetStatusInfos(v []*DBInstanceStatusInfo) *DBInstance {
	s.StatusInfos = v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBInstance) SetStorageEncrypted(v bool) *DBInstance {
	s.StorageEncrypted = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DBInstance) SetStorageType(v string) *DBInstance {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *DBInstance) SetTdeCredentialArn(v string) *DBInstance {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DBInstance) SetTimezone(v string) *DBInstance {
	s.Timezone = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *DBInstance) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *DBInstance {
	s.VpcSecurityGroups = v
	return s
}

// Provides a list of status information for a DB instance.
type DBInstanceStatusInfo struct {
	_ struct{} `type:"structure"`

	// Details of the error if there is an error for the instance. If the instance
	// is not in an error state, this value is blank.
	Message *string `type:"string"`

	// Boolean value that is true if the instance is operating normally, or false
	// if the instance is in an error state.
	Normal *bool `type:"boolean"`

	// Status of the DB instance. For a StatusType of read replica, the values can
	// be replicating, error, stopped, or terminated.
	Status *string `type:"string"`

	// This value is currently "read replication."
	StatusType *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceStatusInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DBInstanceStatusInfo) SetMessage(v string) *DBInstanceStatusInfo {
	s.Message = &v
	return s
}

// SetNormal sets the Normal field's value.
func (s *DBInstanceStatusInfo) SetNormal(v bool) *DBInstanceStatusInfo {
	s.Normal = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBInstanceStatusInfo) SetStatus(v string) *DBInstanceStatusInfo {
	s.Status = &v
	return s
}

// SetStatusType sets the StatusType field's value.
func (s *DBInstanceStatusInfo) SetStatusType(v string) *DBInstanceStatusInfo {
	s.StatusType = &v
	return s
}

// Contains the details of an Amazon Neptune DB parameter group.
//
// This data type is used as a response element in the DescribeDBParameterGroups
// action.
type DBParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB parameter group.
	DBParameterGroupArn *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`

	// Provides the customer-specified description for this DB parameter group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroup) GoString() string {
	return s.String()
}

// SetDBParameterGroupArn sets the DBParameterGroupArn field's value.
func (s *DBParameterGroup) SetDBParameterGroupArn(v string) *DBParameterGroup {
	s.DBParameterGroupArn = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBParameterGroup) SetDBParameterGroupFamily(v string) *DBParameterGroup {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DBParameterGroup) SetDBParameterGroupName(v string) *DBParameterGroup {
	s.DBParameterGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DBParameterGroup) SetDescription(v string) *DBParameterGroup {
	s.Description = &v
	return s
}

// The status of the DB parameter group.
//
// This data type is used as a response element in the following actions:
//
//    * CreateDBInstance
//
//    * DeleteDBInstance
//
//    * ModifyDBInstance
//
//    * RebootDBInstance
type DBParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The name of the DP parameter group.
	DBParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroupStatus) GoString() string {
	return s.String()
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DBParameterGroupStatus) SetDBParameterGroupName(v string) *DBParameterGroupStatus {
	s.DBParameterGroupName = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *DBParameterGroupStatus) SetParameterApplyStatus(v string) *DBParameterGroupStatus {
	s.ParameterApplyStatus = &v
	return s
}

// Specifies membership in a designated DB security group.
type DBSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// The status of the DB security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *DBSecurityGroupMembership) SetDBSecurityGroupName(v string) *DBSecurityGroupMembership {
	s.DBSecurityGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBSecurityGroupMembership) SetStatus(v string) *DBSecurityGroupMembership {
	s.Status = &v
	return s
}

// Contains the details of an Amazon Neptune DB subnet group.
//
// This data type is used as a response element in the DescribeDBSubnetGroups
// action.
type DBSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB subnet group.
	DBSubnetGroupArn *string `type:"string"`

	// Provides the description of the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name of the DB subnet group.
	DBSubnetGroupName *string `type:"string"`

	// Provides the status of the DB subnet group.
	SubnetGroupStatus *string `type:"string"`

	// Contains a list of Subnet elements.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// Provides the VpcId of the DB subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSubnetGroup) GoString() string {
	return s.String()
}

// SetDBSubnetGroupArn sets the DBSubnetGroupArn field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupArn(v string) *DBSubnetGroup {
	s.DBSubnetGroupArn = &v
	return s
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupDescription(v string) *DBSubnetGroup {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupName(v string) *DBSubnetGroup {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *DBSubnetGroup) SetSubnetGroupStatus(v string) *DBSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *DBSubnetGroup) SetSubnets(v []*Subnet) *DBSubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBSubnetGroup) SetVpcId(v string) *DBSubnetGroup {
	s.VpcId = &v
	return s
}

type DeleteDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The DB cluster identifier for the DB cluster to be deleted. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must match an existing DBClusterIdentifier.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The DB cluster snapshot identifier of the new DB cluster snapshot created
	// when SkipFinalSnapshot is set to false.
	//
	// Specifying this parameter and also setting the SkipFinalShapshot parameter
	// to true results in an error.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters, numbers, or hyphens.
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	FinalDBSnapshotIdentifier *string `type:"string"`

	// Determines whether a final DB cluster snapshot is created before the DB cluster
	// is deleted. If true is specified, no DB cluster snapshot is created. If false
	// is specified, a DB cluster snapshot is created before the DB cluster is deleted.
	//
	// You must specify a FinalDBSnapshotIdentifier parameter if SkipFinalSnapshot
	// is false.
	//
	// Default: false
	SkipFinalSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DeleteDBClusterInput) SetDBClusterIdentifier(v string) *DeleteDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFinalDBSnapshotIdentifier sets the FinalDBSnapshotIdentifier field's value.
func (s *DeleteDBClusterInput) SetFinalDBSnapshotIdentifier(v string) *DeleteDBClusterInput {
	s.FinalDBSnapshotIdentifier = &v
	return s
}

// SetSkipFinalSnapshot sets the SkipFinalSnapshot field's value.
func (s *DeleteDBClusterInput) SetSkipFinalSnapshot(v bool) *DeleteDBClusterInput {
	s.SkipFinalSnapshot = &v
	return s
}

type DeleteDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB cluster.
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *DeleteDBClusterOutput) SetDBCluster(v *DBCluster) *DeleteDBClusterOutput {
	s.DBCluster = v
	return s
}

type DeleteDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be the name of an existing DB cluster parameter group.
	//
	//    * You can't delete a default DB cluster parameter group.
	//
	//    * Cannot be associated with any DB clusters.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DeleteDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *DeleteDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

type DeleteDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

type DeleteDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster snapshot to delete.
	//
	// Constraints: Must be the name of an existing DB cluster snapshot in the available
	// state.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterSnapshotInput"}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DeleteDBClusterSnapshotInput) SetDBClusterSnapshotIdentifier(v string) *DeleteDBClusterSnapshotInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

type DeleteDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon Neptune DB cluster snapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *DeleteDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *DeleteDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

type DeleteDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The DB instance identifier for the DB instance to be deleted. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must match the name of an existing DB instance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot
	// is set to false.
	//
	// Specifying this parameter and also setting the SkipFinalShapshot parameter
	// to true results in an error.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters or numbers.
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	//    * Cannot be specified when deleting a Read Replica.
	FinalDBSnapshotIdentifier *string `type:"string"`

	// Determines whether a final DB snapshot is created before the DB instance
	// is deleted. If true is specified, no DBSnapshot is created. If false is specified,
	// a DB snapshot is created before the DB instance is deleted.
	//
	// Note that when a DB instance is in a failure state and has a status of 'failed',
	// 'incompatible-restore', or 'incompatible-network', it can only be deleted
	// when the SkipFinalSnapshot parameter is set to "true".
	//
	// Specify true when deleting a Read Replica.
	//
	// The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot
	// is false.
	//
	// Default: false
	SkipFinalSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DeleteDBInstanceInput) SetDBInstanceIdentifier(v string) *DeleteDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetFinalDBSnapshotIdentifier sets the FinalDBSnapshotIdentifier field's value.
func (s *DeleteDBInstanceInput) SetFinalDBSnapshotIdentifier(v string) *DeleteDBInstanceInput {
	s.FinalDBSnapshotIdentifier = &v
	return s
}

// SetSkipFinalSnapshot sets the SkipFinalSnapshot field's value.
func (s *DeleteDBInstanceInput) SetSkipFinalSnapshot(v bool) *DeleteDBInstanceInput {
	s.SkipFinalSnapshot = &v
	return s
}

type DeleteDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB instance.
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s DeleteDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *DeleteDBInstanceOutput) SetDBInstance(v *DBInstance) *DeleteDBInstanceOutput {
	s.DBInstance = v
	return s
}

type DeleteDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * Must be the name of an existing DB parameter group
	//
	//    * You can't delete a default DB parameter group
	//
	//    * Cannot be associated with any DB instances
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBParameterGroupInput"}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DeleteDBParameterGroupInput) SetDBParameterGroupName(v string) *DeleteDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

type DeleteDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBParameterGroupOutput) GoString() string {
	return s.String()
}

type DeleteDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the database subnet group to delete.
	//
	// You can't delete the default subnet group.
	//
	// Constraints:
	//
	// Constraints: Must match the name of an existing DBSubnetGroup. Must not be
	// default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBSubnetGroupInput"}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DeleteDBSubnetGroupInput) SetDBSubnetGroupName(v string) *DeleteDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

type DeleteDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupOutput) GoString() string {
	return s.String()
}

type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the event notification subscription you want to delete.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DeleteEventSubscriptionInput) SetSubscriptionName(v string) *DeleteEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *DeleteEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *DeleteEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type DescribeDBClusterParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB cluster parameter group to return details for.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBClusterParameterGroup.
	DBClusterParameterGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterParameterGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterParameterGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetDBClusterParameterGroupName(v string) *DescribeDBClusterParameterGroupsInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetFilters(v []*Filter) *DescribeDBClusterParameterGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetMarker(v string) *DescribeDBClusterParameterGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetMaxRecords(v int64) *DescribeDBClusterParameterGroupsInput {
	s.MaxRecords = &v
	return s
}

type DescribeDBClusterParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DB cluster parameter groups.
	DBClusterParameterGroups []*DBClusterParameterGroup `locationNameList:"DBClusterParameterGroup" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroups sets the DBClusterParameterGroups field's value.
func (s *DescribeDBClusterParameterGroupsOutput) SetDBClusterParameterGroups(v []*DBClusterParameterGroup) *DescribeDBClusterParameterGroupsOutput {
	s.DBClusterParameterGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParameterGroupsOutput) SetMarker(v string) *DescribeDBClusterParameterGroupsOutput {
	s.Marker = &v
	return s
}

type DescribeDBClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB cluster parameter group to return parameter details
	// for.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBClusterParameterGroup.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A value that indicates to return only parameters for a specific source. Parameter
	// sources can be engine, service, or customer.
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterParametersInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DescribeDBClusterParametersInput) SetDBClusterParameterGroupName(v string) *DescribeDBClusterParametersInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterParametersInput) SetFilters(v []*Filter) *DescribeDBClusterParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParametersInput) SetMarker(v string) *DescribeDBClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterParametersInput) SetMaxRecords(v int64) *DescribeDBClusterParametersInput {
	s.MaxRecords = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeDBClusterParametersInput) SetSource(v string) *DescribeDBClusterParametersInput {
	s.Source = &v
	return s
}

type DescribeDBClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous DescribeDBClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// Provides a list of parameters for the DB cluster parameter group.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeDBClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParametersOutput) SetMarker(v string) *DescribeDBClusterParametersOutput {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeDBClusterParametersOutput) SetParameters(v []*Parameter) *DescribeDBClusterParametersOutput {
	s.Parameters = v
	return s
}

type DescribeDBClusterSnapshotAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the DB cluster snapshot to describe the attributes for.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterSnapshotAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterSnapshotAttributesInput"}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DescribeDBClusterSnapshotAttributesInput) SetDBClusterSnapshotIdentifier(v string) *DescribeDBClusterSnapshotAttributesInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

type DescribeDBClusterSnapshotAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
	// API action.
	//
	// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
	// to copy or restore a manual DB cluster snapshot. For more information, see
	// the ModifyDBClusterSnapshotAttribute API action.
	DBClusterSnapshotAttributesResult *DBClusterSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotAttributesOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributesResult sets the DBClusterSnapshotAttributesResult field's value.
func (s *DescribeDBClusterSnapshotAttributesOutput) SetDBClusterSnapshotAttributesResult(v *DBClusterSnapshotAttributesResult) *DescribeDBClusterSnapshotAttributesOutput {
	s.DBClusterSnapshotAttributesResult = v
	return s
}

type DescribeDBClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DB cluster to retrieve the list of DB cluster snapshots for.
	// This parameter can't be used in conjunction with the DBClusterSnapshotIdentifier
	// parameter. This parameter is not case-sensitive.
	//
	// Constraints:
	//
	//    * If supplied, must match the identifier of an existing DBCluster.
	DBClusterIdentifier *string `type:"string"`

	// A specific DB cluster snapshot identifier to describe. This parameter can't
	// be used in conjunction with the DBClusterIdentifier parameter. This value
	// is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * If supplied, must match the identifier of an existing DBClusterSnapshot.
	//
	//    * If this identifier is for an automated snapshot, the SnapshotType parameter
	//    must also be specified.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// True to include manual DB cluster snapshots that are public and can be copied
	// or restored by any AWS account, and otherwise false. The default is false.
	// The default is false.
	//
	// You can share a manual DB cluster snapshot as public by using the ModifyDBClusterSnapshotAttribute
	// API action.
	IncludePublic *bool `type:"boolean"`

	// True to include shared manual DB cluster snapshots from other AWS accounts
	// that this AWS account has been given permission to copy or restore, and otherwise
	// false. The default is false.
	//
	// You can give an AWS account permission to restore a manual DB cluster snapshot
	// from another AWS account by the ModifyDBClusterSnapshotAttribute API action.
	IncludeShared *bool `type:"boolean"`

	// An optional pagination token provided by a previous DescribeDBClusterSnapshots
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The type of DB cluster snapshots to be returned. You can specify one of the
	// following values:
	//
	//    * automated - Return all DB cluster snapshots that have been automatically
	//    taken by Amazon Neptune for my AWS account.
	//
	//    * manual - Return all DB cluster snapshots that have been taken by my
	//    AWS account.
	//
	//    * shared - Return all manual DB cluster snapshots that have been shared
	//    to my AWS account.
	//
	//    * public - Return all DB cluster snapshots that have been marked as public.
	//
	// If you don't specify a SnapshotType value, then both automated and manual
	// DB cluster snapshots are returned. You can include shared DB cluster snapshots
	// with these results by setting the IncludeShared parameter to true. You can
	// include public DB cluster snapshots with these results by setting the IncludePublic
	// parameter to true.
	//
	// The IncludeShared and IncludePublic parameters don't apply for SnapshotType
	// values of manual or automated. The IncludePublic parameter doesn't apply
	// when SnapshotType is set to shared. The IncludeShared parameter doesn't apply
	// when SnapshotType is set to public.
	SnapshotType *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterSnapshotsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DescribeDBClusterSnapshotsInput) SetDBClusterIdentifier(v string) *DescribeDBClusterSnapshotsInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DescribeDBClusterSnapshotsInput) SetDBClusterSnapshotIdentifier(v string) *DescribeDBClusterSnapshotsInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterSnapshotsInput) SetFilters(v []*Filter) *DescribeDBClusterSnapshotsInput {
	s.Filters = v
	return s
}

// SetIncludePublic sets the IncludePublic field's value.
func (s *DescribeDBClusterSnapshotsInput) SetIncludePublic(v bool) *DescribeDBClusterSnapshotsInput {
	s.IncludePublic = &v
	return s
}

// SetIncludeShared sets the IncludeShared field's value.
func (s *DescribeDBClusterSnapshotsInput) SetIncludeShared(v bool) *DescribeDBClusterSnapshotsInput {
	s.IncludeShared = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterSnapshotsInput) SetMarker(v string) *DescribeDBClusterSnapshotsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterSnapshotsInput) SetMaxRecords(v int64) *DescribeDBClusterSnapshotsInput {
	s.MaxRecords = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DescribeDBClusterSnapshotsInput) SetSnapshotType(v string) *DescribeDBClusterSnapshotsInput {
	s.SnapshotType = &v
	return s
}

type DescribeDBClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// Provides a list of DB cluster snapshots for the user.
	DBClusterSnapshots []*DBClusterSnapshot `locationNameList:"DBClusterSnapshot" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterSnapshots
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshots sets the DBClusterSnapshots field's value.
func (s *DescribeDBClusterSnapshotsOutput) SetDBClusterSnapshots(v []*DBClusterSnapshot) *DescribeDBClusterSnapshotsOutput {
	s.DBClusterSnapshots = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterSnapshotsOutput) SetMarker(v string) *DescribeDBClusterSnapshotsOutput {
	s.Marker = &v
	return s
}

type DescribeDBClustersInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied DB cluster identifier. If this parameter is specified,
	// information from only the specific DB cluster is returned. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * If supplied, must match an existing DBClusterIdentifier.
	DBClusterIdentifier *string `type:"string"`

	// A filter that specifies one or more DB clusters to describe.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon
	//    Resource Names (ARNs). The results list will only include information
	//    about the DB clusters identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusters request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClustersInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DescribeDBClustersInput) SetDBClusterIdentifier(v string) *DescribeDBClustersInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClustersInput) SetFilters(v []*Filter) *DescribeDBClustersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClustersInput) SetMarker(v string) *DescribeDBClustersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClustersInput) SetMaxRecords(v int64) *DescribeDBClustersInput {
	s.MaxRecords = &v
	return s
}

type DescribeDBClustersOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of DB clusters for the user.
	DBClusters []*DBCluster `locationNameList:"DBCluster" type:"list"`

	// A pagination token that can be used in a subsequent DescribeDBClusters request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClustersOutput) GoString() string {
	return s.String()
}

// SetDBClusters sets the DBClusters field's value.
func (s *DescribeDBClustersOutput) SetDBClusters(v []*DBCluster) *DescribeDBClustersOutput {
	s.DBClusters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClustersOutput) SetMarker(v string) *DescribeDBClustersOutput {
	s.Marker = &v
	return s
}

type DescribeDBEngineVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB parameter group family to return details for.
	//
	// Constraints:
	//
	//    * If supplied, must match an existing DBParameterGroupFamily.
	DBParameterGroupFamily *string `type:"string"`

	// Indicates that only the default version of the specified engine or engine
	// and major version combination is returned.
	DefaultOnly *bool `type:"boolean"`

	// The database engine to return.
	Engine *string `type:"string"`

	// The database engine version to return.
	//
	// Example: 5.1.49
	EngineVersion *string `type:"string"`

	// Not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// If this parameter is specified and the requested engine supports the CharacterSetName
	// parameter for CreateDBInstance, the response includes a list of supported
	// character sets for each engine version.
	ListSupportedCharacterSets *bool `type:"boolean"`

	// If this parameter is specified and the requested engine supports the TimeZone
	// parameter for CreateDBInstance, the response includes a list of supported
	// time zones for each engine version.
	ListSupportedTimezones *bool `type:"boolean"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more than the
	// MaxRecords value is available, a pagination token called a marker is included
	// in the response so that the following results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBEngineVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBEngineVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBEngineVersionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DescribeDBEngineVersionsInput) SetDBParameterGroupFamily(v string) *DescribeDBEngineVersionsInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDefaultOnly sets the DefaultOnly field's value.
func (s *DescribeDBEngineVersionsInput) SetDefaultOnly(v bool) *DescribeDBEngineVersionsInput {
	s.DefaultOnly = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DescribeDBEngineVersionsInput) SetEngine(v string) *DescribeDBEngineVersionsInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeDBEngineVersionsInput) SetEngineVersion(v string) *DescribeDBEngineVersionsInput {
	s.EngineVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBEngineVersionsInput) SetFilters(v []*Filter) *DescribeDBEngineVersionsInput {
	s.Filters = v
	return s
}

// SetListSupportedCharacterSets sets the ListSupportedCharacterSets field's value.
func (s *DescribeDBEngineVersionsInput) SetListSupportedCharacterSets(v bool) *DescribeDBEngineVersionsInput {
	s.ListSupportedCharacterSets = &v
	return s
}

// SetListSupportedTimezones sets the ListSupportedTimezones field's value.
func (s *DescribeDBEngineVersionsInput) SetListSupportedTimezones(v bool) *DescribeDBEngineVersionsInput {
	s.ListSupportedTimezones = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBEngineVersionsInput) SetMarker(v string) *DescribeDBEngineVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBEngineVersionsInput) SetMaxRecords(v int64) *DescribeDBEngineVersionsInput {
	s.MaxRecords = &v
	return s
}

type DescribeDBEngineVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBEngineVersion elements.
	DBEngineVersions []*DBEngineVersion `locationNameList:"DBEngineVersion" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBEngineVersionsOutput) GoString() string {
	return s.String()
}

// SetDBEngineVersions sets the DBEngineVersions field's value.
func (s *DescribeDBEngineVersionsOutput) SetDBEngineVersions(v []*DBEngineVersion) *DescribeDBEngineVersionsOutput {
	s.DBEngineVersions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBEngineVersionsOutput) SetMarker(v string) *DescribeDBEngineVersionsOutput {
	s.Marker = &v
	return s
}

type DescribeDBInstancesInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied instance identifier. If this parameter is specified, information
	// from only the specific DB instance is returned. This parameter isn't case-sensitive.
	//
	// Constraints:
	//
	//    * If supplied, must match the identifier of an existing DBInstance.
	DBInstanceIdentifier *string `type:"string"`

	// A filter that specifies one or more DB instances to describe.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon
	//    Resource Names (ARNs). The results list will only include information
	//    about the DB instances associated with the DB clusters identified by these
	//    ARNs.
	//
	//    * db-instance-id - Accepts DB instance identifiers and DB instance Amazon
	//    Resource Names (ARNs). The results list will only include information
	//    about the DB instances identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBInstances request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBInstancesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DescribeDBInstancesInput) SetDBInstanceIdentifier(v string) *DescribeDBInstancesInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBInstancesInput) SetFilters(v []*Filter) *DescribeDBInstancesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBInstancesInput) SetMarker(v string) *DescribeDBInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBInstancesInput) SetMaxRecords(v int64) *DescribeDBInstancesInput {
	s.MaxRecords = &v
	return s
}

type DescribeDBInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBInstance instances.
	DBInstances []*DBInstance `locationNameList:"DBInstance" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords .
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetDBInstances sets the DBInstances field's value.
func (s *DescribeDBInstancesOutput) SetDBInstances(v []*DBInstance) *DescribeDBInstancesOutput {
	s.DBInstances = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBInstancesOutput) SetMarker(v string) *DescribeDBInstancesOutput {
	s.Marker = &v
	return s
}

type DescribeDBParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB parameter group to return details for.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBClusterParameterGroup.
	DBParameterGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParameterGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBParameterGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBParameterGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DescribeDBParameterGroupsInput) SetDBParameterGroupName(v string) *DescribeDBParameterGroupsInput {
	s.DBParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBParameterGroupsInput) SetFilters(v []*Filter) *DescribeDBParameterGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBParameterGroupsInput) SetMarker(v string) *DescribeDBParameterGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBParameterGroupsInput) SetMaxRecords(v int64) *DescribeDBParameterGroupsInput {
	s.MaxRecords = &v
	return s
}

type DescribeDBParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBParameterGroup instances.
	DBParameterGroups []*DBParameterGroup `locationNameList:"DBParameterGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetDBParameterGroups sets the DBParameterGroups field's value.
func (s *DescribeDBParameterGroupsOutput) SetDBParameterGroups(v []*DBParameterGroup) *DescribeDBParameterGroupsOutput {
	s.DBParameterGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBParameterGroupsOutput) SetMarker(v string) *DescribeDBParameterGroupsOutput {
	s.Marker = &v
	return s
}

type DescribeDBParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB parameter group to return details for.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBParameterGroup.
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The parameter types to return.
	//
	// Default: All parameter types returned
	//
	// Valid Values: user | system | engine-default
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBParametersInput"}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DescribeDBParametersInput) SetDBParameterGroupName(v string) *DescribeDBParametersInput {
	s.DBParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBParametersInput) SetFilters(v []*Filter) *DescribeDBParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBParametersInput) SetMarker(v string) *DescribeDBParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBParametersInput) SetMaxRecords(v int64) *DescribeDBParametersInput {
	s.MaxRecords = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeDBParametersInput) SetSource(v string) *DescribeDBParametersInput {
	s.Source = &v
	return s
}

type DescribeDBParametersOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of Parameter values.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeDBParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParametersOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBParametersOutput) SetMarker(v string) *DescribeDBParametersOutput {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeDBParametersOutput) SetParameters(v []*Parameter) *DescribeDBParametersOutput {
	s.Parameters = v
	return s
}

type DescribeDBSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB subnet group to return details for.
	DBSubnetGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBSubnetGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSubnetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBSubnetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBSubnetGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DescribeDBSubnetGroupsInput) SetDBSubnetGroupName(v string) *DescribeDBSubnetGroupsInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBSubnetGroupsInput) SetFilters(v []*Filter) *DescribeDBSubnetGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSubnetGroupsInput) SetMarker(v string) *DescribeDBSubnetGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBSubnetGroupsInput) SetMaxRecords(v int64) *DescribeDBSubnetGroupsInput {
	s.MaxRecords = &v
	return s
}

type DescribeDBSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBSubnetGroup instances.
	DBSubnetGroups []*DBSubnetGroup `locationNameList:"DBSubnetGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroups sets the DBSubnetGroups field's value.
func (s *DescribeDBSubnetGroupsOutput) SetDBSubnetGroups(v []*DBSubnetGroup) *DescribeDBSubnetGroupsOutput {
	s.DBSubnetGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSubnetGroupsOutput) SetMarker(v string) *DescribeDBSubnetGroupsOutput {
	s.Marker = &v
	return s
}

type DescribeEngineDefaultClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group family to return engine parameter
	// information for.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeEngineDefaultClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEngineDefaultClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEngineDefaultClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEngineDefaultClusterParametersInput"}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetDBParameterGroupFamily(v string) *DescribeEngineDefaultClusterParametersInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetFilters(v []*Filter) *DescribeEngineDefaultClusterParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetMarker(v string) *DescribeEngineDefaultClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetMaxRecords(v int64) *DescribeEngineDefaultClusterParametersInput {
	s.MaxRecords = &v
	return s
}

type DescribeEngineDefaultClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
	// action.
	EngineDefaults *EngineDefaults `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultClusterParametersOutput) GoString() string {
	return s.String()
}

// SetEngineDefaults sets the EngineDefaults field's value.
func (s *DescribeEngineDefaultClusterParametersOutput) SetEngineDefaults(v *EngineDefaults) *DescribeEngineDefaultClusterParametersOutput {
	s.EngineDefaults = v
	return s
}

type DescribeEngineDefaultParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group family.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// Not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeEngineDefaultParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEngineDefaultParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEngineDefaultParametersInput"}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DescribeEngineDefaultParametersInput) SetDBParameterGroupFamily(v string) *DescribeEngineDefaultParametersInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEngineDefaultParametersInput) SetFilters(v []*Filter) *DescribeEngineDefaultParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEngineDefaultParametersInput) SetMarker(v string) *DescribeEngineDefaultParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEngineDefaultParametersInput) SetMaxRecords(v int64) *DescribeEngineDefaultParametersInput {
	s.MaxRecords = &v
	return s
}

type DescribeEngineDefaultParametersOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
	// action.
	EngineDefaults *EngineDefaults `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersOutput) GoString() string {
	return s.String()
}

// SetEngineDefaults sets the EngineDefaults field's value.
func (s *DescribeEngineDefaultParametersOutput) SetEngineDefaults(v *EngineDefaults) *DescribeEngineDefaultParametersOutput {
	s.EngineDefaults = v
	return s
}

type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The type of source that is generating the events.
	//
	// Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventCategoriesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventCategoriesInput) SetFilters(v []*Filter) *DescribeEventCategoriesInput {
	s.Filters = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventCategoriesInput) SetSourceType(v string) *DescribeEventCategoriesInput {
	s.SourceType = &v
	return s
}

type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of EventCategoriesMap data types.
	EventCategoriesMapList []*EventCategoriesMap `locationNameList:"EventCategoriesMap" type:"list"`
}

// String returns the string representation
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

// SetEventCategoriesMapList sets the EventCategoriesMapList field's value.
func (s *DescribeEventCategoriesOutput) SetEventCategoriesMapList(v []*EventCategoriesMap) *DescribeEventCategoriesOutput {
	s.EventCategoriesMapList = v
	return s
}

type DescribeEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the event notification subscription you want to describe.
	SubscriptionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventSubscriptionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventSubscriptionsInput) SetFilters(v []*Filter) *DescribeEventSubscriptionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsInput) SetMarker(v string) *DescribeEventSubscriptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventSubscriptionsInput) SetMaxRecords(v int64) *DescribeEventSubscriptionsInput {
	s.MaxRecords = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DescribeEventSubscriptionsInput) SetSubscriptionName(v string) *DescribeEventSubscriptionsInput {
	s.SubscriptionName = &v
	return s
}

type DescribeEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of EventSubscriptions data types.
	EventSubscriptionsList []*EventSubscription `locationNameList:"EventSubscription" type:"list"`

	// An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetEventSubscriptionsList sets the EventSubscriptionsList field's value.
func (s *DescribeEventSubscriptionsOutput) SetEventSubscriptionsList(v []*EventSubscription) *DescribeEventSubscriptionsOutput {
	s.EventSubscriptionsList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsOutput) SetMarker(v string) *DescribeEventSubscriptionsOutput {
	s.Marker = &v
	return s
}

type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes to retrieve events for.
	//
	// Default: 60
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	EndTime *time.Time `type:"timestamp"`

	// A list of event categories that trigger notifications for a event notification
	// subscription.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeEvents request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source for which events are returned. If not
	// specified, then all sources are included in the response.
	//
	// Constraints:
	//
	//    * If SourceIdentifier is supplied, SourceType must also be provided.
	//
	//    * If the source type is DBInstance, then a DBInstanceIdentifier must be
	//    supplied.
	//
	//    * If the source type is DBSecurityGroup, a DBSecurityGroupName must be
	//    supplied.
	//
	//    * If the source type is DBParameterGroup, a DBParameterGroupName must
	//    be supplied.
	//
	//    * If the source type is DBSnapshot, a DBSnapshotIdentifier must be supplied.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	SourceIdentifier *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *DescribeEventsInput) SetEventCategories(v []*string) *DescribeEventsInput {
	s.EventCategories = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventsInput) SetFilters(v []*Filter) *DescribeEventsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsInput) SetMarker(v string) *DescribeEventsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *DescribeEventsInput) SetSourceIdentifier(v string) *DescribeEventsInput {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Event instances.
	Events []*Event `locationNameList:"Event" type:"list"`

	// An optional pagination token provided by a previous Events request. If this
	// parameter is specified, the response includes only records beyond the marker,
	// up to the value specified by MaxRecords .
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsOutput) SetMarker(v string) *DescribeEventsOutput {
	s.Marker = &v
	return s
}

type DescribeOrderableDBInstanceOptionsInput struct {
	_ struct{} `type:"structure"`

	// The DB instance class filter value. Specify this parameter to show only the
	// available offerings matching the specified DB instance class.
	DBInstanceClass *string `type:"string"`

	// The name of the engine to retrieve DB instance options for.
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The engine version filter value. Specify this parameter to show only the
	// available offerings matching the specified engine version.
	EngineVersion *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The license model filter value. Specify this parameter to show only the available
	// offerings matching the specified license model.
	LicenseModel *string `type:"string"`

	// An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The VPC filter value. Specify this parameter to show only the available VPC
	// or non-VPC offerings.
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeOrderableDBInstanceOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableDBInstanceOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrderableDBInstanceOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrderableDBInstanceOptionsInput"}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetDBInstanceClass(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.DBInstanceClass = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetEngine(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetEngineVersion(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.EngineVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetFilters(v []*Filter) *DescribeOrderableDBInstanceOptionsInput {
	s.Filters = v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetLicenseModel(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.LicenseModel = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetMarker(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetMaxRecords(v int64) *DescribeOrderableDBInstanceOptionsInput {
	s.MaxRecords = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetVpc(v bool) *DescribeOrderableDBInstanceOptionsInput {
	s.Vpc = &v
	return s
}

type DescribeOrderableDBInstanceOptionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous OrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// An OrderableDBInstanceOption structure containing information about orderable
	// options for the DB instance.
	OrderableDBInstanceOptions []*OrderableDBInstanceOption `locationNameList:"OrderableDBInstanceOption" type:"list"`
}

// String returns the string representation
func (s DescribeOrderableDBInstanceOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableDBInstanceOptionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableDBInstanceOptionsOutput) SetMarker(v string) *DescribeOrderableDBInstanceOptionsOutput {
	s.Marker = &v
	return s
}

// SetOrderableDBInstanceOptions sets the OrderableDBInstanceOptions field's value.
func (s *DescribeOrderableDBInstanceOptionsOutput) SetOrderableDBInstanceOptions(v []*OrderableDBInstanceOption) *DescribeOrderableDBInstanceOptionsOutput {
	s.OrderableDBInstanceOptions = v
	return s
}

type DescribePendingMaintenanceActionsInput struct {
	_ struct{} `type:"structure"`

	// A filter that specifies one or more resources to return pending maintenance
	// actions for.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon
	//    Resource Names (ARNs). The results list will only include pending maintenance
	//    actions for the DB clusters identified by these ARNs.
	//
	//    * db-instance-id - Accepts DB instance identifiers and DB instance ARNs.
	//    The results list will only include pending maintenance actions for the
	//    DB instances identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribePendingMaintenanceActions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to a number of records specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The ARN of a resource to return pending maintenance actions for.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePendingMaintenanceActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePendingMaintenanceActionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePendingMaintenanceActionsInput) SetFilters(v []*Filter) *DescribePendingMaintenanceActionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMarker(v string) *DescribePendingMaintenanceActionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMaxRecords(v int64) *DescribePendingMaintenanceActionsInput {
	s.MaxRecords = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *DescribePendingMaintenanceActionsInput) SetResourceIdentifier(v string) *DescribePendingMaintenanceActionsInput {
	s.ResourceIdentifier = &v
	return s
}

type DescribePendingMaintenanceActionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous DescribePendingMaintenanceActions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to a number of records specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of the pending maintenance actions for the resource.
	PendingMaintenanceActions []*ResourcePendingMaintenanceActions `locationNameList:"ResourcePendingMaintenanceActions" type:"list"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetMarker(v string) *DescribePendingMaintenanceActionsOutput {
	s.Marker = &v
	return s
}

// SetPendingMaintenanceActions sets the PendingMaintenanceActions field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetPendingMaintenanceActions(v []*ResourcePendingMaintenanceActions) *DescribePendingMaintenanceActionsOutput {
	s.PendingMaintenanceActions = v
	return s
}

type DescribeValidDBInstanceModificationsInput struct {
	_ struct{} `type:"structure"`

	// The customer identifier or the ARN of your DB instance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeValidDBInstanceModificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeValidDBInstanceModificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeValidDBInstanceModificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeValidDBInstanceModificationsInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DescribeValidDBInstanceModificationsInput) SetDBInstanceIdentifier(v string) *DescribeValidDBInstanceModificationsInput {
	s.DBInstanceIdentifier = &v
	return s
}

type DescribeValidDBInstanceModificationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about valid modifications that you can make to your DB instance.
	// Contains the result of a successful call to the DescribeValidDBInstanceModifications
	// action. You can use this information when you call ModifyDBInstance.
	ValidDBInstanceModificationsMessage *ValidDBInstanceModificationsMessage `type:"structure"`
}

// String returns the string representation
func (s DescribeValidDBInstanceModificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeValidDBInstanceModificationsOutput) GoString() string {
	return s.String()
}

// SetValidDBInstanceModificationsMessage sets the ValidDBInstanceModificationsMessage field's value.
func (s *DescribeValidDBInstanceModificationsOutput) SetValidDBInstanceModificationsMessage(v *ValidDBInstanceModificationsMessage) *DescribeValidDBInstanceModificationsOutput {
	s.ValidDBInstanceModificationsMessage = v
	return s
}

// An Active Directory Domain membership record associated with a DB instance.
type DomainMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the Active Directory Domain.
	Domain *string `type:"string"`

	// The fully qualified domain name of the Active Directory Domain.
	FQDN *string `type:"string"`

	// The name of the IAM role to be used when making API calls to the Directory
	// Service.
	IAMRoleName *string `type:"string"`

	// The status of the DB instance's Active Directory Domain membership, such
	// as joined, pending-join, failed etc).
	Status *string `type:"string"`
}

// String returns the string representation
func (s DomainMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainMembership) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DomainMembership) SetDomain(v string) *DomainMembership {
	s.Domain = &v
	return s
}

// SetFQDN sets the FQDN field's value.
func (s *DomainMembership) SetFQDN(v string) *DomainMembership {
	s.FQDN = &v
	return s
}

// SetIAMRoleName sets the IAMRoleName field's value.
func (s *DomainMembership) SetIAMRoleName(v string) *DomainMembership {
	s.IAMRoleName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainMembership) SetStatus(v string) *DomainMembership {
	s.Status = &v
	return s
}

// A range of double values.
type DoubleRange struct {
	_ struct{} `type:"structure"`

	// The minimum value in the range.
	From *float64 `type:"double"`

	// The maximum value in the range.
	To *float64 `type:"double"`
}

// String returns the string representation
func (s DoubleRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DoubleRange) GoString() string {
	return s.String()
}

// SetFrom sets the From field's value.
func (s *DoubleRange) SetFrom(v float64) *DoubleRange {
	s.From = &v
	return s
}

// SetTo sets the To field's value.
func (s *DoubleRange) SetTo(v float64) *DoubleRange {
	s.To = &v
	return s
}

// Specifies a connection endpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *Endpoint) SetHostedZoneId(v string) *Endpoint {
	s.HostedZoneId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
// action.
type EngineDefaults struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB parameter group family that the engine default
	// parameters apply to.
	DBParameterGroupFamily *string `type:"string"`

	// An optional pagination token provided by a previous EngineDefaults request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// Contains a list of engine default parameters.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineDefaults) GoString() string {
	return s.String()
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *EngineDefaults) SetDBParameterGroupFamily(v string) *EngineDefaults {
	s.DBParameterGroupFamily = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *EngineDefaults) SetMarker(v string) *EngineDefaults {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *EngineDefaults) SetParameters(v []*Parameter) *EngineDefaults {
	s.Parameters = v
	return s
}

// This data type is used as a response element in the DescribeEvents action.
type Event struct {
	_ struct{} `type:"structure"`

	// Specifies the date and time of the event.
	Date *time.Time `type:"timestamp"`

	// Specifies the category for the event.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Provides the text of this event.
	Message *string `type:"string"`

	// The Amazon Resource Name (ARN) for the event.
	SourceArn *string `type:"string"`

	// Provides the identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// Specifies the source type for this event.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *Event) SetEventCategories(v []*string) *Event {
	s.EventCategories = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *Event) SetSourceArn(v string) *Event {
	s.SourceArn = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Event) SetSourceIdentifier(v string) *Event {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

// Contains the results of a successful invocation of the DescribeEventCategories
// action.
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The event categories for the specified source type
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The source type that the returned categories belong to
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCategoriesMap) GoString() string {
	return s.String()
}

// SetEventCategories sets the EventCategories field's value.
func (s *EventCategoriesMap) SetEventCategories(v []*string) *EventCategoriesMap {
	s.EventCategories = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventCategoriesMap) SetSourceType(v string) *EventCategoriesMap {
	s.SourceType = &v
	return s
}

// Contains the results of a successful invocation of the DescribeEventSubscriptions
// action.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The event notification subscription Id.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the event notification subscription.
	CustomerAwsId *string `type:"string"`

	// A Boolean value indicating if the subscription is enabled. True indicates
	// the subscription is enabled.
	Enabled *bool `type:"boolean"`

	// A list of event categories for the event notification subscription.
	EventCategoriesList []*string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) for the event subscription.
	EventSubscriptionArn *string `type:"string"`

	// The topic ARN of the event notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of source IDs for the event notification subscription.
	SourceIdsList []*string `locationNameList:"SourceId" type:"list"`

	// The source type for the event notification subscription.
	SourceType *string `type:"string"`

	// The status of the event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active | no-permission
	// | topic-not-exist
	//
	// The status "no-permission" indicates that Neptune no longer has permission
	// to post to the SNS topic. The status "topic-not-exist" indicates that the
	// topic was deleted after the subscription was created.
	Status *string `type:"string"`

	// The time the event notification subscription was created.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSubscription) GoString() string {
	return s.String()
}

// SetCustSubscriptionId sets the CustSubscriptionId field's value.
func (s *EventSubscription) SetCustSubscriptionId(v string) *EventSubscription {
	s.CustSubscriptionId = &v
	return s
}

// SetCustomerAwsId sets the CustomerAwsId field's value.
func (s *EventSubscription) SetCustomerAwsId(v string) *EventSubscription {
	s.CustomerAwsId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventSubscription) SetEnabled(v bool) *EventSubscription {
	s.Enabled = &v
	return s
}

// SetEventCategoriesList sets the EventCategoriesList field's value.
func (s *EventSubscription) SetEventCategoriesList(v []*string) *EventSubscription {
	s.EventCategoriesList = v
	return s
}

// SetEventSubscriptionArn sets the EventSubscriptionArn field's value.
func (s *EventSubscription) SetEventSubscriptionArn(v string) *EventSubscription {
	s.EventSubscriptionArn = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *EventSubscription) SetSnsTopicArn(v string) *EventSubscription {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIdsList sets the SourceIdsList field's value.
func (s *EventSubscription) SetSourceIdsList(v []*string) *EventSubscription {
	s.SourceIdsList = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventSubscription) SetSourceType(v string) *EventSubscription {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventSubscription) SetStatus(v string) *EventSubscription {
	s.Status = &v
	return s
}

// SetSubscriptionCreationTime sets the SubscriptionCreationTime field's value.
func (s *EventSubscription) SetSubscriptionCreationTime(v string) *EventSubscription {
	s.SubscriptionCreationTime = &v
	return s
}

type FailoverDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A DB cluster identifier to force a failover for. This parameter is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBCluster.
	DBClusterIdentifier *string `type:"string"`

	// The name of the instance to promote to the primary instance.
	//
	// You must specify the instance identifier for an Read Replica in the DB cluster.
	// For example, mydbcluster-replica1.
	TargetDBInstanceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s FailoverDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverDBClusterInput) GoString() string {
	return s.String()
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *FailoverDBClusterInput) SetDBClusterIdentifier(v string) *FailoverDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetTargetDBInstanceIdentifier sets the TargetDBInstanceIdentifier field's value.
func (s *FailoverDBClusterInput) SetTargetDBInstanceIdentifier(v string) *FailoverDBClusterInput {
	s.TargetDBInstanceIdentifier = &v
	return s
}

type FailoverDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB cluster.
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s FailoverDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *FailoverDBClusterOutput) SetDBCluster(v *DBCluster) *FailoverDBClusterOutput {
	s.DBCluster = v
	return s
}

// This type is not currently supported.
type Filter struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	//
	// Values is a required field
	Values []*string `locationNameList:"Value" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The Amazon Neptune resource with tags to be listed. This value is an Amazon
	// Resource Name (ARN). For information about creating an ARN, see  Constructing
	// an Amazon Resource Name (ARN) (https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListTagsForResourceInput) SetFilters(v []*Filter) *ListTagsForResourceInput {
	s.Filters = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ListTagsForResourceInput) SetResourceName(v string) *ListTagsForResourceInput {
	s.ResourceName = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// List of tags returned by the ListTagsForResource operation.
	TagList []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

type ModifyDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A value that specifies whether the modifications in this request and any
	// pending modifications are asynchronously applied as soon as possible, regardless
	// of the PreferredMaintenanceWindow setting for the DB cluster. If this parameter
	// is set to false, changes to the DB cluster are applied during the next maintenance
	// window.
	//
	// The ApplyImmediately parameter only affects the NewDBClusterIdentifier and
	// MasterUserPassword values. If you set the ApplyImmediately parameter value
	// to false, then changes to the NewDBClusterIdentifier and MasterUserPassword
	// values are applied during the next maintenance window. All other changes
	// are applied immediately, regardless of the value of the ApplyImmediately
	// parameter.
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// The number of days for which automated backups are retained. You must specify
	// a minimum value of 1.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 1 to 35
	BackupRetentionPeriod *int64 `type:"integer"`

	// The DB cluster identifier for the cluster being modified. This parameter
	// is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBCluster.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to use for the DB cluster.
	DBClusterParameterGroupName *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts, and otherwise false.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The version number of the database engine to which you want to upgrade. Changing
	// this parameter results in an outage. The change is applied during the next
	// maintenance window unless the ApplyImmediately parameter is set to true.
	//
	// For a list of valid engine versions, see CreateDBInstance, or call DescribeDBEngineVersions.
	EngineVersion *string `type:"string"`

	// The new password for the master database user. This password can contain
	// any printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain from 8 to 41 characters.
	MasterUserPassword *string `type:"string"`

	// The new DB cluster identifier for the DB cluster when renaming a DB cluster.
	// This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens
	//
	//    * The first character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-cluster2
	NewDBClusterIdentifier *string `type:"string"`

	// A value that indicates that the DB cluster should be associated with the
	// specified option group. Changing this parameter doesn't result in an outage
	// except in the following case, and the change is applied during the next maintenance
	// window unless the ApplyImmediately parameter is set to true for this request.
	// If the parameter change results in an option group that enables OEM, this
	// change can cause a brief (sub-second) period during which new connections
	// are rejected but existing connections are not interrupted.
	//
	// Permanent options can't be removed from an option group. The option group
	// can't be removed from a DB cluster once it is associated with a DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the DB cluster accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB cluster.
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Must be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// A list of VPC security groups that the DB cluster will belong to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyDBClusterInput) SetApplyImmediately(v bool) *ModifyDBClusterInput {
	s.ApplyImmediately = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *ModifyDBClusterInput) SetBackupRetentionPeriod(v int64) *ModifyDBClusterInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *ModifyDBClusterInput) SetDBClusterIdentifier(v string) *ModifyDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ModifyDBClusterInput) SetDBClusterParameterGroupName(v string) *ModifyDBClusterInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *ModifyDBClusterInput) SetEnableIAMDatabaseAuthentication(v bool) *ModifyDBClusterInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyDBClusterInput) SetEngineVersion(v string) *ModifyDBClusterInput {
	s.EngineVersion = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *ModifyDBClusterInput) SetMasterUserPassword(v string) *ModifyDBClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetNewDBClusterIdentifier sets the NewDBClusterIdentifier field's value.
func (s *ModifyDBClusterInput) SetNewDBClusterIdentifier(v string) *ModifyDBClusterInput {
	s.NewDBClusterIdentifier = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *ModifyDBClusterInput) SetOptionGroupName(v string) *ModifyDBClusterInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ModifyDBClusterInput) SetPort(v int64) *ModifyDBClusterInput {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *ModifyDBClusterInput) SetPreferredBackupWindow(v string) *ModifyDBClusterInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyDBClusterInput) SetPreferredMaintenanceWindow(v string) *ModifyDBClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ModifyDBClusterInput) SetVpcSecurityGroupIds(v []*string) *ModifyDBClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

type ModifyDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB cluster.
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s ModifyDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *ModifyDBClusterOutput) SetDBCluster(v *DBCluster) *ModifyDBClusterOutput {
	s.DBCluster = v
	return s
}

type ModifyDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group to modify.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// A list of parameters in the DB cluster parameter group to modify.
	//
	// Parameters is a required field
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ModifyDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *ModifyDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ModifyDBClusterParameterGroupInput) SetParameters(v []*Parameter) *ModifyDBClusterParameterGroupInput {
	s.Parameters = v
	return s
}

type ModifyDBClusterSnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster snapshot attribute to modify.
	//
	// To manage authorization for other AWS accounts to copy or restore a manual
	// DB cluster snapshot, set this value to restore.
	//
	// AttributeName is a required field
	AttributeName *string `type:"string" required:"true"`

	// The identifier for the DB cluster snapshot to modify the attributes for.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of DB cluster snapshot attributes to add to the attribute specified
	// by AttributeName.
	//
	// To authorize other AWS accounts to copy or restore a manual DB cluster snapshot,
	// set this list to include one or more AWS account IDs, or all to make the
	// manual DB cluster snapshot restorable by any AWS account. Do not add the
	// all value for any manual DB cluster snapshots that contain private information
	// that you don't want available to all AWS accounts.
	ValuesToAdd []*string `locationNameList:"AttributeValue" type:"list"`

	// A list of DB cluster snapshot attributes to remove from the attribute specified
	// by AttributeName.
	//
	// To remove authorization for other AWS accounts to copy or restore a manual
	// DB cluster snapshot, set this list to include one or more AWS account identifiers,
	// or all to remove authorization for any AWS account to copy or restore the
	// DB cluster snapshot. If you specify all, an AWS account whose account ID
	// is explicitly added to the restore attribute can still copy or restore a
	// manual DB cluster snapshot.
	ValuesToRemove []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s ModifyDBClusterSnapshotAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterSnapshotAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterSnapshotAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBClusterSnapshotAttributeInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetAttributeName(v string) *ModifyDBClusterSnapshotAttributeInput {
	s.AttributeName = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetDBClusterSnapshotIdentifier(v string) *ModifyDBClusterSnapshotAttributeInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetValuesToAdd sets the ValuesToAdd field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetValuesToAdd(v []*string) *ModifyDBClusterSnapshotAttributeInput {
	s.ValuesToAdd = v
	return s
}

// SetValuesToRemove sets the ValuesToRemove field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetValuesToRemove(v []*string) *ModifyDBClusterSnapshotAttributeInput {
	s.ValuesToRemove = v
	return s
}

type ModifyDBClusterSnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
	// API action.
	//
	// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
	// to copy or restore a manual DB cluster snapshot. For more information, see
	// the ModifyDBClusterSnapshotAttribute API action.
	DBClusterSnapshotAttributesResult *DBClusterSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s ModifyDBClusterSnapshotAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterSnapshotAttributeOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributesResult sets the DBClusterSnapshotAttributesResult field's value.
func (s *ModifyDBClusterSnapshotAttributeOutput) SetDBClusterSnapshotAttributesResult(v *DBClusterSnapshotAttributesResult) *ModifyDBClusterSnapshotAttributeOutput {
	s.DBClusterSnapshotAttributesResult = v
	return s
}

type ModifyDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The new amount of storage (in gibibytes) to allocate for the DB instance.
	//
	// Not applicable. Storage is managed by the DB Cluster.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that major version upgrades are allowed. Changing this parameter
	// doesn't result in an outage and the change is asynchronously applied as soon
	// as possible.
	//
	// Constraints: This parameter must be set to true when specifying a value for
	// the EngineVersion parameter that is a different major version than the DB
	// instance's current version.
	AllowMajorVersionUpgrade *bool `type:"boolean"`

	// Specifies whether the modifications in this request and any pending modifications
	// are asynchronously applied as soon as possible, regardless of the PreferredMaintenanceWindow
	// setting for the DB instance.
	//
	// If this parameter is set to false, changes to the DB instance are applied
	// during the next maintenance window. Some parameter changes can cause an outage
	// and are applied on the next call to RebootDBInstance, or the next failure
	// reboot.
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// Indicates that minor version upgrades are applied automatically to the DB
	// instance during the maintenance window. Changing this parameter doesn't result
	// in an outage except in the following case and the change is asynchronously
	// applied as soon as possible. An outage will result if this parameter is set
	// to true during the maintenance window, and a newer minor version is available,
	// and Neptune has enabled auto patching for that engine version.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Not applicable. The retention period for automated backups is managed by
	// the DB cluster. For more information, see ModifyDBCluster.
	//
	// Default: Uses existing setting
	BackupRetentionPeriod *int64 `type:"integer"`

	// Indicates the certificate that needs to be associated with the instance.
	CACertificateIdentifier *string `type:"string"`

	// The configuration setting for the log types to be enabled for export to CloudWatch
	// Logs for a specific DB instance or DB cluster.
	CloudwatchLogsExportConfiguration *CloudwatchLogsExportConfiguration `type:"structure"`

	// True to copy all tags from the DB instance to snapshots of the DB instance,
	// and otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The new compute and memory capacity of the DB instance, for example, db.m4.large.
	// Not all DB instance classes are available in all AWS Regions.
	//
	// If you modify the DB instance class, an outage occurs during the change.
	// The change is applied during the next maintenance window, unless ApplyImmediately
	// is specified as true for this request.
	//
	// Default: Uses existing setting
	DBInstanceClass *string `type:"string"`

	// The DB instance identifier. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBInstance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The name of the DB parameter group to apply to the DB instance. Changing
	// this setting doesn't result in an outage. The parameter group name itself
	// is changed immediately, but the actual parameter changes are not applied
	// until you reboot the instance without failover. The db instance will NOT
	// be rebooted automatically and the parameter changes will NOT be applied during
	// the next maintenance window.
	//
	// Default: Uses existing setting
	//
	// Constraints: The DB parameter group must be in the same DB parameter group
	// family as this DB instance.
	DBParameterGroupName *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	// The value of the DBPortNumber parameter must not match any of the port values
	// specified for options in the option group for the DB instance.
	//
	// Your database will restart when you change the DBPortNumber value regardless
	// of the value of the ApplyImmediately parameter.
	//
	// Default: 8182
	DBPortNumber *int64 `type:"integer"`

	// A list of DB security groups to authorize on this DB instance. Changing this
	// setting doesn't result in an outage and the change is asynchronously applied
	// as soon as possible.
	//
	// Constraints:
	//
	//    * If supplied, must match existing DBSecurityGroups.
	DBSecurityGroups []*string `locationNameList:"DBSecurityGroupName" type:"list"`

	// The new DB subnet group for the DB instance. You can use this parameter to
	// move your DB instance to a different VPC.
	//
	// Changing the subnet group causes an outage during the change. The change
	// is applied during the next maintenance window, unless you specify true for
	// the ApplyImmediately parameter.
	//
	// Constraints: If supplied, must match the name of an existing DBSubnetGroup.
	//
	// Example: mySubnetGroup
	DBSubnetGroupName *string `type:"string"`

	// Not supported.
	Domain *string `type:"string"`

	// Not supported
	DomainIAMRoleName *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts, and otherwise false.
	//
	// You can enable IAM database authentication for the following database engines
	//
	// Not applicable. Mapping AWS IAM accounts to database accounts is managed
	// by the DB cluster. For more information, see ModifyDBCluster.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// Not supported.
	EnablePerformanceInsights *bool `type:"boolean"`

	// The version number of the database engine to upgrade to. Changing this parameter
	// results in an outage and the change is applied during the next maintenance
	// window unless the ApplyImmediately parameter is set to true for this request.
	//
	// For major version upgrades, if a nondefault DB parameter group is currently
	// in use, a new DB parameter group in the DB parameter group family for the
	// new engine version must be specified. The new DB parameter group can be the
	// default for that DB parameter group family.
	EngineVersion *string `type:"string"`

	// The new Provisioned IOPS (I/O operations per second) value for the instance.
	//
	// Changing this setting doesn't result in an outage and the change is applied
	// during the next maintenance window unless the ApplyImmediately parameter
	// is set to true for this request.
	//
	// Default: Uses existing setting
	Iops *int64 `type:"integer"`

	// Not supported.
	LicenseModel *string `type:"string"`

	// Not applicable.
	MasterUserPassword *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 0.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits Neptune to send enhanced monitoring
	// metrics to Amazon CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter
	// doesn't result in an outage and the change is applied during the next maintenance
	// window unless the ApplyImmediately parameter is set to true for this request.
	MultiAZ *bool `type:"boolean"`

	// The new DB instance identifier for the DB instance when renaming a DB instance.
	// When you change the DB instance identifier, an instance reboot will occur
	// immediately if you set Apply Immediately to true, or will occur during the
	// next maintenance window if Apply Immediately to false. This value is stored
	// as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: mydbinstance
	NewDBInstanceIdentifier *string `type:"string"`

	// Indicates that the DB instance should be associated with the specified option
	// group. Changing this parameter doesn't result in an outage except in the
	// following case and the change is applied during the next maintenance window
	// unless the ApplyImmediately parameter is set to true for this request. If
	// the parameter change results in an option group that enables OEM, this change
	// can cause a brief (sub-second) period during which new connections are rejected
	// but existing connections are not interrupted.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// can't be removed from an option group, and that option group can't be removed
	// from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// Not supported.
	PerformanceInsightsKMSKeyId *string `type:"string"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled.
	//
	// Not applicable. The daily time range for creating automated backups is managed
	// by the DB cluster. For more information, see ModifyDBCluster.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi
	//
	//    * Must be in Universal Time Coordinated (UTC)
	//
	//    * Must not conflict with the preferred maintenance window
	//
	//    * Must be at least 30 minutes
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// which might result in an outage. Changing this parameter doesn't result in
	// an outage, except in the following situation, and the change is asynchronously
	// applied as soon as possible. If there are pending actions that cause a reboot,
	// and the maintenance window is changed to include the current time, then changing
	// this parameter will cause a reboot of the DB instance. If moving this window
	// to the current time, there must be at least 30 minutes between the current
	// time and end of the window to ensure pending changes are applied.
	//
	// Default: Uses existing setting
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which a Read Replica is promoted to the
	// primary instance after a failure of the existing primary instance.
	//
	// Default: 1
	//
	// Valid Values: 0 - 15
	PromotionTier *int64 `type:"integer"`

	// This flag should no longer be used.
	//
	// Deprecated: PubliclyAccessible has been deprecated
	PubliclyAccessible *bool `deprecated:"true" type:"boolean"`

	// Not supported.
	StorageType *string `type:"string"`

	// The ARN from the key store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the key store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`

	// A list of EC2 VPC security groups to authorize on this DB instance. This
	// change is asynchronously applied as soon as possible.
	//
	// Not applicable. The associated list of EC2 VPC security groups is managed
	// by the DB cluster. For more information, see ModifyDBCluster.
	//
	// Constraints:
	//
	//    * If supplied, must match existing VpcSecurityGroupIds.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *ModifyDBInstanceInput) SetAllocatedStorage(v int64) *ModifyDBInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAllowMajorVersionUpgrade sets the AllowMajorVersionUpgrade field's value.
func (s *ModifyDBInstanceInput) SetAllowMajorVersionUpgrade(v bool) *ModifyDBInstanceInput {
	s.AllowMajorVersionUpgrade = &v
	return s
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyDBInstanceInput) SetApplyImmediately(v bool) *ModifyDBInstanceInput {
	s.ApplyImmediately = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *ModifyDBInstanceInput) SetAutoMinorVersionUpgrade(v bool) *ModifyDBInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *ModifyDBInstanceInput) SetBackupRetentionPeriod(v int64) *ModifyDBInstanceInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *ModifyDBInstanceInput) SetCACertificateIdentifier(v string) *ModifyDBInstanceInput {
	s.CACertificateIdentifier = &v
	return s
}

// SetCloudwatchLogsExportConfiguration sets the CloudwatchLogsExportConfiguration field's value.
func (s *ModifyDBInstanceInput) SetCloudwatchLogsExportConfiguration(v *CloudwatchLogsExportConfiguration) *ModifyDBInstanceInput {
	s.CloudwatchLogsExportConfiguration = v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *ModifyDBInstanceInput) SetCopyTagsToSnapshot(v bool) *ModifyDBInstanceInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *ModifyDBInstanceInput) SetDBInstanceClass(v string) *ModifyDBInstanceInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *ModifyDBInstanceInput) SetDBInstanceIdentifier(v string) *ModifyDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *ModifyDBInstanceInput) SetDBParameterGroupName(v string) *ModifyDBInstanceInput {
	s.DBParameterGroupName = &v
	return s
}

// SetDBPortNumber sets the DBPortNumber field's value.
func (s *ModifyDBInstanceInput) SetDBPortNumber(v int64) *ModifyDBInstanceInput {
	s.DBPortNumber = &v
	return s
}

// SetDBSecurityGroups sets the DBSecurityGroups field's value.
func (s *ModifyDBInstanceInput) SetDBSecurityGroups(v []*string) *ModifyDBInstanceInput {
	s.DBSecurityGroups = v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *ModifyDBInstanceInput) SetDBSubnetGroupName(v string) *ModifyDBInstanceInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *ModifyDBInstanceInput) SetDomain(v string) *ModifyDBInstanceInput {
	s.Domain = &v
	return s
}

// SetDomainIAMRoleName sets the DomainIAMRoleName field's value.
func (s *ModifyDBInstanceInput) SetDomainIAMRoleName(v string) *ModifyDBInstanceInput {
	s.DomainIAMRoleName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *ModifyDBInstanceInput) SetEnableIAMDatabaseAuthentication(v bool) *ModifyDBInstanceInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEnablePerformanceInsights sets the EnablePerformanceInsights field's value.
func (s *ModifyDBInstanceInput) SetEnablePerformanceInsights(v bool) *ModifyDBInstanceInput {
	s.EnablePerformanceInsights = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyDBInstanceInput) SetEngineVersion(v string) *ModifyDBInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *ModifyDBInstanceInput) SetIops(v int64) *ModifyDBInstanceInput {
	s.Iops = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *ModifyDBInstanceInput) SetLicenseModel(v string) *ModifyDBInstanceInput {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *ModifyDBInstanceInput) SetMasterUserPassword(v string) *ModifyDBInstanceInput {
	s.MasterUserPassword = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *ModifyDBInstanceInput) SetMonitoringInterval(v int64) *ModifyDBInstanceInput {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *ModifyDBInstanceInput) SetMonitoringRoleArn(v string) *ModifyDBInstanceInput {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ModifyDBInstanceInput) SetMultiAZ(v bool) *ModifyDBInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetNewDBInstanceIdentifier sets the NewDBInstanceIdentifier field's value.
func (s *ModifyDBInstanceInput) SetNewDBInstanceIdentifier(v string) *ModifyDBInstanceInput {
	s.NewDBInstanceIdentifier = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *ModifyDBInstanceInput) SetOptionGroupName(v string) *ModifyDBInstanceInput {
	s.OptionGroupName = &v
	return s
}

// SetPerformanceInsightsKMSKeyId sets the PerformanceInsightsKMSKeyId field's value.
func (s *ModifyDBInstanceInput) SetPerformanceInsightsKMSKeyId(v string) *ModifyDBInstanceInput {
	s.PerformanceInsightsKMSKeyId = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *ModifyDBInstanceInput) SetPreferredBackupWindow(v string) *ModifyDBInstanceInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyDBInstanceInput) SetPreferredMaintenanceWindow(v string) *ModifyDBInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *ModifyDBInstanceInput) SetPromotionTier(v int64) *ModifyDBInstanceInput {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *ModifyDBInstanceInput) SetPubliclyAccessible(v bool) *ModifyDBInstanceInput {
	s.PubliclyAccessible = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *ModifyDBInstanceInput) SetStorageType(v string) *ModifyDBInstanceInput {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *ModifyDBInstanceInput) SetTdeCredentialArn(v string) *ModifyDBInstanceInput {
	s.TdeCredentialArn = &v
	return s
}

// SetTdeCredentialPassword sets the TdeCredentialPassword field's value.
func (s *ModifyDBInstanceInput) SetTdeCredentialPassword(v string) *ModifyDBInstanceInput {
	s.TdeCredentialPassword = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ModifyDBInstanceInput) SetVpcSecurityGroupIds(v []*string) *ModifyDBInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

type ModifyDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB instance.
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s ModifyDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *ModifyDBInstanceOutput) SetDBInstance(v *DBInstance) *ModifyDBInstanceOutput {
	s.DBInstance = v
	return s
}

type ModifyDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBParameterGroup.
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names, values, and the apply method for the parameter
	// update. At least one parameter name, value, and apply method must be supplied;
	// subsequent arguments are optional. A maximum of 20 parameters can be modified
	// in a single request.
	//
	// Valid Values (for the application method): immediate | pending-reboot
	//
	// You can use the immediate value with dynamic parameters only. You can use
	// the pending-reboot value for both dynamic and static parameters, and changes
	// are applied when you reboot the DB instance without failover.
	//
	// Parameters is a required field
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBParameterGroupInput"}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *ModifyDBParameterGroupInput) SetDBParameterGroupName(v string) *ModifyDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ModifyDBParameterGroupInput) SetParameters(v []*Parameter) *ModifyDBParameterGroupInput {
	s.Parameters = v
	return s
}

type ModifyDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name for the DB subnet group. This value is stored as a lowercase string.
	// You can't modify the default subnet group.
	//
	// Constraints: Must match the name of an existing DBSubnetGroup. Must not be
	// default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the DB subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBSubnetGroupInput"}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *ModifyDBSubnetGroupInput) SetDBSubnetGroupDescription(v string) *ModifyDBSubnetGroupInput {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *ModifyDBSubnetGroupInput) SetDBSubnetGroupName(v string) *ModifyDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ModifyDBSubnetGroupInput) SetSubnetIds(v []*string) *ModifyDBSubnetGroupInput {
	s.SubnetIds = v
	return s
}

type ModifyDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB subnet group.
	//
	// This data type is used as a response element in the DescribeDBSubnetGroups
	// action.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *ModifyDBSubnetGroupOutput) SetDBSubnetGroup(v *DBSubnetGroup) *ModifyDBSubnetGroupOutput {
	s.DBSubnetGroup = v
	return s
}

type ModifyEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a SourceType that you want to subscribe to.
	// You can see a list of the categories for a given SourceType by using the
	// DescribeEventCategories action.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) of the SNS topic created for event notification.
	// The ARN is created by Amazon SNS when you create a topic and subscribe to
	// it.
	SnsTopicArn *string `type:"string"`

	// The type of source that is generating the events. For example, if you want
	// to be notified of events generated by a DB instance, you would set this parameter
	// to db-instance. if this value is not specified, all events are returned.
	//
	// Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
	SourceType *string `type:"string"`

	// The name of the event notification subscription.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ModifyEventSubscriptionInput) SetEnabled(v bool) *ModifyEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *ModifyEventSubscriptionInput) SetEventCategories(v []*string) *ModifyEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *ModifyEventSubscriptionInput) SetSnsTopicArn(v string) *ModifyEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ModifyEventSubscriptionInput) SetSourceType(v string) *ModifyEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *ModifyEventSubscriptionInput) SetSubscriptionName(v string) *ModifyEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type ModifyEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s ModifyEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *ModifyEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *ModifyEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// Provides information on the option groups the DB instance is a member of.
type OptionGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the option group that the instance belongs to.
	OptionGroupName *string `type:"string"`

	// The status of the DB instance's option group membership. Valid values are:
	// in-sync, pending-apply, pending-removal, pending-maintenance-apply, pending-maintenance-removal,
	// applying, removing, and failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s OptionGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionGroupMembership) GoString() string {
	return s.String()
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *OptionGroupMembership) SetOptionGroupName(v string) *OptionGroupMembership {
	s.OptionGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OptionGroupMembership) SetStatus(v string) *OptionGroupMembership {
	s.Status = &v
	return s
}

// Contains a list of available options for a DB instance.
//
// This data type is used as a response element in the DescribeOrderableDBInstanceOptions
// action.
type OrderableDBInstanceOption struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones for a DB instance.
	AvailabilityZones []*AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The DB instance class for a DB instance.
	DBInstanceClass *string `type:"string"`

	// The engine type of a DB instance.
	Engine *string `type:"string"`

	// The engine version of a DB instance.
	EngineVersion *string `type:"string"`

	// The license model for a DB instance.
	LicenseModel *string `type:"string"`

	// Maximum total provisioned IOPS for a DB instance.
	MaxIopsPerDbInstance *int64 `type:"integer"`

	// Maximum provisioned IOPS per GiB for a DB instance.
	MaxIopsPerGib *float64 `type:"double"`

	// Maximum storage size for a DB instance.
	MaxStorageSize *int64 `type:"integer"`

	// Minimum total provisioned IOPS for a DB instance.
	MinIopsPerDbInstance *int64 `type:"integer"`

	// Minimum provisioned IOPS per GiB for a DB instance.
	MinIopsPerGib *float64 `type:"double"`

	// Minimum storage size for a DB instance.
	MinStorageSize *int64 `type:"integer"`

	// Indicates whether a DB instance is Multi-AZ capable.
	MultiAZCapable *bool `type:"boolean"`

	// Indicates whether a DB instance can have a Read Replica.
	ReadReplicaCapable *bool `type:"boolean"`

	// Indicates the storage type for a DB instance.
	StorageType *string `type:"string"`

	// Indicates whether a DB instance supports Enhanced Monitoring at intervals
	// from 1 to 60 seconds.
	SupportsEnhancedMonitoring *bool `type:"boolean"`

	// Indicates whether a DB instance supports IAM database authentication.
	SupportsIAMDatabaseAuthentication *bool `type:"boolean"`

	// Indicates whether a DB instance supports provisioned IOPS.
	SupportsIops *bool `type:"boolean"`

	// True if a DB instance supports Performance Insights, otherwise false.
	SupportsPerformanceInsights *bool `type:"boolean"`

	// Indicates whether a DB instance supports encrypted storage.
	SupportsStorageEncryption *bool `type:"boolean"`

	// Indicates whether a DB instance is in a VPC.
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s OrderableDBInstanceOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableDBInstanceOption) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *OrderableDBInstanceOption) SetAvailabilityZones(v []*AvailabilityZone) *OrderableDBInstanceOption {
	s.AvailabilityZones = v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *OrderableDBInstanceOption) SetDBInstanceClass(v string) *OrderableDBInstanceOption {
	s.DBInstanceClass = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *OrderableDBInstanceOption) SetEngine(v string) *OrderableDBInstanceOption {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *OrderableDBInstanceOption) SetEngineVersion(v string) *OrderableDBInstanceOption {
	s.EngineVersion = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *OrderableDBInstanceOption) SetLicenseModel(v string) *OrderableDBInstanceOption {
	s.LicenseModel = &v
	return s
}

// SetMaxIopsPerDbInstance sets the MaxIopsPerDbInstance field's value.
func (s *OrderableDBInstanceOption) SetMaxIopsPerDbInstance(v int64) *OrderableDBInstanceOption {
	s.MaxIopsPerDbInstance = &v
	return s
}

// SetMaxIopsPerGib sets the MaxIopsPerGib field's value.
func (s *OrderableDBInstanceOption) SetMaxIopsPerGib(v float64) *OrderableDBInstanceOption {
	s.MaxIopsPerGib = &v
	return s
}

// SetMaxStorageSize sets the MaxStorageSize field's value.
func (s *OrderableDBInstanceOption) SetMaxStorageSize(v int64) *OrderableDBInstanceOption {
	s.MaxStorageSize = &v
	return s
}

// SetMinIopsPerDbInstance sets the MinIopsPerDbInstance field's value.
func (s *OrderableDBInstanceOption) SetMinIopsPerDbInstance(v int64) *OrderableDBInstanceOption {
	s.MinIopsPerDbInstance = &v
	return s
}

// SetMinIopsPerGib sets the MinIopsPerGib field's value.
func (s *OrderableDBInstanceOption) SetMinIopsPerGib(v float64) *OrderableDBInstanceOption {
	s.MinIopsPerGib = &v
	return s
}

// SetMinStorageSize sets the MinStorageSize field's value.
func (s *OrderableDBInstanceOption) SetMinStorageSize(v int64) *OrderableDBInstanceOption {
	s.MinStorageSize = &v
	return s
}

// SetMultiAZCapable sets the MultiAZCapable field's value.
func (s *OrderableDBInstanceOption) SetMultiAZCapable(v bool) *OrderableDBInstanceOption {
	s.MultiAZCapable = &v
	return s
}

// SetReadReplicaCapable sets the ReadReplicaCapable field's value.
func (s *OrderableDBInstanceOption) SetReadReplicaCapable(v bool) *OrderableDBInstanceOption {
	s.ReadReplicaCapable = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *OrderableDBInstanceOption) SetStorageType(v string) *OrderableDBInstanceOption {
	s.StorageType = &v
	return s
}

// SetSupportsEnhancedMonitoring sets the SupportsEnhancedMonitoring field's value.
func (s *OrderableDBInstanceOption) SetSupportsEnhancedMonitoring(v bool) *OrderableDBInstanceOption {
	s.SupportsEnhancedMonitoring = &v
	return s
}

// SetSupportsIAMDatabaseAuthentication sets the SupportsIAMDatabaseAuthentication field's value.
func (s *OrderableDBInstanceOption) SetSupportsIAMDatabaseAuthentication(v bool) *OrderableDBInstanceOption {
	s.SupportsIAMDatabaseAuthentication = &v
	return s
}

// SetSupportsIops sets the SupportsIops field's value.
func (s *OrderableDBInstanceOption) SetSupportsIops(v bool) *OrderableDBInstanceOption {
	s.SupportsIops = &v
	return s
}

// SetSupportsPerformanceInsights sets the SupportsPerformanceInsights field's value.
func (s *OrderableDBInstanceOption) SetSupportsPerformanceInsights(v bool) *OrderableDBInstanceOption {
	s.SupportsPerformanceInsights = &v
	return s
}

// SetSupportsStorageEncryption sets the SupportsStorageEncryption field's value.
func (s *OrderableDBInstanceOption) SetSupportsStorageEncryption(v bool) *OrderableDBInstanceOption {
	s.SupportsStorageEncryption = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *OrderableDBInstanceOption) SetVpc(v bool) *OrderableDBInstanceOption {
	s.Vpc = &v
	return s
}

// Specifies a parameter.
type Parameter struct {
	_ struct{} `type:"structure"`

	// Specifies the valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Indicates when to apply parameter updates.
	ApplyMethod *string `type:"string" enum:"ApplyMethod"`

	// Specifies the engine specific parameters type.
	ApplyType *string `type:"string"`

	// Specifies the valid data type for the parameter.
	DataType *string `type:"string"`

	// Provides a description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// Specifies the name of the parameter.
	ParameterName *string `type:"string"`

	// Specifies the value of the parameter.
	ParameterValue *string `type:"string"`

	// Indicates the source of the parameter value.
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Parameter) SetAllowedValues(v string) *Parameter {
	s.AllowedValues = &v
	return s
}

// SetApplyMethod sets the ApplyMethod field's value.
func (s *Parameter) SetApplyMethod(v string) *Parameter {
	s.ApplyMethod = &v
	return s
}

// SetApplyType sets the ApplyType field's value.
func (s *Parameter) SetApplyType(v string) *Parameter {
	s.ApplyType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Parameter) SetDataType(v string) *Parameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Parameter) SetDescription(v string) *Parameter {
	s.Description = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *Parameter) SetIsModifiable(v bool) *Parameter {
	s.IsModifiable = &v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *Parameter) SetMinimumEngineVersion(v string) *Parameter {
	s.MinimumEngineVersion = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *Parameter) SetParameterName(v string) *Parameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Parameter) SetSource(v string) *Parameter {
	s.Source = &v
	return s
}

// A list of the log types whose configuration is still pending. In other words,
// these log types are in the process of being activated or deactivated.
type PendingCloudwatchLogsExports struct {
	_ struct{} `type:"structure"`

	// Log types that are in the process of being enabled. After they are enabled,
	// these log types are exported to CloudWatch Logs.
	LogTypesToDisable []*string `type:"list"`

	// Log types that are in the process of being deactivated. After they are deactivated,
	// these log types aren't exported to CloudWatch Logs.
	LogTypesToEnable []*string `type:"list"`
}

// String returns the string representation
func (s PendingCloudwatchLogsExports) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingCloudwatchLogsExports) GoString() string {
	return s.String()
}

// SetLogTypesToDisable sets the LogTypesToDisable field's value.
func (s *PendingCloudwatchLogsExports) SetLogTypesToDisable(v []*string) *PendingCloudwatchLogsExports {
	s.LogTypesToDisable = v
	return s
}

// SetLogTypesToEnable sets the LogTypesToEnable field's value.
func (s *PendingCloudwatchLogsExports) SetLogTypesToEnable(v []*string) *PendingCloudwatchLogsExports {
	s.LogTypesToEnable = v
	return s
}

// Provides information about a pending maintenance action for a resource.
type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending maintenance action that is available for the resource.
	Action *string `type:"string"`

	// The date of the maintenance window when the action is applied. The maintenance
	// action is applied to the resource during its first maintenance window after
	// this date. If this date is specified, any next-maintenance opt-in requests
	// are ignored.
	AutoAppliedAfterDate *time.Time `type:"timestamp"`

	// The effective date when the pending maintenance action is applied to the
	// resource. This date takes into account opt-in requests received from the
	// ApplyPendingMaintenanceAction API, the AutoAppliedAfterDate, and the ForcedApplyDate.
	// This value is blank if an opt-in request has not been received and nothing
	// has been specified as AutoAppliedAfterDate or ForcedApplyDate.
	CurrentApplyDate *time.Time `type:"timestamp"`

	// A description providing more detail about the maintenance action.
	Description *string `type:"string"`

	// The date when the maintenance action is automatically applied. The maintenance
	// action is applied to the resource on this date regardless of the maintenance
	// window for the resource. If this date is specified, any immediate opt-in
	// requests are ignored.
	ForcedApplyDate *time.Time `type:"timestamp"`

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string `type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingMaintenanceAction) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *PendingMaintenanceAction) SetAction(v string) *PendingMaintenanceAction {
	s.Action = &v
	return s
}

// SetAutoAppliedAfterDate sets the AutoAppliedAfterDate field's value.
func (s *PendingMaintenanceAction) SetAutoAppliedAfterDate(v time.Time) *PendingMaintenanceAction {
	s.AutoAppliedAfterDate = &v
	return s
}

// SetCurrentApplyDate sets the CurrentApplyDate field's value.
func (s *PendingMaintenanceAction) SetCurrentApplyDate(v time.Time) *PendingMaintenanceAction {
	s.CurrentApplyDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PendingMaintenanceAction) SetDescription(v string) *PendingMaintenanceAction {
	s.Description = &v
	return s
}

// SetForcedApplyDate sets the ForcedApplyDate field's value.
func (s *PendingMaintenanceAction) SetForcedApplyDate(v time.Time) *PendingMaintenanceAction {
	s.ForcedApplyDate = &v
	return s
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *PendingMaintenanceAction) SetOptInStatus(v string) *PendingMaintenanceAction {
	s.OptInStatus = &v
	return s
}

// This data type is used as a response element in the ModifyDBInstance action.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// Contains the new AllocatedStorage size for the DB instance that will be applied
	// or is currently being applied.
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the pending number of days for which automated backups are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Specifies the identifier of the CA certificate for the DB instance.
	CACertificateIdentifier *string `type:"string"`

	// Contains the new DBInstanceClass for the DB instance that will be applied
	// or is currently being applied.
	DBInstanceClass *string `type:"string"`

	// Contains the new DBInstanceIdentifier for the DB instance that will be applied
	// or is currently being applied.
	DBInstanceIdentifier *string `type:"string"`

	// The new DB subnet group for the DB instance.
	DBSubnetGroupName *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the new Provisioned IOPS value for the DB instance that will be
	// applied or is currently being applied.
	Iops *int64 `type:"integer"`

	// The license model for the DB instance.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// Contains the pending or currently-in-progress change of the master credentials
	// for the DB instance.
	MasterUserPassword *string `type:"string"`

	// Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Specifies the CloudWatch logs to be exported.
	PendingCloudwatchLogsExports *PendingCloudwatchLogsExports `type:"structure"`

	// Specifies the pending port for the DB instance.
	Port *int64 `type:"integer"`

	// Specifies the storage type to be associated with the DB instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedValues) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *PendingModifiedValues) SetAllocatedStorage(v int64) *PendingModifiedValues {
	s.AllocatedStorage = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *PendingModifiedValues) SetBackupRetentionPeriod(v int64) *PendingModifiedValues {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *PendingModifiedValues) SetCACertificateIdentifier(v string) *PendingModifiedValues {
	s.CACertificateIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *PendingModifiedValues) SetDBInstanceClass(v string) *PendingModifiedValues {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *PendingModifiedValues) SetDBInstanceIdentifier(v string) *PendingModifiedValues {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *PendingModifiedValues) SetDBSubnetGroupName(v string) *PendingModifiedValues {
	s.DBSubnetGroupName = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *PendingModifiedValues) SetEngineVersion(v string) *PendingModifiedValues {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *PendingModifiedValues) SetIops(v int64) *PendingModifiedValues {
	s.Iops = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *PendingModifiedValues) SetLicenseModel(v string) *PendingModifiedValues {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *PendingModifiedValues) SetMasterUserPassword(v string) *PendingModifiedValues {
	s.MasterUserPassword = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *PendingModifiedValues) SetMultiAZ(v bool) *PendingModifiedValues {
	s.MultiAZ = &v
	return s
}

// SetPendingCloudwatchLogsExports sets the PendingCloudwatchLogsExports field's value.
func (s *PendingModifiedValues) SetPendingCloudwatchLogsExports(v *PendingCloudwatchLogsExports) *PendingModifiedValues {
	s.PendingCloudwatchLogsExports = v
	return s
}

// SetPort sets the Port field's value.
func (s *PendingModifiedValues) SetPort(v int64) *PendingModifiedValues {
	s.Port = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *PendingModifiedValues) SetStorageType(v string) *PendingModifiedValues {
	s.StorageType = &v
	return s
}

type PromoteReadReplicaDBClusterInput struct {
	_ struct{} `type:"structure"`

	// Not supported.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PromoteReadReplicaDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteReadReplicaDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromoteReadReplicaDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromoteReadReplicaDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *PromoteReadReplicaDBClusterInput) SetDBClusterIdentifier(v string) *PromoteReadReplicaDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

type PromoteReadReplicaDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB cluster.
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s PromoteReadReplicaDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteReadReplicaDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *PromoteReadReplicaDBClusterOutput) SetDBCluster(v *DBCluster) *PromoteReadReplicaDBClusterOutput {
	s.DBCluster = v
	return s
}

// A range of integer values.
type Range struct {
	_ struct{} `type:"structure"`

	// The minimum value in the range.
	From *int64 `type:"integer"`

	// The step value for the range. For example, if you have a range of 5,000 to
	// 10,000, with a step value of 1,000, the valid values start at 5,000 and step
	// up by 1,000. Even though 7,500 is within the range, it isn't a valid value
	// for the range. The valid values are 5,000, 6,000, 7,000, 8,000...
	Step *int64 `type:"integer"`

	// The maximum value in the range.
	To *int64 `type:"integer"`
}

// String returns the string representation
func (s Range) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Range) GoString() string {
	return s.String()
}

// SetFrom sets the From field's value.
func (s *Range) SetFrom(v int64) *Range {
	s.From = &v
	return s
}

// SetStep sets the Step field's value.
func (s *Range) SetStep(v int64) *Range {
	s.Step = &v
	return s
}

// SetTo sets the To field's value.
func (s *Range) SetTo(v int64) *Range {
	s.To = &v
	return s
}

type RebootDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The DB instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBInstance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// When true, the reboot is conducted through a MultiAZ failover.
	//
	// Constraint: You can't specify true if the instance is not configured for
	// MultiAZ.
	ForceFailover *bool `type:"boolean"`
}

// String returns the string representation
func (s RebootDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *RebootDBInstanceInput) SetDBInstanceIdentifier(v string) *RebootDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetForceFailover sets the ForceFailover field's value.
func (s *RebootDBInstanceInput) SetForceFailover(v bool) *RebootDBInstanceInput {
	s.ForceFailover = &v
	return s
}

type RebootDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB instance.
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s RebootDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *RebootDBInstanceOutput) SetDBInstance(v *DBInstance) *RebootDBInstanceOutput {
	s.DBInstance = v
	return s
}

type RemoveRoleFromDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster to disassociate the IAM role from.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB
	// cluster, for example arn:aws:iam::123456789012:role/NeptuneAccessRole.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveRoleFromDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRoleFromDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveRoleFromDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveRoleFromDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *RemoveRoleFromDBClusterInput) SetDBClusterIdentifier(v string) *RemoveRoleFromDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *RemoveRoleFromDBClusterInput) SetRoleArn(v string) *RemoveRoleFromDBClusterInput {
	s.RoleArn = &v
	return s
}

type RemoveRoleFromDBClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveRoleFromDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRoleFromDBClusterOutput) GoString() string {
	return s.String()
}

type RemoveSourceIdentifierFromSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The source identifier to be removed from the subscription, such as the DB
	// instance identifier for a DB instance or the name of a security group.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `type:"string" required:"true"`

	// The name of the event notification subscription you want to remove a source
	// identifier from.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveSourceIdentifierFromSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveSourceIdentifierFromSubscriptionInput"}
	if s.SourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceIdentifier"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *RemoveSourceIdentifierFromSubscriptionInput) SetSourceIdentifier(v string) *RemoveSourceIdentifierFromSubscriptionInput {
	s.SourceIdentifier = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *RemoveSourceIdentifierFromSubscriptionInput) SetSubscriptionName(v string) *RemoveSourceIdentifierFromSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type RemoveSourceIdentifierFromSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *RemoveSourceIdentifierFromSubscriptionOutput) SetEventSubscription(v *EventSubscription) *RemoveSourceIdentifierFromSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Neptune resource that the tags are removed from. This value is
	// an Amazon Resource Name (ARN). For information about creating an ARN, see
	//  Constructing an Amazon Resource Name (ARN) (https://docs.aws.amazon.com/neptune/latest/UserGuide/tagging.ARN.html#tagging.ARN.Constructing).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tag key (name) of the tag to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *RemoveTagsFromResourceInput) SetResourceName(v string) *RemoveTagsFromResourceInput {
	s.ResourceName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeys(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeys = v
	return s
}

type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

type ResetDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group to reset.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// A list of parameter names in the DB cluster parameter group to reset to the
	// default values. You can't use this parameter if the ResetAllParameters parameter
	// is set to true.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// A value that is set to true to reset all parameters in the DB cluster parameter
	// group to their default values, and false otherwise. You can't use this parameter
	// if there is a list of parameter names specified for the Parameters parameter.
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ResetDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *ResetDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ResetDBClusterParameterGroupInput) SetParameters(v []*Parameter) *ResetDBClusterParameterGroupInput {
	s.Parameters = v
	return s
}

// SetResetAllParameters sets the ResetAllParameters field's value.
func (s *ResetDBClusterParameterGroupInput) SetResetAllParameters(v bool) *ResetDBClusterParameterGroupInput {
	s.ResetAllParameters = &v
	return s
}

type ResetDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 letters or numbers.
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// This value is stored as a lowercase string.
	DBClusterParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ResetDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ResetDBClusterParameterGroupOutput) SetDBClusterParameterGroupName(v string) *ResetDBClusterParameterGroupOutput {
	s.DBClusterParameterGroupName = &v
	return s
}

type ResetDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * Must match the name of an existing DBParameterGroup.
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`

	// To reset the entire DB parameter group, specify the DBParameterGroup name
	// and ResetAllParameters parameters. To reset specific parameters, provide
	// a list of the following: ParameterName and ApplyMethod. A maximum of 20 parameters
	// can be modified in a single request.
	//
	// Valid Values (for Apply method): pending-reboot
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// Specifies whether (true) or not (false) to reset all parameters in the DB
	// parameter group to default values.
	//
	// Default: true
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetDBParameterGroupInput"}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *ResetDBParameterGroupInput) SetDBParameterGroupName(v string) *ResetDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ResetDBParameterGroupInput) SetParameters(v []*Parameter) *ResetDBParameterGroupInput {
	s.Parameters = v
	return s
}

// SetResetAllParameters sets the ResetAllParameters field's value.
func (s *ResetDBParameterGroupInput) SetResetAllParameters(v bool) *ResetDBParameterGroupInput {
	s.ResetAllParameters = &v
	return s
}

type ResetDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ResetDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *ResetDBParameterGroupOutput) SetDBParameterGroupName(v string) *ResetDBParameterGroupOutput {
	s.DBParameterGroupName = &v
	return s
}

// Describes the pending maintenance actions for a resource.
type ResourcePendingMaintenanceActions struct {
	_ struct{} `type:"structure"`

	// A list that provides details about the pending maintenance actions for the
	// resource.
	PendingMaintenanceActionDetails []*PendingMaintenanceAction `locationNameList:"PendingMaintenanceAction" type:"list"`

	// The ARN of the resource that has pending maintenance actions.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ResourcePendingMaintenanceActions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePendingMaintenanceActions) GoString() string {
	return s.String()
}

// SetPendingMaintenanceActionDetails sets the PendingMaintenanceActionDetails field's value.
func (s *ResourcePendingMaintenanceActions) SetPendingMaintenanceActionDetails(v []*PendingMaintenanceAction) *ResourcePendingMaintenanceActions {
	s.PendingMaintenanceActionDetails = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ResourcePendingMaintenanceActions) SetResourceIdentifier(v string) *ResourcePendingMaintenanceActions {
	s.ResourceIdentifier = &v
	return s
}

type RestoreDBClusterFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Provides the list of EC2 Availability Zones that instances in the restored
	// DB cluster can be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The name of the DB cluster to create from the DB snapshot or DB cluster snapshot.
	// This parameter isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-snapshot-id
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to associate with the new DB cluster.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBClusterParameterGroup.
	DBClusterParameterGroupName *string `type:"string"`

	// The name of the DB subnet group to use for the new DB cluster.
	//
	// Constraints: If supplied, must match the name of an existing DBSubnetGroup.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// Not supported.
	DatabaseName *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts, and otherwise false.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The database engine to use for the new DB cluster.
	//
	// Default: The same as source
	//
	// Constraint: Must be compatible with the engine of the source
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version of the database engine to use for the new DB cluster.
	EngineVersion *string `type:"string"`

	// The AWS KMS key identifier to use when restoring an encrypted DB cluster
	// from a DB snapshot or DB cluster snapshot.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are restoring a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KMS encryption key.
	//
	// If you do not specify a value for the KmsKeyId parameter, then the following
	// will occur:
	//
	//    * If the DB snapshot or DB cluster snapshot in SnapshotIdentifier is encrypted,
	//    then the restored DB cluster is encrypted using the KMS key that was used
	//    to encrypt the DB snapshot or DB cluster snapshot.
	//
	//    * If the DB snapshot or DB cluster snapshot in SnapshotIdentifier is not
	//    encrypted, then the restored DB cluster is not encrypted.
	KmsKeyId *string `type:"string"`

	// The name of the option group to use for the restored DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the new DB cluster accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB cluster.
	Port *int64 `type:"integer"`

	// The identifier for the DB snapshot or DB cluster snapshot to restore from.
	//
	// You can use either the name or the Amazon Resource Name (ARN) to specify
	// a DB cluster snapshot. However, you can use only the ARN to specify a DB
	// snapshot.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing Snapshot.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the restored DB cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of VPC security groups that the new DB cluster will belong to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreDBClusterFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDBClusterFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDBClusterFromSnapshotInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetAvailabilityZones(v []*string) *RestoreDBClusterFromSnapshotInput {
	s.AvailabilityZones = v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDBClusterIdentifier(v string) *RestoreDBClusterFromSnapshotInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDBClusterParameterGroupName(v string) *RestoreDBClusterFromSnapshotInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDBSubnetGroupName(v string) *RestoreDBClusterFromSnapshotInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDatabaseName(v string) *RestoreDBClusterFromSnapshotInput {
	s.DatabaseName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetEnableIAMDatabaseAuthentication(v bool) *RestoreDBClusterFromSnapshotInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetEngine(v string) *RestoreDBClusterFromSnapshotInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetEngineVersion(v string) *RestoreDBClusterFromSnapshotInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetKmsKeyId(v string) *RestoreDBClusterFromSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetOptionGroupName(v string) *RestoreDBClusterFromSnapshotInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetPort(v int64) *RestoreDBClusterFromSnapshotInput {
	s.Port = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetSnapshotIdentifier(v string) *RestoreDBClusterFromSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetTags(v []*Tag) *RestoreDBClusterFromSnapshotInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetVpcSecurityGroupIds(v []*string) *RestoreDBClusterFromSnapshotInput {
	s.VpcSecurityGroupIds = v
	return s
}

type RestoreDBClusterFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB cluster.
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s RestoreDBClusterFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *RestoreDBClusterFromSnapshotOutput) SetDBCluster(v *DBCluster) *RestoreDBClusterFromSnapshotOutput {
	s.DBCluster = v
	return s
}

type RestoreDBClusterToPointInTimeInput struct {
	_ struct{} `type:"structure"`

	// The name of the new DB cluster to be created.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to associate with the new DB cluster.
	//
	// Constraints:
	//
	//    * If supplied, must match the name of an existing DBClusterParameterGroup.
	DBClusterParameterGroupName *string `type:"string"`

	// The DB subnet group name to use for the new DB cluster.
	//
	// Constraints: If supplied, must match the name of an existing DBSubnetGroup.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts, and otherwise false.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The AWS KMS key identifier to use when restoring an encrypted DB cluster
	// from an encrypted DB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are restoring a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KMS encryption key.
	//
	// You can restore to a new DB cluster and encrypt the new DB cluster with a
	// KMS key that is different than the KMS key used to encrypt the source DB
	// cluster. The new DB cluster is encrypted with the KMS key identified by the
	// KmsKeyId parameter.
	//
	// If you do not specify a value for the KmsKeyId parameter, then the following
	// will occur:
	//
	//    * If the DB cluster is encrypted, then the restored DB cluster is encrypted
	//    using the KMS key that was used to encrypt the source DB cluster.
	//
	//    * If the DB cluster is not encrypted, then the restored DB cluster is
	//    not encrypted.
	//
	// If DBClusterIdentifier refers to a DB cluster that is not encrypted, then
	// the restore request is rejected.
	KmsKeyId *string `type:"string"`

	// The name of the option group for the new DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the new DB cluster accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB cluster.
	Port *int64 `type:"integer"`

	// The date and time to restore the DB cluster to.
	//
	// Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
	//
	// Constraints:
	//
	//    * Must be before the latest restorable time for the DB instance
	//
	//    * Must be specified if UseLatestRestorableTime parameter is not provided
	//
	//    * Cannot be specified if UseLatestRestorableTime parameter is true
	//
	//    * Cannot be specified if RestoreType parameter is copy-on-write
	//
	// Example: 2015-03-07T23:45:00Z
	RestoreToTime *time.Time `type:"timestamp"`

	// The type of restore to be performed. The only type of restore currently supported
	// is full-copy (the default).
	RestoreType *string `type:"string"`

	// The identifier of the source DB cluster from which to restore.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBCluster.
	//
	// SourceDBClusterIdentifier is a required field
	SourceDBClusterIdentifier *string `type:"string" required:"true"`

	// The tags to be applied to the restored DB cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A value that is set to true to restore the DB cluster to the latest restorable
	// backup time, and false otherwise.
	//
	// Default: false
	//
	// Constraints: Cannot be specified if RestoreToTime parameter is provided.
	UseLatestRestorableTime *bool `type:"boolean"`

	// A list of VPC security groups that the new DB cluster belongs to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreDBClusterToPointInTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterToPointInTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDBClusterToPointInTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDBClusterToPointInTimeInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.SourceDBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetDBClusterIdentifier(v string) *RestoreDBClusterToPointInTimeInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetDBClusterParameterGroupName(v string) *RestoreDBClusterToPointInTimeInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetDBSubnetGroupName(v string) *RestoreDBClusterToPointInTimeInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetEnableIAMDatabaseAuthentication(v bool) *RestoreDBClusterToPointInTimeInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetKmsKeyId(v string) *RestoreDBClusterToPointInTimeInput {
	s.KmsKeyId = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetOptionGroupName(v string) *RestoreDBClusterToPointInTimeInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetPort(v int64) *RestoreDBClusterToPointInTimeInput {
	s.Port = &v
	return s
}

// SetRestoreToTime sets the RestoreToTime field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetRestoreToTime(v time.Time) *RestoreDBClusterToPointInTimeInput {
	s.RestoreToTime = &v
	return s
}

// SetRestoreType sets the RestoreType field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetRestoreType(v string) *RestoreDBClusterToPointInTimeInput {
	s.RestoreType = &v
	return s
}

// SetSourceDBClusterIdentifier sets the SourceDBClusterIdentifier field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetSourceDBClusterIdentifier(v string) *RestoreDBClusterToPointInTimeInput {
	s.SourceDBClusterIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetTags(v []*Tag) *RestoreDBClusterToPointInTimeInput {
	s.Tags = v
	return s
}

// SetUseLatestRestorableTime sets the UseLatestRestorableTime field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetUseLatestRestorableTime(v bool) *RestoreDBClusterToPointInTimeInput {
	s.UseLatestRestorableTime = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetVpcSecurityGroupIds(v []*string) *RestoreDBClusterToPointInTimeInput {
	s.VpcSecurityGroupIds = v
	return s
}

type RestoreDBClusterToPointInTimeOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon Neptune DB cluster.
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s RestoreDBClusterToPointInTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterToPointInTimeOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *RestoreDBClusterToPointInTimeOutput) SetDBCluster(v *DBCluster) *RestoreDBClusterToPointInTimeOutput {
	s.DBCluster = v
	return s
}

// Specifies a subnet.
//
// This data type is used as a response element in the DescribeDBSubnetGroups
// action.
type Subnet struct {
	_ struct{} `type:"structure"`

	// Specifies the EC2 Availability Zone that the subnet is in.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// Specifies the identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// Specifies the status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *Subnet) SetSubnetAvailabilityZone(v *AvailabilityZone) *Subnet {
	s.SubnetAvailabilityZone = v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *Subnet) SetSubnetIdentifier(v string) *Subnet {
	s.SubnetIdentifier = &v
	return s
}

// SetSubnetStatus sets the SubnetStatus field's value.
func (s *Subnet) SetSubnetStatus(v string) *Subnet {
	s.SubnetStatus = &v
	return s
}

// Metadata assigned to an Amazon Neptune resource consisting of a key-value
// pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// A key is the required name of the tag. The string value can be from 1 to
	// 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:".
	// The string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// A value is the optional value of the tag. The string value can be from 1
	// to 256 Unicode characters in length and can't be prefixed with "aws:" or
	// "rds:". The string can only contain only the set of Unicode letters, digits,
	// white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// A time zone associated with a DBInstance.
type Timezone struct {
	_ struct{} `type:"structure"`

	// The name of the time zone.
	TimezoneName *string `type:"string"`
}

// String returns the string representation
func (s Timezone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Timezone) GoString() string {
	return s.String()
}

// SetTimezoneName sets the TimezoneName field's value.
func (s *Timezone) SetTimezoneName(v string) *Timezone {
	s.TimezoneName = &v
	return s
}

// The version of the database engine that a DB instance can be upgraded to.
type UpgradeTarget struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether the target version is applied to any source
	// DB instances that have AutoMinorVersionUpgrade set to true.
	AutoUpgrade *bool `type:"boolean"`

	// The version of the database engine that a DB instance can be upgraded to.
	Description *string `type:"string"`

	// The name of the upgrade target database engine.
	Engine *string `type:"string"`

	// The version number of the upgrade target database engine.
	EngineVersion *string `type:"string"`

	// A value that indicates whether a database engine is upgraded to a major version.
	IsMajorVersionUpgrade *bool `type:"boolean"`
}

// String returns the string representation
func (s UpgradeTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeTarget) GoString() string {
	return s.String()
}

// SetAutoUpgrade sets the AutoUpgrade field's value.
func (s *UpgradeTarget) SetAutoUpgrade(v bool) *UpgradeTarget {
	s.AutoUpgrade = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpgradeTarget) SetDescription(v string) *UpgradeTarget {
	s.Description = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *UpgradeTarget) SetEngine(v string) *UpgradeTarget {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *UpgradeTarget) SetEngineVersion(v string) *UpgradeTarget {
	s.EngineVersion = &v
	return s
}

// SetIsMajorVersionUpgrade sets the IsMajorVersionUpgrade field's value.
func (s *UpgradeTarget) SetIsMajorVersionUpgrade(v bool) *UpgradeTarget {
	s.IsMajorVersionUpgrade = &v
	return s
}

// Information about valid modifications that you can make to your DB instance.
// Contains the result of a successful call to the DescribeValidDBInstanceModifications
// action. You can use this information when you call ModifyDBInstance.
type ValidDBInstanceModificationsMessage struct {
	_ struct{} `type:"structure"`

	// Valid storage options for your DB instance.
	Storage []*ValidStorageOptions `locationNameList:"ValidStorageOptions" type:"list"`
}

// String returns the string representation
func (s ValidDBInstanceModificationsMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidDBInstanceModificationsMessage) GoString() string {
	return s.String()
}

// SetStorage sets the Storage field's value.
func (s *ValidDBInstanceModificationsMessage) SetStorage(v []*ValidStorageOptions) *ValidDBInstanceModificationsMessage {
	s.Storage = v
	return s
}

// Information about valid modifications that you can make to your DB instance.
//
// Contains the result of a successful call to the DescribeValidDBInstanceModifications
// action.
type ValidStorageOptions struct {
	_ struct{} `type:"structure"`

	// The valid range of Provisioned IOPS to gibibytes of storage multiplier. For
	// example, 3-10, which means that provisioned IOPS can be between 3 and 10
	// times storage.
	IopsToStorageRatio []*DoubleRange `locationNameList:"DoubleRange" type:"list"`

	// The valid range of provisioned IOPS. For example, 1000-20000.
	ProvisionedIops []*Range `locationNameList:"Range" type:"list"`

	// The valid range of storage in gibibytes. For example, 100 to 16384.
	StorageSize []*Range `locationNameList:"Range" type:"list"`

	// The valid storage types for your DB instance. For example, gp2, io1.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s ValidStorageOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidStorageOptions) GoString() string {
	return s.String()
}

// SetIopsToStorageRatio sets the IopsToStorageRatio field's value.
func (s *ValidStorageOptions) SetIopsToStorageRatio(v []*DoubleRange) *ValidStorageOptions {
	s.IopsToStorageRatio = v
	return s
}

// SetProvisionedIops sets the ProvisionedIops field's value.
func (s *ValidStorageOptions) SetProvisionedIops(v []*Range) *ValidStorageOptions {
	s.ProvisionedIops = v
	return s
}

// SetStorageSize sets the StorageSize field's value.
func (s *ValidStorageOptions) SetStorageSize(v []*Range) *ValidStorageOptions {
	s.StorageSize = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *ValidStorageOptions) SetStorageType(v string) *ValidStorageOptions {
	s.StorageType = &v
	return s
}

// This data type is used as a response element for queries on VPC security
// group membership.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VpcSecurityGroupMembership) SetStatus(v string) *VpcSecurityGroupMembership {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *VpcSecurityGroupMembership) SetVpcSecurityGroupId(v string) *VpcSecurityGroupMembership {
	s.VpcSecurityGroupId = &v
	return s
}

const (
	// ApplyMethodImmediate is a ApplyMethod enum value
	ApplyMethodImmediate = "immediate"

	// ApplyMethodPendingReboot is a ApplyMethod enum value
	ApplyMethodPendingReboot = "pending-reboot"
)

const (
	// SourceTypeDbInstance is a SourceType enum value
	SourceTypeDbInstance = "db-instance"

	// SourceTypeDbParameterGroup is a SourceType enum value
	SourceTypeDbParameterGroup = "db-parameter-group"

	// SourceTypeDbSecurityGroup is a SourceType enum value
	SourceTypeDbSecurityGroup = "db-security-group"

	// SourceTypeDbSnapshot is a SourceType enum value
	SourceTypeDbSnapshot = "db-snapshot"

	// SourceTypeDbCluster is a SourceType enum value
	SourceTypeDbCluster = "db-cluster"

	// SourceTypeDbClusterSnapshot is a SourceType enum value
	SourceTypeDbClusterSnapshot = "db-cluster-snapshot"
)
