package datafactory

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/datafactory/mgmt/2018-06-01/datafactory"

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AuthenticationTypeAnonymous ...
	AuthenticationTypeAnonymous AuthenticationType = "Anonymous"
	// AuthenticationTypeBasic ...
	AuthenticationTypeBasic AuthenticationType = "Basic"
	// AuthenticationTypeClientCertificate ...
	AuthenticationTypeClientCertificate AuthenticationType = "ClientCertificate"
	// AuthenticationTypeWebLinkedServiceTypeProperties ...
	AuthenticationTypeWebLinkedServiceTypeProperties AuthenticationType = "WebLinkedServiceTypeProperties"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{AuthenticationTypeAnonymous, AuthenticationTypeBasic, AuthenticationTypeClientCertificate, AuthenticationTypeWebLinkedServiceTypeProperties}
}

// AuthorizationType enumerates the values for authorization type.
type AuthorizationType string

const (
	// AuthorizationTypeKey ...
	AuthorizationTypeKey AuthorizationType = "Key"
	// AuthorizationTypeLinkedIntegrationRuntimeType ...
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = "LinkedIntegrationRuntimeType"
	// AuthorizationTypeRBAC ...
	AuthorizationTypeRBAC AuthorizationType = "RBAC"
)

// PossibleAuthorizationTypeValues returns an array of possible values for the AuthorizationType const type.
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return []AuthorizationType{AuthorizationTypeKey, AuthorizationTypeLinkedIntegrationRuntimeType, AuthorizationTypeRBAC}
}

// AvroCompressionCodec enumerates the values for avro compression codec.
type AvroCompressionCodec string

const (
	// Bzip2 ...
	Bzip2 AvroCompressionCodec = "bzip2"
	// Deflate ...
	Deflate AvroCompressionCodec = "deflate"
	// None ...
	None AvroCompressionCodec = "none"
	// Snappy ...
	Snappy AvroCompressionCodec = "snappy"
	// Xz ...
	Xz AvroCompressionCodec = "xz"
)

// PossibleAvroCompressionCodecValues returns an array of possible values for the AvroCompressionCodec const type.
func PossibleAvroCompressionCodecValues() []AvroCompressionCodec {
	return []AvroCompressionCodec{Bzip2, Deflate, None, Snappy, Xz}
}

// AzureFunctionActivityMethod enumerates the values for azure function activity method.
type AzureFunctionActivityMethod string

const (
	// DELETE ...
	DELETE AzureFunctionActivityMethod = "DELETE"
	// GET ...
	GET AzureFunctionActivityMethod = "GET"
	// HEAD ...
	HEAD AzureFunctionActivityMethod = "HEAD"
	// OPTIONS ...
	OPTIONS AzureFunctionActivityMethod = "OPTIONS"
	// POST ...
	POST AzureFunctionActivityMethod = "POST"
	// PUT ...
	PUT AzureFunctionActivityMethod = "PUT"
	// TRACE ...
	TRACE AzureFunctionActivityMethod = "TRACE"
)

// PossibleAzureFunctionActivityMethodValues returns an array of possible values for the AzureFunctionActivityMethod const type.
func PossibleAzureFunctionActivityMethodValues() []AzureFunctionActivityMethod {
	return []AzureFunctionActivityMethod{DELETE, GET, HEAD, OPTIONS, POST, PUT, TRACE}
}

// AzureSearchIndexWriteBehaviorType enumerates the values for azure search index write behavior type.
type AzureSearchIndexWriteBehaviorType string

const (
	// Merge ...
	Merge AzureSearchIndexWriteBehaviorType = "Merge"
	// Upload ...
	Upload AzureSearchIndexWriteBehaviorType = "Upload"
)

// PossibleAzureSearchIndexWriteBehaviorTypeValues returns an array of possible values for the AzureSearchIndexWriteBehaviorType const type.
func PossibleAzureSearchIndexWriteBehaviorTypeValues() []AzureSearchIndexWriteBehaviorType {
	return []AzureSearchIndexWriteBehaviorType{Merge, Upload}
}

// BlobEventTypes enumerates the values for blob event types.
type BlobEventTypes string

const (
	// MicrosoftStorageBlobCreated ...
	MicrosoftStorageBlobCreated BlobEventTypes = "Microsoft.Storage.BlobCreated"
	// MicrosoftStorageBlobDeleted ...
	MicrosoftStorageBlobDeleted BlobEventTypes = "Microsoft.Storage.BlobDeleted"
)

// PossibleBlobEventTypesValues returns an array of possible values for the BlobEventTypes const type.
func PossibleBlobEventTypesValues() []BlobEventTypes {
	return []BlobEventTypes{MicrosoftStorageBlobCreated, MicrosoftStorageBlobDeleted}
}

// CassandraSourceReadConsistencyLevels enumerates the values for cassandra source read consistency levels.
type CassandraSourceReadConsistencyLevels string

const (
	// ALL ...
	ALL CassandraSourceReadConsistencyLevels = "ALL"
	// EACHQUORUM ...
	EACHQUORUM CassandraSourceReadConsistencyLevels = "EACH_QUORUM"
	// LOCALONE ...
	LOCALONE CassandraSourceReadConsistencyLevels = "LOCAL_ONE"
	// LOCALQUORUM ...
	LOCALQUORUM CassandraSourceReadConsistencyLevels = "LOCAL_QUORUM"
	// LOCALSERIAL ...
	LOCALSERIAL CassandraSourceReadConsistencyLevels = "LOCAL_SERIAL"
	// ONE ...
	ONE CassandraSourceReadConsistencyLevels = "ONE"
	// QUORUM ...
	QUORUM CassandraSourceReadConsistencyLevels = "QUORUM"
	// SERIAL ...
	SERIAL CassandraSourceReadConsistencyLevels = "SERIAL"
	// THREE ...
	THREE CassandraSourceReadConsistencyLevels = "THREE"
	// TWO ...
	TWO CassandraSourceReadConsistencyLevels = "TWO"
)

// PossibleCassandraSourceReadConsistencyLevelsValues returns an array of possible values for the CassandraSourceReadConsistencyLevels const type.
func PossibleCassandraSourceReadConsistencyLevelsValues() []CassandraSourceReadConsistencyLevels {
	return []CassandraSourceReadConsistencyLevels{ALL, EACHQUORUM, LOCALONE, LOCALQUORUM, LOCALSERIAL, ONE, QUORUM, SERIAL, THREE, TWO}
}

// DataFlowComputeType enumerates the values for data flow compute type.
type DataFlowComputeType string

const (
	// ComputeOptimized ...
	ComputeOptimized DataFlowComputeType = "ComputeOptimized"
	// General ...
	General DataFlowComputeType = "General"
	// MemoryOptimized ...
	MemoryOptimized DataFlowComputeType = "MemoryOptimized"
)

// PossibleDataFlowComputeTypeValues returns an array of possible values for the DataFlowComputeType const type.
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return []DataFlowComputeType{ComputeOptimized, General, MemoryOptimized}
}

// DataFlowDebugCommandType enumerates the values for data flow debug command type.
type DataFlowDebugCommandType string

const (
	// ExecuteExpressionQuery ...
	ExecuteExpressionQuery DataFlowDebugCommandType = "executeExpressionQuery"
	// ExecutePreviewQuery ...
	ExecutePreviewQuery DataFlowDebugCommandType = "executePreviewQuery"
	// ExecuteStatisticsQuery ...
	ExecuteStatisticsQuery DataFlowDebugCommandType = "executeStatisticsQuery"
)

// PossibleDataFlowDebugCommandTypeValues returns an array of possible values for the DataFlowDebugCommandType const type.
func PossibleDataFlowDebugCommandTypeValues() []DataFlowDebugCommandType {
	return []DataFlowDebugCommandType{ExecuteExpressionQuery, ExecutePreviewQuery, ExecuteStatisticsQuery}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday ...
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday ...
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday ...
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday ...
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday ...
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday ...
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday ...
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// PossibleDaysOfWeekValues returns an array of possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{DaysOfWeekFriday, DaysOfWeekMonday, DaysOfWeekSaturday, DaysOfWeekSunday, DaysOfWeekThursday, DaysOfWeekTuesday, DaysOfWeekWednesday}
}

// Db2AuthenticationType enumerates the values for db 2 authentication type.
type Db2AuthenticationType string

const (
	// Basic ...
	Basic Db2AuthenticationType = "Basic"
)

// PossibleDb2AuthenticationTypeValues returns an array of possible values for the Db2AuthenticationType const type.
func PossibleDb2AuthenticationTypeValues() []Db2AuthenticationType {
	return []Db2AuthenticationType{Basic}
}

// DependencyCondition enumerates the values for dependency condition.
type DependencyCondition string

const (
	// Completed ...
	Completed DependencyCondition = "Completed"
	// Failed ...
	Failed DependencyCondition = "Failed"
	// Skipped ...
	Skipped DependencyCondition = "Skipped"
	// Succeeded ...
	Succeeded DependencyCondition = "Succeeded"
)

// PossibleDependencyConditionValues returns an array of possible values for the DependencyCondition const type.
func PossibleDependencyConditionValues() []DependencyCondition {
	return []DependencyCondition{Completed, Failed, Skipped, Succeeded}
}

// DynamicsAuthenticationType enumerates the values for dynamics authentication type.
type DynamicsAuthenticationType string

const (
	// AADServicePrincipal ...
	AADServicePrincipal DynamicsAuthenticationType = "AADServicePrincipal"
	// Ifd ...
	Ifd DynamicsAuthenticationType = "Ifd"
	// Office365 ...
	Office365 DynamicsAuthenticationType = "Office365"
)

// PossibleDynamicsAuthenticationTypeValues returns an array of possible values for the DynamicsAuthenticationType const type.
func PossibleDynamicsAuthenticationTypeValues() []DynamicsAuthenticationType {
	return []DynamicsAuthenticationType{AADServicePrincipal, Ifd, Office365}
}

// DynamicsDeploymentType enumerates the values for dynamics deployment type.
type DynamicsDeploymentType string

const (
	// Online ...
	Online DynamicsDeploymentType = "Online"
	// OnPremisesWithIfd ...
	OnPremisesWithIfd DynamicsDeploymentType = "OnPremisesWithIfd"
)

// PossibleDynamicsDeploymentTypeValues returns an array of possible values for the DynamicsDeploymentType const type.
func PossibleDynamicsDeploymentTypeValues() []DynamicsDeploymentType {
	return []DynamicsDeploymentType{Online, OnPremisesWithIfd}
}

// EventSubscriptionStatus enumerates the values for event subscription status.
type EventSubscriptionStatus string

const (
	// Deprovisioning ...
	Deprovisioning EventSubscriptionStatus = "Deprovisioning"
	// Disabled ...
	Disabled EventSubscriptionStatus = "Disabled"
	// Enabled ...
	Enabled EventSubscriptionStatus = "Enabled"
	// Provisioning ...
	Provisioning EventSubscriptionStatus = "Provisioning"
	// Unknown ...
	Unknown EventSubscriptionStatus = "Unknown"
)

// PossibleEventSubscriptionStatusValues returns an array of possible values for the EventSubscriptionStatus const type.
func PossibleEventSubscriptionStatusValues() []EventSubscriptionStatus {
	return []EventSubscriptionStatus{Deprovisioning, Disabled, Enabled, Provisioning, Unknown}
}

// FtpAuthenticationType enumerates the values for ftp authentication type.
type FtpAuthenticationType string

const (
	// FtpAuthenticationTypeAnonymous ...
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = "Anonymous"
	// FtpAuthenticationTypeBasic ...
	FtpAuthenticationTypeBasic FtpAuthenticationType = "Basic"
)

// PossibleFtpAuthenticationTypeValues returns an array of possible values for the FtpAuthenticationType const type.
func PossibleFtpAuthenticationTypeValues() []FtpAuthenticationType {
	return []FtpAuthenticationType{FtpAuthenticationTypeAnonymous, FtpAuthenticationTypeBasic}
}

// GoogleAdWordsAuthenticationType enumerates the values for google ad words authentication type.
type GoogleAdWordsAuthenticationType string

const (
	// ServiceAuthentication ...
	ServiceAuthentication GoogleAdWordsAuthenticationType = "ServiceAuthentication"
	// UserAuthentication ...
	UserAuthentication GoogleAdWordsAuthenticationType = "UserAuthentication"
)

// PossibleGoogleAdWordsAuthenticationTypeValues returns an array of possible values for the GoogleAdWordsAuthenticationType const type.
func PossibleGoogleAdWordsAuthenticationTypeValues() []GoogleAdWordsAuthenticationType {
	return []GoogleAdWordsAuthenticationType{ServiceAuthentication, UserAuthentication}
}

// GoogleBigQueryAuthenticationType enumerates the values for google big query authentication type.
type GoogleBigQueryAuthenticationType string

const (
	// GoogleBigQueryAuthenticationTypeServiceAuthentication ...
	GoogleBigQueryAuthenticationTypeServiceAuthentication GoogleBigQueryAuthenticationType = "ServiceAuthentication"
	// GoogleBigQueryAuthenticationTypeUserAuthentication ...
	GoogleBigQueryAuthenticationTypeUserAuthentication GoogleBigQueryAuthenticationType = "UserAuthentication"
)

// PossibleGoogleBigQueryAuthenticationTypeValues returns an array of possible values for the GoogleBigQueryAuthenticationType const type.
func PossibleGoogleBigQueryAuthenticationTypeValues() []GoogleBigQueryAuthenticationType {
	return []GoogleBigQueryAuthenticationType{GoogleBigQueryAuthenticationTypeServiceAuthentication, GoogleBigQueryAuthenticationTypeUserAuthentication}
}

// HBaseAuthenticationType enumerates the values for h base authentication type.
type HBaseAuthenticationType string

const (
	// HBaseAuthenticationTypeAnonymous ...
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = "Anonymous"
	// HBaseAuthenticationTypeBasic ...
	HBaseAuthenticationTypeBasic HBaseAuthenticationType = "Basic"
)

// PossibleHBaseAuthenticationTypeValues returns an array of possible values for the HBaseAuthenticationType const type.
func PossibleHBaseAuthenticationTypeValues() []HBaseAuthenticationType {
	return []HBaseAuthenticationType{HBaseAuthenticationTypeAnonymous, HBaseAuthenticationTypeBasic}
}

// HDInsightActivityDebugInfoOption enumerates the values for hd insight activity debug info option.
type HDInsightActivityDebugInfoOption string

const (
	// HDInsightActivityDebugInfoOptionAlways ...
	HDInsightActivityDebugInfoOptionAlways HDInsightActivityDebugInfoOption = "Always"
	// HDInsightActivityDebugInfoOptionFailure ...
	HDInsightActivityDebugInfoOptionFailure HDInsightActivityDebugInfoOption = "Failure"
	// HDInsightActivityDebugInfoOptionNone ...
	HDInsightActivityDebugInfoOptionNone HDInsightActivityDebugInfoOption = "None"
)

// PossibleHDInsightActivityDebugInfoOptionValues returns an array of possible values for the HDInsightActivityDebugInfoOption const type.
func PossibleHDInsightActivityDebugInfoOptionValues() []HDInsightActivityDebugInfoOption {
	return []HDInsightActivityDebugInfoOption{HDInsightActivityDebugInfoOptionAlways, HDInsightActivityDebugInfoOptionFailure, HDInsightActivityDebugInfoOptionNone}
}

// HiveAuthenticationType enumerates the values for hive authentication type.
type HiveAuthenticationType string

const (
	// Anonymous ...
	Anonymous HiveAuthenticationType = "Anonymous"
	// Username ...
	Username HiveAuthenticationType = "Username"
	// UsernameAndPassword ...
	UsernameAndPassword HiveAuthenticationType = "UsernameAndPassword"
	// WindowsAzureHDInsightService ...
	WindowsAzureHDInsightService HiveAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleHiveAuthenticationTypeValues returns an array of possible values for the HiveAuthenticationType const type.
func PossibleHiveAuthenticationTypeValues() []HiveAuthenticationType {
	return []HiveAuthenticationType{Anonymous, Username, UsernameAndPassword, WindowsAzureHDInsightService}
}

// HiveServerType enumerates the values for hive server type.
type HiveServerType string

const (
	// HiveServer1 ...
	HiveServer1 HiveServerType = "HiveServer1"
	// HiveServer2 ...
	HiveServer2 HiveServerType = "HiveServer2"
	// HiveThriftServer ...
	HiveThriftServer HiveServerType = "HiveThriftServer"
)

// PossibleHiveServerTypeValues returns an array of possible values for the HiveServerType const type.
func PossibleHiveServerTypeValues() []HiveServerType {
	return []HiveServerType{HiveServer1, HiveServer2, HiveThriftServer}
}

// HiveThriftTransportProtocol enumerates the values for hive thrift transport protocol.
type HiveThriftTransportProtocol string

const (
	// Binary ...
	Binary HiveThriftTransportProtocol = "Binary"
	// HTTP ...
	HTTP HiveThriftTransportProtocol = "HTTP "
	// SASL ...
	SASL HiveThriftTransportProtocol = "SASL"
)

// PossibleHiveThriftTransportProtocolValues returns an array of possible values for the HiveThriftTransportProtocol const type.
func PossibleHiveThriftTransportProtocolValues() []HiveThriftTransportProtocol {
	return []HiveThriftTransportProtocol{Binary, HTTP, SASL}
}

// HTTPAuthenticationType enumerates the values for http authentication type.
type HTTPAuthenticationType string

const (
	// HTTPAuthenticationTypeAnonymous ...
	HTTPAuthenticationTypeAnonymous HTTPAuthenticationType = "Anonymous"
	// HTTPAuthenticationTypeBasic ...
	HTTPAuthenticationTypeBasic HTTPAuthenticationType = "Basic"
	// HTTPAuthenticationTypeClientCertificate ...
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = "ClientCertificate"
	// HTTPAuthenticationTypeDigest ...
	HTTPAuthenticationTypeDigest HTTPAuthenticationType = "Digest"
	// HTTPAuthenticationTypeWindows ...
	HTTPAuthenticationTypeWindows HTTPAuthenticationType = "Windows"
)

// PossibleHTTPAuthenticationTypeValues returns an array of possible values for the HTTPAuthenticationType const type.
func PossibleHTTPAuthenticationTypeValues() []HTTPAuthenticationType {
	return []HTTPAuthenticationType{HTTPAuthenticationTypeAnonymous, HTTPAuthenticationTypeBasic, HTTPAuthenticationTypeClientCertificate, HTTPAuthenticationTypeDigest, HTTPAuthenticationTypeWindows}
}

// ImpalaAuthenticationType enumerates the values for impala authentication type.
type ImpalaAuthenticationType string

const (
	// ImpalaAuthenticationTypeAnonymous ...
	ImpalaAuthenticationTypeAnonymous ImpalaAuthenticationType = "Anonymous"
	// ImpalaAuthenticationTypeSASLUsername ...
	ImpalaAuthenticationTypeSASLUsername ImpalaAuthenticationType = "SASLUsername"
	// ImpalaAuthenticationTypeUsernameAndPassword ...
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = "UsernameAndPassword"
)

// PossibleImpalaAuthenticationTypeValues returns an array of possible values for the ImpalaAuthenticationType const type.
func PossibleImpalaAuthenticationTypeValues() []ImpalaAuthenticationType {
	return []ImpalaAuthenticationType{ImpalaAuthenticationTypeAnonymous, ImpalaAuthenticationTypeSASLUsername, ImpalaAuthenticationTypeUsernameAndPassword}
}

// IntegrationRuntimeAuthKeyName enumerates the values for integration runtime auth key name.
type IntegrationRuntimeAuthKeyName string

const (
	// AuthKey1 ...
	AuthKey1 IntegrationRuntimeAuthKeyName = "authKey1"
	// AuthKey2 ...
	AuthKey2 IntegrationRuntimeAuthKeyName = "authKey2"
)

// PossibleIntegrationRuntimeAuthKeyNameValues returns an array of possible values for the IntegrationRuntimeAuthKeyName const type.
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return []IntegrationRuntimeAuthKeyName{AuthKey1, AuthKey2}
}

// IntegrationRuntimeAutoUpdate enumerates the values for integration runtime auto update.
type IntegrationRuntimeAutoUpdate string

const (
	// Off ...
	Off IntegrationRuntimeAutoUpdate = "Off"
	// On ...
	On IntegrationRuntimeAutoUpdate = "On"
)

// PossibleIntegrationRuntimeAutoUpdateValues returns an array of possible values for the IntegrationRuntimeAutoUpdate const type.
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return []IntegrationRuntimeAutoUpdate{Off, On}
}

// IntegrationRuntimeEdition enumerates the values for integration runtime edition.
type IntegrationRuntimeEdition string

const (
	// Enterprise ...
	Enterprise IntegrationRuntimeEdition = "Enterprise"
	// Standard ...
	Standard IntegrationRuntimeEdition = "Standard"
)

// PossibleIntegrationRuntimeEditionValues returns an array of possible values for the IntegrationRuntimeEdition const type.
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return []IntegrationRuntimeEdition{Enterprise, Standard}
}

// IntegrationRuntimeEntityReferenceType enumerates the values for integration runtime entity reference type.
type IntegrationRuntimeEntityReferenceType string

const (
	// IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference ...
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = "IntegrationRuntimeReference"
	// IntegrationRuntimeEntityReferenceTypeLinkedServiceReference ...
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference IntegrationRuntimeEntityReferenceType = "LinkedServiceReference"
)

// PossibleIntegrationRuntimeEntityReferenceTypeValues returns an array of possible values for the IntegrationRuntimeEntityReferenceType const type.
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return []IntegrationRuntimeEntityReferenceType{IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference, IntegrationRuntimeEntityReferenceTypeLinkedServiceReference}
}

// IntegrationRuntimeInternalChannelEncryptionMode enumerates the values for integration runtime internal
// channel encryption mode.
type IntegrationRuntimeInternalChannelEncryptionMode string

const (
	// NotEncrypted ...
	NotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "NotEncrypted"
	// NotSet ...
	NotSet IntegrationRuntimeInternalChannelEncryptionMode = "NotSet"
	// SslEncrypted ...
	SslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "SslEncrypted"
)

// PossibleIntegrationRuntimeInternalChannelEncryptionModeValues returns an array of possible values for the IntegrationRuntimeInternalChannelEncryptionMode const type.
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return []IntegrationRuntimeInternalChannelEncryptionMode{NotEncrypted, NotSet, SslEncrypted}
}

// IntegrationRuntimeLicenseType enumerates the values for integration runtime license type.
type IntegrationRuntimeLicenseType string

const (
	// BasePrice ...
	BasePrice IntegrationRuntimeLicenseType = "BasePrice"
	// LicenseIncluded ...
	LicenseIncluded IntegrationRuntimeLicenseType = "LicenseIncluded"
)

// PossibleIntegrationRuntimeLicenseTypeValues returns an array of possible values for the IntegrationRuntimeLicenseType const type.
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return []IntegrationRuntimeLicenseType{BasePrice, LicenseIncluded}
}

// IntegrationRuntimeSsisCatalogPricingTier enumerates the values for integration runtime ssis catalog pricing
// tier.
type IntegrationRuntimeSsisCatalogPricingTier string

const (
	// IntegrationRuntimeSsisCatalogPricingTierBasic ...
	IntegrationRuntimeSsisCatalogPricingTierBasic IntegrationRuntimeSsisCatalogPricingTier = "Basic"
	// IntegrationRuntimeSsisCatalogPricingTierPremium ...
	IntegrationRuntimeSsisCatalogPricingTierPremium IntegrationRuntimeSsisCatalogPricingTier = "Premium"
	// IntegrationRuntimeSsisCatalogPricingTierPremiumRS ...
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = "PremiumRS"
	// IntegrationRuntimeSsisCatalogPricingTierStandard ...
	IntegrationRuntimeSsisCatalogPricingTierStandard IntegrationRuntimeSsisCatalogPricingTier = "Standard"
)

// PossibleIntegrationRuntimeSsisCatalogPricingTierValues returns an array of possible values for the IntegrationRuntimeSsisCatalogPricingTier const type.
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return []IntegrationRuntimeSsisCatalogPricingTier{IntegrationRuntimeSsisCatalogPricingTierBasic, IntegrationRuntimeSsisCatalogPricingTierPremium, IntegrationRuntimeSsisCatalogPricingTierPremiumRS, IntegrationRuntimeSsisCatalogPricingTierStandard}
}

// IntegrationRuntimeState enumerates the values for integration runtime state.
type IntegrationRuntimeState string

const (
	// IntegrationRuntimeStateAccessDenied ...
	IntegrationRuntimeStateAccessDenied IntegrationRuntimeState = "AccessDenied"
	// IntegrationRuntimeStateInitial ...
	IntegrationRuntimeStateInitial IntegrationRuntimeState = "Initial"
	// IntegrationRuntimeStateLimited ...
	IntegrationRuntimeStateLimited IntegrationRuntimeState = "Limited"
	// IntegrationRuntimeStateNeedRegistration ...
	IntegrationRuntimeStateNeedRegistration IntegrationRuntimeState = "NeedRegistration"
	// IntegrationRuntimeStateOffline ...
	IntegrationRuntimeStateOffline IntegrationRuntimeState = "Offline"
	// IntegrationRuntimeStateOnline ...
	IntegrationRuntimeStateOnline IntegrationRuntimeState = "Online"
	// IntegrationRuntimeStateStarted ...
	IntegrationRuntimeStateStarted IntegrationRuntimeState = "Started"
	// IntegrationRuntimeStateStarting ...
	IntegrationRuntimeStateStarting IntegrationRuntimeState = "Starting"
	// IntegrationRuntimeStateStopped ...
	IntegrationRuntimeStateStopped IntegrationRuntimeState = "Stopped"
	// IntegrationRuntimeStateStopping ...
	IntegrationRuntimeStateStopping IntegrationRuntimeState = "Stopping"
)

// PossibleIntegrationRuntimeStateValues returns an array of possible values for the IntegrationRuntimeState const type.
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return []IntegrationRuntimeState{IntegrationRuntimeStateAccessDenied, IntegrationRuntimeStateInitial, IntegrationRuntimeStateLimited, IntegrationRuntimeStateNeedRegistration, IntegrationRuntimeStateOffline, IntegrationRuntimeStateOnline, IntegrationRuntimeStateStarted, IntegrationRuntimeStateStarting, IntegrationRuntimeStateStopped, IntegrationRuntimeStateStopping}
}

// IntegrationRuntimeType enumerates the values for integration runtime type.
type IntegrationRuntimeType string

const (
	// Managed ...
	Managed IntegrationRuntimeType = "Managed"
	// SelfHosted ...
	SelfHosted IntegrationRuntimeType = "SelfHosted"
)

// PossibleIntegrationRuntimeTypeValues returns an array of possible values for the IntegrationRuntimeType const type.
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return []IntegrationRuntimeType{Managed, SelfHosted}
}

// IntegrationRuntimeUpdateResult enumerates the values for integration runtime update result.
type IntegrationRuntimeUpdateResult string

const (
	// IntegrationRuntimeUpdateResultFail ...
	IntegrationRuntimeUpdateResultFail IntegrationRuntimeUpdateResult = "Fail"
	// IntegrationRuntimeUpdateResultNone ...
	IntegrationRuntimeUpdateResultNone IntegrationRuntimeUpdateResult = "None"
	// IntegrationRuntimeUpdateResultSucceed ...
	IntegrationRuntimeUpdateResultSucceed IntegrationRuntimeUpdateResult = "Succeed"
)

// PossibleIntegrationRuntimeUpdateResultValues returns an array of possible values for the IntegrationRuntimeUpdateResult const type.
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return []IntegrationRuntimeUpdateResult{IntegrationRuntimeUpdateResultFail, IntegrationRuntimeUpdateResultNone, IntegrationRuntimeUpdateResultSucceed}
}

// JSONWriteFilePattern enumerates the values for json write file pattern.
type JSONWriteFilePattern string

const (
	// ArrayOfObjects ...
	ArrayOfObjects JSONWriteFilePattern = "arrayOfObjects"
	// SetOfObjects ...
	SetOfObjects JSONWriteFilePattern = "setOfObjects"
)

// PossibleJSONWriteFilePatternValues returns an array of possible values for the JSONWriteFilePattern const type.
func PossibleJSONWriteFilePatternValues() []JSONWriteFilePattern {
	return []JSONWriteFilePattern{ArrayOfObjects, SetOfObjects}
}

// ManagedIntegrationRuntimeNodeStatus enumerates the values for managed integration runtime node status.
type ManagedIntegrationRuntimeNodeStatus string

const (
	// Available ...
	Available ManagedIntegrationRuntimeNodeStatus = "Available"
	// Recycling ...
	Recycling ManagedIntegrationRuntimeNodeStatus = "Recycling"
	// Starting ...
	Starting ManagedIntegrationRuntimeNodeStatus = "Starting"
	// Unavailable ...
	Unavailable ManagedIntegrationRuntimeNodeStatus = "Unavailable"
)

// PossibleManagedIntegrationRuntimeNodeStatusValues returns an array of possible values for the ManagedIntegrationRuntimeNodeStatus const type.
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return []ManagedIntegrationRuntimeNodeStatus{Available, Recycling, Starting, Unavailable}
}

// MongoDbAuthenticationType enumerates the values for mongo db authentication type.
type MongoDbAuthenticationType string

const (
	// MongoDbAuthenticationTypeAnonymous ...
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = "Anonymous"
	// MongoDbAuthenticationTypeBasic ...
	MongoDbAuthenticationTypeBasic MongoDbAuthenticationType = "Basic"
)

// PossibleMongoDbAuthenticationTypeValues returns an array of possible values for the MongoDbAuthenticationType const type.
func PossibleMongoDbAuthenticationTypeValues() []MongoDbAuthenticationType {
	return []MongoDbAuthenticationType{MongoDbAuthenticationTypeAnonymous, MongoDbAuthenticationTypeBasic}
}

// NetezzaPartitionOption enumerates the values for netezza partition option.
type NetezzaPartitionOption string

const (
	// NetezzaPartitionOptionDataSlice ...
	NetezzaPartitionOptionDataSlice NetezzaPartitionOption = "DataSlice"
	// NetezzaPartitionOptionDynamicRange ...
	NetezzaPartitionOptionDynamicRange NetezzaPartitionOption = "DynamicRange"
	// NetezzaPartitionOptionNone ...
	NetezzaPartitionOptionNone NetezzaPartitionOption = "None"
)

// PossibleNetezzaPartitionOptionValues returns an array of possible values for the NetezzaPartitionOption const type.
func PossibleNetezzaPartitionOptionValues() []NetezzaPartitionOption {
	return []NetezzaPartitionOption{NetezzaPartitionOptionDataSlice, NetezzaPartitionOptionDynamicRange, NetezzaPartitionOptionNone}
}

// ODataAadServicePrincipalCredentialType enumerates the values for o data aad service principal credential
// type.
type ODataAadServicePrincipalCredentialType string

const (
	// ServicePrincipalCert ...
	ServicePrincipalCert ODataAadServicePrincipalCredentialType = "ServicePrincipalCert"
	// ServicePrincipalKey ...
	ServicePrincipalKey ODataAadServicePrincipalCredentialType = "ServicePrincipalKey"
)

// PossibleODataAadServicePrincipalCredentialTypeValues returns an array of possible values for the ODataAadServicePrincipalCredentialType const type.
func PossibleODataAadServicePrincipalCredentialTypeValues() []ODataAadServicePrincipalCredentialType {
	return []ODataAadServicePrincipalCredentialType{ServicePrincipalCert, ServicePrincipalKey}
}

// ODataAuthenticationType enumerates the values for o data authentication type.
type ODataAuthenticationType string

const (
	// ODataAuthenticationTypeAadServicePrincipal ...
	ODataAuthenticationTypeAadServicePrincipal ODataAuthenticationType = "AadServicePrincipal"
	// ODataAuthenticationTypeAnonymous ...
	ODataAuthenticationTypeAnonymous ODataAuthenticationType = "Anonymous"
	// ODataAuthenticationTypeBasic ...
	ODataAuthenticationTypeBasic ODataAuthenticationType = "Basic"
	// ODataAuthenticationTypeManagedServiceIdentity ...
	ODataAuthenticationTypeManagedServiceIdentity ODataAuthenticationType = "ManagedServiceIdentity"
	// ODataAuthenticationTypeWindows ...
	ODataAuthenticationTypeWindows ODataAuthenticationType = "Windows"
)

// PossibleODataAuthenticationTypeValues returns an array of possible values for the ODataAuthenticationType const type.
func PossibleODataAuthenticationTypeValues() []ODataAuthenticationType {
	return []ODataAuthenticationType{ODataAuthenticationTypeAadServicePrincipal, ODataAuthenticationTypeAnonymous, ODataAuthenticationTypeBasic, ODataAuthenticationTypeManagedServiceIdentity, ODataAuthenticationTypeWindows}
}

// OraclePartitionOption enumerates the values for oracle partition option.
type OraclePartitionOption string

const (
	// OraclePartitionOptionDynamicRange ...
	OraclePartitionOptionDynamicRange OraclePartitionOption = "DynamicRange"
	// OraclePartitionOptionNone ...
	OraclePartitionOptionNone OraclePartitionOption = "None"
	// OraclePartitionOptionPhysicalPartitionsOfTable ...
	OraclePartitionOptionPhysicalPartitionsOfTable OraclePartitionOption = "PhysicalPartitionsOfTable"
)

// PossibleOraclePartitionOptionValues returns an array of possible values for the OraclePartitionOption const type.
func PossibleOraclePartitionOptionValues() []OraclePartitionOption {
	return []OraclePartitionOption{OraclePartitionOptionDynamicRange, OraclePartitionOptionNone, OraclePartitionOptionPhysicalPartitionsOfTable}
}

// OrcCompressionCodec enumerates the values for orc compression codec.
type OrcCompressionCodec string

const (
	// OrcCompressionCodecNone ...
	OrcCompressionCodecNone OrcCompressionCodec = "none"
	// OrcCompressionCodecSnappy ...
	OrcCompressionCodecSnappy OrcCompressionCodec = "snappy"
	// OrcCompressionCodecZlib ...
	OrcCompressionCodecZlib OrcCompressionCodec = "zlib"
)

// PossibleOrcCompressionCodecValues returns an array of possible values for the OrcCompressionCodec const type.
func PossibleOrcCompressionCodecValues() []OrcCompressionCodec {
	return []OrcCompressionCodec{OrcCompressionCodecNone, OrcCompressionCodecSnappy, OrcCompressionCodecZlib}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeArray ...
	ParameterTypeArray ParameterType = "Array"
	// ParameterTypeBool ...
	ParameterTypeBool ParameterType = "Bool"
	// ParameterTypeFloat ...
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInt ...
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeObject ...
	ParameterTypeObject ParameterType = "Object"
	// ParameterTypeSecureString ...
	ParameterTypeSecureString ParameterType = "SecureString"
	// ParameterTypeString ...
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeArray, ParameterTypeBool, ParameterTypeFloat, ParameterTypeInt, ParameterTypeObject, ParameterTypeSecureString, ParameterTypeString}
}

// PhoenixAuthenticationType enumerates the values for phoenix authentication type.
type PhoenixAuthenticationType string

const (
	// PhoenixAuthenticationTypeAnonymous ...
	PhoenixAuthenticationTypeAnonymous PhoenixAuthenticationType = "Anonymous"
	// PhoenixAuthenticationTypeUsernameAndPassword ...
	PhoenixAuthenticationTypeUsernameAndPassword PhoenixAuthenticationType = "UsernameAndPassword"
	// PhoenixAuthenticationTypeWindowsAzureHDInsightService ...
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = "WindowsAzureHDInsightService"
)

// PossiblePhoenixAuthenticationTypeValues returns an array of possible values for the PhoenixAuthenticationType const type.
func PossiblePhoenixAuthenticationTypeValues() []PhoenixAuthenticationType {
	return []PhoenixAuthenticationType{PhoenixAuthenticationTypeAnonymous, PhoenixAuthenticationTypeUsernameAndPassword, PhoenixAuthenticationTypeWindowsAzureHDInsightService}
}

// PolybaseSettingsRejectType enumerates the values for polybase settings reject type.
type PolybaseSettingsRejectType string

const (
	// Percentage ...
	Percentage PolybaseSettingsRejectType = "percentage"
	// Value ...
	Value PolybaseSettingsRejectType = "value"
)

// PossiblePolybaseSettingsRejectTypeValues returns an array of possible values for the PolybaseSettingsRejectType const type.
func PossiblePolybaseSettingsRejectTypeValues() []PolybaseSettingsRejectType {
	return []PolybaseSettingsRejectType{Percentage, Value}
}

// PrestoAuthenticationType enumerates the values for presto authentication type.
type PrestoAuthenticationType string

const (
	// PrestoAuthenticationTypeAnonymous ...
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = "Anonymous"
	// PrestoAuthenticationTypeLDAP ...
	PrestoAuthenticationTypeLDAP PrestoAuthenticationType = "LDAP"
)

// PossiblePrestoAuthenticationTypeValues returns an array of possible values for the PrestoAuthenticationType const type.
func PossiblePrestoAuthenticationTypeValues() []PrestoAuthenticationType {
	return []PrestoAuthenticationType{PrestoAuthenticationTypeAnonymous, PrestoAuthenticationTypeLDAP}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// Day ...
	Day RecurrenceFrequency = "Day"
	// Hour ...
	Hour RecurrenceFrequency = "Hour"
	// Minute ...
	Minute RecurrenceFrequency = "Minute"
	// Month ...
	Month RecurrenceFrequency = "Month"
	// NotSpecified ...
	NotSpecified RecurrenceFrequency = "NotSpecified"
	// Week ...
	Week RecurrenceFrequency = "Week"
	// Year ...
	Year RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{Day, Hour, Minute, Month, NotSpecified, Week, Year}
}

// RestServiceAuthenticationType enumerates the values for rest service authentication type.
type RestServiceAuthenticationType string

const (
	// RestServiceAuthenticationTypeAadServicePrincipal ...
	RestServiceAuthenticationTypeAadServicePrincipal RestServiceAuthenticationType = "AadServicePrincipal"
	// RestServiceAuthenticationTypeAnonymous ...
	RestServiceAuthenticationTypeAnonymous RestServiceAuthenticationType = "Anonymous"
	// RestServiceAuthenticationTypeBasic ...
	RestServiceAuthenticationTypeBasic RestServiceAuthenticationType = "Basic"
	// RestServiceAuthenticationTypeManagedServiceIdentity ...
	RestServiceAuthenticationTypeManagedServiceIdentity RestServiceAuthenticationType = "ManagedServiceIdentity"
)

// PossibleRestServiceAuthenticationTypeValues returns an array of possible values for the RestServiceAuthenticationType const type.
func PossibleRestServiceAuthenticationTypeValues() []RestServiceAuthenticationType {
	return []RestServiceAuthenticationType{RestServiceAuthenticationTypeAadServicePrincipal, RestServiceAuthenticationTypeAnonymous, RestServiceAuthenticationTypeBasic, RestServiceAuthenticationTypeManagedServiceIdentity}
}

// RunQueryFilterOperand enumerates the values for run query filter operand.
type RunQueryFilterOperand string

const (
	// ActivityName ...
	ActivityName RunQueryFilterOperand = "ActivityName"
	// ActivityRunEnd ...
	ActivityRunEnd RunQueryFilterOperand = "ActivityRunEnd"
	// ActivityRunStart ...
	ActivityRunStart RunQueryFilterOperand = "ActivityRunStart"
	// ActivityType ...
	ActivityType RunQueryFilterOperand = "ActivityType"
	// LatestOnly ...
	LatestOnly RunQueryFilterOperand = "LatestOnly"
	// PipelineName ...
	PipelineName RunQueryFilterOperand = "PipelineName"
	// RunEnd ...
	RunEnd RunQueryFilterOperand = "RunEnd"
	// RunGroupID ...
	RunGroupID RunQueryFilterOperand = "RunGroupId"
	// RunStart ...
	RunStart RunQueryFilterOperand = "RunStart"
	// Status ...
	Status RunQueryFilterOperand = "Status"
	// TriggerName ...
	TriggerName RunQueryFilterOperand = "TriggerName"
	// TriggerRunTimestamp ...
	TriggerRunTimestamp RunQueryFilterOperand = "TriggerRunTimestamp"
)

// PossibleRunQueryFilterOperandValues returns an array of possible values for the RunQueryFilterOperand const type.
func PossibleRunQueryFilterOperandValues() []RunQueryFilterOperand {
	return []RunQueryFilterOperand{ActivityName, ActivityRunEnd, ActivityRunStart, ActivityType, LatestOnly, PipelineName, RunEnd, RunGroupID, RunStart, Status, TriggerName, TriggerRunTimestamp}
}

// RunQueryFilterOperator enumerates the values for run query filter operator.
type RunQueryFilterOperator string

const (
	// Equals ...
	Equals RunQueryFilterOperator = "Equals"
	// In ...
	In RunQueryFilterOperator = "In"
	// NotEquals ...
	NotEquals RunQueryFilterOperator = "NotEquals"
	// NotIn ...
	NotIn RunQueryFilterOperator = "NotIn"
)

// PossibleRunQueryFilterOperatorValues returns an array of possible values for the RunQueryFilterOperator const type.
func PossibleRunQueryFilterOperatorValues() []RunQueryFilterOperator {
	return []RunQueryFilterOperator{Equals, In, NotEquals, NotIn}
}

// RunQueryOrder enumerates the values for run query order.
type RunQueryOrder string

const (
	// ASC ...
	ASC RunQueryOrder = "ASC"
	// DESC ...
	DESC RunQueryOrder = "DESC"
)

// PossibleRunQueryOrderValues returns an array of possible values for the RunQueryOrder const type.
func PossibleRunQueryOrderValues() []RunQueryOrder {
	return []RunQueryOrder{ASC, DESC}
}

// RunQueryOrderByField enumerates the values for run query order by field.
type RunQueryOrderByField string

const (
	// RunQueryOrderByFieldActivityName ...
	RunQueryOrderByFieldActivityName RunQueryOrderByField = "ActivityName"
	// RunQueryOrderByFieldActivityRunEnd ...
	RunQueryOrderByFieldActivityRunEnd RunQueryOrderByField = "ActivityRunEnd"
	// RunQueryOrderByFieldActivityRunStart ...
	RunQueryOrderByFieldActivityRunStart RunQueryOrderByField = "ActivityRunStart"
	// RunQueryOrderByFieldPipelineName ...
	RunQueryOrderByFieldPipelineName RunQueryOrderByField = "PipelineName"
	// RunQueryOrderByFieldRunEnd ...
	RunQueryOrderByFieldRunEnd RunQueryOrderByField = "RunEnd"
	// RunQueryOrderByFieldRunStart ...
	RunQueryOrderByFieldRunStart RunQueryOrderByField = "RunStart"
	// RunQueryOrderByFieldStatus ...
	RunQueryOrderByFieldStatus RunQueryOrderByField = "Status"
	// RunQueryOrderByFieldTriggerName ...
	RunQueryOrderByFieldTriggerName RunQueryOrderByField = "TriggerName"
	// RunQueryOrderByFieldTriggerRunTimestamp ...
	RunQueryOrderByFieldTriggerRunTimestamp RunQueryOrderByField = "TriggerRunTimestamp"
)

// PossibleRunQueryOrderByFieldValues returns an array of possible values for the RunQueryOrderByField const type.
func PossibleRunQueryOrderByFieldValues() []RunQueryOrderByField {
	return []RunQueryOrderByField{RunQueryOrderByFieldActivityName, RunQueryOrderByFieldActivityRunEnd, RunQueryOrderByFieldActivityRunStart, RunQueryOrderByFieldPipelineName, RunQueryOrderByFieldRunEnd, RunQueryOrderByFieldRunStart, RunQueryOrderByFieldStatus, RunQueryOrderByFieldTriggerName, RunQueryOrderByFieldTriggerRunTimestamp}
}

// SalesforceSinkWriteBehavior enumerates the values for salesforce sink write behavior.
type SalesforceSinkWriteBehavior string

const (
	// Insert ...
	Insert SalesforceSinkWriteBehavior = "Insert"
	// Upsert ...
	Upsert SalesforceSinkWriteBehavior = "Upsert"
)

// PossibleSalesforceSinkWriteBehaviorValues returns an array of possible values for the SalesforceSinkWriteBehavior const type.
func PossibleSalesforceSinkWriteBehaviorValues() []SalesforceSinkWriteBehavior {
	return []SalesforceSinkWriteBehavior{Insert, Upsert}
}

// SalesforceSourceReadBehavior enumerates the values for salesforce source read behavior.
type SalesforceSourceReadBehavior string

const (
	// Query ...
	Query SalesforceSourceReadBehavior = "Query"
	// QueryAll ...
	QueryAll SalesforceSourceReadBehavior = "QueryAll"
)

// PossibleSalesforceSourceReadBehaviorValues returns an array of possible values for the SalesforceSourceReadBehavior const type.
func PossibleSalesforceSourceReadBehaviorValues() []SalesforceSourceReadBehavior {
	return []SalesforceSourceReadBehavior{Query, QueryAll}
}

// SapCloudForCustomerSinkWriteBehavior enumerates the values for sap cloud for customer sink write behavior.
type SapCloudForCustomerSinkWriteBehavior string

const (
	// SapCloudForCustomerSinkWriteBehaviorInsert ...
	SapCloudForCustomerSinkWriteBehaviorInsert SapCloudForCustomerSinkWriteBehavior = "Insert"
	// SapCloudForCustomerSinkWriteBehaviorUpdate ...
	SapCloudForCustomerSinkWriteBehaviorUpdate SapCloudForCustomerSinkWriteBehavior = "Update"
)

// PossibleSapCloudForCustomerSinkWriteBehaviorValues returns an array of possible values for the SapCloudForCustomerSinkWriteBehavior const type.
func PossibleSapCloudForCustomerSinkWriteBehaviorValues() []SapCloudForCustomerSinkWriteBehavior {
	return []SapCloudForCustomerSinkWriteBehavior{SapCloudForCustomerSinkWriteBehaviorInsert, SapCloudForCustomerSinkWriteBehaviorUpdate}
}

// SapHanaAuthenticationType enumerates the values for sap hana authentication type.
type SapHanaAuthenticationType string

const (
	// SapHanaAuthenticationTypeBasic ...
	SapHanaAuthenticationTypeBasic SapHanaAuthenticationType = "Basic"
	// SapHanaAuthenticationTypeWindows ...
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = "Windows"
)

// PossibleSapHanaAuthenticationTypeValues returns an array of possible values for the SapHanaAuthenticationType const type.
func PossibleSapHanaAuthenticationTypeValues() []SapHanaAuthenticationType {
	return []SapHanaAuthenticationType{SapHanaAuthenticationTypeBasic, SapHanaAuthenticationTypeWindows}
}

// SapHanaPartitionOption enumerates the values for sap hana partition option.
type SapHanaPartitionOption string

const (
	// SapHanaPartitionOptionNone ...
	SapHanaPartitionOptionNone SapHanaPartitionOption = "None"
	// SapHanaPartitionOptionPhysicalPartitionsOfTable ...
	SapHanaPartitionOptionPhysicalPartitionsOfTable SapHanaPartitionOption = "PhysicalPartitionsOfTable"
	// SapHanaPartitionOptionSapHanaDynamicRange ...
	SapHanaPartitionOptionSapHanaDynamicRange SapHanaPartitionOption = "SapHanaDynamicRange"
)

// PossibleSapHanaPartitionOptionValues returns an array of possible values for the SapHanaPartitionOption const type.
func PossibleSapHanaPartitionOptionValues() []SapHanaPartitionOption {
	return []SapHanaPartitionOption{SapHanaPartitionOptionNone, SapHanaPartitionOptionPhysicalPartitionsOfTable, SapHanaPartitionOptionSapHanaDynamicRange}
}

// SapTablePartitionOption enumerates the values for sap table partition option.
type SapTablePartitionOption string

const (
	// SapTablePartitionOptionNone ...
	SapTablePartitionOptionNone SapTablePartitionOption = "None"
	// SapTablePartitionOptionPartitionOnCalendarDate ...
	SapTablePartitionOptionPartitionOnCalendarDate SapTablePartitionOption = "PartitionOnCalendarDate"
	// SapTablePartitionOptionPartitionOnCalendarMonth ...
	SapTablePartitionOptionPartitionOnCalendarMonth SapTablePartitionOption = "PartitionOnCalendarMonth"
	// SapTablePartitionOptionPartitionOnCalendarYear ...
	SapTablePartitionOptionPartitionOnCalendarYear SapTablePartitionOption = "PartitionOnCalendarYear"
	// SapTablePartitionOptionPartitionOnInt ...
	SapTablePartitionOptionPartitionOnInt SapTablePartitionOption = "PartitionOnInt"
	// SapTablePartitionOptionPartitionOnTime ...
	SapTablePartitionOptionPartitionOnTime SapTablePartitionOption = "PartitionOnTime"
)

// PossibleSapTablePartitionOptionValues returns an array of possible values for the SapTablePartitionOption const type.
func PossibleSapTablePartitionOptionValues() []SapTablePartitionOption {
	return []SapTablePartitionOption{SapTablePartitionOptionNone, SapTablePartitionOptionPartitionOnCalendarDate, SapTablePartitionOptionPartitionOnCalendarMonth, SapTablePartitionOptionPartitionOnCalendarYear, SapTablePartitionOptionPartitionOnInt, SapTablePartitionOptionPartitionOnTime}
}

// SelfHostedIntegrationRuntimeNodeStatus enumerates the values for self hosted integration runtime node
// status.
type SelfHostedIntegrationRuntimeNodeStatus string

const (
	// SelfHostedIntegrationRuntimeNodeStatusInitializeFailed ...
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = "InitializeFailed"
	// SelfHostedIntegrationRuntimeNodeStatusInitializing ...
	SelfHostedIntegrationRuntimeNodeStatusInitializing SelfHostedIntegrationRuntimeNodeStatus = "Initializing"
	// SelfHostedIntegrationRuntimeNodeStatusLimited ...
	SelfHostedIntegrationRuntimeNodeStatusLimited SelfHostedIntegrationRuntimeNodeStatus = "Limited"
	// SelfHostedIntegrationRuntimeNodeStatusNeedRegistration ...
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = "NeedRegistration"
	// SelfHostedIntegrationRuntimeNodeStatusOffline ...
	SelfHostedIntegrationRuntimeNodeStatusOffline SelfHostedIntegrationRuntimeNodeStatus = "Offline"
	// SelfHostedIntegrationRuntimeNodeStatusOnline ...
	SelfHostedIntegrationRuntimeNodeStatusOnline SelfHostedIntegrationRuntimeNodeStatus = "Online"
	// SelfHostedIntegrationRuntimeNodeStatusUpgrading ...
	SelfHostedIntegrationRuntimeNodeStatusUpgrading SelfHostedIntegrationRuntimeNodeStatus = "Upgrading"
)

// PossibleSelfHostedIntegrationRuntimeNodeStatusValues returns an array of possible values for the SelfHostedIntegrationRuntimeNodeStatus const type.
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return []SelfHostedIntegrationRuntimeNodeStatus{SelfHostedIntegrationRuntimeNodeStatusInitializeFailed, SelfHostedIntegrationRuntimeNodeStatusInitializing, SelfHostedIntegrationRuntimeNodeStatusLimited, SelfHostedIntegrationRuntimeNodeStatusNeedRegistration, SelfHostedIntegrationRuntimeNodeStatusOffline, SelfHostedIntegrationRuntimeNodeStatusOnline, SelfHostedIntegrationRuntimeNodeStatusUpgrading}
}

// ServiceNowAuthenticationType enumerates the values for service now authentication type.
type ServiceNowAuthenticationType string

const (
	// ServiceNowAuthenticationTypeBasic ...
	ServiceNowAuthenticationTypeBasic ServiceNowAuthenticationType = "Basic"
	// ServiceNowAuthenticationTypeOAuth2 ...
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = "OAuth2"
)

// PossibleServiceNowAuthenticationTypeValues returns an array of possible values for the ServiceNowAuthenticationType const type.
func PossibleServiceNowAuthenticationTypeValues() []ServiceNowAuthenticationType {
	return []ServiceNowAuthenticationType{ServiceNowAuthenticationTypeBasic, ServiceNowAuthenticationTypeOAuth2}
}

// SftpAuthenticationType enumerates the values for sftp authentication type.
type SftpAuthenticationType string

const (
	// SftpAuthenticationTypeBasic ...
	SftpAuthenticationTypeBasic SftpAuthenticationType = "Basic"
	// SftpAuthenticationTypeSSHPublicKey ...
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = "SshPublicKey"
)

// PossibleSftpAuthenticationTypeValues returns an array of possible values for the SftpAuthenticationType const type.
func PossibleSftpAuthenticationTypeValues() []SftpAuthenticationType {
	return []SftpAuthenticationType{SftpAuthenticationTypeBasic, SftpAuthenticationTypeSSHPublicKey}
}

// SparkAuthenticationType enumerates the values for spark authentication type.
type SparkAuthenticationType string

const (
	// SparkAuthenticationTypeAnonymous ...
	SparkAuthenticationTypeAnonymous SparkAuthenticationType = "Anonymous"
	// SparkAuthenticationTypeUsername ...
	SparkAuthenticationTypeUsername SparkAuthenticationType = "Username"
	// SparkAuthenticationTypeUsernameAndPassword ...
	SparkAuthenticationTypeUsernameAndPassword SparkAuthenticationType = "UsernameAndPassword"
	// SparkAuthenticationTypeWindowsAzureHDInsightService ...
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleSparkAuthenticationTypeValues returns an array of possible values for the SparkAuthenticationType const type.
func PossibleSparkAuthenticationTypeValues() []SparkAuthenticationType {
	return []SparkAuthenticationType{SparkAuthenticationTypeAnonymous, SparkAuthenticationTypeUsername, SparkAuthenticationTypeUsernameAndPassword, SparkAuthenticationTypeWindowsAzureHDInsightService}
}

// SparkServerType enumerates the values for spark server type.
type SparkServerType string

const (
	// SharkServer ...
	SharkServer SparkServerType = "SharkServer"
	// SharkServer2 ...
	SharkServer2 SparkServerType = "SharkServer2"
	// SparkThriftServer ...
	SparkThriftServer SparkServerType = "SparkThriftServer"
)

// PossibleSparkServerTypeValues returns an array of possible values for the SparkServerType const type.
func PossibleSparkServerTypeValues() []SparkServerType {
	return []SparkServerType{SharkServer, SharkServer2, SparkThriftServer}
}

// SparkThriftTransportProtocol enumerates the values for spark thrift transport protocol.
type SparkThriftTransportProtocol string

const (
	// SparkThriftTransportProtocolBinary ...
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = "Binary"
	// SparkThriftTransportProtocolHTTP ...
	SparkThriftTransportProtocolHTTP SparkThriftTransportProtocol = "HTTP "
	// SparkThriftTransportProtocolSASL ...
	SparkThriftTransportProtocolSASL SparkThriftTransportProtocol = "SASL"
)

// PossibleSparkThriftTransportProtocolValues returns an array of possible values for the SparkThriftTransportProtocol const type.
func PossibleSparkThriftTransportProtocolValues() []SparkThriftTransportProtocol {
	return []SparkThriftTransportProtocol{SparkThriftTransportProtocolBinary, SparkThriftTransportProtocolHTTP, SparkThriftTransportProtocolSASL}
}

// SsisObjectMetadataType enumerates the values for ssis object metadata type.
type SsisObjectMetadataType string

const (
	// Environment ...
	Environment SsisObjectMetadataType = "Environment"
	// Folder ...
	Folder SsisObjectMetadataType = "Folder"
	// Package ...
	Package SsisObjectMetadataType = "Package"
	// Project ...
	Project SsisObjectMetadataType = "Project"
)

// PossibleSsisObjectMetadataTypeValues returns an array of possible values for the SsisObjectMetadataType const type.
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return []SsisObjectMetadataType{Environment, Folder, Package, Project}
}

// SsisPackageLocationType enumerates the values for ssis package location type.
type SsisPackageLocationType string

const (
	// SsisPackageLocationTypeFile ...
	SsisPackageLocationTypeFile SsisPackageLocationType = "File"
	// SsisPackageLocationTypeInlinePackage ...
	SsisPackageLocationTypeInlinePackage SsisPackageLocationType = "InlinePackage"
	// SsisPackageLocationTypePackageStore ...
	SsisPackageLocationTypePackageStore SsisPackageLocationType = "PackageStore"
	// SsisPackageLocationTypeSSISDB ...
	SsisPackageLocationTypeSSISDB SsisPackageLocationType = "SSISDB"
)

// PossibleSsisPackageLocationTypeValues returns an array of possible values for the SsisPackageLocationType const type.
func PossibleSsisPackageLocationTypeValues() []SsisPackageLocationType {
	return []SsisPackageLocationType{SsisPackageLocationTypeFile, SsisPackageLocationTypeInlinePackage, SsisPackageLocationTypePackageStore, SsisPackageLocationTypeSSISDB}
}

// StoredProcedureParameterType enumerates the values for stored procedure parameter type.
type StoredProcedureParameterType string

const (
	// Boolean ...
	Boolean StoredProcedureParameterType = "Boolean"
	// Date ...
	Date StoredProcedureParameterType = "Date"
	// Decimal ...
	Decimal StoredProcedureParameterType = "Decimal"
	// GUID ...
	GUID StoredProcedureParameterType = "Guid"
	// Int ...
	Int StoredProcedureParameterType = "Int"
	// Int64 ...
	Int64 StoredProcedureParameterType = "Int64"
	// String ...
	String StoredProcedureParameterType = "String"
)

// PossibleStoredProcedureParameterTypeValues returns an array of possible values for the StoredProcedureParameterType const type.
func PossibleStoredProcedureParameterTypeValues() []StoredProcedureParameterType {
	return []StoredProcedureParameterType{Boolean, Date, Decimal, GUID, Int, Int64, String}
}

// SybaseAuthenticationType enumerates the values for sybase authentication type.
type SybaseAuthenticationType string

const (
	// SybaseAuthenticationTypeBasic ...
	SybaseAuthenticationTypeBasic SybaseAuthenticationType = "Basic"
	// SybaseAuthenticationTypeWindows ...
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = "Windows"
)

// PossibleSybaseAuthenticationTypeValues returns an array of possible values for the SybaseAuthenticationType const type.
func PossibleSybaseAuthenticationTypeValues() []SybaseAuthenticationType {
	return []SybaseAuthenticationType{SybaseAuthenticationTypeBasic, SybaseAuthenticationTypeWindows}
}

// TeradataAuthenticationType enumerates the values for teradata authentication type.
type TeradataAuthenticationType string

const (
	// TeradataAuthenticationTypeBasic ...
	TeradataAuthenticationTypeBasic TeradataAuthenticationType = "Basic"
	// TeradataAuthenticationTypeWindows ...
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = "Windows"
)

// PossibleTeradataAuthenticationTypeValues returns an array of possible values for the TeradataAuthenticationType const type.
func PossibleTeradataAuthenticationTypeValues() []TeradataAuthenticationType {
	return []TeradataAuthenticationType{TeradataAuthenticationTypeBasic, TeradataAuthenticationTypeWindows}
}

// TeradataPartitionOption enumerates the values for teradata partition option.
type TeradataPartitionOption string

const (
	// TeradataPartitionOptionDynamicRange ...
	TeradataPartitionOptionDynamicRange TeradataPartitionOption = "DynamicRange"
	// TeradataPartitionOptionHash ...
	TeradataPartitionOptionHash TeradataPartitionOption = "Hash"
	// TeradataPartitionOptionNone ...
	TeradataPartitionOptionNone TeradataPartitionOption = "None"
)

// PossibleTeradataPartitionOptionValues returns an array of possible values for the TeradataPartitionOption const type.
func PossibleTeradataPartitionOptionValues() []TeradataPartitionOption {
	return []TeradataPartitionOption{TeradataPartitionOptionDynamicRange, TeradataPartitionOptionHash, TeradataPartitionOptionNone}
}

// TriggerRunStatus enumerates the values for trigger run status.
type TriggerRunStatus string

const (
	// TriggerRunStatusFailed ...
	TriggerRunStatusFailed TriggerRunStatus = "Failed"
	// TriggerRunStatusInprogress ...
	TriggerRunStatusInprogress TriggerRunStatus = "Inprogress"
	// TriggerRunStatusSucceeded ...
	TriggerRunStatusSucceeded TriggerRunStatus = "Succeeded"
)

// PossibleTriggerRunStatusValues returns an array of possible values for the TriggerRunStatus const type.
func PossibleTriggerRunStatusValues() []TriggerRunStatus {
	return []TriggerRunStatus{TriggerRunStatusFailed, TriggerRunStatusInprogress, TriggerRunStatusSucceeded}
}

// TriggerRuntimeState enumerates the values for trigger runtime state.
type TriggerRuntimeState string

const (
	// TriggerRuntimeStateDisabled ...
	TriggerRuntimeStateDisabled TriggerRuntimeState = "Disabled"
	// TriggerRuntimeStateStarted ...
	TriggerRuntimeStateStarted TriggerRuntimeState = "Started"
	// TriggerRuntimeStateStopped ...
	TriggerRuntimeStateStopped TriggerRuntimeState = "Stopped"
)

// PossibleTriggerRuntimeStateValues returns an array of possible values for the TriggerRuntimeState const type.
func PossibleTriggerRuntimeStateValues() []TriggerRuntimeState {
	return []TriggerRuntimeState{TriggerRuntimeStateDisabled, TriggerRuntimeStateStarted, TriggerRuntimeStateStopped}
}

// TumblingWindowFrequency enumerates the values for tumbling window frequency.
type TumblingWindowFrequency string

const (
	// TumblingWindowFrequencyHour ...
	TumblingWindowFrequencyHour TumblingWindowFrequency = "Hour"
	// TumblingWindowFrequencyMinute ...
	TumblingWindowFrequencyMinute TumblingWindowFrequency = "Minute"
)

// PossibleTumblingWindowFrequencyValues returns an array of possible values for the TumblingWindowFrequency const type.
func PossibleTumblingWindowFrequencyValues() []TumblingWindowFrequency {
	return []TumblingWindowFrequency{TumblingWindowFrequencyHour, TumblingWindowFrequencyMinute}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAzureKeyVaultSecret ...
	TypeAzureKeyVaultSecret Type = "AzureKeyVaultSecret"
	// TypeSecretBase ...
	TypeSecretBase Type = "SecretBase"
	// TypeSecureString ...
	TypeSecureString Type = "SecureString"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAzureKeyVaultSecret, TypeSecretBase, TypeSecureString}
}

// TypeBasicActivity enumerates the values for type basic activity.
type TypeBasicActivity string

const (
	// TypeActivity ...
	TypeActivity TypeBasicActivity = "Activity"
	// TypeAppendVariable ...
	TypeAppendVariable TypeBasicActivity = "AppendVariable"
	// TypeAzureDataExplorerCommand ...
	TypeAzureDataExplorerCommand TypeBasicActivity = "AzureDataExplorerCommand"
	// TypeAzureFunctionActivity ...
	TypeAzureFunctionActivity TypeBasicActivity = "AzureFunctionActivity"
	// TypeAzureMLBatchExecution ...
	TypeAzureMLBatchExecution TypeBasicActivity = "AzureMLBatchExecution"
	// TypeAzureMLExecutePipeline ...
	TypeAzureMLExecutePipeline TypeBasicActivity = "AzureMLExecutePipeline"
	// TypeAzureMLUpdateResource ...
	TypeAzureMLUpdateResource TypeBasicActivity = "AzureMLUpdateResource"
	// TypeContainer ...
	TypeContainer TypeBasicActivity = "Container"
	// TypeCopy ...
	TypeCopy TypeBasicActivity = "Copy"
	// TypeCustom ...
	TypeCustom TypeBasicActivity = "Custom"
	// TypeDatabricksNotebook ...
	TypeDatabricksNotebook TypeBasicActivity = "DatabricksNotebook"
	// TypeDatabricksSparkJar ...
	TypeDatabricksSparkJar TypeBasicActivity = "DatabricksSparkJar"
	// TypeDatabricksSparkPython ...
	TypeDatabricksSparkPython TypeBasicActivity = "DatabricksSparkPython"
	// TypeDataLakeAnalyticsUSQL ...
	TypeDataLakeAnalyticsUSQL TypeBasicActivity = "DataLakeAnalyticsU-SQL"
	// TypeDelete ...
	TypeDelete TypeBasicActivity = "Delete"
	// TypeExecuteDataFlow ...
	TypeExecuteDataFlow TypeBasicActivity = "ExecuteDataFlow"
	// TypeExecutePipeline ...
	TypeExecutePipeline TypeBasicActivity = "ExecutePipeline"
	// TypeExecuteSSISPackage ...
	TypeExecuteSSISPackage TypeBasicActivity = "ExecuteSSISPackage"
	// TypeExecution ...
	TypeExecution TypeBasicActivity = "Execution"
	// TypeFilter ...
	TypeFilter TypeBasicActivity = "Filter"
	// TypeForEach ...
	TypeForEach TypeBasicActivity = "ForEach"
	// TypeGetMetadata ...
	TypeGetMetadata TypeBasicActivity = "GetMetadata"
	// TypeHDInsightHive ...
	TypeHDInsightHive TypeBasicActivity = "HDInsightHive"
	// TypeHDInsightMapReduce ...
	TypeHDInsightMapReduce TypeBasicActivity = "HDInsightMapReduce"
	// TypeHDInsightPig ...
	TypeHDInsightPig TypeBasicActivity = "HDInsightPig"
	// TypeHDInsightSpark ...
	TypeHDInsightSpark TypeBasicActivity = "HDInsightSpark"
	// TypeHDInsightStreaming ...
	TypeHDInsightStreaming TypeBasicActivity = "HDInsightStreaming"
	// TypeIfCondition ...
	TypeIfCondition TypeBasicActivity = "IfCondition"
	// TypeLookup ...
	TypeLookup TypeBasicActivity = "Lookup"
	// TypeSetVariable ...
	TypeSetVariable TypeBasicActivity = "SetVariable"
	// TypeSQLServerStoredProcedure ...
	TypeSQLServerStoredProcedure TypeBasicActivity = "SqlServerStoredProcedure"
	// TypeSwitch ...
	TypeSwitch TypeBasicActivity = "Switch"
	// TypeUntil ...
	TypeUntil TypeBasicActivity = "Until"
	// TypeValidation ...
	TypeValidation TypeBasicActivity = "Validation"
	// TypeWait ...
	TypeWait TypeBasicActivity = "Wait"
	// TypeWebActivity ...
	TypeWebActivity TypeBasicActivity = "WebActivity"
	// TypeWebHook ...
	TypeWebHook TypeBasicActivity = "WebHook"
)

// PossibleTypeBasicActivityValues returns an array of possible values for the TypeBasicActivity const type.
func PossibleTypeBasicActivityValues() []TypeBasicActivity {
	return []TypeBasicActivity{TypeActivity, TypeAppendVariable, TypeAzureDataExplorerCommand, TypeAzureFunctionActivity, TypeAzureMLBatchExecution, TypeAzureMLExecutePipeline, TypeAzureMLUpdateResource, TypeContainer, TypeCopy, TypeCustom, TypeDatabricksNotebook, TypeDatabricksSparkJar, TypeDatabricksSparkPython, TypeDataLakeAnalyticsUSQL, TypeDelete, TypeExecuteDataFlow, TypeExecutePipeline, TypeExecuteSSISPackage, TypeExecution, TypeFilter, TypeForEach, TypeGetMetadata, TypeHDInsightHive, TypeHDInsightMapReduce, TypeHDInsightPig, TypeHDInsightSpark, TypeHDInsightStreaming, TypeIfCondition, TypeLookup, TypeSetVariable, TypeSQLServerStoredProcedure, TypeSwitch, TypeUntil, TypeValidation, TypeWait, TypeWebActivity, TypeWebHook}
}

// TypeBasicCompressionReadSettings enumerates the values for type basic compression read settings.
type TypeBasicCompressionReadSettings string

const (
	// TypeCompressionReadSettings ...
	TypeCompressionReadSettings TypeBasicCompressionReadSettings = "CompressionReadSettings"
	// TypeZipDeflateReadSettings ...
	TypeZipDeflateReadSettings TypeBasicCompressionReadSettings = "ZipDeflateReadSettings"
)

// PossibleTypeBasicCompressionReadSettingsValues returns an array of possible values for the TypeBasicCompressionReadSettings const type.
func PossibleTypeBasicCompressionReadSettingsValues() []TypeBasicCompressionReadSettings {
	return []TypeBasicCompressionReadSettings{TypeCompressionReadSettings, TypeZipDeflateReadSettings}
}

// TypeBasicCopySink enumerates the values for type basic copy sink.
type TypeBasicCopySink string

const (
	// TypeAvroSink ...
	TypeAvroSink TypeBasicCopySink = "AvroSink"
	// TypeAzureBlobFSSink ...
	TypeAzureBlobFSSink TypeBasicCopySink = "AzureBlobFSSink"
	// TypeAzureDataExplorerSink ...
	TypeAzureDataExplorerSink TypeBasicCopySink = "AzureDataExplorerSink"
	// TypeAzureDataLakeStoreSink ...
	TypeAzureDataLakeStoreSink TypeBasicCopySink = "AzureDataLakeStoreSink"
	// TypeAzureMySQLSink ...
	TypeAzureMySQLSink TypeBasicCopySink = "AzureMySqlSink"
	// TypeAzurePostgreSQLSink ...
	TypeAzurePostgreSQLSink TypeBasicCopySink = "AzurePostgreSqlSink"
	// TypeAzureQueueSink ...
	TypeAzureQueueSink TypeBasicCopySink = "AzureQueueSink"
	// TypeAzureSearchIndexSink ...
	TypeAzureSearchIndexSink TypeBasicCopySink = "AzureSearchIndexSink"
	// TypeAzureSQLSink ...
	TypeAzureSQLSink TypeBasicCopySink = "AzureSqlSink"
	// TypeAzureTableSink ...
	TypeAzureTableSink TypeBasicCopySink = "AzureTableSink"
	// TypeBinarySink ...
	TypeBinarySink TypeBasicCopySink = "BinarySink"
	// TypeBlobSink ...
	TypeBlobSink TypeBasicCopySink = "BlobSink"
	// TypeCommonDataServiceForAppsSink ...
	TypeCommonDataServiceForAppsSink TypeBasicCopySink = "CommonDataServiceForAppsSink"
	// TypeCopySink ...
	TypeCopySink TypeBasicCopySink = "CopySink"
	// TypeCosmosDbMongoDbAPISink ...
	TypeCosmosDbMongoDbAPISink TypeBasicCopySink = "CosmosDbMongoDbApiSink"
	// TypeCosmosDbSQLAPISink ...
	TypeCosmosDbSQLAPISink TypeBasicCopySink = "CosmosDbSqlApiSink"
	// TypeDelimitedTextSink ...
	TypeDelimitedTextSink TypeBasicCopySink = "DelimitedTextSink"
	// TypeDocumentDbCollectionSink ...
	TypeDocumentDbCollectionSink TypeBasicCopySink = "DocumentDbCollectionSink"
	// TypeDynamicsCrmSink ...
	TypeDynamicsCrmSink TypeBasicCopySink = "DynamicsCrmSink"
	// TypeDynamicsSink ...
	TypeDynamicsSink TypeBasicCopySink = "DynamicsSink"
	// TypeFileSystemSink ...
	TypeFileSystemSink TypeBasicCopySink = "FileSystemSink"
	// TypeInformixSink ...
	TypeInformixSink TypeBasicCopySink = "InformixSink"
	// TypeJSONSink ...
	TypeJSONSink TypeBasicCopySink = "JsonSink"
	// TypeMicrosoftAccessSink ...
	TypeMicrosoftAccessSink TypeBasicCopySink = "MicrosoftAccessSink"
	// TypeOdbcSink ...
	TypeOdbcSink TypeBasicCopySink = "OdbcSink"
	// TypeOracleSink ...
	TypeOracleSink TypeBasicCopySink = "OracleSink"
	// TypeOrcSink ...
	TypeOrcSink TypeBasicCopySink = "OrcSink"
	// TypeParquetSink ...
	TypeParquetSink TypeBasicCopySink = "ParquetSink"
	// TypeSalesforceServiceCloudSink ...
	TypeSalesforceServiceCloudSink TypeBasicCopySink = "SalesforceServiceCloudSink"
	// TypeSalesforceSink ...
	TypeSalesforceSink TypeBasicCopySink = "SalesforceSink"
	// TypeSapCloudForCustomerSink ...
	TypeSapCloudForCustomerSink TypeBasicCopySink = "SapCloudForCustomerSink"
	// TypeSnowflakeSink ...
	TypeSnowflakeSink TypeBasicCopySink = "SnowflakeSink"
	// TypeSQLDWSink ...
	TypeSQLDWSink TypeBasicCopySink = "SqlDWSink"
	// TypeSQLMISink ...
	TypeSQLMISink TypeBasicCopySink = "SqlMISink"
	// TypeSQLServerSink ...
	TypeSQLServerSink TypeBasicCopySink = "SqlServerSink"
	// TypeSQLSink ...
	TypeSQLSink TypeBasicCopySink = "SqlSink"
)

// PossibleTypeBasicCopySinkValues returns an array of possible values for the TypeBasicCopySink const type.
func PossibleTypeBasicCopySinkValues() []TypeBasicCopySink {
	return []TypeBasicCopySink{TypeAvroSink, TypeAzureBlobFSSink, TypeAzureDataExplorerSink, TypeAzureDataLakeStoreSink, TypeAzureMySQLSink, TypeAzurePostgreSQLSink, TypeAzureQueueSink, TypeAzureSearchIndexSink, TypeAzureSQLSink, TypeAzureTableSink, TypeBinarySink, TypeBlobSink, TypeCommonDataServiceForAppsSink, TypeCopySink, TypeCosmosDbMongoDbAPISink, TypeCosmosDbSQLAPISink, TypeDelimitedTextSink, TypeDocumentDbCollectionSink, TypeDynamicsCrmSink, TypeDynamicsSink, TypeFileSystemSink, TypeInformixSink, TypeJSONSink, TypeMicrosoftAccessSink, TypeOdbcSink, TypeOracleSink, TypeOrcSink, TypeParquetSink, TypeSalesforceServiceCloudSink, TypeSalesforceSink, TypeSapCloudForCustomerSink, TypeSnowflakeSink, TypeSQLDWSink, TypeSQLMISink, TypeSQLServerSink, TypeSQLSink}
}

// TypeBasicCopySource enumerates the values for type basic copy source.
type TypeBasicCopySource string

const (
	// TypeAmazonMWSSource ...
	TypeAmazonMWSSource TypeBasicCopySource = "AmazonMWSSource"
	// TypeAmazonRedshiftSource ...
	TypeAmazonRedshiftSource TypeBasicCopySource = "AmazonRedshiftSource"
	// TypeAvroSource ...
	TypeAvroSource TypeBasicCopySource = "AvroSource"
	// TypeAzureBlobFSSource ...
	TypeAzureBlobFSSource TypeBasicCopySource = "AzureBlobFSSource"
	// TypeAzureDataExplorerSource ...
	TypeAzureDataExplorerSource TypeBasicCopySource = "AzureDataExplorerSource"
	// TypeAzureDataLakeStoreSource ...
	TypeAzureDataLakeStoreSource TypeBasicCopySource = "AzureDataLakeStoreSource"
	// TypeAzureMariaDBSource ...
	TypeAzureMariaDBSource TypeBasicCopySource = "AzureMariaDBSource"
	// TypeAzureMySQLSource ...
	TypeAzureMySQLSource TypeBasicCopySource = "AzureMySqlSource"
	// TypeAzurePostgreSQLSource ...
	TypeAzurePostgreSQLSource TypeBasicCopySource = "AzurePostgreSqlSource"
	// TypeAzureSQLSource ...
	TypeAzureSQLSource TypeBasicCopySource = "AzureSqlSource"
	// TypeAzureTableSource ...
	TypeAzureTableSource TypeBasicCopySource = "AzureTableSource"
	// TypeBinarySource ...
	TypeBinarySource TypeBasicCopySource = "BinarySource"
	// TypeBlobSource ...
	TypeBlobSource TypeBasicCopySource = "BlobSource"
	// TypeCassandraSource ...
	TypeCassandraSource TypeBasicCopySource = "CassandraSource"
	// TypeCommonDataServiceForAppsSource ...
	TypeCommonDataServiceForAppsSource TypeBasicCopySource = "CommonDataServiceForAppsSource"
	// TypeConcurSource ...
	TypeConcurSource TypeBasicCopySource = "ConcurSource"
	// TypeCopySource ...
	TypeCopySource TypeBasicCopySource = "CopySource"
	// TypeCosmosDbMongoDbAPISource ...
	TypeCosmosDbMongoDbAPISource TypeBasicCopySource = "CosmosDbMongoDbApiSource"
	// TypeCosmosDbSQLAPISource ...
	TypeCosmosDbSQLAPISource TypeBasicCopySource = "CosmosDbSqlApiSource"
	// TypeCouchbaseSource ...
	TypeCouchbaseSource TypeBasicCopySource = "CouchbaseSource"
	// TypeDb2Source ...
	TypeDb2Source TypeBasicCopySource = "Db2Source"
	// TypeDelimitedTextSource ...
	TypeDelimitedTextSource TypeBasicCopySource = "DelimitedTextSource"
	// TypeDocumentDbCollectionSource ...
	TypeDocumentDbCollectionSource TypeBasicCopySource = "DocumentDbCollectionSource"
	// TypeDrillSource ...
	TypeDrillSource TypeBasicCopySource = "DrillSource"
	// TypeDynamicsAXSource ...
	TypeDynamicsAXSource TypeBasicCopySource = "DynamicsAXSource"
	// TypeDynamicsCrmSource ...
	TypeDynamicsCrmSource TypeBasicCopySource = "DynamicsCrmSource"
	// TypeDynamicsSource ...
	TypeDynamicsSource TypeBasicCopySource = "DynamicsSource"
	// TypeEloquaSource ...
	TypeEloquaSource TypeBasicCopySource = "EloquaSource"
	// TypeExcelSource ...
	TypeExcelSource TypeBasicCopySource = "ExcelSource"
	// TypeFileSystemSource ...
	TypeFileSystemSource TypeBasicCopySource = "FileSystemSource"
	// TypeGoogleAdWordsSource ...
	TypeGoogleAdWordsSource TypeBasicCopySource = "GoogleAdWordsSource"
	// TypeGoogleBigQuerySource ...
	TypeGoogleBigQuerySource TypeBasicCopySource = "GoogleBigQuerySource"
	// TypeGreenplumSource ...
	TypeGreenplumSource TypeBasicCopySource = "GreenplumSource"
	// TypeHBaseSource ...
	TypeHBaseSource TypeBasicCopySource = "HBaseSource"
	// TypeHdfsSource ...
	TypeHdfsSource TypeBasicCopySource = "HdfsSource"
	// TypeHiveSource ...
	TypeHiveSource TypeBasicCopySource = "HiveSource"
	// TypeHTTPSource ...
	TypeHTTPSource TypeBasicCopySource = "HttpSource"
	// TypeHubspotSource ...
	TypeHubspotSource TypeBasicCopySource = "HubspotSource"
	// TypeImpalaSource ...
	TypeImpalaSource TypeBasicCopySource = "ImpalaSource"
	// TypeInformixSource ...
	TypeInformixSource TypeBasicCopySource = "InformixSource"
	// TypeJiraSource ...
	TypeJiraSource TypeBasicCopySource = "JiraSource"
	// TypeJSONSource ...
	TypeJSONSource TypeBasicCopySource = "JsonSource"
	// TypeMagentoSource ...
	TypeMagentoSource TypeBasicCopySource = "MagentoSource"
	// TypeMariaDBSource ...
	TypeMariaDBSource TypeBasicCopySource = "MariaDBSource"
	// TypeMarketoSource ...
	TypeMarketoSource TypeBasicCopySource = "MarketoSource"
	// TypeMicrosoftAccessSource ...
	TypeMicrosoftAccessSource TypeBasicCopySource = "MicrosoftAccessSource"
	// TypeMongoDbSource ...
	TypeMongoDbSource TypeBasicCopySource = "MongoDbSource"
	// TypeMongoDbV2Source ...
	TypeMongoDbV2Source TypeBasicCopySource = "MongoDbV2Source"
	// TypeMySQLSource ...
	TypeMySQLSource TypeBasicCopySource = "MySqlSource"
	// TypeNetezzaSource ...
	TypeNetezzaSource TypeBasicCopySource = "NetezzaSource"
	// TypeODataSource ...
	TypeODataSource TypeBasicCopySource = "ODataSource"
	// TypeOdbcSource ...
	TypeOdbcSource TypeBasicCopySource = "OdbcSource"
	// TypeOffice365Source ...
	TypeOffice365Source TypeBasicCopySource = "Office365Source"
	// TypeOracleServiceCloudSource ...
	TypeOracleServiceCloudSource TypeBasicCopySource = "OracleServiceCloudSource"
	// TypeOracleSource ...
	TypeOracleSource TypeBasicCopySource = "OracleSource"
	// TypeOrcSource ...
	TypeOrcSource TypeBasicCopySource = "OrcSource"
	// TypeParquetSource ...
	TypeParquetSource TypeBasicCopySource = "ParquetSource"
	// TypePaypalSource ...
	TypePaypalSource TypeBasicCopySource = "PaypalSource"
	// TypePhoenixSource ...
	TypePhoenixSource TypeBasicCopySource = "PhoenixSource"
	// TypePostgreSQLSource ...
	TypePostgreSQLSource TypeBasicCopySource = "PostgreSqlSource"
	// TypePrestoSource ...
	TypePrestoSource TypeBasicCopySource = "PrestoSource"
	// TypeQuickBooksSource ...
	TypeQuickBooksSource TypeBasicCopySource = "QuickBooksSource"
	// TypeRelationalSource ...
	TypeRelationalSource TypeBasicCopySource = "RelationalSource"
	// TypeResponsysSource ...
	TypeResponsysSource TypeBasicCopySource = "ResponsysSource"
	// TypeRestSource ...
	TypeRestSource TypeBasicCopySource = "RestSource"
	// TypeSalesforceMarketingCloudSource ...
	TypeSalesforceMarketingCloudSource TypeBasicCopySource = "SalesforceMarketingCloudSource"
	// TypeSalesforceServiceCloudSource ...
	TypeSalesforceServiceCloudSource TypeBasicCopySource = "SalesforceServiceCloudSource"
	// TypeSalesforceSource ...
	TypeSalesforceSource TypeBasicCopySource = "SalesforceSource"
	// TypeSapBwSource ...
	TypeSapBwSource TypeBasicCopySource = "SapBwSource"
	// TypeSapCloudForCustomerSource ...
	TypeSapCloudForCustomerSource TypeBasicCopySource = "SapCloudForCustomerSource"
	// TypeSapEccSource ...
	TypeSapEccSource TypeBasicCopySource = "SapEccSource"
	// TypeSapHanaSource ...
	TypeSapHanaSource TypeBasicCopySource = "SapHanaSource"
	// TypeSapOpenHubSource ...
	TypeSapOpenHubSource TypeBasicCopySource = "SapOpenHubSource"
	// TypeSapTableSource ...
	TypeSapTableSource TypeBasicCopySource = "SapTableSource"
	// TypeServiceNowSource ...
	TypeServiceNowSource TypeBasicCopySource = "ServiceNowSource"
	// TypeSharePointOnlineListSource ...
	TypeSharePointOnlineListSource TypeBasicCopySource = "SharePointOnlineListSource"
	// TypeShopifySource ...
	TypeShopifySource TypeBasicCopySource = "ShopifySource"
	// TypeSnowflakeSource ...
	TypeSnowflakeSource TypeBasicCopySource = "SnowflakeSource"
	// TypeSparkSource ...
	TypeSparkSource TypeBasicCopySource = "SparkSource"
	// TypeSQLDWSource ...
	TypeSQLDWSource TypeBasicCopySource = "SqlDWSource"
	// TypeSQLMISource ...
	TypeSQLMISource TypeBasicCopySource = "SqlMISource"
	// TypeSQLServerSource ...
	TypeSQLServerSource TypeBasicCopySource = "SqlServerSource"
	// TypeSQLSource ...
	TypeSQLSource TypeBasicCopySource = "SqlSource"
	// TypeSquareSource ...
	TypeSquareSource TypeBasicCopySource = "SquareSource"
	// TypeSybaseSource ...
	TypeSybaseSource TypeBasicCopySource = "SybaseSource"
	// TypeTabularSource ...
	TypeTabularSource TypeBasicCopySource = "TabularSource"
	// TypeTeradataSource ...
	TypeTeradataSource TypeBasicCopySource = "TeradataSource"
	// TypeVerticaSource ...
	TypeVerticaSource TypeBasicCopySource = "VerticaSource"
	// TypeWebSource ...
	TypeWebSource TypeBasicCopySource = "WebSource"
	// TypeXeroSource ...
	TypeXeroSource TypeBasicCopySource = "XeroSource"
	// TypeXMLSource ...
	TypeXMLSource TypeBasicCopySource = "XmlSource"
	// TypeZohoSource ...
	TypeZohoSource TypeBasicCopySource = "ZohoSource"
)

// PossibleTypeBasicCopySourceValues returns an array of possible values for the TypeBasicCopySource const type.
func PossibleTypeBasicCopySourceValues() []TypeBasicCopySource {
	return []TypeBasicCopySource{TypeAmazonMWSSource, TypeAmazonRedshiftSource, TypeAvroSource, TypeAzureBlobFSSource, TypeAzureDataExplorerSource, TypeAzureDataLakeStoreSource, TypeAzureMariaDBSource, TypeAzureMySQLSource, TypeAzurePostgreSQLSource, TypeAzureSQLSource, TypeAzureTableSource, TypeBinarySource, TypeBlobSource, TypeCassandraSource, TypeCommonDataServiceForAppsSource, TypeConcurSource, TypeCopySource, TypeCosmosDbMongoDbAPISource, TypeCosmosDbSQLAPISource, TypeCouchbaseSource, TypeDb2Source, TypeDelimitedTextSource, TypeDocumentDbCollectionSource, TypeDrillSource, TypeDynamicsAXSource, TypeDynamicsCrmSource, TypeDynamicsSource, TypeEloquaSource, TypeExcelSource, TypeFileSystemSource, TypeGoogleAdWordsSource, TypeGoogleBigQuerySource, TypeGreenplumSource, TypeHBaseSource, TypeHdfsSource, TypeHiveSource, TypeHTTPSource, TypeHubspotSource, TypeImpalaSource, TypeInformixSource, TypeJiraSource, TypeJSONSource, TypeMagentoSource, TypeMariaDBSource, TypeMarketoSource, TypeMicrosoftAccessSource, TypeMongoDbSource, TypeMongoDbV2Source, TypeMySQLSource, TypeNetezzaSource, TypeODataSource, TypeOdbcSource, TypeOffice365Source, TypeOracleServiceCloudSource, TypeOracleSource, TypeOrcSource, TypeParquetSource, TypePaypalSource, TypePhoenixSource, TypePostgreSQLSource, TypePrestoSource, TypeQuickBooksSource, TypeRelationalSource, TypeResponsysSource, TypeRestSource, TypeSalesforceMarketingCloudSource, TypeSalesforceServiceCloudSource, TypeSalesforceSource, TypeSapBwSource, TypeSapCloudForCustomerSource, TypeSapEccSource, TypeSapHanaSource, TypeSapOpenHubSource, TypeSapTableSource, TypeServiceNowSource, TypeSharePointOnlineListSource, TypeShopifySource, TypeSnowflakeSource, TypeSparkSource, TypeSQLDWSource, TypeSQLMISource, TypeSQLServerSource, TypeSQLSource, TypeSquareSource, TypeSybaseSource, TypeTabularSource, TypeTeradataSource, TypeVerticaSource, TypeWebSource, TypeXeroSource, TypeXMLSource, TypeZohoSource}
}

// TypeBasicCustomSetupBase enumerates the values for type basic custom setup base.
type TypeBasicCustomSetupBase string

const (
	// TypeCmdkeySetup ...
	TypeCmdkeySetup TypeBasicCustomSetupBase = "CmdkeySetup"
	// TypeComponentSetup ...
	TypeComponentSetup TypeBasicCustomSetupBase = "ComponentSetup"
	// TypeCustomSetupBase ...
	TypeCustomSetupBase TypeBasicCustomSetupBase = "CustomSetupBase"
	// TypeEnvironmentVariableSetup ...
	TypeEnvironmentVariableSetup TypeBasicCustomSetupBase = "EnvironmentVariableSetup"
)

// PossibleTypeBasicCustomSetupBaseValues returns an array of possible values for the TypeBasicCustomSetupBase const type.
func PossibleTypeBasicCustomSetupBaseValues() []TypeBasicCustomSetupBase {
	return []TypeBasicCustomSetupBase{TypeCmdkeySetup, TypeComponentSetup, TypeCustomSetupBase, TypeEnvironmentVariableSetup}
}

// TypeBasicDataFlow enumerates the values for type basic data flow.
type TypeBasicDataFlow string

const (
	// TypeDataFlow ...
	TypeDataFlow TypeBasicDataFlow = "DataFlow"
	// TypeMappingDataFlow ...
	TypeMappingDataFlow TypeBasicDataFlow = "MappingDataFlow"
)

// PossibleTypeBasicDataFlowValues returns an array of possible values for the TypeBasicDataFlow const type.
func PossibleTypeBasicDataFlowValues() []TypeBasicDataFlow {
	return []TypeBasicDataFlow{TypeDataFlow, TypeMappingDataFlow}
}

// TypeBasicDataset enumerates the values for type basic dataset.
type TypeBasicDataset string

const (
	// TypeAmazonMWSObject ...
	TypeAmazonMWSObject TypeBasicDataset = "AmazonMWSObject"
	// TypeAmazonRedshiftTable ...
	TypeAmazonRedshiftTable TypeBasicDataset = "AmazonRedshiftTable"
	// TypeAmazonS3Object ...
	TypeAmazonS3Object TypeBasicDataset = "AmazonS3Object"
	// TypeAvro ...
	TypeAvro TypeBasicDataset = "Avro"
	// TypeAzureBlob ...
	TypeAzureBlob TypeBasicDataset = "AzureBlob"
	// TypeAzureBlobFSFile ...
	TypeAzureBlobFSFile TypeBasicDataset = "AzureBlobFSFile"
	// TypeAzureDataExplorerTable ...
	TypeAzureDataExplorerTable TypeBasicDataset = "AzureDataExplorerTable"
	// TypeAzureDataLakeStoreFile ...
	TypeAzureDataLakeStoreFile TypeBasicDataset = "AzureDataLakeStoreFile"
	// TypeAzureMariaDBTable ...
	TypeAzureMariaDBTable TypeBasicDataset = "AzureMariaDBTable"
	// TypeAzureMySQLTable ...
	TypeAzureMySQLTable TypeBasicDataset = "AzureMySqlTable"
	// TypeAzurePostgreSQLTable ...
	TypeAzurePostgreSQLTable TypeBasicDataset = "AzurePostgreSqlTable"
	// TypeAzureSearchIndex ...
	TypeAzureSearchIndex TypeBasicDataset = "AzureSearchIndex"
	// TypeAzureSQLDWTable ...
	TypeAzureSQLDWTable TypeBasicDataset = "AzureSqlDWTable"
	// TypeAzureSQLMITable ...
	TypeAzureSQLMITable TypeBasicDataset = "AzureSqlMITable"
	// TypeAzureSQLTable ...
	TypeAzureSQLTable TypeBasicDataset = "AzureSqlTable"
	// TypeAzureTable ...
	TypeAzureTable TypeBasicDataset = "AzureTable"
	// TypeBinary ...
	TypeBinary TypeBasicDataset = "Binary"
	// TypeCassandraTable ...
	TypeCassandraTable TypeBasicDataset = "CassandraTable"
	// TypeCommonDataServiceForAppsEntity ...
	TypeCommonDataServiceForAppsEntity TypeBasicDataset = "CommonDataServiceForAppsEntity"
	// TypeConcurObject ...
	TypeConcurObject TypeBasicDataset = "ConcurObject"
	// TypeCosmosDbMongoDbAPICollection ...
	TypeCosmosDbMongoDbAPICollection TypeBasicDataset = "CosmosDbMongoDbApiCollection"
	// TypeCosmosDbSQLAPICollection ...
	TypeCosmosDbSQLAPICollection TypeBasicDataset = "CosmosDbSqlApiCollection"
	// TypeCouchbaseTable ...
	TypeCouchbaseTable TypeBasicDataset = "CouchbaseTable"
	// TypeCustomDataset ...
	TypeCustomDataset TypeBasicDataset = "CustomDataset"
	// TypeDataset ...
	TypeDataset TypeBasicDataset = "Dataset"
	// TypeDb2Table ...
	TypeDb2Table TypeBasicDataset = "Db2Table"
	// TypeDelimitedText ...
	TypeDelimitedText TypeBasicDataset = "DelimitedText"
	// TypeDocumentDbCollection ...
	TypeDocumentDbCollection TypeBasicDataset = "DocumentDbCollection"
	// TypeDrillTable ...
	TypeDrillTable TypeBasicDataset = "DrillTable"
	// TypeDynamicsAXResource ...
	TypeDynamicsAXResource TypeBasicDataset = "DynamicsAXResource"
	// TypeDynamicsCrmEntity ...
	TypeDynamicsCrmEntity TypeBasicDataset = "DynamicsCrmEntity"
	// TypeDynamicsEntity ...
	TypeDynamicsEntity TypeBasicDataset = "DynamicsEntity"
	// TypeEloquaObject ...
	TypeEloquaObject TypeBasicDataset = "EloquaObject"
	// TypeExcel ...
	TypeExcel TypeBasicDataset = "Excel"
	// TypeFileShare ...
	TypeFileShare TypeBasicDataset = "FileShare"
	// TypeGoogleAdWordsObject ...
	TypeGoogleAdWordsObject TypeBasicDataset = "GoogleAdWordsObject"
	// TypeGoogleBigQueryObject ...
	TypeGoogleBigQueryObject TypeBasicDataset = "GoogleBigQueryObject"
	// TypeGreenplumTable ...
	TypeGreenplumTable TypeBasicDataset = "GreenplumTable"
	// TypeHBaseObject ...
	TypeHBaseObject TypeBasicDataset = "HBaseObject"
	// TypeHiveObject ...
	TypeHiveObject TypeBasicDataset = "HiveObject"
	// TypeHTTPFile ...
	TypeHTTPFile TypeBasicDataset = "HttpFile"
	// TypeHubspotObject ...
	TypeHubspotObject TypeBasicDataset = "HubspotObject"
	// TypeImpalaObject ...
	TypeImpalaObject TypeBasicDataset = "ImpalaObject"
	// TypeInformixTable ...
	TypeInformixTable TypeBasicDataset = "InformixTable"
	// TypeJiraObject ...
	TypeJiraObject TypeBasicDataset = "JiraObject"
	// TypeJSON ...
	TypeJSON TypeBasicDataset = "Json"
	// TypeMagentoObject ...
	TypeMagentoObject TypeBasicDataset = "MagentoObject"
	// TypeMariaDBTable ...
	TypeMariaDBTable TypeBasicDataset = "MariaDBTable"
	// TypeMarketoObject ...
	TypeMarketoObject TypeBasicDataset = "MarketoObject"
	// TypeMicrosoftAccessTable ...
	TypeMicrosoftAccessTable TypeBasicDataset = "MicrosoftAccessTable"
	// TypeMongoDbCollection ...
	TypeMongoDbCollection TypeBasicDataset = "MongoDbCollection"
	// TypeMongoDbV2Collection ...
	TypeMongoDbV2Collection TypeBasicDataset = "MongoDbV2Collection"
	// TypeMySQLTable ...
	TypeMySQLTable TypeBasicDataset = "MySqlTable"
	// TypeNetezzaTable ...
	TypeNetezzaTable TypeBasicDataset = "NetezzaTable"
	// TypeODataResource ...
	TypeODataResource TypeBasicDataset = "ODataResource"
	// TypeOdbcTable ...
	TypeOdbcTable TypeBasicDataset = "OdbcTable"
	// TypeOffice365Table ...
	TypeOffice365Table TypeBasicDataset = "Office365Table"
	// TypeOracleServiceCloudObject ...
	TypeOracleServiceCloudObject TypeBasicDataset = "OracleServiceCloudObject"
	// TypeOracleTable ...
	TypeOracleTable TypeBasicDataset = "OracleTable"
	// TypeOrc ...
	TypeOrc TypeBasicDataset = "Orc"
	// TypeParquet ...
	TypeParquet TypeBasicDataset = "Parquet"
	// TypePaypalObject ...
	TypePaypalObject TypeBasicDataset = "PaypalObject"
	// TypePhoenixObject ...
	TypePhoenixObject TypeBasicDataset = "PhoenixObject"
	// TypePostgreSQLTable ...
	TypePostgreSQLTable TypeBasicDataset = "PostgreSqlTable"
	// TypePrestoObject ...
	TypePrestoObject TypeBasicDataset = "PrestoObject"
	// TypeQuickBooksObject ...
	TypeQuickBooksObject TypeBasicDataset = "QuickBooksObject"
	// TypeRelationalTable ...
	TypeRelationalTable TypeBasicDataset = "RelationalTable"
	// TypeResponsysObject ...
	TypeResponsysObject TypeBasicDataset = "ResponsysObject"
	// TypeRestResource ...
	TypeRestResource TypeBasicDataset = "RestResource"
	// TypeSalesforceMarketingCloudObject ...
	TypeSalesforceMarketingCloudObject TypeBasicDataset = "SalesforceMarketingCloudObject"
	// TypeSalesforceObject ...
	TypeSalesforceObject TypeBasicDataset = "SalesforceObject"
	// TypeSalesforceServiceCloudObject ...
	TypeSalesforceServiceCloudObject TypeBasicDataset = "SalesforceServiceCloudObject"
	// TypeSapBwCube ...
	TypeSapBwCube TypeBasicDataset = "SapBwCube"
	// TypeSapCloudForCustomerResource ...
	TypeSapCloudForCustomerResource TypeBasicDataset = "SapCloudForCustomerResource"
	// TypeSapEccResource ...
	TypeSapEccResource TypeBasicDataset = "SapEccResource"
	// TypeSapHanaTable ...
	TypeSapHanaTable TypeBasicDataset = "SapHanaTable"
	// TypeSapOpenHubTable ...
	TypeSapOpenHubTable TypeBasicDataset = "SapOpenHubTable"
	// TypeSapTableResource ...
	TypeSapTableResource TypeBasicDataset = "SapTableResource"
	// TypeServiceNowObject ...
	TypeServiceNowObject TypeBasicDataset = "ServiceNowObject"
	// TypeSharePointOnlineListResource ...
	TypeSharePointOnlineListResource TypeBasicDataset = "SharePointOnlineListResource"
	// TypeShopifyObject ...
	TypeShopifyObject TypeBasicDataset = "ShopifyObject"
	// TypeSnowflakeTable ...
	TypeSnowflakeTable TypeBasicDataset = "SnowflakeTable"
	// TypeSparkObject ...
	TypeSparkObject TypeBasicDataset = "SparkObject"
	// TypeSQLServerTable ...
	TypeSQLServerTable TypeBasicDataset = "SqlServerTable"
	// TypeSquareObject ...
	TypeSquareObject TypeBasicDataset = "SquareObject"
	// TypeSybaseTable ...
	TypeSybaseTable TypeBasicDataset = "SybaseTable"
	// TypeTeradataTable ...
	TypeTeradataTable TypeBasicDataset = "TeradataTable"
	// TypeVerticaTable ...
	TypeVerticaTable TypeBasicDataset = "VerticaTable"
	// TypeWebTable ...
	TypeWebTable TypeBasicDataset = "WebTable"
	// TypeXeroObject ...
	TypeXeroObject TypeBasicDataset = "XeroObject"
	// TypeXML ...
	TypeXML TypeBasicDataset = "Xml"
	// TypeZohoObject ...
	TypeZohoObject TypeBasicDataset = "ZohoObject"
)

// PossibleTypeBasicDatasetValues returns an array of possible values for the TypeBasicDataset const type.
func PossibleTypeBasicDatasetValues() []TypeBasicDataset {
	return []TypeBasicDataset{TypeAmazonMWSObject, TypeAmazonRedshiftTable, TypeAmazonS3Object, TypeAvro, TypeAzureBlob, TypeAzureBlobFSFile, TypeAzureDataExplorerTable, TypeAzureDataLakeStoreFile, TypeAzureMariaDBTable, TypeAzureMySQLTable, TypeAzurePostgreSQLTable, TypeAzureSearchIndex, TypeAzureSQLDWTable, TypeAzureSQLMITable, TypeAzureSQLTable, TypeAzureTable, TypeBinary, TypeCassandraTable, TypeCommonDataServiceForAppsEntity, TypeConcurObject, TypeCosmosDbMongoDbAPICollection, TypeCosmosDbSQLAPICollection, TypeCouchbaseTable, TypeCustomDataset, TypeDataset, TypeDb2Table, TypeDelimitedText, TypeDocumentDbCollection, TypeDrillTable, TypeDynamicsAXResource, TypeDynamicsCrmEntity, TypeDynamicsEntity, TypeEloquaObject, TypeExcel, TypeFileShare, TypeGoogleAdWordsObject, TypeGoogleBigQueryObject, TypeGreenplumTable, TypeHBaseObject, TypeHiveObject, TypeHTTPFile, TypeHubspotObject, TypeImpalaObject, TypeInformixTable, TypeJiraObject, TypeJSON, TypeMagentoObject, TypeMariaDBTable, TypeMarketoObject, TypeMicrosoftAccessTable, TypeMongoDbCollection, TypeMongoDbV2Collection, TypeMySQLTable, TypeNetezzaTable, TypeODataResource, TypeOdbcTable, TypeOffice365Table, TypeOracleServiceCloudObject, TypeOracleTable, TypeOrc, TypeParquet, TypePaypalObject, TypePhoenixObject, TypePostgreSQLTable, TypePrestoObject, TypeQuickBooksObject, TypeRelationalTable, TypeResponsysObject, TypeRestResource, TypeSalesforceMarketingCloudObject, TypeSalesforceObject, TypeSalesforceServiceCloudObject, TypeSapBwCube, TypeSapCloudForCustomerResource, TypeSapEccResource, TypeSapHanaTable, TypeSapOpenHubTable, TypeSapTableResource, TypeServiceNowObject, TypeSharePointOnlineListResource, TypeShopifyObject, TypeSnowflakeTable, TypeSparkObject, TypeSQLServerTable, TypeSquareObject, TypeSybaseTable, TypeTeradataTable, TypeVerticaTable, TypeWebTable, TypeXeroObject, TypeXML, TypeZohoObject}
}

// TypeBasicDatasetCompression enumerates the values for type basic dataset compression.
type TypeBasicDatasetCompression string

const (
	// TypeBZip2 ...
	TypeBZip2 TypeBasicDatasetCompression = "BZip2"
	// TypeDatasetCompression ...
	TypeDatasetCompression TypeBasicDatasetCompression = "DatasetCompression"
	// TypeDeflate ...
	TypeDeflate TypeBasicDatasetCompression = "Deflate"
	// TypeGZip ...
	TypeGZip TypeBasicDatasetCompression = "GZip"
	// TypeZipDeflate ...
	TypeZipDeflate TypeBasicDatasetCompression = "ZipDeflate"
)

// PossibleTypeBasicDatasetCompressionValues returns an array of possible values for the TypeBasicDatasetCompression const type.
func PossibleTypeBasicDatasetCompressionValues() []TypeBasicDatasetCompression {
	return []TypeBasicDatasetCompression{TypeBZip2, TypeDatasetCompression, TypeDeflate, TypeGZip, TypeZipDeflate}
}

// TypeBasicDatasetLocation enumerates the values for type basic dataset location.
type TypeBasicDatasetLocation string

const (
	// TypeAmazonS3Location ...
	TypeAmazonS3Location TypeBasicDatasetLocation = "AmazonS3Location"
	// TypeAzureBlobFSLocation ...
	TypeAzureBlobFSLocation TypeBasicDatasetLocation = "AzureBlobFSLocation"
	// TypeAzureBlobStorageLocation ...
	TypeAzureBlobStorageLocation TypeBasicDatasetLocation = "AzureBlobStorageLocation"
	// TypeAzureDataLakeStoreLocation ...
	TypeAzureDataLakeStoreLocation TypeBasicDatasetLocation = "AzureDataLakeStoreLocation"
	// TypeAzureFileStorageLocation ...
	TypeAzureFileStorageLocation TypeBasicDatasetLocation = "AzureFileStorageLocation"
	// TypeDatasetLocation ...
	TypeDatasetLocation TypeBasicDatasetLocation = "DatasetLocation"
	// TypeFileServerLocation ...
	TypeFileServerLocation TypeBasicDatasetLocation = "FileServerLocation"
	// TypeFtpServerLocation ...
	TypeFtpServerLocation TypeBasicDatasetLocation = "FtpServerLocation"
	// TypeGoogleCloudStorageLocation ...
	TypeGoogleCloudStorageLocation TypeBasicDatasetLocation = "GoogleCloudStorageLocation"
	// TypeHdfsLocation ...
	TypeHdfsLocation TypeBasicDatasetLocation = "HdfsLocation"
	// TypeHTTPServerLocation ...
	TypeHTTPServerLocation TypeBasicDatasetLocation = "HttpServerLocation"
	// TypeSftpLocation ...
	TypeSftpLocation TypeBasicDatasetLocation = "SftpLocation"
)

// PossibleTypeBasicDatasetLocationValues returns an array of possible values for the TypeBasicDatasetLocation const type.
func PossibleTypeBasicDatasetLocationValues() []TypeBasicDatasetLocation {
	return []TypeBasicDatasetLocation{TypeAmazonS3Location, TypeAzureBlobFSLocation, TypeAzureBlobStorageLocation, TypeAzureDataLakeStoreLocation, TypeAzureFileStorageLocation, TypeDatasetLocation, TypeFileServerLocation, TypeFtpServerLocation, TypeGoogleCloudStorageLocation, TypeHdfsLocation, TypeHTTPServerLocation, TypeSftpLocation}
}

// TypeBasicDatasetStorageFormat enumerates the values for type basic dataset storage format.
type TypeBasicDatasetStorageFormat string

const (
	// TypeAvroFormat ...
	TypeAvroFormat TypeBasicDatasetStorageFormat = "AvroFormat"
	// TypeDatasetStorageFormat ...
	TypeDatasetStorageFormat TypeBasicDatasetStorageFormat = "DatasetStorageFormat"
	// TypeJSONFormat ...
	TypeJSONFormat TypeBasicDatasetStorageFormat = "JsonFormat"
	// TypeOrcFormat ...
	TypeOrcFormat TypeBasicDatasetStorageFormat = "OrcFormat"
	// TypeParquetFormat ...
	TypeParquetFormat TypeBasicDatasetStorageFormat = "ParquetFormat"
	// TypeTextFormat ...
	TypeTextFormat TypeBasicDatasetStorageFormat = "TextFormat"
)

// PossibleTypeBasicDatasetStorageFormatValues returns an array of possible values for the TypeBasicDatasetStorageFormat const type.
func PossibleTypeBasicDatasetStorageFormatValues() []TypeBasicDatasetStorageFormat {
	return []TypeBasicDatasetStorageFormat{TypeAvroFormat, TypeDatasetStorageFormat, TypeJSONFormat, TypeOrcFormat, TypeParquetFormat, TypeTextFormat}
}

// TypeBasicDependencyReference enumerates the values for type basic dependency reference.
type TypeBasicDependencyReference string

const (
	// TypeDependencyReference ...
	TypeDependencyReference TypeBasicDependencyReference = "DependencyReference"
	// TypeSelfDependencyTumblingWindowTriggerReference ...
	TypeSelfDependencyTumblingWindowTriggerReference TypeBasicDependencyReference = "SelfDependencyTumblingWindowTriggerReference"
	// TypeTriggerDependencyReference ...
	TypeTriggerDependencyReference TypeBasicDependencyReference = "TriggerDependencyReference"
	// TypeTumblingWindowTriggerDependencyReference ...
	TypeTumblingWindowTriggerDependencyReference TypeBasicDependencyReference = "TumblingWindowTriggerDependencyReference"
)

// PossibleTypeBasicDependencyReferenceValues returns an array of possible values for the TypeBasicDependencyReference const type.
func PossibleTypeBasicDependencyReferenceValues() []TypeBasicDependencyReference {
	return []TypeBasicDependencyReference{TypeDependencyReference, TypeSelfDependencyTumblingWindowTriggerReference, TypeTriggerDependencyReference, TypeTumblingWindowTriggerDependencyReference}
}

// TypeBasicExportSettings enumerates the values for type basic export settings.
type TypeBasicExportSettings string

const (
	// TypeExportSettings ...
	TypeExportSettings TypeBasicExportSettings = "ExportSettings"
	// TypeSnowflakeExportCopyCommand ...
	TypeSnowflakeExportCopyCommand TypeBasicExportSettings = "SnowflakeExportCopyCommand"
)

// PossibleTypeBasicExportSettingsValues returns an array of possible values for the TypeBasicExportSettings const type.
func PossibleTypeBasicExportSettingsValues() []TypeBasicExportSettings {
	return []TypeBasicExportSettings{TypeExportSettings, TypeSnowflakeExportCopyCommand}
}

// TypeBasicFactoryRepoConfiguration enumerates the values for type basic factory repo configuration.
type TypeBasicFactoryRepoConfiguration string

const (
	// TypeFactoryGitHubConfiguration ...
	TypeFactoryGitHubConfiguration TypeBasicFactoryRepoConfiguration = "FactoryGitHubConfiguration"
	// TypeFactoryRepoConfiguration ...
	TypeFactoryRepoConfiguration TypeBasicFactoryRepoConfiguration = "FactoryRepoConfiguration"
	// TypeFactoryVSTSConfiguration ...
	TypeFactoryVSTSConfiguration TypeBasicFactoryRepoConfiguration = "FactoryVSTSConfiguration"
)

// PossibleTypeBasicFactoryRepoConfigurationValues returns an array of possible values for the TypeBasicFactoryRepoConfiguration const type.
func PossibleTypeBasicFactoryRepoConfigurationValues() []TypeBasicFactoryRepoConfiguration {
	return []TypeBasicFactoryRepoConfiguration{TypeFactoryGitHubConfiguration, TypeFactoryRepoConfiguration, TypeFactoryVSTSConfiguration}
}

// TypeBasicFormatReadSettings enumerates the values for type basic format read settings.
type TypeBasicFormatReadSettings string

const (
	// TypeBinaryReadSettings ...
	TypeBinaryReadSettings TypeBasicFormatReadSettings = "BinaryReadSettings"
	// TypeDelimitedTextReadSettings ...
	TypeDelimitedTextReadSettings TypeBasicFormatReadSettings = "DelimitedTextReadSettings"
	// TypeFormatReadSettings ...
	TypeFormatReadSettings TypeBasicFormatReadSettings = "FormatReadSettings"
	// TypeJSONReadSettings ...
	TypeJSONReadSettings TypeBasicFormatReadSettings = "JsonReadSettings"
	// TypeXMLReadSettings ...
	TypeXMLReadSettings TypeBasicFormatReadSettings = "XmlReadSettings"
)

// PossibleTypeBasicFormatReadSettingsValues returns an array of possible values for the TypeBasicFormatReadSettings const type.
func PossibleTypeBasicFormatReadSettingsValues() []TypeBasicFormatReadSettings {
	return []TypeBasicFormatReadSettings{TypeBinaryReadSettings, TypeDelimitedTextReadSettings, TypeFormatReadSettings, TypeJSONReadSettings, TypeXMLReadSettings}
}

// TypeBasicFormatWriteSettings enumerates the values for type basic format write settings.
type TypeBasicFormatWriteSettings string

const (
	// TypeAvroWriteSettings ...
	TypeAvroWriteSettings TypeBasicFormatWriteSettings = "AvroWriteSettings"
	// TypeDelimitedTextWriteSettings ...
	TypeDelimitedTextWriteSettings TypeBasicFormatWriteSettings = "DelimitedTextWriteSettings"
	// TypeFormatWriteSettings ...
	TypeFormatWriteSettings TypeBasicFormatWriteSettings = "FormatWriteSettings"
	// TypeJSONWriteSettings ...
	TypeJSONWriteSettings TypeBasicFormatWriteSettings = "JsonWriteSettings"
)

// PossibleTypeBasicFormatWriteSettingsValues returns an array of possible values for the TypeBasicFormatWriteSettings const type.
func PossibleTypeBasicFormatWriteSettingsValues() []TypeBasicFormatWriteSettings {
	return []TypeBasicFormatWriteSettings{TypeAvroWriteSettings, TypeDelimitedTextWriteSettings, TypeFormatWriteSettings, TypeJSONWriteSettings}
}

// TypeBasicImportSettings enumerates the values for type basic import settings.
type TypeBasicImportSettings string

const (
	// TypeImportSettings ...
	TypeImportSettings TypeBasicImportSettings = "ImportSettings"
	// TypeSnowflakeImportCopyCommand ...
	TypeSnowflakeImportCopyCommand TypeBasicImportSettings = "SnowflakeImportCopyCommand"
)

// PossibleTypeBasicImportSettingsValues returns an array of possible values for the TypeBasicImportSettings const type.
func PossibleTypeBasicImportSettingsValues() []TypeBasicImportSettings {
	return []TypeBasicImportSettings{TypeImportSettings, TypeSnowflakeImportCopyCommand}
}

// TypeBasicIntegrationRuntime enumerates the values for type basic integration runtime.
type TypeBasicIntegrationRuntime string

const (
	// TypeIntegrationRuntime ...
	TypeIntegrationRuntime TypeBasicIntegrationRuntime = "IntegrationRuntime"
	// TypeManaged ...
	TypeManaged TypeBasicIntegrationRuntime = "Managed"
	// TypeSelfHosted ...
	TypeSelfHosted TypeBasicIntegrationRuntime = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeValues returns an array of possible values for the TypeBasicIntegrationRuntime const type.
func PossibleTypeBasicIntegrationRuntimeValues() []TypeBasicIntegrationRuntime {
	return []TypeBasicIntegrationRuntime{TypeIntegrationRuntime, TypeManaged, TypeSelfHosted}
}

// TypeBasicIntegrationRuntimeStatus enumerates the values for type basic integration runtime status.
type TypeBasicIntegrationRuntimeStatus string

const (
	// TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus ...
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = "IntegrationRuntimeStatus"
	// TypeBasicIntegrationRuntimeStatusTypeManaged ...
	TypeBasicIntegrationRuntimeStatusTypeManaged TypeBasicIntegrationRuntimeStatus = "Managed"
	// TypeBasicIntegrationRuntimeStatusTypeSelfHosted ...
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted TypeBasicIntegrationRuntimeStatus = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeStatusValues returns an array of possible values for the TypeBasicIntegrationRuntimeStatus const type.
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return []TypeBasicIntegrationRuntimeStatus{TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus, TypeBasicIntegrationRuntimeStatusTypeManaged, TypeBasicIntegrationRuntimeStatusTypeSelfHosted}
}

// TypeBasicLinkedService enumerates the values for type basic linked service.
type TypeBasicLinkedService string

const (
	// TypeAmazonMWS ...
	TypeAmazonMWS TypeBasicLinkedService = "AmazonMWS"
	// TypeAmazonRedshift ...
	TypeAmazonRedshift TypeBasicLinkedService = "AmazonRedshift"
	// TypeAmazonS3 ...
	TypeAmazonS3 TypeBasicLinkedService = "AmazonS3"
	// TypeAzureBatch ...
	TypeAzureBatch TypeBasicLinkedService = "AzureBatch"
	// TypeAzureBlobFS ...
	TypeAzureBlobFS TypeBasicLinkedService = "AzureBlobFS"
	// TypeAzureBlobStorage ...
	TypeAzureBlobStorage TypeBasicLinkedService = "AzureBlobStorage"
	// TypeAzureDatabricks ...
	TypeAzureDatabricks TypeBasicLinkedService = "AzureDatabricks"
	// TypeAzureDataExplorer ...
	TypeAzureDataExplorer TypeBasicLinkedService = "AzureDataExplorer"
	// TypeAzureDataLakeAnalytics ...
	TypeAzureDataLakeAnalytics TypeBasicLinkedService = "AzureDataLakeAnalytics"
	// TypeAzureDataLakeStore ...
	TypeAzureDataLakeStore TypeBasicLinkedService = "AzureDataLakeStore"
	// TypeAzureFileStorage ...
	TypeAzureFileStorage TypeBasicLinkedService = "AzureFileStorage"
	// TypeAzureFunction ...
	TypeAzureFunction TypeBasicLinkedService = "AzureFunction"
	// TypeAzureKeyVault ...
	TypeAzureKeyVault TypeBasicLinkedService = "AzureKeyVault"
	// TypeAzureMariaDB ...
	TypeAzureMariaDB TypeBasicLinkedService = "AzureMariaDB"
	// TypeAzureML ...
	TypeAzureML TypeBasicLinkedService = "AzureML"
	// TypeAzureMLService ...
	TypeAzureMLService TypeBasicLinkedService = "AzureMLService"
	// TypeAzureMySQL ...
	TypeAzureMySQL TypeBasicLinkedService = "AzureMySql"
	// TypeAzurePostgreSQL ...
	TypeAzurePostgreSQL TypeBasicLinkedService = "AzurePostgreSql"
	// TypeAzureSearch ...
	TypeAzureSearch TypeBasicLinkedService = "AzureSearch"
	// TypeAzureSQLDatabase ...
	TypeAzureSQLDatabase TypeBasicLinkedService = "AzureSqlDatabase"
	// TypeAzureSQLDW ...
	TypeAzureSQLDW TypeBasicLinkedService = "AzureSqlDW"
	// TypeAzureSQLMI ...
	TypeAzureSQLMI TypeBasicLinkedService = "AzureSqlMI"
	// TypeAzureStorage ...
	TypeAzureStorage TypeBasicLinkedService = "AzureStorage"
	// TypeAzureTableStorage ...
	TypeAzureTableStorage TypeBasicLinkedService = "AzureTableStorage"
	// TypeCassandra ...
	TypeCassandra TypeBasicLinkedService = "Cassandra"
	// TypeCommonDataServiceForApps ...
	TypeCommonDataServiceForApps TypeBasicLinkedService = "CommonDataServiceForApps"
	// TypeConcur ...
	TypeConcur TypeBasicLinkedService = "Concur"
	// TypeCosmosDb ...
	TypeCosmosDb TypeBasicLinkedService = "CosmosDb"
	// TypeCosmosDbMongoDbAPI ...
	TypeCosmosDbMongoDbAPI TypeBasicLinkedService = "CosmosDbMongoDbApi"
	// TypeCouchbase ...
	TypeCouchbase TypeBasicLinkedService = "Couchbase"
	// TypeCustomDataSource ...
	TypeCustomDataSource TypeBasicLinkedService = "CustomDataSource"
	// TypeDb2 ...
	TypeDb2 TypeBasicLinkedService = "Db2"
	// TypeDrill ...
	TypeDrill TypeBasicLinkedService = "Drill"
	// TypeDynamics ...
	TypeDynamics TypeBasicLinkedService = "Dynamics"
	// TypeDynamicsAX ...
	TypeDynamicsAX TypeBasicLinkedService = "DynamicsAX"
	// TypeDynamicsCrm ...
	TypeDynamicsCrm TypeBasicLinkedService = "DynamicsCrm"
	// TypeEloqua ...
	TypeEloqua TypeBasicLinkedService = "Eloqua"
	// TypeFileServer ...
	TypeFileServer TypeBasicLinkedService = "FileServer"
	// TypeFtpServer ...
	TypeFtpServer TypeBasicLinkedService = "FtpServer"
	// TypeGoogleAdWords ...
	TypeGoogleAdWords TypeBasicLinkedService = "GoogleAdWords"
	// TypeGoogleBigQuery ...
	TypeGoogleBigQuery TypeBasicLinkedService = "GoogleBigQuery"
	// TypeGoogleCloudStorage ...
	TypeGoogleCloudStorage TypeBasicLinkedService = "GoogleCloudStorage"
	// TypeGreenplum ...
	TypeGreenplum TypeBasicLinkedService = "Greenplum"
	// TypeHBase ...
	TypeHBase TypeBasicLinkedService = "HBase"
	// TypeHdfs ...
	TypeHdfs TypeBasicLinkedService = "Hdfs"
	// TypeHDInsight ...
	TypeHDInsight TypeBasicLinkedService = "HDInsight"
	// TypeHDInsightOnDemand ...
	TypeHDInsightOnDemand TypeBasicLinkedService = "HDInsightOnDemand"
	// TypeHive ...
	TypeHive TypeBasicLinkedService = "Hive"
	// TypeHTTPServer ...
	TypeHTTPServer TypeBasicLinkedService = "HttpServer"
	// TypeHubspot ...
	TypeHubspot TypeBasicLinkedService = "Hubspot"
	// TypeImpala ...
	TypeImpala TypeBasicLinkedService = "Impala"
	// TypeInformix ...
	TypeInformix TypeBasicLinkedService = "Informix"
	// TypeJira ...
	TypeJira TypeBasicLinkedService = "Jira"
	// TypeLinkedService ...
	TypeLinkedService TypeBasicLinkedService = "LinkedService"
	// TypeMagento ...
	TypeMagento TypeBasicLinkedService = "Magento"
	// TypeMariaDB ...
	TypeMariaDB TypeBasicLinkedService = "MariaDB"
	// TypeMarketo ...
	TypeMarketo TypeBasicLinkedService = "Marketo"
	// TypeMicrosoftAccess ...
	TypeMicrosoftAccess TypeBasicLinkedService = "MicrosoftAccess"
	// TypeMongoDb ...
	TypeMongoDb TypeBasicLinkedService = "MongoDb"
	// TypeMongoDbV2 ...
	TypeMongoDbV2 TypeBasicLinkedService = "MongoDbV2"
	// TypeMySQL ...
	TypeMySQL TypeBasicLinkedService = "MySql"
	// TypeNetezza ...
	TypeNetezza TypeBasicLinkedService = "Netezza"
	// TypeOData ...
	TypeOData TypeBasicLinkedService = "OData"
	// TypeOdbc ...
	TypeOdbc TypeBasicLinkedService = "Odbc"
	// TypeOffice365 ...
	TypeOffice365 TypeBasicLinkedService = "Office365"
	// TypeOracle ...
	TypeOracle TypeBasicLinkedService = "Oracle"
	// TypeOracleServiceCloud ...
	TypeOracleServiceCloud TypeBasicLinkedService = "OracleServiceCloud"
	// TypePaypal ...
	TypePaypal TypeBasicLinkedService = "Paypal"
	// TypePhoenix ...
	TypePhoenix TypeBasicLinkedService = "Phoenix"
	// TypePostgreSQL ...
	TypePostgreSQL TypeBasicLinkedService = "PostgreSql"
	// TypePresto ...
	TypePresto TypeBasicLinkedService = "Presto"
	// TypeQuickBooks ...
	TypeQuickBooks TypeBasicLinkedService = "QuickBooks"
	// TypeResponsys ...
	TypeResponsys TypeBasicLinkedService = "Responsys"
	// TypeRestService ...
	TypeRestService TypeBasicLinkedService = "RestService"
	// TypeSalesforce ...
	TypeSalesforce TypeBasicLinkedService = "Salesforce"
	// TypeSalesforceMarketingCloud ...
	TypeSalesforceMarketingCloud TypeBasicLinkedService = "SalesforceMarketingCloud"
	// TypeSalesforceServiceCloud ...
	TypeSalesforceServiceCloud TypeBasicLinkedService = "SalesforceServiceCloud"
	// TypeSapBW ...
	TypeSapBW TypeBasicLinkedService = "SapBW"
	// TypeSapCloudForCustomer ...
	TypeSapCloudForCustomer TypeBasicLinkedService = "SapCloudForCustomer"
	// TypeSapEcc ...
	TypeSapEcc TypeBasicLinkedService = "SapEcc"
	// TypeSapHana ...
	TypeSapHana TypeBasicLinkedService = "SapHana"
	// TypeSapOpenHub ...
	TypeSapOpenHub TypeBasicLinkedService = "SapOpenHub"
	// TypeSapTable ...
	TypeSapTable TypeBasicLinkedService = "SapTable"
	// TypeServiceNow ...
	TypeServiceNow TypeBasicLinkedService = "ServiceNow"
	// TypeSftp ...
	TypeSftp TypeBasicLinkedService = "Sftp"
	// TypeSharePointOnlineList ...
	TypeSharePointOnlineList TypeBasicLinkedService = "SharePointOnlineList"
	// TypeShopify ...
	TypeShopify TypeBasicLinkedService = "Shopify"
	// TypeSnowflake ...
	TypeSnowflake TypeBasicLinkedService = "Snowflake"
	// TypeSpark ...
	TypeSpark TypeBasicLinkedService = "Spark"
	// TypeSQLServer ...
	TypeSQLServer TypeBasicLinkedService = "SqlServer"
	// TypeSquare ...
	TypeSquare TypeBasicLinkedService = "Square"
	// TypeSybase ...
	TypeSybase TypeBasicLinkedService = "Sybase"
	// TypeTeradata ...
	TypeTeradata TypeBasicLinkedService = "Teradata"
	// TypeVertica ...
	TypeVertica TypeBasicLinkedService = "Vertica"
	// TypeWeb ...
	TypeWeb TypeBasicLinkedService = "Web"
	// TypeXero ...
	TypeXero TypeBasicLinkedService = "Xero"
	// TypeZoho ...
	TypeZoho TypeBasicLinkedService = "Zoho"
)

// PossibleTypeBasicLinkedServiceValues returns an array of possible values for the TypeBasicLinkedService const type.
func PossibleTypeBasicLinkedServiceValues() []TypeBasicLinkedService {
	return []TypeBasicLinkedService{TypeAmazonMWS, TypeAmazonRedshift, TypeAmazonS3, TypeAzureBatch, TypeAzureBlobFS, TypeAzureBlobStorage, TypeAzureDatabricks, TypeAzureDataExplorer, TypeAzureDataLakeAnalytics, TypeAzureDataLakeStore, TypeAzureFileStorage, TypeAzureFunction, TypeAzureKeyVault, TypeAzureMariaDB, TypeAzureML, TypeAzureMLService, TypeAzureMySQL, TypeAzurePostgreSQL, TypeAzureSearch, TypeAzureSQLDatabase, TypeAzureSQLDW, TypeAzureSQLMI, TypeAzureStorage, TypeAzureTableStorage, TypeCassandra, TypeCommonDataServiceForApps, TypeConcur, TypeCosmosDb, TypeCosmosDbMongoDbAPI, TypeCouchbase, TypeCustomDataSource, TypeDb2, TypeDrill, TypeDynamics, TypeDynamicsAX, TypeDynamicsCrm, TypeEloqua, TypeFileServer, TypeFtpServer, TypeGoogleAdWords, TypeGoogleBigQuery, TypeGoogleCloudStorage, TypeGreenplum, TypeHBase, TypeHdfs, TypeHDInsight, TypeHDInsightOnDemand, TypeHive, TypeHTTPServer, TypeHubspot, TypeImpala, TypeInformix, TypeJira, TypeLinkedService, TypeMagento, TypeMariaDB, TypeMarketo, TypeMicrosoftAccess, TypeMongoDb, TypeMongoDbV2, TypeMySQL, TypeNetezza, TypeOData, TypeOdbc, TypeOffice365, TypeOracle, TypeOracleServiceCloud, TypePaypal, TypePhoenix, TypePostgreSQL, TypePresto, TypeQuickBooks, TypeResponsys, TypeRestService, TypeSalesforce, TypeSalesforceMarketingCloud, TypeSalesforceServiceCloud, TypeSapBW, TypeSapCloudForCustomer, TypeSapEcc, TypeSapHana, TypeSapOpenHub, TypeSapTable, TypeServiceNow, TypeSftp, TypeSharePointOnlineList, TypeShopify, TypeSnowflake, TypeSpark, TypeSQLServer, TypeSquare, TypeSybase, TypeTeradata, TypeVertica, TypeWeb, TypeXero, TypeZoho}
}

// TypeBasicSsisObjectMetadata enumerates the values for type basic ssis object metadata.
type TypeBasicSsisObjectMetadata string

const (
	// TypeEnvironment ...
	TypeEnvironment TypeBasicSsisObjectMetadata = "Environment"
	// TypeFolder ...
	TypeFolder TypeBasicSsisObjectMetadata = "Folder"
	// TypePackage ...
	TypePackage TypeBasicSsisObjectMetadata = "Package"
	// TypeProject ...
	TypeProject TypeBasicSsisObjectMetadata = "Project"
	// TypeSsisObjectMetadata ...
	TypeSsisObjectMetadata TypeBasicSsisObjectMetadata = "SsisObjectMetadata"
)

// PossibleTypeBasicSsisObjectMetadataValues returns an array of possible values for the TypeBasicSsisObjectMetadata const type.
func PossibleTypeBasicSsisObjectMetadataValues() []TypeBasicSsisObjectMetadata {
	return []TypeBasicSsisObjectMetadata{TypeEnvironment, TypeFolder, TypePackage, TypeProject, TypeSsisObjectMetadata}
}

// TypeBasicStoreReadSettings enumerates the values for type basic store read settings.
type TypeBasicStoreReadSettings string

const (
	// TypeAmazonS3ReadSettings ...
	TypeAmazonS3ReadSettings TypeBasicStoreReadSettings = "AmazonS3ReadSettings"
	// TypeAzureBlobFSReadSettings ...
	TypeAzureBlobFSReadSettings TypeBasicStoreReadSettings = "AzureBlobFSReadSettings"
	// TypeAzureBlobStorageReadSettings ...
	TypeAzureBlobStorageReadSettings TypeBasicStoreReadSettings = "AzureBlobStorageReadSettings"
	// TypeAzureDataLakeStoreReadSettings ...
	TypeAzureDataLakeStoreReadSettings TypeBasicStoreReadSettings = "AzureDataLakeStoreReadSettings"
	// TypeAzureFileStorageReadSettings ...
	TypeAzureFileStorageReadSettings TypeBasicStoreReadSettings = "AzureFileStorageReadSettings"
	// TypeFileServerReadSettings ...
	TypeFileServerReadSettings TypeBasicStoreReadSettings = "FileServerReadSettings"
	// TypeFtpReadSettings ...
	TypeFtpReadSettings TypeBasicStoreReadSettings = "FtpReadSettings"
	// TypeGoogleCloudStorageReadSettings ...
	TypeGoogleCloudStorageReadSettings TypeBasicStoreReadSettings = "GoogleCloudStorageReadSettings"
	// TypeHdfsReadSettings ...
	TypeHdfsReadSettings TypeBasicStoreReadSettings = "HdfsReadSettings"
	// TypeHTTPReadSettings ...
	TypeHTTPReadSettings TypeBasicStoreReadSettings = "HttpReadSettings"
	// TypeSftpReadSettings ...
	TypeSftpReadSettings TypeBasicStoreReadSettings = "SftpReadSettings"
	// TypeStoreReadSettings ...
	TypeStoreReadSettings TypeBasicStoreReadSettings = "StoreReadSettings"
)

// PossibleTypeBasicStoreReadSettingsValues returns an array of possible values for the TypeBasicStoreReadSettings const type.
func PossibleTypeBasicStoreReadSettingsValues() []TypeBasicStoreReadSettings {
	return []TypeBasicStoreReadSettings{TypeAmazonS3ReadSettings, TypeAzureBlobFSReadSettings, TypeAzureBlobStorageReadSettings, TypeAzureDataLakeStoreReadSettings, TypeAzureFileStorageReadSettings, TypeFileServerReadSettings, TypeFtpReadSettings, TypeGoogleCloudStorageReadSettings, TypeHdfsReadSettings, TypeHTTPReadSettings, TypeSftpReadSettings, TypeStoreReadSettings}
}

// TypeBasicStoreWriteSettings enumerates the values for type basic store write settings.
type TypeBasicStoreWriteSettings string

const (
	// TypeAzureBlobFSWriteSettings ...
	TypeAzureBlobFSWriteSettings TypeBasicStoreWriteSettings = "AzureBlobFSWriteSettings"
	// TypeAzureBlobStorageWriteSettings ...
	TypeAzureBlobStorageWriteSettings TypeBasicStoreWriteSettings = "AzureBlobStorageWriteSettings"
	// TypeAzureDataLakeStoreWriteSettings ...
	TypeAzureDataLakeStoreWriteSettings TypeBasicStoreWriteSettings = "AzureDataLakeStoreWriteSettings"
	// TypeFileServerWriteSettings ...
	TypeFileServerWriteSettings TypeBasicStoreWriteSettings = "FileServerWriteSettings"
	// TypeSftpWriteSettings ...
	TypeSftpWriteSettings TypeBasicStoreWriteSettings = "SftpWriteSettings"
	// TypeStoreWriteSettings ...
	TypeStoreWriteSettings TypeBasicStoreWriteSettings = "StoreWriteSettings"
)

// PossibleTypeBasicStoreWriteSettingsValues returns an array of possible values for the TypeBasicStoreWriteSettings const type.
func PossibleTypeBasicStoreWriteSettingsValues() []TypeBasicStoreWriteSettings {
	return []TypeBasicStoreWriteSettings{TypeAzureBlobFSWriteSettings, TypeAzureBlobStorageWriteSettings, TypeAzureDataLakeStoreWriteSettings, TypeFileServerWriteSettings, TypeSftpWriteSettings, TypeStoreWriteSettings}
}

// TypeBasicTrigger enumerates the values for type basic trigger.
type TypeBasicTrigger string

const (
	// TypeBlobEventsTrigger ...
	TypeBlobEventsTrigger TypeBasicTrigger = "BlobEventsTrigger"
	// TypeBlobTrigger ...
	TypeBlobTrigger TypeBasicTrigger = "BlobTrigger"
	// TypeChainingTrigger ...
	TypeChainingTrigger TypeBasicTrigger = "ChainingTrigger"
	// TypeMultiplePipelineTrigger ...
	TypeMultiplePipelineTrigger TypeBasicTrigger = "MultiplePipelineTrigger"
	// TypeRerunTumblingWindowTrigger ...
	TypeRerunTumblingWindowTrigger TypeBasicTrigger = "RerunTumblingWindowTrigger"
	// TypeScheduleTrigger ...
	TypeScheduleTrigger TypeBasicTrigger = "ScheduleTrigger"
	// TypeTrigger ...
	TypeTrigger TypeBasicTrigger = "Trigger"
	// TypeTumblingWindowTrigger ...
	TypeTumblingWindowTrigger TypeBasicTrigger = "TumblingWindowTrigger"
)

// PossibleTypeBasicTriggerValues returns an array of possible values for the TypeBasicTrigger const type.
func PossibleTypeBasicTriggerValues() []TypeBasicTrigger {
	return []TypeBasicTrigger{TypeBlobEventsTrigger, TypeBlobTrigger, TypeChainingTrigger, TypeMultiplePipelineTrigger, TypeRerunTumblingWindowTrigger, TypeScheduleTrigger, TypeTrigger, TypeTumblingWindowTrigger}
}

// VariableType enumerates the values for variable type.
type VariableType string

const (
	// VariableTypeArray ...
	VariableTypeArray VariableType = "Array"
	// VariableTypeBool ...
	VariableTypeBool VariableType = "Bool"
	// VariableTypeString ...
	VariableTypeString VariableType = "String"
)

// PossibleVariableTypeValues returns an array of possible values for the VariableType const type.
func PossibleVariableTypeValues() []VariableType {
	return []VariableType{VariableTypeArray, VariableTypeBool, VariableTypeString}
}

// WebActivityMethod enumerates the values for web activity method.
type WebActivityMethod string

const (
	// WebActivityMethodDELETE ...
	WebActivityMethodDELETE WebActivityMethod = "DELETE"
	// WebActivityMethodGET ...
	WebActivityMethodGET WebActivityMethod = "GET"
	// WebActivityMethodPOST ...
	WebActivityMethodPOST WebActivityMethod = "POST"
	// WebActivityMethodPUT ...
	WebActivityMethodPUT WebActivityMethod = "PUT"
)

// PossibleWebActivityMethodValues returns an array of possible values for the WebActivityMethod const type.
func PossibleWebActivityMethodValues() []WebActivityMethod {
	return []WebActivityMethod{WebActivityMethodDELETE, WebActivityMethodGET, WebActivityMethodPOST, WebActivityMethodPUT}
}

// WebHookActivityMethod enumerates the values for web hook activity method.
type WebHookActivityMethod string

const (
	// WebHookActivityMethodPOST ...
	WebHookActivityMethodPOST WebHookActivityMethod = "POST"
)

// PossibleWebHookActivityMethodValues returns an array of possible values for the WebHookActivityMethod const type.
func PossibleWebHookActivityMethodValues() []WebHookActivityMethod {
	return []WebHookActivityMethod{WebHookActivityMethodPOST}
}

// AccessPolicyResponse get Data Plane read only token response definition.
type AccessPolicyResponse struct {
	autorest.Response `json:"-"`
	// Policy - The user access policy.
	Policy *UserAccessPolicy `json:"policy,omitempty"`
	// AccessToken - Data Plane read only access token.
	AccessToken *string `json:"accessToken,omitempty"`
	// DataPlaneURL - Data Plane service base URL.
	DataPlaneURL *string `json:"dataPlaneUrl,omitempty"`
}

// BasicActivity a pipeline activity.
type BasicActivity interface {
	AsExecuteDataFlowActivity() (*ExecuteDataFlowActivity, bool)
	AsAzureFunctionActivity() (*AzureFunctionActivity, bool)
	AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool)
	AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool)
	AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool)
	AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool)
	AsAzureMLExecutePipelineActivity() (*AzureMLExecutePipelineActivity, bool)
	AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool)
	AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool)
	AsGetMetadataActivity() (*GetMetadataActivity, bool)
	AsWebActivity() (*WebActivity, bool)
	AsLookupActivity() (*LookupActivity, bool)
	AsAzureDataExplorerCommandActivity() (*AzureDataExplorerCommandActivity, bool)
	AsDeleteActivity() (*DeleteActivity, bool)
	AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool)
	AsCustomActivity() (*CustomActivity, bool)
	AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool)
	AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool)
	AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool)
	AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool)
	AsHDInsightPigActivity() (*HDInsightPigActivity, bool)
	AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool)
	AsCopyActivity() (*CopyActivity, bool)
	AsExecutionActivity() (*ExecutionActivity, bool)
	AsBasicExecutionActivity() (BasicExecutionActivity, bool)
	AsWebHookActivity() (*WebHookActivity, bool)
	AsAppendVariableActivity() (*AppendVariableActivity, bool)
	AsSetVariableActivity() (*SetVariableActivity, bool)
	AsFilterActivity() (*FilterActivity, bool)
	AsValidationActivity() (*ValidationActivity, bool)
	AsUntilActivity() (*UntilActivity, bool)
	AsWaitActivity() (*WaitActivity, bool)
	AsForEachActivity() (*ForEachActivity, bool)
	AsSwitchActivity() (*SwitchActivity, bool)
	AsIfConditionActivity() (*IfConditionActivity, bool)
	AsExecutePipelineActivity() (*ExecutePipelineActivity, bool)
	AsControlActivity() (*ControlActivity, bool)
	AsBasicControlActivity() (BasicControlActivity, bool)
	AsActivity() (*Activity, bool)
}

// Activity a pipeline activity.
type Activity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeExecuteDataFlow', 'TypeAzureFunctionActivity', 'TypeDatabricksSparkPython', 'TypeDatabricksSparkJar', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLExecutePipeline', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeAzureDataExplorerCommand', 'TypeDelete', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeWebHook', 'TypeAppendVariable', 'TypeSetVariable', 'TypeFilter', 'TypeValidation', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeSwitch', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

func unmarshalBasicActivity(body []byte) (BasicActivity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeExecuteDataFlow):
		var edfa ExecuteDataFlowActivity
		err := json.Unmarshal(body, &edfa)
		return edfa, err
	case string(TypeAzureFunctionActivity):
		var afa AzureFunctionActivity
		err := json.Unmarshal(body, &afa)
		return afa, err
	case string(TypeDatabricksSparkPython):
		var dspa DatabricksSparkPythonActivity
		err := json.Unmarshal(body, &dspa)
		return dspa, err
	case string(TypeDatabricksSparkJar):
		var dsja DatabricksSparkJarActivity
		err := json.Unmarshal(body, &dsja)
		return dsja, err
	case string(TypeDatabricksNotebook):
		var dna DatabricksNotebookActivity
		err := json.Unmarshal(body, &dna)
		return dna, err
	case string(TypeDataLakeAnalyticsUSQL):
		var dlaua DataLakeAnalyticsUSQLActivity
		err := json.Unmarshal(body, &dlaua)
		return dlaua, err
	case string(TypeAzureMLExecutePipeline):
		var amepa AzureMLExecutePipelineActivity
		err := json.Unmarshal(body, &amepa)
		return amepa, err
	case string(TypeAzureMLUpdateResource):
		var amura AzureMLUpdateResourceActivity
		err := json.Unmarshal(body, &amura)
		return amura, err
	case string(TypeAzureMLBatchExecution):
		var ambea AzureMLBatchExecutionActivity
		err := json.Unmarshal(body, &ambea)
		return ambea, err
	case string(TypeGetMetadata):
		var gma GetMetadataActivity
		err := json.Unmarshal(body, &gma)
		return gma, err
	case string(TypeWebActivity):
		var wa WebActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeLookup):
		var la LookupActivity
		err := json.Unmarshal(body, &la)
		return la, err
	case string(TypeAzureDataExplorerCommand):
		var adeca AzureDataExplorerCommandActivity
		err := json.Unmarshal(body, &adeca)
		return adeca, err
	case string(TypeDelete):
		var da DeleteActivity
		err := json.Unmarshal(body, &da)
		return da, err
	case string(TypeSQLServerStoredProcedure):
		var ssspa SQLServerStoredProcedureActivity
		err := json.Unmarshal(body, &ssspa)
		return ssspa, err
	case string(TypeCustom):
		var ca CustomActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeExecuteSSISPackage):
		var espa ExecuteSSISPackageActivity
		err := json.Unmarshal(body, &espa)
		return espa, err
	case string(TypeHDInsightSpark):
		var hisa HDInsightSparkActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeHDInsightStreaming):
		var hisa HDInsightStreamingActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeHDInsightMapReduce):
		var himra HDInsightMapReduceActivity
		err := json.Unmarshal(body, &himra)
		return himra, err
	case string(TypeHDInsightPig):
		var hipa HDInsightPigActivity
		err := json.Unmarshal(body, &hipa)
		return hipa, err
	case string(TypeHDInsightHive):
		var hiha HDInsightHiveActivity
		err := json.Unmarshal(body, &hiha)
		return hiha, err
	case string(TypeCopy):
		var ca CopyActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeExecution):
		var ea ExecutionActivity
		err := json.Unmarshal(body, &ea)
		return ea, err
	case string(TypeWebHook):
		var wha WebHookActivity
		err := json.Unmarshal(body, &wha)
		return wha, err
	case string(TypeAppendVariable):
		var ava AppendVariableActivity
		err := json.Unmarshal(body, &ava)
		return ava, err
	case string(TypeSetVariable):
		var sva SetVariableActivity
		err := json.Unmarshal(body, &sva)
		return sva, err
	case string(TypeFilter):
		var fa FilterActivity
		err := json.Unmarshal(body, &fa)
		return fa, err
	case string(TypeValidation):
		var va ValidationActivity
		err := json.Unmarshal(body, &va)
		return va, err
	case string(TypeUntil):
		var ua UntilActivity
		err := json.Unmarshal(body, &ua)
		return ua, err
	case string(TypeWait):
		var wa WaitActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeForEach):
		var fea ForEachActivity
		err := json.Unmarshal(body, &fea)
		return fea, err
	case string(TypeSwitch):
		var sa SwitchActivity
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeIfCondition):
		var ica IfConditionActivity
		err := json.Unmarshal(body, &ica)
		return ica, err
	case string(TypeExecutePipeline):
		var epa ExecutePipelineActivity
		err := json.Unmarshal(body, &epa)
		return epa, err
	case string(TypeContainer):
		var ca ControlActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	default:
		var a Activity
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicActivityArray(body []byte) ([]BasicActivity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicActivity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicActivity(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Activity.
func (a Activity) MarshalJSON() ([]byte, error) {
	a.Type = TypeActivity
	objectMap := make(map[string]interface{})
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.DependsOn != nil {
		objectMap["dependsOn"] = a.DependsOn
	}
	if a.UserProperties != nil {
		objectMap["userProperties"] = a.UserProperties
	}
	if a.Type != "" {
		objectMap["type"] = a.Type
	}
	for k, v := range a.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsExecuteDataFlowActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecuteDataFlowActivity() (*ExecuteDataFlowActivity, bool) {
	return nil, false
}

// AsAzureFunctionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLExecutePipelineActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLExecutePipelineActivity() (*AzureMLExecutePipelineActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for Activity.
func (a Activity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for Activity.
func (a Activity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsAzureDataExplorerCommandActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureDataExplorerCommandActivity() (*AzureDataExplorerCommandActivity, bool) {
	return nil, false
}

// AsDeleteActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsWebHookActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return nil, false
}

// AsSetVariableActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for Activity.
func (a Activity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for Activity.
func (a Activity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for Activity.
func (a Activity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for Activity.
func (a Activity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsSwitchActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSwitchActivity() (*SwitchActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for Activity.
func (a Activity) AsActivity() (*Activity, bool) {
	return &a, true
}

// AsBasicActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicActivity() (BasicActivity, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Activity struct.
func (a *Activity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if a.AdditionalProperties == nil {
					a.AdditionalProperties = make(map[string]interface{})
				}
				a.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				a.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				a.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				a.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// ActivityDependency activity dependency information.
type ActivityDependency struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Activity - Activity name.
	Activity *string `json:"activity,omitempty"`
	// DependencyConditions - Match-Condition for the dependency.
	DependencyConditions *[]DependencyCondition `json:"dependencyConditions,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityDependency.
func (ad ActivityDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.Activity != nil {
		objectMap["activity"] = ad.Activity
	}
	if ad.DependencyConditions != nil {
		objectMap["dependencyConditions"] = ad.DependencyConditions
	}
	for k, v := range ad.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityDependency struct.
func (ad *ActivityDependency) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ad.AdditionalProperties == nil {
					ad.AdditionalProperties = make(map[string]interface{})
				}
				ad.AdditionalProperties[k] = additionalProperties
			}
		case "activity":
			if v != nil {
				var activity string
				err = json.Unmarshal(*v, &activity)
				if err != nil {
					return err
				}
				ad.Activity = &activity
			}
		case "dependencyConditions":
			if v != nil {
				var dependencyConditions []DependencyCondition
				err = json.Unmarshal(*v, &dependencyConditions)
				if err != nil {
					return err
				}
				ad.DependencyConditions = &dependencyConditions
			}
		}
	}

	return nil
}

// ActivityPolicy execution policy for an activity.
type ActivityPolicy struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Timeout - Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	Timeout interface{} `json:"timeout,omitempty"`
	// Retry - Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
	Retry interface{} `json:"retry,omitempty"`
	// RetryIntervalInSeconds - Interval between each retry attempt (in seconds). The default is 30 sec.
	RetryIntervalInSeconds *int32 `json:"retryIntervalInSeconds,omitempty"`
	// SecureInput - When set to true, Input from activity is considered as secure and will not be logged to monitoring.
	SecureInput *bool `json:"secureInput,omitempty"`
	// SecureOutput - When set to true, Output from activity is considered as secure and will not be logged to monitoring.
	SecureOutput *bool `json:"secureOutput,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityPolicy.
func (ap ActivityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Timeout != nil {
		objectMap["timeout"] = ap.Timeout
	}
	if ap.Retry != nil {
		objectMap["retry"] = ap.Retry
	}
	if ap.RetryIntervalInSeconds != nil {
		objectMap["retryIntervalInSeconds"] = ap.RetryIntervalInSeconds
	}
	if ap.SecureInput != nil {
		objectMap["secureInput"] = ap.SecureInput
	}
	if ap.SecureOutput != nil {
		objectMap["secureOutput"] = ap.SecureOutput
	}
	for k, v := range ap.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityPolicy struct.
func (ap *ActivityPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ap.AdditionalProperties == nil {
					ap.AdditionalProperties = make(map[string]interface{})
				}
				ap.AdditionalProperties[k] = additionalProperties
			}
		case "timeout":
			if v != nil {
				var timeout interface{}
				err = json.Unmarshal(*v, &timeout)
				if err != nil {
					return err
				}
				ap.Timeout = timeout
			}
		case "retry":
			if v != nil {
				var retry interface{}
				err = json.Unmarshal(*v, &retry)
				if err != nil {
					return err
				}
				ap.Retry = retry
			}
		case "retryIntervalInSeconds":
			if v != nil {
				var retryIntervalInSeconds int32
				err = json.Unmarshal(*v, &retryIntervalInSeconds)
				if err != nil {
					return err
				}
				ap.RetryIntervalInSeconds = &retryIntervalInSeconds
			}
		case "secureInput":
			if v != nil {
				var secureInput bool
				err = json.Unmarshal(*v, &secureInput)
				if err != nil {
					return err
				}
				ap.SecureInput = &secureInput
			}
		case "secureOutput":
			if v != nil {
				var secureOutput bool
				err = json.Unmarshal(*v, &secureOutput)
				if err != nil {
					return err
				}
				ap.SecureOutput = &secureOutput
			}
		}
	}

	return nil
}

// ActivityRun information about an activity run in a pipeline.
type ActivityRun struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// PipelineName - READ-ONLY; The name of the pipeline.
	PipelineName *string `json:"pipelineName,omitempty"`
	// PipelineRunID - READ-ONLY; The id of the pipeline run.
	PipelineRunID *string `json:"pipelineRunId,omitempty"`
	// ActivityName - READ-ONLY; The name of the activity.
	ActivityName *string `json:"activityName,omitempty"`
	// ActivityType - READ-ONLY; The type of the activity.
	ActivityType *string `json:"activityType,omitempty"`
	// ActivityRunID - READ-ONLY; The id of the activity run.
	ActivityRunID *string `json:"activityRunId,omitempty"`
	// LinkedServiceName - READ-ONLY; The name of the compute linked service.
	LinkedServiceName *string `json:"linkedServiceName,omitempty"`
	// Status - READ-ONLY; The status of the activity run.
	Status *string `json:"status,omitempty"`
	// ActivityRunStart - READ-ONLY; The start time of the activity run in 'ISO 8601' format.
	ActivityRunStart *date.Time `json:"activityRunStart,omitempty"`
	// ActivityRunEnd - READ-ONLY; The end time of the activity run in 'ISO 8601' format.
	ActivityRunEnd *date.Time `json:"activityRunEnd,omitempty"`
	// DurationInMs - READ-ONLY; The duration of the activity run.
	DurationInMs *int32 `json:"durationInMs,omitempty"`
	// Input - READ-ONLY; The input for the activity.
	Input interface{} `json:"input,omitempty"`
	// Output - READ-ONLY; The output for the activity.
	Output interface{} `json:"output,omitempty"`
	// Error - READ-ONLY; The error if any from the activity run.
	Error interface{} `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityRun.
func (ar ActivityRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range ar.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityRun struct.
func (ar *ActivityRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ar.AdditionalProperties == nil {
					ar.AdditionalProperties = make(map[string]interface{})
				}
				ar.AdditionalProperties[k] = additionalProperties
			}
		case "pipelineName":
			if v != nil {
				var pipelineName string
				err = json.Unmarshal(*v, &pipelineName)
				if err != nil {
					return err
				}
				ar.PipelineName = &pipelineName
			}
		case "pipelineRunId":
			if v != nil {
				var pipelineRunID string
				err = json.Unmarshal(*v, &pipelineRunID)
				if err != nil {
					return err
				}
				ar.PipelineRunID = &pipelineRunID
			}
		case "activityName":
			if v != nil {
				var activityName string
				err = json.Unmarshal(*v, &activityName)
				if err != nil {
					return err
				}
				ar.ActivityName = &activityName
			}
		case "activityType":
			if v != nil {
				var activityType string
				err = json.Unmarshal(*v, &activityType)
				if err != nil {
					return err
				}
				ar.ActivityType = &activityType
			}
		case "activityRunId":
			if v != nil {
				var activityRunID string
				err = json.Unmarshal(*v, &activityRunID)
				if err != nil {
					return err
				}
				ar.ActivityRunID = &activityRunID
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName string
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ar.LinkedServiceName = &linkedServiceName
			}
		case "status":
			if v != nil {
				var status string
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				ar.Status = &status
			}
		case "activityRunStart":
			if v != nil {
				var activityRunStart date.Time
				err = json.Unmarshal(*v, &activityRunStart)
				if err != nil {
					return err
				}
				ar.ActivityRunStart = &activityRunStart
			}
		case "activityRunEnd":
			if v != nil {
				var activityRunEnd date.Time
				err = json.Unmarshal(*v, &activityRunEnd)
				if err != nil {
					return err
				}
				ar.ActivityRunEnd = &activityRunEnd
			}
		case "durationInMs":
			if v != nil {
				var durationInMs int32
				err = json.Unmarshal(*v, &durationInMs)
				if err != nil {
					return err
				}
				ar.DurationInMs = &durationInMs
			}
		case "input":
			if v != nil {
				var input interface{}
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ar.Input = input
			}
		case "output":
			if v != nil {
				var output interface{}
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ar.Output = output
			}
		case "error":
			if v != nil {
				var errorVar interface{}
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				ar.Error = errorVar
			}
		}
	}

	return nil
}

// ActivityRunsQueryResponse a list activity runs.
type ActivityRunsQueryResponse struct {
	autorest.Response `json:"-"`
	// Value - List of activity runs.
	Value *[]ActivityRun `json:"value,omitempty"`
	// ContinuationToken - The continuation token for getting the next page of results, if any remaining results exist, null otherwise.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// AddDataFlowToDebugSessionResponse response body structure for starting data flow debug session.
type AddDataFlowToDebugSessionResponse struct {
	autorest.Response `json:"-"`
	// JobVersion - The ID of data flow debug job version.
	JobVersion *string `json:"jobVersion,omitempty"`
}

// AdditionalColumns specify the column name and value of additional columns.
type AdditionalColumns struct {
	// Name - Additional column name. Type: string (or Expression with resultType string).
	Name interface{} `json:"name,omitempty"`
	// Value - Additional column value. Type: string (or Expression with resultType string).
	Value interface{} `json:"value,omitempty"`
}

// AmazonMWSLinkedService amazon Marketplace Web Service linked service.
type AmazonMWSLinkedService struct {
	// AmazonMWSLinkedServiceTypeProperties - Amazon Marketplace Web Service linked service properties.
	*AmazonMWSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) MarshalJSON() ([]byte, error) {
	amls.Type = TypeAmazonMWS
	objectMap := make(map[string]interface{})
	if amls.AmazonMWSLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = amls.AmazonMWSLinkedServiceTypeProperties
	}
	if amls.ConnectVia != nil {
		objectMap["connectVia"] = amls.ConnectVia
	}
	if amls.Description != nil {
		objectMap["description"] = amls.Description
	}
	if amls.Parameters != nil {
		objectMap["parameters"] = amls.Parameters
	}
	if amls.Annotations != nil {
		objectMap["annotations"] = amls.Annotations
	}
	if amls.Type != "" {
		objectMap["type"] = amls.Type
	}
	for k, v := range amls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return &amls, true
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedService struct.
func (amls *AmazonMWSLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonMWSLinkedServiceTypeProperties AmazonMWSLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonMWSLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				amls.AmazonMWSLinkedServiceTypeProperties = &amazonMWSLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amls.AdditionalProperties == nil {
					amls.AdditionalProperties = make(map[string]interface{})
				}
				amls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				amls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonMWSLinkedServiceTypeProperties amazon Marketplace Web Service linked service properties.
type AmazonMWSLinkedServiceTypeProperties struct {
	// Endpoint - The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
	Endpoint interface{} `json:"endpoint,omitempty"`
	// MarketplaceID - The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
	MarketplaceID interface{} `json:"marketplaceID,omitempty"`
	// SellerID - The Amazon seller ID.
	SellerID interface{} `json:"sellerID,omitempty"`
	// MwsAuthToken - The Amazon MWS authentication token.
	MwsAuthToken BasicSecretBase `json:"mwsAuthToken,omitempty"`
	// AccessKeyID - The access key id used to access data.
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`
	// SecretKey - The secret key used to access data.
	SecretKey BasicSecretBase `json:"secretKey,omitempty"`
	// UseEncryptedEndpoints - Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`
	// UseHostVerification - Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`
	// UsePeerVerification - Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedServiceTypeProperties struct.
func (amlstp *AmazonMWSLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "endpoint":
			if v != nil {
				var endpoint interface{}
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				amlstp.Endpoint = endpoint
			}
		case "marketplaceID":
			if v != nil {
				var marketplaceID interface{}
				err = json.Unmarshal(*v, &marketplaceID)
				if err != nil {
					return err
				}
				amlstp.MarketplaceID = marketplaceID
			}
		case "sellerID":
			if v != nil {
				var sellerID interface{}
				err = json.Unmarshal(*v, &sellerID)
				if err != nil {
					return err
				}
				amlstp.SellerID = sellerID
			}
		case "mwsAuthToken":
			if v != nil {
				mwsAuthToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.MwsAuthToken = mwsAuthToken
			}
		case "accessKeyId":
			if v != nil {
				var accessKeyID interface{}
				err = json.Unmarshal(*v, &accessKeyID)
				if err != nil {
					return err
				}
				amlstp.AccessKeyID = accessKeyID
			}
		case "secretKey":
			if v != nil {
				secretKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				amlstp.SecretKey = secretKey
			}
		case "useEncryptedEndpoints":
			if v != nil {
				var useEncryptedEndpoints interface{}
				err = json.Unmarshal(*v, &useEncryptedEndpoints)
				if err != nil {
					return err
				}
				amlstp.UseEncryptedEndpoints = useEncryptedEndpoints
			}
		case "useHostVerification":
			if v != nil {
				var useHostVerification interface{}
				err = json.Unmarshal(*v, &useHostVerification)
				if err != nil {
					return err
				}
				amlstp.UseHostVerification = useHostVerification
			}
		case "usePeerVerification":
			if v != nil {
				var usePeerVerification interface{}
				err = json.Unmarshal(*v, &usePeerVerification)
				if err != nil {
					return err
				}
				amlstp.UsePeerVerification = usePeerVerification
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				amlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonMWSObjectDataset amazon Marketplace Web Service dataset.
type AmazonMWSObjectDataset struct {
	// GenericDatasetTypeProperties - Properties specific to this dataset type.
	*GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeSharePointOnlineListResource', 'TypeSnowflakeTable', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeAzureMariaDBTable', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSapTableResource', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapHanaTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSapBwCube', 'TypeSybaseTable', 'TypeSalesforceServiceCloudObject', 'TypeSalesforceObject', 'TypeMicrosoftAccessTable', 'TypePostgreSQLTable', 'TypeMySQLTable', 'TypeOdbcTable', 'TypeInformixTable', 'TypeRelationalTable', 'TypeDb2Table', 'TypeAmazonRedshiftTable', 'TypeAzureMySQLTable', 'TypeTeradataTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeCommonDataServiceForAppsEntity', 'TypeDynamicsCrmEntity', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCosmosDbSQLAPICollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLMITable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeBinary', 'TypeOrc', 'TypeXML', 'TypeJSON', 'TypeDelimitedText', 'TypeParquet', 'TypeExcel', 'TypeAvro', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) MarshalJSON() ([]byte, error) {
	amod.Type = TypeAmazonMWSObject
	objectMap := make(map[string]interface{})
	if amod.GenericDatasetTypeProperties != nil {
		objectMap["typeProperties"] = amod.GenericDatasetTypeProperties
	}
	if amod.Description != nil {
		objectMap["description"] = amod.Description
	}
	if amod.Structure != nil {
		objectMap["structure"] = amod.Structure
	}
	if amod.Schema != nil {
		objectMap["schema"] = amod.Schema
	}
	if amod.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = amod.LinkedServiceName
	}
	if amod.Parameters != nil {
		objectMap["parameters"] = amod.Parameters
	}
	if amod.Annotations != nil {
		objectMap["annotations"] = amod.Annotations
	}
	if amod.Folder != nil {
		objectMap["folder"] = amod.Folder
	}
	if amod.Type != "" {
		objectMap["type"] = amod.Type
	}
	for k, v := range amod.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return &amod, true
}

// AsHTTPDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsBasicDataset() (BasicDataset, bool) {
	return &amod, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSObjectDataset struct.
func (amod *AmazonMWSObjectDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var genericDatasetTypeProperties GenericDatasetTypeProperties
				err = json.Unmarshal(*v, &genericDatasetTypeProperties)
				if err != nil {
					return err
				}
				amod.GenericDatasetTypeProperties = &genericDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if amod.AdditionalProperties == nil {
					amod.AdditionalProperties = make(map[string]interface{})
				}
				amod.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				amod.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				amod.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				amod.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				amod.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				amod.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				amod.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				amod.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amod.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonMWSSource a copy activity Amazon Marketplace Web Service source.
type AmazonMWSSource struct {
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// QueryTimeout - Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`
	// AdditionalColumns - Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects).
	AdditionalColumns *[]AdditionalColumns `json:"additionalColumns,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeSharePointOnlineListSource', 'TypeSnowflakeSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeRestSource', 'TypeSalesforceServiceCloudSource', 'TypeODataSource', 'TypeMicrosoftAccessSource', 'TypeRelationalSource', 'TypeCommonDataServiceForAppsSource', 'TypeDynamicsCrmSource', 'TypeDynamicsSource', 'TypeCosmosDbSQLAPISource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeAzureMariaDBSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeCassandraSource', 'TypeTeradataSource', 'TypeAzureMySQLSource', 'TypeSQLDWSource', 'TypeSQLMISource', 'TypeAzureSQLSource', 'TypeSQLServerSource', 'TypeSQLSource', 'TypeSapTableSource', 'TypeSapOpenHubSource', 'TypeSapHanaSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeSapBwSource', 'TypeSybaseSource', 'TypePostgreSQLSource', 'TypeMySQLSource', 'TypeOdbcSource', 'TypeDb2Source', 'TypeInformixSource', 'TypeAzureTableSource', 'TypeTabularSource', 'TypeBinarySource', 'TypeOrcSource', 'TypeXMLSource', 'TypeJSONSource', 'TypeDelimitedTextSource', 'TypeParquetSource', 'TypeExcelSource', 'TypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSSource.
func (ams AmazonMWSSource) MarshalJSON() ([]byte, error) {
	ams.Type = TypeAmazonMWSSource
	objectMap := make(map[string]interface{})
	if ams.Query != nil {
		objectMap["query"] = ams.Query
	}
	if ams.QueryTimeout != nil {
		objectMap["queryTimeout"] = ams.QueryTimeout
	}
	if ams.AdditionalColumns != nil {
		objectMap["additionalColumns"] = ams.AdditionalColumns
	}
	if ams.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ams.SourceRetryCount
	}
	if ams.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ams.SourceRetryWait
	}
	if ams.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ams.MaxConcurrentConnections
	}
	if ams.Type != "" {
		objectMap["type"] = ams.Type
	}
	for k, v := range ams.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return &ams, true
}

// AsCassandraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return &ams, true
}

// AsBinarySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ams, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSSource struct.
func (ams *AmazonMWSSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ams.Query = query
			}
		case "queryTimeout":
			if v != nil {
				var queryTimeout interface{}
				err = json.Unmarshal(*v, &queryTimeout)
				if err != nil {
					return err
				}
				ams.QueryTimeout = queryTimeout
			}
		case "additionalColumns":
			if v != nil {
				var additionalColumns []AdditionalColumns
				err = json.Unmarshal(*v, &additionalColumns)
				if err != nil {
					return err
				}
				ams.AdditionalColumns = &additionalColumns
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ams.AdditionalProperties == nil {
					ams.AdditionalProperties = make(map[string]interface{})
				}
				ams.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ams.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ams.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ams.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ams.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftLinkedService linked service for Amazon Redshift.
type AmazonRedshiftLinkedService struct {
	// AmazonRedshiftLinkedServiceTypeProperties - Amazon Redshift linked service properties.
	*AmazonRedshiftLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) MarshalJSON() ([]byte, error) {
	arls.Type = TypeAmazonRedshift
	objectMap := make(map[string]interface{})
	if arls.AmazonRedshiftLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = arls.AmazonRedshiftLinkedServiceTypeProperties
	}
	if arls.ConnectVia != nil {
		objectMap["connectVia"] = arls.ConnectVia
	}
	if arls.Description != nil {
		objectMap["description"] = arls.Description
	}
	if arls.Parameters != nil {
		objectMap["parameters"] = arls.Parameters
	}
	if arls.Annotations != nil {
		objectMap["annotations"] = arls.Annotations
	}
	if arls.Type != "" {
		objectMap["type"] = arls.Type
	}
	for k, v := range arls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return &arls, true
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &arls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftLinkedService struct.
func (arls *AmazonRedshiftLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonRedshiftLinkedServiceTypeProperties AmazonRedshiftLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonRedshiftLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				arls.AmazonRedshiftLinkedServiceTypeProperties = &amazonRedshiftLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if arls.AdditionalProperties == nil {
					arls.AdditionalProperties = make(map[string]interface{})
				}
				arls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				arls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				arls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				arls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				arls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				arls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftLinkedServiceTypeProperties amazon Redshift linked service properties.
type AmazonRedshiftLinkedServiceTypeProperties struct {
	// Server - The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
	Server interface{} `json:"server,omitempty"`
	// Username - The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
	// Password - The password of the Amazon Redshift source.
	Password BasicSecretBase `json:"password,omitempty"`
	// Database - The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
	// Port - The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer).
	Port interface{} `json:"port,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftLinkedServiceTypeProperties struct.
func (arlstp *AmazonRedshiftLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "server":
			if v != nil {
				var server interface{}
				err = json.Unmarshal(*v, &server)
				if err != nil {
					return err
				}
				arlstp.Server = server
			}
		case "username":
			if v != nil {
				var username interface{}
				err = json.Unmarshal(*v, &username)
				if err != nil {
					return err
				}
				arlstp.Username = username
			}
		case "password":
			if v != nil {
				password, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				arlstp.Password = password
			}
		case "database":
			if v != nil {
				var databaseVar interface{}
				err = json.Unmarshal(*v, &databaseVar)
				if err != nil {
					return err
				}
				arlstp.Database = databaseVar
			}
		case "port":
			if v != nil {
				var port interface{}
				err = json.Unmarshal(*v, &port)
				if err != nil {
					return err
				}
				arlstp.Port = port
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				arlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonRedshiftSource a copy activity source for Amazon Redshift Source.
type AmazonRedshiftSource struct {
	// Query - Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// RedshiftUnloadSettings - The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
	RedshiftUnloadSettings *RedshiftUnloadSettings `json:"redshiftUnloadSettings,omitempty"`
	// QueryTimeout - Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`
	// AdditionalColumns - Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects).
	AdditionalColumns *[]AdditionalColumns `json:"additionalColumns,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeSharePointOnlineListSource', 'TypeSnowflakeSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeRestSource', 'TypeSalesforceServiceCloudSource', 'TypeODataSource', 'TypeMicrosoftAccessSource', 'TypeRelationalSource', 'TypeCommonDataServiceForAppsSource', 'TypeDynamicsCrmSource', 'TypeDynamicsSource', 'TypeCosmosDbSQLAPISource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeAzureMariaDBSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeCassandraSource', 'TypeTeradataSource', 'TypeAzureMySQLSource', 'TypeSQLDWSource', 'TypeSQLMISource', 'TypeAzureSQLSource', 'TypeSQLServerSource', 'TypeSQLSource', 'TypeSapTableSource', 'TypeSapOpenHubSource', 'TypeSapHanaSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeSapBwSource', 'TypeSybaseSource', 'TypePostgreSQLSource', 'TypeMySQLSource', 'TypeOdbcSource', 'TypeDb2Source', 'TypeInformixSource', 'TypeAzureTableSource', 'TypeTabularSource', 'TypeBinarySource', 'TypeOrcSource', 'TypeXMLSource', 'TypeJSONSource', 'TypeDelimitedTextSource', 'TypeParquetSource', 'TypeExcelSource', 'TypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) MarshalJSON() ([]byte, error) {
	ars.Type = TypeAmazonRedshiftSource
	objectMap := make(map[string]interface{})
	if ars.Query != nil {
		objectMap["query"] = ars.Query
	}
	if ars.RedshiftUnloadSettings != nil {
		objectMap["redshiftUnloadSettings"] = ars.RedshiftUnloadSettings
	}
	if ars.QueryTimeout != nil {
		objectMap["queryTimeout"] = ars.QueryTimeout
	}
	if ars.AdditionalColumns != nil {
		objectMap["additionalColumns"] = ars.AdditionalColumns
	}
	if ars.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ars.SourceRetryCount
	}
	if ars.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ars.SourceRetryWait
	}
	if ars.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ars.MaxConcurrentConnections
	}
	if ars.Type != "" {
		objectMap["type"] = ars.Type
	}
	for k, v := range ars.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return &ars, true
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return &ars, true
}

// AsBinarySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ars, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftSource struct.
func (ars *AmazonRedshiftSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ars.Query = query
			}
		case "redshiftUnloadSettings":
			if v != nil {
				var redshiftUnloadSettings RedshiftUnloadSettings
				err = json.Unmarshal(*v, &redshiftUnloadSettings)
				if err != nil {
					return err
				}
				ars.RedshiftUnloadSettings = &redshiftUnloadSettings
			}
		case "queryTimeout":
			if v != nil {
				var queryTimeout interface{}
				err = json.Unmarshal(*v, &queryTimeout)
				if err != nil {
					return err
				}
				ars.QueryTimeout = queryTimeout
			}
		case "additionalColumns":
			if v != nil {
				var additionalColumns []AdditionalColumns
				err = json.Unmarshal(*v, &additionalColumns)
				if err != nil {
					return err
				}
				ars.AdditionalColumns = &additionalColumns
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ars.AdditionalProperties == nil {
					ars.AdditionalProperties = make(map[string]interface{})
				}
				ars.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ars.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ars.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ars.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ars.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftTableDataset the Amazon Redshift table dataset.
type AmazonRedshiftTableDataset struct {
	// AmazonRedshiftTableDatasetTypeProperties - Amazon Redshift table dataset properties.
	*AmazonRedshiftTableDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeSharePointOnlineListResource', 'TypeSnowflakeTable', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeAzureMariaDBTable', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSapTableResource', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapHanaTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSapBwCube', 'TypeSybaseTable', 'TypeSalesforceServiceCloudObject', 'TypeSalesforceObject', 'TypeMicrosoftAccessTable', 'TypePostgreSQLTable', 'TypeMySQLTable', 'TypeOdbcTable', 'TypeInformixTable', 'TypeRelationalTable', 'TypeDb2Table', 'TypeAmazonRedshiftTable', 'TypeAzureMySQLTable', 'TypeTeradataTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeCommonDataServiceForAppsEntity', 'TypeDynamicsCrmEntity', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCosmosDbSQLAPICollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLMITable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeBinary', 'TypeOrc', 'TypeXML', 'TypeJSON', 'TypeDelimitedText', 'TypeParquet', 'TypeExcel', 'TypeAvro', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) MarshalJSON() ([]byte, error) {
	artd.Type = TypeAmazonRedshiftTable
	objectMap := make(map[string]interface{})
	if artd.AmazonRedshiftTableDatasetTypeProperties != nil {
		objectMap["typeProperties"] = artd.AmazonRedshiftTableDatasetTypeProperties
	}
	if artd.Description != nil {
		objectMap["description"] = artd.Description
	}
	if artd.Structure != nil {
		objectMap["structure"] = artd.Structure
	}
	if artd.Schema != nil {
		objectMap["schema"] = artd.Schema
	}
	if artd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = artd.LinkedServiceName
	}
	if artd.Parameters != nil {
		objectMap["parameters"] = artd.Parameters
	}
	if artd.Annotations != nil {
		objectMap["annotations"] = artd.Annotations
	}
	if artd.Folder != nil {
		objectMap["folder"] = artd.Folder
	}
	if artd.Type != "" {
		objectMap["type"] = artd.Type
	}
	for k, v := range artd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return &artd, true
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonRedshiftTableDataset.
func (artd AmazonRedshiftTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &artd, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftTableDataset struct.
func (artd *AmazonRedshiftTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonRedshiftTableDatasetTypeProperties AmazonRedshiftTableDatasetTypeProperties
				err = json.Unmarshal(*v, &amazonRedshiftTableDatasetTypeProperties)
				if err != nil {
					return err
				}
				artd.AmazonRedshiftTableDatasetTypeProperties = &amazonRedshiftTableDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if artd.AdditionalProperties == nil {
					artd.AdditionalProperties = make(map[string]interface{})
				}
				artd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				artd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				artd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				artd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				artd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				artd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				artd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				artd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				artd.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonRedshiftTableDatasetTypeProperties amazon Redshift table dataset properties.
type AmazonRedshiftTableDatasetTypeProperties struct {
	// TableName - This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
	// Table - The Amazon Redshift table name. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
	// Schema - The Amazon Redshift schema name. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`
}

// AmazonS3Dataset a single Amazon Simple Storage Service (S3) object or a set of S3 objects.
type AmazonS3Dataset struct {
	// AmazonS3DatasetTypeProperties - Amazon S3 dataset properties.
	*AmazonS3DatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeSharePointOnlineListResource', 'TypeSnowflakeTable', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeAzureMariaDBTable', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSapTableResource', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapHanaTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSapBwCube', 'TypeSybaseTable', 'TypeSalesforceServiceCloudObject', 'TypeSalesforceObject', 'TypeMicrosoftAccessTable', 'TypePostgreSQLTable', 'TypeMySQLTable', 'TypeOdbcTable', 'TypeInformixTable', 'TypeRelationalTable', 'TypeDb2Table', 'TypeAmazonRedshiftTable', 'TypeAzureMySQLTable', 'TypeTeradataTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeCommonDataServiceForAppsEntity', 'TypeDynamicsCrmEntity', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCosmosDbSQLAPICollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLMITable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeBinary', 'TypeOrc', 'TypeXML', 'TypeJSON', 'TypeDelimitedText', 'TypeParquet', 'TypeExcel', 'TypeAvro', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3Dataset.
func (asd AmazonS3Dataset) MarshalJSON() ([]byte, error) {
	asd.Type = TypeAmazonS3Object
	objectMap := make(map[string]interface{})
	if asd.AmazonS3DatasetTypeProperties != nil {
		objectMap["typeProperties"] = asd.AmazonS3DatasetTypeProperties
	}
	if asd.Description != nil {
		objectMap["description"] = asd.Description
	}
	if asd.Structure != nil {
		objectMap["structure"] = asd.Structure
	}
	if asd.Schema != nil {
		objectMap["schema"] = asd.Schema
	}
	if asd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = asd.LinkedServiceName
	}
	if asd.Parameters != nil {
		objectMap["parameters"] = asd.Parameters
	}
	if asd.Annotations != nil {
		objectMap["annotations"] = asd.Annotations
	}
	if asd.Folder != nil {
		objectMap["folder"] = asd.Folder
	}
	if asd.Type != "" {
		objectMap["type"] = asd.Type
	}
	for k, v := range asd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return &asd, true
}

// AsDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsBasicDataset() (BasicDataset, bool) {
	return &asd, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3Dataset struct.
func (asd *AmazonS3Dataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonS3DatasetTypeProperties AmazonS3DatasetTypeProperties
				err = json.Unmarshal(*v, &amazonS3DatasetTypeProperties)
				if err != nil {
					return err
				}
				asd.AmazonS3DatasetTypeProperties = &amazonS3DatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asd.AdditionalProperties == nil {
					asd.AdditionalProperties = make(map[string]interface{})
				}
				asd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				asd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				asd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				asd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				asd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asd.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3DatasetTypeProperties amazon S3 dataset properties.
type AmazonS3DatasetTypeProperties struct {
	// BucketName - The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
	BucketName interface{} `json:"bucketName,omitempty"`
	// Key - The key of the Amazon S3 object. Type: string (or Expression with resultType string).
	Key interface{} `json:"key,omitempty"`
	// Prefix - The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`
	// Version - The version for the S3 object. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
	// ModifiedDatetimeStart - The start of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// Format - The format of files.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the Amazon S3 object.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3DatasetTypeProperties struct.
func (asdtp *AmazonS3DatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bucketName":
			if v != nil {
				var bucketName interface{}
				err = json.Unmarshal(*v, &bucketName)
				if err != nil {
					return err
				}
				asdtp.BucketName = bucketName
			}
		case "key":
			if v != nil {
				var key interface{}
				err = json.Unmarshal(*v, &key)
				if err != nil {
					return err
				}
				asdtp.Key = key
			}
		case "prefix":
			if v != nil {
				var prefix interface{}
				err = json.Unmarshal(*v, &prefix)
				if err != nil {
					return err
				}
				asdtp.Prefix = prefix
			}
		case "version":
			if v != nil {
				var version interface{}
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				asdtp.Version = version
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				asdtp.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				asdtp.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				asdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				asdtp.Compression = compression
			}
		}
	}

	return nil
}

// AmazonS3LinkedService linked service for Amazon S3.
type AmazonS3LinkedService struct {
	// AmazonS3LinkedServiceTypeProperties - Amazon S3 linked service properties.
	*AmazonS3LinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeAmazonS3
	objectMap := make(map[string]interface{})
	if asls.AmazonS3LinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = asls.AmazonS3LinkedServiceTypeProperties
	}
	if asls.ConnectVia != nil {
		objectMap["connectVia"] = asls.ConnectVia
	}
	if asls.Description != nil {
		objectMap["description"] = asls.Description
	}
	if asls.Parameters != nil {
		objectMap["parameters"] = asls.Parameters
	}
	if asls.Annotations != nil {
		objectMap["annotations"] = asls.Annotations
	}
	if asls.Type != "" {
		objectMap["type"] = asls.Type
	}
	for k, v := range asls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return &asls, true
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3LinkedService struct.
func (asls *AmazonS3LinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var amazonS3LinkedServiceTypeProperties AmazonS3LinkedServiceTypeProperties
				err = json.Unmarshal(*v, &amazonS3LinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				asls.AmazonS3LinkedServiceTypeProperties = &amazonS3LinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asls.AdditionalProperties == nil {
					asls.AdditionalProperties = make(map[string]interface{})
				}
				asls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				asls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				asls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				asls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				asls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asls.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3LinkedServiceTypeProperties amazon S3 linked service properties.
type AmazonS3LinkedServiceTypeProperties struct {
	// AccessKeyID - The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`
	// SecretAccessKey - The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
	SecretAccessKey BasicSecretBase `json:"secretAccessKey,omitempty"`
	// ServiceURL - This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
	ServiceURL interface{} `json:"serviceUrl,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3LinkedServiceTypeProperties struct.
func (aslstp *AmazonS3LinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accessKeyId":
			if v != nil {
				var accessKeyID interface{}
				err = json.Unmarshal(*v, &accessKeyID)
				if err != nil {
					return err
				}
				aslstp.AccessKeyID = accessKeyID
			}
		case "secretAccessKey":
			if v != nil {
				secretAccessKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				aslstp.SecretAccessKey = secretAccessKey
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL interface{}
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				aslstp.ServiceURL = serviceURL
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				aslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AmazonS3Location the location of amazon S3 dataset.
type AmazonS3Location struct {
	// BucketName - Specify the bucketName of amazon S3. Type: string (or Expression with resultType string)
	BucketName interface{} `json:"bucketName,omitempty"`
	// Version - Specify the version of amazon S3. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// FolderPath - Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Type - Possible values include: 'TypeDatasetLocation', 'TypeHdfsLocation', 'TypeHTTPServerLocation', 'TypeSftpLocation', 'TypeFtpServerLocation', 'TypeGoogleCloudStorageLocation', 'TypeAzureFileStorageLocation', 'TypeFileServerLocation', 'TypeAmazonS3Location', 'TypeAzureDataLakeStoreLocation', 'TypeAzureBlobFSLocation', 'TypeAzureBlobStorageLocation'
	Type TypeBasicDatasetLocation `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3Location.
func (asl AmazonS3Location) MarshalJSON() ([]byte, error) {
	asl.Type = TypeAmazonS3Location
	objectMap := make(map[string]interface{})
	if asl.BucketName != nil {
		objectMap["bucketName"] = asl.BucketName
	}
	if asl.Version != nil {
		objectMap["version"] = asl.Version
	}
	if asl.FolderPath != nil {
		objectMap["folderPath"] = asl.FolderPath
	}
	if asl.FileName != nil {
		objectMap["fileName"] = asl.FileName
	}
	if asl.Type != "" {
		objectMap["type"] = asl.Type
	}
	for k, v := range asl.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsHdfsLocation() (*HdfsLocation, bool) {
	return nil, false
}

// AsHTTPServerLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsHTTPServerLocation() (*HTTPServerLocation, bool) {
	return nil, false
}

// AsSftpLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsSftpLocation() (*SftpLocation, bool) {
	return nil, false
}

// AsFtpServerLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsFtpServerLocation() (*FtpServerLocation, bool) {
	return nil, false
}

// AsGoogleCloudStorageLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsGoogleCloudStorageLocation() (*GoogleCloudStorageLocation, bool) {
	return nil, false
}

// AsAzureFileStorageLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAzureFileStorageLocation() (*AzureFileStorageLocation, bool) {
	return nil, false
}

// AsFileServerLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsFileServerLocation() (*FileServerLocation, bool) {
	return nil, false
}

// AsAmazonS3Location is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAmazonS3Location() (*AmazonS3Location, bool) {
	return &asl, true
}

// AsAzureDataLakeStoreLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAzureDataLakeStoreLocation() (*AzureDataLakeStoreLocation, bool) {
	return nil, false
}

// AsAzureBlobFSLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAzureBlobFSLocation() (*AzureBlobFSLocation, bool) {
	return nil, false
}

// AsAzureBlobStorageLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsAzureBlobStorageLocation() (*AzureBlobStorageLocation, bool) {
	return nil, false
}

// AsDatasetLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsDatasetLocation() (*DatasetLocation, bool) {
	return nil, false
}

// AsBasicDatasetLocation is the BasicDatasetLocation implementation for AmazonS3Location.
func (asl AmazonS3Location) AsBasicDatasetLocation() (BasicDatasetLocation, bool) {
	return &asl, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3Location struct.
func (asl *AmazonS3Location) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bucketName":
			if v != nil {
				var bucketName interface{}
				err = json.Unmarshal(*v, &bucketName)
				if err != nil {
					return err
				}
				asl.BucketName = bucketName
			}
		case "version":
			if v != nil {
				var version interface{}
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				asl.Version = version
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asl.AdditionalProperties == nil {
					asl.AdditionalProperties = make(map[string]interface{})
				}
				asl.AdditionalProperties[k] = additionalProperties
			}
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				asl.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				asl.FileName = fileName
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetLocation
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asl.Type = typeVar
			}
		}
	}

	return nil
}

// AmazonS3ReadSettings azure data lake store read settings.
type AmazonS3ReadSettings struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// WildcardFolderPath - AmazonS3 wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
	// WildcardFileName - AmazonS3 wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`
	// Prefix - The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`
	// FileListPath - Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`
	// EnablePartitionDiscovery - Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`
	// PartitionRootPath - Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`
	// ModifiedDatetimeStart - The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeStoreReadSettings', 'TypeHdfsReadSettings', 'TypeHTTPReadSettings', 'TypeSftpReadSettings', 'TypeFtpReadSettings', 'TypeGoogleCloudStorageReadSettings', 'TypeAzureFileStorageReadSettings', 'TypeFileServerReadSettings', 'TypeAmazonS3ReadSettings', 'TypeAzureDataLakeStoreReadSettings', 'TypeAzureBlobFSReadSettings', 'TypeAzureBlobStorageReadSettings'
	Type TypeBasicStoreReadSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) MarshalJSON() ([]byte, error) {
	asrs.Type = TypeAmazonS3ReadSettings
	objectMap := make(map[string]interface{})
	if asrs.Recursive != nil {
		objectMap["recursive"] = asrs.Recursive
	}
	if asrs.WildcardFolderPath != nil {
		objectMap["wildcardFolderPath"] = asrs.WildcardFolderPath
	}
	if asrs.WildcardFileName != nil {
		objectMap["wildcardFileName"] = asrs.WildcardFileName
	}
	if asrs.Prefix != nil {
		objectMap["prefix"] = asrs.Prefix
	}
	if asrs.FileListPath != nil {
		objectMap["fileListPath"] = asrs.FileListPath
	}
	if asrs.EnablePartitionDiscovery != nil {
		objectMap["enablePartitionDiscovery"] = asrs.EnablePartitionDiscovery
	}
	if asrs.PartitionRootPath != nil {
		objectMap["partitionRootPath"] = asrs.PartitionRootPath
	}
	if asrs.ModifiedDatetimeStart != nil {
		objectMap["modifiedDatetimeStart"] = asrs.ModifiedDatetimeStart
	}
	if asrs.ModifiedDatetimeEnd != nil {
		objectMap["modifiedDatetimeEnd"] = asrs.ModifiedDatetimeEnd
	}
	if asrs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = asrs.MaxConcurrentConnections
	}
	if asrs.Type != "" {
		objectMap["type"] = asrs.Type
	}
	for k, v := range asrs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsHdfsReadSettings() (*HdfsReadSettings, bool) {
	return nil, false
}

// AsHTTPReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsHTTPReadSettings() (*HTTPReadSettings, bool) {
	return nil, false
}

// AsSftpReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsSftpReadSettings() (*SftpReadSettings, bool) {
	return nil, false
}

// AsFtpReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsFtpReadSettings() (*FtpReadSettings, bool) {
	return nil, false
}

// AsGoogleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsGoogleCloudStorageReadSettings() (*GoogleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsAzureFileStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAzureFileStorageReadSettings() (*AzureFileStorageReadSettings, bool) {
	return nil, false
}

// AsFileServerReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsFileServerReadSettings() (*FileServerReadSettings, bool) {
	return nil, false
}

// AsAmazonS3ReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAmazonS3ReadSettings() (*AmazonS3ReadSettings, bool) {
	return &asrs, true
}

// AsAzureDataLakeStoreReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAzureDataLakeStoreReadSettings() (*AzureDataLakeStoreReadSettings, bool) {
	return nil, false
}

// AsAzureBlobFSReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAzureBlobFSReadSettings() (*AzureBlobFSReadSettings, bool) {
	return nil, false
}

// AsAzureBlobStorageReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsAzureBlobStorageReadSettings() (*AzureBlobStorageReadSettings, bool) {
	return nil, false
}

// AsStoreReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsStoreReadSettings() (*StoreReadSettings, bool) {
	return nil, false
}

// AsBasicStoreReadSettings is the BasicStoreReadSettings implementation for AmazonS3ReadSettings.
func (asrs AmazonS3ReadSettings) AsBasicStoreReadSettings() (BasicStoreReadSettings, bool) {
	return &asrs, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3ReadSettings struct.
func (asrs *AmazonS3ReadSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				asrs.Recursive = recursive
			}
		case "wildcardFolderPath":
			if v != nil {
				var wildcardFolderPath interface{}
				err = json.Unmarshal(*v, &wildcardFolderPath)
				if err != nil {
					return err
				}
				asrs.WildcardFolderPath = wildcardFolderPath
			}
		case "wildcardFileName":
			if v != nil {
				var wildcardFileName interface{}
				err = json.Unmarshal(*v, &wildcardFileName)
				if err != nil {
					return err
				}
				asrs.WildcardFileName = wildcardFileName
			}
		case "prefix":
			if v != nil {
				var prefix interface{}
				err = json.Unmarshal(*v, &prefix)
				if err != nil {
					return err
				}
				asrs.Prefix = prefix
			}
		case "fileListPath":
			if v != nil {
				var fileListPath interface{}
				err = json.Unmarshal(*v, &fileListPath)
				if err != nil {
					return err
				}
				asrs.FileListPath = fileListPath
			}
		case "enablePartitionDiscovery":
			if v != nil {
				var enablePartitionDiscovery bool
				err = json.Unmarshal(*v, &enablePartitionDiscovery)
				if err != nil {
					return err
				}
				asrs.EnablePartitionDiscovery = &enablePartitionDiscovery
			}
		case "partitionRootPath":
			if v != nil {
				var partitionRootPath interface{}
				err = json.Unmarshal(*v, &partitionRootPath)
				if err != nil {
					return err
				}
				asrs.PartitionRootPath = partitionRootPath
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				asrs.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				asrs.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asrs.AdditionalProperties == nil {
					asrs.AdditionalProperties = make(map[string]interface{})
				}
				asrs.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				asrs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreReadSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asrs.Type = typeVar
			}
		}
	}

	return nil
}

// AppendVariableActivity append value for a Variable of type Array.
type AppendVariableActivity struct {
	// AppendVariableActivityTypeProperties - Append Variable activity properties.
	*AppendVariableActivityTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeExecuteDataFlow', 'TypeAzureFunctionActivity', 'TypeDatabricksSparkPython', 'TypeDatabricksSparkJar', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLExecutePipeline', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeAzureDataExplorerCommand', 'TypeDelete', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeWebHook', 'TypeAppendVariable', 'TypeSetVariable', 'TypeFilter', 'TypeValidation', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeSwitch', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AppendVariableActivity.
func (ava AppendVariableActivity) MarshalJSON() ([]byte, error) {
	ava.Type = TypeAppendVariable
	objectMap := make(map[string]interface{})
	if ava.AppendVariableActivityTypeProperties != nil {
		objectMap["typeProperties"] = ava.AppendVariableActivityTypeProperties
	}
	if ava.Name != nil {
		objectMap["name"] = ava.Name
	}
	if ava.Description != nil {
		objectMap["description"] = ava.Description
	}
	if ava.DependsOn != nil {
		objectMap["dependsOn"] = ava.DependsOn
	}
	if ava.UserProperties != nil {
		objectMap["userProperties"] = ava.UserProperties
	}
	if ava.Type != "" {
		objectMap["type"] = ava.Type
	}
	for k, v := range ava.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsExecuteDataFlowActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecuteDataFlowActivity() (*ExecuteDataFlowActivity, bool) {
	return nil, false
}

// AsAzureFunctionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLExecutePipelineActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureMLExecutePipelineActivity() (*AzureMLExecutePipelineActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsAzureDataExplorerCommandActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAzureDataExplorerCommandActivity() (*AzureDataExplorerCommandActivity, bool) {
	return nil, false
}

// AsDeleteActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsWebHookActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return &ava, true
}

// AsSetVariableActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsSwitchActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsSwitchActivity() (*SwitchActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return &ava, true
}

// AsActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AppendVariableActivity.
func (ava AppendVariableActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ava, true
}

// UnmarshalJSON is the custom unmarshaler for AppendVariableActivity struct.
func (ava *AppendVariableActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var appendVariableActivityTypeProperties AppendVariableActivityTypeProperties
				err = json.Unmarshal(*v, &appendVariableActivityTypeProperties)
				if err != nil {
					return err
				}
				ava.AppendVariableActivityTypeProperties = &appendVariableActivityTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ava.AdditionalProperties == nil {
					ava.AdditionalProperties = make(map[string]interface{})
				}
				ava.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ava.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ava.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				ava.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				ava.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ava.Type = typeVar
			}
		}
	}

	return nil
}

// AppendVariableActivityTypeProperties appendVariable activity properties.
type AppendVariableActivityTypeProperties struct {
	// VariableName - Name of the variable whose value needs to be appended to.
	VariableName *string `json:"variableName,omitempty"`
	// Value - Value to be appended. Could be a static value or Expression
	Value interface{} `json:"value,omitempty"`
}

// AvroDataset avro dataset.
type AvroDataset struct {
	// AvroDatasetTypeProperties - Avro dataset properties.
	*AvroDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeSharePointOnlineListResource', 'TypeSnowflakeTable', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeAzureMariaDBTable', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSapTableResource', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapHanaTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSapBwCube', 'TypeSybaseTable', 'TypeSalesforceServiceCloudObject', 'TypeSalesforceObject', 'TypeMicrosoftAccessTable', 'TypePostgreSQLTable', 'TypeMySQLTable', 'TypeOdbcTable', 'TypeInformixTable', 'TypeRelationalTable', 'TypeDb2Table', 'TypeAmazonRedshiftTable', 'TypeAzureMySQLTable', 'TypeTeradataTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeCommonDataServiceForAppsEntity', 'TypeDynamicsCrmEntity', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCosmosDbSQLAPICollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLMITable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeBinary', 'TypeOrc', 'TypeXML', 'TypeJSON', 'TypeDelimitedText', 'TypeParquet', 'TypeExcel', 'TypeAvro', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroDataset.
func (ad AvroDataset) MarshalJSON() ([]byte, error) {
	ad.Type = TypeAvro
	objectMap := make(map[string]interface{})
	if ad.AvroDatasetTypeProperties != nil {
		objectMap["typeProperties"] = ad.AvroDatasetTypeProperties
	}
	if ad.Description != nil {
		objectMap["description"] = ad.Description
	}
	if ad.Structure != nil {
		objectMap["structure"] = ad.Structure
	}
	if ad.Schema != nil {
		objectMap["schema"] = ad.Schema
	}
	if ad.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = ad.LinkedServiceName
	}
	if ad.Parameters != nil {
		objectMap["parameters"] = ad.Parameters
	}
	if ad.Annotations != nil {
		objectMap["annotations"] = ad.Annotations
	}
	if ad.Folder != nil {
		objectMap["folder"] = ad.Folder
	}
	if ad.Type != "" {
		objectMap["type"] = ad.Type
	}
	for k, v := range ad.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAvroDataset() (*AvroDataset, bool) {
	return &ad, true
}

// AsAmazonS3Dataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AvroDataset.
func (ad AvroDataset) AsBasicDataset() (BasicDataset, bool) {
	return &ad, true
}

// UnmarshalJSON is the custom unmarshaler for AvroDataset struct.
func (ad *AvroDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var avroDatasetTypeProperties AvroDatasetTypeProperties
				err = json.Unmarshal(*v, &avroDatasetTypeProperties)
				if err != nil {
					return err
				}
				ad.AvroDatasetTypeProperties = &avroDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ad.AdditionalProperties == nil {
					ad.AdditionalProperties = make(map[string]interface{})
				}
				ad.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ad.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				ad.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				ad.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ad.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				ad.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				ad.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				ad.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ad.Type = typeVar
			}
		}
	}

	return nil
}

// AvroDatasetTypeProperties avro dataset properties.
type AvroDatasetTypeProperties struct {
	// Location - The location of the avro storage.
	Location BasicDatasetLocation `json:"location,omitempty"`
	// AvroCompressionCodec - Possible values include: 'None', 'Deflate', 'Snappy', 'Xz', 'Bzip2'
	AvroCompressionCodec AvroCompressionCodec `json:"avroCompressionCodec,omitempty"`
	AvroCompressionLevel *int32               `json:"avroCompressionLevel,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AvroDatasetTypeProperties struct.
func (adtp *AvroDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				location, err := unmarshalBasicDatasetLocation(*v)
				if err != nil {
					return err
				}
				adtp.Location = location
			}
		case "avroCompressionCodec":
			if v != nil {
				var avroCompressionCodec AvroCompressionCodec
				err = json.Unmarshal(*v, &avroCompressionCodec)
				if err != nil {
					return err
				}
				adtp.AvroCompressionCodec = avroCompressionCodec
			}
		case "avroCompressionLevel":
			if v != nil {
				var avroCompressionLevel int32
				err = json.Unmarshal(*v, &avroCompressionLevel)
				if err != nil {
					return err
				}
				adtp.AvroCompressionLevel = &avroCompressionLevel
			}
		}
	}

	return nil
}

// AvroFormat the data stored in Avro format.
type AvroFormat struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Serializer - Serializer. Type: string (or Expression with resultType string).
	Serializer interface{} `json:"serializer,omitempty"`
	// Deserializer - Deserializer. Type: string (or Expression with resultType string).
	Deserializer interface{} `json:"deserializer,omitempty"`
	// Type - Possible values include: 'TypeDatasetStorageFormat', 'TypeParquetFormat', 'TypeOrcFormat', 'TypeAvroFormat', 'TypeJSONFormat', 'TypeTextFormat'
	Type TypeBasicDatasetStorageFormat `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroFormat.
func (af AvroFormat) MarshalJSON() ([]byte, error) {
	af.Type = TypeAvroFormat
	objectMap := make(map[string]interface{})
	if af.Serializer != nil {
		objectMap["serializer"] = af.Serializer
	}
	if af.Deserializer != nil {
		objectMap["deserializer"] = af.Deserializer
	}
	if af.Type != "" {
		objectMap["type"] = af.Type
	}
	for k, v := range af.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsParquetFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsParquetFormat() (*ParquetFormat, bool) {
	return nil, false
}

// AsOrcFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsOrcFormat() (*OrcFormat, bool) {
	return nil, false
}

// AsAvroFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsAvroFormat() (*AvroFormat, bool) {
	return &af, true
}

// AsJSONFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsJSONFormat() (*JSONFormat, bool) {
	return nil, false
}

// AsTextFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsTextFormat() (*TextFormat, bool) {
	return nil, false
}

// AsDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsDatasetStorageFormat() (*DatasetStorageFormat, bool) {
	return nil, false
}

// AsBasicDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsBasicDatasetStorageFormat() (BasicDatasetStorageFormat, bool) {
	return &af, true
}

// UnmarshalJSON is the custom unmarshaler for AvroFormat struct.
func (af *AvroFormat) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if af.AdditionalProperties == nil {
					af.AdditionalProperties = make(map[string]interface{})
				}
				af.AdditionalProperties[k] = additionalProperties
			}
		case "serializer":
			if v != nil {
				var serializer interface{}
				err = json.Unmarshal(*v, &serializer)
				if err != nil {
					return err
				}
				af.Serializer = serializer
			}
		case "deserializer":
			if v != nil {
				var deserializer interface{}
				err = json.Unmarshal(*v, &deserializer)
				if err != nil {
					return err
				}
				af.Deserializer = deserializer
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetStorageFormat
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				af.Type = typeVar
			}
		}
	}

	return nil
}

// AvroSink a copy activity Avro sink.
type AvroSink struct {
	// StoreSettings - Avro store settings.
	StoreSettings BasicStoreWriteSettings `json:"storeSettings,omitempty"`
	// FormatSettings - Avro format settings.
	FormatSettings *AvroWriteSettings `json:"formatSettings,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeCosmosDbMongoDbAPISink', 'TypeSalesforceServiceCloudSink', 'TypeSalesforceSink', 'TypeAzureDataExplorerSink', 'TypeCommonDataServiceForAppsSink', 'TypeDynamicsCrmSink', 'TypeDynamicsSink', 'TypeMicrosoftAccessSink', 'TypeInformixSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureBlobFSSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSnowflakeSink', 'TypeSQLDWSink', 'TypeSQLMISink', 'TypeAzureSQLSink', 'TypeSQLServerSink', 'TypeSQLSink', 'TypeCosmosDbSQLAPISink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeBinarySink', 'TypeParquetSink', 'TypeAvroSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink', 'TypeAzureMySQLSink', 'TypeAzurePostgreSQLSink', 'TypeOrcSink', 'TypeJSONSink', 'TypeDelimitedTextSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroSink.
func (as AvroSink) MarshalJSON() ([]byte, error) {
	as.Type = TypeAvroSink
	objectMap := make(map[string]interface{})
	objectMap["storeSettings"] = as.StoreSettings
	if as.FormatSettings != nil {
		objectMap["formatSettings"] = as.FormatSettings
	}
	if as.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = as.WriteBatchSize
	}
	if as.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = as.WriteBatchTimeout
	}
	if as.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = as.SinkRetryCount
	}
	if as.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = as.SinkRetryWait
	}
	if as.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = as.MaxConcurrentConnections
	}
	if as.Type != "" {
		objectMap["type"] = as.Type
	}
	for k, v := range as.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSalesforceServiceCloudSink() (*SalesforceServiceCloudSink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsCommonDataServiceForAppsSink() (*CommonDataServiceForAppsSink, bool) {
	return nil, false
}

// AsDynamicsCrmSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsDynamicsCrmSink() (*DynamicsCrmSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsMicrosoftAccessSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsMicrosoftAccessSink() (*MicrosoftAccessSink, bool) {
	return nil, false
}

// AsInformixSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsInformixSink() (*InformixSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSnowflakeSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSnowflakeSink() (*SnowflakeSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLMISink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSQLMISink() (*SQLMISink, bool) {
	return nil, false
}

// AsAzureSQLSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureSQLSink() (*AzureSQLSink, bool) {
	return nil, false
}

// AsSQLServerSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSQLServerSink() (*SQLServerSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsCosmosDbSQLAPISink() (*CosmosDbSQLAPISink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsBinarySink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsBinarySink() (*BinarySink, bool) {
	return nil, false
}

// AsParquetSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsParquetSink() (*ParquetSink, bool) {
	return nil, false
}

// AsAvroSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAvroSink() (*AvroSink, bool) {
	return &as, true
}

// AsAzureTableSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsAzureMySQLSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzureMySQLSink() (*AzureMySQLSink, bool) {
	return nil, false
}

// AsAzurePostgreSQLSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsAzurePostgreSQLSink() (*AzurePostgreSQLSink, bool) {
	return nil, false
}

// AsOrcSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsOrcSink() (*OrcSink, bool) {
	return nil, false
}

// AsJSONSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsJSONSink() (*JSONSink, bool) {
	return nil, false
}

// AsDelimitedTextSink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsDelimitedTextSink() (*DelimitedTextSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AvroSink.
func (as AvroSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &as, true
}

// UnmarshalJSON is the custom unmarshaler for AvroSink struct.
func (as *AvroSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "storeSettings":
			if v != nil {
				storeSettings, err := unmarshalBasicStoreWriteSettings(*v)
				if err != nil {
					return err
				}
				as.StoreSettings = storeSettings
			}
		case "formatSettings":
			if v != nil {
				var formatSettings AvroWriteSettings
				err = json.Unmarshal(*v, &formatSettings)
				if err != nil {
					return err
				}
				as.FormatSettings = &formatSettings
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if as.AdditionalProperties == nil {
					as.AdditionalProperties = make(map[string]interface{})
				}
				as.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				as.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				as.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				as.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				as.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				as.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = typeVar
			}
		}
	}

	return nil
}

// AvroSource a copy activity Avro source.
type AvroSource struct {
	// StoreSettings - Avro store settings.
	StoreSettings BasicStoreReadSettings `json:"storeSettings,omitempty"`
	// AdditionalColumns - Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects).
	AdditionalColumns *[]AdditionalColumns `json:"additionalColumns,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeSharePointOnlineListSource', 'TypeSnowflakeSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeRestSource', 'TypeSalesforceServiceCloudSource', 'TypeODataSource', 'TypeMicrosoftAccessSource', 'TypeRelationalSource', 'TypeCommonDataServiceForAppsSource', 'TypeDynamicsCrmSource', 'TypeDynamicsSource', 'TypeCosmosDbSQLAPISource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeAzureMariaDBSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeCassandraSource', 'TypeTeradataSource', 'TypeAzureMySQLSource', 'TypeSQLDWSource', 'TypeSQLMISource', 'TypeAzureSQLSource', 'TypeSQLServerSource', 'TypeSQLSource', 'TypeSapTableSource', 'TypeSapOpenHubSource', 'TypeSapHanaSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeSapBwSource', 'TypeSybaseSource', 'TypePostgreSQLSource', 'TypeMySQLSource', 'TypeOdbcSource', 'TypeDb2Source', 'TypeInformixSource', 'TypeAzureTableSource', 'TypeTabularSource', 'TypeBinarySource', 'TypeOrcSource', 'TypeXMLSource', 'TypeJSONSource', 'TypeDelimitedTextSource', 'TypeParquetSource', 'TypeExcelSource', 'TypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroSource.
func (as AvroSource) MarshalJSON() ([]byte, error) {
	as.Type = TypeAvroSource
	objectMap := make(map[string]interface{})
	objectMap["storeSettings"] = as.StoreSettings
	if as.AdditionalColumns != nil {
		objectMap["additionalColumns"] = as.AdditionalColumns
	}
	if as.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = as.SourceRetryCount
	}
	if as.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = as.SourceRetryWait
	}
	if as.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = as.MaxConcurrentConnections
	}
	if as.Type != "" {
		objectMap["type"] = as.Type
	}
	for k, v := range as.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return nil, false
}

// AsBinarySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsAvroSource() (*AvroSource, bool) {
	return &as, true
}

// AsCopySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AvroSource.
func (as AvroSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &as, true
}

// UnmarshalJSON is the custom unmarshaler for AvroSource struct.
func (as *AvroSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "storeSettings":
			if v != nil {
				storeSettings, err := unmarshalBasicStoreReadSettings(*v)
				if err != nil {
					return err
				}
				as.StoreSettings = storeSettings
			}
		case "additionalColumns":
			if v != nil {
				var additionalColumns []AdditionalColumns
				err = json.Unmarshal(*v, &additionalColumns)
				if err != nil {
					return err
				}
				as.AdditionalColumns = &additionalColumns
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if as.AdditionalProperties == nil {
					as.AdditionalProperties = make(map[string]interface{})
				}
				as.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				as.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				as.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				as.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = typeVar
			}
		}
	}

	return nil
}

// AvroWriteSettings avro write settings.
type AvroWriteSettings struct {
	// RecordName - Top level record name in write result, which is required in AVRO spec.
	RecordName *string `json:"recordName,omitempty"`
	// RecordNamespace - Record namespace in the write result.
	RecordNamespace *string `json:"recordNamespace,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - Possible values include: 'TypeFormatWriteSettings', 'TypeJSONWriteSettings', 'TypeDelimitedTextWriteSettings', 'TypeAvroWriteSettings'
	Type TypeBasicFormatWriteSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroWriteSettings.
func (aws AvroWriteSettings) MarshalJSON() ([]byte, error) {
	aws.Type = TypeAvroWriteSettings
	objectMap := make(map[string]interface{})
	if aws.RecordName != nil {
		objectMap["recordName"] = aws.RecordName
	}
	if aws.RecordNamespace != nil {
		objectMap["recordNamespace"] = aws.RecordNamespace
	}
	if aws.Type != "" {
		objectMap["type"] = aws.Type
	}
	for k, v := range aws.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsJSONWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsJSONWriteSettings() (*JSONWriteSettings, bool) {
	return nil, false
}

// AsDelimitedTextWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsDelimitedTextWriteSettings() (*DelimitedTextWriteSettings, bool) {
	return nil, false
}

// AsAvroWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsAvroWriteSettings() (*AvroWriteSettings, bool) {
	return &aws, true
}

// AsFormatWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsFormatWriteSettings() (*FormatWriteSettings, bool) {
	return nil, false
}

// AsBasicFormatWriteSettings is the BasicFormatWriteSettings implementation for AvroWriteSettings.
func (aws AvroWriteSettings) AsBasicFormatWriteSettings() (BasicFormatWriteSettings, bool) {
	return &aws, true
}

// UnmarshalJSON is the custom unmarshaler for AvroWriteSettings struct.
func (aws *AvroWriteSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recordName":
			if v != nil {
				var recordName string
				err = json.Unmarshal(*v, &recordName)
				if err != nil {
					return err
				}
				aws.RecordName = &recordName
			}
		case "recordNamespace":
			if v != nil {
				var recordNamespace string
				err = json.Unmarshal(*v, &recordNamespace)
				if err != nil {
					return err
				}
				aws.RecordNamespace = &recordNamespace
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if aws.AdditionalProperties == nil {
					aws.AdditionalProperties = make(map[string]interface{})
				}
				aws.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicFormatWriteSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aws.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBatchLinkedService azure Batch linked service.
type AzureBatchLinkedService struct {
	// AzureBatchLinkedServiceTypeProperties - Azure Batch linked service properties.
	*AzureBatchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) MarshalJSON() ([]byte, error) {
	abls.Type = TypeAzureBatch
	objectMap := make(map[string]interface{})
	if abls.AzureBatchLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = abls.AzureBatchLinkedServiceTypeProperties
	}
	if abls.ConnectVia != nil {
		objectMap["connectVia"] = abls.ConnectVia
	}
	if abls.Description != nil {
		objectMap["description"] = abls.Description
	}
	if abls.Parameters != nil {
		objectMap["parameters"] = abls.Parameters
	}
	if abls.Annotations != nil {
		objectMap["annotations"] = abls.Annotations
	}
	if abls.Type != "" {
		objectMap["type"] = abls.Type
	}
	for k, v := range abls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return &abls, true
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &abls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBatchLinkedService struct.
func (abls *AzureBatchLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBatchLinkedServiceTypeProperties AzureBatchLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBatchLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				abls.AzureBatchLinkedServiceTypeProperties = &azureBatchLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abls.AdditionalProperties == nil {
					abls.AdditionalProperties = make(map[string]interface{})
				}
				abls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				abls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBatchLinkedServiceTypeProperties azure Batch linked service properties.
type AzureBatchLinkedServiceTypeProperties struct {
	// AccountName - The Azure Batch account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// AccessKey - The Azure Batch account access key.
	AccessKey BasicSecretBase `json:"accessKey,omitempty"`
	// BatchURI - The Azure Batch URI. Type: string (or Expression with resultType string).
	BatchURI interface{} `json:"batchUri,omitempty"`
	// PoolName - The Azure Batch pool name. Type: string (or Expression with resultType string).
	PoolName interface{} `json:"poolName,omitempty"`
	// LinkedServiceName - The Azure Storage linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBatchLinkedServiceTypeProperties struct.
func (ablstp *AzureBatchLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				ablstp.AccountName = accountName
			}
		case "accessKey":
			if v != nil {
				accessKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				ablstp.AccessKey = accessKey
			}
		case "batchUri":
			if v != nil {
				var batchURI interface{}
				err = json.Unmarshal(*v, &batchURI)
				if err != nil {
					return err
				}
				ablstp.BatchURI = batchURI
			}
		case "poolName":
			if v != nil {
				var poolName interface{}
				err = json.Unmarshal(*v, &poolName)
				if err != nil {
					return err
				}
				ablstp.PoolName = poolName
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				ablstp.LinkedServiceName = &linkedServiceName
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				ablstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureBlobDataset the Azure Blob storage.
type AzureBlobDataset struct {
	// AzureBlobDatasetTypeProperties - Azure Blob dataset properties.
	*AzureBlobDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeSharePointOnlineListResource', 'TypeSnowflakeTable', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeAzureMariaDBTable', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSapTableResource', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapHanaTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSapBwCube', 'TypeSybaseTable', 'TypeSalesforceServiceCloudObject', 'TypeSalesforceObject', 'TypeMicrosoftAccessTable', 'TypePostgreSQLTable', 'TypeMySQLTable', 'TypeOdbcTable', 'TypeInformixTable', 'TypeRelationalTable', 'TypeDb2Table', 'TypeAmazonRedshiftTable', 'TypeAzureMySQLTable', 'TypeTeradataTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeCommonDataServiceForAppsEntity', 'TypeDynamicsCrmEntity', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCosmosDbSQLAPICollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLMITable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeBinary', 'TypeOrc', 'TypeXML', 'TypeJSON', 'TypeDelimitedText', 'TypeParquet', 'TypeExcel', 'TypeAvro', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobDataset.
func (abd AzureBlobDataset) MarshalJSON() ([]byte, error) {
	abd.Type = TypeAzureBlob
	objectMap := make(map[string]interface{})
	if abd.AzureBlobDatasetTypeProperties != nil {
		objectMap["typeProperties"] = abd.AzureBlobDatasetTypeProperties
	}
	if abd.Description != nil {
		objectMap["description"] = abd.Description
	}
	if abd.Structure != nil {
		objectMap["structure"] = abd.Structure
	}
	if abd.Schema != nil {
		objectMap["schema"] = abd.Schema
	}
	if abd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = abd.LinkedServiceName
	}
	if abd.Parameters != nil {
		objectMap["parameters"] = abd.Parameters
	}
	if abd.Annotations != nil {
		objectMap["annotations"] = abd.Annotations
	}
	if abd.Folder != nil {
		objectMap["folder"] = abd.Folder
	}
	if abd.Type != "" {
		objectMap["type"] = abd.Type
	}
	for k, v := range abd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return &abd, true
}

// AsBinaryDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsBasicDataset() (BasicDataset, bool) {
	return &abd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDataset struct.
func (abd *AzureBlobDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobDatasetTypeProperties AzureBlobDatasetTypeProperties
				err = json.Unmarshal(*v, &azureBlobDatasetTypeProperties)
				if err != nil {
					return err
				}
				abd.AzureBlobDatasetTypeProperties = &azureBlobDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abd.AdditionalProperties == nil {
					abd.AdditionalProperties = make(map[string]interface{})
				}
				abd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				abd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				abd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				abd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				abd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobDatasetTypeProperties azure Blob dataset properties.
type AzureBlobDatasetTypeProperties struct {
	// FolderPath - The path of the Azure Blob storage. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// TableRootLocation - The root of blob path. Type: string (or Expression with resultType string).
	TableRootLocation interface{} `json:"tableRootLocation,omitempty"`
	// FileName - The name of the Azure Blob. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// ModifiedDatetimeStart - The start of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// Format - The format of the Azure Blob storage.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the blob storage.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDatasetTypeProperties struct.
func (abdtp *AzureBlobDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				abdtp.FolderPath = folderPath
			}
		case "tableRootLocation":
			if v != nil {
				var tableRootLocation interface{}
				err = json.Unmarshal(*v, &tableRootLocation)
				if err != nil {
					return err
				}
				abdtp.TableRootLocation = tableRootLocation
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				abdtp.FileName = fileName
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				abdtp.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				abdtp.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				abdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				abdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureBlobFSDataset the Azure Data Lake Storage Gen2 storage.
type AzureBlobFSDataset struct {
	// AzureBlobFSDatasetTypeProperties - Azure Data Lake Storage Gen2 dataset properties.
	*AzureBlobFSDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeSharePointOnlineListResource', 'TypeSnowflakeTable', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeAzureMariaDBTable', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSapTableResource', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapHanaTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSapBwCube', 'TypeSybaseTable', 'TypeSalesforceServiceCloudObject', 'TypeSalesforceObject', 'TypeMicrosoftAccessTable', 'TypePostgreSQLTable', 'TypeMySQLTable', 'TypeOdbcTable', 'TypeInformixTable', 'TypeRelationalTable', 'TypeDb2Table', 'TypeAmazonRedshiftTable', 'TypeAzureMySQLTable', 'TypeTeradataTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeCommonDataServiceForAppsEntity', 'TypeDynamicsCrmEntity', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCosmosDbSQLAPICollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLMITable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeBinary', 'TypeOrc', 'TypeXML', 'TypeJSON', 'TypeDelimitedText', 'TypeParquet', 'TypeExcel', 'TypeAvro', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) MarshalJSON() ([]byte, error) {
	abfd.Type = TypeAzureBlobFSFile
	objectMap := make(map[string]interface{})
	if abfd.AzureBlobFSDatasetTypeProperties != nil {
		objectMap["typeProperties"] = abfd.AzureBlobFSDatasetTypeProperties
	}
	if abfd.Description != nil {
		objectMap["description"] = abfd.Description
	}
	if abfd.Structure != nil {
		objectMap["structure"] = abfd.Structure
	}
	if abfd.Schema != nil {
		objectMap["schema"] = abfd.Schema
	}
	if abfd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = abfd.LinkedServiceName
	}
	if abfd.Parameters != nil {
		objectMap["parameters"] = abfd.Parameters
	}
	if abfd.Annotations != nil {
		objectMap["annotations"] = abfd.Annotations
	}
	if abfd.Folder != nil {
		objectMap["folder"] = abfd.Folder
	}
	if abfd.Type != "" {
		objectMap["type"] = abfd.Type
	}
	for k, v := range abfd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return &abfd, true
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureBlobFSDataset.
func (abfd AzureBlobFSDataset) AsBasicDataset() (BasicDataset, bool) {
	return &abfd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSDataset struct.
func (abfd *AzureBlobFSDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobFSDatasetTypeProperties AzureBlobFSDatasetTypeProperties
				err = json.Unmarshal(*v, &azureBlobFSDatasetTypeProperties)
				if err != nil {
					return err
				}
				abfd.AzureBlobFSDatasetTypeProperties = &azureBlobFSDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfd.AdditionalProperties == nil {
					abfd.AdditionalProperties = make(map[string]interface{})
				}
				abfd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abfd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				abfd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				abfd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				abfd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abfd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abfd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				abfd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSDatasetTypeProperties azure Data Lake Storage Gen2 dataset properties.
type AzureBlobFSDatasetTypeProperties struct {
	// FolderPath - The path of the Azure Data Lake Storage Gen2 storage. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - The name of the Azure Data Lake Storage Gen2. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Format - The format of the Azure Data Lake Storage Gen2 storage.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the blob storage.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSDatasetTypeProperties struct.
func (abfdtp *AzureBlobFSDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				abfdtp.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				abfdtp.FileName = fileName
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				abfdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				abfdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureBlobFSLinkedService azure Data Lake Storage Gen2 linked service.
type AzureBlobFSLinkedService struct {
	// AzureBlobFSLinkedServiceTypeProperties - Azure Data Lake Storage Gen2 linked service properties.
	*AzureBlobFSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) MarshalJSON() ([]byte, error) {
	abfls.Type = TypeAzureBlobFS
	objectMap := make(map[string]interface{})
	if abfls.AzureBlobFSLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = abfls.AzureBlobFSLinkedServiceTypeProperties
	}
	if abfls.ConnectVia != nil {
		objectMap["connectVia"] = abfls.ConnectVia
	}
	if abfls.Description != nil {
		objectMap["description"] = abfls.Description
	}
	if abfls.Parameters != nil {
		objectMap["parameters"] = abfls.Parameters
	}
	if abfls.Annotations != nil {
		objectMap["annotations"] = abfls.Annotations
	}
	if abfls.Type != "" {
		objectMap["type"] = abfls.Type
	}
	for k, v := range abfls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return &abfls, true
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBlobFSLinkedService.
func (abfls AzureBlobFSLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &abfls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSLinkedService struct.
func (abfls *AzureBlobFSLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobFSLinkedServiceTypeProperties AzureBlobFSLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBlobFSLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				abfls.AzureBlobFSLinkedServiceTypeProperties = &azureBlobFSLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfls.AdditionalProperties == nil {
					abfls.AdditionalProperties = make(map[string]interface{})
				}
				abfls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				abfls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				abfls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				abfls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				abfls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSLinkedServiceTypeProperties azure Data Lake Storage Gen2 linked service properties.
type AzureBlobFSLinkedServiceTypeProperties struct {
	// URL - Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	URL interface{} `json:"url,omitempty"`
	// AccountKey - Account key for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	AccountKey interface{} `json:"accountKey,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Storage Gen2 account. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Storage Gen2 account.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSLinkedServiceTypeProperties struct.
func (abflstp *AzureBlobFSLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "url":
			if v != nil {
				var URL interface{}
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				abflstp.URL = URL
			}
		case "accountKey":
			if v != nil {
				var accountKey interface{}
				err = json.Unmarshal(*v, &accountKey)
				if err != nil {
					return err
				}
				abflstp.AccountKey = accountKey
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				abflstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				abflstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				abflstp.Tenant = tenant
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				abflstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureBlobFSLocation the location of azure blobFS dataset.
type AzureBlobFSLocation struct {
	// FileSystem - Specify the fileSystem of azure blobFS. Type: string (or Expression with resultType string).
	FileSystem interface{} `json:"fileSystem,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// FolderPath - Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Type - Possible values include: 'TypeDatasetLocation', 'TypeHdfsLocation', 'TypeHTTPServerLocation', 'TypeSftpLocation', 'TypeFtpServerLocation', 'TypeGoogleCloudStorageLocation', 'TypeAzureFileStorageLocation', 'TypeFileServerLocation', 'TypeAmazonS3Location', 'TypeAzureDataLakeStoreLocation', 'TypeAzureBlobFSLocation', 'TypeAzureBlobStorageLocation'
	Type TypeBasicDatasetLocation `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) MarshalJSON() ([]byte, error) {
	abfl.Type = TypeAzureBlobFSLocation
	objectMap := make(map[string]interface{})
	if abfl.FileSystem != nil {
		objectMap["fileSystem"] = abfl.FileSystem
	}
	if abfl.FolderPath != nil {
		objectMap["folderPath"] = abfl.FolderPath
	}
	if abfl.FileName != nil {
		objectMap["fileName"] = abfl.FileName
	}
	if abfl.Type != "" {
		objectMap["type"] = abfl.Type
	}
	for k, v := range abfl.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsHdfsLocation() (*HdfsLocation, bool) {
	return nil, false
}

// AsHTTPServerLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsHTTPServerLocation() (*HTTPServerLocation, bool) {
	return nil, false
}

// AsSftpLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsSftpLocation() (*SftpLocation, bool) {
	return nil, false
}

// AsFtpServerLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsFtpServerLocation() (*FtpServerLocation, bool) {
	return nil, false
}

// AsGoogleCloudStorageLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsGoogleCloudStorageLocation() (*GoogleCloudStorageLocation, bool) {
	return nil, false
}

// AsAzureFileStorageLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAzureFileStorageLocation() (*AzureFileStorageLocation, bool) {
	return nil, false
}

// AsFileServerLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsFileServerLocation() (*FileServerLocation, bool) {
	return nil, false
}

// AsAmazonS3Location is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAmazonS3Location() (*AmazonS3Location, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAzureDataLakeStoreLocation() (*AzureDataLakeStoreLocation, bool) {
	return nil, false
}

// AsAzureBlobFSLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAzureBlobFSLocation() (*AzureBlobFSLocation, bool) {
	return &abfl, true
}

// AsAzureBlobStorageLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsAzureBlobStorageLocation() (*AzureBlobStorageLocation, bool) {
	return nil, false
}

// AsDatasetLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsDatasetLocation() (*DatasetLocation, bool) {
	return nil, false
}

// AsBasicDatasetLocation is the BasicDatasetLocation implementation for AzureBlobFSLocation.
func (abfl AzureBlobFSLocation) AsBasicDatasetLocation() (BasicDatasetLocation, bool) {
	return &abfl, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSLocation struct.
func (abfl *AzureBlobFSLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "fileSystem":
			if v != nil {
				var fileSystem interface{}
				err = json.Unmarshal(*v, &fileSystem)
				if err != nil {
					return err
				}
				abfl.FileSystem = fileSystem
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfl.AdditionalProperties == nil {
					abfl.AdditionalProperties = make(map[string]interface{})
				}
				abfl.AdditionalProperties[k] = additionalProperties
			}
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				abfl.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				abfl.FileName = fileName
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetLocation
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfl.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSReadSettings azure blobFS read settings.
type AzureBlobFSReadSettings struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// WildcardFolderPath - Azure blobFS wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
	// WildcardFileName - Azure blobFS wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`
	// FileListPath - Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`
	// EnablePartitionDiscovery - Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`
	// PartitionRootPath - Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`
	// ModifiedDatetimeStart - The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeStoreReadSettings', 'TypeHdfsReadSettings', 'TypeHTTPReadSettings', 'TypeSftpReadSettings', 'TypeFtpReadSettings', 'TypeGoogleCloudStorageReadSettings', 'TypeAzureFileStorageReadSettings', 'TypeFileServerReadSettings', 'TypeAmazonS3ReadSettings', 'TypeAzureDataLakeStoreReadSettings', 'TypeAzureBlobFSReadSettings', 'TypeAzureBlobStorageReadSettings'
	Type TypeBasicStoreReadSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) MarshalJSON() ([]byte, error) {
	abfrs.Type = TypeAzureBlobFSReadSettings
	objectMap := make(map[string]interface{})
	if abfrs.Recursive != nil {
		objectMap["recursive"] = abfrs.Recursive
	}
	if abfrs.WildcardFolderPath != nil {
		objectMap["wildcardFolderPath"] = abfrs.WildcardFolderPath
	}
	if abfrs.WildcardFileName != nil {
		objectMap["wildcardFileName"] = abfrs.WildcardFileName
	}
	if abfrs.FileListPath != nil {
		objectMap["fileListPath"] = abfrs.FileListPath
	}
	if abfrs.EnablePartitionDiscovery != nil {
		objectMap["enablePartitionDiscovery"] = abfrs.EnablePartitionDiscovery
	}
	if abfrs.PartitionRootPath != nil {
		objectMap["partitionRootPath"] = abfrs.PartitionRootPath
	}
	if abfrs.ModifiedDatetimeStart != nil {
		objectMap["modifiedDatetimeStart"] = abfrs.ModifiedDatetimeStart
	}
	if abfrs.ModifiedDatetimeEnd != nil {
		objectMap["modifiedDatetimeEnd"] = abfrs.ModifiedDatetimeEnd
	}
	if abfrs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfrs.MaxConcurrentConnections
	}
	if abfrs.Type != "" {
		objectMap["type"] = abfrs.Type
	}
	for k, v := range abfrs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsHdfsReadSettings() (*HdfsReadSettings, bool) {
	return nil, false
}

// AsHTTPReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsHTTPReadSettings() (*HTTPReadSettings, bool) {
	return nil, false
}

// AsSftpReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsSftpReadSettings() (*SftpReadSettings, bool) {
	return nil, false
}

// AsFtpReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsFtpReadSettings() (*FtpReadSettings, bool) {
	return nil, false
}

// AsGoogleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsGoogleCloudStorageReadSettings() (*GoogleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsAzureFileStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAzureFileStorageReadSettings() (*AzureFileStorageReadSettings, bool) {
	return nil, false
}

// AsFileServerReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsFileServerReadSettings() (*FileServerReadSettings, bool) {
	return nil, false
}

// AsAmazonS3ReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAmazonS3ReadSettings() (*AmazonS3ReadSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAzureDataLakeStoreReadSettings() (*AzureDataLakeStoreReadSettings, bool) {
	return nil, false
}

// AsAzureBlobFSReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAzureBlobFSReadSettings() (*AzureBlobFSReadSettings, bool) {
	return &abfrs, true
}

// AsAzureBlobStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsAzureBlobStorageReadSettings() (*AzureBlobStorageReadSettings, bool) {
	return nil, false
}

// AsStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsStoreReadSettings() (*StoreReadSettings, bool) {
	return nil, false
}

// AsBasicStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobFSReadSettings.
func (abfrs AzureBlobFSReadSettings) AsBasicStoreReadSettings() (BasicStoreReadSettings, bool) {
	return &abfrs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSReadSettings struct.
func (abfrs *AzureBlobFSReadSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				abfrs.Recursive = recursive
			}
		case "wildcardFolderPath":
			if v != nil {
				var wildcardFolderPath interface{}
				err = json.Unmarshal(*v, &wildcardFolderPath)
				if err != nil {
					return err
				}
				abfrs.WildcardFolderPath = wildcardFolderPath
			}
		case "wildcardFileName":
			if v != nil {
				var wildcardFileName interface{}
				err = json.Unmarshal(*v, &wildcardFileName)
				if err != nil {
					return err
				}
				abfrs.WildcardFileName = wildcardFileName
			}
		case "fileListPath":
			if v != nil {
				var fileListPath interface{}
				err = json.Unmarshal(*v, &fileListPath)
				if err != nil {
					return err
				}
				abfrs.FileListPath = fileListPath
			}
		case "enablePartitionDiscovery":
			if v != nil {
				var enablePartitionDiscovery bool
				err = json.Unmarshal(*v, &enablePartitionDiscovery)
				if err != nil {
					return err
				}
				abfrs.EnablePartitionDiscovery = &enablePartitionDiscovery
			}
		case "partitionRootPath":
			if v != nil {
				var partitionRootPath interface{}
				err = json.Unmarshal(*v, &partitionRootPath)
				if err != nil {
					return err
				}
				abfrs.PartitionRootPath = partitionRootPath
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				abfrs.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				abfrs.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfrs.AdditionalProperties == nil {
					abfrs.AdditionalProperties = make(map[string]interface{})
				}
				abfrs.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfrs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreReadSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfrs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSSink a copy activity Azure Data Lake Storage Gen2 sink.
type AzureBlobFSSink struct {
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeCosmosDbMongoDbAPISink', 'TypeSalesforceServiceCloudSink', 'TypeSalesforceSink', 'TypeAzureDataExplorerSink', 'TypeCommonDataServiceForAppsSink', 'TypeDynamicsCrmSink', 'TypeDynamicsSink', 'TypeMicrosoftAccessSink', 'TypeInformixSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureBlobFSSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSnowflakeSink', 'TypeSQLDWSink', 'TypeSQLMISink', 'TypeAzureSQLSink', 'TypeSQLServerSink', 'TypeSQLSink', 'TypeCosmosDbSQLAPISink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeBinarySink', 'TypeParquetSink', 'TypeAvroSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink', 'TypeAzureMySQLSink', 'TypeAzurePostgreSQLSink', 'TypeOrcSink', 'TypeJSONSink', 'TypeDelimitedTextSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSSink.
func (abfs AzureBlobFSSink) MarshalJSON() ([]byte, error) {
	abfs.Type = TypeAzureBlobFSSink
	objectMap := make(map[string]interface{})
	if abfs.CopyBehavior != nil {
		objectMap["copyBehavior"] = abfs.CopyBehavior
	}
	if abfs.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = abfs.WriteBatchSize
	}
	if abfs.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = abfs.WriteBatchTimeout
	}
	if abfs.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = abfs.SinkRetryCount
	}
	if abfs.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = abfs.SinkRetryWait
	}
	if abfs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfs.MaxConcurrentConnections
	}
	if abfs.Type != "" {
		objectMap["type"] = abfs.Type
	}
	for k, v := range abfs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSalesforceServiceCloudSink() (*SalesforceServiceCloudSink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCommonDataServiceForAppsSink() (*CommonDataServiceForAppsSink, bool) {
	return nil, false
}

// AsDynamicsCrmSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDynamicsCrmSink() (*DynamicsCrmSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsMicrosoftAccessSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsMicrosoftAccessSink() (*MicrosoftAccessSink, bool) {
	return nil, false
}

// AsInformixSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsInformixSink() (*InformixSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return &abfs, true
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSnowflakeSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSnowflakeSink() (*SnowflakeSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLMISink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLMISink() (*SQLMISink, bool) {
	return nil, false
}

// AsAzureSQLSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureSQLSink() (*AzureSQLSink, bool) {
	return nil, false
}

// AsSQLServerSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLServerSink() (*SQLServerSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCosmosDbSQLAPISink() (*CosmosDbSQLAPISink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsBinarySink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsBinarySink() (*BinarySink, bool) {
	return nil, false
}

// AsParquetSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsParquetSink() (*ParquetSink, bool) {
	return nil, false
}

// AsAvroSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAvroSink() (*AvroSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsAzureMySQLSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzureMySQLSink() (*AzureMySQLSink, bool) {
	return nil, false
}

// AsAzurePostgreSQLSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsAzurePostgreSQLSink() (*AzurePostgreSQLSink, bool) {
	return nil, false
}

// AsOrcSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsOrcSink() (*OrcSink, bool) {
	return nil, false
}

// AsJSONSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsJSONSink() (*JSONSink, bool) {
	return nil, false
}

// AsDelimitedTextSink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsDelimitedTextSink() (*DelimitedTextSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureBlobFSSink.
func (abfs AzureBlobFSSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &abfs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSSink struct.
func (abfs *AzureBlobFSSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				abfs.CopyBehavior = copyBehavior
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfs.AdditionalProperties == nil {
					abfs.AdditionalProperties = make(map[string]interface{})
				}
				abfs.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				abfs.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				abfs.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				abfs.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				abfs.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSSource a copy activity Azure BlobFS source.
type AzureBlobFSSource struct {
	// TreatEmptyAsNull - Treat empty as null. Type: boolean (or Expression with resultType boolean).
	TreatEmptyAsNull interface{} `json:"treatEmptyAsNull,omitempty"`
	// SkipHeaderLineCount - Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
	SkipHeaderLineCount interface{} `json:"skipHeaderLineCount,omitempty"`
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeSharePointOnlineListSource', 'TypeSnowflakeSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeRestSource', 'TypeSalesforceServiceCloudSource', 'TypeODataSource', 'TypeMicrosoftAccessSource', 'TypeRelationalSource', 'TypeCommonDataServiceForAppsSource', 'TypeDynamicsCrmSource', 'TypeDynamicsSource', 'TypeCosmosDbSQLAPISource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeAzureMariaDBSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeCassandraSource', 'TypeTeradataSource', 'TypeAzureMySQLSource', 'TypeSQLDWSource', 'TypeSQLMISource', 'TypeAzureSQLSource', 'TypeSQLServerSource', 'TypeSQLSource', 'TypeSapTableSource', 'TypeSapOpenHubSource', 'TypeSapHanaSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeSapBwSource', 'TypeSybaseSource', 'TypePostgreSQLSource', 'TypeMySQLSource', 'TypeOdbcSource', 'TypeDb2Source', 'TypeInformixSource', 'TypeAzureTableSource', 'TypeTabularSource', 'TypeBinarySource', 'TypeOrcSource', 'TypeXMLSource', 'TypeJSONSource', 'TypeDelimitedTextSource', 'TypeParquetSource', 'TypeExcelSource', 'TypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSSource.
func (abfs AzureBlobFSSource) MarshalJSON() ([]byte, error) {
	abfs.Type = TypeAzureBlobFSSource
	objectMap := make(map[string]interface{})
	if abfs.TreatEmptyAsNull != nil {
		objectMap["treatEmptyAsNull"] = abfs.TreatEmptyAsNull
	}
	if abfs.SkipHeaderLineCount != nil {
		objectMap["skipHeaderLineCount"] = abfs.SkipHeaderLineCount
	}
	if abfs.Recursive != nil {
		objectMap["recursive"] = abfs.Recursive
	}
	if abfs.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = abfs.SourceRetryCount
	}
	if abfs.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = abfs.SourceRetryWait
	}
	if abfs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfs.MaxConcurrentConnections
	}
	if abfs.Type != "" {
		objectMap["type"] = abfs.Type
	}
	for k, v := range abfs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return &abfs, true
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return nil, false
}

// AsBinarySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureBlobFSSource.
func (abfs AzureBlobFSSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &abfs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSSource struct.
func (abfs *AzureBlobFSSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "treatEmptyAsNull":
			if v != nil {
				var treatEmptyAsNull interface{}
				err = json.Unmarshal(*v, &treatEmptyAsNull)
				if err != nil {
					return err
				}
				abfs.TreatEmptyAsNull = treatEmptyAsNull
			}
		case "skipHeaderLineCount":
			if v != nil {
				var skipHeaderLineCount interface{}
				err = json.Unmarshal(*v, &skipHeaderLineCount)
				if err != nil {
					return err
				}
				abfs.SkipHeaderLineCount = skipHeaderLineCount
			}
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				abfs.Recursive = recursive
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfs.AdditionalProperties == nil {
					abfs.AdditionalProperties = make(map[string]interface{})
				}
				abfs.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				abfs.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				abfs.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobFSWriteSettings azure blobFS write settings.
type AzureBlobFSWriteSettings struct {
	// BlockSizeInMB - Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
	BlockSizeInMB interface{} `json:"blockSizeInMB,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// Type - Possible values include: 'TypeStoreWriteSettings', 'TypeFileServerWriteSettings', 'TypeAzureDataLakeStoreWriteSettings', 'TypeAzureBlobFSWriteSettings', 'TypeAzureBlobStorageWriteSettings', 'TypeSftpWriteSettings'
	Type TypeBasicStoreWriteSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) MarshalJSON() ([]byte, error) {
	abfws.Type = TypeAzureBlobFSWriteSettings
	objectMap := make(map[string]interface{})
	if abfws.BlockSizeInMB != nil {
		objectMap["blockSizeInMB"] = abfws.BlockSizeInMB
	}
	if abfws.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = abfws.MaxConcurrentConnections
	}
	if abfws.CopyBehavior != nil {
		objectMap["copyBehavior"] = abfws.CopyBehavior
	}
	if abfws.Type != "" {
		objectMap["type"] = abfws.Type
	}
	for k, v := range abfws.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsFileServerWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsFileServerWriteSettings() (*FileServerWriteSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsAzureDataLakeStoreWriteSettings() (*AzureDataLakeStoreWriteSettings, bool) {
	return nil, false
}

// AsAzureBlobFSWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsAzureBlobFSWriteSettings() (*AzureBlobFSWriteSettings, bool) {
	return &abfws, true
}

// AsAzureBlobStorageWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsAzureBlobStorageWriteSettings() (*AzureBlobStorageWriteSettings, bool) {
	return nil, false
}

// AsSftpWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsSftpWriteSettings() (*SftpWriteSettings, bool) {
	return nil, false
}

// AsStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsStoreWriteSettings() (*StoreWriteSettings, bool) {
	return nil, false
}

// AsBasicStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobFSWriteSettings.
func (abfws AzureBlobFSWriteSettings) AsBasicStoreWriteSettings() (BasicStoreWriteSettings, bool) {
	return &abfws, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobFSWriteSettings struct.
func (abfws *AzureBlobFSWriteSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "blockSizeInMB":
			if v != nil {
				var blockSizeInMB interface{}
				err = json.Unmarshal(*v, &blockSizeInMB)
				if err != nil {
					return err
				}
				abfws.BlockSizeInMB = blockSizeInMB
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if abfws.AdditionalProperties == nil {
					abfws.AdditionalProperties = make(map[string]interface{})
				}
				abfws.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				abfws.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				abfws.CopyBehavior = copyBehavior
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreWriteSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abfws.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageLinkedService the azure blob storage linked service.
type AzureBlobStorageLinkedService struct {
	// AzureBlobStorageLinkedServiceTypeProperties - Azure Blob Storage linked service properties.
	*AzureBlobStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) MarshalJSON() ([]byte, error) {
	absls.Type = TypeAzureBlobStorage
	objectMap := make(map[string]interface{})
	if absls.AzureBlobStorageLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = absls.AzureBlobStorageLinkedServiceTypeProperties
	}
	if absls.ConnectVia != nil {
		objectMap["connectVia"] = absls.ConnectVia
	}
	if absls.Description != nil {
		objectMap["description"] = absls.Description
	}
	if absls.Parameters != nil {
		objectMap["parameters"] = absls.Parameters
	}
	if absls.Annotations != nil {
		objectMap["annotations"] = absls.Annotations
	}
	if absls.Type != "" {
		objectMap["type"] = absls.Type
	}
	for k, v := range absls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return &absls, true
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBlobStorageLinkedService.
func (absls AzureBlobStorageLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &absls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageLinkedService struct.
func (absls *AzureBlobStorageLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureBlobStorageLinkedServiceTypeProperties AzureBlobStorageLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureBlobStorageLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				absls.AzureBlobStorageLinkedServiceTypeProperties = &azureBlobStorageLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if absls.AdditionalProperties == nil {
					absls.AdditionalProperties = make(map[string]interface{})
				}
				absls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				absls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				absls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				absls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				absls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				absls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageLinkedServiceTypeProperties azure Blob Storage linked service properties.
type AzureBlobStorageLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`
	// AccountKey - The Azure key vault secret reference of accountKey in connection string.
	AccountKey *AzureKeyVaultSecretReference `json:"accountKey,omitempty"`
	// SasURI - SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
	SasURI interface{} `json:"sasUri,omitempty"`
	// SasToken - The Azure key vault secret reference of sasToken in sas uri.
	SasToken *AzureKeyVaultSecretReference `json:"sasToken,omitempty"`
	// ServiceEndpoint - Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against Azure SQL Data Warehouse.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *string `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageLinkedServiceTypeProperties struct.
func (abslstp *AzureBlobStorageLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "connectionString":
			if v != nil {
				var connectionString interface{}
				err = json.Unmarshal(*v, &connectionString)
				if err != nil {
					return err
				}
				abslstp.ConnectionString = connectionString
			}
		case "accountKey":
			if v != nil {
				var accountKey AzureKeyVaultSecretReference
				err = json.Unmarshal(*v, &accountKey)
				if err != nil {
					return err
				}
				abslstp.AccountKey = &accountKey
			}
		case "sasUri":
			if v != nil {
				var sasURI interface{}
				err = json.Unmarshal(*v, &sasURI)
				if err != nil {
					return err
				}
				abslstp.SasURI = sasURI
			}
		case "sasToken":
			if v != nil {
				var sasToken AzureKeyVaultSecretReference
				err = json.Unmarshal(*v, &sasToken)
				if err != nil {
					return err
				}
				abslstp.SasToken = &sasToken
			}
		case "serviceEndpoint":
			if v != nil {
				var serviceEndpoint string
				err = json.Unmarshal(*v, &serviceEndpoint)
				if err != nil {
					return err
				}
				abslstp.ServiceEndpoint = &serviceEndpoint
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				abslstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				abslstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				abslstp.Tenant = tenant
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential string
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				abslstp.EncryptedCredential = &encryptedCredential
			}
		}
	}

	return nil
}

// AzureBlobStorageLocation the location of azure blob dataset.
type AzureBlobStorageLocation struct {
	// Container - Specify the container of azure blob. Type: string (or Expression with resultType string).
	Container interface{} `json:"container,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// FolderPath - Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Type - Possible values include: 'TypeDatasetLocation', 'TypeHdfsLocation', 'TypeHTTPServerLocation', 'TypeSftpLocation', 'TypeFtpServerLocation', 'TypeGoogleCloudStorageLocation', 'TypeAzureFileStorageLocation', 'TypeFileServerLocation', 'TypeAmazonS3Location', 'TypeAzureDataLakeStoreLocation', 'TypeAzureBlobFSLocation', 'TypeAzureBlobStorageLocation'
	Type TypeBasicDatasetLocation `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) MarshalJSON() ([]byte, error) {
	absl.Type = TypeAzureBlobStorageLocation
	objectMap := make(map[string]interface{})
	if absl.Container != nil {
		objectMap["container"] = absl.Container
	}
	if absl.FolderPath != nil {
		objectMap["folderPath"] = absl.FolderPath
	}
	if absl.FileName != nil {
		objectMap["fileName"] = absl.FileName
	}
	if absl.Type != "" {
		objectMap["type"] = absl.Type
	}
	for k, v := range absl.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsHdfsLocation() (*HdfsLocation, bool) {
	return nil, false
}

// AsHTTPServerLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsHTTPServerLocation() (*HTTPServerLocation, bool) {
	return nil, false
}

// AsSftpLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsSftpLocation() (*SftpLocation, bool) {
	return nil, false
}

// AsFtpServerLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsFtpServerLocation() (*FtpServerLocation, bool) {
	return nil, false
}

// AsGoogleCloudStorageLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsGoogleCloudStorageLocation() (*GoogleCloudStorageLocation, bool) {
	return nil, false
}

// AsAzureFileStorageLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAzureFileStorageLocation() (*AzureFileStorageLocation, bool) {
	return nil, false
}

// AsFileServerLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsFileServerLocation() (*FileServerLocation, bool) {
	return nil, false
}

// AsAmazonS3Location is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAmazonS3Location() (*AmazonS3Location, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAzureDataLakeStoreLocation() (*AzureDataLakeStoreLocation, bool) {
	return nil, false
}

// AsAzureBlobFSLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAzureBlobFSLocation() (*AzureBlobFSLocation, bool) {
	return nil, false
}

// AsAzureBlobStorageLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsAzureBlobStorageLocation() (*AzureBlobStorageLocation, bool) {
	return &absl, true
}

// AsDatasetLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsDatasetLocation() (*DatasetLocation, bool) {
	return nil, false
}

// AsBasicDatasetLocation is the BasicDatasetLocation implementation for AzureBlobStorageLocation.
func (absl AzureBlobStorageLocation) AsBasicDatasetLocation() (BasicDatasetLocation, bool) {
	return &absl, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageLocation struct.
func (absl *AzureBlobStorageLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "container":
			if v != nil {
				var containerVar interface{}
				err = json.Unmarshal(*v, &containerVar)
				if err != nil {
					return err
				}
				absl.Container = containerVar
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if absl.AdditionalProperties == nil {
					absl.AdditionalProperties = make(map[string]interface{})
				}
				absl.AdditionalProperties[k] = additionalProperties
			}
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				absl.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				absl.FileName = fileName
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetLocation
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				absl.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageReadSettings azure blob read settings.
type AzureBlobStorageReadSettings struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// WildcardFolderPath - Azure blob wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
	// WildcardFileName - Azure blob wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`
	// Prefix - The prefix filter for the Azure Blob name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`
	// FileListPath - Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`
	// EnablePartitionDiscovery - Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`
	// PartitionRootPath - Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`
	// ModifiedDatetimeStart - The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeStoreReadSettings', 'TypeHdfsReadSettings', 'TypeHTTPReadSettings', 'TypeSftpReadSettings', 'TypeFtpReadSettings', 'TypeGoogleCloudStorageReadSettings', 'TypeAzureFileStorageReadSettings', 'TypeFileServerReadSettings', 'TypeAmazonS3ReadSettings', 'TypeAzureDataLakeStoreReadSettings', 'TypeAzureBlobFSReadSettings', 'TypeAzureBlobStorageReadSettings'
	Type TypeBasicStoreReadSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) MarshalJSON() ([]byte, error) {
	absrs.Type = TypeAzureBlobStorageReadSettings
	objectMap := make(map[string]interface{})
	if absrs.Recursive != nil {
		objectMap["recursive"] = absrs.Recursive
	}
	if absrs.WildcardFolderPath != nil {
		objectMap["wildcardFolderPath"] = absrs.WildcardFolderPath
	}
	if absrs.WildcardFileName != nil {
		objectMap["wildcardFileName"] = absrs.WildcardFileName
	}
	if absrs.Prefix != nil {
		objectMap["prefix"] = absrs.Prefix
	}
	if absrs.FileListPath != nil {
		objectMap["fileListPath"] = absrs.FileListPath
	}
	if absrs.EnablePartitionDiscovery != nil {
		objectMap["enablePartitionDiscovery"] = absrs.EnablePartitionDiscovery
	}
	if absrs.PartitionRootPath != nil {
		objectMap["partitionRootPath"] = absrs.PartitionRootPath
	}
	if absrs.ModifiedDatetimeStart != nil {
		objectMap["modifiedDatetimeStart"] = absrs.ModifiedDatetimeStart
	}
	if absrs.ModifiedDatetimeEnd != nil {
		objectMap["modifiedDatetimeEnd"] = absrs.ModifiedDatetimeEnd
	}
	if absrs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = absrs.MaxConcurrentConnections
	}
	if absrs.Type != "" {
		objectMap["type"] = absrs.Type
	}
	for k, v := range absrs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsHdfsReadSettings() (*HdfsReadSettings, bool) {
	return nil, false
}

// AsHTTPReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsHTTPReadSettings() (*HTTPReadSettings, bool) {
	return nil, false
}

// AsSftpReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsSftpReadSettings() (*SftpReadSettings, bool) {
	return nil, false
}

// AsFtpReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsFtpReadSettings() (*FtpReadSettings, bool) {
	return nil, false
}

// AsGoogleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsGoogleCloudStorageReadSettings() (*GoogleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsAzureFileStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAzureFileStorageReadSettings() (*AzureFileStorageReadSettings, bool) {
	return nil, false
}

// AsFileServerReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsFileServerReadSettings() (*FileServerReadSettings, bool) {
	return nil, false
}

// AsAmazonS3ReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAmazonS3ReadSettings() (*AmazonS3ReadSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAzureDataLakeStoreReadSettings() (*AzureDataLakeStoreReadSettings, bool) {
	return nil, false
}

// AsAzureBlobFSReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAzureBlobFSReadSettings() (*AzureBlobFSReadSettings, bool) {
	return nil, false
}

// AsAzureBlobStorageReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsAzureBlobStorageReadSettings() (*AzureBlobStorageReadSettings, bool) {
	return &absrs, true
}

// AsStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsStoreReadSettings() (*StoreReadSettings, bool) {
	return nil, false
}

// AsBasicStoreReadSettings is the BasicStoreReadSettings implementation for AzureBlobStorageReadSettings.
func (absrs AzureBlobStorageReadSettings) AsBasicStoreReadSettings() (BasicStoreReadSettings, bool) {
	return &absrs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageReadSettings struct.
func (absrs *AzureBlobStorageReadSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				absrs.Recursive = recursive
			}
		case "wildcardFolderPath":
			if v != nil {
				var wildcardFolderPath interface{}
				err = json.Unmarshal(*v, &wildcardFolderPath)
				if err != nil {
					return err
				}
				absrs.WildcardFolderPath = wildcardFolderPath
			}
		case "wildcardFileName":
			if v != nil {
				var wildcardFileName interface{}
				err = json.Unmarshal(*v, &wildcardFileName)
				if err != nil {
					return err
				}
				absrs.WildcardFileName = wildcardFileName
			}
		case "prefix":
			if v != nil {
				var prefix interface{}
				err = json.Unmarshal(*v, &prefix)
				if err != nil {
					return err
				}
				absrs.Prefix = prefix
			}
		case "fileListPath":
			if v != nil {
				var fileListPath interface{}
				err = json.Unmarshal(*v, &fileListPath)
				if err != nil {
					return err
				}
				absrs.FileListPath = fileListPath
			}
		case "enablePartitionDiscovery":
			if v != nil {
				var enablePartitionDiscovery bool
				err = json.Unmarshal(*v, &enablePartitionDiscovery)
				if err != nil {
					return err
				}
				absrs.EnablePartitionDiscovery = &enablePartitionDiscovery
			}
		case "partitionRootPath":
			if v != nil {
				var partitionRootPath interface{}
				err = json.Unmarshal(*v, &partitionRootPath)
				if err != nil {
					return err
				}
				absrs.PartitionRootPath = partitionRootPath
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				absrs.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				absrs.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if absrs.AdditionalProperties == nil {
					absrs.AdditionalProperties = make(map[string]interface{})
				}
				absrs.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				absrs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreReadSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				absrs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureBlobStorageWriteSettings azure blob write settings.
type AzureBlobStorageWriteSettings struct {
	// BlockSizeInMB - Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
	BlockSizeInMB interface{} `json:"blockSizeInMB,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// Type - Possible values include: 'TypeStoreWriteSettings', 'TypeFileServerWriteSettings', 'TypeAzureDataLakeStoreWriteSettings', 'TypeAzureBlobFSWriteSettings', 'TypeAzureBlobStorageWriteSettings', 'TypeSftpWriteSettings'
	Type TypeBasicStoreWriteSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) MarshalJSON() ([]byte, error) {
	absws.Type = TypeAzureBlobStorageWriteSettings
	objectMap := make(map[string]interface{})
	if absws.BlockSizeInMB != nil {
		objectMap["blockSizeInMB"] = absws.BlockSizeInMB
	}
	if absws.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = absws.MaxConcurrentConnections
	}
	if absws.CopyBehavior != nil {
		objectMap["copyBehavior"] = absws.CopyBehavior
	}
	if absws.Type != "" {
		objectMap["type"] = absws.Type
	}
	for k, v := range absws.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsFileServerWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsFileServerWriteSettings() (*FileServerWriteSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsAzureDataLakeStoreWriteSettings() (*AzureDataLakeStoreWriteSettings, bool) {
	return nil, false
}

// AsAzureBlobFSWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsAzureBlobFSWriteSettings() (*AzureBlobFSWriteSettings, bool) {
	return nil, false
}

// AsAzureBlobStorageWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsAzureBlobStorageWriteSettings() (*AzureBlobStorageWriteSettings, bool) {
	return &absws, true
}

// AsSftpWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsSftpWriteSettings() (*SftpWriteSettings, bool) {
	return nil, false
}

// AsStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsStoreWriteSettings() (*StoreWriteSettings, bool) {
	return nil, false
}

// AsBasicStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureBlobStorageWriteSettings.
func (absws AzureBlobStorageWriteSettings) AsBasicStoreWriteSettings() (BasicStoreWriteSettings, bool) {
	return &absws, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobStorageWriteSettings struct.
func (absws *AzureBlobStorageWriteSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "blockSizeInMB":
			if v != nil {
				var blockSizeInMB interface{}
				err = json.Unmarshal(*v, &blockSizeInMB)
				if err != nil {
					return err
				}
				absws.BlockSizeInMB = blockSizeInMB
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if absws.AdditionalProperties == nil {
					absws.AdditionalProperties = make(map[string]interface{})
				}
				absws.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				absws.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				absws.CopyBehavior = copyBehavior
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreWriteSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				absws.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksLinkedService azure Databricks linked service.
type AzureDatabricksLinkedService struct {
	// AzureDatabricksLinkedServiceTypeProperties - Azure Databricks linked service properties.
	*AzureDatabricksLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) MarshalJSON() ([]byte, error) {
	adls.Type = TypeAzureDatabricks
	objectMap := make(map[string]interface{})
	if adls.AzureDatabricksLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adls.AzureDatabricksLinkedServiceTypeProperties
	}
	if adls.ConnectVia != nil {
		objectMap["connectVia"] = adls.ConnectVia
	}
	if adls.Description != nil {
		objectMap["description"] = adls.Description
	}
	if adls.Parameters != nil {
		objectMap["parameters"] = adls.Parameters
	}
	if adls.Annotations != nil {
		objectMap["annotations"] = adls.Annotations
	}
	if adls.Type != "" {
		objectMap["type"] = adls.Type
	}
	for k, v := range adls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return &adls, true
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDatabricksLinkedService.
func (adls AzureDatabricksLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksLinkedService struct.
func (adls *AzureDatabricksLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDatabricksLinkedServiceTypeProperties AzureDatabricksLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDatabricksLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adls.AzureDatabricksLinkedServiceTypeProperties = &azureDatabricksLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adls.AdditionalProperties == nil {
					adls.AdditionalProperties = make(map[string]interface{})
				}
				adls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDatabricksLinkedServiceTypeProperties azure Databricks linked service properties.
type AzureDatabricksLinkedServiceTypeProperties struct {
	// Domain - <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
	Domain interface{} `json:"domain,omitempty"`
	// AccessToken - Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
	AccessToken BasicSecretBase `json:"accessToken,omitempty"`
	// ExistingClusterID - The id of an existing interactive cluster that will be used for all runs of this activity. Type: string (or Expression with resultType string).
	ExistingClusterID interface{} `json:"existingClusterId,omitempty"`
	// InstancePoolID - The id of an existing instance pool that will be used for all runs of this activity. Type: string (or Expression with resultType string).
	InstancePoolID interface{} `json:"instancePoolId,omitempty"`
	// NewClusterVersion - If not using an existing interactive cluster, this specifies the Spark version of a new job cluster or instance pool nodes created for each run of this activity. Required if instancePoolId is specified. Type: string (or Expression with resultType string).
	NewClusterVersion interface{} `json:"newClusterVersion,omitempty"`
	// NewClusterNumOfWorker - If not using an existing interactive cluster, this specifies the number of worker nodes to use for the new job cluster or instance pool. For new job clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and can only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is specified. Type: string (or Expression with resultType string).
	NewClusterNumOfWorker interface{} `json:"newClusterNumOfWorker,omitempty"`
	// NewClusterNodeType - The node type of the new job cluster. This property is required if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is specified, this property is ignored. Type: string (or Expression with resultType string).
	NewClusterNodeType interface{} `json:"newClusterNodeType,omitempty"`
	// NewClusterSparkConf - A set of optional, user-specified Spark configuration key-value pairs.
	NewClusterSparkConf map[string]interface{} `json:"newClusterSparkConf"`
	// NewClusterSparkEnvVars - A set of optional, user-specified Spark environment variables key-value pairs.
	NewClusterSparkEnvVars map[string]interface{} `json:"newClusterSparkEnvVars"`
	// NewClusterCustomTags - Additional tags for cluster resources. This property is ignored in instance pool configurations.
	NewClusterCustomTags map[string]interface{} `json:"newClusterCustomTags"`
	// NewClusterDriverNodeType - The driver node type for the new job cluster. This property is ignored in instance pool configurations. Type: string (or Expression with resultType string).
	NewClusterDriverNodeType interface{} `json:"newClusterDriverNodeType,omitempty"`
	// NewClusterInitScripts - User-defined initialization scripts for the new cluster. Type: array of strings (or Expression with resultType array of strings).
	NewClusterInitScripts interface{} `json:"newClusterInitScripts,omitempty"`
	// NewClusterEnableElasticDisk - Enable the elastic disk on the new cluster. This property is now ignored, and takes the default elastic disk behavior in Databricks (elastic disks are always enabled). Type: boolean (or Expression with resultType boolean).
	NewClusterEnableElasticDisk interface{} `json:"newClusterEnableElasticDisk,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDatabricksLinkedServiceTypeProperties.
func (adlstp AzureDatabricksLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adlstp.Domain != nil {
		objectMap["domain"] = adlstp.Domain
	}
	objectMap["accessToken"] = adlstp.AccessToken
	if adlstp.ExistingClusterID != nil {
		objectMap["existingClusterId"] = adlstp.ExistingClusterID
	}
	if adlstp.InstancePoolID != nil {
		objectMap["instancePoolId"] = adlstp.InstancePoolID
	}
	if adlstp.NewClusterVersion != nil {
		objectMap["newClusterVersion"] = adlstp.NewClusterVersion
	}
	if adlstp.NewClusterNumOfWorker != nil {
		objectMap["newClusterNumOfWorker"] = adlstp.NewClusterNumOfWorker
	}
	if adlstp.NewClusterNodeType != nil {
		objectMap["newClusterNodeType"] = adlstp.NewClusterNodeType
	}
	if adlstp.NewClusterSparkConf != nil {
		objectMap["newClusterSparkConf"] = adlstp.NewClusterSparkConf
	}
	if adlstp.NewClusterSparkEnvVars != nil {
		objectMap["newClusterSparkEnvVars"] = adlstp.NewClusterSparkEnvVars
	}
	if adlstp.NewClusterCustomTags != nil {
		objectMap["newClusterCustomTags"] = adlstp.NewClusterCustomTags
	}
	if adlstp.NewClusterDriverNodeType != nil {
		objectMap["newClusterDriverNodeType"] = adlstp.NewClusterDriverNodeType
	}
	if adlstp.NewClusterInitScripts != nil {
		objectMap["newClusterInitScripts"] = adlstp.NewClusterInitScripts
	}
	if adlstp.NewClusterEnableElasticDisk != nil {
		objectMap["newClusterEnableElasticDisk"] = adlstp.NewClusterEnableElasticDisk
	}
	if adlstp.EncryptedCredential != nil {
		objectMap["encryptedCredential"] = adlstp.EncryptedCredential
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureDatabricksLinkedServiceTypeProperties struct.
func (adlstp *AzureDatabricksLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "domain":
			if v != nil {
				var domain interface{}
				err = json.Unmarshal(*v, &domain)
				if err != nil {
					return err
				}
				adlstp.Domain = domain
			}
		case "accessToken":
			if v != nil {
				accessToken, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlstp.AccessToken = accessToken
			}
		case "existingClusterId":
			if v != nil {
				var existingClusterID interface{}
				err = json.Unmarshal(*v, &existingClusterID)
				if err != nil {
					return err
				}
				adlstp.ExistingClusterID = existingClusterID
			}
		case "instancePoolId":
			if v != nil {
				var instancePoolID interface{}
				err = json.Unmarshal(*v, &instancePoolID)
				if err != nil {
					return err
				}
				adlstp.InstancePoolID = instancePoolID
			}
		case "newClusterVersion":
			if v != nil {
				var newClusterVersion interface{}
				err = json.Unmarshal(*v, &newClusterVersion)
				if err != nil {
					return err
				}
				adlstp.NewClusterVersion = newClusterVersion
			}
		case "newClusterNumOfWorker":
			if v != nil {
				var newClusterNumOfWorker interface{}
				err = json.Unmarshal(*v, &newClusterNumOfWorker)
				if err != nil {
					return err
				}
				adlstp.NewClusterNumOfWorker = newClusterNumOfWorker
			}
		case "newClusterNodeType":
			if v != nil {
				var newClusterNodeType interface{}
				err = json.Unmarshal(*v, &newClusterNodeType)
				if err != nil {
					return err
				}
				adlstp.NewClusterNodeType = newClusterNodeType
			}
		case "newClusterSparkConf":
			if v != nil {
				var newClusterSparkConf map[string]interface{}
				err = json.Unmarshal(*v, &newClusterSparkConf)
				if err != nil {
					return err
				}
				adlstp.NewClusterSparkConf = newClusterSparkConf
			}
		case "newClusterSparkEnvVars":
			if v != nil {
				var newClusterSparkEnvVars map[string]interface{}
				err = json.Unmarshal(*v, &newClusterSparkEnvVars)
				if err != nil {
					return err
				}
				adlstp.NewClusterSparkEnvVars = newClusterSparkEnvVars
			}
		case "newClusterCustomTags":
			if v != nil {
				var newClusterCustomTags map[string]interface{}
				err = json.Unmarshal(*v, &newClusterCustomTags)
				if err != nil {
					return err
				}
				adlstp.NewClusterCustomTags = newClusterCustomTags
			}
		case "newClusterDriverNodeType":
			if v != nil {
				var newClusterDriverNodeType interface{}
				err = json.Unmarshal(*v, &newClusterDriverNodeType)
				if err != nil {
					return err
				}
				adlstp.NewClusterDriverNodeType = newClusterDriverNodeType
			}
		case "newClusterInitScripts":
			if v != nil {
				var newClusterInitScripts interface{}
				err = json.Unmarshal(*v, &newClusterInitScripts)
				if err != nil {
					return err
				}
				adlstp.NewClusterInitScripts = newClusterInitScripts
			}
		case "newClusterEnableElasticDisk":
			if v != nil {
				var newClusterEnableElasticDisk interface{}
				err = json.Unmarshal(*v, &newClusterEnableElasticDisk)
				if err != nil {
					return err
				}
				adlstp.NewClusterEnableElasticDisk = newClusterEnableElasticDisk
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDataExplorerCommandActivity azure Data Explorer command activity.
type AzureDataExplorerCommandActivity struct {
	// AzureDataExplorerCommandActivityTypeProperties - Azure Data Explorer command activity properties.
	*AzureDataExplorerCommandActivityTypeProperties `json:"typeProperties,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// UserProperties - Activity user properties.
	UserProperties *[]UserProperty `json:"userProperties,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeExecuteDataFlow', 'TypeAzureFunctionActivity', 'TypeDatabricksSparkPython', 'TypeDatabricksSparkJar', 'TypeDatabricksNotebook', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLExecutePipeline', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeAzureDataExplorerCommand', 'TypeDelete', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeWebHook', 'TypeAppendVariable', 'TypeSetVariable', 'TypeFilter', 'TypeValidation', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeSwitch', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) MarshalJSON() ([]byte, error) {
	adeca.Type = TypeAzureDataExplorerCommand
	objectMap := make(map[string]interface{})
	if adeca.AzureDataExplorerCommandActivityTypeProperties != nil {
		objectMap["typeProperties"] = adeca.AzureDataExplorerCommandActivityTypeProperties
	}
	if adeca.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = adeca.LinkedServiceName
	}
	if adeca.Policy != nil {
		objectMap["policy"] = adeca.Policy
	}
	if adeca.Name != nil {
		objectMap["name"] = adeca.Name
	}
	if adeca.Description != nil {
		objectMap["description"] = adeca.Description
	}
	if adeca.DependsOn != nil {
		objectMap["dependsOn"] = adeca.DependsOn
	}
	if adeca.UserProperties != nil {
		objectMap["userProperties"] = adeca.UserProperties
	}
	if adeca.Type != "" {
		objectMap["type"] = adeca.Type
	}
	for k, v := range adeca.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsExecuteDataFlowActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsExecuteDataFlowActivity() (*ExecuteDataFlowActivity, bool) {
	return nil, false
}

// AsAzureFunctionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureFunctionActivity() (*AzureFunctionActivity, bool) {
	return nil, false
}

// AsDatabricksSparkPythonActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDatabricksSparkPythonActivity() (*DatabricksSparkPythonActivity, bool) {
	return nil, false
}

// AsDatabricksSparkJarActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDatabricksSparkJarActivity() (*DatabricksSparkJarActivity, bool) {
	return nil, false
}

// AsDatabricksNotebookActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDatabricksNotebookActivity() (*DatabricksNotebookActivity, bool) {
	return nil, false
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLExecutePipelineActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureMLExecutePipelineActivity() (*AzureMLExecutePipelineActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsAzureDataExplorerCommandActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAzureDataExplorerCommandActivity() (*AzureDataExplorerCommandActivity, bool) {
	return &adeca, true
}

// AsDeleteActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsDeleteActivity() (*DeleteActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &adeca, true
}

// AsWebHookActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsWebHookActivity() (*WebHookActivity, bool) {
	return nil, false
}

// AsAppendVariableActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsAppendVariableActivity() (*AppendVariableActivity, bool) {
	return nil, false
}

// AsSetVariableActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsSetVariableActivity() (*SetVariableActivity, bool) {
	return nil, false
}

// AsFilterActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsFilterActivity() (*FilterActivity, bool) {
	return nil, false
}

// AsValidationActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsValidationActivity() (*ValidationActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsSwitchActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsSwitchActivity() (*SwitchActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AzureDataExplorerCommandActivity.
func (adeca AzureDataExplorerCommandActivity) AsBasicActivity() (BasicActivity, bool) {
	return &adeca, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerCommandActivity struct.
func (adeca *AzureDataExplorerCommandActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataExplorerCommandActivityTypeProperties AzureDataExplorerCommandActivityTypeProperties
				err = json.Unmarshal(*v, &azureDataExplorerCommandActivityTypeProperties)
				if err != nil {
					return err
				}
				adeca.AzureDataExplorerCommandActivityTypeProperties = &azureDataExplorerCommandActivityTypeProperties
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				adeca.LinkedServiceName = &linkedServiceName
			}
		case "policy":
			if v != nil {
				var policy ActivityPolicy
				err = json.Unmarshal(*v, &policy)
				if err != nil {
					return err
				}
				adeca.Policy = &policy
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adeca.AdditionalProperties == nil {
					adeca.AdditionalProperties = make(map[string]interface{})
				}
				adeca.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adeca.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adeca.Description = &description
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []ActivityDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				adeca.DependsOn = &dependsOn
			}
		case "userProperties":
			if v != nil {
				var userProperties []UserProperty
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				adeca.UserProperties = &userProperties
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicActivity
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adeca.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerCommandActivityTypeProperties azure Data Explorer command activity properties.
type AzureDataExplorerCommandActivityTypeProperties struct {
	// Command - A control command, according to the Azure Data Explorer command syntax. Type: string (or Expression with resultType string).
	Command interface{} `json:"command,omitempty"`
	// CommandTimeout - Control command timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..)
	CommandTimeout interface{} `json:"commandTimeout,omitempty"`
}

// AzureDataExplorerDatasetTypeProperties azure Data Explorer (Kusto) dataset properties.
type AzureDataExplorerDatasetTypeProperties struct {
	// Table - The table name of the Azure Data Explorer database. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
}

// AzureDataExplorerLinkedService azure Data Explorer (Kusto) linked service.
type AzureDataExplorerLinkedService struct {
	// AzureDataExplorerLinkedServiceTypeProperties - Azure Data Explorer (Kusto) linked service properties.
	*AzureDataExplorerLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) MarshalJSON() ([]byte, error) {
	adels.Type = TypeAzureDataExplorer
	objectMap := make(map[string]interface{})
	if adels.AzureDataExplorerLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adels.AzureDataExplorerLinkedServiceTypeProperties
	}
	if adels.ConnectVia != nil {
		objectMap["connectVia"] = adels.ConnectVia
	}
	if adels.Description != nil {
		objectMap["description"] = adels.Description
	}
	if adels.Parameters != nil {
		objectMap["parameters"] = adels.Parameters
	}
	if adels.Annotations != nil {
		objectMap["annotations"] = adels.Annotations
	}
	if adels.Type != "" {
		objectMap["type"] = adels.Type
	}
	for k, v := range adels.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return &adels, true
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataExplorerLinkedService.
func (adels AzureDataExplorerLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adels, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerLinkedService struct.
func (adels *AzureDataExplorerLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataExplorerLinkedServiceTypeProperties AzureDataExplorerLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDataExplorerLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adels.AzureDataExplorerLinkedServiceTypeProperties = &azureDataExplorerLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adels.AdditionalProperties == nil {
					adels.AdditionalProperties = make(map[string]interface{})
				}
				adels.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adels.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adels.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adels.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adels.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adels.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerLinkedServiceTypeProperties azure Data Explorer (Kusto) linked service properties.
type AzureDataExplorerLinkedServiceTypeProperties struct {
	// Endpoint - The endpoint of Azure Data Explorer (the engine's endpoint). URL will be in the format https://<clusterName>.<regionName>.kusto.windows.net. Type: string (or Expression with resultType string)
	Endpoint interface{} `json:"endpoint,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against Azure Data Explorer. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against Kusto.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Database - Database name for connection. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerLinkedServiceTypeProperties struct.
func (adelstp *AzureDataExplorerLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "endpoint":
			if v != nil {
				var endpoint interface{}
				err = json.Unmarshal(*v, &endpoint)
				if err != nil {
					return err
				}
				adelstp.Endpoint = endpoint
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				adelstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adelstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "database":
			if v != nil {
				var databaseVar interface{}
				err = json.Unmarshal(*v, &databaseVar)
				if err != nil {
					return err
				}
				adelstp.Database = databaseVar
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				adelstp.Tenant = tenant
			}
		}
	}

	return nil
}

// AzureDataExplorerSink a copy activity Azure Data Explorer sink.
type AzureDataExplorerSink struct {
	// IngestionMappingName - A name of a pre-created csv mapping that was defined on the target Kusto table. Type: string.
	IngestionMappingName interface{} `json:"ingestionMappingName,omitempty"`
	// IngestionMappingAsJSON - An explicit column mapping description provided in a json format. Type: string.
	IngestionMappingAsJSON interface{} `json:"ingestionMappingAsJson,omitempty"`
	// FlushImmediately - If set to true, any aggregation will be skipped. Default is false. Type: boolean.
	FlushImmediately interface{} `json:"flushImmediately,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeCosmosDbMongoDbAPISink', 'TypeSalesforceServiceCloudSink', 'TypeSalesforceSink', 'TypeAzureDataExplorerSink', 'TypeCommonDataServiceForAppsSink', 'TypeDynamicsCrmSink', 'TypeDynamicsSink', 'TypeMicrosoftAccessSink', 'TypeInformixSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureBlobFSSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSnowflakeSink', 'TypeSQLDWSink', 'TypeSQLMISink', 'TypeAzureSQLSink', 'TypeSQLServerSink', 'TypeSQLSink', 'TypeCosmosDbSQLAPISink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeBinarySink', 'TypeParquetSink', 'TypeAvroSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink', 'TypeAzureMySQLSink', 'TypeAzurePostgreSQLSink', 'TypeOrcSink', 'TypeJSONSink', 'TypeDelimitedTextSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) MarshalJSON() ([]byte, error) {
	ades.Type = TypeAzureDataExplorerSink
	objectMap := make(map[string]interface{})
	if ades.IngestionMappingName != nil {
		objectMap["ingestionMappingName"] = ades.IngestionMappingName
	}
	if ades.IngestionMappingAsJSON != nil {
		objectMap["ingestionMappingAsJson"] = ades.IngestionMappingAsJSON
	}
	if ades.FlushImmediately != nil {
		objectMap["flushImmediately"] = ades.FlushImmediately
	}
	if ades.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = ades.WriteBatchSize
	}
	if ades.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = ades.WriteBatchTimeout
	}
	if ades.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = ades.SinkRetryCount
	}
	if ades.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = ades.SinkRetryWait
	}
	if ades.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ades.MaxConcurrentConnections
	}
	if ades.Type != "" {
		objectMap["type"] = ades.Type
	}
	for k, v := range ades.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSalesforceServiceCloudSink() (*SalesforceServiceCloudSink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return &ades, true
}

// AsCommonDataServiceForAppsSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCommonDataServiceForAppsSink() (*CommonDataServiceForAppsSink, bool) {
	return nil, false
}

// AsDynamicsCrmSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDynamicsCrmSink() (*DynamicsCrmSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsMicrosoftAccessSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsMicrosoftAccessSink() (*MicrosoftAccessSink, bool) {
	return nil, false
}

// AsInformixSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsInformixSink() (*InformixSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSnowflakeSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSnowflakeSink() (*SnowflakeSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLMISink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLMISink() (*SQLMISink, bool) {
	return nil, false
}

// AsAzureSQLSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureSQLSink() (*AzureSQLSink, bool) {
	return nil, false
}

// AsSQLServerSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLServerSink() (*SQLServerSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCosmosDbSQLAPISink() (*CosmosDbSQLAPISink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsBinarySink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsBinarySink() (*BinarySink, bool) {
	return nil, false
}

// AsParquetSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsParquetSink() (*ParquetSink, bool) {
	return nil, false
}

// AsAvroSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAvroSink() (*AvroSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsAzureMySQLSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzureMySQLSink() (*AzureMySQLSink, bool) {
	return nil, false
}

// AsAzurePostgreSQLSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsAzurePostgreSQLSink() (*AzurePostgreSQLSink, bool) {
	return nil, false
}

// AsOrcSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsOrcSink() (*OrcSink, bool) {
	return nil, false
}

// AsJSONSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsJSONSink() (*JSONSink, bool) {
	return nil, false
}

// AsDelimitedTextSink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsDelimitedTextSink() (*DelimitedTextSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureDataExplorerSink.
func (ades AzureDataExplorerSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &ades, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerSink struct.
func (ades *AzureDataExplorerSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ingestionMappingName":
			if v != nil {
				var ingestionMappingName interface{}
				err = json.Unmarshal(*v, &ingestionMappingName)
				if err != nil {
					return err
				}
				ades.IngestionMappingName = ingestionMappingName
			}
		case "ingestionMappingAsJson":
			if v != nil {
				var ingestionMappingAsJSON interface{}
				err = json.Unmarshal(*v, &ingestionMappingAsJSON)
				if err != nil {
					return err
				}
				ades.IngestionMappingAsJSON = ingestionMappingAsJSON
			}
		case "flushImmediately":
			if v != nil {
				var flushImmediately interface{}
				err = json.Unmarshal(*v, &flushImmediately)
				if err != nil {
					return err
				}
				ades.FlushImmediately = flushImmediately
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ades.AdditionalProperties == nil {
					ades.AdditionalProperties = make(map[string]interface{})
				}
				ades.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				ades.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				ades.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				ades.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				ades.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ades.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ades.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerSource a copy activity Azure Data Explorer (Kusto) source.
type AzureDataExplorerSource struct {
	// Query - Database query. Should be a Kusto Query Language (KQL) query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`
	// NoTruncation - The name of the Boolean option that controls whether truncation is applied to result-sets that go beyond a certain row-count limit.
	NoTruncation interface{} `json:"noTruncation,omitempty"`
	// QueryTimeout - Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`
	// AdditionalColumns - Specifies the additional columns to be added to source data. Type: array of objects (or Expression with resultType array of objects).
	AdditionalColumns *[]AdditionalColumns `json:"additionalColumns,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeSharePointOnlineListSource', 'TypeSnowflakeSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeRestSource', 'TypeSalesforceServiceCloudSource', 'TypeODataSource', 'TypeMicrosoftAccessSource', 'TypeRelationalSource', 'TypeCommonDataServiceForAppsSource', 'TypeDynamicsCrmSource', 'TypeDynamicsSource', 'TypeCosmosDbSQLAPISource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeAzureMariaDBSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeCassandraSource', 'TypeTeradataSource', 'TypeAzureMySQLSource', 'TypeSQLDWSource', 'TypeSQLMISource', 'TypeAzureSQLSource', 'TypeSQLServerSource', 'TypeSQLSource', 'TypeSapTableSource', 'TypeSapOpenHubSource', 'TypeSapHanaSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeSapBwSource', 'TypeSybaseSource', 'TypePostgreSQLSource', 'TypeMySQLSource', 'TypeOdbcSource', 'TypeDb2Source', 'TypeInformixSource', 'TypeAzureTableSource', 'TypeTabularSource', 'TypeBinarySource', 'TypeOrcSource', 'TypeXMLSource', 'TypeJSONSource', 'TypeDelimitedTextSource', 'TypeParquetSource', 'TypeExcelSource', 'TypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) MarshalJSON() ([]byte, error) {
	ades.Type = TypeAzureDataExplorerSource
	objectMap := make(map[string]interface{})
	if ades.Query != nil {
		objectMap["query"] = ades.Query
	}
	if ades.NoTruncation != nil {
		objectMap["noTruncation"] = ades.NoTruncation
	}
	if ades.QueryTimeout != nil {
		objectMap["queryTimeout"] = ades.QueryTimeout
	}
	if ades.AdditionalColumns != nil {
		objectMap["additionalColumns"] = ades.AdditionalColumns
	}
	if ades.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = ades.SourceRetryCount
	}
	if ades.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = ades.SourceRetryWait
	}
	if ades.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = ades.MaxConcurrentConnections
	}
	if ades.Type != "" {
		objectMap["type"] = ades.Type
	}
	for k, v := range ades.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsOffice365Source is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return &ades, true
}

// AsHdfsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return nil, false
}

// AsBinarySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureDataExplorerSource.
func (ades AzureDataExplorerSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ades, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerSource struct.
func (ades *AzureDataExplorerSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "query":
			if v != nil {
				var query interface{}
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				ades.Query = query
			}
		case "noTruncation":
			if v != nil {
				var noTruncation interface{}
				err = json.Unmarshal(*v, &noTruncation)
				if err != nil {
					return err
				}
				ades.NoTruncation = noTruncation
			}
		case "queryTimeout":
			if v != nil {
				var queryTimeout interface{}
				err = json.Unmarshal(*v, &queryTimeout)
				if err != nil {
					return err
				}
				ades.QueryTimeout = queryTimeout
			}
		case "additionalColumns":
			if v != nil {
				var additionalColumns []AdditionalColumns
				err = json.Unmarshal(*v, &additionalColumns)
				if err != nil {
					return err
				}
				ades.AdditionalColumns = &additionalColumns
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ades.AdditionalProperties == nil {
					ades.AdditionalProperties = make(map[string]interface{})
				}
				ades.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				ades.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				ades.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				ades.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ades.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataExplorerTableDataset the Azure Data Explorer (Kusto) dataset.
type AzureDataExplorerTableDataset struct {
	// AzureDataExplorerDatasetTypeProperties - Azure Data Explorer (Kusto) dataset properties.
	*AzureDataExplorerDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeSharePointOnlineListResource', 'TypeSnowflakeTable', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeAzureMariaDBTable', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSapTableResource', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapHanaTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSapBwCube', 'TypeSybaseTable', 'TypeSalesforceServiceCloudObject', 'TypeSalesforceObject', 'TypeMicrosoftAccessTable', 'TypePostgreSQLTable', 'TypeMySQLTable', 'TypeOdbcTable', 'TypeInformixTable', 'TypeRelationalTable', 'TypeDb2Table', 'TypeAmazonRedshiftTable', 'TypeAzureMySQLTable', 'TypeTeradataTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeCommonDataServiceForAppsEntity', 'TypeDynamicsCrmEntity', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCosmosDbSQLAPICollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLMITable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeBinary', 'TypeOrc', 'TypeXML', 'TypeJSON', 'TypeDelimitedText', 'TypeParquet', 'TypeExcel', 'TypeAvro', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) MarshalJSON() ([]byte, error) {
	adetd.Type = TypeAzureDataExplorerTable
	objectMap := make(map[string]interface{})
	if adetd.AzureDataExplorerDatasetTypeProperties != nil {
		objectMap["typeProperties"] = adetd.AzureDataExplorerDatasetTypeProperties
	}
	if adetd.Description != nil {
		objectMap["description"] = adetd.Description
	}
	if adetd.Structure != nil {
		objectMap["structure"] = adetd.Structure
	}
	if adetd.Schema != nil {
		objectMap["schema"] = adetd.Schema
	}
	if adetd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = adetd.LinkedServiceName
	}
	if adetd.Parameters != nil {
		objectMap["parameters"] = adetd.Parameters
	}
	if adetd.Annotations != nil {
		objectMap["annotations"] = adetd.Annotations
	}
	if adetd.Folder != nil {
		objectMap["folder"] = adetd.Folder
	}
	if adetd.Type != "" {
		objectMap["type"] = adetd.Type
	}
	for k, v := range adetd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return &adetd, true
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureDataExplorerTableDataset.
func (adetd AzureDataExplorerTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &adetd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataExplorerTableDataset struct.
func (adetd *AzureDataExplorerTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataExplorerDatasetTypeProperties AzureDataExplorerDatasetTypeProperties
				err = json.Unmarshal(*v, &azureDataExplorerDatasetTypeProperties)
				if err != nil {
					return err
				}
				adetd.AzureDataExplorerDatasetTypeProperties = &azureDataExplorerDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adetd.AdditionalProperties == nil {
					adetd.AdditionalProperties = make(map[string]interface{})
				}
				adetd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adetd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				adetd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				adetd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				adetd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adetd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adetd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				adetd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adetd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeAnalyticsLinkedService azure Data Lake Analytics linked service.
type AzureDataLakeAnalyticsLinkedService struct {
	// AzureDataLakeAnalyticsLinkedServiceTypeProperties - Azure Data Lake Analytics linked service properties.
	*AzureDataLakeAnalyticsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) MarshalJSON() ([]byte, error) {
	adlals.Type = TypeAzureDataLakeAnalytics
	objectMap := make(map[string]interface{})
	if adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties
	}
	if adlals.ConnectVia != nil {
		objectMap["connectVia"] = adlals.ConnectVia
	}
	if adlals.Description != nil {
		objectMap["description"] = adlals.Description
	}
	if adlals.Parameters != nil {
		objectMap["parameters"] = adlals.Parameters
	}
	if adlals.Annotations != nil {
		objectMap["annotations"] = adlals.Annotations
	}
	if adlals.Type != "" {
		objectMap["type"] = adlals.Type
	}
	for k, v := range adlals.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return &adlals, true
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adlals, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeAnalyticsLinkedService struct.
func (adlals *AzureDataLakeAnalyticsLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataLakeAnalyticsLinkedServiceTypeProperties AzureDataLakeAnalyticsLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDataLakeAnalyticsLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties = &azureDataLakeAnalyticsLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlals.AdditionalProperties == nil {
					adlals.AdditionalProperties = make(map[string]interface{})
				}
				adlals.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adlals.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adlals.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adlals.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adlals.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlals.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeAnalyticsLinkedServiceTypeProperties azure Data Lake Analytics linked service properties.
type AzureDataLakeAnalyticsLinkedServiceTypeProperties struct {
	// AccountName - The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Analytics account.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// SubscriptionID - Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
	SubscriptionID interface{} `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
	ResourceGroupName interface{} `json:"resourceGroupName,omitempty"`
	// DataLakeAnalyticsURI - Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
	DataLakeAnalyticsURI interface{} `json:"dataLakeAnalyticsUri,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeAnalyticsLinkedServiceTypeProperties struct.
func (adlalstp *AzureDataLakeAnalyticsLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				adlalstp.AccountName = accountName
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				adlalstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlalstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				adlalstp.Tenant = tenant
			}
		case "subscriptionId":
			if v != nil {
				var subscriptionID interface{}
				err = json.Unmarshal(*v, &subscriptionID)
				if err != nil {
					return err
				}
				adlalstp.SubscriptionID = subscriptionID
			}
		case "resourceGroupName":
			if v != nil {
				var resourceGroupName interface{}
				err = json.Unmarshal(*v, &resourceGroupName)
				if err != nil {
					return err
				}
				adlalstp.ResourceGroupName = resourceGroupName
			}
		case "dataLakeAnalyticsUri":
			if v != nil {
				var dataLakeAnalyticsURI interface{}
				err = json.Unmarshal(*v, &dataLakeAnalyticsURI)
				if err != nil {
					return err
				}
				adlalstp.DataLakeAnalyticsURI = dataLakeAnalyticsURI
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlalstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDataLakeStoreDataset azure Data Lake Store dataset.
type AzureDataLakeStoreDataset struct {
	// AzureDataLakeStoreDatasetTypeProperties - Azure Data Lake Store dataset properties.
	*AzureDataLakeStoreDatasetTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
	// Schema - Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the Dataset.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Folder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeSharePointOnlineListResource', 'TypeSnowflakeTable', 'TypeGoogleAdWordsObject', 'TypeAzureDataExplorerTable', 'TypeOracleServiceCloudObject', 'TypeDynamicsAXResource', 'TypeResponsysObject', 'TypeSalesforceMarketingCloudObject', 'TypeVerticaTable', 'TypeNetezzaTable', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeAzureMariaDBTable', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSapTableResource', 'TypeRestResource', 'TypeSQLServerTable', 'TypeSapOpenHubTable', 'TypeSapHanaTable', 'TypeSapEccResource', 'TypeSapCloudForCustomerResource', 'TypeSapBwCube', 'TypeSybaseTable', 'TypeSalesforceServiceCloudObject', 'TypeSalesforceObject', 'TypeMicrosoftAccessTable', 'TypePostgreSQLTable', 'TypeMySQLTable', 'TypeOdbcTable', 'TypeInformixTable', 'TypeRelationalTable', 'TypeDb2Table', 'TypeAmazonRedshiftTable', 'TypeAzureMySQLTable', 'TypeTeradataTable', 'TypeOracleTable', 'TypeODataResource', 'TypeCosmosDbMongoDbAPICollection', 'TypeMongoDbV2Collection', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeOffice365Table', 'TypeAzureBlobFSFile', 'TypeAzureDataLakeStoreFile', 'TypeCommonDataServiceForAppsEntity', 'TypeDynamicsCrmEntity', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCosmosDbSQLAPICollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLMITable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeBinary', 'TypeOrc', 'TypeXML', 'TypeJSON', 'TypeDelimitedText', 'TypeParquet', 'TypeExcel', 'TypeAvro', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) MarshalJSON() ([]byte, error) {
	adlsd.Type = TypeAzureDataLakeStoreFile
	objectMap := make(map[string]interface{})
	if adlsd.AzureDataLakeStoreDatasetTypeProperties != nil {
		objectMap["typeProperties"] = adlsd.AzureDataLakeStoreDatasetTypeProperties
	}
	if adlsd.Description != nil {
		objectMap["description"] = adlsd.Description
	}
	if adlsd.Structure != nil {
		objectMap["structure"] = adlsd.Structure
	}
	if adlsd.Schema != nil {
		objectMap["schema"] = adlsd.Schema
	}
	if adlsd.LinkedServiceName != nil {
		objectMap["linkedServiceName"] = adlsd.LinkedServiceName
	}
	if adlsd.Parameters != nil {
		objectMap["parameters"] = adlsd.Parameters
	}
	if adlsd.Annotations != nil {
		objectMap["annotations"] = adlsd.Annotations
	}
	if adlsd.Folder != nil {
		objectMap["folder"] = adlsd.Folder
	}
	if adlsd.Type != "" {
		objectMap["type"] = adlsd.Type
	}
	for k, v := range adlsd.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSharePointOnlineListResourceDataset() (*SharePointOnlineListResourceDataset, bool) {
	return nil, false
}

// AsSnowflakeDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSnowflakeDataset() (*SnowflakeDataset, bool) {
	return nil, false
}

// AsGoogleAdWordsObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGoogleAdWordsObjectDataset() (*GoogleAdWordsObjectDataset, bool) {
	return nil, false
}

// AsAzureDataExplorerTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureDataExplorerTableDataset() (*AzureDataExplorerTableDataset, bool) {
	return nil, false
}

// AsOracleServiceCloudObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOracleServiceCloudObjectDataset() (*OracleServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsDynamicsAXResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDynamicsAXResourceDataset() (*DynamicsAXResourceDataset, bool) {
	return nil, false
}

// AsResponsysObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsResponsysObjectDataset() (*ResponsysObjectDataset, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSalesforceMarketingCloudObjectDataset() (*SalesforceMarketingCloudObjectDataset, bool) {
	return nil, false
}

// AsVerticaTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsVerticaTableDataset() (*VerticaTableDataset, bool) {
	return nil, false
}

// AsNetezzaTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsNetezzaTableDataset() (*NetezzaTableDataset, bool) {
	return nil, false
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsAzureMariaDBTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureMariaDBTableDataset() (*AzureMariaDBTableDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSapTableResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapTableResourceDataset() (*SapTableResourceDataset, bool) {
	return nil, false
}

// AsRestResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsRestResourceDataset() (*RestResourceDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapOpenHubTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapOpenHubTableDataset() (*SapOpenHubTableDataset, bool) {
	return nil, false
}

// AsSapHanaTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapHanaTableDataset() (*SapHanaTableDataset, bool) {
	return nil, false
}

// AsSapEccResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapEccResourceDataset() (*SapEccResourceDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSapBwCubeDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapBwCubeDataset() (*SapBwCubeDataset, bool) {
	return nil, false
}

// AsSybaseTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSybaseTableDataset() (*SybaseTableDataset, bool) {
	return nil, false
}

// AsSalesforceServiceCloudObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSalesforceServiceCloudObjectDataset() (*SalesforceServiceCloudObjectDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsMicrosoftAccessTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMicrosoftAccessTableDataset() (*MicrosoftAccessTableDataset, bool) {
	return nil, false
}

// AsPostgreSQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPostgreSQLTableDataset() (*PostgreSQLTableDataset, bool) {
	return nil, false
}

// AsMySQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMySQLTableDataset() (*MySQLTableDataset, bool) {
	return nil, false
}

// AsOdbcTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOdbcTableDataset() (*OdbcTableDataset, bool) {
	return nil, false
}

// AsInformixTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsInformixTableDataset() (*InformixTableDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsDb2TableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDb2TableDataset() (*Db2TableDataset, bool) {
	return nil, false
}

// AsAmazonRedshiftTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAmazonRedshiftTableDataset() (*AmazonRedshiftTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsTeradataTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsTeradataTableDataset() (*TeradataTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPICollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCosmosDbMongoDbAPICollectionDataset() (*CosmosDbMongoDbAPICollectionDataset, bool) {
	return nil, false
}

// AsMongoDbV2CollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMongoDbV2CollectionDataset() (*MongoDbV2CollectionDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsOffice365Dataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOffice365Dataset() (*Office365Dataset, bool) {
	return nil, false
}

// AsAzureBlobFSDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureBlobFSDataset() (*AzureBlobFSDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return &adlsd, true
}

// AsCommonDataServiceForAppsEntityDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCommonDataServiceForAppsEntityDataset() (*CommonDataServiceForAppsEntityDataset, bool) {
	return nil, false
}

// AsDynamicsCrmEntityDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDynamicsCrmEntityDataset() (*DynamicsCrmEntityDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCosmosDbSQLAPICollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCosmosDbSQLAPICollectionDataset() (*CosmosDbSQLAPICollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLMITableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSQLMITableDataset() (*AzureSQLMITableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsBinaryDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsBinaryDataset() (*BinaryDataset, bool) {
	return nil, false
}

// AsOrcDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOrcDataset() (*OrcDataset, bool) {
	return nil, false
}

// AsXMLDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsXMLDataset() (*XMLDataset, bool) {
	return nil, false
}

// AsJSONDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsJSONDataset() (*JSONDataset, bool) {
	return nil, false
}

// AsDelimitedTextDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDelimitedTextDataset() (*DelimitedTextDataset, bool) {
	return nil, false
}

// AsParquetDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsParquetDataset() (*ParquetDataset, bool) {
	return nil, false
}

// AsExcelDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsExcelDataset() (*ExcelDataset, bool) {
	return nil, false
}

// AsAvroDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAvroDataset() (*AvroDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsBasicDataset() (BasicDataset, bool) {
	return &adlsd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreDataset struct.
func (adlsd *AzureDataLakeStoreDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataLakeStoreDatasetTypeProperties AzureDataLakeStoreDatasetTypeProperties
				err = json.Unmarshal(*v, &azureDataLakeStoreDatasetTypeProperties)
				if err != nil {
					return err
				}
				adlsd.AzureDataLakeStoreDatasetTypeProperties = &azureDataLakeStoreDatasetTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlsd.AdditionalProperties == nil {
					adlsd.AdditionalProperties = make(map[string]interface{})
				}
				adlsd.AdditionalProperties[k] = additionalProperties
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adlsd.Description = &description
			}
		case "structure":
			if v != nil {
				var structure interface{}
				err = json.Unmarshal(*v, &structure)
				if err != nil {
					return err
				}
				adlsd.Structure = structure
			}
		case "schema":
			if v != nil {
				var schema interface{}
				err = json.Unmarshal(*v, &schema)
				if err != nil {
					return err
				}
				adlsd.Schema = schema
			}
		case "linkedServiceName":
			if v != nil {
				var linkedServiceName LinkedServiceReference
				err = json.Unmarshal(*v, &linkedServiceName)
				if err != nil {
					return err
				}
				adlsd.LinkedServiceName = &linkedServiceName
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adlsd.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adlsd.Annotations = &annotations
			}
		case "folder":
			if v != nil {
				var folder DatasetFolder
				err = json.Unmarshal(*v, &folder)
				if err != nil {
					return err
				}
				adlsd.Folder = &folder
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDataset
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsd.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreDatasetTypeProperties azure Data Lake Store dataset properties.
type AzureDataLakeStoreDatasetTypeProperties struct {
	// FolderPath - Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Format - The format of the Data Lake Store.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the item(s) in the Azure Data Lake Store.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreDatasetTypeProperties struct.
func (adlsdtp *AzureDataLakeStoreDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				adlsdtp.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				adlsdtp.FileName = fileName
			}
		case "format":
			if v != nil {
				formatVar, err := unmarshalBasicDatasetStorageFormat(*v)
				if err != nil {
					return err
				}
				adlsdtp.Format = formatVar
			}
		case "compression":
			if v != nil {
				compression, err := unmarshalBasicDatasetCompression(*v)
				if err != nil {
					return err
				}
				adlsdtp.Compression = compression
			}
		}
	}

	return nil
}

// AzureDataLakeStoreLinkedService azure Data Lake Store linked service.
type AzureDataLakeStoreLinkedService struct {
	// AzureDataLakeStoreLinkedServiceTypeProperties - Azure Data Lake Store linked service properties.
	*AzureDataLakeStoreLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) MarshalJSON() ([]byte, error) {
	adlsls.Type = TypeAzureDataLakeStore
	objectMap := make(map[string]interface{})
	if adlsls.AzureDataLakeStoreLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = adlsls.AzureDataLakeStoreLinkedServiceTypeProperties
	}
	if adlsls.ConnectVia != nil {
		objectMap["connectVia"] = adlsls.ConnectVia
	}
	if adlsls.Description != nil {
		objectMap["description"] = adlsls.Description
	}
	if adlsls.Parameters != nil {
		objectMap["parameters"] = adlsls.Parameters
	}
	if adlsls.Annotations != nil {
		objectMap["annotations"] = adlsls.Annotations
	}
	if adlsls.Type != "" {
		objectMap["type"] = adlsls.Type
	}
	for k, v := range adlsls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsAzureMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMariaDBLinkedService() (*AzureMariaDBLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsRestServiceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsRestServiceLinkedService() (*RestServiceLinkedService, bool) {
	return nil, false
}

// AsSapOpenHubLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapOpenHubLinkedService() (*SapOpenHubLinkedService, bool) {
	return nil, false
}

// AsSapEccLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapEccLinkedService() (*SapEccLinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceServiceCloudLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSalesforceServiceCloudLinkedService() (*SalesforceServiceCloudLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsOffice365LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOffice365LinkedService() (*Office365LinkedService, bool) {
	return nil, false
}

// AsAzureBlobFSLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureBlobFSLinkedService() (*AzureBlobFSLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return &adlsls, true
}

// AsCosmosDbMongoDbAPILinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCosmosDbMongoDbAPILinkedService() (*CosmosDbMongoDbAPILinkedService, bool) {
	return nil, false
}

// AsMongoDbV2LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMongoDbV2LinkedService() (*MongoDbV2LinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsMicrosoftAccessLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMicrosoftAccessLinkedService() (*MicrosoftAccessLinkedService, bool) {
	return nil, false
}

// AsInformixLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsInformixLinkedService() (*InformixLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLServiceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMLServiceLinkedService() (*AzureMLServiceLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsGoogleCloudStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGoogleCloudStorageLinkedService() (*GoogleCloudStorageLinkedService, bool) {
	return nil, false
}

// AsAzureFileStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureFileStorageLinkedService() (*AzureFileStorageLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCommonDataServiceForAppsLinkedService() (*CommonDataServiceForAppsLinkedService, bool) {
	return nil, false
}

// AsDynamicsCrmLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDynamicsCrmLinkedService() (*DynamicsCrmLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLMILinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSQLMILinkedService() (*AzureSQLMILinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureTableStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureTableStorageLinkedService() (*AzureTableStorageLinkedService, bool) {
	return nil, false
}

// AsAzureBlobStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureBlobStorageLinkedService() (*AzureBlobStorageLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adlsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreLinkedService struct.
func (adlsls *AzureDataLakeStoreLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "typeProperties":
			if v != nil {
				var azureDataLakeStoreLinkedServiceTypeProperties AzureDataLakeStoreLinkedServiceTypeProperties
				err = json.Unmarshal(*v, &azureDataLakeStoreLinkedServiceTypeProperties)
				if err != nil {
					return err
				}
				adlsls.AzureDataLakeStoreLinkedServiceTypeProperties = &azureDataLakeStoreLinkedServiceTypeProperties
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlsls.AdditionalProperties == nil {
					adlsls.AdditionalProperties = make(map[string]interface{})
				}
				adlsls.AdditionalProperties[k] = additionalProperties
			}
		case "connectVia":
			if v != nil {
				var connectVia IntegrationRuntimeReference
				err = json.Unmarshal(*v, &connectVia)
				if err != nil {
					return err
				}
				adlsls.ConnectVia = &connectVia
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				adlsls.Description = &description
			}
		case "parameters":
			if v != nil {
				var parameters map[string]*ParameterSpecification
				err = json.Unmarshal(*v, &parameters)
				if err != nil {
					return err
				}
				adlsls.Parameters = parameters
			}
		case "annotations":
			if v != nil {
				var annotations []interface{}
				err = json.Unmarshal(*v, &annotations)
				if err != nil {
					return err
				}
				adlsls.Annotations = &annotations
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicLinkedService
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsls.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreLinkedServiceTypeProperties azure Data Lake Store linked service properties.
type AzureDataLakeStoreLinkedServiceTypeProperties struct {
	// DataLakeStoreURI - Data Lake Store service URI. Type: string (or Expression with resultType string).
	DataLakeStoreURI interface{} `json:"dataLakeStoreUri,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Store account.
	ServicePrincipalKey BasicSecretBase `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
	// AccountName - Data Lake Store account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`
	// SubscriptionID - Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
	SubscriptionID interface{} `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
	ResourceGroupName interface{} `json:"resourceGroupName,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreLinkedServiceTypeProperties struct.
func (adlslstp *AzureDataLakeStoreLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataLakeStoreUri":
			if v != nil {
				var dataLakeStoreURI interface{}
				err = json.Unmarshal(*v, &dataLakeStoreURI)
				if err != nil {
					return err
				}
				adlslstp.DataLakeStoreURI = dataLakeStoreURI
			}
		case "servicePrincipalId":
			if v != nil {
				var servicePrincipalID interface{}
				err = json.Unmarshal(*v, &servicePrincipalID)
				if err != nil {
					return err
				}
				adlslstp.ServicePrincipalID = servicePrincipalID
			}
		case "servicePrincipalKey":
			if v != nil {
				servicePrincipalKey, err := unmarshalBasicSecretBase(*v)
				if err != nil {
					return err
				}
				adlslstp.ServicePrincipalKey = servicePrincipalKey
			}
		case "tenant":
			if v != nil {
				var tenant interface{}
				err = json.Unmarshal(*v, &tenant)
				if err != nil {
					return err
				}
				adlslstp.Tenant = tenant
			}
		case "accountName":
			if v != nil {
				var accountName interface{}
				err = json.Unmarshal(*v, &accountName)
				if err != nil {
					return err
				}
				adlslstp.AccountName = accountName
			}
		case "subscriptionId":
			if v != nil {
				var subscriptionID interface{}
				err = json.Unmarshal(*v, &subscriptionID)
				if err != nil {
					return err
				}
				adlslstp.SubscriptionID = subscriptionID
			}
		case "resourceGroupName":
			if v != nil {
				var resourceGroupName interface{}
				err = json.Unmarshal(*v, &resourceGroupName)
				if err != nil {
					return err
				}
				adlslstp.ResourceGroupName = resourceGroupName
			}
		case "encryptedCredential":
			if v != nil {
				var encryptedCredential interface{}
				err = json.Unmarshal(*v, &encryptedCredential)
				if err != nil {
					return err
				}
				adlslstp.EncryptedCredential = encryptedCredential
			}
		}
	}

	return nil
}

// AzureDataLakeStoreLocation the location of azure data lake store dataset.
type AzureDataLakeStoreLocation struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// FolderPath - Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
	// FileName - Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`
	// Type - Possible values include: 'TypeDatasetLocation', 'TypeHdfsLocation', 'TypeHTTPServerLocation', 'TypeSftpLocation', 'TypeFtpServerLocation', 'TypeGoogleCloudStorageLocation', 'TypeAzureFileStorageLocation', 'TypeFileServerLocation', 'TypeAmazonS3Location', 'TypeAzureDataLakeStoreLocation', 'TypeAzureBlobFSLocation', 'TypeAzureBlobStorageLocation'
	Type TypeBasicDatasetLocation `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) MarshalJSON() ([]byte, error) {
	adlsl.Type = TypeAzureDataLakeStoreLocation
	objectMap := make(map[string]interface{})
	if adlsl.FolderPath != nil {
		objectMap["folderPath"] = adlsl.FolderPath
	}
	if adlsl.FileName != nil {
		objectMap["fileName"] = adlsl.FileName
	}
	if adlsl.Type != "" {
		objectMap["type"] = adlsl.Type
	}
	for k, v := range adlsl.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsHdfsLocation() (*HdfsLocation, bool) {
	return nil, false
}

// AsHTTPServerLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsHTTPServerLocation() (*HTTPServerLocation, bool) {
	return nil, false
}

// AsSftpLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsSftpLocation() (*SftpLocation, bool) {
	return nil, false
}

// AsFtpServerLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsFtpServerLocation() (*FtpServerLocation, bool) {
	return nil, false
}

// AsGoogleCloudStorageLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsGoogleCloudStorageLocation() (*GoogleCloudStorageLocation, bool) {
	return nil, false
}

// AsAzureFileStorageLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsAzureFileStorageLocation() (*AzureFileStorageLocation, bool) {
	return nil, false
}

// AsFileServerLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsFileServerLocation() (*FileServerLocation, bool) {
	return nil, false
}

// AsAmazonS3Location is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsAmazonS3Location() (*AmazonS3Location, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsAzureDataLakeStoreLocation() (*AzureDataLakeStoreLocation, bool) {
	return &adlsl, true
}

// AsAzureBlobFSLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsAzureBlobFSLocation() (*AzureBlobFSLocation, bool) {
	return nil, false
}

// AsAzureBlobStorageLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsAzureBlobStorageLocation() (*AzureBlobStorageLocation, bool) {
	return nil, false
}

// AsDatasetLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsDatasetLocation() (*DatasetLocation, bool) {
	return nil, false
}

// AsBasicDatasetLocation is the BasicDatasetLocation implementation for AzureDataLakeStoreLocation.
func (adlsl AzureDataLakeStoreLocation) AsBasicDatasetLocation() (BasicDatasetLocation, bool) {
	return &adlsl, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreLocation struct.
func (adlsl *AzureDataLakeStoreLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlsl.AdditionalProperties == nil {
					adlsl.AdditionalProperties = make(map[string]interface{})
				}
				adlsl.AdditionalProperties[k] = additionalProperties
			}
		case "folderPath":
			if v != nil {
				var folderPath interface{}
				err = json.Unmarshal(*v, &folderPath)
				if err != nil {
					return err
				}
				adlsl.FolderPath = folderPath
			}
		case "fileName":
			if v != nil {
				var fileName interface{}
				err = json.Unmarshal(*v, &fileName)
				if err != nil {
					return err
				}
				adlsl.FileName = fileName
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicDatasetLocation
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsl.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreReadSettings azure data lake store read settings.
type AzureDataLakeStoreReadSettings struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// WildcardFolderPath - ADLS wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
	// WildcardFileName - ADLS wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`
	// FileListPath - Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`
	// EnablePartitionDiscovery - Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`
	// PartitionRootPath - Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`
	// ModifiedDatetimeStart - The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
	// ModifiedDatetimeEnd - The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeStoreReadSettings', 'TypeHdfsReadSettings', 'TypeHTTPReadSettings', 'TypeSftpReadSettings', 'TypeFtpReadSettings', 'TypeGoogleCloudStorageReadSettings', 'TypeAzureFileStorageReadSettings', 'TypeFileServerReadSettings', 'TypeAmazonS3ReadSettings', 'TypeAzureDataLakeStoreReadSettings', 'TypeAzureBlobFSReadSettings', 'TypeAzureBlobStorageReadSettings'
	Type TypeBasicStoreReadSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) MarshalJSON() ([]byte, error) {
	adlsrs.Type = TypeAzureDataLakeStoreReadSettings
	objectMap := make(map[string]interface{})
	if adlsrs.Recursive != nil {
		objectMap["recursive"] = adlsrs.Recursive
	}
	if adlsrs.WildcardFolderPath != nil {
		objectMap["wildcardFolderPath"] = adlsrs.WildcardFolderPath
	}
	if adlsrs.WildcardFileName != nil {
		objectMap["wildcardFileName"] = adlsrs.WildcardFileName
	}
	if adlsrs.FileListPath != nil {
		objectMap["fileListPath"] = adlsrs.FileListPath
	}
	if adlsrs.EnablePartitionDiscovery != nil {
		objectMap["enablePartitionDiscovery"] = adlsrs.EnablePartitionDiscovery
	}
	if adlsrs.PartitionRootPath != nil {
		objectMap["partitionRootPath"] = adlsrs.PartitionRootPath
	}
	if adlsrs.ModifiedDatetimeStart != nil {
		objectMap["modifiedDatetimeStart"] = adlsrs.ModifiedDatetimeStart
	}
	if adlsrs.ModifiedDatetimeEnd != nil {
		objectMap["modifiedDatetimeEnd"] = adlsrs.ModifiedDatetimeEnd
	}
	if adlsrs.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = adlsrs.MaxConcurrentConnections
	}
	if adlsrs.Type != "" {
		objectMap["type"] = adlsrs.Type
	}
	for k, v := range adlsrs.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsHdfsReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsHdfsReadSettings() (*HdfsReadSettings, bool) {
	return nil, false
}

// AsHTTPReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsHTTPReadSettings() (*HTTPReadSettings, bool) {
	return nil, false
}

// AsSftpReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsSftpReadSettings() (*SftpReadSettings, bool) {
	return nil, false
}

// AsFtpReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsFtpReadSettings() (*FtpReadSettings, bool) {
	return nil, false
}

// AsGoogleCloudStorageReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsGoogleCloudStorageReadSettings() (*GoogleCloudStorageReadSettings, bool) {
	return nil, false
}

// AsAzureFileStorageReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsAzureFileStorageReadSettings() (*AzureFileStorageReadSettings, bool) {
	return nil, false
}

// AsFileServerReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsFileServerReadSettings() (*FileServerReadSettings, bool) {
	return nil, false
}

// AsAmazonS3ReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsAmazonS3ReadSettings() (*AmazonS3ReadSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsAzureDataLakeStoreReadSettings() (*AzureDataLakeStoreReadSettings, bool) {
	return &adlsrs, true
}

// AsAzureBlobFSReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsAzureBlobFSReadSettings() (*AzureBlobFSReadSettings, bool) {
	return nil, false
}

// AsAzureBlobStorageReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsAzureBlobStorageReadSettings() (*AzureBlobStorageReadSettings, bool) {
	return nil, false
}

// AsStoreReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsStoreReadSettings() (*StoreReadSettings, bool) {
	return nil, false
}

// AsBasicStoreReadSettings is the BasicStoreReadSettings implementation for AzureDataLakeStoreReadSettings.
func (adlsrs AzureDataLakeStoreReadSettings) AsBasicStoreReadSettings() (BasicStoreReadSettings, bool) {
	return &adlsrs, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreReadSettings struct.
func (adlsrs *AzureDataLakeStoreReadSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				adlsrs.Recursive = recursive
			}
		case "wildcardFolderPath":
			if v != nil {
				var wildcardFolderPath interface{}
				err = json.Unmarshal(*v, &wildcardFolderPath)
				if err != nil {
					return err
				}
				adlsrs.WildcardFolderPath = wildcardFolderPath
			}
		case "wildcardFileName":
			if v != nil {
				var wildcardFileName interface{}
				err = json.Unmarshal(*v, &wildcardFileName)
				if err != nil {
					return err
				}
				adlsrs.WildcardFileName = wildcardFileName
			}
		case "fileListPath":
			if v != nil {
				var fileListPath interface{}
				err = json.Unmarshal(*v, &fileListPath)
				if err != nil {
					return err
				}
				adlsrs.FileListPath = fileListPath
			}
		case "enablePartitionDiscovery":
			if v != nil {
				var enablePartitionDiscovery bool
				err = json.Unmarshal(*v, &enablePartitionDiscovery)
				if err != nil {
					return err
				}
				adlsrs.EnablePartitionDiscovery = &enablePartitionDiscovery
			}
		case "partitionRootPath":
			if v != nil {
				var partitionRootPath interface{}
				err = json.Unmarshal(*v, &partitionRootPath)
				if err != nil {
					return err
				}
				adlsrs.PartitionRootPath = partitionRootPath
			}
		case "modifiedDatetimeStart":
			if v != nil {
				var modifiedDatetimeStart interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeStart)
				if err != nil {
					return err
				}
				adlsrs.ModifiedDatetimeStart = modifiedDatetimeStart
			}
		case "modifiedDatetimeEnd":
			if v != nil {
				var modifiedDatetimeEnd interface{}
				err = json.Unmarshal(*v, &modifiedDatetimeEnd)
				if err != nil {
					return err
				}
				adlsrs.ModifiedDatetimeEnd = modifiedDatetimeEnd
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlsrs.AdditionalProperties == nil {
					adlsrs.AdditionalProperties = make(map[string]interface{})
				}
				adlsrs.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				adlsrs.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreReadSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsrs.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreSink a copy activity Azure Data Lake Store sink.
type AzureDataLakeStoreSink struct {
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// EnableAdlsSingleFileParallel - Single File Parallel.
	EnableAdlsSingleFileParallel interface{} `json:"enableAdlsSingleFileParallel,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeCosmosDbMongoDbAPISink', 'TypeSalesforceServiceCloudSink', 'TypeSalesforceSink', 'TypeAzureDataExplorerSink', 'TypeCommonDataServiceForAppsSink', 'TypeDynamicsCrmSink', 'TypeDynamicsSink', 'TypeMicrosoftAccessSink', 'TypeInformixSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureBlobFSSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSnowflakeSink', 'TypeSQLDWSink', 'TypeSQLMISink', 'TypeAzureSQLSink', 'TypeSQLServerSink', 'TypeSQLSink', 'TypeCosmosDbSQLAPISink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeBinarySink', 'TypeParquetSink', 'TypeAvroSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink', 'TypeAzureMySQLSink', 'TypeAzurePostgreSQLSink', 'TypeOrcSink', 'TypeJSONSink', 'TypeDelimitedTextSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) MarshalJSON() ([]byte, error) {
	adlss.Type = TypeAzureDataLakeStoreSink
	objectMap := make(map[string]interface{})
	if adlss.CopyBehavior != nil {
		objectMap["copyBehavior"] = adlss.CopyBehavior
	}
	if adlss.EnableAdlsSingleFileParallel != nil {
		objectMap["enableAdlsSingleFileParallel"] = adlss.EnableAdlsSingleFileParallel
	}
	if adlss.WriteBatchSize != nil {
		objectMap["writeBatchSize"] = adlss.WriteBatchSize
	}
	if adlss.WriteBatchTimeout != nil {
		objectMap["writeBatchTimeout"] = adlss.WriteBatchTimeout
	}
	if adlss.SinkRetryCount != nil {
		objectMap["sinkRetryCount"] = adlss.SinkRetryCount
	}
	if adlss.SinkRetryWait != nil {
		objectMap["sinkRetryWait"] = adlss.SinkRetryWait
	}
	if adlss.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = adlss.MaxConcurrentConnections
	}
	if adlss.Type != "" {
		objectMap["type"] = adlss.Type
	}
	for k, v := range adlss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsCosmosDbMongoDbAPISink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsCosmosDbMongoDbAPISink() (*CosmosDbMongoDbAPISink, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSalesforceServiceCloudSink() (*SalesforceServiceCloudSink, bool) {
	return nil, false
}

// AsSalesforceSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsAzureDataExplorerSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureDataExplorerSink() (*AzureDataExplorerSink, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsCommonDataServiceForAppsSink() (*CommonDataServiceForAppsSink, bool) {
	return nil, false
}

// AsDynamicsCrmSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDynamicsCrmSink() (*DynamicsCrmSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsMicrosoftAccessSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsMicrosoftAccessSink() (*MicrosoftAccessSink, bool) {
	return nil, false
}

// AsInformixSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsInformixSink() (*InformixSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureBlobFSSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureBlobFSSink() (*AzureBlobFSSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return &adlss, true
}

// AsOracleSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSnowflakeSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSnowflakeSink() (*SnowflakeSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLMISink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLMISink() (*SQLMISink, bool) {
	return nil, false
}

// AsAzureSQLSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureSQLSink() (*AzureSQLSink, bool) {
	return nil, false
}

// AsSQLServerSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLServerSink() (*SQLServerSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsCosmosDbSQLAPISink() (*CosmosDbSQLAPISink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsBinarySink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsBinarySink() (*BinarySink, bool) {
	return nil, false
}

// AsParquetSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsParquetSink() (*ParquetSink, bool) {
	return nil, false
}

// AsAvroSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAvroSink() (*AvroSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsAzureMySQLSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureMySQLSink() (*AzureMySQLSink, bool) {
	return nil, false
}

// AsAzurePostgreSQLSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzurePostgreSQLSink() (*AzurePostgreSQLSink, bool) {
	return nil, false
}

// AsOrcSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsOrcSink() (*OrcSink, bool) {
	return nil, false
}

// AsJSONSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsJSONSink() (*JSONSink, bool) {
	return nil, false
}

// AsDelimitedTextSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDelimitedTextSink() (*DelimitedTextSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &adlss, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreSink struct.
func (adlss *AzureDataLakeStoreSink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				adlss.CopyBehavior = copyBehavior
			}
		case "enableAdlsSingleFileParallel":
			if v != nil {
				var enableAdlsSingleFileParallel interface{}
				err = json.Unmarshal(*v, &enableAdlsSingleFileParallel)
				if err != nil {
					return err
				}
				adlss.EnableAdlsSingleFileParallel = enableAdlsSingleFileParallel
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlss.AdditionalProperties == nil {
					adlss.AdditionalProperties = make(map[string]interface{})
				}
				adlss.AdditionalProperties[k] = additionalProperties
			}
		case "writeBatchSize":
			if v != nil {
				var writeBatchSize interface{}
				err = json.Unmarshal(*v, &writeBatchSize)
				if err != nil {
					return err
				}
				adlss.WriteBatchSize = writeBatchSize
			}
		case "writeBatchTimeout":
			if v != nil {
				var writeBatchTimeout interface{}
				err = json.Unmarshal(*v, &writeBatchTimeout)
				if err != nil {
					return err
				}
				adlss.WriteBatchTimeout = writeBatchTimeout
			}
		case "sinkRetryCount":
			if v != nil {
				var sinkRetryCount interface{}
				err = json.Unmarshal(*v, &sinkRetryCount)
				if err != nil {
					return err
				}
				adlss.SinkRetryCount = sinkRetryCount
			}
		case "sinkRetryWait":
			if v != nil {
				var sinkRetryWait interface{}
				err = json.Unmarshal(*v, &sinkRetryWait)
				if err != nil {
					return err
				}
				adlss.SinkRetryWait = sinkRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				adlss.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySink
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlss.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreSource a copy activity Azure Data Lake source.
type AzureDataLakeStoreSource struct {
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeSharePointOnlineListSource', 'TypeSnowflakeSource', 'TypeHTTPSource', 'TypeAzureBlobFSSource', 'TypeAzureDataLakeStoreSource', 'TypeOffice365Source', 'TypeCosmosDbMongoDbAPISource', 'TypeMongoDbV2Source', 'TypeMongoDbSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureDataExplorerSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeRestSource', 'TypeSalesforceServiceCloudSource', 'TypeODataSource', 'TypeMicrosoftAccessSource', 'TypeRelationalSource', 'TypeCommonDataServiceForAppsSource', 'TypeDynamicsCrmSource', 'TypeDynamicsSource', 'TypeCosmosDbSQLAPISource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAmazonRedshiftSource', 'TypeGoogleAdWordsSource', 'TypeOracleServiceCloudSource', 'TypeDynamicsAXSource', 'TypeResponsysSource', 'TypeSalesforceMarketingCloudSource', 'TypeVerticaSource', 'TypeNetezzaSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeAzureMariaDBSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeCassandraSource', 'TypeTeradataSource', 'TypeAzureMySQLSource', 'TypeSQLDWSource', 'TypeSQLMISource', 'TypeAzureSQLSource', 'TypeSQLServerSource', 'TypeSQLSource', 'TypeSapTableSource', 'TypeSapOpenHubSource', 'TypeSapHanaSource', 'TypeSapEccSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeSapBwSource', 'TypeSybaseSource', 'TypePostgreSQLSource', 'TypeMySQLSource', 'TypeOdbcSource', 'TypeDb2Source', 'TypeInformixSource', 'TypeAzureTableSource', 'TypeTabularSource', 'TypeBinarySource', 'TypeOrcSource', 'TypeXMLSource', 'TypeJSONSource', 'TypeDelimitedTextSource', 'TypeParquetSource', 'TypeExcelSource', 'TypeAvroSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) MarshalJSON() ([]byte, error) {
	adlss.Type = TypeAzureDataLakeStoreSource
	objectMap := make(map[string]interface{})
	if adlss.Recursive != nil {
		objectMap["recursive"] = adlss.Recursive
	}
	if adlss.SourceRetryCount != nil {
		objectMap["sourceRetryCount"] = adlss.SourceRetryCount
	}
	if adlss.SourceRetryWait != nil {
		objectMap["sourceRetryWait"] = adlss.SourceRetryWait
	}
	if adlss.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = adlss.MaxConcurrentConnections
	}
	if adlss.Type != "" {
		objectMap["type"] = adlss.Type
	}
	for k, v := range adlss.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSharePointOnlineListSource() (*SharePointOnlineListSource, bool) {
	return nil, false
}

// AsSnowflakeSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSnowflakeSource() (*SnowflakeSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureBlobFSSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureBlobFSSource() (*AzureBlobFSSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return &adlss, true
}

// AsOffice365Source is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOffice365Source() (*Office365Source, bool) {
	return nil, false
}

// AsCosmosDbMongoDbAPISource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCosmosDbMongoDbAPISource() (*CosmosDbMongoDbAPISource, bool) {
	return nil, false
}

// AsMongoDbV2Source is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMongoDbV2Source() (*MongoDbV2Source, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureDataExplorerSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureDataExplorerSource() (*AzureDataExplorerSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsRestSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsRestSource() (*RestSource, bool) {
	return nil, false
}

// AsSalesforceServiceCloudSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSalesforceServiceCloudSource() (*SalesforceServiceCloudSource, bool) {
	return nil, false
}

// AsODataSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsODataSource() (*ODataSource, bool) {
	return nil, false
}

// AsMicrosoftAccessSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMicrosoftAccessSource() (*MicrosoftAccessSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsCommonDataServiceForAppsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCommonDataServiceForAppsSource() (*CommonDataServiceForAppsSource, bool) {
	return nil, false
}

// AsDynamicsCrmSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDynamicsCrmSource() (*DynamicsCrmSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsCosmosDbSQLAPISource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCosmosDbSQLAPISource() (*CosmosDbSQLAPISource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsGoogleAdWordsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGoogleAdWordsSource() (*GoogleAdWordsSource, bool) {
	return nil, false
}

// AsOracleServiceCloudSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOracleServiceCloudSource() (*OracleServiceCloudSource, bool) {
	return nil, false
}

// AsDynamicsAXSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDynamicsAXSource() (*DynamicsAXSource, bool) {
	return nil, false
}

// AsResponsysSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsResponsysSource() (*ResponsysSource, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSalesforceMarketingCloudSource() (*SalesforceMarketingCloudSource, bool) {
	return nil, false
}

// AsVerticaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsVerticaSource() (*VerticaSource, bool) {
	return nil, false
}

// AsNetezzaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsNetezzaSource() (*NetezzaSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsAzureMariaDBSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureMariaDBSource() (*AzureMariaDBSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsTeradataSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsTeradataSource() (*TeradataSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLMISource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLMISource() (*SQLMISource, bool) {
	return nil, false
}

// AsAzureSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureSQLSource() (*AzureSQLSource, bool) {
	return nil, false
}

// AsSQLServerSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLServerSource() (*SQLServerSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapTableSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapTableSource() (*SapTableSource, bool) {
	return nil, false
}

// AsSapOpenHubSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapOpenHubSource() (*SapOpenHubSource, bool) {
	return nil, false
}

// AsSapHanaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapHanaSource() (*SapHanaSource, bool) {
	return nil, false
}

// AsSapEccSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapEccSource() (*SapEccSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsSapBwSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapBwSource() (*SapBwSource, bool) {
	return nil, false
}

// AsSybaseSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSybaseSource() (*SybaseSource, bool) {
	return nil, false
}

// AsPostgreSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPostgreSQLSource() (*PostgreSQLSource, bool) {
	return nil, false
}

// AsMySQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMySQLSource() (*MySQLSource, bool) {
	return nil, false
}

// AsOdbcSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOdbcSource() (*OdbcSource, bool) {
	return nil, false
}

// AsDb2Source is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDb2Source() (*Db2Source, bool) {
	return nil, false
}

// AsInformixSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsInformixSource() (*InformixSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsTabularSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsTabularSource() (*TabularSource, bool) {
	return nil, false
}

// AsBasicTabularSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBasicTabularSource() (BasicTabularSource, bool) {
	return nil, false
}

// AsBinarySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBinarySource() (*BinarySource, bool) {
	return nil, false
}

// AsOrcSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOrcSource() (*OrcSource, bool) {
	return nil, false
}

// AsXMLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsXMLSource() (*XMLSource, bool) {
	return nil, false
}

// AsJSONSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsJSONSource() (*JSONSource, bool) {
	return nil, false
}

// AsDelimitedTextSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDelimitedTextSource() (*DelimitedTextSource, bool) {
	return nil, false
}

// AsParquetSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsParquetSource() (*ParquetSource, bool) {
	return nil, false
}

// AsExcelSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsExcelSource() (*ExcelSource, bool) {
	return nil, false
}

// AsAvroSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAvroSource() (*AvroSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &adlss, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreSource struct.
func (adlss *AzureDataLakeStoreSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recursive":
			if v != nil {
				var recursive interface{}
				err = json.Unmarshal(*v, &recursive)
				if err != nil {
					return err
				}
				adlss.Recursive = recursive
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlss.AdditionalProperties == nil {
					adlss.AdditionalProperties = make(map[string]interface{})
				}
				adlss.AdditionalProperties[k] = additionalProperties
			}
		case "sourceRetryCount":
			if v != nil {
				var sourceRetryCount interface{}
				err = json.Unmarshal(*v, &sourceRetryCount)
				if err != nil {
					return err
				}
				adlss.SourceRetryCount = sourceRetryCount
			}
		case "sourceRetryWait":
			if v != nil {
				var sourceRetryWait interface{}
				err = json.Unmarshal(*v, &sourceRetryWait)
				if err != nil {
					return err
				}
				adlss.SourceRetryWait = sourceRetryWait
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				adlss.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicCopySource
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlss.Type = typeVar
			}
		}
	}

	return nil
}

// AzureDataLakeStoreWriteSettings azure data lake store write settings.
type AzureDataLakeStoreWriteSettings struct {
	// ExpiryDateTime - Specifies the expiry time of the written files. The time is applied to the UTC time zone in the format of "2018-12-01T05:00:00Z". Default value is NULL. Type: integer (or Expression with resultType integer).
	ExpiryDateTime interface{} `json:"expiryDateTime,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// MaxConcurrentConnections - The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
	// CopyBehavior - The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`
	// Type - Possible values include: 'TypeStoreWriteSettings', 'TypeFileServerWriteSettings', 'TypeAzureDataLakeStoreWriteSettings', 'TypeAzureBlobFSWriteSettings', 'TypeAzureBlobStorageWriteSettings', 'TypeSftpWriteSettings'
	Type TypeBasicStoreWriteSettings `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreWriteSettings.
func (adlsws AzureDataLakeStoreWriteSettings) MarshalJSON() ([]byte, error) {
	adlsws.Type = TypeAzureDataLakeStoreWriteSettings
	objectMap := make(map[string]interface{})
	if adlsws.ExpiryDateTime != nil {
		objectMap["expiryDateTime"] = adlsws.ExpiryDateTime
	}
	if adlsws.MaxConcurrentConnections != nil {
		objectMap["maxConcurrentConnections"] = adlsws.MaxConcurrentConnections
	}
	if adlsws.CopyBehavior != nil {
		objectMap["copyBehavior"] = adlsws.CopyBehavior
	}
	if adlsws.Type != "" {
		objectMap["type"] = adlsws.Type
	}
	for k, v := range adlsws.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsFileServerWriteSettings is the BasicStoreWriteSettings implementation for AzureDataLakeStoreWriteSettings.
func (adlsws AzureDataLakeStoreWriteSettings) AsFileServerWriteSettings() (*FileServerWriteSettings, bool) {
	return nil, false
}

// AsAzureDataLakeStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureDataLakeStoreWriteSettings.
func (adlsws AzureDataLakeStoreWriteSettings) AsAzureDataLakeStoreWriteSettings() (*AzureDataLakeStoreWriteSettings, bool) {
	return &adlsws, true
}

// AsAzureBlobFSWriteSettings is the BasicStoreWriteSettings implementation for AzureDataLakeStoreWriteSettings.
func (adlsws AzureDataLakeStoreWriteSettings) AsAzureBlobFSWriteSettings() (*AzureBlobFSWriteSettings, bool) {
	return nil, false
}

// AsAzureBlobStorageWriteSettings is the BasicStoreWriteSettings implementation for AzureDataLakeStoreWriteSettings.
func (adlsws AzureDataLakeStoreWriteSettings) AsAzureBlobStorageWriteSettings() (*AzureBlobStorageWriteSettings, bool) {
	return nil, false
}

// AsSftpWriteSettings is the BasicStoreWriteSettings implementation for AzureDataLakeStoreWriteSettings.
func (adlsws AzureDataLakeStoreWriteSettings) AsSftpWriteSettings() (*SftpWriteSettings, bool) {
	return nil, false
}

// AsStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureDataLakeStoreWriteSettings.
func (adlsws AzureDataLakeStoreWriteSettings) AsStoreWriteSettings() (*StoreWriteSettings, bool) {
	return nil, false
}

// AsBasicStoreWriteSettings is the BasicStoreWriteSettings implementation for AzureDataLakeStoreWriteSettings.
func (adlsws AzureDataLakeStoreWriteSettings) AsBasicStoreWriteSettings() (BasicStoreWriteSettings, bool) {
	return &adlsws, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreWriteSettings struct.
func (adlsws *AzureDataLakeStoreWriteSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "expiryDateTime":
			if v != nil {
				var expiryDateTime interface{}
				err = json.Unmarshal(*v, &expiryDateTime)
				if err != nil {
					return err
				}
				adlsws.ExpiryDateTime = expiryDateTime
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if adlsws.AdditionalProperties == nil {
					adlsws.AdditionalProperties = make(map[string]interface{})
				}
				adlsws.AdditionalProperties[k] = additionalProperties
			}
		case "maxConcurrentConnections":
			if v != nil {
				var maxConcurrentConnections interface{}
				err = json.Unmarshal(*v, &maxConcurrentConnections)
				if err != nil {
					return err
				}
				adlsws.MaxConcurrentConnections = maxConcurrentConnections
			}
		case "copyBehavior":
			if v != nil {
				var copyBehavior interface{}
				err = json.Unmarshal(*v, &copyBehavior)
				if err != nil {
					return err
				}
				adlsws.CopyBehavior = copyBehavior
			}
		case "type":
			if v != nil {
				var typeVar TypeBasicStoreWriteSettings
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adlsws.Type = typeVar
			}
		}
	}

	return nil
}

// AzureFileStorageLinkedService azure File Storage linked service.
type AzureFileStorageLinkedService struct {
	// AzureFileStorageLinkedServiceTypeProperties - Azure File Storage linked service properties.
	*AzureFileStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Parameters - Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters"`
	// Annotations - List of tags that can be used for describing the linked service.
	Annotations *[]interface{} `json:"annotations,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeSharePointOnlineList', 'TypeSnowflake', 'TypeAzureFunction', 'TypeAzureDataExplorer', 'TypeSapTable', 'TypeGoogleAdWords', 'TypeOracleServiceCloud', 'TypeDynamicsAX', 'TypeResponsys', 'TypeAzureDatabricks', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeSalesforceMarketingCloud', 'TypeNetezza', 'TypeVertica', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeAzureMariaDB', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeRestService', 'TypeSapOpenHub', 'TypeSapEcc', 'TypeSapCloudForCustomer', 'TypeSalesforceServiceCloud', 'TypeSalesforce', 'TypeOffice365', 'TypeAzureBlobFS', 'TypeAzureDataLakeStore', 'TypeCosmosDbMongoDbAPI', 'TypeMongoDbV2', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeMicrosoftAccess', 'TypeInformix', 'TypeOdbc', 'TypeAzureMLService', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeGoogleCloudStorage', 'TypeAzureFileStorage', 'TypeFileServer', 'TypeHDInsight', 'TypeCommonDataServiceForApps', 'TypeDynamicsCrm', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLMI', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureTableStorage', 'TypeAzureBlobStorage', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) MarshalJSON() ([]byte, error) {
	afsls.Type = TypeAzureFileStorage
	objectMap := make(map[string]interface{})
	if afsls.AzureFileStorageLinkedServiceTypeProperties != nil {
		objectMap["typeProperties"] = afsls.AzureFileStorageLinkedServiceTypeProperties
	}
	if afsls.ConnectVia != nil {
		objectMap["connectVia"] = afsls.ConnectVia
	}
	if afsls.Description != nil {
		objectMap["description"] = afsls.Description
	}
	if afsls.Parameters != nil {
		objectMap["parameters"] = afsls.Parameters
	}
	if afsls.Annotations != nil {
		objectMap["annotations"] = afsls.Annotations
	}
	if afsls.Type != "" {
		objectMap["type"] = afsls.Type
	}
	for k, v := range afsls.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsSharePointOnlineListLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsSharePointOnlineListLinkedService() (*SharePointOnlineListLinkedService, bool) {
	return nil, false
}

// AsSnowflakeLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsSnowflakeLinkedService() (*SnowflakeLinkedService, bool) {
	return nil, false
}

// AsAzureFunctionLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsAzureFunctionLinkedService() (*AzureFunctionLinkedService, bool) {
	return nil, false
}

// AsAzureDataExplorerLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsAzureDataExplorerLinkedService() (*AzureDataExplorerLinkedService, bool) {
	return nil, false
}

// AsSapTableLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsSapTableLinkedService() (*SapTableLinkedService, bool) {
	return nil, false
}

// AsGoogleAdWordsLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsGoogleAdWordsLinkedService() (*GoogleAdWordsLinkedService, bool) {
	return nil, false
}

// AsOracleServiceCloudLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsOracleServiceCloudLinkedService() (*OracleServiceCloudLinkedService, bool) {
	return nil, false
}

// AsDynamicsAXLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsDynamicsAXLinkedService() (*DynamicsAXLinkedService, bool) {
	return nil, false
}

// AsResponsysLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsResponsysLinkedService() (*ResponsysLinkedService, bool) {
	return nil, false
}

// AsAzureDatabricksLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsAzureDatabricksLinkedService() (*AzureDatabricksLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsSalesforceMarketingCloudLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsSalesforceMarketingCloudLinkedService() (*SalesforceMarketingCloudLinkedService, bool) {
	return nil, false
}

// AsNetezzaLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsNetezzaLinkedService() (*NetezzaLinkedService, bool) {
	return nil, false
}

// AsVerticaLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsVerticaLinkedService() (*VerticaLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureFileStorageLinkedService.
func (afsls AzureFileStorageLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService imple