package resources

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// DeploymentMode enumerates the values for deployment mode.
type DeploymentMode string

const (
	// Complete ...
	Complete DeploymentMode = "Complete"
	// Incremental ...
	Incremental DeploymentMode = "Incremental"
)

// PossibleDeploymentModeValues returns an array of possible values for the DeploymentMode const type.
func PossibleDeploymentModeValues() []DeploymentMode {
	return []DeploymentMode{Complete, Incremental}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{SystemAssigned}
}

// AliasPathType ...
type AliasPathType struct {
	// Path - The path of an alias.
	Path *string `json:"path,omitempty"`
	// APIVersions - The api versions.
	APIVersions *[]string `json:"apiVersions,omitempty"`
}

// AliasType ...
type AliasType struct {
	// Name - The alias name.
	Name *string `json:"name,omitempty"`
	// Paths - The paths for an alias.
	Paths *[]AliasPathType `json:"paths,omitempty"`
}

// BasicDependency deployment dependency information.
type BasicDependency struct {
	// ID - The ID of the dependency.
	ID *string `json:"id,omitempty"`
	// ResourceType - The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceName - The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`
}

// DebugSetting ...
type DebugSetting struct {
	// DetailLevel - The debug detail level.
	DetailLevel *string `json:"detailLevel,omitempty"`
}

// Dependency deployment dependency information.
type Dependency struct {
	// DependsOn - The list of dependencies.
	DependsOn *[]BasicDependency `json:"dependsOn,omitempty"`
	// ID - The ID of the dependency.
	ID *string `json:"id,omitempty"`
	// ResourceType - The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceName - The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`
}

// Deployment deployment operation parameters.
type Deployment struct {
	// Properties - The deployment properties.
	Properties *DeploymentProperties `json:"properties,omitempty"`
}

// DeploymentExportResult ...
type DeploymentExportResult struct {
	autorest.Response `json:"-"`
	// Template - The template content.
	Template interface{} `json:"template,omitempty"`
}

// DeploymentExtended deployment information.
type DeploymentExtended struct {
	autorest.Response `json:"-"`
	// ID - The ID of the deployment.
	ID *string `json:"id,omitempty"`
	// Name - The name of the deployment.
	Name *string `json:"name,omitempty"`
	// Properties - Deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`
}

// DeploymentExtendedFilter deployment filter.
type DeploymentExtendedFilter struct {
	// ProvisioningState - The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// DeploymentListResult list of deployments.
type DeploymentListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of deployments.
	Value *[]DeploymentExtended `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentListResultIterator provides access to a complete listing of DeploymentExtended values.
type DeploymentListResultIterator struct {
	i    int
	page DeploymentListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentListResultIterator) Response() DeploymentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentListResultIterator) Value() DeploymentExtended {
	if !iter.page.NotDone() {
		return DeploymentExtended{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DeploymentListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// deploymentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DeploymentListResult) deploymentListResultPreparer() (*http.Request, error) {
	if dlr.NextLink == nil || len(to.String(dlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DeploymentListResultPage contains a page of DeploymentExtended values.
type DeploymentListResultPage struct {
	fn  func(DeploymentListResult) (DeploymentListResult, error)
	dlr DeploymentListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentListResultPage) Next() error {
	next, err := page.fn(page.dlr)
	if err != nil {
		return err
	}
	page.dlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentListResultPage) Response() DeploymentListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentListResultPage) Values() []DeploymentExtended {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// DeploymentOperation deployment operation information.
type DeploymentOperation struct {
	autorest.Response `json:"-"`
	// ID - Full deployment operation id.
	ID *string `json:"id,omitempty"`
	// OperationID - Deployment operation id.
	OperationID *string `json:"operationId,omitempty"`
	// Properties - Deployment properties.
	Properties *DeploymentOperationProperties `json:"properties,omitempty"`
}

// DeploymentOperationProperties deployment operation properties.
type DeploymentOperationProperties struct {
	// ProvisioningState - The state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Timestamp - The date and time of the operation.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// ServiceRequestID - Deployment operation service request id.
	ServiceRequestID *string `json:"serviceRequestId,omitempty"`
	// StatusCode - Operation status code.
	StatusCode *string `json:"statusCode,omitempty"`
	// StatusMessage - Operation status message.
	StatusMessage interface{} `json:"statusMessage,omitempty"`
	// TargetResource - The target resource.
	TargetResource *TargetResource `json:"targetResource,omitempty"`
	// Request - The HTTP request message.
	Request *HTTPMessage `json:"request,omitempty"`
	// Response - The HTTP response message.
	Response *HTTPMessage `json:"response,omitempty"`
}

// DeploymentOperationsListResult list of deployment operations.
type DeploymentOperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of deployments.
	Value *[]DeploymentOperation `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentOperationsListResultIterator provides access to a complete listing of DeploymentOperation values.
type DeploymentOperationsListResultIterator struct {
	i    int
	page DeploymentOperationsListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentOperationsListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentOperationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentOperationsListResultIterator) Response() DeploymentOperationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentOperationsListResultIterator) Value() DeploymentOperation {
	if !iter.page.NotDone() {
		return DeploymentOperation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DeploymentOperationsListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// deploymentOperationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DeploymentOperationsListResult) deploymentOperationsListResultPreparer() (*http.Request, error) {
	if dolr.NextLink == nil || len(to.String(dolr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.NextLink)))
}

// DeploymentOperationsListResultPage contains a page of DeploymentOperation values.
type DeploymentOperationsListResultPage struct {
	fn   func(DeploymentOperationsListResult) (DeploymentOperationsListResult, error)
	dolr DeploymentOperationsListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentOperationsListResultPage) Next() error {
	next, err := page.fn(page.dolr)
	if err != nil {
		return err
	}
	page.dolr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentOperationsListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentOperationsListResultPage) Response() DeploymentOperationsListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentOperationsListResultPage) Values() []DeploymentOperation {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// DeploymentProperties deployment properties.
type DeploymentProperties struct {
	// Template - The template content. It can be a JObject or a well formed JSON string. Use only one of Template or TemplateLink.
	Template interface{} `json:"template,omitempty"`
	// TemplateLink - The template URI. Use only one of Template or TemplateLink.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
	// Parameters - Deployment parameters. It can be a JObject or a well formed JSON string. Use only one of Parameters or ParametersLink.
	Parameters interface{} `json:"parameters,omitempty"`
	// ParametersLink - The parameters URI. Use only one of Parameters or ParametersLink.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`
	// Mode - The deployment mode. Possible values include: 'Incremental', 'Complete'
	Mode DeploymentMode `json:"mode,omitempty"`
	// DebugSetting - The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`
}

// DeploymentPropertiesExtended deployment properties with additional details.
type DeploymentPropertiesExtended struct {
	// ProvisioningState - The state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// CorrelationID - The correlation ID of the deployment.
	CorrelationID *string `json:"correlationId,omitempty"`
	// Timestamp - The timestamp of the template deployment.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Outputs - Key/value pairs that represent deploymentoutput.
	Outputs interface{} `json:"outputs,omitempty"`
	// Providers - The list of resource providers needed for the deployment.
	Providers *[]Provider `json:"providers,omitempty"`
	// Dependencies - The list of deployment dependencies.
	Dependencies *[]Dependency `json:"dependencies,omitempty"`
	// Template - The template content. Use only one of Template or TemplateLink.
	Template interface{} `json:"template,omitempty"`
	// TemplateLink - The URI referencing the template. Use only one of Template or TemplateLink.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
	// Parameters - Deployment parameters. Use only one of Parameters or ParametersLink.
	Parameters interface{} `json:"parameters,omitempty"`
	// ParametersLink - The URI referencing the parameters. Use only one of Parameters or ParametersLink.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`
	// Mode - The deployment mode. Possible values include: 'Incremental', 'Complete'
	Mode DeploymentMode `json:"mode,omitempty"`
	// DebugSetting - The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`
}

// DeploymentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsCreateOrUpdateFuture) Result(client DeploymentsClient) (de DeploymentExtended, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if de.Response.Response, err = future.GetResult(sender); err == nil && de.Response.Response.StatusCode != http.StatusNoContent {
		de, err = client.CreateOrUpdateResponder(de.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateFuture", "Result", de.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeploymentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsDeleteFuture) Result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentValidateResult information from validate template deployment response.
type DeploymentValidateResult struct {
	autorest.Response `json:"-"`
	// Error - Validation error.
	Error *ManagementErrorWithDetails `json:"error,omitempty"`
	// Properties - The template deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`
}

// ExportTemplateRequest export resource group template request parameters.
type ExportTemplateRequest struct {
	// ResourcesProperty - The ids of the resources. The only supported string currently is '*' (all resources). Future api updates will support exporting specific resources.
	ResourcesProperty *[]string `json:"resources,omitempty"`
	// Options - The export template options. Supported values include 'IncludeParameterDefaultValue', 'IncludeComments' or 'IncludeParameterDefaultValue, IncludeComments
	Options *string `json:"options,omitempty"`
}

// GenericResource resource information.
type GenericResource struct {
	autorest.Response `json:"-"`
	// Plan - The plan of the resource.
	Plan *Plan `json:"plan,omitempty"`
	// Properties - The resource properties.
	Properties interface{} `json:"properties,omitempty"`
	// Kind - The kind of the resource.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - Id of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The sku of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GenericResource.
func (gr GenericResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.Plan != nil {
		objectMap["plan"] = gr.Plan
	}
	objectMap["properties"] = gr.Properties
	if gr.Kind != nil {
		objectMap["kind"] = gr.Kind
	}
	if gr.ManagedBy != nil {
		objectMap["managedBy"] = gr.ManagedBy
	}
	if gr.Sku != nil {
		objectMap["sku"] = gr.Sku
	}
	if gr.Identity != nil {
		objectMap["identity"] = gr.Identity
	}
	if gr.ID != nil {
		objectMap["id"] = gr.ID
	}
	if gr.Name != nil {
		objectMap["name"] = gr.Name
	}
	if gr.Type != nil {
		objectMap["type"] = gr.Type
	}
	if gr.Location != nil {
		objectMap["location"] = gr.Location
	}
	if gr.Tags != nil {
		objectMap["tags"] = gr.Tags
	}
	return json.Marshal(objectMap)
}

// GenericResourceFilter resource filter.
type GenericResourceFilter struct {
	// ResourceType - The resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Tagname - The tag name.
	Tagname *string `json:"tagname,omitempty"`
	// Tagvalue - The tag value.
	Tagvalue *string `json:"tagvalue,omitempty"`
}

// Group resource group information.
type Group struct {
	autorest.Response `json:"-"`
	// ID - The ID of the resource group.
	ID *string `json:"id,omitempty"`
	// Name - The Name of the resource group.
	Name       *string          `json:"name,omitempty"`
	Properties *GroupProperties `json:"properties,omitempty"`
	// Location - The location of the resource group. It cannot be changed after the resource group has been created. Has to be one of the supported Azure Locations, such as West US, East US, West Europe, East Asia, etc.
	Location *string `json:"location,omitempty"`
	// Tags - The tags attached to the resource group.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.ID != nil {
		objectMap["id"] = g.ID
	}
	if g.Name != nil {
		objectMap["name"] = g.Name
	}
	if g.Properties != nil {
		objectMap["properties"] = g.Properties
	}
	if g.Location != nil {
		objectMap["location"] = g.Location
	}
	if g.Tags != nil {
		objectMap["tags"] = g.Tags
	}
	return json.Marshal(objectMap)
}

// GroupExportResult ...
type GroupExportResult struct {
	autorest.Response `json:"-"`
	// Template - The template content.
	Template interface{} `json:"template,omitempty"`
	// Error - The error.
	Error *ManagementErrorWithDetails `json:"error,omitempty"`
}

// GroupFilter resource group filter.
type GroupFilter struct {
	// TagName - The tag name.
	TagName *string `json:"tagName,omitempty"`
	// TagValue - The tag value.
	TagValue *string `json:"tagValue,omitempty"`
}

// GroupListResult list of resource groups.
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of resource groups.
	Value *[]Group `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupListResultIterator provides access to a complete listing of Group values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() Group {
	if !iter.page.NotDone() {
		return Group{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// groupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (glr GroupListResult) groupListResultPreparer() (*http.Request, error) {
	if glr.NextLink == nil || len(to.String(glr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(glr.NextLink)))
}

// GroupListResultPage contains a page of Group values.
type GroupListResultPage struct {
	fn  func(GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) Next() error {
	next, err := page.fn(page.glr)
	if err != nil {
		return err
	}
	page.glr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []Group {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// GroupProperties the resource group properties.
type GroupProperties struct {
	// ProvisioningState - The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// GroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *GroupsDeleteFuture) Result(client GroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.GroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.GroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HTTPMessage ...
type HTTPMessage struct {
	// Content - HTTP message content.
	Content interface{} `json:"content,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - The principal id of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - The tenant id of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// ListResult list of resource groups.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of resources.
	Value *[]GenericResource `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of GenericResource values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() GenericResource {
	if !iter.page.NotDone() {
		return GenericResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer() (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of GenericResource values.
type ListResultPage struct {
	fn func(ListResult) (ListResult, error)
	lr ListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) Next() error {
	next, err := page.fn(page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []GenericResource {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// ManagementErrorWithDetails ...
type ManagementErrorWithDetails struct {
	// Code - The error code returned from the server.
	Code *string `json:"code,omitempty"`
	// Message - The error message returned from the server.
	Message *string `json:"message,omitempty"`
	// Target - The target of the error.
	Target *string `json:"target,omitempty"`
	// Details - Validation error.
	Details *[]ManagementErrorWithDetails `json:"details,omitempty"`
}

// MoveInfo parameters of move resources.
type MoveInfo struct {
	// ResourcesProperty - The ids of the resources.
	ResourcesProperty *[]string `json:"resources,omitempty"`
	// TargetResourceGroup - The target resource group.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
}

// MoveResourcesFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type MoveResourcesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MoveResourcesFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.MoveResourcesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.MoveResourcesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ParametersLink entity representing the reference to the deployment paramaters.
type ParametersLink struct {
	// URI - URI referencing the template.
	URI *string `json:"uri,omitempty"`
	// ContentVersion - If included it must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// Plan plan for the resource.
type Plan struct {
	// Name - The plan ID.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - The offer ID.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
}

// Provider resource provider information.
type Provider struct {
	autorest.Response `json:"-"`
	// ID - The provider id.
	ID *string `json:"id,omitempty"`
	// Namespace - The namespace of the provider.
	Namespace *string `json:"namespace,omitempty"`
	// RegistrationState - The registration state of the provider.
	RegistrationState *string `json:"registrationState,omitempty"`
	// ResourceTypes - The collection of provider resource types.
	ResourceTypes *[]ProviderResourceType `json:"resourceTypes,omitempty"`
}

// ProviderListResult list of resource providers.
type ProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of resource providers.
	Value *[]Provider `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProviderListResultIterator provides access to a complete listing of Provider values.
type ProviderListResultIterator struct {
	i    int
	page ProviderListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProviderListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProviderListResultIterator) Response() ProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProviderListResultIterator) Value() Provider {
	if !iter.page.NotDone() {
		return Provider{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProviderListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// providerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProviderListResult) providerListResultPreparer() (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProviderListResultPage contains a page of Provider values.
type ProviderListResultPage struct {
	fn  func(ProviderListResult) (ProviderListResult, error)
	plr ProviderListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProviderListResultPage) Next() error {
	next, err := page.fn(page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProviderListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProviderListResultPage) Response() ProviderListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProviderListResultPage) Values() []Provider {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// ProviderOperationDisplayProperties resource provider operation's display properties.
type ProviderOperationDisplayProperties struct {
	// Publisher - Operation description.
	Publisher *string `json:"publisher,omitempty"`
	// Provider - Operation provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Operation resource.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// ProviderResourceType resource type managed by the resource provider.
type ProviderResourceType struct {
	// ResourceType - The resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Locations - The collection of locations where this resource type can be created in.
	Locations *[]string `json:"locations,omitempty"`
	// Aliases - The aliases that are supported by this resource type.
	Aliases *[]AliasType `json:"aliases,omitempty"`
	// APIVersions - The api version.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// Properties - The properties.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for ProviderResourceType.
func (prt ProviderResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prt.ResourceType != nil {
		objectMap["resourceType"] = prt.ResourceType
	}
	if prt.Locations != nil {
		objectMap["locations"] = prt.Locations
	}
	if prt.Aliases != nil {
		objectMap["aliases"] = prt.Aliases
	}
	if prt.APIVersions != nil {
		objectMap["apiVersions"] = prt.APIVersions
	}
	if prt.Properties != nil {
		objectMap["properties"] = prt.Properties
	}
	return json.Marshal(objectMap)
}

// Resource ...
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Sku sku for the resource.
type Sku struct {
	// Name - The sku name.
	Name *string `json:"name,omitempty"`
	// Tier - The sku tier.
	Tier *string `json:"tier,omitempty"`
	// Size - The sku size.
	Size *string `json:"size,omitempty"`
	// Family - The sku family.
	Family *string `json:"family,omitempty"`
	// Model - The sku model.
	Model *string `json:"model,omitempty"`
	// Capacity - The sku capacity.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SubResource ...
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// TagCount tag count.
type TagCount struct {
	// Type - Type of count.
	Type *string `json:"type,omitempty"`
	// Value - Value of count.
	Value *string `json:"value,omitempty"`
}

// TagDetails tag details.
type TagDetails struct {
	autorest.Response `json:"-"`
	// ID - The tag ID.
	ID *string `json:"id,omitempty"`
	// TagName - The tag name.
	TagName *string `json:"tagName,omitempty"`
	// Count - The tag count.
	Count *TagCount `json:"count,omitempty"`
	// Values - The list of tag values.
	Values *[]TagValue `json:"values,omitempty"`
}

// TagsListResult list of subscription tags.
type TagsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of tags.
	Value *[]TagDetails `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TagsListResultIterator provides access to a complete listing of TagDetails values.
type TagsListResultIterator struct {
	i    int
	page TagsListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TagsListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TagsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TagsListResultIterator) Response() TagsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TagsListResultIterator) Value() TagDetails {
	if !iter.page.NotDone() {
		return TagDetails{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TagsListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// tagsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TagsListResult) tagsListResultPreparer() (*http.Request, error) {
	if tlr.NextLink == nil || len(to.String(tlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TagsListResultPage contains a page of TagDetails values.
type TagsListResultPage struct {
	fn  func(TagsListResult) (TagsListResult, error)
	tlr TagsListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TagsListResultPage) Next() error {
	next, err := page.fn(page.tlr)
	if err != nil {
		return err
	}
	page.tlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TagsListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TagsListResultPage) Response() TagsListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TagsListResultPage) Values() []TagDetails {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// TagValue tag information.
type TagValue struct {
	autorest.Response `json:"-"`
	// ID - The tag ID.
	ID *string `json:"id,omitempty"`
	// TagValue - The tag value.
	TagValue *string `json:"tagValue,omitempty"`
	// Count - The tag value count.
	Count *TagCount `json:"count,omitempty"`
}

// TargetResource target resource.
type TargetResource struct {
	// ID - The ID of the resource.
	ID *string `json:"id,omitempty"`
	// ResourceName - The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// ResourceType - The type of the resource.
	ResourceType *string `json:"resourceType,omitempty"`
}

// TemplateLink entity representing the reference to the template.
type TemplateLink struct {
	// URI - URI referencing the template.
	URI *string `json:"uri,omitempty"`
	// ContentVersion - If included it must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// UpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *UpdateFuture) Result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.UpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.UpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.UpdateResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.UpdateFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}
