package devspaces

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ContainerHostMappingsClient is the dev Spaces Client
type ContainerHostMappingsClient struct {
	BaseClient
}

// NewContainerHostMappingsClient creates an instance of the ContainerHostMappingsClient client.
func NewContainerHostMappingsClient(subscriptionID string) ContainerHostMappingsClient {
	return NewContainerHostMappingsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewContainerHostMappingsClientWithBaseURI creates an instance of the ContainerHostMappingsClient client.
func NewContainerHostMappingsClientWithBaseURI(baseURI string, subscriptionID string) ContainerHostMappingsClient {
	return ContainerHostMappingsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetContainerHostMapping sends the get container host mapping request.
// Parameters:
// location - location of the container host.
func (client ContainerHostMappingsClient) GetContainerHostMapping(ctx context.Context, containerHostMapping ContainerHostMapping, location string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerHostMappingsClient.GetContainerHostMapping")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetContainerHostMappingPreparer(ctx, containerHostMapping, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devspaces.ContainerHostMappingsClient", "GetContainerHostMapping", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetContainerHostMappingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devspaces.ContainerHostMappingsClient", "GetContainerHostMapping", resp, "Failure sending request")
		return
	}

	result, err = client.GetContainerHostMappingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devspaces.ContainerHostMappingsClient", "GetContainerHostMapping", resp, "Failure responding to request")
	}

	return
}

// GetContainerHostMappingPreparer prepares the GetContainerHostMapping request.
func (client ContainerHostMappingsClient) GetContainerHostMappingPreparer(ctx context.Context, containerHostMapping ContainerHostMapping, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location": autorest.Encode("path", location),
	}

	const APIVersion = "2018-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.DevSpaces/locations/{location}/checkContainerHostMapping", pathParameters),
		autorest.WithJSON(containerHostMapping),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetContainerHostMappingSender sends the GetContainerHostMapping request. The method will close the
// http.Response Body if it receives an error.
func (client ContainerHostMappingsClient) GetContainerHostMappingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetContainerHostMappingResponder handles the response to the GetContainerHostMapping request. The method always
// closes the http.Response Body.
func (client ContainerHostMappingsClient) GetContainerHostMappingResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
