package google

import (
	"github.com/hashicorp/terraform/helper/schema"
)

func dataSourceGoogleProjectServices() *schema.Resource {
	// Generate datasource schema from resource
	dsSchema := datasourceSchemaFromResourceSchema(resourceGoogleProjectServices().Schema)

	// Set 'Optional' schema elements
	addOptionalFieldsToSchema(dsSchema, "project")

	return &schema.Resource{
		Read:   dataSourceGoogleProjectServicesRead,
		Schema: dsSchema,
	}
}

func dataSourceGoogleProjectServicesRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	project, err := getProject(d, config)
	if err != nil {
		return err
	}
	d.SetId(project)

	return resourceGoogleProjectServicesRead(d, meta)
}
