package devspaces

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ContainerHostMappingsClient is the dev Spaces Client
type ContainerHostMappingsClient struct {
	BaseClient
}

// NewContainerHostMappingsClient creates an instance of the ContainerHostMappingsClient client.
func NewContainerHostMappingsClient(subscriptionID string) ContainerHostMappingsClient {
	return NewContainerHostMappingsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewContainerHostMappingsClientWithBaseURI creates an instance of the ContainerHostMappingsClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewContainerHostMappingsClientWithBaseURI(baseURI string, subscriptionID string) ContainerHostMappingsClient {
	return ContainerHostMappingsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetContainerHostMapping sends the get container host mapping request.
// Parameters:
// resourceGroupName - resource group to which the resource belongs.
// location - location of the container host.
func (client ContainerHostMappingsClient) GetContainerHostMapping(ctx context.Context, containerHostMapping ContainerHostMapping, resourceGroupName string, location string) (result ContainerHostMapping, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContainerHostMappingsClient.GetContainerHostMapping")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("devspaces.ContainerHostMappingsClient", "GetContainerHostMapping", err.Error())
	}

	req, err := client.GetContainerHostMappingPreparer(ctx, containerHostMapping, resourceGroupName, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devspaces.ContainerHostMappingsClient", "GetContainerHostMapping", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetContainerHostMappingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devspaces.ContainerHostMappingsClient", "GetContainerHostMapping", resp, "Failure sending request")
		return
	}

	result, err = client.GetContainerHostMappingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devspaces.ContainerHostMappingsClient", "GetContainerHostMapping", resp, "Failure responding to request")
	}

	return
}

// GetContainerHostMappingPreparer prepares the GetContainerHostMapping request.
func (client ContainerHostMappingsClient) GetContainerHostMappingPreparer(ctx context.Context, containerHostMapping ContainerHostMapping, resourceGroupName string, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":          autorest.Encode("path", location),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	containerHostMapping.MappedControllerResourceID = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevSpaces/locations/{location}/checkContainerHostMapping", pathParameters),
		autorest.WithJSON(containerHostMapping),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetContainerHostMappingSender sends the GetContainerHostMapping request. The method will close the
// http.Response Body if it receives an error.
func (client ContainerHostMappingsClient) GetContainerHostMappingSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetContainerHostMappingResponder handles the response to the GetContainerHostMapping request. The method always
// closes the http.Response Body.
func (client ContainerHostMappingsClient) GetContainerHostMappingResponder(resp *http.Response) (result ContainerHostMapping, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
