# etcd-certificate-generator

The `etcd-certificate-generator` generates TLS certificates for etcd nodes so they can communicate between themselves.

## Components

### Certificate Signer

The certificate signer approves a given valid Certificate Signing Request (CSR) provided by the client agent and returns the updated CSR with a [request status](https://godoc.org/k8s.io/api/certificates/v1beta1#CertificateSigningRequestStatus) which can either be `Approved` or `Denied`. If the CSR is `Approved`, it will contain a signed certificate in the [CSR status](https://godoc.org/k8s.io/api/certificates/v1beta1#CertificateSigningRequestStatus). This component makes use of the [`cfssl`](https://github.com/cloudflare/cfssl) package to perfom the signing operations. It requires the CA's certificate and private key to be provided in the config file.

### Certificate Agent

The certificate agent should run on the node that requires the signed certificate. This agent generates a valid CSR according to the configuration flags provided to it and does a POST request to the signer passing along the CSR for approval. Once the CSR is approved the agent receives the approved CSR back and which contains the signed certificate. It saves the signed certificate to a disk location provided as a flag value.

The certificate client agent does not have any `etcd` specific logic in it. It can be used for other nodes in theory, though it has not been tested and verified for any other nodes.


## Usage

Both the `kube-etcd-signer-server` and `kube-client-agent` modules need credentials to run the binaries. You can make use of the [`cert-gen.sh`](../scripts/cert-gen.sh) script to generate fake credentials for the CA, server and client. The [`cert-destroy.sh`](../scripts/cert-destroy.sh) script will destroy all the credentials generated by `cert-gen.sh`. The following usage examples assume that the credential files exist in the `testdata` directory.

### Running the kube-etcd-signer-server module:

Run the following make command to create the kube-etcd-signer-server binary:

```
make bin/kube-etcd-signer-server

```

Run the following command to start the kube-etcd-signer-server instance with the example configuration flag values:

```
./cmd/bin/kube-etcd-signer-server serve --cacrt=ca.crt --cakey=ca.key --csrdir=<path to directory> --servcrt=server.crt --servkey=server.key
```

Now a signer has been setup and it listens for requests at `0.0.0.0:6443` (which is the default listening address)

### Running the kube-client-agent module:

Run the following make command to create the kube-client-agent binary:

```
make bin/kube-client-agent

```

Run the following command to start the kube-client-agent with the example configuration flag values:

```
./cmd/bin/kube-client-agent request --dnsnames=test --ipaddrs=10.8.89.9 --commonname=system:etcd-peer:etcd1 --orgname=system:etcd-peers --assetsdir=<path to directory> --cacrt=ca.crt
```

Check the `assetsDir` location for the signed certificate.

## Running the tests:

Run `make test` to run both the `certagent` and `certsigner` test. If successful the results should be as follows:

```
$ make test
ok  	github.com/coreos-inc/etcd-certificate-generator/pkg/certagent	0.214s
ok  	github.com/coreos-inc/etcd-certificate-generator/pkg/certsigner	0.026s
```
