/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package phases

import (
	"github.com/openshift/cluster-api/cmd/clusterctl/clusterdeployer/clusterclient"
	"github.com/pkg/errors"
	"k8s.io/klog"
)

func ApplyBootstrapComponents(client clusterclient.Client, components string) error {
	klog.Info("Applying Bootstrap-only Components")
	if err := client.Apply(components); err != nil {
		return errors.Wrap(err, "unable to apply bootstrap-only components")
	}

	return nil
}
