// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/machine-config-operator/pkg/apis/machineconfiguration.openshift.io/v1"
	scheme "github.com/openshift/machine-config-operator/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KubeletConfigsGetter has a method to return a KubeletConfigInterface.
// A group's client should implement this interface.
type KubeletConfigsGetter interface {
	KubeletConfigs() KubeletConfigInterface
}

// KubeletConfigInterface has methods to work with KubeletConfig resources.
type KubeletConfigInterface interface {
	Create(*v1.KubeletConfig) (*v1.KubeletConfig, error)
	Update(*v1.KubeletConfig) (*v1.KubeletConfig, error)
	UpdateStatus(*v1.KubeletConfig) (*v1.KubeletConfig, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.KubeletConfig, error)
	List(opts metav1.ListOptions) (*v1.KubeletConfigList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubeletConfig, err error)
	KubeletConfigExpansion
}

// kubeletConfigs implements KubeletConfigInterface
type kubeletConfigs struct {
	client rest.Interface
}

// newKubeletConfigs returns a KubeletConfigs
func newKubeletConfigs(c *MachineconfigurationV1Client) *kubeletConfigs {
	return &kubeletConfigs{
		client: c.RESTClient(),
	}
}

// Get takes name of the kubeletConfig, and returns the corresponding kubeletConfig object, and an error if there is any.
func (c *kubeletConfigs) Get(name string, options metav1.GetOptions) (result *v1.KubeletConfig, err error) {
	result = &v1.KubeletConfig{}
	err = c.client.Get().
		Resource("kubeletconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KubeletConfigs that match those selectors.
func (c *kubeletConfigs) List(opts metav1.ListOptions) (result *v1.KubeletConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.KubeletConfigList{}
	err = c.client.Get().
		Resource("kubeletconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kubeletConfigs.
func (c *kubeletConfigs) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("kubeletconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a kubeletConfig and creates it.  Returns the server's representation of the kubeletConfig, and an error, if there is any.
func (c *kubeletConfigs) Create(kubeletConfig *v1.KubeletConfig) (result *v1.KubeletConfig, err error) {
	result = &v1.KubeletConfig{}
	err = c.client.Post().
		Resource("kubeletconfigs").
		Body(kubeletConfig).
		Do().
		Into(result)
	return
}

// Update takes the representation of a kubeletConfig and updates it. Returns the server's representation of the kubeletConfig, and an error, if there is any.
func (c *kubeletConfigs) Update(kubeletConfig *v1.KubeletConfig) (result *v1.KubeletConfig, err error) {
	result = &v1.KubeletConfig{}
	err = c.client.Put().
		Resource("kubeletconfigs").
		Name(kubeletConfig.Name).
		Body(kubeletConfig).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *kubeletConfigs) UpdateStatus(kubeletConfig *v1.KubeletConfig) (result *v1.KubeletConfig, err error) {
	result = &v1.KubeletConfig{}
	err = c.client.Put().
		Resource("kubeletconfigs").
		Name(kubeletConfig.Name).
		SubResource("status").
		Body(kubeletConfig).
		Do().
		Into(result)
	return
}

// Delete takes name of the kubeletConfig and deletes it. Returns an error if one occurs.
func (c *kubeletConfigs) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("kubeletconfigs").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *kubeletConfigs) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("kubeletconfigs").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched kubeletConfig.
func (c *kubeletConfigs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubeletConfig, err error) {
	result = &v1.KubeletConfig{}
	err = c.client.Patch(pt).
		Resource("kubeletconfigs").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
