# once-from

The promise of the next-generation OpenShift installer and Red Hat CoreOS
combined with the machine-config-operator is fully automated management
of the hosts in a highly integrated fashion.

However, we also aim to support a "bring your own host" model. We want to avoid
duplication as much as possible between these two code paths. The idea of the
"once-from" mode for the machine-config-daemon is that one can pass it an
Ignition config (as generated by the installer for example) and execute it
on a host that was already created. (The feature also supports MachineConfig
manifests which are meant to be used for host updates rather than installation).

This is mostly about laying down files and systemd units and the like; we
don't expect "once-from" to e.g. create users.

# Testing once-from mode

Once-from should generally be used on a machine not connected to a cluster.  You can use for example a traditional CentOS 7 machine;
this could be anything from a cloud instance to a Vagrant Box or even
a physical install.

This guide was written using Vagrant to make a CentOS 7 box: https://app.vagrantup.com/centos/boxes/7

An easy way to test this is to copy over the machine-config-daemon
binary from `_output/linux/amd64/machine-config-daemon` to the
target.  (With Vagrant for example, copy to the target dir then `vagrant rsync`, the output will be in `/vagrant`).

To run:

`./machine-config-daemon start --node-name $(hostname) --root-mount / --once-from $(pwd)/example.ign`

Where `example.ign` here is the content from https://github.com/coreos/ignition/blob/master/doc/examples.md#start-services

```json
{
  "ignition": { "version": "2.2.0" },
  "systemd": {
    "units": [{
      "name": "example.service",
      "enabled": true,
      "contents": "[Service]\nType=oneshot\nExecStart=/usr/bin/echo Hello World\n\n[Install]\nWantedBy=multi-user.target"
    }]
  }
}
```

You can also try out the MachineConfig support of "once-from" mode by passing a MC manifest instead, see [HACKING.md](./HACKING.md) for a MachineConfig example.
