// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBatchGetNamedQuery = "BatchGetNamedQuery"

// BatchGetNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetNamedQuery operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetNamedQuery for more information on using the BatchGetNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetNamedQueryRequest method.
//    req, resp := client.BatchGetNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery
func (c *Athena) BatchGetNamedQueryRequest(input *BatchGetNamedQueryInput) (req *request.Request, output *BatchGetNamedQueryOutput) {
	op := &request.Operation{
		Name:       opBatchGetNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetNamedQueryInput{}
	}

	output = &BatchGetNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetNamedQuery API operation for Amazon Athena.
//
// Returns the details of a single named query or a list of up to 50 queries,
// which you provide as an array of query ID strings. Use ListNamedQueries to
// get the list of named query IDs. If information could not be retrieved for
// a submitted query ID, information about the query ID submitted is listed
// under UnprocessedNamedQueryId. Named queries are different from executed
// queries. Use BatchGetQueryExecution to get details about each unique query
// execution, and ListQueryExecutions to get a list of query execution IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation BatchGetNamedQuery for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery
func (c *Athena) BatchGetNamedQuery(input *BatchGetNamedQueryInput) (*BatchGetNamedQueryOutput, error) {
	req, out := c.BatchGetNamedQueryRequest(input)
	return out, req.Send()
}

// BatchGetNamedQueryWithContext is the same as BatchGetNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) BatchGetNamedQueryWithContext(ctx aws.Context, input *BatchGetNamedQueryInput, opts ...request.Option) (*BatchGetNamedQueryOutput, error) {
	req, out := c.BatchGetNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetQueryExecution = "BatchGetQueryExecution"

// BatchGetQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetQueryExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetQueryExecution for more information on using the BatchGetQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetQueryExecutionRequest method.
//    req, resp := client.BatchGetQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution
func (c *Athena) BatchGetQueryExecutionRequest(input *BatchGetQueryExecutionInput) (req *request.Request, output *BatchGetQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opBatchGetQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetQueryExecutionInput{}
	}

	output = &BatchGetQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetQueryExecution API operation for Amazon Athena.
//
// Returns the details of a single query execution or a list of up to 50 query
// executions, which you provide as an array of query execution ID strings.
// To get a list of query execution IDs, use ListQueryExecutions. Query executions
// are different from named (saved) queries. Use BatchGetNamedQuery to get details
// about named queries.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation BatchGetQueryExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution
func (c *Athena) BatchGetQueryExecution(input *BatchGetQueryExecutionInput) (*BatchGetQueryExecutionOutput, error) {
	req, out := c.BatchGetQueryExecutionRequest(input)
	return out, req.Send()
}

// BatchGetQueryExecutionWithContext is the same as BatchGetQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) BatchGetQueryExecutionWithContext(ctx aws.Context, input *BatchGetQueryExecutionInput, opts ...request.Option) (*BatchGetQueryExecutionOutput, error) {
	req, out := c.BatchGetQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNamedQuery = "CreateNamedQuery"

// CreateNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the CreateNamedQuery operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNamedQuery for more information on using the CreateNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNamedQueryRequest method.
//    req, resp := client.CreateNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery
func (c *Athena) CreateNamedQueryRequest(input *CreateNamedQueryInput) (req *request.Request, output *CreateNamedQueryOutput) {
	op := &request.Operation{
		Name:       opCreateNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNamedQueryInput{}
	}

	output = &CreateNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNamedQuery API operation for Amazon Athena.
//
// Creates a named query.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation CreateNamedQuery for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery
func (c *Athena) CreateNamedQuery(input *CreateNamedQueryInput) (*CreateNamedQueryOutput, error) {
	req, out := c.CreateNamedQueryRequest(input)
	return out, req.Send()
}

// CreateNamedQueryWithContext is the same as CreateNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) CreateNamedQueryWithContext(ctx aws.Context, input *CreateNamedQueryInput, opts ...request.Option) (*CreateNamedQueryOutput, error) {
	req, out := c.CreateNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamedQuery = "DeleteNamedQuery"

// DeleteNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamedQuery operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamedQuery for more information on using the DeleteNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNamedQueryRequest method.
//    req, resp := client.DeleteNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery
func (c *Athena) DeleteNamedQueryRequest(input *DeleteNamedQueryInput) (req *request.Request, output *DeleteNamedQueryOutput) {
	op := &request.Operation{
		Name:       opDeleteNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNamedQueryInput{}
	}

	output = &DeleteNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNamedQuery API operation for Amazon Athena.
//
// Deletes a named query.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation DeleteNamedQuery for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery
func (c *Athena) DeleteNamedQuery(input *DeleteNamedQueryInput) (*DeleteNamedQueryOutput, error) {
	req, out := c.DeleteNamedQueryRequest(input)
	return out, req.Send()
}

// DeleteNamedQueryWithContext is the same as DeleteNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) DeleteNamedQueryWithContext(ctx aws.Context, input *DeleteNamedQueryInput, opts ...request.Option) (*DeleteNamedQueryOutput, error) {
	req, out := c.DeleteNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNamedQuery = "GetNamedQuery"

// GetNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the GetNamedQuery operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNamedQuery for more information on using the GetNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNamedQueryRequest method.
//    req, resp := client.GetNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery
func (c *Athena) GetNamedQueryRequest(input *GetNamedQueryInput) (req *request.Request, output *GetNamedQueryOutput) {
	op := &request.Operation{
		Name:       opGetNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNamedQueryInput{}
	}

	output = &GetNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNamedQuery API operation for Amazon Athena.
//
// Returns information about a single query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetNamedQuery for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery
func (c *Athena) GetNamedQuery(input *GetNamedQueryInput) (*GetNamedQueryOutput, error) {
	req, out := c.GetNamedQueryRequest(input)
	return out, req.Send()
}

// GetNamedQueryWithContext is the same as GetNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See GetNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetNamedQueryWithContext(ctx aws.Context, input *GetNamedQueryInput, opts ...request.Option) (*GetNamedQueryOutput, error) {
	req, out := c.GetNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueryExecution = "GetQueryExecution"

// GetQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetQueryExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueryExecution for more information on using the GetQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQueryExecutionRequest method.
//    req, resp := client.GetQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution
func (c *Athena) GetQueryExecutionRequest(input *GetQueryExecutionInput) (req *request.Request, output *GetQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opGetQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQueryExecutionInput{}
	}

	output = &GetQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQueryExecution API operation for Amazon Athena.
//
// Returns information about a single execution of a query. Each time a query
// executes, information about the query execution is saved with a unique ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetQueryExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution
func (c *Athena) GetQueryExecution(input *GetQueryExecutionInput) (*GetQueryExecutionOutput, error) {
	req, out := c.GetQueryExecutionRequest(input)
	return out, req.Send()
}

// GetQueryExecutionWithContext is the same as GetQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetQueryExecutionWithContext(ctx aws.Context, input *GetQueryExecutionInput, opts ...request.Option) (*GetQueryExecutionOutput, error) {
	req, out := c.GetQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueryResults = "GetQueryResults"

// GetQueryResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetQueryResults operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueryResults for more information on using the GetQueryResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQueryResultsRequest method.
//    req, resp := client.GetQueryResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults
func (c *Athena) GetQueryResultsRequest(input *GetQueryResultsInput) (req *request.Request, output *GetQueryResultsOutput) {
	op := &request.Operation{
		Name:       opGetQueryResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetQueryResultsInput{}
	}

	output = &GetQueryResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQueryResults API operation for Amazon Athena.
//
// Returns the results of a single query execution specified by QueryExecutionId.
// This request does not execute the query but returns results. Use StartQueryExecution
// to run a query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetQueryResults for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults
func (c *Athena) GetQueryResults(input *GetQueryResultsInput) (*GetQueryResultsOutput, error) {
	req, out := c.GetQueryResultsRequest(input)
	return out, req.Send()
}

// GetQueryResultsWithContext is the same as GetQueryResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueryResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetQueryResultsWithContext(ctx aws.Context, input *GetQueryResultsInput, opts ...request.Option) (*GetQueryResultsOutput, error) {
	req, out := c.GetQueryResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetQueryResultsPages iterates over the pages of a GetQueryResults operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetQueryResults method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetQueryResults operation.
//    pageNum := 0
//    err := client.GetQueryResultsPages(params,
//        func(page *GetQueryResultsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) GetQueryResultsPages(input *GetQueryResultsInput, fn func(*GetQueryResultsOutput, bool) bool) error {
	return c.GetQueryResultsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetQueryResultsPagesWithContext same as GetQueryResultsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetQueryResultsPagesWithContext(ctx aws.Context, input *GetQueryResultsInput, fn func(*GetQueryResultsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetQueryResultsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetQueryResultsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetQueryResultsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListNamedQueries = "ListNamedQueries"

// ListNamedQueriesRequest generates a "aws/request.Request" representing the
// client's request for the ListNamedQueries operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamedQueries for more information on using the ListNamedQueries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNamedQueriesRequest method.
//    req, resp := client.ListNamedQueriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries
func (c *Athena) ListNamedQueriesRequest(input *ListNamedQueriesInput) (req *request.Request, output *ListNamedQueriesOutput) {
	op := &request.Operation{
		Name:       opListNamedQueries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNamedQueriesInput{}
	}

	output = &ListNamedQueriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamedQueries API operation for Amazon Athena.
//
// Provides a list of all available query IDs.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListNamedQueries for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries
func (c *Athena) ListNamedQueries(input *ListNamedQueriesInput) (*ListNamedQueriesOutput, error) {
	req, out := c.ListNamedQueriesRequest(input)
	return out, req.Send()
}

// ListNamedQueriesWithContext is the same as ListNamedQueries with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamedQueries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListNamedQueriesWithContext(ctx aws.Context, input *ListNamedQueriesInput, opts ...request.Option) (*ListNamedQueriesOutput, error) {
	req, out := c.ListNamedQueriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNamedQueriesPages iterates over the pages of a ListNamedQueries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNamedQueries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNamedQueries operation.
//    pageNum := 0
//    err := client.ListNamedQueriesPages(params,
//        func(page *ListNamedQueriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListNamedQueriesPages(input *ListNamedQueriesInput, fn func(*ListNamedQueriesOutput, bool) bool) error {
	return c.ListNamedQueriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNamedQueriesPagesWithContext same as ListNamedQueriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListNamedQueriesPagesWithContext(ctx aws.Context, input *ListNamedQueriesInput, fn func(*ListNamedQueriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNamedQueriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNamedQueriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListNamedQueriesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListQueryExecutions = "ListQueryExecutions"

// ListQueryExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListQueryExecutions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueryExecutions for more information on using the ListQueryExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListQueryExecutionsRequest method.
//    req, resp := client.ListQueryExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions
func (c *Athena) ListQueryExecutionsRequest(input *ListQueryExecutionsInput) (req *request.Request, output *ListQueryExecutionsOutput) {
	op := &request.Operation{
		Name:       opListQueryExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueryExecutionsInput{}
	}

	output = &ListQueryExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQueryExecutions API operation for Amazon Athena.
//
// Provides a list of all available query execution IDs.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListQueryExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions
func (c *Athena) ListQueryExecutions(input *ListQueryExecutionsInput) (*ListQueryExecutionsOutput, error) {
	req, out := c.ListQueryExecutionsRequest(input)
	return out, req.Send()
}

// ListQueryExecutionsWithContext is the same as ListQueryExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueryExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListQueryExecutionsWithContext(ctx aws.Context, input *ListQueryExecutionsInput, opts ...request.Option) (*ListQueryExecutionsOutput, error) {
	req, out := c.ListQueryExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueryExecutionsPages iterates over the pages of a ListQueryExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueryExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListQueryExecutions operation.
//    pageNum := 0
//    err := client.ListQueryExecutionsPages(params,
//        func(page *ListQueryExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListQueryExecutionsPages(input *ListQueryExecutionsInput, fn func(*ListQueryExecutionsOutput, bool) bool) error {
	return c.ListQueryExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueryExecutionsPagesWithContext same as ListQueryExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListQueryExecutionsPagesWithContext(ctx aws.Context, input *ListQueryExecutionsInput, fn func(*ListQueryExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueryExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueryExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListQueryExecutionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opStartQueryExecution = "StartQueryExecution"

// StartQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartQueryExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartQueryExecution for more information on using the StartQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartQueryExecutionRequest method.
//    req, resp := client.StartQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution
func (c *Athena) StartQueryExecutionRequest(input *StartQueryExecutionInput) (req *request.Request, output *StartQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opStartQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartQueryExecutionInput{}
	}

	output = &StartQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartQueryExecution API operation for Amazon Athena.
//
// Runs (executes) the SQL query statements contained in the Query string.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation StartQueryExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Indicates that the request was throttled.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution
func (c *Athena) StartQueryExecution(input *StartQueryExecutionInput) (*StartQueryExecutionOutput, error) {
	req, out := c.StartQueryExecutionRequest(input)
	return out, req.Send()
}

// StartQueryExecutionWithContext is the same as StartQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) StartQueryExecutionWithContext(ctx aws.Context, input *StartQueryExecutionInput, opts ...request.Option) (*StartQueryExecutionOutput, error) {
	req, out := c.StartQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopQueryExecution = "StopQueryExecution"

// StopQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopQueryExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopQueryExecution for more information on using the StopQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopQueryExecutionRequest method.
//    req, resp := client.StopQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution
func (c *Athena) StopQueryExecutionRequest(input *StopQueryExecutionInput) (req *request.Request, output *StopQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opStopQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopQueryExecutionInput{}
	}

	output = &StopQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopQueryExecution API operation for Amazon Athena.
//
// Stops a query execution.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation StopQueryExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution
func (c *Athena) StopQueryExecution(input *StopQueryExecutionInput) (*StopQueryExecutionOutput, error) {
	req, out := c.StopQueryExecutionRequest(input)
	return out, req.Send()
}

// StopQueryExecutionWithContext is the same as StopQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) StopQueryExecutionWithContext(ctx aws.Context, input *StopQueryExecutionInput, opts ...request.Option) (*StopQueryExecutionOutput, error) {
	req, out := c.StopQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQueryInput
type BatchGetNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// An array of query IDs.
	//
	// NamedQueryIds is a required field
	NamedQueryIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetNamedQueryInput"}
	if s.NamedQueryIds == nil {
		invalidParams.Add(request.NewErrParamRequired("NamedQueryIds"))
	}
	if s.NamedQueryIds != nil && len(s.NamedQueryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamedQueryIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamedQueryIds sets the NamedQueryIds field's value.
func (s *BatchGetNamedQueryInput) SetNamedQueryIds(v []*string) *BatchGetNamedQueryInput {
	s.NamedQueryIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQueryOutput
type BatchGetNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the named query IDs submitted.
	NamedQueries []*NamedQuery `type:"list"`

	// Information about provided query IDs.
	UnprocessedNamedQueryIds []*UnprocessedNamedQueryId `type:"list"`
}

// String returns the string representation
func (s BatchGetNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetNamedQueryOutput) GoString() string {
	return s.String()
}

// SetNamedQueries sets the NamedQueries field's value.
func (s *BatchGetNamedQueryOutput) SetNamedQueries(v []*NamedQuery) *BatchGetNamedQueryOutput {
	s.NamedQueries = v
	return s
}

// SetUnprocessedNamedQueryIds sets the UnprocessedNamedQueryIds field's value.
func (s *BatchGetNamedQueryOutput) SetUnprocessedNamedQueryIds(v []*UnprocessedNamedQueryId) *BatchGetNamedQueryOutput {
	s.UnprocessedNamedQueryIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecutionInput
type BatchGetQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// An array of query execution IDs.
	//
	// QueryExecutionIds is a required field
	QueryExecutionIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetQueryExecutionInput"}
	if s.QueryExecutionIds == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionIds"))
	}
	if s.QueryExecutionIds != nil && len(s.QueryExecutionIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryExecutionIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryExecutionIds sets the QueryExecutionIds field's value.
func (s *BatchGetQueryExecutionInput) SetQueryExecutionIds(v []*string) *BatchGetQueryExecutionInput {
	s.QueryExecutionIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecutionOutput
type BatchGetQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Information about a query execution.
	QueryExecutions []*QueryExecution `type:"list"`

	// Information about the query executions that failed to run.
	UnprocessedQueryExecutionIds []*UnprocessedQueryExecutionId `type:"list"`
}

// String returns the string representation
func (s BatchGetQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetQueryExecutionOutput) GoString() string {
	return s.String()
}

// SetQueryExecutions sets the QueryExecutions field's value.
func (s *BatchGetQueryExecutionOutput) SetQueryExecutions(v []*QueryExecution) *BatchGetQueryExecutionOutput {
	s.QueryExecutions = v
	return s
}

// SetUnprocessedQueryExecutionIds sets the UnprocessedQueryExecutionIds field's value.
func (s *BatchGetQueryExecutionOutput) SetUnprocessedQueryExecutionIds(v []*UnprocessedQueryExecutionId) *BatchGetQueryExecutionOutput {
	s.UnprocessedQueryExecutionIds = v
	return s
}

// Information about the columns in a query execution result.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ColumnInfo
type ColumnInfo struct {
	_ struct{} `type:"structure"`

	// Indicates whether values in the column are case-sensitive.
	CaseSensitive *bool `type:"boolean"`

	// The catalog to which the query results belong.
	CatalogName *string `type:"string"`

	// A column label.
	Label *string `type:"string"`

	// The name of the column.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Indicates the column's nullable status.
	Nullable *string `type:"string" enum:"ColumnNullable"`

	// For DECIMAL data types, specifies the total number of digits, up to 38. For
	// performance reasons, we recommend up to 18 digits.
	Precision *int64 `type:"integer"`

	// For DECIMAL data types, specifies the total number of digits in the fractional
	// part of the value. Defaults to 0.
	Scale *int64 `type:"integer"`

	// The schema name (database name) to which the query results belong.
	SchemaName *string `type:"string"`

	// The table name for the query results.
	TableName *string `type:"string"`

	// The data type of the column.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ColumnInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnInfo) GoString() string {
	return s.String()
}

// SetCaseSensitive sets the CaseSensitive field's value.
func (s *ColumnInfo) SetCaseSensitive(v bool) *ColumnInfo {
	s.CaseSensitive = &v
	return s
}

// SetCatalogName sets the CatalogName field's value.
func (s *ColumnInfo) SetCatalogName(v string) *ColumnInfo {
	s.CatalogName = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *ColumnInfo) SetLabel(v string) *ColumnInfo {
	s.Label = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnInfo) SetName(v string) *ColumnInfo {
	s.Name = &v
	return s
}

// SetNullable sets the Nullable field's value.
func (s *ColumnInfo) SetNullable(v string) *ColumnInfo {
	s.Nullable = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *ColumnInfo) SetPrecision(v int64) *ColumnInfo {
	s.Precision = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *ColumnInfo) SetScale(v int64) *ColumnInfo {
	s.Scale = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *ColumnInfo) SetSchemaName(v string) *ColumnInfo {
	s.SchemaName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ColumnInfo) SetTableName(v string) *ColumnInfo {
	s.TableName = &v
	return s
}

// SetType sets the Type field's value.
func (s *ColumnInfo) SetType(v string) *ColumnInfo {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQueryInput
type CreateNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure the request to create the query
	// is idempotent (executes only once). If another CreateNamedQuery request is
	// received, the same response is returned and another query is not created.
	// If a parameter has changed, for example, the QueryString, an error is returned.
	//
	// This token is listed as not required because AWS SDKs (for example the AWS
	// SDK for Java) auto-generate the token for users. If you are not using the
	// AWS SDK or the AWS CLI, you must provide this token or the action will fail.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// The database to which the query belongs.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// A brief explanation of the query.
	Description *string `min:"1" type:"string"`

	// The plain language name for the query.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The text of the query itself. In other words, all query statements.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNamedQueryInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNamedQueryInput) SetClientRequestToken(v string) *CreateNamedQueryInput {
	s.ClientRequestToken = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *CreateNamedQueryInput) SetDatabase(v string) *CreateNamedQueryInput {
	s.Database = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNamedQueryInput) SetDescription(v string) *CreateNamedQueryInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateNamedQueryInput) SetName(v string) *CreateNamedQueryInput {
	s.Name = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *CreateNamedQueryInput) SetQueryString(v string) *CreateNamedQueryInput {
	s.QueryString = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQueryOutput
type CreateNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query.
	NamedQueryId *string `type:"string"`
}

// String returns the string representation
func (s CreateNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNamedQueryOutput) GoString() string {
	return s.String()
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *CreateNamedQueryOutput) SetNamedQueryId(v string) *CreateNamedQueryOutput {
	s.NamedQueryId = &v
	return s
}

// A piece of data (a field in the table).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/Datum
type Datum struct {
	_ struct{} `type:"structure"`

	// The value of the datum.
	VarCharValue *string `type:"string"`
}

// String returns the string representation
func (s Datum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Datum) GoString() string {
	return s.String()
}

// SetVarCharValue sets the VarCharValue field's value.
func (s *Datum) SetVarCharValue(v string) *Datum {
	s.VarCharValue = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQueryInput
type DeleteNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query to delete.
	//
	// NamedQueryId is a required field
	NamedQueryId *string `type:"string" required:"true" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNamedQueryInput"}
	if s.NamedQueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("NamedQueryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *DeleteNamedQueryInput) SetNamedQueryId(v string) *DeleteNamedQueryInput {
	s.NamedQueryId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQueryOutput
type DeleteNamedQueryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamedQueryOutput) GoString() string {
	return s.String()
}

// If query results are encrypted in Amazon S3, indicates the Amazon S3 encryption
// option used.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/EncryptionConfiguration
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether Amazon S3 server-side encryption with Amazon S3-managed
	// keys (SSE-S3), server-side encryption with KMS-managed keys (SSE-KMS), or
	// client-side encryption with KMS-managed keys (CSE-KMS) is used.
	//
	// EncryptionOption is a required field
	EncryptionOption *string `type:"string" required:"true" enum:"EncryptionOption"`

	// For SSE-KMS and CSE-KMS, this is the KMS key ARN or ID.
	KmsKey *string `type:"string"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfiguration"}
	if s.EncryptionOption == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionOption"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionOption sets the EncryptionOption field's value.
func (s *EncryptionConfiguration) SetEncryptionOption(v string) *EncryptionConfiguration {
	s.EncryptionOption = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *EncryptionConfiguration) SetKmsKey(v string) *EncryptionConfiguration {
	s.KmsKey = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQueryInput
type GetNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query. Use ListNamedQueries to get query IDs.
	//
	// NamedQueryId is a required field
	NamedQueryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNamedQueryInput"}
	if s.NamedQueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("NamedQueryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *GetNamedQueryInput) SetNamedQueryId(v string) *GetNamedQueryInput {
	s.NamedQueryId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQueryOutput
type GetNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query.
	NamedQuery *NamedQuery `type:"structure"`
}

// String returns the string representation
func (s GetNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamedQueryOutput) GoString() string {
	return s.String()
}

// SetNamedQuery sets the NamedQuery field's value.
func (s *GetNamedQueryOutput) SetNamedQuery(v *NamedQuery) *GetNamedQueryOutput {
	s.NamedQuery = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecutionInput
type GetQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query execution.
	//
	// QueryExecutionId is a required field
	QueryExecutionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueryExecutionInput"}
	if s.QueryExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *GetQueryExecutionInput) SetQueryExecutionId(v string) *GetQueryExecutionInput {
	s.QueryExecutionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecutionOutput
type GetQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query execution.
	QueryExecution *QueryExecution `type:"structure"`
}

// String returns the string representation
func (s GetQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryExecutionOutput) GoString() string {
	return s.String()
}

// SetQueryExecution sets the QueryExecution field's value.
func (s *GetQueryExecutionOutput) SetQueryExecution(v *QueryExecution) *GetQueryExecutionOutput {
	s.QueryExecution = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResultsInput
type GetQueryResultsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results (rows) to return in this request.
	MaxResults *int64 `type:"integer"`

	// The token that specifies where to start pagination if a previous request
	// was truncated.
	NextToken *string `type:"string"`

	// The unique ID of the query execution.
	//
	// QueryExecutionId is a required field
	QueryExecutionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetQueryResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueryResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueryResultsInput"}
	if s.QueryExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetQueryResultsInput) SetMaxResults(v int64) *GetQueryResultsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetQueryResultsInput) SetNextToken(v string) *GetQueryResultsInput {
	s.NextToken = &v
	return s
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *GetQueryResultsInput) SetQueryExecutionId(v string) *GetQueryResultsInput {
	s.QueryExecutionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResultsOutput
type GetQueryResultsOutput struct {
	_ struct{} `type:"structure"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `type:"string"`

	// The results of the query execution.
	ResultSet *ResultSet `type:"structure"`
}

// String returns the string representation
func (s GetQueryResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryResultsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetQueryResultsOutput) SetNextToken(v string) *GetQueryResultsOutput {
	s.NextToken = &v
	return s
}

// SetResultSet sets the ResultSet field's value.
func (s *GetQueryResultsOutput) SetResultSet(v *ResultSet) *GetQueryResultsOutput {
	s.ResultSet = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueriesInput
type ListNamedQueriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of queries to return in this request.
	MaxResults *int64 `type:"integer"`

	// The token that specifies where to start pagination if a previous request
	// was truncated.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListNamedQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamedQueriesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNamedQueriesInput) SetMaxResults(v int64) *ListNamedQueriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamedQueriesInput) SetNextToken(v string) *ListNamedQueriesInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueriesOutput
type ListNamedQueriesOutput struct {
	_ struct{} `type:"structure"`

	// The list of unique query IDs.
	NamedQueryIds []*string `min:"1" type:"list"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListNamedQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamedQueriesOutput) GoString() string {
	return s.String()
}

// SetNamedQueryIds sets the NamedQueryIds field's value.
func (s *ListNamedQueriesOutput) SetNamedQueryIds(v []*string) *ListNamedQueriesOutput {
	s.NamedQueryIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamedQueriesOutput) SetNextToken(v string) *ListNamedQueriesOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutionsInput
type ListQueryExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of query executions to return in this request.
	MaxResults *int64 `type:"integer"`

	// The token that specifies where to start pagination if a previous request
	// was truncated.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListQueryExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueryExecutionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQueryExecutionsInput) SetMaxResults(v int64) *ListQueryExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueryExecutionsInput) SetNextToken(v string) *ListQueryExecutionsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutionsOutput
type ListQueryExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `type:"string"`

	// The unique IDs of each query execution as an array of strings.
	QueryExecutionIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s ListQueryExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueryExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueryExecutionsOutput) SetNextToken(v string) *ListQueryExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetQueryExecutionIds sets the QueryExecutionIds field's value.
func (s *ListQueryExecutionsOutput) SetQueryExecutionIds(v []*string) *ListQueryExecutionsOutput {
	s.QueryExecutionIds = v
	return s
}

// A query, where QueryString is the SQL query statements that comprise the
// query.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/NamedQuery
type NamedQuery struct {
	_ struct{} `type:"structure"`

	// The database to which the query belongs.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// A brief description of the query.
	Description *string `min:"1" type:"string"`

	// The plain-language name of the query.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the query.
	NamedQueryId *string `type:"string"`

	// The SQL query statements that comprise the query.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s NamedQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamedQuery) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *NamedQuery) SetDatabase(v string) *NamedQuery {
	s.Database = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NamedQuery) SetDescription(v string) *NamedQuery {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *NamedQuery) SetName(v string) *NamedQuery {
	s.Name = &v
	return s
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *NamedQuery) SetNamedQueryId(v string) *NamedQuery {
	s.NamedQueryId = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *NamedQuery) SetQueryString(v string) *NamedQuery {
	s.QueryString = &v
	return s
}

// Information about a single instance of a query execution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/QueryExecution
type QueryExecution struct {
	_ struct{} `type:"structure"`

	// The SQL query statements which the query execution ran.
	Query *string `min:"1" type:"string"`

	// The database in which the query execution occurred.
	QueryExecutionContext *QueryExecutionContext `type:"structure"`

	// The unique identifier for each query execution.
	QueryExecutionId *string `type:"string"`

	// The location in Amazon S3 where query results were stored and the encryption
	// option, if any, used for query results.
	ResultConfiguration *ResultConfiguration `type:"structure"`

	// The amount of data scanned during the query execution and the amount of time
	// that it took to execute.
	Statistics *QueryExecutionStatistics `type:"structure"`

	// The completion date, current state, submission time, and state change reason
	// (if applicable) for the query execution.
	Status *QueryExecutionStatus `type:"structure"`
}

// String returns the string representation
func (s QueryExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecution) GoString() string {
	return s.String()
}

// SetQuery sets the Query field's value.
func (s *QueryExecution) SetQuery(v string) *QueryExecution {
	s.Query = &v
	return s
}

// SetQueryExecutionContext sets the QueryExecutionContext field's value.
func (s *QueryExecution) SetQueryExecutionContext(v *QueryExecutionContext) *QueryExecution {
	s.QueryExecutionContext = v
	return s
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *QueryExecution) SetQueryExecutionId(v string) *QueryExecution {
	s.QueryExecutionId = &v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *QueryExecution) SetResultConfiguration(v *ResultConfiguration) *QueryExecution {
	s.ResultConfiguration = v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *QueryExecution) SetStatistics(v *QueryExecutionStatistics) *QueryExecution {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *QueryExecution) SetStatus(v *QueryExecutionStatus) *QueryExecution {
	s.Status = v
	return s
}

// The database in which the query execution occurs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/QueryExecutionContext
type QueryExecutionContext struct {
	_ struct{} `type:"structure"`

	// The name of the database.
	Database *string `min:"1" type:"string"`
}

// String returns the string representation
func (s QueryExecutionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecutionContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryExecutionContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryExecutionContext"}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *QueryExecutionContext) SetDatabase(v string) *QueryExecutionContext {
	s.Database = &v
	return s
}

// The amount of data scanned during the query execution and the amount of time
// that it took to execute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/QueryExecutionStatistics
type QueryExecutionStatistics struct {
	_ struct{} `type:"structure"`

	// The number of bytes in the data that was queried.
	DataScannedInBytes *int64 `type:"long"`

	// The number of milliseconds that the query took to execute.
	EngineExecutionTimeInMillis *int64 `type:"long"`
}

// String returns the string representation
func (s QueryExecutionStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecutionStatistics) GoString() string {
	return s.String()
}

// SetDataScannedInBytes sets the DataScannedInBytes field's value.
func (s *QueryExecutionStatistics) SetDataScannedInBytes(v int64) *QueryExecutionStatistics {
	s.DataScannedInBytes = &v
	return s
}

// SetEngineExecutionTimeInMillis sets the EngineExecutionTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetEngineExecutionTimeInMillis(v int64) *QueryExecutionStatistics {
	s.EngineExecutionTimeInMillis = &v
	return s
}

// The completion date, current state, submission time, and state change reason
// (if applicable) for the query execution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/QueryExecutionStatus
type QueryExecutionStatus struct {
	_ struct{} `type:"structure"`

	// The date and time that the query completed.
	CompletionDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The state of query execution. SUBMITTED indicates that the query is queued
	// for execution. RUNNING indicates that the query is scanning data and returning
	// results. SUCCEEDED indicates that the query completed without error. FAILED
	// indicates that the query experienced an error and did not complete processing.
	// CANCELLED indicates that user input interrupted query execution.
	State *string `type:"string" enum:"QueryExecutionState"`

	// Further detail about the status of the query.
	StateChangeReason *string `type:"string"`

	// The date and time that the query was submitted.
	SubmissionDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s QueryExecutionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecutionStatus) GoString() string {
	return s.String()
}

// SetCompletionDateTime sets the CompletionDateTime field's value.
func (s *QueryExecutionStatus) SetCompletionDateTime(v time.Time) *QueryExecutionStatus {
	s.CompletionDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *QueryExecutionStatus) SetState(v string) *QueryExecutionStatus {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *QueryExecutionStatus) SetStateChangeReason(v string) *QueryExecutionStatus {
	s.StateChangeReason = &v
	return s
}

// SetSubmissionDateTime sets the SubmissionDateTime field's value.
func (s *QueryExecutionStatus) SetSubmissionDateTime(v time.Time) *QueryExecutionStatus {
	s.SubmissionDateTime = &v
	return s
}

// The location in Amazon S3 where query results are stored and the encryption
// option, if any, used for query results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ResultConfiguration
type ResultConfiguration struct {
	_ struct{} `type:"structure"`

	// If query results are encrypted in S3, indicates the S3 encryption option
	// used (for example, SSE-KMS or CSE-KMS and key information.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The location in S3 where query results are stored.
	//
	// OutputLocation is a required field
	OutputLocation *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResultConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResultConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResultConfiguration"}
	if s.OutputLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputLocation"))
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ResultConfiguration) SetEncryptionConfiguration(v *EncryptionConfiguration) *ResultConfiguration {
	s.EncryptionConfiguration = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *ResultConfiguration) SetOutputLocation(v string) *ResultConfiguration {
	s.OutputLocation = &v
	return s
}

// The metadata and rows that comprise a query result set. The metadata describes
// the column structure and data types.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ResultSet
type ResultSet struct {
	_ struct{} `type:"structure"`

	// The metadata that describes the column structure and data types of a table
	// of query results.
	ResultSetMetadata *ResultSetMetadata `type:"structure"`

	// The rows in the table.
	Rows []*Row `type:"list"`
}

// String returns the string representation
func (s ResultSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultSet) GoString() string {
	return s.String()
}

// SetResultSetMetadata sets the ResultSetMetadata field's value.
func (s *ResultSet) SetResultSetMetadata(v *ResultSetMetadata) *ResultSet {
	s.ResultSetMetadata = v
	return s
}

// SetRows sets the Rows field's value.
func (s *ResultSet) SetRows(v []*Row) *ResultSet {
	s.Rows = v
	return s
}

// The metadata that describes the column structure and data types of a table
// of query results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ResultSetMetadata
type ResultSetMetadata struct {
	_ struct{} `type:"structure"`

	// Information about the columns in a query execution result.
	ColumnInfo []*ColumnInfo `type:"list"`
}

// String returns the string representation
func (s ResultSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultSetMetadata) GoString() string {
	return s.String()
}

// SetColumnInfo sets the ColumnInfo field's value.
func (s *ResultSetMetadata) SetColumnInfo(v []*ColumnInfo) *ResultSetMetadata {
	s.ColumnInfo = v
	return s
}

// The rows that comprise a query result table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/Row
type Row struct {
	_ struct{} `type:"structure"`

	// The data that populates a row in a query result table.
	Data []*Datum `type:"list"`
}

// String returns the string representation
func (s Row) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Row) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *Row) SetData(v []*Datum) *Row {
	s.Data = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecutionInput
type StartQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure the request to create the query
	// is idempotent (executes only once). If another StartQueryExecution request
	// is received, the same response is returned and another query is not created.
	// If a parameter has changed, for example, the QueryString, an error is returned.
	//
	// This token is listed as not required because AWS SDKs (for example the AWS
	// SDK for Java) auto-generate the token for users. If you are not using the
	// AWS SDK or the AWS CLI, you must provide this token or the action will fail.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// The database within which the query executes.
	QueryExecutionContext *QueryExecutionContext `type:"structure"`

	// The SQL query statements to be executed.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`

	// Specifies information about where and how to save the results of the query
	// execution.
	//
	// ResultConfiguration is a required field
	ResultConfiguration *ResultConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartQueryExecutionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}
	if s.ResultConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultConfiguration"))
	}
	if s.QueryExecutionContext != nil {
		if err := s.QueryExecutionContext.Validate(); err != nil {
			invalidParams.AddNested("QueryExecutionContext", err.(request.ErrInvalidParams))
		}
	}
	if s.ResultConfiguration != nil {
		if err := s.ResultConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ResultConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartQueryExecutionInput) SetClientRequestToken(v string) *StartQueryExecutionInput {
	s.ClientRequestToken = &v
	return s
}

// SetQueryExecutionContext sets the QueryExecutionContext field's value.
func (s *StartQueryExecutionInput) SetQueryExecutionContext(v *QueryExecutionContext) *StartQueryExecutionInput {
	s.QueryExecutionContext = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *StartQueryExecutionInput) SetQueryString(v string) *StartQueryExecutionInput {
	s.QueryString = &v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *StartQueryExecutionInput) SetResultConfiguration(v *ResultConfiguration) *StartQueryExecutionInput {
	s.ResultConfiguration = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecutionOutput
type StartQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query that ran as a result of this request.
	QueryExecutionId *string `type:"string"`
}

// String returns the string representation
func (s StartQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartQueryExecutionOutput) GoString() string {
	return s.String()
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *StartQueryExecutionOutput) SetQueryExecutionId(v string) *StartQueryExecutionOutput {
	s.QueryExecutionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecutionInput
type StopQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query execution to stop.
	//
	// QueryExecutionId is a required field
	QueryExecutionId *string `type:"string" required:"true" idempotencyToken:"true"`
}

// String returns the string representation
func (s StopQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopQueryExecutionInput"}
	if s.QueryExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *StopQueryExecutionInput) SetQueryExecutionId(v string) *StopQueryExecutionInput {
	s.QueryExecutionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecutionOutput
type StopQueryExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopQueryExecutionOutput) GoString() string {
	return s.String()
}

// Information about a named query ID that could not be processed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UnprocessedNamedQueryId
type UnprocessedNamedQueryId struct {
	_ struct{} `type:"structure"`

	// The error code returned when the processing request for the named query failed,
	// if applicable.
	ErrorCode *string `min:"1" type:"string"`

	// The error message returned when the processing request for the named query
	// failed, if applicable.
	ErrorMessage *string `type:"string"`

	// The unique identifier of the named query.
	NamedQueryId *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedNamedQueryId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedNamedQueryId) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedNamedQueryId) SetErrorCode(v string) *UnprocessedNamedQueryId {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedNamedQueryId) SetErrorMessage(v string) *UnprocessedNamedQueryId {
	s.ErrorMessage = &v
	return s
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *UnprocessedNamedQueryId) SetNamedQueryId(v string) *UnprocessedNamedQueryId {
	s.NamedQueryId = &v
	return s
}

// Describes a query execution that failed to process.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UnprocessedQueryExecutionId
type UnprocessedQueryExecutionId struct {
	_ struct{} `type:"structure"`

	// The error code returned when the query execution failed to process, if applicable.
	ErrorCode *string `min:"1" type:"string"`

	// The error message returned when the query execution failed to process, if
	// applicable.
	ErrorMessage *string `type:"string"`

	// The unique identifier of the query execution.
	QueryExecutionId *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedQueryExecutionId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedQueryExecutionId) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedQueryExecutionId) SetErrorCode(v string) *UnprocessedQueryExecutionId {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedQueryExecutionId) SetErrorMessage(v string) *UnprocessedQueryExecutionId {
	s.ErrorMessage = &v
	return s
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *UnprocessedQueryExecutionId) SetQueryExecutionId(v string) *UnprocessedQueryExecutionId {
	s.QueryExecutionId = &v
	return s
}

const (
	// ColumnNullableNotNull is a ColumnNullable enum value
	ColumnNullableNotNull = "NOT_NULL"

	// ColumnNullableNullable is a ColumnNullable enum value
	ColumnNullableNullable = "NULLABLE"

	// ColumnNullableUnknown is a ColumnNullable enum value
	ColumnNullableUnknown = "UNKNOWN"
)

const (
	// EncryptionOptionSseS3 is a EncryptionOption enum value
	EncryptionOptionSseS3 = "SSE_S3"

	// EncryptionOptionSseKms is a EncryptionOption enum value
	EncryptionOptionSseKms = "SSE_KMS"

	// EncryptionOptionCseKms is a EncryptionOption enum value
	EncryptionOptionCseKms = "CSE_KMS"
)

const (
	// QueryExecutionStateQueued is a QueryExecutionState enum value
	QueryExecutionStateQueued = "QUEUED"

	// QueryExecutionStateRunning is a QueryExecutionState enum value
	QueryExecutionStateRunning = "RUNNING"

	// QueryExecutionStateSucceeded is a QueryExecutionState enum value
	QueryExecutionStateSucceeded = "SUCCEEDED"

	// QueryExecutionStateFailed is a QueryExecutionState enum value
	QueryExecutionStateFailed = "FAILED"

	// QueryExecutionStateCancelled is a QueryExecutionState enum value
	QueryExecutionStateCancelled = "CANCELLED"
)

const (
	// ThrottleReasonConcurrentQueryLimitExceeded is a ThrottleReason enum value
	ThrottleReasonConcurrentQueryLimitExceeded = "CONCURRENT_QUERY_LIMIT_EXCEEDED"
)
