// Code generated by protoc-gen-go. DO NOT EDIT.
// source: csi.proto

/*
Package csi is a generated protocol buffer package.

It is generated from these files:
	csi.proto

It has these top-level messages:
	GetSupportedVersionsRequest
	GetSupportedVersionsResponse
	Version
	GetPluginInfoRequest
	GetPluginInfoResponse
	CreateVolumeRequest
	CreateVolumeResponse
	VolumeCapability
	CapacityRange
	VolumeInfo
	DeleteVolumeRequest
	DeleteVolumeResponse
	ControllerPublishVolumeRequest
	ControllerPublishVolumeResponse
	ControllerUnpublishVolumeRequest
	ControllerUnpublishVolumeResponse
	ValidateVolumeCapabilitiesRequest
	ValidateVolumeCapabilitiesResponse
	ListVolumesRequest
	ListVolumesResponse
	GetCapacityRequest
	GetCapacityResponse
	ControllerProbeRequest
	ControllerProbeResponse
	ControllerGetCapabilitiesRequest
	ControllerGetCapabilitiesResponse
	ControllerServiceCapability
	NodePublishVolumeRequest
	NodePublishVolumeResponse
	NodeUnpublishVolumeRequest
	NodeUnpublishVolumeResponse
	GetNodeIDRequest
	GetNodeIDResponse
	NodeProbeRequest
	NodeProbeResponse
	NodeGetCapabilitiesRequest
	NodeGetCapabilitiesResponse
	NodeServiceCapability
*/
package csi

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type VolumeCapability_AccessMode_Mode int32

const (
	VolumeCapability_AccessMode_UNKNOWN VolumeCapability_AccessMode_Mode = 0
	// Can be published as read/write at one node at a time.
	VolumeCapability_AccessMode_SINGLE_NODE_WRITER VolumeCapability_AccessMode_Mode = 1
	// Can be published as readonly at one node at a time.
	VolumeCapability_AccessMode_SINGLE_NODE_READER_ONLY VolumeCapability_AccessMode_Mode = 2
	// Can be published as readonly at multiple nodes simultaneously.
	VolumeCapability_AccessMode_MULTI_NODE_READER_ONLY VolumeCapability_AccessMode_Mode = 3
	// Can be published at multiple nodes simultaneously. Only one of
	// the node can be used as read/write. The rest will be readonly.
	VolumeCapability_AccessMode_MULTI_NODE_SINGLE_WRITER VolumeCapability_AccessMode_Mode = 4
	// Can be published as read/write at multiple nodes
	// simultaneously.
	VolumeCapability_AccessMode_MULTI_NODE_MULTI_WRITER VolumeCapability_AccessMode_Mode = 5
)

var VolumeCapability_AccessMode_Mode_name = map[int32]string{
	0: "UNKNOWN",
	1: "SINGLE_NODE_WRITER",
	2: "SINGLE_NODE_READER_ONLY",
	3: "MULTI_NODE_READER_ONLY",
	4: "MULTI_NODE_SINGLE_WRITER",
	5: "MULTI_NODE_MULTI_WRITER",
}
var VolumeCapability_AccessMode_Mode_value = map[string]int32{
	"UNKNOWN":                  0,
	"SINGLE_NODE_WRITER":       1,
	"SINGLE_NODE_READER_ONLY":  2,
	"MULTI_NODE_READER_ONLY":   3,
	"MULTI_NODE_SINGLE_WRITER": 4,
	"MULTI_NODE_MULTI_WRITER":  5,
}

func (x VolumeCapability_AccessMode_Mode) String() string {
	return proto.EnumName(VolumeCapability_AccessMode_Mode_name, int32(x))
}
func (VolumeCapability_AccessMode_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{7, 2, 0}
}

type ControllerServiceCapability_RPC_Type int32

const (
	ControllerServiceCapability_RPC_UNKNOWN                  ControllerServiceCapability_RPC_Type = 0
	ControllerServiceCapability_RPC_CREATE_DELETE_VOLUME     ControllerServiceCapability_RPC_Type = 1
	ControllerServiceCapability_RPC_PUBLISH_UNPUBLISH_VOLUME ControllerServiceCapability_RPC_Type = 2
	ControllerServiceCapability_RPC_LIST_VOLUMES             ControllerServiceCapability_RPC_Type = 3
	ControllerServiceCapability_RPC_GET_CAPACITY             ControllerServiceCapability_RPC_Type = 4
)

var ControllerServiceCapability_RPC_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "CREATE_DELETE_VOLUME",
	2: "PUBLISH_UNPUBLISH_VOLUME",
	3: "LIST_VOLUMES",
	4: "GET_CAPACITY",
}
var ControllerServiceCapability_RPC_Type_value = map[string]int32{
	"UNKNOWN":                  0,
	"CREATE_DELETE_VOLUME":     1,
	"PUBLISH_UNPUBLISH_VOLUME": 2,
	"LIST_VOLUMES":             3,
	"GET_CAPACITY":             4,
}

func (x ControllerServiceCapability_RPC_Type) String() string {
	return proto.EnumName(ControllerServiceCapability_RPC_Type_name, int32(x))
}
func (ControllerServiceCapability_RPC_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{26, 0, 0}
}

type NodeServiceCapability_RPC_Type int32

const (
	NodeServiceCapability_RPC_UNKNOWN NodeServiceCapability_RPC_Type = 0
)

var NodeServiceCapability_RPC_Type_name = map[int32]string{
	0: "UNKNOWN",
}
var NodeServiceCapability_RPC_Type_value = map[string]int32{
	"UNKNOWN": 0,
}

func (x NodeServiceCapability_RPC_Type) String() string {
	return proto.EnumName(NodeServiceCapability_RPC_Type_name, int32(x))
}
func (NodeServiceCapability_RPC_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{37, 0, 0}
}

// //////
// //////
type GetSupportedVersionsRequest struct {
}

func (m *GetSupportedVersionsRequest) Reset()                    { *m = GetSupportedVersionsRequest{} }
func (m *GetSupportedVersionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSupportedVersionsRequest) ProtoMessage()               {}
func (*GetSupportedVersionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type GetSupportedVersionsResponse struct {
	// All the CSI versions that the Plugin supports. This field is
	// REQUIRED.
	SupportedVersions []*Version `protobuf:"bytes,1,rep,name=supported_versions,json=supportedVersions" json:"supported_versions,omitempty"`
}

func (m *GetSupportedVersionsResponse) Reset()                    { *m = GetSupportedVersionsResponse{} }
func (m *GetSupportedVersionsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetSupportedVersionsResponse) ProtoMessage()               {}
func (*GetSupportedVersionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *GetSupportedVersionsResponse) GetSupportedVersions() []*Version {
	if m != nil {
		return m.SupportedVersions
	}
	return nil
}

// Specifies a version in Semantic Version 2.0 format.
// (http://semver.org/spec/v2.0.0.html)
type Version struct {
	Major uint32 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor uint32 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Patch uint32 `protobuf:"varint,3,opt,name=patch" json:"patch,omitempty"`
}

func (m *Version) Reset()                    { *m = Version{} }
func (m *Version) String() string            { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()               {}
func (*Version) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Version) GetMajor() uint32 {
	if m != nil {
		return m.Major
	}
	return 0
}

func (m *Version) GetMinor() uint32 {
	if m != nil {
		return m.Minor
	}
	return 0
}

func (m *Version) GetPatch() uint32 {
	if m != nil {
		return m.Patch
	}
	return 0
}

// //////
// //////
type GetPluginInfoRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
}

func (m *GetPluginInfoRequest) Reset()                    { *m = GetPluginInfoRequest{} }
func (m *GetPluginInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPluginInfoRequest) ProtoMessage()               {}
func (*GetPluginInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *GetPluginInfoRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

type GetPluginInfoResponse struct {
	// The name MUST follow reverse domain name notation format
	// (https://en.wikipedia.org/wiki/Reverse_domain_name_notation).
	// It SHOULD include the plugin's host company name and the plugin
	// name, to minimize the possibility of collisions. It MUST be 63
	// characters or less, beginning and ending with an alphanumeric
	// character ([a-z0-9A-Z]) with dashes (-), underscores (_),
	// dots (.), and alphanumerics between. This field is REQUIRED.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This field is REQUIRED. Value of this field is opaque to the CO.
	VendorVersion string `protobuf:"bytes,2,opt,name=vendor_version,json=vendorVersion" json:"vendor_version,omitempty"`
	// This field is OPTIONAL. Values are opaque to the CO.
	Manifest map[string]string `protobuf:"bytes,3,rep,name=manifest" json:"manifest,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GetPluginInfoResponse) Reset()                    { *m = GetPluginInfoResponse{} }
func (m *GetPluginInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPluginInfoResponse) ProtoMessage()               {}
func (*GetPluginInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *GetPluginInfoResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetPluginInfoResponse) GetVendorVersion() string {
	if m != nil {
		return m.VendorVersion
	}
	return ""
}

func (m *GetPluginInfoResponse) GetManifest() map[string]string {
	if m != nil {
		return m.Manifest
	}
	return nil
}

// //////
// //////
type CreateVolumeRequest struct {
	// The API version assumed by the CO. This field is REQUIRED.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// The suggested name for the storage space. This field is REQUIRED.
	// It serves two purposes:
	// 1) Idempotency - This name is generated by the CO to achieve
	//    idempotency. If `CreateVolume` fails, the volume may or may not
	//    be provisioned. In this case, the CO may call `CreateVolume`
	//    again, with the same name, to ensure the volume exists. The
	//    Plugin should ensure that multiple `CreateVolume` calls for the
	//    same name do not result in more than one piece of storage
	//    provisioned corresponding to that name. If a Plugin is unable to
	//    enforce idempotency, the CO's error recovery logic could result
	//    in multiple (unused) volumes being provisioned.
	// 2) Suggested name - Some storage systems allow callers to specify
	//    an identifier by which to refer to the newly provisioned
	//    storage. If a storage system supports this, it can optionally
	//    use this name as the identifier for the new volume.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// This field is OPTIONAL. This allows the CO to specify the capacity
	// requirement of the volume to be provisioned. If not specified, the
	// Plugin MAY choose an implementation-defined capacity range.
	CapacityRange *CapacityRange `protobuf:"bytes,3,opt,name=capacity_range,json=capacityRange" json:"capacity_range,omitempty"`
	// The capabilities that the provisioned volume MUST have: the Plugin
	// MUST provision a volume that could satisfy ALL of the
	// capabilities specified in this list. The Plugin MUST assume that
	// the CO MAY use the  provisioned volume later with ANY of the
	// capabilities specified in this list. This also enables the CO to do
	// early validation: if ANY of the specified volume capabilities are
	// not supported by the Plugin, the call SHALL fail. This field is
	// REQUIRED.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,4,rep,name=volume_capabilities,json=volumeCapabilities" json:"volume_capabilities,omitempty"`
	// Plugin specific parameters passed in as opaque key-value pairs.
	// This field is OPTIONAL. The Plugin is responsible for parsing and
	// validating these parameters. COs will treat these as opaque.
	Parameters map[string]string `protobuf:"bytes,5,rep,name=parameters" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// End user credentials used to authenticate/authorize volume creation
	// request.
	// This field contains credential data, for example username and
	// password. Each key must consist of alphanumeric characters, '-',
	// '_' or '.'. Each value MUST contain a valid string. An SP MAY
	// choose to accept binary (non-string) data by using a binary-to-text
	// encoding scheme, like base64. An SP SHALL advertise the
	// requirements for credentials in documentation. COs SHALL permit
	// users to pass through the required credentials. This information is
	// sensitive and MUST be treated as such (not logged, etc.) by the CO.
	// This field is OPTIONAL.
	UserCredentials map[string]string `protobuf:"bytes,6,rep,name=user_credentials,json=userCredentials" json:"user_credentials,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CreateVolumeRequest) Reset()                    { *m = CreateVolumeRequest{} }
func (m *CreateVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVolumeRequest) ProtoMessage()               {}
func (*CreateVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CreateVolumeRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *CreateVolumeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateVolumeRequest) GetCapacityRange() *CapacityRange {
	if m != nil {
		return m.CapacityRange
	}
	return nil
}

func (m *CreateVolumeRequest) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *CreateVolumeRequest) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *CreateVolumeRequest) GetUserCredentials() map[string]string {
	if m != nil {
		return m.UserCredentials
	}
	return nil
}

type CreateVolumeResponse struct {
	// Contains all attributes of the newly created volume that are
	// relevant to the CO along with information required by the Plugin
	// to uniquely identify the volume. This field is REQUIRED.
	VolumeInfo *VolumeInfo `protobuf:"bytes,1,opt,name=volume_info,json=volumeInfo" json:"volume_info,omitempty"`
}

func (m *CreateVolumeResponse) Reset()                    { *m = CreateVolumeResponse{} }
func (m *CreateVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateVolumeResponse) ProtoMessage()               {}
func (*CreateVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *CreateVolumeResponse) GetVolumeInfo() *VolumeInfo {
	if m != nil {
		return m.VolumeInfo
	}
	return nil
}

// Specify a capability of a volume.
type VolumeCapability struct {
	// Specifies what API the volume will be accessed using. One of the
	// following fields MUST be specified.
	//
	// Types that are valid to be assigned to AccessType:
	//	*VolumeCapability_Block
	//	*VolumeCapability_Mount
	AccessType isVolumeCapability_AccessType `protobuf_oneof:"access_type"`
	// This is a REQUIRED field.
	AccessMode *VolumeCapability_AccessMode `protobuf:"bytes,3,opt,name=access_mode,json=accessMode" json:"access_mode,omitempty"`
}

func (m *VolumeCapability) Reset()                    { *m = VolumeCapability{} }
func (m *VolumeCapability) String() string            { return proto.CompactTextString(m) }
func (*VolumeCapability) ProtoMessage()               {}
func (*VolumeCapability) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type isVolumeCapability_AccessType interface {
	isVolumeCapability_AccessType()
}

type VolumeCapability_Block struct {
	Block *VolumeCapability_BlockVolume `protobuf:"bytes,1,opt,name=block,oneof"`
}
type VolumeCapability_Mount struct {
	Mount *VolumeCapability_MountVolume `protobuf:"bytes,2,opt,name=mount,oneof"`
}

func (*VolumeCapability_Block) isVolumeCapability_AccessType() {}
func (*VolumeCapability_Mount) isVolumeCapability_AccessType() {}

func (m *VolumeCapability) GetAccessType() isVolumeCapability_AccessType {
	if m != nil {
		return m.AccessType
	}
	return nil
}

func (m *VolumeCapability) GetBlock() *VolumeCapability_BlockVolume {
	if x, ok := m.GetAccessType().(*VolumeCapability_Block); ok {
		return x.Block
	}
	return nil
}

func (m *VolumeCapability) GetMount() *VolumeCapability_MountVolume {
	if x, ok := m.GetAccessType().(*VolumeCapability_Mount); ok {
		return x.Mount
	}
	return nil
}

func (m *VolumeCapability) GetAccessMode() *VolumeCapability_AccessMode {
	if m != nil {
		return m.AccessMode
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*VolumeCapability) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _VolumeCapability_OneofMarshaler, _VolumeCapability_OneofUnmarshaler, _VolumeCapability_OneofSizer, []interface{}{
		(*VolumeCapability_Block)(nil),
		(*VolumeCapability_Mount)(nil),
	}
}

func _VolumeCapability_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*VolumeCapability)
	// access_type
	switch x := m.AccessType.(type) {
	case *VolumeCapability_Block:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Block); err != nil {
			return err
		}
	case *VolumeCapability_Mount:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Mount); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("VolumeCapability.AccessType has unexpected type %T", x)
	}
	return nil
}

func _VolumeCapability_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*VolumeCapability)
	switch tag {
	case 1: // access_type.block
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VolumeCapability_BlockVolume)
		err := b.DecodeMessage(msg)
		m.AccessType = &VolumeCapability_Block{msg}
		return true, err
	case 2: // access_type.mount
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VolumeCapability_MountVolume)
		err := b.DecodeMessage(msg)
		m.AccessType = &VolumeCapability_Mount{msg}
		return true, err
	default:
		return false, nil
	}
}

func _VolumeCapability_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*VolumeCapability)
	// access_type
	switch x := m.AccessType.(type) {
	case *VolumeCapability_Block:
		s := proto.Size(x.Block)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *VolumeCapability_Mount:
		s := proto.Size(x.Mount)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Indicate that the volume will be accessed via the block device API.
type VolumeCapability_BlockVolume struct {
}

func (m *VolumeCapability_BlockVolume) Reset()                    { *m = VolumeCapability_BlockVolume{} }
func (m *VolumeCapability_BlockVolume) String() string            { return proto.CompactTextString(m) }
func (*VolumeCapability_BlockVolume) ProtoMessage()               {}
func (*VolumeCapability_BlockVolume) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

// Indicate that the volume will be accessed via the filesystem API.
type VolumeCapability_MountVolume struct {
	// The filesystem type. This field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	FsType string `protobuf:"bytes,1,opt,name=fs_type,json=fsType" json:"fs_type,omitempty"`
	// The mount options that can be used for the volume. This field is
	// OPTIONAL. `mount_flags` MAY contain sensitive information.
	// Therefore, the CO and the Plugin MUST NOT leak this information
	// to untrusted entities. The total size of this repeated field
	// SHALL NOT exceed 4 KiB.
	MountFlags []string `protobuf:"bytes,2,rep,name=mount_flags,json=mountFlags" json:"mount_flags,omitempty"`
}

func (m *VolumeCapability_MountVolume) Reset()                    { *m = VolumeCapability_MountVolume{} }
func (m *VolumeCapability_MountVolume) String() string            { return proto.CompactTextString(m) }
func (*VolumeCapability_MountVolume) ProtoMessage()               {}
func (*VolumeCapability_MountVolume) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 1} }

func (m *VolumeCapability_MountVolume) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *VolumeCapability_MountVolume) GetMountFlags() []string {
	if m != nil {
		return m.MountFlags
	}
	return nil
}

// Specify how a volume can be accessed.
type VolumeCapability_AccessMode struct {
	// This field is REQUIRED.
	Mode VolumeCapability_AccessMode_Mode `protobuf:"varint,1,opt,name=mode,enum=csi.VolumeCapability_AccessMode_Mode" json:"mode,omitempty"`
}

func (m *VolumeCapability_AccessMode) Reset()                    { *m = VolumeCapability_AccessMode{} }
func (m *VolumeCapability_AccessMode) String() string            { return proto.CompactTextString(m) }
func (*VolumeCapability_AccessMode) ProtoMessage()               {}
func (*VolumeCapability_AccessMode) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 2} }

func (m *VolumeCapability_AccessMode) GetMode() VolumeCapability_AccessMode_Mode {
	if m != nil {
		return m.Mode
	}
	return VolumeCapability_AccessMode_UNKNOWN
}

// The capacity of the storage space in bytes. To specify an exact size,
// `required_bytes` and `limit_bytes` can be set to the same value. At
// least one of the these fields MUST be specified.
type CapacityRange struct {
	// Volume must be at least this big. This field is OPTIONAL.
	// A value of 0 is equal to an unspecified field value.
	RequiredBytes uint64 `protobuf:"varint,1,opt,name=required_bytes,json=requiredBytes" json:"required_bytes,omitempty"`
	// Volume must not be bigger than this. This field is OPTIONAL.
	// A value of 0 is equal to an unspecified field value.
	LimitBytes uint64 `protobuf:"varint,2,opt,name=limit_bytes,json=limitBytes" json:"limit_bytes,omitempty"`
}

func (m *CapacityRange) Reset()                    { *m = CapacityRange{} }
func (m *CapacityRange) String() string            { return proto.CompactTextString(m) }
func (*CapacityRange) ProtoMessage()               {}
func (*CapacityRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *CapacityRange) GetRequiredBytes() uint64 {
	if m != nil {
		return m.RequiredBytes
	}
	return 0
}

func (m *CapacityRange) GetLimitBytes() uint64 {
	if m != nil {
		return m.LimitBytes
	}
	return 0
}

// The information about a provisioned volume.
type VolumeInfo struct {
	// The capacity of the volume in bytes. This field is OPTIONAL. If not
	// set (value of 0), it indicates that the capacity of the volume is
	// unknown (e.g., NFS share).
	CapacityBytes uint64 `protobuf:"varint,1,opt,name=capacity_bytes,json=capacityBytes" json:"capacity_bytes,omitempty"`
	// Contains identity information for the created volume. This field is
	// REQUIRED. The identity information will be used by the CO in
	// subsequent calls to refer to the provisioned volume.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Attributes reflect static properties of a volume and MUST be passed
	// to volume validation and publishing calls.
	// Attributes SHALL be opaque to a CO. Attributes SHALL NOT be mutable
	// and SHALL be safe for the CO to cache. Attributes SHOULD NOT
	// contain sensitive information. Attributes MAY NOT uniquely identify
	// a volume. A volume uniquely identified by `id` SHALL always report
	// the same attributes. This field is OPTIONAL and when present MUST
	// be passed to volume validation and publishing calls.
	Attributes map[string]string `protobuf:"bytes,3,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *VolumeInfo) Reset()                    { *m = VolumeInfo{} }
func (m *VolumeInfo) String() string            { return proto.CompactTextString(m) }
func (*VolumeInfo) ProtoMessage()               {}
func (*VolumeInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *VolumeInfo) GetCapacityBytes() uint64 {
	if m != nil {
		return m.CapacityBytes
	}
	return 0
}

func (m *VolumeInfo) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VolumeInfo) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// //////
// //////
type DeleteVolumeRequest struct {
	// The API version assumed by the CO. This field is REQUIRED.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// The ID of the volume to be deprovisioned.
	// This field is REQUIRED.
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// End user credentials used to authenticate/authorize volume deletion
	// request.
	// This field contains credential data, for example username and
	// password. Each key must consist of alphanumeric characters, '-',
	// '_' or '.'. Each value MUST contain a valid string. An SP MAY
	// choose to accept binary (non-string) data by using a binary-to-text
	// encoding scheme, like base64. An SP SHALL advertise the
	// requirements for credentials in documentation. COs SHALL permit
	// users to pass through the required credentials. This information is
	// sensitive and MUST be treated as such (not logged, etc.) by the CO.
	// This field is OPTIONAL.
	UserCredentials map[string]string `protobuf:"bytes,3,rep,name=user_credentials,json=userCredentials" json:"user_credentials,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *DeleteVolumeRequest) Reset()                    { *m = DeleteVolumeRequest{} }
func (m *DeleteVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVolumeRequest) ProtoMessage()               {}
func (*DeleteVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *DeleteVolumeRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *DeleteVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *DeleteVolumeRequest) GetUserCredentials() map[string]string {
	if m != nil {
		return m.UserCredentials
	}
	return nil
}

type DeleteVolumeResponse struct {
}

func (m *DeleteVolumeResponse) Reset()                    { *m = DeleteVolumeResponse{} }
func (m *DeleteVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteVolumeResponse) ProtoMessage()               {}
func (*DeleteVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

// //////
// //////
type ControllerPublishVolumeRequest struct {
	// The API version assumed by the CO. This field is REQUIRED.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// The ID of the volume to be used on a node.
	// This field is REQUIRED.
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The ID of the node. This field is REQUIRED. The CO SHALL set this
	// field to match the node ID returned by `GetNodeID`.
	NodeId string `protobuf:"bytes,3,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
	// The capability of the volume the CO expects the volume to have.
	// This is a REQUIRED field.
	VolumeCapability *VolumeCapability `protobuf:"bytes,4,opt,name=volume_capability,json=volumeCapability" json:"volume_capability,omitempty"`
	// Whether to publish the volume in readonly mode. This field is
	// REQUIRED.
	Readonly bool `protobuf:"varint,5,opt,name=readonly" json:"readonly,omitempty"`
	// End user credentials used to authenticate/authorize controller
	// publish request.
	// This field contains credential data, for example username and
	// password. Each key must consist of alphanumeric characters, '-',
	// '_' or '.'. Each value MUST contain a valid string. An SP MAY
	// choose to accept binary (non-string) data by using a binary-to-text
	// encoding scheme, like base64. An SP SHALL advertise the
	// requirements for credentials in documentation. COs SHALL permit
	// users to pass through the required credentials. This information is
	// sensitive and MUST be treated as such (not logged, etc.) by the CO.
	// This field is OPTIONAL.
	UserCredentials map[string]string `protobuf:"bytes,6,rep,name=user_credentials,json=userCredentials" json:"user_credentials,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Attributes of the volume to be used on a node. This field is
	// OPTIONAL and MUST match the attributes of the VolumeInfo identified
	// by `volume_id`.
	VolumeAttributes map[string]string `protobuf:"bytes,7,rep,name=volume_attributes,json=volumeAttributes" json:"volume_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ControllerPublishVolumeRequest) Reset()                    { *m = ControllerPublishVolumeRequest{} }
func (m *ControllerPublishVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*ControllerPublishVolumeRequest) ProtoMessage()               {}
func (*ControllerPublishVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ControllerPublishVolumeRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *ControllerPublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ControllerPublishVolumeRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *ControllerPublishVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

func (m *ControllerPublishVolumeRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *ControllerPublishVolumeRequest) GetUserCredentials() map[string]string {
	if m != nil {
		return m.UserCredentials
	}
	return nil
}

func (m *ControllerPublishVolumeRequest) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

type ControllerPublishVolumeResponse struct {
	// The SP specific information that will be passed to the Plugin in
	// the subsequent `NodePublishVolume` call for the given volume.
	// This information is opaque to the CO. This field is OPTIONAL.
	PublishVolumeInfo map[string]string `protobuf:"bytes,1,rep,name=publish_volume_info,json=publishVolumeInfo" json:"publish_volume_info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ControllerPublishVolumeResponse) Reset()         { *m = ControllerPublishVolumeResponse{} }
func (m *ControllerPublishVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerPublishVolumeResponse) ProtoMessage()    {}
func (*ControllerPublishVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{13}
}

func (m *ControllerPublishVolumeResponse) GetPublishVolumeInfo() map[string]string {
	if m != nil {
		return m.PublishVolumeInfo
	}
	return nil
}

// //////
// //////
type ControllerUnpublishVolumeRequest struct {
	// The API version assumed by the CO. This field is REQUIRED.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The ID of the node. This field is OPTIONAL. The CO SHOULD set this
	// field to match the node ID returned by `GetNodeID` or leave it
	// unset. If the value is set, the SP MUST unpublish the volume from
	// the specified node. If the value is unset, the SP MUST unpublish
	// the volume from all nodes it is published to.
	NodeId string `protobuf:"bytes,3,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
	// End user credentials used to authenticate/authorize controller
	// unpublish request.
	// This field contains credential data, for example username and
	// password. Each key must consist of alphanumeric characters, '-',
	// '_' or '.'. Each value MUST contain a valid string. An SP MAY
	// choose to accept binary (non-string) data by using a binary-to-text
	// encoding scheme, like base64. An SP SHALL advertise the
	// requirements for credentials in documentation. COs SHALL permit
	// users to pass through the required credentials. This information is
	// sensitive and MUST be treated as such (not logged, etc.) by the CO.
	// This field is OPTIONAL.
	UserCredentials map[string]string `protobuf:"bytes,4,rep,name=user_credentials,json=userCredentials" json:"user_credentials,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ControllerUnpublishVolumeRequest) Reset()         { *m = ControllerUnpublishVolumeRequest{} }
func (m *ControllerUnpublishVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*ControllerUnpublishVolumeRequest) ProtoMessage()    {}
func (*ControllerUnpublishVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{14}
}

func (m *ControllerUnpublishVolumeRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *ControllerUnpublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ControllerUnpublishVolumeRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *ControllerUnpublishVolumeRequest) GetUserCredentials() map[string]string {
	if m != nil {
		return m.UserCredentials
	}
	return nil
}

type ControllerUnpublishVolumeResponse struct {
}

func (m *ControllerUnpublishVolumeResponse) Reset()         { *m = ControllerUnpublishVolumeResponse{} }
func (m *ControllerUnpublishVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerUnpublishVolumeResponse) ProtoMessage()    {}
func (*ControllerUnpublishVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{15}
}

// //////
// //////
type ValidateVolumeCapabilitiesRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// The ID of the volume to check. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The capabilities that the CO wants to check for the volume. This
	// call SHALL return "supported" only if all the volume capabilities
	// specified below are supported. This field is REQUIRED.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,3,rep,name=volume_capabilities,json=volumeCapabilities" json:"volume_capabilities,omitempty"`
	// Attributes of the volume to check. This field is OPTIONAL and MUST
	// match the attributes of the VolumeInfo identified by `volume_id`.
	VolumeAttributes map[string]string `protobuf:"bytes,4,rep,name=volume_attributes,json=volumeAttributes" json:"volume_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ValidateVolumeCapabilitiesRequest) Reset()         { *m = ValidateVolumeCapabilitiesRequest{} }
func (m *ValidateVolumeCapabilitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ValidateVolumeCapabilitiesRequest) ProtoMessage()    {}
func (*ValidateVolumeCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{16}
}

func (m *ValidateVolumeCapabilitiesRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *ValidateVolumeCapabilitiesRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ValidateVolumeCapabilitiesRequest) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *ValidateVolumeCapabilitiesRequest) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

type ValidateVolumeCapabilitiesResponse struct {
	// True if the Plugin supports the specified capabilities for the
	// given volume. This field is REQUIRED.
	Supported bool `protobuf:"varint,1,opt,name=supported" json:"supported,omitempty"`
	// Message to the CO if `supported` above is false. This field is
	// OPTIONAL.
	// An empty string is equal to an unspecified field value.
	Message string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (m *ValidateVolumeCapabilitiesResponse) Reset()         { *m = ValidateVolumeCapabilitiesResponse{} }
func (m *ValidateVolumeCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*ValidateVolumeCapabilitiesResponse) ProtoMessage()    {}
func (*ValidateVolumeCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{17}
}

func (m *ValidateVolumeCapabilitiesResponse) GetSupported() bool {
	if m != nil {
		return m.Supported
	}
	return false
}

func (m *ValidateVolumeCapabilitiesResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// //////
// //////
type ListVolumesRequest struct {
	// The API version assumed by the CO. This field is REQUIRED.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// If specified (non-zero value), the Plugin MUST NOT return more
	// entries than this number in the response. If the actual number of
	// entries is more than this number, the Plugin MUST set `next_token`
	// in the response which can be used to get the next page of entries
	// in the subsequent `ListVolumes` call. This field is OPTIONAL. If
	// not specified (zero value), it means there is no restriction on the
	// number of entries that can be returned.
	MaxEntries uint32 `protobuf:"varint,2,opt,name=max_entries,json=maxEntries" json:"max_entries,omitempty"`
	// A token to specify where to start paginating. Set this field to
	// `next_token` returned by a previous `ListVolumes` call to get the
	// next page of entries. This field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	StartingToken string `protobuf:"bytes,3,opt,name=starting_token,json=startingToken" json:"starting_token,omitempty"`
}

func (m *ListVolumesRequest) Reset()                    { *m = ListVolumesRequest{} }
func (m *ListVolumesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListVolumesRequest) ProtoMessage()               {}
func (*ListVolumesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ListVolumesRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *ListVolumesRequest) GetMaxEntries() uint32 {
	if m != nil {
		return m.MaxEntries
	}
	return 0
}

func (m *ListVolumesRequest) GetStartingToken() string {
	if m != nil {
		return m.StartingToken
	}
	return ""
}

type ListVolumesResponse struct {
	Entries []*ListVolumesResponse_Entry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
	// This token allows you to get the next page of entries for
	// `ListVolumes` request. If the number of entries is larger than
	// `max_entries`, use the `next_token` as a value for the
	// `starting_token` field in the next `ListVolumes` request. This
	// field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	NextToken string `protobuf:"bytes,2,opt,name=next_token,json=nextToken" json:"next_token,omitempty"`
}

func (m *ListVolumesResponse) Reset()                    { *m = ListVolumesResponse{} }
func (m *ListVolumesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListVolumesResponse) ProtoMessage()               {}
func (*ListVolumesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *ListVolumesResponse) GetEntries() []*ListVolumesResponse_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *ListVolumesResponse) GetNextToken() string {
	if m != nil {
		return m.NextToken
	}
	return ""
}

type ListVolumesResponse_Entry struct {
	VolumeInfo *VolumeInfo `protobuf:"bytes,1,opt,name=volume_info,json=volumeInfo" json:"volume_info,omitempty"`
}

func (m *ListVolumesResponse_Entry) Reset()                    { *m = ListVolumesResponse_Entry{} }
func (m *ListVolumesResponse_Entry) String() string            { return proto.CompactTextString(m) }
func (*ListVolumesResponse_Entry) ProtoMessage()               {}
func (*ListVolumesResponse_Entry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19, 0} }

func (m *ListVolumesResponse_Entry) GetVolumeInfo() *VolumeInfo {
	if m != nil {
		return m.VolumeInfo
	}
	return nil
}

// //////
// //////
type GetCapacityRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// If specified, the Plugin SHALL report the capacity of the storage
	// that can be used to provision volumes that satisfy ALL of the
	// specified `volume_capabilities`. These are the same
	// `volume_capabilities` the CO will use in `CreateVolumeRequest`.
	// This field is OPTIONAL.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,2,rep,name=volume_capabilities,json=volumeCapabilities" json:"volume_capabilities,omitempty"`
	// If specified, the Plugin SHALL report the capacity of the storage
	// that can be used to provision volumes with the given Plugin
	// specific `parameters`. These are the same `parameters` the CO will
	// use in `CreateVolumeRequest`. This field is OPTIONAL.
	Parameters map[string]string `protobuf:"bytes,3,rep,name=parameters" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GetCapacityRequest) Reset()                    { *m = GetCapacityRequest{} }
func (m *GetCapacityRequest) String() string            { return proto.CompactTextString(m) }
func (*GetCapacityRequest) ProtoMessage()               {}
func (*GetCapacityRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *GetCapacityRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *GetCapacityRequest) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *GetCapacityRequest) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

type GetCapacityResponse struct {
	// The available capacity of the storage that can be used to
	// provision volumes. If `volume_capabilities` or `parameters` is
	// specified in the request, the Plugin SHALL take those into
	// consideration when calculating the available capacity of the
	// storage. This field is REQUIRED.
	AvailableCapacity uint64 `protobuf:"varint,1,opt,name=available_capacity,json=availableCapacity" json:"available_capacity,omitempty"`
}

func (m *GetCapacityResponse) Reset()                    { *m = GetCapacityResponse{} }
func (m *GetCapacityResponse) String() string            { return proto.CompactTextString(m) }
func (*GetCapacityResponse) ProtoMessage()               {}
func (*GetCapacityResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *GetCapacityResponse) GetAvailableCapacity() uint64 {
	if m != nil {
		return m.AvailableCapacity
	}
	return 0
}

// //////
// //////
type ControllerProbeRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
}

func (m *ControllerProbeRequest) Reset()                    { *m = ControllerProbeRequest{} }
func (m *ControllerProbeRequest) String() string            { return proto.CompactTextString(m) }
func (*ControllerProbeRequest) ProtoMessage()               {}
func (*ControllerProbeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *ControllerProbeRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

type ControllerProbeResponse struct {
}

func (m *ControllerProbeResponse) Reset()                    { *m = ControllerProbeResponse{} }
func (m *ControllerProbeResponse) String() string            { return proto.CompactTextString(m) }
func (*ControllerProbeResponse) ProtoMessage()               {}
func (*ControllerProbeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

// //////
// //////
type ControllerGetCapabilitiesRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
}

func (m *ControllerGetCapabilitiesRequest) Reset()         { *m = ControllerGetCapabilitiesRequest{} }
func (m *ControllerGetCapabilitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ControllerGetCapabilitiesRequest) ProtoMessage()    {}
func (*ControllerGetCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{24}
}

func (m *ControllerGetCapabilitiesRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

type ControllerGetCapabilitiesResponse struct {
	// All the capabilities that the controller service supports. This
	// field is OPTIONAL.
	Capabilities []*ControllerServiceCapability `protobuf:"bytes,2,rep,name=capabilities" json:"capabilities,omitempty"`
}

func (m *ControllerGetCapabilitiesResponse) Reset()         { *m = ControllerGetCapabilitiesResponse{} }
func (m *ControllerGetCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerGetCapabilitiesResponse) ProtoMessage()    {}
func (*ControllerGetCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{25}
}

func (m *ControllerGetCapabilitiesResponse) GetCapabilities() []*ControllerServiceCapability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// Specifies a capability of the controller service.
type ControllerServiceCapability struct {
	// Types that are valid to be assigned to Type:
	//	*ControllerServiceCapability_Rpc
	Type isControllerServiceCapability_Type `protobuf_oneof:"type"`
}

func (m *ControllerServiceCapability) Reset()                    { *m = ControllerServiceCapability{} }
func (m *ControllerServiceCapability) String() string            { return proto.CompactTextString(m) }
func (*ControllerServiceCapability) ProtoMessage()               {}
func (*ControllerServiceCapability) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

type isControllerServiceCapability_Type interface {
	isControllerServiceCapability_Type()
}

type ControllerServiceCapability_Rpc struct {
	Rpc *ControllerServiceCapability_RPC `protobuf:"bytes,1,opt,name=rpc,oneof"`
}

func (*ControllerServiceCapability_Rpc) isControllerServiceCapability_Type() {}

func (m *ControllerServiceCapability) GetType() isControllerServiceCapability_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *ControllerServiceCapability) GetRpc() *ControllerServiceCapability_RPC {
	if x, ok := m.GetType().(*ControllerServiceCapability_Rpc); ok {
		return x.Rpc
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ControllerServiceCapability) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ControllerServiceCapability_OneofMarshaler, _ControllerServiceCapability_OneofUnmarshaler, _ControllerServiceCapability_OneofSizer, []interface{}{
		(*ControllerServiceCapability_Rpc)(nil),
	}
}

func _ControllerServiceCapability_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ControllerServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *ControllerServiceCapability_Rpc:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Rpc); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ControllerServiceCapability.Type has unexpected type %T", x)
	}
	return nil
}

func _ControllerServiceCapability_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ControllerServiceCapability)
	switch tag {
	case 1: // type.rpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ControllerServiceCapability_RPC)
		err := b.DecodeMessage(msg)
		m.Type = &ControllerServiceCapability_Rpc{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ControllerServiceCapability_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ControllerServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *ControllerServiceCapability_Rpc:
		s := proto.Size(x.Rpc)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ControllerServiceCapability_RPC struct {
	Type ControllerServiceCapability_RPC_Type `protobuf:"varint,1,opt,name=type,enum=csi.ControllerServiceCapability_RPC_Type" json:"type,omitempty"`
}

func (m *ControllerServiceCapability_RPC) Reset()         { *m = ControllerServiceCapability_RPC{} }
func (m *ControllerServiceCapability_RPC) String() string { return proto.CompactTextString(m) }
func (*ControllerServiceCapability_RPC) ProtoMessage()    {}
func (*ControllerServiceCapability_RPC) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{26, 0}
}

func (m *ControllerServiceCapability_RPC) GetType() ControllerServiceCapability_RPC_Type {
	if m != nil {
		return m.Type
	}
	return ControllerServiceCapability_RPC_UNKNOWN
}

// //////
// //////
type NodePublishVolumeRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// The ID of the volume to publish. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The CO SHALL set this field to the value returned by
	// `ControllerPublishVolume` if the corresponding Controller Plugin
	// has `PUBLISH_UNPUBLISH_VOLUME` controller capability, and SHALL be
	// left unset if the corresponding Controller Plugin does not have
	// this capability. This is an OPTIONAL field.
	PublishVolumeInfo map[string]string `protobuf:"bytes,3,rep,name=publish_volume_info,json=publishVolumeInfo" json:"publish_volume_info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The path to which the volume will be published. It MUST be an
	// absolute path in the root filesystem of the process serving this
	// request. The CO SHALL ensure uniqueness of target_path per volume.
	// This is a REQUIRED field.
	TargetPath string `protobuf:"bytes,4,opt,name=target_path,json=targetPath" json:"target_path,omitempty"`
	// The capability of the volume the CO expects the volume to have.
	// This is a REQUIRED field.
	VolumeCapability *VolumeCapability `protobuf:"bytes,5,opt,name=volume_capability,json=volumeCapability" json:"volume_capability,omitempty"`
	// Whether to publish the volume in readonly mode. This field is
	// REQUIRED.
	Readonly bool `protobuf:"varint,6,opt,name=readonly" json:"readonly,omitempty"`
	// End user credentials used to authenticate/authorize node
	// publish request.
	// This field contains credential data, for example username and
	// password. Each key must consist of alphanumeric characters, '-',
	// '_' or '.'. Each value MUST contain a valid string. An SP MAY
	// choose to accept binary (non-string) data by using a binary-to-text
	// encoding scheme, like base64. An SP SHALL advertise the
	// requirements for credentials in documentation. COs SHALL permit
	// users to pass through the required credentials. This information is
	// sensitive and MUST be treated as such (not logged, etc.) by the CO.
	// This field is OPTIONAL.
	UserCredentials map[string]string `protobuf:"bytes,7,rep,name=user_credentials,json=userCredentials" json:"user_credentials,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Attributes of the volume to publish. This field is OPTIONAL and
	// MUST match the attributes of the VolumeInfo identified by
	// `volume_id`.
	VolumeAttributes map[string]string `protobuf:"bytes,8,rep,name=volume_attributes,json=volumeAttributes" json:"volume_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *NodePublishVolumeRequest) Reset()                    { *m = NodePublishVolumeRequest{} }
func (m *NodePublishVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*NodePublishVolumeRequest) ProtoMessage()               {}
func (*NodePublishVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *NodePublishVolumeRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodePublishVolumeRequest) GetPublishVolumeInfo() map[string]string {
	if m != nil {
		return m.PublishVolumeInfo
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetTargetPath() string {
	if m != nil {
		return m.TargetPath
	}
	return ""
}

func (m *NodePublishVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *NodePublishVolumeRequest) GetUserCredentials() map[string]string {
	if m != nil {
		return m.UserCredentials
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

type NodePublishVolumeResponse struct {
}

func (m *NodePublishVolumeResponse) Reset()                    { *m = NodePublishVolumeResponse{} }
func (m *NodePublishVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*NodePublishVolumeResponse) ProtoMessage()               {}
func (*NodePublishVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

// //////
// //////
type NodeUnpublishVolumeRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The path at which the volume was published. It MUST be an absolute
	// path in the root filesystem of the process serving this request.
	// This is a REQUIRED field.
	TargetPath string `protobuf:"bytes,3,opt,name=target_path,json=targetPath" json:"target_path,omitempty"`
	// End user credentials used to authenticate/authorize node
	// unpublish request.
	// This field contains credential data, for example username and
	// password. Each key must consist of alphanumeric characters, '-',
	// '_' or '.'. Each value MUST contain a valid string. An SP MAY
	// choose to accept binary (non-string) data by using a binary-to-text
	// encoding scheme, like base64. An SP SHALL advertise the
	// requirements for credentials in documentation. COs SHALL permit
	// users to pass through the required credentials. This information is
	// sensitive and MUST be treated as such (not logged, etc.) by the CO.
	// This field is OPTIONAL.
	UserCredentials map[string]string `protobuf:"bytes,4,rep,name=user_credentials,json=userCredentials" json:"user_credentials,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *NodeUnpublishVolumeRequest) Reset()                    { *m = NodeUnpublishVolumeRequest{} }
func (m *NodeUnpublishVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeUnpublishVolumeRequest) ProtoMessage()               {}
func (*NodeUnpublishVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *NodeUnpublishVolumeRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *NodeUnpublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodeUnpublishVolumeRequest) GetTargetPath() string {
	if m != nil {
		return m.TargetPath
	}
	return ""
}

func (m *NodeUnpublishVolumeRequest) GetUserCredentials() map[string]string {
	if m != nil {
		return m.UserCredentials
	}
	return nil
}

type NodeUnpublishVolumeResponse struct {
}

func (m *NodeUnpublishVolumeResponse) Reset()                    { *m = NodeUnpublishVolumeResponse{} }
func (m *NodeUnpublishVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*NodeUnpublishVolumeResponse) ProtoMessage()               {}
func (*NodeUnpublishVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

// //////
// //////
type GetNodeIDRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
}

func (m *GetNodeIDRequest) Reset()                    { *m = GetNodeIDRequest{} }
func (m *GetNodeIDRequest) String() string            { return proto.CompactTextString(m) }
func (*GetNodeIDRequest) ProtoMessage()               {}
func (*GetNodeIDRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *GetNodeIDRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

type GetNodeIDResponse struct {
	// The ID of the node as understood by the SP which SHALL be used by
	// CO in subsequent `ControllerPublishVolume`.
	// This is a REQUIRED field.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
}

func (m *GetNodeIDResponse) Reset()                    { *m = GetNodeIDResponse{} }
func (m *GetNodeIDResponse) String() string            { return proto.CompactTextString(m) }
func (*GetNodeIDResponse) ProtoMessage()               {}
func (*GetNodeIDResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *GetNodeIDResponse) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

// //////
// //////
type NodeProbeRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
}

func (m *NodeProbeRequest) Reset()                    { *m = NodeProbeRequest{} }
func (m *NodeProbeRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeProbeRequest) ProtoMessage()               {}
func (*NodeProbeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *NodeProbeRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

type NodeProbeResponse struct {
}

func (m *NodeProbeResponse) Reset()                    { *m = NodeProbeResponse{} }
func (m *NodeProbeResponse) String() string            { return proto.CompactTextString(m) }
func (*NodeProbeResponse) ProtoMessage()               {}
func (*NodeProbeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

// //////
// //////
type NodeGetCapabilitiesRequest struct {
	// The API version assumed by the CO. This is a REQUIRED field.
	Version *Version `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
}

func (m *NodeGetCapabilitiesRequest) Reset()                    { *m = NodeGetCapabilitiesRequest{} }
func (m *NodeGetCapabilitiesRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeGetCapabilitiesRequest) ProtoMessage()               {}
func (*NodeGetCapabilitiesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *NodeGetCapabilitiesRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

type NodeGetCapabilitiesResponse struct {
	// All the capabilities that the node service supports. This field
	// is OPTIONAL.
	Capabilities []*NodeServiceCapability `protobuf:"bytes,1,rep,name=capabilities" json:"capabilities,omitempty"`
}

func (m *NodeGetCapabilitiesResponse) Reset()                    { *m = NodeGetCapabilitiesResponse{} }
func (m *NodeGetCapabilitiesResponse) String() string            { return proto.CompactTextString(m) }
func (*NodeGetCapabilitiesResponse) ProtoMessage()               {}
func (*NodeGetCapabilitiesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *NodeGetCapabilitiesResponse) GetCapabilities() []*NodeServiceCapability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// Specifies a capability of the node service.
type NodeServiceCapability struct {
	// Types that are valid to be assigned to Type:
	//	*NodeServiceCapability_Rpc
	Type isNodeServiceCapability_Type `protobuf_oneof:"type"`
}

func (m *NodeServiceCapability) Reset()                    { *m = NodeServiceCapability{} }
func (m *NodeServiceCapability) String() string            { return proto.CompactTextString(m) }
func (*NodeServiceCapability) ProtoMessage()               {}
func (*NodeServiceCapability) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

type isNodeServiceCapability_Type interface {
	isNodeServiceCapability_Type()
}

type NodeServiceCapability_Rpc struct {
	Rpc *NodeServiceCapability_RPC `protobuf:"bytes,1,opt,name=rpc,oneof"`
}

func (*NodeServiceCapability_Rpc) isNodeServiceCapability_Type() {}

func (m *NodeServiceCapability) GetType() isNodeServiceCapability_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *NodeServiceCapability) GetRpc() *NodeServiceCapability_RPC {
	if x, ok := m.GetType().(*NodeServiceCapability_Rpc); ok {
		return x.Rpc
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*NodeServiceCapability) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _NodeServiceCapability_OneofMarshaler, _NodeServiceCapability_OneofUnmarshaler, _NodeServiceCapability_OneofSizer, []interface{}{
		(*NodeServiceCapability_Rpc)(nil),
	}
}

func _NodeServiceCapability_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*NodeServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *NodeServiceCapability_Rpc:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Rpc); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("NodeServiceCapability.Type has unexpected type %T", x)
	}
	return nil
}

func _NodeServiceCapability_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*NodeServiceCapability)
	switch tag {
	case 1: // type.rpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NodeServiceCapability_RPC)
		err := b.DecodeMessage(msg)
		m.Type = &NodeServiceCapability_Rpc{msg}
		return true, err
	default:
		return false, nil
	}
}

func _NodeServiceCapability_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*NodeServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *NodeServiceCapability_Rpc:
		s := proto.Size(x.Rpc)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type NodeServiceCapability_RPC struct {
	Type NodeServiceCapability_RPC_Type `protobuf:"varint,1,opt,name=type,enum=csi.NodeServiceCapability_RPC_Type" json:"type,omitempty"`
}

func (m *NodeServiceCapability_RPC) Reset()                    { *m = NodeServiceCapability_RPC{} }
func (m *NodeServiceCapability_RPC) String() string            { return proto.CompactTextString(m) }
func (*NodeServiceCapability_RPC) ProtoMessage()               {}
func (*NodeServiceCapability_RPC) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37, 0} }

func (m *NodeServiceCapability_RPC) GetType() NodeServiceCapability_RPC_Type {
	if m != nil {
		return m.Type
	}
	return NodeServiceCapability_RPC_UNKNOWN
}

func init() {
	proto.RegisterType((*GetSupportedVersionsRequest)(nil), "csi.GetSupportedVersionsRequest")
	proto.RegisterType((*GetSupportedVersionsResponse)(nil), "csi.GetSupportedVersionsResponse")
	proto.RegisterType((*Version)(nil), "csi.Version")
	proto.RegisterType((*GetPluginInfoRequest)(nil), "csi.GetPluginInfoRequest")
	proto.RegisterType((*GetPluginInfoResponse)(nil), "csi.GetPluginInfoResponse")
	proto.RegisterType((*CreateVolumeRequest)(nil), "csi.CreateVolumeRequest")
	proto.RegisterType((*CreateVolumeResponse)(nil), "csi.CreateVolumeResponse")
	proto.RegisterType((*VolumeCapability)(nil), "csi.VolumeCapability")
	proto.RegisterType((*VolumeCapability_BlockVolume)(nil), "csi.VolumeCapability.BlockVolume")
	proto.RegisterType((*VolumeCapability_MountVolume)(nil), "csi.VolumeCapability.MountVolume")
	proto.RegisterType((*VolumeCapability_AccessMode)(nil), "csi.VolumeCapability.AccessMode")
	proto.RegisterType((*CapacityRange)(nil), "csi.CapacityRange")
	proto.RegisterType((*VolumeInfo)(nil), "csi.VolumeInfo")
	proto.RegisterType((*DeleteVolumeRequest)(nil), "csi.DeleteVolumeRequest")
	proto.RegisterType((*DeleteVolumeResponse)(nil), "csi.DeleteVolumeResponse")
	proto.RegisterType((*ControllerPublishVolumeRequest)(nil), "csi.ControllerPublishVolumeRequest")
	proto.RegisterType((*ControllerPublishVolumeResponse)(nil), "csi.ControllerPublishVolumeResponse")
	proto.RegisterType((*ControllerUnpublishVolumeRequest)(nil), "csi.ControllerUnpublishVolumeRequest")
	proto.RegisterType((*ControllerUnpublishVolumeResponse)(nil), "csi.ControllerUnpublishVolumeResponse")
	proto.RegisterType((*ValidateVolumeCapabilitiesRequest)(nil), "csi.ValidateVolumeCapabilitiesRequest")
	proto.RegisterType((*ValidateVolumeCapabilitiesResponse)(nil), "csi.ValidateVolumeCapabilitiesResponse")
	proto.RegisterType((*ListVolumesRequest)(nil), "csi.ListVolumesRequest")
	proto.RegisterType((*ListVolumesResponse)(nil), "csi.ListVolumesResponse")
	proto.RegisterType((*ListVolumesResponse_Entry)(nil), "csi.ListVolumesResponse.Entry")
	proto.RegisterType((*GetCapacityRequest)(nil), "csi.GetCapacityRequest")
	proto.RegisterType((*GetCapacityResponse)(nil), "csi.GetCapacityResponse")
	proto.RegisterType((*ControllerProbeRequest)(nil), "csi.ControllerProbeRequest")
	proto.RegisterType((*ControllerProbeResponse)(nil), "csi.ControllerProbeResponse")
	proto.RegisterType((*ControllerGetCapabilitiesRequest)(nil), "csi.ControllerGetCapabilitiesRequest")
	proto.RegisterType((*ControllerGetCapabilitiesResponse)(nil), "csi.ControllerGetCapabilitiesResponse")
	proto.RegisterType((*ControllerServiceCapability)(nil), "csi.ControllerServiceCapability")
	proto.RegisterType((*ControllerServiceCapability_RPC)(nil), "csi.ControllerServiceCapability.RPC")
	proto.RegisterType((*NodePublishVolumeRequest)(nil), "csi.NodePublishVolumeRequest")
	proto.RegisterType((*NodePublishVolumeResponse)(nil), "csi.NodePublishVolumeResponse")
	proto.RegisterType((*NodeUnpublishVolumeRequest)(nil), "csi.NodeUnpublishVolumeRequest")
	proto.RegisterType((*NodeUnpublishVolumeResponse)(nil), "csi.NodeUnpublishVolumeResponse")
	proto.RegisterType((*GetNodeIDRequest)(nil), "csi.GetNodeIDRequest")
	proto.RegisterType((*GetNodeIDResponse)(nil), "csi.GetNodeIDResponse")
	proto.RegisterType((*NodeProbeRequest)(nil), "csi.NodeProbeRequest")
	proto.RegisterType((*NodeProbeResponse)(nil), "csi.NodeProbeResponse")
	proto.RegisterType((*NodeGetCapabilitiesRequest)(nil), "csi.NodeGetCapabilitiesRequest")
	proto.RegisterType((*NodeGetCapabilitiesResponse)(nil), "csi.NodeGetCapabilitiesResponse")
	proto.RegisterType((*NodeServiceCapability)(nil), "csi.NodeServiceCapability")
	proto.RegisterType((*NodeServiceCapability_RPC)(nil), "csi.NodeServiceCapability.RPC")
	proto.RegisterEnum("csi.VolumeCapability_AccessMode_Mode", VolumeCapability_AccessMode_Mode_name, VolumeCapability_AccessMode_Mode_value)
	proto.RegisterEnum("csi.ControllerServiceCapability_RPC_Type", ControllerServiceCapability_RPC_Type_name, ControllerServiceCapability_RPC_Type_value)
	proto.RegisterEnum("csi.NodeServiceCapability_RPC_Type", NodeServiceCapability_RPC_Type_name, NodeServiceCapability_RPC_Type_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Identity service

type IdentityClient interface {
	GetSupportedVersions(ctx context.Context, in *GetSupportedVersionsRequest, opts ...grpc.CallOption) (*GetSupportedVersionsResponse, error)
	GetPluginInfo(ctx context.Context, in *GetPluginInfoRequest, opts ...grpc.CallOption) (*GetPluginInfoResponse, error)
}

type identityClient struct {
	cc *grpc.ClientConn
}

func NewIdentityClient(cc *grpc.ClientConn) IdentityClient {
	return &identityClient{cc}
}

func (c *identityClient) GetSupportedVersions(ctx context.Context, in *GetSupportedVersionsRequest, opts ...grpc.CallOption) (*GetSupportedVersionsResponse, error) {
	out := new(GetSupportedVersionsResponse)
	err := grpc.Invoke(ctx, "/csi.Identity/GetSupportedVersions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityClient) GetPluginInfo(ctx context.Context, in *GetPluginInfoRequest, opts ...grpc.CallOption) (*GetPluginInfoResponse, error) {
	out := new(GetPluginInfoResponse)
	err := grpc.Invoke(ctx, "/csi.Identity/GetPluginInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Identity service

type IdentityServer interface {
	GetSupportedVersions(context.Context, *GetSupportedVersionsRequest) (*GetSupportedVersionsResponse, error)
	GetPluginInfo(context.Context, *GetPluginInfoRequest) (*GetPluginInfoResponse, error)
}

func RegisterIdentityServer(s *grpc.Server, srv IdentityServer) {
	s.RegisterService(&_Identity_serviceDesc, srv)
}

func _Identity_GetSupportedVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSupportedVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityServer).GetSupportedVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Identity/GetSupportedVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityServer).GetSupportedVersions(ctx, req.(*GetSupportedVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Identity_GetPluginInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPluginInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityServer).GetPluginInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Identity/GetPluginInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityServer).GetPluginInfo(ctx, req.(*GetPluginInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Identity_serviceDesc = grpc.ServiceDesc{
	ServiceName: "csi.Identity",
	HandlerType: (*IdentityServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSupportedVersions",
			Handler:    _Identity_GetSupportedVersions_Handler,
		},
		{
			MethodName: "GetPluginInfo",
			Handler:    _Identity_GetPluginInfo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "csi.proto",
}

// Client API for Controller service

type ControllerClient interface {
	CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*CreateVolumeResponse, error)
	DeleteVolume(ctx context.Context, in *DeleteVolumeRequest, opts ...grpc.CallOption) (*DeleteVolumeResponse, error)
	ControllerPublishVolume(ctx context.Context, in *ControllerPublishVolumeRequest, opts ...grpc.CallOption) (*ControllerPublishVolumeResponse, error)
	ControllerUnpublishVolume(ctx context.Context, in *ControllerUnpublishVolumeRequest, opts ...grpc.CallOption) (*ControllerUnpublishVolumeResponse, error)
	ValidateVolumeCapabilities(ctx context.Context, in *ValidateVolumeCapabilitiesRequest, opts ...grpc.CallOption) (*ValidateVolumeCapabilitiesResponse, error)
	ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error)
	GetCapacity(ctx context.Context, in *GetCapacityRequest, opts ...grpc.CallOption) (*GetCapacityResponse, error)
	ControllerProbe(ctx context.Context, in *ControllerProbeRequest, opts ...grpc.CallOption) (*ControllerProbeResponse, error)
	ControllerGetCapabilities(ctx context.Context, in *ControllerGetCapabilitiesRequest, opts ...grpc.CallOption) (*ControllerGetCapabilitiesResponse, error)
}

type controllerClient struct {
	cc *grpc.ClientConn
}

func NewControllerClient(cc *grpc.ClientConn) ControllerClient {
	return &controllerClient{cc}
}

func (c *controllerClient) CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*CreateVolumeResponse, error) {
	out := new(CreateVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.Controller/CreateVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) DeleteVolume(ctx context.Context, in *DeleteVolumeRequest, opts ...grpc.CallOption) (*DeleteVolumeResponse, error) {
	out := new(DeleteVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.Controller/DeleteVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerPublishVolume(ctx context.Context, in *ControllerPublishVolumeRequest, opts ...grpc.CallOption) (*ControllerPublishVolumeResponse, error) {
	out := new(ControllerPublishVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.Controller/ControllerPublishVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerUnpublishVolume(ctx context.Context, in *ControllerUnpublishVolumeRequest, opts ...grpc.CallOption) (*ControllerUnpublishVolumeResponse, error) {
	out := new(ControllerUnpublishVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.Controller/ControllerUnpublishVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ValidateVolumeCapabilities(ctx context.Context, in *ValidateVolumeCapabilitiesRequest, opts ...grpc.CallOption) (*ValidateVolumeCapabilitiesResponse, error) {
	out := new(ValidateVolumeCapabilitiesResponse)
	err := grpc.Invoke(ctx, "/csi.Controller/ValidateVolumeCapabilities", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error) {
	out := new(ListVolumesResponse)
	err := grpc.Invoke(ctx, "/csi.Controller/ListVolumes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) GetCapacity(ctx context.Context, in *GetCapacityRequest, opts ...grpc.CallOption) (*GetCapacityResponse, error) {
	out := new(GetCapacityResponse)
	err := grpc.Invoke(ctx, "/csi.Controller/GetCapacity", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerProbe(ctx context.Context, in *ControllerProbeRequest, opts ...grpc.CallOption) (*ControllerProbeResponse, error) {
	out := new(ControllerProbeResponse)
	err := grpc.Invoke(ctx, "/csi.Controller/ControllerProbe", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerGetCapabilities(ctx context.Context, in *ControllerGetCapabilitiesRequest, opts ...grpc.CallOption) (*ControllerGetCapabilitiesResponse, error) {
	out := new(ControllerGetCapabilitiesResponse)
	err := grpc.Invoke(ctx, "/csi.Controller/ControllerGetCapabilities", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Controller service

type ControllerServer interface {
	CreateVolume(context.Context, *CreateVolumeRequest) (*CreateVolumeResponse, error)
	DeleteVolume(context.Context, *DeleteVolumeRequest) (*DeleteVolumeResponse, error)
	ControllerPublishVolume(context.Context, *ControllerPublishVolumeRequest) (*ControllerPublishVolumeResponse, error)
	ControllerUnpublishVolume(context.Context, *ControllerUnpublishVolumeRequest) (*ControllerUnpublishVolumeResponse, error)
	ValidateVolumeCapabilities(context.Context, *ValidateVolumeCapabilitiesRequest) (*ValidateVolumeCapabilitiesResponse, error)
	ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error)
	GetCapacity(context.Context, *GetCapacityRequest) (*GetCapacityResponse, error)
	ControllerProbe(context.Context, *ControllerProbeRequest) (*ControllerProbeResponse, error)
	ControllerGetCapabilities(context.Context, *ControllerGetCapabilitiesRequest) (*ControllerGetCapabilitiesResponse, error)
}

func RegisterControllerServer(s *grpc.Server, srv ControllerServer) {
	s.RegisterService(&_Controller_serviceDesc, srv)
}

func _Controller_CreateVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).CreateVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Controller/CreateVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).CreateVolume(ctx, req.(*CreateVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_DeleteVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).DeleteVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Controller/DeleteVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).DeleteVolume(ctx, req.(*DeleteVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerPublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerPublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerPublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Controller/ControllerPublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerPublishVolume(ctx, req.(*ControllerPublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerUnpublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerUnpublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerUnpublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Controller/ControllerUnpublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerUnpublishVolume(ctx, req.(*ControllerUnpublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ValidateVolumeCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateVolumeCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ValidateVolumeCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Controller/ValidateVolumeCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ValidateVolumeCapabilities(ctx, req.(*ValidateVolumeCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ListVolumes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ListVolumes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Controller/ListVolumes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ListVolumes(ctx, req.(*ListVolumesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_GetCapacity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCapacityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).GetCapacity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Controller/GetCapacity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).GetCapacity(ctx, req.(*GetCapacityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerProbe_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerProbeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerProbe(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Controller/ControllerProbe",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerProbe(ctx, req.(*ControllerProbeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerGetCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerGetCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerGetCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Controller/ControllerGetCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerGetCapabilities(ctx, req.(*ControllerGetCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Controller_serviceDesc = grpc.ServiceDesc{
	ServiceName: "csi.Controller",
	HandlerType: (*ControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateVolume",
			Handler:    _Controller_CreateVolume_Handler,
		},
		{
			MethodName: "DeleteVolume",
			Handler:    _Controller_DeleteVolume_Handler,
		},
		{
			MethodName: "ControllerPublishVolume",
			Handler:    _Controller_ControllerPublishVolume_Handler,
		},
		{
			MethodName: "ControllerUnpublishVolume",
			Handler:    _Controller_ControllerUnpublishVolume_Handler,
		},
		{
			MethodName: "ValidateVolumeCapabilities",
			Handler:    _Controller_ValidateVolumeCapabilities_Handler,
		},
		{
			MethodName: "ListVolumes",
			Handler:    _Controller_ListVolumes_Handler,
		},
		{
			MethodName: "GetCapacity",
			Handler:    _Controller_GetCapacity_Handler,
		},
		{
			MethodName: "ControllerProbe",
			Handler:    _Controller_ControllerProbe_Handler,
		},
		{
			MethodName: "ControllerGetCapabilities",
			Handler:    _Controller_ControllerGetCapabilities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "csi.proto",
}

// Client API for Node service

type NodeClient interface {
	NodePublishVolume(ctx context.Context, in *NodePublishVolumeRequest, opts ...grpc.CallOption) (*NodePublishVolumeResponse, error)
	NodeUnpublishVolume(ctx context.Context, in *NodeUnpublishVolumeRequest, opts ...grpc.CallOption) (*NodeUnpublishVolumeResponse, error)
	GetNodeID(ctx context.Context, in *GetNodeIDRequest, opts ...grpc.CallOption) (*GetNodeIDResponse, error)
	NodeProbe(ctx context.Context, in *NodeProbeRequest, opts ...grpc.CallOption) (*NodeProbeResponse, error)
	NodeGetCapabilities(ctx context.Context, in *NodeGetCapabilitiesRequest, opts ...grpc.CallOption) (*NodeGetCapabilitiesResponse, error)
}

type nodeClient struct {
	cc *grpc.ClientConn
}

func NewNodeClient(cc *grpc.ClientConn) NodeClient {
	return &nodeClient{cc}
}

func (c *nodeClient) NodePublishVolume(ctx context.Context, in *NodePublishVolumeRequest, opts ...grpc.CallOption) (*NodePublishVolumeResponse, error) {
	out := new(NodePublishVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.Node/NodePublishVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeUnpublishVolume(ctx context.Context, in *NodeUnpublishVolumeRequest, opts ...grpc.CallOption) (*NodeUnpublishVolumeResponse, error) {
	out := new(NodeUnpublishVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.Node/NodeUnpublishVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) GetNodeID(ctx context.Context, in *GetNodeIDRequest, opts ...grpc.CallOption) (*GetNodeIDResponse, error) {
	out := new(GetNodeIDResponse)
	err := grpc.Invoke(ctx, "/csi.Node/GetNodeID", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeProbe(ctx context.Context, in *NodeProbeRequest, opts ...grpc.CallOption) (*NodeProbeResponse, error) {
	out := new(NodeProbeResponse)
	err := grpc.Invoke(ctx, "/csi.Node/NodeProbe", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeGetCapabilities(ctx context.Context, in *NodeGetCapabilitiesRequest, opts ...grpc.CallOption) (*NodeGetCapabilitiesResponse, error) {
	out := new(NodeGetCapabilitiesResponse)
	err := grpc.Invoke(ctx, "/csi.Node/NodeGetCapabilities", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Node service

type NodeServer interface {
	NodePublishVolume(context.Context, *NodePublishVolumeRequest) (*NodePublishVolumeResponse, error)
	NodeUnpublishVolume(context.Context, *NodeUnpublishVolumeRequest) (*NodeUnpublishVolumeResponse, error)
	GetNodeID(context.Context, *GetNodeIDRequest) (*GetNodeIDResponse, error)
	NodeProbe(context.Context, *NodeProbeRequest) (*NodeProbeResponse, error)
	NodeGetCapabilities(context.Context, *NodeGetCapabilitiesRequest) (*NodeGetCapabilitiesResponse, error)
}

func RegisterNodeServer(s *grpc.Server, srv NodeServer) {
	s.RegisterService(&_Node_serviceDesc, srv)
}

func _Node_NodePublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodePublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodePublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Node/NodePublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodePublishVolume(ctx, req.(*NodePublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeUnpublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeUnpublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeUnpublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Node/NodeUnpublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeUnpublishVolume(ctx, req.(*NodeUnpublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_GetNodeID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeIDRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).GetNodeID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Node/GetNodeID",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).GetNodeID(ctx, req.(*GetNodeIDRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeProbe_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeProbeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeProbe(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Node/NodeProbe",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeProbe(ctx, req.(*NodeProbeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeGetCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeGetCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeGetCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.Node/NodeGetCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeGetCapabilities(ctx, req.(*NodeGetCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Node_serviceDesc = grpc.ServiceDesc{
	ServiceName: "csi.Node",
	HandlerType: (*NodeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NodePublishVolume",
			Handler:    _Node_NodePublishVolume_Handler,
		},
		{
			MethodName: "NodeUnpublishVolume",
			Handler:    _Node_NodeUnpublishVolume_Handler,
		},
		{
			MethodName: "GetNodeID",
			Handler:    _Node_GetNodeID_Handler,
		},
		{
			MethodName: "NodeProbe",
			Handler:    _Node_NodeProbe_Handler,
		},
		{
			MethodName: "NodeGetCapabilities",
			Handler:    _Node_NodeGetCapabilities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "csi.proto",
}

func init() { proto.RegisterFile("csi.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1993 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0x4b, 0x73, 0xe3, 0x58,
	0x15, 0xb6, 0x6c, 0xe7, 0xe1, 0xe3, 0x38, 0xed, 0x5c, 0xe7, 0xa1, 0x28, 0xfd, 0x70, 0xab, 0xa7,
	0x7b, 0x42, 0x15, 0xe3, 0xa2, 0x3c, 0x54, 0xd1, 0xe9, 0x9e, 0x19, 0x48, 0x6c, 0x4f, 0x62, 0x26,
	0x71, 0xa7, 0x14, 0xa7, 0x9b, 0x01, 0xa6, 0x84, 0x62, 0xdf, 0xa4, 0x45, 0xcb, 0x92, 0x47, 0x92,
	0x5d, 0xed, 0x3d, 0x4b, 0x16, 0xec, 0xd8, 0xc1, 0x72, 0xa0, 0x58, 0x02, 0xbf, 0x80, 0xbf, 0x00,
	0xac, 0xd9, 0xf2, 0x0f, 0xa8, 0x62, 0x43, 0xdd, 0x87, 0x64, 0x49, 0x96, 0x1c, 0x3b, 0x93, 0x1e,
	0x66, 0x27, 0x9d, 0xc7, 0x77, 0xcf, 0xe3, 0xde, 0x73, 0xce, 0x95, 0x20, 0xd7, 0x71, 0xf4, 0x4a,
	0xdf, 0xb6, 0x5c, 0x0b, 0x65, 0x3a, 0x8e, 0x2e, 0xdf, 0x83, 0x9d, 0x43, 0xec, 0x9e, 0x0d, 0xfa,
	0x7d, 0xcb, 0x76, 0x71, 0xf7, 0x25, 0xb6, 0x1d, 0xdd, 0x32, 0x1d, 0x05, 0x7f, 0x39, 0xc0, 0x8e,
	0x2b, 0xff, 0x0c, 0xee, 0xc6, 0xb3, 0x9d, 0xbe, 0x65, 0x3a, 0x18, 0x3d, 0x07, 0xe4, 0x78, 0x4c,
	0x75, 0xc8, 0xb9, 0xa2, 0x50, 0xce, 0xec, 0xe6, 0xab, 0x2b, 0x15, 0xb2, 0x16, 0x57, 0x51, 0xd6,
	0x9c, 0x28, 0x88, 0xfc, 0x19, 0x2c, 0xf1, 0x67, 0xb4, 0x0e, 0x0b, 0x3d, 0xed, 0x97, 0x96, 0x2d,
	0x0a, 0x65, 0x61, 0xb7, 0xa0, 0xb0, 0x17, 0x4a, 0xd5, 0x4d, 0xcb, 0x16, 0xd3, 0x9c, 0x4a, 0x5e,
	0x08, 0xb5, 0xaf, 0xb9, 0x9d, 0xd7, 0x62, 0x86, 0x51, 0xe9, 0x8b, 0xfc, 0x09, 0xac, 0x1f, 0x62,
	0xf7, 0xd4, 0x18, 0x5c, 0xe9, 0x66, 0xd3, 0xbc, 0xb4, 0xb8, 0x07, 0xe8, 0x09, 0x2c, 0x71, 0xbb,
	0x28, 0x76, 0xd4, 0x2c, 0x8f, 0x29, 0xff, 0x43, 0x80, 0x8d, 0x08, 0x00, 0xf7, 0x11, 0x41, 0xd6,
	0xd4, 0x7a, 0x98, 0xaa, 0xe7, 0x14, 0xfa, 0x8c, 0x1e, 0xc3, 0xea, 0x10, 0x9b, 0x5d, 0xcb, 0xf6,
	0x9c, 0xa6, 0x26, 0xe6, 0x94, 0x02, 0xa3, 0x7a, 0x6e, 0xd5, 0x61, 0xb9, 0xa7, 0x99, 0xfa, 0x25,
	0x76, 0x5c, 0x31, 0x43, 0x83, 0xb2, 0x4b, 0x57, 0x8f, 0x5d, 0xa8, 0x72, 0xc2, 0x45, 0x1b, 0xa6,
	0x6b, 0x8f, 0x14, 0x5f, 0x53, 0x7a, 0x0e, 0x85, 0x10, 0x0b, 0x15, 0x21, 0xf3, 0x06, 0x8f, 0xb8,
	0x41, 0xe4, 0x91, 0xc4, 0x64, 0xa8, 0x19, 0x03, 0xcc, 0xcd, 0x60, 0x2f, 0xcf, 0xd2, 0x4f, 0x05,
	0xf9, 0xbf, 0x19, 0x28, 0xd5, 0x6c, 0xac, 0xb9, 0xf8, 0xa5, 0x65, 0x0c, 0x7a, 0x78, 0xce, 0xb8,
	0xf8, 0xde, 0xa7, 0x03, 0xde, 0xef, 0xc1, 0x6a, 0x47, 0xeb, 0x6b, 0x1d, 0xdd, 0x1d, 0xa9, 0xb6,
	0x66, 0x5e, 0x61, 0x9a, 0x8a, 0x7c, 0x15, 0x51, 0x88, 0x1a, 0x67, 0x29, 0x84, 0xa3, 0x14, 0x3a,
	0xc1, 0x57, 0xf4, 0x29, 0x94, 0x86, 0xd4, 0x0e, 0x95, 0xd0, 0x2f, 0x74, 0x43, 0x77, 0x75, 0xec,
	0x88, 0x59, 0x1a, 0x9c, 0x0d, 0x66, 0x02, 0xe5, 0xd7, 0x3c, 0xf6, 0x48, 0x41, 0xc3, 0x30, 0x45,
	0xc7, 0x0e, 0x3a, 0x02, 0xe8, 0x6b, 0xb6, 0xd6, 0xc3, 0x2e, 0xb6, 0x1d, 0x71, 0x21, 0x10, 0xdb,
	0x18, 0x67, 0x2b, 0xa7, 0xbe, 0x28, 0x8b, 0x6d, 0x40, 0x17, 0xfd, 0x04, 0x8a, 0x03, 0x07, 0xdb,
	0x6a, 0xc7, 0xc6, 0x5d, 0x6c, 0xba, 0xba, 0x66, 0x38, 0xe2, 0x22, 0xc5, 0xfb, 0x20, 0x11, 0xef,
	0xdc, 0xc1, 0x76, 0x6d, 0x2c, 0xcf, 0x40, 0xef, 0x0c, 0xc2, 0x54, 0xe9, 0x63, 0xb8, 0x13, 0x59,
	0x78, 0x9e, 0xcc, 0x49, 0x07, 0xb0, 0x1e, 0xb7, 0xce, 0x5c, 0xd9, 0x3f, 0x82, 0xf5, 0xb0, 0xfd,
	0x7c, 0x4f, 0x7f, 0x0f, 0xf2, 0x3c, 0x0d, 0xba, 0x79, 0x69, 0xf1, 0x1d, 0x70, 0x27, 0x10, 0x7e,
	0xba, 0x31, 0x61, 0xe8, 0x3f, 0xcb, 0xbf, 0xcb, 0x42, 0x31, 0x9a, 0x19, 0xb4, 0x07, 0x0b, 0x17,
	0x86, 0xd5, 0x79, 0xc3, 0x01, 0x1e, 0xc6, 0xe6, 0xaf, 0x72, 0x40, 0x44, 0x18, 0xf5, 0x28, 0xa5,
	0x30, 0x0d, 0xa2, 0xda, 0xb3, 0x06, 0xa6, 0x4b, 0x6d, 0x4e, 0x54, 0x3d, 0x21, 0x22, 0x63, 0x55,
	0xaa, 0x81, 0xf6, 0x21, 0xaf, 0x75, 0x3a, 0xd8, 0x71, 0xd4, 0x9e, 0xd5, 0xf5, 0xf6, 0x5e, 0x39,
	0x1e, 0x60, 0x9f, 0x0a, 0x9e, 0x58, 0x5d, 0xac, 0x80, 0xe6, 0x3f, 0x4b, 0x05, 0xc8, 0x07, 0xac,
	0x92, 0x0e, 0x21, 0x1f, 0x58, 0x09, 0x6d, 0xc1, 0xd2, 0xa5, 0xa3, 0xba, 0xa3, 0xbe, 0x77, 0xe8,
	0x17, 0x2f, 0x9d, 0xf6, 0xa8, 0x8f, 0xd1, 0x03, 0xc8, 0x53, 0x13, 0xd4, 0x4b, 0x43, 0xbb, 0x72,
	0xc4, 0x74, 0x39, 0xb3, 0x9b, 0x53, 0x80, 0x92, 0x3e, 0x25, 0x14, 0xe9, 0xdf, 0x02, 0xc0, 0x78,
	0x49, 0xb4, 0x07, 0x59, 0x6a, 0x22, 0x41, 0x59, 0xad, 0x3e, 0xbe, 0xce, 0xc4, 0x0a, 0xb5, 0x93,
	0xaa, 0xc8, 0xbf, 0x17, 0x20, 0x4b, 0x31, 0xf2, 0xb0, 0x74, 0xde, 0xfa, 0xac, 0xf5, 0xe2, 0x55,
	0xab, 0x98, 0x42, 0x9b, 0x80, 0xce, 0x9a, 0xad, 0xc3, 0xe3, 0x86, 0xda, 0x7a, 0x51, 0x6f, 0xa8,
	0xaf, 0x94, 0x66, 0xbb, 0xa1, 0x14, 0x05, 0xb4, 0x03, 0x5b, 0x41, 0xba, 0xd2, 0xd8, 0xaf, 0x37,
	0x14, 0xf5, 0x45, 0xeb, 0xf8, 0xf3, 0x62, 0x1a, 0x49, 0xb0, 0x79, 0x72, 0x7e, 0xdc, 0x6e, 0x4e,
	0xf2, 0x32, 0xe8, 0x2e, 0x88, 0x01, 0x1e, 0xc7, 0xe0, 0xb0, 0x59, 0x02, 0x1b, 0xe0, 0xb2, 0x47,
	0xce, 0x5c, 0x38, 0x28, 0xf8, 0x69, 0x20, 0x91, 0x92, 0x5f, 0x41, 0x21, 0x74, 0xf2, 0x49, 0x8d,
	0xb4, 0xf1, 0x97, 0x03, 0xdd, 0xc6, 0x5d, 0xf5, 0x62, 0xe4, 0x62, 0x87, 0x86, 0x21, 0xab, 0x14,
	0x3c, 0xea, 0x01, 0x21, 0x92, 0x98, 0x1a, 0x7a, 0x4f, 0x77, 0xb9, 0x4c, 0x9a, 0xca, 0x00, 0x25,
	0x51, 0x01, 0xf9, 0x6f, 0x02, 0xc0, 0x78, 0x53, 0x12, 0x58, 0xbf, 0xf8, 0x84, 0x60, 0x3d, 0x2a,
	0x83, 0x5d, 0x85, 0xb4, 0xde, 0xe5, 0x07, 0x22, 0xad, 0x77, 0xd1, 0x0f, 0x01, 0x34, 0xd7, 0xb5,
	0xf5, 0x8b, 0x01, 0x51, 0x61, 0xc5, 0xf8, 0x41, 0x64, 0xc3, 0x57, 0xf6, 0x7d, 0x09, 0x5e, 0x27,
	0xc6, 0x2a, 0xe4, 0x34, 0x47, 0xd8, 0x73, 0x9d, 0xc4, 0xff, 0x08, 0x50, 0xaa, 0x63, 0x03, 0xdf,
	0xb4, 0x0e, 0xef, 0x40, 0xce, 0x3b, 0xb1, 0x9e, 0x5b, 0xcb, 0xfc, 0x78, 0x76, 0x63, 0x6b, 0x58,
	0x26, 0x50, 0xc3, 0x62, 0x16, 0x9e, 0xb1, 0x86, 0xdd, 0x46, 0x11, 0xda, 0x84, 0xf5, 0xb0, 0x01,
	0xac, 0x08, 0xc9, 0x7f, 0xc9, 0xc2, 0xfd, 0x9a, 0x65, 0xba, 0xb6, 0x65, 0x18, 0xd8, 0x3e, 0x1d,
	0x5c, 0x18, 0xba, 0xf3, 0xfa, 0x1d, 0x44, 0x67, 0x0b, 0x96, 0x4c, 0xab, 0x4b, 0x59, 0x19, 0x76,
	0x9c, 0xc9, 0x6b, 0xb3, 0x8b, 0x0e, 0x60, 0x2d, 0xda, 0x8c, 0x46, 0x62, 0x96, 0xae, 0x93, 0xd0,
	0x8a, 0x8a, 0xc3, 0x68, 0x09, 0x94, 0x60, 0xd9, 0xc6, 0x5a, 0xd7, 0x32, 0x8d, 0x91, 0xb8, 0x50,
	0x16, 0x76, 0x97, 0x15, 0xff, 0x1d, 0x75, 0x12, 0x5b, 0xcb, 0x53, 0xd6, 0x5a, 0xa6, 0x3a, 0x3f,
	0x5b, 0x86, 0xd0, 0xa5, 0xef, 0x44, 0x60, 0x7f, 0x2f, 0xd1, 0x55, 0xf6, 0x66, 0x59, 0x85, 0xbd,
	0x45, 0x77, 0x3e, 0x77, 0x74, 0x4c, 0xbe, 0x8d, 0x9d, 0x20, 0xd5, 0x60, 0x23, 0x76, 0xb9, 0xb9,
	0xb6, 0xd3, 0xdf, 0x05, 0x78, 0x90, 0xe8, 0x13, 0xef, 0x6f, 0x6f, 0xa0, 0xd4, 0x67, 0x0c, 0x35,
	0xdc, 0xe7, 0x48, 0x58, 0x9e, 0x4f, 0x0f, 0x0b, 0x9f, 0xc6, 0x42, 0x54, 0x52, 0x1d, 0x58, 0x60,
	0xd6, 0xfa, 0x51, 0xba, 0x54, 0x87, 0xcd, 0x78, 0xe1, 0xb9, 0xdc, 0xfa, 0x53, 0x1a, 0xca, 0x63,
	0x9b, 0xce, 0xcd, 0xfe, 0x37, 0x7f, 0x1e, 0x70, 0xcc, 0x7e, 0x65, 0x93, 0xd9, 0xb3, 0x48, 0xc8,
	0xe2, 0xcd, 0xfb, 0x06, 0x6b, 0xca, 0x23, 0x78, 0x38, 0xc5, 0x1a, 0x5e, 0x60, 0xfe, 0x95, 0x86,
	0x87, 0x2f, 0x35, 0x43, 0xef, 0xfa, 0x03, 0x50, 0x70, 0x86, 0xbc, 0xd5, 0x98, 0x26, 0xcc, 0xb5,
	0x99, 0x79, 0xe7, 0x5a, 0x3d, 0xee, 0x34, 0xb3, 0x1c, 0x7c, 0xc4, 0x50, 0xae, 0xf3, 0x67, 0xe6,
	0x03, 0x7d, 0x2b, 0x87, 0xf1, 0xe7, 0x20, 0x4f, 0xb3, 0x88, 0x1f, 0xc7, 0xbb, 0x90, 0xf3, 0xaf,
	0x7f, 0x14, 0x77, 0x59, 0x19, 0x13, 0x90, 0x08, 0x4b, 0x3d, 0xec, 0x38, 0xda, 0x95, 0x87, 0xef,
	0xbd, 0xca, 0xbf, 0x12, 0x00, 0x1d, 0xeb, 0x0e, 0x9f, 0xcb, 0xe6, 0xce, 0x18, 0x19, 0xd7, 0xb4,
	0xb7, 0x2a, 0x36, 0x5d, 0x5b, 0xe7, 0xa3, 0x45, 0x41, 0x81, 0x9e, 0xf6, 0xb6, 0xc1, 0x28, 0x64,
	0x96, 0x70, 0x5c, 0xcd, 0x76, 0x75, 0xf3, 0x4a, 0x75, 0xad, 0x37, 0xd8, 0xe4, 0x07, 0xa2, 0xe0,
	0x51, 0xdb, 0x84, 0x28, 0xff, 0x51, 0x80, 0x52, 0xc8, 0x0c, 0xee, 0xd6, 0x53, 0x58, 0xf2, 0xb0,
	0x59, 0x65, 0xb9, 0x4f, 0xed, 0x88, 0x11, 0xad, 0xb0, 0x24, 0x78, 0xe2, 0xe8, 0x1e, 0x80, 0x89,
	0xdf, 0xba, 0x7c, 0x51, 0xe6, 0x75, 0x8e, 0x50, 0xe8, 0x82, 0xd2, 0x1e, 0x2c, 0xb0, 0x54, 0xcc,
	0x3f, 0xa7, 0xff, 0x3a, 0x0d, 0xe8, 0x10, 0xbb, 0xfe, 0x28, 0x36, 0x67, 0xc8, 0x12, 0xf6, 0x71,
	0x7a, 0xde, 0x7d, 0x7c, 0x18, 0xba, 0x9f, 0xb1, 0x63, 0xf0, 0xbe, 0x77, 0xf7, 0x8d, 0x18, 0x37,
	0xed, 0x7a, 0xf6, 0x35, 0x2f, 0x51, 0x72, 0x1d, 0x4a, 0xa1, 0x05, 0x79, 0xe6, 0x3e, 0x00, 0xa4,
	0x0d, 0x35, 0xdd, 0xd0, 0x2e, 0x0c, 0xe6, 0x29, 0xe1, 0xf2, 0x41, 0x72, 0xcd, 0xe7, 0x78, 0x6a,
	0xf2, 0x8f, 0x60, 0x33, 0xd0, 0x2e, 0x6c, 0xeb, 0x62, 0xde, 0x82, 0x2c, 0x6f, 0xc3, 0xd6, 0x04,
	0x02, 0xaf, 0x52, 0x3f, 0x0e, 0xd6, 0x7d, 0x6e, 0xec, 0x0d, 0x6b, 0x94, 0xac, 0x07, 0xcb, 0xe2,
	0x04, 0x16, 0x77, 0xbe, 0x0e, 0x2b, 0x31, 0xc9, 0x2d, 0x47, 0x4a, 0xfc, 0x19, 0xb6, 0x87, 0x7a,
	0x27, 0x98, 0xe7, 0x90, 0x96, 0xfc, 0xdb, 0x34, 0xec, 0x4c, 0x91, 0x46, 0x4f, 0x21, 0x63, 0xf7,
	0x3b, 0xdc, 0xdc, 0xf7, 0xae, 0x03, 0xaf, 0x28, 0xa7, 0xb5, 0xa3, 0x94, 0x42, 0x54, 0xa4, 0xbf,
	0x0a, 0x90, 0x51, 0x4e, 0x6b, 0xe8, 0x63, 0xc8, 0xfa, 0x77, 0xb0, 0xd5, 0xea, 0x77, 0x66, 0x81,
	0xa8, 0x90, 0x6b, 0x9a, 0x42, 0xd5, 0x64, 0x0b, 0xb2, 0xf4, 0xd2, 0x16, 0xba, 0x40, 0x89, 0xb0,
	0x5e, 0x53, 0x1a, 0xfb, 0xed, 0x86, 0x5a, 0x6f, 0x1c, 0x37, 0xda, 0x0d, 0xf5, 0xe5, 0x8b, 0xe3,
	0xf3, 0x93, 0x46, 0x51, 0x20, 0x37, 0xa1, 0xd3, 0xf3, 0x83, 0xe3, 0xe6, 0xd9, 0x91, 0x7a, 0xde,
	0xf2, 0x9e, 0x38, 0x37, 0x8d, 0x8a, 0xb0, 0x72, 0xdc, 0x3c, 0x6b, 0x73, 0xc2, 0x59, 0x31, 0x43,
	0x28, 0x87, 0x8d, 0xb6, 0x5a, 0xdb, 0x3f, 0xdd, 0xaf, 0x35, 0xdb, 0x9f, 0x17, 0xb3, 0x07, 0x8b,
	0xcc, 0x5e, 0xf9, 0x9f, 0x0b, 0x20, 0xb6, 0xac, 0x2e, 0x7e, 0x77, 0x13, 0x6d, 0x37, 0x7e, 0xbc,
	0x61, 0xc7, 0xec, 0xfb, 0x14, 0x30, 0xc9, 0x80, 0xd9, 0xe7, 0x1a, 0x52, 0x3e, 0x5d, 0xcd, 0xbe,
	0xc2, 0xae, 0xda, 0xd7, 0xdc, 0xd7, 0x74, 0x30, 0xce, 0x29, 0xc0, 0x48, 0xa7, 0x9a, 0xfb, 0x3a,
	0x7e, 0x7e, 0x5e, 0xb8, 0xf9, 0xfc, 0xbc, 0x18, 0x99, 0x9f, 0xbf, 0x88, 0x99, 0x47, 0xd8, 0x64,
	0x5b, 0x9d, 0xee, 0xe3, 0x6c, 0x93, 0xf3, 0x2f, 0xe2, 0x7a, 0xed, 0x32, 0xc5, 0xff, 0x70, 0x3a,
	0xfe, 0xac, 0x2d, 0xf6, 0x56, 0x26, 0xc3, 0x6f, 0xcf, 0xe4, 0xbd, 0x03, 0xdb, 0x31, 0x21, 0xe1,
	0x65, 0xec, 0xab, 0x34, 0x48, 0x84, 0xfb, 0x2e, 0x27, 0xd7, 0xc8, 0x8e, 0xcc, 0x4c, 0xec, 0x48,
	0x35, 0x71, 0x82, 0x1d, 0x9f, 0x8a, 0xff, 0xfb, 0xec, 0x7a, 0x0f, 0x76, 0x62, 0xed, 0xe0, 0x81,
	0x7c, 0x06, 0xc5, 0x43, 0xec, 0x12, 0x89, 0x66, 0x7d, 0xde, 0xfa, 0xff, 0x5d, 0x58, 0x0b, 0xe8,
	0xf2, 0x7a, 0x1f, 0x98, 0xf7, 0x85, 0xe0, 0xbc, 0x4f, 0x56, 0xa2, 0xf9, 0xbc, 0x49, 0x43, 0x2b,
	0xc1, 0x5a, 0x40, 0x97, 0x9b, 0x5e, 0x67, 0x5b, 0xe0, 0x6b, 0x36, 0xb1, 0x2f, 0x58, 0x7c, 0x92,
	0xda, 0xd7, 0x27, 0x91, 0xf6, 0xc5, 0x46, 0x2f, 0xc9, 0xcf, 0xef, 0x75, 0x8d, 0xeb, 0x0f, 0x02,
	0x6c, 0xc4, 0xca, 0xa1, 0x6a, 0xb0, 0x65, 0xdd, 0x4f, 0x06, 0x0c, 0x36, 0xab, 0x33, 0xd6, 0xab,
	0x7e, 0x10, 0xea, 0x55, 0x8f, 0xa6, 0xeb, 0x06, 0xbb, 0x54, 0x29, 0xa6, 0x4b, 0x79, 0x9d, 0xa4,
	0xfa, 0x67, 0x01, 0x96, 0x9b, 0x74, 0xa3, 0xb9, 0xa4, 0x1a, 0xae, 0xc7, 0xfd, 0x8b, 0x41, 0x65,
	0x6f, 0xac, 0x4a, 0xfa, 0x8b, 0x23, 0x3d, 0x9c, 0x22, 0xc1, 0x33, 0x97, 0x42, 0x47, 0x50, 0x08,
	0xfd, 0x96, 0x40, 0xdb, 0x71, 0xbf, 0x2a, 0x18, 0xa0, 0x94, 0xfc, 0x17, 0x43, 0x4e, 0x55, 0xbf,
	0x5a, 0x04, 0x18, 0xf7, 0x69, 0xd4, 0x80, 0x95, 0xe0, 0x37, 0x68, 0x24, 0x26, 0x7d, 0x56, 0x97,
	0xb6, 0x63, 0x38, 0xbe, 0x7d, 0x0d, 0x58, 0x09, 0x7e, 0x45, 0xe2, 0x30, 0x31, 0x5f, 0xb6, 0x38,
	0x4c, 0xec, 0x27, 0xa7, 0x14, 0xba, 0x0c, 0x0d, 0x62, 0xc1, 0x03, 0x88, 0x1e, 0xcd, 0xf0, 0xb9,
	0x44, 0x7a, 0x6f, 0x96, 0x8f, 0x07, 0x72, 0x0a, 0x19, 0xb0, 0x9d, 0x78, 0x41, 0x45, 0x8f, 0x67,
	0xba, 0x4e, 0x4b, 0x4f, 0xae, 0x13, 0xf3, 0x57, 0xb3, 0x40, 0x4a, 0xbe, 0x86, 0xa1, 0x27, 0xb3,
	0xdd, 0x1c, 0xa5, 0xf7, 0xaf, 0x95, 0xf3, 0x17, 0x3c, 0x80, 0x7c, 0xe0, 0x9a, 0x83, 0xb6, 0x26,
	0x2f, 0x3e, 0x0c, 0x52, 0x4c, 0xba, 0x11, 0x31, 0x8c, 0xc0, 0x6c, 0xce, 0x31, 0x26, 0xaf, 0x07,
	0x1c, 0x23, 0x66, 0x8c, 0x97, 0x53, 0xa8, 0x05, 0x77, 0x22, 0x73, 0x35, 0xda, 0x89, 0x66, 0x28,
	0x50, 0xde, 0xa4, 0xbb, 0xf1, 0xcc, 0xf8, 0xb4, 0x45, 0x2a, 0xd0, 0x44, 0xda, 0xe2, 0xeb, 0xdc,
	0x44, 0xda, 0x12, 0x0a, 0x99, 0x9c, 0xaa, 0xfe, 0x26, 0x03, 0x59, 0x52, 0x25, 0x50, 0x9b, 0x57,
	0xd3, 0xd0, 0x2e, 0xb9, 0x37, 0x75, 0x08, 0x91, 0xee, 0x27, 0xb1, 0x7d, 0x67, 0x7e, 0x0a, 0xa5,
	0x98, 0x46, 0x83, 0x1e, 0x5c, 0xd3, 0x0a, 0xa5, 0x72, 0xb2, 0x80, 0x8f, 0xfd, 0x11, 0xe4, 0xfc,
	0x4e, 0x83, 0x36, 0xbc, 0x0c, 0x85, 0xba, 0x96, 0xb4, 0x19, 0x25, 0x07, 0xb5, 0xfd, 0xee, 0xc1,
	0xb5, 0xa3, 0x9d, 0x88, 0x6b, 0x4f, 0x36, 0x19, 0xdf, 0xaf, 0x68, 0x7a, 0xc6, 0x7e, 0x25, 0x24,
	0xa6, 0x9c, 0x2c, 0xe0, 0x61, 0x5f, 0x2c, 0xd2, 0x9f, 0xe3, 0x1f, 0xfe, 0x2f, 0x00, 0x00, 0xff,
	0xff, 0x17, 0x25, 0x65, 0xbe, 0x29, 0x1f, 0x00, 0x00,
}
