package compute

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessLevel enumerates the values for access level.
type AccessLevel string

const (
	// None specifies the none state for access level.
	None AccessLevel = "None"
	// Read specifies the read state for access level.
	Read AccessLevel = "Read"
)

// CachingTypes enumerates the values for caching types.
type CachingTypes string

const (
	// CachingTypesNone specifies the caching types none state for caching types.
	CachingTypesNone CachingTypes = "None"
	// CachingTypesReadOnly specifies the caching types read only state for caching types.
	CachingTypesReadOnly CachingTypes = "ReadOnly"
	// CachingTypesReadWrite specifies the caching types read write state for caching types.
	CachingTypesReadWrite CachingTypes = "ReadWrite"
)

// ComponentNames enumerates the values for component names.
type ComponentNames string

const (
	// MicrosoftWindowsShellSetup specifies the microsoft windows shell setup state for component names.
	MicrosoftWindowsShellSetup ComponentNames = "Microsoft-Windows-Shell-Setup"
)

// ContainerServiceOrchestratorTypes enumerates the values for container service orchestrator types.
type ContainerServiceOrchestratorTypes string

const (
	// Custom specifies the custom state for container service orchestrator types.
	Custom ContainerServiceOrchestratorTypes = "Custom"
	// DCOS specifies the dcos state for container service orchestrator types.
	DCOS ContainerServiceOrchestratorTypes = "DCOS"
	// Kubernetes specifies the kubernetes state for container service orchestrator types.
	Kubernetes ContainerServiceOrchestratorTypes = "Kubernetes"
	// Swarm specifies the swarm state for container service orchestrator types.
	Swarm ContainerServiceOrchestratorTypes = "Swarm"
)

// ContainerServiceVMSizeTypes enumerates the values for container service vm size types.
type ContainerServiceVMSizeTypes string

const (
	// StandardA0 specifies the standard a0 state for container service vm size types.
	StandardA0 ContainerServiceVMSizeTypes = "Standard_A0"
	// StandardA1 specifies the standard a1 state for container service vm size types.
	StandardA1 ContainerServiceVMSizeTypes = "Standard_A1"
	// StandardA10 specifies the standard a10 state for container service vm size types.
	StandardA10 ContainerServiceVMSizeTypes = "Standard_A10"
	// StandardA11 specifies the standard a11 state for container service vm size types.
	StandardA11 ContainerServiceVMSizeTypes = "Standard_A11"
	// StandardA2 specifies the standard a2 state for container service vm size types.
	StandardA2 ContainerServiceVMSizeTypes = "Standard_A2"
	// StandardA3 specifies the standard a3 state for container service vm size types.
	StandardA3 ContainerServiceVMSizeTypes = "Standard_A3"
	// StandardA4 specifies the standard a4 state for container service vm size types.
	StandardA4 ContainerServiceVMSizeTypes = "Standard_A4"
	// StandardA5 specifies the standard a5 state for container service vm size types.
	StandardA5 ContainerServiceVMSizeTypes = "Standard_A5"
	// StandardA6 specifies the standard a6 state for container service vm size types.
	StandardA6 ContainerServiceVMSizeTypes = "Standard_A6"
	// StandardA7 specifies the standard a7 state for container service vm size types.
	StandardA7 ContainerServiceVMSizeTypes = "Standard_A7"
	// StandardA8 specifies the standard a8 state for container service vm size types.
	StandardA8 ContainerServiceVMSizeTypes = "Standard_A8"
	// StandardA9 specifies the standard a9 state for container service vm size types.
	StandardA9 ContainerServiceVMSizeTypes = "Standard_A9"
	// StandardD1 specifies the standard d1 state for container service vm size types.
	StandardD1 ContainerServiceVMSizeTypes = "Standard_D1"
	// StandardD11 specifies the standard d11 state for container service vm size types.
	StandardD11 ContainerServiceVMSizeTypes = "Standard_D11"
	// StandardD11V2 specifies the standard d11v2 state for container service vm size types.
	StandardD11V2 ContainerServiceVMSizeTypes = "Standard_D11_v2"
	// StandardD12 specifies the standard d12 state for container service vm size types.
	StandardD12 ContainerServiceVMSizeTypes = "Standard_D12"
	// StandardD12V2 specifies the standard d12v2 state for container service vm size types.
	StandardD12V2 ContainerServiceVMSizeTypes = "Standard_D12_v2"
	// StandardD13 specifies the standard d13 state for container service vm size types.
	StandardD13 ContainerServiceVMSizeTypes = "Standard_D13"
	// StandardD13V2 specifies the standard d13v2 state for container service vm size types.
	StandardD13V2 ContainerServiceVMSizeTypes = "Standard_D13_v2"
	// StandardD14 specifies the standard d14 state for container service vm size types.
	StandardD14 ContainerServiceVMSizeTypes = "Standard_D14"
	// StandardD14V2 specifies the standard d14v2 state for container service vm size types.
	StandardD14V2 ContainerServiceVMSizeTypes = "Standard_D14_v2"
	// StandardD1V2 specifies the standard d1v2 state for container service vm size types.
	StandardD1V2 ContainerServiceVMSizeTypes = "Standard_D1_v2"
	// StandardD2 specifies the standard d2 state for container service vm size types.
	StandardD2 ContainerServiceVMSizeTypes = "Standard_D2"
	// StandardD2V2 specifies the standard d2v2 state for container service vm size types.
	StandardD2V2 ContainerServiceVMSizeTypes = "Standard_D2_v2"
	// StandardD3 specifies the standard d3 state for container service vm size types.
	StandardD3 ContainerServiceVMSizeTypes = "Standard_D3"
	// StandardD3V2 specifies the standard d3v2 state for container service vm size types.
	StandardD3V2 ContainerServiceVMSizeTypes = "Standard_D3_v2"
	// StandardD4 specifies the standard d4 state for container service vm size types.
	StandardD4 ContainerServiceVMSizeTypes = "Standard_D4"
	// StandardD4V2 specifies the standard d4v2 state for container service vm size types.
	StandardD4V2 ContainerServiceVMSizeTypes = "Standard_D4_v2"
	// StandardD5V2 specifies the standard d5v2 state for container service vm size types.
	StandardD5V2 ContainerServiceVMSizeTypes = "Standard_D5_v2"
	// StandardDS1 specifies the standard ds1 state for container service vm size types.
	StandardDS1 ContainerServiceVMSizeTypes = "Standard_DS1"
	// StandardDS11 specifies the standard ds11 state for container service vm size types.
	StandardDS11 ContainerServiceVMSizeTypes = "Standard_DS11"
	// StandardDS12 specifies the standard ds12 state for container service vm size types.
	StandardDS12 ContainerServiceVMSizeTypes = "Standard_DS12"
	// StandardDS13 specifies the standard ds13 state for container service vm size types.
	StandardDS13 ContainerServiceVMSizeTypes = "Standard_DS13"
	// StandardDS14 specifies the standard ds14 state for container service vm size types.
	StandardDS14 ContainerServiceVMSizeTypes = "Standard_DS14"
	// StandardDS2 specifies the standard ds2 state for container service vm size types.
	StandardDS2 ContainerServiceVMSizeTypes = "Standard_DS2"
	// StandardDS3 specifies the standard ds3 state for container service vm size types.
	StandardDS3 ContainerServiceVMSizeTypes = "Standard_DS3"
	// StandardDS4 specifies the standard ds4 state for container service vm size types.
	StandardDS4 ContainerServiceVMSizeTypes = "Standard_DS4"
	// StandardG1 specifies the standard g1 state for container service vm size types.
	StandardG1 ContainerServiceVMSizeTypes = "Standard_G1"
	// StandardG2 specifies the standard g2 state for container service vm size types.
	StandardG2 ContainerServiceVMSizeTypes = "Standard_G2"
	// StandardG3 specifies the standard g3 state for container service vm size types.
	StandardG3 ContainerServiceVMSizeTypes = "Standard_G3"
	// StandardG4 specifies the standard g4 state for container service vm size types.
	StandardG4 ContainerServiceVMSizeTypes = "Standard_G4"
	// StandardG5 specifies the standard g5 state for container service vm size types.
	StandardG5 ContainerServiceVMSizeTypes = "Standard_G5"
	// StandardGS1 specifies the standard gs1 state for container service vm size types.
	StandardGS1 ContainerServiceVMSizeTypes = "Standard_GS1"
	// StandardGS2 specifies the standard gs2 state for container service vm size types.
	StandardGS2 ContainerServiceVMSizeTypes = "Standard_GS2"
	// StandardGS3 specifies the standard gs3 state for container service vm size types.
	StandardGS3 ContainerServiceVMSizeTypes = "Standard_GS3"
	// StandardGS4 specifies the standard gs4 state for container service vm size types.
	StandardGS4 ContainerServiceVMSizeTypes = "Standard_GS4"
	// StandardGS5 specifies the standard gs5 state for container service vm size types.
	StandardGS5 ContainerServiceVMSizeTypes = "Standard_GS5"
)

// DiskCreateOption enumerates the values for disk create option.
type DiskCreateOption string

const (
	// Attach specifies the attach state for disk create option.
	Attach DiskCreateOption = "Attach"
	// Copy specifies the copy state for disk create option.
	Copy DiskCreateOption = "Copy"
	// Empty specifies the empty state for disk create option.
	Empty DiskCreateOption = "Empty"
	// FromImage specifies the from image state for disk create option.
	FromImage DiskCreateOption = "FromImage"
	// Import specifies the import state for disk create option.
	Import DiskCreateOption = "Import"
)

// DiskCreateOptionTypes enumerates the values for disk create option types.
type DiskCreateOptionTypes string

const (
	// DiskCreateOptionTypesAttach specifies the disk create option types attach state for disk create option types.
	DiskCreateOptionTypesAttach DiskCreateOptionTypes = "Attach"
	// DiskCreateOptionTypesEmpty specifies the disk create option types empty state for disk create option types.
	DiskCreateOptionTypesEmpty DiskCreateOptionTypes = "Empty"
	// DiskCreateOptionTypesFromImage specifies the disk create option types from image state for disk create option types.
	DiskCreateOptionTypesFromImage DiskCreateOptionTypes = "FromImage"
)

// InstanceViewTypes enumerates the values for instance view types.
type InstanceViewTypes string

const (
	// InstanceView specifies the instance view state for instance view types.
	InstanceView InstanceViewTypes = "instanceView"
)

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPv4 specifies the i pv 4 state for ip version.
	IPv4 IPVersion = "IPv4"
	// IPv6 specifies the i pv 6 state for ip version.
	IPv6 IPVersion = "IPv6"
)

// MaintenanceOperationResultCodeTypes enumerates the values for maintenance operation result code types.
type MaintenanceOperationResultCodeTypes string

const (
	// MaintenanceOperationResultCodeTypesMaintenanceAborted specifies the maintenance operation result code types
	// maintenance aborted state for maintenance operation result code types.
	MaintenanceOperationResultCodeTypesMaintenanceAborted MaintenanceOperationResultCodeTypes = "MaintenanceAborted"
	// MaintenanceOperationResultCodeTypesMaintenanceCompleted specifies the maintenance operation result code types
	// maintenance completed state for maintenance operation result code types.
	MaintenanceOperationResultCodeTypesMaintenanceCompleted MaintenanceOperationResultCodeTypes = "MaintenanceCompleted"
	// MaintenanceOperationResultCodeTypesNone specifies the maintenance operation result code types none state for
	// maintenance operation result code types.
	MaintenanceOperationResultCodeTypesNone MaintenanceOperationResultCodeTypes = "None"
	// MaintenanceOperationResultCodeTypesRetryLater specifies the maintenance operation result code types retry later
	// state for maintenance operation result code types.
	MaintenanceOperationResultCodeTypesRetryLater MaintenanceOperationResultCodeTypes = "RetryLater"
)

// OperatingSystemStateTypes enumerates the values for operating system state types.
type OperatingSystemStateTypes string

const (
	// Generalized specifies the generalized state for operating system state types.
	Generalized OperatingSystemStateTypes = "Generalized"
	// Specialized specifies the specialized state for operating system state types.
	Specialized OperatingSystemStateTypes = "Specialized"
)

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// Linux specifies the linux state for operating system types.
	Linux OperatingSystemTypes = "Linux"
	// Windows specifies the windows state for operating system types.
	Windows OperatingSystemTypes = "Windows"
)

// PassNames enumerates the values for pass names.
type PassNames string

const (
	// OobeSystem specifies the oobe system state for pass names.
	OobeSystem PassNames = "OobeSystem"
)

// ProtocolTypes enumerates the values for protocol types.
type ProtocolTypes string

const (
	// HTTP specifies the http state for protocol types.
	HTTP ProtocolTypes = "Http"
	// HTTPS specifies the https state for protocol types.
	HTTPS ProtocolTypes = "Https"
)

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// SystemAssigned specifies the system assigned state for resource identity type.
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic specifies the resource sku capacity scale type automatic state for resource
	// sku capacity scale type.
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "Automatic"
	// ResourceSkuCapacityScaleTypeManual specifies the resource sku capacity scale type manual state for resource sku
	// capacity scale type.
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "Manual"
	// ResourceSkuCapacityScaleTypeNone specifies the resource sku capacity scale type none state for resource sku capacity
	// scale type.
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "None"
)

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// NotAvailableForSubscription specifies the not available for subscription state for resource sku restrictions reason
	// code.
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// QuotaID specifies the quota id state for resource sku restrictions reason code.
	QuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// Location specifies the location state for resource sku restrictions type.
	Location ResourceSkuRestrictionsType = "Location"
)

// RollingUpgradeActionType enumerates the values for rolling upgrade action type.
type RollingUpgradeActionType string

const (
	// Cancel specifies the cancel state for rolling upgrade action type.
	Cancel RollingUpgradeActionType = "Cancel"
	// Start specifies the start state for rolling upgrade action type.
	Start RollingUpgradeActionType = "Start"
)

// RollingUpgradeStatusCode enumerates the values for rolling upgrade status code.
type RollingUpgradeStatusCode string

const (
	// Cancelled specifies the cancelled state for rolling upgrade status code.
	Cancelled RollingUpgradeStatusCode = "Cancelled"
	// Completed specifies the completed state for rolling upgrade status code.
	Completed RollingUpgradeStatusCode = "Completed"
	// Faulted specifies the faulted state for rolling upgrade status code.
	Faulted RollingUpgradeStatusCode = "Faulted"
	// RollingForward specifies the rolling forward state for rolling upgrade status code.
	RollingForward RollingUpgradeStatusCode = "RollingForward"
)

// SettingNames enumerates the values for setting names.
type SettingNames string

const (
	// AutoLogon specifies the auto logon state for setting names.
	AutoLogon SettingNames = "AutoLogon"
	// FirstLogonCommands specifies the first logon commands state for setting names.
	FirstLogonCommands SettingNames = "FirstLogonCommands"
)

// StatusLevelTypes enumerates the values for status level types.
type StatusLevelTypes string

const (
	// Error specifies the error state for status level types.
	Error StatusLevelTypes = "Error"
	// Info specifies the info state for status level types.
	Info StatusLevelTypes = "Info"
	// Warning specifies the warning state for status level types.
	Warning StatusLevelTypes = "Warning"
)

// StorageAccountTypes enumerates the values for storage account types.
type StorageAccountTypes string

const (
	// PremiumLRS specifies the premium lrs state for storage account types.
	PremiumLRS StorageAccountTypes = "Premium_LRS"
	// StandardLRS specifies the standard lrs state for storage account types.
	StandardLRS StorageAccountTypes = "Standard_LRS"
)

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// Automatic specifies the automatic state for upgrade mode.
	Automatic UpgradeMode = "Automatic"
	// Manual specifies the manual state for upgrade mode.
	Manual UpgradeMode = "Manual"
	// Rolling specifies the rolling state for upgrade mode.
	Rolling UpgradeMode = "Rolling"
)

// VirtualMachineScaleSetSkuScaleType enumerates the values for virtual machine scale set sku scale type.
type VirtualMachineScaleSetSkuScaleType string

const (
	// VirtualMachineScaleSetSkuScaleTypeAutomatic specifies the virtual machine scale set sku scale type automatic state
	// for virtual machine scale set sku scale type.
	VirtualMachineScaleSetSkuScaleTypeAutomatic VirtualMachineScaleSetSkuScaleType = "Automatic"
	// VirtualMachineScaleSetSkuScaleTypeNone specifies the virtual machine scale set sku scale type none state for virtual
	// machine scale set sku scale type.
	VirtualMachineScaleSetSkuScaleTypeNone VirtualMachineScaleSetSkuScaleType = "None"
)

// VirtualMachineSizeTypes enumerates the values for virtual machine size types.
type VirtualMachineSizeTypes string

const (
	// VirtualMachineSizeTypesBasicA0 specifies the virtual machine size types basic a0 state for virtual machine size
	// types.
	VirtualMachineSizeTypesBasicA0 VirtualMachineSizeTypes = "Basic_A0"
	// VirtualMachineSizeTypesBasicA1 specifies the virtual machine size types basic a1 state for virtual machine size
	// types.
	VirtualMachineSizeTypesBasicA1 VirtualMachineSizeTypes = "Basic_A1"
	// VirtualMachineSizeTypesBasicA2 specifies the virtual machine size types basic a2 state for virtual machine size
	// types.
	VirtualMachineSizeTypesBasicA2 VirtualMachineSizeTypes = "Basic_A2"
	// VirtualMachineSizeTypesBasicA3 specifies the virtual machine size types basic a3 state for virtual machine size
	// types.
	VirtualMachineSizeTypesBasicA3 VirtualMachineSizeTypes = "Basic_A3"
	// VirtualMachineSizeTypesBasicA4 specifies the virtual machine size types basic a4 state for virtual machine size
	// types.
	VirtualMachineSizeTypesBasicA4 VirtualMachineSizeTypes = "Basic_A4"
	// VirtualMachineSizeTypesStandardA0 specifies the virtual machine size types standard a0 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA0 VirtualMachineSizeTypes = "Standard_A0"
	// VirtualMachineSizeTypesStandardA1 specifies the virtual machine size types standard a1 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA1 VirtualMachineSizeTypes = "Standard_A1"
	// VirtualMachineSizeTypesStandardA10 specifies the virtual machine size types standard a10 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA10 VirtualMachineSizeTypes = "Standard_A10"
	// VirtualMachineSizeTypesStandardA11 specifies the virtual machine size types standard a11 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA11 VirtualMachineSizeTypes = "Standard_A11"
	// VirtualMachineSizeTypesStandardA1V2 specifies the virtual machine size types standard a1v2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA1V2 VirtualMachineSizeTypes = "Standard_A1_v2"
	// VirtualMachineSizeTypesStandardA2 specifies the virtual machine size types standard a2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA2 VirtualMachineSizeTypes = "Standard_A2"
	// VirtualMachineSizeTypesStandardA2mV2 specifies the virtual machine size types standard a2mv2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardA2mV2 VirtualMachineSizeTypes = "Standard_A2m_v2"
	// VirtualMachineSizeTypesStandardA2V2 specifies the virtual machine size types standard a2v2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA2V2 VirtualMachineSizeTypes = "Standard_A2_v2"
	// VirtualMachineSizeTypesStandardA3 specifies the virtual machine size types standard a3 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA3 VirtualMachineSizeTypes = "Standard_A3"
	// VirtualMachineSizeTypesStandardA4 specifies the virtual machine size types standard a4 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA4 VirtualMachineSizeTypes = "Standard_A4"
	// VirtualMachineSizeTypesStandardA4mV2 specifies the virtual machine size types standard a4mv2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardA4mV2 VirtualMachineSizeTypes = "Standard_A4m_v2"
	// VirtualMachineSizeTypesStandardA4V2 specifies the virtual machine size types standard a4v2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA4V2 VirtualMachineSizeTypes = "Standard_A4_v2"
	// VirtualMachineSizeTypesStandardA5 specifies the virtual machine size types standard a5 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA5 VirtualMachineSizeTypes = "Standard_A5"
	// VirtualMachineSizeTypesStandardA6 specifies the virtual machine size types standard a6 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA6 VirtualMachineSizeTypes = "Standard_A6"
	// VirtualMachineSizeTypesStandardA7 specifies the virtual machine size types standard a7 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA7 VirtualMachineSizeTypes = "Standard_A7"
	// VirtualMachineSizeTypesStandardA8 specifies the virtual machine size types standard a8 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA8 VirtualMachineSizeTypes = "Standard_A8"
	// VirtualMachineSizeTypesStandardA8mV2 specifies the virtual machine size types standard a8mv2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardA8mV2 VirtualMachineSizeTypes = "Standard_A8m_v2"
	// VirtualMachineSizeTypesStandardA8V2 specifies the virtual machine size types standard a8v2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA8V2 VirtualMachineSizeTypes = "Standard_A8_v2"
	// VirtualMachineSizeTypesStandardA9 specifies the virtual machine size types standard a9 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardA9 VirtualMachineSizeTypes = "Standard_A9"
	// VirtualMachineSizeTypesStandardD1 specifies the virtual machine size types standard d1 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD1 VirtualMachineSizeTypes = "Standard_D1"
	// VirtualMachineSizeTypesStandardD11 specifies the virtual machine size types standard d11 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD11 VirtualMachineSizeTypes = "Standard_D11"
	// VirtualMachineSizeTypesStandardD11V2 specifies the virtual machine size types standard d11v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardD11V2 VirtualMachineSizeTypes = "Standard_D11_v2"
	// VirtualMachineSizeTypesStandardD12 specifies the virtual machine size types standard d12 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD12 VirtualMachineSizeTypes = "Standard_D12"
	// VirtualMachineSizeTypesStandardD12V2 specifies the virtual machine size types standard d12v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardD12V2 VirtualMachineSizeTypes = "Standard_D12_v2"
	// VirtualMachineSizeTypesStandardD13 specifies the virtual machine size types standard d13 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD13 VirtualMachineSizeTypes = "Standard_D13"
	// VirtualMachineSizeTypesStandardD13V2 specifies the virtual machine size types standard d13v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardD13V2 VirtualMachineSizeTypes = "Standard_D13_v2"
	// VirtualMachineSizeTypesStandardD14 specifies the virtual machine size types standard d14 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD14 VirtualMachineSizeTypes = "Standard_D14"
	// VirtualMachineSizeTypesStandardD14V2 specifies the virtual machine size types standard d14v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardD14V2 VirtualMachineSizeTypes = "Standard_D14_v2"
	// VirtualMachineSizeTypesStandardD15V2 specifies the virtual machine size types standard d15v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardD15V2 VirtualMachineSizeTypes = "Standard_D15_v2"
	// VirtualMachineSizeTypesStandardD1V2 specifies the virtual machine size types standard d1v2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD1V2 VirtualMachineSizeTypes = "Standard_D1_v2"
	// VirtualMachineSizeTypesStandardD2 specifies the virtual machine size types standard d2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD2 VirtualMachineSizeTypes = "Standard_D2"
	// VirtualMachineSizeTypesStandardD2V2 specifies the virtual machine size types standard d2v2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD2V2 VirtualMachineSizeTypes = "Standard_D2_v2"
	// VirtualMachineSizeTypesStandardD3 specifies the virtual machine size types standard d3 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD3 VirtualMachineSizeTypes = "Standard_D3"
	// VirtualMachineSizeTypesStandardD3V2 specifies the virtual machine size types standard d3v2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD3V2 VirtualMachineSizeTypes = "Standard_D3_v2"
	// VirtualMachineSizeTypesStandardD4 specifies the virtual machine size types standard d4 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD4 VirtualMachineSizeTypes = "Standard_D4"
	// VirtualMachineSizeTypesStandardD4V2 specifies the virtual machine size types standard d4v2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD4V2 VirtualMachineSizeTypes = "Standard_D4_v2"
	// VirtualMachineSizeTypesStandardD5V2 specifies the virtual machine size types standard d5v2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardD5V2 VirtualMachineSizeTypes = "Standard_D5_v2"
	// VirtualMachineSizeTypesStandardDS1 specifies the virtual machine size types standard ds1 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardDS1 VirtualMachineSizeTypes = "Standard_DS1"
	// VirtualMachineSizeTypesStandardDS11 specifies the virtual machine size types standard ds11 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardDS11 VirtualMachineSizeTypes = "Standard_DS11"
	// VirtualMachineSizeTypesStandardDS11V2 specifies the virtual machine size types standard ds11v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS11V2 VirtualMachineSizeTypes = "Standard_DS11_v2"
	// VirtualMachineSizeTypesStandardDS12 specifies the virtual machine size types standard ds12 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardDS12 VirtualMachineSizeTypes = "Standard_DS12"
	// VirtualMachineSizeTypesStandardDS12V2 specifies the virtual machine size types standard ds12v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS12V2 VirtualMachineSizeTypes = "Standard_DS12_v2"
	// VirtualMachineSizeTypesStandardDS13 specifies the virtual machine size types standard ds13 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardDS13 VirtualMachineSizeTypes = "Standard_DS13"
	// VirtualMachineSizeTypesStandardDS13V2 specifies the virtual machine size types standard ds13v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS13V2 VirtualMachineSizeTypes = "Standard_DS13_v2"
	// VirtualMachineSizeTypesStandardDS14 specifies the virtual machine size types standard ds14 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardDS14 VirtualMachineSizeTypes = "Standard_DS14"
	// VirtualMachineSizeTypesStandardDS14V2 specifies the virtual machine size types standard ds14v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS14V2 VirtualMachineSizeTypes = "Standard_DS14_v2"
	// VirtualMachineSizeTypesStandardDS15V2 specifies the virtual machine size types standard ds15v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS15V2 VirtualMachineSizeTypes = "Standard_DS15_v2"
	// VirtualMachineSizeTypesStandardDS1V2 specifies the virtual machine size types standard ds1v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS1V2 VirtualMachineSizeTypes = "Standard_DS1_v2"
	// VirtualMachineSizeTypesStandardDS2 specifies the virtual machine size types standard ds2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardDS2 VirtualMachineSizeTypes = "Standard_DS2"
	// VirtualMachineSizeTypesStandardDS2V2 specifies the virtual machine size types standard ds2v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS2V2 VirtualMachineSizeTypes = "Standard_DS2_v2"
	// VirtualMachineSizeTypesStandardDS3 specifies the virtual machine size types standard ds3 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardDS3 VirtualMachineSizeTypes = "Standard_DS3"
	// VirtualMachineSizeTypesStandardDS3V2 specifies the virtual machine size types standard ds3v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS3V2 VirtualMachineSizeTypes = "Standard_DS3_v2"
	// VirtualMachineSizeTypesStandardDS4 specifies the virtual machine size types standard ds4 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardDS4 VirtualMachineSizeTypes = "Standard_DS4"
	// VirtualMachineSizeTypesStandardDS4V2 specifies the virtual machine size types standard ds4v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS4V2 VirtualMachineSizeTypes = "Standard_DS4_v2"
	// VirtualMachineSizeTypesStandardDS5V2 specifies the virtual machine size types standard ds5v2 state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardDS5V2 VirtualMachineSizeTypes = "Standard_DS5_v2"
	// VirtualMachineSizeTypesStandardF1 specifies the virtual machine size types standard f1 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF1 VirtualMachineSizeTypes = "Standard_F1"
	// VirtualMachineSizeTypesStandardF16 specifies the virtual machine size types standard f16 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF16 VirtualMachineSizeTypes = "Standard_F16"
	// VirtualMachineSizeTypesStandardF16s specifies the virtual machine size types standard f16s state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF16s VirtualMachineSizeTypes = "Standard_F16s"
	// VirtualMachineSizeTypesStandardF1s specifies the virtual machine size types standard f1s state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF1s VirtualMachineSizeTypes = "Standard_F1s"
	// VirtualMachineSizeTypesStandardF2 specifies the virtual machine size types standard f2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF2 VirtualMachineSizeTypes = "Standard_F2"
	// VirtualMachineSizeTypesStandardF2s specifies the virtual machine size types standard f2s state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF2s VirtualMachineSizeTypes = "Standard_F2s"
	// VirtualMachineSizeTypesStandardF4 specifies the virtual machine size types standard f4 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF4 VirtualMachineSizeTypes = "Standard_F4"
	// VirtualMachineSizeTypesStandardF4s specifies the virtual machine size types standard f4s state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF4s VirtualMachineSizeTypes = "Standard_F4s"
	// VirtualMachineSizeTypesStandardF8 specifies the virtual machine size types standard f8 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF8 VirtualMachineSizeTypes = "Standard_F8"
	// VirtualMachineSizeTypesStandardF8s specifies the virtual machine size types standard f8s state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardF8s VirtualMachineSizeTypes = "Standard_F8s"
	// VirtualMachineSizeTypesStandardG1 specifies the virtual machine size types standard g1 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardG1 VirtualMachineSizeTypes = "Standard_G1"
	// VirtualMachineSizeTypesStandardG2 specifies the virtual machine size types standard g2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardG2 VirtualMachineSizeTypes = "Standard_G2"
	// VirtualMachineSizeTypesStandardG3 specifies the virtual machine size types standard g3 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardG3 VirtualMachineSizeTypes = "Standard_G3"
	// VirtualMachineSizeTypesStandardG4 specifies the virtual machine size types standard g4 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardG4 VirtualMachineSizeTypes = "Standard_G4"
	// VirtualMachineSizeTypesStandardG5 specifies the virtual machine size types standard g5 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardG5 VirtualMachineSizeTypes = "Standard_G5"
	// VirtualMachineSizeTypesStandardGS1 specifies the virtual machine size types standard gs1 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardGS1 VirtualMachineSizeTypes = "Standard_GS1"
	// VirtualMachineSizeTypesStandardGS2 specifies the virtual machine size types standard gs2 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardGS2 VirtualMachineSizeTypes = "Standard_GS2"
	// VirtualMachineSizeTypesStandardGS3 specifies the virtual machine size types standard gs3 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardGS3 VirtualMachineSizeTypes = "Standard_GS3"
	// VirtualMachineSizeTypesStandardGS4 specifies the virtual machine size types standard gs4 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardGS4 VirtualMachineSizeTypes = "Standard_GS4"
	// VirtualMachineSizeTypesStandardGS5 specifies the virtual machine size types standard gs5 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardGS5 VirtualMachineSizeTypes = "Standard_GS5"
	// VirtualMachineSizeTypesStandardH16 specifies the virtual machine size types standard h16 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardH16 VirtualMachineSizeTypes = "Standard_H16"
	// VirtualMachineSizeTypesStandardH16m specifies the virtual machine size types standard h16m state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardH16m VirtualMachineSizeTypes = "Standard_H16m"
	// VirtualMachineSizeTypesStandardH16mr specifies the virtual machine size types standard h16mr state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardH16mr VirtualMachineSizeTypes = "Standard_H16mr"
	// VirtualMachineSizeTypesStandardH16r specifies the virtual machine size types standard h16r state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardH16r VirtualMachineSizeTypes = "Standard_H16r"
	// VirtualMachineSizeTypesStandardH8 specifies the virtual machine size types standard h8 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardH8 VirtualMachineSizeTypes = "Standard_H8"
	// VirtualMachineSizeTypesStandardH8m specifies the virtual machine size types standard h8m state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardH8m VirtualMachineSizeTypes = "Standard_H8m"
	// VirtualMachineSizeTypesStandardL16s specifies the virtual machine size types standard l16s state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardL16s VirtualMachineSizeTypes = "Standard_L16s"
	// VirtualMachineSizeTypesStandardL32s specifies the virtual machine size types standard l32s state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardL32s VirtualMachineSizeTypes = "Standard_L32s"
	// VirtualMachineSizeTypesStandardL4s specifies the virtual machine size types standard l4s state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardL4s VirtualMachineSizeTypes = "Standard_L4s"
	// VirtualMachineSizeTypesStandardL8s specifies the virtual machine size types standard l8s state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardL8s VirtualMachineSizeTypes = "Standard_L8s"
	// VirtualMachineSizeTypesStandardNC12 specifies the virtual machine size types standard nc12 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardNC12 VirtualMachineSizeTypes = "Standard_NC12"
	// VirtualMachineSizeTypesStandardNC24 specifies the virtual machine size types standard nc24 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardNC24 VirtualMachineSizeTypes = "Standard_NC24"
	// VirtualMachineSizeTypesStandardNC24r specifies the virtual machine size types standard nc24r state for virtual
	// machine size types.
	VirtualMachineSizeTypesStandardNC24r VirtualMachineSizeTypes = "Standard_NC24r"
	// VirtualMachineSizeTypesStandardNC6 specifies the virtual machine size types standard nc6 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardNC6 VirtualMachineSizeTypes = "Standard_NC6"
	// VirtualMachineSizeTypesStandardNV12 specifies the virtual machine size types standard nv12 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardNV12 VirtualMachineSizeTypes = "Standard_NV12"
	// VirtualMachineSizeTypesStandardNV24 specifies the virtual machine size types standard nv24 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardNV24 VirtualMachineSizeTypes = "Standard_NV24"
	// VirtualMachineSizeTypesStandardNV6 specifies the virtual machine size types standard nv6 state for virtual machine
	// size types.
	VirtualMachineSizeTypesStandardNV6 VirtualMachineSizeTypes = "Standard_NV6"
)

// AccessURI is a disk access SAS uri.
type AccessURI struct {
	autorest.Response `json:"-"`
	*AccessURIOutput  `json:"properties,omitempty"`
}

// AccessURIOutput is azure properties, including output.
type AccessURIOutput struct {
	*AccessURIRaw `json:"output,omitempty"`
}

// AccessURIRaw is this object gets 'bubbled up' through flattening.
type AccessURIRaw struct {
	AccessSAS *string `json:"accessSAS,omitempty"`
}

// AdditionalUnattendContent is specifies additional XML formatted information that can be included in the Unattend.xml
// file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which
// the content is applied.
type AdditionalUnattendContent struct {
	PassName      PassNames      `json:"passName,omitempty"`
	ComponentName ComponentNames `json:"componentName,omitempty"`
	SettingName   SettingNames   `json:"settingName,omitempty"`
	Content       *string        `json:"content,omitempty"`
}

// APIEntityReference is the API entity reference.
type APIEntityReference struct {
	ID *string `json:"id,omitempty"`
}

// APIError is api error.
type APIError struct {
	Details    *[]APIErrorBase `json:"details,omitempty"`
	Innererror *InnerError     `json:"innererror,omitempty"`
	Code       *string         `json:"code,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Message    *string         `json:"message,omitempty"`
}

// APIErrorBase is api error base.
type APIErrorBase struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// AvailabilitySet is specifies information about the availability set that the virtual machine should be assigned to.
// Virtual machines specified in the same availability set are allocated to different nodes to maximize availability.
// For more information about availability sets, see [Manage the availability of virtual
// machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
// <br><br> For more information on Azure planned maintainance, see [Planned maintenance for virtual machines in
// Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
// <br><br> Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to
// an availability set.
type AvailabilitySet struct {
	autorest.Response          `json:"-"`
	ID                         *string             `json:"id,omitempty"`
	Name                       *string             `json:"name,omitempty"`
	Type                       *string             `json:"type,omitempty"`
	Location                   *string             `json:"location,omitempty"`
	Tags                       *map[string]*string `json:"tags,omitempty"`
	*AvailabilitySetProperties `json:"properties,omitempty"`
	Sku                        *Sku `json:"sku,omitempty"`
}

// AvailabilitySetListResult is the List Availability Set operation response.
type AvailabilitySetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]AvailabilitySet `json:"value,omitempty"`
}

// AvailabilitySetProperties is the instance view of a resource.
type AvailabilitySetProperties struct {
	PlatformUpdateDomainCount *int32                `json:"platformUpdateDomainCount,omitempty"`
	PlatformFaultDomainCount  *int32                `json:"platformFaultDomainCount,omitempty"`
	VirtualMachines           *[]SubResource        `json:"virtualMachines,omitempty"`
	Statuses                  *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// BootDiagnostics is boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to
// diagnose VM status. <br><br> For Linux Virtual Machines, you can easily view the output of your console log.
// <br><br> For both Windows and Linux virtual machines, Azure also enables you to see a screenshot of the VM from the
// hypervisor.
type BootDiagnostics struct {
	Enabled    *bool   `json:"enabled,omitempty"`
	StorageURI *string `json:"storageUri,omitempty"`
}

// BootDiagnosticsInstanceView is the instance view of a virtual machine boot diagnostics.
type BootDiagnosticsInstanceView struct {
	ConsoleScreenshotBlobURI *string `json:"consoleScreenshotBlobUri,omitempty"`
	SerialConsoleLogBlobURI  *string `json:"serialConsoleLogBlobUri,omitempty"`
}

// ContainerService is container service.
type ContainerService struct {
	autorest.Response           `json:"-"`
	ID                          *string             `json:"id,omitempty"`
	Name                        *string             `json:"name,omitempty"`
	Type                        *string             `json:"type,omitempty"`
	Location                    *string             `json:"location,omitempty"`
	Tags                        *map[string]*string `json:"tags,omitempty"`
	*ContainerServiceProperties `json:"properties,omitempty"`
}

// ContainerServiceAgentPoolProfile is profile for the container service agent pool.
type ContainerServiceAgentPoolProfile struct {
	Name      *string                     `json:"name,omitempty"`
	Count     *int32                      `json:"count,omitempty"`
	VMSize    ContainerServiceVMSizeTypes `json:"vmSize,omitempty"`
	DNSPrefix *string                     `json:"dnsPrefix,omitempty"`
	Fqdn      *string                     `json:"fqdn,omitempty"`
}

// ContainerServiceCustomProfile is properties to configure a custom container service cluster.
type ContainerServiceCustomProfile struct {
	Orchestrator *string `json:"orchestrator,omitempty"`
}

// ContainerServiceDiagnosticsProfile is
type ContainerServiceDiagnosticsProfile struct {
	VMDiagnostics *ContainerServiceVMDiagnostics `json:"vmDiagnostics,omitempty"`
}

// ContainerServiceLinuxProfile is profile for Linux VMs in the container service cluster.
type ContainerServiceLinuxProfile struct {
	AdminUsername *string                           `json:"adminUsername,omitempty"`
	SSH           *ContainerServiceSSHConfiguration `json:"ssh,omitempty"`
}

// ContainerServiceListResult is the response from the List Container Services operation.
type ContainerServiceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ContainerService `json:"value,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// ContainerServiceListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ContainerServiceListResult) ContainerServiceListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ContainerServiceMasterProfile is profile for the container service master.
type ContainerServiceMasterProfile struct {
	Count     *int32  `json:"count,omitempty"`
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	Fqdn      *string `json:"fqdn,omitempty"`
}

// ContainerServiceOrchestratorProfile is profile for the container service orchestrator.
type ContainerServiceOrchestratorProfile struct {
	OrchestratorType ContainerServiceOrchestratorTypes `json:"orchestratorType,omitempty"`
}

// ContainerServiceProperties is properties of the container service.
type ContainerServiceProperties struct {
	ProvisioningState       *string                                  `json:"provisioningState,omitempty"`
	OrchestratorProfile     *ContainerServiceOrchestratorProfile     `json:"orchestratorProfile,omitempty"`
	CustomProfile           *ContainerServiceCustomProfile           `json:"customProfile,omitempty"`
	ServicePrincipalProfile *ContainerServiceServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`
	MasterProfile           *ContainerServiceMasterProfile           `json:"masterProfile,omitempty"`
	AgentPoolProfiles       *[]ContainerServiceAgentPoolProfile      `json:"agentPoolProfiles,omitempty"`
	WindowsProfile          *ContainerServiceWindowsProfile          `json:"windowsProfile,omitempty"`
	LinuxProfile            *ContainerServiceLinuxProfile            `json:"linuxProfile,omitempty"`
	DiagnosticsProfile      *ContainerServiceDiagnosticsProfile      `json:"diagnosticsProfile,omitempty"`
}

// ContainerServiceServicePrincipalProfile is information about a service principal identity for the cluster to use for
// manipulating Azure APIs.
type ContainerServiceServicePrincipalProfile struct {
	ClientID *string `json:"clientId,omitempty"`
	Secret   *string `json:"secret,omitempty"`
}

// ContainerServiceSSHConfiguration is SSH configuration for Linux-based VMs running on Azure.
type ContainerServiceSSHConfiguration struct {
	PublicKeys *[]ContainerServiceSSHPublicKey `json:"publicKeys,omitempty"`
}

// ContainerServiceSSHPublicKey is contains information about SSH certificate public key data.
type ContainerServiceSSHPublicKey struct {
	KeyData *string `json:"keyData,omitempty"`
}

// ContainerServiceVMDiagnostics is profile for diagnostics on the container service VMs.
type ContainerServiceVMDiagnostics struct {
	Enabled    *bool   `json:"enabled,omitempty"`
	StorageURI *string `json:"storageUri,omitempty"`
}

// ContainerServiceWindowsProfile is profile for Windows VMs in the container service cluster.
type ContainerServiceWindowsProfile struct {
	AdminUsername *string `json:"adminUsername,omitempty"`
	AdminPassword *string `json:"adminPassword,omitempty"`
}

// CreationData is data used when creating a disk.
type CreationData struct {
	CreateOption     DiskCreateOption    `json:"createOption,omitempty"`
	StorageAccountID *string             `json:"storageAccountId,omitempty"`
	ImageReference   *ImageDiskReference `json:"imageReference,omitempty"`
	SourceURI        *string             `json:"sourceUri,omitempty"`
	SourceResourceID *string             `json:"sourceResourceId,omitempty"`
}

// DataDisk is describes a data disk.
type DataDisk struct {
	Lun          *int32                 `json:"lun,omitempty"`
	Name         *string                `json:"name,omitempty"`
	Vhd          *VirtualHardDisk       `json:"vhd,omitempty"`
	Image        *VirtualHardDisk       `json:"image,omitempty"`
	Caching      CachingTypes           `json:"caching,omitempty"`
	CreateOption DiskCreateOptionTypes  `json:"createOption,omitempty"`
	DiskSizeGB   *int32                 `json:"diskSizeGB,omitempty"`
	ManagedDisk  *ManagedDiskParameters `json:"managedDisk,omitempty"`
}

// DataDiskImage is contains the data disk images information.
type DataDiskImage struct {
	Lun *int32 `json:"lun,omitempty"`
}

// DiagnosticsProfile is specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
type DiagnosticsProfile struct {
	BootDiagnostics *BootDiagnostics `json:"bootDiagnostics,omitempty"`
}

// Disk is disk resource.
type Disk struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	ManagedBy         *string             `json:"managedBy,omitempty"`
	Sku               *DiskSku            `json:"sku,omitempty"`
	Zones             *[]string           `json:"zones,omitempty"`
	*DiskProperties   `json:"properties,omitempty"`
}

// DiskEncryptionSettings is describes a Encryption Settings for a Disk
type DiskEncryptionSettings struct {
	DiskEncryptionKey *KeyVaultSecretReference `json:"diskEncryptionKey,omitempty"`
	KeyEncryptionKey  *KeyVaultKeyReference    `json:"keyEncryptionKey,omitempty"`
	Enabled           *bool                    `json:"enabled,omitempty"`
}

// DiskInstanceView is the instance view of the disk.
type DiskInstanceView struct {
	Name               *string                   `json:"name,omitempty"`
	EncryptionSettings *[]DiskEncryptionSettings `json:"encryptionSettings,omitempty"`
	Statuses           *[]InstanceViewStatus     `json:"statuses,omitempty"`
}

// DiskList is the List Disks operation response.
type DiskList struct {
	autorest.Response `json:"-"`
	Value             *[]Disk `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// DiskListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DiskList) DiskListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DiskProperties is disk resource properties.
type DiskProperties struct {
	TimeCreated        *date.Time           `json:"timeCreated,omitempty"`
	OsType             OperatingSystemTypes `json:"osType,omitempty"`
	CreationData       *CreationData        `json:"creationData,omitempty"`
	DiskSizeGB         *int32               `json:"diskSizeGB,omitempty"`
	EncryptionSettings *EncryptionSettings  `json:"encryptionSettings,omitempty"`
	ProvisioningState  *string              `json:"provisioningState,omitempty"`
}

// DiskSku is the disks and snapshots sku name. Can be Standard_LRS or Premium_LRS.
type DiskSku struct {
	Name StorageAccountTypes `json:"name,omitempty"`
	Tier *string             `json:"tier,omitempty"`
}

// DiskUpdate is disk update resource.
type DiskUpdate struct {
	Tags                  *map[string]*string `json:"tags,omitempty"`
	Sku                   *DiskSku            `json:"sku,omitempty"`
	*DiskUpdateProperties `json:"properties,omitempty"`
}

// DiskUpdateProperties is disk resource update properties.
type DiskUpdateProperties struct {
	OsType             OperatingSystemTypes `json:"osType,omitempty"`
	DiskSizeGB         *int32               `json:"diskSizeGB,omitempty"`
	EncryptionSettings *EncryptionSettings  `json:"encryptionSettings,omitempty"`
}

// EncryptionSettings is encryption settings for disk or snapshot
type EncryptionSettings struct {
	Enabled           *bool                       `json:"enabled,omitempty"`
	DiskEncryptionKey *KeyVaultAndSecretReference `json:"diskEncryptionKey,omitempty"`
	KeyEncryptionKey  *KeyVaultAndKeyReference    `json:"keyEncryptionKey,omitempty"`
}

// GrantAccessData is data used for requesting a SAS.
type GrantAccessData struct {
	Access            AccessLevel `json:"access,omitempty"`
	DurationInSeconds *int32      `json:"durationInSeconds,omitempty"`
}

// HardwareProfile is specifies the hardware settings for the virtual machine.
type HardwareProfile struct {
	VMSize VirtualMachineSizeTypes `json:"vmSize,omitempty"`
}

// Image is the source user image virtual hard disk. The virtual hard disk will be copied before being attached to the
// virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
type Image struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*ImageProperties  `json:"properties,omitempty"`
}

// ImageDataDisk is describes a data disk.
type ImageDataDisk struct {
	Lun                *int32              `json:"lun,omitempty"`
	Snapshot           *SubResource        `json:"snapshot,omitempty"`
	ManagedDisk        *SubResource        `json:"managedDisk,omitempty"`
	BlobURI            *string             `json:"blobUri,omitempty"`
	Caching            CachingTypes        `json:"caching,omitempty"`
	DiskSizeGB         *int32              `json:"diskSizeGB,omitempty"`
	StorageAccountType StorageAccountTypes `json:"storageAccountType,omitempty"`
}

// ImageDiskReference is the source image used for creating the disk.
type ImageDiskReference struct {
	ID  *string `json:"id,omitempty"`
	Lun *int32  `json:"lun,omitempty"`
}

// ImageListResult is the List Image operation response.
type ImageListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Image `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// ImageListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ImageListResult) ImageListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ImageOSDisk is describes an Operating System disk.
type ImageOSDisk struct {
	OsType             OperatingSystemTypes      `json:"osType,omitempty"`
	OsState            OperatingSystemStateTypes `json:"osState,omitempty"`
	Snapshot           *SubResource              `json:"snapshot,omitempty"`
	ManagedDisk        *SubResource              `json:"managedDisk,omitempty"`
	BlobURI            *string                   `json:"blobUri,omitempty"`
	Caching            CachingTypes              `json:"caching,omitempty"`
	DiskSizeGB         *int32                    `json:"diskSizeGB,omitempty"`
	StorageAccountType StorageAccountTypes       `json:"storageAccountType,omitempty"`
}

// ImageProperties is describes the properties of an Image.
type ImageProperties struct {
	SourceVirtualMachine *SubResource         `json:"sourceVirtualMachine,omitempty"`
	StorageProfile       *ImageStorageProfile `json:"storageProfile,omitempty"`
	ProvisioningState    *string              `json:"provisioningState,omitempty"`
}

// ImageReference is specifies information about the image to use. You can specify information about platform images,
// marketplace images, or virtual machine images. This element is required when you want to use a platform image,
// marketplace image, or virtual machine image, but is not used in other creation operations.
type ImageReference struct {
	ID        *string `json:"id,omitempty"`
	Publisher *string `json:"publisher,omitempty"`
	Offer     *string `json:"offer,omitempty"`
	Sku       *string `json:"sku,omitempty"`
	Version   *string `json:"version,omitempty"`
}

// ImageStorageProfile is describes a storage profile.
type ImageStorageProfile struct {
	OsDisk    *ImageOSDisk     `json:"osDisk,omitempty"`
	DataDisks *[]ImageDataDisk `json:"dataDisks,omitempty"`
}

// InnerError is inner error details.
type InnerError struct {
	Exceptiontype *string `json:"exceptiontype,omitempty"`
	Errordetail   *string `json:"errordetail,omitempty"`
}

// InstanceViewStatus is instance view status.
type InstanceViewStatus struct {
	Code          *string          `json:"code,omitempty"`
	Level         StatusLevelTypes `json:"level,omitempty"`
	DisplayStatus *string          `json:"displayStatus,omitempty"`
	Message       *string          `json:"message,omitempty"`
	Time          *date.Time       `json:"time,omitempty"`
}

// KeyVaultAndKeyReference is key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to
// unwrap the encryptionKey
type KeyVaultAndKeyReference struct {
	SourceVault *SourceVault `json:"sourceVault,omitempty"`
	KeyURL      *string      `json:"keyUrl,omitempty"`
}

// KeyVaultAndSecretReference is key Vault Secret Url and vault id of the encryption key
type KeyVaultAndSecretReference struct {
	SourceVault *SourceVault `json:"sourceVault,omitempty"`
	SecretURL   *string      `json:"secretUrl,omitempty"`
}

// KeyVaultKeyReference is describes a reference to Key Vault Key
type KeyVaultKeyReference struct {
	KeyURL      *string      `json:"keyUrl,omitempty"`
	SourceVault *SubResource `json:"sourceVault,omitempty"`
}

// KeyVaultSecretReference is describes a reference to Key Vault Secret
type KeyVaultSecretReference struct {
	SecretURL   *string      `json:"secretUrl,omitempty"`
	SourceVault *SubResource `json:"sourceVault,omitempty"`
}

// LinuxConfiguration is specifies the Linux operating system settings on the virtual machine. <br><br>For a list of
// supported Linux distributions, see [Linux on Azure-Endorsed
// Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
// <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed
// Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
type LinuxConfiguration struct {
	DisablePasswordAuthentication *bool             `json:"disablePasswordAuthentication,omitempty"`
	SSH                           *SSHConfiguration `json:"ssh,omitempty"`
}

// ListUsagesResult is the List Usages operation response.
type ListUsagesResult struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// ListUsagesResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ListUsagesResult) ListUsagesResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ListVirtualMachineExtensionImage is
type ListVirtualMachineExtensionImage struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineExtensionImage `json:"value,omitempty"`
}

// ListVirtualMachineImageResource is
type ListVirtualMachineImageResource struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineImageResource `json:"value,omitempty"`
}

// LongRunningOperationProperties is compute-specific operation properties, including output
type LongRunningOperationProperties struct {
	Output *map[string]interface{} `json:"output,omitempty"`
}

// MaintenanceRedeployStatus is maintenance Operation Status.
type MaintenanceRedeployStatus struct {
	IsCustomerInitiatedMaintenanceAllowed *bool                               `json:"isCustomerInitiatedMaintenanceAllowed,omitempty"`
	PreMaintenanceWindowStartTime         *date.Time                          `json:"preMaintenanceWindowStartTime,omitempty"`
	PreMaintenanceWindowEndTime           *date.Time                          `json:"preMaintenanceWindowEndTime,omitempty"`
	MaintenanceWindowStartTime            *date.Time                          `json:"maintenanceWindowStartTime,omitempty"`
	MaintenanceWindowEndTime              *date.Time                          `json:"maintenanceWindowEndTime,omitempty"`
	LastOperationResultCode               MaintenanceOperationResultCodeTypes `json:"lastOperationResultCode,omitempty"`
	LastOperationMessage                  *string                             `json:"lastOperationMessage,omitempty"`
}

// ManagedDiskParameters is the parameters of a managed disk.
type ManagedDiskParameters struct {
	ID                 *string             `json:"id,omitempty"`
	StorageAccountType StorageAccountTypes `json:"storageAccountType,omitempty"`
}

// NetworkInterfaceReference is describes a network interface reference.
type NetworkInterfaceReference struct {
	ID                                   *string `json:"id,omitempty"`
	*NetworkInterfaceReferenceProperties `json:"properties,omitempty"`
}

// NetworkInterfaceReferenceProperties is describes a network interface reference properties.
type NetworkInterfaceReferenceProperties struct {
	Primary *bool `json:"primary,omitempty"`
}

// NetworkProfile is specifies the network interfaces of the virtual machine.
type NetworkProfile struct {
	NetworkInterfaces *[]NetworkInterfaceReference `json:"networkInterfaces,omitempty"`
}

// OperationStatusResponse is operation status response
type OperationStatusResponse struct {
	autorest.Response `json:"-"`
	Name              *string    `json:"name,omitempty"`
	Status            *string    `json:"status,omitempty"`
	StartTime         *date.Time `json:"startTime,omitempty"`
	EndTime           *date.Time `json:"endTime,omitempty"`
	Error             *APIError  `json:"error,omitempty"`
}

// OSDisk is specifies information about the operating system disk used by the virtual machine. <br><br> For more
// information about disks, see [About disks and VHDs for Azure virtual
// machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
type OSDisk struct {
	OsType             OperatingSystemTypes    `json:"osType,omitempty"`
	EncryptionSettings *DiskEncryptionSettings `json:"encryptionSettings,omitempty"`
	Name               *string                 `json:"name,omitempty"`
	Vhd                *VirtualHardDisk        `json:"vhd,omitempty"`
	Image              *VirtualHardDisk        `json:"image,omitempty"`
	Caching            CachingTypes            `json:"caching,omitempty"`
	CreateOption       DiskCreateOptionTypes   `json:"createOption,omitempty"`
	DiskSizeGB         *int32                  `json:"diskSizeGB,omitempty"`
	ManagedDisk        *ManagedDiskParameters  `json:"managedDisk,omitempty"`
}

// OSDiskImage is contains the os disk image information.
type OSDiskImage struct {
	OperatingSystem OperatingSystemTypes `json:"operatingSystem,omitempty"`
}

// OSProfile is specifies the operating system settings for the virtual machine.
type OSProfile struct {
	ComputerName         *string               `json:"computerName,omitempty"`
	AdminUsername        *string               `json:"adminUsername,omitempty"`
	AdminPassword        *string               `json:"adminPassword,omitempty"`
	CustomData           *string               `json:"customData,omitempty"`
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	LinuxConfiguration   *LinuxConfiguration   `json:"linuxConfiguration,omitempty"`
	Secrets              *[]VaultSecretGroup   `json:"secrets,omitempty"`
}

// Plan is specifies information about the marketplace image used to create the virtual machine. This element is only
// used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for
// programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to
// deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
type Plan struct {
	Name          *string `json:"name,omitempty"`
	Publisher     *string `json:"publisher,omitempty"`
	Product       *string `json:"product,omitempty"`
	PromotionCode *string `json:"promotionCode,omitempty"`
}

// PurchasePlan is used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
type PurchasePlan struct {
	Publisher *string `json:"publisher,omitempty"`
	Name      *string `json:"name,omitempty"`
	Product   *string `json:"product,omitempty"`
}

// Resource is the Resource model definition.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceSku is describes an available Compute SKU.
type ResourceSku struct {
	ResourceType *string                    `json:"resourceType,omitempty"`
	Name         *string                    `json:"name,omitempty"`
	Tier         *string                    `json:"tier,omitempty"`
	Size         *string                    `json:"size,omitempty"`
	Family       *string                    `json:"family,omitempty"`
	Kind         *string                    `json:"kind,omitempty"`
	Capacity     *ResourceSkuCapacity       `json:"capacity,omitempty"`
	Locations    *[]string                  `json:"locations,omitempty"`
	APIVersions  *[]string                  `json:"apiVersions,omitempty"`
	Costs        *[]ResourceSkuCosts        `json:"costs,omitempty"`
	Capabilities *[]ResourceSkuCapabilities `json:"capabilities,omitempty"`
	Restrictions *[]ResourceSkuRestrictions `json:"restrictions,omitempty"`
}

// ResourceSkuCapabilities is describes The SKU capabilites object.
type ResourceSkuCapabilities struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ResourceSkuCapacity is describes scaling information of a SKU.
type ResourceSkuCapacity struct {
	Minimum   *int64                       `json:"minimum,omitempty"`
	Maximum   *int64                       `json:"maximum,omitempty"`
	Default   *int64                       `json:"default,omitempty"`
	ScaleType ResourceSkuCapacityScaleType `json:"scaleType,omitempty"`
}

// ResourceSkuCosts is describes metadata for retrieving price info.
type ResourceSkuCosts struct {
	MeterID      *string `json:"meterID,omitempty"`
	Quantity     *int64  `json:"quantity,omitempty"`
	ExtendedUnit *string `json:"extendedUnit,omitempty"`
}

// ResourceSkuRestrictions is describes scaling information of a SKU.
type ResourceSkuRestrictions struct {
	Type       ResourceSkuRestrictionsType       `json:"type,omitempty"`
	Values     *[]string                         `json:"values,omitempty"`
	ReasonCode ResourceSkuRestrictionsReasonCode `json:"reasonCode,omitempty"`
}

// ResourceSkusResult is the Compute List Skus operation response.
type ResourceSkusResult struct {
	autorest.Response `json:"-"`
	Value             *[]ResourceSku `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// ResourceSkusResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResourceSkusResult) ResourceSkusResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResourceUpdate is the Resource model definition.
type ResourceUpdate struct {
	Tags *map[string]*string `json:"tags,omitempty"`
	Sku  *DiskSku            `json:"sku,omitempty"`
}

// RollingUpgradePolicy is the configuration parameters used while performing a rolling upgrade.
type RollingUpgradePolicy struct {
	MaxBatchInstancePercent             *int32  `json:"maxBatchInstancePercent,omitempty"`
	MaxUnhealthyInstancePercent         *int32  `json:"maxUnhealthyInstancePercent,omitempty"`
	MaxUnhealthyUpgradedInstancePercent *int32  `json:"maxUnhealthyUpgradedInstancePercent,omitempty"`
	PauseTimeBetweenBatches             *string `json:"pauseTimeBetweenBatches,omitempty"`
}

// RollingUpgradeProgressInfo is information about the number of virtual machine instances in each upgrade state.
type RollingUpgradeProgressInfo struct {
	SuccessfulInstanceCount *int32 `json:"successfulInstanceCount,omitempty"`
	FailedInstanceCount     *int32 `json:"failedInstanceCount,omitempty"`
	InProgressInstanceCount *int32 `json:"inProgressInstanceCount,omitempty"`
	PendingInstanceCount    *int32 `json:"pendingInstanceCount,omitempty"`
}

// RollingUpgradeRunningStatus is information about the current running state of the overall upgrade.
type RollingUpgradeRunningStatus struct {
	Code           RollingUpgradeStatusCode `json:"code,omitempty"`
	StartTime      *date.Time               `json:"startTime,omitempty"`
	LastAction     RollingUpgradeActionType `json:"lastAction,omitempty"`
	LastActionTime *date.Time               `json:"lastActionTime,omitempty"`
}

// RollingUpgradeStatusInfo is the status of the latest virtual machine scale set rolling upgrade.
type RollingUpgradeStatusInfo struct {
	autorest.Response                   `json:"-"`
	ID                                  *string             `json:"id,omitempty"`
	Name                                *string             `json:"name,omitempty"`
	Type                                *string             `json:"type,omitempty"`
	Location                            *string             `json:"location,omitempty"`
	Tags                                *map[string]*string `json:"tags,omitempty"`
	*RollingUpgradeStatusInfoProperties `json:"properties,omitempty"`
}

// RollingUpgradeStatusInfoProperties is the status of the latest virtual machine scale set rolling upgrade.
type RollingUpgradeStatusInfoProperties struct {
	Policy        *RollingUpgradePolicy        `json:"policy,omitempty"`
	RunningStatus *RollingUpgradeRunningStatus `json:"runningStatus,omitempty"`
	Progress      *RollingUpgradeProgressInfo  `json:"progress,omitempty"`
	Error         *APIError                    `json:"error,omitempty"`
}

// RunCommandDocument is describes the properties of a Run Command.
type RunCommandDocument struct {
	autorest.Response `json:"-"`
	Schema            *string                          `json:"$schema,omitempty"`
	ID                *string                          `json:"id,omitempty"`
	OsType            OperatingSystemTypes             `json:"osType,omitempty"`
	Label             *string                          `json:"label,omitempty"`
	Description       *string                          `json:"description,omitempty"`
	Script            *[]string                        `json:"script,omitempty"`
	Parameters        *[]RunCommandParameterDefinition `json:"parameters,omitempty"`
}

// RunCommandDocumentBase is describes the properties of a Run Command metadata.
type RunCommandDocumentBase struct {
	Schema      *string              `json:"$schema,omitempty"`
	ID          *string              `json:"id,omitempty"`
	OsType      OperatingSystemTypes `json:"osType,omitempty"`
	Label       *string              `json:"label,omitempty"`
	Description *string              `json:"description,omitempty"`
}

// RunCommandInput is capture Virtual Machine parameters.
type RunCommandInput struct {
	CommandID  *string                     `json:"commandId,omitempty"`
	Script     *[]string                   `json:"script,omitempty"`
	Parameters *[]RunCommandInputParameter `json:"parameters,omitempty"`
}

// RunCommandInputParameter is describes the properties of a run command parameter.
type RunCommandInputParameter struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// RunCommandListResult is the List Virtual Machine operation response.
type RunCommandListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RunCommandDocumentBase `json:"value,omitempty"`
	NextLink          *string                   `json:"nextLink,omitempty"`
}

// RunCommandListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RunCommandListResult) RunCommandListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RunCommandParameterDefinition is describes the properties of a run command parameter.
type RunCommandParameterDefinition struct {
	Name         *string `json:"name,omitempty"`
	Type         *string `json:"type,omitempty"`
	DefaultValue *string `json:"defaultValue,omitempty"`
	Required     *bool   `json:"required,omitempty"`
}

// RunCommandResult is run command operation response.
type RunCommandResult struct {
	autorest.Response           `json:"-"`
	Name                        *string    `json:"name,omitempty"`
	Status                      *string    `json:"status,omitempty"`
	StartTime                   *date.Time `json:"startTime,omitempty"`
	EndTime                     *date.Time `json:"endTime,omitempty"`
	Error                       *APIError  `json:"error,omitempty"`
	*RunCommandResultProperties `json:"properties,omitempty"`
}

// RunCommandResultProperties is compute-specific operation properties, including output
type RunCommandResultProperties struct {
	Output *map[string]interface{} `json:"output,omitempty"`
}

// Sku is describes a virtual machine scale set sku.
type Sku struct {
	Name     *string `json:"name,omitempty"`
	Tier     *string `json:"tier,omitempty"`
	Capacity *int64  `json:"capacity,omitempty"`
}

// Snapshot is snapshot resource.
type Snapshot struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	ManagedBy         *string             `json:"managedBy,omitempty"`
	Sku               *DiskSku            `json:"sku,omitempty"`
	*DiskProperties   `json:"properties,omitempty"`
}

// SnapshotList is the List Snapshots operation response.
type SnapshotList struct {
	autorest.Response `json:"-"`
	Value             *[]Snapshot `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// SnapshotListPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SnapshotList) SnapshotListPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SnapshotUpdate is snapshot update resource.
type SnapshotUpdate struct {
	Tags                  *map[string]*string `json:"tags,omitempty"`
	Sku                   *DiskSku            `json:"sku,omitempty"`
	*DiskUpdateProperties `json:"properties,omitempty"`
}

// SourceVault is the vault id is an Azure Resource Manager Resoure id in the form
// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
type SourceVault struct {
	ID *string `json:"id,omitempty"`
}

// SSHConfiguration is SSH configuration for Linux based VMs running on Azure
type SSHConfiguration struct {
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey is contains information about SSH certificate public key and the path on the Linux VM where the public
// key is placed.
type SSHPublicKey struct {
	Path    *string `json:"path,omitempty"`
	KeyData *string `json:"keyData,omitempty"`
}

// StorageProfile is specifies the storage settings for the virtual machine disks.
type StorageProfile struct {
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	OsDisk         *OSDisk         `json:"osDisk,omitempty"`
	DataDisks      *[]DataDisk     `json:"dataDisks,omitempty"`
}

// SubResource is
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// SubResourceReadOnly is
type SubResourceReadOnly struct {
	ID *string `json:"id,omitempty"`
}

// UpdateResource is the Update Resource model definition.
type UpdateResource struct {
	Tags *map[string]*string `json:"tags,omitempty"`
}

// UpgradePolicy is describes an upgrade policy - automatic, manual, or rolling.
type UpgradePolicy struct {
	Mode                 UpgradeMode           `json:"mode,omitempty"`
	RollingUpgradePolicy *RollingUpgradePolicy `json:"rollingUpgradePolicy,omitempty"`
	AutomaticOSUpgrade   *bool                 `json:"automaticOSUpgrade,omitempty"`
}

// Usage is describes Compute Resource Usage.
type Usage struct {
	Unit         *string    `json:"unit,omitempty"`
	CurrentValue *int32     `json:"currentValue,omitempty"`
	Limit        *int64     `json:"limit,omitempty"`
	Name         *UsageName `json:"name,omitempty"`
}

// UsageName is the Usage Names.
type UsageName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// VaultCertificate is describes a single certificate reference in a Key Vault, and where the certificate should reside
// on the VM.
type VaultCertificate struct {
	CertificateURL   *string `json:"certificateUrl,omitempty"`
	CertificateStore *string `json:"certificateStore,omitempty"`
}

// VaultSecretGroup is describes a set of certificates which are all in the same Key Vault.
type VaultSecretGroup struct {
	SourceVault       *SubResource        `json:"sourceVault,omitempty"`
	VaultCertificates *[]VaultCertificate `json:"vaultCertificates,omitempty"`
}

// VirtualHardDisk is describes the uri of a disk.
type VirtualHardDisk struct {
	URI *string `json:"uri,omitempty"`
}

// VirtualMachine is describes a Virtual Machine.
type VirtualMachine struct {
	autorest.Response         `json:"-"`
	ID                        *string             `json:"id,omitempty"`
	Name                      *string             `json:"name,omitempty"`
	Type                      *string             `json:"type,omitempty"`
	Location                  *string             `json:"location,omitempty"`
	Tags                      *map[string]*string `json:"tags,omitempty"`
	Plan                      *Plan               `json:"plan,omitempty"`
	*VirtualMachineProperties `json:"properties,omitempty"`
	Resources                 *[]VirtualMachineExtension `json:"resources,omitempty"`
	Identity                  *VirtualMachineIdentity    `json:"identity,omitempty"`
	Zones                     *[]string                  `json:"zones,omitempty"`
}

// VirtualMachineAgentInstanceView is the instance view of the VM Agent running on the virtual machine.
type VirtualMachineAgentInstanceView struct {
	VMAgentVersion    *string                                       `json:"vmAgentVersion,omitempty"`
	ExtensionHandlers *[]VirtualMachineExtensionHandlerInstanceView `json:"extensionHandlers,omitempty"`
	Statuses          *[]InstanceViewStatus                         `json:"statuses,omitempty"`
}

// VirtualMachineCaptureParameters is capture Virtual Machine parameters.
type VirtualMachineCaptureParameters struct {
	VhdPrefix                *string `json:"vhdPrefix,omitempty"`
	DestinationContainerName *string `json:"destinationContainerName,omitempty"`
	OverwriteVhds            *bool   `json:"overwriteVhds,omitempty"`
}

// VirtualMachineCaptureResult is resource Id.
type VirtualMachineCaptureResult struct {
	autorest.Response                      `json:"-"`
	ID                                     *string `json:"id,omitempty"`
	*VirtualMachineCaptureResultProperties `json:"properties,omitempty"`
}

// VirtualMachineCaptureResultProperties is compute-specific operation properties, including output
type VirtualMachineCaptureResultProperties struct {
	Output *map[string]interface{} `json:"output,omitempty"`
}

// VirtualMachineExtension is describes a Virtual Machine Extension.
type VirtualMachineExtension struct {
	autorest.Response                  `json:"-"`
	ID                                 *string             `json:"id,omitempty"`
	Name                               *string             `json:"name,omitempty"`
	Type                               *string             `json:"type,omitempty"`
	Location                           *string             `json:"location,omitempty"`
	Tags                               *map[string]*string `json:"tags,omitempty"`
	*VirtualMachineExtensionProperties `json:"properties,omitempty"`
}

// VirtualMachineExtensionHandlerInstanceView is the instance view of a virtual machine extension handler.
type VirtualMachineExtensionHandlerInstanceView struct {
	Type               *string             `json:"type,omitempty"`
	TypeHandlerVersion *string             `json:"typeHandlerVersion,omitempty"`
	Status             *InstanceViewStatus `json:"status,omitempty"`
}

// VirtualMachineExtensionImage is describes a Virtual Machine Extension Image.
type VirtualMachineExtensionImage struct {
	autorest.Response                       `json:"-"`
	ID                                      *string             `json:"id,omitempty"`
	Name                                    *string             `json:"name,omitempty"`
	Type                                    *string             `json:"type,omitempty"`
	Location                                *string             `json:"location,omitempty"`
	Tags                                    *map[string]*string `json:"tags,omitempty"`
	*VirtualMachineExtensionImageProperties `json:"properties,omitempty"`
}

// VirtualMachineExtensionImageProperties is describes the properties of a Virtual Machine Extension Image.
type VirtualMachineExtensionImageProperties struct {
	OperatingSystem            *string `json:"operatingSystem,omitempty"`
	ComputeRole                *string `json:"computeRole,omitempty"`
	HandlerSchema              *string `json:"handlerSchema,omitempty"`
	VMScaleSetEnabled          *bool   `json:"vmScaleSetEnabled,omitempty"`
	SupportsMultipleExtensions *bool   `json:"supportsMultipleExtensions,omitempty"`
}

// VirtualMachineExtensionInstanceView is the instance view of a virtual machine extension.
type VirtualMachineExtensionInstanceView struct {
	Name               *string               `json:"name,omitempty"`
	Type               *string               `json:"type,omitempty"`
	TypeHandlerVersion *string               `json:"typeHandlerVersion,omitempty"`
	Substatuses        *[]InstanceViewStatus `json:"substatuses,omitempty"`
	Statuses           *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// VirtualMachineExtensionProperties is describes the properties of a Virtual Machine Extension.
type VirtualMachineExtensionProperties struct {
	ForceUpdateTag          *string                              `json:"forceUpdateTag,omitempty"`
	Publisher               *string                              `json:"publisher,omitempty"`
	Type                    *string                              `json:"type,omitempty"`
	TypeHandlerVersion      *string                              `json:"typeHandlerVersion,omitempty"`
	AutoUpgradeMinorVersion *bool                                `json:"autoUpgradeMinorVersion,omitempty"`
	Settings                *map[string]interface{}              `json:"settings,omitempty"`
	ProtectedSettings       *map[string]interface{}              `json:"protectedSettings,omitempty"`
	ProvisioningState       *string                              `json:"provisioningState,omitempty"`
	InstanceView            *VirtualMachineExtensionInstanceView `json:"instanceView,omitempty"`
}

// VirtualMachineHealthStatus is the health status of the VM.
type VirtualMachineHealthStatus struct {
	Status *InstanceViewStatus `json:"status,omitempty"`
}

// VirtualMachineIdentity is identity for the virtual machine.
type VirtualMachineIdentity struct {
	PrincipalID *string              `json:"principalId,omitempty"`
	TenantID    *string              `json:"tenantId,omitempty"`
	Type        ResourceIdentityType `json:"type,omitempty"`
}

// VirtualMachineImage is describes a Virtual Machine Image.
type VirtualMachineImage struct {
	autorest.Response              `json:"-"`
	ID                             *string             `json:"id,omitempty"`
	Name                           *string             `json:"name,omitempty"`
	Location                       *string             `json:"location,omitempty"`
	Tags                           *map[string]*string `json:"tags,omitempty"`
	*VirtualMachineImageProperties `json:"properties,omitempty"`
}

// VirtualMachineImageProperties is describes the properties of a Virtual Machine Image.
type VirtualMachineImageProperties struct {
	Plan           *PurchasePlan    `json:"plan,omitempty"`
	OsDiskImage    *OSDiskImage     `json:"osDiskImage,omitempty"`
	DataDiskImages *[]DataDiskImage `json:"dataDiskImages,omitempty"`
}

// VirtualMachineImageResource is virtual machine image resource information.
type VirtualMachineImageResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineInstanceView is the instance view of a virtual machine.
type VirtualMachineInstanceView struct {
	autorest.Response         `json:"-"`
	PlatformUpdateDomain      *int32                                 `json:"platformUpdateDomain,omitempty"`
	PlatformFaultDomain       *int32                                 `json:"platformFaultDomain,omitempty"`
	RdpThumbPrint             *string                                `json:"rdpThumbPrint,omitempty"`
	VMAgent                   *VirtualMachineAgentInstanceView       `json:"vmAgent,omitempty"`
	MaintenanceRedeployStatus *MaintenanceRedeployStatus             `json:"maintenanceRedeployStatus,omitempty"`
	Disks                     *[]DiskInstanceView                    `json:"disks,omitempty"`
	Extensions                *[]VirtualMachineExtensionInstanceView `json:"extensions,omitempty"`
	BootDiagnostics           *BootDiagnosticsInstanceView           `json:"bootDiagnostics,omitempty"`
	Statuses                  *[]InstanceViewStatus                  `json:"statuses,omitempty"`
}

// VirtualMachineListResult is the List Virtual Machine operation response.
type VirtualMachineListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachine `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// VirtualMachineListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineListResult) VirtualMachineListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineProperties is describes the properties of a Virtual Machine.
type VirtualMachineProperties struct {
	HardwareProfile    *HardwareProfile            `json:"hardwareProfile,omitempty"`
	StorageProfile     *StorageProfile             `json:"storageProfile,omitempty"`
	OsProfile          *OSProfile                  `json:"osProfile,omitempty"`
	NetworkProfile     *NetworkProfile             `json:"networkProfile,omitempty"`
	DiagnosticsProfile *DiagnosticsProfile         `json:"diagnosticsProfile,omitempty"`
	AvailabilitySet    *SubResource                `json:"availabilitySet,omitempty"`
	ProvisioningState  *string                     `json:"provisioningState,omitempty"`
	InstanceView       *VirtualMachineInstanceView `json:"instanceView,omitempty"`
	LicenseType        *string                     `json:"licenseType,omitempty"`
	VMID               *string                     `json:"vmId,omitempty"`
}

// VirtualMachineScaleSet is describes a Virtual Machine Scale Set.
type VirtualMachineScaleSet struct {
	autorest.Response                 `json:"-"`
	ID                                *string             `json:"id,omitempty"`
	Name                              *string             `json:"name,omitempty"`
	Type                              *string             `json:"type,omitempty"`
	Location                          *string             `json:"location,omitempty"`
	Tags                              *map[string]*string `json:"tags,omitempty"`
	Sku                               *Sku                `json:"sku,omitempty"`
	Plan                              *Plan               `json:"plan,omitempty"`
	*VirtualMachineScaleSetProperties `json:"properties,omitempty"`
	Identity                          *VirtualMachineScaleSetIdentity `json:"identity,omitempty"`
	Zones                             *[]string                       `json:"zones,omitempty"`
}

// VirtualMachineScaleSetDataDisk is describes a virtual machine scale set data disk.
type VirtualMachineScaleSetDataDisk struct {
	Name         *string                                      `json:"name,omitempty"`
	Lun          *int32                                       `json:"lun,omitempty"`
	Caching      CachingTypes                                 `json:"caching,omitempty"`
	CreateOption DiskCreateOptionTypes                        `json:"createOption,omitempty"`
	DiskSizeGB   *int32                                       `json:"diskSizeGB,omitempty"`
	ManagedDisk  *VirtualMachineScaleSetManagedDiskParameters `json:"managedDisk,omitempty"`
}

// VirtualMachineScaleSetExtension is describes a Virtual Machine Scale Set Extension.
type VirtualMachineScaleSetExtension struct {
	autorest.Response                          `json:"-"`
	ID                                         *string `json:"id,omitempty"`
	Name                                       *string `json:"name,omitempty"`
	*VirtualMachineScaleSetExtensionProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetExtensionListResult is the List VM scale set extension operation response.
type VirtualMachineScaleSetExtensionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineScaleSetExtension `json:"value,omitempty"`
	NextLink          *string                            `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetExtensionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineScaleSetExtensionListResult) VirtualMachineScaleSetExtensionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineScaleSetExtensionProfile is describes a virtual machine scale set extension profile.
type VirtualMachineScaleSetExtensionProfile struct {
	Extensions *[]VirtualMachineScaleSetExtension `json:"extensions,omitempty"`
}

// VirtualMachineScaleSetExtensionProperties is describes the properties of a Virtual Machine Scale Set Extension.
type VirtualMachineScaleSetExtensionProperties struct {
	ForceUpdateTag          *string                 `json:"forceUpdateTag,omitempty"`
	Publisher               *string                 `json:"publisher,omitempty"`
	Type                    *string                 `json:"type,omitempty"`
	TypeHandlerVersion      *string                 `json:"typeHandlerVersion,omitempty"`
	AutoUpgradeMinorVersion *bool                   `json:"autoUpgradeMinorVersion,omitempty"`
	Settings                *map[string]interface{} `json:"settings,omitempty"`
	ProtectedSettings       *map[string]interface{} `json:"protectedSettings,omitempty"`
	ProvisioningState       *string                 `json:"provisioningState,omitempty"`
}

// VirtualMachineScaleSetIdentity is identity for the virtual machine scale set.
type VirtualMachineScaleSetIdentity struct {
	PrincipalID *string              `json:"principalId,omitempty"`
	TenantID    *string              `json:"tenantId,omitempty"`
	Type        ResourceIdentityType `json:"type,omitempty"`
}

// VirtualMachineScaleSetInstanceView is the instance view of a virtual machine scale set.
type VirtualMachineScaleSetInstanceView struct {
	autorest.Response `json:"-"`
	VirtualMachine    *VirtualMachineScaleSetInstanceViewStatusesSummary `json:"virtualMachine,omitempty"`
	Extensions        *[]VirtualMachineScaleSetVMExtensionsSummary       `json:"extensions,omitempty"`
	Statuses          *[]InstanceViewStatus                              `json:"statuses,omitempty"`
}

// VirtualMachineScaleSetInstanceViewStatusesSummary is instance view statuses summary for virtual machines of a
// virtual machine scale set.
type VirtualMachineScaleSetInstanceViewStatusesSummary struct {
	StatusesSummary *[]VirtualMachineStatusCodeCount `json:"statusesSummary,omitempty"`
}

// VirtualMachineScaleSetIPConfiguration is describes a virtual machine scale set network profile's IP configuration.
type VirtualMachineScaleSetIPConfiguration struct {
	ID                                               *string `json:"id,omitempty"`
	Name                                             *string `json:"name,omitempty"`
	*VirtualMachineScaleSetIPConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetIPConfigurationProperties is describes a virtual machine scale set network profile's IP
// configuration properties.
type VirtualMachineScaleSetIPConfigurationProperties struct {
	Subnet                                *APIEntityReference                                 `json:"subnet,omitempty"`
	Primary                               *bool                                               `json:"primary,omitempty"`
	PublicIPAddressConfiguration          *VirtualMachineScaleSetPublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`
	PrivateIPAddressVersion               IPVersion                                           `json:"privateIPAddressVersion,omitempty"`
	ApplicationGatewayBackendAddressPools *[]SubResource                                      `json:"applicationGatewayBackendAddressPools,omitempty"`
	LoadBalancerBackendAddressPools       *[]SubResource                                      `json:"loadBalancerBackendAddressPools,omitempty"`
	LoadBalancerInboundNatPools           *[]SubResource                                      `json:"loadBalancerInboundNatPools,omitempty"`
}

// VirtualMachineScaleSetListResult is the List Virtual Machine operation response.
type VirtualMachineScaleSetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineScaleSet `json:"value,omitempty"`
	NextLink          *string                   `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineScaleSetListResult) VirtualMachineScaleSetListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineScaleSetListSkusResult is the Virtual Machine Scale Set List Skus operation response.
type VirtualMachineScaleSetListSkusResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineScaleSetSku `json:"value,omitempty"`
	NextLink          *string                      `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListSkusResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineScaleSetListSkusResult) VirtualMachineScaleSetListSkusResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineScaleSetListWithLinkResult is the List Virtual Machine operation response.
type VirtualMachineScaleSetListWithLinkResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineScaleSet `json:"value,omitempty"`
	NextLink          *string                   `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListWithLinkResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineScaleSetListWithLinkResult) VirtualMachineScaleSetListWithLinkResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineScaleSetManagedDiskParameters is describes the parameters of a ScaleSet managed disk.
type VirtualMachineScaleSetManagedDiskParameters struct {
	StorageAccountType StorageAccountTypes `json:"storageAccountType,omitempty"`
}

// VirtualMachineScaleSetNetworkConfiguration is describes a virtual machine scale set network profile's network
// configurations.
type VirtualMachineScaleSetNetworkConfiguration struct {
	ID                                                    *string `json:"id,omitempty"`
	Name                                                  *string `json:"name,omitempty"`
	*VirtualMachineScaleSetNetworkConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetNetworkConfigurationDNSSettings is describes a virtual machines scale sets network
// configuration's DNS settings.
type VirtualMachineScaleSetNetworkConfigurationDNSSettings struct {
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// VirtualMachineScaleSetNetworkConfigurationProperties is describes a virtual machine scale set network profile's IP
// configuration.
type VirtualMachineScaleSetNetworkConfigurationProperties struct {
	Primary                     *bool                                                  `json:"primary,omitempty"`
	EnableAcceleratedNetworking *bool                                                  `json:"enableAcceleratedNetworking,omitempty"`
	NetworkSecurityGroup        *SubResource                                           `json:"networkSecurityGroup,omitempty"`
	DNSSettings                 *VirtualMachineScaleSetNetworkConfigurationDNSSettings `json:"dnsSettings,omitempty"`
	IPConfigurations            *[]VirtualMachineScaleSetIPConfiguration               `json:"ipConfigurations,omitempty"`
}

// VirtualMachineScaleSetNetworkProfile is describes a virtual machine scale set network profile.
type VirtualMachineScaleSetNetworkProfile struct {
	HealthProbe                    *APIEntityReference                           `json:"healthProbe,omitempty"`
	NetworkInterfaceConfigurations *[]VirtualMachineScaleSetNetworkConfiguration `json:"networkInterfaceConfigurations,omitempty"`
}

// VirtualMachineScaleSetOSDisk is describes a virtual machine scale set operating system disk.
type VirtualMachineScaleSetOSDisk struct {
	Name          *string                                      `json:"name,omitempty"`
	Caching       CachingTypes                                 `json:"caching,omitempty"`
	CreateOption  DiskCreateOptionTypes                        `json:"createOption,omitempty"`
	OsType        OperatingSystemTypes                         `json:"osType,omitempty"`
	Image         *VirtualHardDisk                             `json:"image,omitempty"`
	VhdContainers *[]string                                    `json:"vhdContainers,omitempty"`
	ManagedDisk   *VirtualMachineScaleSetManagedDiskParameters `json:"managedDisk,omitempty"`
}

// VirtualMachineScaleSetOSProfile is describes a virtual machine scale set OS profile.
type VirtualMachineScaleSetOSProfile struct {
	ComputerNamePrefix   *string               `json:"computerNamePrefix,omitempty"`
	AdminUsername        *string               `json:"adminUsername,omitempty"`
	AdminPassword        *string               `json:"adminPassword,omitempty"`
	CustomData           *string               `json:"customData,omitempty"`
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	LinuxConfiguration   *LinuxConfiguration   `json:"linuxConfiguration,omitempty"`
	Secrets              *[]VaultSecretGroup   `json:"secrets,omitempty"`
}

// VirtualMachineScaleSetProperties is describes the properties of a Virtual Machine Scale Set.
type VirtualMachineScaleSetProperties struct {
	UpgradePolicy         *UpgradePolicy                   `json:"upgradePolicy,omitempty"`
	VirtualMachineProfile *VirtualMachineScaleSetVMProfile `json:"virtualMachineProfile,omitempty"`
	ProvisioningState     *string                          `json:"provisioningState,omitempty"`
	Overprovision         *bool                            `json:"overprovision,omitempty"`
	UniqueID              *string                          `json:"uniqueId,omitempty"`
	SinglePlacementGroup  *bool                            `json:"singlePlacementGroup,omitempty"`
}

// VirtualMachineScaleSetPublicIPAddressConfiguration is describes a virtual machines scale set IP Configuration's
// PublicIPAddress configuration
type VirtualMachineScaleSetPublicIPAddressConfiguration struct {
	Name                                                          *string `json:"name,omitempty"`
	*VirtualMachineScaleSetPublicIPAddressConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings is describes a virtual machines scale sets network
// configuration's DNS settings.
type VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings struct {
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
}

// VirtualMachineScaleSetPublicIPAddressConfigurationProperties is describes a virtual machines scale set IP
// Configuration's PublicIPAddress configuration
type VirtualMachineScaleSetPublicIPAddressConfigurationProperties struct {
	IdleTimeoutInMinutes *int32                                                         `json:"idleTimeoutInMinutes,omitempty"`
	DNSSettings          *VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings `json:"dnsSettings,omitempty"`
}

// VirtualMachineScaleSetSku is describes an available virtual machine scale set sku.
type VirtualMachineScaleSetSku struct {
	ResourceType *string                            `json:"resourceType,omitempty"`
	Sku          *Sku                               `json:"sku,omitempty"`
	Capacity     *VirtualMachineScaleSetSkuCapacity `json:"capacity,omitempty"`
}

// VirtualMachineScaleSetSkuCapacity is describes scaling information of a sku.
type VirtualMachineScaleSetSkuCapacity struct {
	Minimum         *int64                             `json:"minimum,omitempty"`
	Maximum         *int64                             `json:"maximum,omitempty"`
	DefaultCapacity *int64                             `json:"defaultCapacity,omitempty"`
	ScaleType       VirtualMachineScaleSetSkuScaleType `json:"scaleType,omitempty"`
}

// VirtualMachineScaleSetStorageProfile is describes a virtual machine scale set storage profile.
type VirtualMachineScaleSetStorageProfile struct {
	ImageReference *ImageReference                   `json:"imageReference,omitempty"`
	OsDisk         *VirtualMachineScaleSetOSDisk     `json:"osDisk,omitempty"`
	DataDisks      *[]VirtualMachineScaleSetDataDisk `json:"dataDisks,omitempty"`
}

// VirtualMachineScaleSetUpdate is describes a Virtual Machine Scale Set.
type VirtualMachineScaleSetUpdate struct {
	Tags                                    *map[string]*string `json:"tags,omitempty"`
	Sku                                     *Sku                `json:"sku,omitempty"`
	Plan                                    *Plan               `json:"plan,omitempty"`
	*VirtualMachineScaleSetUpdateProperties `json:"properties,omitempty"`
	Identity                                *VirtualMachineScaleSetIdentity `json:"identity,omitempty"`
}

// VirtualMachineScaleSetUpdateIPConfiguration is describes a virtual machine scale set network profile's IP
// configuration.
type VirtualMachineScaleSetUpdateIPConfiguration struct {
	ID                                                     *string `json:"id,omitempty"`
	Name                                                   *string `json:"name,omitempty"`
	*VirtualMachineScaleSetUpdateIPConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetUpdateIPConfigurationProperties is describes a virtual machine scale set network profile's IP
// configuration properties.
type VirtualMachineScaleSetUpdateIPConfigurationProperties struct {
	Subnet                                *APIEntityReference                                       `json:"subnet,omitempty"`
	Primary                               *bool                                                     `json:"primary,omitempty"`
	PublicIPAddressConfiguration          *VirtualMachineScaleSetUpdatePublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`
	PrivateIPAddressVersion               IPVersion                                                 `json:"privateIPAddressVersion,omitempty"`
	ApplicationGatewayBackendAddressPools *[]SubResource                                            `json:"applicationGatewayBackendAddressPools,omitempty"`
	LoadBalancerBackendAddressPools       *[]SubResource                                            `json:"loadBalancerBackendAddressPools,omitempty"`
	LoadBalancerInboundNatPools           *[]SubResource                                            `json:"loadBalancerInboundNatPools,omitempty"`
}

// VirtualMachineScaleSetUpdateNetworkConfiguration is describes a virtual machine scale set network profile's network
// configurations.
type VirtualMachineScaleSetUpdateNetworkConfiguration struct {
	ID                                                          *string `json:"id,omitempty"`
	Name                                                        *string `json:"name,omitempty"`
	*VirtualMachineScaleSetUpdateNetworkConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetUpdateNetworkConfigurationProperties is describes a virtual machine scale set updatable
// network profile's IP configuration.Use this object for updating network profile's IP Configuration.
type VirtualMachineScaleSetUpdateNetworkConfigurationProperties struct {
	Primary                     *bool                                                  `json:"primary,omitempty"`
	EnableAcceleratedNetworking *bool                                                  `json:"enableAcceleratedNetworking,omitempty"`
	NetworkSecurityGroup        *SubResource                                           `json:"networkSecurityGroup,omitempty"`
	DNSSettings                 *VirtualMachineScaleSetNetworkConfigurationDNSSettings `json:"dnsSettings,omitempty"`
	IPConfigurations            *[]VirtualMachineScaleSetUpdateIPConfiguration         `json:"ipConfigurations,omitempty"`
}

// VirtualMachineScaleSetUpdateNetworkProfile is describes a virtual machine scale set network profile.
type VirtualMachineScaleSetUpdateNetworkProfile struct {
	NetworkInterfaceConfigurations *[]VirtualMachineScaleSetUpdateNetworkConfiguration `json:"networkInterfaceConfigurations,omitempty"`
}

// VirtualMachineScaleSetUpdateOSDisk is describes virtual machine scale set operating system disk Update Object. This
// should be used for Updating VMSS OS Disk.
type VirtualMachineScaleSetUpdateOSDisk struct {
	Caching       CachingTypes                                 `json:"caching,omitempty"`
	Image         *VirtualHardDisk                             `json:"image,omitempty"`
	VhdContainers *[]string                                    `json:"vhdContainers,omitempty"`
	ManagedDisk   *VirtualMachineScaleSetManagedDiskParameters `json:"managedDisk,omitempty"`
}

// VirtualMachineScaleSetUpdateOSProfile is describes a virtual machine scale set OS profile.
type VirtualMachineScaleSetUpdateOSProfile struct {
	CustomData           *string               `json:"customData,omitempty"`
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	LinuxConfiguration   *LinuxConfiguration   `json:"linuxConfiguration,omitempty"`
	Secrets              *[]VaultSecretGroup   `json:"secrets,omitempty"`
}

// VirtualMachineScaleSetUpdateProperties is describes the properties of a Virtual Machine Scale Set.
type VirtualMachineScaleSetUpdateProperties struct {
	UpgradePolicy         *UpgradePolicy                         `json:"upgradePolicy,omitempty"`
	VirtualMachineProfile *VirtualMachineScaleSetUpdateVMProfile `json:"virtualMachineProfile,omitempty"`
	Overprovision         *bool                                  `json:"overprovision,omitempty"`
	SinglePlacementGroup  *bool                                  `json:"singlePlacementGroup,omitempty"`
}

// VirtualMachineScaleSetUpdatePublicIPAddressConfiguration is describes a virtual machines scale set IP
// Configuration's PublicIPAddress configuration
type VirtualMachineScaleSetUpdatePublicIPAddressConfiguration struct {
	Name                                                                *string `json:"name,omitempty"`
	*VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties is describes a virtual machines scale set IP
// Configuration's PublicIPAddress configuration
type VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties struct {
	IdleTimeoutInMinutes *int32                                                         `json:"idleTimeoutInMinutes,omitempty"`
	DNSSettings          *VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings `json:"dnsSettings,omitempty"`
}

// VirtualMachineScaleSetUpdateStorageProfile is describes a virtual machine scale set storage profile.
type VirtualMachineScaleSetUpdateStorageProfile struct {
	ImageReference *ImageReference                     `json:"imageReference,omitempty"`
	OsDisk         *VirtualMachineScaleSetUpdateOSDisk `json:"osDisk,omitempty"`
	DataDisks      *[]VirtualMachineScaleSetDataDisk   `json:"dataDisks,omitempty"`
}

// VirtualMachineScaleSetUpdateVMProfile is describes a virtual machine scale set virtual machine profile.
type VirtualMachineScaleSetUpdateVMProfile struct {
	OsProfile          *VirtualMachineScaleSetUpdateOSProfile      `json:"osProfile,omitempty"`
	StorageProfile     *VirtualMachineScaleSetUpdateStorageProfile `json:"storageProfile,omitempty"`
	NetworkProfile     *VirtualMachineScaleSetUpdateNetworkProfile `json:"networkProfile,omitempty"`
	DiagnosticsProfile *DiagnosticsProfile                         `json:"diagnosticsProfile,omitempty"`
	ExtensionProfile   *VirtualMachineScaleSetExtensionProfile     `json:"extensionProfile,omitempty"`
	LicenseType        *string                                     `json:"licenseType,omitempty"`
}

// VirtualMachineScaleSetVM is describes a virtual machine scale set virtual machine.
type VirtualMachineScaleSetVM struct {
	autorest.Response                   `json:"-"`
	ID                                  *string             `json:"id,omitempty"`
	Name                                *string             `json:"name,omitempty"`
	Type                                *string             `json:"type,omitempty"`
	Location                            *string             `json:"location,omitempty"`
	Tags                                *map[string]*string `json:"tags,omitempty"`
	InstanceID                          *string             `json:"instanceId,omitempty"`
	Sku                                 *Sku                `json:"sku,omitempty"`
	*VirtualMachineScaleSetVMProperties `json:"properties,omitempty"`
	Plan                                *Plan                      `json:"plan,omitempty"`
	Resources                           *[]VirtualMachineExtension `json:"resources,omitempty"`
}

// VirtualMachineScaleSetVMExtensionsSummary is extensions summary for virtual machines of a virtual machine scale set.
type VirtualMachineScaleSetVMExtensionsSummary struct {
	Name            *string                          `json:"name,omitempty"`
	StatusesSummary *[]VirtualMachineStatusCodeCount `json:"statusesSummary,omitempty"`
}

// VirtualMachineScaleSetVMInstanceIDs is specifies a list of virtual machine instance IDs from the VM scale set.
type VirtualMachineScaleSetVMInstanceIDs struct {
	InstanceIds *[]string `json:"instanceIds,omitempty"`
}

// VirtualMachineScaleSetVMInstanceRequiredIDs is specifies a list of virtual machine instance IDs from the VM scale
// set.
type VirtualMachineScaleSetVMInstanceRequiredIDs struct {
	InstanceIds *[]string `json:"instanceIds,omitempty"`
}

// VirtualMachineScaleSetVMInstanceView is the instance view of a virtual machine scale set VM.
type VirtualMachineScaleSetVMInstanceView struct {
	autorest.Response    `json:"-"`
	PlatformUpdateDomain *int32                                 `json:"platformUpdateDomain,omitempty"`
	PlatformFaultDomain  *int32                                 `json:"platformFaultDomain,omitempty"`
	RdpThumbPrint        *string                                `json:"rdpThumbPrint,omitempty"`
	VMAgent              *VirtualMachineAgentInstanceView       `json:"vmAgent,omitempty"`
	Disks                *[]DiskInstanceView                    `json:"disks,omitempty"`
	Extensions           *[]VirtualMachineExtensionInstanceView `json:"extensions,omitempty"`
	VMHealth             *VirtualMachineHealthStatus            `json:"vmHealth,omitempty"`
	BootDiagnostics      *BootDiagnosticsInstanceView           `json:"bootDiagnostics,omitempty"`
	Statuses             *[]InstanceViewStatus                  `json:"statuses,omitempty"`
	PlacementGroupID     *string                                `json:"placementGroupId,omitempty"`
}

// VirtualMachineScaleSetVMListResult is the List Virtual Machine Scale Set VMs operation response.
type VirtualMachineScaleSetVMListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineScaleSetVM `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetVMListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineScaleSetVMListResult) VirtualMachineScaleSetVMListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineScaleSetVMProfile is describes a virtual machine scale set virtual machine profile.
type VirtualMachineScaleSetVMProfile struct {
	OsProfile          *VirtualMachineScaleSetOSProfile        `json:"osProfile,omitempty"`
	StorageProfile     *VirtualMachineScaleSetStorageProfile   `json:"storageProfile,omitempty"`
	NetworkProfile     *VirtualMachineScaleSetNetworkProfile   `json:"networkProfile,omitempty"`
	DiagnosticsProfile *DiagnosticsProfile                     `json:"diagnosticsProfile,omitempty"`
	ExtensionProfile   *VirtualMachineScaleSetExtensionProfile `json:"extensionProfile,omitempty"`
	LicenseType        *string                                 `json:"licenseType,omitempty"`
}

// VirtualMachineScaleSetVMProperties is describes the properties of a virtual machine scale set virtual machine.
type VirtualMachineScaleSetVMProperties struct {
	LatestModelApplied *bool                       `json:"latestModelApplied,omitempty"`
	VMID               *string                     `json:"vmId,omitempty"`
	InstanceView       *VirtualMachineInstanceView `json:"instanceView,omitempty"`
	HardwareProfile    *HardwareProfile            `json:"hardwareProfile,omitempty"`
	StorageProfile     *StorageProfile             `json:"storageProfile,omitempty"`
	OsProfile          *OSProfile                  `json:"osProfile,omitempty"`
	NetworkProfile     *NetworkProfile             `json:"networkProfile,omitempty"`
	DiagnosticsProfile *DiagnosticsProfile         `json:"diagnosticsProfile,omitempty"`
	AvailabilitySet    *SubResource                `json:"availabilitySet,omitempty"`
	ProvisioningState  *string                     `json:"provisioningState,omitempty"`
	LicenseType        *string                     `json:"licenseType,omitempty"`
}

// VirtualMachineSize is describes the properties of a VM size.
type VirtualMachineSize struct {
	Name                 *string `json:"name,omitempty"`
	NumberOfCores        *int32  `json:"numberOfCores,omitempty"`
	OsDiskSizeInMB       *int32  `json:"osDiskSizeInMB,omitempty"`
	ResourceDiskSizeInMB *int32  `json:"resourceDiskSizeInMB,omitempty"`
	MemoryInMB           *int32  `json:"memoryInMB,omitempty"`
	MaxDataDiskCount     *int32  `json:"maxDataDiskCount,omitempty"`
}

// VirtualMachineSizeListResult is the List Virtual Machine operation response.
type VirtualMachineSizeListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineSize `json:"value,omitempty"`
}

// VirtualMachineStatusCodeCount is the status code and count of the virtual machine scale set instance view status
// summary.
type VirtualMachineStatusCodeCount struct {
	Code  *string `json:"code,omitempty"`
	Count *int32  `json:"count,omitempty"`
}

// WindowsConfiguration is specifies Windows operating system settings on the virtual machine.
type WindowsConfiguration struct {
	ProvisionVMAgent          *bool                        `json:"provisionVMAgent,omitempty"`
	EnableAutomaticUpdates    *bool                        `json:"enableAutomaticUpdates,omitempty"`
	TimeZone                  *string                      `json:"timeZone,omitempty"`
	AdditionalUnattendContent *[]AdditionalUnattendContent `json:"additionalUnattendContent,omitempty"`
	WinRM                     *WinRMConfiguration          `json:"winRM,omitempty"`
}

// WinRMConfiguration is describes Windows Remote Management configuration of the VM
type WinRMConfiguration struct {
	Listeners *[]WinRMListener `json:"listeners,omitempty"`
}

// WinRMListener is describes Protocol and thumbprint of Windows Remote Management listener
type WinRMListener struct {
	Protocol       ProtocolTypes `json:"protocol,omitempty"`
	CertificateURL *string       `json:"certificateUrl,omitempty"`
}
