/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/ptp-operator/pkg/apis/ptp/v1"
	scheme "github.com/openshift/ptp-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PtpOperatorConfigsGetter has a method to return a PtpOperatorConfigInterface.
// A group's client should implement this interface.
type PtpOperatorConfigsGetter interface {
	PtpOperatorConfigs(namespace string) PtpOperatorConfigInterface
}

// PtpOperatorConfigInterface has methods to work with PtpOperatorConfig resources.
type PtpOperatorConfigInterface interface {
	Create(*v1.PtpOperatorConfig) (*v1.PtpOperatorConfig, error)
	Update(*v1.PtpOperatorConfig) (*v1.PtpOperatorConfig, error)
	UpdateStatus(*v1.PtpOperatorConfig) (*v1.PtpOperatorConfig, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.PtpOperatorConfig, error)
	List(opts metav1.ListOptions) (*v1.PtpOperatorConfigList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.PtpOperatorConfig, err error)
	PtpOperatorConfigExpansion
}

// ptpOperatorConfigs implements PtpOperatorConfigInterface
type ptpOperatorConfigs struct {
	client rest.Interface
	ns     string
}

// newPtpOperatorConfigs returns a PtpOperatorConfigs
func newPtpOperatorConfigs(c *PtpV1Client, namespace string) *ptpOperatorConfigs {
	return &ptpOperatorConfigs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the ptpOperatorConfig, and returns the corresponding ptpOperatorConfig object, and an error if there is any.
func (c *ptpOperatorConfigs) Get(name string, options metav1.GetOptions) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PtpOperatorConfigs that match those selectors.
func (c *ptpOperatorConfigs) List(opts metav1.ListOptions) (result *v1.PtpOperatorConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.PtpOperatorConfigList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ptpOperatorConfigs.
func (c *ptpOperatorConfigs) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a ptpOperatorConfig and creates it.  Returns the server's representation of the ptpOperatorConfig, and an error, if there is any.
func (c *ptpOperatorConfigs) Create(ptpOperatorConfig *v1.PtpOperatorConfig) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Body(ptpOperatorConfig).
		Do().
		Into(result)
	return
}

// Update takes the representation of a ptpOperatorConfig and updates it. Returns the server's representation of the ptpOperatorConfig, and an error, if there is any.
func (c *ptpOperatorConfigs) Update(ptpOperatorConfig *v1.PtpOperatorConfig) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Name(ptpOperatorConfig.Name).
		Body(ptpOperatorConfig).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *ptpOperatorConfigs) UpdateStatus(ptpOperatorConfig *v1.PtpOperatorConfig) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Name(ptpOperatorConfig.Name).
		SubResource("status").
		Body(ptpOperatorConfig).
		Do().
		Into(result)
	return
}

// Delete takes name of the ptpOperatorConfig and deletes it. Returns an error if one occurs.
func (c *ptpOperatorConfigs) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ptpOperatorConfigs) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched ptpOperatorConfig.
func (c *ptpOperatorConfigs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.PtpOperatorConfig, err error) {
	result = &v1.PtpOperatorConfig{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("ptpoperatorconfigs").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
