// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/ptp-operator/pkg/apis/ptp/v1"
	scheme "github.com/openshift/ptp-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// NodePtpDevicesGetter has a method to return a NodePtpDeviceInterface.
// A group's client should implement this interface.
type NodePtpDevicesGetter interface {
	NodePtpDevices(namespace string) NodePtpDeviceInterface
}

// NodePtpDeviceInterface has methods to work with NodePtpDevice resources.
type NodePtpDeviceInterface interface {
	Create(ctx context.Context, nodePtpDevice *v1.NodePtpDevice, opts metav1.CreateOptions) (*v1.NodePtpDevice, error)
	Update(ctx context.Context, nodePtpDevice *v1.NodePtpDevice, opts metav1.UpdateOptions) (*v1.NodePtpDevice, error)
	UpdateStatus(ctx context.Context, nodePtpDevice *v1.NodePtpDevice, opts metav1.UpdateOptions) (*v1.NodePtpDevice, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.NodePtpDevice, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.NodePtpDeviceList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.NodePtpDevice, err error)
	NodePtpDeviceExpansion
}

// nodePtpDevices implements NodePtpDeviceInterface
type nodePtpDevices struct {
	client rest.Interface
	ns     string
}

// newNodePtpDevices returns a NodePtpDevices
func newNodePtpDevices(c *PtpV1Client, namespace string) *nodePtpDevices {
	return &nodePtpDevices{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the nodePtpDevice, and returns the corresponding nodePtpDevice object, and an error if there is any.
func (c *nodePtpDevices) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of NodePtpDevices that match those selectors.
func (c *nodePtpDevices) List(ctx context.Context, opts metav1.ListOptions) (result *v1.NodePtpDeviceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.NodePtpDeviceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested nodePtpDevices.
func (c *nodePtpDevices) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a nodePtpDevice and creates it.  Returns the server's representation of the nodePtpDevice, and an error, if there is any.
func (c *nodePtpDevices) Create(ctx context.Context, nodePtpDevice *v1.NodePtpDevice, opts metav1.CreateOptions) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nodePtpDevice).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a nodePtpDevice and updates it. Returns the server's representation of the nodePtpDevice, and an error, if there is any.
func (c *nodePtpDevices) Update(ctx context.Context, nodePtpDevice *v1.NodePtpDevice, opts metav1.UpdateOptions) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Name(nodePtpDevice.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nodePtpDevice).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *nodePtpDevices) UpdateStatus(ctx context.Context, nodePtpDevice *v1.NodePtpDevice, opts metav1.UpdateOptions) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Name(nodePtpDevice.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nodePtpDevice).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the nodePtpDevice and deletes it. Returns an error if one occurs.
func (c *nodePtpDevices) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *nodePtpDevices) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched nodePtpDevice.
func (c *nodePtpDevices) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
