// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/api/config/v1"
	scheme "github.com/openshift/client-go/config/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// OAuthsGetter has a method to return a OAuthInterface.
// A group's client should implement this interface.
type OAuthsGetter interface {
	OAuths() OAuthInterface
}

// OAuthInterface has methods to work with OAuth resources.
type OAuthInterface interface {
	Create(*v1.OAuth) (*v1.OAuth, error)
	Update(*v1.OAuth) (*v1.OAuth, error)
	UpdateStatus(*v1.OAuth) (*v1.OAuth, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.OAuth, error)
	List(opts metav1.ListOptions) (*v1.OAuthList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.OAuth, err error)
	OAuthExpansion
}

// oAuths implements OAuthInterface
type oAuths struct {
	client rest.Interface
}

// newOAuths returns a OAuths
func newOAuths(c *ConfigV1Client) *oAuths {
	return &oAuths{
		client: c.RESTClient(),
	}
}

// Get takes name of the oAuth, and returns the corresponding oAuth object, and an error if there is any.
func (c *oAuths) Get(name string, options metav1.GetOptions) (result *v1.OAuth, err error) {
	result = &v1.OAuth{}
	err = c.client.Get().
		Resource("oauths").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OAuths that match those selectors.
func (c *oAuths) List(opts metav1.ListOptions) (result *v1.OAuthList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.OAuthList{}
	err = c.client.Get().
		Resource("oauths").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested oAuths.
func (c *oAuths) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("oauths").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a oAuth and creates it.  Returns the server's representation of the oAuth, and an error, if there is any.
func (c *oAuths) Create(oAuth *v1.OAuth) (result *v1.OAuth, err error) {
	result = &v1.OAuth{}
	err = c.client.Post().
		Resource("oauths").
		Body(oAuth).
		Do().
		Into(result)
	return
}

// Update takes the representation of a oAuth and updates it. Returns the server's representation of the oAuth, and an error, if there is any.
func (c *oAuths) Update(oAuth *v1.OAuth) (result *v1.OAuth, err error) {
	result = &v1.OAuth{}
	err = c.client.Put().
		Resource("oauths").
		Name(oAuth.Name).
		Body(oAuth).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *oAuths) UpdateStatus(oAuth *v1.OAuth) (result *v1.OAuth, err error) {
	result = &v1.OAuth{}
	err = c.client.Put().
		Resource("oauths").
		Name(oAuth.Name).
		SubResource("status").
		Body(oAuth).
		Do().
		Into(result)
	return
}

// Delete takes name of the oAuth and deletes it. Returns an error if one occurs.
func (c *oAuths) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("oauths").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *oAuths) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("oauths").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched oAuth.
func (c *oAuths) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.OAuth, err error) {
	result = &v1.OAuth{}
	err = c.client.Patch(pt).
		Resource("oauths").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
