package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_Link = map[string]string{
	"":     "Represents a standard link that could be generated in HTML",
	"text": "text is the display text for the link",
	"href": "href is the absolute secure URL for the link (must use https)",
}

func (Link) SwaggerDoc() map[string]string {
	return map_Link
}

var map_ConsoleCLIDownload = map[string]string{
	"":         "ConsoleCLIDownload is an extension for configuring openshift web console command line interface (CLI) downloads.",
	"metadata": "Standard object's metadata.",
}

func (ConsoleCLIDownload) SwaggerDoc() map[string]string {
	return map_ConsoleCLIDownload
}

var map_ConsoleCLIDownloadList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ConsoleCLIDownloadList) SwaggerDoc() map[string]string {
	return map_ConsoleCLIDownloadList
}

var map_ConsoleCLIDownloadSpec = map[string]string{
	"":            "ConsoleCLIDownloadSpec is the desired cli download configuration.",
	"displayName": "displayName is the display name of the CLI download.",
	"description": "description is the description of the CLI download (can include markdown).",
	"links":       "links is a list of objects that provide CLI download link details.",
}

func (ConsoleCLIDownloadSpec) SwaggerDoc() map[string]string {
	return map_ConsoleCLIDownloadSpec
}

var map_ConsoleLink = map[string]string{
	"":         "ConsoleLink is an extension for customizing OpenShift web console links.",
	"metadata": "Standard object's metadata.",
}

func (ConsoleLink) SwaggerDoc() map[string]string {
	return map_ConsoleLink
}

var map_ConsoleLinkList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ConsoleLinkList) SwaggerDoc() map[string]string {
	return map_ConsoleLinkList
}

var map_ConsoleLinkSpec = map[string]string{
	"":         "ConsoleLinkSpec is the desired console link configuration.",
	"location": "location determines which location in the console the link will be appended to.",
}

func (ConsoleLinkSpec) SwaggerDoc() map[string]string {
	return map_ConsoleLinkSpec
}

var map_ConsoleNotification = map[string]string{
	"":         "ConsoleNotification is the extension for configuring openshift web console notifications.",
	"metadata": "Standard object's metadata.",
}

func (ConsoleNotification) SwaggerDoc() map[string]string {
	return map_ConsoleNotification
}

var map_ConsoleNotificationList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ConsoleNotificationList) SwaggerDoc() map[string]string {
	return map_ConsoleNotificationList
}

var map_ConsoleNotificationSpec = map[string]string{
	"":                "ConsoleNotificationSpec is the desired console notification configuration.",
	"text":            "text is the visible text of the notification.",
	"location":        "location is the location of the notification in the console.",
	"link":            "link is an object that holds notification link details.",
	"color":           "color is the color of the text for the notification as CSS data type color.",
	"backgroundColor": "backgroundColor is the color of the background for the notification as CSS data type color.",
}

func (ConsoleNotificationSpec) SwaggerDoc() map[string]string {
	return map_ConsoleNotificationSpec
}

// AUTO-GENERATED FUNCTIONS END HERE
