// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: rpc.proto

/*
	Package storepb is a generated protocol buffer package.

	It is generated from these files:
		rpc.proto
		types.proto

	It has these top-level messages:
		InfoRequest
		InfoResponse
		SeriesRequest
		SeriesResponse
		LabelNamesRequest
		LabelNamesResponse
		LabelValuesRequest
		LabelValuesResponse
		Label
		Chunk
		Series
		AggrChunk
		LabelMatcher
*/
package storepb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Aggr int32

const (
	Aggr_RAW     Aggr = 0
	Aggr_COUNT   Aggr = 1
	Aggr_SUM     Aggr = 2
	Aggr_MIN     Aggr = 3
	Aggr_MAX     Aggr = 4
	Aggr_COUNTER Aggr = 5
)

var Aggr_name = map[int32]string{
	0: "RAW",
	1: "COUNT",
	2: "SUM",
	3: "MIN",
	4: "MAX",
	5: "COUNTER",
}
var Aggr_value = map[string]int32{
	"RAW":     0,
	"COUNT":   1,
	"SUM":     2,
	"MIN":     3,
	"MAX":     4,
	"COUNTER": 5,
}

func (x Aggr) String() string {
	return proto.EnumName(Aggr_name, int32(x))
}
func (Aggr) EnumDescriptor() ([]byte, []int) { return fileDescriptorRpc, []int{0} }

type InfoRequest struct {
}

func (m *InfoRequest) Reset()                    { *m = InfoRequest{} }
func (m *InfoRequest) String() string            { return proto.CompactTextString(m) }
func (*InfoRequest) ProtoMessage()               {}
func (*InfoRequest) Descriptor() ([]byte, []int) { return fileDescriptorRpc, []int{0} }

type InfoResponse struct {
	Labels  []Label `protobuf:"bytes,1,rep,name=labels" json:"labels"`
	MinTime int64   `protobuf:"varint,2,opt,name=min_time,json=minTime,proto3" json:"min_time,omitempty"`
	MaxTime int64   `protobuf:"varint,3,opt,name=max_time,json=maxTime,proto3" json:"max_time,omitempty"`
}

func (m *InfoResponse) Reset()                    { *m = InfoResponse{} }
func (m *InfoResponse) String() string            { return proto.CompactTextString(m) }
func (*InfoResponse) ProtoMessage()               {}
func (*InfoResponse) Descriptor() ([]byte, []int) { return fileDescriptorRpc, []int{1} }

type SeriesRequest struct {
	MinTime             int64          `protobuf:"varint,1,opt,name=min_time,json=minTime,proto3" json:"min_time,omitempty"`
	MaxTime             int64          `protobuf:"varint,2,opt,name=max_time,json=maxTime,proto3" json:"max_time,omitempty"`
	Matchers            []LabelMatcher `protobuf:"bytes,3,rep,name=matchers" json:"matchers"`
	MaxResolutionWindow int64          `protobuf:"varint,4,opt,name=max_resolution_window,json=maxResolutionWindow,proto3" json:"max_resolution_window,omitempty"`
	Aggregates          []Aggr         `protobuf:"varint,5,rep,packed,name=aggregates,enum=thanos.Aggr" json:"aggregates,omitempty"`
}

func (m *SeriesRequest) Reset()                    { *m = SeriesRequest{} }
func (m *SeriesRequest) String() string            { return proto.CompactTextString(m) }
func (*SeriesRequest) ProtoMessage()               {}
func (*SeriesRequest) Descriptor() ([]byte, []int) { return fileDescriptorRpc, []int{2} }

type SeriesResponse struct {
	// Types that are valid to be assigned to Result:
	//	*SeriesResponse_Series
	//	*SeriesResponse_Warning
	Result isSeriesResponse_Result `protobuf_oneof:"result"`
}

func (m *SeriesResponse) Reset()                    { *m = SeriesResponse{} }
func (m *SeriesResponse) String() string            { return proto.CompactTextString(m) }
func (*SeriesResponse) ProtoMessage()               {}
func (*SeriesResponse) Descriptor() ([]byte, []int) { return fileDescriptorRpc, []int{3} }

type isSeriesResponse_Result interface {
	isSeriesResponse_Result()
	MarshalTo([]byte) (int, error)
	Size() int
}

type SeriesResponse_Series struct {
	Series *Series `protobuf:"bytes,1,opt,name=series,oneof"`
}
type SeriesResponse_Warning struct {
	Warning string `protobuf:"bytes,2,opt,name=warning,proto3,oneof"`
}

func (*SeriesResponse_Series) isSeriesResponse_Result()  {}
func (*SeriesResponse_Warning) isSeriesResponse_Result() {}

func (m *SeriesResponse) GetResult() isSeriesResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *SeriesResponse) GetSeries() *Series {
	if x, ok := m.GetResult().(*SeriesResponse_Series); ok {
		return x.Series
	}
	return nil
}

func (m *SeriesResponse) GetWarning() string {
	if x, ok := m.GetResult().(*SeriesResponse_Warning); ok {
		return x.Warning
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SeriesResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SeriesResponse_OneofMarshaler, _SeriesResponse_OneofUnmarshaler, _SeriesResponse_OneofSizer, []interface{}{
		(*SeriesResponse_Series)(nil),
		(*SeriesResponse_Warning)(nil),
	}
}

func _SeriesResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SeriesResponse)
	// result
	switch x := m.Result.(type) {
	case *SeriesResponse_Series:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Series); err != nil {
			return err
		}
	case *SeriesResponse_Warning:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Warning)
	case nil:
	default:
		return fmt.Errorf("SeriesResponse.Result has unexpected type %T", x)
	}
	return nil
}

func _SeriesResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SeriesResponse)
	switch tag {
	case 1: // result.series
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Series)
		err := b.DecodeMessage(msg)
		m.Result = &SeriesResponse_Series{msg}
		return true, err
	case 2: // result.warning
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Result = &SeriesResponse_Warning{x}
		return true, err
	default:
		return false, nil
	}
}

func _SeriesResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SeriesResponse)
	// result
	switch x := m.Result.(type) {
	case *SeriesResponse_Series:
		s := proto.Size(x.Series)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SeriesResponse_Warning:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Warning)))
		n += len(x.Warning)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type LabelNamesRequest struct {
}

func (m *LabelNamesRequest) Reset()                    { *m = LabelNamesRequest{} }
func (m *LabelNamesRequest) String() string            { return proto.CompactTextString(m) }
func (*LabelNamesRequest) ProtoMessage()               {}
func (*LabelNamesRequest) Descriptor() ([]byte, []int) { return fileDescriptorRpc, []int{4} }

type LabelNamesResponse struct {
	Names    []string `protobuf:"bytes,1,rep,name=names" json:"names,omitempty"`
	Warnings []string `protobuf:"bytes,2,rep,name=warnings" json:"warnings,omitempty"`
}

func (m *LabelNamesResponse) Reset()                    { *m = LabelNamesResponse{} }
func (m *LabelNamesResponse) String() string            { return proto.CompactTextString(m) }
func (*LabelNamesResponse) ProtoMessage()               {}
func (*LabelNamesResponse) Descriptor() ([]byte, []int) { return fileDescriptorRpc, []int{5} }

type LabelValuesRequest struct {
	Label string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
}

func (m *LabelValuesRequest) Reset()                    { *m = LabelValuesRequest{} }
func (m *LabelValuesRequest) String() string            { return proto.CompactTextString(m) }
func (*LabelValuesRequest) ProtoMessage()               {}
func (*LabelValuesRequest) Descriptor() ([]byte, []int) { return fileDescriptorRpc, []int{6} }

type LabelValuesResponse struct {
	Values   []string `protobuf:"bytes,1,rep,name=values" json:"values,omitempty"`
	Warnings []string `protobuf:"bytes,2,rep,name=warnings" json:"warnings,omitempty"`
}

func (m *LabelValuesResponse) Reset()                    { *m = LabelValuesResponse{} }
func (m *LabelValuesResponse) String() string            { return proto.CompactTextString(m) }
func (*LabelValuesResponse) ProtoMessage()               {}
func (*LabelValuesResponse) Descriptor() ([]byte, []int) { return fileDescriptorRpc, []int{7} }

func init() {
	proto.RegisterType((*InfoRequest)(nil), "thanos.InfoRequest")
	proto.RegisterType((*InfoResponse)(nil), "thanos.InfoResponse")
	proto.RegisterType((*SeriesRequest)(nil), "thanos.SeriesRequest")
	proto.RegisterType((*SeriesResponse)(nil), "thanos.SeriesResponse")
	proto.RegisterType((*LabelNamesRequest)(nil), "thanos.LabelNamesRequest")
	proto.RegisterType((*LabelNamesResponse)(nil), "thanos.LabelNamesResponse")
	proto.RegisterType((*LabelValuesRequest)(nil), "thanos.LabelValuesRequest")
	proto.RegisterType((*LabelValuesResponse)(nil), "thanos.LabelValuesResponse")
	proto.RegisterEnum("thanos.Aggr", Aggr_name, Aggr_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Store service

type StoreClient interface {
	// / Info returns meta information about a store e.g labels that makes that store unique.
	Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error)
	Series(ctx context.Context, in *SeriesRequest, opts ...grpc.CallOption) (Store_SeriesClient, error)
	LabelNames(ctx context.Context, in *LabelNamesRequest, opts ...grpc.CallOption) (*LabelNamesResponse, error)
	LabelValues(ctx context.Context, in *LabelValuesRequest, opts ...grpc.CallOption) (*LabelValuesResponse, error)
}

type storeClient struct {
	cc *grpc.ClientConn
}

func NewStoreClient(cc *grpc.ClientConn) StoreClient {
	return &storeClient{cc}
}

func (c *storeClient) Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error) {
	out := new(InfoResponse)
	err := grpc.Invoke(ctx, "/thanos.Store/Info", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storeClient) Series(ctx context.Context, in *SeriesRequest, opts ...grpc.CallOption) (Store_SeriesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Store_serviceDesc.Streams[0], c.cc, "/thanos.Store/Series", opts...)
	if err != nil {
		return nil, err
	}
	x := &storeSeriesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Store_SeriesClient interface {
	Recv() (*SeriesResponse, error)
	grpc.ClientStream
}

type storeSeriesClient struct {
	grpc.ClientStream
}

func (x *storeSeriesClient) Recv() (*SeriesResponse, error) {
	m := new(SeriesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storeClient) LabelNames(ctx context.Context, in *LabelNamesRequest, opts ...grpc.CallOption) (*LabelNamesResponse, error) {
	out := new(LabelNamesResponse)
	err := grpc.Invoke(ctx, "/thanos.Store/LabelNames", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storeClient) LabelValues(ctx context.Context, in *LabelValuesRequest, opts ...grpc.CallOption) (*LabelValuesResponse, error) {
	out := new(LabelValuesResponse)
	err := grpc.Invoke(ctx, "/thanos.Store/LabelValues", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Store service

type StoreServer interface {
	// / Info returns meta information about a store e.g labels that makes that store unique.
	Info(context.Context, *InfoRequest) (*InfoResponse, error)
	Series(*SeriesRequest, Store_SeriesServer) error
	LabelNames(context.Context, *LabelNamesRequest) (*LabelNamesResponse, error)
	LabelValues(context.Context, *LabelValuesRequest) (*LabelValuesResponse, error)
}

func RegisterStoreServer(s *grpc.Server, srv StoreServer) {
	s.RegisterService(&_Store_serviceDesc, srv)
}

func _Store_Info_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoreServer).Info(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.Store/Info",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoreServer).Info(ctx, req.(*InfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Store_Series_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SeriesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StoreServer).Series(m, &storeSeriesServer{stream})
}

type Store_SeriesServer interface {
	Send(*SeriesResponse) error
	grpc.ServerStream
}

type storeSeriesServer struct {
	grpc.ServerStream
}

func (x *storeSeriesServer) Send(m *SeriesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Store_LabelNames_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelNamesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoreServer).LabelNames(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.Store/LabelNames",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoreServer).LabelNames(ctx, req.(*LabelNamesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Store_LabelValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoreServer).LabelValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.Store/LabelValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoreServer).LabelValues(ctx, req.(*LabelValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Store_serviceDesc = grpc.ServiceDesc{
	ServiceName: "thanos.Store",
	HandlerType: (*StoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Info",
			Handler:    _Store_Info_Handler,
		},
		{
			MethodName: "LabelNames",
			Handler:    _Store_LabelNames_Handler,
		},
		{
			MethodName: "LabelValues",
			Handler:    _Store_LabelValues_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Series",
			Handler:       _Store_Series_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "rpc.proto",
}

func (m *InfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *InfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, msg := range m.Labels {
			dAtA[i] = 0xa
			i++
			i = encodeVarintRpc(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MinTime != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintRpc(dAtA, i, uint64(m.MinTime))
	}
	if m.MaxTime != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxTime))
	}
	return i, nil
}

func (m *SeriesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MinTime != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRpc(dAtA, i, uint64(m.MinTime))
	}
	if m.MaxTime != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxTime))
	}
	if len(m.Matchers) > 0 {
		for _, msg := range m.Matchers {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRpc(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MaxResolutionWindow != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxResolutionWindow))
	}
	if len(m.Aggregates) > 0 {
		dAtA2 := make([]byte, len(m.Aggregates)*10)
		var j1 int
		for _, num := range m.Aggregates {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRpc(dAtA, i, uint64(j1))
		i += copy(dAtA[i:], dAtA2[:j1])
	}
	return i, nil
}

func (m *SeriesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		nn3, err := m.Result.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn3
	}
	return i, nil
}

func (m *SeriesResponse_Series) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Series != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRpc(dAtA, i, uint64(m.Series.Size()))
		n4, err := m.Series.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *SeriesResponse_Warning) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintRpc(dAtA, i, uint64(len(m.Warning)))
	i += copy(dAtA[i:], m.Warning)
	return i, nil
}
func (m *LabelNamesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelNamesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *LabelNamesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelNamesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *LabelValuesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelValuesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Label) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Label)))
		i += copy(dAtA[i:], m.Label)
	}
	return i, nil
}

func (m *LabelValuesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelValuesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func encodeVarintRpc(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *InfoRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *InfoResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.MinTime != 0 {
		n += 1 + sovRpc(uint64(m.MinTime))
	}
	if m.MaxTime != 0 {
		n += 1 + sovRpc(uint64(m.MaxTime))
	}
	return n
}

func (m *SeriesRequest) Size() (n int) {
	var l int
	_ = l
	if m.MinTime != 0 {
		n += 1 + sovRpc(uint64(m.MinTime))
	}
	if m.MaxTime != 0 {
		n += 1 + sovRpc(uint64(m.MaxTime))
	}
	if len(m.Matchers) > 0 {
		for _, e := range m.Matchers {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.MaxResolutionWindow != 0 {
		n += 1 + sovRpc(uint64(m.MaxResolutionWindow))
	}
	if len(m.Aggregates) > 0 {
		l = 0
		for _, e := range m.Aggregates {
			l += sovRpc(uint64(e))
		}
		n += 1 + sovRpc(uint64(l)) + l
	}
	return n
}

func (m *SeriesResponse) Size() (n int) {
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *SeriesResponse_Series) Size() (n int) {
	var l int
	_ = l
	if m.Series != nil {
		l = m.Series.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *SeriesResponse_Warning) Size() (n int) {
	var l int
	_ = l
	l = len(m.Warning)
	n += 1 + l + sovRpc(uint64(l))
	return n
}
func (m *LabelNamesRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *LabelNamesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func (m *LabelValuesRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}

func (m *LabelValuesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func sovRpc(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRpc(x uint64) (n int) {
	return sovRpc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *InfoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, Label{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTime", wireType)
			}
			m.MinTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTime", wireType)
			}
			m.MaxTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTime", wireType)
			}
			m.MinTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTime", wireType)
			}
			m.MaxTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Matchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Matchers = append(m.Matchers, LabelMatcher{})
			if err := m.Matchers[len(m.Matchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxResolutionWindow", wireType)
			}
			m.MaxResolutionWindow = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxResolutionWindow |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 0 {
				var v Aggr
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRpc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (Aggr(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Aggregates = append(m.Aggregates, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRpc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRpc
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v Aggr
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRpc
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (Aggr(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Aggregates = append(m.Aggregates, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregates", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Series", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Series{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_Series{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warning", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = &SeriesResponse_Warning{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelNamesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelNamesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelNamesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelNamesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelNamesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelNamesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelValuesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelValuesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelValuesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelValuesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelValuesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelValuesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRpc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthRpc
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRpc
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRpc(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRpc = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRpc   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("rpc.proto", fileDescriptorRpc) }

var fileDescriptorRpc = []byte{
	// 555 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x54, 0x5d, 0x6f, 0xd2, 0x50,
	0x18, 0xa6, 0x94, 0x16, 0x78, 0x3b, 0x48, 0x3d, 0xb0, 0xa5, 0xd4, 0x04, 0x49, 0xaf, 0xc8, 0x34,
	0xa8, 0x98, 0x98, 0x78, 0x09, 0x8b, 0xcb, 0x48, 0x04, 0x93, 0xc3, 0xe6, 0x8c, 0x37, 0xb3, 0xcc,
	0x63, 0xd7, 0x84, 0xf6, 0xb0, 0x9e, 0x22, 0x78, 0xeb, 0xaf, 0xe3, 0xd2, 0x5f, 0xe0, 0x07, 0xbf,
	0xc4, 0x9c, 0x8f, 0x32, 0x6a, 0xa6, 0x77, 0xef, 0xfb, 0x3c, 0x6f, 0x9f, 0xf7, 0xe3, 0x39, 0x29,
	0x54, 0x93, 0xc5, 0x75, 0x6f, 0x91, 0xd0, 0x94, 0x22, 0x33, 0xbd, 0xf1, 0x63, 0xca, 0x5c, 0x2b,
	0xfd, 0xba, 0x20, 0x4c, 0x82, 0x6e, 0x33, 0xa0, 0x01, 0x15, 0xe1, 0x53, 0x1e, 0x49, 0xd4, 0xab,
	0x81, 0x35, 0x8a, 0x3f, 0x53, 0x4c, 0x6e, 0x97, 0x84, 0xa5, 0xde, 0x2d, 0x1c, 0xc8, 0x94, 0x2d,
	0x68, 0xcc, 0x08, 0x7a, 0x0c, 0xe6, 0xdc, 0x9f, 0x91, 0x39, 0x73, 0xb4, 0x8e, 0xde, 0xb5, 0xfa,
	0xb5, 0x9e, 0x94, 0xee, 0xbd, 0xe1, 0xe8, 0xb0, 0xb4, 0xf9, 0xf1, 0xa8, 0x80, 0x55, 0x09, 0x6a,
	0x41, 0x25, 0x0a, 0xe3, 0xab, 0x34, 0x8c, 0x88, 0x53, 0xec, 0x68, 0x5d, 0x1d, 0x97, 0xa3, 0x30,
	0x3e, 0x0f, 0x23, 0x22, 0x28, 0x7f, 0x2d, 0x29, 0x5d, 0x51, 0xfe, 0x9a, 0x53, 0xde, 0x4f, 0x0d,
	0x6a, 0x53, 0x92, 0x84, 0x84, 0xa9, 0x21, 0x72, 0x3a, 0xda, 0xbf, 0x75, 0x8a, 0x39, 0x1d, 0xf4,
	0x92, 0x53, 0xe9, 0xf5, 0x0d, 0x49, 0x98, 0xa3, 0x8b, 0x61, 0x9b, 0xb9, 0x61, 0xc7, 0x92, 0x54,
	0x33, 0xef, 0x6a, 0x51, 0x1f, 0x0e, 0xb9, 0x64, 0x42, 0x18, 0x9d, 0x2f, 0xd3, 0x90, 0xc6, 0x57,
	0xab, 0x30, 0xfe, 0x44, 0x57, 0x4e, 0x49, 0xe8, 0x37, 0x22, 0x7f, 0x8d, 0x77, 0xdc, 0xa5, 0xa0,
	0xd0, 0x13, 0x00, 0x3f, 0x08, 0x12, 0x12, 0xf8, 0x29, 0x61, 0x8e, 0xd1, 0xd1, 0xbb, 0xf5, 0xfe,
	0x41, 0xd6, 0x6d, 0x10, 0x04, 0x09, 0xde, 0xe3, 0xbd, 0x8f, 0x50, 0xcf, 0x16, 0x54, 0x67, 0xed,
	0x82, 0xc9, 0x04, 0x22, 0xf6, 0xb3, 0xfa, 0xf5, 0xec, 0x5b, 0x59, 0x77, 0x56, 0xc0, 0x8a, 0x47,
	0x2e, 0x94, 0x57, 0x7e, 0x12, 0x87, 0x71, 0x20, 0xf6, 0xad, 0x9e, 0x15, 0x70, 0x06, 0x0c, 0x2b,
	0x60, 0x26, 0x84, 0x2d, 0xe7, 0xa9, 0xd7, 0x80, 0x07, 0x62, 0xc7, 0x89, 0x1f, 0xed, 0xce, 0xe8,
	0x9d, 0x02, 0xda, 0x07, 0x55, 0xeb, 0x26, 0x18, 0x31, 0x07, 0x84, 0xa1, 0x55, 0x2c, 0x13, 0xe4,
	0x42, 0x45, 0xa9, 0x32, 0xa7, 0x28, 0x88, 0x5d, 0xee, 0x1d, 0x2b, 0x9d, 0x77, 0xfe, 0x7c, 0x79,
	0x67, 0x52, 0x13, 0x0c, 0x61, 0xbb, 0xd8, 0xa0, 0x8a, 0x65, 0xe2, 0x8d, 0xa0, 0x91, 0xab, 0x55,
	0x4d, 0x8f, 0xc0, 0xfc, 0x22, 0x10, 0xd5, 0x55, 0x65, 0xff, 0x6b, 0x7b, 0x3c, 0x84, 0x12, 0xbf,
	0x24, 0x2a, 0x83, 0x8e, 0x07, 0x97, 0x76, 0x01, 0x55, 0xc1, 0x38, 0x79, 0x7b, 0x31, 0x39, 0xb7,
	0x35, 0x8e, 0x4d, 0x2f, 0xc6, 0x76, 0x91, 0x07, 0xe3, 0xd1, 0xc4, 0xd6, 0x45, 0x30, 0x78, 0x6f,
	0x97, 0x90, 0x05, 0x65, 0x51, 0xf5, 0x1a, 0xdb, 0x46, 0xff, 0x5b, 0x11, 0x8c, 0x69, 0x4a, 0x13,
	0x82, 0x9e, 0x43, 0x89, 0x3f, 0x6c, 0xd4, 0xc8, 0x2e, 0xbd, 0xf7, 0xea, 0xdd, 0x66, 0x1e, 0x54,
	0x43, 0xbf, 0x02, 0x53, 0xda, 0x81, 0x0e, 0xf3, 0xf6, 0x64, 0x9f, 0x1d, 0xfd, 0x0d, 0xcb, 0x0f,
	0x9f, 0x69, 0xe8, 0x04, 0xe0, 0xee, 0xf4, 0xa8, 0x95, 0x7b, 0x87, 0xfb, 0x1e, 0xb9, 0xee, 0x7d,
	0x94, 0xea, 0x7f, 0x0a, 0xd6, 0xde, 0x2d, 0x51, 0xbe, 0x34, 0x67, 0x86, 0xfb, 0xf0, 0x5e, 0x4e,
	0xea, 0x0c, 0x5b, 0x9b, 0xdf, 0xed, 0xc2, 0x66, 0xdb, 0xd6, 0xbe, 0x6f, 0xdb, 0xda, 0xaf, 0x6d,
	0x5b, 0xfb, 0x50, 0x66, 0xfc, 0x26, 0x8b, 0xd9, 0xcc, 0x14, 0x3f, 0x81, 0x17, 0x7f, 0x02, 0x00,
	0x00, 0xff, 0xff, 0x4c, 0xf3, 0x8b, 0x29, 0x3c, 0x04, 0x00, 0x00,
}
