// Code generated by protoc-gen-go. DO NOT EDIT.
// source: config.proto

package configpb

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	configpb "github.com/google/certificate-transparency-go/trillian/ctfe/configpb"
	keyspb "github.com/google/trillian/crypto/keyspb"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// IdentityFunction specifies how Trillian identity hash is computed.
type IdentityFunction int32

const (
	IdentityFunction_UNKNOWN_IDENTITY_FUNCTION IdentityFunction = 0
	// Returns SHA256 hash of the certificate DER. This is the same function that
	// CTFE uses when submitting add-[pre-]chain entries to Trillian.
	//
	// For example, it can be used when migrating a CT log to Trillian. Using the
	// same function as CTFE makes any newly submitted entries compatible with the
	// ones that migrated from the source log.
	IdentityFunction_SHA256_CERT_DATA IdentityFunction = 1
	// Returns SHA256 hash of the leaf index.
	//
	// For example, this function can be used for mirroring CT logs. Since the
	// source logs might have duplicates of different kinds (depends on the
	// operator), this function allows storing them all (unlike SHA256_CERT_DATA).
	// Note that the CTFE log must stay read-only (mirror), as CTFE's identity
	// hash is incompatible.
	IdentityFunction_SHA256_LEAF_INDEX IdentityFunction = 2
)

var IdentityFunction_name = map[int32]string{
	0: "UNKNOWN_IDENTITY_FUNCTION",
	1: "SHA256_CERT_DATA",
	2: "SHA256_LEAF_INDEX",
}

var IdentityFunction_value = map[string]int32{
	"UNKNOWN_IDENTITY_FUNCTION": 0,
	"SHA256_CERT_DATA":          1,
	"SHA256_LEAF_INDEX":         2,
}

func (x IdentityFunction) String() string {
	return proto.EnumName(IdentityFunction_name, int32(x))
}

func (IdentityFunction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0}
}

// MigrationConfig describes the configuration options for a single CT log
// migration instance.
type MigrationConfig struct {
	// The URI of the source CT log, e.g. "https://ct.googleapis.com/pilot".
	SourceUri string `protobuf:"bytes,1,opt,name=source_uri,json=sourceUri,proto3" json:"source_uri,omitempty"`
	// The public key of the source log.
	PublicKey *keyspb.PublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// The name of the backend which this log migrates to. The name must be one of
	// those defined in the LogBackendSet.
	LogBackendName string `protobuf:"bytes,3,opt,name=log_backend_name,json=logBackendName,proto3" json:"log_backend_name,omitempty"`
	// The ID of a Trillian PREORDERED_LOG tree that stores the log data.
	LogId int64 `protobuf:"varint,4,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	// Max number of entries per get-entries request from the source log.
	BatchSize int32 `protobuf:"varint,5,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	// Determines whether the migration should run continuously, i.e. watch and
	// follow the updates of the source log's STH. For example, this mode can be
	// used to support a mirror CT log.
	IsContinuous bool `protobuf:"varint,6,opt,name=is_continuous,json=isContinuous,proto3" json:"is_continuous,omitempty"`
	// The log entry index to start fetching at. If negative, then it is assumed
	// equal to the current Trillian tree size.
	// Ignored in continuous mode which starts at the point where it stopped (e.g.
	// the current Trillian tree size in a simple case).
	StartIndex int64 `protobuf:"varint,7,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// The log index to end fetching at, non-inclusive. If zero, fetch up to the
	// source log's current STH. Ignored in continuous mode which keeps updating
	// STH and fetching up to that.
	EndIndex int64 `protobuf:"varint,8,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	// The number of parallel get-entries fetchers. Assumed equal to 1 if not
	// specified.
	NumFetchers int32 `protobuf:"varint,9,opt,name=num_fetchers,json=numFetchers,proto3" json:"num_fetchers,omitempty"`
	// The number of parallel workers submitting entries to Trillian. Assumed
	// equal to 1 if not specified.
	NumSubmitters int32 `protobuf:"varint,10,opt,name=num_submitters,json=numSubmitters,proto3" json:"num_submitters,omitempty"`
	// Max number of batches in fetchers->submitters channel.
	ChannelSize int32 `protobuf:"varint,11,opt,name=channel_size,json=channelSize,proto3" json:"channel_size,omitempty"`
	// The function that computes LeafIdentityHash for Trillian log entries.
	IdentityFunction     IdentityFunction `protobuf:"varint,12,opt,name=identity_function,json=identityFunction,proto3,enum=configpb.IdentityFunction" json:"identity_function,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *MigrationConfig) Reset()         { *m = MigrationConfig{} }
func (m *MigrationConfig) String() string { return proto.CompactTextString(m) }
func (*MigrationConfig) ProtoMessage()    {}
func (*MigrationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0}
}

func (m *MigrationConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MigrationConfig.Unmarshal(m, b)
}
func (m *MigrationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MigrationConfig.Marshal(b, m, deterministic)
}
func (m *MigrationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MigrationConfig.Merge(m, src)
}
func (m *MigrationConfig) XXX_Size() int {
	return xxx_messageInfo_MigrationConfig.Size(m)
}
func (m *MigrationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MigrationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MigrationConfig proto.InternalMessageInfo

func (m *MigrationConfig) GetSourceUri() string {
	if m != nil {
		return m.SourceUri
	}
	return ""
}

func (m *MigrationConfig) GetPublicKey() *keyspb.PublicKey {
	if m != nil {
		return m.PublicKey
	}
	return nil
}

func (m *MigrationConfig) GetLogBackendName() string {
	if m != nil {
		return m.LogBackendName
	}
	return ""
}

func (m *MigrationConfig) GetLogId() int64 {
	if m != nil {
		return m.LogId
	}
	return 0
}

func (m *MigrationConfig) GetBatchSize() int32 {
	if m != nil {
		return m.BatchSize
	}
	return 0
}

func (m *MigrationConfig) GetIsContinuous() bool {
	if m != nil {
		return m.IsContinuous
	}
	return false
}

func (m *MigrationConfig) GetStartIndex() int64 {
	if m != nil {
		return m.StartIndex
	}
	return 0
}

func (m *MigrationConfig) GetEndIndex() int64 {
	if m != nil {
		return m.EndIndex
	}
	return 0
}

func (m *MigrationConfig) GetNumFetchers() int32 {
	if m != nil {
		return m.NumFetchers
	}
	return 0
}

func (m *MigrationConfig) GetNumSubmitters() int32 {
	if m != nil {
		return m.NumSubmitters
	}
	return 0
}

func (m *MigrationConfig) GetChannelSize() int32 {
	if m != nil {
		return m.ChannelSize
	}
	return 0
}

func (m *MigrationConfig) GetIdentityFunction() IdentityFunction {
	if m != nil {
		return m.IdentityFunction
	}
	return IdentityFunction_UNKNOWN_IDENTITY_FUNCTION
}

// MigrationConfigSet is a set of MigrationConfig messages.
type MigrationConfigSet struct {
	Config               []*MigrationConfig `protobuf:"bytes,1,rep,name=config,proto3" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *MigrationConfigSet) Reset()         { *m = MigrationConfigSet{} }
func (m *MigrationConfigSet) String() string { return proto.CompactTextString(m) }
func (*MigrationConfigSet) ProtoMessage()    {}
func (*MigrationConfigSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{1}
}

func (m *MigrationConfigSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MigrationConfigSet.Unmarshal(m, b)
}
func (m *MigrationConfigSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MigrationConfigSet.Marshal(b, m, deterministic)
}
func (m *MigrationConfigSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MigrationConfigSet.Merge(m, src)
}
func (m *MigrationConfigSet) XXX_Size() int {
	return xxx_messageInfo_MigrationConfigSet.Size(m)
}
func (m *MigrationConfigSet) XXX_DiscardUnknown() {
	xxx_messageInfo_MigrationConfigSet.DiscardUnknown(m)
}

var xxx_messageInfo_MigrationConfigSet proto.InternalMessageInfo

func (m *MigrationConfigSet) GetConfig() []*MigrationConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

// MigrillianConfig holds configuration for multiple migration / mirroring jobs.
type MigrillianConfig struct {
	// The set of backends that this configuration will use to send requests to.
	// The names of the backends in the LogBackendSet must all be distinct.
	Backends *configpb.LogBackendSet `protobuf:"bytes,1,opt,name=backends,proto3" json:"backends,omitempty"`
	// The set of migrations that will use the above backends. All the protos in
	// it must set a valid log_backend_name for the config to be usable.
	MigrationConfigs     *MigrationConfigSet `protobuf:"bytes,2,opt,name=migration_configs,json=migrationConfigs,proto3" json:"migration_configs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *MigrillianConfig) Reset()         { *m = MigrillianConfig{} }
func (m *MigrillianConfig) String() string { return proto.CompactTextString(m) }
func (*MigrillianConfig) ProtoMessage()    {}
func (*MigrillianConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2}
}

func (m *MigrillianConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MigrillianConfig.Unmarshal(m, b)
}
func (m *MigrillianConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MigrillianConfig.Marshal(b, m, deterministic)
}
func (m *MigrillianConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MigrillianConfig.Merge(m, src)
}
func (m *MigrillianConfig) XXX_Size() int {
	return xxx_messageInfo_MigrillianConfig.Size(m)
}
func (m *MigrillianConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MigrillianConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MigrillianConfig proto.InternalMessageInfo

func (m *MigrillianConfig) GetBackends() *configpb.LogBackendSet {
	if m != nil {
		return m.Backends
	}
	return nil
}

func (m *MigrillianConfig) GetMigrationConfigs() *MigrationConfigSet {
	if m != nil {
		return m.MigrationConfigs
	}
	return nil
}

func init() {
	proto.RegisterEnum("configpb.IdentityFunction", IdentityFunction_name, IdentityFunction_value)
	proto.RegisterType((*MigrationConfig)(nil), "configpb.MigrationConfig")
	proto.RegisterType((*MigrationConfigSet)(nil), "configpb.MigrationConfigSet")
	proto.RegisterType((*MigrillianConfig)(nil), "configpb.MigrillianConfig")
}

func init() { proto.RegisterFile("config.proto", fileDescriptor_3eaf2c85e69e9ea4) }

var fileDescriptor_3eaf2c85e69e9ea4 = []byte{
	// 586 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x93, 0xef, 0x6e, 0xd3, 0x3c,
	0x14, 0x87, 0xdf, 0xac, 0xef, 0x4a, 0x7b, 0xda, 0x8d, 0xd4, 0x62, 0x22, 0x1b, 0x4c, 0x84, 0x21,
	0xa4, 0x08, 0x69, 0x0d, 0x74, 0x1a, 0xdf, 0x4b, 0xd7, 0x8e, 0x68, 0x23, 0x83, 0xb4, 0x13, 0xf0,
	0x05, 0x2b, 0x71, 0xdd, 0xd4, 0x5a, 0x62, 0x47, 0xb1, 0x23, 0x91, 0x5d, 0x06, 0xb7, 0xc7, 0xcd,
	0xa0, 0xfc, 0x69, 0x0b, 0x45, 0x7c, 0x6a, 0xfb, 0x9c, 0x9f, 0x9f, 0x1e, 0xe7, 0x9c, 0x40, 0x97,
	0x08, 0xbe, 0x60, 0x61, 0x3f, 0x49, 0x85, 0x12, 0xa8, 0x55, 0xfd, 0x4a, 0x82, 0xa3, 0x4f, 0x21,
	0x53, 0xcb, 0x2c, 0xe8, 0x13, 0x11, 0xdb, 0xa1, 0x10, 0x61, 0x44, 0x6d, 0x42, 0x53, 0xc5, 0x16,
	0x8c, 0xf8, 0x8a, 0x9e, 0xaa, 0xd4, 0xe7, 0x32, 0xf1, 0x53, 0xca, 0x49, 0x7e, 0x1a, 0x0a, 0x5b,
	0xa5, 0x2c, 0x8a, 0x98, 0xcf, 0x6d, 0xa2, 0x16, 0xd4, 0x5e, 0x59, 0xec, 0xdf, 0xe5, 0x47, 0xe7,
	0x7f, 0x2b, 0x37, 0xc7, 0xd2, 0x3c, 0x51, 0xc2, 0xbe, 0xa3, 0xb9, 0x4c, 0x82, 0xfa, 0xa3, 0x3a,
	0x76, 0xf2, 0xb3, 0x01, 0x0f, 0x3f, 0xb0, 0x30, 0xf5, 0x15, 0x13, 0x7c, 0x54, 0x0a, 0xd1, 0x31,
	0x80, 0x14, 0x59, 0x4a, 0x28, 0xce, 0x52, 0x66, 0x68, 0xa6, 0x66, 0xb5, 0xbd, 0x76, 0x45, 0x6e,
	0x53, 0x86, 0x5e, 0x03, 0x24, 0x59, 0x10, 0x31, 0x82, 0xef, 0x68, 0x6e, 0xec, 0x98, 0x9a, 0xd5,
	0x19, 0xf4, 0xfa, 0xb5, 0xf5, 0x63, 0x59, 0xb9, 0xa2, 0xb9, 0xd7, 0x4e, 0x56, 0x5f, 0x91, 0x05,
	0x7a, 0x24, 0x42, 0x1c, 0xf8, 0xe4, 0x8e, 0xf2, 0x39, 0xe6, 0x7e, 0x4c, 0x8d, 0x46, 0xa9, 0xdd,
	0x8f, 0x44, 0xf8, 0xae, 0xc2, 0xae, 0x1f, 0x53, 0x74, 0x00, 0xcd, 0x22, 0xc9, 0xe6, 0xc6, 0xff,
	0xa6, 0x66, 0x35, 0xbc, 0xdd, 0x48, 0x84, 0xce, 0xbc, 0xe8, 0x28, 0xf0, 0x15, 0x59, 0x62, 0xc9,
	0xee, 0xa9, 0xb1, 0x6b, 0x6a, 0xd6, 0xae, 0xd7, 0x2e, 0xc9, 0x94, 0xdd, 0x53, 0xf4, 0x02, 0xf6,
	0x98, 0xc4, 0x44, 0x70, 0xc5, 0x78, 0x26, 0x32, 0x69, 0x34, 0x4d, 0xcd, 0x6a, 0x79, 0x5d, 0x26,
	0x47, 0x6b, 0x86, 0x9e, 0x41, 0x47, 0x2a, 0x3f, 0x55, 0x98, 0xf1, 0x39, 0xfd, 0x6e, 0x3c, 0x28,
	0xfd, 0x50, 0x22, 0xa7, 0x20, 0xe8, 0x09, 0xb4, 0x8b, 0xee, 0xaa, 0x72, 0xab, 0x2c, 0xb7, 0x28,
	0x9f, 0x57, 0xc5, 0xe7, 0xd0, 0xe5, 0x59, 0x8c, 0x17, 0x54, 0x91, 0x25, 0x4d, 0xa5, 0xd1, 0x2e,
	0x7b, 0xe8, 0xf0, 0x2c, 0x9e, 0xd4, 0x08, 0xbd, 0x84, 0xfd, 0x22, 0x22, 0xb3, 0x20, 0x66, 0x4a,
	0x15, 0x21, 0x28, 0x43, 0x7b, 0x3c, 0x8b, 0xa7, 0x6b, 0x58, 0x98, 0xc8, 0xd2, 0xe7, 0x9c, 0x46,
	0xd5, 0x6d, 0x3a, 0x95, 0xa9, 0x66, 0xe5, 0x7d, 0x2e, 0xa1, 0xc7, 0xe6, 0x94, 0x2b, 0xa6, 0x72,
	0xbc, 0xc8, 0x38, 0x29, 0x66, 0x63, 0x74, 0x4d, 0xcd, 0xda, 0x1f, 0x1c, 0xf5, 0x57, 0xe3, 0xef,
	0x3b, 0x75, 0x64, 0x52, 0x27, 0x3c, 0x9d, 0x6d, 0x91, 0x93, 0x4b, 0x40, 0x5b, 0xc3, 0x9d, 0x52,
	0x85, 0xde, 0x40, 0xb3, 0x92, 0x18, 0x9a, 0xd9, 0xb0, 0x3a, 0x83, 0xc3, 0x8d, 0x73, 0x2b, 0xed,
	0xd5, 0xc1, 0x93, 0x1f, 0x1a, 0xe8, 0x45, 0xad, 0x5a, 0xa8, 0x7a, 0x4f, 0xce, 0xa0, 0x55, 0x8f,
	0x54, 0x96, 0x5b, 0xd2, 0x19, 0x3c, 0xde, 0x98, 0xae, 0xd7, 0x83, 0x9d, 0x52, 0xe5, 0xad, 0x83,
	0xc8, 0x81, 0x5e, 0xbc, 0xfa, 0x13, 0x5c, 0xa5, 0x65, 0xbd, 0x44, 0x4f, 0xff, 0xd9, 0x47, 0xa1,
	0xd0, 0xe3, 0x3f, 0x99, 0x7c, 0xf5, 0x0d, 0xf4, 0xed, 0x67, 0x80, 0x8e, 0xe1, 0xf0, 0xd6, 0xbd,
	0x72, 0x6f, 0x3e, 0xbb, 0xd8, 0xb9, 0x18, 0xbb, 0x33, 0x67, 0xf6, 0x15, 0x4f, 0x6e, 0xdd, 0xd1,
	0xcc, 0xb9, 0x71, 0xf5, 0xff, 0xd0, 0x23, 0xd0, 0xa7, 0xef, 0x87, 0x83, 0xf3, 0xb7, 0x78, 0x34,
	0xf6, 0x66, 0xf8, 0x62, 0x38, 0x1b, 0xea, 0x1a, 0x3a, 0x80, 0x5e, 0x4d, 0xaf, 0xc7, 0xc3, 0x09,
	0x76, 0xdc, 0x8b, 0xf1, 0x17, 0x7d, 0x27, 0x68, 0x96, 0xaf, 0xc8, 0xd9, 0xaf, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x62, 0x97, 0x87, 0x03, 0xc6, 0x03, 0x00, 0x00,
}
