// Code generated by protoc-gen-go. DO NOT EDIT.
// source: config.proto

package configpb

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	configpb "github.com/google/certificate-transparency-go/trillian/ctfe/configpb"
	keyspb "github.com/google/trillian/crypto/keyspb"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// IdentityFunction specifies how Trillian identity hash is computed.
type IdentityFunction int32

const (
	IdentityFunction_UNKNOWN_IDENTITY_FUNCTION IdentityFunction = 0
	// Returns SHA256 hash of the certificate DER. This is the same function that
	// CTFE uses when submitting add-[pre-]chain entries to Trillian.
	//
	// For example, it can be used when migrating a CT log to Trillian. Using the
	// same function as CTFE makes any newly submitted entries compatible with the
	// ones that migrated from the source log.
	IdentityFunction_SHA256_CERT_DATA IdentityFunction = 1
	// Returns SHA256 hash of the leaf index.
	//
	// For example, this function can be used for mirroring CT logs. Since the
	// source logs might have duplicates of different kinds (depends on the
	// operator), this function allows storing them all (unlike SHA256_CERT_DATA).
	// Note that the CTFE log must stay read-only (mirror), as CTFE's identity
	// hash is incompatible.
	IdentityFunction_SHA256_LEAF_INDEX IdentityFunction = 2
)

var IdentityFunction_name = map[int32]string{
	0: "UNKNOWN_IDENTITY_FUNCTION",
	1: "SHA256_CERT_DATA",
	2: "SHA256_LEAF_INDEX",
}

var IdentityFunction_value = map[string]int32{
	"UNKNOWN_IDENTITY_FUNCTION": 0,
	"SHA256_CERT_DATA":          1,
	"SHA256_LEAF_INDEX":         2,
}

func (x IdentityFunction) String() string {
	return proto.EnumName(IdentityFunction_name, int32(x))
}

func (IdentityFunction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0}
}

// MigrationConfig describes the configuration options for a single CT log
// migration instance.
type MigrationConfig struct {
	// The URI of the source CT log, e.g. "https://ct.googleapis.com/pilot".
	SourceUri string `protobuf:"bytes,1,opt,name=source_uri,json=sourceUri,proto3" json:"source_uri,omitempty"`
	// The public key of the source log.
	PublicKey *keyspb.PublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// The name of the backend which this log migrates to. The name must be one of
	// those defined in the LogBackendSet.
	LogBackendName string `protobuf:"bytes,3,opt,name=log_backend_name,json=logBackendName,proto3" json:"log_backend_name,omitempty"`
	// The ID of a Trillian PREORDERED_LOG tree that stores the log data.
	LogId int64 `protobuf:"varint,4,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	// Max number of entries per get-entries request from the source log.
	BatchSize int32 `protobuf:"varint,5,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	// Determines whether the migration should run continuously, i.e. watch and
	// follow the updates of the source log's STH. For example, this mode can be
	// used to support a mirror CT log.
	IsContinuous bool `protobuf:"varint,6,opt,name=is_continuous,json=isContinuous,proto3" json:"is_continuous,omitempty"`
	// The log entry index to start fetching at. If negative, then it is assumed
	// equal to the current Trillian tree size.
	// Ignored in continuous mode which starts at the point where it stopped (e.g.
	// the current Trillian tree size in a simple case).
	StartIndex int64 `protobuf:"varint,7,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// The log index to end fetching at, non-inclusive. If zero, fetch up to the
	// source log's current STH. Ignored in continuous mode which keeps updating
	// STH and fetching up to that.
	EndIndex int64 `protobuf:"varint,8,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	// The number of parallel get-entries fetchers. Assumed equal to 1 if not
	// specified.
	NumFetchers int32 `protobuf:"varint,9,opt,name=num_fetchers,json=numFetchers,proto3" json:"num_fetchers,omitempty"`
	// The number of parallel workers submitting entries to Trillian. Assumed
	// equal to 1 if not specified.
	NumSubmitters int32 `protobuf:"varint,10,opt,name=num_submitters,json=numSubmitters,proto3" json:"num_submitters,omitempty"`
	// Max number of batches in fetchers->submitters channel.
	ChannelSize int32 `protobuf:"varint,11,opt,name=channel_size,json=channelSize,proto3" json:"channel_size,omitempty"`
	// The function that computes LeafIdentityHash for Trillian log entries.
	IdentityFunction IdentityFunction `protobuf:"varint,12,opt,name=identity_function,json=identityFunction,proto3,enum=configpb.IdentityFunction" json:"identity_function,omitempty"`
	// If set to false (by default), then Migrillian verifies that the tree as
	// seen by Trillian is consistent with the current STH of the source CT log.
	// It invokes the get-sth-consistency endpoint (section 4.4 of RFC 6962) with
	// the corresponding tree sizes, and verifies the returned proof.
	NoConsistencyCheck   bool     `protobuf:"varint,13,opt,name=no_consistency_check,json=noConsistencyCheck,proto3" json:"no_consistency_check,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MigrationConfig) Reset()         { *m = MigrationConfig{} }
func (m *MigrationConfig) String() string { return proto.CompactTextString(m) }
func (*MigrationConfig) ProtoMessage()    {}
func (*MigrationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0}
}

func (m *MigrationConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MigrationConfig.Unmarshal(m, b)
}
func (m *MigrationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MigrationConfig.Marshal(b, m, deterministic)
}
func (m *MigrationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MigrationConfig.Merge(m, src)
}
func (m *MigrationConfig) XXX_Size() int {
	return xxx_messageInfo_MigrationConfig.Size(m)
}
func (m *MigrationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MigrationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MigrationConfig proto.InternalMessageInfo

func (m *MigrationConfig) GetSourceUri() string {
	if m != nil {
		return m.SourceUri
	}
	return ""
}

func (m *MigrationConfig) GetPublicKey() *keyspb.PublicKey {
	if m != nil {
		return m.PublicKey
	}
	return nil
}

func (m *MigrationConfig) GetLogBackendName() string {
	if m != nil {
		return m.LogBackendName
	}
	return ""
}

func (m *MigrationConfig) GetLogId() int64 {
	if m != nil {
		return m.LogId
	}
	return 0
}

func (m *MigrationConfig) GetBatchSize() int32 {
	if m != nil {
		return m.BatchSize
	}
	return 0
}

func (m *MigrationConfig) GetIsContinuous() bool {
	if m != nil {
		return m.IsContinuous
	}
	return false
}

func (m *MigrationConfig) GetStartIndex() int64 {
	if m != nil {
		return m.StartIndex
	}
	return 0
}

func (m *MigrationConfig) GetEndIndex() int64 {
	if m != nil {
		return m.EndIndex
	}
	return 0
}

func (m *MigrationConfig) GetNumFetchers() int32 {
	if m != nil {
		return m.NumFetchers
	}
	return 0
}

func (m *MigrationConfig) GetNumSubmitters() int32 {
	if m != nil {
		return m.NumSubmitters
	}
	return 0
}

func (m *MigrationConfig) GetChannelSize() int32 {
	if m != nil {
		return m.ChannelSize
	}
	return 0
}

func (m *MigrationConfig) GetIdentityFunction() IdentityFunction {
	if m != nil {
		return m.IdentityFunction
	}
	return IdentityFunction_UNKNOWN_IDENTITY_FUNCTION
}

func (m *MigrationConfig) GetNoConsistencyCheck() bool {
	if m != nil {
		return m.NoConsistencyCheck
	}
	return false
}

// MigrationConfigSet is a set of MigrationConfig messages.
type MigrationConfigSet struct {
	Config               []*MigrationConfig `protobuf:"bytes,1,rep,name=config,proto3" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *MigrationConfigSet) Reset()         { *m = MigrationConfigSet{} }
func (m *MigrationConfigSet) String() string { return proto.CompactTextString(m) }
func (*MigrationConfigSet) ProtoMessage()    {}
func (*MigrationConfigSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{1}
}

func (m *MigrationConfigSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MigrationConfigSet.Unmarshal(m, b)
}
func (m *MigrationConfigSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MigrationConfigSet.Marshal(b, m, deterministic)
}
func (m *MigrationConfigSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MigrationConfigSet.Merge(m, src)
}
func (m *MigrationConfigSet) XXX_Size() int {
	return xxx_messageInfo_MigrationConfigSet.Size(m)
}
func (m *MigrationConfigSet) XXX_DiscardUnknown() {
	xxx_messageInfo_MigrationConfigSet.DiscardUnknown(m)
}

var xxx_messageInfo_MigrationConfigSet proto.InternalMessageInfo

func (m *MigrationConfigSet) GetConfig() []*MigrationConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

// MigrillianConfig holds configuration for multiple migration / mirroring jobs.
type MigrillianConfig struct {
	// The set of backends that this configuration will use to send requests to.
	// The names of the backends in the LogBackendSet must all be distinct.
	Backends *configpb.LogBackendSet `protobuf:"bytes,1,opt,name=backends,proto3" json:"backends,omitempty"`
	// The set of migrations that will use the above backends. All the protos in
	// it must set a valid log_backend_name for the config to be usable.
	MigrationConfigs     *MigrationConfigSet `protobuf:"bytes,2,opt,name=migration_configs,json=migrationConfigs,proto3" json:"migration_configs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *MigrillianConfig) Reset()         { *m = MigrillianConfig{} }
func (m *MigrillianConfig) String() string { return proto.CompactTextString(m) }
func (*MigrillianConfig) ProtoMessage()    {}
func (*MigrillianConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2}
}

func (m *MigrillianConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MigrillianConfig.Unmarshal(m, b)
}
func (m *MigrillianConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MigrillianConfig.Marshal(b, m, deterministic)
}
func (m *MigrillianConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MigrillianConfig.Merge(m, src)
}
func (m *MigrillianConfig) XXX_Size() int {
	return xxx_messageInfo_MigrillianConfig.Size(m)
}
func (m *MigrillianConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MigrillianConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MigrillianConfig proto.InternalMessageInfo

func (m *MigrillianConfig) GetBackends() *configpb.LogBackendSet {
	if m != nil {
		return m.Backends
	}
	return nil
}

func (m *MigrillianConfig) GetMigrationConfigs() *MigrationConfigSet {
	if m != nil {
		return m.MigrationConfigs
	}
	return nil
}

func init() {
	proto.RegisterEnum("configpb.IdentityFunction", IdentityFunction_name, IdentityFunction_value)
	proto.RegisterType((*MigrationConfig)(nil), "configpb.MigrationConfig")
	proto.RegisterType((*MigrationConfigSet)(nil), "configpb.MigrationConfigSet")
	proto.RegisterType((*MigrillianConfig)(nil), "configpb.MigrillianConfig")
}

func init() { proto.RegisterFile("config.proto", fileDescriptor_3eaf2c85e69e9ea4) }

var fileDescriptor_3eaf2c85e69e9ea4 = []byte{
	// 622 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x93, 0x5d, 0x6f, 0xd3, 0x3e,
	0x14, 0xc6, 0xff, 0xd9, 0x4b, 0xff, 0xed, 0x69, 0x37, 0x52, 0x6b, 0x13, 0x59, 0x61, 0xa2, 0x6c,
	0x42, 0x8a, 0x90, 0xd6, 0x8c, 0x4e, 0x70, 0xdf, 0x75, 0xed, 0x08, 0x1b, 0x19, 0x4a, 0x3b, 0xf1,
	0x72, 0x81, 0x95, 0xb8, 0x6e, 0x6a, 0x35, 0xb1, 0xa3, 0xd8, 0x91, 0xe8, 0xbe, 0x03, 0x37, 0x7c,
	0x62, 0x94, 0x97, 0x66, 0x50, 0x89, 0xab, 0x24, 0xbf, 0xe7, 0xc9, 0xf1, 0xf1, 0xf1, 0x63, 0x68,
	0x11, 0xc1, 0xe7, 0x2c, 0xe8, 0xc5, 0x89, 0x50, 0x02, 0xd5, 0x8b, 0xaf, 0xd8, 0xef, 0x9c, 0xaa,
	0x84, 0x85, 0x21, 0xf3, 0xb8, 0x45, 0xd4, 0x9c, 0x5a, 0x6b, 0x6e, 0xfd, 0x69, 0xef, 0x74, 0x48,
	0xb2, 0x8a, 0x95, 0xb0, 0x96, 0x74, 0x25, 0x63, 0xbf, 0x7c, 0x14, 0xda, 0xc9, 0xcf, 0x1d, 0x78,
	0xf2, 0x91, 0x05, 0x89, 0xa7, 0x98, 0xe0, 0xc3, 0xfc, 0x2f, 0x74, 0x0c, 0x20, 0x45, 0x9a, 0x10,
	0x8a, 0xd3, 0x84, 0x19, 0x5a, 0x57, 0x33, 0x1b, 0x6e, 0xa3, 0x20, 0xf7, 0x09, 0x43, 0xe7, 0x00,
	0x71, 0xea, 0x87, 0x8c, 0xe0, 0x25, 0x5d, 0x19, 0x5b, 0x5d, 0xcd, 0x6c, 0xf6, 0xdb, 0xbd, 0xb2,
	0xea, 0xa7, 0x5c, 0xb9, 0xa1, 0x2b, 0xb7, 0x11, 0xaf, 0x5f, 0x91, 0x09, 0x7a, 0x28, 0x02, 0xec,
	0x7b, 0x64, 0x49, 0xf9, 0x0c, 0x73, 0x2f, 0xa2, 0xc6, 0x76, 0x5e, 0x76, 0x3f, 0x14, 0xc1, 0x65,
	0x81, 0x1d, 0x2f, 0xa2, 0xe8, 0x10, 0x6a, 0x99, 0x93, 0xcd, 0x8c, 0x9d, 0xae, 0x66, 0x6e, 0xbb,
	0xbb, 0xa1, 0x08, 0xec, 0x59, 0xd6, 0x91, 0xef, 0x29, 0xb2, 0xc0, 0x92, 0x3d, 0x50, 0x63, 0xb7,
	0xab, 0x99, 0xbb, 0x6e, 0x23, 0x27, 0x13, 0xf6, 0x40, 0xd1, 0x29, 0xec, 0x31, 0x89, 0x89, 0xe0,
	0x8a, 0xf1, 0x54, 0xa4, 0xd2, 0xa8, 0x75, 0x35, 0xb3, 0xee, 0xb6, 0x98, 0x1c, 0x56, 0x0c, 0xbd,
	0x80, 0xa6, 0x54, 0x5e, 0xa2, 0x30, 0xe3, 0x33, 0xfa, 0xc3, 0xf8, 0x3f, 0xaf, 0x0f, 0x39, 0xb2,
	0x33, 0x82, 0x9e, 0x41, 0x23, 0xeb, 0xae, 0x90, 0xeb, 0xb9, 0x5c, 0xa7, 0x7c, 0x56, 0x88, 0x2f,
	0xa1, 0xc5, 0xd3, 0x08, 0xcf, 0xa9, 0x22, 0x0b, 0x9a, 0x48, 0xa3, 0x91, 0xf7, 0xd0, 0xe4, 0x69,
	0x34, 0x2e, 0x11, 0x7a, 0x05, 0xfb, 0x99, 0x45, 0xa6, 0x7e, 0xc4, 0x94, 0xca, 0x4c, 0x90, 0x9b,
	0xf6, 0x78, 0x1a, 0x4d, 0x2a, 0x98, 0x55, 0x22, 0x0b, 0x8f, 0x73, 0x1a, 0x16, 0xbb, 0x69, 0x16,
	0x95, 0x4a, 0x96, 0xef, 0xe7, 0x1a, 0xda, 0x6c, 0x46, 0xb9, 0x62, 0x6a, 0x85, 0xe7, 0x29, 0x27,
	0xd9, 0xd9, 0x18, 0xad, 0xae, 0x66, 0xee, 0xf7, 0x3b, 0xbd, 0xf5, 0x19, 0xf7, 0xec, 0xd2, 0x32,
	0x2e, 0x1d, 0xae, 0xce, 0x36, 0x08, 0x3a, 0x87, 0x03, 0x2e, 0xb2, 0xc1, 0x48, 0x26, 0x15, 0xe5,
	0x64, 0x85, 0xc9, 0x82, 0x92, 0xa5, 0xb1, 0x97, 0xcf, 0x07, 0x71, 0x31, 0x7c, 0x94, 0x86, 0x99,
	0x72, 0x72, 0x0d, 0x68, 0x23, 0x0e, 0x13, 0xaa, 0xd0, 0x1b, 0xa8, 0x15, 0xcb, 0x1a, 0x5a, 0x77,
	0xdb, 0x6c, 0xf6, 0x8f, 0x1e, 0xbb, 0xd8, 0x70, 0xbb, 0xa5, 0xf1, 0xe4, 0x97, 0x06, 0x7a, 0xa6,
	0x15, 0xf1, 0x2c, 0x93, 0x75, 0x01, 0xf5, 0x32, 0x04, 0x32, 0xcf, 0x55, 0xb3, 0xff, 0xf4, 0xb1,
	0xd2, 0x6d, 0x15, 0x85, 0x09, 0x55, 0x6e, 0x65, 0x44, 0x36, 0xb4, 0xa3, 0xf5, 0x22, 0xb8, 0x70,
	0xcb, 0x32, 0x76, 0xcf, 0xff, 0xd9, 0x47, 0x56, 0x42, 0x8f, 0xfe, 0x66, 0xf2, 0xf5, 0x77, 0xd0,
	0x37, 0xa7, 0x86, 0x8e, 0xe1, 0xe8, 0xde, 0xb9, 0x71, 0xee, 0x3e, 0x3b, 0xd8, 0xbe, 0x1a, 0x39,
	0x53, 0x7b, 0xfa, 0x15, 0x8f, 0xef, 0x9d, 0xe1, 0xd4, 0xbe, 0x73, 0xf4, 0xff, 0xd0, 0x01, 0xe8,
	0x93, 0xf7, 0x83, 0xfe, 0xdb, 0x77, 0x78, 0x38, 0x72, 0xa7, 0xf8, 0x6a, 0x30, 0x1d, 0xe8, 0x1a,
	0x3a, 0x84, 0x76, 0x49, 0x6f, 0x47, 0x83, 0x31, 0xb6, 0x9d, 0xab, 0xd1, 0x17, 0x7d, 0xeb, 0xf2,
	0xf6, 0xdb, 0x87, 0x80, 0xa9, 0x45, 0xea, 0xf7, 0x88, 0x88, 0xac, 0x40, 0x88, 0x20, 0xa4, 0x16,
	0xa1, 0x89, 0x62, 0x73, 0x46, 0x3c, 0x45, 0xcf, 0x54, 0xe2, 0x71, 0x19, 0x7b, 0x49, 0x36, 0xf0,
	0xb3, 0x40, 0x58, 0xd5, 0xf5, 0x8d, 0xaa, 0x51, 0x55, 0x97, 0xd8, 0xaf, 0xe5, 0x57, 0xf4, 0xe2,
	0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7e, 0xf8, 0x14, 0xee, 0xfd, 0x03, 0x00, 0x00,
}
