// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/entity_type.proto

package dialogflow // import "google.golang.org/genproto/googleapis/cloud/dialogflow/v2beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import _ "github.com/golang/protobuf/ptypes/struct"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents kinds of entities.
type EntityType_Kind int32

const (
	// Not specified. This value should be never used.
	EntityType_KIND_UNSPECIFIED EntityType_Kind = 0
	// Map entity types allow mapping of a group of synonyms to a canonical
	// value.
	EntityType_KIND_MAP EntityType_Kind = 1
	// List entity types contain a set of entries that do not map to canonical
	// values. However, list entity types can contain references to other entity
	// types (with or without aliases).
	EntityType_KIND_LIST EntityType_Kind = 2
)

var EntityType_Kind_name = map[int32]string{
	0: "KIND_UNSPECIFIED",
	1: "KIND_MAP",
	2: "KIND_LIST",
}
var EntityType_Kind_value = map[string]int32{
	"KIND_UNSPECIFIED": 0,
	"KIND_MAP":         1,
	"KIND_LIST":        2,
}

func (x EntityType_Kind) String() string {
	return proto.EnumName(EntityType_Kind_name, int32(x))
}
func (EntityType_Kind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{0, 0}
}

// Represents different entity type expansion modes. Automated expansion
// allows an agent to recognize values that have not been explicitly listed in
// the entity (for example, new kinds of shopping list items).
type EntityType_AutoExpansionMode int32

const (
	// Auto expansion disabled for the entity.
	EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED EntityType_AutoExpansionMode = 0
	// Allows an agent to recognize values that have not been explicitly
	// listed in the entity.
	EntityType_AUTO_EXPANSION_MODE_DEFAULT EntityType_AutoExpansionMode = 1
)

var EntityType_AutoExpansionMode_name = map[int32]string{
	0: "AUTO_EXPANSION_MODE_UNSPECIFIED",
	1: "AUTO_EXPANSION_MODE_DEFAULT",
}
var EntityType_AutoExpansionMode_value = map[string]int32{
	"AUTO_EXPANSION_MODE_UNSPECIFIED": 0,
	"AUTO_EXPANSION_MODE_DEFAULT":     1,
}

func (x EntityType_AutoExpansionMode) String() string {
	return proto.EnumName(EntityType_AutoExpansionMode_name, int32(x))
}
func (EntityType_AutoExpansionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{0, 1}
}

// Represents an entity type.
// Entity types serve as a tool for extracting parameter values from natural
// language queries.
type EntityType struct {
	// The unique identifier of the entity type.
	// Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.UpdateEntityType] and
	// [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes] methods.
	// Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the entity type.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Indicates the kind of entity type.
	Kind EntityType_Kind `protobuf:"varint,3,opt,name=kind,proto3,enum=google.cloud.dialogflow.v2beta1.EntityType_Kind" json:"kind,omitempty"`
	// Optional. Indicates whether the entity type can be automatically
	// expanded.
	AutoExpansionMode EntityType_AutoExpansionMode `protobuf:"varint,4,opt,name=auto_expansion_mode,json=autoExpansionMode,proto3,enum=google.cloud.dialogflow.v2beta1.EntityType_AutoExpansionMode" json:"auto_expansion_mode,omitempty"`
	// Optional. The collection of entity entries associated with the entity type.
	Entities             []*EntityType_Entity `protobuf:"bytes,6,rep,name=entities,proto3" json:"entities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *EntityType) Reset()         { *m = EntityType{} }
func (m *EntityType) String() string { return proto.CompactTextString(m) }
func (*EntityType) ProtoMessage()    {}
func (*EntityType) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{0}
}
func (m *EntityType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityType.Unmarshal(m, b)
}
func (m *EntityType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityType.Marshal(b, m, deterministic)
}
func (dst *EntityType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityType.Merge(dst, src)
}
func (m *EntityType) XXX_Size() int {
	return xxx_messageInfo_EntityType.Size(m)
}
func (m *EntityType) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityType.DiscardUnknown(m)
}

var xxx_messageInfo_EntityType proto.InternalMessageInfo

func (m *EntityType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EntityType) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *EntityType) GetKind() EntityType_Kind {
	if m != nil {
		return m.Kind
	}
	return EntityType_KIND_UNSPECIFIED
}

func (m *EntityType) GetAutoExpansionMode() EntityType_AutoExpansionMode {
	if m != nil {
		return m.AutoExpansionMode
	}
	return EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED
}

func (m *EntityType) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

// An **entity entry** for an associated entity type.
type EntityType_Entity struct {
	// Required. The primary value associated with this entity entry.
	// For example, if the entity type is *vegetable*, the value could be
	// *scallions*.
	//
	// For `KIND_MAP` entity types:
	//
	// *   A canonical value to be used in place of synonyms.
	//
	// For `KIND_LIST` entity types:
	//
	// *   A string that can contain references to other entity types (with or
	//     without aliases).
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Required. A collection of value synonyms. For example, if the entity type
	// is *vegetable*, and `value` is *scallions*, a synonym could be *green
	// onions*.
	//
	// For `KIND_LIST` entity types:
	//
	// *   This collection must contain exactly one synonym equal to `value`.
	Synonyms             []string `protobuf:"bytes,2,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityType_Entity) Reset()         { *m = EntityType_Entity{} }
func (m *EntityType_Entity) String() string { return proto.CompactTextString(m) }
func (*EntityType_Entity) ProtoMessage()    {}
func (*EntityType_Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{0, 0}
}
func (m *EntityType_Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityType_Entity.Unmarshal(m, b)
}
func (m *EntityType_Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityType_Entity.Marshal(b, m, deterministic)
}
func (dst *EntityType_Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityType_Entity.Merge(dst, src)
}
func (m *EntityType_Entity) XXX_Size() int {
	return xxx_messageInfo_EntityType_Entity.Size(m)
}
func (m *EntityType_Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityType_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_EntityType_Entity proto.InternalMessageInfo

func (m *EntityType_Entity) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *EntityType_Entity) GetSynonyms() []string {
	if m != nil {
		return m.Synonyms
	}
	return nil
}

// The request message for [EntityTypes.ListEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.ListEntityTypes].
type ListEntityTypesRequest struct {
	// Required. The agent to list all entity types from.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language to list entity synonyms for. If not specified,
	// the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEntityTypesRequest) Reset()         { *m = ListEntityTypesRequest{} }
func (m *ListEntityTypesRequest) String() string { return proto.CompactTextString(m) }
func (*ListEntityTypesRequest) ProtoMessage()    {}
func (*ListEntityTypesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{1}
}
func (m *ListEntityTypesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntityTypesRequest.Unmarshal(m, b)
}
func (m *ListEntityTypesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntityTypesRequest.Marshal(b, m, deterministic)
}
func (dst *ListEntityTypesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntityTypesRequest.Merge(dst, src)
}
func (m *ListEntityTypesRequest) XXX_Size() int {
	return xxx_messageInfo_ListEntityTypesRequest.Size(m)
}
func (m *ListEntityTypesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntityTypesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntityTypesRequest proto.InternalMessageInfo

func (m *ListEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListEntityTypesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *ListEntityTypesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEntityTypesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [EntityTypes.ListEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.ListEntityTypes].
type ListEntityTypesResponse struct {
	// The list of agent entity types. There will be a maximum number of items
	// returned based on the page_size field in the request.
	EntityTypes []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEntityTypesResponse) Reset()         { *m = ListEntityTypesResponse{} }
func (m *ListEntityTypesResponse) String() string { return proto.CompactTextString(m) }
func (*ListEntityTypesResponse) ProtoMessage()    {}
func (*ListEntityTypesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{2}
}
func (m *ListEntityTypesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntityTypesResponse.Unmarshal(m, b)
}
func (m *ListEntityTypesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntityTypesResponse.Marshal(b, m, deterministic)
}
func (dst *ListEntityTypesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntityTypesResponse.Merge(dst, src)
}
func (m *ListEntityTypesResponse) XXX_Size() int {
	return xxx_messageInfo_ListEntityTypesResponse.Size(m)
}
func (m *ListEntityTypesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntityTypesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntityTypesResponse proto.InternalMessageInfo

func (m *ListEntityTypesResponse) GetEntityTypes() []*EntityType {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

func (m *ListEntityTypesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [EntityTypes.GetEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.GetEntityType].
type GetEntityTypeRequest struct {
	// Required. The name of the entity type.
	// Format: `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The language to retrieve entity synonyms for. If not specified,
	// the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEntityTypeRequest) Reset()         { *m = GetEntityTypeRequest{} }
func (m *GetEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*GetEntityTypeRequest) ProtoMessage()    {}
func (*GetEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{3}
}
func (m *GetEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEntityTypeRequest.Unmarshal(m, b)
}
func (m *GetEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEntityTypeRequest.Marshal(b, m, deterministic)
}
func (dst *GetEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEntityTypeRequest.Merge(dst, src)
}
func (m *GetEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_GetEntityTypeRequest.Size(m)
}
func (m *GetEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEntityTypeRequest proto.InternalMessageInfo

func (m *GetEntityTypeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetEntityTypeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// The request message for [EntityTypes.CreateEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.CreateEntityType].
type CreateEntityTypeRequest struct {
	// Required. The agent to create a entity type for.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entity type to create.
	EntityType *EntityType `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The language of entity synonyms defined in `entity_type`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateEntityTypeRequest) Reset()         { *m = CreateEntityTypeRequest{} }
func (m *CreateEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*CreateEntityTypeRequest) ProtoMessage()    {}
func (*CreateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{4}
}
func (m *CreateEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateEntityTypeRequest.Unmarshal(m, b)
}
func (m *CreateEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateEntityTypeRequest.Marshal(b, m, deterministic)
}
func (dst *CreateEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateEntityTypeRequest.Merge(dst, src)
}
func (m *CreateEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_CreateEntityTypeRequest.Size(m)
}
func (m *CreateEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateEntityTypeRequest proto.InternalMessageInfo

func (m *CreateEntityTypeRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateEntityTypeRequest) GetEntityType() *EntityType {
	if m != nil {
		return m.EntityType
	}
	return nil
}

func (m *CreateEntityTypeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// The request message for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.UpdateEntityType].
type UpdateEntityTypeRequest struct {
	// Required. The entity type to update.
	EntityType *EntityType `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The language of entity synonyms defined in `entity_type`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateEntityTypeRequest) Reset()         { *m = UpdateEntityTypeRequest{} }
func (m *UpdateEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateEntityTypeRequest) ProtoMessage()    {}
func (*UpdateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{5}
}
func (m *UpdateEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateEntityTypeRequest.Unmarshal(m, b)
}
func (m *UpdateEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateEntityTypeRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateEntityTypeRequest.Merge(dst, src)
}
func (m *UpdateEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateEntityTypeRequest.Size(m)
}
func (m *UpdateEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateEntityTypeRequest proto.InternalMessageInfo

func (m *UpdateEntityTypeRequest) GetEntityType() *EntityType {
	if m != nil {
		return m.EntityType
	}
	return nil
}

func (m *UpdateEntityTypeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *UpdateEntityTypeRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [EntityTypes.DeleteEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.DeleteEntityType].
type DeleteEntityTypeRequest struct {
	// Required. The name of the entity type to delete.
	// Format: `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEntityTypeRequest) Reset()         { *m = DeleteEntityTypeRequest{} }
func (m *DeleteEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEntityTypeRequest) ProtoMessage()    {}
func (*DeleteEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{6}
}
func (m *DeleteEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEntityTypeRequest.Unmarshal(m, b)
}
func (m *DeleteEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEntityTypeRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEntityTypeRequest.Merge(dst, src)
}
func (m *DeleteEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEntityTypeRequest.Size(m)
}
func (m *DeleteEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEntityTypeRequest proto.InternalMessageInfo

func (m *DeleteEntityTypeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes].
type BatchUpdateEntityTypesRequest struct {
	// Required. The name of the agent to update or create entity types in.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The source of the entity type batch.
	//
	// For each entity type in the batch:
	//
	// *   If `name` is specified, we update an existing entity type.
	// *   If `name` is not specified, we create a new entity type.
	//
	// Types that are valid to be assigned to EntityTypeBatch:
	//	*BatchUpdateEntityTypesRequest_EntityTypeBatchUri
	//	*BatchUpdateEntityTypesRequest_EntityTypeBatchInline
	EntityTypeBatch isBatchUpdateEntityTypesRequest_EntityTypeBatch `protobuf_oneof:"entity_type_batch"`
	// Optional. The language of entity synonyms defined in `entity_types`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BatchUpdateEntityTypesRequest) Reset()         { *m = BatchUpdateEntityTypesRequest{} }
func (m *BatchUpdateEntityTypesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateEntityTypesRequest) ProtoMessage()    {}
func (*BatchUpdateEntityTypesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{7}
}
func (m *BatchUpdateEntityTypesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateEntityTypesRequest.Unmarshal(m, b)
}
func (m *BatchUpdateEntityTypesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateEntityTypesRequest.Marshal(b, m, deterministic)
}
func (dst *BatchUpdateEntityTypesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateEntityTypesRequest.Merge(dst, src)
}
func (m *BatchUpdateEntityTypesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateEntityTypesRequest.Size(m)
}
func (m *BatchUpdateEntityTypesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateEntityTypesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateEntityTypesRequest proto.InternalMessageInfo

func (m *BatchUpdateEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isBatchUpdateEntityTypesRequest_EntityTypeBatch interface {
	isBatchUpdateEntityTypesRequest_EntityTypeBatch()
}

type BatchUpdateEntityTypesRequest_EntityTypeBatchUri struct {
	EntityTypeBatchUri string `protobuf:"bytes,2,opt,name=entity_type_batch_uri,json=entityTypeBatchUri,proto3,oneof"`
}

type BatchUpdateEntityTypesRequest_EntityTypeBatchInline struct {
	EntityTypeBatchInline *EntityTypeBatch `protobuf:"bytes,3,opt,name=entity_type_batch_inline,json=entityTypeBatchInline,proto3,oneof"`
}

func (*BatchUpdateEntityTypesRequest_EntityTypeBatchUri) isBatchUpdateEntityTypesRequest_EntityTypeBatch() {
}

func (*BatchUpdateEntityTypesRequest_EntityTypeBatchInline) isBatchUpdateEntityTypesRequest_EntityTypeBatch() {
}

func (m *BatchUpdateEntityTypesRequest) GetEntityTypeBatch() isBatchUpdateEntityTypesRequest_EntityTypeBatch {
	if m != nil {
		return m.EntityTypeBatch
	}
	return nil
}

func (m *BatchUpdateEntityTypesRequest) GetEntityTypeBatchUri() string {
	if x, ok := m.GetEntityTypeBatch().(*BatchUpdateEntityTypesRequest_EntityTypeBatchUri); ok {
		return x.EntityTypeBatchUri
	}
	return ""
}

func (m *BatchUpdateEntityTypesRequest) GetEntityTypeBatchInline() *EntityTypeBatch {
	if x, ok := m.GetEntityTypeBatch().(*BatchUpdateEntityTypesRequest_EntityTypeBatchInline); ok {
		return x.EntityTypeBatchInline
	}
	return nil
}

func (m *BatchUpdateEntityTypesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *BatchUpdateEntityTypesRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BatchUpdateEntityTypesRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BatchUpdateEntityTypesRequest_OneofMarshaler, _BatchUpdateEntityTypesRequest_OneofUnmarshaler, _BatchUpdateEntityTypesRequest_OneofSizer, []interface{}{
		(*BatchUpdateEntityTypesRequest_EntityTypeBatchUri)(nil),
		(*BatchUpdateEntityTypesRequest_EntityTypeBatchInline)(nil),
	}
}

func _BatchUpdateEntityTypesRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BatchUpdateEntityTypesRequest)
	// entity_type_batch
	switch x := m.EntityTypeBatch.(type) {
	case *BatchUpdateEntityTypesRequest_EntityTypeBatchUri:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.EntityTypeBatchUri)
	case *BatchUpdateEntityTypesRequest_EntityTypeBatchInline:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EntityTypeBatchInline); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("BatchUpdateEntityTypesRequest.EntityTypeBatch has unexpected type %T", x)
	}
	return nil
}

func _BatchUpdateEntityTypesRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BatchUpdateEntityTypesRequest)
	switch tag {
	case 2: // entity_type_batch.entity_type_batch_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.EntityTypeBatch = &BatchUpdateEntityTypesRequest_EntityTypeBatchUri{x}
		return true, err
	case 3: // entity_type_batch.entity_type_batch_inline
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EntityTypeBatch)
		err := b.DecodeMessage(msg)
		m.EntityTypeBatch = &BatchUpdateEntityTypesRequest_EntityTypeBatchInline{msg}
		return true, err
	default:
		return false, nil
	}
}

func _BatchUpdateEntityTypesRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BatchUpdateEntityTypesRequest)
	// entity_type_batch
	switch x := m.EntityTypeBatch.(type) {
	case *BatchUpdateEntityTypesRequest_EntityTypeBatchUri:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.EntityTypeBatchUri)))
		n += len(x.EntityTypeBatchUri)
	case *BatchUpdateEntityTypesRequest_EntityTypeBatchInline:
		s := proto.Size(x.EntityTypeBatchInline)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response message for [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes].
type BatchUpdateEntityTypesResponse struct {
	// The collection of updated or created entity types.
	EntityTypes          []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *BatchUpdateEntityTypesResponse) Reset()         { *m = BatchUpdateEntityTypesResponse{} }
func (m *BatchUpdateEntityTypesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateEntityTypesResponse) ProtoMessage()    {}
func (*BatchUpdateEntityTypesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{8}
}
func (m *BatchUpdateEntityTypesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateEntityTypesResponse.Unmarshal(m, b)
}
func (m *BatchUpdateEntityTypesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateEntityTypesResponse.Marshal(b, m, deterministic)
}
func (dst *BatchUpdateEntityTypesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateEntityTypesResponse.Merge(dst, src)
}
func (m *BatchUpdateEntityTypesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateEntityTypesResponse.Size(m)
}
func (m *BatchUpdateEntityTypesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateEntityTypesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateEntityTypesResponse proto.InternalMessageInfo

func (m *BatchUpdateEntityTypesResponse) GetEntityTypes() []*EntityType {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

// The request message for [EntityTypes.BatchDeleteEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchDeleteEntityTypes].
type BatchDeleteEntityTypesRequest struct {
	// Required. The name of the agent to delete all entities types for. Format:
	// `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names entity types to delete. All names must point to the
	// same agent as `parent`.
	EntityTypeNames      []string `protobuf:"bytes,2,rep,name=entity_type_names,json=entityTypeNames,proto3" json:"entity_type_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchDeleteEntityTypesRequest) Reset()         { *m = BatchDeleteEntityTypesRequest{} }
func (m *BatchDeleteEntityTypesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteEntityTypesRequest) ProtoMessage()    {}
func (*BatchDeleteEntityTypesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{9}
}
func (m *BatchDeleteEntityTypesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteEntityTypesRequest.Unmarshal(m, b)
}
func (m *BatchDeleteEntityTypesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteEntityTypesRequest.Marshal(b, m, deterministic)
}
func (dst *BatchDeleteEntityTypesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteEntityTypesRequest.Merge(dst, src)
}
func (m *BatchDeleteEntityTypesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteEntityTypesRequest.Size(m)
}
func (m *BatchDeleteEntityTypesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteEntityTypesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteEntityTypesRequest proto.InternalMessageInfo

func (m *BatchDeleteEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteEntityTypesRequest) GetEntityTypeNames() []string {
	if m != nil {
		return m.EntityTypeNames
	}
	return nil
}

// The request message for [EntityTypes.BatchCreateEntities][google.cloud.dialogflow.v2beta1.EntityTypes.BatchCreateEntities].
type BatchCreateEntitiesRequest struct {
	// Required. The name of the entity type to create entities in. Format:
	// `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entities to create.
	Entities []*EntityType_Entity `protobuf:"bytes,2,rep,name=entities,proto3" json:"entities,omitempty"`
	// Optional. The language of entity synonyms defined in `entities`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchCreateEntitiesRequest) Reset()         { *m = BatchCreateEntitiesRequest{} }
func (m *BatchCreateEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchCreateEntitiesRequest) ProtoMessage()    {}
func (*BatchCreateEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{10}
}
func (m *BatchCreateEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateEntitiesRequest.Unmarshal(m, b)
}
func (m *BatchCreateEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateEntitiesRequest.Marshal(b, m, deterministic)
}
func (dst *BatchCreateEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateEntitiesRequest.Merge(dst, src)
}
func (m *BatchCreateEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchCreateEntitiesRequest.Size(m)
}
func (m *BatchCreateEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateEntitiesRequest proto.InternalMessageInfo

func (m *BatchCreateEntitiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchCreateEntitiesRequest) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

func (m *BatchCreateEntitiesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// The request message for [EntityTypes.BatchUpdateEntities][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntities].
type BatchUpdateEntitiesRequest struct {
	// Required. The name of the entity type to update or create entities in.
	// Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entities to update or create.
	Entities []*EntityType_Entity `protobuf:"bytes,2,rep,name=entities,proto3" json:"entities,omitempty"`
	// Optional. The language of entity synonyms defined in `entities`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BatchUpdateEntitiesRequest) Reset()         { *m = BatchUpdateEntitiesRequest{} }
func (m *BatchUpdateEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateEntitiesRequest) ProtoMessage()    {}
func (*BatchUpdateEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{11}
}
func (m *BatchUpdateEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateEntitiesRequest.Unmarshal(m, b)
}
func (m *BatchUpdateEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateEntitiesRequest.Marshal(b, m, deterministic)
}
func (dst *BatchUpdateEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateEntitiesRequest.Merge(dst, src)
}
func (m *BatchUpdateEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateEntitiesRequest.Size(m)
}
func (m *BatchUpdateEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateEntitiesRequest proto.InternalMessageInfo

func (m *BatchUpdateEntitiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchUpdateEntitiesRequest) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

func (m *BatchUpdateEntitiesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *BatchUpdateEntitiesRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [EntityTypes.BatchDeleteEntities][google.cloud.dialogflow.v2beta1.EntityTypes.BatchDeleteEntities].
type BatchDeleteEntitiesRequest struct {
	// Required. The name of the entity type to delete entries for. Format:
	// `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The canonical `values` of the entities to delete. Note that
	// these are not fully-qualified names, i.e. they don't start with
	// `projects/<Project ID>`.
	EntityValues []string `protobuf:"bytes,2,rep,name=entity_values,json=entityValues,proto3" json:"entity_values,omitempty"`
	// Optional. The language of entity synonyms defined in `entities`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchDeleteEntitiesRequest) Reset()         { *m = BatchDeleteEntitiesRequest{} }
func (m *BatchDeleteEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteEntitiesRequest) ProtoMessage()    {}
func (*BatchDeleteEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{12}
}
func (m *BatchDeleteEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteEntitiesRequest.Unmarshal(m, b)
}
func (m *BatchDeleteEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteEntitiesRequest.Marshal(b, m, deterministic)
}
func (dst *BatchDeleteEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteEntitiesRequest.Merge(dst, src)
}
func (m *BatchDeleteEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteEntitiesRequest.Size(m)
}
func (m *BatchDeleteEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteEntitiesRequest proto.InternalMessageInfo

func (m *BatchDeleteEntitiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteEntitiesRequest) GetEntityValues() []string {
	if m != nil {
		return m.EntityValues
	}
	return nil
}

func (m *BatchDeleteEntitiesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// This message is a wrapper around a collection of entity types.
type EntityTypeBatch struct {
	// A collection of entity types.
	EntityTypes          []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *EntityTypeBatch) Reset()         { *m = EntityTypeBatch{} }
func (m *EntityTypeBatch) String() string { return proto.CompactTextString(m) }
func (*EntityTypeBatch) ProtoMessage()    {}
func (*EntityTypeBatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_entity_type_5d56c2b8d11cd69d, []int{13}
}
func (m *EntityTypeBatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityTypeBatch.Unmarshal(m, b)
}
func (m *EntityTypeBatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityTypeBatch.Marshal(b, m, deterministic)
}
func (dst *EntityTypeBatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityTypeBatch.Merge(dst, src)
}
func (m *EntityTypeBatch) XXX_Size() int {
	return xxx_messageInfo_EntityTypeBatch.Size(m)
}
func (m *EntityTypeBatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityTypeBatch.DiscardUnknown(m)
}

var xxx_messageInfo_EntityTypeBatch proto.InternalMessageInfo

func (m *EntityTypeBatch) GetEntityTypes() []*EntityType {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

func init() {
	proto.RegisterType((*EntityType)(nil), "google.cloud.dialogflow.v2beta1.EntityType")
	proto.RegisterType((*EntityType_Entity)(nil), "google.cloud.dialogflow.v2beta1.EntityType.Entity")
	proto.RegisterType((*ListEntityTypesRequest)(nil), "google.cloud.dialogflow.v2beta1.ListEntityTypesRequest")
	proto.RegisterType((*ListEntityTypesResponse)(nil), "google.cloud.dialogflow.v2beta1.ListEntityTypesResponse")
	proto.RegisterType((*GetEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.GetEntityTypeRequest")
	proto.RegisterType((*CreateEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.CreateEntityTypeRequest")
	proto.RegisterType((*UpdateEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.UpdateEntityTypeRequest")
	proto.RegisterType((*DeleteEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteEntityTypeRequest")
	proto.RegisterType((*BatchUpdateEntityTypesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest")
	proto.RegisterType((*BatchUpdateEntityTypesResponse)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesResponse")
	proto.RegisterType((*BatchDeleteEntityTypesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchDeleteEntityTypesRequest")
	proto.RegisterType((*BatchCreateEntitiesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchCreateEntitiesRequest")
	proto.RegisterType((*BatchUpdateEntitiesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateEntitiesRequest")
	proto.RegisterType((*BatchDeleteEntitiesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchDeleteEntitiesRequest")
	proto.RegisterType((*EntityTypeBatch)(nil), "google.cloud.dialogflow.v2beta1.EntityTypeBatch")
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.EntityType_Kind", EntityType_Kind_name, EntityType_Kind_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.EntityType_AutoExpansionMode", EntityType_AutoExpansionMode_name, EntityType_AutoExpansionMode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// EntityTypesClient is the client API for EntityTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EntityTypesClient interface {
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error)
	// Retrieves the specified entity type.
	GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Updates the specified entity type.
	UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Deletes the specified entity type.
	DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates/Creates multiple entity types in the specified agent.
	//
	// Operation <response: [BatchUpdateEntityTypesResponse][google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesResponse]>
	BatchUpdateEntityTypes(ctx context.Context, in *BatchUpdateEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes entity types in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntityTypes(ctx context.Context, in *BatchDeleteEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates multiple new entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchCreateEntities(ctx context.Context, in *BatchCreateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates or creates multiple entities in the specified entity type. This
	// method does not affect entities in the entity type that aren't explicitly
	// specified in the request.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchUpdateEntities(ctx context.Context, in *BatchUpdateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntities(ctx context.Context, in *BatchDeleteEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type entityTypesClient struct {
	cc *grpc.ClientConn
}

func NewEntityTypesClient(cc *grpc.ClientConn) EntityTypesClient {
	return &entityTypesClient{cc}
}

func (c *entityTypesClient) ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error) {
	out := new(ListEntityTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/ListEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/GetEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/CreateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/UpdateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/DeleteEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchUpdateEntityTypes(ctx context.Context, in *BatchUpdateEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchUpdateEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchDeleteEntityTypes(ctx context.Context, in *BatchDeleteEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchDeleteEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchCreateEntities(ctx context.Context, in *BatchCreateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchCreateEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchUpdateEntities(ctx context.Context, in *BatchUpdateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchUpdateEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchDeleteEntities(ctx context.Context, in *BatchDeleteEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchDeleteEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EntityTypesServer is the server API for EntityTypes service.
type EntityTypesServer interface {
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error)
	// Retrieves the specified entity type.
	GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(context.Context, *CreateEntityTypeRequest) (*EntityType, error)
	// Updates the specified entity type.
	UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error)
	// Deletes the specified entity type.
	DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*empty.Empty, error)
	// Updates/Creates multiple entity types in the specified agent.
	//
	// Operation <response: [BatchUpdateEntityTypesResponse][google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesResponse]>
	BatchUpdateEntityTypes(context.Context, *BatchUpdateEntityTypesRequest) (*longrunning.Operation, error)
	// Deletes entity types in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntityTypes(context.Context, *BatchDeleteEntityTypesRequest) (*longrunning.Operation, error)
	// Creates multiple new entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchCreateEntities(context.Context, *BatchCreateEntitiesRequest) (*longrunning.Operation, error)
	// Updates or creates multiple entities in the specified entity type. This
	// method does not affect entities in the entity type that aren't explicitly
	// specified in the request.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchUpdateEntities(context.Context, *BatchUpdateEntitiesRequest) (*longrunning.Operation, error)
	// Deletes entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntities(context.Context, *BatchDeleteEntitiesRequest) (*longrunning.Operation, error)
}

func RegisterEntityTypesServer(s *grpc.Server, srv EntityTypesServer) {
	s.RegisterService(&_EntityTypes_serviceDesc, srv)
}

func _EntityTypes_ListEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/ListEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, req.(*ListEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_GetEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).GetEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/GetEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).GetEntityType(ctx, req.(*GetEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_CreateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).CreateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/CreateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).CreateEntityType(ctx, req.(*CreateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_UpdateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/UpdateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, req.(*UpdateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_DeleteEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/DeleteEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, req.(*DeleteEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchUpdateEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchUpdateEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchUpdateEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchUpdateEntityTypes(ctx, req.(*BatchUpdateEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchDeleteEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchDeleteEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchDeleteEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchDeleteEntityTypes(ctx, req.(*BatchDeleteEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchCreateEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchCreateEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchCreateEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchCreateEntities(ctx, req.(*BatchCreateEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchUpdateEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchUpdateEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchUpdateEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchUpdateEntities(ctx, req.(*BatchUpdateEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchDeleteEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchDeleteEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchDeleteEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchDeleteEntities(ctx, req.(*BatchDeleteEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EntityTypes_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.EntityTypes",
	HandlerType: (*EntityTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEntityTypes",
			Handler:    _EntityTypes_ListEntityTypes_Handler,
		},
		{
			MethodName: "GetEntityType",
			Handler:    _EntityTypes_GetEntityType_Handler,
		},
		{
			MethodName: "CreateEntityType",
			Handler:    _EntityTypes_CreateEntityType_Handler,
		},
		{
			MethodName: "UpdateEntityType",
			Handler:    _EntityTypes_UpdateEntityType_Handler,
		},
		{
			MethodName: "DeleteEntityType",
			Handler:    _EntityTypes_DeleteEntityType_Handler,
		},
		{
			MethodName: "BatchUpdateEntityTypes",
			Handler:    _EntityTypes_BatchUpdateEntityTypes_Handler,
		},
		{
			MethodName: "BatchDeleteEntityTypes",
			Handler:    _EntityTypes_BatchDeleteEntityTypes_Handler,
		},
		{
			MethodName: "BatchCreateEntities",
			Handler:    _EntityTypes_BatchCreateEntities_Handler,
		},
		{
			MethodName: "BatchUpdateEntities",
			Handler:    _EntityTypes_BatchUpdateEntities_Handler,
		},
		{
			MethodName: "BatchDeleteEntities",
			Handler:    _EntityTypes_BatchDeleteEntities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/entity_type.proto",
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/entity_type.proto", fileDescriptor_entity_type_5d56c2b8d11cd69d)
}

var fileDescriptor_entity_type_5d56c2b8d11cd69d = []byte{
	// 1246 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0x4f, 0x6f, 0xe3, 0x44,
	0x14, 0xdf, 0x49, 0xb3, 0x55, 0xfb, 0xd2, 0x6e, 0xd3, 0x69, 0xb7, 0x0d, 0xe9, 0x96, 0x16, 0x57,
	0x42, 0x55, 0x11, 0xf1, 0x6e, 0x56, 0xfc, 0x6b, 0x55, 0x50, 0xdb, 0xa4, 0xbb, 0x61, 0xdb, 0x24,
	0x72, 0xdb, 0x15, 0x70, 0xb1, 0xdc, 0x64, 0x1a, 0x4c, 0x93, 0x19, 0xe3, 0x3f, 0xcb, 0x66, 0xd1,
	0x72, 0xe0, 0x1b, 0x20, 0x6e, 0x88, 0x13, 0xe2, 0x02, 0x88, 0x6f, 0x80, 0xb8, 0x70, 0x82, 0x13,
	0x12, 0x5f, 0x01, 0xf1, 0x19, 0x90, 0xb8, 0x20, 0x8f, 0xed, 0xd8, 0x71, 0x1c, 0x6c, 0xc3, 0xee,
	0x8a, 0x5b, 0xe6, 0xcf, 0x7b, 0xef, 0xf7, 0x7b, 0xef, 0xcd, 0xfc, 0xc6, 0x81, 0x5b, 0x1d, 0xc6,
	0x3a, 0x5d, 0x22, 0xb6, 0xba, 0xcc, 0x6a, 0x8b, 0x6d, 0x55, 0xe9, 0xb2, 0xce, 0x45, 0x97, 0x7d,
	0x24, 0x3e, 0x28, 0x9f, 0x13, 0x53, 0xb9, 0x25, 0x12, 0x6a, 0xaa, 0x66, 0x5f, 0x36, 0xfb, 0x1a,
	0x29, 0x69, 0x3a, 0x33, 0x19, 0x5e, 0x73, 0x4c, 0x4a, 0xdc, 0xa4, 0xe4, 0x9b, 0x94, 0x5c, 0x93,
	0xe2, 0x0d, 0xd7, 0xa7, 0xa2, 0xa9, 0xa2, 0x42, 0x29, 0x33, 0x15, 0x53, 0x65, 0xd4, 0x70, 0xcc,
	0x8b, 0xcf, 0x05, 0x56, 0x75, 0x62, 0x30, 0x4b, 0x6f, 0xb9, 0x9e, 0x8b, 0x1b, 0xee, 0x52, 0x97,
	0xd1, 0x8e, 0x6e, 0x51, 0xaa, 0xd2, 0x8e, 0xc8, 0x34, 0xa2, 0x0f, 0xd9, 0xaf, 0xb8, 0x9b, 0xf8,
	0xe8, 0xdc, 0xba, 0x10, 0x49, 0x4f, 0x33, 0xfb, 0xee, 0xe2, 0x7a, 0x78, 0xf1, 0x42, 0x25, 0xdd,
	0xb6, 0xdc, 0x53, 0x8c, 0x4b, 0x77, 0xc7, 0x8d, 0xf0, 0x0e, 0xc3, 0xd4, 0xad, 0x96, 0xe9, 0xac,
	0x0a, 0x5f, 0x64, 0x01, 0xaa, 0x9c, 0xf1, 0x69, 0x5f, 0x23, 0x18, 0x43, 0x96, 0x2a, 0x3d, 0x52,
	0x40, 0xeb, 0x68, 0x73, 0x5a, 0xe2, 0xbf, 0xf1, 0x0b, 0x30, 0xd3, 0x56, 0x0d, 0xad, 0xab, 0xf4,
	0x65, 0xbe, 0x96, 0xe1, 0x6b, 0x39, 0x77, 0xae, 0x6e, 0x6f, 0xa9, 0x40, 0xf6, 0x52, 0xa5, 0xed,
	0xc2, 0xc4, 0x3a, 0xda, 0xbc, 0x56, 0xbe, 0x59, 0x8a, 0x49, 0x58, 0xc9, 0x8f, 0x58, 0xba, 0xa7,
	0xd2, 0xb6, 0xc4, 0xad, 0x71, 0x0f, 0x16, 0x14, 0xcb, 0x64, 0x32, 0x79, 0xa8, 0x29, 0xd4, 0x50,
	0x19, 0x95, 0x7b, 0xac, 0x4d, 0x0a, 0x59, 0xee, 0x74, 0x37, 0x8d, 0xd3, 0x3d, 0xcb, 0x64, 0x55,
	0xcf, 0xcb, 0x31, 0x6b, 0x13, 0x69, 0x5e, 0x09, 0x4f, 0xe1, 0x3a, 0x4c, 0xf1, 0x5a, 0xab, 0xc4,
	0x28, 0x4c, 0xae, 0x4f, 0x6c, 0xe6, 0xca, 0xe5, 0x34, 0x31, 0x9c, 0x9f, 0xd2, 0xc0, 0x47, 0x71,
	0x1b, 0x26, 0x9d, 0x39, 0xbc, 0x08, 0x57, 0x1f, 0x28, 0x5d, 0xcb, 0x4b, 0xa3, 0x33, 0xc0, 0x45,
	0x98, 0x32, 0xfa, 0x94, 0xd1, 0x7e, 0xcf, 0x28, 0x64, 0xd6, 0x27, 0x36, 0xa7, 0xa5, 0xc1, 0x58,
	0x78, 0x03, 0xb2, 0x76, 0x22, 0xf0, 0x22, 0xe4, 0xef, 0xd5, 0xea, 0x15, 0xf9, 0xac, 0x7e, 0xd2,
	0xac, 0x1e, 0xd4, 0x0e, 0x6b, 0xd5, 0x4a, 0xfe, 0x0a, 0x9e, 0x81, 0x29, 0x3e, 0x7b, 0xbc, 0xd7,
	0xcc, 0x23, 0x3c, 0x0b, 0xd3, 0x7c, 0x74, 0x54, 0x3b, 0x39, 0xcd, 0x67, 0x84, 0x77, 0x61, 0x7e,
	0x84, 0x2e, 0xde, 0x80, 0xb5, 0xbd, 0xb3, 0xd3, 0x86, 0x5c, 0x7d, 0xa7, 0xb9, 0x57, 0x3f, 0xa9,
	0x35, 0xea, 0xf2, 0x71, 0xa3, 0x52, 0x0d, 0xb9, 0x5d, 0x83, 0x95, 0xa8, 0x4d, 0x95, 0xea, 0xe1,
	0xde, 0xd9, 0xd1, 0x69, 0x1e, 0x09, 0x9f, 0x21, 0x58, 0x3a, 0x52, 0x0d, 0xd3, 0x67, 0x6d, 0x48,
	0xe4, 0x43, 0x8b, 0x18, 0x26, 0x5e, 0x82, 0x49, 0x4d, 0xd1, 0x09, 0x35, 0x5d, 0x8e, 0xee, 0x08,
	0x6f, 0xc0, 0x6c, 0x57, 0xa1, 0x1d, 0x4b, 0xe9, 0x10, 0xb9, 0x65, 0x57, 0xcf, 0xe9, 0x96, 0x19,
	0x6f, 0xf2, 0xc0, 0x46, 0xb7, 0x02, 0xd3, 0x9a, 0xbd, 0xc1, 0x50, 0x1f, 0x11, 0xde, 0x33, 0x57,
	0xa5, 0x29, 0x7b, 0xe2, 0x44, 0x7d, 0x44, 0xf0, 0x2a, 0x00, 0x5f, 0x34, 0xd9, 0x25, 0xa1, 0xbc,
	0xf8, 0xd3, 0x12, 0xdf, 0x7e, 0x6a, 0x4f, 0xd8, 0x98, 0x96, 0x47, 0x30, 0x19, 0x1a, 0xa3, 0x86,
	0x5d, 0xd1, 0x99, 0xc0, 0xe9, 0x35, 0x0a, 0x88, 0x57, 0xf5, 0xa5, 0x14, 0x55, 0x95, 0x72, 0xc4,
	0xf7, 0x8b, 0x5f, 0x84, 0x39, 0x4a, 0x1e, 0x9a, 0x72, 0x00, 0x8f, 0x43, 0x67, 0xd6, 0x9e, 0x6e,
	0x0e, 0x30, 0x35, 0x60, 0xf1, 0x0e, 0x09, 0x20, 0xf2, 0x92, 0x14, 0x75, 0x9a, 0x92, 0x24, 0x48,
	0xf8, 0x1a, 0xc1, 0xf2, 0x81, 0x4e, 0x14, 0x93, 0x8c, 0x3a, 0x1d, 0x97, 0xf9, 0x23, 0xc8, 0x05,
	0xc8, 0x73, 0xb7, 0x29, 0xb9, 0x83, 0xcf, 0x7d, 0x14, 0xe6, 0x44, 0x04, 0xcc, 0x9f, 0x11, 0x2c,
	0x9f, 0x69, 0xed, 0x48, 0x98, 0x21, 0x38, 0xe8, 0x09, 0xc3, 0x89, 0x6a, 0xab, 0x1d, 0xc8, 0x59,
	0x1c, 0x0d, 0xbf, 0xfe, 0x38, 0xe2, 0x5c, 0xb9, 0xe8, 0x85, 0xf4, 0xee, 0xbf, 0xd2, 0xa1, 0x7d,
	0x43, 0x1e, 0x2b, 0xc6, 0xa5, 0x04, 0xce, 0x76, 0xfb, 0xb7, 0xf0, 0x32, 0x2c, 0x57, 0x48, 0x97,
	0x44, 0x51, 0x89, 0x28, 0xa3, 0xf0, 0x6b, 0x06, 0x56, 0xf7, 0x15, 0xb3, 0xf5, 0x7e, 0x98, 0x7f,
	0xec, 0x09, 0xb9, 0x0d, 0xd7, 0x03, 0x89, 0x91, 0xcf, 0x6d, 0x27, 0xb2, 0xa5, 0xab, 0x0e, 0xa5,
	0xbb, 0x57, 0x24, 0xec, 0xf3, 0x76, 0x22, 0xe8, 0x2a, 0xbe, 0x84, 0xc2, 0xa8, 0x91, 0x4a, 0xbb,
	0x2a, 0x25, 0x2e, 0xcf, 0x34, 0x97, 0x2e, 0x77, 0x7b, 0xf7, 0x8a, 0x74, 0x3d, 0x14, 0xa9, 0xc6,
	0x1d, 0x8e, 0x26, 0x3b, 0x1b, 0x9f, 0xec, 0xab, 0x69, 0x92, 0xbd, 0xbf, 0x00, 0xf3, 0x23, 0x74,
	0x04, 0x0d, 0x9e, 0x1f, 0x97, 0xd1, 0xa7, 0x73, 0xbe, 0x85, 0x96, 0x5b, 0xc3, 0x70, 0xe1, 0x63,
	0x6b, 0xb8, 0x35, 0x8c, 0xdf, 0xee, 0x08, 0xef, 0x4e, 0x9f, 0xf3, 0x03, 0xd8, 0xd2, 0x68, 0x08,
	0xdf, 0x20, 0x28, 0xf2, 0x28, 0x81, 0x03, 0xad, 0xc6, 0x87, 0x08, 0xaa, 0x53, 0xe6, 0xbf, 0xab,
	0x53, 0xb2, 0x03, 0xfd, 0x87, 0x87, 0x35, 0x50, 0x83, 0xff, 0x29, 0xd6, 0x70, 0x03, 0x66, 0x53,
	0x9d, 0xf6, 0x4f, 0x5c, 0x9e, 0x81, 0xca, 0xab, 0x89, 0xc4, 0xcd, 0x2d, 0x3b, 0x57, 0x74, 0xaf,
	0xe4, 0x6e, 0x53, 0xde, 0xe7, 0x73, 0xc9, 0x12, 0xad, 0xc0, 0x5c, 0xe8, 0x38, 0x3e, 0xe9, 0xe6,
	0x2e, 0xff, 0x75, 0x0d, 0x72, 0x81, 0x96, 0xc6, 0x3f, 0x20, 0x98, 0x0b, 0x09, 0x27, 0x7e, 0x2d,
	0xd6, 0x7b, 0xb4, 0xfc, 0x17, 0x5f, 0x4f, 0x6f, 0xe8, 0x9c, 0x61, 0xe1, 0xd5, 0x4f, 0x7f, 0xfb,
	0xfd, 0xf3, 0xcc, 0x4d, 0x5c, 0x1a, 0x3c, 0xb8, 0x3f, 0x76, 0xb2, 0xbb, 0xab, 0xe9, 0xec, 0x03,
	0xd2, 0x32, 0x0d, 0x71, 0x4b, 0x54, 0x3a, 0x84, 0x9a, 0x8f, 0xc5, 0xa0, 0x16, 0x7f, 0x87, 0x60,
	0x76, 0x48, 0x64, 0xf1, 0x2b, 0xb1, 0x18, 0xa2, 0x44, 0xb9, 0x98, 0x26, 0xa3, 0x51, 0x68, 0xed,
	0xc3, 0x3e, 0x82, 0x35, 0x08, 0x55, 0xdc, 0x7a, 0x8c, 0x7f, 0x44, 0x90, 0x0f, 0x0b, 0x38, 0x8e,
	0x4f, 0xda, 0x18, 0xcd, 0x4f, 0x87, 0xf9, 0x80, 0x63, 0xde, 0x15, 0x52, 0x66, 0x78, 0x3b, 0xa8,
	0xd7, 0xf8, 0x17, 0x04, 0xf9, 0xf0, 0x45, 0x9c, 0x80, 0xc0, 0x98, 0xd7, 0x40, 0x3a, 0x02, 0x0d,
	0x4e, 0xa0, 0x56, 0xde, 0xf6, 0x09, 0x04, 0x3f, 0xca, 0x92, 0x14, 0x60, 0x98, 0xcc, 0x97, 0x08,
	0xf2, 0xe1, 0x3b, 0x3e, 0x01, 0x99, 0x31, 0xef, 0x81, 0xe2, 0xd2, 0xc8, 0x25, 0x53, 0xb5, 0xbf,
	0xc8, 0xbc, 0x66, 0xd9, 0xfa, 0x17, 0xcd, 0xb2, 0x14, 0xad, 0x7c, 0xf8, 0xcd, 0x58, 0x90, 0xff,
	0xf8, 0x08, 0x29, 0xae, 0x7a, 0xf6, 0x81, 0x2f, 0xcc, 0x52, 0xc3, 0xfb, 0xc2, 0x14, 0xaa, 0x1c,
	0xf1, 0x5b, 0xc2, 0x76, 0xca, 0x56, 0x39, 0xf7, 0x83, 0x6e, 0xa3, 0x2d, 0x9f, 0xc0, 0x88, 0x90,
	0x26, 0x25, 0x30, 0x4e, 0x81, 0x9f, 0x2a, 0x01, 0x27, 0xa8, 0x4d, 0xe0, 0x27, 0x04, 0x0b, 0x11,
	0x1a, 0x8d, 0x77, 0x92, 0xa1, 0x8f, 0x54, 0xf6, 0x38, 0xe8, 0x4d, 0x0e, 0xfd, 0x6d, 0xa1, 0x1a,
	0x0b, 0x3d, 0xd4, 0x2f, 0xa2, 0xa7, 0x93, 0x0e, 0x0b, 0x27, 0xf8, 0x10, 0x8b, 0x61, 0xf5, 0x4e,
	0xca, 0x22, 0x52, 0xf3, 0x9f, 0x15, 0x0b, 0xbf, 0x99, 0x06, 0x2c, 0x86, 0xb5, 0x39, 0x29, 0x8b,
	0x48, 0x45, 0x7f, 0x56, 0x2c, 0x06, 0x1d, 0xb5, 0xff, 0x3d, 0x82, 0x8d, 0x16, 0xeb, 0xc5, 0x61,
	0xde, 0x0f, 0x3c, 0x03, 0x9a, 0xf6, 0x6d, 0xd2, 0x44, 0xef, 0xd5, 0x5c, 0x9b, 0x0e, 0xb3, 0x9f,
	0x0c, 0x25, 0xa6, 0x77, 0xc4, 0x0e, 0xa1, 0xfc, 0xae, 0x11, 0x9d, 0x25, 0x45, 0x53, 0x8d, 0xb1,
	0x7f, 0x60, 0xed, 0xf8, 0x53, 0x7f, 0x22, 0xf4, 0x55, 0x26, 0x53, 0x39, 0xfc, 0x36, 0xb3, 0x76,
	0xc7, 0xf1, 0x79, 0xc0, 0x71, 0x54, 0x7c, 0x1c, 0xf7, 0x1d, 0xa3, 0xf3, 0x49, 0xee, 0xff, 0xf6,
	0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xfb, 0xe2, 0x2e, 0xe6, 0x1f, 0x13, 0x00, 0x00,
}
