// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1/workflow_templates.proto

package dataproc // import "google.golang.org/genproto/googleapis/cloud/dataproc/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The operation state.
type WorkflowMetadata_State int32

const (
	// Unused.
	WorkflowMetadata_UNKNOWN WorkflowMetadata_State = 0
	// The operation has been created.
	WorkflowMetadata_PENDING WorkflowMetadata_State = 1
	// The operation is running.
	WorkflowMetadata_RUNNING WorkflowMetadata_State = 2
	// The operation is done; either cancelled or completed.
	WorkflowMetadata_DONE WorkflowMetadata_State = 3
)

var WorkflowMetadata_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
}
var WorkflowMetadata_State_value = map[string]int32{
	"UNKNOWN": 0,
	"PENDING": 1,
	"RUNNING": 2,
	"DONE":    3,
}

func (x WorkflowMetadata_State) String() string {
	return proto.EnumName(WorkflowMetadata_State_name, int32(x))
}
func (WorkflowMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{9, 0}
}

// The workflow node state.
type WorkflowNode_NodeState int32

const (
	// State is unspecified.
	WorkflowNode_NODE_STATE_UNSPECIFIED WorkflowNode_NodeState = 0
	// The node is awaiting prerequisite node to finish.
	WorkflowNode_BLOCKED WorkflowNode_NodeState = 1
	// The node is runnable but not running.
	WorkflowNode_RUNNABLE WorkflowNode_NodeState = 2
	// The node is running.
	WorkflowNode_RUNNING WorkflowNode_NodeState = 3
	// The node completed successfully.
	WorkflowNode_COMPLETED WorkflowNode_NodeState = 4
	// The node failed. A node can be marked FAILED because
	// its ancestor or peer failed.
	WorkflowNode_FAILED WorkflowNode_NodeState = 5
)

var WorkflowNode_NodeState_name = map[int32]string{
	0: "NODE_STATE_UNSPECIFIED",
	1: "BLOCKED",
	2: "RUNNABLE",
	3: "RUNNING",
	4: "COMPLETED",
	5: "FAILED",
}
var WorkflowNode_NodeState_value = map[string]int32{
	"NODE_STATE_UNSPECIFIED": 0,
	"BLOCKED":                1,
	"RUNNABLE":               2,
	"RUNNING":                3,
	"COMPLETED":              4,
	"FAILED":                 5,
}

func (x WorkflowNode_NodeState) String() string {
	return proto.EnumName(WorkflowNode_NodeState_name, int32(x))
}
func (WorkflowNode_NodeState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{12, 0}
}

// A Cloud Dataproc workflow template resource.
type WorkflowTemplate struct {
	// Required. The template id.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). Cannot begin or end with underscore
	// or hyphen. Must consist of between 3 and 50 characters.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The "resource name" of the template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Used to perform a consistent read-modify-write.
	//
	// This field should be left blank for a `CreateWorkflowTemplate` request. It
	// is required for an `UpdateWorkflowTemplate` request, and must match the
	// current server version. A typical update template flow would fetch the
	// current template with a `GetWorkflowTemplate` request, which will return
	// the current template with the `version` field filled in with the
	// current server version. The user updates other fields in the template,
	// then returns it as part of the `UpdateWorkflowTemplate` request.
	Version int32 `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The time template was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time template was last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The labels to associate with this template. These labels
	// will be propagated to all jobs and clusters created by the workflow
	// instance.
	//
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	//
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	//
	// No more than 32 labels can be associated with a template.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. WorkflowTemplate scheduling information.
	Placement *WorkflowTemplatePlacement `protobuf:"bytes,7,opt,name=placement,proto3" json:"placement,omitempty"`
	// Required. The Directed Acyclic Graph of Jobs to submit.
	Jobs []*OrderedJob `protobuf:"bytes,8,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Optional. Template parameters whose values are substituted into the
	// template. Values for parameters must be provided when the template is
	// instantiated.
	Parameters           []*TemplateParameter `protobuf:"bytes,9,rep,name=parameters,proto3" json:"parameters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *WorkflowTemplate) Reset()         { *m = WorkflowTemplate{} }
func (m *WorkflowTemplate) String() string { return proto.CompactTextString(m) }
func (*WorkflowTemplate) ProtoMessage()    {}
func (*WorkflowTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{0}
}
func (m *WorkflowTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowTemplate.Unmarshal(m, b)
}
func (m *WorkflowTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowTemplate.Marshal(b, m, deterministic)
}
func (dst *WorkflowTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowTemplate.Merge(dst, src)
}
func (m *WorkflowTemplate) XXX_Size() int {
	return xxx_messageInfo_WorkflowTemplate.Size(m)
}
func (m *WorkflowTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowTemplate proto.InternalMessageInfo

func (m *WorkflowTemplate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *WorkflowTemplate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WorkflowTemplate) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *WorkflowTemplate) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *WorkflowTemplate) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *WorkflowTemplate) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *WorkflowTemplate) GetPlacement() *WorkflowTemplatePlacement {
	if m != nil {
		return m.Placement
	}
	return nil
}

func (m *WorkflowTemplate) GetJobs() []*OrderedJob {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *WorkflowTemplate) GetParameters() []*TemplateParameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

// Specifies workflow execution target.
//
// Either `managed_cluster` or `cluster_selector` is required.
type WorkflowTemplatePlacement struct {
	// Required. Specifies where workflow executes; either on a managed
	// cluster or an existing cluster chosen by labels.
	//
	// Types that are valid to be assigned to Placement:
	//	*WorkflowTemplatePlacement_ManagedCluster
	//	*WorkflowTemplatePlacement_ClusterSelector
	Placement            isWorkflowTemplatePlacement_Placement `protobuf_oneof:"placement"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *WorkflowTemplatePlacement) Reset()         { *m = WorkflowTemplatePlacement{} }
func (m *WorkflowTemplatePlacement) String() string { return proto.CompactTextString(m) }
func (*WorkflowTemplatePlacement) ProtoMessage()    {}
func (*WorkflowTemplatePlacement) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{1}
}
func (m *WorkflowTemplatePlacement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowTemplatePlacement.Unmarshal(m, b)
}
func (m *WorkflowTemplatePlacement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowTemplatePlacement.Marshal(b, m, deterministic)
}
func (dst *WorkflowTemplatePlacement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowTemplatePlacement.Merge(dst, src)
}
func (m *WorkflowTemplatePlacement) XXX_Size() int {
	return xxx_messageInfo_WorkflowTemplatePlacement.Size(m)
}
func (m *WorkflowTemplatePlacement) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowTemplatePlacement.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowTemplatePlacement proto.InternalMessageInfo

type isWorkflowTemplatePlacement_Placement interface {
	isWorkflowTemplatePlacement_Placement()
}

type WorkflowTemplatePlacement_ManagedCluster struct {
	ManagedCluster *ManagedCluster `protobuf:"bytes,1,opt,name=managed_cluster,json=managedCluster,proto3,oneof"`
}

type WorkflowTemplatePlacement_ClusterSelector struct {
	ClusterSelector *ClusterSelector `protobuf:"bytes,2,opt,name=cluster_selector,json=clusterSelector,proto3,oneof"`
}

func (*WorkflowTemplatePlacement_ManagedCluster) isWorkflowTemplatePlacement_Placement() {}

func (*WorkflowTemplatePlacement_ClusterSelector) isWorkflowTemplatePlacement_Placement() {}

func (m *WorkflowTemplatePlacement) GetPlacement() isWorkflowTemplatePlacement_Placement {
	if m != nil {
		return m.Placement
	}
	return nil
}

func (m *WorkflowTemplatePlacement) GetManagedCluster() *ManagedCluster {
	if x, ok := m.GetPlacement().(*WorkflowTemplatePlacement_ManagedCluster); ok {
		return x.ManagedCluster
	}
	return nil
}

func (m *WorkflowTemplatePlacement) GetClusterSelector() *ClusterSelector {
	if x, ok := m.GetPlacement().(*WorkflowTemplatePlacement_ClusterSelector); ok {
		return x.ClusterSelector
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*WorkflowTemplatePlacement) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _WorkflowTemplatePlacement_OneofMarshaler, _WorkflowTemplatePlacement_OneofUnmarshaler, _WorkflowTemplatePlacement_OneofSizer, []interface{}{
		(*WorkflowTemplatePlacement_ManagedCluster)(nil),
		(*WorkflowTemplatePlacement_ClusterSelector)(nil),
	}
}

func _WorkflowTemplatePlacement_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*WorkflowTemplatePlacement)
	// placement
	switch x := m.Placement.(type) {
	case *WorkflowTemplatePlacement_ManagedCluster:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManagedCluster); err != nil {
			return err
		}
	case *WorkflowTemplatePlacement_ClusterSelector:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterSelector); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("WorkflowTemplatePlacement.Placement has unexpected type %T", x)
	}
	return nil
}

func _WorkflowTemplatePlacement_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*WorkflowTemplatePlacement)
	switch tag {
	case 1: // placement.managed_cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ManagedCluster)
		err := b.DecodeMessage(msg)
		m.Placement = &WorkflowTemplatePlacement_ManagedCluster{msg}
		return true, err
	case 2: // placement.cluster_selector
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClusterSelector)
		err := b.DecodeMessage(msg)
		m.Placement = &WorkflowTemplatePlacement_ClusterSelector{msg}
		return true, err
	default:
		return false, nil
	}
}

func _WorkflowTemplatePlacement_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*WorkflowTemplatePlacement)
	// placement
	switch x := m.Placement.(type) {
	case *WorkflowTemplatePlacement_ManagedCluster:
		s := proto.Size(x.ManagedCluster)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *WorkflowTemplatePlacement_ClusterSelector:
		s := proto.Size(x.ClusterSelector)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Cluster that is managed by the workflow.
type ManagedCluster struct {
	// Required. The cluster name prefix. A unique cluster name will be formed by
	// appending a random suffix.
	//
	// The name must contain only lower-case letters (a-z), numbers (0-9),
	// and hyphens (-). Must begin with a letter. Cannot begin or end with
	// hyphen. Must consist of between 2 and 35 characters.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Required. The cluster configuration.
	Config *ClusterConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	// Optional. The labels to associate with this cluster.
	//
	// Label keys must be between 1 and 63 characters long, and must conform to
	// the following PCRE regular expression:
	// [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
	//
	// Label values must be between 1 and 63 characters long, and must conform to
	// the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
	//
	// No more than 32 labels can be associated with a given cluster.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ManagedCluster) Reset()         { *m = ManagedCluster{} }
func (m *ManagedCluster) String() string { return proto.CompactTextString(m) }
func (*ManagedCluster) ProtoMessage()    {}
func (*ManagedCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{2}
}
func (m *ManagedCluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManagedCluster.Unmarshal(m, b)
}
func (m *ManagedCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManagedCluster.Marshal(b, m, deterministic)
}
func (dst *ManagedCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedCluster.Merge(dst, src)
}
func (m *ManagedCluster) XXX_Size() int {
	return xxx_messageInfo_ManagedCluster.Size(m)
}
func (m *ManagedCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedCluster.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedCluster proto.InternalMessageInfo

func (m *ManagedCluster) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ManagedCluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ManagedCluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// A selector that chooses target cluster for jobs based on metadata.
type ClusterSelector struct {
	// Optional. The zone where workflow process executes. This parameter does not
	// affect the selection of the cluster.
	//
	// If unspecified, the zone of the first cluster matching the selector
	// is used.
	Zone string `protobuf:"bytes,1,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. The cluster labels. Cluster must have all labels
	// to match.
	ClusterLabels        map[string]string `protobuf:"bytes,2,rep,name=cluster_labels,json=clusterLabels,proto3" json:"cluster_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ClusterSelector) Reset()         { *m = ClusterSelector{} }
func (m *ClusterSelector) String() string { return proto.CompactTextString(m) }
func (*ClusterSelector) ProtoMessage()    {}
func (*ClusterSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{3}
}
func (m *ClusterSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterSelector.Unmarshal(m, b)
}
func (m *ClusterSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterSelector.Marshal(b, m, deterministic)
}
func (dst *ClusterSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterSelector.Merge(dst, src)
}
func (m *ClusterSelector) XXX_Size() int {
	return xxx_messageInfo_ClusterSelector.Size(m)
}
func (m *ClusterSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterSelector.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterSelector proto.InternalMessageInfo

func (m *ClusterSelector) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ClusterSelector) GetClusterLabels() map[string]string {
	if m != nil {
		return m.ClusterLabels
	}
	return nil
}

// A job executed by the workflow.
type OrderedJob struct {
	// Required. The step id. The id must be unique among all jobs
	// within the template.
	//
	// The step id is used as prefix for job id, as job
	// `goog-dataproc-workflow-step-id` label, and in
	// [prerequisiteStepIds][google.cloud.dataproc.v1.OrderedJob.prerequisite_step_ids]
	// field from other steps.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). Cannot begin or end with underscore
	// or hyphen. Must consist of between 3 and 50 characters.
	StepId string `protobuf:"bytes,1,opt,name=step_id,json=stepId,proto3" json:"step_id,omitempty"`
	// Required. The job definition.
	//
	// Types that are valid to be assigned to JobType:
	//	*OrderedJob_HadoopJob
	//	*OrderedJob_SparkJob
	//	*OrderedJob_PysparkJob
	//	*OrderedJob_HiveJob
	//	*OrderedJob_PigJob
	//	*OrderedJob_SparkSqlJob
	JobType isOrderedJob_JobType `protobuf_oneof:"job_type"`
	// Optional. The labels to associate with this job.
	//
	// Label keys must be between 1 and 63 characters long, and must conform to
	// the following regular expression:
	// [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
	//
	// Label values must be between 1 and 63 characters long, and must conform to
	// the following regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
	//
	// No more than 32 labels can be associated with a given job.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Job scheduling configuration.
	Scheduling *JobScheduling `protobuf:"bytes,9,opt,name=scheduling,proto3" json:"scheduling,omitempty"`
	// Optional. The optional list of prerequisite job step_ids.
	// If not specified, the job will start at the beginning of workflow.
	PrerequisiteStepIds  []string `protobuf:"bytes,10,rep,name=prerequisite_step_ids,json=prerequisiteStepIds,proto3" json:"prerequisite_step_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OrderedJob) Reset()         { *m = OrderedJob{} }
func (m *OrderedJob) String() string { return proto.CompactTextString(m) }
func (*OrderedJob) ProtoMessage()    {}
func (*OrderedJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{4}
}
func (m *OrderedJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OrderedJob.Unmarshal(m, b)
}
func (m *OrderedJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OrderedJob.Marshal(b, m, deterministic)
}
func (dst *OrderedJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrderedJob.Merge(dst, src)
}
func (m *OrderedJob) XXX_Size() int {
	return xxx_messageInfo_OrderedJob.Size(m)
}
func (m *OrderedJob) XXX_DiscardUnknown() {
	xxx_messageInfo_OrderedJob.DiscardUnknown(m)
}

var xxx_messageInfo_OrderedJob proto.InternalMessageInfo

func (m *OrderedJob) GetStepId() string {
	if m != nil {
		return m.StepId
	}
	return ""
}

type isOrderedJob_JobType interface {
	isOrderedJob_JobType()
}

type OrderedJob_HadoopJob struct {
	HadoopJob *HadoopJob `protobuf:"bytes,2,opt,name=hadoop_job,json=hadoopJob,proto3,oneof"`
}

type OrderedJob_SparkJob struct {
	SparkJob *SparkJob `protobuf:"bytes,3,opt,name=spark_job,json=sparkJob,proto3,oneof"`
}

type OrderedJob_PysparkJob struct {
	PysparkJob *PySparkJob `protobuf:"bytes,4,opt,name=pyspark_job,json=pysparkJob,proto3,oneof"`
}

type OrderedJob_HiveJob struct {
	HiveJob *HiveJob `protobuf:"bytes,5,opt,name=hive_job,json=hiveJob,proto3,oneof"`
}

type OrderedJob_PigJob struct {
	PigJob *PigJob `protobuf:"bytes,6,opt,name=pig_job,json=pigJob,proto3,oneof"`
}

type OrderedJob_SparkSqlJob struct {
	SparkSqlJob *SparkSqlJob `protobuf:"bytes,7,opt,name=spark_sql_job,json=sparkSqlJob,proto3,oneof"`
}

func (*OrderedJob_HadoopJob) isOrderedJob_JobType() {}

func (*OrderedJob_SparkJob) isOrderedJob_JobType() {}

func (*OrderedJob_PysparkJob) isOrderedJob_JobType() {}

func (*OrderedJob_HiveJob) isOrderedJob_JobType() {}

func (*OrderedJob_PigJob) isOrderedJob_JobType() {}

func (*OrderedJob_SparkSqlJob) isOrderedJob_JobType() {}

func (m *OrderedJob) GetJobType() isOrderedJob_JobType {
	if m != nil {
		return m.JobType
	}
	return nil
}

func (m *OrderedJob) GetHadoopJob() *HadoopJob {
	if x, ok := m.GetJobType().(*OrderedJob_HadoopJob); ok {
		return x.HadoopJob
	}
	return nil
}

func (m *OrderedJob) GetSparkJob() *SparkJob {
	if x, ok := m.GetJobType().(*OrderedJob_SparkJob); ok {
		return x.SparkJob
	}
	return nil
}

func (m *OrderedJob) GetPysparkJob() *PySparkJob {
	if x, ok := m.GetJobType().(*OrderedJob_PysparkJob); ok {
		return x.PysparkJob
	}
	return nil
}

func (m *OrderedJob) GetHiveJob() *HiveJob {
	if x, ok := m.GetJobType().(*OrderedJob_HiveJob); ok {
		return x.HiveJob
	}
	return nil
}

func (m *OrderedJob) GetPigJob() *PigJob {
	if x, ok := m.GetJobType().(*OrderedJob_PigJob); ok {
		return x.PigJob
	}
	return nil
}

func (m *OrderedJob) GetSparkSqlJob() *SparkSqlJob {
	if x, ok := m.GetJobType().(*OrderedJob_SparkSqlJob); ok {
		return x.SparkSqlJob
	}
	return nil
}

func (m *OrderedJob) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *OrderedJob) GetScheduling() *JobScheduling {
	if m != nil {
		return m.Scheduling
	}
	return nil
}

func (m *OrderedJob) GetPrerequisiteStepIds() []string {
	if m != nil {
		return m.PrerequisiteStepIds
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OrderedJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OrderedJob_OneofMarshaler, _OrderedJob_OneofUnmarshaler, _OrderedJob_OneofSizer, []interface{}{
		(*OrderedJob_HadoopJob)(nil),
		(*OrderedJob_SparkJob)(nil),
		(*OrderedJob_PysparkJob)(nil),
		(*OrderedJob_HiveJob)(nil),
		(*OrderedJob_PigJob)(nil),
		(*OrderedJob_SparkSqlJob)(nil),
	}
}

func _OrderedJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OrderedJob)
	// job_type
	switch x := m.JobType.(type) {
	case *OrderedJob_HadoopJob:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HadoopJob); err != nil {
			return err
		}
	case *OrderedJob_SparkJob:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkJob); err != nil {
			return err
		}
	case *OrderedJob_PysparkJob:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PysparkJob); err != nil {
			return err
		}
	case *OrderedJob_HiveJob:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HiveJob); err != nil {
			return err
		}
	case *OrderedJob_PigJob:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PigJob); err != nil {
			return err
		}
	case *OrderedJob_SparkSqlJob:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkSqlJob); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("OrderedJob.JobType has unexpected type %T", x)
	}
	return nil
}

func _OrderedJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OrderedJob)
	switch tag {
	case 2: // job_type.hadoop_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HadoopJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_HadoopJob{msg}
		return true, err
	case 3: // job_type.spark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_SparkJob{msg}
		return true, err
	case 4: // job_type.pyspark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PySparkJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_PysparkJob{msg}
		return true, err
	case 5: // job_type.hive_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HiveJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_HiveJob{msg}
		return true, err
	case 6: // job_type.pig_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PigJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_PigJob{msg}
		return true, err
	case 7: // job_type.spark_sql_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkSqlJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_SparkSqlJob{msg}
		return true, err
	default:
		return false, nil
	}
}

func _OrderedJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OrderedJob)
	// job_type
	switch x := m.JobType.(type) {
	case *OrderedJob_HadoopJob:
		s := proto.Size(x.HadoopJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_SparkJob:
		s := proto.Size(x.SparkJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_PysparkJob:
		s := proto.Size(x.PysparkJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_HiveJob:
		s := proto.Size(x.HiveJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_PigJob:
		s := proto.Size(x.PigJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_SparkSqlJob:
		s := proto.Size(x.SparkSqlJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A configurable parameter that replaces one or more fields in the template.
// Parameterizable fields:
// - Labels
// - File uris
// - Job properties
// - Job arguments
// - Script variables
// - Main class (in HadoopJob and SparkJob)
// - Zone (in ClusterSelector)
type TemplateParameter struct {
	// Required.  Parameter name.
	// The parameter name is used as the key, and paired with the
	// parameter value, which are passed to the template when the template
	// is instantiated.
	// The name must contain only capital letters (A-Z), numbers (0-9), and
	// underscores (_), and must not start with a number. The maximum length is
	// 40 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Paths to all fields that the parameter replaces.
	// A field is allowed to appear in at most one parameter's list of field
	// paths.
	//
	// A field path is similar in syntax to a
	// [google.protobuf.FieldMask][google.protobuf.FieldMask]. For example, a
	// field path that references the zone field of a workflow template's cluster
	// selector would be specified as `placement.clusterSelector.zone`.
	//
	// Also, field paths can reference fields using the following syntax:
	//
	// * Values in maps can be referenced by key:
	//     * labels['key']
	//     * placement.clusterSelector.clusterLabels['key']
	//     * placement.managedCluster.labels['key']
	//     * placement.clusterSelector.clusterLabels['key']
	//     * jobs['step-id'].labels['key']
	//
	// * Jobs in the jobs list can be referenced by step-id:
	//     * jobs['step-id'].hadoopJob.mainJarFileUri
	//     * jobs['step-id'].hiveJob.queryFileUri
	//     * jobs['step-id'].pySparkJob.mainPythonFileUri
	//     * jobs['step-id'].hadoopJob.jarFileUris[0]
	//     * jobs['step-id'].hadoopJob.archiveUris[0]
	//     * jobs['step-id'].hadoopJob.fileUris[0]
	//     * jobs['step-id'].pySparkJob.pythonFileUris[0]
	//
	// * Items in repeated fields can be referenced by a zero-based index:
	//     * jobs['step-id'].sparkJob.args[0]
	//
	// * Other examples:
	//     * jobs['step-id'].hadoopJob.properties['key']
	//     * jobs['step-id'].hadoopJob.args[0]
	//     * jobs['step-id'].hiveJob.scriptVariables['key']
	//     * jobs['step-id'].hadoopJob.mainJarFileUri
	//     * placement.clusterSelector.zone
	//
	// It may not be possible to parameterize maps and repeated fields in their
	// entirety since only individual map values and individual items in repeated
	// fields can be referenced. For example, the following field paths are
	// invalid:
	//
	// - placement.clusterSelector.clusterLabels
	// - jobs['step-id'].sparkJob.args
	Fields []string `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
	// Optional. Brief description of the parameter.
	// Must not exceed 1024 characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Validation rules to be applied to this parameter's value.
	Validation           *ParameterValidation `protobuf:"bytes,4,opt,name=validation,proto3" json:"validation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TemplateParameter) Reset()         { *m = TemplateParameter{} }
func (m *TemplateParameter) String() string { return proto.CompactTextString(m) }
func (*TemplateParameter) ProtoMessage()    {}
func (*TemplateParameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{5}
}
func (m *TemplateParameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TemplateParameter.Unmarshal(m, b)
}
func (m *TemplateParameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TemplateParameter.Marshal(b, m, deterministic)
}
func (dst *TemplateParameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TemplateParameter.Merge(dst, src)
}
func (m *TemplateParameter) XXX_Size() int {
	return xxx_messageInfo_TemplateParameter.Size(m)
}
func (m *TemplateParameter) XXX_DiscardUnknown() {
	xxx_messageInfo_TemplateParameter.DiscardUnknown(m)
}

var xxx_messageInfo_TemplateParameter proto.InternalMessageInfo

func (m *TemplateParameter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TemplateParameter) GetFields() []string {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *TemplateParameter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *TemplateParameter) GetValidation() *ParameterValidation {
	if m != nil {
		return m.Validation
	}
	return nil
}

// Configuration for parameter validation.
type ParameterValidation struct {
	// Required. The type of validation to be performed.
	//
	// Types that are valid to be assigned to ValidationType:
	//	*ParameterValidation_Regex
	//	*ParameterValidation_Values
	ValidationType       isParameterValidation_ValidationType `protobuf_oneof:"validation_type"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ParameterValidation) Reset()         { *m = ParameterValidation{} }
func (m *ParameterValidation) String() string { return proto.CompactTextString(m) }
func (*ParameterValidation) ProtoMessage()    {}
func (*ParameterValidation) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{6}
}
func (m *ParameterValidation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParameterValidation.Unmarshal(m, b)
}
func (m *ParameterValidation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParameterValidation.Marshal(b, m, deterministic)
}
func (dst *ParameterValidation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParameterValidation.Merge(dst, src)
}
func (m *ParameterValidation) XXX_Size() int {
	return xxx_messageInfo_ParameterValidation.Size(m)
}
func (m *ParameterValidation) XXX_DiscardUnknown() {
	xxx_messageInfo_ParameterValidation.DiscardUnknown(m)
}

var xxx_messageInfo_ParameterValidation proto.InternalMessageInfo

type isParameterValidation_ValidationType interface {
	isParameterValidation_ValidationType()
}

type ParameterValidation_Regex struct {
	Regex *RegexValidation `protobuf:"bytes,1,opt,name=regex,proto3,oneof"`
}

type ParameterValidation_Values struct {
	Values *ValueValidation `protobuf:"bytes,2,opt,name=values,proto3,oneof"`
}

func (*ParameterValidation_Regex) isParameterValidation_ValidationType() {}

func (*ParameterValidation_Values) isParameterValidation_ValidationType() {}

func (m *ParameterValidation) GetValidationType() isParameterValidation_ValidationType {
	if m != nil {
		return m.ValidationType
	}
	return nil
}

func (m *ParameterValidation) GetRegex() *RegexValidation {
	if x, ok := m.GetValidationType().(*ParameterValidation_Regex); ok {
		return x.Regex
	}
	return nil
}

func (m *ParameterValidation) GetValues() *ValueValidation {
	if x, ok := m.GetValidationType().(*ParameterValidation_Values); ok {
		return x.Values
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ParameterValidation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ParameterValidation_OneofMarshaler, _ParameterValidation_OneofUnmarshaler, _ParameterValidation_OneofSizer, []interface{}{
		(*ParameterValidation_Regex)(nil),
		(*ParameterValidation_Values)(nil),
	}
}

func _ParameterValidation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ParameterValidation)
	// validation_type
	switch x := m.ValidationType.(type) {
	case *ParameterValidation_Regex:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Regex); err != nil {
			return err
		}
	case *ParameterValidation_Values:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Values); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ParameterValidation.ValidationType has unexpected type %T", x)
	}
	return nil
}

func _ParameterValidation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ParameterValidation)
	switch tag {
	case 1: // validation_type.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RegexValidation)
		err := b.DecodeMessage(msg)
		m.ValidationType = &ParameterValidation_Regex{msg}
		return true, err
	case 2: // validation_type.values
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ValueValidation)
		err := b.DecodeMessage(msg)
		m.ValidationType = &ParameterValidation_Values{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ParameterValidation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ParameterValidation)
	// validation_type
	switch x := m.ValidationType.(type) {
	case *ParameterValidation_Regex:
		s := proto.Size(x.Regex)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ParameterValidation_Values:
		s := proto.Size(x.Values)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Validation based on regular expressions.
type RegexValidation struct {
	// Required. RE2 regular expressions used to validate the parameter's value.
	// The value must match the regex in its entirety (substring
	// matches are not sufficient).
	Regexes              []string `protobuf:"bytes,1,rep,name=regexes,proto3" json:"regexes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegexValidation) Reset()         { *m = RegexValidation{} }
func (m *RegexValidation) String() string { return proto.CompactTextString(m) }
func (*RegexValidation) ProtoMessage()    {}
func (*RegexValidation) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{7}
}
func (m *RegexValidation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegexValidation.Unmarshal(m, b)
}
func (m *RegexValidation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegexValidation.Marshal(b, m, deterministic)
}
func (dst *RegexValidation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegexValidation.Merge(dst, src)
}
func (m *RegexValidation) XXX_Size() int {
	return xxx_messageInfo_RegexValidation.Size(m)
}
func (m *RegexValidation) XXX_DiscardUnknown() {
	xxx_messageInfo_RegexValidation.DiscardUnknown(m)
}

var xxx_messageInfo_RegexValidation proto.InternalMessageInfo

func (m *RegexValidation) GetRegexes() []string {
	if m != nil {
		return m.Regexes
	}
	return nil
}

// Validation based on a list of allowed values.
type ValueValidation struct {
	// Required. List of allowed values for the parameter.
	Values               []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ValueValidation) Reset()         { *m = ValueValidation{} }
func (m *ValueValidation) String() string { return proto.CompactTextString(m) }
func (*ValueValidation) ProtoMessage()    {}
func (*ValueValidation) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{8}
}
func (m *ValueValidation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValueValidation.Unmarshal(m, b)
}
func (m *ValueValidation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValueValidation.Marshal(b, m, deterministic)
}
func (dst *ValueValidation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueValidation.Merge(dst, src)
}
func (m *ValueValidation) XXX_Size() int {
	return xxx_messageInfo_ValueValidation.Size(m)
}
func (m *ValueValidation) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueValidation.DiscardUnknown(m)
}

var xxx_messageInfo_ValueValidation proto.InternalMessageInfo

func (m *ValueValidation) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// A Cloud Dataproc workflow template resource.
type WorkflowMetadata struct {
	// Output only. The "resource name" of the template.
	Template string `protobuf:"bytes,1,opt,name=template,proto3" json:"template,omitempty"`
	// Output only. The version of template at the time of
	// workflow instantiation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The create cluster operation metadata.
	CreateCluster *ClusterOperation `protobuf:"bytes,3,opt,name=create_cluster,json=createCluster,proto3" json:"create_cluster,omitempty"`
	// Output only. The workflow graph.
	Graph *WorkflowGraph `protobuf:"bytes,4,opt,name=graph,proto3" json:"graph,omitempty"`
	// Output only. The delete cluster operation metadata.
	DeleteCluster *ClusterOperation `protobuf:"bytes,5,opt,name=delete_cluster,json=deleteCluster,proto3" json:"delete_cluster,omitempty"`
	// Output only. The workflow state.
	State WorkflowMetadata_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.dataproc.v1.WorkflowMetadata_State" json:"state,omitempty"`
	// Output only. The name of the target cluster.
	ClusterName string `protobuf:"bytes,7,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Map from parameter names to values that were used for those parameters.
	Parameters map[string]string `protobuf:"bytes,8,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Workflow start time.
	StartTime *timestamp.Timestamp `protobuf:"bytes,9,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Workflow end time.
	EndTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The UUID of target cluster.
	ClusterUuid          string   `protobuf:"bytes,11,opt,name=cluster_uuid,json=clusterUuid,proto3" json:"cluster_uuid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WorkflowMetadata) Reset()         { *m = WorkflowMetadata{} }
func (m *WorkflowMetadata) String() string { return proto.CompactTextString(m) }
func (*WorkflowMetadata) ProtoMessage()    {}
func (*WorkflowMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{9}
}
func (m *WorkflowMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowMetadata.Unmarshal(m, b)
}
func (m *WorkflowMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowMetadata.Marshal(b, m, deterministic)
}
func (dst *WorkflowMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowMetadata.Merge(dst, src)
}
func (m *WorkflowMetadata) XXX_Size() int {
	return xxx_messageInfo_WorkflowMetadata.Size(m)
}
func (m *WorkflowMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowMetadata proto.InternalMessageInfo

func (m *WorkflowMetadata) GetTemplate() string {
	if m != nil {
		return m.Template
	}
	return ""
}

func (m *WorkflowMetadata) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *WorkflowMetadata) GetCreateCluster() *ClusterOperation {
	if m != nil {
		return m.CreateCluster
	}
	return nil
}

func (m *WorkflowMetadata) GetGraph() *WorkflowGraph {
	if m != nil {
		return m.Graph
	}
	return nil
}

func (m *WorkflowMetadata) GetDeleteCluster() *ClusterOperation {
	if m != nil {
		return m.DeleteCluster
	}
	return nil
}

func (m *WorkflowMetadata) GetState() WorkflowMetadata_State {
	if m != nil {
		return m.State
	}
	return WorkflowMetadata_UNKNOWN
}

func (m *WorkflowMetadata) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *WorkflowMetadata) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *WorkflowMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WorkflowMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WorkflowMetadata) GetClusterUuid() string {
	if m != nil {
		return m.ClusterUuid
	}
	return ""
}

// The cluster operation triggered by a workflow.
type ClusterOperation struct {
	// Output only. The id of the cluster operation.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// Output only. Error, if operation failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Indicates the operation is done.
	Done                 bool     `protobuf:"varint,3,opt,name=done,proto3" json:"done,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterOperation) Reset()         { *m = ClusterOperation{} }
func (m *ClusterOperation) String() string { return proto.CompactTextString(m) }
func (*ClusterOperation) ProtoMessage()    {}
func (*ClusterOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{10}
}
func (m *ClusterOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterOperation.Unmarshal(m, b)
}
func (m *ClusterOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterOperation.Marshal(b, m, deterministic)
}
func (dst *ClusterOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterOperation.Merge(dst, src)
}
func (m *ClusterOperation) XXX_Size() int {
	return xxx_messageInfo_ClusterOperation.Size(m)
}
func (m *ClusterOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterOperation.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterOperation proto.InternalMessageInfo

func (m *ClusterOperation) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *ClusterOperation) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *ClusterOperation) GetDone() bool {
	if m != nil {
		return m.Done
	}
	return false
}

// The workflow graph.
type WorkflowGraph struct {
	// Output only. The workflow nodes.
	Nodes                []*WorkflowNode `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *WorkflowGraph) Reset()         { *m = WorkflowGraph{} }
func (m *WorkflowGraph) String() string { return proto.CompactTextString(m) }
func (*WorkflowGraph) ProtoMessage()    {}
func (*WorkflowGraph) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{11}
}
func (m *WorkflowGraph) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowGraph.Unmarshal(m, b)
}
func (m *WorkflowGraph) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowGraph.Marshal(b, m, deterministic)
}
func (dst *WorkflowGraph) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowGraph.Merge(dst, src)
}
func (m *WorkflowGraph) XXX_Size() int {
	return xxx_messageInfo_WorkflowGraph.Size(m)
}
func (m *WorkflowGraph) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowGraph.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowGraph proto.InternalMessageInfo

func (m *WorkflowGraph) GetNodes() []*WorkflowNode {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// The workflow node.
type WorkflowNode struct {
	// Output only. The name of the node.
	StepId string `protobuf:"bytes,1,opt,name=step_id,json=stepId,proto3" json:"step_id,omitempty"`
	// Output only. Node's prerequisite nodes.
	PrerequisiteStepIds []string `protobuf:"bytes,2,rep,name=prerequisite_step_ids,json=prerequisiteStepIds,proto3" json:"prerequisite_step_ids,omitempty"`
	// Output only. The job id; populated after the node enters RUNNING state.
	JobId string `protobuf:"bytes,3,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Output only. The node state.
	State WorkflowNode_NodeState `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.dataproc.v1.WorkflowNode_NodeState" json:"state,omitempty"`
	// Output only. The error detail.
	Error                string   `protobuf:"bytes,6,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WorkflowNode) Reset()         { *m = WorkflowNode{} }
func (m *WorkflowNode) String() string { return proto.CompactTextString(m) }
func (*WorkflowNode) ProtoMessage()    {}
func (*WorkflowNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{12}
}
func (m *WorkflowNode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowNode.Unmarshal(m, b)
}
func (m *WorkflowNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowNode.Marshal(b, m, deterministic)
}
func (dst *WorkflowNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowNode.Merge(dst, src)
}
func (m *WorkflowNode) XXX_Size() int {
	return xxx_messageInfo_WorkflowNode.Size(m)
}
func (m *WorkflowNode) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowNode.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowNode proto.InternalMessageInfo

func (m *WorkflowNode) GetStepId() string {
	if m != nil {
		return m.StepId
	}
	return ""
}

func (m *WorkflowNode) GetPrerequisiteStepIds() []string {
	if m != nil {
		return m.PrerequisiteStepIds
	}
	return nil
}

func (m *WorkflowNode) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *WorkflowNode) GetState() WorkflowNode_NodeState {
	if m != nil {
		return m.State
	}
	return WorkflowNode_NODE_STATE_UNSPECIFIED
}

func (m *WorkflowNode) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// A request to create a workflow template.
type CreateWorkflowTemplateRequest struct {
	// Required. The "resource name" of the region, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Dataproc workflow template to create.
	Template             *WorkflowTemplate `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateWorkflowTemplateRequest) Reset()         { *m = CreateWorkflowTemplateRequest{} }
func (m *CreateWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*CreateWorkflowTemplateRequest) ProtoMessage()    {}
func (*CreateWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{13}
}
func (m *CreateWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *CreateWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *CreateWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateWorkflowTemplateRequest.Merge(dst, src)
}
func (m *CreateWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_CreateWorkflowTemplateRequest.Size(m)
}
func (m *CreateWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateWorkflowTemplateRequest proto.InternalMessageInfo

func (m *CreateWorkflowTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateWorkflowTemplateRequest) GetTemplate() *WorkflowTemplate {
	if m != nil {
		return m.Template
	}
	return nil
}

// A request to fetch a workflow template.
type GetWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The version of workflow template to retrieve. Only previously
	// instatiated versions can be retrieved.
	//
	// If unspecified, retrieves the current version.
	Version              int32    `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetWorkflowTemplateRequest) Reset()         { *m = GetWorkflowTemplateRequest{} }
func (m *GetWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*GetWorkflowTemplateRequest) ProtoMessage()    {}
func (*GetWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{14}
}
func (m *GetWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *GetWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *GetWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkflowTemplateRequest.Merge(dst, src)
}
func (m *GetWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_GetWorkflowTemplateRequest.Size(m)
}
func (m *GetWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkflowTemplateRequest proto.InternalMessageInfo

func (m *GetWorkflowTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetWorkflowTemplateRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

// A request to instantiate a workflow template.
type InstantiateWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The version of workflow template to instantiate. If specified,
	// the workflow will be instantiated only if the current version of
	// the workflow template has the supplied version.
	//
	// This option cannot be used to instantiate a previous version of
	// workflow template.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. A tag that prevents multiple concurrent workflow
	// instances with the same tag from running. This mitigates risk of
	// concurrent instances started due to retries.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The tag must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Map from parameter names to values that should be used for those
	// parameters. Values may not exceed 100 characters.
	Parameters           map[string]string `protobuf:"bytes,6,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *InstantiateWorkflowTemplateRequest) Reset()         { *m = InstantiateWorkflowTemplateRequest{} }
func (m *InstantiateWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*InstantiateWorkflowTemplateRequest) ProtoMessage()    {}
func (*InstantiateWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{15}
}
func (m *InstantiateWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstantiateWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *InstantiateWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstantiateWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *InstantiateWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstantiateWorkflowTemplateRequest.Merge(dst, src)
}
func (m *InstantiateWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_InstantiateWorkflowTemplateRequest.Size(m)
}
func (m *InstantiateWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstantiateWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstantiateWorkflowTemplateRequest proto.InternalMessageInfo

func (m *InstantiateWorkflowTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstantiateWorkflowTemplateRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *InstantiateWorkflowTemplateRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *InstantiateWorkflowTemplateRequest) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

// A request to instantiate an inline workflow template.
type InstantiateInlineWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template region, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The workflow template to instantiate.
	Template *WorkflowTemplate `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	// Optional. A tag that prevents multiple concurrent workflow
	// instances with the same tag from running. This mitigates risk of
	// concurrent instances started due to retries.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The tag must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId            string   `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstantiateInlineWorkflowTemplateRequest) Reset() {
	*m = InstantiateInlineWorkflowTemplateRequest{}
}
func (m *InstantiateInlineWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*InstantiateInlineWorkflowTemplateRequest) ProtoMessage()    {}
func (*InstantiateInlineWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{16}
}
func (m *InstantiateInlineWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *InstantiateInlineWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *InstantiateInlineWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.Merge(dst, src)
}
func (m *InstantiateInlineWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.Size(m)
}
func (m *InstantiateInlineWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest proto.InternalMessageInfo

func (m *InstantiateInlineWorkflowTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *InstantiateInlineWorkflowTemplateRequest) GetTemplate() *WorkflowTemplate {
	if m != nil {
		return m.Template
	}
	return nil
}

func (m *InstantiateInlineWorkflowTemplateRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// A request to update a workflow template.
type UpdateWorkflowTemplateRequest struct {
	// Required. The updated workflow template.
	//
	// The `template.version` field must match the current version.
	Template             *WorkflowTemplate `protobuf:"bytes,1,opt,name=template,proto3" json:"template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateWorkflowTemplateRequest) Reset()         { *m = UpdateWorkflowTemplateRequest{} }
func (m *UpdateWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateWorkflowTemplateRequest) ProtoMessage()    {}
func (*UpdateWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{17}
}
func (m *UpdateWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *UpdateWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateWorkflowTemplateRequest.Merge(dst, src)
}
func (m *UpdateWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateWorkflowTemplateRequest.Size(m)
}
func (m *UpdateWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateWorkflowTemplateRequest proto.InternalMessageInfo

func (m *UpdateWorkflowTemplateRequest) GetTemplate() *WorkflowTemplate {
	if m != nil {
		return m.Template
	}
	return nil
}

// A request to list workflow templates in a project.
type ListWorkflowTemplatesRequest struct {
	// Required. The "resource name" of the region, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in each response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, returned by a previous call, to request the
	// next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListWorkflowTemplatesRequest) Reset()         { *m = ListWorkflowTemplatesRequest{} }
func (m *ListWorkflowTemplatesRequest) String() string { return proto.CompactTextString(m) }
func (*ListWorkflowTemplatesRequest) ProtoMessage()    {}
func (*ListWorkflowTemplatesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{18}
}
func (m *ListWorkflowTemplatesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListWorkflowTemplatesRequest.Unmarshal(m, b)
}
func (m *ListWorkflowTemplatesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListWorkflowTemplatesRequest.Marshal(b, m, deterministic)
}
func (dst *ListWorkflowTemplatesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWorkflowTemplatesRequest.Merge(dst, src)
}
func (m *ListWorkflowTemplatesRequest) XXX_Size() int {
	return xxx_messageInfo_ListWorkflowTemplatesRequest.Size(m)
}
func (m *ListWorkflowTemplatesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWorkflowTemplatesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListWorkflowTemplatesRequest proto.InternalMessageInfo

func (m *ListWorkflowTemplatesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListWorkflowTemplatesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListWorkflowTemplatesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response to a request to list workflow templates in a project.
type ListWorkflowTemplatesResponse struct {
	// Output only. WorkflowTemplates list.
	Templates []*WorkflowTemplate `protobuf:"bytes,1,rep,name=templates,proto3" json:"templates,omitempty"`
	// Output only. This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent <code>ListWorkflowTemplatesRequest</code>.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListWorkflowTemplatesResponse) Reset()         { *m = ListWorkflowTemplatesResponse{} }
func (m *ListWorkflowTemplatesResponse) String() string { return proto.CompactTextString(m) }
func (*ListWorkflowTemplatesResponse) ProtoMessage()    {}
func (*ListWorkflowTemplatesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{19}
}
func (m *ListWorkflowTemplatesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListWorkflowTemplatesResponse.Unmarshal(m, b)
}
func (m *ListWorkflowTemplatesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListWorkflowTemplatesResponse.Marshal(b, m, deterministic)
}
func (dst *ListWorkflowTemplatesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWorkflowTemplatesResponse.Merge(dst, src)
}
func (m *ListWorkflowTemplatesResponse) XXX_Size() int {
	return xxx_messageInfo_ListWorkflowTemplatesResponse.Size(m)
}
func (m *ListWorkflowTemplatesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWorkflowTemplatesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListWorkflowTemplatesResponse proto.InternalMessageInfo

func (m *ListWorkflowTemplatesResponse) GetTemplates() []*WorkflowTemplate {
	if m != nil {
		return m.Templates
	}
	return nil
}

func (m *ListWorkflowTemplatesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to delete a workflow template.
//
// Currently started workflows will remain running.
type DeleteWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The version of workflow template to delete. If specified,
	// will only delete the template if the current server version matches
	// specified version.
	Version              int32    `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteWorkflowTemplateRequest) Reset()         { *m = DeleteWorkflowTemplateRequest{} }
func (m *DeleteWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteWorkflowTemplateRequest) ProtoMessage()    {}
func (*DeleteWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_59ea55b2e6560827, []int{20}
}
func (m *DeleteWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *DeleteWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteWorkflowTemplateRequest.Merge(dst, src)
}
func (m *DeleteWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteWorkflowTemplateRequest.Size(m)
}
func (m *DeleteWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteWorkflowTemplateRequest proto.InternalMessageInfo

func (m *DeleteWorkflowTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteWorkflowTemplateRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func init() {
	proto.RegisterType((*WorkflowTemplate)(nil), "google.cloud.dataproc.v1.WorkflowTemplate")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1.WorkflowTemplate.LabelsEntry")
	proto.RegisterType((*WorkflowTemplatePlacement)(nil), "google.cloud.dataproc.v1.WorkflowTemplatePlacement")
	proto.RegisterType((*ManagedCluster)(nil), "google.cloud.dataproc.v1.ManagedCluster")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1.ManagedCluster.LabelsEntry")
	proto.RegisterType((*ClusterSelector)(nil), "google.cloud.dataproc.v1.ClusterSelector")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1.ClusterSelector.ClusterLabelsEntry")
	proto.RegisterType((*OrderedJob)(nil), "google.cloud.dataproc.v1.OrderedJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1.OrderedJob.LabelsEntry")
	proto.RegisterType((*TemplateParameter)(nil), "google.cloud.dataproc.v1.TemplateParameter")
	proto.RegisterType((*ParameterValidation)(nil), "google.cloud.dataproc.v1.ParameterValidation")
	proto.RegisterType((*RegexValidation)(nil), "google.cloud.dataproc.v1.RegexValidation")
	proto.RegisterType((*ValueValidation)(nil), "google.cloud.dataproc.v1.ValueValidation")
	proto.RegisterType((*WorkflowMetadata)(nil), "google.cloud.dataproc.v1.WorkflowMetadata")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1.WorkflowMetadata.ParametersEntry")
	proto.RegisterType((*ClusterOperation)(nil), "google.cloud.dataproc.v1.ClusterOperation")
	proto.RegisterType((*WorkflowGraph)(nil), "google.cloud.dataproc.v1.WorkflowGraph")
	proto.RegisterType((*WorkflowNode)(nil), "google.cloud.dataproc.v1.WorkflowNode")
	proto.RegisterType((*CreateWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1.CreateWorkflowTemplateRequest")
	proto.RegisterType((*GetWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1.GetWorkflowTemplateRequest")
	proto.RegisterType((*InstantiateWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1.InstantiateWorkflowTemplateRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1.InstantiateWorkflowTemplateRequest.ParametersEntry")
	proto.RegisterType((*InstantiateInlineWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1.InstantiateInlineWorkflowTemplateRequest")
	proto.RegisterType((*UpdateWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1.UpdateWorkflowTemplateRequest")
	proto.RegisterType((*ListWorkflowTemplatesRequest)(nil), "google.cloud.dataproc.v1.ListWorkflowTemplatesRequest")
	proto.RegisterType((*ListWorkflowTemplatesResponse)(nil), "google.cloud.dataproc.v1.ListWorkflowTemplatesResponse")
	proto.RegisterType((*DeleteWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1.DeleteWorkflowTemplateRequest")
	proto.RegisterEnum("google.cloud.dataproc.v1.WorkflowMetadata_State", WorkflowMetadata_State_name, WorkflowMetadata_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1.WorkflowNode_NodeState", WorkflowNode_NodeState_name, WorkflowNode_NodeState_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// WorkflowTemplateServiceClient is the client API for WorkflowTemplateService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WorkflowTemplateServiceClient interface {
	// Creates new workflow template.
	CreateWorkflowTemplate(ctx context.Context, in *CreateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error)
	// Retrieves the latest workflow template.
	//
	// Can retrieve previously instantiated template by specifying optional
	// version parameter.
	GetWorkflowTemplate(ctx context.Context, in *GetWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error)
	// Instantiates a template and begins execution.
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [operations.get][google.longrunning.Operations.GetOperation].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [operations.cancel][google.longrunning.Operations.CancelOperation].
	// This will cause any inflight jobs to be cancelled and workflow-owned
	// clusters to be deleted.
	//
	// The [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [WorkflowMetadata][google.cloud.dataproc.v1.WorkflowMetadata].
	//
	// On successful completion,
	// [Operation.response][google.longrunning.Operation.response] will be
	// [Empty][google.protobuf.Empty].
	InstantiateWorkflowTemplate(ctx context.Context, in *InstantiateWorkflowTemplateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Instantiates a template and begins execution.
	//
	// This method is equivalent to executing the sequence
	// [CreateWorkflowTemplate][google.cloud.dataproc.v1.WorkflowTemplateService.CreateWorkflowTemplate],
	// [InstantiateWorkflowTemplate][google.cloud.dataproc.v1.WorkflowTemplateService.InstantiateWorkflowTemplate],
	// [DeleteWorkflowTemplate][google.cloud.dataproc.v1.WorkflowTemplateService.DeleteWorkflowTemplate].
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [operations.get][google.longrunning.Operations.GetOperation].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [operations.cancel][google.longrunning.Operations.CancelOperation].
	// This will cause any inflight jobs to be cancelled and workflow-owned
	// clusters to be deleted.
	//
	// The [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [WorkflowMetadata][google.cloud.dataproc.v1.WorkflowMetadata].
	//
	// On successful completion,
	// [Operation.response][google.longrunning.Operation.response] will be
	// [Empty][google.protobuf.Empty].
	InstantiateInlineWorkflowTemplate(ctx context.Context, in *InstantiateInlineWorkflowTemplateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates (replaces) workflow template. The updated template
	// must contain version that matches the current server version.
	UpdateWorkflowTemplate(ctx context.Context, in *UpdateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error)
	// Lists workflows that match the specified filter in the request.
	ListWorkflowTemplates(ctx context.Context, in *ListWorkflowTemplatesRequest, opts ...grpc.CallOption) (*ListWorkflowTemplatesResponse, error)
	// Deletes a workflow template. It does not cancel in-progress workflows.
	DeleteWorkflowTemplate(ctx context.Context, in *DeleteWorkflowTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type workflowTemplateServiceClient struct {
	cc *grpc.ClientConn
}

func NewWorkflowTemplateServiceClient(cc *grpc.ClientConn) WorkflowTemplateServiceClient {
	return &workflowTemplateServiceClient{cc}
}

func (c *workflowTemplateServiceClient) CreateWorkflowTemplate(ctx context.Context, in *CreateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error) {
	out := new(WorkflowTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.WorkflowTemplateService/CreateWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) GetWorkflowTemplate(ctx context.Context, in *GetWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error) {
	out := new(WorkflowTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.WorkflowTemplateService/GetWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) InstantiateWorkflowTemplate(ctx context.Context, in *InstantiateWorkflowTemplateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.WorkflowTemplateService/InstantiateWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) InstantiateInlineWorkflowTemplate(ctx context.Context, in *InstantiateInlineWorkflowTemplateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.WorkflowTemplateService/InstantiateInlineWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) UpdateWorkflowTemplate(ctx context.Context, in *UpdateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error) {
	out := new(WorkflowTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.WorkflowTemplateService/UpdateWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) ListWorkflowTemplates(ctx context.Context, in *ListWorkflowTemplatesRequest, opts ...grpc.CallOption) (*ListWorkflowTemplatesResponse, error) {
	out := new(ListWorkflowTemplatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.WorkflowTemplateService/ListWorkflowTemplates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) DeleteWorkflowTemplate(ctx context.Context, in *DeleteWorkflowTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.WorkflowTemplateService/DeleteWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkflowTemplateServiceServer is the server API for WorkflowTemplateService service.
type WorkflowTemplateServiceServer interface {
	// Creates new workflow template.
	CreateWorkflowTemplate(context.Context, *CreateWorkflowTemplateRequest) (*WorkflowTemplate, error)
	// Retrieves the latest workflow template.
	//
	// Can retrieve previously instantiated template by specifying optional
	// version parameter.
	GetWorkflowTemplate(context.Context, *GetWorkflowTemplateRequest) (*WorkflowTemplate, error)
	// Instantiates a template and begins execution.
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [operations.get][google.longrunning.Operations.GetOperation].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [operations.cancel][google.longrunning.Operations.CancelOperation].
	// This will cause any inflight jobs to be cancelled and workflow-owned
	// clusters to be deleted.
	//
	// The [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [WorkflowMetadata][google.cloud.dataproc.v1.WorkflowMetadata].
	//
	// On successful completion,
	// [Operation.response][google.longrunning.Operation.response] will be
	// [Empty][google.protobuf.Empty].
	InstantiateWorkflowTemplate(context.Context, *InstantiateWorkflowTemplateRequest) (*longrunning.Operation, error)
	// Instantiates a template and begins execution.
	//
	// This method is equivalent to executing the sequence
	// [CreateWorkflowTemplate][google.cloud.dataproc.v1.WorkflowTemplateService.CreateWorkflowTemplate],
	// [InstantiateWorkflowTemplate][google.cloud.dataproc.v1.WorkflowTemplateService.InstantiateWorkflowTemplate],
	// [DeleteWorkflowTemplate][google.cloud.dataproc.v1.WorkflowTemplateService.DeleteWorkflowTemplate].
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [operations.get][google.longrunning.Operations.GetOperation].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [operations.cancel][google.longrunning.Operations.CancelOperation].
	// This will cause any inflight jobs to be cancelled and workflow-owned
	// clusters to be deleted.
	//
	// The [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [WorkflowMetadata][google.cloud.dataproc.v1.WorkflowMetadata].
	//
	// On successful completion,
	// [Operation.response][google.longrunning.Operation.response] will be
	// [Empty][google.protobuf.Empty].
	InstantiateInlineWorkflowTemplate(context.Context, *InstantiateInlineWorkflowTemplateRequest) (*longrunning.Operation, error)
	// Updates (replaces) workflow template. The updated template
	// must contain version that matches the current server version.
	UpdateWorkflowTemplate(context.Context, *UpdateWorkflowTemplateRequest) (*WorkflowTemplate, error)
	// Lists workflows that match the specified filter in the request.
	ListWorkflowTemplates(context.Context, *ListWorkflowTemplatesRequest) (*ListWorkflowTemplatesResponse, error)
	// Deletes a workflow template. It does not cancel in-progress workflows.
	DeleteWorkflowTemplate(context.Context, *DeleteWorkflowTemplateRequest) (*empty.Empty, error)
}

func RegisterWorkflowTemplateServiceServer(s *grpc.Server, srv WorkflowTemplateServiceServer) {
	s.RegisterService(&_WorkflowTemplateService_serviceDesc, srv)
}

func _WorkflowTemplateService_CreateWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).CreateWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.WorkflowTemplateService/CreateWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).CreateWorkflowTemplate(ctx, req.(*CreateWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_GetWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).GetWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.WorkflowTemplateService/GetWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).GetWorkflowTemplate(ctx, req.(*GetWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_InstantiateWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstantiateWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).InstantiateWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.WorkflowTemplateService/InstantiateWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).InstantiateWorkflowTemplate(ctx, req.(*InstantiateWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_InstantiateInlineWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstantiateInlineWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).InstantiateInlineWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.WorkflowTemplateService/InstantiateInlineWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).InstantiateInlineWorkflowTemplate(ctx, req.(*InstantiateInlineWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_UpdateWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).UpdateWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.WorkflowTemplateService/UpdateWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).UpdateWorkflowTemplate(ctx, req.(*UpdateWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_ListWorkflowTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkflowTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).ListWorkflowTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.WorkflowTemplateService/ListWorkflowTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).ListWorkflowTemplates(ctx, req.(*ListWorkflowTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_DeleteWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).DeleteWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.WorkflowTemplateService/DeleteWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).DeleteWorkflowTemplate(ctx, req.(*DeleteWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WorkflowTemplateService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.WorkflowTemplateService",
	HandlerType: (*WorkflowTemplateServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWorkflowTemplate",
			Handler:    _WorkflowTemplateService_CreateWorkflowTemplate_Handler,
		},
		{
			MethodName: "GetWorkflowTemplate",
			Handler:    _WorkflowTemplateService_GetWorkflowTemplate_Handler,
		},
		{
			MethodName: "InstantiateWorkflowTemplate",
			Handler:    _WorkflowTemplateService_InstantiateWorkflowTemplate_Handler,
		},
		{
			MethodName: "InstantiateInlineWorkflowTemplate",
			Handler:    _WorkflowTemplateService_InstantiateInlineWorkflowTemplate_Handler,
		},
		{
			MethodName: "UpdateWorkflowTemplate",
			Handler:    _WorkflowTemplateService_UpdateWorkflowTemplate_Handler,
		},
		{
			MethodName: "ListWorkflowTemplates",
			Handler:    _WorkflowTemplateService_ListWorkflowTemplates_Handler,
		},
		{
			MethodName: "DeleteWorkflowTemplate",
			Handler:    _WorkflowTemplateService_DeleteWorkflowTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/workflow_templates.proto",
}

func init() {
	proto.RegisterFile("google/cloud/dataproc/v1/workflow_templates.proto", fileDescriptor_workflow_templates_59ea55b2e6560827)
}

var fileDescriptor_workflow_templates_59ea55b2e6560827 = []byte{
	// 2000 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0xcd, 0x6f, 0xdb, 0xc8,
	0x15, 0x37, 0x65, 0x4b, 0x96, 0x9e, 0x62, 0x5b, 0x3b, 0x69, 0xbc, 0xaa, 0x12, 0xa3, 0x0e, 0xb7,
	0xdd, 0x78, 0xbd, 0xa8, 0xd4, 0x38, 0x4d, 0x37, 0xeb, 0x24, 0x9b, 0xb5, 0x2d, 0xd9, 0x56, 0x62,
	0xcb, 0x0e, 0x65, 0x67, 0x01, 0x5f, 0x04, 0x4a, 0x9c, 0xd0, 0x74, 0x28, 0x0e, 0x43, 0x52, 0xda,
	0x75, 0x8a, 0x45, 0x81, 0xdc, 0x16, 0xe8, 0xa1, 0xc5, 0xf6, 0x16, 0xa0, 0xc7, 0x02, 0x3d, 0x14,
	0xed, 0xa9, 0xa7, 0xfe, 0x09, 0x05, 0x7a, 0x28, 0x7a, 0x2e, 0x50, 0xf4, 0xda, 0x3f, 0xa1, 0x45,
	0x31, 0x1f, 0xa4, 0xa8, 0x0f, 0x52, 0x96, 0x5d, 0xa0, 0x17, 0x83, 0x33, 0x7a, 0xbf, 0x37, 0xef,
	0x6b, 0x7e, 0xef, 0x91, 0x86, 0xbb, 0x3a, 0x21, 0xba, 0x89, 0x4b, 0x2d, 0x93, 0x74, 0xb4, 0x92,
	0xa6, 0x7a, 0xaa, 0xed, 0x90, 0x56, 0xa9, 0x7b, 0xb7, 0xf4, 0x25, 0x71, 0x5e, 0xbd, 0x34, 0xc9,
	0x97, 0x0d, 0x0f, 0xb7, 0x6d, 0x53, 0xf5, 0xb0, 0x5b, 0xb4, 0x1d, 0xe2, 0x11, 0x94, 0xe7, 0x90,
	0x22, 0x83, 0x14, 0x7d, 0x48, 0xb1, 0x7b, 0xb7, 0x70, 0x4b, 0x28, 0x53, 0x6d, 0xa3, 0xa4, 0x5a,
	0x16, 0xf1, 0x54, 0xcf, 0x20, 0x96, 0xc0, 0x15, 0xee, 0x44, 0x1e, 0xd5, 0x32, 0x3b, 0xae, 0x87,
	0x1d, 0x5f, 0xf0, 0x83, 0x48, 0xc1, 0x33, 0xd2, 0x1c, 0x14, 0x32, 0x89, 0xa5, 0x3b, 0x1d, 0xcb,
	0x32, 0x2c, 0xbd, 0x44, 0x6c, 0xec, 0xf4, 0x1d, 0x79, 0x53, 0x08, 0xb1, 0x55, 0xb3, 0xf3, 0xb2,
	0x84, 0xdb, 0xb6, 0x77, 0x2e, 0x7e, 0xfc, 0xde, 0xe0, 0x8f, 0x9e, 0xd1, 0xc6, 0xae, 0xa7, 0xb6,
	0x6d, 0x2e, 0x20, 0xff, 0x7e, 0x06, 0x72, 0x5f, 0x88, 0x28, 0x1c, 0x89, 0x20, 0xa0, 0x79, 0x48,
	0x18, 0x5a, 0x3e, 0xb1, 0x2c, 0xad, 0x64, 0x94, 0x84, 0xa1, 0x21, 0x04, 0x33, 0x96, 0xda, 0xc6,
	0x79, 0x89, 0xed, 0xb0, 0x67, 0x94, 0x87, 0xd9, 0x2e, 0x76, 0x5c, 0x83, 0x58, 0xf9, 0xe9, 0x65,
	0x69, 0x25, 0xa9, 0xf8, 0x4b, 0xf4, 0x10, 0xb2, 0x2d, 0x07, 0xab, 0x1e, 0x6e, 0xd0, 0xc3, 0xf2,
	0x33, 0xcb, 0xd2, 0x4a, 0x76, 0xad, 0x50, 0x14, 0x11, 0xf5, 0x2d, 0x29, 0x1e, 0xf9, 0x96, 0x28,
	0xc0, 0xc5, 0xe9, 0x06, 0x05, 0x77, 0x6c, 0x2d, 0x00, 0x27, 0xc7, 0x83, 0xb9, 0x38, 0x03, 0xd7,
	0x20, 0x65, 0xaa, 0x4d, 0x6c, 0xba, 0xf9, 0xd4, 0xf2, 0xf4, 0x4a, 0x76, 0xed, 0x27, 0xc5, 0xa8,
	0x34, 0x16, 0x07, 0x7d, 0x2e, 0xee, 0x31, 0x60, 0xc5, 0xf2, 0x9c, 0x73, 0x45, 0x68, 0x41, 0xcf,
	0x21, 0x63, 0x9b, 0x6a, 0x0b, 0xb7, 0xb1, 0xe5, 0xe5, 0x67, 0x99, 0x29, 0xf7, 0x2e, 0xae, 0xf2,
	0xd0, 0x87, 0x2a, 0x3d, 0x2d, 0xe8, 0x01, 0xcc, 0xd0, 0x04, 0xe7, 0xd3, 0xcc, 0xc0, 0xef, 0x47,
	0x6b, 0x3b, 0x70, 0x34, 0xec, 0x60, 0xed, 0x29, 0x69, 0x2a, 0x0c, 0x81, 0x9e, 0x01, 0xd8, 0xaa,
	0xa3, 0xb6, 0x31, 0xad, 0xa2, 0x7c, 0x86, 0xe1, 0x3f, 0x8e, 0xc6, 0x07, 0x56, 0xf8, 0x18, 0x25,
	0x04, 0x2f, 0x7c, 0x0a, 0xd9, 0x90, 0xc3, 0x28, 0x07, 0xd3, 0xaf, 0xf0, 0xb9, 0xc8, 0x2f, 0x7d,
	0x44, 0xdf, 0x81, 0x64, 0x57, 0x35, 0x3b, 0x58, 0x54, 0x01, 0x5f, 0xac, 0x27, 0x1e, 0x48, 0xf2,
	0xdf, 0x24, 0xf8, 0x6e, 0xa4, 0xab, 0xa8, 0x0e, 0x0b, 0x6d, 0xd5, 0x52, 0x75, 0xac, 0x35, 0x44,
	0xc5, 0x33, 0xad, 0xd9, 0xb5, 0x95, 0x68, 0x53, 0xf7, 0x39, 0x60, 0x8b, 0xcb, 0xef, 0x4e, 0x29,
	0xf3, 0xed, 0xbe, 0x1d, 0xf4, 0x02, 0x72, 0x42, 0x59, 0xc3, 0xc5, 0x26, 0x6e, 0x79, 0xc4, 0x61,
	0x76, 0x65, 0xd7, 0x3e, 0x8a, 0xd6, 0x2a, 0xc0, 0x75, 0x01, 0xd8, 0x9d, 0x52, 0x16, 0x5a, 0xfd,
	0x5b, 0x9b, 0xd9, 0x50, 0x7e, 0xe5, 0x7f, 0x4b, 0x30, 0xdf, 0x6f, 0x09, 0xba, 0x0d, 0xd7, 0xfc,
	0x73, 0x59, 0xfd, 0xf3, 0x58, 0x64, 0xc5, 0x5e, 0x8d, 0x5e, 0x83, 0x27, 0x90, 0x6a, 0x11, 0xeb,
	0xa5, 0xa1, 0xb3, 0x5b, 0x90, 0x5d, 0xbb, 0x33, 0xd6, 0xa0, 0x2d, 0x26, 0xae, 0x08, 0x18, 0xda,
	0x0b, 0x6a, 0x76, 0x86, 0xa5, 0xf4, 0xc7, 0x17, 0x8d, 0xd3, 0xa8, 0x8a, 0xbd, 0x4a, 0x5e, 0xff,
	0x2c, 0xc1, 0xc2, 0x40, 0xcc, 0xe8, 0xc5, 0x7f, 0x43, 0xac, 0xe0, 0xe2, 0xd3, 0x67, 0xd4, 0x82,
	0x79, 0x3f, 0x28, 0xc2, 0xf0, 0x04, 0x33, 0xfc, 0xd1, 0x85, 0x53, 0xe1, 0xaf, 0xc3, 0x0e, 0xcc,
	0xb5, 0xc2, 0x7b, 0x85, 0xcf, 0x01, 0x0d, 0x0b, 0x4d, 0xe4, 0xce, 0x5f, 0x92, 0x00, 0xbd, 0x3b,
	0x84, 0xde, 0x87, 0x59, 0xd7, 0xc3, 0x76, 0xc3, 0xd0, 0x04, 0x3c, 0x45, 0x97, 0x55, 0x0d, 0x95,
	0x01, 0x4e, 0x55, 0x8d, 0x10, 0xbb, 0x71, 0x46, 0x9a, 0xa2, 0xaa, 0x3e, 0x88, 0x76, 0x65, 0x97,
	0xc9, 0x3e, 0x25, 0xcd, 0xdd, 0x29, 0x25, 0x73, 0xea, 0x2f, 0xd0, 0x06, 0x64, 0x5c, 0x5b, 0x75,
	0x5e, 0x31, 0x25, 0xbc, 0x12, 0xe4, 0x68, 0x25, 0x75, 0x2a, 0xca, 0x75, 0xa4, 0x5d, 0xf1, 0x8c,
	0x76, 0x20, 0x6b, 0x9f, 0xf7, 0x94, 0x70, 0xda, 0x8c, 0x21, 0x88, 0xc3, 0xf3, 0x90, 0x1a, 0x10,
	0x50, 0xaa, 0xe8, 0x33, 0x48, 0x9f, 0x1a, 0x5d, 0xcc, 0xb4, 0x70, 0xfe, 0xbc, 0x1d, 0xe3, 0x8f,
	0xd1, 0xc5, 0x5c, 0xc5, 0xec, 0x29, 0x7f, 0x44, 0x0f, 0x61, 0xd6, 0x36, 0x74, 0x06, 0x4f, 0x31,
	0xf8, 0x72, 0x8c, 0x11, 0x86, 0xce, 0xd1, 0x29, 0x9b, 0x3d, 0xa1, 0x67, 0x30, 0xc7, 0x7d, 0x70,
	0x5f, 0x9b, 0x4c, 0x05, 0xa7, 0xcd, 0x1f, 0x8c, 0x09, 0x46, 0xfd, 0xb5, 0xc9, 0xf5, 0x64, 0xdd,
	0xde, 0x12, 0xed, 0x06, 0x77, 0x83, 0xd3, 0xe5, 0x8f, 0x2e, 0x42, 0x97, 0x23, 0x99, 0x7c, 0x07,
	0xc0, 0x6d, 0x9d, 0x62, 0xad, 0x63, 0x1a, 0x96, 0x9e, 0xcf, 0x8c, 0xbb, 0xaa, 0x4f, 0x49, 0xb3,
	0x1e, 0x88, 0x2b, 0x21, 0x28, 0x5a, 0x83, 0x1b, 0xb6, 0x83, 0x1d, 0xfc, 0xba, 0x63, 0xb8, 0x86,
	0x87, 0x1b, 0xa2, 0xa8, 0xdc, 0x3c, 0x2c, 0x4f, 0xaf, 0x64, 0x94, 0xeb, 0xe1, 0x1f, 0xeb, 0xac,
	0xc2, 0xae, 0x72, 0x29, 0x37, 0x01, 0xd2, 0x67, 0xa4, 0xd9, 0xf0, 0xce, 0x6d, 0x2c, 0xff, 0x41,
	0x82, 0xf7, 0x86, 0x58, 0x7d, 0x64, 0x6f, 0x5e, 0x84, 0xd4, 0x4b, 0x03, 0x9b, 0x1a, 0xbf, 0x9a,
	0x19, 0x45, 0xac, 0xd0, 0x32, 0x64, 0x35, 0xec, 0xb6, 0x1c, 0xc3, 0xf6, 0xfc, 0xbe, 0x9d, 0x51,
	0xc2, 0x5b, 0x68, 0x1f, 0xa0, 0xab, 0x9a, 0x86, 0xc6, 0x26, 0x0c, 0x51, 0x83, 0x3f, 0x8c, 0x49,
	0xbf, 0x6f, 0xc6, 0x8b, 0x00, 0xa4, 0x84, 0x14, 0x50, 0x93, 0xaf, 0x8f, 0x90, 0x41, 0x1b, 0x90,
	0x74, 0xb0, 0x8e, 0xbf, 0x12, 0xbd, 0x21, 0x86, 0xc5, 0x15, 0x2a, 0xd6, 0x43, 0xee, 0x4e, 0x29,
	0x1c, 0x89, 0xb6, 0x20, 0xc5, 0xc2, 0xe4, 0x8e, 0xef, 0x04, 0x2f, 0xa8, 0x5c, 0x9f, 0x0e, 0x01,
	0xdd, 0x7c, 0x0f, 0x16, 0x7a, 0xd6, 0xf2, 0x28, 0x7f, 0x0c, 0x0b, 0x03, 0x67, 0xd2, 0x51, 0x87,
	0x9d, 0x89, 0xdd, 0xbc, 0xc4, 0xe2, 0xe9, 0x2f, 0xe5, 0x8f, 0x60, 0x61, 0x40, 0x39, 0x8d, 0xbd,
	0xb0, 0x8b, 0xcb, 0x8a, 0x95, 0xfc, 0x36, 0xd5, 0x1b, 0xb4, 0xf6, 0xb1, 0xa7, 0x52, 0x03, 0x51,
	0x01, 0xd2, 0xfe, 0xe4, 0x29, 0x12, 0x18, 0xac, 0xc3, 0x03, 0x56, 0xa2, 0x7f, 0xc0, 0x7a, 0x0e,
	0xf3, 0x62, 0xc0, 0xf2, 0x5b, 0x2c, 0x67, 0x9c, 0xd5, 0xb1, 0x0c, 0x7c, 0xe0, 0x0f, 0x8f, 0xca,
	0x1c, 0xd7, 0xe0, 0x77, 0xba, 0xc7, 0x90, 0xd4, 0x1d, 0xd5, 0x3e, 0x15, 0x29, 0xbf, 0x33, 0x7e,
	0xca, 0xd9, 0xa1, 0xe2, 0x0a, 0x47, 0x51, 0x8b, 0x34, 0x6c, 0xe2, 0x90, 0x45, 0xc9, 0xc9, 0x2d,
	0xe2, 0x1a, 0x7c, 0x8b, 0xb6, 0x21, 0xe9, 0x7a, 0x34, 0x2e, 0x94, 0x83, 0xe6, 0xe3, 0xae, 0xfe,
	0x60, 0x54, 0x8b, 0x75, 0x8a, 0x53, 0x38, 0x7c, 0xa8, 0x87, 0xcf, 0x0e, 0xf7, 0xf0, 0x93, 0xbe,
	0xc9, 0x8a, 0x53, 0xcd, 0xfa, 0x04, 0xe7, 0x05, 0x15, 0x2e, 0x48, 0x27, 0xa4, 0x0d, 0x7d, 0x0a,
	0xe0, 0x7a, 0xaa, 0xe3, 0xf1, 0x71, 0x36, 0x33, 0x76, 0x9c, 0xcd, 0x30, 0x69, 0x36, 0xcd, 0xde,
	0x87, 0x34, 0xb6, 0x34, 0x0e, 0x84, 0xb1, 0xc0, 0x59, 0x6c, 0x69, 0x0c, 0x16, 0x72, 0xb8, 0xd3,
	0x31, 0xb4, 0x7c, 0xb6, 0xcf, 0xe1, 0xe3, 0x8e, 0xa1, 0x15, 0x1e, 0xc3, 0xc2, 0x80, 0xcd, 0x13,
	0xb5, 0xd6, 0x07, 0x90, 0x64, 0x21, 0x46, 0x59, 0x98, 0x3d, 0xae, 0x3d, 0xab, 0x1d, 0x7c, 0x51,
	0xcb, 0x4d, 0xd1, 0xc5, 0x61, 0xa5, 0x56, 0xae, 0xd6, 0x76, 0x72, 0x12, 0x5d, 0x28, 0xc7, 0xb5,
	0x1a, 0x5d, 0x24, 0x50, 0x1a, 0x66, 0xca, 0x07, 0xb5, 0x4a, 0x6e, 0x5a, 0x6e, 0x40, 0x6e, 0x30,
	0xef, 0xd4, 0xde, 0xe0, 0x9d, 0xa6, 0xd7, 0x9e, 0xb3, 0xc1, 0x5e, 0x55, 0xa3, 0xa6, 0x60, 0xc7,
	0x11, 0x43, 0x5f, 0x46, 0xe1, 0x0b, 0xca, 0x7c, 0x1a, 0x1d, 0x4e, 0x68, 0xf1, 0xa7, 0x15, 0xf6,
	0x2c, 0xef, 0xc3, 0x5c, 0x5f, 0x81, 0xa2, 0x47, 0x90, 0xb4, 0x88, 0x26, 0x6e, 0x63, 0x76, 0xed,
	0xc3, 0xf1, 0x69, 0xad, 0x11, 0x0d, 0x2b, 0x1c, 0x24, 0xff, 0x29, 0x01, 0xd7, 0xc2, 0xfb, 0xd1,
	0x63, 0x44, 0x64, 0x5f, 0x48, 0x44, 0xf6, 0x05, 0x74, 0x03, 0x52, 0x94, 0xdc, 0x0d, 0x4d, 0x30,
	0x71, 0xf2, 0x8c, 0x34, 0xab, 0x5a, 0xaf, 0xf2, 0x93, 0x17, 0xad, 0x7c, 0x6a, 0x5a, 0x91, 0xfe,
	0xe9, 0xab, 0xfc, 0x20, 0x6a, 0xa9, 0x50, 0xd4, 0xe4, 0x33, 0xc8, 0x04, 0x92, 0xa8, 0x00, 0x8b,
	0xb5, 0x83, 0x72, 0xa5, 0x51, 0x3f, 0xda, 0x38, 0xaa, 0x34, 0x8e, 0x6b, 0xf5, 0xc3, 0xca, 0x56,
	0x75, 0xbb, 0x5a, 0x29, 0xf3, 0x7c, 0x6e, 0xee, 0x1d, 0x6c, 0x3d, 0xab, 0x94, 0x73, 0x12, 0xba,
	0x06, 0x69, 0x9a, 0xcf, 0x8d, 0xcd, 0xbd, 0x4a, 0x2e, 0x11, 0xce, 0xee, 0x34, 0x9a, 0x83, 0xcc,
	0xd6, 0xc1, 0xfe, 0xe1, 0x5e, 0xe5, 0xa8, 0x52, 0xce, 0xcd, 0x20, 0x80, 0xd4, 0xf6, 0x46, 0x75,
	0xaf, 0x52, 0xce, 0x25, 0xe5, 0x9f, 0xc1, 0xd2, 0x16, 0xa3, 0x99, 0xc1, 0xf7, 0x05, 0x05, 0xbf,
	0xee, 0x60, 0xd7, 0xa3, 0x64, 0x69, 0xab, 0x0e, 0x7d, 0xbb, 0x12, 0xd1, 0xe4, 0x2b, 0xb4, 0x1d,
	0xe2, 0xc5, 0xc4, 0x38, 0x26, 0x19, 0x52, 0x1e, 0x60, 0xe5, 0xa7, 0x50, 0xd8, 0xc1, 0x5e, 0xd4,
	0xe9, 0x63, 0x5e, 0x6b, 0xfb, 0x59, 0x57, 0xfe, 0x75, 0x02, 0xe4, 0xaa, 0xe5, 0x7a, 0xaa, 0xe5,
	0x19, 0x31, 0x2e, 0x4d, 0xa4, 0x14, 0x2d, 0x01, 0x38, 0x1c, 0x48, 0xcb, 0x20, 0xc9, 0x30, 0x19,
	0xb1, 0x53, 0xd5, 0x90, 0xd9, 0xc7, 0x4c, 0xfc, 0xa5, 0x76, 0x2f, 0x3a, 0x12, 0xe3, 0xcd, 0x8b,
	0xe3, 0xaa, 0xab, 0xd2, 0xc2, 0x6f, 0x25, 0x58, 0x09, 0x59, 0x50, 0xb5, 0x4c, 0xc3, 0xfa, 0x7f,
	0x65, 0x7e, 0x20, 0xb0, 0xd3, 0x03, 0x81, 0x95, 0x75, 0x58, 0x3a, 0x66, 0xdf, 0x0d, 0xa2, 0xec,
	0xdb, 0x1e, 0xe8, 0xcc, 0x97, 0xad, 0x40, 0x07, 0x6e, 0xed, 0x19, 0xee, 0x50, 0x09, 0xba, 0xe3,
	0xe2, 0x70, 0x13, 0x32, 0xb6, 0xaa, 0xe3, 0x86, 0x6b, 0xbc, 0xc1, 0xa2, 0x68, 0xd2, 0x74, 0xa3,
	0x6e, 0xbc, 0x61, 0xce, 0xb1, 0x1f, 0x3d, 0xf2, 0x0a, 0xfb, 0x63, 0x1c, 0x13, 0x3f, 0xa2, 0x1b,
	0xf2, 0x2f, 0x25, 0x58, 0x8a, 0x38, 0xd4, 0xb5, 0x89, 0xe5, 0x62, 0xb4, 0x0b, 0x99, 0xe0, 0x8b,
	0x97, 0x60, 0xc6, 0x49, 0xdc, 0xeb, 0x81, 0xd1, 0x87, 0xb0, 0x60, 0xe1, 0xaf, 0xbc, 0x46, 0xc8,
	0x1e, 0x5e, 0x18, 0x73, 0x74, 0xfb, 0x30, 0xb0, 0x69, 0x1f, 0x96, 0xca, 0xac, 0xbf, 0xff, 0x4f,
	0xee, 0xcd, 0xda, 0x3f, 0xe6, 0xe1, 0xfd, 0x41, 0x4d, 0x75, 0xec, 0x74, 0x8d, 0x16, 0x46, 0xdf,
	0x24, 0x60, 0x71, 0x34, 0xed, 0xa0, 0x4f, 0x62, 0xe6, 0x91, 0x38, 0xa2, 0x2a, 0x4c, 0x10, 0x1d,
	0xf9, 0x1b, 0xe9, 0xed, 0x5f, 0xff, 0xf9, 0x6d, 0xe2, 0xad, 0x24, 0xdf, 0x2f, 0x75, 0xef, 0x96,
	0x7e, 0xca, 0x33, 0xfa, 0xd8, 0x76, 0xc8, 0x19, 0x6e, 0x79, 0x6e, 0x69, 0xb5, 0x64, 0x92, 0x16,
	0xff, 0x84, 0x57, 0x5a, 0xfd, 0x3a, 0xf8, 0x06, 0x19, 0x64, 0x69, 0x3d, 0xa8, 0x9e, 0x93, 0x27,
	0xf2, 0xbd, 0x08, 0x15, 0x0e, 0xd6, 0x2f, 0xa0, 0x00, 0xfd, 0x4b, 0x82, 0xeb, 0x23, 0x18, 0x10,
	0xc5, 0x7c, 0x65, 0x88, 0x26, 0xcc, 0x89, 0xa2, 0xe0, 0xb1, 0x20, 0x58, 0x88, 0xc7, 0x80, 0xa6,
	0x33, 0x22, 0x02, 0xc3, 0xf6, 0x97, 0x56, 0xbf, 0x3e, 0xb9, 0x8f, 0xee, 0x8d, 0x04, 0x06, 0x7e,
	0x8f, 0x84, 0xa1, 0x5f, 0x24, 0xe0, 0x66, 0x0c, 0x0b, 0xa2, 0x47, 0x57, 0x21, 0xcf, 0xc2, 0x92,
	0x8f, 0x0e, 0x7d, 0x90, 0x2d, 0x06, 0x93, 0x8c, 0xfc, 0x2d, 0x4f, 0xfc, 0xcf, 0x25, 0x79, 0xe3,
	0x52, 0x4e, 0xaf, 0x1b, 0x3d, 0x13, 0xd6, 0xa5, 0xd5, 0x93, 0xb2, 0xfc, 0xe4, 0x12, 0x31, 0x18,
	0xd0, 0x82, 0xfe, 0x98, 0x80, 0xdb, 0x63, 0x69, 0x19, 0x6d, 0x5e, 0x28, 0x30, 0xb1, 0x9c, 0x3e,
	0x2e, 0x3c, 0xbf, 0xe3, 0xe1, 0xf9, 0x8d, 0x24, 0xef, 0x5c, 0xee, 0x5e, 0x18, 0x83, 0x86, 0x84,
	0x6e, 0xca, 0x73, 0xb9, 0x72, 0x99, 0x9b, 0x12, 0xa3, 0x12, 0xbd, 0x4b, 0xc0, 0xe2, 0xe8, 0x26,
	0x11, 0xc7, 0x23, 0xb1, 0x6d, 0x65, 0xa2, 0x1b, 0xf4, 0x8e, 0xc7, 0xeb, 0x57, 0x52, 0xe1, 0x33,
	0xe6, 0x9a, 0x6f, 0x58, 0x71, 0xe2, 0xba, 0xea, 0x85, 0x69, 0xb7, 0xf0, 0x28, 0x5e, 0xd7, 0x98,
	0xda, 0xea, 0x45, 0xe7, 0x3f, 0x12, 0xdc, 0x18, 0xd9, 0x64, 0x50, 0xcc, 0x57, 0xf7, 0xb8, 0x56,
	0x58, 0xf8, 0x64, 0x62, 0x1c, 0xef, 0x66, 0x03, 0x54, 0x33, 0x69, 0x59, 0x05, 0x54, 0x33, 0x59,
	0xe9, 0xa0, 0xbf, 0x4b, 0xb0, 0x38, 0xba, 0xa5, 0xc5, 0x95, 0x47, 0x6c, 0x13, 0x2c, 0x2c, 0x0e,
	0xbd, 0xe0, 0x55, 0xda, 0xb6, 0x77, 0xee, 0x7b, 0xb8, 0x7a, 0x59, 0x32, 0x5d, 0xbd, 0x0c, 0x99,
	0x6e, 0xbe, 0x81, 0x5b, 0x2d, 0xd2, 0x8e, 0xf4, 0x65, 0x73, 0x71, 0x28, 0x25, 0x87, 0xd4, 0xec,
	0x43, 0xe9, 0xe4, 0x73, 0x81, 0xd1, 0x89, 0xa9, 0x5a, 0x7a, 0x91, 0x38, 0x7a, 0x49, 0xc7, 0x16,
	0x73, 0xaa, 0xc4, 0x7f, 0x52, 0x6d, 0xc3, 0x1d, 0xfe, 0xe7, 0xd7, 0x43, 0xff, 0xb9, 0x99, 0x62,
	0xc2, 0xf7, 0xfe, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x70, 0xa3, 0x03, 0xbc, 0xbc, 0x1b, 0x00, 0x00,
}
