// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/conversion_upload_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v1/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [ConversionUploadService.UploadClickConversions][google.ads.googleads.v1.services.ConversionUploadService.UploadClickConversions].
type UploadClickConversionsRequest struct {
	// The ID of the customer performing the upload.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The conversions that are being uploaded.
	Conversions []*ClickConversion `protobuf:"bytes,2,rep,name=conversions,proto3" json:"conversions,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// This should always be set to true.
	PartialFailure       bool     `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UploadClickConversionsRequest) Reset()         { *m = UploadClickConversionsRequest{} }
func (m *UploadClickConversionsRequest) String() string { return proto.CompactTextString(m) }
func (*UploadClickConversionsRequest) ProtoMessage()    {}
func (*UploadClickConversionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_upload_service_bae8a38c0c8cb79b, []int{0}
}
func (m *UploadClickConversionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UploadClickConversionsRequest.Unmarshal(m, b)
}
func (m *UploadClickConversionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UploadClickConversionsRequest.Marshal(b, m, deterministic)
}
func (dst *UploadClickConversionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UploadClickConversionsRequest.Merge(dst, src)
}
func (m *UploadClickConversionsRequest) XXX_Size() int {
	return xxx_messageInfo_UploadClickConversionsRequest.Size(m)
}
func (m *UploadClickConversionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UploadClickConversionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UploadClickConversionsRequest proto.InternalMessageInfo

func (m *UploadClickConversionsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *UploadClickConversionsRequest) GetConversions() []*ClickConversion {
	if m != nil {
		return m.Conversions
	}
	return nil
}

func (m *UploadClickConversionsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

// Response message for [ConversionUploadService.UploadClickConversions][google.ads.googleads.v1.services.ConversionUploadService.UploadClickConversions].
type UploadClickConversionsResponse struct {
	// Errors that pertain to conversion failures in the partial failure mode.
	// Returned when all errors occur inside the conversions. If any errors occur
	// outside the conversions (e.g. auth errors), we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,1,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// Returned for successfully processed conversions. Proto will be empty for
	// rows that received an error.
	Results              []*ClickConversionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *UploadClickConversionsResponse) Reset()         { *m = UploadClickConversionsResponse{} }
func (m *UploadClickConversionsResponse) String() string { return proto.CompactTextString(m) }
func (*UploadClickConversionsResponse) ProtoMessage()    {}
func (*UploadClickConversionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_upload_service_bae8a38c0c8cb79b, []int{1}
}
func (m *UploadClickConversionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UploadClickConversionsResponse.Unmarshal(m, b)
}
func (m *UploadClickConversionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UploadClickConversionsResponse.Marshal(b, m, deterministic)
}
func (dst *UploadClickConversionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UploadClickConversionsResponse.Merge(dst, src)
}
func (m *UploadClickConversionsResponse) XXX_Size() int {
	return xxx_messageInfo_UploadClickConversionsResponse.Size(m)
}
func (m *UploadClickConversionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UploadClickConversionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UploadClickConversionsResponse proto.InternalMessageInfo

func (m *UploadClickConversionsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *UploadClickConversionsResponse) GetResults() []*ClickConversionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// A click conversion.
type ClickConversion struct {
	// The Google click ID (gclid) associated with this conversion.
	Gclid *wrappers.StringValue `protobuf:"bytes,1,opt,name=gclid,proto3" json:"gclid,omitempty"`
	// Resource name of the conversion action associated with this conversion.
	// Note: Although this resource name consists of a customer id and a
	// conversion action id, validation will ignore the customer id and use the
	// conversion action id as the sole identifier of the conversion action.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,2,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The date time at which the conversion occurred. Must be after
	// the click time. The timezone must be specified. The format is
	// "yyyy-mm-dd hh:mm:ss+|-hh:mm", e.g. “2019-01-01 12:32:45-08:00”.
	ConversionDateTime *wrappers.StringValue `protobuf:"bytes,3,opt,name=conversion_date_time,json=conversionDateTime,proto3" json:"conversion_date_time,omitempty"`
	// The value of the conversion for the advertiser.
	ConversionValue *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=conversion_value,json=conversionValue,proto3" json:"conversion_value,omitempty"`
	// Currency associated with the conversion value. This is the ISO 4217
	// 3-character currency code. For example: USD, EUR.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,5,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// The order ID associated with the conversion. An order id can only be used
	// for one conversion per conversion action.
	OrderId *wrappers.StringValue `protobuf:"bytes,6,opt,name=order_id,json=orderId,proto3" json:"order_id,omitempty"`
	// Additional data about externally attributed conversions. This field
	// is required for conversions with an externally attributed conversion
	// action, but should not be set otherwise.
	ExternalAttributionData *ExternalAttributionData `protobuf:"bytes,7,opt,name=external_attribution_data,json=externalAttributionData,proto3" json:"external_attribution_data,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                 `json:"-"`
	XXX_unrecognized        []byte                   `json:"-"`
	XXX_sizecache           int32                    `json:"-"`
}

func (m *ClickConversion) Reset()         { *m = ClickConversion{} }
func (m *ClickConversion) String() string { return proto.CompactTextString(m) }
func (*ClickConversion) ProtoMessage()    {}
func (*ClickConversion) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_upload_service_bae8a38c0c8cb79b, []int{2}
}
func (m *ClickConversion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClickConversion.Unmarshal(m, b)
}
func (m *ClickConversion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClickConversion.Marshal(b, m, deterministic)
}
func (dst *ClickConversion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClickConversion.Merge(dst, src)
}
func (m *ClickConversion) XXX_Size() int {
	return xxx_messageInfo_ClickConversion.Size(m)
}
func (m *ClickConversion) XXX_DiscardUnknown() {
	xxx_messageInfo_ClickConversion.DiscardUnknown(m)
}

var xxx_messageInfo_ClickConversion proto.InternalMessageInfo

func (m *ClickConversion) GetGclid() *wrappers.StringValue {
	if m != nil {
		return m.Gclid
	}
	return nil
}

func (m *ClickConversion) GetConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *ClickConversion) GetConversionDateTime() *wrappers.StringValue {
	if m != nil {
		return m.ConversionDateTime
	}
	return nil
}

func (m *ClickConversion) GetConversionValue() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionValue
	}
	return nil
}

func (m *ClickConversion) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *ClickConversion) GetOrderId() *wrappers.StringValue {
	if m != nil {
		return m.OrderId
	}
	return nil
}

func (m *ClickConversion) GetExternalAttributionData() *ExternalAttributionData {
	if m != nil {
		return m.ExternalAttributionData
	}
	return nil
}

// Contains additional information about externally attributed conversions.
type ExternalAttributionData struct {
	// Represents the fraction of the conversion that is attributed to the
	// Google Ads click.
	ExternalAttributionCredit *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=external_attribution_credit,json=externalAttributionCredit,proto3" json:"external_attribution_credit,omitempty"`
	// Specifies the attribution model name.
	ExternalAttributionModel *wrappers.StringValue `protobuf:"bytes,2,opt,name=external_attribution_model,json=externalAttributionModel,proto3" json:"external_attribution_model,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}              `json:"-"`
	XXX_unrecognized         []byte                `json:"-"`
	XXX_sizecache            int32                 `json:"-"`
}

func (m *ExternalAttributionData) Reset()         { *m = ExternalAttributionData{} }
func (m *ExternalAttributionData) String() string { return proto.CompactTextString(m) }
func (*ExternalAttributionData) ProtoMessage()    {}
func (*ExternalAttributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_upload_service_bae8a38c0c8cb79b, []int{3}
}
func (m *ExternalAttributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExternalAttributionData.Unmarshal(m, b)
}
func (m *ExternalAttributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExternalAttributionData.Marshal(b, m, deterministic)
}
func (dst *ExternalAttributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalAttributionData.Merge(dst, src)
}
func (m *ExternalAttributionData) XXX_Size() int {
	return xxx_messageInfo_ExternalAttributionData.Size(m)
}
func (m *ExternalAttributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalAttributionData.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalAttributionData proto.InternalMessageInfo

func (m *ExternalAttributionData) GetExternalAttributionCredit() *wrappers.DoubleValue {
	if m != nil {
		return m.ExternalAttributionCredit
	}
	return nil
}

func (m *ExternalAttributionData) GetExternalAttributionModel() *wrappers.StringValue {
	if m != nil {
		return m.ExternalAttributionModel
	}
	return nil
}

// Identifying information for a successfully processed ClickConversion.
type ClickConversionResult struct {
	// The Google Click ID (gclid) associated with this conversion.
	Gclid *wrappers.StringValue `protobuf:"bytes,1,opt,name=gclid,proto3" json:"gclid,omitempty"`
	// Resource name of the conversion action associated with this conversion.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,2,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The date time at which the conversion occurred. The format is
	// "yyyy-mm-dd hh:mm:ss+|-hh:mm", e.g. “2019-01-01 12:32:45-08:00”.
	ConversionDateTime   *wrappers.StringValue `protobuf:"bytes,3,opt,name=conversion_date_time,json=conversionDateTime,proto3" json:"conversion_date_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ClickConversionResult) Reset()         { *m = ClickConversionResult{} }
func (m *ClickConversionResult) String() string { return proto.CompactTextString(m) }
func (*ClickConversionResult) ProtoMessage()    {}
func (*ClickConversionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_conversion_upload_service_bae8a38c0c8cb79b, []int{4}
}
func (m *ClickConversionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClickConversionResult.Unmarshal(m, b)
}
func (m *ClickConversionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClickConversionResult.Marshal(b, m, deterministic)
}
func (dst *ClickConversionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClickConversionResult.Merge(dst, src)
}
func (m *ClickConversionResult) XXX_Size() int {
	return xxx_messageInfo_ClickConversionResult.Size(m)
}
func (m *ClickConversionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ClickConversionResult.DiscardUnknown(m)
}

var xxx_messageInfo_ClickConversionResult proto.InternalMessageInfo

func (m *ClickConversionResult) GetGclid() *wrappers.StringValue {
	if m != nil {
		return m.Gclid
	}
	return nil
}

func (m *ClickConversionResult) GetConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *ClickConversionResult) GetConversionDateTime() *wrappers.StringValue {
	if m != nil {
		return m.ConversionDateTime
	}
	return nil
}

func init() {
	proto.RegisterType((*UploadClickConversionsRequest)(nil), "google.ads.googleads.v1.services.UploadClickConversionsRequest")
	proto.RegisterType((*UploadClickConversionsResponse)(nil), "google.ads.googleads.v1.services.UploadClickConversionsResponse")
	proto.RegisterType((*ClickConversion)(nil), "google.ads.googleads.v1.services.ClickConversion")
	proto.RegisterType((*ExternalAttributionData)(nil), "google.ads.googleads.v1.services.ExternalAttributionData")
	proto.RegisterType((*ClickConversionResult)(nil), "google.ads.googleads.v1.services.ClickConversionResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ConversionUploadServiceClient is the client API for ConversionUploadService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConversionUploadServiceClient interface {
	// Processes the given click conversions.
	UploadClickConversions(ctx context.Context, in *UploadClickConversionsRequest, opts ...grpc.CallOption) (*UploadClickConversionsResponse, error)
}

type conversionUploadServiceClient struct {
	cc *grpc.ClientConn
}

func NewConversionUploadServiceClient(cc *grpc.ClientConn) ConversionUploadServiceClient {
	return &conversionUploadServiceClient{cc}
}

func (c *conversionUploadServiceClient) UploadClickConversions(ctx context.Context, in *UploadClickConversionsRequest, opts ...grpc.CallOption) (*UploadClickConversionsResponse, error) {
	out := new(UploadClickConversionsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.ConversionUploadService/UploadClickConversions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversionUploadServiceServer is the server API for ConversionUploadService service.
type ConversionUploadServiceServer interface {
	// Processes the given click conversions.
	UploadClickConversions(context.Context, *UploadClickConversionsRequest) (*UploadClickConversionsResponse, error)
}

func RegisterConversionUploadServiceServer(s *grpc.Server, srv ConversionUploadServiceServer) {
	s.RegisterService(&_ConversionUploadService_serviceDesc, srv)
}

func _ConversionUploadService_UploadClickConversions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadClickConversionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionUploadServiceServer).UploadClickConversions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.ConversionUploadService/UploadClickConversions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionUploadServiceServer).UploadClickConversions(ctx, req.(*UploadClickConversionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConversionUploadService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.ConversionUploadService",
	HandlerType: (*ConversionUploadServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UploadClickConversions",
			Handler:    _ConversionUploadService_UploadClickConversions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/conversion_upload_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/conversion_upload_service.proto", fileDescriptor_conversion_upload_service_bae8a38c0c8cb79b)
}

var fileDescriptor_conversion_upload_service_bae8a38c0c8cb79b = []byte{
	// 736 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x55, 0xcb, 0x6e, 0xd3, 0x40,
	0x14, 0x95, 0xd3, 0x27, 0x13, 0xa0, 0x30, 0x50, 0xe2, 0x86, 0x52, 0xa2, 0xa8, 0x12, 0x55, 0x17,
	0xb6, 0x12, 0x90, 0xaa, 0x1a, 0xa1, 0xd6, 0x4d, 0x1f, 0x74, 0x01, 0x2a, 0x0e, 0x64, 0x51, 0x45,
	0xb2, 0x26, 0x9e, 0xa9, 0x65, 0xe1, 0x78, 0xcc, 0xcc, 0x38, 0x80, 0x10, 0x1b, 0xf8, 0x04, 0xb6,
	0xac, 0x58, 0xf2, 0x0b, 0x48, 0x7c, 0x00, 0xdb, 0x6e, 0x59, 0x22, 0x16, 0x7c, 0x01, 0x4b, 0xe4,
	0xc7, 0x24, 0xa1, 0x72, 0x48, 0x60, 0xc9, 0xee, 0xe6, 0xde, 0x73, 0xce, 0x7d, 0xf8, 0xe6, 0x0e,
	0xd8, 0x76, 0x29, 0x75, 0x7d, 0xa2, 0x23, 0xcc, 0xf5, 0xd4, 0x8c, 0xad, 0x5e, 0x4d, 0xe7, 0x84,
	0xf5, 0x3c, 0x87, 0x70, 0xdd, 0xa1, 0x41, 0x8f, 0x30, 0xee, 0xd1, 0xc0, 0x8e, 0x42, 0x9f, 0x22,
	0x6c, 0x67, 0x21, 0x2d, 0x64, 0x54, 0x50, 0x58, 0x49, 0x69, 0x1a, 0xc2, 0x5c, 0xeb, 0x2b, 0x68,
	0xbd, 0x9a, 0x26, 0x15, 0xca, 0xcb, 0x32, 0x47, 0xe8, 0xe9, 0x28, 0x08, 0xa8, 0x40, 0xc2, 0xa3,
	0x01, 0x4f, 0xf9, 0xe5, 0x95, 0x2c, 0x9a, 0xfc, 0xea, 0x44, 0x27, 0xfa, 0x73, 0x86, 0xc2, 0x90,
	0x30, 0x19, 0x2f, 0x65, 0x71, 0x16, 0x3a, 0x3a, 0x17, 0x48, 0x44, 0x59, 0xa0, 0xfa, 0x59, 0x01,
	0x37, 0x9e, 0x24, 0x15, 0x35, 0x7c, 0xcf, 0x79, 0xda, 0xe8, 0xd7, 0xc9, 0x2d, 0xf2, 0x2c, 0x22,
	0x5c, 0xc0, 0x9b, 0xa0, 0xe8, 0x44, 0x5c, 0xd0, 0x2e, 0x61, 0xb6, 0x87, 0x55, 0xa5, 0xa2, 0xac,
	0x9d, 0xb3, 0x80, 0x74, 0x1d, 0x62, 0xd8, 0x04, 0xc5, 0x41, 0x7b, 0x5c, 0x2d, 0x54, 0xa6, 0xd6,
	0x8a, 0xf5, 0x9a, 0x36, 0xae, 0x23, 0xed, 0x4c, 0x42, 0x6b, 0x58, 0x05, 0xde, 0x02, 0x0b, 0x21,
	0x62, 0xc2, 0x43, 0xbe, 0x7d, 0x82, 0x3c, 0x3f, 0x62, 0x44, 0x9d, 0xaa, 0x28, 0x6b, 0xf3, 0xd6,
	0xc5, 0xcc, 0xbd, 0x9f, 0x7a, 0xab, 0x9f, 0x14, 0xb0, 0x32, 0xaa, 0x01, 0x1e, 0xd2, 0x80, 0x13,
	0xb8, 0x0f, 0x16, 0xcf, 0x68, 0xd9, 0x84, 0x31, 0xca, 0x92, 0x5e, 0x8a, 0x75, 0x28, 0x4b, 0x65,
	0xa1, 0xa3, 0x35, 0x93, 0xe1, 0x58, 0x57, 0x7e, 0xcf, 0xb2, 0x17, 0xc3, 0xe1, 0x23, 0x30, 0xc7,
	0x08, 0x8f, 0x7c, 0x21, 0x9b, 0xdc, 0xf8, 0xfb, 0x26, 0x13, 0xbe, 0x25, 0x75, 0xaa, 0xef, 0xa7,
	0xc1, 0xc2, 0x19, 0x08, 0xac, 0x83, 0x19, 0xd7, 0xf1, 0xb3, 0x51, 0x17, 0xeb, 0xcb, 0x32, 0x89,
	0xfc, 0xb6, 0x5a, 0x53, 0x30, 0x2f, 0x70, 0x5b, 0xc8, 0x8f, 0x88, 0x95, 0x42, 0xe1, 0x21, 0xb8,
	0x3c, 0xb4, 0x62, 0xc8, 0x89, 0x77, 0x43, 0x2d, 0x4c, 0xc0, 0xbf, 0x34, 0xa0, 0x99, 0x09, 0x0b,
	0x3e, 0x04, 0x57, 0x87, 0xa4, 0x30, 0x12, 0xc4, 0x16, 0x5e, 0x37, 0x1d, 0xff, 0x38, 0x35, 0x38,
	0x60, 0xee, 0x22, 0x41, 0x1e, 0x7b, 0x5d, 0x02, 0x0f, 0xc0, 0x50, 0x0e, 0xbb, 0x17, 0xe3, 0xd4,
	0xe9, 0x11, 0x5a, 0xbb, 0x34, 0xea, 0xf8, 0x24, 0xd5, 0x5a, 0x18, 0xb0, 0x12, 0x07, 0x34, 0xc1,
	0x05, 0x27, 0x62, 0x8c, 0x04, 0xce, 0x4b, 0xdb, 0xa1, 0x98, 0xa8, 0x33, 0x13, 0x54, 0x74, 0x5e,
	0x52, 0x1a, 0x14, 0x13, 0xb8, 0x01, 0xe6, 0x29, 0xc3, 0xe9, 0x22, 0xcf, 0x4e, 0xc0, 0x9e, 0x4b,
	0xd0, 0x87, 0x18, 0x46, 0x60, 0x89, 0xbc, 0x10, 0x84, 0x05, 0xc8, 0xb7, 0x91, 0x10, 0xcc, 0xeb,
	0x44, 0x22, 0x1b, 0x0f, 0x52, 0xe7, 0x12, 0xa5, 0xcd, 0xf1, 0xcb, 0xb0, 0x97, 0x49, 0x98, 0x03,
	0x85, 0x5d, 0x24, 0x90, 0x55, 0x22, 0xf9, 0x81, 0xea, 0xa9, 0x02, 0x4a, 0x23, 0x48, 0xb0, 0x0d,
	0xae, 0xe7, 0x96, 0xe4, 0x30, 0x82, 0x3d, 0x31, 0x72, 0x79, 0x86, 0x47, 0xbc, 0x94, 0x93, 0xb7,
	0x91, 0xd0, 0xe1, 0x31, 0x28, 0xe7, 0xaa, 0x77, 0x29, 0x26, 0xfe, 0x44, 0x9b, 0xa5, 0xe6, 0x88,
	0x3f, 0x88, 0xd9, 0xd5, 0xef, 0x0a, 0x58, 0xcc, 0xfd, 0x5f, 0xfc, 0x67, 0xab, 0x5f, 0xff, 0xa9,
	0x80, 0xd2, 0xa0, 0xc7, 0xf4, 0x4a, 0x35, 0xd3, 0x65, 0x80, 0x5f, 0x15, 0x70, 0x2d, 0xff, 0x6e,
	0xc1, 0xad, 0xf1, 0x9b, 0xf4, 0xc7, 0x93, 0x5d, 0xde, 0xfe, 0x77, 0x81, 0xf4, 0x64, 0x56, 0xb7,
	0xde, 0x9c, 0x7e, 0x7b, 0x57, 0xd8, 0xac, 0xde, 0x89, 0x5f, 0x31, 0x79, 0xeb, 0xb9, 0xfe, 0x6a,
	0xe8, 0x25, 0xb8, 0xb7, 0xfe, 0xda, 0x88, 0x72, 0x55, 0x0c, 0x65, 0x7d, 0xe7, 0x6d, 0x01, 0xac,
	0x3a, 0xb4, 0x3b, 0xb6, 0x90, 0x9d, 0xe5, 0x11, 0x03, 0x3a, 0x8a, 0x87, 0x7c, 0xa4, 0x1c, 0xdf,
	0xcf, 0x14, 0x5c, 0xea, 0xa3, 0xc0, 0xd5, 0x28, 0x73, 0x75, 0x97, 0x04, 0xc9, 0x27, 0x90, 0x6f,
	0x6d, 0xe8, 0xf1, 0xd1, 0x4f, 0xef, 0x5d, 0x69, 0x7c, 0x28, 0x4c, 0x1d, 0x98, 0xe6, 0xc7, 0x42,
	0xe5, 0x20, 0x15, 0x34, 0x31, 0xd7, 0x52, 0x33, 0xb6, 0x5a, 0x35, 0x2d, 0x4b, 0xcc, 0xbf, 0x48,
	0x48, 0xdb, 0xc4, 0xbc, 0xdd, 0x87, 0xb4, 0x5b, 0xb5, 0xb6, 0x84, 0xfc, 0x28, 0xac, 0xa6, 0x7e,
	0xc3, 0x30, 0x31, 0x37, 0x8c, 0x3e, 0xc8, 0x30, 0x5a, 0x35, 0xc3, 0x90, 0xb0, 0xce, 0x6c, 0x52,
	0xe7, 0xed, 0x5f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x96, 0x31, 0xec, 0xf5, 0x21, 0x08, 0x00, 0x00,
}
