// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/common.proto

package talent // import "google.golang.org/genproto/googleapis/cloud/talent/v4beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import latlng "google.golang.org/genproto/googleapis/type/latlng"
import money "google.golang.org/genproto/googleapis/type/money"
import postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An enum that represents the size of the company.
type CompanySize int32

const (
	// Default value if the size isn't specified.
	CompanySize_COMPANY_SIZE_UNSPECIFIED CompanySize = 0
	// The company has less than 50 employees.
	CompanySize_MINI CompanySize = 1
	// The company has between 50 and 99 employees.
	CompanySize_SMALL CompanySize = 2
	// The company has between 100 and 499 employees.
	CompanySize_SMEDIUM CompanySize = 3
	// The company has between 500 and 999 employees.
	CompanySize_MEDIUM CompanySize = 4
	// The company has between 1,000 and 4,999 employees.
	CompanySize_BIG CompanySize = 5
	// The company has between 5,000 and 9,999 employees.
	CompanySize_BIGGER CompanySize = 6
	// The company has 10,000 or more employees.
	CompanySize_GIANT CompanySize = 7
)

var CompanySize_name = map[int32]string{
	0: "COMPANY_SIZE_UNSPECIFIED",
	1: "MINI",
	2: "SMALL",
	3: "SMEDIUM",
	4: "MEDIUM",
	5: "BIG",
	6: "BIGGER",
	7: "GIANT",
}
var CompanySize_value = map[string]int32{
	"COMPANY_SIZE_UNSPECIFIED": 0,
	"MINI":                     1,
	"SMALL":                    2,
	"SMEDIUM":                  3,
	"MEDIUM":                   4,
	"BIG":                      5,
	"BIGGER":                   6,
	"GIANT":                    7,
}

func (x CompanySize) String() string {
	return proto.EnumName(CompanySize_name, int32(x))
}
func (CompanySize) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{0}
}

// An enum that represents employee benefits included with the job.
type JobBenefit int32

const (
	// Default value if the type isn't specified.
	JobBenefit_JOB_BENEFIT_UNSPECIFIED JobBenefit = 0
	// The job includes access to programs that support child care, such
	// as daycare.
	JobBenefit_CHILD_CARE JobBenefit = 1
	// The job includes dental services covered by a dental
	// insurance plan.
	JobBenefit_DENTAL JobBenefit = 2
	// The job offers specific benefits to domestic partners.
	JobBenefit_DOMESTIC_PARTNER JobBenefit = 3
	// The job allows for a flexible work schedule.
	JobBenefit_FLEXIBLE_HOURS JobBenefit = 4
	// The job includes health services covered by a medical insurance plan.
	JobBenefit_MEDICAL JobBenefit = 5
	// The job includes a life insurance plan provided by the employer or
	// available for purchase by the employee.
	JobBenefit_LIFE_INSURANCE JobBenefit = 6
	// The job allows for a leave of absence to a parent to care for a newborn
	// child.
	JobBenefit_PARENTAL_LEAVE JobBenefit = 7
	// The job includes a workplace retirement plan provided by the
	// employer or available for purchase by the employee.
	JobBenefit_RETIREMENT_PLAN JobBenefit = 8
	// The job allows for paid time off due to illness.
	JobBenefit_SICK_DAYS JobBenefit = 9
	// The job includes paid time off for vacation.
	JobBenefit_VACATION JobBenefit = 10
	// The job includes vision services covered by a vision
	// insurance plan.
	JobBenefit_VISION JobBenefit = 11
)

var JobBenefit_name = map[int32]string{
	0:  "JOB_BENEFIT_UNSPECIFIED",
	1:  "CHILD_CARE",
	2:  "DENTAL",
	3:  "DOMESTIC_PARTNER",
	4:  "FLEXIBLE_HOURS",
	5:  "MEDICAL",
	6:  "LIFE_INSURANCE",
	7:  "PARENTAL_LEAVE",
	8:  "RETIREMENT_PLAN",
	9:  "SICK_DAYS",
	10: "VACATION",
	11: "VISION",
}
var JobBenefit_value = map[string]int32{
	"JOB_BENEFIT_UNSPECIFIED": 0,
	"CHILD_CARE":              1,
	"DENTAL":                  2,
	"DOMESTIC_PARTNER":        3,
	"FLEXIBLE_HOURS":          4,
	"MEDICAL":                 5,
	"LIFE_INSURANCE":          6,
	"PARENTAL_LEAVE":          7,
	"RETIREMENT_PLAN":         8,
	"SICK_DAYS":               9,
	"VACATION":                10,
	"VISION":                  11,
}

func (x JobBenefit) String() string {
	return proto.EnumName(JobBenefit_name, int32(x))
}
func (JobBenefit) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{1}
}

// Educational degree level defined in International Standard Classification
// of Education (ISCED).
type DegreeType int32

const (
	// Default value. Represents no degree, or early childhood education.
	// Maps to ISCED code 0.
	// Ex) Kindergarten
	DegreeType_DEGREE_TYPE_UNSPECIFIED DegreeType = 0
	// Primary education which is typically the first stage of compulsory
	// education. ISCED code 1.
	// Ex) Elementary school
	DegreeType_PRIMARY_EDUCATION DegreeType = 1
	// Lower secondary education; First stage of secondary education building on
	// primary education, typically with a more subject-oriented curriculum.
	// ISCED code 2.
	// Ex) Middle school
	DegreeType_LOWER_SECONDARY_EDUCATION DegreeType = 2
	// Middle education; Second/final stage of secondary education preparing for
	// tertiary education and/or providing skills relevant to employment.
	// Usually with an increased range of subject options and streams. ISCED
	// code 3.
	// Ex) High school
	DegreeType_UPPER_SECONDARY_EDUCATION DegreeType = 3
	// Adult Remedial Education; Programmes providing learning experiences that
	// build on secondary education and prepare for labour market entry and/or
	// tertiary education. The content is broader than secondary but not as
	// complex as tertiary education. ISCED code 4.
	DegreeType_ADULT_REMEDIAL_EDUCATION DegreeType = 4
	// Associate's or equivalent; Short first tertiary programmes that are
	// typically practically-based, occupationally-specific and prepare for
	// labour market entry. These programmes may also provide a pathway to other
	// tertiary programmes. ISCED code 5.
	DegreeType_ASSOCIATES_OR_EQUIVALENT DegreeType = 5
	// Bachelor's or equivalent; Programmes designed to provide intermediate
	// academic and/or professional knowledge, skills and competencies leading
	// to a first tertiary degree or equivalent qualification. ISCED code 6.
	DegreeType_BACHELORS_OR_EQUIVALENT DegreeType = 6
	// Master's or equivalent; Programmes designed to provide advanced academic
	// and/or professional knowledge, skills and competencies leading to a
	// second tertiary degree or equivalent qualification. ISCED code 7.
	DegreeType_MASTERS_OR_EQUIVALENT DegreeType = 7
	// Doctoral or equivalent; Programmes designed primarily to lead to an
	// advanced research qualification, usually concluding with the submission
	// and defense of a substantive dissertation of publishable quality based on
	// original research. ISCED code 8.
	DegreeType_DOCTORAL_OR_EQUIVALENT DegreeType = 8
)

var DegreeType_name = map[int32]string{
	0: "DEGREE_TYPE_UNSPECIFIED",
	1: "PRIMARY_EDUCATION",
	2: "LOWER_SECONDARY_EDUCATION",
	3: "UPPER_SECONDARY_EDUCATION",
	4: "ADULT_REMEDIAL_EDUCATION",
	5: "ASSOCIATES_OR_EQUIVALENT",
	6: "BACHELORS_OR_EQUIVALENT",
	7: "MASTERS_OR_EQUIVALENT",
	8: "DOCTORAL_OR_EQUIVALENT",
}
var DegreeType_value = map[string]int32{
	"DEGREE_TYPE_UNSPECIFIED":   0,
	"PRIMARY_EDUCATION":         1,
	"LOWER_SECONDARY_EDUCATION": 2,
	"UPPER_SECONDARY_EDUCATION": 3,
	"ADULT_REMEDIAL_EDUCATION":  4,
	"ASSOCIATES_OR_EQUIVALENT":  5,
	"BACHELORS_OR_EQUIVALENT":   6,
	"MASTERS_OR_EQUIVALENT":     7,
	"DOCTORAL_OR_EQUIVALENT":    8,
}

func (x DegreeType) String() string {
	return proto.EnumName(DegreeType_name, int32(x))
}
func (DegreeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{2}
}

// An enum that represents the employment type of a job.
type EmploymentType int32

const (
	// The default value if the employment type isn't specified.
	EmploymentType_EMPLOYMENT_TYPE_UNSPECIFIED EmploymentType = 0
	// The job requires working a number of hours that constitute full
	// time employment, typically 40 or more hours per week.
	EmploymentType_FULL_TIME EmploymentType = 1
	// The job entails working fewer hours than a full time job,
	// typically less than 40 hours a week.
	EmploymentType_PART_TIME EmploymentType = 2
	// The job is offered as a contracted, as opposed to a salaried employee,
	// position.
	EmploymentType_CONTRACTOR EmploymentType = 3
	// The job is offered as a contracted position with the understanding
	// that it's converted into a full-time position at the end of the
	// contract. Jobs of this type are also returned by a search for
	// [EmploymentType.CONTRACTOR][google.cloud.talent.v4beta1.EmploymentType.CONTRACTOR]
	// jobs.
	EmploymentType_CONTRACT_TO_HIRE EmploymentType = 4
	// The job is offered as a temporary employment opportunity, usually
	// a short-term engagement.
	EmploymentType_TEMPORARY EmploymentType = 5
	// The job is a fixed-term opportunity for students or entry-level job
	// seekers to obtain on-the-job training, typically offered as a summer
	// position.
	EmploymentType_INTERN EmploymentType = 6
	// The is an opportunity for an individual to volunteer, where there's no
	// expectation of compensation for the provided services.
	EmploymentType_VOLUNTEER EmploymentType = 7
	// The job requires an employee to work on an as-needed basis with a
	// flexible schedule.
	EmploymentType_PER_DIEM EmploymentType = 8
	// The job involves employing people in remote areas and flying them
	// temporarily to the work site instead of relocating employees and their
	// families permanently.
	EmploymentType_FLY_IN_FLY_OUT EmploymentType = 9
	// The job does not fit any of the other listed types.
	EmploymentType_OTHER_EMPLOYMENT_TYPE EmploymentType = 10
)

var EmploymentType_name = map[int32]string{
	0:  "EMPLOYMENT_TYPE_UNSPECIFIED",
	1:  "FULL_TIME",
	2:  "PART_TIME",
	3:  "CONTRACTOR",
	4:  "CONTRACT_TO_HIRE",
	5:  "TEMPORARY",
	6:  "INTERN",
	7:  "VOLUNTEER",
	8:  "PER_DIEM",
	9:  "FLY_IN_FLY_OUT",
	10: "OTHER_EMPLOYMENT_TYPE",
}
var EmploymentType_value = map[string]int32{
	"EMPLOYMENT_TYPE_UNSPECIFIED": 0,
	"FULL_TIME":                   1,
	"PART_TIME":                   2,
	"CONTRACTOR":                  3,
	"CONTRACT_TO_HIRE":            4,
	"TEMPORARY":                   5,
	"INTERN":                      6,
	"VOLUNTEER":                   7,
	"PER_DIEM":                    8,
	"FLY_IN_FLY_OUT":              9,
	"OTHER_EMPLOYMENT_TYPE":       10,
}

func (x EmploymentType) String() string {
	return proto.EnumName(EmploymentType_name, int32(x))
}
func (EmploymentType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{3}
}

// An enum that represents the required experience level required for the job.
type JobLevel int32

const (
	// The default value if the level isn't specified.
	JobLevel_JOB_LEVEL_UNSPECIFIED JobLevel = 0
	// Entry-level individual contributors, typically with less than 2 years of
	// experience in a similar role. Includes interns.
	JobLevel_ENTRY_LEVEL JobLevel = 1
	// Experienced individual contributors, typically with 2+ years of
	// experience in a similar role.
	JobLevel_EXPERIENCED JobLevel = 2
	// Entry- to mid-level managers responsible for managing a team of people.
	JobLevel_MANAGER JobLevel = 3
	// Senior-level managers responsible for managing teams of managers.
	JobLevel_DIRECTOR JobLevel = 4
	// Executive-level managers and above, including C-level positions.
	JobLevel_EXECUTIVE JobLevel = 5
)

var JobLevel_name = map[int32]string{
	0: "JOB_LEVEL_UNSPECIFIED",
	1: "ENTRY_LEVEL",
	2: "EXPERIENCED",
	3: "MANAGER",
	4: "DIRECTOR",
	5: "EXECUTIVE",
}
var JobLevel_value = map[string]int32{
	"JOB_LEVEL_UNSPECIFIED": 0,
	"ENTRY_LEVEL":           1,
	"EXPERIENCED":           2,
	"MANAGER":               3,
	"DIRECTOR":              4,
	"EXECUTIVE":             5,
}

func (x JobLevel) String() string {
	return proto.EnumName(JobLevel_name, int32(x))
}
func (JobLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{4}
}

// An enum that represents the categorization or primary focus of specific
// role. This value is different than the "industry" associated with a role,
// which is related to the categorization of the company listing the job.
type JobCategory int32

const (
	// The default value if the category isn't specified.
	JobCategory_JOB_CATEGORY_UNSPECIFIED JobCategory = 0
	// An accounting and finance job, such as an Accountant.
	JobCategory_ACCOUNTING_AND_FINANCE JobCategory = 1
	// An administrative and office job, such as an Administrative Assistant.
	JobCategory_ADMINISTRATIVE_AND_OFFICE JobCategory = 2
	// An advertising and marketing job, such as Marketing Manager.
	JobCategory_ADVERTISING_AND_MARKETING JobCategory = 3
	// An animal care job, such as Veterinarian.
	JobCategory_ANIMAL_CARE JobCategory = 4
	// An art, fashion, or design job, such as Designer.
	JobCategory_ART_FASHION_AND_DESIGN JobCategory = 5
	// A business operations job, such as Business Operations Manager.
	JobCategory_BUSINESS_OPERATIONS JobCategory = 6
	// A cleaning and facilities job, such as Custodial Staff.
	JobCategory_CLEANING_AND_FACILITIES JobCategory = 7
	// A computer and IT job, such as Systems Administrator.
	JobCategory_COMPUTER_AND_IT JobCategory = 8
	// A construction job, such as General Laborer.
	JobCategory_CONSTRUCTION JobCategory = 9
	// A customer service job, such s Cashier.
	JobCategory_CUSTOMER_SERVICE JobCategory = 10
	// An education job, such as School Teacher.
	JobCategory_EDUCATION JobCategory = 11
	// An entertainment and travel job, such as Flight Attendant.
	JobCategory_ENTERTAINMENT_AND_TRAVEL JobCategory = 12
	// A farming or outdoor job, such as Park Ranger.
	JobCategory_FARMING_AND_OUTDOORS JobCategory = 13
	// A healthcare job, such as Registered Nurse.
	JobCategory_HEALTHCARE JobCategory = 14
	// A human resources job, such as Human Resources Director.
	JobCategory_HUMAN_RESOURCES JobCategory = 15
	// An installation, maintenance, or repair job, such as Electrician.
	JobCategory_INSTALLATION_MAINTENANCE_AND_REPAIR JobCategory = 16
	// A legal job, such as Law Clerk.
	JobCategory_LEGAL JobCategory = 17
	// A management job, often used in conjunction with another category,
	// such as Store Manager.
	JobCategory_MANAGEMENT JobCategory = 18
	// A manufacturing or warehouse job, such as Assembly Technician.
	JobCategory_MANUFACTURING_AND_WAREHOUSE JobCategory = 19
	// A media, communications, or writing job, such as Media Relations.
	JobCategory_MEDIA_COMMUNICATIONS_AND_WRITING JobCategory = 20
	// An oil, gas or mining job, such as Offshore Driller.
	JobCategory_OIL_GAS_AND_MINING JobCategory = 21
	// A personal care and services job, such as Hair Stylist.
	JobCategory_PERSONAL_CARE_AND_SERVICES JobCategory = 22
	// A protective services job, such as Security Guard.
	JobCategory_PROTECTIVE_SERVICES JobCategory = 23
	// A real estate job, such as Buyer's Agent.
	JobCategory_REAL_ESTATE JobCategory = 24
	// A restaurant and hospitality job, such as Restaurant Server.
	JobCategory_RESTAURANT_AND_HOSPITALITY JobCategory = 25
	// A sales and/or retail job, such Sales Associate.
	JobCategory_SALES_AND_RETAIL JobCategory = 26
	// A science and engineering job, such as Lab Technician.
	JobCategory_SCIENCE_AND_ENGINEERING JobCategory = 27
	// A social services or non-profit job, such as Case Worker.
	JobCategory_SOCIAL_SERVICES_AND_NON_PROFIT JobCategory = 28
	// A sports, fitness, or recreation job, such as Personal Trainer.
	JobCategory_SPORTS_FITNESS_AND_RECREATION JobCategory = 29
	// A transportation or logistics job, such as Truck Driver.
	JobCategory_TRANSPORTATION_AND_LOGISTICS JobCategory = 30
)

var JobCategory_name = map[int32]string{
	0:  "JOB_CATEGORY_UNSPECIFIED",
	1:  "ACCOUNTING_AND_FINANCE",
	2:  "ADMINISTRATIVE_AND_OFFICE",
	3:  "ADVERTISING_AND_MARKETING",
	4:  "ANIMAL_CARE",
	5:  "ART_FASHION_AND_DESIGN",
	6:  "BUSINESS_OPERATIONS",
	7:  "CLEANING_AND_FACILITIES",
	8:  "COMPUTER_AND_IT",
	9:  "CONSTRUCTION",
	10: "CUSTOMER_SERVICE",
	11: "EDUCATION",
	12: "ENTERTAINMENT_AND_TRAVEL",
	13: "FARMING_AND_OUTDOORS",
	14: "HEALTHCARE",
	15: "HUMAN_RESOURCES",
	16: "INSTALLATION_MAINTENANCE_AND_REPAIR",
	17: "LEGAL",
	18: "MANAGEMENT",
	19: "MANUFACTURING_AND_WAREHOUSE",
	20: "MEDIA_COMMUNICATIONS_AND_WRITING",
	21: "OIL_GAS_AND_MINING",
	22: "PERSONAL_CARE_AND_SERVICES",
	23: "PROTECTIVE_SERVICES",
	24: "REAL_ESTATE",
	25: "RESTAURANT_AND_HOSPITALITY",
	26: "SALES_AND_RETAIL",
	27: "SCIENCE_AND_ENGINEERING",
	28: "SOCIAL_SERVICES_AND_NON_PROFIT",
	29: "SPORTS_FITNESS_AND_RECREATION",
	30: "TRANSPORTATION_AND_LOGISTICS",
}
var JobCategory_value = map[string]int32{
	"JOB_CATEGORY_UNSPECIFIED":            0,
	"ACCOUNTING_AND_FINANCE":              1,
	"ADMINISTRATIVE_AND_OFFICE":           2,
	"ADVERTISING_AND_MARKETING":           3,
	"ANIMAL_CARE":                         4,
	"ART_FASHION_AND_DESIGN":              5,
	"BUSINESS_OPERATIONS":                 6,
	"CLEANING_AND_FACILITIES":             7,
	"COMPUTER_AND_IT":                     8,
	"CONSTRUCTION":                        9,
	"CUSTOMER_SERVICE":                    10,
	"EDUCATION":                           11,
	"ENTERTAINMENT_AND_TRAVEL":            12,
	"FARMING_AND_OUTDOORS":                13,
	"HEALTHCARE":                          14,
	"HUMAN_RESOURCES":                     15,
	"INSTALLATION_MAINTENANCE_AND_REPAIR": 16,
	"LEGAL":                               17,
	"MANAGEMENT":                          18,
	"MANUFACTURING_AND_WAREHOUSE":         19,
	"MEDIA_COMMUNICATIONS_AND_WRITING":    20,
	"OIL_GAS_AND_MINING":                  21,
	"PERSONAL_CARE_AND_SERVICES":          22,
	"PROTECTIVE_SERVICES":                 23,
	"REAL_ESTATE":                         24,
	"RESTAURANT_AND_HOSPITALITY":          25,
	"SALES_AND_RETAIL":                    26,
	"SCIENCE_AND_ENGINEERING":             27,
	"SOCIAL_SERVICES_AND_NON_PROFIT":      28,
	"SPORTS_FITNESS_AND_RECREATION":       29,
	"TRANSPORTATION_AND_LOGISTICS":        30,
}

func (x JobCategory) String() string {
	return proto.EnumName(JobCategory_name, int32(x))
}
func (JobCategory) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{5}
}

// An enum that represents the job posting region. In most cases, job postings
// don't need to specify a region. If a region is given, jobs are
// eligible for searches in the specified region.
type PostingRegion int32

const (
	// If the region is unspecified, the job is only returned if it
	// matches the [LocationFilter][google.cloud.talent.v4beta1.LocationFilter].
	PostingRegion_POSTING_REGION_UNSPECIFIED PostingRegion = 0
	// In addition to exact location matching, job posting is returned when the
	// [LocationFilter][google.cloud.talent.v4beta1.LocationFilter] in the search
	// query is in the same administrative area as the returned job posting. For
	// example, if a `ADMINISTRATIVE_AREA` job is posted in "CA, USA", it's
	// returned if [LocationFilter][google.cloud.talent.v4beta1.LocationFilter]
	// has "Mountain View".
	//
	// Administrative area refers to top-level administrative subdivision of this
	// country. For example, US state, IT region, UK constituent nation and
	// JP prefecture.
	PostingRegion_ADMINISTRATIVE_AREA PostingRegion = 1
	// In addition to exact location matching, job is returned when
	// [LocationFilter][google.cloud.talent.v4beta1.LocationFilter] in search
	// query is in the same country as this job. For example, if a `NATION_WIDE`
	// job is posted in "USA", it's returned if
	// [LocationFilter][google.cloud.talent.v4beta1.LocationFilter] has 'Mountain
	// View'.
	PostingRegion_NATION PostingRegion = 2
	// Job allows employees to work remotely (telecommute).
	// If [locations][] are provided with this value, the job is
	// considered as having a location, but telecommuting is allowed.
	PostingRegion_TELECOMMUTE PostingRegion = 3
)

var PostingRegion_name = map[int32]string{
	0: "POSTING_REGION_UNSPECIFIED",
	1: "ADMINISTRATIVE_AREA",
	2: "NATION",
	3: "TELECOMMUTE",
}
var PostingRegion_value = map[string]int32{
	"POSTING_REGION_UNSPECIFIED": 0,
	"ADMINISTRATIVE_AREA":        1,
	"NATION":                     2,
	"TELECOMMUTE":                3,
}

func (x PostingRegion) String() string {
	return proto.EnumName(PostingRegion_name, int32(x))
}
func (PostingRegion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{6}
}

// An enum that represents who has view access to the resource.
type Visibility int32

const (
	// Default value.
	Visibility_VISIBILITY_UNSPECIFIED Visibility = 0
	// The resource is only visible to the GCP account who owns it.
	Visibility_ACCOUNT_ONLY Visibility = 1
	// The resource is visible to the owner and may be visible to other
	// applications and processes at Google.
	Visibility_SHARED_WITH_GOOGLE Visibility = 2
	// The resource is visible to the owner and may be visible to all other API
	// clients.
	Visibility_SHARED_WITH_PUBLIC Visibility = 3
)

var Visibility_name = map[int32]string{
	0: "VISIBILITY_UNSPECIFIED",
	1: "ACCOUNT_ONLY",
	2: "SHARED_WITH_GOOGLE",
	3: "SHARED_WITH_PUBLIC",
}
var Visibility_value = map[string]int32{
	"VISIBILITY_UNSPECIFIED": 0,
	"ACCOUNT_ONLY":           1,
	"SHARED_WITH_GOOGLE":     2,
	"SHARED_WITH_PUBLIC":     3,
}

func (x Visibility) String() string {
	return proto.EnumName(Visibility_name, int32(x))
}
func (Visibility) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{7}
}

// Enum that represents the usage of the contact information.
type ContactInfoUsage int32

const (
	// Default value.
	ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED ContactInfoUsage = 0
	// Personal use.
	ContactInfoUsage_PERSONAL ContactInfoUsage = 1
	// Work use.
	ContactInfoUsage_WORK ContactInfoUsage = 2
	// School use.
	ContactInfoUsage_SCHOOL ContactInfoUsage = 3
)

var ContactInfoUsage_name = map[int32]string{
	0: "CONTACT_INFO_USAGE_UNSPECIFIED",
	1: "PERSONAL",
	2: "WORK",
	3: "SCHOOL",
}
var ContactInfoUsage_value = map[string]int32{
	"CONTACT_INFO_USAGE_UNSPECIFIED": 0,
	"PERSONAL":                       1,
	"WORK":                           2,
	"SCHOOL":                         3,
}

func (x ContactInfoUsage) String() string {
	return proto.EnumName(ContactInfoUsage_name, int32(x))
}
func (ContactInfoUsage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{8}
}

// Input only.
//
// Option for HTML content sanitization on user input fields, for example, job
// description. By setting this option, user can determine whether and how
// sanitization is performed on these fields.
type HtmlSanitization int32

const (
	// Default value.
	HtmlSanitization_HTML_SANITIZATION_UNSPECIFIED HtmlSanitization = 0
	// Disables sanitization on HTML input.
	HtmlSanitization_HTML_SANITIZATION_DISABLED HtmlSanitization = 1
	// Sanitizes HTML input, only accepts bold, italic, ordered list, and
	// unordered list markup tags.
	HtmlSanitization_SIMPLE_FORMATTING_ONLY HtmlSanitization = 2
)

var HtmlSanitization_name = map[int32]string{
	0: "HTML_SANITIZATION_UNSPECIFIED",
	1: "HTML_SANITIZATION_DISABLED",
	2: "SIMPLE_FORMATTING_ONLY",
}
var HtmlSanitization_value = map[string]int32{
	"HTML_SANITIZATION_UNSPECIFIED": 0,
	"HTML_SANITIZATION_DISABLED":    1,
	"SIMPLE_FORMATTING_ONLY":        2,
}

func (x HtmlSanitization) String() string {
	return proto.EnumName(HtmlSanitization_name, int32(x))
}
func (HtmlSanitization) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{9}
}

// Method for commute.
type CommuteMethod int32

const (
	// Commute method isn't specified.
	CommuteMethod_COMMUTE_METHOD_UNSPECIFIED CommuteMethod = 0
	// Commute time is calculated based on driving time.
	CommuteMethod_DRIVING CommuteMethod = 1
	// Commute time is calculated based on public transit including bus, metro,
	// subway, etc.
	CommuteMethod_TRANSIT CommuteMethod = 2
	// Commute time is calculated based on walking time.
	CommuteMethod_WALKING CommuteMethod = 3
	// Commute time is calculated based on biking time.
	CommuteMethod_CYCLING CommuteMethod = 4
	// Commute time is calculated based on public transit that is wheelchair
	// accessible.
	CommuteMethod_TRANSIT_ACCESSIBLE CommuteMethod = 5
)

var CommuteMethod_name = map[int32]string{
	0: "COMMUTE_METHOD_UNSPECIFIED",
	1: "DRIVING",
	2: "TRANSIT",
	3: "WALKING",
	4: "CYCLING",
	5: "TRANSIT_ACCESSIBLE",
}
var CommuteMethod_value = map[string]int32{
	"COMMUTE_METHOD_UNSPECIFIED": 0,
	"DRIVING":                    1,
	"TRANSIT":                    2,
	"WALKING":                    3,
	"CYCLING":                    4,
	"TRANSIT_ACCESSIBLE":         5,
}

func (x CommuteMethod) String() string {
	return proto.EnumName(CommuteMethod_name, int32(x))
}
func (CommuteMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{10}
}

// An enum which represents the type of a location.
type Location_LocationType int32

const (
	// Default value if the type isn't specified.
	Location_LOCATION_TYPE_UNSPECIFIED Location_LocationType = 0
	// A country level location.
	Location_COUNTRY Location_LocationType = 1
	// A state or equivalent level location.
	Location_ADMINISTRATIVE_AREA Location_LocationType = 2
	// A county or equivalent level location.
	Location_SUB_ADMINISTRATIVE_AREA Location_LocationType = 3
	// A city or equivalent level location.
	Location_LOCALITY Location_LocationType = 4
	// A postal code level location.
	Location_POSTAL_CODE Location_LocationType = 5
	// A sublocality is a subdivision of a locality, for example a city borough,
	// ward, or arrondissement. Sublocalities are usually recognized by a local
	// political authority. For example, Manhattan and Brooklyn are recognized
	// as boroughs by the City of New York, and are therefore modeled as
	// sublocalities.
	Location_SUB_LOCALITY Location_LocationType = 6
	// A district or equivalent level location.
	Location_SUB_LOCALITY_1 Location_LocationType = 7
	// A smaller district or equivalent level display.
	Location_SUB_LOCALITY_2 Location_LocationType = 8
	// A neighborhood level location.
	Location_NEIGHBORHOOD Location_LocationType = 9
	// A street address level location.
	Location_STREET_ADDRESS Location_LocationType = 10
)

var Location_LocationType_name = map[int32]string{
	0:  "LOCATION_TYPE_UNSPECIFIED",
	1:  "COUNTRY",
	2:  "ADMINISTRATIVE_AREA",
	3:  "SUB_ADMINISTRATIVE_AREA",
	4:  "LOCALITY",
	5:  "POSTAL_CODE",
	6:  "SUB_LOCALITY",
	7:  "SUB_LOCALITY_1",
	8:  "SUB_LOCALITY_2",
	9:  "NEIGHBORHOOD",
	10: "STREET_ADDRESS",
}
var Location_LocationType_value = map[string]int32{
	"LOCATION_TYPE_UNSPECIFIED": 0,
	"COUNTRY":                   1,
	"ADMINISTRATIVE_AREA":       2,
	"SUB_ADMINISTRATIVE_AREA":   3,
	"LOCALITY":                  4,
	"POSTAL_CODE":               5,
	"SUB_LOCALITY":              6,
	"SUB_LOCALITY_1":            7,
	"SUB_LOCALITY_2":            8,
	"NEIGHBORHOOD":              9,
	"STREET_ADDRESS":            10,
}

func (x Location_LocationType) String() string {
	return proto.EnumName(Location_LocationType_name, int32(x))
}
func (Location_LocationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{1, 0}
}

// An enumeration describing an API access portal and exposure mechanism.
type DeviceInfo_DeviceType int32

const (
	// The device type isn't specified.
	DeviceInfo_DEVICE_TYPE_UNSPECIFIED DeviceInfo_DeviceType = 0
	// A desktop web browser, such as, Chrome, Firefox, Safari, or Internet
	// Explorer)
	DeviceInfo_WEB DeviceInfo_DeviceType = 1
	// A mobile device web browser, such as a phone or tablet with a Chrome
	// browser.
	DeviceInfo_MOBILE_WEB DeviceInfo_DeviceType = 2
	// An Android device native application.
	DeviceInfo_ANDROID DeviceInfo_DeviceType = 3
	// An iOS device native application.
	DeviceInfo_IOS DeviceInfo_DeviceType = 4
	// A bot, as opposed to a device operated by human beings, such as a web
	// crawler.
	DeviceInfo_BOT DeviceInfo_DeviceType = 5
	// Other devices types.
	DeviceInfo_OTHER DeviceInfo_DeviceType = 6
)

var DeviceInfo_DeviceType_name = map[int32]string{
	0: "DEVICE_TYPE_UNSPECIFIED",
	1: "WEB",
	2: "MOBILE_WEB",
	3: "ANDROID",
	4: "IOS",
	5: "BOT",
	6: "OTHER",
}
var DeviceInfo_DeviceType_value = map[string]int32{
	"DEVICE_TYPE_UNSPECIFIED": 0,
	"WEB":                     1,
	"MOBILE_WEB":              2,
	"ANDROID":                 3,
	"IOS":                     4,
	"BOT":                     5,
	"OTHER":                   6,
}

func (x DeviceInfo_DeviceType) String() string {
	return proto.EnumName(DeviceInfo_DeviceType_name, int32(x))
}
func (DeviceInfo_DeviceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{4, 0}
}

// The type of compensation.
//
// For compensation amounts specified in non-monetary amounts,
// describe the compensation scheme in the
// [CompensationEntry.description][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.description].
//
// For example, tipping format is described in
// [CompensationEntry.description][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.description]
// (for example, "expect 15-20% tips based on customer bill.") and an estimate
// of the tips provided in
// [CompensationEntry.amount][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.amount]
// or
// [CompensationEntry.range][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.range]
// ($10 per hour).
//
// For example, equity is described in
// [CompensationEntry.description][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.description]
// (for example, "1% - 2% equity vesting over 4 years, 1 year cliff") and
// value estimated in
// [CompensationEntry.amount][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.amount]
// or
// [CompensationEntry.range][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.range].
// If no value estimate is possible, units are
// [CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED]
// and then further clarified in
// [CompensationEntry.description][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.description]
// field.
type CompensationInfo_CompensationType int32

const (
	// Default value.
	CompensationInfo_COMPENSATION_TYPE_UNSPECIFIED CompensationInfo_CompensationType = 0
	// Base compensation: Refers to the fixed amount of money paid to an
	// employee by an employer in return for work performed. Base compensation
	// does not include benefits, bonuses or any other potential compensation
	// from an employer.
	CompensationInfo_BASE CompensationInfo_CompensationType = 1
	// Bonus.
	CompensationInfo_BONUS CompensationInfo_CompensationType = 2
	// Signing bonus.
	CompensationInfo_SIGNING_BONUS CompensationInfo_CompensationType = 3
	// Equity.
	CompensationInfo_EQUITY CompensationInfo_CompensationType = 4
	// Profit sharing.
	CompensationInfo_PROFIT_SHARING CompensationInfo_CompensationType = 5
	// Commission.
	CompensationInfo_COMMISSIONS CompensationInfo_CompensationType = 6
	// Tips.
	CompensationInfo_TIPS CompensationInfo_CompensationType = 7
	// Other compensation type.
	CompensationInfo_OTHER_COMPENSATION_TYPE CompensationInfo_CompensationType = 8
)

var CompensationInfo_CompensationType_name = map[int32]string{
	0: "COMPENSATION_TYPE_UNSPECIFIED",
	1: "BASE",
	2: "BONUS",
	3: "SIGNING_BONUS",
	4: "EQUITY",
	5: "PROFIT_SHARING",
	6: "COMMISSIONS",
	7: "TIPS",
	8: "OTHER_COMPENSATION_TYPE",
}
var CompensationInfo_CompensationType_value = map[string]int32{
	"COMPENSATION_TYPE_UNSPECIFIED": 0,
	"BASE":                          1,
	"BONUS":                         2,
	"SIGNING_BONUS":                 3,
	"EQUITY":                        4,
	"PROFIT_SHARING":                5,
	"COMMISSIONS":                   6,
	"TIPS":                          7,
	"OTHER_COMPENSATION_TYPE":       8,
}

func (x CompensationInfo_CompensationType) String() string {
	return proto.EnumName(CompensationInfo_CompensationType_name, int32(x))
}
func (CompensationInfo_CompensationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{7, 0}
}

// Pay frequency.
type CompensationInfo_CompensationUnit int32

const (
	// Default value.
	CompensationInfo_COMPENSATION_UNIT_UNSPECIFIED CompensationInfo_CompensationUnit = 0
	// Hourly.
	CompensationInfo_HOURLY CompensationInfo_CompensationUnit = 1
	// Daily.
	CompensationInfo_DAILY CompensationInfo_CompensationUnit = 2
	// Weekly
	CompensationInfo_WEEKLY CompensationInfo_CompensationUnit = 3
	// Monthly.
	CompensationInfo_MONTHLY CompensationInfo_CompensationUnit = 4
	// Yearly.
	CompensationInfo_YEARLY CompensationInfo_CompensationUnit = 5
	// One time.
	CompensationInfo_ONE_TIME CompensationInfo_CompensationUnit = 6
	// Other compensation units.
	CompensationInfo_OTHER_COMPENSATION_UNIT CompensationInfo_CompensationUnit = 7
)

var CompensationInfo_CompensationUnit_name = map[int32]string{
	0: "COMPENSATION_UNIT_UNSPECIFIED",
	1: "HOURLY",
	2: "DAILY",
	3: "WEEKLY",
	4: "MONTHLY",
	5: "YEARLY",
	6: "ONE_TIME",
	7: "OTHER_COMPENSATION_UNIT",
}
var CompensationInfo_CompensationUnit_value = map[string]int32{
	"COMPENSATION_UNIT_UNSPECIFIED": 0,
	"HOURLY":                        1,
	"DAILY":                         2,
	"WEEKLY":                        3,
	"MONTHLY":                       4,
	"YEARLY":                        5,
	"ONE_TIME":                      6,
	"OTHER_COMPENSATION_UNIT":       7,
}

func (x CompensationInfo_CompensationUnit) String() string {
	return proto.EnumName(CompensationInfo_CompensationUnit_name, int32(x))
}
func (CompensationInfo_CompensationUnit) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{7, 1}
}

// Message representing a period of time between two timestamps.
type TimestampRange struct {
	// Begin of the period.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of the period.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimestampRange) Reset()         { *m = TimestampRange{} }
func (m *TimestampRange) String() string { return proto.CompactTextString(m) }
func (*TimestampRange) ProtoMessage()    {}
func (*TimestampRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{0}
}
func (m *TimestampRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampRange.Unmarshal(m, b)
}
func (m *TimestampRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampRange.Marshal(b, m, deterministic)
}
func (dst *TimestampRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampRange.Merge(dst, src)
}
func (m *TimestampRange) XXX_Size() int {
	return xxx_messageInfo_TimestampRange.Size(m)
}
func (m *TimestampRange) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampRange.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampRange proto.InternalMessageInfo

func (m *TimestampRange) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TimestampRange) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Output only.
//
// A resource that represents a location with full geographic information.
type Location struct {
	// The type of a location, which corresponds to the address lines field of
	// [PostalAddress][]. For example, "Downtown, Atlanta, GA, USA" has a type of
	// [LocationType#NEIGHBORHOOD][], and "Kansas City, KS, USA" has a type of
	// [LocationType#LOCALITY][].
	LocationType Location_LocationType `protobuf:"varint,1,opt,name=location_type,json=locationType,proto3,enum=google.cloud.talent.v4beta1.Location_LocationType" json:"location_type,omitempty"`
	// Postal address of the location that includes human readable information,
	// such as postal delivery and payments addresses. Given a postal address,
	// a postal service can deliver items to a premises, P.O. Box, or other
	// delivery location.
	PostalAddress *postaladdress.PostalAddress `protobuf:"bytes,2,opt,name=postal_address,json=postalAddress,proto3" json:"postal_address,omitempty"`
	// An object representing a latitude/longitude pair.
	LatLng *latlng.LatLng `protobuf:"bytes,3,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
	// Radius in miles of the job location. This value is derived from the
	// location bounding box in which a circle with the specified radius
	// centered from [LatLng][] covers the area associated with the job location.
	// For example, currently, "Mountain View, CA, USA" has a radius of
	// 6.17 miles.
	RadiusMiles          float64  `protobuf:"fixed64,4,opt,name=radius_miles,json=radiusMiles,proto3" json:"radius_miles,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Location) Reset()         { *m = Location{} }
func (m *Location) String() string { return proto.CompactTextString(m) }
func (*Location) ProtoMessage()    {}
func (*Location) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{1}
}
func (m *Location) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Location.Unmarshal(m, b)
}
func (m *Location) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Location.Marshal(b, m, deterministic)
}
func (dst *Location) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Location.Merge(dst, src)
}
func (m *Location) XXX_Size() int {
	return xxx_messageInfo_Location.Size(m)
}
func (m *Location) XXX_DiscardUnknown() {
	xxx_messageInfo_Location.DiscardUnknown(m)
}

var xxx_messageInfo_Location proto.InternalMessageInfo

func (m *Location) GetLocationType() Location_LocationType {
	if m != nil {
		return m.LocationType
	}
	return Location_LOCATION_TYPE_UNSPECIFIED
}

func (m *Location) GetPostalAddress() *postaladdress.PostalAddress {
	if m != nil {
		return m.PostalAddress
	}
	return nil
}

func (m *Location) GetLatLng() *latlng.LatLng {
	if m != nil {
		return m.LatLng
	}
	return nil
}

func (m *Location) GetRadiusMiles() float64 {
	if m != nil {
		return m.RadiusMiles
	}
	return 0
}

// Input only.
//
// Meta information related to the job searcher or entity
// conducting the job search. This information is used to improve the
// performance of the service.
type RequestMetadata struct {
	// Required if
	// [allow_missing_ids][google.cloud.talent.v4beta1.RequestMetadata.allow_missing_ids]
	// is unset or `false`.
	//
	// The client-defined scope or source of the service call, which typically
	// is the domain on
	// which the service has been implemented and is currently being run.
	//
	// For example, if the service is being run by client <em>Foo, Inc.</em>, on
	// job board www.foo.com and career site www.bar.com, then this field is
	// set to "foo.com" for use on the job board, and "bar.com" for use on the
	// career site.
	//
	// Note that any improvements to the model for a particular tenant site rely
	// on this field being set correctly to a unique domain.
	//
	// The maximum number of allowed characters is 255.
	Domain string `protobuf:"bytes,1,opt,name=domain,proto3" json:"domain,omitempty"`
	// Required if
	// [allow_missing_ids][google.cloud.talent.v4beta1.RequestMetadata.allow_missing_ids]
	// is unset or `false`.
	//
	// A unique session identification string. A session is defined as the
	// duration of an end user's interaction with the service over a certain
	// period.
	// Obfuscate this field for privacy concerns before
	// providing it to the service.
	//
	// Note that any improvements to the model for a particular tenant site rely
	// on this field being set correctly to a unique session ID.
	//
	// The maximum number of allowed characters is 255.
	SessionId string `protobuf:"bytes,2,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// Required if
	// [allow_missing_ids][google.cloud.talent.v4beta1.RequestMetadata.allow_missing_ids]
	// is unset or `false`.
	//
	// A unique user identification string, as determined by the client.
	// To have the strongest positive impact on search quality
	// make sure the client-level is unique.
	// Obfuscate this field for privacy concerns before
	// providing it to the service.
	//
	// Note that any improvements to the model for a particular tenant site rely
	// on this field being set correctly to a unique user ID.
	//
	// The maximum number of allowed characters is 255.
	UserId string `protobuf:"bytes,3,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Optional.
	//
	// If set to `true`,
	// [domain][google.cloud.talent.v4beta1.RequestMetadata.domain],
	// [session_id][google.cloud.talent.v4beta1.RequestMetadata.session_id] and
	// [user_id][google.cloud.talent.v4beta1.RequestMetadata.user_id] are
	// optional. Only set when any of these fields isn't available for some
	// reason. It is highly recommended not to set this field and provide accurate
	// [domain][google.cloud.talent.v4beta1.RequestMetadata.domain],
	// [session_id][google.cloud.talent.v4beta1.RequestMetadata.session_id] and
	// [user_id][google.cloud.talent.v4beta1.RequestMetadata.user_id] for the best
	// service experience.
	AllowMissingIds bool `protobuf:"varint,4,opt,name=allow_missing_ids,json=allowMissingIds,proto3" json:"allow_missing_ids,omitempty"`
	// Optional.
	//
	// The type of device used by the job seeker at the time of the call to the
	// service.
	DeviceInfo           *DeviceInfo `protobuf:"bytes,5,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RequestMetadata) Reset()         { *m = RequestMetadata{} }
func (m *RequestMetadata) String() string { return proto.CompactTextString(m) }
func (*RequestMetadata) ProtoMessage()    {}
func (*RequestMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{2}
}
func (m *RequestMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RequestMetadata.Unmarshal(m, b)
}
func (m *RequestMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RequestMetadata.Marshal(b, m, deterministic)
}
func (dst *RequestMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestMetadata.Merge(dst, src)
}
func (m *RequestMetadata) XXX_Size() int {
	return xxx_messageInfo_RequestMetadata.Size(m)
}
func (m *RequestMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RequestMetadata proto.InternalMessageInfo

func (m *RequestMetadata) GetDomain() string {
	if m != nil {
		return m.Domain
	}
	return ""
}

func (m *RequestMetadata) GetSessionId() string {
	if m != nil {
		return m.SessionId
	}
	return ""
}

func (m *RequestMetadata) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *RequestMetadata) GetAllowMissingIds() bool {
	if m != nil {
		return m.AllowMissingIds
	}
	return false
}

func (m *RequestMetadata) GetDeviceInfo() *DeviceInfo {
	if m != nil {
		return m.DeviceInfo
	}
	return nil
}

// Output only.
//
// Additional information returned to client, such as debugging information.
type ResponseMetadata struct {
	// A unique id associated with this call.
	// This id is logged for tracking purposes.
	RequestId            string   `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResponseMetadata) Reset()         { *m = ResponseMetadata{} }
func (m *ResponseMetadata) String() string { return proto.CompactTextString(m) }
func (*ResponseMetadata) ProtoMessage()    {}
func (*ResponseMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{3}
}
func (m *ResponseMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResponseMetadata.Unmarshal(m, b)
}
func (m *ResponseMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResponseMetadata.Marshal(b, m, deterministic)
}
func (dst *ResponseMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseMetadata.Merge(dst, src)
}
func (m *ResponseMetadata) XXX_Size() int {
	return xxx_messageInfo_ResponseMetadata.Size(m)
}
func (m *ResponseMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseMetadata proto.InternalMessageInfo

func (m *ResponseMetadata) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Device information collected from the job seeker, candidate, or
// other entity conducting the job search. Providing this information improves
// the quality of the search results across devices.
type DeviceInfo struct {
	// Optional.
	//
	// Type of the device.
	DeviceType DeviceInfo_DeviceType `protobuf:"varint,1,opt,name=device_type,json=deviceType,proto3,enum=google.cloud.talent.v4beta1.DeviceInfo_DeviceType" json:"device_type,omitempty"`
	// Optional.
	//
	// A device-specific ID. The ID must be a unique identifier that
	// distinguishes the device from other devices.
	Id                   string   `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceInfo) Reset()         { *m = DeviceInfo{} }
func (m *DeviceInfo) String() string { return proto.CompactTextString(m) }
func (*DeviceInfo) ProtoMessage()    {}
func (*DeviceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{4}
}
func (m *DeviceInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceInfo.Unmarshal(m, b)
}
func (m *DeviceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceInfo.Marshal(b, m, deterministic)
}
func (dst *DeviceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceInfo.Merge(dst, src)
}
func (m *DeviceInfo) XXX_Size() int {
	return xxx_messageInfo_DeviceInfo.Size(m)
}
func (m *DeviceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceInfo proto.InternalMessageInfo

func (m *DeviceInfo) GetDeviceType() DeviceInfo_DeviceType {
	if m != nil {
		return m.DeviceType
	}
	return DeviceInfo_DEVICE_TYPE_UNSPECIFIED
}

func (m *DeviceInfo) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Custom attribute values that are either filterable or non-filterable.
type CustomAttribute struct {
	// Optional but exactly one of
	// [string_values][google.cloud.talent.v4beta1.CustomAttribute.string_values]
	// or [long_values][google.cloud.talent.v4beta1.CustomAttribute.long_values]
	// must be specified.
	//
	// This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
	// `CASE_INSENSITIVE_MATCH`) search.
	// For filterable `string_value`s, a maximum total number of 200 values
	// is allowed, with each `string_value` has a byte size of no more than
	// 255B. For unfilterable `string_values`, the maximum total byte size of
	// unfilterable `string_values` is 50KB.
	//
	// Empty string isn't allowed.
	StringValues []string `protobuf:"bytes,1,rep,name=string_values,json=stringValues,proto3" json:"string_values,omitempty"`
	// Optional but exactly one of
	// [string_values][google.cloud.talent.v4beta1.CustomAttribute.string_values]
	// or [long_values][google.cloud.talent.v4beta1.CustomAttribute.long_values]
	// must be specified.
	//
	// This field is used to perform number range search.
	// (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
	//
	// Currently at most 1
	// [long_values][google.cloud.talent.v4beta1.CustomAttribute.long_values] is
	// supported.
	LongValues []int64 `protobuf:"varint,2,rep,packed,name=long_values,json=longValues,proto3" json:"long_values,omitempty"`
	// Optional.
	//
	// If the `filterable` flag is true, custom field values are searchable.
	// If false, values are not searchable.
	//
	// Default is false.
	Filterable           bool     `protobuf:"varint,3,opt,name=filterable,proto3" json:"filterable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CustomAttribute) Reset()         { *m = CustomAttribute{} }
func (m *CustomAttribute) String() string { return proto.CompactTextString(m) }
func (*CustomAttribute) ProtoMessage()    {}
func (*CustomAttribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{5}
}
func (m *CustomAttribute) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomAttribute.Unmarshal(m, b)
}
func (m *CustomAttribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomAttribute.Marshal(b, m, deterministic)
}
func (dst *CustomAttribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomAttribute.Merge(dst, src)
}
func (m *CustomAttribute) XXX_Size() int {
	return xxx_messageInfo_CustomAttribute.Size(m)
}
func (m *CustomAttribute) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomAttribute.DiscardUnknown(m)
}

var xxx_messageInfo_CustomAttribute proto.InternalMessageInfo

func (m *CustomAttribute) GetStringValues() []string {
	if m != nil {
		return m.StringValues
	}
	return nil
}

func (m *CustomAttribute) GetLongValues() []int64 {
	if m != nil {
		return m.LongValues
	}
	return nil
}

func (m *CustomAttribute) GetFilterable() bool {
	if m != nil {
		return m.Filterable
	}
	return false
}

// Output only.
//
// Spell check result.
type SpellingCorrection struct {
	// Indicates if the query was corrected by the spell checker.
	Corrected bool `protobuf:"varint,1,opt,name=corrected,proto3" json:"corrected,omitempty"`
	// Correction output consisting of the corrected keyword string.
	CorrectedText string `protobuf:"bytes,2,opt,name=corrected_text,json=correctedText,proto3" json:"corrected_text,omitempty"`
	// Corrected output with html tags to highlight the corrected words.
	// Corrected words are called out with the "<b><i>...</i></b>" html tags.
	//
	// For example, the user input query is "software enginear", where the second
	// word, "enginear," is incorrect. It should be "engineer". When spelling
	// correction is enabled, this value is
	// "software <b><i>engineer</i></b>".
	CorrectedHtml        string   `protobuf:"bytes,3,opt,name=corrected_html,json=correctedHtml,proto3" json:"corrected_html,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpellingCorrection) Reset()         { *m = SpellingCorrection{} }
func (m *SpellingCorrection) String() string { return proto.CompactTextString(m) }
func (*SpellingCorrection) ProtoMessage()    {}
func (*SpellingCorrection) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{6}
}
func (m *SpellingCorrection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpellingCorrection.Unmarshal(m, b)
}
func (m *SpellingCorrection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpellingCorrection.Marshal(b, m, deterministic)
}
func (dst *SpellingCorrection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpellingCorrection.Merge(dst, src)
}
func (m *SpellingCorrection) XXX_Size() int {
	return xxx_messageInfo_SpellingCorrection.Size(m)
}
func (m *SpellingCorrection) XXX_DiscardUnknown() {
	xxx_messageInfo_SpellingCorrection.DiscardUnknown(m)
}

var xxx_messageInfo_SpellingCorrection proto.InternalMessageInfo

func (m *SpellingCorrection) GetCorrected() bool {
	if m != nil {
		return m.Corrected
	}
	return false
}

func (m *SpellingCorrection) GetCorrectedText() string {
	if m != nil {
		return m.CorrectedText
	}
	return ""
}

func (m *SpellingCorrection) GetCorrectedHtml() string {
	if m != nil {
		return m.CorrectedHtml
	}
	return ""
}

// Job compensation details.
type CompensationInfo struct {
	// Optional.
	//
	// Job compensation information.
	//
	// At most one entry can be of type
	// [CompensationInfo.CompensationType.BASE][google.cloud.talent.v4beta1.CompensationInfo.CompensationType.BASE],
	// which is referred as ** base compensation entry ** for the job.
	Entries []*CompensationInfo_CompensationEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// Output only. Annualized base compensation range. Computed as
	// base compensation entry's [CompensationEntry.compensation][] times
	// [CompensationEntry.expected_units_per_year][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.expected_units_per_year].
	//
	// See
	// [CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry]
	// for explanation on compensation annualization.
	AnnualizedBaseCompensationRange *CompensationInfo_CompensationRange `protobuf:"bytes,2,opt,name=annualized_base_compensation_range,json=annualizedBaseCompensationRange,proto3" json:"annualized_base_compensation_range,omitempty"`
	// Output only. Annualized total compensation range. Computed as
	// all compensation entries' [CompensationEntry.compensation][] times
	// [CompensationEntry.expected_units_per_year][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.expected_units_per_year].
	//
	// See
	// [CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry]
	// for explanation on compensation annualization.
	AnnualizedTotalCompensationRange *CompensationInfo_CompensationRange `protobuf:"bytes,3,opt,name=annualized_total_compensation_range,json=annualizedTotalCompensationRange,proto3" json:"annualized_total_compensation_range,omitempty"`
	XXX_NoUnkeyedLiteral             struct{}                            `json:"-"`
	XXX_unrecognized                 []byte                              `json:"-"`
	XXX_sizecache                    int32                               `json:"-"`
}

func (m *CompensationInfo) Reset()         { *m = CompensationInfo{} }
func (m *CompensationInfo) String() string { return proto.CompactTextString(m) }
func (*CompensationInfo) ProtoMessage()    {}
func (*CompensationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{7}
}
func (m *CompensationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompensationInfo.Unmarshal(m, b)
}
func (m *CompensationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompensationInfo.Marshal(b, m, deterministic)
}
func (dst *CompensationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompensationInfo.Merge(dst, src)
}
func (m *CompensationInfo) XXX_Size() int {
	return xxx_messageInfo_CompensationInfo.Size(m)
}
func (m *CompensationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CompensationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CompensationInfo proto.InternalMessageInfo

func (m *CompensationInfo) GetEntries() []*CompensationInfo_CompensationEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *CompensationInfo) GetAnnualizedBaseCompensationRange() *CompensationInfo_CompensationRange {
	if m != nil {
		return m.AnnualizedBaseCompensationRange
	}
	return nil
}

func (m *CompensationInfo) GetAnnualizedTotalCompensationRange() *CompensationInfo_CompensationRange {
	if m != nil {
		return m.AnnualizedTotalCompensationRange
	}
	return nil
}

// A compensation entry that represents one component of compensation, such
// as base pay, bonus, or other compensation type.
//
// Annualization: One compensation entry can be annualized if
// - it contains valid
// [amount][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.amount]
// or
// [range][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.range].
// - and its
// [expected_units_per_year][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.expected_units_per_year]
// is set or can be derived. Its annualized range is determined as
// ([amount][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.amount]
// or
// [range][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.range])
// times
// [expected_units_per_year][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.expected_units_per_year].
type CompensationInfo_CompensationEntry struct {
	// Optional.
	//
	// Compensation type.
	//
	// Default is [CompensationUnit.OTHER_COMPENSATION_TYPE][].
	Type CompensationInfo_CompensationType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.CompensationInfo_CompensationType" json:"type,omitempty"`
	// Optional.
	//
	// Frequency of the specified amount.
	//
	// Default is
	// [CompensationUnit.OTHER_COMPENSATION_UNIT][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit.OTHER_COMPENSATION_UNIT].
	Unit CompensationInfo_CompensationUnit `protobuf:"varint,2,opt,name=unit,proto3,enum=google.cloud.talent.v4beta1.CompensationInfo_CompensationUnit" json:"unit,omitempty"`
	// Optional.
	//
	// Compensation amount. It could be a fixed amount or a floating range.
	//
	// Types that are valid to be assigned to CompensationAmount:
	//	*CompensationInfo_CompensationEntry_Amount
	//	*CompensationInfo_CompensationEntry_Range
	CompensationAmount isCompensationInfo_CompensationEntry_CompensationAmount `protobuf_oneof:"compensation_amount"`
	// Optional.
	//
	// Compensation description.  For example, could
	// indicate equity terms or provide additional context to an estimated
	// bonus.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional.
	//
	// Expected number of units paid each year. If not specified, when
	// [Job.employment_types][google.cloud.talent.v4beta1.Job.employment_types]
	// is FULLTIME, a default value is inferred based on
	// [unit][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry.unit].
	// Default values:
	// - HOURLY: 2080
	// - DAILY: 260
	// - WEEKLY: 52
	// - MONTHLY: 12
	// - ANNUAL: 1
	ExpectedUnitsPerYear *wrappers.DoubleValue `protobuf:"bytes,6,opt,name=expected_units_per_year,json=expectedUnitsPerYear,proto3" json:"expected_units_per_year,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CompensationInfo_CompensationEntry) Reset()         { *m = CompensationInfo_CompensationEntry{} }
func (m *CompensationInfo_CompensationEntry) String() string { return proto.CompactTextString(m) }
func (*CompensationInfo_CompensationEntry) ProtoMessage()    {}
func (*CompensationInfo_CompensationEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{7, 0}
}
func (m *CompensationInfo_CompensationEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompensationInfo_CompensationEntry.Unmarshal(m, b)
}
func (m *CompensationInfo_CompensationEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompensationInfo_CompensationEntry.Marshal(b, m, deterministic)
}
func (dst *CompensationInfo_CompensationEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompensationInfo_CompensationEntry.Merge(dst, src)
}
func (m *CompensationInfo_CompensationEntry) XXX_Size() int {
	return xxx_messageInfo_CompensationInfo_CompensationEntry.Size(m)
}
func (m *CompensationInfo_CompensationEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_CompensationInfo_CompensationEntry.DiscardUnknown(m)
}

var xxx_messageInfo_CompensationInfo_CompensationEntry proto.InternalMessageInfo

func (m *CompensationInfo_CompensationEntry) GetType() CompensationInfo_CompensationType {
	if m != nil {
		return m.Type
	}
	return CompensationInfo_COMPENSATION_TYPE_UNSPECIFIED
}

func (m *CompensationInfo_CompensationEntry) GetUnit() CompensationInfo_CompensationUnit {
	if m != nil {
		return m.Unit
	}
	return CompensationInfo_COMPENSATION_UNIT_UNSPECIFIED
}

type isCompensationInfo_CompensationEntry_CompensationAmount interface {
	isCompensationInfo_CompensationEntry_CompensationAmount()
}

type CompensationInfo_CompensationEntry_Amount struct {
	Amount *money.Money `protobuf:"bytes,3,opt,name=amount,proto3,oneof"`
}

type CompensationInfo_CompensationEntry_Range struct {
	Range *CompensationInfo_CompensationRange `protobuf:"bytes,4,opt,name=range,proto3,oneof"`
}

func (*CompensationInfo_CompensationEntry_Amount) isCompensationInfo_CompensationEntry_CompensationAmount() {
}

func (*CompensationInfo_CompensationEntry_Range) isCompensationInfo_CompensationEntry_CompensationAmount() {
}

func (m *CompensationInfo_CompensationEntry) GetCompensationAmount() isCompensationInfo_CompensationEntry_CompensationAmount {
	if m != nil {
		return m.CompensationAmount
	}
	return nil
}

func (m *CompensationInfo_CompensationEntry) GetAmount() *money.Money {
	if x, ok := m.GetCompensationAmount().(*CompensationInfo_CompensationEntry_Amount); ok {
		return x.Amount
	}
	return nil
}

func (m *CompensationInfo_CompensationEntry) GetRange() *CompensationInfo_CompensationRange {
	if x, ok := m.GetCompensationAmount().(*CompensationInfo_CompensationEntry_Range); ok {
		return x.Range
	}
	return nil
}

func (m *CompensationInfo_CompensationEntry) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CompensationInfo_CompensationEntry) GetExpectedUnitsPerYear() *wrappers.DoubleValue {
	if m != nil {
		return m.ExpectedUnitsPerYear
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CompensationInfo_CompensationEntry) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CompensationInfo_CompensationEntry_OneofMarshaler, _CompensationInfo_CompensationEntry_OneofUnmarshaler, _CompensationInfo_CompensationEntry_OneofSizer, []interface{}{
		(*CompensationInfo_CompensationEntry_Amount)(nil),
		(*CompensationInfo_CompensationEntry_Range)(nil),
	}
}

func _CompensationInfo_CompensationEntry_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CompensationInfo_CompensationEntry)
	// compensation_amount
	switch x := m.CompensationAmount.(type) {
	case *CompensationInfo_CompensationEntry_Amount:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Amount); err != nil {
			return err
		}
	case *CompensationInfo_CompensationEntry_Range:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Range); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CompensationInfo_CompensationEntry.CompensationAmount has unexpected type %T", x)
	}
	return nil
}

func _CompensationInfo_CompensationEntry_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CompensationInfo_CompensationEntry)
	switch tag {
	case 3: // compensation_amount.amount
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(money.Money)
		err := b.DecodeMessage(msg)
		m.CompensationAmount = &CompensationInfo_CompensationEntry_Amount{msg}
		return true, err
	case 4: // compensation_amount.range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CompensationInfo_CompensationRange)
		err := b.DecodeMessage(msg)
		m.CompensationAmount = &CompensationInfo_CompensationEntry_Range{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CompensationInfo_CompensationEntry_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CompensationInfo_CompensationEntry)
	// compensation_amount
	switch x := m.CompensationAmount.(type) {
	case *CompensationInfo_CompensationEntry_Amount:
		s := proto.Size(x.Amount)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CompensationInfo_CompensationEntry_Range:
		s := proto.Size(x.Range)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Compensation range.
type CompensationInfo_CompensationRange struct {
	// Optional.
	//
	// The maximum amount of compensation. If left empty, the value is set
	// to a maximal compensation value and the currency code is set to
	// match the [currency code][google.type.Money.currency_code] of
	// min_compensation.
	MaxCompensation *money.Money `protobuf:"bytes,2,opt,name=max_compensation,json=maxCompensation,proto3" json:"max_compensation,omitempty"`
	// Optional.
	//
	// The minimum amount of compensation. If left empty, the value is set
	// to zero and the currency code is set to match the
	// [currency code][google.type.Money.currency_code] of max_compensation.
	MinCompensation      *money.Money `protobuf:"bytes,1,opt,name=min_compensation,json=minCompensation,proto3" json:"min_compensation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CompensationInfo_CompensationRange) Reset()         { *m = CompensationInfo_CompensationRange{} }
func (m *CompensationInfo_CompensationRange) String() string { return proto.CompactTextString(m) }
func (*CompensationInfo_CompensationRange) ProtoMessage()    {}
func (*CompensationInfo_CompensationRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_9a8bd73dbaf606cc, []int{7, 1}
}
func (m *CompensationInfo_CompensationRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompensationInfo_CompensationRange.Unmarshal(m, b)
}
func (m *CompensationInfo_CompensationRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompensationInfo_CompensationRange.Marshal(b, m, deterministic)
}
func (dst *CompensationInfo_CompensationRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompensationInfo_CompensationRange.Merge(dst, src)
}
func (m *CompensationInfo_CompensationRange) XXX_Size() int {
	return xxx_messageInfo_CompensationInfo_CompensationRange.Size(m)
}
func (m *CompensationInfo_CompensationRange) XXX_DiscardUnknown() {
	xxx_messageInfo_CompensationInfo_CompensationRange.DiscardUnknown(m)
}

var xxx_messageInfo_CompensationInfo_CompensationRange proto.InternalMessageInfo

func (m *CompensationInfo_CompensationRange) GetMaxCompensation() *money.Money {
	if m != nil {
		return m.MaxCompensation
	}
	return nil
}

func (m *CompensationInfo_CompensationRange) GetMinCompensation() *money.Money {
	if m != nil {
		return m.MinCompensation
	}
	return nil
}

func init() {
	proto.RegisterType((*TimestampRange)(nil), "google.cloud.talent.v4beta1.TimestampRange")
	proto.RegisterType((*Location)(nil), "google.cloud.talent.v4beta1.Location")
	proto.RegisterType((*RequestMetadata)(nil), "google.cloud.talent.v4beta1.RequestMetadata")
	proto.RegisterType((*ResponseMetadata)(nil), "google.cloud.talent.v4beta1.ResponseMetadata")
	proto.RegisterType((*DeviceInfo)(nil), "google.cloud.talent.v4beta1.DeviceInfo")
	proto.RegisterType((*CustomAttribute)(nil), "google.cloud.talent.v4beta1.CustomAttribute")
	proto.RegisterType((*SpellingCorrection)(nil), "google.cloud.talent.v4beta1.SpellingCorrection")
	proto.RegisterType((*CompensationInfo)(nil), "google.cloud.talent.v4beta1.CompensationInfo")
	proto.RegisterType((*CompensationInfo_CompensationEntry)(nil), "google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry")
	proto.RegisterType((*CompensationInfo_CompensationRange)(nil), "google.cloud.talent.v4beta1.CompensationInfo.CompensationRange")
	proto.RegisterEnum("google.cloud.talent.v4beta1.CompanySize", CompanySize_name, CompanySize_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.JobBenefit", JobBenefit_name, JobBenefit_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.DegreeType", DegreeType_name, DegreeType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.EmploymentType", EmploymentType_name, EmploymentType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.JobLevel", JobLevel_name, JobLevel_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.JobCategory", JobCategory_name, JobCategory_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.PostingRegion", PostingRegion_name, PostingRegion_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.Visibility", Visibility_name, Visibility_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.ContactInfoUsage", ContactInfoUsage_name, ContactInfoUsage_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.HtmlSanitization", HtmlSanitization_name, HtmlSanitization_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.CommuteMethod", CommuteMethod_name, CommuteMethod_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.Location_LocationType", Location_LocationType_name, Location_LocationType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.DeviceInfo_DeviceType", DeviceInfo_DeviceType_name, DeviceInfo_DeviceType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.CompensationInfo_CompensationType", CompensationInfo_CompensationType_name, CompensationInfo_CompensationType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.CompensationInfo_CompensationUnit", CompensationInfo_CompensationUnit_name, CompensationInfo_CompensationUnit_value)
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/common.proto", fileDescriptor_common_9a8bd73dbaf606cc)
}

var fileDescriptor_common_9a8bd73dbaf606cc = []byte{
	// 2622 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xcd, 0x6f, 0xe3, 0xc8,
	0x95, 0x1f, 0x59, 0xb6, 0x6c, 0x95, 0xbf, 0xaa, 0xd9, 0x1f, 0xf6, 0xb8, 0xbf, 0x3c, 0x9e, 0x5d,
	0x4c, 0xc3, 0x18, 0xd8, 0x98, 0xde, 0xdd, 0xc3, 0x62, 0xb1, 0xbb, 0x28, 0x91, 0x25, 0xa9, 0xba,
	0x49, 0x96, 0xb6, 0xaa, 0x68, 0x8f, 0xfa, 0x52, 0xa0, 0x2d, 0xb6, 0x86, 0x0b, 0x8a, 0xd4, 0x88,
	0x74, 0x4f, 0x7b, 0xf6, 0xb2, 0xc8, 0x39, 0x18, 0x20, 0xf7, 0x9c, 0xf2, 0x3f, 0xe4, 0x92, 0x7f,
	0x21, 0x97, 0xdc, 0x72, 0x09, 0x10, 0x20, 0xb7, 0x9c, 0xf2, 0x2f, 0x04, 0xaf, 0x8a, 0xb6, 0xe5,
	0x8f, 0xee, 0x04, 0x99, 0x39, 0x89, 0xf5, 0xbe, 0xea, 0xd5, 0x7b, 0xbf, 0x7a, 0xef, 0x95, 0xd0,
	0x8b, 0x71, 0x51, 0x8c, 0xb3, 0xe4, 0xf0, 0x34, 0x2b, 0xce, 0x46, 0x87, 0x55, 0x9c, 0x25, 0x79,
	0x75, 0xf8, 0xee, 0x5f, 0x4f, 0x92, 0x2a, 0xfe, 0xea, 0xf0, 0xb4, 0x98, 0x4c, 0x8a, 0xfc, 0x60,
	0x3a, 0x2b, 0xaa, 0xc2, 0x79, 0x6c, 0x25, 0x0f, 0x8c, 0xe4, 0x81, 0x95, 0x3c, 0xa8, 0x25, 0x77,
	0x9e, 0xd4, 0x66, 0xe2, 0x69, 0x7a, 0x18, 0xe7, 0x79, 0x51, 0xc5, 0x55, 0x5a, 0xe4, 0xa5, 0x55,
	0xdd, 0x79, 0x5e, 0x73, 0xcd, 0xea, 0xe4, 0xec, 0xed, 0x61, 0x95, 0x4e, 0x92, 0xb2, 0x8a, 0x27,
	0xd3, 0x5a, 0xe0, 0xd9, 0x4d, 0x81, 0xef, 0x66, 0xf1, 0x74, 0x9a, 0xcc, 0x2e, 0x0c, 0x6c, 0xd7,
	0xfc, 0xea, 0x7c, 0x9a, 0x1c, 0x66, 0x71, 0x95, 0xe5, 0xe3, 0x9a, 0xb3, 0x35, 0xcf, 0x99, 0x14,
	0x79, 0x72, 0x5e, 0x33, 0x76, 0xe7, 0x19, 0xd3, 0xa2, 0xac, 0xe2, 0x4c, 0xc7, 0xa3, 0xd1, 0x2c,
	0x29, 0x6b, 0xa3, 0x7b, 0x3f, 0x6b, 0xa0, 0x0d, 0x75, 0xe1, 0x88, 0x88, 0xf3, 0x71, 0xe2, 0xfc,
	0x3b, 0x42, 0x65, 0x15, 0xcf, 0x2a, 0x0d, 0x0e, 0x6e, 0x37, 0x76, 0x1b, 0x2f, 0x56, 0x5f, 0xee,
	0x1c, 0xd4, 0x07, 0xbf, 0x70, 0xee, 0xe0, 0x4a, 0xa9, 0x6d, 0xa4, 0x61, 0xed, 0xfc, 0x1b, 0x5a,
	0x49, 0xf2, 0x91, 0x55, 0x5c, 0xf8, 0x9b, 0x8a, 0xcb, 0x49, 0x3e, 0x82, 0xd5, 0xde, 0x9f, 0x9b,
	0x68, 0xc5, 0x2f, 0x4e, 0x4d, 0xb8, 0x9c, 0x63, 0xb4, 0x9e, 0xd5, 0xdf, 0x1a, 0xfc, 0x36, 0x1e,
	0x6c, 0xbc, 0x7c, 0x79, 0xf0, 0x91, 0xd0, 0x1f, 0x5c, 0x68, 0x5f, 0x7e, 0xa8, 0xf3, 0x69, 0x22,
	0xd6, 0xb2, 0xb9, 0x95, 0x43, 0xd0, 0xc6, 0xf5, 0x10, 0xdc, 0x74, 0x11, 0x76, 0x3b, 0x18, 0x18,
	0x11, 0x62, 0x25, 0xc4, 0xfa, 0x74, 0x7e, 0xe9, 0x7c, 0x89, 0x96, 0xb3, 0xb8, 0xd2, 0x59, 0x3e,
	0xde, 0x6e, 0x1a, 0xdd, 0xfb, 0xd7, 0x74, 0xfd, 0xb8, 0xf2, 0xf3, 0xb1, 0x68, 0x65, 0xe6, 0xd7,
	0xf9, 0x0c, 0xad, 0xcd, 0xe2, 0x51, 0x7a, 0x56, 0xea, 0x49, 0x9a, 0x25, 0xe5, 0xf6, 0xe2, 0x6e,
	0xe3, 0x45, 0x43, 0xac, 0x5a, 0x5a, 0x00, 0xa4, 0xbd, 0xbf, 0x34, 0xd0, 0xda, 0xbc, 0xcb, 0xce,
	0x53, 0xf4, 0xa9, 0xcf, 0x5d, 0xa2, 0x18, 0x0f, 0xb5, 0x1a, 0x0e, 0xa8, 0x8e, 0x42, 0x39, 0xa0,
	0x2e, 0xeb, 0x32, 0xea, 0xe1, 0x4f, 0x9c, 0x55, 0xb4, 0xec, 0xf2, 0x28, 0x54, 0x62, 0x88, 0x1b,
	0xce, 0x16, 0xba, 0x4f, 0xbc, 0x80, 0x85, 0x4c, 0x2a, 0x41, 0x14, 0x3b, 0xa2, 0x9a, 0x08, 0x4a,
	0xf0, 0x82, 0xf3, 0x18, 0x6d, 0xc9, 0xa8, 0xa3, 0xef, 0x62, 0x36, 0x9d, 0x35, 0xb4, 0x02, 0x3b,
	0xf8, 0x4c, 0x0d, 0xf1, 0xa2, 0xb3, 0x89, 0x56, 0x07, 0x5c, 0x2a, 0xe2, 0x6b, 0x97, 0x7b, 0x14,
	0x2f, 0x39, 0x18, 0xad, 0x81, 0xee, 0xa5, 0x48, 0xcb, 0x71, 0xd0, 0xc6, 0x3c, 0x45, 0x7f, 0x85,
	0x97, 0x6f, 0xd1, 0x5e, 0xe2, 0x15, 0xd0, 0x0c, 0x29, 0xeb, 0xf5, 0x3b, 0x5c, 0xf4, 0x39, 0xf7,
	0x70, 0xdb, 0x48, 0x29, 0x41, 0xa9, 0xd2, 0xc4, 0xf3, 0x04, 0x95, 0x12, 0xa3, 0xbd, 0xdf, 0x37,
	0xd0, 0xa6, 0x48, 0xbe, 0x3d, 0x4b, 0xca, 0x2a, 0x48, 0xaa, 0x78, 0x14, 0x57, 0xb1, 0xf3, 0x08,
	0xb5, 0x46, 0xc5, 0x24, 0x4e, 0x73, 0x93, 0xeb, 0xb6, 0xa8, 0x57, 0xce, 0x53, 0x84, 0xca, 0xa4,
	0x2c, 0x01, 0x09, 0xe9, 0xc8, 0x64, 0xab, 0x2d, 0xda, 0x35, 0x85, 0x8d, 0x9c, 0x2d, 0xb4, 0x7c,
	0x56, 0x26, 0x33, 0xe0, 0x35, 0xad, 0x1e, 0x2c, 0xd9, 0xc8, 0xd9, 0x47, 0xf7, 0xe2, 0x2c, 0x2b,
	0xbe, 0xd3, 0x93, 0xb4, 0x2c, 0xd3, 0x7c, 0xac, 0xd3, 0x91, 0x8d, 0xfe, 0x8a, 0xd8, 0x34, 0x8c,
	0xc0, 0xd2, 0xd9, 0xa8, 0x74, 0xfa, 0x68, 0x75, 0x94, 0xbc, 0x4b, 0x4f, 0x13, 0x9d, 0xe6, 0x6f,
	0x8b, 0xed, 0x25, 0x93, 0xd6, 0x2f, 0x3e, 0x0a, 0x36, 0xcf, 0xc8, 0xb3, 0xfc, 0x6d, 0x21, 0xd0,
	0xe8, 0xf2, 0x7b, 0xef, 0x2b, 0x84, 0x45, 0x52, 0x4e, 0x8b, 0xbc, 0x4c, 0x2e, 0x4f, 0xf6, 0x14,
	0xa1, 0x99, 0x3d, 0x2c, 0x78, 0x69, 0x4f, 0xd7, 0xae, 0x29, 0x6c, 0xb4, 0xf7, 0xc7, 0x06, 0x42,
	0x57, 0xd6, 0x1c, 0x79, 0xe9, 0xcb, 0xdf, 0x0d, 0xfc, 0x2b, 0xed, 0xfa, 0xd3, 0x00, 0xbf, 0x76,
	0xcb, 0x20, 0x6a, 0x03, 0x2d, 0x5c, 0x06, 0x6f, 0x21, 0x1d, 0xed, 0x65, 0x17, 0x5b, 0x1a, 0xee,
	0x63, 0xb4, 0xe5, 0xd1, 0x23, 0xe6, 0xd2, 0xbb, 0xd0, 0xb6, 0x8c, 0x9a, 0xc7, 0xb4, 0x83, 0x1b,
	0xce, 0x06, 0x42, 0x01, 0xef, 0x30, 0x9f, 0x6a, 0x58, 0x2f, 0x00, 0x0c, 0x49, 0xe8, 0x09, 0xce,
	0x3c, 0xdc, 0x04, 0x29, 0xc6, 0x25, 0x5e, 0x84, 0x8f, 0x0e, 0x57, 0x78, 0xc9, 0x69, 0xa3, 0x25,
	0xae, 0xfa, 0x54, 0xe0, 0xd6, 0xde, 0x77, 0x68, 0xd3, 0x3d, 0x2b, 0xab, 0x62, 0x42, 0xaa, 0x6a,
	0x96, 0x9e, 0x9c, 0x55, 0x89, 0xf3, 0x39, 0x5a, 0x2f, 0xab, 0x19, 0xa4, 0xe5, 0x5d, 0x9c, 0x9d,
	0x25, 0xe5, 0x76, 0x63, 0xb7, 0xf9, 0xa2, 0x2d, 0xd6, 0x2c, 0xf1, 0xc8, 0xd0, 0x9c, 0xe7, 0x68,
	0x35, 0x2b, 0xae, 0x44, 0x16, 0x76, 0x9b, 0x2f, 0x9a, 0x02, 0x01, 0xa9, 0x16, 0x78, 0x86, 0xd0,
	0xdb, 0x34, 0xab, 0x92, 0x59, 0x7c, 0x92, 0x25, 0x26, 0xff, 0x2b, 0x62, 0x8e, 0xb2, 0xf7, 0xff,
	0x0d, 0xe4, 0xc8, 0x69, 0x92, 0x65, 0x69, 0x3e, 0x76, 0x8b, 0xd9, 0x2c, 0x39, 0x35, 0xd5, 0xe5,
	0x09, 0x6a, 0x9f, 0xda, 0x55, 0x62, 0xf3, 0xb1, 0x22, 0xae, 0x08, 0xce, 0x3f, 0xa3, 0x8d, 0xcb,
	0x85, 0xae, 0x92, 0xf7, 0x55, 0x1d, 0xb7, 0xf5, 0x4b, 0xaa, 0x4a, 0xde, 0x57, 0xd7, 0xc5, 0xbe,
	0xa9, 0x26, 0x59, 0x8d, 0xbf, 0x2b, 0xb1, 0x7e, 0x35, 0xc9, 0xf6, 0x7e, 0x8b, 0x10, 0x76, 0x8b,
	0xc9, 0x34, 0xc9, 0x4b, 0x73, 0xc1, 0x4d, 0x8e, 0x87, 0x68, 0x39, 0xc9, 0xab, 0x59, 0x5a, 0x9f,
	0x7b, 0xf5, 0xe5, 0x7f, 0x7f, 0x34, 0xbf, 0x37, 0xf5, 0xaf, 0x11, 0x68, 0x5e, 0xcd, 0xce, 0xc5,
	0x85, 0x3d, 0xe7, 0xe7, 0x0d, 0xb4, 0x17, 0xe7, 0xf9, 0x59, 0x9c, 0xa5, 0xdf, 0x27, 0x23, 0x7d,
	0x12, 0x97, 0x89, 0x3e, 0x9d, 0x13, 0xd7, 0x33, 0xa8, 0xef, 0x75, 0xd5, 0xfb, 0x11, 0xdb, 0x9a,
	0x36, 0x21, 0x9e, 0x5f, 0x6d, 0xd5, 0x89, 0xcb, 0xe4, 0x96, 0x80, 0xf3, 0x43, 0x03, 0x7d, 0x3e,
	0xe7, 0x4e, 0x55, 0x40, 0xe9, 0xbd, 0xc3, 0x9f, 0xe6, 0x4f, 0xe3, 0xcf, 0xee, 0xd5, 0x5e, 0x0a,
	0xb6, 0xba, 0x25, 0xb1, 0xf3, 0xbb, 0x26, 0xba, 0x77, 0x2b, 0x7c, 0x8e, 0x40, 0x8b, 0x73, 0xb7,
	0xed, 0xbf, 0xfe, 0x71, 0x37, 0xcc, 0xcd, 0x33, 0xb6, 0xc0, 0xe6, 0x59, 0x9e, 0x5a, 0xf4, 0xfc,
	0x28, 0x9b, 0x51, 0x9e, 0x56, 0xc2, 0xd8, 0x72, 0xbe, 0x44, 0xad, 0x78, 0x52, 0x9c, 0xe5, 0x55,
	0x1d, 0x30, 0xe7, 0x5a, 0xeb, 0x09, 0xa0, 0xeb, 0xf7, 0x3f, 0x11, 0xb5, 0x8c, 0x73, 0x8c, 0x96,
	0x6c, 0x74, 0x17, 0x7f, 0x92, 0xe8, 0xf6, 0x3f, 0x11, 0xd6, 0x9e, 0xb3, 0x0b, 0x35, 0xaa, 0x3c,
	0x9d, 0xa5, 0x53, 0x60, 0x9a, 0x7a, 0xd9, 0x16, 0xf3, 0x24, 0x47, 0xa2, 0xad, 0xe4, 0xfd, 0xd4,
	0x5e, 0x0e, 0xf0, 0xbc, 0xd4, 0xd3, 0x64, 0xa6, 0xcf, 0x93, 0x78, 0xb6, 0xdd, 0x32, 0xce, 0x3c,
	0xb9, 0x35, 0x13, 0x78, 0xc5, 0xd9, 0x49, 0x96, 0x98, 0x9b, 0x2d, 0x1e, 0x5c, 0x28, 0xc3, 0xd9,
	0xcb, 0x41, 0x32, 0x1b, 0x26, 0xf1, 0xac, 0xf3, 0x10, 0xdd, 0xbf, 0x06, 0x1d, 0x7b, 0xcc, 0x9d,
	0x5f, 0x34, 0xae, 0xa7, 0xd4, 0x22, 0xef, 0x3f, 0x11, 0x9e, 0xc4, 0xef, 0xaf, 0x61, 0xad, 0x46,
	0xfd, 0x1d, 0x41, 0x13, 0x9b, 0x93, 0xf8, 0xfd, 0xbc, 0x0d, 0xa3, 0x9e, 0xe6, 0xd7, 0xd5, 0x1b,
	0x1f, 0x51, 0x4f, 0xf3, 0x79, 0xf5, 0xbd, 0x5f, 0x37, 0xae, 0x5f, 0x7b, 0x53, 0x67, 0x3f, 0x43,
	0x4f, 0x5d, 0x1e, 0x0c, 0x68, 0x28, 0x3f, 0xd8, 0xdb, 0x57, 0xd0, 0x62, 0x87, 0x48, 0x8a, 0x1b,
	0x50, 0x3f, 0x3b, 0x3c, 0x8c, 0x24, 0x5e, 0x70, 0xee, 0xa1, 0x75, 0xc9, 0x7a, 0x21, 0x0b, 0x7b,
	0xda, 0x92, 0x9a, 0x0e, 0x42, 0x2d, 0xfa, 0x3f, 0x91, 0x6d, 0xdf, 0x0e, 0xda, 0x18, 0x08, 0xde,
	0x65, 0x4a, 0xcb, 0x3e, 0x11, 0x2c, 0xec, 0xe1, 0x25, 0x68, 0xe9, 0x2e, 0x0f, 0x02, 0x26, 0x25,
	0xe3, 0xa1, 0xc4, 0x2d, 0x30, 0xac, 0xd8, 0x40, 0xe2, 0x65, 0xa8, 0xf6, 0xa6, 0x30, 0xeb, 0x5b,
	0xbe, 0xe0, 0x95, 0xbd, 0x5f, 0xde, 0xf0, 0x1b, 0xe2, 0x7f, 0xcb, 0xef, 0x28, 0x64, 0xea, 0x86,
	0xdf, 0x08, 0xb5, 0xfa, 0x3c, 0x12, 0xfe, 0xd0, 0x7a, 0xee, 0x11, 0xe6, 0x0f, 0xf1, 0x02, 0x90,
	0x8f, 0x29, 0x7d, 0xed, 0x0f, 0x71, 0x13, 0xfa, 0x45, 0xc0, 0x43, 0xd5, 0xf7, 0xc1, 0x67, 0x84,
	0x5a, 0x43, 0x4a, 0x40, 0x7e, 0x09, 0x86, 0x11, 0x1e, 0x52, 0xad, 0x58, 0x40, 0x71, 0xeb, 0x03,
	0xee, 0xc1, 0x96, 0x78, 0x79, 0xff, 0x1c, 0xad, 0x82, 0x77, 0x71, 0x7e, 0x2e, 0xd3, 0xef, 0x13,
	0xe7, 0x09, 0xda, 0x06, 0x29, 0x12, 0x0e, 0xb5, 0x64, 0x6f, 0xee, 0x88, 0x25, 0xcc, 0x3e, 0xd6,
	0x23, 0x19, 0x10, 0xdf, 0xb7, 0x5d, 0x4b, 0x06, 0xd4, 0x63, 0x51, 0x60, 0xa3, 0x58, 0x7f, 0xdb,
	0xc6, 0xc5, 0x20, 0x74, 0x08, 0xb5, 0x3a, 0xac, 0xd7, 0x83, 0xce, 0x05, 0x8a, 0x3d, 0x46, 0x42,
	0xd8, 0xfa, 0x4f, 0x0d, 0x84, 0x5e, 0x15, 0x27, 0x9d, 0x24, 0x4f, 0xde, 0xa6, 0x15, 0xb8, 0xf9,
	0x8a, 0x77, 0x74, 0x87, 0x86, 0xb4, 0x7b, 0x2b, 0x1a, 0x1b, 0x08, 0xb9, 0x7d, 0xe6, 0x7b, 0xda,
	0x25, 0x02, 0x72, 0x89, 0x50, 0xcb, 0xa3, 0xa1, 0x22, 0xe0, 0xc0, 0x03, 0x84, 0x3d, 0x1e, 0x50,
	0xa9, 0x98, 0xab, 0x07, 0x44, 0xa8, 0x90, 0x0a, 0xdc, 0x84, 0x1c, 0x76, 0x7d, 0xfa, 0x35, 0xeb,
	0xf8, 0x54, 0x43, 0x20, 0xa1, 0x95, 0x42, 0xc0, 0xa8, 0xc7, 0x5c, 0xe2, 0xe3, 0x25, 0x10, 0xf0,
	0x59, 0x97, 0x6a, 0x16, 0xca, 0x48, 0x90, 0xd0, 0xa5, 0x76, 0x28, 0x1b, 0x10, 0x61, 0x0c, 0x6b,
	0x9f, 0x92, 0x23, 0x8a, 0x97, 0x9d, 0xfb, 0x68, 0x53, 0x50, 0xc5, 0x04, 0x0d, 0x68, 0xa8, 0xf4,
	0xc0, 0x27, 0x21, 0x5e, 0x71, 0xd6, 0x51, 0x5b, 0x32, 0xf7, 0xb5, 0xf6, 0xc8, 0x50, 0xe2, 0x36,
	0x04, 0xfc, 0x88, 0xd8, 0xf9, 0x12, 0x23, 0x70, 0xee, 0x88, 0x01, 0x4c, 0xf0, 0xea, 0xfe, 0x0f,
	0x0b, 0x30, 0x18, 0x8c, 0x67, 0xc9, 0xdc, 0x60, 0xd0, 0x13, 0xf4, 0xce, 0xc1, 0xe0, 0x21, 0xba,
	0x37, 0x10, 0x2c, 0x20, 0x62, 0xa8, 0xa9, 0x17, 0xd5, 0xe6, 0x1a, 0x76, 0x78, 0x3d, 0xa6, 0x42,
	0x4b, 0xea, 0xf2, 0xd0, 0xbb, 0xce, 0x5e, 0x00, 0x76, 0x34, 0x18, 0x7c, 0x80, 0xdd, 0x84, 0x8c,
	0x12, 0x2f, 0xf2, 0x95, 0x86, 0x03, 0x78, 0x8c, 0xf8, 0x73, 0xdc, 0x45, 0xc3, 0x95, 0x92, 0xbb,
	0x8c, 0x28, 0x2a, 0x35, 0x17, 0x1a, 0xee, 0xc0, 0x11, 0xf1, 0x69, 0x08, 0x13, 0xc7, 0x63, 0xb4,
	0xd5, 0x21, 0x6e, 0x9f, 0xfa, 0x5c, 0xdc, 0x64, 0xb6, 0x9c, 0x4f, 0xd1, 0xc3, 0x80, 0x48, 0x45,
	0x6f, 0xb1, 0x96, 0x9d, 0x1d, 0xf4, 0xc8, 0xe3, 0xae, 0xe2, 0x82, 0xf8, 0x37, 0x78, 0x2b, 0xfb,
	0x7f, 0x68, 0xa0, 0x0d, 0x3a, 0x99, 0x66, 0xc5, 0xf9, 0x24, 0xc9, 0x2b, 0x13, 0x94, 0xe7, 0xe8,
	0x31, 0x0d, 0x06, 0x3e, 0x1f, 0x9a, 0x08, 0xdf, 0x11, 0x98, 0x75, 0xd4, 0xee, 0x46, 0xbe, 0x6f,
	0x01, 0xdd, 0x80, 0x25, 0xe4, 0xd9, 0x2e, 0x17, 0x0c, 0x36, 0x78, 0xa8, 0x04, 0x81, 0x1d, 0x71,
	0x13, 0xf0, 0x70, 0xb1, 0xd6, 0x8a, 0xeb, 0x3e, 0x13, 0x14, 0x2f, 0x82, 0x92, 0xa2, 0xc1, 0x80,
	0x0b, 0x22, 0x86, 0x16, 0x93, 0x2c, 0x54, 0x54, 0x84, 0xb8, 0x05, 0xac, 0x23, 0xee, 0x47, 0xa1,
	0xa2, 0x54, 0xe0, 0x65, 0x48, 0x26, 0x84, 0xd3, 0x63, 0x34, 0xc0, 0x2b, 0x16, 0x47, 0x43, 0xcd,
	0x42, 0x0d, 0x3f, 0x3c, 0x52, 0xb8, 0x0d, 0x47, 0xb7, 0x37, 0xea, 0x86, 0xdb, 0x18, 0xed, 0x7f,
	0x8b, 0x56, 0x5e, 0x15, 0x27, 0x7e, 0xf2, 0x2e, 0xc9, 0x40, 0x0c, 0x10, 0xed, 0xd3, 0x23, 0xea,
	0xdf, 0x38, 0xd1, 0x26, 0x5a, 0xa5, 0xf0, 0xde, 0xb0, 0x4c, 0xdc, 0x30, 0x84, 0xaf, 0x07, 0x54,
	0x30, 0x1a, 0xba, 0xd4, 0xb3, 0xd7, 0x2a, 0x20, 0x21, 0xe9, 0x19, 0x30, 0xaf, 0xa1, 0x15, 0x8f,
	0x09, 0x6a, 0x0e, 0x68, 0x8e, 0x42, 0xbf, 0xa6, 0x6e, 0x04, 0xef, 0x0f, 0xbc, 0xb4, 0xff, 0x9b,
	0x16, 0x5a, 0x7d, 0x55, 0x9c, 0xb8, 0x71, 0x95, 0x8c, 0x8b, 0xd9, 0x39, 0xe4, 0x14, 0xb6, 0x75,
	0x89, 0xa2, 0x3d, 0x2e, 0x86, 0x37, 0x76, 0xde, 0x41, 0x8f, 0x88, 0x6b, 0x5e, 0x3b, 0x50, 0xfd,
	0x48, 0xe8, 0xe9, 0x2e, 0x0b, 0x0d, 0xfc, 0x0d, 0xd2, 0x6e, 0xbe, 0x6e, 0x42, 0x4f, 0xf3, 0x6e,
	0x97, 0xb9, 0xd4, 0x22, 0x8d, 0x78, 0x47, 0x54, 0x28, 0x26, 0x2f, 0x74, 0x03, 0x22, 0x5e, 0x53,
	0xb0, 0x84, 0x9b, 0x70, 0x04, 0x12, 0xb2, 0x00, 0x1e, 0x3d, 0xc4, 0x84, 0x1c, 0xb6, 0x12, 0x4a,
	0x77, 0x89, 0xec, 0x43, 0xc5, 0x01, 0x79, 0x8f, 0x42, 0xdd, 0xc5, 0x4b, 0xf0, 0xca, 0xea, 0x44,
	0x92, 0x85, 0x54, 0x4a, 0xcd, 0x07, 0x54, 0x18, 0x40, 0x4a, 0x5b, 0xad, 0x5c, 0x9f, 0x92, 0xf0,
	0xd2, 0x3b, 0xe2, 0x32, 0x9f, 0x29, 0x46, 0xa5, 0xbd, 0x8b, 0x50, 0x9e, 0x22, 0x45, 0x85, 0x61,
	0x32, 0x65, 0x5f, 0x48, 0x2e, 0x0f, 0xa5, 0x12, 0x91, 0x6b, 0x50, 0xdd, 0x36, 0x08, 0x88, 0xa4,
	0xe2, 0x81, 0xb9, 0x15, 0x02, 0x06, 0x71, 0x8c, 0x4c, 0xd8, 0x2e, 0xa1, 0xbf, 0x0a, 0x61, 0xa2,
	0x80, 0x00, 0x45, 0x58, 0x68, 0x32, 0x08, 0x06, 0x95, 0x20, 0x90, 0x8f, 0x35, 0x67, 0x1b, 0x3d,
	0xe8, 0x12, 0x11, 0x5c, 0x78, 0xc1, 0x23, 0xe5, 0x71, 0x2e, 0x24, 0x5e, 0x07, 0xb8, 0xf5, 0x29,
	0xf1, 0x55, 0xdf, 0x9c, 0x72, 0x03, 0x7c, 0xea, 0x47, 0x01, 0x09, 0xb5, 0xa0, 0x92, 0x47, 0xc2,
	0xa5, 0x12, 0x6f, 0x3a, 0x5f, 0xa0, 0xcf, 0x59, 0x08, 0x0f, 0x40, 0xdf, 0x56, 0xdb, 0x80, 0x00,
	0xda, 0x4c, 0x9c, 0x8d, 0x3d, 0x41, 0x07, 0x84, 0x09, 0x8c, 0xa1, 0x1e, 0xfa, 0xb4, 0x47, 0x7c,
	0x7c, 0xcf, 0x3c, 0x07, 0x4c, 0xc6, 0xc1, 0x1b, 0xec, 0xc0, 0xb5, 0x08, 0x48, 0x18, 0x75, 0x89,
	0xab, 0x22, 0x71, 0xe1, 0xc8, 0x31, 0x11, 0xb4, 0xcf, 0x23, 0x49, 0xf1, 0x7d, 0xe7, 0x9f, 0xd0,
	0xae, 0xb9, 0xd2, 0x50, 0xd8, 0x83, 0x28, 0x64, 0xf6, 0x68, 0xd2, 0xca, 0x09, 0x66, 0xd2, 0xf2,
	0xc0, 0x79, 0x84, 0x1c, 0xce, 0x7c, 0xdd, 0x23, 0x96, 0x01, 0xe9, 0x0d, 0x7b, 0xf8, 0xa1, 0xf3,
	0x0c, 0xed, 0x0c, 0xa8, 0x90, 0x3c, 0xac, 0x13, 0x66, 0xb8, 0x75, 0xb4, 0x24, 0x7e, 0x04, 0x19,
	0x1a, 0x08, 0xae, 0xa8, 0x6b, 0x80, 0x70, 0xc9, 0xd8, 0x82, 0x3c, 0x0b, 0x0a, 0x75, 0x44, 0x2a,
	0xa2, 0x28, 0xde, 0x06, 0x4b, 0x02, 0x16, 0x50, 0x46, 0x6d, 0x18, 0xfb, 0x5c, 0x0e, 0x98, 0xb2,
	0x4f, 0xdd, 0x4f, 0x21, 0x1d, 0x92, 0xf8, 0x54, 0xd6, 0x27, 0x57, 0x84, 0xf9, 0x78, 0xc7, 0x3c,
	0xa7, 0x5d, 0x03, 0x77, 0x43, 0xa7, 0x61, 0x8f, 0x85, 0x94, 0x9a, 0x6e, 0xfb, 0xd8, 0xd9, 0x43,
	0xcf, 0x4c, 0x55, 0xf2, 0x2f, 0x37, 0x36, 0x42, 0x21, 0x0f, 0xb5, 0xed, 0xcc, 0xf8, 0x09, 0x34,
	0x51, 0x39, 0xe0, 0x42, 0x49, 0xdd, 0x65, 0xca, 0x00, 0xc9, 0xda, 0x77, 0x05, 0xb5, 0x39, 0x7e,
	0xea, 0xec, 0xa2, 0x27, 0x4a, 0x90, 0xd0, 0x88, 0xd9, 0x44, 0x80, 0x88, 0xcf, 0x7b, 0x0c, 0xba,
	0x85, 0xc4, 0xcf, 0xf6, 0x13, 0xb4, 0x3e, 0x28, 0xca, 0x2a, 0xcd, 0xc7, 0x22, 0x19, 0xc3, 0x98,
	0x02, 0x61, 0xe1, 0xd2, 0x5c, 0x0e, 0x41, 0x7b, 0xb6, 0x53, 0xce, 0xdf, 0x9f, 0x0f, 0xfc, 0x3d,
	0x60, 0x5a, 0x52, 0x78, 0x51, 0x93, 0x37, 0xd1, 0xaa, 0xa2, 0x3e, 0x35, 0x79, 0x51, 0x14, 0x37,
	0xf7, 0xff, 0x17, 0xa1, 0xa3, 0xb4, 0x4c, 0x4f, 0xd2, 0x2c, 0xad, 0xce, 0xe1, 0x62, 0x40, 0x83,
	0xe8, 0x30, 0xf3, 0xca, 0xbf, 0x6e, 0x1f, 0xa3, 0xb5, 0xfa, 0x7e, 0x6a, 0x1e, 0x9a, 0xee, 0xff,
	0x08, 0x39, 0x30, 0x86, 0x50, 0x4f, 0x1f, 0x33, 0xd5, 0xd7, 0x3d, 0xce, 0x7b, 0x3e, 0x5c, 0xc7,
	0x1b, 0xf4, 0x41, 0xd4, 0xf1, 0x99, 0x8b, 0x9b, 0xfb, 0x6f, 0x60, 0xe0, 0xc8, 0xab, 0xf8, 0xb4,
	0x82, 0xa9, 0x33, 0x2a, 0xe3, 0x71, 0x02, 0xf1, 0x84, 0x9a, 0x08, 0x25, 0x91, 0x85, 0x5d, 0xae,
	0x23, 0x49, 0x7a, 0x37, 0xab, 0xac, 0xad, 0x7b, 0x06, 0x10, 0xb8, 0x01, 0xbd, 0xfe, 0x98, 0x8b,
	0xd7, 0x76, 0xe4, 0x90, 0x6e, 0x9f, 0x73, 0x1f, 0x37, 0xf7, 0xbf, 0x45, 0x18, 0x1e, 0x61, 0x32,
	0xce, 0xd3, 0x2a, 0xfd, 0xde, 0x0e, 0x76, 0x9f, 0xa1, 0xa7, 0x7d, 0x15, 0xf8, 0x5a, 0x92, 0x90,
	0x29, 0xf6, 0xe6, 0x62, 0xbc, 0x98, 0x37, 0xfd, 0x0c, 0xed, 0xdc, 0x16, 0xf1, 0x98, 0x24, 0x1d,
	0x9f, 0x7a, 0xb8, 0x01, 0x01, 0x91, 0x2c, 0x18, 0xf8, 0x54, 0x77, 0xb9, 0x08, 0x88, 0x32, 0xe1,
	0x37, 0xc7, 0x5f, 0xd8, 0xff, 0x3f, 0xb4, 0xee, 0x16, 0x93, 0xc9, 0x59, 0x05, 0xef, 0xff, 0x6f,
	0x8a, 0x11, 0x18, 0xab, 0x03, 0xab, 0x03, 0xaa, 0xfa, 0xdc, 0xbb, 0xfd, 0x6f, 0x8e, 0x27, 0xd8,
	0x11, 0x00, 0xa9, 0x01, 0x0b, 0x83, 0x00, 0xa6, 0x6c, 0x4d, 0x3d, 0x26, 0xfe, 0x6b, 0x5b, 0xae,
	0x56, 0xd1, 0xb2, 0x3b, 0x74, 0x7d, 0x58, 0x2c, 0x42, 0x2c, 0x6b, 0x31, 0x4d, 0x5c, 0x97, 0x4a,
	0x09, 0x73, 0x03, 0x5e, 0xea, 0x9c, 0xa3, 0xe7, 0xa7, 0xc5, 0xe4, 0x63, 0x63, 0x7e, 0x07, 0xe6,
	0xa7, 0x49, 0x91, 0x0f, 0x60, 0xea, 0x1e, 0x34, 0xde, 0x90, 0x5a, 0x76, 0x5c, 0x64, 0x71, 0x3e,
	0x3e, 0x28, 0x66, 0xe3, 0xc3, 0x71, 0x92, 0x9b, 0x99, 0xfc, 0xd0, 0xb2, 0xe2, 0x69, 0x5a, 0xde,
	0xf9, 0xa7, 0xe8, 0x7f, 0xd8, 0xe5, 0xaf, 0x16, 0x9a, 0xae, 0x92, 0x27, 0x2d, 0xa3, 0xf3, 0x2f,
	0x7f, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x2c, 0x34, 0x27, 0x0b, 0x47, 0x15, 0x00, 0x00,
}
