// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/common/criteria.proto

package common // import "google.golang.org/genproto/googleapis/ads/googleads/v1/common"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A keyword criterion.
type KeywordInfo struct {
	// The text of the keyword (at most 80 characters and 10 words).
	Text *wrappers.StringValue `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The match type of the keyword.
	MatchType            enums.KeywordMatchTypeEnum_KeywordMatchType `protobuf:"varint,2,opt,name=match_type,json=matchType,proto3,enum=google.ads.googleads.v1.enums.KeywordMatchTypeEnum_KeywordMatchType" json:"match_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *KeywordInfo) Reset()         { *m = KeywordInfo{} }
func (m *KeywordInfo) String() string { return proto.CompactTextString(m) }
func (*KeywordInfo) ProtoMessage()    {}
func (*KeywordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{0}
}
func (m *KeywordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeywordInfo.Unmarshal(m, b)
}
func (m *KeywordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeywordInfo.Marshal(b, m, deterministic)
}
func (dst *KeywordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeywordInfo.Merge(dst, src)
}
func (m *KeywordInfo) XXX_Size() int {
	return xxx_messageInfo_KeywordInfo.Size(m)
}
func (m *KeywordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_KeywordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_KeywordInfo proto.InternalMessageInfo

func (m *KeywordInfo) GetText() *wrappers.StringValue {
	if m != nil {
		return m.Text
	}
	return nil
}

func (m *KeywordInfo) GetMatchType() enums.KeywordMatchTypeEnum_KeywordMatchType {
	if m != nil {
		return m.MatchType
	}
	return enums.KeywordMatchTypeEnum_UNSPECIFIED
}

// A placement criterion. This can be used to modify bids for sites when
// targeting the content network.
type PlacementInfo struct {
	// URL of the placement.
	//
	// For example, "http://www.domain.com".
	Url                  *wrappers.StringValue `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PlacementInfo) Reset()         { *m = PlacementInfo{} }
func (m *PlacementInfo) String() string { return proto.CompactTextString(m) }
func (*PlacementInfo) ProtoMessage()    {}
func (*PlacementInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{1}
}
func (m *PlacementInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlacementInfo.Unmarshal(m, b)
}
func (m *PlacementInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlacementInfo.Marshal(b, m, deterministic)
}
func (dst *PlacementInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlacementInfo.Merge(dst, src)
}
func (m *PlacementInfo) XXX_Size() int {
	return xxx_messageInfo_PlacementInfo.Size(m)
}
func (m *PlacementInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_PlacementInfo.DiscardUnknown(m)
}

var xxx_messageInfo_PlacementInfo proto.InternalMessageInfo

func (m *PlacementInfo) GetUrl() *wrappers.StringValue {
	if m != nil {
		return m.Url
	}
	return nil
}

// A mobile app category criterion.
type MobileAppCategoryInfo struct {
	// The mobile app category constant resource name.
	MobileAppCategoryConstant *wrappers.StringValue `protobuf:"bytes,1,opt,name=mobile_app_category_constant,json=mobileAppCategoryConstant,proto3" json:"mobile_app_category_constant,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}              `json:"-"`
	XXX_unrecognized          []byte                `json:"-"`
	XXX_sizecache             int32                 `json:"-"`
}

func (m *MobileAppCategoryInfo) Reset()         { *m = MobileAppCategoryInfo{} }
func (m *MobileAppCategoryInfo) String() string { return proto.CompactTextString(m) }
func (*MobileAppCategoryInfo) ProtoMessage()    {}
func (*MobileAppCategoryInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{2}
}
func (m *MobileAppCategoryInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MobileAppCategoryInfo.Unmarshal(m, b)
}
func (m *MobileAppCategoryInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MobileAppCategoryInfo.Marshal(b, m, deterministic)
}
func (dst *MobileAppCategoryInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MobileAppCategoryInfo.Merge(dst, src)
}
func (m *MobileAppCategoryInfo) XXX_Size() int {
	return xxx_messageInfo_MobileAppCategoryInfo.Size(m)
}
func (m *MobileAppCategoryInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MobileAppCategoryInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MobileAppCategoryInfo proto.InternalMessageInfo

func (m *MobileAppCategoryInfo) GetMobileAppCategoryConstant() *wrappers.StringValue {
	if m != nil {
		return m.MobileAppCategoryConstant
	}
	return nil
}

// A mobile application criterion.
type MobileApplicationInfo struct {
	// A string that uniquely identifies a mobile application to Google Ads API.
	// The format of this string is "{platform}-{platform_native_id}", where
	// platform is "1" for iOS apps and "2" for Android apps, and where
	// platform_native_id is the mobile application identifier native to the
	// corresponding platform.
	// For iOS, this native identifier is the 9 digit string that appears at the
	// end of an App Store URL (e.g., "476943146" for "Flood-It! 2" whose App
	// Store link is http://itunes.apple.com/us/app/flood-it!-2/id476943146).
	// For Android, this native identifier is the application's package name
	// (e.g., "com.labpixies.colordrips" for "Color Drips" given Google Play link
	// https://play.google.com/store/apps/details?id=com.labpixies.colordrips).
	// A well formed app id for Google Ads API would thus be "1-476943146" for iOS
	// and "2-com.labpixies.colordrips" for Android.
	// This field is required and must be set in CREATE operations.
	AppId                *wrappers.StringValue `protobuf:"bytes,2,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MobileApplicationInfo) Reset()         { *m = MobileApplicationInfo{} }
func (m *MobileApplicationInfo) String() string { return proto.CompactTextString(m) }
func (*MobileApplicationInfo) ProtoMessage()    {}
func (*MobileApplicationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{3}
}
func (m *MobileApplicationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MobileApplicationInfo.Unmarshal(m, b)
}
func (m *MobileApplicationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MobileApplicationInfo.Marshal(b, m, deterministic)
}
func (dst *MobileApplicationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MobileApplicationInfo.Merge(dst, src)
}
func (m *MobileApplicationInfo) XXX_Size() int {
	return xxx_messageInfo_MobileApplicationInfo.Size(m)
}
func (m *MobileApplicationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MobileApplicationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MobileApplicationInfo proto.InternalMessageInfo

func (m *MobileApplicationInfo) GetAppId() *wrappers.StringValue {
	if m != nil {
		return m.AppId
	}
	return nil
}

// A location criterion.
type LocationInfo struct {
	// The geo target constant resource name.
	GeoTargetConstant    *wrappers.StringValue `protobuf:"bytes,1,opt,name=geo_target_constant,json=geoTargetConstant,proto3" json:"geo_target_constant,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LocationInfo) Reset()         { *m = LocationInfo{} }
func (m *LocationInfo) String() string { return proto.CompactTextString(m) }
func (*LocationInfo) ProtoMessage()    {}
func (*LocationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{4}
}
func (m *LocationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationInfo.Unmarshal(m, b)
}
func (m *LocationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationInfo.Marshal(b, m, deterministic)
}
func (dst *LocationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationInfo.Merge(dst, src)
}
func (m *LocationInfo) XXX_Size() int {
	return xxx_messageInfo_LocationInfo.Size(m)
}
func (m *LocationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LocationInfo proto.InternalMessageInfo

func (m *LocationInfo) GetGeoTargetConstant() *wrappers.StringValue {
	if m != nil {
		return m.GeoTargetConstant
	}
	return nil
}

// A device criterion.
type DeviceInfo struct {
	// Type of the device.
	Type                 enums.DeviceEnum_Device `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.DeviceEnum_Device" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *DeviceInfo) Reset()         { *m = DeviceInfo{} }
func (m *DeviceInfo) String() string { return proto.CompactTextString(m) }
func (*DeviceInfo) ProtoMessage()    {}
func (*DeviceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{5}
}
func (m *DeviceInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceInfo.Unmarshal(m, b)
}
func (m *DeviceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceInfo.Marshal(b, m, deterministic)
}
func (dst *DeviceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceInfo.Merge(dst, src)
}
func (m *DeviceInfo) XXX_Size() int {
	return xxx_messageInfo_DeviceInfo.Size(m)
}
func (m *DeviceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceInfo proto.InternalMessageInfo

func (m *DeviceInfo) GetType() enums.DeviceEnum_Device {
	if m != nil {
		return m.Type
	}
	return enums.DeviceEnum_UNSPECIFIED
}

// A preferred content criterion.
type PreferredContentInfo struct {
	// Type of the preferred content.
	Type                 enums.PreferredContentTypeEnum_PreferredContentType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.PreferredContentTypeEnum_PreferredContentType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_unrecognized     []byte                                              `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *PreferredContentInfo) Reset()         { *m = PreferredContentInfo{} }
func (m *PreferredContentInfo) String() string { return proto.CompactTextString(m) }
func (*PreferredContentInfo) ProtoMessage()    {}
func (*PreferredContentInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{6}
}
func (m *PreferredContentInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreferredContentInfo.Unmarshal(m, b)
}
func (m *PreferredContentInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreferredContentInfo.Marshal(b, m, deterministic)
}
func (dst *PreferredContentInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreferredContentInfo.Merge(dst, src)
}
func (m *PreferredContentInfo) XXX_Size() int {
	return xxx_messageInfo_PreferredContentInfo.Size(m)
}
func (m *PreferredContentInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_PreferredContentInfo.DiscardUnknown(m)
}

var xxx_messageInfo_PreferredContentInfo proto.InternalMessageInfo

func (m *PreferredContentInfo) GetType() enums.PreferredContentTypeEnum_PreferredContentType {
	if m != nil {
		return m.Type
	}
	return enums.PreferredContentTypeEnum_UNSPECIFIED
}

// A listing group criterion.
type ListingGroupInfo struct {
	// Type of the listing group.
	Type enums.ListingGroupTypeEnum_ListingGroupType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.ListingGroupTypeEnum_ListingGroupType" json:"type,omitempty"`
	// Dimension value with which this listing group is refining its parent.
	// Undefined for the root group.
	CaseValue *ListingDimensionInfo `protobuf:"bytes,2,opt,name=case_value,json=caseValue,proto3" json:"case_value,omitempty"`
	// Resource name of ad group criterion which is the parent listing group
	// subdivision. Null for the root group.
	ParentAdGroupCriterion *wrappers.StringValue `protobuf:"bytes,3,opt,name=parent_ad_group_criterion,json=parentAdGroupCriterion,proto3" json:"parent_ad_group_criterion,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}              `json:"-"`
	XXX_unrecognized       []byte                `json:"-"`
	XXX_sizecache          int32                 `json:"-"`
}

func (m *ListingGroupInfo) Reset()         { *m = ListingGroupInfo{} }
func (m *ListingGroupInfo) String() string { return proto.CompactTextString(m) }
func (*ListingGroupInfo) ProtoMessage()    {}
func (*ListingGroupInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{7}
}
func (m *ListingGroupInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingGroupInfo.Unmarshal(m, b)
}
func (m *ListingGroupInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingGroupInfo.Marshal(b, m, deterministic)
}
func (dst *ListingGroupInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingGroupInfo.Merge(dst, src)
}
func (m *ListingGroupInfo) XXX_Size() int {
	return xxx_messageInfo_ListingGroupInfo.Size(m)
}
func (m *ListingGroupInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingGroupInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingGroupInfo proto.InternalMessageInfo

func (m *ListingGroupInfo) GetType() enums.ListingGroupTypeEnum_ListingGroupType {
	if m != nil {
		return m.Type
	}
	return enums.ListingGroupTypeEnum_UNSPECIFIED
}

func (m *ListingGroupInfo) GetCaseValue() *ListingDimensionInfo {
	if m != nil {
		return m.CaseValue
	}
	return nil
}

func (m *ListingGroupInfo) GetParentAdGroupCriterion() *wrappers.StringValue {
	if m != nil {
		return m.ParentAdGroupCriterion
	}
	return nil
}

// A listing scope criterion.
type ListingScopeInfo struct {
	// Scope of the campaign criterion.
	Dimensions           []*ListingDimensionInfo `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ListingScopeInfo) Reset()         { *m = ListingScopeInfo{} }
func (m *ListingScopeInfo) String() string { return proto.CompactTextString(m) }
func (*ListingScopeInfo) ProtoMessage()    {}
func (*ListingScopeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{8}
}
func (m *ListingScopeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingScopeInfo.Unmarshal(m, b)
}
func (m *ListingScopeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingScopeInfo.Marshal(b, m, deterministic)
}
func (dst *ListingScopeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingScopeInfo.Merge(dst, src)
}
func (m *ListingScopeInfo) XXX_Size() int {
	return xxx_messageInfo_ListingScopeInfo.Size(m)
}
func (m *ListingScopeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingScopeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingScopeInfo proto.InternalMessageInfo

func (m *ListingScopeInfo) GetDimensions() []*ListingDimensionInfo {
	if m != nil {
		return m.Dimensions
	}
	return nil
}

// Listing dimensions for listing group criterion.
type ListingDimensionInfo struct {
	// Dimension of one of the types below is always present.
	//
	// Types that are valid to be assigned to Dimension:
	//	*ListingDimensionInfo_ListingBrand
	//	*ListingDimensionInfo_HotelId
	//	*ListingDimensionInfo_HotelClass
	//	*ListingDimensionInfo_HotelCountryRegion
	//	*ListingDimensionInfo_HotelState
	//	*ListingDimensionInfo_HotelCity
	//	*ListingDimensionInfo_ListingCustomAttribute
	//	*ListingDimensionInfo_ProductBiddingCategory
	//	*ListingDimensionInfo_ProductChannel
	//	*ListingDimensionInfo_ProductChannelExclusivity
	//	*ListingDimensionInfo_ProductCondition
	//	*ListingDimensionInfo_ProductItemId
	//	*ListingDimensionInfo_ProductType
	Dimension            isListingDimensionInfo_Dimension `protobuf_oneof:"dimension"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *ListingDimensionInfo) Reset()         { *m = ListingDimensionInfo{} }
func (m *ListingDimensionInfo) String() string { return proto.CompactTextString(m) }
func (*ListingDimensionInfo) ProtoMessage()    {}
func (*ListingDimensionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{9}
}
func (m *ListingDimensionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingDimensionInfo.Unmarshal(m, b)
}
func (m *ListingDimensionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingDimensionInfo.Marshal(b, m, deterministic)
}
func (dst *ListingDimensionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingDimensionInfo.Merge(dst, src)
}
func (m *ListingDimensionInfo) XXX_Size() int {
	return xxx_messageInfo_ListingDimensionInfo.Size(m)
}
func (m *ListingDimensionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingDimensionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingDimensionInfo proto.InternalMessageInfo

type isListingDimensionInfo_Dimension interface {
	isListingDimensionInfo_Dimension()
}

type ListingDimensionInfo_ListingBrand struct {
	ListingBrand *ListingBrandInfo `protobuf:"bytes,1,opt,name=listing_brand,json=listingBrand,proto3,oneof"`
}

type ListingDimensionInfo_HotelId struct {
	HotelId *HotelIdInfo `protobuf:"bytes,2,opt,name=hotel_id,json=hotelId,proto3,oneof"`
}

type ListingDimensionInfo_HotelClass struct {
	HotelClass *HotelClassInfo `protobuf:"bytes,3,opt,name=hotel_class,json=hotelClass,proto3,oneof"`
}

type ListingDimensionInfo_HotelCountryRegion struct {
	HotelCountryRegion *HotelCountryRegionInfo `protobuf:"bytes,4,opt,name=hotel_country_region,json=hotelCountryRegion,proto3,oneof"`
}

type ListingDimensionInfo_HotelState struct {
	HotelState *HotelStateInfo `protobuf:"bytes,5,opt,name=hotel_state,json=hotelState,proto3,oneof"`
}

type ListingDimensionInfo_HotelCity struct {
	HotelCity *HotelCityInfo `protobuf:"bytes,6,opt,name=hotel_city,json=hotelCity,proto3,oneof"`
}

type ListingDimensionInfo_ListingCustomAttribute struct {
	ListingCustomAttribute *ListingCustomAttributeInfo `protobuf:"bytes,7,opt,name=listing_custom_attribute,json=listingCustomAttribute,proto3,oneof"`
}

type ListingDimensionInfo_ProductBiddingCategory struct {
	ProductBiddingCategory *ProductBiddingCategoryInfo `protobuf:"bytes,13,opt,name=product_bidding_category,json=productBiddingCategory,proto3,oneof"`
}

type ListingDimensionInfo_ProductChannel struct {
	ProductChannel *ProductChannelInfo `protobuf:"bytes,8,opt,name=product_channel,json=productChannel,proto3,oneof"`
}

type ListingDimensionInfo_ProductChannelExclusivity struct {
	ProductChannelExclusivity *ProductChannelExclusivityInfo `protobuf:"bytes,9,opt,name=product_channel_exclusivity,json=productChannelExclusivity,proto3,oneof"`
}

type ListingDimensionInfo_ProductCondition struct {
	ProductCondition *ProductConditionInfo `protobuf:"bytes,10,opt,name=product_condition,json=productCondition,proto3,oneof"`
}

type ListingDimensionInfo_ProductItemId struct {
	ProductItemId *ProductItemIdInfo `protobuf:"bytes,11,opt,name=product_item_id,json=productItemId,proto3,oneof"`
}

type ListingDimensionInfo_ProductType struct {
	ProductType *ProductTypeInfo `protobuf:"bytes,12,opt,name=product_type,json=productType,proto3,oneof"`
}

func (*ListingDimensionInfo_ListingBrand) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelId) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelClass) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelCountryRegion) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelState) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_HotelCity) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ListingCustomAttribute) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductBiddingCategory) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductChannel) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductChannelExclusivity) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductCondition) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductItemId) isListingDimensionInfo_Dimension() {}

func (*ListingDimensionInfo_ProductType) isListingDimensionInfo_Dimension() {}

func (m *ListingDimensionInfo) GetDimension() isListingDimensionInfo_Dimension {
	if m != nil {
		return m.Dimension
	}
	return nil
}

func (m *ListingDimensionInfo) GetListingBrand() *ListingBrandInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ListingBrand); ok {
		return x.ListingBrand
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelId() *HotelIdInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelId); ok {
		return x.HotelId
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelClass() *HotelClassInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelClass); ok {
		return x.HotelClass
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelCountryRegion() *HotelCountryRegionInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelCountryRegion); ok {
		return x.HotelCountryRegion
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelState() *HotelStateInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelState); ok {
		return x.HotelState
	}
	return nil
}

func (m *ListingDimensionInfo) GetHotelCity() *HotelCityInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_HotelCity); ok {
		return x.HotelCity
	}
	return nil
}

func (m *ListingDimensionInfo) GetListingCustomAttribute() *ListingCustomAttributeInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ListingCustomAttribute); ok {
		return x.ListingCustomAttribute
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductBiddingCategory() *ProductBiddingCategoryInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductBiddingCategory); ok {
		return x.ProductBiddingCategory
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductChannel() *ProductChannelInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductChannel); ok {
		return x.ProductChannel
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductChannelExclusivity() *ProductChannelExclusivityInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductChannelExclusivity); ok {
		return x.ProductChannelExclusivity
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductCondition() *ProductConditionInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductCondition); ok {
		return x.ProductCondition
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductItemId() *ProductItemIdInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductItemId); ok {
		return x.ProductItemId
	}
	return nil
}

func (m *ListingDimensionInfo) GetProductType() *ProductTypeInfo {
	if x, ok := m.GetDimension().(*ListingDimensionInfo_ProductType); ok {
		return x.ProductType
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ListingDimensionInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ListingDimensionInfo_OneofMarshaler, _ListingDimensionInfo_OneofUnmarshaler, _ListingDimensionInfo_OneofSizer, []interface{}{
		(*ListingDimensionInfo_ListingBrand)(nil),
		(*ListingDimensionInfo_HotelId)(nil),
		(*ListingDimensionInfo_HotelClass)(nil),
		(*ListingDimensionInfo_HotelCountryRegion)(nil),
		(*ListingDimensionInfo_HotelState)(nil),
		(*ListingDimensionInfo_HotelCity)(nil),
		(*ListingDimensionInfo_ListingCustomAttribute)(nil),
		(*ListingDimensionInfo_ProductBiddingCategory)(nil),
		(*ListingDimensionInfo_ProductChannel)(nil),
		(*ListingDimensionInfo_ProductChannelExclusivity)(nil),
		(*ListingDimensionInfo_ProductCondition)(nil),
		(*ListingDimensionInfo_ProductItemId)(nil),
		(*ListingDimensionInfo_ProductType)(nil),
	}
}

func _ListingDimensionInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ListingDimensionInfo)
	// dimension
	switch x := m.Dimension.(type) {
	case *ListingDimensionInfo_ListingBrand:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ListingBrand); err != nil {
			return err
		}
	case *ListingDimensionInfo_HotelId:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotelId); err != nil {
			return err
		}
	case *ListingDimensionInfo_HotelClass:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotelClass); err != nil {
			return err
		}
	case *ListingDimensionInfo_HotelCountryRegion:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotelCountryRegion); err != nil {
			return err
		}
	case *ListingDimensionInfo_HotelState:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotelState); err != nil {
			return err
		}
	case *ListingDimensionInfo_HotelCity:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotelCity); err != nil {
			return err
		}
	case *ListingDimensionInfo_ListingCustomAttribute:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ListingCustomAttribute); err != nil {
			return err
		}
	case *ListingDimensionInfo_ProductBiddingCategory:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProductBiddingCategory); err != nil {
			return err
		}
	case *ListingDimensionInfo_ProductChannel:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProductChannel); err != nil {
			return err
		}
	case *ListingDimensionInfo_ProductChannelExclusivity:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProductChannelExclusivity); err != nil {
			return err
		}
	case *ListingDimensionInfo_ProductCondition:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProductCondition); err != nil {
			return err
		}
	case *ListingDimensionInfo_ProductItemId:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProductItemId); err != nil {
			return err
		}
	case *ListingDimensionInfo_ProductType:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProductType); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ListingDimensionInfo.Dimension has unexpected type %T", x)
	}
	return nil
}

func _ListingDimensionInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ListingDimensionInfo)
	switch tag {
	case 1: // dimension.listing_brand
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ListingBrandInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_ListingBrand{msg}
		return true, err
	case 2: // dimension.hotel_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HotelIdInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_HotelId{msg}
		return true, err
	case 3: // dimension.hotel_class
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HotelClassInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_HotelClass{msg}
		return true, err
	case 4: // dimension.hotel_country_region
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HotelCountryRegionInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_HotelCountryRegion{msg}
		return true, err
	case 5: // dimension.hotel_state
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HotelStateInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_HotelState{msg}
		return true, err
	case 6: // dimension.hotel_city
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HotelCityInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_HotelCity{msg}
		return true, err
	case 7: // dimension.listing_custom_attribute
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ListingCustomAttributeInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_ListingCustomAttribute{msg}
		return true, err
	case 13: // dimension.product_bidding_category
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProductBiddingCategoryInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_ProductBiddingCategory{msg}
		return true, err
	case 8: // dimension.product_channel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProductChannelInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_ProductChannel{msg}
		return true, err
	case 9: // dimension.product_channel_exclusivity
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProductChannelExclusivityInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_ProductChannelExclusivity{msg}
		return true, err
	case 10: // dimension.product_condition
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProductConditionInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_ProductCondition{msg}
		return true, err
	case 11: // dimension.product_item_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProductItemIdInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_ProductItemId{msg}
		return true, err
	case 12: // dimension.product_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProductTypeInfo)
		err := b.DecodeMessage(msg)
		m.Dimension = &ListingDimensionInfo_ProductType{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ListingDimensionInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ListingDimensionInfo)
	// dimension
	switch x := m.Dimension.(type) {
	case *ListingDimensionInfo_ListingBrand:
		s := proto.Size(x.ListingBrand)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_HotelId:
		s := proto.Size(x.HotelId)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_HotelClass:
		s := proto.Size(x.HotelClass)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_HotelCountryRegion:
		s := proto.Size(x.HotelCountryRegion)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_HotelState:
		s := proto.Size(x.HotelState)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_HotelCity:
		s := proto.Size(x.HotelCity)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_ListingCustomAttribute:
		s := proto.Size(x.ListingCustomAttribute)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_ProductBiddingCategory:
		s := proto.Size(x.ProductBiddingCategory)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_ProductChannel:
		s := proto.Size(x.ProductChannel)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_ProductChannelExclusivity:
		s := proto.Size(x.ProductChannelExclusivity)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_ProductCondition:
		s := proto.Size(x.ProductCondition)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_ProductItemId:
		s := proto.Size(x.ProductItemId)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListingDimensionInfo_ProductType:
		s := proto.Size(x.ProductType)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Brand of the listing.
type ListingBrandInfo struct {
	// String value of the listing brand.
	Value                *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListingBrandInfo) Reset()         { *m = ListingBrandInfo{} }
func (m *ListingBrandInfo) String() string { return proto.CompactTextString(m) }
func (*ListingBrandInfo) ProtoMessage()    {}
func (*ListingBrandInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{10}
}
func (m *ListingBrandInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingBrandInfo.Unmarshal(m, b)
}
func (m *ListingBrandInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingBrandInfo.Marshal(b, m, deterministic)
}
func (dst *ListingBrandInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingBrandInfo.Merge(dst, src)
}
func (m *ListingBrandInfo) XXX_Size() int {
	return xxx_messageInfo_ListingBrandInfo.Size(m)
}
func (m *ListingBrandInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingBrandInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingBrandInfo proto.InternalMessageInfo

func (m *ListingBrandInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// Advertiser-specific hotel ID.
type HotelIdInfo struct {
	// String value of the hotel ID.
	Value                *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HotelIdInfo) Reset()         { *m = HotelIdInfo{} }
func (m *HotelIdInfo) String() string { return proto.CompactTextString(m) }
func (*HotelIdInfo) ProtoMessage()    {}
func (*HotelIdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{11}
}
func (m *HotelIdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelIdInfo.Unmarshal(m, b)
}
func (m *HotelIdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelIdInfo.Marshal(b, m, deterministic)
}
func (dst *HotelIdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelIdInfo.Merge(dst, src)
}
func (m *HotelIdInfo) XXX_Size() int {
	return xxx_messageInfo_HotelIdInfo.Size(m)
}
func (m *HotelIdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelIdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelIdInfo proto.InternalMessageInfo

func (m *HotelIdInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// Class of the hotel as a number of stars 1 to 5.
type HotelClassInfo struct {
	// Long value of the hotel class.
	Value                *wrappers.Int64Value `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *HotelClassInfo) Reset()         { *m = HotelClassInfo{} }
func (m *HotelClassInfo) String() string { return proto.CompactTextString(m) }
func (*HotelClassInfo) ProtoMessage()    {}
func (*HotelClassInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{12}
}
func (m *HotelClassInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelClassInfo.Unmarshal(m, b)
}
func (m *HotelClassInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelClassInfo.Marshal(b, m, deterministic)
}
func (dst *HotelClassInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelClassInfo.Merge(dst, src)
}
func (m *HotelClassInfo) XXX_Size() int {
	return xxx_messageInfo_HotelClassInfo.Size(m)
}
func (m *HotelClassInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelClassInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelClassInfo proto.InternalMessageInfo

func (m *HotelClassInfo) GetValue() *wrappers.Int64Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// Country or Region the hotel is located in.
type HotelCountryRegionInfo struct {
	// The Geo Target Constant resource name.
	CountryRegionCriterion *wrappers.StringValue `protobuf:"bytes,1,opt,name=country_region_criterion,json=countryRegionCriterion,proto3" json:"country_region_criterion,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}              `json:"-"`
	XXX_unrecognized       []byte                `json:"-"`
	XXX_sizecache          int32                 `json:"-"`
}

func (m *HotelCountryRegionInfo) Reset()         { *m = HotelCountryRegionInfo{} }
func (m *HotelCountryRegionInfo) String() string { return proto.CompactTextString(m) }
func (*HotelCountryRegionInfo) ProtoMessage()    {}
func (*HotelCountryRegionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{13}
}
func (m *HotelCountryRegionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelCountryRegionInfo.Unmarshal(m, b)
}
func (m *HotelCountryRegionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelCountryRegionInfo.Marshal(b, m, deterministic)
}
func (dst *HotelCountryRegionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelCountryRegionInfo.Merge(dst, src)
}
func (m *HotelCountryRegionInfo) XXX_Size() int {
	return xxx_messageInfo_HotelCountryRegionInfo.Size(m)
}
func (m *HotelCountryRegionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelCountryRegionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelCountryRegionInfo proto.InternalMessageInfo

func (m *HotelCountryRegionInfo) GetCountryRegionCriterion() *wrappers.StringValue {
	if m != nil {
		return m.CountryRegionCriterion
	}
	return nil
}

// State the hotel is located in.
type HotelStateInfo struct {
	// The Geo Target Constant resource name.
	StateCriterion       *wrappers.StringValue `protobuf:"bytes,1,opt,name=state_criterion,json=stateCriterion,proto3" json:"state_criterion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HotelStateInfo) Reset()         { *m = HotelStateInfo{} }
func (m *HotelStateInfo) String() string { return proto.CompactTextString(m) }
func (*HotelStateInfo) ProtoMessage()    {}
func (*HotelStateInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{14}
}
func (m *HotelStateInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelStateInfo.Unmarshal(m, b)
}
func (m *HotelStateInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelStateInfo.Marshal(b, m, deterministic)
}
func (dst *HotelStateInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelStateInfo.Merge(dst, src)
}
func (m *HotelStateInfo) XXX_Size() int {
	return xxx_messageInfo_HotelStateInfo.Size(m)
}
func (m *HotelStateInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelStateInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelStateInfo proto.InternalMessageInfo

func (m *HotelStateInfo) GetStateCriterion() *wrappers.StringValue {
	if m != nil {
		return m.StateCriterion
	}
	return nil
}

// City the hotel is located in.
type HotelCityInfo struct {
	// The Geo Target Constant resource name.
	CityCriterion        *wrappers.StringValue `protobuf:"bytes,1,opt,name=city_criterion,json=cityCriterion,proto3" json:"city_criterion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HotelCityInfo) Reset()         { *m = HotelCityInfo{} }
func (m *HotelCityInfo) String() string { return proto.CompactTextString(m) }
func (*HotelCityInfo) ProtoMessage()    {}
func (*HotelCityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{15}
}
func (m *HotelCityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelCityInfo.Unmarshal(m, b)
}
func (m *HotelCityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelCityInfo.Marshal(b, m, deterministic)
}
func (dst *HotelCityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelCityInfo.Merge(dst, src)
}
func (m *HotelCityInfo) XXX_Size() int {
	return xxx_messageInfo_HotelCityInfo.Size(m)
}
func (m *HotelCityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelCityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelCityInfo proto.InternalMessageInfo

func (m *HotelCityInfo) GetCityCriterion() *wrappers.StringValue {
	if m != nil {
		return m.CityCriterion
	}
	return nil
}

// Listing custom attribute.
type ListingCustomAttributeInfo struct {
	// String value of the listing custom attribute.
	Value *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Indicates the index of the custom attribute.
	Index                enums.ListingCustomAttributeIndexEnum_ListingCustomAttributeIndex `protobuf:"varint,2,opt,name=index,proto3,enum=google.ads.googleads.v1.enums.ListingCustomAttributeIndexEnum_ListingCustomAttributeIndex" json:"index,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                          `json:"-"`
	XXX_unrecognized     []byte                                                            `json:"-"`
	XXX_sizecache        int32                                                             `json:"-"`
}

func (m *ListingCustomAttributeInfo) Reset()         { *m = ListingCustomAttributeInfo{} }
func (m *ListingCustomAttributeInfo) String() string { return proto.CompactTextString(m) }
func (*ListingCustomAttributeInfo) ProtoMessage()    {}
func (*ListingCustomAttributeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{16}
}
func (m *ListingCustomAttributeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListingCustomAttributeInfo.Unmarshal(m, b)
}
func (m *ListingCustomAttributeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListingCustomAttributeInfo.Marshal(b, m, deterministic)
}
func (dst *ListingCustomAttributeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListingCustomAttributeInfo.Merge(dst, src)
}
func (m *ListingCustomAttributeInfo) XXX_Size() int {
	return xxx_messageInfo_ListingCustomAttributeInfo.Size(m)
}
func (m *ListingCustomAttributeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListingCustomAttributeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListingCustomAttributeInfo proto.InternalMessageInfo

func (m *ListingCustomAttributeInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ListingCustomAttributeInfo) GetIndex() enums.ListingCustomAttributeIndexEnum_ListingCustomAttributeIndex {
	if m != nil {
		return m.Index
	}
	return enums.ListingCustomAttributeIndexEnum_UNSPECIFIED
}

// Bidding category of a product offer.
type ProductBiddingCategoryInfo struct {
	// ID of the product bidding category.
	//
	// This ID is equivalent to the google_product_category ID as described in
	// this article: https://support.google.com/merchants/answer/6324436.
	Id *wrappers.Int64Value `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Two-letter upper-case country code of the product bidding category. It must
	// match the campaign.shopping_setting.sales_country field.
	CountryCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Level of the product bidding category.
	Level                enums.ProductBiddingCategoryLevelEnum_ProductBiddingCategoryLevel `protobuf:"varint,3,opt,name=level,proto3,enum=google.ads.googleads.v1.enums.ProductBiddingCategoryLevelEnum_ProductBiddingCategoryLevel" json:"level,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                          `json:"-"`
	XXX_unrecognized     []byte                                                            `json:"-"`
	XXX_sizecache        int32                                                             `json:"-"`
}

func (m *ProductBiddingCategoryInfo) Reset()         { *m = ProductBiddingCategoryInfo{} }
func (m *ProductBiddingCategoryInfo) String() string { return proto.CompactTextString(m) }
func (*ProductBiddingCategoryInfo) ProtoMessage()    {}
func (*ProductBiddingCategoryInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{17}
}
func (m *ProductBiddingCategoryInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductBiddingCategoryInfo.Unmarshal(m, b)
}
func (m *ProductBiddingCategoryInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductBiddingCategoryInfo.Marshal(b, m, deterministic)
}
func (dst *ProductBiddingCategoryInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductBiddingCategoryInfo.Merge(dst, src)
}
func (m *ProductBiddingCategoryInfo) XXX_Size() int {
	return xxx_messageInfo_ProductBiddingCategoryInfo.Size(m)
}
func (m *ProductBiddingCategoryInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductBiddingCategoryInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductBiddingCategoryInfo proto.InternalMessageInfo

func (m *ProductBiddingCategoryInfo) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *ProductBiddingCategoryInfo) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *ProductBiddingCategoryInfo) GetLevel() enums.ProductBiddingCategoryLevelEnum_ProductBiddingCategoryLevel {
	if m != nil {
		return m.Level
	}
	return enums.ProductBiddingCategoryLevelEnum_UNSPECIFIED
}

// Locality of a product offer.
type ProductChannelInfo struct {
	// Value of the locality.
	Channel              enums.ProductChannelEnum_ProductChannel `protobuf:"varint,1,opt,name=channel,proto3,enum=google.ads.googleads.v1.enums.ProductChannelEnum_ProductChannel" json:"channel,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *ProductChannelInfo) Reset()         { *m = ProductChannelInfo{} }
func (m *ProductChannelInfo) String() string { return proto.CompactTextString(m) }
func (*ProductChannelInfo) ProtoMessage()    {}
func (*ProductChannelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{18}
}
func (m *ProductChannelInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductChannelInfo.Unmarshal(m, b)
}
func (m *ProductChannelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductChannelInfo.Marshal(b, m, deterministic)
}
func (dst *ProductChannelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductChannelInfo.Merge(dst, src)
}
func (m *ProductChannelInfo) XXX_Size() int {
	return xxx_messageInfo_ProductChannelInfo.Size(m)
}
func (m *ProductChannelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductChannelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductChannelInfo proto.InternalMessageInfo

func (m *ProductChannelInfo) GetChannel() enums.ProductChannelEnum_ProductChannel {
	if m != nil {
		return m.Channel
	}
	return enums.ProductChannelEnum_UNSPECIFIED
}

// Availability of a product offer.
type ProductChannelExclusivityInfo struct {
	// Value of the availability.
	ChannelExclusivity   enums.ProductChannelExclusivityEnum_ProductChannelExclusivity `protobuf:"varint,1,opt,name=channel_exclusivity,json=channelExclusivity,proto3,enum=google.ads.googleads.v1.enums.ProductChannelExclusivityEnum_ProductChannelExclusivity" json:"channel_exclusivity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                      `json:"-"`
	XXX_unrecognized     []byte                                                        `json:"-"`
	XXX_sizecache        int32                                                         `json:"-"`
}

func (m *ProductChannelExclusivityInfo) Reset()         { *m = ProductChannelExclusivityInfo{} }
func (m *ProductChannelExclusivityInfo) String() string { return proto.CompactTextString(m) }
func (*ProductChannelExclusivityInfo) ProtoMessage()    {}
func (*ProductChannelExclusivityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{19}
}
func (m *ProductChannelExclusivityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductChannelExclusivityInfo.Unmarshal(m, b)
}
func (m *ProductChannelExclusivityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductChannelExclusivityInfo.Marshal(b, m, deterministic)
}
func (dst *ProductChannelExclusivityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductChannelExclusivityInfo.Merge(dst, src)
}
func (m *ProductChannelExclusivityInfo) XXX_Size() int {
	return xxx_messageInfo_ProductChannelExclusivityInfo.Size(m)
}
func (m *ProductChannelExclusivityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductChannelExclusivityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductChannelExclusivityInfo proto.InternalMessageInfo

func (m *ProductChannelExclusivityInfo) GetChannelExclusivity() enums.ProductChannelExclusivityEnum_ProductChannelExclusivity {
	if m != nil {
		return m.ChannelExclusivity
	}
	return enums.ProductChannelExclusivityEnum_UNSPECIFIED
}

// Condition of a product offer.
type ProductConditionInfo struct {
	// Value of the condition.
	Condition            enums.ProductConditionEnum_ProductCondition `protobuf:"varint,1,opt,name=condition,proto3,enum=google.ads.googleads.v1.enums.ProductConditionEnum_ProductCondition" json:"condition,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ProductConditionInfo) Reset()         { *m = ProductConditionInfo{} }
func (m *ProductConditionInfo) String() string { return proto.CompactTextString(m) }
func (*ProductConditionInfo) ProtoMessage()    {}
func (*ProductConditionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{20}
}
func (m *ProductConditionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductConditionInfo.Unmarshal(m, b)
}
func (m *ProductConditionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductConditionInfo.Marshal(b, m, deterministic)
}
func (dst *ProductConditionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductConditionInfo.Merge(dst, src)
}
func (m *ProductConditionInfo) XXX_Size() int {
	return xxx_messageInfo_ProductConditionInfo.Size(m)
}
func (m *ProductConditionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductConditionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductConditionInfo proto.InternalMessageInfo

func (m *ProductConditionInfo) GetCondition() enums.ProductConditionEnum_ProductCondition {
	if m != nil {
		return m.Condition
	}
	return enums.ProductConditionEnum_UNSPECIFIED
}

// Item id of a product offer.
type ProductItemIdInfo struct {
	// Value of the id.
	Value                *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ProductItemIdInfo) Reset()         { *m = ProductItemIdInfo{} }
func (m *ProductItemIdInfo) String() string { return proto.CompactTextString(m) }
func (*ProductItemIdInfo) ProtoMessage()    {}
func (*ProductItemIdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{21}
}
func (m *ProductItemIdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductItemIdInfo.Unmarshal(m, b)
}
func (m *ProductItemIdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductItemIdInfo.Marshal(b, m, deterministic)
}
func (dst *ProductItemIdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductItemIdInfo.Merge(dst, src)
}
func (m *ProductItemIdInfo) XXX_Size() int {
	return xxx_messageInfo_ProductItemIdInfo.Size(m)
}
func (m *ProductItemIdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductItemIdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductItemIdInfo proto.InternalMessageInfo

func (m *ProductItemIdInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// Type of a product offer.
type ProductTypeInfo struct {
	// Value of the type.
	Value *wrappers.StringValue `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Level of the type.
	Level                enums.ProductTypeLevelEnum_ProductTypeLevel `protobuf:"varint,2,opt,name=level,proto3,enum=google.ads.googleads.v1.enums.ProductTypeLevelEnum_ProductTypeLevel" json:"level,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ProductTypeInfo) Reset()         { *m = ProductTypeInfo{} }
func (m *ProductTypeInfo) String() string { return proto.CompactTextString(m) }
func (*ProductTypeInfo) ProtoMessage()    {}
func (*ProductTypeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{22}
}
func (m *ProductTypeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductTypeInfo.Unmarshal(m, b)
}
func (m *ProductTypeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductTypeInfo.Marshal(b, m, deterministic)
}
func (dst *ProductTypeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductTypeInfo.Merge(dst, src)
}
func (m *ProductTypeInfo) XXX_Size() int {
	return xxx_messageInfo_ProductTypeInfo.Size(m)
}
func (m *ProductTypeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductTypeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductTypeInfo proto.InternalMessageInfo

func (m *ProductTypeInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ProductTypeInfo) GetLevel() enums.ProductTypeLevelEnum_ProductTypeLevel {
	if m != nil {
		return m.Level
	}
	return enums.ProductTypeLevelEnum_UNSPECIFIED
}

// Criterion for hotel date selection (default dates vs. user selected).
type HotelDateSelectionTypeInfo struct {
	// Type of the hotel date selection
	Type                 enums.HotelDateSelectionTypeEnum_HotelDateSelectionType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.HotelDateSelectionTypeEnum_HotelDateSelectionType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                `json:"-"`
	XXX_unrecognized     []byte                                                  `json:"-"`
	XXX_sizecache        int32                                                   `json:"-"`
}

func (m *HotelDateSelectionTypeInfo) Reset()         { *m = HotelDateSelectionTypeInfo{} }
func (m *HotelDateSelectionTypeInfo) String() string { return proto.CompactTextString(m) }
func (*HotelDateSelectionTypeInfo) ProtoMessage()    {}
func (*HotelDateSelectionTypeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{23}
}
func (m *HotelDateSelectionTypeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelDateSelectionTypeInfo.Unmarshal(m, b)
}
func (m *HotelDateSelectionTypeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelDateSelectionTypeInfo.Marshal(b, m, deterministic)
}
func (dst *HotelDateSelectionTypeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelDateSelectionTypeInfo.Merge(dst, src)
}
func (m *HotelDateSelectionTypeInfo) XXX_Size() int {
	return xxx_messageInfo_HotelDateSelectionTypeInfo.Size(m)
}
func (m *HotelDateSelectionTypeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelDateSelectionTypeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelDateSelectionTypeInfo proto.InternalMessageInfo

func (m *HotelDateSelectionTypeInfo) GetType() enums.HotelDateSelectionTypeEnum_HotelDateSelectionType {
	if m != nil {
		return m.Type
	}
	return enums.HotelDateSelectionTypeEnum_UNSPECIFIED
}

// Criterion for number of days prior to the stay the booking is being made.
type HotelAdvanceBookingWindowInfo struct {
	// Low end of the number of days prior to the stay.
	MinDays *wrappers.Int64Value `protobuf:"bytes,1,opt,name=min_days,json=minDays,proto3" json:"min_days,omitempty"`
	// High end of the number of days prior to the stay.
	MaxDays              *wrappers.Int64Value `protobuf:"bytes,2,opt,name=max_days,json=maxDays,proto3" json:"max_days,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *HotelAdvanceBookingWindowInfo) Reset()         { *m = HotelAdvanceBookingWindowInfo{} }
func (m *HotelAdvanceBookingWindowInfo) String() string { return proto.CompactTextString(m) }
func (*HotelAdvanceBookingWindowInfo) ProtoMessage()    {}
func (*HotelAdvanceBookingWindowInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{24}
}
func (m *HotelAdvanceBookingWindowInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelAdvanceBookingWindowInfo.Unmarshal(m, b)
}
func (m *HotelAdvanceBookingWindowInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelAdvanceBookingWindowInfo.Marshal(b, m, deterministic)
}
func (dst *HotelAdvanceBookingWindowInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelAdvanceBookingWindowInfo.Merge(dst, src)
}
func (m *HotelAdvanceBookingWindowInfo) XXX_Size() int {
	return xxx_messageInfo_HotelAdvanceBookingWindowInfo.Size(m)
}
func (m *HotelAdvanceBookingWindowInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelAdvanceBookingWindowInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelAdvanceBookingWindowInfo proto.InternalMessageInfo

func (m *HotelAdvanceBookingWindowInfo) GetMinDays() *wrappers.Int64Value {
	if m != nil {
		return m.MinDays
	}
	return nil
}

func (m *HotelAdvanceBookingWindowInfo) GetMaxDays() *wrappers.Int64Value {
	if m != nil {
		return m.MaxDays
	}
	return nil
}

// Criterion for length of hotel stay in nights.
type HotelLengthOfStayInfo struct {
	// Low end of the number of nights in the stay.
	MinNights *wrappers.Int64Value `protobuf:"bytes,1,opt,name=min_nights,json=minNights,proto3" json:"min_nights,omitempty"`
	// High end of the number of nights in the stay.
	MaxNights            *wrappers.Int64Value `protobuf:"bytes,2,opt,name=max_nights,json=maxNights,proto3" json:"max_nights,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *HotelLengthOfStayInfo) Reset()         { *m = HotelLengthOfStayInfo{} }
func (m *HotelLengthOfStayInfo) String() string { return proto.CompactTextString(m) }
func (*HotelLengthOfStayInfo) ProtoMessage()    {}
func (*HotelLengthOfStayInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{25}
}
func (m *HotelLengthOfStayInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelLengthOfStayInfo.Unmarshal(m, b)
}
func (m *HotelLengthOfStayInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelLengthOfStayInfo.Marshal(b, m, deterministic)
}
func (dst *HotelLengthOfStayInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelLengthOfStayInfo.Merge(dst, src)
}
func (m *HotelLengthOfStayInfo) XXX_Size() int {
	return xxx_messageInfo_HotelLengthOfStayInfo.Size(m)
}
func (m *HotelLengthOfStayInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelLengthOfStayInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelLengthOfStayInfo proto.InternalMessageInfo

func (m *HotelLengthOfStayInfo) GetMinNights() *wrappers.Int64Value {
	if m != nil {
		return m.MinNights
	}
	return nil
}

func (m *HotelLengthOfStayInfo) GetMaxNights() *wrappers.Int64Value {
	if m != nil {
		return m.MaxNights
	}
	return nil
}

// Criterion for day of the week the booking is for.
type HotelCheckInDayInfo struct {
	// The day of the week.
	DayOfWeek            enums.DayOfWeekEnum_DayOfWeek `protobuf:"varint,1,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.ads.googleads.v1.enums.DayOfWeekEnum_DayOfWeek" json:"day_of_week,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *HotelCheckInDayInfo) Reset()         { *m = HotelCheckInDayInfo{} }
func (m *HotelCheckInDayInfo) String() string { return proto.CompactTextString(m) }
func (*HotelCheckInDayInfo) ProtoMessage()    {}
func (*HotelCheckInDayInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{26}
}
func (m *HotelCheckInDayInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelCheckInDayInfo.Unmarshal(m, b)
}
func (m *HotelCheckInDayInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelCheckInDayInfo.Marshal(b, m, deterministic)
}
func (dst *HotelCheckInDayInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelCheckInDayInfo.Merge(dst, src)
}
func (m *HotelCheckInDayInfo) XXX_Size() int {
	return xxx_messageInfo_HotelCheckInDayInfo.Size(m)
}
func (m *HotelCheckInDayInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelCheckInDayInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelCheckInDayInfo proto.InternalMessageInfo

func (m *HotelCheckInDayInfo) GetDayOfWeek() enums.DayOfWeekEnum_DayOfWeek {
	if m != nil {
		return m.DayOfWeek
	}
	return enums.DayOfWeekEnum_UNSPECIFIED
}

// Criterion for Interaction Type.
type InteractionTypeInfo struct {
	// The interaction type.
	Type                 enums.InteractionTypeEnum_InteractionType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.InteractionTypeEnum_InteractionType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *InteractionTypeInfo) Reset()         { *m = InteractionTypeInfo{} }
func (m *InteractionTypeInfo) String() string { return proto.CompactTextString(m) }
func (*InteractionTypeInfo) ProtoMessage()    {}
func (*InteractionTypeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{27}
}
func (m *InteractionTypeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InteractionTypeInfo.Unmarshal(m, b)
}
func (m *InteractionTypeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InteractionTypeInfo.Marshal(b, m, deterministic)
}
func (dst *InteractionTypeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InteractionTypeInfo.Merge(dst, src)
}
func (m *InteractionTypeInfo) XXX_Size() int {
	return xxx_messageInfo_InteractionTypeInfo.Size(m)
}
func (m *InteractionTypeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_InteractionTypeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_InteractionTypeInfo proto.InternalMessageInfo

func (m *InteractionTypeInfo) GetType() enums.InteractionTypeEnum_InteractionType {
	if m != nil {
		return m.Type
	}
	return enums.InteractionTypeEnum_UNSPECIFIED
}

// Represents an AdSchedule criterion.
//
// AdSchedule is specified as the day of the week and a time interval
// within which ads will be shown.
//
// No more than six AdSchedules can be added for the same day.
type AdScheduleInfo struct {
	// Minutes after the start hour at which this schedule starts.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	StartMinute enums.MinuteOfHourEnum_MinuteOfHour `protobuf:"varint,1,opt,name=start_minute,json=startMinute,proto3,enum=google.ads.googleads.v1.enums.MinuteOfHourEnum_MinuteOfHour" json:"start_minute,omitempty"`
	// Minutes after the end hour at which this schedule ends. The schedule is
	// exclusive of the end minute.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	EndMinute enums.MinuteOfHourEnum_MinuteOfHour `protobuf:"varint,2,opt,name=end_minute,json=endMinute,proto3,enum=google.ads.googleads.v1.enums.MinuteOfHourEnum_MinuteOfHour" json:"end_minute,omitempty"`
	// Starting hour in 24 hour time.
	// This field must be between 0 and 23, inclusive.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	StartHour *wrappers.Int32Value `protobuf:"bytes,3,opt,name=start_hour,json=startHour,proto3" json:"start_hour,omitempty"`
	// Ending hour in 24 hour time; 24 signifies end of the day.
	// This field must be between 0 and 24, inclusive.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	EndHour *wrappers.Int32Value `protobuf:"bytes,4,opt,name=end_hour,json=endHour,proto3" json:"end_hour,omitempty"`
	// Day of the week the schedule applies to.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	DayOfWeek            enums.DayOfWeekEnum_DayOfWeek `protobuf:"varint,5,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.ads.googleads.v1.enums.DayOfWeekEnum_DayOfWeek" json:"day_of_week,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AdScheduleInfo) Reset()         { *m = AdScheduleInfo{} }
func (m *AdScheduleInfo) String() string { return proto.CompactTextString(m) }
func (*AdScheduleInfo) ProtoMessage()    {}
func (*AdScheduleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{28}
}
func (m *AdScheduleInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdScheduleInfo.Unmarshal(m, b)
}
func (m *AdScheduleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdScheduleInfo.Marshal(b, m, deterministic)
}
func (dst *AdScheduleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdScheduleInfo.Merge(dst, src)
}
func (m *AdScheduleInfo) XXX_Size() int {
	return xxx_messageInfo_AdScheduleInfo.Size(m)
}
func (m *AdScheduleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AdScheduleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AdScheduleInfo proto.InternalMessageInfo

func (m *AdScheduleInfo) GetStartMinute() enums.MinuteOfHourEnum_MinuteOfHour {
	if m != nil {
		return m.StartMinute
	}
	return enums.MinuteOfHourEnum_UNSPECIFIED
}

func (m *AdScheduleInfo) GetEndMinute() enums.MinuteOfHourEnum_MinuteOfHour {
	if m != nil {
		return m.EndMinute
	}
	return enums.MinuteOfHourEnum_UNSPECIFIED
}

func (m *AdScheduleInfo) GetStartHour() *wrappers.Int32Value {
	if m != nil {
		return m.StartHour
	}
	return nil
}

func (m *AdScheduleInfo) GetEndHour() *wrappers.Int32Value {
	if m != nil {
		return m.EndHour
	}
	return nil
}

func (m *AdScheduleInfo) GetDayOfWeek() enums.DayOfWeekEnum_DayOfWeek {
	if m != nil {
		return m.DayOfWeek
	}
	return enums.DayOfWeekEnum_UNSPECIFIED
}

// An age range criterion.
type AgeRangeInfo struct {
	// Type of the age range.
	Type                 enums.AgeRangeTypeEnum_AgeRangeType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.AgeRangeTypeEnum_AgeRangeType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *AgeRangeInfo) Reset()         { *m = AgeRangeInfo{} }
func (m *AgeRangeInfo) String() string { return proto.CompactTextString(m) }
func (*AgeRangeInfo) ProtoMessage()    {}
func (*AgeRangeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{29}
}
func (m *AgeRangeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AgeRangeInfo.Unmarshal(m, b)
}
func (m *AgeRangeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AgeRangeInfo.Marshal(b, m, deterministic)
}
func (dst *AgeRangeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AgeRangeInfo.Merge(dst, src)
}
func (m *AgeRangeInfo) XXX_Size() int {
	return xxx_messageInfo_AgeRangeInfo.Size(m)
}
func (m *AgeRangeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AgeRangeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AgeRangeInfo proto.InternalMessageInfo

func (m *AgeRangeInfo) GetType() enums.AgeRangeTypeEnum_AgeRangeType {
	if m != nil {
		return m.Type
	}
	return enums.AgeRangeTypeEnum_UNSPECIFIED
}

// A gender criterion.
type GenderInfo struct {
	// Type of the gender.
	Type                 enums.GenderTypeEnum_GenderType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.GenderTypeEnum_GenderType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *GenderInfo) Reset()         { *m = GenderInfo{} }
func (m *GenderInfo) String() string { return proto.CompactTextString(m) }
func (*GenderInfo) ProtoMessage()    {}
func (*GenderInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{30}
}
func (m *GenderInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenderInfo.Unmarshal(m, b)
}
func (m *GenderInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenderInfo.Marshal(b, m, deterministic)
}
func (dst *GenderInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenderInfo.Merge(dst, src)
}
func (m *GenderInfo) XXX_Size() int {
	return xxx_messageInfo_GenderInfo.Size(m)
}
func (m *GenderInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GenderInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GenderInfo proto.InternalMessageInfo

func (m *GenderInfo) GetType() enums.GenderTypeEnum_GenderType {
	if m != nil {
		return m.Type
	}
	return enums.GenderTypeEnum_UNSPECIFIED
}

// An income range criterion.
type IncomeRangeInfo struct {
	// Type of the income range.
	Type                 enums.IncomeRangeTypeEnum_IncomeRangeType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.IncomeRangeTypeEnum_IncomeRangeType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *IncomeRangeInfo) Reset()         { *m = IncomeRangeInfo{} }
func (m *IncomeRangeInfo) String() string { return proto.CompactTextString(m) }
func (*IncomeRangeInfo) ProtoMessage()    {}
func (*IncomeRangeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{31}
}
func (m *IncomeRangeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IncomeRangeInfo.Unmarshal(m, b)
}
func (m *IncomeRangeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IncomeRangeInfo.Marshal(b, m, deterministic)
}
func (dst *IncomeRangeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncomeRangeInfo.Merge(dst, src)
}
func (m *IncomeRangeInfo) XXX_Size() int {
	return xxx_messageInfo_IncomeRangeInfo.Size(m)
}
func (m *IncomeRangeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_IncomeRangeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_IncomeRangeInfo proto.InternalMessageInfo

func (m *IncomeRangeInfo) GetType() enums.IncomeRangeTypeEnum_IncomeRangeType {
	if m != nil {
		return m.Type
	}
	return enums.IncomeRangeTypeEnum_UNSPECIFIED
}

// A parental status criterion.
type ParentalStatusInfo struct {
	// Type of the parental status.
	Type                 enums.ParentalStatusTypeEnum_ParentalStatusType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.ParentalStatusTypeEnum_ParentalStatusType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *ParentalStatusInfo) Reset()         { *m = ParentalStatusInfo{} }
func (m *ParentalStatusInfo) String() string { return proto.CompactTextString(m) }
func (*ParentalStatusInfo) ProtoMessage()    {}
func (*ParentalStatusInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{32}
}
func (m *ParentalStatusInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParentalStatusInfo.Unmarshal(m, b)
}
func (m *ParentalStatusInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParentalStatusInfo.Marshal(b, m, deterministic)
}
func (dst *ParentalStatusInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParentalStatusInfo.Merge(dst, src)
}
func (m *ParentalStatusInfo) XXX_Size() int {
	return xxx_messageInfo_ParentalStatusInfo.Size(m)
}
func (m *ParentalStatusInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ParentalStatusInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ParentalStatusInfo proto.InternalMessageInfo

func (m *ParentalStatusInfo) GetType() enums.ParentalStatusTypeEnum_ParentalStatusType {
	if m != nil {
		return m.Type
	}
	return enums.ParentalStatusTypeEnum_UNSPECIFIED
}

// A YouTube Video criterion.
type YouTubeVideoInfo struct {
	// YouTube video id as it appears on the YouTube watch page.
	VideoId              *wrappers.StringValue `protobuf:"bytes,1,opt,name=video_id,json=videoId,proto3" json:"video_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *YouTubeVideoInfo) Reset()         { *m = YouTubeVideoInfo{} }
func (m *YouTubeVideoInfo) String() string { return proto.CompactTextString(m) }
func (*YouTubeVideoInfo) ProtoMessage()    {}
func (*YouTubeVideoInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{33}
}
func (m *YouTubeVideoInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_YouTubeVideoInfo.Unmarshal(m, b)
}
func (m *YouTubeVideoInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_YouTubeVideoInfo.Marshal(b, m, deterministic)
}
func (dst *YouTubeVideoInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_YouTubeVideoInfo.Merge(dst, src)
}
func (m *YouTubeVideoInfo) XXX_Size() int {
	return xxx_messageInfo_YouTubeVideoInfo.Size(m)
}
func (m *YouTubeVideoInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_YouTubeVideoInfo.DiscardUnknown(m)
}

var xxx_messageInfo_YouTubeVideoInfo proto.InternalMessageInfo

func (m *YouTubeVideoInfo) GetVideoId() *wrappers.StringValue {
	if m != nil {
		return m.VideoId
	}
	return nil
}

// A YouTube Channel criterion.
type YouTubeChannelInfo struct {
	// The YouTube uploader channel id or the channel code of a YouTube channel.
	ChannelId            *wrappers.StringValue `protobuf:"bytes,1,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *YouTubeChannelInfo) Reset()         { *m = YouTubeChannelInfo{} }
func (m *YouTubeChannelInfo) String() string { return proto.CompactTextString(m) }
func (*YouTubeChannelInfo) ProtoMessage()    {}
func (*YouTubeChannelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{34}
}
func (m *YouTubeChannelInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_YouTubeChannelInfo.Unmarshal(m, b)
}
func (m *YouTubeChannelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_YouTubeChannelInfo.Marshal(b, m, deterministic)
}
func (dst *YouTubeChannelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_YouTubeChannelInfo.Merge(dst, src)
}
func (m *YouTubeChannelInfo) XXX_Size() int {
	return xxx_messageInfo_YouTubeChannelInfo.Size(m)
}
func (m *YouTubeChannelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_YouTubeChannelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_YouTubeChannelInfo proto.InternalMessageInfo

func (m *YouTubeChannelInfo) GetChannelId() *wrappers.StringValue {
	if m != nil {
		return m.ChannelId
	}
	return nil
}

// A User List criterion. Represents a user list that is defined by the
// advertiser to be targeted.
type UserListInfo struct {
	// The User List resource name.
	UserList             *wrappers.StringValue `protobuf:"bytes,1,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UserListInfo) Reset()         { *m = UserListInfo{} }
func (m *UserListInfo) String() string { return proto.CompactTextString(m) }
func (*UserListInfo) ProtoMessage()    {}
func (*UserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{35}
}
func (m *UserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListInfo.Unmarshal(m, b)
}
func (m *UserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListInfo.Marshal(b, m, deterministic)
}
func (dst *UserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListInfo.Merge(dst, src)
}
func (m *UserListInfo) XXX_Size() int {
	return xxx_messageInfo_UserListInfo.Size(m)
}
func (m *UserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListInfo proto.InternalMessageInfo

func (m *UserListInfo) GetUserList() *wrappers.StringValue {
	if m != nil {
		return m.UserList
	}
	return nil
}

// A Proximity criterion. The geo point and radius determine what geographical
// area is included. The address is a description of the geo point that does
// not affect ad serving.
//
// There are two ways to create a proximity. First, by setting an address
// and radius. The geo point will be automatically computed. Second, by
// setting a geo point and radius. The address is an optional label that won't
// be validated.
type ProximityInfo struct {
	// Latitude and longitude.
	GeoPoint *GeoPointInfo `protobuf:"bytes,1,opt,name=geo_point,json=geoPoint,proto3" json:"geo_point,omitempty"`
	// The radius of the proximity.
	Radius *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=radius,proto3" json:"radius,omitempty"`
	// The unit of measurement of the radius. Default is KILOMETERS.
	RadiusUnits enums.ProximityRadiusUnitsEnum_ProximityRadiusUnits `protobuf:"varint,3,opt,name=radius_units,json=radiusUnits,proto3,enum=google.ads.googleads.v1.enums.ProximityRadiusUnitsEnum_ProximityRadiusUnits" json:"radius_units,omitempty"`
	// Full address.
	Address              *AddressInfo `protobuf:"bytes,4,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ProximityInfo) Reset()         { *m = ProximityInfo{} }
func (m *ProximityInfo) String() string { return proto.CompactTextString(m) }
func (*ProximityInfo) ProtoMessage()    {}
func (*ProximityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{36}
}
func (m *ProximityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProximityInfo.Unmarshal(m, b)
}
func (m *ProximityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProximityInfo.Marshal(b, m, deterministic)
}
func (dst *ProximityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProximityInfo.Merge(dst, src)
}
func (m *ProximityInfo) XXX_Size() int {
	return xxx_messageInfo_ProximityInfo.Size(m)
}
func (m *ProximityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProximityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProximityInfo proto.InternalMessageInfo

func (m *ProximityInfo) GetGeoPoint() *GeoPointInfo {
	if m != nil {
		return m.GeoPoint
	}
	return nil
}

func (m *ProximityInfo) GetRadius() *wrappers.DoubleValue {
	if m != nil {
		return m.Radius
	}
	return nil
}

func (m *ProximityInfo) GetRadiusUnits() enums.ProximityRadiusUnitsEnum_ProximityRadiusUnits {
	if m != nil {
		return m.RadiusUnits
	}
	return enums.ProximityRadiusUnitsEnum_UNSPECIFIED
}

func (m *ProximityInfo) GetAddress() *AddressInfo {
	if m != nil {
		return m.Address
	}
	return nil
}

// Geo point for proximity criterion.
type GeoPointInfo struct {
	// Micro degrees for the longitude.
	LongitudeInMicroDegrees *wrappers.Int32Value `protobuf:"bytes,1,opt,name=longitude_in_micro_degrees,json=longitudeInMicroDegrees,proto3" json:"longitude_in_micro_degrees,omitempty"`
	// Micro degrees for the latitude.
	LatitudeInMicroDegrees *wrappers.Int32Value `protobuf:"bytes,2,opt,name=latitude_in_micro_degrees,json=latitudeInMicroDegrees,proto3" json:"latitude_in_micro_degrees,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}             `json:"-"`
	XXX_unrecognized       []byte               `json:"-"`
	XXX_sizecache          int32                `json:"-"`
}

func (m *GeoPointInfo) Reset()         { *m = GeoPointInfo{} }
func (m *GeoPointInfo) String() string { return proto.CompactTextString(m) }
func (*GeoPointInfo) ProtoMessage()    {}
func (*GeoPointInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{37}
}
func (m *GeoPointInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GeoPointInfo.Unmarshal(m, b)
}
func (m *GeoPointInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GeoPointInfo.Marshal(b, m, deterministic)
}
func (dst *GeoPointInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GeoPointInfo.Merge(dst, src)
}
func (m *GeoPointInfo) XXX_Size() int {
	return xxx_messageInfo_GeoPointInfo.Size(m)
}
func (m *GeoPointInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GeoPointInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GeoPointInfo proto.InternalMessageInfo

func (m *GeoPointInfo) GetLongitudeInMicroDegrees() *wrappers.Int32Value {
	if m != nil {
		return m.LongitudeInMicroDegrees
	}
	return nil
}

func (m *GeoPointInfo) GetLatitudeInMicroDegrees() *wrappers.Int32Value {
	if m != nil {
		return m.LatitudeInMicroDegrees
	}
	return nil
}

// Address for proximity criterion.
type AddressInfo struct {
	// Postal code.
	PostalCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
	// Province or state code.
	ProvinceCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=province_code,json=provinceCode,proto3" json:"province_code,omitempty"`
	// Country code.
	CountryCode *wrappers.StringValue `protobuf:"bytes,3,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Province or state name.
	ProvinceName *wrappers.StringValue `protobuf:"bytes,4,opt,name=province_name,json=provinceName,proto3" json:"province_name,omitempty"`
	// Street address line 1.
	StreetAddress *wrappers.StringValue `protobuf:"bytes,5,opt,name=street_address,json=streetAddress,proto3" json:"street_address,omitempty"`
	// Street address line 2. This field is write-only. It is only used for
	// calculating the longitude and latitude of an address when geo_point is
	// empty.
	StreetAddress2 *wrappers.StringValue `protobuf:"bytes,6,opt,name=street_address2,json=streetAddress2,proto3" json:"street_address2,omitempty"`
	// Name of the city.
	CityName             *wrappers.StringValue `protobuf:"bytes,7,opt,name=city_name,json=cityName,proto3" json:"city_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *AddressInfo) Reset()         { *m = AddressInfo{} }
func (m *AddressInfo) String() string { return proto.CompactTextString(m) }
func (*AddressInfo) ProtoMessage()    {}
func (*AddressInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{38}
}
func (m *AddressInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddressInfo.Unmarshal(m, b)
}
func (m *AddressInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddressInfo.Marshal(b, m, deterministic)
}
func (dst *AddressInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddressInfo.Merge(dst, src)
}
func (m *AddressInfo) XXX_Size() int {
	return xxx_messageInfo_AddressInfo.Size(m)
}
func (m *AddressInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AddressInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AddressInfo proto.InternalMessageInfo

func (m *AddressInfo) GetPostalCode() *wrappers.StringValue {
	if m != nil {
		return m.PostalCode
	}
	return nil
}

func (m *AddressInfo) GetProvinceCode() *wrappers.StringValue {
	if m != nil {
		return m.ProvinceCode
	}
	return nil
}

func (m *AddressInfo) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *AddressInfo) GetProvinceName() *wrappers.StringValue {
	if m != nil {
		return m.ProvinceName
	}
	return nil
}

func (m *AddressInfo) GetStreetAddress() *wrappers.StringValue {
	if m != nil {
		return m.StreetAddress
	}
	return nil
}

func (m *AddressInfo) GetStreetAddress2() *wrappers.StringValue {
	if m != nil {
		return m.StreetAddress2
	}
	return nil
}

func (m *AddressInfo) GetCityName() *wrappers.StringValue {
	if m != nil {
		return m.CityName
	}
	return nil
}

// A topic criterion. Use topics to target or exclude placements in the
// Google Display Network based on the category into which the placement falls
// (for example, "Pets & Animals/Pets/Dogs").
type TopicInfo struct {
	// The Topic Constant resource name.
	TopicConstant *wrappers.StringValue `protobuf:"bytes,1,opt,name=topic_constant,json=topicConstant,proto3" json:"topic_constant,omitempty"`
	// The category to target or exclude. Each subsequent element in the array
	// describes a more specific sub-category. For example,
	// "Pets & Animals", "Pets", "Dogs" represents the "Pets & Animals/Pets/Dogs"
	// category.
	Path                 []*wrappers.StringValue `protobuf:"bytes,2,rep,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *TopicInfo) Reset()         { *m = TopicInfo{} }
func (m *TopicInfo) String() string { return proto.CompactTextString(m) }
func (*TopicInfo) ProtoMessage()    {}
func (*TopicInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{39}
}
func (m *TopicInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TopicInfo.Unmarshal(m, b)
}
func (m *TopicInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TopicInfo.Marshal(b, m, deterministic)
}
func (dst *TopicInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TopicInfo.Merge(dst, src)
}
func (m *TopicInfo) XXX_Size() int {
	return xxx_messageInfo_TopicInfo.Size(m)
}
func (m *TopicInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TopicInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TopicInfo proto.InternalMessageInfo

func (m *TopicInfo) GetTopicConstant() *wrappers.StringValue {
	if m != nil {
		return m.TopicConstant
	}
	return nil
}

func (m *TopicInfo) GetPath() []*wrappers.StringValue {
	if m != nil {
		return m.Path
	}
	return nil
}

// A language criterion.
type LanguageInfo struct {
	// The language constant resource name.
	LanguageConstant     *wrappers.StringValue `protobuf:"bytes,1,opt,name=language_constant,json=languageConstant,proto3" json:"language_constant,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LanguageInfo) Reset()         { *m = LanguageInfo{} }
func (m *LanguageInfo) String() string { return proto.CompactTextString(m) }
func (*LanguageInfo) ProtoMessage()    {}
func (*LanguageInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{40}
}
func (m *LanguageInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LanguageInfo.Unmarshal(m, b)
}
func (m *LanguageInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LanguageInfo.Marshal(b, m, deterministic)
}
func (dst *LanguageInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LanguageInfo.Merge(dst, src)
}
func (m *LanguageInfo) XXX_Size() int {
	return xxx_messageInfo_LanguageInfo.Size(m)
}
func (m *LanguageInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LanguageInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LanguageInfo proto.InternalMessageInfo

func (m *LanguageInfo) GetLanguageConstant() *wrappers.StringValue {
	if m != nil {
		return m.LanguageConstant
	}
	return nil
}

// An IpBlock criterion used for IP exclusions. We allow:
//  - IPv4 and IPv6 addresses
//  - individual addresses (192.168.0.1)
//  - masks for individual addresses (192.168.0.1/32)
//  - masks for Class C networks (192.168.0.1/24)
type IpBlockInfo struct {
	// The IP address of this IP block.
	IpAddress            *wrappers.StringValue `protobuf:"bytes,1,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *IpBlockInfo) Reset()         { *m = IpBlockInfo{} }
func (m *IpBlockInfo) String() string { return proto.CompactTextString(m) }
func (*IpBlockInfo) ProtoMessage()    {}
func (*IpBlockInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{41}
}
func (m *IpBlockInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IpBlockInfo.Unmarshal(m, b)
}
func (m *IpBlockInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IpBlockInfo.Marshal(b, m, deterministic)
}
func (dst *IpBlockInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IpBlockInfo.Merge(dst, src)
}
func (m *IpBlockInfo) XXX_Size() int {
	return xxx_messageInfo_IpBlockInfo.Size(m)
}
func (m *IpBlockInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_IpBlockInfo.DiscardUnknown(m)
}

var xxx_messageInfo_IpBlockInfo proto.InternalMessageInfo

func (m *IpBlockInfo) GetIpAddress() *wrappers.StringValue {
	if m != nil {
		return m.IpAddress
	}
	return nil
}

// Content Label for category exclusion.
type ContentLabelInfo struct {
	// Content label type, required for CREATE operations.
	Type                 enums.ContentLabelTypeEnum_ContentLabelType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.ContentLabelTypeEnum_ContentLabelType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ContentLabelInfo) Reset()         { *m = ContentLabelInfo{} }
func (m *ContentLabelInfo) String() string { return proto.CompactTextString(m) }
func (*ContentLabelInfo) ProtoMessage()    {}
func (*ContentLabelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{42}
}
func (m *ContentLabelInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContentLabelInfo.Unmarshal(m, b)
}
func (m *ContentLabelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContentLabelInfo.Marshal(b, m, deterministic)
}
func (dst *ContentLabelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContentLabelInfo.Merge(dst, src)
}
func (m *ContentLabelInfo) XXX_Size() int {
	return xxx_messageInfo_ContentLabelInfo.Size(m)
}
func (m *ContentLabelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ContentLabelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ContentLabelInfo proto.InternalMessageInfo

func (m *ContentLabelInfo) GetType() enums.ContentLabelTypeEnum_ContentLabelType {
	if m != nil {
		return m.Type
	}
	return enums.ContentLabelTypeEnum_UNSPECIFIED
}

// Represents a Carrier Criterion.
type CarrierInfo struct {
	// The Carrier constant resource name.
	CarrierConstant      *wrappers.StringValue `protobuf:"bytes,1,opt,name=carrier_constant,json=carrierConstant,proto3" json:"carrier_constant,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CarrierInfo) Reset()         { *m = CarrierInfo{} }
func (m *CarrierInfo) String() string { return proto.CompactTextString(m) }
func (*CarrierInfo) ProtoMessage()    {}
func (*CarrierInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{43}
}
func (m *CarrierInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CarrierInfo.Unmarshal(m, b)
}
func (m *CarrierInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CarrierInfo.Marshal(b, m, deterministic)
}
func (dst *CarrierInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CarrierInfo.Merge(dst, src)
}
func (m *CarrierInfo) XXX_Size() int {
	return xxx_messageInfo_CarrierInfo.Size(m)
}
func (m *CarrierInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CarrierInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CarrierInfo proto.InternalMessageInfo

func (m *CarrierInfo) GetCarrierConstant() *wrappers.StringValue {
	if m != nil {
		return m.CarrierConstant
	}
	return nil
}

// Represents a particular interest-based topic to be targeted.
type UserInterestInfo struct {
	// The UserInterest resource name.
	UserInterestCategory *wrappers.StringValue `protobuf:"bytes,1,opt,name=user_interest_category,json=userInterestCategory,proto3" json:"user_interest_category,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UserInterestInfo) Reset()         { *m = UserInterestInfo{} }
func (m *UserInterestInfo) String() string { return proto.CompactTextString(m) }
func (*UserInterestInfo) ProtoMessage()    {}
func (*UserInterestInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{44}
}
func (m *UserInterestInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserInterestInfo.Unmarshal(m, b)
}
func (m *UserInterestInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserInterestInfo.Marshal(b, m, deterministic)
}
func (dst *UserInterestInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserInterestInfo.Merge(dst, src)
}
func (m *UserInterestInfo) XXX_Size() int {
	return xxx_messageInfo_UserInterestInfo.Size(m)
}
func (m *UserInterestInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserInterestInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserInterestInfo proto.InternalMessageInfo

func (m *UserInterestInfo) GetUserInterestCategory() *wrappers.StringValue {
	if m != nil {
		return m.UserInterestCategory
	}
	return nil
}

// Represents a criterion for targeting webpages of an advertiser's website.
type WebpageInfo struct {
	// The name of the criterion that is defined by this parameter. The name value
	// will be used for identifying, sorting and filtering criteria with this type
	// of parameters.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	CriterionName *wrappers.StringValue `protobuf:"bytes,1,opt,name=criterion_name,json=criterionName,proto3" json:"criterion_name,omitempty"`
	// Conditions, or logical expressions, for webpage targeting. The list of
	// webpage targeting conditions are and-ed together when evaluated
	// for targeting.
	//
	// This field is required for CREATE operations and is prohibited on UPDATE
	// operations.
	Conditions           []*WebpageConditionInfo `protobuf:"bytes,2,rep,name=conditions,proto3" json:"conditions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *WebpageInfo) Reset()         { *m = WebpageInfo{} }
func (m *WebpageInfo) String() string { return proto.CompactTextString(m) }
func (*WebpageInfo) ProtoMessage()    {}
func (*WebpageInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{45}
}
func (m *WebpageInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WebpageInfo.Unmarshal(m, b)
}
func (m *WebpageInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WebpageInfo.Marshal(b, m, deterministic)
}
func (dst *WebpageInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebpageInfo.Merge(dst, src)
}
func (m *WebpageInfo) XXX_Size() int {
	return xxx_messageInfo_WebpageInfo.Size(m)
}
func (m *WebpageInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WebpageInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WebpageInfo proto.InternalMessageInfo

func (m *WebpageInfo) GetCriterionName() *wrappers.StringValue {
	if m != nil {
		return m.CriterionName
	}
	return nil
}

func (m *WebpageInfo) GetConditions() []*WebpageConditionInfo {
	if m != nil {
		return m.Conditions
	}
	return nil
}

// Logical expression for targeting webpages of an advertiser's website.
type WebpageConditionInfo struct {
	// Operand of webpage targeting condition.
	Operand enums.WebpageConditionOperandEnum_WebpageConditionOperand `protobuf:"varint,1,opt,name=operand,proto3,enum=google.ads.googleads.v1.enums.WebpageConditionOperandEnum_WebpageConditionOperand" json:"operand,omitempty"`
	// Operator of webpage targeting condition.
	Operator enums.WebpageConditionOperatorEnum_WebpageConditionOperator `protobuf:"varint,2,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.WebpageConditionOperatorEnum_WebpageConditionOperator" json:"operator,omitempty"`
	// Argument of webpage targeting condition.
	Argument             *wrappers.StringValue `protobuf:"bytes,3,opt,name=argument,proto3" json:"argument,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *WebpageConditionInfo) Reset()         { *m = WebpageConditionInfo{} }
func (m *WebpageConditionInfo) String() string { return proto.CompactTextString(m) }
func (*WebpageConditionInfo) ProtoMessage()    {}
func (*WebpageConditionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{46}
}
func (m *WebpageConditionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WebpageConditionInfo.Unmarshal(m, b)
}
func (m *WebpageConditionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WebpageConditionInfo.Marshal(b, m, deterministic)
}
func (dst *WebpageConditionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebpageConditionInfo.Merge(dst, src)
}
func (m *WebpageConditionInfo) XXX_Size() int {
	return xxx_messageInfo_WebpageConditionInfo.Size(m)
}
func (m *WebpageConditionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WebpageConditionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WebpageConditionInfo proto.InternalMessageInfo

func (m *WebpageConditionInfo) GetOperand() enums.WebpageConditionOperandEnum_WebpageConditionOperand {
	if m != nil {
		return m.Operand
	}
	return enums.WebpageConditionOperandEnum_UNSPECIFIED
}

func (m *WebpageConditionInfo) GetOperator() enums.WebpageConditionOperatorEnum_WebpageConditionOperator {
	if m != nil {
		return m.Operator
	}
	return enums.WebpageConditionOperatorEnum_UNSPECIFIED
}

func (m *WebpageConditionInfo) GetArgument() *wrappers.StringValue {
	if m != nil {
		return m.Argument
	}
	return nil
}

// Represents an operating system version to be targeted.
type OperatingSystemVersionInfo struct {
	// The operating system version constant resource name.
	OperatingSystemVersionConstant *wrappers.StringValue `protobuf:"bytes,1,opt,name=operating_system_version_constant,json=operatingSystemVersionConstant,proto3" json:"operating_system_version_constant,omitempty"`
	XXX_NoUnkeyedLiteral           struct{}              `json:"-"`
	XXX_unrecognized               []byte                `json:"-"`
	XXX_sizecache                  int32                 `json:"-"`
}

func (m *OperatingSystemVersionInfo) Reset()         { *m = OperatingSystemVersionInfo{} }
func (m *OperatingSystemVersionInfo) String() string { return proto.CompactTextString(m) }
func (*OperatingSystemVersionInfo) ProtoMessage()    {}
func (*OperatingSystemVersionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{47}
}
func (m *OperatingSystemVersionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperatingSystemVersionInfo.Unmarshal(m, b)
}
func (m *OperatingSystemVersionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperatingSystemVersionInfo.Marshal(b, m, deterministic)
}
func (dst *OperatingSystemVersionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperatingSystemVersionInfo.Merge(dst, src)
}
func (m *OperatingSystemVersionInfo) XXX_Size() int {
	return xxx_messageInfo_OperatingSystemVersionInfo.Size(m)
}
func (m *OperatingSystemVersionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_OperatingSystemVersionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_OperatingSystemVersionInfo proto.InternalMessageInfo

func (m *OperatingSystemVersionInfo) GetOperatingSystemVersionConstant() *wrappers.StringValue {
	if m != nil {
		return m.OperatingSystemVersionConstant
	}
	return nil
}

// An app payment model criterion.
type AppPaymentModelInfo struct {
	// Type of the app payment model.
	Type                 enums.AppPaymentModelTypeEnum_AppPaymentModelType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.AppPaymentModelTypeEnum_AppPaymentModelType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *AppPaymentModelInfo) Reset()         { *m = AppPaymentModelInfo{} }
func (m *AppPaymentModelInfo) String() string { return proto.CompactTextString(m) }
func (*AppPaymentModelInfo) ProtoMessage()    {}
func (*AppPaymentModelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{48}
}
func (m *AppPaymentModelInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppPaymentModelInfo.Unmarshal(m, b)
}
func (m *AppPaymentModelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppPaymentModelInfo.Marshal(b, m, deterministic)
}
func (dst *AppPaymentModelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppPaymentModelInfo.Merge(dst, src)
}
func (m *AppPaymentModelInfo) XXX_Size() int {
	return xxx_messageInfo_AppPaymentModelInfo.Size(m)
}
func (m *AppPaymentModelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AppPaymentModelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AppPaymentModelInfo proto.InternalMessageInfo

func (m *AppPaymentModelInfo) GetType() enums.AppPaymentModelTypeEnum_AppPaymentModelType {
	if m != nil {
		return m.Type
	}
	return enums.AppPaymentModelTypeEnum_UNSPECIFIED
}

// A mobile device criterion.
type MobileDeviceInfo struct {
	// The mobile device constant resource name.
	MobileDeviceConstant *wrappers.StringValue `protobuf:"bytes,1,opt,name=mobile_device_constant,json=mobileDeviceConstant,proto3" json:"mobile_device_constant,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MobileDeviceInfo) Reset()         { *m = MobileDeviceInfo{} }
func (m *MobileDeviceInfo) String() string { return proto.CompactTextString(m) }
func (*MobileDeviceInfo) ProtoMessage()    {}
func (*MobileDeviceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{49}
}
func (m *MobileDeviceInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MobileDeviceInfo.Unmarshal(m, b)
}
func (m *MobileDeviceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MobileDeviceInfo.Marshal(b, m, deterministic)
}
func (dst *MobileDeviceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MobileDeviceInfo.Merge(dst, src)
}
func (m *MobileDeviceInfo) XXX_Size() int {
	return xxx_messageInfo_MobileDeviceInfo.Size(m)
}
func (m *MobileDeviceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MobileDeviceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MobileDeviceInfo proto.InternalMessageInfo

func (m *MobileDeviceInfo) GetMobileDeviceConstant() *wrappers.StringValue {
	if m != nil {
		return m.MobileDeviceConstant
	}
	return nil
}

// A custom affinity criterion.
// A criterion of this type is only targetable.
type CustomAffinityInfo struct {
	// The CustomInterest resource name.
	CustomAffinity       *wrappers.StringValue `protobuf:"bytes,1,opt,name=custom_affinity,json=customAffinity,proto3" json:"custom_affinity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CustomAffinityInfo) Reset()         { *m = CustomAffinityInfo{} }
func (m *CustomAffinityInfo) String() string { return proto.CompactTextString(m) }
func (*CustomAffinityInfo) ProtoMessage()    {}
func (*CustomAffinityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{50}
}
func (m *CustomAffinityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomAffinityInfo.Unmarshal(m, b)
}
func (m *CustomAffinityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomAffinityInfo.Marshal(b, m, deterministic)
}
func (dst *CustomAffinityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomAffinityInfo.Merge(dst, src)
}
func (m *CustomAffinityInfo) XXX_Size() int {
	return xxx_messageInfo_CustomAffinityInfo.Size(m)
}
func (m *CustomAffinityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomAffinityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CustomAffinityInfo proto.InternalMessageInfo

func (m *CustomAffinityInfo) GetCustomAffinity() *wrappers.StringValue {
	if m != nil {
		return m.CustomAffinity
	}
	return nil
}

// A custom intent criterion.
// A criterion of this type is only targetable.
type CustomIntentInfo struct {
	// The CustomInterest resource name.
	CustomIntent         *wrappers.StringValue `protobuf:"bytes,1,opt,name=custom_intent,json=customIntent,proto3" json:"custom_intent,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CustomIntentInfo) Reset()         { *m = CustomIntentInfo{} }
func (m *CustomIntentInfo) String() string { return proto.CompactTextString(m) }
func (*CustomIntentInfo) ProtoMessage()    {}
func (*CustomIntentInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_criteria_788c5aafd5a06a45, []int{51}
}
func (m *CustomIntentInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomIntentInfo.Unmarshal(m, b)
}
func (m *CustomIntentInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomIntentInfo.Marshal(b, m, deterministic)
}
func (dst *CustomIntentInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomIntentInfo.Merge(dst, src)
}
func (m *CustomIntentInfo) XXX_Size() int {
	return xxx_messageInfo_CustomIntentInfo.Size(m)
}
func (m *CustomIntentInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomIntentInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CustomIntentInfo proto.InternalMessageInfo

func (m *CustomIntentInfo) GetCustomIntent() *wrappers.StringValue {
	if m != nil {
		return m.CustomIntent
	}
	return nil
}

func init() {
	proto.RegisterType((*KeywordInfo)(nil), "google.ads.googleads.v1.common.KeywordInfo")
	proto.RegisterType((*PlacementInfo)(nil), "google.ads.googleads.v1.common.PlacementInfo")
	proto.RegisterType((*MobileAppCategoryInfo)(nil), "google.ads.googleads.v1.common.MobileAppCategoryInfo")
	proto.RegisterType((*MobileApplicationInfo)(nil), "google.ads.googleads.v1.common.MobileApplicationInfo")
	proto.RegisterType((*LocationInfo)(nil), "google.ads.googleads.v1.common.LocationInfo")
	proto.RegisterType((*DeviceInfo)(nil), "google.ads.googleads.v1.common.DeviceInfo")
	proto.RegisterType((*PreferredContentInfo)(nil), "google.ads.googleads.v1.common.PreferredContentInfo")
	proto.RegisterType((*ListingGroupInfo)(nil), "google.ads.googleads.v1.common.ListingGroupInfo")
	proto.RegisterType((*ListingScopeInfo)(nil), "google.ads.googleads.v1.common.ListingScopeInfo")
	proto.RegisterType((*ListingDimensionInfo)(nil), "google.ads.googleads.v1.common.ListingDimensionInfo")
	proto.RegisterType((*ListingBrandInfo)(nil), "google.ads.googleads.v1.common.ListingBrandInfo")
	proto.RegisterType((*HotelIdInfo)(nil), "google.ads.googleads.v1.common.HotelIdInfo")
	proto.RegisterType((*HotelClassInfo)(nil), "google.ads.googleads.v1.common.HotelClassInfo")
	proto.RegisterType((*HotelCountryRegionInfo)(nil), "google.ads.googleads.v1.common.HotelCountryRegionInfo")
	proto.RegisterType((*HotelStateInfo)(nil), "google.ads.googleads.v1.common.HotelStateInfo")
	proto.RegisterType((*HotelCityInfo)(nil), "google.ads.googleads.v1.common.HotelCityInfo")
	proto.RegisterType((*ListingCustomAttributeInfo)(nil), "google.ads.googleads.v1.common.ListingCustomAttributeInfo")
	proto.RegisterType((*ProductBiddingCategoryInfo)(nil), "google.ads.googleads.v1.common.ProductBiddingCategoryInfo")
	proto.RegisterType((*ProductChannelInfo)(nil), "google.ads.googleads.v1.common.ProductChannelInfo")
	proto.RegisterType((*ProductChannelExclusivityInfo)(nil), "google.ads.googleads.v1.common.ProductChannelExclusivityInfo")
	proto.RegisterType((*ProductConditionInfo)(nil), "google.ads.googleads.v1.common.ProductConditionInfo")
	proto.RegisterType((*ProductItemIdInfo)(nil), "google.ads.googleads.v1.common.ProductItemIdInfo")
	proto.RegisterType((*ProductTypeInfo)(nil), "google.ads.googleads.v1.common.ProductTypeInfo")
	proto.RegisterType((*HotelDateSelectionTypeInfo)(nil), "google.ads.googleads.v1.common.HotelDateSelectionTypeInfo")
	proto.RegisterType((*HotelAdvanceBookingWindowInfo)(nil), "google.ads.googleads.v1.common.HotelAdvanceBookingWindowInfo")
	proto.RegisterType((*HotelLengthOfStayInfo)(nil), "google.ads.googleads.v1.common.HotelLengthOfStayInfo")
	proto.RegisterType((*HotelCheckInDayInfo)(nil), "google.ads.googleads.v1.common.HotelCheckInDayInfo")
	proto.RegisterType((*InteractionTypeInfo)(nil), "google.ads.googleads.v1.common.InteractionTypeInfo")
	proto.RegisterType((*AdScheduleInfo)(nil), "google.ads.googleads.v1.common.AdScheduleInfo")
	proto.RegisterType((*AgeRangeInfo)(nil), "google.ads.googleads.v1.common.AgeRangeInfo")
	proto.RegisterType((*GenderInfo)(nil), "google.ads.googleads.v1.common.GenderInfo")
	proto.RegisterType((*IncomeRangeInfo)(nil), "google.ads.googleads.v1.common.IncomeRangeInfo")
	proto.RegisterType((*ParentalStatusInfo)(nil), "google.ads.googleads.v1.common.ParentalStatusInfo")
	proto.RegisterType((*YouTubeVideoInfo)(nil), "google.ads.googleads.v1.common.YouTubeVideoInfo")
	proto.RegisterType((*YouTubeChannelInfo)(nil), "google.ads.googleads.v1.common.YouTubeChannelInfo")
	proto.RegisterType((*UserListInfo)(nil), "google.ads.googleads.v1.common.UserListInfo")
	proto.RegisterType((*ProximityInfo)(nil), "google.ads.googleads.v1.common.ProximityInfo")
	proto.RegisterType((*GeoPointInfo)(nil), "google.ads.googleads.v1.common.GeoPointInfo")
	proto.RegisterType((*AddressInfo)(nil), "google.ads.googleads.v1.common.AddressInfo")
	proto.RegisterType((*TopicInfo)(nil), "google.ads.googleads.v1.common.TopicInfo")
	proto.RegisterType((*LanguageInfo)(nil), "google.ads.googleads.v1.common.LanguageInfo")
	proto.RegisterType((*IpBlockInfo)(nil), "google.ads.googleads.v1.common.IpBlockInfo")
	proto.RegisterType((*ContentLabelInfo)(nil), "google.ads.googleads.v1.common.ContentLabelInfo")
	proto.RegisterType((*CarrierInfo)(nil), "google.ads.googleads.v1.common.CarrierInfo")
	proto.RegisterType((*UserInterestInfo)(nil), "google.ads.googleads.v1.common.UserInterestInfo")
	proto.RegisterType((*WebpageInfo)(nil), "google.ads.googleads.v1.common.WebpageInfo")
	proto.RegisterType((*WebpageConditionInfo)(nil), "google.ads.googleads.v1.common.WebpageConditionInfo")
	proto.RegisterType((*OperatingSystemVersionInfo)(nil), "google.ads.googleads.v1.common.OperatingSystemVersionInfo")
	proto.RegisterType((*AppPaymentModelInfo)(nil), "google.ads.googleads.v1.common.AppPaymentModelInfo")
	proto.RegisterType((*MobileDeviceInfo)(nil), "google.ads.googleads.v1.common.MobileDeviceInfo")
	proto.RegisterType((*CustomAffinityInfo)(nil), "google.ads.googleads.v1.common.CustomAffinityInfo")
	proto.RegisterType((*CustomIntentInfo)(nil), "google.ads.googleads.v1.common.CustomIntentInfo")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/common/criteria.proto", fileDescriptor_criteria_788c5aafd5a06a45)
}

var fileDescriptor_criteria_788c5aafd5a06a45 = []byte{
	// 2647 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x5a, 0x4d, 0x73, 0x1c, 0x47,
	0x19, 0x66, 0x57, 0xb6, 0xa5, 0x7d, 0x77, 0x65, 0xcb, 0x63, 0x47, 0xac, 0x95, 0x8f, 0x0a, 0x73,
	0x4a, 0x11, 0xb2, 0xb2, 0x64, 0x63, 0x82, 0x42, 0x08, 0x2b, 0xc9, 0xc8, 0x9b, 0xc8, 0xb1, 0x32,
	0x52, 0xe4, 0xc4, 0x76, 0x98, 0xb4, 0x66, 0x5a, 0xb3, 0x8d, 0x67, 0xba, 0xa7, 0x66, 0x7a, 0x64,
	0x2d, 0x17, 0xaa, 0xa8, 0xa2, 0x38, 0xc2, 0x99, 0x1b, 0x14, 0x07, 0xe0, 0xc4, 0x4f, 0xa0, 0x38,
	0x51, 0xfc, 0x04, 0x7e, 0x01, 0xc5, 0x6f, 0xe0, 0x40, 0xf5, 0xd7, 0xec, 0xec, 0x97, 0x66, 0x56,
	0x95, 0x93, 0x76, 0xba, 0xfb, 0x79, 0x9e, 0xb7, 0xbb, 0xdf, 0x7e, 0xfb, 0xed, 0x6e, 0xc1, 0x7b,
	0x01, 0x63, 0x41, 0x88, 0xd7, 0x91, 0x9f, 0xae, 0xab, 0x9f, 0xe2, 0xd7, 0xd9, 0xc6, 0xba, 0xc7,
	0xa2, 0x88, 0xd1, 0x75, 0x2f, 0x21, 0x1c, 0x27, 0x04, 0x75, 0xe2, 0x84, 0x71, 0x66, 0xbd, 0xa5,
	0xda, 0x74, 0x90, 0x9f, 0x76, 0xf2, 0xe6, 0x9d, 0xb3, 0x8d, 0x8e, 0x6a, 0xbe, 0xb6, 0x39, 0x8b,
	0x0e, 0xd3, 0x2c, 0x4a, 0xd7, 0x51, 0x80, 0xdd, 0x04, 0xd1, 0x00, 0xbb, 0x7c, 0x10, 0x63, 0xc5,
	0xb9, 0xb6, 0x55, 0x82, 0x89, 0x63, 0x37, 0x46, 0x83, 0x08, 0x53, 0xee, 0x46, 0xcc, 0xc7, 0x61,
	0x11, 0xfb, 0xe0, 0x62, 0xac, 0xc7, 0x28, 0x17, 0xb8, 0x10, 0x9d, 0x8c, 0xe2, 0xd6, 0x2f, 0xc6,
	0xf9, 0x68, 0xe0, 0xb2, 0x53, 0xf7, 0x15, 0xc6, 0x2f, 0x35, 0xe0, 0xbb, 0x25, 0x00, 0x7c, 0x46,
	0xbc, 0x8a, 0xe4, 0x01, 0xa6, 0x3e, 0x4e, 0x8a, 0xd6, 0x7c, 0x78, 0x31, 0xa0, 0xcf, 0x38, 0x0e,
	0x5d, 0x1f, 0x71, 0xec, 0xa6, 0x38, 0xc4, 0x1e, 0x27, 0x8c, 0x16, 0xe1, 0xdf, 0xbf, 0x18, 0x4e,
	0xa8, 0xc7, 0xa2, 0x29, 0xe3, 0x7e, 0xbf, 0x0c, 0xc6, 0x71, 0x82, 0x26, 0xc4, 0x4a, 0x46, 0xfc,
	0x25, 0x1e, 0xbc, 0x62, 0x89, 0xef, 0x46, 0x88, 0x7b, 0xfd, 0x22, 0x6e, 0xfb, 0x62, 0x5c, 0x48,
	0x52, 0x4e, 0x68, 0xe0, 0x7a, 0x59, 0xca, 0x59, 0xe4, 0x22, 0xce, 0x13, 0x72, 0x92, 0x71, 0xec,
	0x12, 0xea, 0xe3, 0xf3, 0x6a, 0xda, 0x86, 0x23, 0x48, 0x58, 0x16, 0x17, 0xb5, 0x4b, 0xbc, 0x32,
	0x22, 0x54, 0x28, 0xb1, 0x53, 0xb7, 0xcf, 0xb2, 0x44, 0x63, 0xde, 0xbf, 0x18, 0x13, 0xa3, 0x04,
	0x53, 0x8e, 0x42, 0x37, 0xe5, 0x88, 0x67, 0xe9, 0x1c, 0xfe, 0x1c, 0x27, 0xf8, 0x14, 0x27, 0x09,
	0xf6, 0x5d, 0xe3, 0x9d, 0xd5, 0x47, 0x29, 0x4e, 0x98, 0x9f, 0x79, 0xdc, 0x3d, 0x21, 0xbe, 0x2f,
	0x47, 0x0b, 0x71, 0x1c, 0xb0, 0x64, 0xe0, 0x86, 0xf8, 0x0c, 0x87, 0x9a, 0xe3, 0x5e, 0x35, 0x0e,
	0xaf, 0x8f, 0x28, 0xcd, 0x41, 0x1f, 0xcd, 0x05, 0x72, 0xf1, 0xb9, 0x17, 0x66, 0x29, 0x39, 0x23,
	0x7c, 0x50, 0xcd, 0x09, 0x73, 0x02, 0x46, 0x7d, 0x22, 0x7c, 0xaa, 0xda, 0x94, 0x1a, 0x98, 0x18,
	0xa2, 0x91, 0x4e, 0x96, 0x0e, 0x32, 0x3b, 0x27, 0x11, 0xe1, 0x03, 0x37, 0x41, 0x3e, 0xc9, 0x52,
	0x37, 0xa3, 0x84, 0xa7, 0xd5, 0x96, 0xdb, 0x2b, 0x7c, 0x12, 0x8b, 0x40, 0x95, 0x9b, 0xea, 0xb2,
	0x18, 0x27, 0x88, 0xfa, 0x1a, 0xfe, 0xe3, 0x4b, 0xc1, 0x39, 0x33, 0x9e, 0xa5, 0x63, 0xe8, 0xba,
	0xfc, 0x3a, 0xc9, 0x4e, 0xd7, 0x5f, 0x25, 0x28, 0x8e, 0x71, 0x62, 0xcc, 0x7b, 0xc3, 0xf0, 0xc7,
	0x64, 0x1d, 0x51, 0xca, 0x38, 0x12, 0x2c, 0xba, 0xd6, 0xfe, 0x53, 0x0d, 0x9a, 0x9f, 0xa8, 0x45,
	0xd6, 0xa3, 0xa7, 0xcc, 0xba, 0x0b, 0x57, 0x38, 0x3e, 0xe7, 0xed, 0xda, 0xdb, 0xb5, 0x77, 0x9a,
	0x9b, 0x6f, 0xe8, 0xa8, 0xdc, 0x31, 0xe4, 0x9d, 0x43, 0x9e, 0x10, 0x1a, 0x1c, 0xa3, 0x30, 0xc3,
	0x8e, 0x6c, 0x69, 0x79, 0x00, 0xc3, 0xd5, 0xd9, 0xae, 0xbf, 0x5d, 0x7b, 0xe7, 0xfa, 0xe6, 0x6e,
	0x67, 0x56, 0x60, 0x97, 0x9d, 0xea, 0x68, 0xc5, 0xc7, 0x02, 0x77, 0x34, 0x88, 0xf1, 0x43, 0x9a,
	0x45, 0x13, 0x85, 0x4e, 0x23, 0x32, 0x3f, 0xed, 0x8f, 0x60, 0xf9, 0x20, 0x44, 0x1e, 0x16, 0x61,
	0x5b, 0xda, 0xd9, 0x81, 0x85, 0x2c, 0x09, 0x2b, 0x99, 0x29, 0x1a, 0xda, 0x67, 0xf0, 0xda, 0x63,
	0x76, 0x42, 0x42, 0xdc, 0x8d, 0xe3, 0x1d, 0xed, 0xe6, 0x92, 0xe8, 0x2b, 0x78, 0x23, 0x92, 0x15,
	0xae, 0xd8, 0x19, 0xf2, 0x15, 0xe0, 0x31, 0x9a, 0x72, 0x44, 0xab, 0x0d, 0xc4, 0x9d, 0x68, 0x9c,
	0x7a, 0x47, 0xc3, 0xed, 0xfd, 0x82, 0x6e, 0x48, 0x3c, 0x39, 0xf6, 0x52, 0xf7, 0x1e, 0x5c, 0x13,
	0x82, 0xc4, 0x97, 0x43, 0x56, 0xa6, 0x70, 0x15, 0xc5, 0x71, 0xcf, 0xb7, 0x5f, 0x40, 0x6b, 0x9f,
	0x15, 0x48, 0xf6, 0xe1, 0x56, 0x80, 0x99, 0xcb, 0x51, 0x12, 0x60, 0x3e, 0x9f, 0xcd, 0x37, 0x03,
	0xcc, 0x8e, 0x24, 0x2e, 0xb7, 0xd5, 0x01, 0xd8, 0x95, 0x1b, 0x8f, 0xe4, 0xde, 0x85, 0x2b, 0x72,
	0x46, 0x6b, 0x72, 0x46, 0xef, 0x96, 0xcc, 0xa8, 0x02, 0xca, 0x79, 0x54, 0x3f, 0x1d, 0x89, 0xb6,
	0xcf, 0xe1, 0xf6, 0x81, 0x89, 0x50, 0x3b, 0x2a, 0x40, 0x49, 0xf6, 0xaf, 0x35, 0xbb, 0xf2, 0x97,
	0xfd, 0x12, 0xf6, 0x71, 0x8a, 0xdc, 0x67, 0xa6, 0x55, 0x68, 0xe5, 0xdf, 0xd7, 0x61, 0x65, 0x5f,
	0x85, 0xf0, 0x3d, 0x11, 0xc1, 0xa5, 0xec, 0x17, 0x23, 0x9d, 0x2a, 0x73, 0xd3, 0x22, 0x3c, 0x97,
	0x1c, 0x2f, 0x54, 0x72, 0xd6, 0x21, 0x80, 0x87, 0x52, 0xec, 0x9e, 0x89, 0xd1, 0xd5, 0x73, 0x7a,
	0xbf, 0x73, 0x71, 0x7e, 0x63, 0xb8, 0x76, 0x49, 0x84, 0x69, 0xaa, 0x27, 0xd5, 0x69, 0x08, 0x1e,
	0x39, 0x49, 0xd6, 0x53, 0xb8, 0xa3, 0x76, 0x06, 0x17, 0xf9, 0x7a, 0x1f, 0xd2, 0x19, 0x14, 0xa3,
	0xed, 0x85, 0x0a, 0xb3, 0xbc, 0xaa, 0xe0, 0x5d, 0x5f, 0x9a, 0xbb, 0x63, 0xb0, 0x76, 0x3f, 0x1f,
	0x9b, 0x43, 0x8f, 0xc5, 0x6a, 0xc2, 0x8f, 0x00, 0x7c, 0x63, 0x48, 0xda, 0xae, 0xbf, 0xbd, 0x70,
	0xe9, 0x1e, 0x14, 0x78, 0xec, 0xdf, 0x01, 0xdc, 0x9e, 0xd6, 0xc8, 0x7a, 0x0a, 0xcb, 0x66, 0x87,
	0x3d, 0x11, 0xe1, 0x50, 0x7b, 0xed, 0xdd, 0x8a, 0x8a, 0xdb, 0x02, 0x23, 0x88, 0x1e, 0x7d, 0xcb,
	0x69, 0x85, 0x85, 0x32, 0xeb, 0x11, 0x2c, 0xa9, 0x14, 0x27, 0x5f, 0x5b, 0xef, 0x96, 0x71, 0x3e,
	0x12, 0xed, 0x7b, 0x86, 0x6e, 0xb1, 0xaf, 0x3e, 0xad, 0xcf, 0xa0, 0xa9, 0x98, 0xbc, 0x10, 0xa5,
	0xa9, 0x1e, 0xf0, 0x4e, 0x25, 0xb2, 0x1d, 0x81, 0xd0, 0x7c, 0xd0, 0xcf, 0x4b, 0xac, 0x9f, 0xc3,
	0x6d, 0x4d, 0xc9, 0x32, 0xca, 0x93, 0x81, 0x9b, 0xe0, 0x40, 0x4c, 0xe6, 0x15, 0xc9, 0xfd, 0xa0,
	0x1a, 0xb7, 0x82, 0x3a, 0x12, 0xa9, 0x35, 0xac, 0xfe, 0x44, 0xcd, 0xd0, 0x7c, 0x91, 0x54, 0xe0,
	0xf6, 0xd5, 0x39, 0xcc, 0x3f, 0x14, 0x88, 0x11, 0xf3, 0x65, 0x89, 0xf5, 0x29, 0x80, 0x36, 0x9f,
	0xf0, 0x41, 0xfb, 0x9a, 0x64, 0x7c, 0xaf, 0x9a, 0xd1, 0x84, 0x0f, 0x34, 0x61, 0xa3, 0x6f, 0x0a,
	0xac, 0x33, 0x68, 0xcf, 0x4a, 0xd5, 0xda, 0x8b, 0x92, 0x7d, 0xab, 0xa2, 0x3f, 0xec, 0x48, 0x78,
	0xd7, 0xa0, 0xb5, 0xd4, 0x6a, 0x38, 0xb5, 0x56, 0xe8, 0xce, 0x4a, 0x7e, 0xda, 0xcb, 0xd5, 0x74,
	0x0f, 0x14, 0x7e, 0x5b, 0xc1, 0x8b, 0x7b, 0x8a, 0xd0, 0x8d, 0xa7, 0xd6, 0x5a, 0x5f, 0xc1, 0x8d,
	0xb1, 0xdc, 0xa7, 0xbd, 0x24, 0xe5, 0x36, 0x2b, 0xca, 0xed, 0x28, 0x94, 0x96, 0xb9, 0x1e, 0x8f,
	0x94, 0x5a, 0xbf, 0x84, 0xd7, 0x2f, 0x48, 0xad, 0xda, 0x0d, 0x29, 0xf5, 0xe1, 0x7c, 0x52, 0x0f,
	0x87, 0x04, 0x5a, 0xf5, 0x4e, 0x3c, 0xab, 0x81, 0xe5, 0xc1, 0xcd, 0x89, 0xd4, 0xac, 0x0d, 0xd5,
	0x82, 0xa1, 0x91, 0x35, 0x38, 0xad, 0xb6, 0x12, 0x8f, 0x95, 0x5b, 0xcf, 0x87, 0x83, 0x48, 0x38,
	0x8e, 0xc4, 0x3a, 0x6f, 0x4a, 0x89, 0x8d, 0x8a, 0x12, 0x3d, 0x8e, 0xa3, 0x7c, 0xb5, 0x2f, 0xc7,
	0xc5, 0x42, 0xeb, 0x08, 0x5a, 0xc5, 0x2c, 0xb1, 0xdd, 0x92, 0xcc, 0xeb, 0x15, 0x99, 0xc5, 0x86,
	0xa0, 0x79, 0x9b, 0xf1, 0xb0, 0x68, 0xbb, 0x09, 0x8d, 0x3c, 0x26, 0xda, 0x3f, 0xcd, 0x83, 0x6f,
	0x1e, 0xc4, 0xac, 0x4d, 0xb8, 0xaa, 0x76, 0x8e, 0x2a, 0x7b, 0xb7, 0x6a, 0x6a, 0x77, 0xa1, 0x59,
	0x08, 0x5c, 0x97, 0xa2, 0xd8, 0x81, 0xeb, 0xa3, 0xe1, 0xca, 0xda, 0x18, 0x65, 0x79, 0x7d, 0x82,
	0xa5, 0x47, 0xf9, 0x83, 0xfb, 0x23, 0x24, 0x31, 0xac, 0x4e, 0x8f, 0x4b, 0xd6, 0x31, 0xb4, 0x47,
	0xe3, 0x5c, 0x61, 0xfb, 0xaa, 0x62, 0xe5, 0xaa, 0x57, 0xa4, 0x1c, 0x6e, 0x5f, 0x4f, 0xb5, 0xd9,
	0x79, 0x98, 0xb2, 0x1e, 0xc2, 0x0d, 0x19, 0xe5, 0xe6, 0x14, 0xb8, 0x2e, 0x41, 0x43, 0xe2, 0x23,
	0x58, 0x1e, 0x89, 0x56, 0xd6, 0x0e, 0x5c, 0x17, 0xa1, 0x6e, 0x4e, 0xda, 0x65, 0x81, 0x19, 0xb2,
	0xfe, 0xa3, 0x06, 0x6b, 0xb3, 0xc3, 0xd4, 0x65, 0x26, 0xce, 0x8a, 0xe1, 0xaa, 0x3c, 0xca, 0xea,
	0x04, 0xea, 0x59, 0xb5, 0x4c, 0x66, 0x42, 0xdd, 0xc7, 0xe7, 0xc5, 0xa4, 0x66, 0x5a, 0xbd, 0xa3,
	0x84, 0xec, 0xff, 0xd5, 0x60, 0x6d, 0x76, 0xcc, 0xb3, 0xde, 0x85, 0x3a, 0xf1, 0xab, 0x38, 0x4d,
	0x9d, 0xf8, 0xd6, 0x47, 0xd0, 0x32, 0x7e, 0xe1, 0x31, 0x1f, 0x57, 0x4a, 0x81, 0x9b, 0x1a, 0xb1,
	0xc3, 0x7c, 0xd9, 0x7d, 0x79, 0x7c, 0x93, 0x7b, 0x72, 0x79, 0xf7, 0xa7, 0xdb, 0xbd, 0x2f, 0x18,
	0x74, 0x1a, 0x39, 0xb3, 0xde, 0x51, 0x42, 0x76, 0x0c, 0xd6, 0x64, 0x08, 0xb6, 0x9e, 0xc1, 0xa2,
	0x89, 0xe3, 0x2a, 0xa5, 0xfc, 0x49, 0x35, 0x4b, 0x4c, 0xe8, 0x2c, 0x88, 0xeb, 0x22, 0xc7, 0x10,
	0xda, 0x7f, 0xa9, 0xc1, 0x9b, 0x17, 0x86, 0x62, 0xeb, 0x37, 0x35, 0xb8, 0x35, 0x2d, 0xce, 0x2b,
	0x53, 0x8e, 0xe7, 0x33, 0x65, 0x88, 0x9f, 0x62, 0x55, 0xa1, 0xd6, 0xb1, 0xbc, 0x89, 0x32, 0xfb,
	0x17, 0x22, 0xcd, 0x9f, 0x0c, 0xdf, 0xd6, 0x09, 0x34, 0x86, 0xfb, 0x40, 0xb5, 0xa4, 0x7b, 0x9c,
	0x67, 0xc4, 0x1a, 0x53, 0xe8, 0x0c, 0x69, 0xed, 0x3d, 0xb8, 0x39, 0x11, 0xd7, 0x2f, 0x15, 0x0c,
	0xff, 0x50, 0x83, 0x1b, 0x63, 0x71, 0xfc, 0x52, 0x6b, 0xf3, 0x99, 0x71, 0xce, 0xfa, 0x3c, 0x1d,
	0x16, 0x92, 0x13, 0x1e, 0x99, 0x17, 0x1a, 0x37, 0xfc, 0x55, 0x0d, 0xd6, 0x64, 0x84, 0xda, 0x45,
	0x1c, 0x1f, 0x9a, 0xeb, 0xbb, 0xdc, 0x5c, 0x7f, 0xe4, 0x7c, 0x73, 0x50, 0xa2, 0x3c, 0x9d, 0x48,
	0xea, 0x4f, 0xaf, 0xd2, 0x47, 0xab, 0xdf, 0xd6, 0xe0, 0x4d, 0xd9, 0xa0, 0xeb, 0x9f, 0x21, 0xea,
	0xe1, 0x6d, 0xc6, 0x5e, 0x12, 0x1a, 0x3c, 0x25, 0xd4, 0x67, 0xaf, 0xa4, 0x1d, 0x0f, 0x60, 0x29,
	0x22, 0xd4, 0xf5, 0xd1, 0x20, 0xad, 0x12, 0x13, 0x16, 0x23, 0x42, 0x77, 0xd1, 0x20, 0x95, 0x38,
	0x74, 0xae, 0x70, 0xf5, 0x2a, 0x38, 0x74, 0x2e, 0x70, 0xc2, 0xa2, 0xd7, 0xa4, 0x45, 0xfb, 0x98,
	0x06, 0xbc, 0xff, 0xe4, 0xf4, 0x90, 0x23, 0xb5, 0x46, 0xb6, 0x00, 0x84, 0x25, 0x94, 0x04, 0x7d,
	0x5e, 0xc9, 0x96, 0x46, 0x44, 0xe8, 0xa7, 0xb2, 0xb5, 0xc4, 0xa2, 0x73, 0x83, 0xad, 0x57, 0xc1,
	0xa2, 0x73, 0x85, 0xb5, 0x23, 0xb8, 0xa5, 0x76, 0x92, 0x3e, 0xf6, 0x5e, 0xf6, 0x44, 0xef, 0xf4,
	0x8e, 0xd8, 0x2c, 0xdc, 0x06, 0xeb, 0x79, 0x7a, 0x50, 0x76, 0xb8, 0x46, 0x83, 0x27, 0xa7, 0x4f,
	0x31, 0x7e, 0xa9, 0xce, 0xd7, 0xe6, 0xcb, 0x69, 0xf8, 0xe6, 0xa7, 0x90, 0xeb, 0x0d, 0x6f, 0x58,
	0x73, 0x7f, 0x38, 0x1e, 0xf1, 0x87, 0xed, 0x12, 0x9d, 0x31, 0x06, 0xa9, 0x36, 0x56, 0x66, 0x0e,
	0xd7, 0x0b, 0x70, 0xbd, 0xeb, 0x1f, 0x7a, 0x7d, 0xec, 0x67, 0xa1, 0x92, 0x72, 0xa1, 0x95, 0x72,
	0x94, 0x70, 0x57, 0xdd, 0x7f, 0x6a, 0xc9, 0x1f, 0x95, 0x48, 0x3e, 0x96, 0x8d, 0x9f, 0x9c, 0x3e,
	0x62, 0x59, 0x22, 0xf5, 0x8a, 0x05, 0x4e, 0x53, 0x32, 0xaa, 0x22, 0xeb, 0x39, 0x00, 0xa6, 0xbe,
	0xa1, 0xaf, 0x7f, 0x03, 0xf4, 0x0d, 0x4c, 0x7d, 0x4d, 0xbe, 0x05, 0xa0, 0xac, 0xef, 0xb3, 0x2c,
	0xd1, 0x27, 0xbd, 0xa9, 0x53, 0x7d, 0x6f, 0x53, 0x4f, 0xb5, 0x6c, 0x2e, 0x68, 0x84, 0xd3, 0x0a,
	0xc3, 0x24, 0xf2, 0x4a, 0x39, 0x72, 0x11, 0x53, 0x5f, 0xe2, 0xc6, 0x7c, 0xe1, 0xea, 0x37, 0xe5,
	0x0b, 0x5f, 0x43, 0xab, 0x1b, 0x60, 0x07, 0xd1, 0x40, 0xcd, 0xcc, 0xc1, 0x88, 0x13, 0x94, 0x0d,
	0x99, 0x81, 0xe6, 0x1e, 0x50, 0x2c, 0xd0, 0xd3, 0xff, 0x0c, 0x60, 0x4f, 0x3e, 0x3b, 0xe8, 0x5b,
	0xa8, 0x22, 0xff, 0xfb, 0x25, 0xfc, 0x0a, 0x98, 0xb3, 0x0f, 0x3f, 0x35, 0x37, 0x81, 0x1b, 0x3d,
	0xf9, 0xc4, 0x30, 0xec, 0xc0, 0xbc, 0x5e, 0x9c, 0xa3, 0x0b, 0x5e, 0x3c, 0x52, 0xa6, 0xa5, 0x12,
	0xb0, 0x0e, 0xf4, 0xc5, 0xfb, 0xa1, 0xbc, 0x77, 0x97, 0x6a, 0x2f, 0x46, 0xd4, 0x1e, 0x95, 0x45,
	0xef, 0x11, 0x82, 0xe1, 0xc5, 0xd4, 0x44, 0xb1, 0xd6, 0xfc, 0x04, 0x56, 0xbe, 0x64, 0xd9, 0x51,
	0x76, 0x82, 0x8f, 0x89, 0x8f, 0x99, 0x54, 0xfc, 0x01, 0x2c, 0x9d, 0x89, 0x0f, 0x37, 0xcf, 0xa0,
	0x2e, 0xde, 0x67, 0x16, 0x65, 0xeb, 0x9e, 0x6f, 0x7f, 0x06, 0x96, 0x26, 0x2b, 0x26, 0x25, 0x1f,
	0x00, 0x98, 0xac, 0xa0, 0x22, 0x61, 0x43, 0xb7, 0xef, 0xf9, 0x76, 0x0f, 0x5a, 0x9f, 0xa7, 0x38,
	0x11, 0x09, 0xa1, 0x24, 0xfb, 0x21, 0x34, 0xb2, 0x14, 0x27, 0xae, 0x38, 0x48, 0x57, 0xe2, 0x5a,
	0xca, 0x34, 0xdc, 0xfe, 0x67, 0x1d, 0x96, 0x0f, 0xcc, 0xcd, 0xb9, 0x24, 0xeb, 0x41, 0x23, 0xc0,
	0xcc, 0x8d, 0x19, 0xc9, 0x6f, 0x29, 0xbf, 0x57, 0x76, 0xb2, 0xda, 0xc3, 0xec, 0x40, 0xb4, 0x97,
	0x37, 0x4b, 0x4b, 0x81, 0xfe, 0xb2, 0xee, 0xc3, 0x35, 0x75, 0x17, 0x3f, 0x33, 0x79, 0xdc, 0x65,
	0xd9, 0x49, 0xa8, 0x2e, 0xd2, 0x1c, 0xdd, 0xd6, 0x62, 0xd0, 0x2a, 0xde, 0xe0, 0xeb, 0xf4, 0xb1,
	0xfc, 0xfa, 0x51, 0x77, 0xc2, 0x91, 0xd8, 0xcf, 0x05, 0xd4, 0xec, 0xd2, 0x13, 0x15, 0x4e, 0x33,
	0x19, 0x7e, 0x58, 0x0f, 0x61, 0x11, 0xf9, 0x7e, 0x82, 0xd3, 0x54, 0x87, 0x86, 0xd2, 0xbb, 0xa8,
	0xae, 0x6a, 0x2e, 0xbb, 0x6b, 0xb0, 0xf6, 0xdf, 0x6b, 0xd0, 0x2a, 0x0e, 0x84, 0xf5, 0x05, 0xac,
	0x85, 0x8c, 0x06, 0x84, 0x67, 0x3e, 0x76, 0x09, 0x75, 0x23, 0xe2, 0x25, 0xcc, 0xf5, 0x71, 0x90,
	0x60, 0x7c, 0xe1, 0x36, 0x67, 0xa2, 0xd0, 0xb7, 0x73, 0x78, 0x8f, 0x3e, 0x16, 0xe0, 0x5d, 0x85,
	0xb5, 0x8e, 0xe1, 0x4e, 0x88, 0xf8, 0x0c, 0xe2, 0x7a, 0x39, 0xf1, 0xaa, 0x41, 0x8f, 0xf2, 0xda,
	0xff, 0x5e, 0x80, 0x66, 0xa1, 0x6f, 0xd6, 0x87, 0xd0, 0x8c, 0x59, 0xca, 0x51, 0xa8, 0x8e, 0x00,
	0x55, 0x5c, 0x0b, 0x14, 0x40, 0x9e, 0x00, 0xba, 0x20, 0x0e, 0xee, 0x67, 0x84, 0x7a, 0xb8, 0xfa,
	0x19, 0xa2, 0x65, 0x20, 0x92, 0x62, 0xfc, 0x14, 0xb2, 0x30, 0xef, 0x29, 0xa4, 0x68, 0x03, 0x45,
	0x11, 0xd6, 0x53, 0x5c, 0xd1, 0x86, 0x4f, 0x51, 0x84, 0xc5, 0xf9, 0x32, 0xe5, 0x09, 0xc6, 0xdc,
	0x35, 0x6e, 0x72, 0xb5, 0xca, 0xf9, 0x52, 0x61, 0xf4, 0x70, 0xaa, 0xc3, 0x6f, 0x91, 0x64, 0x53,
	0x5f, 0xcd, 0x95, 0x1e, 0x7e, 0x0b, 0x2c, 0x9b, 0x62, 0xa9, 0xcb, 0xb3, 0xae, 0xec, 0xca, 0x62,
	0x95, 0xa5, 0x2e, 0x9a, 0x8b, 0x6e, 0x88, 0xb4, 0xb4, 0x71, 0xc4, 0x62, 0xe2, 0x99, 0x43, 0x33,
	0x17, 0x1f, 0xf3, 0xbd, 0x48, 0x2c, 0x4b, 0x8c, 0x79, 0x8d, 0xb0, 0xee, 0xc2, 0x95, 0x18, 0xf1,
	0xbe, 0xbe, 0x88, 0x2e, 0x79, 0x89, 0x12, 0x2d, 0xed, 0x2f, 0xa1, 0xb5, 0x8f, 0x68, 0x90, 0x21,
	0xbd, 0x6d, 0xf4, 0xe0, 0x66, 0xa8, 0xbf, 0xe7, 0xb3, 0x64, 0xc5, 0xc0, 0xf2, 0xa7, 0x91, 0x8f,
	0xa1, 0xd9, 0x8b, 0xb7, 0x43, 0x26, 0x52, 0x39, 0x15, 0x61, 0x49, 0x9c, 0xcf, 0x58, 0xa5, 0x08,
	0x4b, 0x62, 0x3d, 0xce, 0x76, 0x08, 0x2b, 0xfa, 0xb5, 0x62, 0x1f, 0x9d, 0xe8, 0x90, 0x3d, 0xdf,
	0xbb, 0x44, 0x11, 0x9e, 0xef, 0x38, 0xe3, 0x85, 0x7a, 0xbf, 0x39, 0x86, 0xe6, 0x0e, 0x4a, 0x12,
	0xa2, 0xf7, 0xea, 0x3d, 0x58, 0xf1, 0xd4, 0xe7, 0x7c, 0x43, 0x72, 0x43, 0xa3, 0xf2, 0x11, 0x39,
	0x85, 0x15, 0xb1, 0x4f, 0xc8, 0xf4, 0x10, 0xeb, 0xbd, 0xc2, 0x81, 0x55, 0xb9, 0x57, 0x10, 0x5d,
	0x38, 0xbc, 0x53, 0xad, 0x22, 0x71, 0x3b, 0x2b, 0xf0, 0x99, 0x33, 0xb8, 0xfd, 0xe7, 0x1a, 0x34,
	0x9f, 0xaa, 0x37, 0xd0, 0xfc, 0x42, 0xc6, 0x5c, 0xac, 0x28, 0x4f, 0xad, 0x76, 0x21, 0x63, 0x30,
	0x72, 0xd5, 0x1d, 0x01, 0xe4, 0xe7, 0xc7, 0xca, 0x4f, 0x1d, 0xda, 0x8a, 0x91, 0x03, 0xae, 0x53,
	0xe0, 0xb1, 0xff, 0x56, 0x87, 0xdb, 0xd3, 0x1a, 0x59, 0x21, 0x2c, 0xea, 0x37, 0x5f, 0x3d, 0xc1,
	0x4e, 0xc9, 0x04, 0x8f, 0xb3, 0x3c, 0x51, 0x68, 0x39, 0xcf, 0x33, 0xea, 0x1c, 0x23, 0x61, 0xc5,
	0xb0, 0x64, 0x9e, 0x88, 0x75, 0x96, 0x7c, 0x74, 0x19, 0x39, 0xce, 0x92, 0xd9, 0x7a, 0x9c, 0x25,
	0x4e, 0xae, 0x62, 0xbd, 0x0f, 0x4b, 0x28, 0x09, 0xb2, 0x08, 0x53, 0x5e, 0x29, 0x88, 0xe6, 0xad,
	0xed, 0x5f, 0xd7, 0x60, 0x4d, 0x11, 0x12, 0x1a, 0x1c, 0x0e, 0x52, 0x8e, 0xa3, 0x63, 0x9c, 0xe4,
	0x6f, 0x44, 0x01, 0x7c, 0x87, 0x99, 0x5a, 0x37, 0x95, 0xd5, 0xee, 0x99, 0xaa, 0x9f, 0xcf, 0x7d,
	0xdf, 0x62, 0x53, 0x45, 0x72, 0x6f, 0xce, 0xe0, 0x56, 0x37, 0x8e, 0x0f, 0xd4, 0xff, 0x05, 0x3d,
	0x66, 0xbe, 0x5e, 0x96, 0x3f, 0x1b, 0x59, 0x96, 0x1f, 0x97, 0x65, 0xce, 0xa3, 0x0c, 0xc3, 0x04,
	0x7a, 0xb2, 0x5c, 0x2f, 0xce, 0x53, 0x58, 0x51, 0xaf, 0xc3, 0x85, 0x77, 0x57, 0x07, 0x56, 0xf5,
	0x83, 0xb4, 0xfa, 0x2f, 0xa0, 0xf9, 0x3a, 0x7a, 0x3b, 0x2a, 0xf0, 0xe5, 0xdd, 0x7b, 0x0e, 0x96,
	0xbe, 0xda, 0x3b, 0x3d, 0x25, 0xd4, 0x64, 0x63, 0x0f, 0xe1, 0x86, 0x79, 0x74, 0xd1, 0xc5, 0xd5,
	0xee, 0x4c, 0xbd, 0x11, 0x2a, 0xfb, 0x73, 0x58, 0x51, 0xe4, 0xbd, 0xe1, 0xf3, 0x6e, 0x17, 0x96,
	0x35, 0x35, 0x91, 0x85, 0x95, 0x88, 0x5b, 0x5e, 0x81, 0x66, 0xfb, 0x3f, 0x35, 0xb0, 0x3d, 0x16,
	0x95, 0xac, 0xca, 0xed, 0x65, 0x7d, 0xcd, 0x8a, 0x0e, 0x04, 0xe5, 0x41, 0xed, 0xd9, 0xae, 0x06,
	0x04, 0x4c, 0x44, 0xf1, 0x0e, 0x4b, 0x82, 0xf5, 0x00, 0x53, 0x29, 0x68, 0xfe, 0xbf, 0x22, 0x26,
	0xe9, 0xac, 0xff, 0x50, 0xfb, 0x40, 0xfd, 0xf9, 0x63, 0x7d, 0x61, 0xaf, 0xdb, 0xfd, 0x6b, 0xfd,
	0xad, 0x3d, 0x45, 0xd6, 0xf5, 0xd3, 0x8e, 0xfa, 0x29, 0x7e, 0x1d, 0x6f, 0x74, 0x76, 0x64, 0xb3,
	0x7f, 0x99, 0x06, 0x2f, 0xba, 0x7e, 0xfa, 0x22, 0x6f, 0xf0, 0xe2, 0x78, 0xe3, 0x85, 0x6a, 0xf0,
	0xdf, 0xba, 0xad, 0x4a, 0xb7, 0xb6, 0xba, 0x7e, 0xba, 0xb5, 0x95, 0x37, 0xd9, 0xda, 0x3a, 0xde,
	0xd8, 0xda, 0x52, 0x8d, 0x4e, 0xae, 0x49, 0xeb, 0xee, 0xfd, 0x3f, 0x00, 0x00, 0xff, 0xff, 0x4e,
	0xc2, 0x3b, 0x34, 0x3e, 0x27, 0x00, 0x00,
}
