// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/common/ad_type_infos.proto

package common // import "google.golang.org/genproto/googleapis/ads/googleads/v1/common"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A text ad.
type TextAdInfo struct {
	// The headline of the ad.
	Headline *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	// The first line of the ad's description.
	Description1 *wrappers.StringValue `protobuf:"bytes,2,opt,name=description1,proto3" json:"description1,omitempty"`
	// The second line of the ad's description.
	Description2         *wrappers.StringValue `protobuf:"bytes,3,opt,name=description2,proto3" json:"description2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TextAdInfo) Reset()         { *m = TextAdInfo{} }
func (m *TextAdInfo) String() string { return proto.CompactTextString(m) }
func (*TextAdInfo) ProtoMessage()    {}
func (*TextAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{0}
}
func (m *TextAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextAdInfo.Unmarshal(m, b)
}
func (m *TextAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextAdInfo.Marshal(b, m, deterministic)
}
func (dst *TextAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextAdInfo.Merge(dst, src)
}
func (m *TextAdInfo) XXX_Size() int {
	return xxx_messageInfo_TextAdInfo.Size(m)
}
func (m *TextAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TextAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TextAdInfo proto.InternalMessageInfo

func (m *TextAdInfo) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *TextAdInfo) GetDescription1() *wrappers.StringValue {
	if m != nil {
		return m.Description1
	}
	return nil
}

func (m *TextAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

// An expanded text ad.
type ExpandedTextAdInfo struct {
	// The first part of the ad's headline.
	HeadlinePart1 *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline_part1,json=headlinePart1,proto3" json:"headline_part1,omitempty"`
	// The second part of the ad's headline.
	HeadlinePart2 *wrappers.StringValue `protobuf:"bytes,2,opt,name=headline_part2,json=headlinePart2,proto3" json:"headline_part2,omitempty"`
	// The third part of the ad's headline.
	HeadlinePart3 *wrappers.StringValue `protobuf:"bytes,6,opt,name=headline_part3,json=headlinePart3,proto3" json:"headline_part3,omitempty"`
	// The description of the ad.
	Description *wrappers.StringValue `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The second description of the ad.
	Description2 *wrappers.StringValue `protobuf:"bytes,7,opt,name=description2,proto3" json:"description2,omitempty"`
	// The text that can appear alongside the ad's displayed URL.
	Path1 *wrappers.StringValue `protobuf:"bytes,4,opt,name=path1,proto3" json:"path1,omitempty"`
	// Additional text that can appear alongside the ad's displayed URL.
	Path2                *wrappers.StringValue `protobuf:"bytes,5,opt,name=path2,proto3" json:"path2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExpandedTextAdInfo) Reset()         { *m = ExpandedTextAdInfo{} }
func (m *ExpandedTextAdInfo) String() string { return proto.CompactTextString(m) }
func (*ExpandedTextAdInfo) ProtoMessage()    {}
func (*ExpandedTextAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{1}
}
func (m *ExpandedTextAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExpandedTextAdInfo.Unmarshal(m, b)
}
func (m *ExpandedTextAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExpandedTextAdInfo.Marshal(b, m, deterministic)
}
func (dst *ExpandedTextAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExpandedTextAdInfo.Merge(dst, src)
}
func (m *ExpandedTextAdInfo) XXX_Size() int {
	return xxx_messageInfo_ExpandedTextAdInfo.Size(m)
}
func (m *ExpandedTextAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExpandedTextAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExpandedTextAdInfo proto.InternalMessageInfo

func (m *ExpandedTextAdInfo) GetHeadlinePart1() *wrappers.StringValue {
	if m != nil {
		return m.HeadlinePart1
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetHeadlinePart2() *wrappers.StringValue {
	if m != nil {
		return m.HeadlinePart2
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetHeadlinePart3() *wrappers.StringValue {
	if m != nil {
		return m.HeadlinePart3
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetPath1() *wrappers.StringValue {
	if m != nil {
		return m.Path1
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetPath2() *wrappers.StringValue {
	if m != nil {
		return m.Path2
	}
	return nil
}

// A call-only ad.
type CallOnlyAdInfo struct {
	// The country code in the ad.
	CountryCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// The phone number in the ad.
	PhoneNumber *wrappers.StringValue `protobuf:"bytes,2,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// The business name in the ad.
	BusinessName *wrappers.StringValue `protobuf:"bytes,3,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// The first line of the ad's description.
	Description1 *wrappers.StringValue `protobuf:"bytes,4,opt,name=description1,proto3" json:"description1,omitempty"`
	// The second line of the ad's description.
	Description2 *wrappers.StringValue `protobuf:"bytes,5,opt,name=description2,proto3" json:"description2,omitempty"`
	// Whether to enable call tracking for the creative. Enabling call
	// tracking also enables call conversions.
	CallTracked *wrappers.BoolValue `protobuf:"bytes,6,opt,name=call_tracked,json=callTracked,proto3" json:"call_tracked,omitempty"`
	// Whether to disable call conversion for the creative.
	// If set to `true`, disables call conversions even when `call_tracked` is
	// `true`.
	// If `call_tracked` is `false`, this field is ignored.
	DisableCallConversion *wrappers.BoolValue `protobuf:"bytes,7,opt,name=disable_call_conversion,json=disableCallConversion,proto3" json:"disable_call_conversion,omitempty"`
	// The URL to be used for phone number verification.
	PhoneNumberVerificationUrl *wrappers.StringValue `protobuf:"bytes,8,opt,name=phone_number_verification_url,json=phoneNumberVerificationUrl,proto3" json:"phone_number_verification_url,omitempty"`
	// The conversion action to attribute a call conversion to. If not set a
	// default conversion action is used. This field only has effect if
	// call_tracked is set to true. Otherwise this field is ignored.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,9,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The call conversion behavior of this call only ad. It can use its own call
	// conversion setting, inherit the account level setting, or be disabled.
	ConversionReportingState enums.CallConversionReportingStateEnum_CallConversionReportingState `protobuf:"varint,10,opt,name=conversion_reporting_state,json=conversionReportingState,proto3,enum=google.ads.googleads.v1.enums.CallConversionReportingStateEnum_CallConversionReportingState" json:"conversion_reporting_state,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}                                                            `json:"-"`
	XXX_unrecognized         []byte                                                              `json:"-"`
	XXX_sizecache            int32                                                               `json:"-"`
}

func (m *CallOnlyAdInfo) Reset()         { *m = CallOnlyAdInfo{} }
func (m *CallOnlyAdInfo) String() string { return proto.CompactTextString(m) }
func (*CallOnlyAdInfo) ProtoMessage()    {}
func (*CallOnlyAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{2}
}
func (m *CallOnlyAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CallOnlyAdInfo.Unmarshal(m, b)
}
func (m *CallOnlyAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CallOnlyAdInfo.Marshal(b, m, deterministic)
}
func (dst *CallOnlyAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CallOnlyAdInfo.Merge(dst, src)
}
func (m *CallOnlyAdInfo) XXX_Size() int {
	return xxx_messageInfo_CallOnlyAdInfo.Size(m)
}
func (m *CallOnlyAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CallOnlyAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CallOnlyAdInfo proto.InternalMessageInfo

func (m *CallOnlyAdInfo) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *CallOnlyAdInfo) GetPhoneNumber() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumber
	}
	return nil
}

func (m *CallOnlyAdInfo) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *CallOnlyAdInfo) GetDescription1() *wrappers.StringValue {
	if m != nil {
		return m.Description1
	}
	return nil
}

func (m *CallOnlyAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

func (m *CallOnlyAdInfo) GetCallTracked() *wrappers.BoolValue {
	if m != nil {
		return m.CallTracked
	}
	return nil
}

func (m *CallOnlyAdInfo) GetDisableCallConversion() *wrappers.BoolValue {
	if m != nil {
		return m.DisableCallConversion
	}
	return nil
}

func (m *CallOnlyAdInfo) GetPhoneNumberVerificationUrl() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumberVerificationUrl
	}
	return nil
}

func (m *CallOnlyAdInfo) GetConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *CallOnlyAdInfo) GetConversionReportingState() enums.CallConversionReportingStateEnum_CallConversionReportingState {
	if m != nil {
		return m.ConversionReportingState
	}
	return enums.CallConversionReportingStateEnum_UNSPECIFIED
}

// An expanded dynamic search ad.
type ExpandedDynamicSearchAdInfo struct {
	// The description of the ad.
	Description          *wrappers.StringValue `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExpandedDynamicSearchAdInfo) Reset()         { *m = ExpandedDynamicSearchAdInfo{} }
func (m *ExpandedDynamicSearchAdInfo) String() string { return proto.CompactTextString(m) }
func (*ExpandedDynamicSearchAdInfo) ProtoMessage()    {}
func (*ExpandedDynamicSearchAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{3}
}
func (m *ExpandedDynamicSearchAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExpandedDynamicSearchAdInfo.Unmarshal(m, b)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExpandedDynamicSearchAdInfo.Marshal(b, m, deterministic)
}
func (dst *ExpandedDynamicSearchAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExpandedDynamicSearchAdInfo.Merge(dst, src)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_Size() int {
	return xxx_messageInfo_ExpandedDynamicSearchAdInfo.Size(m)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExpandedDynamicSearchAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExpandedDynamicSearchAdInfo proto.InternalMessageInfo

func (m *ExpandedDynamicSearchAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

// A hotel ad.
type HotelAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HotelAdInfo) Reset()         { *m = HotelAdInfo{} }
func (m *HotelAdInfo) String() string { return proto.CompactTextString(m) }
func (*HotelAdInfo) ProtoMessage()    {}
func (*HotelAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{4}
}
func (m *HotelAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelAdInfo.Unmarshal(m, b)
}
func (m *HotelAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelAdInfo.Marshal(b, m, deterministic)
}
func (dst *HotelAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelAdInfo.Merge(dst, src)
}
func (m *HotelAdInfo) XXX_Size() int {
	return xxx_messageInfo_HotelAdInfo.Size(m)
}
func (m *HotelAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelAdInfo proto.InternalMessageInfo

// A Smart Shopping ad.
type ShoppingSmartAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShoppingSmartAdInfo) Reset()         { *m = ShoppingSmartAdInfo{} }
func (m *ShoppingSmartAdInfo) String() string { return proto.CompactTextString(m) }
func (*ShoppingSmartAdInfo) ProtoMessage()    {}
func (*ShoppingSmartAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{5}
}
func (m *ShoppingSmartAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShoppingSmartAdInfo.Unmarshal(m, b)
}
func (m *ShoppingSmartAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShoppingSmartAdInfo.Marshal(b, m, deterministic)
}
func (dst *ShoppingSmartAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShoppingSmartAdInfo.Merge(dst, src)
}
func (m *ShoppingSmartAdInfo) XXX_Size() int {
	return xxx_messageInfo_ShoppingSmartAdInfo.Size(m)
}
func (m *ShoppingSmartAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ShoppingSmartAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ShoppingSmartAdInfo proto.InternalMessageInfo

// A standard Shopping ad.
type ShoppingProductAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShoppingProductAdInfo) Reset()         { *m = ShoppingProductAdInfo{} }
func (m *ShoppingProductAdInfo) String() string { return proto.CompactTextString(m) }
func (*ShoppingProductAdInfo) ProtoMessage()    {}
func (*ShoppingProductAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{6}
}
func (m *ShoppingProductAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShoppingProductAdInfo.Unmarshal(m, b)
}
func (m *ShoppingProductAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShoppingProductAdInfo.Marshal(b, m, deterministic)
}
func (dst *ShoppingProductAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShoppingProductAdInfo.Merge(dst, src)
}
func (m *ShoppingProductAdInfo) XXX_Size() int {
	return xxx_messageInfo_ShoppingProductAdInfo.Size(m)
}
func (m *ShoppingProductAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ShoppingProductAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ShoppingProductAdInfo proto.InternalMessageInfo

// A Gmail ad.
type GmailAdInfo struct {
	// The Gmail teaser.
	Teaser *GmailTeaser `protobuf:"bytes,1,opt,name=teaser,proto3" json:"teaser,omitempty"`
	// The MediaFile resource name of the header image. Valid image types are GIF,
	// JPEG and PNG. The minimum size is 300x100 pixels and the aspect ratio must
	// be between 3:1 and 5:1 (+-1%).
	HeaderImage *wrappers.StringValue `protobuf:"bytes,2,opt,name=header_image,json=headerImage,proto3" json:"header_image,omitempty"`
	// The MediaFile resource name of the marketing image. Valid image types are
	// GIF, JPEG and PNG. The image must either be landscape with a minimum size
	// of 600x314 pixels and aspect ratio of 600:314 (+-1%) or square with a
	// minimum size of 300x300 pixels and aspect ratio of 1:1 (+-1%)
	MarketingImage *wrappers.StringValue `protobuf:"bytes,3,opt,name=marketing_image,json=marketingImage,proto3" json:"marketing_image,omitempty"`
	// Headline of the marketing image.
	MarketingImageHeadline *wrappers.StringValue `protobuf:"bytes,4,opt,name=marketing_image_headline,json=marketingImageHeadline,proto3" json:"marketing_image_headline,omitempty"`
	// Description of the marketing image.
	MarketingImageDescription *wrappers.StringValue `protobuf:"bytes,5,opt,name=marketing_image_description,json=marketingImageDescription,proto3" json:"marketing_image_description,omitempty"`
	// Display-call-to-action of the marketing image.
	MarketingImageDisplayCallToAction *DisplayCallToAction `protobuf:"bytes,6,opt,name=marketing_image_display_call_to_action,json=marketingImageDisplayCallToAction,proto3" json:"marketing_image_display_call_to_action,omitempty"`
	// Product images. Up to 15 images are supported.
	ProductImages []*ProductImage `protobuf:"bytes,7,rep,name=product_images,json=productImages,proto3" json:"product_images,omitempty"`
	// Product videos. Up to 7 videos are supported. At least one product video
	// or a marketing image must be specified.
	ProductVideos        []*ProductVideo `protobuf:"bytes,8,rep,name=product_videos,json=productVideos,proto3" json:"product_videos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *GmailAdInfo) Reset()         { *m = GmailAdInfo{} }
func (m *GmailAdInfo) String() string { return proto.CompactTextString(m) }
func (*GmailAdInfo) ProtoMessage()    {}
func (*GmailAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{7}
}
func (m *GmailAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GmailAdInfo.Unmarshal(m, b)
}
func (m *GmailAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GmailAdInfo.Marshal(b, m, deterministic)
}
func (dst *GmailAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GmailAdInfo.Merge(dst, src)
}
func (m *GmailAdInfo) XXX_Size() int {
	return xxx_messageInfo_GmailAdInfo.Size(m)
}
func (m *GmailAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GmailAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GmailAdInfo proto.InternalMessageInfo

func (m *GmailAdInfo) GetTeaser() *GmailTeaser {
	if m != nil {
		return m.Teaser
	}
	return nil
}

func (m *GmailAdInfo) GetHeaderImage() *wrappers.StringValue {
	if m != nil {
		return m.HeaderImage
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImage() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImage
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImageHeadline() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImageHeadline
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImageDescription() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImageDescription
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImageDisplayCallToAction() *DisplayCallToAction {
	if m != nil {
		return m.MarketingImageDisplayCallToAction
	}
	return nil
}

func (m *GmailAdInfo) GetProductImages() []*ProductImage {
	if m != nil {
		return m.ProductImages
	}
	return nil
}

func (m *GmailAdInfo) GetProductVideos() []*ProductVideo {
	if m != nil {
		return m.ProductVideos
	}
	return nil
}

// Gmail teaser data. The teaser is a small header that acts as an invitation
// to view the rest of the ad (the body).
type GmailTeaser struct {
	// Headline of the teaser.
	Headline *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	// Description of the teaser.
	Description *wrappers.StringValue `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Business name of the advertiser.
	BusinessName *wrappers.StringValue `protobuf:"bytes,3,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// The MediaFile resource name of the logo image. Valid image types are GIF,
	// JPEG and PNG. The minimum size is 144x144 pixels and the aspect ratio must
	// be 1:1 (+-1%).
	LogoImage            *wrappers.StringValue `protobuf:"bytes,4,opt,name=logo_image,json=logoImage,proto3" json:"logo_image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GmailTeaser) Reset()         { *m = GmailTeaser{} }
func (m *GmailTeaser) String() string { return proto.CompactTextString(m) }
func (*GmailTeaser) ProtoMessage()    {}
func (*GmailTeaser) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{8}
}
func (m *GmailTeaser) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GmailTeaser.Unmarshal(m, b)
}
func (m *GmailTeaser) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GmailTeaser.Marshal(b, m, deterministic)
}
func (dst *GmailTeaser) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GmailTeaser.Merge(dst, src)
}
func (m *GmailTeaser) XXX_Size() int {
	return xxx_messageInfo_GmailTeaser.Size(m)
}
func (m *GmailTeaser) XXX_DiscardUnknown() {
	xxx_messageInfo_GmailTeaser.DiscardUnknown(m)
}

var xxx_messageInfo_GmailTeaser proto.InternalMessageInfo

func (m *GmailTeaser) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *GmailTeaser) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *GmailTeaser) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *GmailTeaser) GetLogoImage() *wrappers.StringValue {
	if m != nil {
		return m.LogoImage
	}
	return nil
}

// Data for display call to action. The call to action is a piece of the ad
// that prompts the user to do something. Like clicking a link or making a phone
// call.
type DisplayCallToAction struct {
	// Text for the display-call-to-action.
	Text *wrappers.StringValue `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Text color for the display-call-to-action in hexadecimal, e.g. #ffffff for
	// white.
	TextColor *wrappers.StringValue `protobuf:"bytes,2,opt,name=text_color,json=textColor,proto3" json:"text_color,omitempty"`
	// Identifies the url collection in the ad.url_collections field. If not set
	// the url defaults to final_url.
	UrlCollectionId      *wrappers.StringValue `protobuf:"bytes,3,opt,name=url_collection_id,json=urlCollectionId,proto3" json:"url_collection_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DisplayCallToAction) Reset()         { *m = DisplayCallToAction{} }
func (m *DisplayCallToAction) String() string { return proto.CompactTextString(m) }
func (*DisplayCallToAction) ProtoMessage()    {}
func (*DisplayCallToAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{9}
}
func (m *DisplayCallToAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisplayCallToAction.Unmarshal(m, b)
}
func (m *DisplayCallToAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisplayCallToAction.Marshal(b, m, deterministic)
}
func (dst *DisplayCallToAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisplayCallToAction.Merge(dst, src)
}
func (m *DisplayCallToAction) XXX_Size() int {
	return xxx_messageInfo_DisplayCallToAction.Size(m)
}
func (m *DisplayCallToAction) XXX_DiscardUnknown() {
	xxx_messageInfo_DisplayCallToAction.DiscardUnknown(m)
}

var xxx_messageInfo_DisplayCallToAction proto.InternalMessageInfo

func (m *DisplayCallToAction) GetText() *wrappers.StringValue {
	if m != nil {
		return m.Text
	}
	return nil
}

func (m *DisplayCallToAction) GetTextColor() *wrappers.StringValue {
	if m != nil {
		return m.TextColor
	}
	return nil
}

func (m *DisplayCallToAction) GetUrlCollectionId() *wrappers.StringValue {
	if m != nil {
		return m.UrlCollectionId
	}
	return nil
}

// Product image specific data.
type ProductImage struct {
	// The MediaFile resource name of the product image. Valid image types are
	// GIF, JPEG and PNG. The minimum size is 300x300 pixels and the aspect ratio
	// must be 1:1 (+-1%).
	ProductImage *wrappers.StringValue `protobuf:"bytes,1,opt,name=product_image,json=productImage,proto3" json:"product_image,omitempty"`
	// Description of the product.
	Description *wrappers.StringValue `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Display-call-to-action of the product image.
	DisplayCallToAction  *DisplayCallToAction `protobuf:"bytes,3,opt,name=display_call_to_action,json=displayCallToAction,proto3" json:"display_call_to_action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ProductImage) Reset()         { *m = ProductImage{} }
func (m *ProductImage) String() string { return proto.CompactTextString(m) }
func (*ProductImage) ProtoMessage()    {}
func (*ProductImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{10}
}
func (m *ProductImage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductImage.Unmarshal(m, b)
}
func (m *ProductImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductImage.Marshal(b, m, deterministic)
}
func (dst *ProductImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductImage.Merge(dst, src)
}
func (m *ProductImage) XXX_Size() int {
	return xxx_messageInfo_ProductImage.Size(m)
}
func (m *ProductImage) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductImage.DiscardUnknown(m)
}

var xxx_messageInfo_ProductImage proto.InternalMessageInfo

func (m *ProductImage) GetProductImage() *wrappers.StringValue {
	if m != nil {
		return m.ProductImage
	}
	return nil
}

func (m *ProductImage) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *ProductImage) GetDisplayCallToAction() *DisplayCallToAction {
	if m != nil {
		return m.DisplayCallToAction
	}
	return nil
}

// Product video specific data.
type ProductVideo struct {
	// The MediaFile resource name of a video which must be hosted on YouTube.
	ProductVideo         *wrappers.StringValue `protobuf:"bytes,1,opt,name=product_video,json=productVideo,proto3" json:"product_video,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ProductVideo) Reset()         { *m = ProductVideo{} }
func (m *ProductVideo) String() string { return proto.CompactTextString(m) }
func (*ProductVideo) ProtoMessage()    {}
func (*ProductVideo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{11}
}
func (m *ProductVideo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductVideo.Unmarshal(m, b)
}
func (m *ProductVideo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductVideo.Marshal(b, m, deterministic)
}
func (dst *ProductVideo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductVideo.Merge(dst, src)
}
func (m *ProductVideo) XXX_Size() int {
	return xxx_messageInfo_ProductVideo.Size(m)
}
func (m *ProductVideo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductVideo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductVideo proto.InternalMessageInfo

func (m *ProductVideo) GetProductVideo() *wrappers.StringValue {
	if m != nil {
		return m.ProductVideo
	}
	return nil
}

// An image ad.
type ImageAdInfo struct {
	// Width in pixels of the full size image.
	PixelWidth *wrappers.Int64Value `protobuf:"bytes,4,opt,name=pixel_width,json=pixelWidth,proto3" json:"pixel_width,omitempty"`
	// Height in pixels of the full size image.
	PixelHeight *wrappers.Int64Value `protobuf:"bytes,5,opt,name=pixel_height,json=pixelHeight,proto3" json:"pixel_height,omitempty"`
	// URL of the full size image.
	ImageUrl *wrappers.StringValue `protobuf:"bytes,6,opt,name=image_url,json=imageUrl,proto3" json:"image_url,omitempty"`
	// Width in pixels of the preview size image.
	PreviewPixelWidth *wrappers.Int64Value `protobuf:"bytes,7,opt,name=preview_pixel_width,json=previewPixelWidth,proto3" json:"preview_pixel_width,omitempty"`
	// Height in pixels of the preview size image.
	PreviewPixelHeight *wrappers.Int64Value `protobuf:"bytes,8,opt,name=preview_pixel_height,json=previewPixelHeight,proto3" json:"preview_pixel_height,omitempty"`
	// URL of the preview size image.
	PreviewImageUrl *wrappers.StringValue `protobuf:"bytes,9,opt,name=preview_image_url,json=previewImageUrl,proto3" json:"preview_image_url,omitempty"`
	// The mime type of the image.
	MimeType enums.MimeTypeEnum_MimeType `protobuf:"varint,10,opt,name=mime_type,json=mimeType,proto3,enum=google.ads.googleads.v1.enums.MimeTypeEnum_MimeType" json:"mime_type,omitempty"`
	// The name of the image. If the image was created from a MediaFile, this is
	// the MediaFile's name. If the image was created from bytes, this is empty.
	Name *wrappers.StringValue `protobuf:"bytes,11,opt,name=name,proto3" json:"name,omitempty"`
	// The image to create the ImageAd from. This can be specified in one of
	// two ways.
	// 1. An existing MediaFile resource.
	// 2. The raw image data as bytes.
	//
	// Types that are valid to be assigned to Image:
	//	*ImageAdInfo_MediaFile
	//	*ImageAdInfo_Data
	//	*ImageAdInfo_AdIdToCopyImageFrom
	Image                isImageAdInfo_Image `protobuf_oneof:"image"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ImageAdInfo) Reset()         { *m = ImageAdInfo{} }
func (m *ImageAdInfo) String() string { return proto.CompactTextString(m) }
func (*ImageAdInfo) ProtoMessage()    {}
func (*ImageAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{12}
}
func (m *ImageAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageAdInfo.Unmarshal(m, b)
}
func (m *ImageAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageAdInfo.Marshal(b, m, deterministic)
}
func (dst *ImageAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageAdInfo.Merge(dst, src)
}
func (m *ImageAdInfo) XXX_Size() int {
	return xxx_messageInfo_ImageAdInfo.Size(m)
}
func (m *ImageAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ImageAdInfo proto.InternalMessageInfo

func (m *ImageAdInfo) GetPixelWidth() *wrappers.Int64Value {
	if m != nil {
		return m.PixelWidth
	}
	return nil
}

func (m *ImageAdInfo) GetPixelHeight() *wrappers.Int64Value {
	if m != nil {
		return m.PixelHeight
	}
	return nil
}

func (m *ImageAdInfo) GetImageUrl() *wrappers.StringValue {
	if m != nil {
		return m.ImageUrl
	}
	return nil
}

func (m *ImageAdInfo) GetPreviewPixelWidth() *wrappers.Int64Value {
	if m != nil {
		return m.PreviewPixelWidth
	}
	return nil
}

func (m *ImageAdInfo) GetPreviewPixelHeight() *wrappers.Int64Value {
	if m != nil {
		return m.PreviewPixelHeight
	}
	return nil
}

func (m *ImageAdInfo) GetPreviewImageUrl() *wrappers.StringValue {
	if m != nil {
		return m.PreviewImageUrl
	}
	return nil
}

func (m *ImageAdInfo) GetMimeType() enums.MimeTypeEnum_MimeType {
	if m != nil {
		return m.MimeType
	}
	return enums.MimeTypeEnum_UNSPECIFIED
}

func (m *ImageAdInfo) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

type isImageAdInfo_Image interface {
	isImageAdInfo_Image()
}

type ImageAdInfo_MediaFile struct {
	MediaFile *wrappers.StringValue `protobuf:"bytes,1,opt,name=media_file,json=mediaFile,proto3,oneof"`
}

type ImageAdInfo_Data struct {
	Data *wrappers.BytesValue `protobuf:"bytes,2,opt,name=data,proto3,oneof"`
}

type ImageAdInfo_AdIdToCopyImageFrom struct {
	AdIdToCopyImageFrom *wrappers.Int64Value `protobuf:"bytes,3,opt,name=ad_id_to_copy_image_from,json=adIdToCopyImageFrom,proto3,oneof"`
}

func (*ImageAdInfo_MediaFile) isImageAdInfo_Image() {}

func (*ImageAdInfo_Data) isImageAdInfo_Image() {}

func (*ImageAdInfo_AdIdToCopyImageFrom) isImageAdInfo_Image() {}

func (m *ImageAdInfo) GetImage() isImageAdInfo_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ImageAdInfo) GetMediaFile() *wrappers.StringValue {
	if x, ok := m.GetImage().(*ImageAdInfo_MediaFile); ok {
		return x.MediaFile
	}
	return nil
}

func (m *ImageAdInfo) GetData() *wrappers.BytesValue {
	if x, ok := m.GetImage().(*ImageAdInfo_Data); ok {
		return x.Data
	}
	return nil
}

func (m *ImageAdInfo) GetAdIdToCopyImageFrom() *wrappers.Int64Value {
	if x, ok := m.GetImage().(*ImageAdInfo_AdIdToCopyImageFrom); ok {
		return x.AdIdToCopyImageFrom
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ImageAdInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ImageAdInfo_OneofMarshaler, _ImageAdInfo_OneofUnmarshaler, _ImageAdInfo_OneofSizer, []interface{}{
		(*ImageAdInfo_MediaFile)(nil),
		(*ImageAdInfo_Data)(nil),
		(*ImageAdInfo_AdIdToCopyImageFrom)(nil),
	}
}

func _ImageAdInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ImageAdInfo)
	// image
	switch x := m.Image.(type) {
	case *ImageAdInfo_MediaFile:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MediaFile); err != nil {
			return err
		}
	case *ImageAdInfo_Data:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Data); err != nil {
			return err
		}
	case *ImageAdInfo_AdIdToCopyImageFrom:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdIdToCopyImageFrom); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ImageAdInfo.Image has unexpected type %T", x)
	}
	return nil
}

func _ImageAdInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ImageAdInfo)
	switch tag {
	case 1: // image.media_file
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.StringValue)
		err := b.DecodeMessage(msg)
		m.Image = &ImageAdInfo_MediaFile{msg}
		return true, err
	case 2: // image.data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.BytesValue)
		err := b.DecodeMessage(msg)
		m.Image = &ImageAdInfo_Data{msg}
		return true, err
	case 3: // image.ad_id_to_copy_image_from
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.Int64Value)
		err := b.DecodeMessage(msg)
		m.Image = &ImageAdInfo_AdIdToCopyImageFrom{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ImageAdInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ImageAdInfo)
	// image
	switch x := m.Image.(type) {
	case *ImageAdInfo_MediaFile:
		s := proto.Size(x.MediaFile)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ImageAdInfo_Data:
		s := proto.Size(x.Data)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ImageAdInfo_AdIdToCopyImageFrom:
		s := proto.Size(x.AdIdToCopyImageFrom)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Representation of video bumper in-stream ad format (very short in-stream
// non-skippable video ad).
type VideoBumperInStreamAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VideoBumperInStreamAdInfo) Reset()         { *m = VideoBumperInStreamAdInfo{} }
func (m *VideoBumperInStreamAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoBumperInStreamAdInfo) ProtoMessage()    {}
func (*VideoBumperInStreamAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{13}
}
func (m *VideoBumperInStreamAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoBumperInStreamAdInfo.Unmarshal(m, b)
}
func (m *VideoBumperInStreamAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoBumperInStreamAdInfo.Marshal(b, m, deterministic)
}
func (dst *VideoBumperInStreamAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoBumperInStreamAdInfo.Merge(dst, src)
}
func (m *VideoBumperInStreamAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoBumperInStreamAdInfo.Size(m)
}
func (m *VideoBumperInStreamAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoBumperInStreamAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoBumperInStreamAdInfo proto.InternalMessageInfo

// Representation of video non-skippable in-stream ad format (15 second
// in-stream non-skippable video ad).
type VideoNonSkippableInStreamAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VideoNonSkippableInStreamAdInfo) Reset()         { *m = VideoNonSkippableInStreamAdInfo{} }
func (m *VideoNonSkippableInStreamAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoNonSkippableInStreamAdInfo) ProtoMessage()    {}
func (*VideoNonSkippableInStreamAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{14}
}
func (m *VideoNonSkippableInStreamAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoNonSkippableInStreamAdInfo.Unmarshal(m, b)
}
func (m *VideoNonSkippableInStreamAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoNonSkippableInStreamAdInfo.Marshal(b, m, deterministic)
}
func (dst *VideoNonSkippableInStreamAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoNonSkippableInStreamAdInfo.Merge(dst, src)
}
func (m *VideoNonSkippableInStreamAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoNonSkippableInStreamAdInfo.Size(m)
}
func (m *VideoNonSkippableInStreamAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoNonSkippableInStreamAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoNonSkippableInStreamAdInfo proto.InternalMessageInfo

// Representation of video TrueView in-stream ad format (ad shown during video
// playback, often at beginning, which displays a skip button a few seconds into
// the video).
type VideoTrueViewInStreamAdInfo struct {
	// Label on the CTA (call-to-action) button taking the user to the video ad's
	// final URL.
	// Required for TrueView for action campaigns, optional otherwise.
	ActionButtonLabel *wrappers.StringValue `protobuf:"bytes,1,opt,name=action_button_label,json=actionButtonLabel,proto3" json:"action_button_label,omitempty"`
	// Additional text displayed with the CTA (call-to-action) button to give
	// context and encourage clicking on the button.
	ActionHeadline       *wrappers.StringValue `protobuf:"bytes,2,opt,name=action_headline,json=actionHeadline,proto3" json:"action_headline,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoTrueViewInStreamAdInfo) Reset()         { *m = VideoTrueViewInStreamAdInfo{} }
func (m *VideoTrueViewInStreamAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoTrueViewInStreamAdInfo) ProtoMessage()    {}
func (*VideoTrueViewInStreamAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{15}
}
func (m *VideoTrueViewInStreamAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoTrueViewInStreamAdInfo.Unmarshal(m, b)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoTrueViewInStreamAdInfo.Marshal(b, m, deterministic)
}
func (dst *VideoTrueViewInStreamAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoTrueViewInStreamAdInfo.Merge(dst, src)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoTrueViewInStreamAdInfo.Size(m)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoTrueViewInStreamAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoTrueViewInStreamAdInfo proto.InternalMessageInfo

func (m *VideoTrueViewInStreamAdInfo) GetActionButtonLabel() *wrappers.StringValue {
	if m != nil {
		return m.ActionButtonLabel
	}
	return nil
}

func (m *VideoTrueViewInStreamAdInfo) GetActionHeadline() *wrappers.StringValue {
	if m != nil {
		return m.ActionHeadline
	}
	return nil
}

// Representation of video out-stream ad format (ad shown alongside a feed
// with automatic playback, without sound).
type VideoOutstreamAdInfo struct {
	// The headline of the ad.
	Headline *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	// The description line.
	Description          *wrappers.StringValue `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoOutstreamAdInfo) Reset()         { *m = VideoOutstreamAdInfo{} }
func (m *VideoOutstreamAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoOutstreamAdInfo) ProtoMessage()    {}
func (*VideoOutstreamAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{16}
}
func (m *VideoOutstreamAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoOutstreamAdInfo.Unmarshal(m, b)
}
func (m *VideoOutstreamAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoOutstreamAdInfo.Marshal(b, m, deterministic)
}
func (dst *VideoOutstreamAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoOutstreamAdInfo.Merge(dst, src)
}
func (m *VideoOutstreamAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoOutstreamAdInfo.Size(m)
}
func (m *VideoOutstreamAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoOutstreamAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoOutstreamAdInfo proto.InternalMessageInfo

func (m *VideoOutstreamAdInfo) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *VideoOutstreamAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

// A video ad.
type VideoAdInfo struct {
	// The MediaFile resource to use for the video.
	MediaFile *wrappers.StringValue `protobuf:"bytes,1,opt,name=media_file,json=mediaFile,proto3" json:"media_file,omitempty"`
	// Format-specific schema for the different video formats.
	//
	// Types that are valid to be assigned to Format:
	//	*VideoAdInfo_InStream
	//	*VideoAdInfo_Bumper
	//	*VideoAdInfo_OutStream
	//	*VideoAdInfo_NonSkippable
	Format               isVideoAdInfo_Format `protobuf_oneof:"format"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAdInfo) Reset()         { *m = VideoAdInfo{} }
func (m *VideoAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoAdInfo) ProtoMessage()    {}
func (*VideoAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{17}
}
func (m *VideoAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAdInfo.Unmarshal(m, b)
}
func (m *VideoAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAdInfo.Marshal(b, m, deterministic)
}
func (dst *VideoAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAdInfo.Merge(dst, src)
}
func (m *VideoAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoAdInfo.Size(m)
}
func (m *VideoAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAdInfo proto.InternalMessageInfo

func (m *VideoAdInfo) GetMediaFile() *wrappers.StringValue {
	if m != nil {
		return m.MediaFile
	}
	return nil
}

type isVideoAdInfo_Format interface {
	isVideoAdInfo_Format()
}

type VideoAdInfo_InStream struct {
	InStream *VideoTrueViewInStreamAdInfo `protobuf:"bytes,2,opt,name=in_stream,json=inStream,proto3,oneof"`
}

type VideoAdInfo_Bumper struct {
	Bumper *VideoBumperInStreamAdInfo `protobuf:"bytes,3,opt,name=bumper,proto3,oneof"`
}

type VideoAdInfo_OutStream struct {
	OutStream *VideoOutstreamAdInfo `protobuf:"bytes,4,opt,name=out_stream,json=outStream,proto3,oneof"`
}

type VideoAdInfo_NonSkippable struct {
	NonSkippable *VideoNonSkippableInStreamAdInfo `protobuf:"bytes,5,opt,name=non_skippable,json=nonSkippable,proto3,oneof"`
}

func (*VideoAdInfo_InStream) isVideoAdInfo_Format() {}

func (*VideoAdInfo_Bumper) isVideoAdInfo_Format() {}

func (*VideoAdInfo_OutStream) isVideoAdInfo_Format() {}

func (*VideoAdInfo_NonSkippable) isVideoAdInfo_Format() {}

func (m *VideoAdInfo) GetFormat() isVideoAdInfo_Format {
	if m != nil {
		return m.Format
	}
	return nil
}

func (m *VideoAdInfo) GetInStream() *VideoTrueViewInStreamAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_InStream); ok {
		return x.InStream
	}
	return nil
}

func (m *VideoAdInfo) GetBumper() *VideoBumperInStreamAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_Bumper); ok {
		return x.Bumper
	}
	return nil
}

func (m *VideoAdInfo) GetOutStream() *VideoOutstreamAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_OutStream); ok {
		return x.OutStream
	}
	return nil
}

func (m *VideoAdInfo) GetNonSkippable() *VideoNonSkippableInStreamAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_NonSkippable); ok {
		return x.NonSkippable
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*VideoAdInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _VideoAdInfo_OneofMarshaler, _VideoAdInfo_OneofUnmarshaler, _VideoAdInfo_OneofSizer, []interface{}{
		(*VideoAdInfo_InStream)(nil),
		(*VideoAdInfo_Bumper)(nil),
		(*VideoAdInfo_OutStream)(nil),
		(*VideoAdInfo_NonSkippable)(nil),
	}
}

func _VideoAdInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*VideoAdInfo)
	// format
	switch x := m.Format.(type) {
	case *VideoAdInfo_InStream:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InStream); err != nil {
			return err
		}
	case *VideoAdInfo_Bumper:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Bumper); err != nil {
			return err
		}
	case *VideoAdInfo_OutStream:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OutStream); err != nil {
			return err
		}
	case *VideoAdInfo_NonSkippable:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NonSkippable); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("VideoAdInfo.Format has unexpected type %T", x)
	}
	return nil
}

func _VideoAdInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*VideoAdInfo)
	switch tag {
	case 2: // format.in_stream
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VideoTrueViewInStreamAdInfo)
		err := b.DecodeMessage(msg)
		m.Format = &VideoAdInfo_InStream{msg}
		return true, err
	case 3: // format.bumper
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VideoBumperInStreamAdInfo)
		err := b.DecodeMessage(msg)
		m.Format = &VideoAdInfo_Bumper{msg}
		return true, err
	case 4: // format.out_stream
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VideoOutstreamAdInfo)
		err := b.DecodeMessage(msg)
		m.Format = &VideoAdInfo_OutStream{msg}
		return true, err
	case 5: // format.non_skippable
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VideoNonSkippableInStreamAdInfo)
		err := b.DecodeMessage(msg)
		m.Format = &VideoAdInfo_NonSkippable{msg}
		return true, err
	default:
		return false, nil
	}
}

func _VideoAdInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*VideoAdInfo)
	// format
	switch x := m.Format.(type) {
	case *VideoAdInfo_InStream:
		s := proto.Size(x.InStream)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *VideoAdInfo_Bumper:
		s := proto.Size(x.Bumper)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *VideoAdInfo_OutStream:
		s := proto.Size(x.OutStream)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *VideoAdInfo_NonSkippable:
		s := proto.Size(x.NonSkippable)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A responsive search ad.
//
// Responsive search ads let you create an ad that adapts to show more text, and
// more relevant messages, to your customers. Enter multiple headlines and
// descriptions when creating a responsive search ad, and over time, Google Ads
// will automatically test different combinations and learn which combinations
// perform best. By adapting your ad's content to more closely match potential
// customers' search terms, responsive search ads may improve your campaign's
// performance.
//
// More information at https://support.google.com/google-ads/answer/7684791
type ResponsiveSearchAdInfo struct {
	// List of text assets for headlines. When the ad serves the headlines will
	// be selected from this list.
	Headlines []*AdTextAsset `protobuf:"bytes,1,rep,name=headlines,proto3" json:"headlines,omitempty"`
	// List of text assets for descriptions. When the ad serves the descriptions
	// will be selected from this list.
	Descriptions []*AdTextAsset `protobuf:"bytes,2,rep,name=descriptions,proto3" json:"descriptions,omitempty"`
	// First part of text that may appear appended to the url displayed in the ad.
	Path1 *wrappers.StringValue `protobuf:"bytes,3,opt,name=path1,proto3" json:"path1,omitempty"`
	// Second part of text that may appear appended to the url displayed in the
	// ad. This field can only be set when path1 is also set.
	Path2                *wrappers.StringValue `protobuf:"bytes,4,opt,name=path2,proto3" json:"path2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ResponsiveSearchAdInfo) Reset()         { *m = ResponsiveSearchAdInfo{} }
func (m *ResponsiveSearchAdInfo) String() string { return proto.CompactTextString(m) }
func (*ResponsiveSearchAdInfo) ProtoMessage()    {}
func (*ResponsiveSearchAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{18}
}
func (m *ResponsiveSearchAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResponsiveSearchAdInfo.Unmarshal(m, b)
}
func (m *ResponsiveSearchAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResponsiveSearchAdInfo.Marshal(b, m, deterministic)
}
func (dst *ResponsiveSearchAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponsiveSearchAdInfo.Merge(dst, src)
}
func (m *ResponsiveSearchAdInfo) XXX_Size() int {
	return xxx_messageInfo_ResponsiveSearchAdInfo.Size(m)
}
func (m *ResponsiveSearchAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponsiveSearchAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ResponsiveSearchAdInfo proto.InternalMessageInfo

func (m *ResponsiveSearchAdInfo) GetHeadlines() []*AdTextAsset {
	if m != nil {
		return m.Headlines
	}
	return nil
}

func (m *ResponsiveSearchAdInfo) GetDescriptions() []*AdTextAsset {
	if m != nil {
		return m.Descriptions
	}
	return nil
}

func (m *ResponsiveSearchAdInfo) GetPath1() *wrappers.StringValue {
	if m != nil {
		return m.Path1
	}
	return nil
}

func (m *ResponsiveSearchAdInfo) GetPath2() *wrappers.StringValue {
	if m != nil {
		return m.Path2
	}
	return nil
}

// A legacy responsive display ad. Ads of this type are labeled 'Responsive ads'
// in the Google Ads UI.
type LegacyResponsiveDisplayAdInfo struct {
	// The short version of the ad's headline.
	ShortHeadline *wrappers.StringValue `protobuf:"bytes,1,opt,name=short_headline,json=shortHeadline,proto3" json:"short_headline,omitempty"`
	// The long version of the ad's headline.
	LongHeadline *wrappers.StringValue `protobuf:"bytes,2,opt,name=long_headline,json=longHeadline,proto3" json:"long_headline,omitempty"`
	// The description of the ad.
	Description *wrappers.StringValue `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The business name in the ad.
	BusinessName *wrappers.StringValue `protobuf:"bytes,4,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// Advertiser's consent to allow flexible color. When true, the ad may be
	// served with different color if necessary. When false, the ad will be served
	// with the specified colors or a neutral color.
	// The default value is true.
	// Must be true if main_color and accent_color are not set.
	AllowFlexibleColor *wrappers.BoolValue `protobuf:"bytes,5,opt,name=allow_flexible_color,json=allowFlexibleColor,proto3" json:"allow_flexible_color,omitempty"`
	// The accent color of the ad in hexadecimal, e.g. #ffffff for white.
	// If one of main_color and accent_color is set, the other is required as
	// well.
	AccentColor *wrappers.StringValue `protobuf:"bytes,6,opt,name=accent_color,json=accentColor,proto3" json:"accent_color,omitempty"`
	// The main color of the ad in hexadecimal, e.g. #ffffff for white.
	// If one of main_color and accent_color is set, the other is required as
	// well.
	MainColor *wrappers.StringValue `protobuf:"bytes,7,opt,name=main_color,json=mainColor,proto3" json:"main_color,omitempty"`
	// The call-to-action text for the ad.
	CallToActionText *wrappers.StringValue `protobuf:"bytes,8,opt,name=call_to_action_text,json=callToActionText,proto3" json:"call_to_action_text,omitempty"`
	// The MediaFile resource name of the logo image used in the ad.
	LogoImage *wrappers.StringValue `protobuf:"bytes,9,opt,name=logo_image,json=logoImage,proto3" json:"logo_image,omitempty"`
	// The MediaFile resource name of the square logo image used in the ad.
	SquareLogoImage *wrappers.StringValue `protobuf:"bytes,10,opt,name=square_logo_image,json=squareLogoImage,proto3" json:"square_logo_image,omitempty"`
	// The MediaFile resource name of the marketing image used in the ad.
	MarketingImage *wrappers.StringValue `protobuf:"bytes,11,opt,name=marketing_image,json=marketingImage,proto3" json:"marketing_image,omitempty"`
	// The MediaFile resource name of the square marketing image used in the ad.
	SquareMarketingImage *wrappers.StringValue `protobuf:"bytes,12,opt,name=square_marketing_image,json=squareMarketingImage,proto3" json:"square_marketing_image,omitempty"`
	// Specifies which format the ad will be served in. Default is ALL_FORMATS.
	FormatSetting enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting `protobuf:"varint,13,opt,name=format_setting,json=formatSetting,proto3,enum=google.ads.googleads.v1.enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting" json:"format_setting,omitempty"`
	// Prefix before price. E.g. 'as low as'.
	PricePrefix *wrappers.StringValue `protobuf:"bytes,14,opt,name=price_prefix,json=pricePrefix,proto3" json:"price_prefix,omitempty"`
	// Promotion text used for dyanmic formats of responsive ads. For example
	// 'Free two-day shipping'.
	PromoText            *wrappers.StringValue `protobuf:"bytes,15,opt,name=promo_text,json=promoText,proto3" json:"promo_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LegacyResponsiveDisplayAdInfo) Reset()         { *m = LegacyResponsiveDisplayAdInfo{} }
func (m *LegacyResponsiveDisplayAdInfo) String() string { return proto.CompactTextString(m) }
func (*LegacyResponsiveDisplayAdInfo) ProtoMessage()    {}
func (*LegacyResponsiveDisplayAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_2271eaf47f4b0cda, []int{19}
}
func (m *LegacyResponsiveDisplayAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LegacyResponsiveDisplayAdInfo.Unmarshal(m, b)
}
func (m *LegacyResponsiveDisplayAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LegacyResponsiveDisplayAdInfo.Marshal(b, m, deterministic)
}
func (dst *LegacyResponsiveDisplayAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LegacyResponsiveDisplayAdInfo.Merge(dst, src)
}
func (m *LegacyResponsiveDisplayAdInfo) XXX_Size() int {
	return xxx_messageInfo_LegacyResponsiveDisplayAdInfo.Size(m)
}
func (m *LegacyResponsiveDisplayAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LegacyResponsiveDisplayAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LegacyResponsiveDisplayAdInfo proto.InternalMessageInfo

func (m *LegacyResponsiveDisplayAdInfo) GetShortHeadline() *wrappers.StringValue {
	if m != nil {
		return m.ShortHeadline
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetLongHeadline() *wrappers.StringValue {
	if m != nil {
		return m.LongHeadline
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetAllowFlexibleColor() *wrappers.BoolValue {
	if m != nil {
		return m.AllowFlexibleColor
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetAccentColor() *wrappers.StringValue {
	if m != nil {
		return m.AccentColor
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetMainColor() *wrappers.StringValue {
	if m != nil {
		return m.MainColor
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetCallToActionText() *wrappers.StringValue {
	if m != nil {
		return m.CallToActionText
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetLogoImage() *wrappers.StringValue {
	if m != nil {
		return m.LogoImage
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetSquareLogoImage() *wrappers.StringValue {
	if m != nil {
		return m.SquareLogoImage
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetMarketingImage() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImage
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetSquareMarketingImage() *wrappers.StringValue {
	if m != nil {
		return m.SquareMarketingImage
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetFormatSetting() enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting {
	if m != nil {
		return m.FormatSetting
	}
	return enums.DisplayAdFormatSettingEnum_UNSPECIFIED
}

func (m *LegacyResponsiveDisplayAdInfo) GetPricePrefix() *wrappers.StringValue {
	if m != nil {
		return m.PricePrefix
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetPromoText() *wrappers.StringValue {
	if m != nil {
		return m.PromoText
	}
	return nil
}

func init() {
	proto.RegisterType((*TextAdInfo)(nil), "google.ads.googleads.v1.common.TextAdInfo")
	proto.RegisterType((*ExpandedTextAdInfo)(nil), "google.ads.googleads.v1.common.ExpandedTextAdInfo")
	proto.RegisterType((*CallOnlyAdInfo)(nil), "google.ads.googleads.v1.common.CallOnlyAdInfo")
	proto.RegisterType((*ExpandedDynamicSearchAdInfo)(nil), "google.ads.googleads.v1.common.ExpandedDynamicSearchAdInfo")
	proto.RegisterType((*HotelAdInfo)(nil), "google.ads.googleads.v1.common.HotelAdInfo")
	proto.RegisterType((*ShoppingSmartAdInfo)(nil), "google.ads.googleads.v1.common.ShoppingSmartAdInfo")
	proto.RegisterType((*ShoppingProductAdInfo)(nil), "google.ads.googleads.v1.common.ShoppingProductAdInfo")
	proto.RegisterType((*GmailAdInfo)(nil), "google.ads.googleads.v1.common.GmailAdInfo")
	proto.RegisterType((*GmailTeaser)(nil), "google.ads.googleads.v1.common.GmailTeaser")
	proto.RegisterType((*DisplayCallToAction)(nil), "google.ads.googleads.v1.common.DisplayCallToAction")
	proto.RegisterType((*ProductImage)(nil), "google.ads.googleads.v1.common.ProductImage")
	proto.RegisterType((*ProductVideo)(nil), "google.ads.googleads.v1.common.ProductVideo")
	proto.RegisterType((*ImageAdInfo)(nil), "google.ads.googleads.v1.common.ImageAdInfo")
	proto.RegisterType((*VideoBumperInStreamAdInfo)(nil), "google.ads.googleads.v1.common.VideoBumperInStreamAdInfo")
	proto.RegisterType((*VideoNonSkippableInStreamAdInfo)(nil), "google.ads.googleads.v1.common.VideoNonSkippableInStreamAdInfo")
	proto.RegisterType((*VideoTrueViewInStreamAdInfo)(nil), "google.ads.googleads.v1.common.VideoTrueViewInStreamAdInfo")
	proto.RegisterType((*VideoOutstreamAdInfo)(nil), "google.ads.googleads.v1.common.VideoOutstreamAdInfo")
	proto.RegisterType((*VideoAdInfo)(nil), "google.ads.googleads.v1.common.VideoAdInfo")
	proto.RegisterType((*ResponsiveSearchAdInfo)(nil), "google.ads.googleads.v1.common.ResponsiveSearchAdInfo")
	proto.RegisterType((*LegacyResponsiveDisplayAdInfo)(nil), "google.ads.googleads.v1.common.LegacyResponsiveDisplayAdInfo")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/common/ad_type_infos.proto", fileDescriptor_ad_type_infos_2271eaf47f4b0cda)
}

var fileDescriptor_ad_type_infos_2271eaf47f4b0cda = []byte{
	// 1857 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0x4d, 0x6f, 0x1b, 0xc7,
	0x19, 0x36, 0xf5, 0x49, 0xbd, 0xa4, 0xe4, 0x78, 0x65, 0x3b, 0x8c, 0x94, 0xa4, 0xce, 0x1e, 0x0a,
	0x03, 0x6d, 0xa8, 0x92, 0x36, 0x8a, 0x46, 0xae, 0xe3, 0x52, 0xf4, 0x07, 0x89, 0xc8, 0xb6, 0x42,
	0x32, 0x2a, 0x10, 0xa8, 0x58, 0x8c, 0x76, 0x87, 0xe4, 0xc0, 0xbb, 0x33, 0xdb, 0x99, 0x5d, 0x49,
	0xbc, 0xf6, 0xd0, 0x5e, 0x7b, 0x2e, 0x7a, 0xea, 0xb1, 0xc7, 0x02, 0xfd, 0x05, 0xed, 0x29, 0x40,
	0xfb, 0x0b, 0xfa, 0x0b, 0xda, 0x9f, 0xd0, 0x4b, 0x31, 0x1f, 0x4b, 0x2d, 0x49, 0x4b, 0x1c, 0xda,
	0x05, 0x72, 0xe2, 0x7e, 0xbc, 0xcf, 0xb3, 0xef, 0xf7, 0xbc, 0x33, 0x84, 0xfa, 0x80, 0xb1, 0x41,
	0x88, 0xf7, 0x50, 0x20, 0xf6, 0xf4, 0xa5, 0xbc, 0x3a, 0xab, 0xed, 0xf9, 0x2c, 0x8a, 0x18, 0xdd,
	0x43, 0x81, 0x97, 0x8c, 0x62, 0xec, 0x11, 0xda, 0x67, 0xa2, 0x1a, 0x73, 0x96, 0x30, 0xe7, 0x53,
	0x2d, 0x58, 0x45, 0x81, 0xa8, 0x8e, 0x31, 0xd5, 0xb3, 0x5a, 0x55, 0x63, 0x76, 0x3e, 0x9f, 0xcf,
	0x89, 0x84, 0xc0, 0x89, 0xa6, 0xdb, 0x69, 0x5e, 0x25, 0x8e, 0x69, 0x1a, 0x89, 0x3d, 0x1f, 0x85,
	0xa1, 0xe7, 0x33, 0x7a, 0x86, 0xb9, 0x20, 0x8c, 0x7a, 0x1c, 0xc7, 0x8c, 0x27, 0x84, 0x0e, 0x3c,
	0x91, 0xa0, 0x04, 0x1b, 0x92, 0xc7, 0xd7, 0x93, 0x04, 0x44, 0xc4, 0x21, 0x1a, 0x79, 0x28, 0xf0,
	0xfa, 0x8c, 0x47, 0x28, 0xf1, 0x04, 0x4e, 0x24, 0x89, 0x81, 0x7f, 0x7e, 0x3d, 0x3c, 0x22, 0x11,
	0x56, 0x7e, 0x30, 0xe2, 0xc6, 0x03, 0x7b, 0xea, 0xee, 0x34, 0xed, 0xef, 0x9d, 0x73, 0x14, 0xc7,
	0x98, 0x1b, 0x0f, 0xed, 0x7c, 0x9c, 0xd1, 0xc5, 0x64, 0x0f, 0x51, 0xca, 0x12, 0x94, 0x10, 0x46,
	0xcd, 0x5b, 0xf7, 0xbb, 0x02, 0x40, 0x0f, 0x5f, 0x24, 0x8d, 0xa0, 0x4d, 0xfb, 0xcc, 0xf9, 0x19,
	0x14, 0x87, 0x18, 0x05, 0x21, 0xa1, 0xb8, 0x52, 0xb8, 0x57, 0xb8, 0x5f, 0xaa, 0x7f, 0x6c, 0xdc,
	0x5a, 0xcd, 0xf8, 0xab, 0xdd, 0x84, 0x13, 0x3a, 0x38, 0x46, 0x61, 0x8a, 0x3b, 0x63, 0x69, 0xe7,
	0x17, 0x50, 0x0e, 0xb0, 0xf0, 0x39, 0x89, 0x25, 0x7d, 0xad, 0xb2, 0x64, 0x81, 0x9e, 0x40, 0x4c,
	0x31, 0xd4, 0x2b, 0xcb, 0x0b, 0x32, 0xd4, 0xdd, 0x7f, 0x2c, 0x83, 0xf3, 0xec, 0x22, 0x46, 0x34,
	0xc0, 0x41, 0xce, 0xa8, 0x26, 0x6c, 0x65, 0x6a, 0x7a, 0x31, 0xe2, 0x49, 0xcd, 0xca, 0xb4, 0xcd,
	0x0c, 0x73, 0x24, 0x21, 0x33, 0x24, 0x75, 0x2b, 0x0b, 0x27, 0x48, 0xea, 0x33, 0x24, 0x0f, 0x2a,
	0x6b, 0x8b, 0x92, 0x3c, 0x70, 0xbe, 0x84, 0x52, 0xce, 0x6a, 0x2b, 0x37, 0xe5, 0x01, 0x33, 0x7e,
	0x5e, 0x5f, 0xd4, 0xcf, 0x4e, 0x1d, 0x56, 0x63, 0x94, 0x0c, 0x6b, 0x95, 0x15, 0x0b, 0xa8, 0x16,
	0xcd, 0x30, 0xf5, 0xca, 0xaa, 0x2d, 0xa6, 0xee, 0xfe, 0x75, 0x0d, 0xb6, 0x9a, 0x28, 0x0c, 0x5f,
	0xd3, 0x70, 0x64, 0x62, 0xf9, 0x04, 0xca, 0x3e, 0x4b, 0x69, 0xc2, 0x47, 0x9e, 0xcf, 0x02, 0xbb,
	0x24, 0x2d, 0x19, 0x44, 0x93, 0x05, 0x58, 0x12, 0xc4, 0x43, 0x46, 0xb1, 0x47, 0xd3, 0xe8, 0x14,
	0x73, 0xab, 0x28, 0x96, 0x14, 0xe2, 0x95, 0x02, 0x38, 0x0d, 0xd8, 0x3c, 0x4d, 0x05, 0xa1, 0x58,
	0x08, 0x8f, 0xa2, 0x08, 0xdb, 0xe5, 0x69, 0x06, 0x79, 0x85, 0xa2, 0xd9, 0x5a, 0x59, 0x79, 0xef,
	0x5a, 0x59, 0x5d, 0x38, 0x86, 0x8f, 0xa1, 0xac, 0xba, 0x59, 0xc2, 0x91, 0xff, 0x06, 0x07, 0x26,
	0x11, 0x77, 0x66, 0x18, 0x0e, 0x18, 0x0b, 0x33, 0x37, 0xa2, 0x30, 0xec, 0x69, 0x71, 0xa7, 0x03,
	0x1f, 0x06, 0x44, 0xa0, 0xd3, 0x10, 0x7b, 0x53, 0x4d, 0xd1, 0xe4, 0xd3, 0x75, 0x4c, 0x77, 0x0c,
	0x54, 0xc6, 0xb6, 0x39, 0x06, 0x3a, 0x1e, 0x7c, 0x92, 0x0f, 0x8d, 0x77, 0x86, 0x39, 0xe9, 0x13,
	0x5f, 0xf5, 0x2b, 0x2f, 0xe5, 0x61, 0xa5, 0x68, 0x61, 0xe5, 0x4e, 0x2e, 0x56, 0xc7, 0x39, 0x82,
	0x6f, 0x78, 0xe8, 0xb4, 0xe1, 0x56, 0xae, 0x79, 0x23, 0x5f, 0xd5, 0xcf, 0x86, 0x05, 0xe9, 0x07,
	0x97, 0xb0, 0x86, 0x42, 0x39, 0x7f, 0x28, 0xc0, 0xce, 0xd5, 0x0b, 0x41, 0x05, 0xee, 0x15, 0xee,
	0x6f, 0xd5, 0x4f, 0xaa, 0x57, 0xad, 0x4e, 0xaa, 0x95, 0x57, 0x27, 0xed, 0xef, 0x64, 0x1c, 0x5d,
	0x49, 0xf1, 0x8c, 0xa6, 0xd1, 0xb5, 0x02, 0x9d, 0x8a, 0x7f, 0xc5, 0x1b, 0xf7, 0x57, 0xb0, 0x9b,
	0xb5, 0xc1, 0xa7, 0x23, 0x8a, 0x22, 0xe2, 0x77, 0x31, 0xe2, 0xfe, 0xd0, 0xd4, 0xd0, 0x54, 0x03,
	0x29, 0x2c, 0xd8, 0x40, 0xdc, 0x4d, 0x28, 0xb5, 0x58, 0x82, 0x43, 0x4d, 0xe7, 0xde, 0x81, 0xed,
	0xee, 0x90, 0xc5, 0xb1, 0xfc, 0x7c, 0x84, 0xb8, 0xe9, 0xba, 0xee, 0x87, 0x70, 0x27, 0x7b, 0x7c,
	0xc4, 0x59, 0x90, 0xfa, 0xd9, 0x8b, 0xbf, 0xad, 0x42, 0xe9, 0x45, 0x84, 0x48, 0x38, 0x6e, 0xcf,
	0x6b, 0x09, 0x46, 0x02, 0x73, 0xa3, 0xc9, 0x8f, 0xaa, 0xd7, 0xaf, 0xe9, 0x55, 0x05, 0xee, 0x29,
	0x48, 0xc7, 0x40, 0x65, 0x59, 0xcb, 0x2e, 0x89, 0xb9, 0x47, 0x22, 0x34, 0xc0, 0x76, 0x65, 0xad,
	0x11, 0x6d, 0x09, 0x70, 0x9e, 0xc1, 0xcd, 0x08, 0xf1, 0x37, 0x58, 0x05, 0x51, 0x73, 0xd8, 0x14,
	0xf6, 0xd6, 0x18, 0xa4, 0x69, 0x8e, 0xa1, 0x32, 0x45, 0xe3, 0x8d, 0x17, 0x54, 0x9b, 0x32, 0xbf,
	0x3b, 0xc9, 0xd7, 0xca, 0x96, 0xd7, 0x13, 0xd8, 0x9d, 0xe6, 0xcd, 0xc7, 0xd0, 0xa6, 0xfe, 0x3f,
	0x9a, 0xa4, 0x7e, 0x9a, 0x5b, 0x12, 0x7e, 0x5b, 0x80, 0x1f, 0xce, 0xd0, 0x9b, 0x31, 0x45, 0x77,
	0x09, 0x96, 0x95, 0x8b, 0xee, 0x13, 0x0f, 0xe6, 0xc5, 0xe8, 0xa9, 0x46, 0xcb, 0x04, 0xee, 0x31,
	0x5d, 0x33, 0x9d, 0xcf, 0xa6, 0x14, 0x98, 0x15, 0x71, 0xba, 0xb0, 0x15, 0xeb, 0x64, 0xd1, 0x5a,
	0x88, 0xca, 0xfa, 0xbd, 0xe5, 0xfb, 0xa5, 0xfa, 0x8f, 0xe7, 0x7d, 0xcf, 0xa4, 0x98, 0x22, 0xee,
	0x6c, 0xc6, 0xb9, 0x3b, 0x91, 0x27, 0x3d, 0x23, 0x01, 0x66, 0xa2, 0x52, 0x5c, 0x88, 0xf4, 0x58,
	0x82, 0xc6, 0xa4, 0xea, 0x4e, 0xb8, 0xbf, 0x5b, 0x32, 0x59, 0xac, 0x13, 0xf1, 0x3d, 0x26, 0xa7,
	0xa9, 0x72, 0x5c, 0x5a, 0x74, 0x3d, 0xff, 0x3f, 0x2c, 0x48, 0x8f, 0x00, 0x42, 0x36, 0x60, 0x26,
	0xef, 0x6d, 0xf2, 0x74, 0x43, 0xca, 0x2b, 0xff, 0xba, 0xff, 0x2c, 0xc0, 0xf6, 0xdb, 0x62, 0xf9,
	0x13, 0x58, 0x49, 0xf0, 0x45, 0x62, 0xe5, 0x0d, 0x25, 0x29, 0xd5, 0x90, 0xbf, 0x9e, 0xcf, 0x42,
	0x66, 0xb7, 0x32, 0x6f, 0x48, 0xf9, 0xa6, 0x14, 0x77, 0x5a, 0x70, 0x2b, 0xe5, 0x72, 0x21, 0x0a,
	0x43, 0xac, 0x14, 0xf0, 0x48, 0x60, 0xe5, 0x8a, 0x9b, 0x29, 0x0f, 0x9b, 0x63, 0x54, 0x3b, 0x70,
	0xff, 0x5b, 0x80, 0x72, 0x3e, 0x9f, 0xa4, 0x87, 0x27, 0xb2, 0xd2, 0xca, 0xa4, 0x72, 0x3e, 0x09,
	0xdf, 0x3b, 0xc8, 0x43, 0xb8, 0x7b, 0x45, 0x41, 0x2e, 0xbf, 0x7b, 0x41, 0x6e, 0x07, 0xb3, 0x0f,
	0xdd, 0xaf, 0xc7, 0xc6, 0xab, 0x4c, 0xcf, 0x1b, 0xaf, 0xaa, 0x67, 0x21, 0xe3, 0x15, 0x85, 0xfb,
	0x9b, 0x35, 0x28, 0x29, 0x37, 0x98, 0x8e, 0xff, 0x73, 0x28, 0xc5, 0xe4, 0x02, 0x87, 0xde, 0x39,
	0x09, 0x92, 0xa1, 0xc9, 0xb7, 0xdd, 0x19, 0xc2, 0x36, 0x4d, 0x7e, 0xfa, 0x50, 0xf3, 0x81, 0x92,
	0xff, 0xa5, 0x14, 0x77, 0xbe, 0x84, 0xb2, 0x46, 0x0f, 0x31, 0x19, 0x0c, 0x13, 0xd3, 0xfb, 0xae,
	0x85, 0xeb, 0xcf, 0xb5, 0x94, 0xbc, 0xf3, 0x05, 0x6c, 0xe8, 0x0e, 0x27, 0x47, 0x0a, 0x9b, 0xf9,
	0xbb, 0xa8, 0xc4, 0xe5, 0x00, 0xf1, 0x15, 0x6c, 0xc7, 0x1c, 0x9f, 0x11, 0x7c, 0xee, 0xe5, 0x0d,
	0x58, 0x9f, 0xaf, 0xc1, 0x2d, 0x83, 0x3b, 0xba, 0xb4, 0xe3, 0x25, 0xdc, 0x9e, 0x24, 0x33, 0xf6,
	0x14, 0xe7, 0xb3, 0x39, 0x79, 0x36, 0x63, 0x56, 0x0b, 0xb2, 0x6f, 0x78, 0x97, 0xe6, 0xd9, 0x0c,
	0x37, 0x37, 0x0d, 0xac, 0x9d, 0x59, 0xf9, 0x35, 0x6c, 0x8c, 0x37, 0x99, 0x66, 0x92, 0x79, 0x38,
	0x67, 0x92, 0x79, 0x49, 0x22, 0xdc, 0x1b, 0xc5, 0x7a, 0x6a, 0xc9, 0x6e, 0x3a, 0xc5, 0xc8, 0x5c,
	0xc9, 0x5e, 0xa0, 0x5a, 0x53, 0xc9, 0xa6, 0x17, 0x48, 0x49, 0xe7, 0x31, 0x40, 0x84, 0x03, 0x82,
	0xbc, 0x3e, 0x09, 0xad, 0x0a, 0xae, 0x75, 0xa3, 0xb3, 0xa1, 0x10, 0xcf, 0x49, 0x88, 0x9d, 0x1a,
	0xac, 0x04, 0x28, 0x41, 0xa6, 0xd0, 0x66, 0x9d, 0x79, 0x30, 0x4a, 0xb0, 0xc8, 0x70, 0x4a, 0xd4,
	0xe9, 0x41, 0x05, 0x05, 0x1e, 0x09, 0x64, 0x6d, 0xf9, 0x2c, 0x1e, 0x19, 0x37, 0xf6, 0x39, 0x8b,
	0x4c, 0x91, 0x5d, 0x17, 0x93, 0xd6, 0x8d, 0xce, 0x36, 0x0a, 0xda, 0x41, 0x8f, 0x35, 0x59, 0x3c,
	0x52, 0xbe, 0x7c, 0xce, 0x59, 0x74, 0xb0, 0x0e, 0xab, 0x8a, 0xc7, 0xdd, 0x85, 0x8f, 0x54, 0x35,
	0x1c, 0xa4, 0x51, 0x8c, 0x79, 0x9b, 0x76, 0x13, 0x8e, 0x51, 0x64, 0x66, 0xa2, 0xcf, 0xe0, 0x07,
	0xea, 0xe5, 0x2b, 0x46, 0xbb, 0x6f, 0x48, 0x1c, 0xcb, 0xe9, 0x78, 0x4a, 0xe4, 0x2f, 0x05, 0xd8,
	0x55, 0x32, 0x3d, 0x9e, 0xe2, 0x63, 0x19, 0xaf, 0x89, 0xf7, 0xce, 0x21, 0x6c, 0xeb, 0x8e, 0xe0,
	0x9d, 0xa6, 0x49, 0xc2, 0xa8, 0x17, 0xa2, 0x53, 0x1c, 0x5a, 0x55, 0xeb, 0x2d, 0x0d, 0x3c, 0x50,
	0xb8, 0x43, 0x09, 0x93, 0xe3, 0x90, 0x61, 0x1b, 0xaf, 0x6a, 0x36, 0x3d, 0x6b, 0x4b, 0x83, 0xb2,
	0xb1, 0xc5, 0xfd, 0x7d, 0x01, 0x6e, 0x2b, 0xa5, 0x5f, 0xa7, 0x89, 0xc8, 0x6b, 0xfb, 0xbd, 0x2d,
	0x97, 0xee, 0xdf, 0x97, 0xa1, 0xa4, 0x54, 0x32, 0x9a, 0x3c, 0x5a, 0x34, 0xd1, 0xf2, 0x69, 0xf6,
	0x2d, 0x6c, 0x10, 0xea, 0x69, 0xcb, 0x8c, 0x2a, 0x8f, 0xe6, 0x75, 0xe2, 0x6b, 0x82, 0xd8, 0xba,
	0xd1, 0x29, 0x12, 0xf3, 0xc4, 0xe9, 0xc2, 0xda, 0xa9, 0xca, 0x15, 0x93, 0x7d, 0x5f, 0x58, 0x11,
	0xbf, 0x2d, 0xbd, 0x5a, 0x37, 0x3a, 0x86, 0xca, 0xf9, 0x06, 0x80, 0xa5, 0x49, 0xa6, 0xb1, 0xee,
	0xbc, 0x0f, 0xad, 0x88, 0xa7, 0x22, 0x28, 0xcb, 0x8d, 0xa5, 0x89, 0xd1, 0xb5, 0x0f, 0x9b, 0x94,
	0x51, 0x4f, 0x64, 0xb9, 0x6b, 0x9a, 0xf2, 0x13, 0x2b, 0xe6, 0xab, 0x93, 0xbe, 0x75, 0xa3, 0x53,
	0xa6, 0xb9, 0xb7, 0x07, 0x45, 0x58, 0xd3, 0x67, 0x66, 0xee, 0x1f, 0x97, 0xe0, 0x6e, 0x07, 0x8b,
	0x98, 0x51, 0x41, 0xce, 0xf0, 0xc4, 0xfe, 0xa6, 0x0d, 0x1b, 0x59, 0xb6, 0x88, 0x4a, 0x41, 0x8d,
	0x7a, 0x73, 0xf7, 0x14, 0x0d, 0x7d, 0x60, 0x24, 0x04, 0x4e, 0x3a, 0x97, 0x68, 0xe7, 0xf5, 0xc4,
	0x3e, 0x5b, 0x54, 0x96, 0x16, 0x67, 0x9b, 0x20, 0xb8, 0x3c, 0x3a, 0x59, 0x7e, 0x87, 0xa3, 0x93,
	0x15, 0xfb, 0xa3, 0x93, 0x7f, 0x15, 0xe1, 0x93, 0x43, 0x3c, 0x40, 0xfe, 0xe8, 0xd2, 0x49, 0x66,
	0x04, 0xb8, 0x3c, 0x15, 0x13, 0x43, 0xc6, 0x13, 0x6f, 0xa1, 0x3a, 0xdc, 0x54, 0x98, 0xf1, 0xb6,
	0xa4, 0x01, 0x9b, 0x21, 0xa3, 0x83, 0xc5, 0x9a, 0x44, 0x59, 0x42, 0x5a, 0x57, 0xd4, 0xf3, 0xf2,
	0x7b, 0x8f, 0xbf, 0x2b, 0x0b, 0x8f, 0xbf, 0x87, 0x70, 0x1b, 0x85, 0x21, 0x3b, 0xf7, 0xfa, 0x21,
	0xbe, 0x20, 0xea, 0x4c, 0x43, 0x4d, 0xa0, 0xab, 0x73, 0x4f, 0x32, 0x1c, 0x85, 0x7b, 0x6e, 0x60,
	0x7a, 0x10, 0x7d, 0x02, 0x65, 0xe4, 0xfb, 0x98, 0x66, 0x73, 0xac, 0xcd, 0x88, 0x51, 0xd2, 0x08,
	0x4d, 0x20, 0x3b, 0x12, 0x22, 0xd4, 0xc0, 0xd7, 0xad, 0x3a, 0x12, 0x22, 0x54, 0x83, 0xbf, 0x82,
	0xed, 0xc9, 0x01, 0xd1, 0x53, 0x43, 0x78, 0xd1, 0xea, 0x94, 0x23, 0x37, 0x07, 0xf6, 0xcc, 0x40,
	0x9e, 0xdb, 0x17, 0x6c, 0x2c, 0xb4, 0x2f, 0x90, 0x03, 0x89, 0xf8, 0x75, 0x8a, 0x38, 0xf6, 0x72,
	0x1c, 0x60, 0x33, 0x90, 0x68, 0xd8, 0xe1, 0x98, 0xe9, 0x2d, 0x7b, 0xf3, 0xd2, 0x3b, 0xec, 0xcd,
	0x3b, 0x70, 0xd7, 0x28, 0x34, 0xcd, 0x56, 0xb6, 0x60, 0xbb, 0xad, 0xb1, 0x2f, 0x27, 0x39, 0xcf,
	0x61, 0x6b, 0xf2, 0x10, 0xbf, 0xb2, 0xa9, 0x06, 0xa6, 0xa3, 0x39, 0x03, 0xd3, 0xb8, 0x16, 0x9f,
	0x2b, 0x74, 0x57, 0x83, 0xd5, 0xf8, 0xf4, 0xf6, 0x57, 0x9d, 0xcd, 0x7e, 0xfe, 0x56, 0x9d, 0x63,
	0x72, 0xe2, 0x63, 0x2f, 0xe6, 0xb8, 0x4f, 0x2e, 0x2a, 0x5b, 0x56, 0xe7, 0x98, 0x12, 0x71, 0xa4,
	0x00, 0x32, 0xb6, 0x31, 0x67, 0x11, 0xd3, 0xf9, 0x71, 0xd3, 0x26, 0xb6, 0x4a, 0x5e, 0x26, 0xc6,
	0xc1, 0x7f, 0x0a, 0xe0, 0xfa, 0x2c, 0x9a, 0xd3, 0x07, 0x0f, 0x3e, 0x68, 0x04, 0x72, 0xfc, 0x93,
	0xfd, 0x46, 0x1c, 0x49, 0xca, 0xa3, 0xc2, 0xb7, 0x4f, 0x0d, 0x66, 0xc0, 0x42, 0x44, 0x07, 0x55,
	0xc6, 0x07, 0x7b, 0x03, 0x4c, 0xd5, 0x07, 0xb3, 0xbf, 0x3b, 0x62, 0x22, 0xae, 0xfa, 0xc3, 0xe6,
	0x91, 0xfe, 0xf9, 0xd3, 0xd2, 0xf2, 0x8b, 0x46, 0xe3, 0xcf, 0x4b, 0x9f, 0xbe, 0xd0, 0x64, 0x8d,
	0x40, 0x54, 0xf5, 0xa5, 0xbc, 0x3a, 0xae, 0x55, 0x9b, 0x4a, 0xec, 0xbb, 0x4c, 0xe0, 0xa4, 0x11,
	0x88, 0x93, 0xb1, 0xc0, 0xc9, 0x71, 0xed, 0x44, 0x0b, 0xfc, 0x7b, 0xc9, 0xd5, 0x4f, 0xf7, 0xf7,
	0x1b, 0x81, 0xd8, 0xdf, 0x1f, 0x8b, 0xec, 0xef, 0x1f, 0xd7, 0xf6, 0xf7, 0xb5, 0xd0, 0xe9, 0x9a,
	0xd2, 0xee, 0xc1, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x0e, 0xee, 0x7f, 0x61, 0xa1, 0x1a, 0x00,
	0x00,
}
