// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/vision/v1/product_search_service.proto

package vision

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Enumerates the possible states that the batch request can be in.
type BatchOperationMetadata_State int32

const (
	// Invalid.
	BatchOperationMetadata_STATE_UNSPECIFIED BatchOperationMetadata_State = 0
	// Request is actively being processed.
	BatchOperationMetadata_PROCESSING BatchOperationMetadata_State = 1
	// The request is done and at least one item has been successfully
	// processed.
	BatchOperationMetadata_SUCCESSFUL BatchOperationMetadata_State = 2
	// The request is done and no item has been successfully processed.
	BatchOperationMetadata_FAILED BatchOperationMetadata_State = 3
	// The request is done after the longrunning.Operations.CancelOperation has
	// been called by the user.  Any records that were processed before the
	// cancel command are output as specified in the request.
	BatchOperationMetadata_CANCELLED BatchOperationMetadata_State = 4
)

var BatchOperationMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PROCESSING",
	2: "SUCCESSFUL",
	3: "FAILED",
	4: "CANCELLED",
}

var BatchOperationMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PROCESSING":        1,
	"SUCCESSFUL":        2,
	"FAILED":            3,
	"CANCELLED":         4,
}

func (x BatchOperationMetadata_State) String() string {
	return proto.EnumName(BatchOperationMetadata_State_name, int32(x))
}

func (BatchOperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{28, 0}
}

// A Product contains ReferenceImages.
type Product struct {
	// The resource name of the product.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
	//
	// This field is ignored when creating a product.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The user-provided name for this Product. Must not be empty. Must be at most
	// 4096 characters long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// User-provided metadata to be stored with this product. Must be at most 4096
	// characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Immutable. The category for the product identified by the reference image. This should
	// be either "homegoods-v2", "apparel-v2", "toys-v2", "packagedgoods-v1", or
	// "general-v1" The legacy categories "homegoods", "apparel", and "toys" are
	// still supported, but these should not be used for new products.
	ProductCategory string `protobuf:"bytes,4,opt,name=product_category,json=productCategory,proto3" json:"product_category,omitempty"`
	// Key-value pairs that can be attached to a product. At query time,
	// constraints can be specified based on the product_labels.
	//
	// Note that integer values can be provided as strings, e.g. "1199". Only
	// strings with integer values can match a range-based restriction which is
	// to be supported soon.
	//
	// Multiple values can be assigned to the same key. One product may have up to
	// 500 product_labels.
	//
	// Notice that the total number of distinct product_labels over all products
	// in one ProductSet cannot exceed 1M, otherwise the product search pipeline
	// will refuse to work for that ProductSet.
	ProductLabels        []*Product_KeyValue `protobuf:"bytes,5,rep,name=product_labels,json=productLabels,proto3" json:"product_labels,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Product) Reset()         { *m = Product{} }
func (m *Product) String() string { return proto.CompactTextString(m) }
func (*Product) ProtoMessage()    {}
func (*Product) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{0}
}

func (m *Product) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Product.Unmarshal(m, b)
}
func (m *Product) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Product.Marshal(b, m, deterministic)
}
func (m *Product) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Product.Merge(m, src)
}
func (m *Product) XXX_Size() int {
	return xxx_messageInfo_Product.Size(m)
}
func (m *Product) XXX_DiscardUnknown() {
	xxx_messageInfo_Product.DiscardUnknown(m)
}

var xxx_messageInfo_Product proto.InternalMessageInfo

func (m *Product) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Product) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Product) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Product) GetProductCategory() string {
	if m != nil {
		return m.ProductCategory
	}
	return ""
}

func (m *Product) GetProductLabels() []*Product_KeyValue {
	if m != nil {
		return m.ProductLabels
	}
	return nil
}

// A product label represented as a key-value pair.
type Product_KeyValue struct {
	// The key of the label attached to the product. Cannot be empty and cannot
	// exceed 128 bytes.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value of the label attached to the product. Cannot be empty and
	// cannot exceed 128 bytes.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Product_KeyValue) Reset()         { *m = Product_KeyValue{} }
func (m *Product_KeyValue) String() string { return proto.CompactTextString(m) }
func (*Product_KeyValue) ProtoMessage()    {}
func (*Product_KeyValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{0, 0}
}

func (m *Product_KeyValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Product_KeyValue.Unmarshal(m, b)
}
func (m *Product_KeyValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Product_KeyValue.Marshal(b, m, deterministic)
}
func (m *Product_KeyValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Product_KeyValue.Merge(m, src)
}
func (m *Product_KeyValue) XXX_Size() int {
	return xxx_messageInfo_Product_KeyValue.Size(m)
}
func (m *Product_KeyValue) XXX_DiscardUnknown() {
	xxx_messageInfo_Product_KeyValue.DiscardUnknown(m)
}

var xxx_messageInfo_Product_KeyValue proto.InternalMessageInfo

func (m *Product_KeyValue) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Product_KeyValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A ProductSet contains Products. A ProductSet can contain a maximum of 1
// million reference images. If the limit is exceeded, periodic indexing will
// fail.
type ProductSet struct {
	// The resource name of the ProductSet.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
	//
	// This field is ignored when creating a ProductSet.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The user-provided name for this ProductSet. Must not be empty. Must be at
	// most 4096 characters long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The time at which this ProductSet was last indexed. Query
	// results will reflect all updates before this time. If this ProductSet has
	// never been indexed, this timestamp is the default value
	// "1970-01-01T00:00:00Z".
	//
	// This field is ignored when creating a ProductSet.
	IndexTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=index_time,json=indexTime,proto3" json:"index_time,omitempty"`
	// Output only. If there was an error with indexing the product set, the field
	// is populated.
	//
	// This field is ignored when creating a ProductSet.
	IndexError           *status.Status `protobuf:"bytes,4,opt,name=index_error,json=indexError,proto3" json:"index_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ProductSet) Reset()         { *m = ProductSet{} }
func (m *ProductSet) String() string { return proto.CompactTextString(m) }
func (*ProductSet) ProtoMessage()    {}
func (*ProductSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{1}
}

func (m *ProductSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductSet.Unmarshal(m, b)
}
func (m *ProductSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductSet.Marshal(b, m, deterministic)
}
func (m *ProductSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductSet.Merge(m, src)
}
func (m *ProductSet) XXX_Size() int {
	return xxx_messageInfo_ProductSet.Size(m)
}
func (m *ProductSet) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductSet.DiscardUnknown(m)
}

var xxx_messageInfo_ProductSet proto.InternalMessageInfo

func (m *ProductSet) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ProductSet) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ProductSet) GetIndexTime() *timestamp.Timestamp {
	if m != nil {
		return m.IndexTime
	}
	return nil
}

func (m *ProductSet) GetIndexError() *status.Status {
	if m != nil {
		return m.IndexError
	}
	return nil
}

// A `ReferenceImage` represents a product image and its associated metadata,
// such as bounding boxes.
type ReferenceImage struct {
	// The resource name of the reference image.
	//
	// Format is:
	//
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
	//
	// This field is ignored when creating a reference image.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The Google Cloud Storage URI of the reference image.
	//
	// The URI must start with `gs://`.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. Bounding polygons around the areas of interest in the reference image.
	// If this field is empty, the system will try to detect regions of
	// interest. At most 10 bounding polygons will be used.
	//
	// The provided shape is converted into a non-rotated rectangle. Once
	// converted, the small edge of the rectangle must be greater than or equal
	// to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
	// is not).
	BoundingPolys        []*BoundingPoly `protobuf:"bytes,3,rep,name=bounding_polys,json=boundingPolys,proto3" json:"bounding_polys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ReferenceImage) Reset()         { *m = ReferenceImage{} }
func (m *ReferenceImage) String() string { return proto.CompactTextString(m) }
func (*ReferenceImage) ProtoMessage()    {}
func (*ReferenceImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{2}
}

func (m *ReferenceImage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReferenceImage.Unmarshal(m, b)
}
func (m *ReferenceImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReferenceImage.Marshal(b, m, deterministic)
}
func (m *ReferenceImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReferenceImage.Merge(m, src)
}
func (m *ReferenceImage) XXX_Size() int {
	return xxx_messageInfo_ReferenceImage.Size(m)
}
func (m *ReferenceImage) XXX_DiscardUnknown() {
	xxx_messageInfo_ReferenceImage.DiscardUnknown(m)
}

var xxx_messageInfo_ReferenceImage proto.InternalMessageInfo

func (m *ReferenceImage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ReferenceImage) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *ReferenceImage) GetBoundingPolys() []*BoundingPoly {
	if m != nil {
		return m.BoundingPolys
	}
	return nil
}

// Request message for the `CreateProduct` method.
type CreateProductRequest struct {
	// Required. The project in which the Product should be created.
	//
	// Format is
	// `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The product to create.
	Product *Product `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
	// A user-supplied resource id for this Product. If set, the server will
	// attempt to use this value as the resource id. If it is already in use, an
	// error is returned with code ALREADY_EXISTS. Must be at most 128 characters
	// long. It cannot contain the character `/`.
	ProductId            string   `protobuf:"bytes,3,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateProductRequest) Reset()         { *m = CreateProductRequest{} }
func (m *CreateProductRequest) String() string { return proto.CompactTextString(m) }
func (*CreateProductRequest) ProtoMessage()    {}
func (*CreateProductRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{3}
}

func (m *CreateProductRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateProductRequest.Unmarshal(m, b)
}
func (m *CreateProductRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateProductRequest.Marshal(b, m, deterministic)
}
func (m *CreateProductRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateProductRequest.Merge(m, src)
}
func (m *CreateProductRequest) XXX_Size() int {
	return xxx_messageInfo_CreateProductRequest.Size(m)
}
func (m *CreateProductRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateProductRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateProductRequest proto.InternalMessageInfo

func (m *CreateProductRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateProductRequest) GetProduct() *Product {
	if m != nil {
		return m.Product
	}
	return nil
}

func (m *CreateProductRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

// Request message for the `ListProducts` method.
type ListProductsRequest struct {
	// Required. The project OR ProductSet from which Products should be listed.
	//
	// Format:
	// `projects/PROJECT_ID/locations/LOC_ID`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductsRequest) Reset()         { *m = ListProductsRequest{} }
func (m *ListProductsRequest) String() string { return proto.CompactTextString(m) }
func (*ListProductsRequest) ProtoMessage()    {}
func (*ListProductsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{4}
}

func (m *ListProductsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductsRequest.Unmarshal(m, b)
}
func (m *ListProductsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductsRequest.Marshal(b, m, deterministic)
}
func (m *ListProductsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductsRequest.Merge(m, src)
}
func (m *ListProductsRequest) XXX_Size() int {
	return xxx_messageInfo_ListProductsRequest.Size(m)
}
func (m *ListProductsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductsRequest proto.InternalMessageInfo

func (m *ListProductsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListProductsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListProductsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for the `ListProducts` method.
type ListProductsResponse struct {
	// List of products.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductsResponse) Reset()         { *m = ListProductsResponse{} }
func (m *ListProductsResponse) String() string { return proto.CompactTextString(m) }
func (*ListProductsResponse) ProtoMessage()    {}
func (*ListProductsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{5}
}

func (m *ListProductsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductsResponse.Unmarshal(m, b)
}
func (m *ListProductsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductsResponse.Marshal(b, m, deterministic)
}
func (m *ListProductsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductsResponse.Merge(m, src)
}
func (m *ListProductsResponse) XXX_Size() int {
	return xxx_messageInfo_ListProductsResponse.Size(m)
}
func (m *ListProductsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductsResponse proto.InternalMessageInfo

func (m *ListProductsResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

func (m *ListProductsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for the `GetProduct` method.
type GetProductRequest struct {
	// Required. Resource name of the Product to get.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetProductRequest) Reset()         { *m = GetProductRequest{} }
func (m *GetProductRequest) String() string { return proto.CompactTextString(m) }
func (*GetProductRequest) ProtoMessage()    {}
func (*GetProductRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{6}
}

func (m *GetProductRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetProductRequest.Unmarshal(m, b)
}
func (m *GetProductRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetProductRequest.Marshal(b, m, deterministic)
}
func (m *GetProductRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProductRequest.Merge(m, src)
}
func (m *GetProductRequest) XXX_Size() int {
	return xxx_messageInfo_GetProductRequest.Size(m)
}
func (m *GetProductRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProductRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProductRequest proto.InternalMessageInfo

func (m *GetProductRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `UpdateProduct` method.
type UpdateProductRequest struct {
	// Required. The Product resource which replaces the one on the server.
	// product.name is immutable.
	Product *Product `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// The [FieldMask][google.protobuf.FieldMask] that specifies which fields
	// to update.
	// If update_mask isn't specified, all mutable fields are to be updated.
	// Valid mask paths include `product_labels`, `display_name`, and
	// `description`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateProductRequest) Reset()         { *m = UpdateProductRequest{} }
func (m *UpdateProductRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateProductRequest) ProtoMessage()    {}
func (*UpdateProductRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{7}
}

func (m *UpdateProductRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateProductRequest.Unmarshal(m, b)
}
func (m *UpdateProductRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateProductRequest.Marshal(b, m, deterministic)
}
func (m *UpdateProductRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateProductRequest.Merge(m, src)
}
func (m *UpdateProductRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateProductRequest.Size(m)
}
func (m *UpdateProductRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateProductRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateProductRequest proto.InternalMessageInfo

func (m *UpdateProductRequest) GetProduct() *Product {
	if m != nil {
		return m.Product
	}
	return nil
}

func (m *UpdateProductRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for the `DeleteProduct` method.
type DeleteProductRequest struct {
	// Required. Resource name of product to delete.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteProductRequest) Reset()         { *m = DeleteProductRequest{} }
func (m *DeleteProductRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteProductRequest) ProtoMessage()    {}
func (*DeleteProductRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{8}
}

func (m *DeleteProductRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteProductRequest.Unmarshal(m, b)
}
func (m *DeleteProductRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteProductRequest.Marshal(b, m, deterministic)
}
func (m *DeleteProductRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteProductRequest.Merge(m, src)
}
func (m *DeleteProductRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteProductRequest.Size(m)
}
func (m *DeleteProductRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteProductRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteProductRequest proto.InternalMessageInfo

func (m *DeleteProductRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `CreateProductSet` method.
type CreateProductSetRequest struct {
	// Required. The project in which the ProductSet should be created.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ProductSet to create.
	ProductSet *ProductSet `protobuf:"bytes,2,opt,name=product_set,json=productSet,proto3" json:"product_set,omitempty"`
	// A user-supplied resource id for this ProductSet. If set, the server will
	// attempt to use this value as the resource id. If it is already in use, an
	// error is returned with code ALREADY_EXISTS. Must be at most 128 characters
	// long. It cannot contain the character `/`.
	ProductSetId         string   `protobuf:"bytes,3,opt,name=product_set_id,json=productSetId,proto3" json:"product_set_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateProductSetRequest) Reset()         { *m = CreateProductSetRequest{} }
func (m *CreateProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateProductSetRequest) ProtoMessage()    {}
func (*CreateProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{9}
}

func (m *CreateProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateProductSetRequest.Unmarshal(m, b)
}
func (m *CreateProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateProductSetRequest.Marshal(b, m, deterministic)
}
func (m *CreateProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateProductSetRequest.Merge(m, src)
}
func (m *CreateProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateProductSetRequest.Size(m)
}
func (m *CreateProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateProductSetRequest proto.InternalMessageInfo

func (m *CreateProductSetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateProductSetRequest) GetProductSet() *ProductSet {
	if m != nil {
		return m.ProductSet
	}
	return nil
}

func (m *CreateProductSetRequest) GetProductSetId() string {
	if m != nil {
		return m.ProductSetId
	}
	return ""
}

// Request message for the `ListProductSets` method.
type ListProductSetsRequest struct {
	// Required. The project from which ProductSets should be listed.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductSetsRequest) Reset()         { *m = ListProductSetsRequest{} }
func (m *ListProductSetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListProductSetsRequest) ProtoMessage()    {}
func (*ListProductSetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{10}
}

func (m *ListProductSetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductSetsRequest.Unmarshal(m, b)
}
func (m *ListProductSetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductSetsRequest.Marshal(b, m, deterministic)
}
func (m *ListProductSetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductSetsRequest.Merge(m, src)
}
func (m *ListProductSetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListProductSetsRequest.Size(m)
}
func (m *ListProductSetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductSetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductSetsRequest proto.InternalMessageInfo

func (m *ListProductSetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListProductSetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListProductSetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for the `ListProductSets` method.
type ListProductSetsResponse struct {
	// List of ProductSets.
	ProductSets []*ProductSet `protobuf:"bytes,1,rep,name=product_sets,json=productSets,proto3" json:"product_sets,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductSetsResponse) Reset()         { *m = ListProductSetsResponse{} }
func (m *ListProductSetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListProductSetsResponse) ProtoMessage()    {}
func (*ListProductSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{11}
}

func (m *ListProductSetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductSetsResponse.Unmarshal(m, b)
}
func (m *ListProductSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductSetsResponse.Marshal(b, m, deterministic)
}
func (m *ListProductSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductSetsResponse.Merge(m, src)
}
func (m *ListProductSetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListProductSetsResponse.Size(m)
}
func (m *ListProductSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductSetsResponse proto.InternalMessageInfo

func (m *ListProductSetsResponse) GetProductSets() []*ProductSet {
	if m != nil {
		return m.ProductSets
	}
	return nil
}

func (m *ListProductSetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for the `GetProductSet` method.
type GetProductSetRequest struct {
	// Required. Resource name of the ProductSet to get.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOG_ID/productSets/PRODUCT_SET_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetProductSetRequest) Reset()         { *m = GetProductSetRequest{} }
func (m *GetProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*GetProductSetRequest) ProtoMessage()    {}
func (*GetProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{12}
}

func (m *GetProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetProductSetRequest.Unmarshal(m, b)
}
func (m *GetProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetProductSetRequest.Marshal(b, m, deterministic)
}
func (m *GetProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProductSetRequest.Merge(m, src)
}
func (m *GetProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_GetProductSetRequest.Size(m)
}
func (m *GetProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProductSetRequest proto.InternalMessageInfo

func (m *GetProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `UpdateProductSet` method.
type UpdateProductSetRequest struct {
	// Required. The ProductSet resource which replaces the one on the server.
	ProductSet *ProductSet `protobuf:"bytes,1,opt,name=product_set,json=productSet,proto3" json:"product_set,omitempty"`
	// The [FieldMask][google.protobuf.FieldMask] that specifies which fields to
	// update.
	// If update_mask isn't specified, all mutable fields are to be updated.
	// Valid mask path is `display_name`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateProductSetRequest) Reset()         { *m = UpdateProductSetRequest{} }
func (m *UpdateProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateProductSetRequest) ProtoMessage()    {}
func (*UpdateProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{13}
}

func (m *UpdateProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateProductSetRequest.Unmarshal(m, b)
}
func (m *UpdateProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateProductSetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateProductSetRequest.Merge(m, src)
}
func (m *UpdateProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateProductSetRequest.Size(m)
}
func (m *UpdateProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateProductSetRequest proto.InternalMessageInfo

func (m *UpdateProductSetRequest) GetProductSet() *ProductSet {
	if m != nil {
		return m.ProductSet
	}
	return nil
}

func (m *UpdateProductSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for the `DeleteProductSet` method.
type DeleteProductSetRequest struct {
	// Required. Resource name of the ProductSet to delete.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteProductSetRequest) Reset()         { *m = DeleteProductSetRequest{} }
func (m *DeleteProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteProductSetRequest) ProtoMessage()    {}
func (*DeleteProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{14}
}

func (m *DeleteProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteProductSetRequest.Unmarshal(m, b)
}
func (m *DeleteProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteProductSetRequest.Marshal(b, m, deterministic)
}
func (m *DeleteProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteProductSetRequest.Merge(m, src)
}
func (m *DeleteProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteProductSetRequest.Size(m)
}
func (m *DeleteProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteProductSetRequest proto.InternalMessageInfo

func (m *DeleteProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `CreateReferenceImage` method.
type CreateReferenceImageRequest struct {
	// Required. Resource name of the product in which to create the reference image.
	//
	// Format is
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The reference image to create.
	// If an image ID is specified, it is ignored.
	ReferenceImage *ReferenceImage `protobuf:"bytes,2,opt,name=reference_image,json=referenceImage,proto3" json:"reference_image,omitempty"`
	// A user-supplied resource id for the ReferenceImage to be added. If set,
	// the server will attempt to use this value as the resource id. If it is
	// already in use, an error is returned with code ALREADY_EXISTS. Must be at
	// most 128 characters long. It cannot contain the character `/`.
	ReferenceImageId     string   `protobuf:"bytes,3,opt,name=reference_image_id,json=referenceImageId,proto3" json:"reference_image_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateReferenceImageRequest) Reset()         { *m = CreateReferenceImageRequest{} }
func (m *CreateReferenceImageRequest) String() string { return proto.CompactTextString(m) }
func (*CreateReferenceImageRequest) ProtoMessage()    {}
func (*CreateReferenceImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{15}
}

func (m *CreateReferenceImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateReferenceImageRequest.Unmarshal(m, b)
}
func (m *CreateReferenceImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateReferenceImageRequest.Marshal(b, m, deterministic)
}
func (m *CreateReferenceImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateReferenceImageRequest.Merge(m, src)
}
func (m *CreateReferenceImageRequest) XXX_Size() int {
	return xxx_messageInfo_CreateReferenceImageRequest.Size(m)
}
func (m *CreateReferenceImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateReferenceImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateReferenceImageRequest proto.InternalMessageInfo

func (m *CreateReferenceImageRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateReferenceImageRequest) GetReferenceImage() *ReferenceImage {
	if m != nil {
		return m.ReferenceImage
	}
	return nil
}

func (m *CreateReferenceImageRequest) GetReferenceImageId() string {
	if m != nil {
		return m.ReferenceImageId
	}
	return ""
}

// Request message for the `ListReferenceImages` method.
type ListReferenceImagesRequest struct {
	// Required. Resource name of the product containing the reference images.
	//
	// Format is
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results to be returned. This is the value
	// of `nextPageToken` returned in a previous reference image list request.
	//
	// Defaults to the first page if not specified.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListReferenceImagesRequest) Reset()         { *m = ListReferenceImagesRequest{} }
func (m *ListReferenceImagesRequest) String() string { return proto.CompactTextString(m) }
func (*ListReferenceImagesRequest) ProtoMessage()    {}
func (*ListReferenceImagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{16}
}

func (m *ListReferenceImagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReferenceImagesRequest.Unmarshal(m, b)
}
func (m *ListReferenceImagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReferenceImagesRequest.Marshal(b, m, deterministic)
}
func (m *ListReferenceImagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReferenceImagesRequest.Merge(m, src)
}
func (m *ListReferenceImagesRequest) XXX_Size() int {
	return xxx_messageInfo_ListReferenceImagesRequest.Size(m)
}
func (m *ListReferenceImagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReferenceImagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListReferenceImagesRequest proto.InternalMessageInfo

func (m *ListReferenceImagesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListReferenceImagesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListReferenceImagesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for the `ListReferenceImages` method.
type ListReferenceImagesResponse struct {
	// The list of reference images.
	ReferenceImages []*ReferenceImage `protobuf:"bytes,1,rep,name=reference_images,json=referenceImages,proto3" json:"reference_images,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	NextPageToken        string   `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListReferenceImagesResponse) Reset()         { *m = ListReferenceImagesResponse{} }
func (m *ListReferenceImagesResponse) String() string { return proto.CompactTextString(m) }
func (*ListReferenceImagesResponse) ProtoMessage()    {}
func (*ListReferenceImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{17}
}

func (m *ListReferenceImagesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListReferenceImagesResponse.Unmarshal(m, b)
}
func (m *ListReferenceImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListReferenceImagesResponse.Marshal(b, m, deterministic)
}
func (m *ListReferenceImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReferenceImagesResponse.Merge(m, src)
}
func (m *ListReferenceImagesResponse) XXX_Size() int {
	return xxx_messageInfo_ListReferenceImagesResponse.Size(m)
}
func (m *ListReferenceImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReferenceImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListReferenceImagesResponse proto.InternalMessageInfo

func (m *ListReferenceImagesResponse) GetReferenceImages() []*ReferenceImage {
	if m != nil {
		return m.ReferenceImages
	}
	return nil
}

func (m *ListReferenceImagesResponse) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListReferenceImagesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for the `GetReferenceImage` method.
type GetReferenceImageRequest struct {
	// Required. The resource name of the ReferenceImage to get.
	//
	// Format is:
	//
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetReferenceImageRequest) Reset()         { *m = GetReferenceImageRequest{} }
func (m *GetReferenceImageRequest) String() string { return proto.CompactTextString(m) }
func (*GetReferenceImageRequest) ProtoMessage()    {}
func (*GetReferenceImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{18}
}

func (m *GetReferenceImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetReferenceImageRequest.Unmarshal(m, b)
}
func (m *GetReferenceImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetReferenceImageRequest.Marshal(b, m, deterministic)
}
func (m *GetReferenceImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReferenceImageRequest.Merge(m, src)
}
func (m *GetReferenceImageRequest) XXX_Size() int {
	return xxx_messageInfo_GetReferenceImageRequest.Size(m)
}
func (m *GetReferenceImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReferenceImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReferenceImageRequest proto.InternalMessageInfo

func (m *GetReferenceImageRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `DeleteReferenceImage` method.
type DeleteReferenceImageRequest struct {
	// Required. The resource name of the reference image to delete.
	//
	// Format is:
	//
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteReferenceImageRequest) Reset()         { *m = DeleteReferenceImageRequest{} }
func (m *DeleteReferenceImageRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteReferenceImageRequest) ProtoMessage()    {}
func (*DeleteReferenceImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{19}
}

func (m *DeleteReferenceImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteReferenceImageRequest.Unmarshal(m, b)
}
func (m *DeleteReferenceImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteReferenceImageRequest.Marshal(b, m, deterministic)
}
func (m *DeleteReferenceImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteReferenceImageRequest.Merge(m, src)
}
func (m *DeleteReferenceImageRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteReferenceImageRequest.Size(m)
}
func (m *DeleteReferenceImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteReferenceImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteReferenceImageRequest proto.InternalMessageInfo

func (m *DeleteReferenceImageRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the `AddProductToProductSet` method.
type AddProductToProductSetRequest struct {
	// Required. The resource name for the ProductSet to modify.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The resource name for the Product to be added to this ProductSet.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Product              string   `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddProductToProductSetRequest) Reset()         { *m = AddProductToProductSetRequest{} }
func (m *AddProductToProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*AddProductToProductSetRequest) ProtoMessage()    {}
func (*AddProductToProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{20}
}

func (m *AddProductToProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddProductToProductSetRequest.Unmarshal(m, b)
}
func (m *AddProductToProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddProductToProductSetRequest.Marshal(b, m, deterministic)
}
func (m *AddProductToProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddProductToProductSetRequest.Merge(m, src)
}
func (m *AddProductToProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_AddProductToProductSetRequest.Size(m)
}
func (m *AddProductToProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddProductToProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddProductToProductSetRequest proto.InternalMessageInfo

func (m *AddProductToProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AddProductToProductSetRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

// Request message for the `RemoveProductFromProductSet` method.
type RemoveProductFromProductSetRequest struct {
	// Required. The resource name for the ProductSet to modify.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The resource name for the Product to be removed from this ProductSet.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
	Product              string   `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveProductFromProductSetRequest) Reset()         { *m = RemoveProductFromProductSetRequest{} }
func (m *RemoveProductFromProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveProductFromProductSetRequest) ProtoMessage()    {}
func (*RemoveProductFromProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{21}
}

func (m *RemoveProductFromProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveProductFromProductSetRequest.Unmarshal(m, b)
}
func (m *RemoveProductFromProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveProductFromProductSetRequest.Marshal(b, m, deterministic)
}
func (m *RemoveProductFromProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveProductFromProductSetRequest.Merge(m, src)
}
func (m *RemoveProductFromProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveProductFromProductSetRequest.Size(m)
}
func (m *RemoveProductFromProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveProductFromProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveProductFromProductSetRequest proto.InternalMessageInfo

func (m *RemoveProductFromProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RemoveProductFromProductSetRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

// Request message for the `ListProductsInProductSet` method.
type ListProductsInProductSetRequest struct {
	// Required. The ProductSet resource for which to retrieve Products.
	//
	// Format is:
	// `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum number of items to return. Default 10, maximum 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductsInProductSetRequest) Reset()         { *m = ListProductsInProductSetRequest{} }
func (m *ListProductsInProductSetRequest) String() string { return proto.CompactTextString(m) }
func (*ListProductsInProductSetRequest) ProtoMessage()    {}
func (*ListProductsInProductSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{22}
}

func (m *ListProductsInProductSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductsInProductSetRequest.Unmarshal(m, b)
}
func (m *ListProductsInProductSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductsInProductSetRequest.Marshal(b, m, deterministic)
}
func (m *ListProductsInProductSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductsInProductSetRequest.Merge(m, src)
}
func (m *ListProductsInProductSetRequest) XXX_Size() int {
	return xxx_messageInfo_ListProductsInProductSetRequest.Size(m)
}
func (m *ListProductsInProductSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductsInProductSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductsInProductSetRequest proto.InternalMessageInfo

func (m *ListProductsInProductSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListProductsInProductSetRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListProductsInProductSetRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for the `ListProductsInProductSet` method.
type ListProductsInProductSetResponse struct {
	// The list of Products.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProductsInProductSetResponse) Reset()         { *m = ListProductsInProductSetResponse{} }
func (m *ListProductsInProductSetResponse) String() string { return proto.CompactTextString(m) }
func (*ListProductsInProductSetResponse) ProtoMessage()    {}
func (*ListProductsInProductSetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{23}
}

func (m *ListProductsInProductSetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListProductsInProductSetResponse.Unmarshal(m, b)
}
func (m *ListProductsInProductSetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListProductsInProductSetResponse.Marshal(b, m, deterministic)
}
func (m *ListProductsInProductSetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProductsInProductSetResponse.Merge(m, src)
}
func (m *ListProductsInProductSetResponse) XXX_Size() int {
	return xxx_messageInfo_ListProductsInProductSetResponse.Size(m)
}
func (m *ListProductsInProductSetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProductsInProductSetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListProductsInProductSetResponse proto.InternalMessageInfo

func (m *ListProductsInProductSetResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

func (m *ListProductsInProductSetResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The Google Cloud Storage location for a csv file which preserves a list of
// ImportProductSetRequests in each line.
type ImportProductSetsGcsSource struct {
	// The Google Cloud Storage URI of the input csv file.
	//
	// The URI must start with `gs://`.
	//
	// The format of the input csv file should be one image per line.
	// In each line, there are 8 columns.
	//
	// 1.  image-uri
	// 2.  image-id
	// 3.  product-set-id
	// 4.  product-id
	// 5.  product-category
	// 6.  product-display-name
	// 7.  labels
	// 8.  bounding-poly
	//
	// The `image-uri`, `product-set-id`, `product-id`, and `product-category`
	// columns are required. All other columns are optional.
	//
	// If the `ProductSet` or `Product` specified by the `product-set-id` and
	// `product-id` values does not exist, then the system will create a new
	// `ProductSet` or `Product` for the image. In this case, the
	// `product-display-name` column refers to
	// [display_name][google.cloud.vision.v1.Product.display_name], the
	// `product-category` column refers to
	// [product_category][google.cloud.vision.v1.Product.product_category], and the
	// `labels` column refers to [product_labels][google.cloud.vision.v1.Product.product_labels].
	//
	// The `image-id` column is optional but must be unique if provided. If it is
	// empty, the system will automatically assign a unique id to the image.
	//
	// The `product-display-name` column is optional. If it is empty, the system
	// sets the [display_name][google.cloud.vision.v1.Product.display_name] field for the product to a
	// space (" "). You can update the `display_name` later by using the API.
	//
	// If a `Product` with the specified `product-id` already exists, then the
	// system ignores the `product-display-name`, `product-category`, and `labels`
	// columns.
	//
	// The `labels` column (optional) is a line containing a list of
	// comma-separated key-value pairs, in the following format:
	//
	//     "key_1=value_1,key_2=value_2,...,key_n=value_n"
	//
	// The `bounding-poly` column (optional) identifies one region of
	// interest from the image in the same manner as `CreateReferenceImage`. If
	// you do not specify the `bounding-poly` column, then the system will try to
	// detect regions of interest automatically.
	//
	// At most one `bounding-poly` column is allowed per line. If the image
	// contains multiple regions of interest, add a line to the CSV file that
	// includes the same product information, and the `bounding-poly` values for
	// each region of interest.
	//
	// The `bounding-poly` column must contain an even number of comma-separated
	// numbers, in the format "p1_x,p1_y,p2_x,p2_y,...,pn_x,pn_y". Use
	// non-negative integers for absolute bounding polygons, and float values
	// in [0, 1] for normalized bounding polygons.
	//
	// The system will resize the image if the image resolution is too
	// large to process (larger than 20MP).
	CsvFileUri           string   `protobuf:"bytes,1,opt,name=csv_file_uri,json=csvFileUri,proto3" json:"csv_file_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportProductSetsGcsSource) Reset()         { *m = ImportProductSetsGcsSource{} }
func (m *ImportProductSetsGcsSource) String() string { return proto.CompactTextString(m) }
func (*ImportProductSetsGcsSource) ProtoMessage()    {}
func (*ImportProductSetsGcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{24}
}

func (m *ImportProductSetsGcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportProductSetsGcsSource.Unmarshal(m, b)
}
func (m *ImportProductSetsGcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportProductSetsGcsSource.Marshal(b, m, deterministic)
}
func (m *ImportProductSetsGcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportProductSetsGcsSource.Merge(m, src)
}
func (m *ImportProductSetsGcsSource) XXX_Size() int {
	return xxx_messageInfo_ImportProductSetsGcsSource.Size(m)
}
func (m *ImportProductSetsGcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportProductSetsGcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_ImportProductSetsGcsSource proto.InternalMessageInfo

func (m *ImportProductSetsGcsSource) GetCsvFileUri() string {
	if m != nil {
		return m.CsvFileUri
	}
	return ""
}

// The input content for the `ImportProductSets` method.
type ImportProductSetsInputConfig struct {
	// The source of the input.
	//
	// Types that are valid to be assigned to Source:
	//	*ImportProductSetsInputConfig_GcsSource
	Source               isImportProductSetsInputConfig_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *ImportProductSetsInputConfig) Reset()         { *m = ImportProductSetsInputConfig{} }
func (m *ImportProductSetsInputConfig) String() string { return proto.CompactTextString(m) }
func (*ImportProductSetsInputConfig) ProtoMessage()    {}
func (*ImportProductSetsInputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{25}
}

func (m *ImportProductSetsInputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportProductSetsInputConfig.Unmarshal(m, b)
}
func (m *ImportProductSetsInputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportProductSetsInputConfig.Marshal(b, m, deterministic)
}
func (m *ImportProductSetsInputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportProductSetsInputConfig.Merge(m, src)
}
func (m *ImportProductSetsInputConfig) XXX_Size() int {
	return xxx_messageInfo_ImportProductSetsInputConfig.Size(m)
}
func (m *ImportProductSetsInputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportProductSetsInputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ImportProductSetsInputConfig proto.InternalMessageInfo

type isImportProductSetsInputConfig_Source interface {
	isImportProductSetsInputConfig_Source()
}

type ImportProductSetsInputConfig_GcsSource struct {
	GcsSource *ImportProductSetsGcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*ImportProductSetsInputConfig_GcsSource) isImportProductSetsInputConfig_Source() {}

func (m *ImportProductSetsInputConfig) GetSource() isImportProductSetsInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *ImportProductSetsInputConfig) GetGcsSource() *ImportProductSetsGcsSource {
	if x, ok := m.GetSource().(*ImportProductSetsInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImportProductSetsInputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImportProductSetsInputConfig_GcsSource)(nil),
	}
}

// Request message for the `ImportProductSets` method.
type ImportProductSetsRequest struct {
	// Required. The project in which the ProductSets should be imported.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The input content for the list of requests.
	InputConfig          *ImportProductSetsInputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ImportProductSetsRequest) Reset()         { *m = ImportProductSetsRequest{} }
func (m *ImportProductSetsRequest) String() string { return proto.CompactTextString(m) }
func (*ImportProductSetsRequest) ProtoMessage()    {}
func (*ImportProductSetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{26}
}

func (m *ImportProductSetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportProductSetsRequest.Unmarshal(m, b)
}
func (m *ImportProductSetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportProductSetsRequest.Marshal(b, m, deterministic)
}
func (m *ImportProductSetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportProductSetsRequest.Merge(m, src)
}
func (m *ImportProductSetsRequest) XXX_Size() int {
	return xxx_messageInfo_ImportProductSetsRequest.Size(m)
}
func (m *ImportProductSetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportProductSetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportProductSetsRequest proto.InternalMessageInfo

func (m *ImportProductSetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ImportProductSetsRequest) GetInputConfig() *ImportProductSetsInputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// Response message for the `ImportProductSets` method.
//
// This message is returned by the
// [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation] method in the returned
// [google.longrunning.Operation.response][google.longrunning.Operation.response] field.
type ImportProductSetsResponse struct {
	// The list of reference_images that are imported successfully.
	ReferenceImages []*ReferenceImage `protobuf:"bytes,1,rep,name=reference_images,json=referenceImages,proto3" json:"reference_images,omitempty"`
	// The rpc status for each ImportProductSet request, including both successes
	// and errors.
	//
	// The number of statuses here matches the number of lines in the csv file,
	// and statuses[i] stores the success or failure status of processing the i-th
	// line of the csv, starting from line 0.
	Statuses             []*status.Status `protobuf:"bytes,2,rep,name=statuses,proto3" json:"statuses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ImportProductSetsResponse) Reset()         { *m = ImportProductSetsResponse{} }
func (m *ImportProductSetsResponse) String() string { return proto.CompactTextString(m) }
func (*ImportProductSetsResponse) ProtoMessage()    {}
func (*ImportProductSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{27}
}

func (m *ImportProductSetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportProductSetsResponse.Unmarshal(m, b)
}
func (m *ImportProductSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportProductSetsResponse.Marshal(b, m, deterministic)
}
func (m *ImportProductSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportProductSetsResponse.Merge(m, src)
}
func (m *ImportProductSetsResponse) XXX_Size() int {
	return xxx_messageInfo_ImportProductSetsResponse.Size(m)
}
func (m *ImportProductSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportProductSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportProductSetsResponse proto.InternalMessageInfo

func (m *ImportProductSetsResponse) GetReferenceImages() []*ReferenceImage {
	if m != nil {
		return m.ReferenceImages
	}
	return nil
}

func (m *ImportProductSetsResponse) GetStatuses() []*status.Status {
	if m != nil {
		return m.Statuses
	}
	return nil
}

// Metadata for the batch operations such as the current state.
//
// This is included in the `metadata` field of the `Operation` returned by the
// `GetOperation` call of the `google::longrunning::Operations` service.
type BatchOperationMetadata struct {
	// The current state of the batch operation.
	State BatchOperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.vision.v1.BatchOperationMetadata_State" json:"state,omitempty"`
	// The time when the batch request was submitted to the server.
	SubmitTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// The time when the batch request is finished and
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] is set to true.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *BatchOperationMetadata) Reset()         { *m = BatchOperationMetadata{} }
func (m *BatchOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*BatchOperationMetadata) ProtoMessage()    {}
func (*BatchOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{28}
}

func (m *BatchOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchOperationMetadata.Unmarshal(m, b)
}
func (m *BatchOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchOperationMetadata.Marshal(b, m, deterministic)
}
func (m *BatchOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchOperationMetadata.Merge(m, src)
}
func (m *BatchOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_BatchOperationMetadata.Size(m)
}
func (m *BatchOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BatchOperationMetadata proto.InternalMessageInfo

func (m *BatchOperationMetadata) GetState() BatchOperationMetadata_State {
	if m != nil {
		return m.State
	}
	return BatchOperationMetadata_STATE_UNSPECIFIED
}

func (m *BatchOperationMetadata) GetSubmitTime() *timestamp.Timestamp {
	if m != nil {
		return m.SubmitTime
	}
	return nil
}

func (m *BatchOperationMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Config to control which ProductSet contains the Products to be deleted.
type ProductSetPurgeConfig struct {
	// The ProductSet that contains the Products to delete. If a Product is a
	// member of product_set_id in addition to other ProductSets, the Product will
	// still be deleted.
	ProductSetId         string   `protobuf:"bytes,1,opt,name=product_set_id,json=productSetId,proto3" json:"product_set_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProductSetPurgeConfig) Reset()         { *m = ProductSetPurgeConfig{} }
func (m *ProductSetPurgeConfig) String() string { return proto.CompactTextString(m) }
func (*ProductSetPurgeConfig) ProtoMessage()    {}
func (*ProductSetPurgeConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{29}
}

func (m *ProductSetPurgeConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductSetPurgeConfig.Unmarshal(m, b)
}
func (m *ProductSetPurgeConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductSetPurgeConfig.Marshal(b, m, deterministic)
}
func (m *ProductSetPurgeConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductSetPurgeConfig.Merge(m, src)
}
func (m *ProductSetPurgeConfig) XXX_Size() int {
	return xxx_messageInfo_ProductSetPurgeConfig.Size(m)
}
func (m *ProductSetPurgeConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductSetPurgeConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ProductSetPurgeConfig proto.InternalMessageInfo

func (m *ProductSetPurgeConfig) GetProductSetId() string {
	if m != nil {
		return m.ProductSetId
	}
	return ""
}

// Request message for the `PurgeProducts` method.
type PurgeProductsRequest struct {
	// The Products to delete.
	//
	// Types that are valid to be assigned to Target:
	//	*PurgeProductsRequest_ProductSetPurgeConfig
	//	*PurgeProductsRequest_DeleteOrphanProducts
	Target isPurgeProductsRequest_Target `protobuf_oneof:"target"`
	// Required. The project and location in which the Products should be deleted.
	//
	// Format is `projects/PROJECT_ID/locations/LOC_ID`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The default value is false. Override this value to true to actually perform
	// the purge.
	Force                bool     `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PurgeProductsRequest) Reset()         { *m = PurgeProductsRequest{} }
func (m *PurgeProductsRequest) String() string { return proto.CompactTextString(m) }
func (*PurgeProductsRequest) ProtoMessage()    {}
func (*PurgeProductsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7cf22baa8e45dc96, []int{30}
}

func (m *PurgeProductsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PurgeProductsRequest.Unmarshal(m, b)
}
func (m *PurgeProductsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PurgeProductsRequest.Marshal(b, m, deterministic)
}
func (m *PurgeProductsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeProductsRequest.Merge(m, src)
}
func (m *PurgeProductsRequest) XXX_Size() int {
	return xxx_messageInfo_PurgeProductsRequest.Size(m)
}
func (m *PurgeProductsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeProductsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeProductsRequest proto.InternalMessageInfo

type isPurgeProductsRequest_Target interface {
	isPurgeProductsRequest_Target()
}

type PurgeProductsRequest_ProductSetPurgeConfig struct {
	ProductSetPurgeConfig *ProductSetPurgeConfig `protobuf:"bytes,2,opt,name=product_set_purge_config,json=productSetPurgeConfig,proto3,oneof"`
}

type PurgeProductsRequest_DeleteOrphanProducts struct {
	DeleteOrphanProducts bool `protobuf:"varint,3,opt,name=delete_orphan_products,json=deleteOrphanProducts,proto3,oneof"`
}

func (*PurgeProductsRequest_ProductSetPurgeConfig) isPurgeProductsRequest_Target() {}

func (*PurgeProductsRequest_DeleteOrphanProducts) isPurgeProductsRequest_Target() {}

func (m *PurgeProductsRequest) GetTarget() isPurgeProductsRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *PurgeProductsRequest) GetProductSetPurgeConfig() *ProductSetPurgeConfig {
	if x, ok := m.GetTarget().(*PurgeProductsRequest_ProductSetPurgeConfig); ok {
		return x.ProductSetPurgeConfig
	}
	return nil
}

func (m *PurgeProductsRequest) GetDeleteOrphanProducts() bool {
	if x, ok := m.GetTarget().(*PurgeProductsRequest_DeleteOrphanProducts); ok {
		return x.DeleteOrphanProducts
	}
	return false
}

func (m *PurgeProductsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *PurgeProductsRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PurgeProductsRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PurgeProductsRequest_ProductSetPurgeConfig)(nil),
		(*PurgeProductsRequest_DeleteOrphanProducts)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.vision.v1.BatchOperationMetadata_State", BatchOperationMetadata_State_name, BatchOperationMetadata_State_value)
	proto.RegisterType((*Product)(nil), "google.cloud.vision.v1.Product")
	proto.RegisterType((*Product_KeyValue)(nil), "google.cloud.vision.v1.Product.KeyValue")
	proto.RegisterType((*ProductSet)(nil), "google.cloud.vision.v1.ProductSet")
	proto.RegisterType((*ReferenceImage)(nil), "google.cloud.vision.v1.ReferenceImage")
	proto.RegisterType((*CreateProductRequest)(nil), "google.cloud.vision.v1.CreateProductRequest")
	proto.RegisterType((*ListProductsRequest)(nil), "google.cloud.vision.v1.ListProductsRequest")
	proto.RegisterType((*ListProductsResponse)(nil), "google.cloud.vision.v1.ListProductsResponse")
	proto.RegisterType((*GetProductRequest)(nil), "google.cloud.vision.v1.GetProductRequest")
	proto.RegisterType((*UpdateProductRequest)(nil), "google.cloud.vision.v1.UpdateProductRequest")
	proto.RegisterType((*DeleteProductRequest)(nil), "google.cloud.vision.v1.DeleteProductRequest")
	proto.RegisterType((*CreateProductSetRequest)(nil), "google.cloud.vision.v1.CreateProductSetRequest")
	proto.RegisterType((*ListProductSetsRequest)(nil), "google.cloud.vision.v1.ListProductSetsRequest")
	proto.RegisterType((*ListProductSetsResponse)(nil), "google.cloud.vision.v1.ListProductSetsResponse")
	proto.RegisterType((*GetProductSetRequest)(nil), "google.cloud.vision.v1.GetProductSetRequest")
	proto.RegisterType((*UpdateProductSetRequest)(nil), "google.cloud.vision.v1.UpdateProductSetRequest")
	proto.RegisterType((*DeleteProductSetRequest)(nil), "google.cloud.vision.v1.DeleteProductSetRequest")
	proto.RegisterType((*CreateReferenceImageRequest)(nil), "google.cloud.vision.v1.CreateReferenceImageRequest")
	proto.RegisterType((*ListReferenceImagesRequest)(nil), "google.cloud.vision.v1.ListReferenceImagesRequest")
	proto.RegisterType((*ListReferenceImagesResponse)(nil), "google.cloud.vision.v1.ListReferenceImagesResponse")
	proto.RegisterType((*GetReferenceImageRequest)(nil), "google.cloud.vision.v1.GetReferenceImageRequest")
	proto.RegisterType((*DeleteReferenceImageRequest)(nil), "google.cloud.vision.v1.DeleteReferenceImageRequest")
	proto.RegisterType((*AddProductToProductSetRequest)(nil), "google.cloud.vision.v1.AddProductToProductSetRequest")
	proto.RegisterType((*RemoveProductFromProductSetRequest)(nil), "google.cloud.vision.v1.RemoveProductFromProductSetRequest")
	proto.RegisterType((*ListProductsInProductSetRequest)(nil), "google.cloud.vision.v1.ListProductsInProductSetRequest")
	proto.RegisterType((*ListProductsInProductSetResponse)(nil), "google.cloud.vision.v1.ListProductsInProductSetResponse")
	proto.RegisterType((*ImportProductSetsGcsSource)(nil), "google.cloud.vision.v1.ImportProductSetsGcsSource")
	proto.RegisterType((*ImportProductSetsInputConfig)(nil), "google.cloud.vision.v1.ImportProductSetsInputConfig")
	proto.RegisterType((*ImportProductSetsRequest)(nil), "google.cloud.vision.v1.ImportProductSetsRequest")
	proto.RegisterType((*ImportProductSetsResponse)(nil), "google.cloud.vision.v1.ImportProductSetsResponse")
	proto.RegisterType((*BatchOperationMetadata)(nil), "google.cloud.vision.v1.BatchOperationMetadata")
	proto.RegisterType((*ProductSetPurgeConfig)(nil), "google.cloud.vision.v1.ProductSetPurgeConfig")
	proto.RegisterType((*PurgeProductsRequest)(nil), "google.cloud.vision.v1.PurgeProductsRequest")
}

func init() {
	proto.RegisterFile("google/cloud/vision/v1/product_search_service.proto", fileDescriptor_7cf22baa8e45dc96)
}

var fileDescriptor_7cf22baa8e45dc96 = []byte{
	// 2358 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xcd, 0x6f, 0xdc, 0xc6,
	0x15, 0xf7, 0xac, 0x2c, 0x5b, 0x7a, 0x2b, 0xc9, 0xeb, 0x89, 0x3e, 0xd6, 0xab, 0x18, 0x96, 0x19,
	0xc7, 0xb0, 0x55, 0x65, 0x59, 0xaf, 0x93, 0xd8, 0x5d, 0xc5, 0x8a, 0x29, 0x59, 0x92, 0x95, 0xca,
	0xb2, 0xcc, 0x95, 0x13, 0xa4, 0x36, 0xba, 0xa0, 0xb8, 0xa3, 0x15, 0xe3, 0x5d, 0x92, 0x25, 0xb9,
	0x6b, 0x2b, 0x86, 0x0e, 0xfd, 0x00, 0x9a, 0x4b, 0x2f, 0x4d, 0x8b, 0x16, 0x30, 0x50, 0xf4, 0xe3,
	0xd0, 0x9e, 0xdb, 0x06, 0x68, 0x11, 0xf4, 0x1f, 0x30, 0x0a, 0x14, 0x6d, 0x80, 0x1e, 0x74, 0xf2,
	0xa1, 0x27, 0x03, 0xbd, 0x15, 0xe8, 0xc7, 0xa9, 0x18, 0xce, 0x70, 0x97, 0xe4, 0x92, 0x5a, 0xae,
	0xa5, 0x04, 0xb9, 0x91, 0x9c, 0xf7, 0x66, 0x7e, 0xef, 0xe3, 0x37, 0x33, 0xef, 0xed, 0xc2, 0xe5,
	0xaa, 0x61, 0x54, 0x6b, 0x44, 0x54, 0x6b, 0x46, 0xa3, 0x22, 0x36, 0x35, 0x5b, 0x33, 0x74, 0xb1,
	0x79, 0x49, 0x34, 0x2d, 0xa3, 0xd2, 0x50, 0x9d, 0xb2, 0x4d, 0x14, 0x4b, 0xdd, 0x2e, 0xdb, 0xc4,
	0x6a, 0x6a, 0x2a, 0xc9, 0x9b, 0x96, 0xe1, 0x18, 0x78, 0x9c, 0x29, 0xe5, 0x5d, 0xa5, 0x3c, 0x53,
	0xca, 0x37, 0x2f, 0xe5, 0x5e, 0xe6, 0x93, 0x29, 0xa6, 0x26, 0x2a, 0xba, 0x6e, 0x38, 0x8a, 0xa3,
	0x19, 0xba, 0xcd, 0xb4, 0x72, 0x13, 0xbe, 0x51, 0xb5, 0xa6, 0x11, 0xdd, 0xe1, 0x03, 0x67, 0x7c,
	0x03, 0x5b, 0x1a, 0xa9, 0x55, 0xca, 0x9b, 0x64, 0x5b, 0x69, 0x6a, 0x86, 0xc5, 0x05, 0x4e, 0xf9,
	0x04, 0x2c, 0x62, 0x1b, 0x0d, 0xcb, 0x83, 0x92, 0x7b, 0x35, 0x06, 0x7f, 0x95, 0x18, 0x75, 0xe2,
	0x58, 0x3b, 0x5c, 0xec, 0x15, 0x2e, 0x56, 0x33, 0xf4, 0xaa, 0xd5, 0xd0, 0x75, 0x4d, 0xaf, 0x8a,
	0x86, 0x49, 0xac, 0x00, 0xc0, 0x49, 0x2e, 0xe4, 0xbe, 0x6d, 0x36, 0xb6, 0x44, 0x52, 0x37, 0x1d,
	0x6f, 0x86, 0xa9, 0xf0, 0x20, 0x43, 0x5a, 0x57, 0xec, 0x07, 0x21, 0x33, 0x5a, 0x12, 0x8e, 0x56,
	0x27, 0xb6, 0xa3, 0xd4, 0xcd, 0x90, 0x03, 0x2c, 0x53, 0x15, 0x6d, 0x47, 0x71, 0x1a, 0x7c, 0x61,
	0xe1, 0xdf, 0x29, 0x38, 0xbe, 0xce, 0x1c, 0x8e, 0x31, 0x1c, 0xd5, 0x95, 0x3a, 0xc9, 0xa2, 0x29,
	0x74, 0x61, 0x50, 0x76, 0x9f, 0xf1, 0x59, 0x18, 0xaa, 0x68, 0xb6, 0x59, 0x53, 0x76, 0xca, 0xee,
	0x58, 0xca, 0x1d, 0x4b, 0xf3, 0x6f, 0x6b, 0x54, 0x64, 0x0a, 0xd2, 0x15, 0x62, 0xab, 0x96, 0x66,
	0x52, 0x8b, 0xb2, 0x7d, 0x5c, 0xa2, 0xfd, 0x09, 0xe7, 0x21, 0xe3, 0x05, 0x55, 0x55, 0x1c, 0x52,
	0x35, 0xac, 0x9d, 0xec, 0x51, 0x2a, 0x36, 0xdf, 0xf7, 0x4c, 0xea, 0x97, 0x4f, 0xf0, 0xc1, 0x05,
	0x3e, 0x86, 0x6f, 0xc3, 0x88, 0x27, 0x5f, 0x53, 0x36, 0x49, 0xcd, 0xce, 0xf6, 0x4f, 0xf5, 0x5d,
	0x48, 0x17, 0x2e, 0xe4, 0xa3, 0xa3, 0x9f, 0xe7, 0x16, 0xe4, 0xbf, 0x4e, 0x76, 0xde, 0x55, 0x6a,
	0x0d, 0x22, 0x0f, 0x73, 0xfd, 0x55, 0x57, 0x3d, 0x57, 0x80, 0x01, 0x6f, 0x08, 0x67, 0xa0, 0xef,
	0x01, 0xd9, 0xe1, 0x46, 0xd2, 0x47, 0x3c, 0x0a, 0xfd, 0x4d, 0x3a, 0xc4, 0x8d, 0x63, 0x2f, 0xc5,
	0x6f, 0x3e, 0x97, 0xee, 0xc1, 0x69, 0xbe, 0x06, 0x5b, 0x57, 0x31, 0x35, 0x3b, 0xaf, 0x1a, 0x75,
	0xd1, 0xf3, 0x58, 0xd1, 0xb4, 0x8c, 0x0f, 0x88, 0xea, 0xd8, 0xe2, 0x63, 0xfe, 0xb4, 0x2b, 0xd6,
	0x0c, 0x95, 0x85, 0x56, 0x7c, 0xec, 0x3d, 0xee, 0x7a, 0x39, 0xcd, 0xe4, 0xe8, 0xd3, 0xae, 0xf0,
	0xeb, 0x14, 0x00, 0x9f, 0xa7, 0x44, 0x5e, 0xd8, 0xf9, 0x73, 0x00, 0x9a, 0x5e, 0x21, 0x8f, 0xca,
	0x34, 0xe2, 0xae, 0xef, 0xd3, 0x85, 0x9c, 0xe7, 0x26, 0x2f, 0x1d, 0xf2, 0x1b, 0x5e, 0x3a, 0x50,
	0x87, 0xf7, 0xc9, 0x83, 0xae, 0x0a, 0xfd, 0x88, 0xaf, 0x42, 0x9a, 0xe9, 0x13, 0xcb, 0x32, 0x2c,
	0x37, 0x2a, 0xe9, 0x02, 0xf6, 0x26, 0xb0, 0x4c, 0x35, 0x5f, 0x72, 0xd3, 0x85, 0x29, 0xb2, 0xb5,
	0x16, 0xa9, 0x68, 0x71, 0xfb, 0xb9, 0x44, 0x60, 0x6a, 0x5f, 0xff, 0x50, 0xbb, 0xa4, 0x1e, 0x5d,
	0x54, 0x22, 0x3e, 0x2f, 0x95, 0x6d, 0xe2, 0xec, 0x0a, 0x3f, 0x4d, 0xc1, 0x88, 0x4c, 0xb6, 0x88,
	0x45, 0x74, 0x95, 0xac, 0xd4, 0x95, 0x2a, 0x89, 0xf4, 0xd6, 0x18, 0xf4, 0x35, 0x2c, 0x8d, 0x39,
	0x89, 0xc2, 0x4d, 0xc9, 0xf4, 0x1d, 0xaf, 0xc3, 0xc8, 0xa6, 0xd1, 0xd0, 0x2b, 0x9a, 0x5e, 0x2d,
	0x9b, 0x46, 0x6d, 0xc7, 0xce, 0xf6, 0xb9, 0xc9, 0x74, 0x2e, 0x2e, 0x99, 0xe6, 0xb9, 0xf4, 0xba,
	0x51, 0xdb, 0xa1, 0xf3, 0x20, 0x79, 0x78, 0xd3, 0xf7, 0xc9, 0x2e, 0x7e, 0x84, 0x9e, 0x4b, 0xdf,
	0x43, 0x70, 0x2e, 0xda, 0xf6, 0x10, 0xd2, 0xfb, 0x2f, 0x9e, 0x22, 0xa2, 0x15, 0x98, 0xca, 0x16,
	0x1f, 0xb7, 0x3e, 0x94, 0x35, 0xfa, 0x65, 0x57, 0xf8, 0x03, 0x82, 0xd1, 0x05, 0x8b, 0x28, 0x0e,
	0xe1, 0x2e, 0x97, 0xc9, 0xb7, 0x1a, 0xc4, 0x76, 0xb0, 0x04, 0xc7, 0x4c, 0xc5, 0x22, 0xba, 0xc3,
	0x5c, 0x34, 0x7f, 0xf1, 0x99, 0x94, 0xfa, 0x9f, 0xf4, 0x0a, 0x9c, 0x6d, 0xad, 0x1d, 0xc6, 0xbd,
	0xca, 0x07, 0x64, 0xae, 0x88, 0xe7, 0xe0, 0x38, 0x47, 0xe2, 0xfa, 0x34, 0x5d, 0x38, 0xd3, 0x85,
	0x7e, 0xcc, 0xe9, 0x9e, 0x12, 0x3e, 0x0d, 0xe0, 0x85, 0x51, 0xab, 0xf0, 0x6d, 0x61, 0x90, 0x7f,
	0x59, 0xa9, 0x08, 0x3f, 0x42, 0xf0, 0xd2, 0xaa, 0x66, 0x3b, 0x5c, 0xd9, 0x3e, 0x44, 0xe4, 0x93,
	0x30, 0x68, 0x2a, 0x55, 0x52, 0xb6, 0xb5, 0x0f, 0x19, 0x69, 0xfa, 0xe5, 0x01, 0xfa, 0xa1, 0xa4,
	0x7d, 0x48, 0x5c, 0x58, 0x74, 0xd0, 0x31, 0x1e, 0x10, 0xbd, 0x05, 0x4b, 0xa9, 0x92, 0x0d, 0xfa,
	0x41, 0x78, 0x0c, 0xa3, 0x41, 0x54, 0xb6, 0x69, 0xe8, 0x36, 0xc1, 0xb3, 0x30, 0xe0, 0x45, 0x28,
	0x8b, 0xdc, 0x04, 0xea, 0xe6, 0x0e, 0xb9, 0xa5, 0x80, 0xcf, 0xc3, 0x09, 0x9d, 0x3c, 0x72, 0xca,
	0xbe, 0x85, 0x19, 0x97, 0x87, 0xe9, 0xe7, 0xf5, 0xd6, 0xe2, 0x6b, 0x70, 0x72, 0x99, 0x38, 0xa1,
	0x50, 0x7e, 0xcd, 0x9f, 0xeb, 0xf3, 0xaf, 0xba, 0xee, 0x38, 0xd3, 0x65, 0x67, 0x62, 0x94, 0x10,
	0x3e, 0x46, 0x30, 0x7a, 0xd7, 0xac, 0x74, 0xa6, 0x87, 0x2f, 0xb6, 0xe8, 0x45, 0x62, 0x3b, 0x0b,
	0xe9, 0x86, 0x3b, 0xaf, 0x7b, 0x0a, 0xf1, 0xfc, 0xe8, 0xdc, 0x77, 0x96, 0xe8, 0x41, 0x75, 0x4b,
	0xb1, 0x1f, 0xc8, 0xc0, 0xc4, 0xe9, 0xb3, 0x70, 0x07, 0x46, 0x6f, 0x90, 0x1a, 0xe9, 0x00, 0x75,
	0x00, 0x43, 0xff, 0x8c, 0x60, 0x22, 0xc0, 0x83, 0x12, 0x39, 0x4c, 0x2a, 0xdc, 0x84, 0xb4, 0x6f,
	0x47, 0xe2, 0xe6, 0x0a, 0x5d, 0x5c, 0x56, 0x22, 0xdc, 0x6b, 0xd0, 0xde, 0xda, 0xf0, 0xb9, 0xf6,
	0xd1, 0x66, 0x13, 0x1f, 0x31, 0x86, 0xda, 0x32, 0x2b, 0x15, 0xe1, 0x27, 0x08, 0xc6, 0x7d, 0x59,
	0x48, 0xf7, 0xc4, 0x2f, 0x09, 0x3d, 0x3e, 0x42, 0x30, 0xd1, 0x81, 0x8c, 0x53, 0x64, 0x11, 0x86,
	0x7c, 0xb6, 0x79, 0x34, 0x49, 0xe0, 0x26, 0x39, 0xed, 0xdb, 0xfc, 0x13, 0x93, 0x65, 0x03, 0x46,
	0xdb, 0x64, 0xf1, 0xc5, 0xfb, 0xad, 0x40, 0x1a, 0x5d, 0x70, 0xfd, 0x23, 0x74, 0x3f, 0xa9, 0x78,
	0x26, 0xfd, 0x1c, 0xc1, 0x44, 0x80, 0x32, 0xbe, 0x99, 0x43, 0x69, 0x80, 0x5e, 0x3c, 0x0d, 0x0e,
	0xc4, 0x9f, 0xf7, 0x60, 0x22, 0xc0, 0x9f, 0x43, 0xb3, 0xfd, 0x19, 0x82, 0x49, 0xc6, 0xa2, 0xe0,
	0x21, 0xe6, 0xcd, 0x7e, 0x2d, 0x94, 0x7b, 0x09, 0x29, 0xea, 0xe5, 0xdd, 0x06, 0x9c, 0x08, 0x1d,
	0x60, 0xdc, 0xf0, 0xf3, 0x71, 0x2e, 0x0c, 0xc2, 0x60, 0x6e, 0x1c, 0x09, 0x9e, 0x8a, 0x78, 0x06,
	0x70, 0x68, 0xd6, 0x36, 0xab, 0x32, 0x41, 0x59, 0xc6, 0xac, 0x1c, 0xcd, 0xdf, 0xe0, 0xcc, 0xf6,
	0x21, 0x59, 0x78, 0x10, 0x66, 0x7d, 0x82, 0x60, 0x32, 0x12, 0x19, 0x67, 0xd7, 0x1d, 0xc8, 0x84,
	0xec, 0xf4, 0x18, 0x96, 0xd0, 0x7d, 0xf2, 0x89, 0xd0, 0x7d, 0x62, 0x7f, 0xb8, 0x11, 0x34, 0xec,
	0x8b, 0xa2, 0xe1, 0x7d, 0xc8, 0x2e, 0x13, 0x27, 0x3a, 0x61, 0xae, 0x07, 0xd2, 0x71, 0xc6, 0x75,
	0xe6, 0xf9, 0x64, 0x17, 0x27, 0x9e, 0x92, 0x65, 0x98, 0x64, 0xb9, 0xfe, 0x79, 0x2d, 0xf0, 0x33,
	0x04, 0xa7, 0xa5, 0x4a, 0x85, 0x47, 0x72, 0xc3, 0x38, 0x64, 0x4e, 0xe1, 0xb7, 0x83, 0xb7, 0xa8,
	0xc4, 0x29, 0xe5, 0x69, 0x09, 0xbf, 0x42, 0x20, 0xc8, 0xa4, 0x6e, 0x34, 0x3d, 0xba, 0x2f, 0x59,
	0x46, 0xfd, 0x4b, 0x87, 0xf2, 0x09, 0x82, 0x33, 0xfe, 0x7b, 0xd3, 0x8a, 0x7e, 0xd8, 0x10, 0x0f,
	0xc2, 0xad, 0xef, 0x23, 0x98, 0x8a, 0x47, 0xf7, 0x45, 0xde, 0xf0, 0xe6, 0x20, 0xb7, 0x52, 0x37,
	0x0d, 0xcb, 0x7f, 0x80, 0x2e, 0xab, 0x76, 0xc9, 0x6d, 0x2c, 0xe0, 0x29, 0x18, 0x52, 0xed, 0x66,
	0x79, 0x4b, 0xab, 0x91, 0x32, 0xad, 0x65, 0x58, 0x79, 0x03, 0xaa, 0xdd, 0x5c, 0xd2, 0x6a, 0xe4,
	0xae, 0xa5, 0x09, 0xbb, 0xf0, 0x72, 0x87, 0xfe, 0x8a, 0x6e, 0x36, 0x9c, 0x05, 0x43, 0xdf, 0xd2,
	0xaa, 0xb8, 0x04, 0x50, 0x55, 0xed, 0x32, 0x6b, 0x54, 0xf0, 0x13, 0xaa, 0x10, 0x67, 0x46, 0x3c,
	0x92, 0x9b, 0x47, 0xe4, 0xc1, 0xaa, 0xf7, 0x32, 0x3f, 0x00, 0xc7, 0xd8, 0x84, 0xc2, 0xa7, 0x08,
	0xb2, 0x1d, 0x5a, 0x87, 0x78, 0x35, 0xb9, 0x0f, 0x43, 0x1a, 0xb5, 0xa6, 0xac, 0xba, 0xe6, 0xf0,
	0xf3, 0xe1, 0xf5, 0xc4, 0x06, 0xf8, 0x5c, 0xc1, 0x4e, 0x8b, 0xb4, 0xd6, 0xfe, 0x42, 0xb9, 0x7e,
	0x2a, 0x02, 0xfd, 0xe7, 0xb7, 0xc1, 0xe6, 0x61, 0x80, 0x75, 0x5b, 0x88, 0x9d, 0x4d, 0xb9, 0x53,
	0x45, 0x94, 0xd6, 0x72, 0x4b, 0x46, 0xf8, 0x5d, 0x0a, 0xc6, 0xe7, 0x15, 0x47, 0xdd, 0xbe, 0xed,
	0x35, 0x88, 0x6e, 0x11, 0x47, 0xa9, 0x28, 0x8e, 0x82, 0xdf, 0x81, 0x7e, 0x2a, 0xc6, 0x62, 0x3a,
	0x12, 0xef, 0x92, 0x68, 0x75, 0x77, 0x29, 0x22, 0xb3, 0x29, 0xe8, 0xed, 0xc3, 0x6e, 0x6c, 0xd6,
	0x35, 0x87, 0x75, 0x0d, 0x52, 0xdd, 0xba, 0x06, 0x32, 0x30, 0x71, 0xb7, 0x63, 0xf0, 0x06, 0x0c,
	0x10, 0xbd, 0x92, 0xb0, 0xdf, 0x20, 0x1f, 0x27, 0x7a, 0x85, 0xbe, 0x09, 0xef, 0x43, 0xbf, 0x8b,
	0x01, 0x8f, 0xc1, 0xc9, 0xd2, 0x86, 0xb4, 0xb1, 0x58, 0xbe, 0xbb, 0x56, 0x5a, 0x5f, 0x5c, 0x58,
	0x59, 0x5a, 0x59, 0xbc, 0x91, 0x39, 0x82, 0x47, 0x00, 0xd6, 0xe5, 0xdb, 0x0b, 0x8b, 0xa5, 0xd2,
	0xca, 0xda, 0x72, 0x06, 0xd1, 0xf7, 0xd2, 0xdd, 0x05, 0xfa, 0xbe, 0x74, 0x77, 0x35, 0x93, 0xc2,
	0x00, 0xc7, 0x96, 0xa4, 0x95, 0xd5, 0xc5, 0x1b, 0x99, 0x3e, 0x3c, 0x0c, 0x83, 0x0b, 0xd2, 0xda,
	0xc2, 0xe2, 0x2a, 0x7d, 0x3d, 0x2a, 0x5c, 0x83, 0xb1, 0x76, 0x3c, 0xd7, 0x1b, 0x56, 0x95, 0x70,
	0x32, 0x74, 0x5e, 0xb6, 0x51, 0xc4, 0x65, 0xfb, 0x49, 0x0a, 0x46, 0x5d, 0xad, 0x70, 0x25, 0xba,
	0x0d, 0x59, 0xbf, 0xba, 0x49, 0x65, 0x82, 0x89, 0xf9, 0x5a, 0xf7, 0xbb, 0x9f, 0x0f, 0xcf, 0xcd,
	0x23, 0xf2, 0x98, 0x19, 0x09, 0xf4, 0x4d, 0x18, 0xaf, 0xb8, 0xa7, 0x5c, 0xd9, 0xb0, 0xcc, 0x6d,
	0x45, 0x2f, 0xb7, 0x36, 0x22, 0xea, 0xe1, 0x81, 0x9b, 0x47, 0xe4, 0x51, 0x36, 0x7e, 0xdb, 0x1d,
	0xf6, 0x80, 0x1e, 0x06, 0xe3, 0x46, 0xa1, 0x7f, 0xcb, 0xa0, 0x7b, 0xc5, 0x51, 0xba, 0x92, 0xcc,
	0x5e, 0x28, 0xe3, 0x1d, 0xc5, 0xaa, 0x12, 0xa7, 0xf0, 0xcf, 0xd3, 0x30, 0xdc, 0xb2, 0x46, 0xb1,
	0xd4, 0x6d, 0xfc, 0x57, 0x04, 0x99, 0x70, 0xad, 0x85, 0xc5, 0x38, 0x4f, 0xc4, 0x54, 0x65, 0xb9,
	0x04, 0xd7, 0x66, 0x61, 0x7b, 0x4f, 0x3a, 0xcb, 0x60, 0xce, 0xf8, 0x02, 0x31, 0x13, 0x8c, 0xe9,
	0x77, 0x3e, 0xfb, 0xc7, 0xc7, 0xa9, 0x39, 0x41, 0x14, 0x9b, 0x97, 0xc4, 0xc7, 0x4c, 0xfa, 0x5a,
	0xab, 0xe7, 0x32, 0xed, 0xeb, 0xb5, 0x4c, 0x07, 0x7a, 0x4c, 0x45, 0xff, 0x55, 0x1e, 0xff, 0x1e,
	0xc1, 0x89, 0x50, 0x59, 0x83, 0xf3, 0x71, 0x08, 0xa3, 0x2b, 0xb3, 0x9c, 0x98, 0x58, 0x9e, 0x6d,
	0x38, 0xc2, 0xf5, 0x3d, 0x89, 0x47, 0xc1, 0xb5, 0xe1, 0x12, 0xee, 0xd5, 0x06, 0xfc, 0x0b, 0x04,
	0xc3, 0x81, 0x1a, 0x08, 0xcf, 0xc4, 0x81, 0x88, 0x2a, 0x95, 0x12, 0x05, 0x61, 0x6e, 0x4f, 0x72,
	0x0f, 0xe0, 0x00, 0x46, 0xfa, 0x21, 0x06, 0x61, 0xa0, 0x91, 0x37, 0xbd, 0x8b, 0x3f, 0x43, 0x90,
	0x09, 0x17, 0x54, 0xf1, 0xe9, 0x12, 0x53, 0x7a, 0x25, 0x42, 0xfa, 0xc1, 0x9e, 0x34, 0xe1, 0xcf,
	0x13, 0x5f, 0x85, 0xe5, 0x82, 0x7f, 0xa7, 0x30, 0xcb, 0x1c, 0xdc, 0x96, 0xc9, 0x27, 0x37, 0x24,
	0x98, 0x30, 0x4f, 0x10, 0x64, 0xc2, 0x45, 0x58, 0xbc, 0x55, 0x31, 0xe5, 0x5a, 0x6e, 0xbc, 0x63,
	0xe7, 0x5c, 0xac, 0x9b, 0xce, 0x4e, 0xc8, 0xe7, 0xd3, 0x3d, 0xfb, 0xfc, 0x8f, 0x08, 0x86, 0x03,
	0xc4, 0x8b, 0xcf, 0x8b, 0xa8, 0xee, 0x61, 0xae, 0xdb, 0xc5, 0x47, 0x78, 0x7f, 0x4f, 0x3a, 0x15,
	0x64, 0xe6, 0x4c, 0xbb, 0xd7, 0xe7, 0xa2, 0xbe, 0x22, 0xcc, 0xf4, 0x90, 0xcd, 0x76, 0xb1, 0xd5,
	0x5a, 0xfa, 0x0d, 0x82, 0x21, 0xff, 0x5d, 0x0d, 0x7f, 0x25, 0x01, 0xaf, 0x5a, 0x24, 0x9c, 0x49,
	0x26, 0xcc, 0x19, 0x78, 0x2d, 0xc8, 0xc0, 0x3c, 0xee, 0x09, 0x33, 0xfe, 0x31, 0x02, 0x68, 0xf3,
	0x0a, 0x5f, 0xec, 0xce, 0xbd, 0xc4, 0x0e, 0x9e, 0xf5, 0x67, 0x80, 0x87, 0x2b, 0x41, 0x06, 0xb8,
	0xe1, 0xff, 0x14, 0xc1, 0x70, 0x80, 0x48, 0xf1, 0xe1, 0x8f, 0xea, 0x0e, 0x76, 0x47, 0x77, 0x6f,
	0x4f, 0x7a, 0xc9, 0x8b, 0x7b, 0x98, 0x65, 0x6f, 0x17, 0x5e, 0xf7, 0xb3, 0x2c, 0x9f, 0x10, 0x74,
	0x3b, 0x01, 0x7e, 0x88, 0x60, 0x38, 0x40, 0x98, 0x78, 0xf4, 0x51, 0x6d, 0xc4, 0x58, 0x52, 0x05,
	0x5d, 0x3a, 0xdd, 0x9b, 0x4b, 0xff, 0xdb, 0x6a, 0xb4, 0x87, 0xfa, 0xfb, 0x97, 0xf7, 0x27, 0x56,
	0x64, 0xd9, 0x9a, 0x4b, 0x78, 0xa1, 0x14, 0xbe, 0x8b, 0xf6, 0xa4, 0x8b, 0x9c, 0x67, 0xa1, 0xbb,
	0xe9, 0x4c, 0x67, 0xd3, 0xc3, 0x35, 0xec, 0x8e, 0x30, 0xd7, 0x3d, 0x87, 0xfd, 0xa6, 0x85, 0x7f,
	0x65, 0x28, 0x86, 0x9b, 0x34, 0xf8, 0xb7, 0xc8, 0x6b, 0xd8, 0x26, 0xb5, 0x7d, 0x9f, 0x92, 0x3d,
	0x36, 0x3c, 0xb7, 0xfc, 0xe1, 0xb9, 0x3e, 0x3d, 0xd7, 0x43, 0x78, 0x3a, 0x7e, 0x28, 0x99, 0xde,
	0xc5, 0x7f, 0xe1, 0x3f, 0x2f, 0x84, 0xda, 0x29, 0xb8, 0xb0, 0xdf, 0x06, 0x11, 0xdd, 0x15, 0xca,
	0x5d, 0xee, 0x49, 0x87, 0xef, 0x2d, 0xb7, 0x83, 0x7b, 0xcb, 0x75, 0x7c, 0xc0, 0xb8, 0xe0, 0x4f,
	0x90, 0xfb, 0xeb, 0x40, 0x28, 0x06, 0x5f, 0xdd, 0x67, 0xd3, 0x39, 0x58, 0xf2, 0x2d, 0x05, 0x70,
	0xbf, 0x78, 0x24, 0xfe, 0x84, 0x60, 0x3c, 0xba, 0xc3, 0x82, 0xdf, 0x88, 0x83, 0xb2, 0x6f, 0x47,
	0x26, 0x36, 0x85, 0x36, 0xf6, 0xa4, 0x21, 0x8a, 0xd3, 0x3b, 0x8b, 0xd8, 0x7e, 0x24, 0x14, 0x7b,
	0x3c, 0x3e, 0x8b, 0x4a, 0x6b, 0xf5, 0x22, 0x9a, 0xc6, 0x4f, 0x11, 0x4c, 0xee, 0xd3, 0x80, 0xc1,
	0xc5, 0x78, 0x7f, 0x76, 0xeb, 0xda, 0xc4, 0x5a, 0xf2, 0x5e, 0x94, 0x25, 0xf3, 0xc2, 0xb5, 0x5e,
	0x2d, 0xb1, 0xfc, 0x10, 0xa8, 0x31, 0x7f, 0x47, 0x90, 0x8d, 0xeb, 0x84, 0xe0, 0x2b, 0x49, 0x0e,
	0xcf, 0x88, 0xce, 0x4e, 0xee, 0x6a, 0xef, 0x8a, 0x9c, 0x25, 0xcb, 0x7e, 0xd6, 0x17, 0xf1, 0xd5,
	0x1e, 0x0d, 0x6c, 0x9f, 0xc5, 0xff, 0x42, 0x70, 0xb2, 0xa3, 0xb6, 0x8f, 0x67, 0x47, 0x5c, 0x13,
	0x23, 0x77, 0xda, 0xd3, 0xf0, 0xfd, 0x5f, 0x23, 0xdf, 0xaa, 0xa7, 0x85, 0x1f, 0xa0, 0xa7, 0xd2,
	0xe5, 0xfd, 0xba, 0x08, 0x31, 0xf5, 0x3b, 0x3d, 0x30, 0xd9, 0x3e, 0xee, 0xef, 0x6f, 0xb8, 0x56,
	0xcf, 0x0a, 0x6f, 0xf6, 0x5a, 0xbb, 0x68, 0xee, 0xf2, 0x3c, 0x9e, 0xc3, 0x81, 0xe2, 0x35, 0xfe,
	0xb0, 0x8c, 0xaa, 0x71, 0xbb, 0x99, 0xfb, 0xe8, 0xa9, 0x24, 0xc2, 0x58, 0x64, 0x8e, 0xc6, 0x5b,
	0xea, 0xdf, 0xf6, 0xae, 0x08, 0x85, 0x9e, 0xae, 0x81, 0x6e, 0x91, 0x5d, 0x44, 0xd3, 0xb9, 0xe6,
	0x53, 0x69, 0x2c, 0xb2, 0x33, 0xf8, 0x37, 0xe9, 0xde, 0xb6, 0xe3, 0x98, 0x76, 0x51, 0x14, 0x1f,
	0x3e, 0x7c, 0x18, 0xae, 0x6f, 0x95, 0x86, 0xb3, 0xcd, 0xfe, 0x91, 0xf3, 0x9a, 0x59, 0x53, 0x9c,
	0x2d, 0xc3, 0xaa, 0xcf, 0x24, 0x13, 0x67, 0x8b, 0xcd, 0x7f, 0x1b, 0x41, 0x4e, 0x35, 0xea, 0x31,
	0x4e, 0x9c, 0x3f, 0x15, 0xa8, 0x85, 0x4b, 0xec, 0xbf, 0x49, 0xeb, 0xd4, 0x31, 0xeb, 0xe8, 0x1b,
	0x6f, 0x71, 0xa5, 0xaa, 0x51, 0x53, 0xf4, 0x6a, 0xde, 0xb0, 0xaa, 0x62, 0x95, 0xe8, 0xae, 0xdb,
	0xc4, 0xf6, 0xc2, 0xe1, 0x3f, 0x0c, 0xcd, 0xb2, 0xa7, 0xff, 0x20, 0xf4, 0xcb, 0xd4, 0xd1, 0xe5,
	0x85, 0x77, 0xd7, 0x36, 0x8f, 0xb9, 0x2a, 0x97, 0xff, 0x1f, 0x00, 0x00, 0xff, 0xff, 0x16, 0x7a,
	0xba, 0x14, 0x22, 0x25, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ProductSearchClient is the client API for ProductSearch service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProductSearchClient interface {
	// Creates and returns a new ProductSet resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
	//   4096 characters.
	CreateProductSet(ctx context.Context, in *CreateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Lists ProductSets in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
	//   than 1.
	ListProductSets(ctx context.Context, in *ListProductSetsRequest, opts ...grpc.CallOption) (*ListProductSetsResponse, error)
	// Gets information associated with a ProductSet.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	GetProductSet(ctx context.Context, in *GetProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Makes changes to a ProductSet resource.
	// Only display_name can be updated currently.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
	//   missing from the request or longer than 4096 characters.
	UpdateProductSet(ctx context.Context, in *UpdateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error)
	// Permanently deletes a ProductSet. Products and ReferenceImages in the
	// ProductSet are not deleted.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteProductSet(ctx context.Context, in *DeleteProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates and returns a new product resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
	CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Lists products in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error)
	// Gets information associated with a Product.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Makes changes to a Product resource.
	// Only the `display_name`, `description`, and `labels` fields can be updated
	// right now.
	//
	// If labels are updated, the change will not be reflected in queries until
	// the next index time.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
	//   missing from the request or longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if description is present in update_mask but is
	//   longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
	UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Permanently deletes a product and its reference images.
	//
	// Metadata of the product and all its images will be deleted right away, but
	// search queries against ProductSets containing the product may still work
	// until all related caches are refreshed.
	DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates and returns a new ReferenceImage resource.
	//
	// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
	// the system will try to detect regions of interest in the image that are
	// compatible with the product_category on the parent product. If it is
	// specified, detection is ALWAYS skipped. The system converts polygons into
	// non-rotated rectangles.
	//
	// Note that the pipeline will resize the image if the image resolution is too
	// large to process (above 50MP).
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if the product does not exist.
	// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
	//   compatible with the parent product's product_category is detected.
	// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
	CreateReferenceImage(ctx context.Context, in *CreateReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error)
	// Permanently deletes a reference image.
	//
	// The image metadata will be deleted right away, but search queries
	// against ProductSets containing the image may still work until all related
	// caches are refreshed.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteReferenceImage(ctx context.Context, in *DeleteReferenceImageRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists reference images.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the parent product does not exist.
	// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
	//   than 1.
	ListReferenceImages(ctx context.Context, in *ListReferenceImagesRequest, opts ...grpc.CallOption) (*ListReferenceImagesResponse, error)
	// Gets information associated with a ReferenceImage.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the specified image does not exist.
	GetReferenceImage(ctx context.Context, in *GetReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error)
	// Adds a Product to the specified ProductSet. If the Product is already
	// present, no change is made.
	//
	// One Product can be added to at most 100 ProductSets.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
	AddProductToProductSet(ctx context.Context, in *AddProductToProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Removes a Product from the specified ProductSet.
	RemoveProductFromProductSet(ctx context.Context, in *RemoveProductFromProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists the Products in a ProductSet, in an unspecified order. If the
	// ProductSet does not exist, the products field of the response will be
	// empty.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProductsInProductSet(ctx context.Context, in *ListProductsInProductSetRequest, opts ...grpc.CallOption) (*ListProductsInProductSetResponse, error)
	// Asynchronous API that imports a list of reference images to specified
	// product sets based on a list of image information.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be used to keep track of the
	// progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	// `Operation.response` contains `ImportProductSetsResponse`. (results)
	//
	// The input source of this method is a csv file on Google Cloud Storage.
	// For the format of the csv file please see
	// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
	ImportProductSets(ctx context.Context, in *ImportProductSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Asynchronous API to delete all Products in a ProductSet or all Products
	// that are in no ProductSet.
	//
	// If a Product is a member of the specified ProductSet in addition to other
	// ProductSets, the Product will still be deleted.
	//
	// It is recommended to not delete the specified ProductSet until after this
	// operation has completed. It is also recommended to not add any of the
	// Products involved in the batch delete to a new ProductSet while this
	// operation is running because those Products may still end up deleted.
	//
	// It's not possible to undo the PurgeProducts operation. Therefore, it is
	// recommended to keep the csv files used in ImportProductSets (if that was
	// how you originally built the Product Set) before starting PurgeProducts, in
	// case you need to re-import the data after deletion.
	//
	// If the plan is to purge all of the Products from a ProductSet and then
	// re-use the empty ProductSet to re-import new Products into the empty
	// ProductSet, you must wait until the PurgeProducts operation has finished
	// for that ProductSet.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be used to keep track of the
	// progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	PurgeProducts(ctx context.Context, in *PurgeProductsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type productSearchClient struct {
	cc *grpc.ClientConn
}

func NewProductSearchClient(cc *grpc.ClientConn) ProductSearchClient {
	return &productSearchClient{cc}
}

func (c *productSearchClient) CreateProductSet(ctx context.Context, in *CreateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/CreateProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProductSets(ctx context.Context, in *ListProductSetsRequest, opts ...grpc.CallOption) (*ListProductSetsResponse, error) {
	out := new(ListProductSetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListProductSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetProductSet(ctx context.Context, in *GetProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/GetProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) UpdateProductSet(ctx context.Context, in *UpdateProductSetRequest, opts ...grpc.CallOption) (*ProductSet, error) {
	out := new(ProductSet)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/UpdateProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteProductSet(ctx context.Context, in *DeleteProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/DeleteProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/CreateProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error) {
	out := new(ListProductsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/GetProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/UpdateProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/DeleteProduct", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) CreateReferenceImage(ctx context.Context, in *CreateReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error) {
	out := new(ReferenceImage)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/CreateReferenceImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) DeleteReferenceImage(ctx context.Context, in *DeleteReferenceImageRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/DeleteReferenceImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListReferenceImages(ctx context.Context, in *ListReferenceImagesRequest, opts ...grpc.CallOption) (*ListReferenceImagesResponse, error) {
	out := new(ListReferenceImagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListReferenceImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) GetReferenceImage(ctx context.Context, in *GetReferenceImageRequest, opts ...grpc.CallOption) (*ReferenceImage, error) {
	out := new(ReferenceImage)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/GetReferenceImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) AddProductToProductSet(ctx context.Context, in *AddProductToProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/AddProductToProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) RemoveProductFromProductSet(ctx context.Context, in *RemoveProductFromProductSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/RemoveProductFromProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ListProductsInProductSet(ctx context.Context, in *ListProductsInProductSetRequest, opts ...grpc.CallOption) (*ListProductsInProductSetResponse, error) {
	out := new(ListProductsInProductSetResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ListProductsInProductSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) ImportProductSets(ctx context.Context, in *ImportProductSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/ImportProductSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productSearchClient) PurgeProducts(ctx context.Context, in *PurgeProductsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ProductSearch/PurgeProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProductSearchServer is the server API for ProductSearch service.
type ProductSearchServer interface {
	// Creates and returns a new ProductSet resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
	//   4096 characters.
	CreateProductSet(context.Context, *CreateProductSetRequest) (*ProductSet, error)
	// Lists ProductSets in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
	//   than 1.
	ListProductSets(context.Context, *ListProductSetsRequest) (*ListProductSetsResponse, error)
	// Gets information associated with a ProductSet.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	GetProductSet(context.Context, *GetProductSetRequest) (*ProductSet, error)
	// Makes changes to a ProductSet resource.
	// Only display_name can be updated currently.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the ProductSet does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
	//   missing from the request or longer than 4096 characters.
	UpdateProductSet(context.Context, *UpdateProductSetRequest) (*ProductSet, error)
	// Permanently deletes a ProductSet. Products and ReferenceImages in the
	// ProductSet are not deleted.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteProductSet(context.Context, *DeleteProductSetRequest) (*empty.Empty, error)
	// Creates and returns a new product resource.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
	CreateProduct(context.Context, *CreateProductRequest) (*Product, error)
	// Lists products in an unspecified order.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error)
	// Gets information associated with a Product.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	GetProduct(context.Context, *GetProductRequest) (*Product, error)
	// Makes changes to a Product resource.
	// Only the `display_name`, `description`, and `labels` fields can be updated
	// right now.
	//
	// If labels are updated, the change will not be reflected in queries until
	// the next index time.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product does not exist.
	// * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
	//   missing from the request or longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if description is present in update_mask but is
	//   longer than 4096 characters.
	// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
	UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error)
	// Permanently deletes a product and its reference images.
	//
	// Metadata of the product and all its images will be deleted right away, but
	// search queries against ProductSets containing the product may still work
	// until all related caches are refreshed.
	DeleteProduct(context.Context, *DeleteProductRequest) (*empty.Empty, error)
	// Creates and returns a new ReferenceImage resource.
	//
	// The `bounding_poly` field is optional. If `bounding_poly` is not specified,
	// the system will try to detect regions of interest in the image that are
	// compatible with the product_category on the parent product. If it is
	// specified, detection is ALWAYS skipped. The system converts polygons into
	// non-rotated rectangles.
	//
	// Note that the pipeline will resize the image if the image resolution is too
	// large to process (above 50MP).
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
	//   characters.
	// * Returns INVALID_ARGUMENT if the product does not exist.
	// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
	//   compatible with the parent product's product_category is detected.
	// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
	CreateReferenceImage(context.Context, *CreateReferenceImageRequest) (*ReferenceImage, error)
	// Permanently deletes a reference image.
	//
	// The image metadata will be deleted right away, but search queries
	// against ProductSets containing the image may still work until all related
	// caches are refreshed.
	//
	// The actual image files are not deleted from Google Cloud Storage.
	DeleteReferenceImage(context.Context, *DeleteReferenceImageRequest) (*empty.Empty, error)
	// Lists reference images.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the parent product does not exist.
	// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
	//   than 1.
	ListReferenceImages(context.Context, *ListReferenceImagesRequest) (*ListReferenceImagesResponse, error)
	// Gets information associated with a ReferenceImage.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the specified image does not exist.
	GetReferenceImage(context.Context, *GetReferenceImageRequest) (*ReferenceImage, error)
	// Adds a Product to the specified ProductSet. If the Product is already
	// present, no change is made.
	//
	// One Product can be added to at most 100 ProductSets.
	//
	// Possible errors:
	//
	// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
	AddProductToProductSet(context.Context, *AddProductToProductSetRequest) (*empty.Empty, error)
	// Removes a Product from the specified ProductSet.
	RemoveProductFromProductSet(context.Context, *RemoveProductFromProductSetRequest) (*empty.Empty, error)
	// Lists the Products in a ProductSet, in an unspecified order. If the
	// ProductSet does not exist, the products field of the response will be
	// empty.
	//
	// Possible errors:
	//
	// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
	ListProductsInProductSet(context.Context, *ListProductsInProductSetRequest) (*ListProductsInProductSetResponse, error)
	// Asynchronous API that imports a list of reference images to specified
	// product sets based on a list of image information.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be used to keep track of the
	// progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	// `Operation.response` contains `ImportProductSetsResponse`. (results)
	//
	// The input source of this method is a csv file on Google Cloud Storage.
	// For the format of the csv file please see
	// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
	ImportProductSets(context.Context, *ImportProductSetsRequest) (*longrunning.Operation, error)
	// Asynchronous API to delete all Products in a ProductSet or all Products
	// that are in no ProductSet.
	//
	// If a Product is a member of the specified ProductSet in addition to other
	// ProductSets, the Product will still be deleted.
	//
	// It is recommended to not delete the specified ProductSet until after this
	// operation has completed. It is also recommended to not add any of the
	// Products involved in the batch delete to a new ProductSet while this
	// operation is running because those Products may still end up deleted.
	//
	// It's not possible to undo the PurgeProducts operation. Therefore, it is
	// recommended to keep the csv files used in ImportProductSets (if that was
	// how you originally built the Product Set) before starting PurgeProducts, in
	// case you need to re-import the data after deletion.
	//
	// If the plan is to purge all of the Products from a ProductSet and then
	// re-use the empty ProductSet to re-import new Products into the empty
	// ProductSet, you must wait until the PurgeProducts operation has finished
	// for that ProductSet.
	//
	// The [google.longrunning.Operation][google.longrunning.Operation] API can be used to keep track of the
	// progress and results of the request.
	// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
	PurgeProducts(context.Context, *PurgeProductsRequest) (*longrunning.Operation, error)
}

// UnimplementedProductSearchServer can be embedded to have forward compatible implementations.
type UnimplementedProductSearchServer struct {
}

func (*UnimplementedProductSearchServer) CreateProductSet(ctx context.Context, req *CreateProductSetRequest) (*ProductSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateProductSet not implemented")
}
func (*UnimplementedProductSearchServer) ListProductSets(ctx context.Context, req *ListProductSetsRequest) (*ListProductSetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProductSets not implemented")
}
func (*UnimplementedProductSearchServer) GetProductSet(ctx context.Context, req *GetProductSetRequest) (*ProductSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetProductSet not implemented")
}
func (*UnimplementedProductSearchServer) UpdateProductSet(ctx context.Context, req *UpdateProductSetRequest) (*ProductSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateProductSet not implemented")
}
func (*UnimplementedProductSearchServer) DeleteProductSet(ctx context.Context, req *DeleteProductSetRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteProductSet not implemented")
}
func (*UnimplementedProductSearchServer) CreateProduct(ctx context.Context, req *CreateProductRequest) (*Product, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateProduct not implemented")
}
func (*UnimplementedProductSearchServer) ListProducts(ctx context.Context, req *ListProductsRequest) (*ListProductsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProducts not implemented")
}
func (*UnimplementedProductSearchServer) GetProduct(ctx context.Context, req *GetProductRequest) (*Product, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetProduct not implemented")
}
func (*UnimplementedProductSearchServer) UpdateProduct(ctx context.Context, req *UpdateProductRequest) (*Product, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateProduct not implemented")
}
func (*UnimplementedProductSearchServer) DeleteProduct(ctx context.Context, req *DeleteProductRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteProduct not implemented")
}
func (*UnimplementedProductSearchServer) CreateReferenceImage(ctx context.Context, req *CreateReferenceImageRequest) (*ReferenceImage, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateReferenceImage not implemented")
}
func (*UnimplementedProductSearchServer) DeleteReferenceImage(ctx context.Context, req *DeleteReferenceImageRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteReferenceImage not implemented")
}
func (*UnimplementedProductSearchServer) ListReferenceImages(ctx context.Context, req *ListReferenceImagesRequest) (*ListReferenceImagesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReferenceImages not implemented")
}
func (*UnimplementedProductSearchServer) GetReferenceImage(ctx context.Context, req *GetReferenceImageRequest) (*ReferenceImage, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReferenceImage not implemented")
}
func (*UnimplementedProductSearchServer) AddProductToProductSet(ctx context.Context, req *AddProductToProductSetRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddProductToProductSet not implemented")
}
func (*UnimplementedProductSearchServer) RemoveProductFromProductSet(ctx context.Context, req *RemoveProductFromProductSetRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RemoveProductFromProductSet not implemented")
}
func (*UnimplementedProductSearchServer) ListProductsInProductSet(ctx context.Context, req *ListProductsInProductSetRequest) (*ListProductsInProductSetResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProductsInProductSet not implemented")
}
func (*UnimplementedProductSearchServer) ImportProductSets(ctx context.Context, req *ImportProductSetsRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ImportProductSets not implemented")
}
func (*UnimplementedProductSearchServer) PurgeProducts(ctx context.Context, req *PurgeProductsRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PurgeProducts not implemented")
}

func RegisterProductSearchServer(s *grpc.Server, srv ProductSearchServer) {
	s.RegisterService(&_ProductSearch_serviceDesc, srv)
}

func _ProductSearch_CreateProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/CreateProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateProductSet(ctx, req.(*CreateProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProductSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProductSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListProductSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProductSets(ctx, req.(*ListProductSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/GetProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetProductSet(ctx, req.(*GetProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_UpdateProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).UpdateProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/UpdateProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).UpdateProductSet(ctx, req.(*UpdateProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/DeleteProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteProductSet(ctx, req.(*DeleteProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_CreateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/CreateProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateProduct(ctx, req.(*CreateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProducts(ctx, req.(*ListProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/GetProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetProduct(ctx, req.(*GetProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_UpdateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).UpdateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/UpdateProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).UpdateProduct(ctx, req.(*UpdateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/DeleteProduct",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteProduct(ctx, req.(*DeleteProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_CreateReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).CreateReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/CreateReferenceImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).CreateReferenceImage(ctx, req.(*CreateReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_DeleteReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).DeleteReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/DeleteReferenceImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).DeleteReferenceImage(ctx, req.(*DeleteReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListReferenceImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReferenceImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListReferenceImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListReferenceImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListReferenceImages(ctx, req.(*ListReferenceImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_GetReferenceImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReferenceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).GetReferenceImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/GetReferenceImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).GetReferenceImage(ctx, req.(*GetReferenceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_AddProductToProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddProductToProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).AddProductToProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/AddProductToProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).AddProductToProductSet(ctx, req.(*AddProductToProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_RemoveProductFromProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveProductFromProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).RemoveProductFromProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/RemoveProductFromProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).RemoveProductFromProductSet(ctx, req.(*RemoveProductFromProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ListProductsInProductSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsInProductSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ListProductsInProductSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ListProductsInProductSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ListProductsInProductSet(ctx, req.(*ListProductsInProductSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_ImportProductSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportProductSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).ImportProductSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/ImportProductSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).ImportProductSets(ctx, req.(*ImportProductSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductSearch_PurgeProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductSearchServer).PurgeProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ProductSearch/PurgeProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductSearchServer).PurgeProducts(ctx, req.(*PurgeProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProductSearch_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1.ProductSearch",
	HandlerType: (*ProductSearchServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateProductSet",
			Handler:    _ProductSearch_CreateProductSet_Handler,
		},
		{
			MethodName: "ListProductSets",
			Handler:    _ProductSearch_ListProductSets_Handler,
		},
		{
			MethodName: "GetProductSet",
			Handler:    _ProductSearch_GetProductSet_Handler,
		},
		{
			MethodName: "UpdateProductSet",
			Handler:    _ProductSearch_UpdateProductSet_Handler,
		},
		{
			MethodName: "DeleteProductSet",
			Handler:    _ProductSearch_DeleteProductSet_Handler,
		},
		{
			MethodName: "CreateProduct",
			Handler:    _ProductSearch_CreateProduct_Handler,
		},
		{
			MethodName: "ListProducts",
			Handler:    _ProductSearch_ListProducts_Handler,
		},
		{
			MethodName: "GetProduct",
			Handler:    _ProductSearch_GetProduct_Handler,
		},
		{
			MethodName: "UpdateProduct",
			Handler:    _ProductSearch_UpdateProduct_Handler,
		},
		{
			MethodName: "DeleteProduct",
			Handler:    _ProductSearch_DeleteProduct_Handler,
		},
		{
			MethodName: "CreateReferenceImage",
			Handler:    _ProductSearch_CreateReferenceImage_Handler,
		},
		{
			MethodName: "DeleteReferenceImage",
			Handler:    _ProductSearch_DeleteReferenceImage_Handler,
		},
		{
			MethodName: "ListReferenceImages",
			Handler:    _ProductSearch_ListReferenceImages_Handler,
		},
		{
			MethodName: "GetReferenceImage",
			Handler:    _ProductSearch_GetReferenceImage_Handler,
		},
		{
			MethodName: "AddProductToProductSet",
			Handler:    _ProductSearch_AddProductToProductSet_Handler,
		},
		{
			MethodName: "RemoveProductFromProductSet",
			Handler:    _ProductSearch_RemoveProductFromProductSet_Handler,
		},
		{
			MethodName: "ListProductsInProductSet",
			Handler:    _ProductSearch_ListProductsInProductSet_Handler,
		},
		{
			MethodName: "ImportProductSets",
			Handler:    _ProductSearch_ImportProductSets_Handler,
		},
		{
			MethodName: "PurgeProducts",
			Handler:    _ProductSearch_PurgeProducts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1/product_search_service.proto",
}
