// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1beta1/video_intelligence.proto

package videointelligence

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 2
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 3
	// Safe search detection.
	Feature_SAFE_SEARCH_DETECTION Feature = 4
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "FACE_DETECTION",
	3: "SHOT_CHANGE_DETECTION",
	4: "SAFE_SEARCH_DETECTION",
}

var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":   0,
	"LABEL_DETECTION":       1,
	"FACE_DETECTION":        2,
	"SHOT_CHANGE_DETECTION": 3,
	"SAFE_SEARCH_DETECTION": 4,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}

func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{0}
}

// Label level (scope).
type LabelLevel int32

const (
	// Unspecified.
	LabelLevel_LABEL_LEVEL_UNSPECIFIED LabelLevel = 0
	// Video-level. Corresponds to the whole video.
	LabelLevel_VIDEO_LEVEL LabelLevel = 1
	// Segment-level. Corresponds to one of `AnnotateSpec.segments`.
	LabelLevel_SEGMENT_LEVEL LabelLevel = 2
	// Shot-level. Corresponds to a single shot (i.e. a series of frames
	// without a major camera position or background change).
	LabelLevel_SHOT_LEVEL LabelLevel = 3
	// Frame-level. Corresponds to a single video frame.
	LabelLevel_FRAME_LEVEL LabelLevel = 4
)

var LabelLevel_name = map[int32]string{
	0: "LABEL_LEVEL_UNSPECIFIED",
	1: "VIDEO_LEVEL",
	2: "SEGMENT_LEVEL",
	3: "SHOT_LEVEL",
	4: "FRAME_LEVEL",
}

var LabelLevel_value = map[string]int32{
	"LABEL_LEVEL_UNSPECIFIED": 0,
	"VIDEO_LEVEL":             1,
	"SEGMENT_LEVEL":           2,
	"SHOT_LEVEL":              3,
	"FRAME_LEVEL":             4,
}

func (x LabelLevel) String() string {
	return proto.EnumName(LabelLevel_name, int32(x))
}

func (LabelLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{1}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}

var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}

func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{2}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "UNKNOWN",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"UNKNOWN":       0,
	"VERY_UNLIKELY": 1,
	"UNLIKELY":      2,
	"POSSIBLE":      3,
	"LIKELY":        4,
	"VERY_LIKELY":   5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{3}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes. Encoding: base64. If unset, the input video(s)
	// should be specified via `input_uri`. If set, `input_uri` should be unset.
	InputContent string `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{0}
}

func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(m, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() string {
	if m != nil {
		return m.InputContent
	}
	return ""
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video
	// is treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// If label detection has been requested, what labels should be detected
	// in addition to video-level labels or segment-level labels. If unspecified,
	// defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,2,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	StationaryCamera bool `protobuf:"varint,3,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "latest" and "stable" (the default).
	LabelDetectionModel string `protobuf:"bytes,4,opt,name=label_detection_model,json=labelDetectionModel,proto3" json:"label_detection_model,omitempty"`
	// Model to use for face detection.
	// Supported values: "latest" and "stable" (the default).
	FaceDetectionModel string `protobuf:"bytes,5,opt,name=face_detection_model,json=faceDetectionModel,proto3" json:"face_detection_model,omitempty"`
	// Model to use for shot change detection.
	// Supported values: "latest" and "stable" (the default).
	ShotChangeDetectionModel string `protobuf:"bytes,6,opt,name=shot_change_detection_model,json=shotChangeDetectionModel,proto3" json:"shot_change_detection_model,omitempty"`
	// Model to use for safe search detection.
	// Supported values: "latest" and "stable" (the default).
	SafeSearchDetectionModel string   `protobuf:"bytes,7,opt,name=safe_search_detection_model,json=safeSearchDetectionModel,proto3" json:"safe_search_detection_model,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{1}
}

func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (m *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(m, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *VideoContext) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *VideoContext) GetLabelDetectionModel() string {
	if m != nil {
		return m.LabelDetectionModel
	}
	return ""
}

func (m *VideoContext) GetFaceDetectionModel() string {
	if m != nil {
		return m.FaceDetectionModel
	}
	return ""
}

func (m *VideoContext) GetShotChangeDetectionModel() string {
	if m != nil {
		return m.ShotChangeDetectionModel
	}
	return ""
}

func (m *VideoContext) GetSafeSearchDetectionModel() string {
	if m != nil {
		return m.SafeSearchDetectionModel
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	// Start offset in microseconds (inclusive). Unset means 0.
	StartTimeOffset int64 `protobuf:"varint,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// End offset in microseconds (inclusive). Unset means 0.
	EndTimeOffset        int64    `protobuf:"varint,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{2}
}

func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (m *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(m, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() int64 {
	if m != nil {
		return m.StartTimeOffset
	}
	return 0
}

func (m *VideoSegment) GetEndTimeOffset() int64 {
	if m != nil {
		return m.EndTimeOffset
	}
	return 0
}

// Label location.
type LabelLocation struct {
	// Video segment. Set to [-1, -1] for video-level labels.
	// Set to [timestamp, timestamp] for frame-level labels.
	// Otherwise, corresponds to one of `AnnotateSpec.segments`
	// (if specified) or to shot boundaries (if requested).
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Label level.
	Level                LabelLevel `protobuf:"varint,3,opt,name=level,proto3,enum=google.cloud.videointelligence.v1beta1.LabelLevel" json:"level,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *LabelLocation) Reset()         { *m = LabelLocation{} }
func (m *LabelLocation) String() string { return proto.CompactTextString(m) }
func (*LabelLocation) ProtoMessage()    {}
func (*LabelLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{3}
}

func (m *LabelLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelLocation.Unmarshal(m, b)
}
func (m *LabelLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelLocation.Marshal(b, m, deterministic)
}
func (m *LabelLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelLocation.Merge(m, src)
}
func (m *LabelLocation) XXX_Size() int {
	return xxx_messageInfo_LabelLocation.Size(m)
}
func (m *LabelLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelLocation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelLocation proto.InternalMessageInfo

func (m *LabelLocation) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelLocation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *LabelLocation) GetLevel() LabelLevel {
	if m != nil {
		return m.Level
	}
	return LabelLevel_LABEL_LEVEL_UNSPECIFIED
}

// Label annotation.
type LabelAnnotation struct {
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Where the label was detected and with what confidence.
	Locations            []*LabelLocation `protobuf:"bytes,3,rep,name=locations,proto3" json:"locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{4}
}

func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (m *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(m, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *LabelAnnotation) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *LabelAnnotation) GetLocations() []*LabelLocation {
	if m != nil {
		return m.Locations
	}
	return nil
}

// Safe search annotation (based on per-frame visual signals only).
// If no unsafe content has been detected in a frame, no annotations
// are present for that frame. If only some types of unsafe content
// have been detected in a frame, the likelihood is set to `UNKNOWN`
// for all other types of unsafe content.
type SafeSearchAnnotation struct {
	// Likelihood of adult content.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"adult,omitempty"`
	// Likelihood that an obvious modification was made to the original
	// version to make it appear funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"spoof,omitempty"`
	// Likelihood of medical content.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"medical,omitempty"`
	// Likelihood of violent content.
	Violent Likelihood `protobuf:"varint,4,opt,name=violent,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"violent,omitempty"`
	// Likelihood of racy content.
	Racy Likelihood `protobuf:"varint,5,opt,name=racy,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"racy,omitempty"`
	// Video time offset in microseconds.
	TimeOffset           int64    `protobuf:"varint,6,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SafeSearchAnnotation) Reset()         { *m = SafeSearchAnnotation{} }
func (m *SafeSearchAnnotation) String() string { return proto.CompactTextString(m) }
func (*SafeSearchAnnotation) ProtoMessage()    {}
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{5}
}

func (m *SafeSearchAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SafeSearchAnnotation.Unmarshal(m, b)
}
func (m *SafeSearchAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SafeSearchAnnotation.Marshal(b, m, deterministic)
}
func (m *SafeSearchAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SafeSearchAnnotation.Merge(m, src)
}
func (m *SafeSearchAnnotation) XXX_Size() int {
	return xxx_messageInfo_SafeSearchAnnotation.Size(m)
}
func (m *SafeSearchAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_SafeSearchAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_SafeSearchAnnotation proto.InternalMessageInfo

func (m *SafeSearchAnnotation) GetAdult() Likelihood {
	if m != nil {
		return m.Adult
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetSpoof() Likelihood {
	if m != nil {
		return m.Spoof
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetMedical() Likelihood {
	if m != nil {
		return m.Medical
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetViolent() Likelihood {
	if m != nil {
		return m.Violent
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetRacy() Likelihood {
	if m != nil {
		return m.Racy
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetTimeOffset() int64 {
	if m != nil {
		return m.TimeOffset
	}
	return 0
}

// Bounding box.
type BoundingBox struct {
	// Left X coordinate.
	Left int32 `protobuf:"varint,1,opt,name=left,proto3" json:"left,omitempty"`
	// Right X coordinate.
	Right int32 `protobuf:"varint,2,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom int32 `protobuf:"varint,3,opt,name=bottom,proto3" json:"bottom,omitempty"`
	// Top Y coordinate.
	Top                  int32    `protobuf:"varint,4,opt,name=top,proto3" json:"top,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoundingBox) Reset()         { *m = BoundingBox{} }
func (m *BoundingBox) String() string { return proto.CompactTextString(m) }
func (*BoundingBox) ProtoMessage()    {}
func (*BoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{6}
}

func (m *BoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoundingBox.Unmarshal(m, b)
}
func (m *BoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoundingBox.Marshal(b, m, deterministic)
}
func (m *BoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoundingBox.Merge(m, src)
}
func (m *BoundingBox) XXX_Size() int {
	return xxx_messageInfo_BoundingBox.Size(m)
}
func (m *BoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_BoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_BoundingBox proto.InternalMessageInfo

func (m *BoundingBox) GetLeft() int32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *BoundingBox) GetRight() int32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *BoundingBox) GetBottom() int32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

func (m *BoundingBox) GetTop() int32 {
	if m != nil {
		return m.Top
	}
	return 0
}

// Face location.
type FaceLocation struct {
	// Bounding box in a frame.
	BoundingBox *BoundingBox `protobuf:"bytes,1,opt,name=bounding_box,json=boundingBox,proto3" json:"bounding_box,omitempty"`
	// Video time offset in microseconds.
	TimeOffset           int64    `protobuf:"varint,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaceLocation) Reset()         { *m = FaceLocation{} }
func (m *FaceLocation) String() string { return proto.CompactTextString(m) }
func (*FaceLocation) ProtoMessage()    {}
func (*FaceLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{7}
}

func (m *FaceLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceLocation.Unmarshal(m, b)
}
func (m *FaceLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceLocation.Marshal(b, m, deterministic)
}
func (m *FaceLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceLocation.Merge(m, src)
}
func (m *FaceLocation) XXX_Size() int {
	return xxx_messageInfo_FaceLocation.Size(m)
}
func (m *FaceLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceLocation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceLocation proto.InternalMessageInfo

func (m *FaceLocation) GetBoundingBox() *BoundingBox {
	if m != nil {
		return m.BoundingBox
	}
	return nil
}

func (m *FaceLocation) GetTimeOffset() int64 {
	if m != nil {
		return m.TimeOffset
	}
	return 0
}

// Face annotation.
type FaceAnnotation struct {
	// Thumbnail of a representative face view (in JPEG format). Encoding: base64.
	Thumbnail string `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// All locations where a face was detected.
	// Faces are detected and tracked on a per-video basis
	// (as opposed to across multiple videos).
	Segments []*VideoSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// Face locations at one frame per second.
	Locations            []*FaceLocation `protobuf:"bytes,3,rep,name=locations,proto3" json:"locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *FaceAnnotation) Reset()         { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()    {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{8}
}

func (m *FaceAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation.Unmarshal(m, b)
}
func (m *FaceAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation.Marshal(b, m, deterministic)
}
func (m *FaceAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation.Merge(m, src)
}
func (m *FaceAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation.Size(m)
}
func (m *FaceAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation proto.InternalMessageInfo

func (m *FaceAnnotation) GetThumbnail() string {
	if m != nil {
		return m.Thumbnail
	}
	return ""
}

func (m *FaceAnnotation) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceAnnotation) GetLocations() []*FaceLocation {
	if m != nil {
		return m.Locations
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations. There is exactly one element for each unique label.
	LabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=label_annotations,json=labelAnnotations,proto3" json:"label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,3,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,4,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Safe search annotations.
	SafeSearchAnnotations []*SafeSearchAnnotation `protobuf:"bytes,6,rep,name=safe_search_annotations,json=safeSearchAnnotations,proto3" json:"safe_search_annotations,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{9}
}

func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(m, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetSafeSearchAnnotations() []*SafeSearchAnnotation {
	if m != nil {
		return m.SafeSearchAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{10}
}

func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(m, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far.
	// Guaranteed to be 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{11}
}

func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(m, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{12}
}

func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(m, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.LabelLevel", LabelLevel_name, LabelLevel_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1beta1.VideoContext")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1beta1.VideoSegment")
	proto.RegisterType((*LabelLocation)(nil), "google.cloud.videointelligence.v1beta1.LabelLocation")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1beta1.LabelAnnotation")
	proto.RegisterType((*SafeSearchAnnotation)(nil), "google.cloud.videointelligence.v1beta1.SafeSearchAnnotation")
	proto.RegisterType((*BoundingBox)(nil), "google.cloud.videointelligence.v1beta1.BoundingBox")
	proto.RegisterType((*FaceLocation)(nil), "google.cloud.videointelligence.v1beta1.FaceLocation")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.videointelligence.v1beta1.FaceAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1beta1.AnnotateVideoProgress")
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1beta1/video_intelligence.proto", fileDescriptor_bda050609d2e9d85)
}

var fileDescriptor_bda050609d2e9d85 = []byte{
	// 1537 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xcb, 0x6f, 0x1b, 0xd5,
	0x1a, 0xef, 0xf8, 0x91, 0xc4, 0x9f, 0x93, 0xd8, 0x39, 0x49, 0x1a, 0xdf, 0xb4, 0xb9, 0x8d, 0xdc,
	0xab, 0x2a, 0xcd, 0x95, 0xec, 0x5b, 0xf7, 0x02, 0xc2, 0x05, 0x2a, 0xc7, 0x19, 0x37, 0x56, 0x1d,
	0x3b, 0x1a, 0x27, 0xa9, 0x8a, 0x2a, 0x8d, 0xc6, 0x33, 0xc7, 0x93, 0x11, 0xe3, 0x39, 0xc3, 0x3c,
	0xa2, 0x76, 0x09, 0x0b, 0x10, 0x4b, 0xc4, 0xbf, 0xc0, 0x0a, 0x09, 0xf8, 0x17, 0xd8, 0xc2, 0x16,
	0x36, 0xac, 0xd8, 0xb0, 0xe2, 0x9f, 0x00, 0x9d, 0xc7, 0xd8, 0x63, 0x3b, 0x50, 0x3b, 0xb0, 0xf3,
	0xf9, 0x1e, 0xbf, 0xef, 0x7d, 0xce, 0x37, 0x86, 0xc7, 0x26, 0x21, 0xa6, 0x8d, 0xcb, 0xba, 0x4d,
	0x42, 0xa3, 0x7c, 0x69, 0x19, 0x98, 0x58, 0x4e, 0x80, 0x6d, 0xdb, 0x32, 0xb1, 0xa3, 0xe3, 0xf2,
	0xe5, 0x83, 0x1e, 0x0e, 0xb4, 0x07, 0x9c, 0xa3, 0xc6, 0x59, 0x25, 0xd7, 0x23, 0x01, 0x41, 0xf7,
	0x38, 0x40, 0x89, 0x01, 0x94, 0xa6, 0x00, 0x4a, 0x02, 0x60, 0xfb, 0xb6, 0x30, 0xa4, 0xb9, 0x56,
	0x59, 0x73, 0x1c, 0x12, 0x68, 0x81, 0x45, 0x1c, 0x9f, 0xa3, 0x6c, 0xdf, 0x15, 0x5c, 0x9b, 0x38,
	0xa6, 0x17, 0x3a, 0x8e, 0xe5, 0x98, 0x65, 0xe2, 0x62, 0x6f, 0x4c, 0xe8, 0x8e, 0x10, 0x62, 0xa7,
	0x5e, 0xd8, 0x2f, 0x07, 0xd6, 0x00, 0xfb, 0x81, 0x36, 0x70, 0x85, 0xc0, 0x96, 0x10, 0xf0, 0x5c,
	0xbd, 0xec, 0x07, 0x5a, 0x10, 0x0a, 0xcd, 0xe2, 0x77, 0x09, 0xd8, 0xa8, 0x71, 0xa3, 0xf8, 0x9c,
	0xba, 0xa8, 0xe0, 0x0f, 0x43, 0xec, 0x07, 0xe8, 0x16, 0x64, 0x2c, 0xc7, 0x0d, 0x03, 0x35, 0xf4,
	0xac, 0x82, 0xb4, 0x2b, 0xed, 0x65, 0x94, 0x25, 0x46, 0x38, 0xf3, 0x2c, 0x74, 0x17, 0x56, 0x38,
	0x53, 0x27, 0x4e, 0x80, 0x9d, 0xa0, 0xb0, 0xc0, 0x04, 0x96, 0x19, 0xb1, 0xce, 0x69, 0xe8, 0x29,
	0x2c, 0xf5, 0xb1, 0x16, 0x84, 0x1e, 0xf6, 0x0b, 0x89, 0xdd, 0xe4, 0xde, 0x6a, 0xa5, 0x5c, 0x9a,
	0x2d, 0x25, 0xa5, 0x06, 0xd7, 0x53, 0x86, 0x00, 0xe8, 0x39, 0xac, 0xf0, 0x44, 0x33, 0x8b, 0x2f,
	0x83, 0x42, 0x72, 0x57, 0xda, 0xcb, 0x56, 0xfe, 0x3f, 0x2b, 0x22, 0x8b, 0xad, 0xce, 0x75, 0x95,
	0xe5, 0xcb, 0xd8, 0x09, 0xed, 0x00, 0x90, 0x30, 0x88, 0x42, 0x4d, 0xb1, 0x48, 0x32, 0x9c, 0x42,
	0x63, 0xbd, 0x03, 0x59, 0x9b, 0xe8, 0x2c, 0xdd, 0xaa, 0x65, 0x14, 0xd2, 0x8c, 0x0f, 0x11, 0xa9,
	0x69, 0x14, 0x7f, 0x49, 0xc2, 0x72, 0x1c, 0x1e, 0x9d, 0xc0, 0x92, 0x8f, 0xcd, 0x01, 0x76, 0x02,
	0xbf, 0x20, 0xed, 0x26, 0xe7, 0x76, 0xb3, 0xcb, 0x95, 0x95, 0x21, 0x0a, 0xb2, 0x61, 0xc3, 0xd6,
	0x7a, 0xd8, 0x56, 0x0d, 0x1c, 0x60, 0x9d, 0xb9, 0x32, 0x20, 0x06, 0x2e, 0x24, 0x76, 0xa5, 0xbd,
	0xd5, 0x4a, 0x75, 0x56, 0xf4, 0x16, 0xc5, 0x38, 0x8c, 0x20, 0x8e, 0x89, 0x81, 0x15, 0x64, 0x4f,
	0xd1, 0xd0, 0x7f, 0x61, 0xcd, 0xe7, 0x4d, 0xa8, 0x79, 0xaf, 0x54, 0x5d, 0x1b, 0x60, 0x4f, 0x63,
	0xf9, 0x5e, 0x52, 0xf2, 0x23, 0x46, 0x9d, 0xd1, 0x51, 0x05, 0x36, 0xaf, 0x72, 0xcd, 0x16, 0x89,
	0x5c, 0x9f, 0xc6, 0xb7, 0xd1, 0xff, 0x60, 0xa3, 0xaf, 0xe9, 0x78, 0x4a, 0x85, 0xe7, 0x16, 0x51,
	0xde, 0x84, 0xc6, 0xbb, 0x70, 0xcb, 0xbf, 0x20, 0x81, 0xaa, 0x5f, 0x68, 0x8e, 0x39, 0xad, 0xc8,
	0xdb, 0xaf, 0x40, 0x45, 0xea, 0x4c, 0xe2, 0x0a, 0x75, 0xad, 0x8f, 0x55, 0x1f, 0x6b, 0x9e, 0x7e,
	0x31, 0xa5, 0xbe, 0x28, 0xd4, 0xb5, 0x3e, 0xee, 0x32, 0x89, 0x71, 0xf5, 0x62, 0x4f, 0x14, 0x58,
	0x14, 0x06, 0xed, 0xb3, 0x04, 0x79, 0x81, 0x4a, 0xc7, 0x4c, 0x25, 0xfd, 0xbe, 0x8f, 0x03, 0x36,
	0x23, 0x49, 0x25, 0xc7, 0x18, 0xa7, 0xd6, 0x00, 0x77, 0x18, 0x19, 0xdd, 0x83, 0x1c, 0x76, 0x8c,
	0x31, 0xc9, 0x04, 0x93, 0x5c, 0xc1, 0x8e, 0x31, 0x92, 0x2b, 0x7e, 0x2f, 0xc1, 0x0a, 0xab, 0x4f,
	0x4b, 0x74, 0x16, 0x6a, 0xc3, 0xa2, 0x68, 0x00, 0x86, 0x7d, 0xdd, 0x2e, 0x8a, 0x40, 0xd0, 0xbf,
	0x01, 0x74, 0xe2, 0xf4, 0x2d, 0x83, 0xca, 0x32, 0x27, 0x12, 0x4a, 0x8c, 0x82, 0x8e, 0x20, 0x6d,
	0xe3, 0x4b, 0x6c, 0xb3, 0x52, 0xaf, 0x56, 0x2a, 0x73, 0x75, 0x55, 0x8b, 0x6a, 0x2a, 0x1c, 0xa0,
	0xf8, 0xb5, 0x04, 0x39, 0x46, 0xad, 0x0d, 0xaf, 0x33, 0xb4, 0x0b, 0x59, 0x03, 0xfb, 0xba, 0x67,
	0xb9, 0xf4, 0x28, 0x6e, 0x94, 0x38, 0x89, 0x5e, 0x2a, 0xb6, 0xe6, 0x98, 0xa1, 0x66, 0x62, 0x55,
	0x8f, 0xba, 0x3b, 0xa3, 0x2c, 0x47, 0xc4, 0x3a, 0xed, 0xcd, 0x2e, 0x64, 0xa2, 0xd1, 0xf3, 0x0b,
	0x49, 0x36, 0x5c, 0x6f, 0xcc, 0xe7, 0xa8, 0xd0, 0x56, 0x46, 0x38, 0xc5, 0x6f, 0x93, 0xb0, 0xd1,
	0x1d, 0x16, 0x3f, 0xe6, 0xf4, 0x11, 0xa4, 0x35, 0x23, 0xb4, 0x79, 0x01, 0xe6, 0x49, 0x89, 0xf5,
	0x01, 0xb6, 0xad, 0x0b, 0x42, 0x0c, 0x85, 0x03, 0x50, 0x24, 0xdf, 0x25, 0xa4, 0x2f, 0x46, 0xf6,
	0x5a, 0x48, 0x0c, 0x00, 0xb5, 0x60, 0x71, 0x80, 0x0d, 0x4b, 0xd7, 0xe6, 0x2f, 0xd4, 0x08, 0x2b,
	0x82, 0xa0, 0x68, 0x97, 0x16, 0xb1, 0x69, 0x93, 0xa5, 0xae, 0x8f, 0x26, 0x20, 0x50, 0x03, 0x52,
	0x9e, 0xa6, 0xbf, 0x62, 0x83, 0x7c, 0x3d, 0x28, 0xa6, 0x4f, 0xef, 0xdc, 0xf8, 0xc0, 0x2c, 0xb0,
	0x81, 0x81, 0x60, 0x34, 0x2d, 0x1a, 0x64, 0x0f, 0x48, 0xe8, 0x18, 0x96, 0x63, 0x1e, 0x90, 0x97,
	0x08, 0x41, 0xca, 0xc6, 0x7d, 0x5e, 0xa6, 0xb4, 0xc2, 0x7e, 0xa3, 0x0d, 0x48, 0x7b, 0x96, 0x79,
	0xc1, 0xc7, 0x2d, 0xad, 0xf0, 0x03, 0xba, 0x09, 0x0b, 0x3d, 0x12, 0x04, 0x64, 0xc0, 0x92, 0x97,
	0x56, 0xc4, 0x09, 0xe5, 0x21, 0x19, 0x10, 0x97, 0xe5, 0x20, 0xad, 0xd0, 0x9f, 0xc5, 0x4f, 0x25,
	0x58, 0x6e, 0x68, 0x3a, 0x1e, 0xce, 0xe3, 0x39, 0x2c, 0xf7, 0x84, 0x4d, 0xb5, 0x47, 0x5e, 0x8a,
	0xa1, 0x7c, 0x38, 0x6b, 0x90, 0x31, 0x7f, 0x95, 0x6c, 0x2f, 0xe6, 0xfc, 0x44, 0xb0, 0x89, 0xa9,
	0x60, 0x7f, 0x92, 0x60, 0x95, 0x7a, 0x12, 0x6b, 0xcc, 0xdb, 0x90, 0x09, 0x2e, 0xc2, 0x41, 0xcf,
	0xd1, 0x2c, 0x5b, 0xcc, 0xd2, 0x88, 0x30, 0xf6, 0x00, 0x25, 0xfe, 0x91, 0x07, 0x48, 0x99, 0x1e,
	0xbb, 0x99, 0x21, 0xe3, 0x49, 0x8c, 0x4f, 0xdd, 0xef, 0x49, 0xb8, 0xc9, 0xcc, 0x8d, 0xe2, 0x52,
	0xb0, 0x1f, 0xda, 0x81, 0xff, 0xd7, 0xcb, 0x87, 0x01, 0x6b, 0xfc, 0xc5, 0x89, 0x2d, 0x4b, 0x22,
	0xcc, 0xb7, 0xe6, 0xba, 0x0a, 0x62, 0x76, 0xf3, 0xf6, 0x38, 0xc1, 0x47, 0x1a, 0xe4, 0xd9, 0x1b,
	0x15, 0x37, 0xc2, 0x03, 0x7f, 0x73, 0x9e, 0xc0, 0x63, 0x36, 0x72, 0xfd, 0xb1, 0xb3, 0x8f, 0x54,
	0xc8, 0xb3, 0x47, 0x2d, 0x6e, 0x22, 0xf5, 0x37, 0xca, 0x95, 0xa3, 0x68, 0x71, 0x03, 0x01, 0x6c,
	0xc5, 0x9f, 0xbd, 0xb8, 0x9d, 0x05, 0x66, 0xe7, 0x9d, 0x59, 0xed, 0x5c, 0x75, 0x3b, 0x2a, 0x9b,
	0xfe, 0x15, 0x54, 0x1f, 0xed, 0x41, 0x1a, 0x7b, 0x1e, 0xf1, 0xd8, 0x2d, 0x90, 0xad, 0xa0, 0xc8,
	0x86, 0xe7, 0xea, 0xa5, 0x2e, 0xdb, 0x3d, 0x15, 0x2e, 0x50, 0xfc, 0x44, 0x82, 0xcd, 0x89, 0xe5,
	0xd3, 0x77, 0x89, 0xe3, 0x63, 0x34, 0x00, 0x34, 0xf2, 0x56, 0xf5, 0x78, 0x5b, 0x88, 0x65, 0xea,
	0xbd, 0xb9, 0x92, 0x33, 0xd5, 0x5c, 0xca, 0x9a, 0x36, 0x49, 0x2a, 0xfe, 0x2c, 0xc1, 0xd6, 0x84,
	0xf4, 0x89, 0x47, 0x4c, 0x0f, 0xfb, 0xaf, 0xe9, 0xc5, 0xfb, 0x90, 0x77, 0x85, 0xa0, 0xea, 0x62,
	0x4f, 0xa7, 0xf7, 0x28, 0xbf, 0x6f, 0x72, 0x11, 0xfd, 0x84, 0x93, 0xd1, 0xdb, 0x00, 0xa3, 0xa5,
	0x41, 0xac, 0xaf, 0xdb, 0x51, 0x28, 0xd1, 0xe2, 0x5e, 0x3a, 0x8d, 0x16, 0x77, 0x25, 0x33, 0xdc,
	0x24, 0xd0, 0x23, 0xc8, 0x86, 0xae, 0xa1, 0x05, 0x98, 0xeb, 0xa6, 0x5e, 0xab, 0x0b, 0x5c, 0x9c,
	0x12, 0x8a, 0x9f, 0x4d, 0x26, 0x79, 0x18, 0x99, 0x0b, 0xeb, 0xb1, 0x24, 0x47, 0xfe, 0x8a, 0x2c,
	0x3f, 0xbe, 0x66, 0x96, 0x23, 0x74, 0x25, 0x56, 0xc0, 0x88, 0xb6, 0xff, 0x91, 0x04, 0x8b, 0x62,
	0xb7, 0x47, 0x5b, 0xb0, 0xde, 0x90, 0x6b, 0xa7, 0x67, 0x8a, 0xac, 0x9e, 0xb5, 0xbb, 0x27, 0x72,
	0xbd, 0xd9, 0x68, 0xca, 0x87, 0xf9, 0x1b, 0x68, 0x1d, 0x72, 0xad, 0xda, 0x81, 0xdc, 0x52, 0x0f,
	0xe5, 0x53, 0xb9, 0x7e, 0xda, 0xec, 0xb4, 0xf3, 0x12, 0x42, 0xb0, 0xda, 0xa8, 0xd5, 0xe5, 0x18,
	0x2d, 0x81, 0xfe, 0x05, 0x9b, 0xdd, 0xa3, 0xce, 0xa9, 0x5a, 0x3f, 0xaa, 0xb5, 0x9f, 0xc4, 0x59,
	0x49, 0xc6, 0xaa, 0x35, 0x64, 0xb5, 0x2b, 0xd7, 0x94, 0xfa, 0x51, 0x8c, 0x95, 0xda, 0x77, 0x00,
	0x46, 0x1b, 0x0b, 0xba, 0x05, 0x5b, 0xdc, 0x58, 0x4b, 0x3e, 0x97, 0x5b, 0x13, 0x9e, 0xe4, 0x20,
	0x7b, 0xde, 0x3c, 0x94, 0x3b, 0x9c, 0x99, 0x97, 0xd0, 0x1a, 0xac, 0x74, 0xe5, 0x27, 0xc7, 0x72,
	0xfb, 0x54, 0x90, 0x12, 0x68, 0x15, 0x80, 0x39, 0xc1, 0xcf, 0x49, 0xaa, 0xd3, 0x50, 0x6a, 0xc7,
	0xb2, 0x20, 0xa4, 0xf6, 0x3d, 0x40, 0xd3, 0x7b, 0x37, 0xfa, 0x0f, 0xec, 0x4e, 0x04, 0xa9, 0x1e,
	0x77, 0x0e, 0x27, 0x53, 0xb1, 0x02, 0x19, 0x06, 0x4e, 0x59, 0x79, 0x89, 0xda, 0xe2, 0xd8, 0xec,
	0x9c, 0xa0, 0x29, 0x64, 0xec, 0x5a, 0xfb, 0x50, 0x8d, 0x31, 0x92, 0xfb, 0x18, 0x60, 0xf4, 0xa6,
	0xa2, 0x2c, 0x2c, 0x9e, 0xb5, 0x9f, 0xb6, 0x3b, 0xcf, 0xda, 0xf9, 0x1b, 0x34, 0x84, 0x73, 0x59,
	0x79, 0xae, 0x9e, 0xb5, 0x5b, 0xcd, 0xa7, 0x72, 0xeb, 0x79, 0x5e, 0x42, 0xcb, 0xb0, 0x34, 0x3c,
	0x25, 0xe8, 0xe9, 0xa4, 0xd3, 0xed, 0x36, 0x0f, 0x5a, 0x72, 0x3e, 0x89, 0x00, 0x16, 0x04, 0x27,
	0xc5, 0xd2, 0x41, 0x55, 0x05, 0x21, 0x5d, 0xf9, 0x46, 0x82, 0x02, 0x2b, 0x7f, 0x33, 0xd6, 0x18,
	0x5d, 0xec, 0x5d, 0x5a, 0x3a, 0x46, 0x9f, 0x4b, 0xb0, 0x32, 0xd6, 0x77, 0x68, 0xe6, 0xdb, 0xe6,
	0xaa, 0x0f, 0xd2, 0xed, 0x9d, 0x48, 0x3b, 0xf6, 0x25, 0x5c, 0xea, 0x44, 0x5f, 0xc2, 0xc5, 0xbb,
	0x1f, 0xff, 0xf8, 0xeb, 0x17, 0x89, 0x9d, 0x62, 0x61, 0xfc, 0xc3, 0xdc, 0xaf, 0x8a, 0x36, 0xc4,
	0x55, 0x69, 0xff, 0xe0, 0xcb, 0x04, 0xec, 0xeb, 0x64, 0x30, 0xa3, 0x1f, 0x07, 0x3b, 0x7f, 0x16,
	0xdc, 0x09, 0x1d, 0xb9, 0x13, 0xe9, 0xfd, 0x67, 0x02, 0xc8, 0x24, 0x74, 0x49, 0x2d, 0x11, 0xcf,
	0x2c, 0x9b, 0xd8, 0x61, 0x03, 0x59, 0xe6, 0x2c, 0xcd, 0xb5, 0xfc, 0xd7, 0xfd, 0x85, 0xf0, 0x68,
	0x8a, 0xf3, 0x55, 0xe2, 0xde, 0x13, 0x8e, 0x5c, 0x67, 0x2e, 0x4e, 0xf9, 0x51, 0x3a, 0x7f, 0x70,
	0x40, 0x55, 0x7f, 0x88, 0x04, 0x5f, 0x30, 0xc1, 0x17, 0x53, 0x82, 0x2f, 0xce, 0xb9, 0x8d, 0xdf,
	0x12, 0xf7, 0xb9, 0x60, 0xb5, 0xca, 0x24, 0xab, 0xd5, 0x29, 0xd1, 0x6a, 0x55, 0xc8, 0xf6, 0x16,
	0x58, 0x04, 0x0f, 0xff, 0x08, 0x00, 0x00, 0xff, 0xff, 0x2b, 0xad, 0x21, 0xb6, 0x03, 0x11, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1beta1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

// UnimplementedVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoIntelligenceServiceServer struct {
}

func (*UnimplementedVideoIntelligenceServiceServer) AnnotateVideo(ctx context.Context, req *AnnotateVideoRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnnotateVideo not implemented")
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1beta1/video_intelligence.proto",
}
