// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/tenant_service.proto

package talent

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The Request of the CreateTenant method.
type CreateTenantRequest struct {
	// Required. Resource name of the project under which the tenant is created.
	//
	// The format is "projects/{project_id}", for example,
	// "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The tenant to be created.
	Tenant               *Tenant  `protobuf:"bytes,2,opt,name=tenant,proto3" json:"tenant,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTenantRequest) Reset()         { *m = CreateTenantRequest{} }
func (m *CreateTenantRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTenantRequest) ProtoMessage()    {}
func (*CreateTenantRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{0}
}

func (m *CreateTenantRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTenantRequest.Unmarshal(m, b)
}
func (m *CreateTenantRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTenantRequest.Marshal(b, m, deterministic)
}
func (m *CreateTenantRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTenantRequest.Merge(m, src)
}
func (m *CreateTenantRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTenantRequest.Size(m)
}
func (m *CreateTenantRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTenantRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTenantRequest proto.InternalMessageInfo

func (m *CreateTenantRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTenantRequest) GetTenant() *Tenant {
	if m != nil {
		return m.Tenant
	}
	return nil
}

// Request for getting a tenant by name.
type GetTenantRequest struct {
	// Required. The resource name of the tenant to be retrieved.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/foo/tenants/bar".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTenantRequest) Reset()         { *m = GetTenantRequest{} }
func (m *GetTenantRequest) String() string { return proto.CompactTextString(m) }
func (*GetTenantRequest) ProtoMessage()    {}
func (*GetTenantRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{1}
}

func (m *GetTenantRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTenantRequest.Unmarshal(m, b)
}
func (m *GetTenantRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTenantRequest.Marshal(b, m, deterministic)
}
func (m *GetTenantRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTenantRequest.Merge(m, src)
}
func (m *GetTenantRequest) XXX_Size() int {
	return xxx_messageInfo_GetTenantRequest.Size(m)
}
func (m *GetTenantRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTenantRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTenantRequest proto.InternalMessageInfo

func (m *GetTenantRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for updating a specified tenant.
type UpdateTenantRequest struct {
	// Required. The tenant resource to replace the current resource in the
	// system.
	Tenant *Tenant `protobuf:"bytes,1,opt,name=tenant,proto3" json:"tenant,omitempty"`
	// Strongly recommended for the best service experience.
	//
	// If
	// [update_mask][google.cloud.talent.v4beta1.UpdateTenantRequest.update_mask]
	// is provided, only the specified fields in
	// [tenant][google.cloud.talent.v4beta1.UpdateTenantRequest.tenant] are
	// updated. Otherwise all the fields are updated.
	//
	// A field mask to specify the tenant fields to be updated. Only
	// top level fields of [Tenant][google.cloud.talent.v4beta1.Tenant] are
	// supported.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTenantRequest) Reset()         { *m = UpdateTenantRequest{} }
func (m *UpdateTenantRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTenantRequest) ProtoMessage()    {}
func (*UpdateTenantRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{2}
}

func (m *UpdateTenantRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTenantRequest.Unmarshal(m, b)
}
func (m *UpdateTenantRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTenantRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTenantRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTenantRequest.Merge(m, src)
}
func (m *UpdateTenantRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTenantRequest.Size(m)
}
func (m *UpdateTenantRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTenantRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTenantRequest proto.InternalMessageInfo

func (m *UpdateTenantRequest) GetTenant() *Tenant {
	if m != nil {
		return m.Tenant
	}
	return nil
}

func (m *UpdateTenantRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to delete a tenant.
type DeleteTenantRequest struct {
	// Required. The resource name of the tenant to be deleted.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/foo/tenants/bar".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTenantRequest) Reset()         { *m = DeleteTenantRequest{} }
func (m *DeleteTenantRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTenantRequest) ProtoMessage()    {}
func (*DeleteTenantRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{3}
}

func (m *DeleteTenantRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTenantRequest.Unmarshal(m, b)
}
func (m *DeleteTenantRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTenantRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTenantRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTenantRequest.Merge(m, src)
}
func (m *DeleteTenantRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTenantRequest.Size(m)
}
func (m *DeleteTenantRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTenantRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTenantRequest proto.InternalMessageInfo

func (m *DeleteTenantRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// List tenants for which the client has ACL visibility.
type ListTenantsRequest struct {
	// Required. Resource name of the project under which the tenant is created.
	//
	// The format is "projects/{project_id}", for example,
	// "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The starting indicator from which to return results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of tenants to be returned, at most 100.
	// Default is 100 if a non-positive number is provided.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTenantsRequest) Reset()         { *m = ListTenantsRequest{} }
func (m *ListTenantsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTenantsRequest) ProtoMessage()    {}
func (*ListTenantsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{4}
}

func (m *ListTenantsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTenantsRequest.Unmarshal(m, b)
}
func (m *ListTenantsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTenantsRequest.Marshal(b, m, deterministic)
}
func (m *ListTenantsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTenantsRequest.Merge(m, src)
}
func (m *ListTenantsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTenantsRequest.Size(m)
}
func (m *ListTenantsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTenantsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTenantsRequest proto.InternalMessageInfo

func (m *ListTenantsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTenantsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTenantsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The List tenants response object.
type ListTenantsResponse struct {
	// Tenants for the current client.
	Tenants []*Tenant `protobuf:"bytes,1,rep,name=tenants,proto3" json:"tenants,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata             *ResponseMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListTenantsResponse) Reset()         { *m = ListTenantsResponse{} }
func (m *ListTenantsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTenantsResponse) ProtoMessage()    {}
func (*ListTenantsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2df49c13fa187082, []int{5}
}

func (m *ListTenantsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTenantsResponse.Unmarshal(m, b)
}
func (m *ListTenantsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTenantsResponse.Marshal(b, m, deterministic)
}
func (m *ListTenantsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTenantsResponse.Merge(m, src)
}
func (m *ListTenantsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTenantsResponse.Size(m)
}
func (m *ListTenantsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTenantsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTenantsResponse proto.InternalMessageInfo

func (m *ListTenantsResponse) GetTenants() []*Tenant {
	if m != nil {
		return m.Tenants
	}
	return nil
}

func (m *ListTenantsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListTenantsResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateTenantRequest)(nil), "google.cloud.talent.v4beta1.CreateTenantRequest")
	proto.RegisterType((*GetTenantRequest)(nil), "google.cloud.talent.v4beta1.GetTenantRequest")
	proto.RegisterType((*UpdateTenantRequest)(nil), "google.cloud.talent.v4beta1.UpdateTenantRequest")
	proto.RegisterType((*DeleteTenantRequest)(nil), "google.cloud.talent.v4beta1.DeleteTenantRequest")
	proto.RegisterType((*ListTenantsRequest)(nil), "google.cloud.talent.v4beta1.ListTenantsRequest")
	proto.RegisterType((*ListTenantsResponse)(nil), "google.cloud.talent.v4beta1.ListTenantsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/tenant_service.proto", fileDescriptor_2df49c13fa187082)
}

var fileDescriptor_2df49c13fa187082 = []byte{
	// 724 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x95, 0xcf, 0x6e, 0xd3, 0x4a,
	0x14, 0xc6, 0x35, 0xc9, 0xbd, 0xb9, 0xcd, 0xa4, 0xd5, 0xbd, 0x9a, 0x48, 0xb7, 0x51, 0x0a, 0x6a,
	0x64, 0x50, 0x15, 0xd2, 0xd6, 0x13, 0x02, 0x62, 0xd1, 0xaa, 0x12, 0x69, 0xf9, 0x23, 0x24, 0x2a,
	0x55, 0x4e, 0xd9, 0xb0, 0x89, 0x26, 0xce, 0xd4, 0x75, 0x6b, 0xcf, 0x18, 0xcf, 0xa4, 0x85, 0xa2,
	0x4a, 0x88, 0x05, 0x3b, 0x56, 0x20, 0x76, 0xb0, 0xe0, 0x65, 0x90, 0x58, 0xc2, 0x0b, 0xb0, 0xe0,
	0x01, 0x78, 0x04, 0x64, 0xcf, 0x24, 0x75, 0x93, 0xd4, 0xb5, 0xd8, 0xc5, 0x33, 0xe7, 0x3b, 0xe7,
	0x77, 0x8e, 0xcf, 0x17, 0xc3, 0xa6, 0xc3, 0xb9, 0xe3, 0x51, 0x6c, 0x7b, 0x7c, 0xd0, 0xc7, 0x92,
	0x78, 0x94, 0x49, 0x7c, 0x74, 0xbb, 0x47, 0x25, 0xb9, 0x89, 0x25, 0x65, 0x84, 0xc9, 0xae, 0xa0,
	0xe1, 0x91, 0x6b, 0x53, 0x33, 0x08, 0xb9, 0xe4, 0x68, 0x41, 0x29, 0xcc, 0x58, 0x61, 0x2a, 0x85,
	0xa9, 0x15, 0xd5, 0x2b, 0x3a, 0x1d, 0x09, 0x5c, 0x4c, 0x18, 0xe3, 0x92, 0x48, 0x97, 0x33, 0xa1,
	0xa4, 0xd5, 0xf9, 0xc4, 0xad, 0xed, 0xb9, 0x91, 0x50, 0x5d, 0x2c, 0x26, 0x2e, 0xf6, 0x5c, 0xea,
	0xf5, 0xbb, 0x3d, 0xba, 0x4f, 0x8e, 0x5c, 0x1e, 0xea, 0x80, 0x7a, 0x1a, 0xa6, 0xcd, 0x7d, 0x9f,
	0xb3, 0x2c, 0x91, 0xaa, 0x21, 0x1d, 0xa9, 0x1b, 0xc1, 0xf1, 0x53, 0x6f, 0xb0, 0x87, 0xa9, 0x1f,
	0xc8, 0x17, 0xfa, 0xb2, 0x36, 0x7e, 0xa9, 0xb0, 0x7c, 0x22, 0x0e, 0x55, 0x84, 0x21, 0x61, 0x79,
	0x2b, 0xa4, 0x44, 0xd2, 0xdd, 0x38, 0xa9, 0x45, 0x9f, 0x0d, 0xa8, 0x90, 0x68, 0x01, 0x16, 0x02,
	0x12, 0x52, 0x26, 0x2b, 0xa0, 0x06, 0xea, 0xc5, 0xcd, 0xfc, 0x8f, 0x76, 0xce, 0xd2, 0x47, 0xe8,
	0x2e, 0x2c, 0x28, 0x84, 0x4a, 0xae, 0x06, 0xea, 0xa5, 0xd6, 0x35, 0x33, 0x65, 0x98, 0xa6, 0x4a,
	0xac, 0x33, 0x28, 0x9d, 0xb1, 0x0c, 0xff, 0x7b, 0x48, 0xe5, 0xf9, 0x92, 0xf3, 0xf0, 0x2f, 0x46,
	0x7c, 0x9a, 0x2c, 0x18, 0x1f, 0x18, 0xef, 0x01, 0x2c, 0x3f, 0x09, 0xfa, 0x13, 0x8c, 0x67, 0x18,
	0xe0, 0xcf, 0x30, 0xd0, 0x3a, 0x2c, 0x0d, 0xe2, 0xc4, 0xf1, 0x44, 0x74, 0x37, 0xd5, 0x61, 0x9a,
	0xe1, 0xd0, 0xcc, 0x07, 0xd1, 0xd0, 0xb6, 0x89, 0x38, 0xb4, 0xa0, 0x0a, 0x8f, 0x7e, 0x1b, 0x26,
	0x2c, 0xdf, 0xa3, 0x1e, 0x1d, 0xa7, 0xba, 0xb0, 0x0d, 0x1f, 0xa2, 0xc7, 0xae, 0xd0, 0x4d, 0x8b,
	0x4c, 0x83, 0xbe, 0x0a, 0x61, 0x40, 0x1c, 0xda, 0x95, 0xfc, 0x90, 0xb2, 0x18, 0xaf, 0x68, 0x15,
	0xa3, 0x93, 0xdd, 0xe8, 0x00, 0x2d, 0xc0, 0xf8, 0xa1, 0x2b, 0xdc, 0x13, 0x5a, 0xc9, 0xd7, 0x40,
	0xfd, 0x6f, 0x6b, 0x26, 0x3a, 0xe8, 0xb8, 0x27, 0xd4, 0xf8, 0x02, 0x60, 0xf9, 0x5c, 0x3d, 0x11,
	0x70, 0x26, 0x28, 0xda, 0x80, 0xff, 0xa8, 0xee, 0x45, 0x05, 0xd4, 0xf2, 0x19, 0xc7, 0x66, 0x0d,
	0x35, 0x68, 0x09, 0xfe, 0xcb, 0xe8, 0x73, 0xd9, 0x9d, 0xe0, 0x9a, 0x8b, 0x8e, 0x77, 0x46, 0x6c,
	0x8f, 0xe0, 0x8c, 0x4f, 0x25, 0xe9, 0x13, 0x49, 0x62, 0xb4, 0x52, 0x6b, 0x35, 0xb5, 0xce, 0x90,
	0x6f, 0x5b, 0x8b, 0xac, 0x91, 0xbc, 0xf5, 0xab, 0x00, 0xe7, 0x14, 0x46, 0x47, 0x59, 0x18, 0x7d,
	0x00, 0x70, 0x36, 0xb9, 0xb5, 0xa8, 0x99, 0x9a, 0x7b, 0xca, 0x82, 0x57, 0xb3, 0x74, 0x6d, 0xe0,
	0xd7, 0xdf, 0x7f, 0xbe, 0xcb, 0xdd, 0x30, 0xae, 0x8f, 0xac, 0xf7, 0x52, 0xbd, 0x99, 0x8d, 0x20,
	0xe4, 0x07, 0xd4, 0x96, 0x02, 0x37, 0x4e, 0xb5, 0x1d, 0xc5, 0x1a, 0x68, 0xa0, 0xb7, 0x00, 0x16,
	0x47, 0x8b, 0x8d, 0xd2, 0x3b, 0x1e, 0x37, 0x40, 0x36, 0xa4, 0x95, 0x18, 0x69, 0x09, 0x25, 0x90,
	0xa2, 0xed, 0x4a, 0x00, 0x0d, 0x79, 0x70, 0xe3, 0x14, 0x7d, 0x04, 0x70, 0x36, 0x69, 0x9d, 0x4b,
	0x06, 0x35, 0xc5, 0x65, 0xd9, 0xa8, 0xee, 0xc4, 0x54, 0xcd, 0xd6, 0xf2, 0x19, 0x95, 0xfe, 0x93,
	0xba, 0x18, 0x2e, 0x9a, 0xd7, 0x1b, 0x00, 0x67, 0x93, 0x26, 0xba, 0x84, 0x6f, 0x8a, 0xdf, 0xaa,
	0xff, 0x4f, 0xd8, 0xf5, 0x7e, 0xf4, 0x07, 0x38, 0x1c, 0x54, 0x23, 0xdb, 0xa0, 0x3e, 0x01, 0x58,
	0x4a, 0xb8, 0x05, 0xe1, 0x54, 0x8e, 0x49, 0x1f, 0x57, 0x9b, 0xd9, 0x05, 0x6a, 0xd1, 0xa7, 0xbd,
	0xc9, 0x8b, 0x97, 0xab, 0xea, 0x7d, 0x6d, 0x97, 0x0f, 0x78, 0x4f, 0xe8, 0x32, 0x24, 0x70, 0x85,
	0x69, 0x73, 0xff, 0x5b, 0xbb, 0xb3, 0x2f, 0x65, 0x20, 0xd6, 0x30, 0x3e, 0x3e, 0x3e, 0x1e, 0xbb,
	0xc4, 0x64, 0x20, 0xf7, 0xd5, 0x27, 0x64, 0x35, 0xf0, 0x88, 0xdc, 0xe3, 0xa1, 0xbf, 0x72, 0x59,
	0x78, 0x54, 0x64, 0xf3, 0x15, 0x80, 0x8b, 0x36, 0xf7, 0xd3, 0x7a, 0xda, 0x44, 0xe7, 0x3c, 0xb9,
	0x13, 0x4d, 0x7f, 0x07, 0x3c, 0x6d, 0x6b, 0x89, 0xc3, 0x3d, 0xc2, 0x1c, 0x93, 0x87, 0x0e, 0x76,
	0x28, 0x8b, 0xdf, 0x0d, 0x3e, 0x2b, 0x37, 0xf5, 0xbb, 0xb6, 0xae, 0x1e, 0x3f, 0xe7, 0xf2, 0x5b,
	0xbb, 0x9d, 0x5e, 0x21, 0xd6, 0xdc, 0xfa, 0x1d, 0x00, 0x00, 0xff, 0xff, 0xcd, 0xd4, 0x9d, 0xd0,
	0xdb, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TenantServiceClient is the client API for TenantService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TenantServiceClient interface {
	// Creates a new tenant entity.
	CreateTenant(ctx context.Context, in *CreateTenantRequest, opts ...grpc.CallOption) (*Tenant, error)
	// Retrieves specified tenant.
	GetTenant(ctx context.Context, in *GetTenantRequest, opts ...grpc.CallOption) (*Tenant, error)
	// Updates specified tenant.
	UpdateTenant(ctx context.Context, in *UpdateTenantRequest, opts ...grpc.CallOption) (*Tenant, error)
	// Deletes specified tenant.
	DeleteTenant(ctx context.Context, in *DeleteTenantRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists all tenants associated with the project.
	ListTenants(ctx context.Context, in *ListTenantsRequest, opts ...grpc.CallOption) (*ListTenantsResponse, error)
}

type tenantServiceClient struct {
	cc *grpc.ClientConn
}

func NewTenantServiceClient(cc *grpc.ClientConn) TenantServiceClient {
	return &tenantServiceClient{cc}
}

func (c *tenantServiceClient) CreateTenant(ctx context.Context, in *CreateTenantRequest, opts ...grpc.CallOption) (*Tenant, error) {
	out := new(Tenant)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/CreateTenant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenantServiceClient) GetTenant(ctx context.Context, in *GetTenantRequest, opts ...grpc.CallOption) (*Tenant, error) {
	out := new(Tenant)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/GetTenant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenantServiceClient) UpdateTenant(ctx context.Context, in *UpdateTenantRequest, opts ...grpc.CallOption) (*Tenant, error) {
	out := new(Tenant)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/UpdateTenant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenantServiceClient) DeleteTenant(ctx context.Context, in *DeleteTenantRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/DeleteTenant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tenantServiceClient) ListTenants(ctx context.Context, in *ListTenantsRequest, opts ...grpc.CallOption) (*ListTenantsResponse, error) {
	out := new(ListTenantsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.TenantService/ListTenants", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TenantServiceServer is the server API for TenantService service.
type TenantServiceServer interface {
	// Creates a new tenant entity.
	CreateTenant(context.Context, *CreateTenantRequest) (*Tenant, error)
	// Retrieves specified tenant.
	GetTenant(context.Context, *GetTenantRequest) (*Tenant, error)
	// Updates specified tenant.
	UpdateTenant(context.Context, *UpdateTenantRequest) (*Tenant, error)
	// Deletes specified tenant.
	DeleteTenant(context.Context, *DeleteTenantRequest) (*empty.Empty, error)
	// Lists all tenants associated with the project.
	ListTenants(context.Context, *ListTenantsRequest) (*ListTenantsResponse, error)
}

// UnimplementedTenantServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTenantServiceServer struct {
}

func (*UnimplementedTenantServiceServer) CreateTenant(ctx context.Context, req *CreateTenantRequest) (*Tenant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTenant not implemented")
}
func (*UnimplementedTenantServiceServer) GetTenant(ctx context.Context, req *GetTenantRequest) (*Tenant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTenant not implemented")
}
func (*UnimplementedTenantServiceServer) UpdateTenant(ctx context.Context, req *UpdateTenantRequest) (*Tenant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTenant not implemented")
}
func (*UnimplementedTenantServiceServer) DeleteTenant(ctx context.Context, req *DeleteTenantRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTenant not implemented")
}
func (*UnimplementedTenantServiceServer) ListTenants(ctx context.Context, req *ListTenantsRequest) (*ListTenantsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTenants not implemented")
}

func RegisterTenantServiceServer(s *grpc.Server, srv TenantServiceServer) {
	s.RegisterService(&_TenantService_serviceDesc, srv)
}

func _TenantService_CreateTenant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTenantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).CreateTenant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/CreateTenant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).CreateTenant(ctx, req.(*CreateTenantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TenantService_GetTenant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTenantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).GetTenant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/GetTenant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).GetTenant(ctx, req.(*GetTenantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TenantService_UpdateTenant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTenantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).UpdateTenant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/UpdateTenant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).UpdateTenant(ctx, req.(*UpdateTenantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TenantService_DeleteTenant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTenantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).DeleteTenant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/DeleteTenant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).DeleteTenant(ctx, req.(*DeleteTenantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TenantService_ListTenants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTenantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantServiceServer).ListTenants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.TenantService/ListTenants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantServiceServer).ListTenants(ctx, req.(*ListTenantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TenantService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.TenantService",
	HandlerType: (*TenantServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTenant",
			Handler:    _TenantService_CreateTenant_Handler,
		},
		{
			MethodName: "GetTenant",
			Handler:    _TenantService_GetTenant_Handler,
		},
		{
			MethodName: "UpdateTenant",
			Handler:    _TenantService_UpdateTenant_Handler,
		},
		{
			MethodName: "DeleteTenant",
			Handler:    _TenantService_DeleteTenant_Handler,
		},
		{
			MethodName: "ListTenants",
			Handler:    _TenantService_ListTenants_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/tenant_service.proto",
}
