// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/redis/v1beta1/cloud_redis.proto

package redis

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents the different states of a Redis instance.
type Instance_State int32

const (
	// Not set.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// Redis instance is being created.
	Instance_CREATING Instance_State = 1
	// Redis instance has been created and is fully usable.
	Instance_READY Instance_State = 2
	// Redis instance configuration is being updated. Certain kinds of updates
	// may cause the instance to become unusable while the update is in
	// progress.
	Instance_UPDATING Instance_State = 3
	// Redis instance is being deleted.
	Instance_DELETING Instance_State = 4
	// Redis instance is being repaired and may be unusable.
	Instance_REPAIRING Instance_State = 5
	// Maintenance is being performed on this Redis instance.
	Instance_MAINTENANCE Instance_State = 6
	// Redis instance is importing data (availability may be affected).
	Instance_IMPORTING Instance_State = 8
	// Redis instance is failing over (availability may be affected).
	Instance_FAILING_OVER Instance_State = 10
)

var Instance_State_name = map[int32]string{
	0:  "STATE_UNSPECIFIED",
	1:  "CREATING",
	2:  "READY",
	3:  "UPDATING",
	4:  "DELETING",
	5:  "REPAIRING",
	6:  "MAINTENANCE",
	8:  "IMPORTING",
	10: "FAILING_OVER",
}

var Instance_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
	"UPDATING":          3,
	"DELETING":          4,
	"REPAIRING":         5,
	"MAINTENANCE":       6,
	"IMPORTING":         8,
	"FAILING_OVER":      10,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}

func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{0, 0}
}

// Available service tiers to choose from
type Instance_Tier int32

const (
	// Not set.
	Instance_TIER_UNSPECIFIED Instance_Tier = 0
	// BASIC tier: standalone instance
	Instance_BASIC Instance_Tier = 1
	// STANDARD_HA tier: highly available primary/replica instances
	Instance_STANDARD_HA Instance_Tier = 3
)

var Instance_Tier_name = map[int32]string{
	0: "TIER_UNSPECIFIED",
	1: "BASIC",
	3: "STANDARD_HA",
}

var Instance_Tier_value = map[string]int32{
	"TIER_UNSPECIFIED": 0,
	"BASIC":            1,
	"STANDARD_HA":      3,
}

func (x Instance_Tier) String() string {
	return proto.EnumName(Instance_Tier_name, int32(x))
}

func (Instance_Tier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{0, 1}
}

type FailoverInstanceRequest_DataProtectionMode int32

const (
	// Defaults to LIMITED_DATA_LOSS if a data protection mode is not
	// specified.
	FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED FailoverInstanceRequest_DataProtectionMode = 0
	// Instance failover will be protected with data loss control. More
	// specifically, the failover will only be performed if the current
	// replication offset diff between master and replica is under a certain
	// threshold.
	FailoverInstanceRequest_LIMITED_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 1
	// Instance failover will be performed without data loss control.
	FailoverInstanceRequest_FORCE_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 2
)

var FailoverInstanceRequest_DataProtectionMode_name = map[int32]string{
	0: "DATA_PROTECTION_MODE_UNSPECIFIED",
	1: "LIMITED_DATA_LOSS",
	2: "FORCE_DATA_LOSS",
}

var FailoverInstanceRequest_DataProtectionMode_value = map[string]int32{
	"DATA_PROTECTION_MODE_UNSPECIFIED": 0,
	"LIMITED_DATA_LOSS":                1,
	"FORCE_DATA_LOSS":                  2,
}

func (x FailoverInstanceRequest_DataProtectionMode) String() string {
	return proto.EnumName(FailoverInstanceRequest_DataProtectionMode_name, int32(x))
}

func (FailoverInstanceRequest_DataProtectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{13, 0}
}

// A Google Cloud Redis instance.
type Instance struct {
	// Required. Unique name of the resource in this scope including project and
	// location using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	//
	// Note: Redis instances are managed and addressed at regional level so
	// location_id here refers to a GCP region; however, users may choose which
	// specific zone (or collection of zones for cross-zone instances) an instance
	// should be provisioned in. Refer to [location_id] and
	// [alternative_location_id] fields for more details.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An arbitrary and optional user-provided name for the instance.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Resource labels to represent user provided metadata
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The zone where the instance will be provisioned. If not provided,
	// the service will choose a zone for the instance. For STANDARD_HA tier,
	// instances will be created across two zones for protection against zonal
	// failures. If [alternative_location_id] is also provided, it must be
	// different from [location_id].
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Optional. Only applicable to STANDARD_HA tier which protects the instance
	// against zonal failures by provisioning it across two zones. If provided, it
	// must be a different zone from the one provided in [location_id].
	AlternativeLocationId string `protobuf:"bytes,5,opt,name=alternative_location_id,json=alternativeLocationId,proto3" json:"alternative_location_id,omitempty"`
	// Optional. The version of Redis software.
	// If not provided, latest supported version will be used. Updating the
	// version will perform an upgrade/downgrade to the new version. Currently,
	// the supported values are:
	//
	//  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
	//  *   `REDIS_3_2` for Redis 3.2 compatibility
	RedisVersion string `protobuf:"bytes,7,opt,name=redis_version,json=redisVersion,proto3" json:"redis_version,omitempty"`
	// Optional. The CIDR range of internal addresses that are reserved for this
	// instance. If not provided, the service will choose an unused /29 block,
	// for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
	// and non-overlapping with existing subnets in an authorized network.
	ReservedIpRange string `protobuf:"bytes,9,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Output only. Hostname or IP address of the exposed Redis endpoint used by
	// clients to connect to the service.
	Host string `protobuf:"bytes,10,opt,name=host,proto3" json:"host,omitempty"`
	// Output only. The port number of the exposed Redis endpoint.
	Port int32 `protobuf:"varint,11,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The current zone where the Redis endpoint is placed. For Basic
	// Tier instances, this will always be the same as the [location_id]
	// provided by the user at creation time. For Standard Tier instances,
	// this can be either [location_id] or [alternative_location_id] and can
	// change after a failover event.
	CurrentLocationId string `protobuf:"bytes,12,opt,name=current_location_id,json=currentLocationId,proto3" json:"current_location_id,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The current state of this instance.
	State Instance_State `protobuf:"varint,14,opt,name=state,proto3,enum=google.cloud.redis.v1beta1.Instance_State" json:"state,omitempty"`
	// Output only. Additional information about the current status of this
	// instance, if available.
	StatusMessage string `protobuf:"bytes,15,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Optional. Redis configuration parameters, according to
	// http://redis.io/topics/config. Currently, the only supported parameters
	// are:
	//
	//  Redis 3.2 and above:
	//
	//  *   maxmemory-policy
	//  *   notify-keyspace-events
	//
	//  Redis 4.0 and above:
	//
	//  *   activedefrag
	//  *   lfu-log-factor
	//  *   lfu-decay-time
	RedisConfigs map[string]string `protobuf:"bytes,16,rep,name=redis_configs,json=redisConfigs,proto3" json:"redis_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The service tier of the instance.
	Tier Instance_Tier `protobuf:"varint,17,opt,name=tier,proto3,enum=google.cloud.redis.v1beta1.Instance_Tier" json:"tier,omitempty"`
	// Required. Redis memory size in GiB.
	MemorySizeGb int32 `protobuf:"varint,18,opt,name=memory_size_gb,json=memorySizeGb,proto3" json:"memory_size_gb,omitempty"`
	// Optional. The full name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// instance is connected. If left unspecified, the `default` network
	// will be used.
	AuthorizedNetwork string `protobuf:"bytes,20,opt,name=authorized_network,json=authorizedNetwork,proto3" json:"authorized_network,omitempty"`
	// Output only. Cloud IAM identity used by import / export operations to
	// transfer data to/from Cloud Storage. Format is
	// "serviceAccount:<service_account_email>". The value may change over time
	// for a given instance so should be checked before each import/export
	// operation.
	PersistenceIamIdentity string   `protobuf:"bytes,21,opt,name=persistence_iam_identity,json=persistenceIamIdentity,proto3" json:"persistence_iam_identity,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{0}
}

func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (m *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(m, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Instance) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

func (m *Instance) GetAlternativeLocationId() string {
	if m != nil {
		return m.AlternativeLocationId
	}
	return ""
}

func (m *Instance) GetRedisVersion() string {
	if m != nil {
		return m.RedisVersion
	}
	return ""
}

func (m *Instance) GetReservedIpRange() string {
	if m != nil {
		return m.ReservedIpRange
	}
	return ""
}

func (m *Instance) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Instance) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Instance) GetCurrentLocationId() string {
	if m != nil {
		return m.CurrentLocationId
	}
	return ""
}

func (m *Instance) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (m *Instance) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Instance) GetRedisConfigs() map[string]string {
	if m != nil {
		return m.RedisConfigs
	}
	return nil
}

func (m *Instance) GetTier() Instance_Tier {
	if m != nil {
		return m.Tier
	}
	return Instance_TIER_UNSPECIFIED
}

func (m *Instance) GetMemorySizeGb() int32 {
	if m != nil {
		return m.MemorySizeGb
	}
	return 0
}

func (m *Instance) GetAuthorizedNetwork() string {
	if m != nil {
		return m.AuthorizedNetwork
	}
	return ""
}

func (m *Instance) GetPersistenceIamIdentity() string {
	if m != nil {
		return m.PersistenceIamIdentity
	}
	return ""
}

// Request for [ListInstances][google.cloud.redis.v1beta1.CloudRedis.ListInstances].
type ListInstancesRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [next_page_token][CloudRedis.ListInstancesResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request,
	// if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{1}
}

func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (m *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(m, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for [ListInstances][google.cloud.redis.v1beta1.CloudRedis.ListInstances].
type ListInstancesResponse struct {
	// A list of Redis instances in the project in the specified location,
	// or across all locations.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	// If in such an aggregated query a location is unavailable, a dummy Redis
	// entry is included in the response with the "name" field set to a value of
	// the form projects/{project_id}/locations/{location_id}/instances/- and the
	// "status" field set to ERROR and "status_message" field set to "location not
	// available for ListInstances".
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable          []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{2}
}

func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (m *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(m, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListInstancesResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request for [GetInstance][google.cloud.redis.v1beta1.CloudRedis.GetInstance].
type GetInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{3}
}

func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (m *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(m, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for [CreateInstance][google.cloud.redis.v1beta1.CloudRedis.CreateInstance].
type CreateInstanceRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the Redis instance in the customer project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-40 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the customer project / location
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. A Redis [Instance] resource
	Instance             *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{4}
}

func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(m, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for [UpdateInstance][google.cloud.redis.v1beta1.CloudRedis.UpdateInstance].
type UpdateInstanceRequest struct {
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field may only include these
	// fields from [Instance][google.cloud.redis.v1beta1.Instance]:
	//
	//  *   `displayName`
	//  *   `labels`
	//  *   `memorySizeGb`
	//  *   `redisConfig`
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Update description.
	// Only fields specified in update_mask are updated.
	Instance             *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateInstanceRequest) Reset()         { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()    {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{5}
}

func (m *UpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceRequest.Merge(m, src)
}
func (m *UpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceRequest.Size(m)
}
func (m *UpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceRequest proto.InternalMessageInfo

func (m *UpdateInstanceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for [DeleteInstance][google.cloud.redis.v1beta1.CloudRedis.DeleteInstance].
type DeleteInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{6}
}

func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(m, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The Cloud Storage location for the input content
type GcsSource struct {
	// Required. Source data URI. (e.g. 'gs://my_bucket/my_object').
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{7}
}

func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (m *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(m, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The input content
type InputConfig struct {
	// Required. Specify source location of input data
	//
	// Types that are valid to be assigned to Source:
	//	*InputConfig_GcsSource
	Source               isInputConfig_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{8}
}

func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (m *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(m, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InputConfig_GcsSource)(nil),
	}
}

// Request for [Import][google.cloud.redis.v1beta1.CloudRedis.ImportInstance].
type ImportInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specify data to be imported.
	InputConfig          *InputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImportInstanceRequest) Reset()         { *m = ImportInstanceRequest{} }
func (m *ImportInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*ImportInstanceRequest) ProtoMessage()    {}
func (*ImportInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{9}
}

func (m *ImportInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportInstanceRequest.Unmarshal(m, b)
}
func (m *ImportInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportInstanceRequest.Marshal(b, m, deterministic)
}
func (m *ImportInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportInstanceRequest.Merge(m, src)
}
func (m *ImportInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_ImportInstanceRequest.Size(m)
}
func (m *ImportInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportInstanceRequest proto.InternalMessageInfo

func (m *ImportInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportInstanceRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// The Cloud Storage location for the output content
type GcsDestination struct {
	// Required. Data destination URI (e.g.
	// 'gs://my_bucket/my_object'). Existing files will be overwritten.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{10}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

func (m *GcsDestination) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The output content
type OutputConfig struct {
	// Required. Specify destination location of output data
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{11}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
}

// Request for [Export][google.cloud.redis.v1beta1.CloudRedis.ExportInstance].
type ExportInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specify data to be exported.
	OutputConfig         *OutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportInstanceRequest) Reset()         { *m = ExportInstanceRequest{} }
func (m *ExportInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*ExportInstanceRequest) ProtoMessage()    {}
func (*ExportInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{12}
}

func (m *ExportInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportInstanceRequest.Unmarshal(m, b)
}
func (m *ExportInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportInstanceRequest.Marshal(b, m, deterministic)
}
func (m *ExportInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportInstanceRequest.Merge(m, src)
}
func (m *ExportInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_ExportInstanceRequest.Size(m)
}
func (m *ExportInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportInstanceRequest proto.InternalMessageInfo

func (m *ExportInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportInstanceRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request for [Failover][google.cloud.redis.v1beta1.CloudRedis.FailoverInstance].
type FailoverInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Available data protection modes that the user can choose. If it's
	// unspecified, data protection mode will be LIMITED_DATA_LOSS by default.
	DataProtectionMode   FailoverInstanceRequest_DataProtectionMode `protobuf:"varint,2,opt,name=data_protection_mode,json=dataProtectionMode,proto3,enum=google.cloud.redis.v1beta1.FailoverInstanceRequest_DataProtectionMode" json:"data_protection_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *FailoverInstanceRequest) Reset()         { *m = FailoverInstanceRequest{} }
func (m *FailoverInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*FailoverInstanceRequest) ProtoMessage()    {}
func (*FailoverInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{13}
}

func (m *FailoverInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FailoverInstanceRequest.Unmarshal(m, b)
}
func (m *FailoverInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FailoverInstanceRequest.Marshal(b, m, deterministic)
}
func (m *FailoverInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FailoverInstanceRequest.Merge(m, src)
}
func (m *FailoverInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_FailoverInstanceRequest.Size(m)
}
func (m *FailoverInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FailoverInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FailoverInstanceRequest proto.InternalMessageInfo

func (m *FailoverInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FailoverInstanceRequest) GetDataProtectionMode() FailoverInstanceRequest_DataProtectionMode {
	if m != nil {
		return m.DataProtectionMode
	}
	return FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED
}

// This location metadata represents additional configuration options for a
// given location where a Redis instance may be created. All fields are output
// only. It is returned as content of the
// `google.cloud.location.Location.metadata` field.
type LocationMetadata struct {
	// Output only. The set of available zones in the location. The map is keyed
	// by the lowercase ID of each zone, as defined by GCE. These keys can be
	// specified in `location_id` or `alternative_location_id` fields when
	// creating a Redis instance.
	AvailableZones       map[string]*ZoneMetadata `protobuf:"bytes,1,rep,name=available_zones,json=availableZones,proto3" json:"available_zones,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LocationMetadata) Reset()         { *m = LocationMetadata{} }
func (m *LocationMetadata) String() string { return proto.CompactTextString(m) }
func (*LocationMetadata) ProtoMessage()    {}
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{14}
}

func (m *LocationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationMetadata.Unmarshal(m, b)
}
func (m *LocationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationMetadata.Marshal(b, m, deterministic)
}
func (m *LocationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationMetadata.Merge(m, src)
}
func (m *LocationMetadata) XXX_Size() int {
	return xxx_messageInfo_LocationMetadata.Size(m)
}
func (m *LocationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LocationMetadata proto.InternalMessageInfo

func (m *LocationMetadata) GetAvailableZones() map[string]*ZoneMetadata {
	if m != nil {
		return m.AvailableZones
	}
	return nil
}

// Defines specific information for a particular zone. Currently empty and
// reserved for future use only.
type ZoneMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZoneMetadata) Reset()         { *m = ZoneMetadata{} }
func (m *ZoneMetadata) String() string { return proto.CompactTextString(m) }
func (*ZoneMetadata) ProtoMessage()    {}
func (*ZoneMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{15}
}

func (m *ZoneMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZoneMetadata.Unmarshal(m, b)
}
func (m *ZoneMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZoneMetadata.Marshal(b, m, deterministic)
}
func (m *ZoneMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZoneMetadata.Merge(m, src)
}
func (m *ZoneMetadata) XXX_Size() int {
	return xxx_messageInfo_ZoneMetadata.Size(m)
}
func (m *ZoneMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ZoneMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ZoneMetadata proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("google.cloud.redis.v1beta1.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterEnum("google.cloud.redis.v1beta1.Instance_Tier", Instance_Tier_name, Instance_Tier_value)
	proto.RegisterEnum("google.cloud.redis.v1beta1.FailoverInstanceRequest_DataProtectionMode", FailoverInstanceRequest_DataProtectionMode_name, FailoverInstanceRequest_DataProtectionMode_value)
	proto.RegisterType((*Instance)(nil), "google.cloud.redis.v1beta1.Instance")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1beta1.Instance.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1beta1.Instance.RedisConfigsEntry")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.cloud.redis.v1beta1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.cloud.redis.v1beta1.ListInstancesResponse")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.cloud.redis.v1beta1.GetInstanceRequest")
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.cloud.redis.v1beta1.CreateInstanceRequest")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "google.cloud.redis.v1beta1.UpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.cloud.redis.v1beta1.DeleteInstanceRequest")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.redis.v1beta1.GcsSource")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.redis.v1beta1.InputConfig")
	proto.RegisterType((*ImportInstanceRequest)(nil), "google.cloud.redis.v1beta1.ImportInstanceRequest")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.redis.v1beta1.GcsDestination")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.redis.v1beta1.OutputConfig")
	proto.RegisterType((*ExportInstanceRequest)(nil), "google.cloud.redis.v1beta1.ExportInstanceRequest")
	proto.RegisterType((*FailoverInstanceRequest)(nil), "google.cloud.redis.v1beta1.FailoverInstanceRequest")
	proto.RegisterType((*LocationMetadata)(nil), "google.cloud.redis.v1beta1.LocationMetadata")
	proto.RegisterMapType((map[string]*ZoneMetadata)(nil), "google.cloud.redis.v1beta1.LocationMetadata.AvailableZonesEntry")
	proto.RegisterType((*ZoneMetadata)(nil), "google.cloud.redis.v1beta1.ZoneMetadata")
}

func init() {
	proto.RegisterFile("google/cloud/redis/v1beta1/cloud_redis.proto", fileDescriptor_522f9b2de914b9c5)
}

var fileDescriptor_522f9b2de914b9c5 = []byte{
	// 1663 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x6f, 0x6f, 0xe3, 0x48,
	0x19, 0x5f, 0xb7, 0x4d, 0x69, 0x1e, 0xa7, 0x69, 0x3a, 0xdb, 0xdc, 0x5a, 0x81, 0x65, 0x8b, 0x6f,
	0x0f, 0x4a, 0x81, 0x84, 0xed, 0xa1, 0xd3, 0x5e, 0xab, 0xbb, 0xdb, 0x34, 0x71, 0xbb, 0x46, 0x4d,
	0x52, 0x39, 0xd9, 0x93, 0x38, 0x5e, 0x58, 0x53, 0x7b, 0xea, 0x9d, 0xab, 0xe3, 0x31, 0xf6, 0xa4,
	0xb7, 0x2d, 0x3a, 0x21, 0xf8, 0x02, 0x48, 0x80, 0x78, 0x09, 0xaf, 0x90, 0x90, 0x90, 0x10, 0x7c,
	0x0d, 0xde, 0xf2, 0x15, 0x78, 0xc5, 0xa7, 0x40, 0x33, 0xb6, 0x13, 0xa7, 0xcd, 0xa6, 0xd9, 0x4a,
	0xbc, 0xf3, 0x3c, 0x7f, 0x66, 0x7e, 0xf3, 0x7b, 0x66, 0x9e, 0xdf, 0x24, 0xf0, 0x43, 0x8f, 0x31,
	0xcf, 0x27, 0x0d, 0xc7, 0x67, 0x23, 0xb7, 0x11, 0x11, 0x97, 0xc6, 0x8d, 0xcb, 0x67, 0x67, 0x84,
	0xe3, 0x67, 0x89, 0xcd, 0x96, 0xb6, 0x7a, 0x18, 0x31, 0xce, 0x50, 0x2d, 0x89, 0xae, 0x4b, 0x4f,
	0x3d, 0xf1, 0xa4, 0xd1, 0xb5, 0x6f, 0xa5, 0x33, 0xe1, 0x90, 0x36, 0x70, 0x10, 0x30, 0x8e, 0x39,
	0x65, 0x41, 0x9a, 0x59, 0x7b, 0x3f, 0xf5, 0xfa, 0x2c, 0xf0, 0xa2, 0x51, 0x10, 0xd0, 0xc0, 0x6b,
	0xb0, 0x90, 0x44, 0x53, 0x41, 0xdb, 0x69, 0x90, 0x1c, 0x9d, 0x8d, 0xce, 0x1b, 0xe7, 0x94, 0xf8,
	0xae, 0x3d, 0xc4, 0xf1, 0x45, 0x1a, 0xf1, 0xe4, 0x66, 0x04, 0xa7, 0x43, 0x12, 0x73, 0x3c, 0x0c,
	0xd3, 0x80, 0x47, 0x39, 0x14, 0x8e, 0x4f, 0x49, 0xc0, 0x13, 0x87, 0xfe, 0xb7, 0x22, 0xac, 0x99,
	0x41, 0xcc, 0x71, 0xe0, 0x10, 0x84, 0x60, 0x25, 0xc0, 0x43, 0xa2, 0x29, 0xdb, 0xca, 0x4e, 0xd1,
	0x92, 0xdf, 0xe8, 0x3b, 0x50, 0x72, 0x69, 0x1c, 0xfa, 0xf8, 0xca, 0x96, 0xbe, 0x25, 0xe9, 0x53,
	0x53, 0x5b, 0x57, 0x84, 0xbc, 0x84, 0x55, 0x1f, 0x9f, 0x11, 0x3f, 0xd6, 0x96, 0xb7, 0x97, 0x77,
	0xd4, 0xbd, 0x1f, 0xd7, 0xdf, 0xce, 0x47, 0x3d, 0x5b, 0xac, 0x7e, 0x22, 0x53, 0x8c, 0x80, 0x47,
	0x57, 0x56, 0x9a, 0x8f, 0x9e, 0x80, 0xea, 0x33, 0x47, 0x6e, 0xde, 0xa6, 0xae, 0xb6, 0x22, 0xd7,
	0x82, 0xcc, 0x64, 0xba, 0xe8, 0x23, 0x78, 0x84, 0x7d, 0x4e, 0xa2, 0x00, 0x73, 0x7a, 0x49, 0xec,
	0x7c, 0x70, 0x41, 0x06, 0x57, 0x73, 0xee, 0x93, 0x49, 0xde, 0xfb, 0xb0, 0x2e, 0x61, 0xd8, 0x97,
	0x24, 0x8a, 0x29, 0x0b, 0xb4, 0x6f, 0xc8, 0xe8, 0x92, 0x34, 0x7e, 0x9e, 0xd8, 0xd0, 0x2e, 0x6c,
	0x46, 0x24, 0x26, 0xd1, 0x25, 0x71, 0x6d, 0x1a, 0xda, 0x11, 0x0e, 0x3c, 0xa2, 0x15, 0x65, 0xe0,
	0x46, 0xe6, 0x30, 0x43, 0x4b, 0x98, 0x05, 0x55, 0xaf, 0x59, 0xcc, 0x35, 0x48, 0xa8, 0x12, 0xdf,
	0xc2, 0x16, 0xb2, 0x88, 0x6b, 0xea, 0xb6, 0xb2, 0x53, 0xb0, 0xe4, 0x37, 0xaa, 0xc3, 0x43, 0x67,
	0x14, 0x45, 0x24, 0xe0, 0x53, 0x60, 0x4b, 0x32, 0x6d, 0x33, 0x75, 0xe5, 0x80, 0x1e, 0x80, 0xea,
	0x44, 0x04, 0x73, 0x62, 0x8b, 0x12, 0x6a, 0xeb, 0xdb, 0xca, 0x8e, 0xba, 0x57, 0xcb, 0x08, 0xcd,
	0xea, 0x5b, 0x1f, 0x64, 0xf5, 0xb5, 0x20, 0x09, 0x17, 0x06, 0xf4, 0x02, 0x0a, 0x31, 0xc7, 0x9c,
	0x68, 0xe5, 0x6d, 0x65, 0xa7, 0xbc, 0xb7, 0xbb, 0x50, 0x1d, 0xfa, 0x22, 0xc3, 0x4a, 0x12, 0xd1,
	0x07, 0x50, 0x16, 0x1f, 0xa3, 0xd8, 0x1e, 0x92, 0x38, 0xc6, 0x1e, 0xd1, 0x36, 0x24, 0xd2, 0xf5,
	0xc4, 0xda, 0x49, 0x8c, 0xe8, 0xe7, 0x19, 0x9d, 0x0e, 0x0b, 0xce, 0xa9, 0x17, 0x6b, 0x15, 0x59,
	0xf8, 0x8f, 0x16, 0x5a, 0xd0, 0x12, 0xe6, 0x56, 0x92, 0x98, 0x94, 0x3f, 0x29, 0x43, 0x6a, 0x42,
	0x9f, 0xc0, 0x0a, 0xa7, 0x24, 0xd2, 0x36, 0xe5, 0x26, 0xbe, 0xbf, 0xd0, 0x9c, 0x03, 0x4a, 0x22,
	0x4b, 0xa6, 0xa1, 0xa7, 0x50, 0x1e, 0x92, 0x21, 0x8b, 0xae, 0xec, 0x98, 0x5e, 0x13, 0xdb, 0x3b,
	0xd3, 0x90, 0xac, 0x47, 0x29, 0xb1, 0xf6, 0xe9, 0x35, 0x39, 0x3e, 0x43, 0x3f, 0x02, 0x84, 0x47,
	0xfc, 0x35, 0x8b, 0xe8, 0x35, 0x71, 0xed, 0x80, 0xf0, 0xaf, 0x58, 0x74, 0xa1, 0x6d, 0x25, 0x65,
	0x99, 0x78, 0xba, 0x89, 0x03, 0x3d, 0x07, 0x2d, 0x14, 0xa7, 0x24, 0xe6, 0x24, 0x70, 0x88, 0x4d,
	0xf1, 0xd0, 0xa6, 0x2e, 0x09, 0x38, 0xe5, 0x57, 0x5a, 0x55, 0x26, 0xbd, 0x97, 0xf3, 0x9b, 0x78,
	0x68, 0xa6, 0xde, 0xda, 0xc7, 0xa0, 0xe6, 0x4e, 0x3a, 0xaa, 0xc0, 0xf2, 0x05, 0xb9, 0x4a, 0x6f,
	0x98, 0xf8, 0x44, 0x5b, 0x50, 0xb8, 0xc4, 0xfe, 0x28, 0xbb, 0x59, 0xc9, 0x60, 0x7f, 0xe9, 0xb9,
	0x52, 0xfb, 0x0c, 0x36, 0x6f, 0x71, 0xf5, 0x2e, 0x13, 0xe8, 0x7f, 0x50, 0xa0, 0x20, 0xcb, 0x8b,
	0xaa, 0xb0, 0xd9, 0x1f, 0x34, 0x07, 0x86, 0xfd, 0xaa, 0xdb, 0x3f, 0x35, 0x5a, 0xe6, 0x91, 0x69,
	0xb4, 0x2b, 0x0f, 0x50, 0x09, 0xd6, 0x5a, 0x96, 0xd1, 0x1c, 0x98, 0xdd, 0xe3, 0x8a, 0x82, 0x8a,
	0x50, 0xb0, 0x8c, 0x66, 0xfb, 0x67, 0x95, 0x25, 0xe1, 0x78, 0x75, 0xda, 0x4e, 0x1c, 0xcb, 0x62,
	0xd4, 0x36, 0x4e, 0x0c, 0x39, 0x5a, 0x41, 0xeb, 0x50, 0xb4, 0x8c, 0xd3, 0xa6, 0x69, 0x89, 0x61,
	0x01, 0x6d, 0x80, 0xda, 0x69, 0x9a, 0xdd, 0x81, 0xd1, 0x6d, 0x76, 0x5b, 0x46, 0x65, 0x55, 0xf8,
	0xcd, 0xce, 0x69, 0xcf, 0x92, 0xe1, 0x6b, 0xa8, 0x02, 0xa5, 0xa3, 0xa6, 0x79, 0x62, 0x76, 0x8f,
	0xed, 0xde, 0xe7, 0x86, 0x55, 0x01, 0xfd, 0x39, 0xac, 0x88, 0x7a, 0xa1, 0x2d, 0xa8, 0x0c, 0x4c,
	0xc3, 0xba, 0x81, 0xa9, 0x08, 0x85, 0xc3, 0x66, 0xdf, 0x6c, 0x55, 0x14, 0x31, 0x75, 0x7f, 0xd0,
	0xec, 0xb6, 0x9b, 0x56, 0xdb, 0x7e, 0xd9, 0xac, 0x2c, 0xeb, 0x5f, 0xc2, 0xd6, 0x09, 0x8d, 0x79,
	0x56, 0xf6, 0xd8, 0x22, 0xbf, 0x18, 0x91, 0x98, 0xa3, 0xf7, 0x60, 0x35, 0xc4, 0xe2, 0x26, 0xa5,
	0xbc, 0xa4, 0x23, 0xf4, 0x4d, 0x28, 0x86, 0xd8, 0x23, 0xf2, 0x24, 0x48, 0x7a, 0x0a, 0xd6, 0x9a,
	0x30, 0x88, 0x43, 0x80, 0x1e, 0x03, 0x48, 0x27, 0x67, 0x17, 0x24, 0xd0, 0x96, 0x65, 0xa2, 0x0c,
	0x1f, 0x08, 0x83, 0xfe, 0x17, 0x05, 0xaa, 0x37, 0x16, 0x8b, 0x43, 0x16, 0xc4, 0x04, 0x1d, 0x42,
	0x91, 0x66, 0x46, 0x4d, 0x91, 0x27, 0xff, 0xe9, 0x22, 0xa7, 0xd4, 0x9a, 0xa4, 0xa1, 0xef, 0xc2,
	0x46, 0x40, 0xde, 0x70, 0x3b, 0x87, 0x20, 0x29, 0xdf, 0xba, 0x30, 0x9f, 0x66, 0x28, 0xd0, 0x36,
	0xa8, 0xa3, 0x20, 0x22, 0xd8, 0x79, 0x8d, 0xcf, 0x7c, 0x22, 0x1b, 0x6c, 0xd1, 0xca, 0x9b, 0xf4,
	0x1d, 0x40, 0xc7, 0x64, 0x8c, 0x32, 0x63, 0x64, 0x46, 0x2b, 0xd7, 0x7f, 0xa7, 0x40, 0xb5, 0x25,
	0xbb, 0xc5, 0xcd, 0xe8, 0xb7, 0xf1, 0xf7, 0x04, 0xd4, 0x0c, 0xb2, 0xe8, 0x5a, 0x09, 0x42, 0xc8,
	0x4c, 0xa6, 0x8b, 0x5e, 0xc0, 0x5a, 0x36, 0x92, 0x0c, 0x2e, 0xca, 0xc4, 0x38, 0x4b, 0xff, 0xa3,
	0x02, 0xd5, 0x57, 0xa1, 0x3b, 0x03, 0xd4, 0x01, 0xa8, 0x23, 0xe9, 0x90, 0x4a, 0x27, 0x91, 0xcd,
	0x6a, 0x85, 0x47, 0x42, 0x0c, 0x3b, 0x38, 0xbe, 0xb0, 0x20, 0x09, 0x17, 0xdf, 0x53, 0xc0, 0x96,
	0xee, 0x05, 0xec, 0x07, 0x50, 0x6d, 0x13, 0x9f, 0xdc, 0xc6, 0x35, 0x8b, 0xda, 0xc7, 0x50, 0x3c,
	0x76, 0xe2, 0x3e, 0x1b, 0x45, 0x0e, 0x11, 0x57, 0x74, 0x14, 0xd1, 0xec, 0x8a, 0x8e, 0x22, 0xaa,
	0xdb, 0xa0, 0x9a, 0x41, 0x38, 0xe2, 0xc9, 0x4d, 0x46, 0x47, 0x00, 0x9e, 0x13, 0xdb, 0xb1, 0x0c,
	0x4f, 0x37, 0xf6, 0xc1, 0x3c, 0x78, 0xe3, 0xb9, 0x5f, 0x3e, 0xb0, 0x8a, 0x5e, 0x36, 0x38, 0x5c,
	0x83, 0xd5, 0x64, 0x0e, 0xfd, 0x2b, 0xa8, 0x9a, 0x43, 0x21, 0x38, 0x0b, 0x80, 0x45, 0x3f, 0x85,
	0x12, 0x15, 0x68, 0xd2, 0xee, 0x9d, 0x16, 0xee, 0x7b, 0xf3, 0xf9, 0x19, 0xa3, 0xb7, 0x54, 0x3a,
	0x19, 0xe8, 0x3a, 0x94, 0x8f, 0x9d, 0xb8, 0x4d, 0x62, 0x4e, 0x03, 0xa9, 0x61, 0x33, 0x76, 0xcf,
	0xa1, 0xd4, 0x1b, 0xf1, 0xc9, 0xf6, 0x5f, 0xc1, 0x86, 0xd8, 0xbe, 0x3b, 0x49, 0x4a, 0x39, 0xd8,
	0xbd, 0x83, 0x83, 0xdc, 0x32, 0x2f, 0x1f, 0x58, 0x65, 0x6f, 0xca, 0x72, 0xb8, 0x0e, 0x6a, 0x6e,
	0x4a, 0xfd, 0x1a, 0xaa, 0xc6, 0x9b, 0x45, 0x29, 0xe9, 0xc0, 0x3a, 0x93, 0x10, 0xa7, 0x39, 0xd9,
	0x99, 0x07, 0x28, 0xbf, 0x27, 0xab, 0xc4, 0x72, 0x23, 0xfd, 0xb7, 0x4b, 0xf0, 0xe8, 0x08, 0x53,
	0x9f, 0x5d, 0x92, 0x68, 0x91, 0xe5, 0xdf, 0xc0, 0x96, 0x8b, 0x39, 0xb6, 0xc5, 0xa1, 0x26, 0x8e,
	0x7c, 0x24, 0x0c, 0x99, 0x9b, 0x9c, 0xdc, 0xf2, 0xde, 0xd1, 0x3c, 0x14, 0x6f, 0x59, 0xa6, 0xde,
	0xc6, 0x1c, 0x9f, 0x8e, 0xa7, 0xeb, 0x30, 0x97, 0x58, 0xc8, 0xbd, 0x65, 0xd3, 0xcf, 0x01, 0xdd,
	0x8e, 0x44, 0x4f, 0x61, 0xbb, 0xdd, 0x1c, 0x34, 0xed, 0x53, 0xab, 0x37, 0x30, 0x5a, 0x03, 0xb3,
	0xd7, 0xb5, 0x3b, 0xbd, 0xf6, 0x4d, 0xf5, 0xa8, 0xc2, 0xe6, 0x89, 0xd9, 0x31, 0x07, 0x46, 0xdb,
	0x96, 0xd1, 0x27, 0xbd, 0x7e, 0xbf, 0xa2, 0xa0, 0x87, 0xb0, 0x71, 0xd4, 0xb3, 0x5a, 0x46, 0xce,
	0xb8, 0xa4, 0xff, 0x57, 0x81, 0x4a, 0xf6, 0xcc, 0xe9, 0x10, 0x8e, 0x05, 0x14, 0x44, 0x61, 0x03,
	0x5f, 0x62, 0xea, 0x8b, 0x3e, 0x66, 0x5f, 0xb3, 0x60, 0xdc, 0x4e, 0x5f, 0xcc, 0xdb, 0xf1, 0xcd,
	0x69, 0xea, 0xcd, 0x6c, 0x8e, 0x2f, 0xc4, 0x14, 0xc9, 0x93, 0xa2, 0x8c, 0xa7, 0x8c, 0xb5, 0x0b,
	0x78, 0x38, 0x23, 0x6c, 0x86, 0x9a, 0x7e, 0x9a, 0x57, 0xd3, 0x3b, 0x4e, 0x80, 0x98, 0x28, 0x43,
	0x91, 0xd7, 0xdd, 0x32, 0x94, 0xf2, 0xae, 0xbd, 0x5f, 0xab, 0x00, 0x2d, 0x91, 0x2f, 0xe5, 0x1c,
	0xfd, 0x43, 0x81, 0xf5, 0x29, 0x65, 0x41, 0x73, 0x5f, 0xcc, 0xb3, 0x14, 0xaf, 0xf6, 0xec, 0x1d,
	0x32, 0x12, 0xd9, 0xd2, 0xf7, 0x7f, 0xf3, 0xef, 0xff, 0xfc, 0x7e, 0xe9, 0x27, 0x68, 0x6f, 0xfc,
	0x4b, 0xe6, 0x97, 0x49, 0x9b, 0xff, 0x24, 0x8c, 0xd8, 0x97, 0xc4, 0xe1, 0x71, 0x63, 0xb7, 0x91,
	0x3d, 0x52, 0xe3, 0xc6, 0xee, 0xd7, 0x8d, 0x89, 0x5c, 0xfd, 0x59, 0x01, 0x35, 0xa7, 0x32, 0xa8,
	0x3e, 0xf7, 0xa6, 0xde, 0x92, 0xa3, 0xda, 0x42, 0xcd, 0x77, 0x16, 0x42, 0x71, 0x3d, 0xde, 0x82,
	0x6f, 0x02, 0xaf, 0xb1, 0xfb, 0x35, 0xfa, 0xab, 0x02, 0xe5, 0x69, 0x71, 0x43, 0x73, 0x39, 0x9a,
	0x29, 0x84, 0xb5, 0xc7, 0x59, 0x4a, 0xee, 0x07, 0x59, 0xbd, 0x97, 0xfd, 0x20, 0xd3, 0xdb, 0x12,
	0xe0, 0xa7, 0xfa, 0x3d, 0x28, 0xdc, 0x1f, 0x2b, 0x0b, 0xfa, 0xa7, 0x02, 0xe5, 0x69, 0xc9, 0x9b,
	0x0f, 0x75, 0xa6, 0x3c, 0xde, 0x05, 0xb5, 0x23, 0xa1, 0x1e, 0xef, 0x1d, 0x4c, 0xa0, 0x66, 0x00,
	0xea, 0x8b, 0x92, 0x9a, 0xc3, 0x2c, 0xe8, 0x9d, 0x56, 0x98, 0xf9, 0x98, 0x67, 0xaa, 0xd1, 0xa2,
	0xf4, 0x7e, 0xfc, 0xee, 0xf5, 0xdf, 0xa7, 0x72, 0xc1, 0x7d, 0x65, 0x57, 0x42, 0x9d, 0xee, 0xfc,
	0xf3, 0xa1, 0xce, 0x54, 0x89, 0xff, 0x27, 0x54, 0xf2, 0x26, 0x83, 0xfa, 0x77, 0x05, 0x2a, 0x37,
	0x1b, 0x38, 0xfa, 0xf0, 0x1e, 0xed, 0xfe, 0x2e, 0xb8, 0x47, 0x12, 0xee, 0x0b, 0xfd, 0xe0, 0x1e,
	0x70, 0xcf, 0xd3, 0x25, 0x05, 0xe0, 0x3f, 0x29, 0x50, 0x9e, 0x7e, 0x15, 0xcd, 0xe7, 0x76, 0xe6,
	0x0b, 0xea, 0x2e, 0xb0, 0x69, 0x1b, 0xd8, 0xbd, 0x47, 0x1b, 0xa8, 0x3d, 0xfa, 0x57, 0x73, 0x2b,
	0x81, 0x90, 0x2c, 0x81, 0x43, 0x1a, 0xd7, 0x1d, 0x36, 0x3c, 0xfc, 0x15, 0x7c, 0xdb, 0x61, 0xc3,
	0x39, 0x58, 0x0f, 0x6b, 0x93, 0x16, 0xdd, 0x27, 0xd1, 0x25, 0x75, 0xc8, 0x21, 0x49, 0x94, 0x91,
	0x9d, 0x2a, 0x5f, 0x7c, 0x96, 0x66, 0x7a, 0xcc, 0xc7, 0x81, 0x57, 0x67, 0x91, 0xd7, 0xf0, 0x48,
	0x20, 0x5f, 0xa1, 0x8d, 0xc9, 0x52, 0xb3, 0xfe, 0x30, 0x3a, 0x90, 0xa3, 0xb3, 0x55, 0x19, 0xfb,
	0xe1, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0xcb, 0xc3, 0xfc, 0x2b, 0x5b, 0x12, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudRedisClient is the client API for CloudRedis service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudRedisClient interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Import a Redis RDB snapshot file from Cloud Storage into a Redis instance.
	//
	// Redis may stop serving during this operation. Instance state will be
	// IMPORTING for entire operation. When complete, the instance will contain
	// only data from the imported file.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ImportInstance(ctx context.Context, in *ImportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Export Redis instance data into a Redis RDB format file in Cloud Storage.
	//
	// Redis will continue serving during this operation.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ExportInstance(ctx context.Context, in *ExportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Initiates a failover of the master node to current replica node for a
	// specific STANDARD tier Cloud Memorystore for Redis instance.
	FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type cloudRedisClient struct {
	cc *grpc.ClientConn
}

func NewCloudRedisClient(cc *grpc.ClientConn) CloudRedisClient {
	return &cloudRedisClient{cc}
}

func (c *cloudRedisClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) ImportInstance(ctx context.Context, in *ImportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/ImportInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) ExportInstance(ctx context.Context, in *ExportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/ExportInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/FailoverInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudRedisServer is the server API for CloudRedis service.
type CloudRedisServer interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunning.Operation, error)
	// Import a Redis RDB snapshot file from Cloud Storage into a Redis instance.
	//
	// Redis may stop serving during this operation. Instance state will be
	// IMPORTING for entire operation. When complete, the instance will contain
	// only data from the imported file.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ImportInstance(context.Context, *ImportInstanceRequest) (*longrunning.Operation, error)
	// Export Redis instance data into a Redis RDB format file in Cloud Storage.
	//
	// Redis will continue serving during this operation.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ExportInstance(context.Context, *ExportInstanceRequest) (*longrunning.Operation, error)
	// Initiates a failover of the master node to current replica node for a
	// specific STANDARD tier Cloud Memorystore for Redis instance.
	FailoverInstance(context.Context, *FailoverInstanceRequest) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunning.Operation, error)
}

// UnimplementedCloudRedisServer can be embedded to have forward compatible implementations.
type UnimplementedCloudRedisServer struct {
}

func (*UnimplementedCloudRedisServer) ListInstances(ctx context.Context, req *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedCloudRedisServer) GetInstance(ctx context.Context, req *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedCloudRedisServer) CreateInstance(ctx context.Context, req *CreateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (*UnimplementedCloudRedisServer) UpdateInstance(ctx context.Context, req *UpdateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (*UnimplementedCloudRedisServer) ImportInstance(ctx context.Context, req *ImportInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportInstance not implemented")
}
func (*UnimplementedCloudRedisServer) ExportInstance(ctx context.Context, req *ExportInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportInstance not implemented")
}
func (*UnimplementedCloudRedisServer) FailoverInstance(ctx context.Context, req *FailoverInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FailoverInstance not implemented")
}
func (*UnimplementedCloudRedisServer) DeleteInstance(ctx context.Context, req *DeleteInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}

func RegisterCloudRedisServer(s *grpc.Server, srv CloudRedisServer) {
	s.RegisterService(&_CloudRedis_serviceDesc, srv)
}

func _CloudRedis_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_ImportInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ImportInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/ImportInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ImportInstance(ctx, req.(*ImportInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_ExportInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ExportInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/ExportInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ExportInstance(ctx, req.(*ExportInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_FailoverInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FailoverInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).FailoverInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/FailoverInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).FailoverInstance(ctx, req.(*FailoverInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudRedis_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.redis.v1beta1.CloudRedis",
	HandlerType: (*CloudRedisServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudRedis_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudRedis_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudRedis_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudRedis_UpdateInstance_Handler,
		},
		{
			MethodName: "ImportInstance",
			Handler:    _CloudRedis_ImportInstance_Handler,
		},
		{
			MethodName: "ExportInstance",
			Handler:    _CloudRedis_ExportInstance_Handler,
		},
		{
			MethodName: "FailoverInstance",
			Handler:    _CloudRedis_FailoverInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudRedis_DeleteInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/redis/v1beta1/cloud_redis.proto",
}
