/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/sriov-network-operator/pkg/apis/sriovnetwork/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SriovNetworkLister helps list SriovNetworks.
type SriovNetworkLister interface {
	// List lists all SriovNetworks in the indexer.
	List(selector labels.Selector) (ret []*v1.SriovNetwork, err error)
	// SriovNetworks returns an object that can list and get SriovNetworks.
	SriovNetworks(namespace string) SriovNetworkNamespaceLister
	SriovNetworkListerExpansion
}

// sriovNetworkLister implements the SriovNetworkLister interface.
type sriovNetworkLister struct {
	indexer cache.Indexer
}

// NewSriovNetworkLister returns a new SriovNetworkLister.
func NewSriovNetworkLister(indexer cache.Indexer) SriovNetworkLister {
	return &sriovNetworkLister{indexer: indexer}
}

// List lists all SriovNetworks in the indexer.
func (s *sriovNetworkLister) List(selector labels.Selector) (ret []*v1.SriovNetwork, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SriovNetwork))
	})
	return ret, err
}

// SriovNetworks returns an object that can list and get SriovNetworks.
func (s *sriovNetworkLister) SriovNetworks(namespace string) SriovNetworkNamespaceLister {
	return sriovNetworkNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SriovNetworkNamespaceLister helps list and get SriovNetworks.
type SriovNetworkNamespaceLister interface {
	// List lists all SriovNetworks in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.SriovNetwork, err error)
	// Get retrieves the SriovNetwork from the indexer for a given namespace and name.
	Get(name string) (*v1.SriovNetwork, error)
	SriovNetworkNamespaceListerExpansion
}

// sriovNetworkNamespaceLister implements the SriovNetworkNamespaceLister
// interface.
type sriovNetworkNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SriovNetworks in the indexer for a given namespace.
func (s sriovNetworkNamespaceLister) List(selector labels.Selector) (ret []*v1.SriovNetwork, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SriovNetwork))
	})
	return ret, err
}

// Get retrieves the SriovNetwork from the indexer for a given namespace and name.
func (s sriovNetworkNamespaceLister) Get(name string) (*v1.SriovNetwork, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("sriovnetwork"), name)
	}
	return obj.(*v1.SriovNetwork), nil
}
