/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/sriov-network-operator/pkg/apis/sriovnetwork/v1"
	scheme "github.com/openshift/sriov-network-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SriovOperatorConfigsGetter has a method to return a SriovOperatorConfigInterface.
// A group's client should implement this interface.
type SriovOperatorConfigsGetter interface {
	SriovOperatorConfigs(namespace string) SriovOperatorConfigInterface
}

// SriovOperatorConfigInterface has methods to work with SriovOperatorConfig resources.
type SriovOperatorConfigInterface interface {
	Create(*v1.SriovOperatorConfig) (*v1.SriovOperatorConfig, error)
	Update(*v1.SriovOperatorConfig) (*v1.SriovOperatorConfig, error)
	UpdateStatus(*v1.SriovOperatorConfig) (*v1.SriovOperatorConfig, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.SriovOperatorConfig, error)
	List(opts metav1.ListOptions) (*v1.SriovOperatorConfigList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SriovOperatorConfig, err error)
	SriovOperatorConfigExpansion
}

// sriovOperatorConfigs implements SriovOperatorConfigInterface
type sriovOperatorConfigs struct {
	client rest.Interface
	ns     string
}

// newSriovOperatorConfigs returns a SriovOperatorConfigs
func newSriovOperatorConfigs(c *SriovnetworkV1Client, namespace string) *sriovOperatorConfigs {
	return &sriovOperatorConfigs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the sriovOperatorConfig, and returns the corresponding sriovOperatorConfig object, and an error if there is any.
func (c *sriovOperatorConfigs) Get(name string, options metav1.GetOptions) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SriovOperatorConfigs that match those selectors.
func (c *sriovOperatorConfigs) List(opts metav1.ListOptions) (result *v1.SriovOperatorConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SriovOperatorConfigList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested sriovOperatorConfigs.
func (c *sriovOperatorConfigs) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a sriovOperatorConfig and creates it.  Returns the server's representation of the sriovOperatorConfig, and an error, if there is any.
func (c *sriovOperatorConfigs) Create(sriovOperatorConfig *v1.SriovOperatorConfig) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Body(sriovOperatorConfig).
		Do().
		Into(result)
	return
}

// Update takes the representation of a sriovOperatorConfig and updates it. Returns the server's representation of the sriovOperatorConfig, and an error, if there is any.
func (c *sriovOperatorConfigs) Update(sriovOperatorConfig *v1.SriovOperatorConfig) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Name(sriovOperatorConfig.Name).
		Body(sriovOperatorConfig).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *sriovOperatorConfigs) UpdateStatus(sriovOperatorConfig *v1.SriovOperatorConfig) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Name(sriovOperatorConfig.Name).
		SubResource("status").
		Body(sriovOperatorConfig).
		Do().
		Into(result)
	return
}

// Delete takes name of the sriovOperatorConfig and deletes it. Returns an error if one occurs.
func (c *sriovOperatorConfigs) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *sriovOperatorConfigs) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched sriovOperatorConfig.
func (c *sriovOperatorConfigs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
