package costmanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// ConnectorStatus enumerates the values for connector status.
type ConnectorStatus string

const (
	// Active ...
	Active ConnectorStatus = "active"
	// Error ...
	Error ConnectorStatus = "error"
	// Suspended ...
	Suspended ConnectorStatus = "suspended"
)

// PossibleConnectorStatusValues returns an array of possible values for the ConnectorStatus const type.
func PossibleConnectorStatusValues() []ConnectorStatus {
	return []ConnectorStatus{Active, Error, Suspended}
}

// ExecutionStatus enumerates the values for execution status.
type ExecutionStatus string

const (
	// Completed ...
	Completed ExecutionStatus = "Completed"
	// Failed ...
	Failed ExecutionStatus = "Failed"
	// InProgress ...
	InProgress ExecutionStatus = "InProgress"
	// Queud ...
	Queud ExecutionStatus = "Queud"
	// Timeout ...
	Timeout ExecutionStatus = "Timeout"
)

// PossibleExecutionStatusValues returns an array of possible values for the ExecutionStatus const type.
func PossibleExecutionStatusValues() []ExecutionStatus {
	return []ExecutionStatus{Completed, Failed, InProgress, Queud, Timeout}
}

// ExecutionType enumerates the values for execution type.
type ExecutionType string

const (
	// OnDemand ...
	OnDemand ExecutionType = "OnDemand"
	// Scheduled ...
	Scheduled ExecutionType = "Scheduled"
)

// PossibleExecutionTypeValues returns an array of possible values for the ExecutionType const type.
func PossibleExecutionTypeValues() []ExecutionType {
	return []ExecutionType{OnDemand, Scheduled}
}

// FormatType enumerates the values for format type.
type FormatType string

const (
	// Csv ...
	Csv FormatType = "Csv"
)

// PossibleFormatTypeValues returns an array of possible values for the FormatType const type.
func PossibleFormatTypeValues() []FormatType {
	return []FormatType{Csv}
}

// GranularityType enumerates the values for granularity type.
type GranularityType string

const (
	// Daily ...
	Daily GranularityType = "Daily"
)

// PossibleGranularityTypeValues returns an array of possible values for the GranularityType const type.
func PossibleGranularityTypeValues() []GranularityType {
	return []GranularityType{Daily}
}

// RecurrenceType enumerates the values for recurrence type.
type RecurrenceType string

const (
	// RecurrenceTypeAnnually ...
	RecurrenceTypeAnnually RecurrenceType = "Annually"
	// RecurrenceTypeDaily ...
	RecurrenceTypeDaily RecurrenceType = "Daily"
	// RecurrenceTypeMonthly ...
	RecurrenceTypeMonthly RecurrenceType = "Monthly"
	// RecurrenceTypeWeekly ...
	RecurrenceTypeWeekly RecurrenceType = "Weekly"
)

// PossibleRecurrenceTypeValues returns an array of possible values for the RecurrenceType const type.
func PossibleRecurrenceTypeValues() []RecurrenceType {
	return []RecurrenceType{RecurrenceTypeAnnually, RecurrenceTypeDaily, RecurrenceTypeMonthly, RecurrenceTypeWeekly}
}

// ReportColumnType enumerates the values for report column type.
type ReportColumnType string

const (
	// ReportColumnTypeDimension ...
	ReportColumnTypeDimension ReportColumnType = "Dimension"
	// ReportColumnTypeTag ...
	ReportColumnTypeTag ReportColumnType = "Tag"
)

// PossibleReportColumnTypeValues returns an array of possible values for the ReportColumnType const type.
func PossibleReportColumnTypeValues() []ReportColumnType {
	return []ReportColumnType{ReportColumnTypeDimension, ReportColumnTypeTag}
}

// StatusType enumerates the values for status type.
type StatusType string

const (
	// StatusTypeActive ...
	StatusTypeActive StatusType = "Active"
	// StatusTypeInactive ...
	StatusTypeInactive StatusType = "Inactive"
)

// PossibleStatusTypeValues returns an array of possible values for the StatusType const type.
func PossibleStatusTypeValues() []StatusType {
	return []StatusType{StatusTypeActive, StatusTypeInactive}
}

// TimeframeType enumerates the values for timeframe type.
type TimeframeType string

const (
	// Custom ...
	Custom TimeframeType = "Custom"
	// MonthToDate ...
	MonthToDate TimeframeType = "MonthToDate"
	// WeekToDate ...
	WeekToDate TimeframeType = "WeekToDate"
)

// PossibleTimeframeTypeValues returns an array of possible values for the TimeframeType const type.
func PossibleTimeframeTypeValues() []TimeframeType {
	return []TimeframeType{Custom, MonthToDate, WeekToDate}
}

// CommonReportProperties the common properties of the report.
type CommonReportProperties struct {
	// Format - The format of the report being delivered. Possible values include: 'Csv'
	Format FormatType `json:"format,omitempty"`
	// DeliveryInfo - Has delivery information for the report.
	DeliveryInfo *ReportDeliveryInfo `json:"deliveryInfo,omitempty"`
	// Definition - Has definition for the report.
	Definition *ReportDefinition `json:"definition,omitempty"`
}

// ConnectorCollectionErrorInfo details of any error encountered on last collection attempt
type ConnectorCollectionErrorInfo struct {
	// ErrorMessage - Detailed error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorCode - Short error message
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorStartTime - Time the error started occuring (Last time error occurred in lastRun)
	ErrorStartTime *date.Time `json:"errorStartTime,omitempty"`
}

// ConnectorCollectionInfo collection and ingestion information
type ConnectorCollectionInfo struct {
	// LastRun - Last time the data acquisition process completed (even if no new data was found)
	LastRun *date.Time `json:"lastRun,omitempty"`
	// SourceLastUpdated - Source timestamp of external data currently available in Azure (eg AWS last processed CUR file timestamp)
	SourceLastUpdated *date.Time `json:"sourceLastUpdated,omitempty"`
	// LastUpdated - Last time the external data was updated into Azure
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// Error - Error information of last collection
	Error *ConnectorCollectionErrorInfo `json:"error,omitempty"`
}

// ConnectorDefinition the Connector model definition
type ConnectorDefinition struct {
	autorest.Response `json:"-"`
	// Kind - Connector kind (eg aws)
	Kind *string `json:"kind,omitempty"`
	// ID - Connector id
	ID *string `json:"id,omitempty"`
	// Name - Connector name
	Name *string `json:"name,omitempty"`
	// Type - Connector type
	Type *string `json:"type,omitempty"`
	// Location - Connector location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ConnectorProperties - Connector properties
	*ConnectorProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorDefinition.
func (cd ConnectorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.Kind != nil {
		objectMap["kind"] = cd.Kind
	}
	if cd.ID != nil {
		objectMap["id"] = cd.ID
	}
	if cd.Name != nil {
		objectMap["name"] = cd.Name
	}
	if cd.Type != nil {
		objectMap["type"] = cd.Type
	}
	if cd.Location != nil {
		objectMap["location"] = cd.Location
	}
	if cd.Tags != nil {
		objectMap["tags"] = cd.Tags
	}
	if cd.ConnectorProperties != nil {
		objectMap["properties"] = cd.ConnectorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectorDefinition struct.
func (cd *ConnectorDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cd.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cd.Tags = tags
			}
		case "properties":
			if v != nil {
				var connectorProperties ConnectorProperties
				err = json.Unmarshal(*v, &connectorProperties)
				if err != nil {
					return err
				}
				cd.ConnectorProperties = &connectorProperties
			}
		}
	}

	return nil
}

// ConnectorDefinitionListResult result of listing connector definitions. It contains a list of available connector
// definitions in the scope provided.
type ConnectorDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of connector definitions.
	Value *[]ConnectorDefinition `json:"value,omitempty"`
}

// ConnectorProperties the properties of a Connector
type ConnectorProperties struct {
	// DisplayName - Connector DisplayName (defaults to Name)
	DisplayName *string `json:"displayName,omitempty"`
	// ProviderAccountID - Connector providerAccountId (determined from credentials)
	ProviderAccountID *string `json:"providerAccountId,omitempty"`
	// CredentialsKey - Credentials authentication key (eg AWS ARN)
	CredentialsKey *string `json:"credentialsKey,omitempty"`
	// CredentialsSecret - Credentials secret (eg AWS ExternalId)
	CredentialsSecret *string `json:"credentialsSecret,omitempty"`
	// ReportID - Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
	ReportID *string `json:"reportId,omitempty"`
	// CreatedOn - Connector definition creation datetime
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - Connector last modified datetime
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// Status - Connector status. Possible values include: 'Active', 'Error', 'Suspended'
	Status ConnectorStatus `json:"status,omitempty"`
	// Collection - Collection information
	Collection *ConnectorCollectionInfo `json:"collection,omitempty"`
}

// Dimension ...
type Dimension struct {
	*DimensionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DimensionProperties != nil {
		objectMap["properties"] = d.DimensionProperties
	}
	if d.ID != nil {
		objectMap["id"] = d.ID
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.Type != nil {
		objectMap["type"] = d.Type
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Dimension struct.
func (d *Dimension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dimensionProperties DimensionProperties
				err = json.Unmarshal(*v, &dimensionProperties)
				if err != nil {
					return err
				}
				d.DimensionProperties = &dimensionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		}
	}

	return nil
}

// DimensionProperties ...
type DimensionProperties struct {
	Data       *[]string  `json:"data,omitempty"`
	Total      *int32     `json:"total,omitempty"`
	Category   *string    `json:"category,omitempty"`
	UsageStart *date.Time `json:"usageStart,omitempty"`
	UsageEnd   *date.Time `json:"usageEnd,omitempty"`
	NextLink   *string    `json:"nextLink,omitempty"`
}

// DimensionsListResult result of listing dimensions. It contains a list of available dimensions.
type DimensionsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of dimensions.
	Value *[]Dimension `json:"value,omitempty"`
}

// ErrorBase the details of the error.
type ErrorBase struct {
	// Code - A machine readable error code.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Target - Indicates which property in the request is responsible for the error.
	Target *string `json:"target,omitempty"`
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - A machine readable error code.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Target - Indicates which property in the request is responsible for the error.
	Target *string `json:"target,omitempty"`
	// Details - error details.
	Details *[]ErrorBase `json:"details,omitempty"`
}

// ErrorResponse error response indicates that the service is not able to process the incoming request. The reason
// is provided in the error message.
type ErrorResponse struct {
	// Error - The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// Query ...
type Query struct {
	*QueryProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Query.
func (q Query) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if q.QueryProperties != nil {
		objectMap["properties"] = q.QueryProperties
	}
	if q.ID != nil {
		objectMap["id"] = q.ID
	}
	if q.Name != nil {
		objectMap["name"] = q.Name
	}
	if q.Type != nil {
		objectMap["type"] = q.Type
	}
	if q.Tags != nil {
		objectMap["tags"] = q.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Query struct.
func (q *Query) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queryProperties QueryProperties
				err = json.Unmarshal(*v, &queryProperties)
				if err != nil {
					return err
				}
				q.QueryProperties = &queryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				q.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				q.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				q.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				q.Tags = tags
			}
		}
	}

	return nil
}

// QueryColumn ...
type QueryColumn struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// QueryProperties ...
type QueryProperties struct {
	NextLink *string `json:"nextLink,omitempty"`
	// Columns - Array of columns
	Columns *[]QueryColumn   `json:"columns,omitempty"`
	Rows    *[][]interface{} `json:"rows,omitempty"`
}

// QueryResult result of query. It contains all columns listed under groupings and aggregation.
type QueryResult struct {
	autorest.Response `json:"-"`
	// Value - The list of usage data.
	Value *[]Query `json:"value,omitempty"`
}

// Report a report resource.
type Report struct {
	autorest.Response `json:"-"`
	*ReportProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Report.
func (r Report) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReportProperties != nil {
		objectMap["properties"] = r.ReportProperties
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Report struct.
func (r *Report) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reportProperties ReportProperties
				err = json.Unmarshal(*v, &reportProperties)
				if err != nil {
					return err
				}
				r.ReportProperties = &reportProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		}
	}

	return nil
}

// ReportAggregation the aggregation expression to be used in the report.
type ReportAggregation struct {
	// Name - The name of the column to aggregate.
	Name *string `json:"name,omitempty"`
	// Function - The name of the aggregation function to use.
	Function *string `json:"function,omitempty"`
}

// ReportComparisonExpression the comparison expression to be used in the report.
type ReportComparisonExpression struct {
	// Name - The name of the column to use in comaprison.
	Name *string `json:"name,omitempty"`
	// Operator - The operator to use for comparison.
	Operator *string `json:"operator,omitempty"`
	// Values - Array of values to use for comparison
	Values *[]string `json:"values,omitempty"`
}

// ReportDataset the definition of data present in the report.
type ReportDataset struct {
	// Granularity - The granularity of rows in the report. Possible values include: 'Daily'
	Granularity GranularityType `json:"granularity,omitempty"`
	// Configuration - Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
	Configuration *ReportDatasetConfiguration `json:"configuration,omitempty"`
	// Aggregation - Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have upto 2 aggregation clauses.
	Aggregation map[string]*ReportAggregation `json:"aggregation"`
	// Grouping - Array of group by expression to use in the report. Report can have upto 2 group by clauses.
	Grouping *[]ReportGrouping `json:"grouping,omitempty"`
	// Filter - Has filter expression to use in the report.
	Filter *ReportFilter `json:"filter,omitempty"`
}

// MarshalJSON is the custom marshaler for ReportDataset.
func (rd ReportDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.Granularity != "" {
		objectMap["granularity"] = rd.Granularity
	}
	if rd.Configuration != nil {
		objectMap["configuration"] = rd.Configuration
	}
	if rd.Aggregation != nil {
		objectMap["aggregation"] = rd.Aggregation
	}
	if rd.Grouping != nil {
		objectMap["grouping"] = rd.Grouping
	}
	if rd.Filter != nil {
		objectMap["filter"] = rd.Filter
	}
	return json.Marshal(objectMap)
}

// ReportDatasetConfiguration the configuration of dataset in the report.
type ReportDatasetConfiguration struct {
	// Columns - Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
	Columns *[]string `json:"columns,omitempty"`
}

// ReportDefinition the definition of a report.
type ReportDefinition struct {
	// Type - The type of the report.
	Type *string `json:"type,omitempty"`
	// Timeframe - The time frame for pulling data for the report. If custom, then a specific time period must be provided. Possible values include: 'WeekToDate', 'MonthToDate', 'Custom'
	Timeframe TimeframeType `json:"timeframe,omitempty"`
	// TimePeriod - Has time period for pulling data for the report.
	TimePeriod *ReportTimePeriod `json:"timePeriod,omitempty"`
	// Dataset - Has definition for data in this report.
	Dataset *ReportDataset `json:"dataset,omitempty"`
}

// ReportDeliveryDestination the destination information for the delivery of the report.
type ReportDeliveryDestination struct {
	// ResourceID - The resource id of the storage account where reports will be delivered.
	ResourceID *string `json:"resourceId,omitempty"`
	// Container - The name of the container where reports will be uploaded.
	Container *string `json:"container,omitempty"`
	// RootFolderPath - The name of the directory where reports will be uploaded.
	RootFolderPath *string `json:"rootFolderPath,omitempty"`
}

// ReportDeliveryInfo the delivery information associated with a report.
type ReportDeliveryInfo struct {
	// Destination - Has destination for the report being delivered.
	Destination *ReportDeliveryDestination `json:"destination,omitempty"`
}

// ReportExecution a report exeuction.
type ReportExecution struct {
	*ReportExecutionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReportExecution.
func (re ReportExecution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if re.ReportExecutionProperties != nil {
		objectMap["properties"] = re.ReportExecutionProperties
	}
	if re.ID != nil {
		objectMap["id"] = re.ID
	}
	if re.Name != nil {
		objectMap["name"] = re.Name
	}
	if re.Type != nil {
		objectMap["type"] = re.Type
	}
	if re.Tags != nil {
		objectMap["tags"] = re.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReportExecution struct.
func (re *ReportExecution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reportExecutionProperties ReportExecutionProperties
				err = json.Unmarshal(*v, &reportExecutionProperties)
				if err != nil {
					return err
				}
				re.ReportExecutionProperties = &reportExecutionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				re.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				re.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				re.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				re.Tags = tags
			}
		}
	}

	return nil
}

// ReportExecutionListResult result of listing reports execution history of a report by name
type ReportExecutionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of report executions.
	Value *[]ReportExecution `json:"value,omitempty"`
}

// ReportExecutionProperties the properties of the report execution.
type ReportExecutionProperties struct {
	// ExecutionType - The type of the report execution. Possible values include: 'OnDemand', 'Scheduled'
	ExecutionType ExecutionType `json:"executionType,omitempty"`
	// Status - The status of the report execution. Possible values include: 'Queud', 'InProgress', 'Completed', 'Failed', 'Timeout'
	Status ExecutionStatus `json:"status,omitempty"`
	// SubmittedBy - The identifier for the entity that executed the report. For OnDemand executions, it is the email id. For Scheduled executions, it is the constant value - System.
	SubmittedBy *string `json:"submittedBy,omitempty"`
	// SubmittedTime - The time when report was queued to be executed.
	SubmittedTime *date.Time `json:"submittedTime,omitempty"`
	// ProcessingStartTime - The time when report was picked up to be executed.
	ProcessingStartTime *date.Time `json:"processingStartTime,omitempty"`
	// ProcessingEndTime - The time when report execution finished.
	ProcessingEndTime *date.Time `json:"processingEndTime,omitempty"`
	// FileName - The name of the file report got written to.
	FileName       *string                 `json:"fileName,omitempty"`
	ReportSettings *CommonReportProperties `json:"reportSettings,omitempty"`
}

// ReportFilter the filter expression to be used in the report.
type ReportFilter struct {
	// And - The logical "AND" expression. Must have atleast 2 items.
	And *[]ReportFilter `json:"and,omitempty"`
	// Or - The logical "OR" expression. Must have atleast 2 items.
	Or *[]ReportFilter `json:"or,omitempty"`
	// Not - The logical "NOT" expression.
	Not *ReportFilter `json:"not,omitempty"`
	// Dimension - Has comparison expression for a dimension
	Dimension *ReportComparisonExpression `json:"dimension,omitempty"`
	// Tag - Has comparison expression for a tag
	Tag *ReportComparisonExpression `json:"tag,omitempty"`
}

// ReportGrouping the group by expression to be used in the report.
type ReportGrouping struct {
	// Type - Has type of the column to group. Possible values include: 'ReportColumnTypeTag', 'ReportColumnTypeDimension'
	Type ReportColumnType `json:"type,omitempty"`
	// Name - The name of the column to group.
	Name *string `json:"name,omitempty"`
}

// ReportListResult result of listing reports. It contains a list of available reports in the scope provided.
type ReportListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of reports.
	Value *[]Report `json:"value,omitempty"`
}

// ReportProperties the properties of the report.
type ReportProperties struct {
	// Schedule - Has schedule information for the report.
	Schedule *ReportSchedule `json:"schedule,omitempty"`
	// Format - The format of the report being delivered. Possible values include: 'Csv'
	Format FormatType `json:"format,omitempty"`
	// DeliveryInfo - Has delivery information for the report.
	DeliveryInfo *ReportDeliveryInfo `json:"deliveryInfo,omitempty"`
	// Definition - Has definition for the report.
	Definition *ReportDefinition `json:"definition,omitempty"`
}

// ReportRecurrencePeriod the start and end date for recurrence schedule.
type ReportRecurrencePeriod struct {
	// From - The start date of recurrence.
	From *date.Time `json:"from,omitempty"`
	// To - The end date of recurrence.
	To *date.Time `json:"to,omitempty"`
}

// ReportSchedule the schedule associated with a report.
type ReportSchedule struct {
	// Status - The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused. Possible values include: 'StatusTypeActive', 'StatusTypeInactive'
	Status StatusType `json:"status,omitempty"`
	// Recurrence - The schedule recurrence. Possible values include: 'RecurrenceTypeDaily', 'RecurrenceTypeWeekly', 'RecurrenceTypeMonthly', 'RecurrenceTypeAnnually'
	Recurrence RecurrenceType `json:"recurrence,omitempty"`
	// RecurrencePeriod - Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
	RecurrencePeriod *ReportRecurrencePeriod `json:"recurrencePeriod,omitempty"`
}

// ReportTimePeriod the start and end date for pulling data for the report.
type ReportTimePeriod struct {
	// From - The start date to pull data from.
	From *date.Time `json:"from,omitempty"`
	// To - The end date to pull data to.
	To *date.Time `json:"to,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}
