// +build use_ffjson

// DO NOT EDIT!
// Code generated by ffjson <https://github.com/pquerna/ffjson>
// source: .root/src/github.com/mailru/easyjson/benchmark/data.go
// DO NOT EDIT!

package benchmark

import (
	"bytes"
	"errors"
	"fmt"
	fflib "github.com/pquerna/ffjson/fflib/v1"
)

func (mj *Entities) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Entities) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"hashtags":`)
	if mj.Hashtags != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Hashtags {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"urls":`)
	if mj.Urls != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Urls {
			if i != 0 {
				buf.WriteString(`,`)
			}
			if v != nil {
				fflib.WriteJsonString(buf, string(*v))
			} else {
				buf.WriteString(`null`)
			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"user_mentions":`)
	if mj.UserMentions != nil {
		buf.WriteString(`[`)
		for i, v := range mj.UserMentions {
			if i != 0 {
				buf.WriteString(`,`)
			}
			if v != nil {
				fflib.WriteJsonString(buf, string(*v))
			} else {
				buf.WriteString(`null`)
			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Entitiesbase = iota
	ffj_t_Entitiesno_such_key

	ffj_t_Entities_Hashtags

	ffj_t_Entities_Urls

	ffj_t_Entities_UserMentions
)

var ffj_key_Entities_Hashtags = []byte("hashtags")

var ffj_key_Entities_Urls = []byte("urls")

var ffj_key_Entities_UserMentions = []byte("user_mentions")

func (uj *Entities) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Entities) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Entitiesbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Entitiesno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'h':

					if bytes.Equal(ffj_key_Entities_Hashtags, kn) {
						currentKey = ffj_t_Entities_Hashtags
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_Entities_Urls, kn) {
						currentKey = ffj_t_Entities_Urls
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Entities_UserMentions, kn) {
						currentKey = ffj_t_Entities_UserMentions
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Entities_UserMentions, kn) {
					currentKey = ffj_t_Entities_UserMentions
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Entities_Urls, kn) {
					currentKey = ffj_t_Entities_Urls
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Entities_Hashtags, kn) {
					currentKey = ffj_t_Entities_Hashtags
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Entitiesno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Entities_Hashtags:
					goto handle_Hashtags

				case ffj_t_Entities_Urls:
					goto handle_Urls

				case ffj_t_Entities_UserMentions:
					goto handle_UserMentions

				case ffj_t_Entitiesno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Hashtags:

	/* handler: uj.Hashtags type=[]benchmark.Hashtag kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Hashtags = nil
		} else {

			uj.Hashtags = make([]Hashtag, 0)

			wantVal := true

			for {

				var tmp_uj__Hashtags Hashtag

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Hashtags type=benchmark.Hashtag kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Hashtags.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Hashtags = append(uj.Hashtags, tmp_uj__Hashtags)
				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Urls:

	/* handler: uj.Urls type=[]*string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Urls = nil
		} else {

			uj.Urls = make([]*string, 0)

			wantVal := true

			for {

				var tmp_uj__Urls *string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Urls type=*string kind=ptr quoted=false*/

				{

					if tok == fflib.FFTok_null {
						tmp_uj__Urls = nil
					} else {
						if tmp_uj__Urls == nil {
							tmp_uj__Urls = new(string)
						}

						/* handler: tmp_uj__Urls type=string kind=string quoted=false*/

						{

							{
								if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
									return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
								}
							}

							if tok == fflib.FFTok_null {

								tmp_uj__Urls = nil

							} else {

								var tval string
								outBuf := fs.Output.Bytes()

								tval = string(string(outBuf))
								tmp_uj__Urls = &tval

							}
						}

					}
				}

				uj.Urls = append(uj.Urls, tmp_uj__Urls)
				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UserMentions:

	/* handler: uj.UserMentions type=[]*string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.UserMentions = nil
		} else {

			uj.UserMentions = make([]*string, 0)

			wantVal := true

			for {

				var tmp_uj__UserMentions *string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__UserMentions type=*string kind=ptr quoted=false*/

				{

					if tok == fflib.FFTok_null {
						tmp_uj__UserMentions = nil
					} else {
						if tmp_uj__UserMentions == nil {
							tmp_uj__UserMentions = new(string)
						}

						/* handler: tmp_uj__UserMentions type=string kind=string quoted=false*/

						{

							{
								if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
									return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
								}
							}

							if tok == fflib.FFTok_null {

								tmp_uj__UserMentions = nil

							} else {

								var tval string
								outBuf := fs.Output.Bytes()

								tval = string(string(outBuf))
								tmp_uj__UserMentions = &tval

							}
						}

					}
				}

				uj.UserMentions = append(uj.UserMentions, tmp_uj__UserMentions)
				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *Hashtag) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Hashtag) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"indices":`)
	if mj.Indices != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Indices {
			if i != 0 {
				buf.WriteString(`,`)
			}
			fflib.FormatBits2(buf, uint64(v), 10, v < 0)
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"text":`)
	fflib.WriteJsonString(buf, string(mj.Text))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Hashtagbase = iota
	ffj_t_Hashtagno_such_key

	ffj_t_Hashtag_Indices

	ffj_t_Hashtag_Text
)

var ffj_key_Hashtag_Indices = []byte("indices")

var ffj_key_Hashtag_Text = []byte("text")

func (uj *Hashtag) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Hashtag) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Hashtagbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Hashtagno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'i':

					if bytes.Equal(ffj_key_Hashtag_Indices, kn) {
						currentKey = ffj_t_Hashtag_Indices
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_Hashtag_Text, kn) {
						currentKey = ffj_t_Hashtag_Text
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Hashtag_Text, kn) {
					currentKey = ffj_t_Hashtag_Text
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Hashtag_Indices, kn) {
					currentKey = ffj_t_Hashtag_Indices
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Hashtagno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Hashtag_Indices:
					goto handle_Indices

				case ffj_t_Hashtag_Text:
					goto handle_Text

				case ffj_t_Hashtagno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Indices:

	/* handler: uj.Indices type=[]int kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Indices = nil
		} else {

			uj.Indices = make([]int, 0)

			wantVal := true

			for {

				var tmp_uj__Indices int

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Indices type=int kind=int quoted=false*/

				{
					if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
						return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
					}
				}

				{

					if tok == fflib.FFTok_null {

					} else {

						tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

						if err != nil {
							return fs.WrapErr(err)
						}

						tmp_uj__Indices = int(tval)

					}
				}

				uj.Indices = append(uj.Indices, tmp_uj__Indices)
				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Text:

	/* handler: uj.Text type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Text = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *LargeStruct) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *LargeStruct) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"search_metadata":`)

	{

		err = mj.SearchMetadata.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"statuses":`)
	if mj.Statuses != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Statuses {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_LargeStructbase = iota
	ffj_t_LargeStructno_such_key

	ffj_t_LargeStruct_SearchMetadata

	ffj_t_LargeStruct_Statuses
)

var ffj_key_LargeStruct_SearchMetadata = []byte("search_metadata")

var ffj_key_LargeStruct_Statuses = []byte("statuses")

func (uj *LargeStruct) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *LargeStruct) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_LargeStructbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_LargeStructno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 's':

					if bytes.Equal(ffj_key_LargeStruct_SearchMetadata, kn) {
						currentKey = ffj_t_LargeStruct_SearchMetadata
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_LargeStruct_Statuses, kn) {
						currentKey = ffj_t_LargeStruct_Statuses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_LargeStruct_Statuses, kn) {
					currentKey = ffj_t_LargeStruct_Statuses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_LargeStruct_SearchMetadata, kn) {
					currentKey = ffj_t_LargeStruct_SearchMetadata
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_LargeStructno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_LargeStruct_SearchMetadata:
					goto handle_SearchMetadata

				case ffj_t_LargeStruct_Statuses:
					goto handle_Statuses

				case ffj_t_LargeStructno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_SearchMetadata:

	/* handler: uj.SearchMetadata type=benchmark.SearchMetadata kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.SearchMetadata.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Statuses:

	/* handler: uj.Statuses type=[]benchmark.Status kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Statuses = nil
		} else {

			uj.Statuses = make([]Status, 0)

			wantVal := true

			for {

				var tmp_uj__Statuses Status

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Statuses type=benchmark.Status kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Statuses.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Statuses = append(uj.Statuses, tmp_uj__Statuses)
				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *SearchMetadata) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *SearchMetadata) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"completed_in":`)
	fflib.AppendFloat(buf, float64(mj.CompletedIn), 'g', -1, 64)
	buf.WriteString(`,"count":`)
	fflib.FormatBits2(buf, uint64(mj.Count), 10, mj.Count < 0)
	buf.WriteString(`,"max_id":`)
	fflib.FormatBits2(buf, uint64(mj.MaxID), 10, mj.MaxID < 0)
	buf.WriteString(`,"max_id_str":`)
	fflib.WriteJsonString(buf, string(mj.MaxIDStr))
	buf.WriteString(`,"next_results":`)
	fflib.WriteJsonString(buf, string(mj.NextResults))
	buf.WriteString(`,"query":`)
	fflib.WriteJsonString(buf, string(mj.Query))
	buf.WriteString(`,"refresh_url":`)
	fflib.WriteJsonString(buf, string(mj.RefreshURL))
	buf.WriteString(`,"since_id":`)
	fflib.FormatBits2(buf, uint64(mj.SinceID), 10, mj.SinceID < 0)
	buf.WriteString(`,"since_id_str":`)
	fflib.WriteJsonString(buf, string(mj.SinceIDStr))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_SearchMetadatabase = iota
	ffj_t_SearchMetadatano_such_key

	ffj_t_SearchMetadata_CompletedIn

	ffj_t_SearchMetadata_Count

	ffj_t_SearchMetadata_MaxID

	ffj_t_SearchMetadata_MaxIDStr

	ffj_t_SearchMetadata_NextResults

	ffj_t_SearchMetadata_Query

	ffj_t_SearchMetadata_RefreshURL

	ffj_t_SearchMetadata_SinceID

	ffj_t_SearchMetadata_SinceIDStr
)

var ffj_key_SearchMetadata_CompletedIn = []byte("completed_in")

var ffj_key_SearchMetadata_Count = []byte("count")

var ffj_key_SearchMetadata_MaxID = []byte("max_id")

var ffj_key_SearchMetadata_MaxIDStr = []byte("max_id_str")

var ffj_key_SearchMetadata_NextResults = []byte("next_results")

var ffj_key_SearchMetadata_Query = []byte("query")

var ffj_key_SearchMetadata_RefreshURL = []byte("refresh_url")

var ffj_key_SearchMetadata_SinceID = []byte("since_id")

var ffj_key_SearchMetadata_SinceIDStr = []byte("since_id_str")

func (uj *SearchMetadata) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *SearchMetadata) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_SearchMetadatabase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_SearchMetadatano_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_SearchMetadata_CompletedIn, kn) {
						currentKey = ffj_t_SearchMetadata_CompletedIn
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_SearchMetadata_Count, kn) {
						currentKey = ffj_t_SearchMetadata_Count
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffj_key_SearchMetadata_MaxID, kn) {
						currentKey = ffj_t_SearchMetadata_MaxID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_SearchMetadata_MaxIDStr, kn) {
						currentKey = ffj_t_SearchMetadata_MaxIDStr
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_SearchMetadata_NextResults, kn) {
						currentKey = ffj_t_SearchMetadata_NextResults
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'q':

					if bytes.Equal(ffj_key_SearchMetadata_Query, kn) {
						currentKey = ffj_t_SearchMetadata_Query
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_SearchMetadata_RefreshURL, kn) {
						currentKey = ffj_t_SearchMetadata_RefreshURL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_SearchMetadata_SinceID, kn) {
						currentKey = ffj_t_SearchMetadata_SinceID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_SearchMetadata_SinceIDStr, kn) {
						currentKey = ffj_t_SearchMetadata_SinceIDStr
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_SearchMetadata_SinceIDStr, kn) {
					currentKey = ffj_t_SearchMetadata_SinceIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_SearchMetadata_SinceID, kn) {
					currentKey = ffj_t_SearchMetadata_SinceID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_SearchMetadata_RefreshURL, kn) {
					currentKey = ffj_t_SearchMetadata_RefreshURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_SearchMetadata_Query, kn) {
					currentKey = ffj_t_SearchMetadata_Query
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_SearchMetadata_NextResults, kn) {
					currentKey = ffj_t_SearchMetadata_NextResults
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_SearchMetadata_MaxIDStr, kn) {
					currentKey = ffj_t_SearchMetadata_MaxIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_SearchMetadata_MaxID, kn) {
					currentKey = ffj_t_SearchMetadata_MaxID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_SearchMetadata_Count, kn) {
					currentKey = ffj_t_SearchMetadata_Count
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_SearchMetadata_CompletedIn, kn) {
					currentKey = ffj_t_SearchMetadata_CompletedIn
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_SearchMetadatano_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_SearchMetadata_CompletedIn:
					goto handle_CompletedIn

				case ffj_t_SearchMetadata_Count:
					goto handle_Count

				case ffj_t_SearchMetadata_MaxID:
					goto handle_MaxID

				case ffj_t_SearchMetadata_MaxIDStr:
					goto handle_MaxIDStr

				case ffj_t_SearchMetadata_NextResults:
					goto handle_NextResults

				case ffj_t_SearchMetadata_Query:
					goto handle_Query

				case ffj_t_SearchMetadata_RefreshURL:
					goto handle_RefreshURL

				case ffj_t_SearchMetadata_SinceID:
					goto handle_SinceID

				case ffj_t_SearchMetadata_SinceIDStr:
					goto handle_SinceIDStr

				case ffj_t_SearchMetadatano_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_CompletedIn:

	/* handler: uj.CompletedIn type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.CompletedIn = float64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Count:

	/* handler: uj.Count type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Count = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_MaxID:

	/* handler: uj.MaxID type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.MaxID = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_MaxIDStr:

	/* handler: uj.MaxIDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.MaxIDStr = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NextResults:

	/* handler: uj.NextResults type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.NextResults = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Query:

	/* handler: uj.Query type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Query = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_RefreshURL:

	/* handler: uj.RefreshURL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.RefreshURL = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_SinceID:

	/* handler: uj.SinceID type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.SinceID = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_SinceIDStr:

	/* handler: uj.SinceIDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.SinceIDStr = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *Status) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Status) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	if mj.Contributors != nil {
		buf.WriteString(`{"contributors":`)
		fflib.WriteJsonString(buf, string(*mj.Contributors))
	} else {
		buf.WriteString(`{"contributors":null`)
	}
	if mj.Coordinates != nil {
		buf.WriteString(`,"coordinates":`)
		fflib.WriteJsonString(buf, string(*mj.Coordinates))
	} else {
		buf.WriteString(`,"coordinates":null`)
	}
	buf.WriteString(`,"created_at":`)
	fflib.WriteJsonString(buf, string(mj.CreatedAt))
	buf.WriteString(`,"entities":`)

	{

		err = mj.Entities.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	if mj.Favorited {
		buf.WriteString(`,"favorited":true`)
	} else {
		buf.WriteString(`,"favorited":false`)
	}
	if mj.Geo != nil {
		buf.WriteString(`,"geo":`)
		fflib.WriteJsonString(buf, string(*mj.Geo))
	} else {
		buf.WriteString(`,"geo":null`)
	}
	buf.WriteString(`,"id":`)
	fflib.FormatBits2(buf, uint64(mj.ID), 10, mj.ID < 0)
	buf.WriteString(`,"id_str":`)
	fflib.WriteJsonString(buf, string(mj.IDStr))
	if mj.InReplyToScreenName != nil {
		buf.WriteString(`,"in_reply_to_screen_name":`)
		fflib.WriteJsonString(buf, string(*mj.InReplyToScreenName))
	} else {
		buf.WriteString(`,"in_reply_to_screen_name":null`)
	}
	if mj.InReplyToStatusID != nil {
		buf.WriteString(`,"in_reply_to_status_id":`)
		fflib.WriteJsonString(buf, string(*mj.InReplyToStatusID))
	} else {
		buf.WriteString(`,"in_reply_to_status_id":null`)
	}
	if mj.InReplyToStatusIDStr != nil {
		buf.WriteString(`,"in_reply_to_status_id_str":`)
		fflib.WriteJsonString(buf, string(*mj.InReplyToStatusIDStr))
	} else {
		buf.WriteString(`,"in_reply_to_status_id_str":null`)
	}
	if mj.InReplyToUserID != nil {
		buf.WriteString(`,"in_reply_to_user_id":`)
		fflib.WriteJsonString(buf, string(*mj.InReplyToUserID))
	} else {
		buf.WriteString(`,"in_reply_to_user_id":null`)
	}
	if mj.InReplyToUserIDStr != nil {
		buf.WriteString(`,"in_reply_to_user_id_str":`)
		fflib.WriteJsonString(buf, string(*mj.InReplyToUserIDStr))
	} else {
		buf.WriteString(`,"in_reply_to_user_id_str":null`)
	}
	buf.WriteString(`,"metadata":`)

	{

		err = mj.Metadata.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	if mj.Place != nil {
		buf.WriteString(`,"place":`)
		fflib.WriteJsonString(buf, string(*mj.Place))
	} else {
		buf.WriteString(`,"place":null`)
	}
	buf.WriteString(`,"retweet_count":`)
	fflib.FormatBits2(buf, uint64(mj.RetweetCount), 10, mj.RetweetCount < 0)
	if mj.Retweeted {
		buf.WriteString(`,"retweeted":true`)
	} else {
		buf.WriteString(`,"retweeted":false`)
	}
	buf.WriteString(`,"source":`)
	fflib.WriteJsonString(buf, string(mj.Source))
	buf.WriteString(`,"text":`)
	fflib.WriteJsonString(buf, string(mj.Text))
	if mj.Truncated {
		buf.WriteString(`,"truncated":true`)
	} else {
		buf.WriteString(`,"truncated":false`)
	}
	buf.WriteString(`,"user":`)

	{

		err = mj.User.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Statusbase = iota
	ffj_t_Statusno_such_key

	ffj_t_Status_Contributors

	ffj_t_Status_Coordinates

	ffj_t_Status_CreatedAt

	ffj_t_Status_Entities

	ffj_t_Status_Favorited

	ffj_t_Status_Geo

	ffj_t_Status_ID

	ffj_t_Status_IDStr

	ffj_t_Status_InReplyToScreenName

	ffj_t_Status_InReplyToStatusID

	ffj_t_Status_InReplyToStatusIDStr

	ffj_t_Status_InReplyToUserID

	ffj_t_Status_InReplyToUserIDStr

	ffj_t_Status_Metadata

	ffj_t_Status_Place

	ffj_t_Status_RetweetCount

	ffj_t_Status_Retweeted

	ffj_t_Status_Source

	ffj_t_Status_Text

	ffj_t_Status_Truncated

	ffj_t_Status_User
)

var ffj_key_Status_Contributors = []byte("contributors")

var ffj_key_Status_Coordinates = []byte("coordinates")

var ffj_key_Status_CreatedAt = []byte("created_at")

var ffj_key_Status_Entities = []byte("entities")

var ffj_key_Status_Favorited = []byte("favorited")

var ffj_key_Status_Geo = []byte("geo")

var ffj_key_Status_ID = []byte("id")

var ffj_key_Status_IDStr = []byte("id_str")

var ffj_key_Status_InReplyToScreenName = []byte("in_reply_to_screen_name")

var ffj_key_Status_InReplyToStatusID = []byte("in_reply_to_status_id")

var ffj_key_Status_InReplyToStatusIDStr = []byte("in_reply_to_status_id_str")

var ffj_key_Status_InReplyToUserID = []byte("in_reply_to_user_id")

var ffj_key_Status_InReplyToUserIDStr = []byte("in_reply_to_user_id_str")

var ffj_key_Status_Metadata = []byte("metadata")

var ffj_key_Status_Place = []byte("place")

var ffj_key_Status_RetweetCount = []byte("retweet_count")

var ffj_key_Status_Retweeted = []byte("retweeted")

var ffj_key_Status_Source = []byte("source")

var ffj_key_Status_Text = []byte("text")

var ffj_key_Status_Truncated = []byte("truncated")

var ffj_key_Status_User = []byte("user")

func (uj *Status) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Status) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Statusbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Statusno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_Status_Contributors, kn) {
						currentKey = ffj_t_Status_Contributors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_Coordinates, kn) {
						currentKey = ffj_t_Status_Coordinates
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_CreatedAt, kn) {
						currentKey = ffj_t_Status_CreatedAt
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffj_key_Status_Entities, kn) {
						currentKey = ffj_t_Status_Entities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffj_key_Status_Favorited, kn) {
						currentKey = ffj_t_Status_Favorited
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'g':

					if bytes.Equal(ffj_key_Status_Geo, kn) {
						currentKey = ffj_t_Status_Geo
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_Status_ID, kn) {
						currentKey = ffj_t_Status_ID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_IDStr, kn) {
						currentKey = ffj_t_Status_IDStr
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_InReplyToScreenName, kn) {
						currentKey = ffj_t_Status_InReplyToScreenName
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_InReplyToStatusID, kn) {
						currentKey = ffj_t_Status_InReplyToStatusID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_InReplyToStatusIDStr, kn) {
						currentKey = ffj_t_Status_InReplyToStatusIDStr
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_InReplyToUserID, kn) {
						currentKey = ffj_t_Status_InReplyToUserID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_InReplyToUserIDStr, kn) {
						currentKey = ffj_t_Status_InReplyToUserIDStr
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffj_key_Status_Metadata, kn) {
						currentKey = ffj_t_Status_Metadata
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_Status_Place, kn) {
						currentKey = ffj_t_Status_Place
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_Status_RetweetCount, kn) {
						currentKey = ffj_t_Status_RetweetCount
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_Retweeted, kn) {
						currentKey = ffj_t_Status_Retweeted
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_Status_Source, kn) {
						currentKey = ffj_t_Status_Source
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_Status_Text, kn) {
						currentKey = ffj_t_Status_Text
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Status_Truncated, kn) {
						currentKey = ffj_t_Status_Truncated
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_Status_User, kn) {
						currentKey = ffj_t_Status_User
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Status_User, kn) {
					currentKey = ffj_t_Status_User
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Status_Truncated, kn) {
					currentKey = ffj_t_Status_Truncated
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Status_Text, kn) {
					currentKey = ffj_t_Status_Text
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_Source, kn) {
					currentKey = ffj_t_Status_Source
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Status_Retweeted, kn) {
					currentKey = ffj_t_Status_Retweeted
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Status_RetweetCount, kn) {
					currentKey = ffj_t_Status_RetweetCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Status_Place, kn) {
					currentKey = ffj_t_Status_Place
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Status_Metadata, kn) {
					currentKey = ffj_t_Status_Metadata
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_InReplyToUserIDStr, kn) {
					currentKey = ffj_t_Status_InReplyToUserIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_InReplyToUserID, kn) {
					currentKey = ffj_t_Status_InReplyToUserID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_InReplyToStatusIDStr, kn) {
					currentKey = ffj_t_Status_InReplyToStatusIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_InReplyToStatusID, kn) {
					currentKey = ffj_t_Status_InReplyToStatusID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_InReplyToScreenName, kn) {
					currentKey = ffj_t_Status_InReplyToScreenName
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_IDStr, kn) {
					currentKey = ffj_t_Status_IDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Status_ID, kn) {
					currentKey = ffj_t_Status_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Status_Geo, kn) {
					currentKey = ffj_t_Status_Geo
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Status_Favorited, kn) {
					currentKey = ffj_t_Status_Favorited
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_Entities, kn) {
					currentKey = ffj_t_Status_Entities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Status_CreatedAt, kn) {
					currentKey = ffj_t_Status_CreatedAt
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_Coordinates, kn) {
					currentKey = ffj_t_Status_Coordinates
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Status_Contributors, kn) {
					currentKey = ffj_t_Status_Contributors
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Statusno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Status_Contributors:
					goto handle_Contributors

				case ffj_t_Status_Coordinates:
					goto handle_Coordinates

				case ffj_t_Status_CreatedAt:
					goto handle_CreatedAt

				case ffj_t_Status_Entities:
					goto handle_Entities

				case ffj_t_Status_Favorited:
					goto handle_Favorited

				case ffj_t_Status_Geo:
					goto handle_Geo

				case ffj_t_Status_ID:
					goto handle_ID

				case ffj_t_Status_IDStr:
					goto handle_IDStr

				case ffj_t_Status_InReplyToScreenName:
					goto handle_InReplyToScreenName

				case ffj_t_Status_InReplyToStatusID:
					goto handle_InReplyToStatusID

				case ffj_t_Status_InReplyToStatusIDStr:
					goto handle_InReplyToStatusIDStr

				case ffj_t_Status_InReplyToUserID:
					goto handle_InReplyToUserID

				case ffj_t_Status_InReplyToUserIDStr:
					goto handle_InReplyToUserIDStr

				case ffj_t_Status_Metadata:
					goto handle_Metadata

				case ffj_t_Status_Place:
					goto handle_Place

				case ffj_t_Status_RetweetCount:
					goto handle_RetweetCount

				case ffj_t_Status_Retweeted:
					goto handle_Retweeted

				case ffj_t_Status_Source:
					goto handle_Source

				case ffj_t_Status_Text:
					goto handle_Text

				case ffj_t_Status_Truncated:
					goto handle_Truncated

				case ffj_t_Status_User:
					goto handle_User

				case ffj_t_Statusno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Contributors:

	/* handler: uj.Contributors type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Contributors = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Contributors = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Coordinates:

	/* handler: uj.Coordinates type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Coordinates = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Coordinates = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CreatedAt:

	/* handler: uj.CreatedAt type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.CreatedAt = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Entities:

	/* handler: uj.Entities type=benchmark.Entities kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Entities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Favorited:

	/* handler: uj.Favorited type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.Favorited = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.Favorited = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Geo:

	/* handler: uj.Geo type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Geo = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Geo = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ID:

	/* handler: uj.ID type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.ID = int64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IDStr:

	/* handler: uj.IDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.IDStr = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToScreenName:

	/* handler: uj.InReplyToScreenName type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.InReplyToScreenName = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.InReplyToScreenName = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToStatusID:

	/* handler: uj.InReplyToStatusID type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.InReplyToStatusID = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.InReplyToStatusID = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToStatusIDStr:

	/* handler: uj.InReplyToStatusIDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.InReplyToStatusIDStr = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.InReplyToStatusIDStr = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToUserID:

	/* handler: uj.InReplyToUserID type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.InReplyToUserID = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.InReplyToUserID = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToUserIDStr:

	/* handler: uj.InReplyToUserIDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.InReplyToUserIDStr = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.InReplyToUserIDStr = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Metadata:

	/* handler: uj.Metadata type=benchmark.StatusMetadata kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Metadata.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Place:

	/* handler: uj.Place type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Place = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Place = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_RetweetCount:

	/* handler: uj.RetweetCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.RetweetCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Retweeted:

	/* handler: uj.Retweeted type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.Retweeted = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.Retweeted = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Source:

	/* handler: uj.Source type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Source = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Text:

	/* handler: uj.Text type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Text = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Truncated:

	/* handler: uj.Truncated type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.Truncated = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.Truncated = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_User:

	/* handler: uj.User type=benchmark.User kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.User.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *StatusMetadata) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *StatusMetadata) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"iso_language_code":`)
	fflib.WriteJsonString(buf, string(mj.IsoLanguageCode))
	buf.WriteString(`,"result_type":`)
	fflib.WriteJsonString(buf, string(mj.ResultType))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_StatusMetadatabase = iota
	ffj_t_StatusMetadatano_such_key

	ffj_t_StatusMetadata_IsoLanguageCode

	ffj_t_StatusMetadata_ResultType
)

var ffj_key_StatusMetadata_IsoLanguageCode = []byte("iso_language_code")

var ffj_key_StatusMetadata_ResultType = []byte("result_type")

func (uj *StatusMetadata) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *StatusMetadata) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_StatusMetadatabase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_StatusMetadatano_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'i':

					if bytes.Equal(ffj_key_StatusMetadata_IsoLanguageCode, kn) {
						currentKey = ffj_t_StatusMetadata_IsoLanguageCode
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_StatusMetadata_ResultType, kn) {
						currentKey = ffj_t_StatusMetadata_ResultType
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_StatusMetadata_ResultType, kn) {
					currentKey = ffj_t_StatusMetadata_ResultType
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_StatusMetadata_IsoLanguageCode, kn) {
					currentKey = ffj_t_StatusMetadata_IsoLanguageCode
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_StatusMetadatano_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_StatusMetadata_IsoLanguageCode:
					goto handle_IsoLanguageCode

				case ffj_t_StatusMetadata_ResultType:
					goto handle_ResultType

				case ffj_t_StatusMetadatano_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_IsoLanguageCode:

	/* handler: uj.IsoLanguageCode type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.IsoLanguageCode = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ResultType:

	/* handler: uj.ResultType type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ResultType = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *URL) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *URL) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	if mj.ExpandedURL != nil {
		buf.WriteString(`{"expanded_url":`)
		fflib.WriteJsonString(buf, string(*mj.ExpandedURL))
	} else {
		buf.WriteString(`{"expanded_url":null`)
	}
	buf.WriteString(`,"indices":`)
	if mj.Indices != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Indices {
			if i != 0 {
				buf.WriteString(`,`)
			}
			fflib.FormatBits2(buf, uint64(v), 10, v < 0)
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"url":`)
	fflib.WriteJsonString(buf, string(mj.URL))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_URLbase = iota
	ffj_t_URLno_such_key

	ffj_t_URL_ExpandedURL

	ffj_t_URL_Indices

	ffj_t_URL_URL
)

var ffj_key_URL_ExpandedURL = []byte("expanded_url")

var ffj_key_URL_Indices = []byte("indices")

var ffj_key_URL_URL = []byte("url")

func (uj *URL) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *URL) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_URLbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_URLno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'e':

					if bytes.Equal(ffj_key_URL_ExpandedURL, kn) {
						currentKey = ffj_t_URL_ExpandedURL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_URL_Indices, kn) {
						currentKey = ffj_t_URL_Indices
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_URL_URL, kn) {
						currentKey = ffj_t_URL_URL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_URL_URL, kn) {
					currentKey = ffj_t_URL_URL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_URL_Indices, kn) {
					currentKey = ffj_t_URL_Indices
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_URL_ExpandedURL, kn) {
					currentKey = ffj_t_URL_ExpandedURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_URLno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_URL_ExpandedURL:
					goto handle_ExpandedURL

				case ffj_t_URL_Indices:
					goto handle_Indices

				case ffj_t_URL_URL:
					goto handle_URL

				case ffj_t_URLno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ExpandedURL:

	/* handler: uj.ExpandedURL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.ExpandedURL = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.ExpandedURL = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Indices:

	/* handler: uj.Indices type=[]int kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Indices = nil
		} else {

			uj.Indices = make([]int, 0)

			wantVal := true

			for {

				var tmp_uj__Indices int

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Indices type=int kind=int quoted=false*/

				{
					if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
						return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
					}
				}

				{

					if tok == fflib.FFTok_null {

					} else {

						tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

						if err != nil {
							return fs.WrapErr(err)
						}

						tmp_uj__Indices = int(tval)

					}
				}

				uj.Indices = append(uj.Indices, tmp_uj__Indices)
				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_URL:

	/* handler: uj.URL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.URL = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *User) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *User) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	if mj.ContributorsEnabled {
		buf.WriteString(`{"contributors_enabled":true`)
	} else {
		buf.WriteString(`{"contributors_enabled":false`)
	}
	buf.WriteString(`,"created_at":`)
	fflib.WriteJsonString(buf, string(mj.CreatedAt))
	if mj.DefaultProfile {
		buf.WriteString(`,"default_profile":true`)
	} else {
		buf.WriteString(`,"default_profile":false`)
	}
	if mj.DefaultProfileImage {
		buf.WriteString(`,"default_profile_image":true`)
	} else {
		buf.WriteString(`,"default_profile_image":false`)
	}
	buf.WriteString(`,"description":`)
	fflib.WriteJsonString(buf, string(mj.Description))
	buf.WriteString(`,"entities":`)

	{

		err = mj.Entities.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"favourites_count":`)
	fflib.FormatBits2(buf, uint64(mj.FavouritesCount), 10, mj.FavouritesCount < 0)
	if mj.FollowRequestSent != nil {
		buf.WriteString(`,"follow_request_sent":`)
		fflib.WriteJsonString(buf, string(*mj.FollowRequestSent))
	} else {
		buf.WriteString(`,"follow_request_sent":null`)
	}
	buf.WriteString(`,"followers_count":`)
	fflib.FormatBits2(buf, uint64(mj.FollowersCount), 10, mj.FollowersCount < 0)
	if mj.Following != nil {
		buf.WriteString(`,"following":`)
		fflib.WriteJsonString(buf, string(*mj.Following))
	} else {
		buf.WriteString(`,"following":null`)
	}
	buf.WriteString(`,"friends_count":`)
	fflib.FormatBits2(buf, uint64(mj.FriendsCount), 10, mj.FriendsCount < 0)
	if mj.GeoEnabled {
		buf.WriteString(`,"geo_enabled":true`)
	} else {
		buf.WriteString(`,"geo_enabled":false`)
	}
	buf.WriteString(`,"id":`)
	fflib.FormatBits2(buf, uint64(mj.ID), 10, mj.ID < 0)
	buf.WriteString(`,"id_str":`)
	fflib.WriteJsonString(buf, string(mj.IDStr))
	if mj.IsTranslator {
		buf.WriteString(`,"is_translator":true`)
	} else {
		buf.WriteString(`,"is_translator":false`)
	}
	buf.WriteString(`,"lang":`)
	fflib.WriteJsonString(buf, string(mj.Lang))
	buf.WriteString(`,"listed_count":`)
	fflib.FormatBits2(buf, uint64(mj.ListedCount), 10, mj.ListedCount < 0)
	buf.WriteString(`,"location":`)
	fflib.WriteJsonString(buf, string(mj.Location))
	buf.WriteString(`,"name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	if mj.Notifications != nil {
		buf.WriteString(`,"notifications":`)
		fflib.WriteJsonString(buf, string(*mj.Notifications))
	} else {
		buf.WriteString(`,"notifications":null`)
	}
	buf.WriteString(`,"profile_background_color":`)
	fflib.WriteJsonString(buf, string(mj.ProfileBackgroundColor))
	buf.WriteString(`,"profile_background_image_url":`)
	fflib.WriteJsonString(buf, string(mj.ProfileBackgroundImageURL))
	buf.WriteString(`,"profile_background_image_url_https":`)
	fflib.WriteJsonString(buf, string(mj.ProfileBackgroundImageURLHTTPS))
	if mj.ProfileBackgroundTile {
		buf.WriteString(`,"profile_background_tile":true`)
	} else {
		buf.WriteString(`,"profile_background_tile":false`)
	}
	buf.WriteString(`,"profile_image_url":`)
	fflib.WriteJsonString(buf, string(mj.ProfileImageURL))
	buf.WriteString(`,"profile_image_url_https":`)
	fflib.WriteJsonString(buf, string(mj.ProfileImageURLHTTPS))
	buf.WriteString(`,"profile_link_color":`)
	fflib.WriteJsonString(buf, string(mj.ProfileLinkColor))
	buf.WriteString(`,"profile_sidebar_border_color":`)
	fflib.WriteJsonString(buf, string(mj.ProfileSidebarBorderColor))
	buf.WriteString(`,"profile_sidebar_fill_color":`)
	fflib.WriteJsonString(buf, string(mj.ProfileSidebarFillColor))
	buf.WriteString(`,"profile_text_color":`)
	fflib.WriteJsonString(buf, string(mj.ProfileTextColor))
	if mj.ProfileUseBackgroundImage {
		buf.WriteString(`,"profile_use_background_image":true`)
	} else {
		buf.WriteString(`,"profile_use_background_image":false`)
	}
	if mj.Protected {
		buf.WriteString(`,"protected":true`)
	} else {
		buf.WriteString(`,"protected":false`)
	}
	buf.WriteString(`,"screen_name":`)
	fflib.WriteJsonString(buf, string(mj.ScreenName))
	if mj.ShowAllInlineMedia {
		buf.WriteString(`,"show_all_inline_media":true`)
	} else {
		buf.WriteString(`,"show_all_inline_media":false`)
	}
	buf.WriteString(`,"statuses_count":`)
	fflib.FormatBits2(buf, uint64(mj.StatusesCount), 10, mj.StatusesCount < 0)
	buf.WriteString(`,"time_zone":`)
	fflib.WriteJsonString(buf, string(mj.TimeZone))
	if mj.URL != nil {
		buf.WriteString(`,"url":`)
		fflib.WriteJsonString(buf, string(*mj.URL))
	} else {
		buf.WriteString(`,"url":null`)
	}
	buf.WriteString(`,"utc_offset":`)
	fflib.FormatBits2(buf, uint64(mj.UtcOffset), 10, mj.UtcOffset < 0)
	if mj.Verified {
		buf.WriteString(`,"verified":true`)
	} else {
		buf.WriteString(`,"verified":false`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Userbase = iota
	ffj_t_Userno_such_key

	ffj_t_User_ContributorsEnabled

	ffj_t_User_CreatedAt

	ffj_t_User_DefaultProfile

	ffj_t_User_DefaultProfileImage

	ffj_t_User_Description

	ffj_t_User_Entities

	ffj_t_User_FavouritesCount

	ffj_t_User_FollowRequestSent

	ffj_t_User_FollowersCount

	ffj_t_User_Following

	ffj_t_User_FriendsCount

	ffj_t_User_GeoEnabled

	ffj_t_User_ID

	ffj_t_User_IDStr

	ffj_t_User_IsTranslator

	ffj_t_User_Lang

	ffj_t_User_ListedCount

	ffj_t_User_Location

	ffj_t_User_Name

	ffj_t_User_Notifications

	ffj_t_User_ProfileBackgroundColor

	ffj_t_User_ProfileBackgroundImageURL

	ffj_t_User_ProfileBackgroundImageURLHTTPS

	ffj_t_User_ProfileBackgroundTile

	ffj_t_User_ProfileImageURL

	ffj_t_User_ProfileImageURLHTTPS

	ffj_t_User_ProfileLinkColor

	ffj_t_User_ProfileSidebarBorderColor

	ffj_t_User_ProfileSidebarFillColor

	ffj_t_User_ProfileTextColor

	ffj_t_User_ProfileUseBackgroundImage

	ffj_t_User_Protected

	ffj_t_User_ScreenName

	ffj_t_User_ShowAllInlineMedia

	ffj_t_User_StatusesCount

	ffj_t_User_TimeZone

	ffj_t_User_URL

	ffj_t_User_UtcOffset

	ffj_t_User_Verified
)

var ffj_key_User_ContributorsEnabled = []byte("contributors_enabled")

var ffj_key_User_CreatedAt = []byte("created_at")

var ffj_key_User_DefaultProfile = []byte("default_profile")

var ffj_key_User_DefaultProfileImage = []byte("default_profile_image")

var ffj_key_User_Description = []byte("description")

var ffj_key_User_Entities = []byte("entities")

var ffj_key_User_FavouritesCount = []byte("favourites_count")

var ffj_key_User_FollowRequestSent = []byte("follow_request_sent")

var ffj_key_User_FollowersCount = []byte("followers_count")

var ffj_key_User_Following = []byte("following")

var ffj_key_User_FriendsCount = []byte("friends_count")

var ffj_key_User_GeoEnabled = []byte("geo_enabled")

var ffj_key_User_ID = []byte("id")

var ffj_key_User_IDStr = []byte("id_str")

var ffj_key_User_IsTranslator = []byte("is_translator")

var ffj_key_User_Lang = []byte("lang")

var ffj_key_User_ListedCount = []byte("listed_count")

var ffj_key_User_Location = []byte("location")

var ffj_key_User_Name = []byte("name")

var ffj_key_User_Notifications = []byte("notifications")

var ffj_key_User_ProfileBackgroundColor = []byte("profile_background_color")

var ffj_key_User_ProfileBackgroundImageURL = []byte("profile_background_image_url")

var ffj_key_User_ProfileBackgroundImageURLHTTPS = []byte("profile_background_image_url_https")

var ffj_key_User_ProfileBackgroundTile = []byte("profile_background_tile")

var ffj_key_User_ProfileImageURL = []byte("profile_image_url")

var ffj_key_User_ProfileImageURLHTTPS = []byte("profile_image_url_https")

var ffj_key_User_ProfileLinkColor = []byte("profile_link_color")

var ffj_key_User_ProfileSidebarBorderColor = []byte("profile_sidebar_border_color")

var ffj_key_User_ProfileSidebarFillColor = []byte("profile_sidebar_fill_color")

var ffj_key_User_ProfileTextColor = []byte("profile_text_color")

var ffj_key_User_ProfileUseBackgroundImage = []byte("profile_use_background_image")

var ffj_key_User_Protected = []byte("protected")

var ffj_key_User_ScreenName = []byte("screen_name")

var ffj_key_User_ShowAllInlineMedia = []byte("show_all_inline_media")

var ffj_key_User_StatusesCount = []byte("statuses_count")

var ffj_key_User_TimeZone = []byte("time_zone")

var ffj_key_User_URL = []byte("url")

var ffj_key_User_UtcOffset = []byte("utc_offset")

var ffj_key_User_Verified = []byte("verified")

func (uj *User) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *User) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Userbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Userno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_User_ContributorsEnabled, kn) {
						currentKey = ffj_t_User_ContributorsEnabled
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_CreatedAt, kn) {
						currentKey = ffj_t_User_CreatedAt
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_User_DefaultProfile, kn) {
						currentKey = ffj_t_User_DefaultProfile
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_DefaultProfileImage, kn) {
						currentKey = ffj_t_User_DefaultProfileImage
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_Description, kn) {
						currentKey = ffj_t_User_Description
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffj_key_User_Entities, kn) {
						currentKey = ffj_t_User_Entities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffj_key_User_FavouritesCount, kn) {
						currentKey = ffj_t_User_FavouritesCount
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_FollowRequestSent, kn) {
						currentKey = ffj_t_User_FollowRequestSent
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_FollowersCount, kn) {
						currentKey = ffj_t_User_FollowersCount
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_Following, kn) {
						currentKey = ffj_t_User_Following
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_FriendsCount, kn) {
						currentKey = ffj_t_User_FriendsCount
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'g':

					if bytes.Equal(ffj_key_User_GeoEnabled, kn) {
						currentKey = ffj_t_User_GeoEnabled
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_User_ID, kn) {
						currentKey = ffj_t_User_ID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_IDStr, kn) {
						currentKey = ffj_t_User_IDStr
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_IsTranslator, kn) {
						currentKey = ffj_t_User_IsTranslator
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_User_Lang, kn) {
						currentKey = ffj_t_User_Lang
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ListedCount, kn) {
						currentKey = ffj_t_User_ListedCount
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_Location, kn) {
						currentKey = ffj_t_User_Location
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_User_Name, kn) {
						currentKey = ffj_t_User_Name
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_Notifications, kn) {
						currentKey = ffj_t_User_Notifications
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_User_ProfileBackgroundColor, kn) {
						currentKey = ffj_t_User_ProfileBackgroundColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileBackgroundImageURL, kn) {
						currentKey = ffj_t_User_ProfileBackgroundImageURL
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileBackgroundImageURLHTTPS, kn) {
						currentKey = ffj_t_User_ProfileBackgroundImageURLHTTPS
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileBackgroundTile, kn) {
						currentKey = ffj_t_User_ProfileBackgroundTile
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileImageURL, kn) {
						currentKey = ffj_t_User_ProfileImageURL
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileImageURLHTTPS, kn) {
						currentKey = ffj_t_User_ProfileImageURLHTTPS
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileLinkColor, kn) {
						currentKey = ffj_t_User_ProfileLinkColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileSidebarBorderColor, kn) {
						currentKey = ffj_t_User_ProfileSidebarBorderColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileSidebarFillColor, kn) {
						currentKey = ffj_t_User_ProfileSidebarFillColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileTextColor, kn) {
						currentKey = ffj_t_User_ProfileTextColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ProfileUseBackgroundImage, kn) {
						currentKey = ffj_t_User_ProfileUseBackgroundImage
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_Protected, kn) {
						currentKey = ffj_t_User_Protected
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_User_ScreenName, kn) {
						currentKey = ffj_t_User_ScreenName
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_ShowAllInlineMedia, kn) {
						currentKey = ffj_t_User_ShowAllInlineMedia
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_StatusesCount, kn) {
						currentKey = ffj_t_User_StatusesCount
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_User_TimeZone, kn) {
						currentKey = ffj_t_User_TimeZone
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_User_URL, kn) {
						currentKey = ffj_t_User_URL
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_User_UtcOffset, kn) {
						currentKey = ffj_t_User_UtcOffset
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_User_Verified, kn) {
						currentKey = ffj_t_User_Verified
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_User_Verified, kn) {
					currentKey = ffj_t_User_Verified
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_UtcOffset, kn) {
					currentKey = ffj_t_User_UtcOffset
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_User_URL, kn) {
					currentKey = ffj_t_User_URL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_User_TimeZone, kn) {
					currentKey = ffj_t_User_TimeZone
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_StatusesCount, kn) {
					currentKey = ffj_t_User_StatusesCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ShowAllInlineMedia, kn) {
					currentKey = ffj_t_User_ShowAllInlineMedia
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ScreenName, kn) {
					currentKey = ffj_t_User_ScreenName
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_User_Protected, kn) {
					currentKey = ffj_t_User_Protected
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ProfileUseBackgroundImage, kn) {
					currentKey = ffj_t_User_ProfileUseBackgroundImage
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_User_ProfileTextColor, kn) {
					currentKey = ffj_t_User_ProfileTextColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ProfileSidebarFillColor, kn) {
					currentKey = ffj_t_User_ProfileSidebarFillColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ProfileSidebarBorderColor, kn) {
					currentKey = ffj_t_User_ProfileSidebarBorderColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ProfileLinkColor, kn) {
					currentKey = ffj_t_User_ProfileLinkColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ProfileImageURLHTTPS, kn) {
					currentKey = ffj_t_User_ProfileImageURLHTTPS
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_User_ProfileImageURL, kn) {
					currentKey = ffj_t_User_ProfileImageURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ProfileBackgroundTile, kn) {
					currentKey = ffj_t_User_ProfileBackgroundTile
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ProfileBackgroundImageURLHTTPS, kn) {
					currentKey = ffj_t_User_ProfileBackgroundImageURLHTTPS
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ProfileBackgroundImageURL, kn) {
					currentKey = ffj_t_User_ProfileBackgroundImageURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ProfileBackgroundColor, kn) {
					currentKey = ffj_t_User_ProfileBackgroundColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_Notifications, kn) {
					currentKey = ffj_t_User_Notifications
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_User_Name, kn) {
					currentKey = ffj_t_User_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_User_Location, kn) {
					currentKey = ffj_t_User_Location
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ListedCount, kn) {
					currentKey = ffj_t_User_ListedCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_User_Lang, kn) {
					currentKey = ffj_t_User_Lang
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_IsTranslator, kn) {
					currentKey = ffj_t_User_IsTranslator
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_IDStr, kn) {
					currentKey = ffj_t_User_IDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_User_ID, kn) {
					currentKey = ffj_t_User_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_User_GeoEnabled, kn) {
					currentKey = ffj_t_User_GeoEnabled
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_FriendsCount, kn) {
					currentKey = ffj_t_User_FriendsCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_User_Following, kn) {
					currentKey = ffj_t_User_Following
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_FollowersCount, kn) {
					currentKey = ffj_t_User_FollowersCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_FollowRequestSent, kn) {
					currentKey = ffj_t_User_FollowRequestSent
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_FavouritesCount, kn) {
					currentKey = ffj_t_User_FavouritesCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_Entities, kn) {
					currentKey = ffj_t_User_Entities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_Description, kn) {
					currentKey = ffj_t_User_Description
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_User_DefaultProfileImage, kn) {
					currentKey = ffj_t_User_DefaultProfileImage
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_User_DefaultProfile, kn) {
					currentKey = ffj_t_User_DefaultProfile
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_User_CreatedAt, kn) {
					currentKey = ffj_t_User_CreatedAt
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_User_ContributorsEnabled, kn) {
					currentKey = ffj_t_User_ContributorsEnabled
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Userno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_User_ContributorsEnabled:
					goto handle_ContributorsEnabled

				case ffj_t_User_CreatedAt:
					goto handle_CreatedAt

				case ffj_t_User_DefaultProfile:
					goto handle_DefaultProfile

				case ffj_t_User_DefaultProfileImage:
					goto handle_DefaultProfileImage

				case ffj_t_User_Description:
					goto handle_Description

				case ffj_t_User_Entities:
					goto handle_Entities

				case ffj_t_User_FavouritesCount:
					goto handle_FavouritesCount

				case ffj_t_User_FollowRequestSent:
					goto handle_FollowRequestSent

				case ffj_t_User_FollowersCount:
					goto handle_FollowersCount

				case ffj_t_User_Following:
					goto handle_Following

				case ffj_t_User_FriendsCount:
					goto handle_FriendsCount

				case ffj_t_User_GeoEnabled:
					goto handle_GeoEnabled

				case ffj_t_User_ID:
					goto handle_ID

				case ffj_t_User_IDStr:
					goto handle_IDStr

				case ffj_t_User_IsTranslator:
					goto handle_IsTranslator

				case ffj_t_User_Lang:
					goto handle_Lang

				case ffj_t_User_ListedCount:
					goto handle_ListedCount

				case ffj_t_User_Location:
					goto handle_Location

				case ffj_t_User_Name:
					goto handle_Name

				case ffj_t_User_Notifications:
					goto handle_Notifications

				case ffj_t_User_ProfileBackgroundColor:
					goto handle_ProfileBackgroundColor

				case ffj_t_User_ProfileBackgroundImageURL:
					goto handle_ProfileBackgroundImageURL

				case ffj_t_User_ProfileBackgroundImageURLHTTPS:
					goto handle_ProfileBackgroundImageURLHTTPS

				case ffj_t_User_ProfileBackgroundTile:
					goto handle_ProfileBackgroundTile

				case ffj_t_User_ProfileImageURL:
					goto handle_ProfileImageURL

				case ffj_t_User_ProfileImageURLHTTPS:
					goto handle_ProfileImageURLHTTPS

				case ffj_t_User_ProfileLinkColor:
					goto handle_ProfileLinkColor

				case ffj_t_User_ProfileSidebarBorderColor:
					goto handle_ProfileSidebarBorderColor

				case ffj_t_User_ProfileSidebarFillColor:
					goto handle_ProfileSidebarFillColor

				case ffj_t_User_ProfileTextColor:
					goto handle_ProfileTextColor

				case ffj_t_User_ProfileUseBackgroundImage:
					goto handle_ProfileUseBackgroundImage

				case ffj_t_User_Protected:
					goto handle_Protected

				case ffj_t_User_ScreenName:
					goto handle_ScreenName

				case ffj_t_User_ShowAllInlineMedia:
					goto handle_ShowAllInlineMedia

				case ffj_t_User_StatusesCount:
					goto handle_StatusesCount

				case ffj_t_User_TimeZone:
					goto handle_TimeZone

				case ffj_t_User_URL:
					goto handle_URL

				case ffj_t_User_UtcOffset:
					goto handle_UtcOffset

				case ffj_t_User_Verified:
					goto handle_Verified

				case ffj_t_Userno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ContributorsEnabled:

	/* handler: uj.ContributorsEnabled type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.ContributorsEnabled = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.ContributorsEnabled = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CreatedAt:

	/* handler: uj.CreatedAt type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.CreatedAt = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DefaultProfile:

	/* handler: uj.DefaultProfile type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.DefaultProfile = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.DefaultProfile = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DefaultProfileImage:

	/* handler: uj.DefaultProfileImage type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.DefaultProfileImage = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.DefaultProfileImage = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Description:

	/* handler: uj.Description type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Description = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Entities:

	/* handler: uj.Entities type=benchmark.UserEntities kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Entities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FavouritesCount:

	/* handler: uj.FavouritesCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.FavouritesCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FollowRequestSent:

	/* handler: uj.FollowRequestSent type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.FollowRequestSent = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.FollowRequestSent = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FollowersCount:

	/* handler: uj.FollowersCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.FollowersCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Following:

	/* handler: uj.Following type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Following = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Following = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FriendsCount:

	/* handler: uj.FriendsCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.FriendsCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_GeoEnabled:

	/* handler: uj.GeoEnabled type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.GeoEnabled = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.GeoEnabled = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ID:

	/* handler: uj.ID type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.ID = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IDStr:

	/* handler: uj.IDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.IDStr = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IsTranslator:

	/* handler: uj.IsTranslator type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.IsTranslator = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.IsTranslator = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Lang:

	/* handler: uj.Lang type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Lang = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ListedCount:

	/* handler: uj.ListedCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.ListedCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Location:

	/* handler: uj.Location type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Location = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Notifications:

	/* handler: uj.Notifications type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Notifications = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Notifications = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileBackgroundColor:

	/* handler: uj.ProfileBackgroundColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ProfileBackgroundColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileBackgroundImageURL:

	/* handler: uj.ProfileBackgroundImageURL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ProfileBackgroundImageURL = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileBackgroundImageURLHTTPS:

	/* handler: uj.ProfileBackgroundImageURLHTTPS type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ProfileBackgroundImageURLHTTPS = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileBackgroundTile:

	/* handler: uj.ProfileBackgroundTile type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.ProfileBackgroundTile = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.ProfileBackgroundTile = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileImageURL:

	/* handler: uj.ProfileImageURL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ProfileImageURL = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileImageURLHTTPS:

	/* handler: uj.ProfileImageURLHTTPS type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ProfileImageURLHTTPS = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileLinkColor:

	/* handler: uj.ProfileLinkColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ProfileLinkColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileSidebarBorderColor:

	/* handler: uj.ProfileSidebarBorderColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ProfileSidebarBorderColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileSidebarFillColor:

	/* handler: uj.ProfileSidebarFillColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ProfileSidebarFillColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileTextColor:

	/* handler: uj.ProfileTextColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ProfileTextColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileUseBackgroundImage:

	/* handler: uj.ProfileUseBackgroundImage type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.ProfileUseBackgroundImage = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.ProfileUseBackgroundImage = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Protected:

	/* handler: uj.Protected type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.Protected = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.Protected = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ScreenName:

	/* handler: uj.ScreenName type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ScreenName = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ShowAllInlineMedia:

	/* handler: uj.ShowAllInlineMedia type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.ShowAllInlineMedia = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.ShowAllInlineMedia = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_StatusesCount:

	/* handler: uj.StatusesCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.StatusesCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TimeZone:

	/* handler: uj.TimeZone type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.TimeZone = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_URL:

	/* handler: uj.URL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.URL = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.URL = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UtcOffset:

	/* handler: uj.UtcOffset type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.UtcOffset = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Verified:

	/* handler: uj.Verified type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				uj.Verified = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				uj.Verified = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *UserEntities) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *UserEntities) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"description":`)

	{

		err = mj.Description.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"url":`)

	{

		err = mj.URL.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_UserEntitiesbase = iota
	ffj_t_UserEntitiesno_such_key

	ffj_t_UserEntities_Description

	ffj_t_UserEntities_URL
)

var ffj_key_UserEntities_Description = []byte("description")

var ffj_key_UserEntities_URL = []byte("url")

func (uj *UserEntities) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *UserEntities) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_UserEntitiesbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_UserEntitiesno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'd':

					if bytes.Equal(ffj_key_UserEntities_Description, kn) {
						currentKey = ffj_t_UserEntities_Description
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_UserEntities_URL, kn) {
						currentKey = ffj_t_UserEntities_URL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_UserEntities_URL, kn) {
					currentKey = ffj_t_UserEntities_URL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_UserEntities_Description, kn) {
					currentKey = ffj_t_UserEntities_Description
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_UserEntitiesno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_UserEntities_Description:
					goto handle_Description

				case ffj_t_UserEntities_URL:
					goto handle_URL

				case ffj_t_UserEntitiesno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Description:

	/* handler: uj.Description type=benchmark.UserEntityDescription kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Description.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_URL:

	/* handler: uj.URL type=benchmark.UserEntityURL kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.URL.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *UserEntityDescription) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *UserEntityDescription) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"urls":`)
	if mj.Urls != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Urls {
			if i != 0 {
				buf.WriteString(`,`)
			}
			if v != nil {
				fflib.WriteJsonString(buf, string(*v))
			} else {
				buf.WriteString(`null`)
			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_UserEntityDescriptionbase = iota
	ffj_t_UserEntityDescriptionno_such_key

	ffj_t_UserEntityDescription_Urls
)

var ffj_key_UserEntityDescription_Urls = []byte("urls")

func (uj *UserEntityDescription) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *UserEntityDescription) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_UserEntityDescriptionbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_UserEntityDescriptionno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'u':

					if bytes.Equal(ffj_key_UserEntityDescription_Urls, kn) {
						currentKey = ffj_t_UserEntityDescription_Urls
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_UserEntityDescription_Urls, kn) {
					currentKey = ffj_t_UserEntityDescription_Urls
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_UserEntityDescriptionno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_UserEntityDescription_Urls:
					goto handle_Urls

				case ffj_t_UserEntityDescriptionno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Urls:

	/* handler: uj.Urls type=[]*string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Urls = nil
		} else {

			uj.Urls = make([]*string, 0)

			wantVal := true

			for {

				var tmp_uj__Urls *string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Urls type=*string kind=ptr quoted=false*/

				{

					if tok == fflib.FFTok_null {
						tmp_uj__Urls = nil
					} else {
						if tmp_uj__Urls == nil {
							tmp_uj__Urls = new(string)
						}

						/* handler: tmp_uj__Urls type=string kind=string quoted=false*/

						{

							{
								if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
									return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
								}
							}

							if tok == fflib.FFTok_null {

								tmp_uj__Urls = nil

							} else {

								var tval string
								outBuf := fs.Output.Bytes()

								tval = string(string(outBuf))
								tmp_uj__Urls = &tval

							}
						}

					}
				}

				uj.Urls = append(uj.Urls, tmp_uj__Urls)
				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *UserEntityURL) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *UserEntityURL) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"urls":`)
	if mj.Urls != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Urls {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_UserEntityURLbase = iota
	ffj_t_UserEntityURLno_such_key

	ffj_t_UserEntityURL_Urls
)

var ffj_key_UserEntityURL_Urls = []byte("urls")

func (uj *UserEntityURL) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *UserEntityURL) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_UserEntityURLbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_UserEntityURLno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'u':

					if bytes.Equal(ffj_key_UserEntityURL_Urls, kn) {
						currentKey = ffj_t_UserEntityURL_Urls
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_UserEntityURL_Urls, kn) {
					currentKey = ffj_t_UserEntityURL_Urls
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_UserEntityURLno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_UserEntityURL_Urls:
					goto handle_Urls

				case ffj_t_UserEntityURLno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Urls:

	/* handler: uj.Urls type=[]benchmark.URL kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Urls = nil
		} else {

			uj.Urls = make([]URL, 0)

			wantVal := true

			for {

				var tmp_uj__Urls URL

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Urls type=benchmark.URL kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Urls.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Urls = append(uj.Urls, tmp_uj__Urls)
				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}

func (mj *XLStruct) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *XLStruct) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"Data":`)
	if mj.Data != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Data {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_XLStructbase = iota
	ffj_t_XLStructno_such_key

	ffj_t_XLStruct_Data
)

var ffj_key_XLStruct_Data = []byte("Data")

func (uj *XLStruct) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *XLStruct) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_XLStructbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_XLStructno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'D':

					if bytes.Equal(ffj_key_XLStruct_Data, kn) {
						currentKey = ffj_t_XLStruct_Data
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_XLStruct_Data, kn) {
					currentKey = ffj_t_XLStruct_Data
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_XLStructno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_XLStruct_Data:
					goto handle_Data

				case ffj_t_XLStructno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Data:

	/* handler: uj.Data type=[]benchmark.LargeStruct kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Data = nil
		} else {

			uj.Data = make([]LargeStruct, 0)

			wantVal := true

			for {

				var tmp_uj__Data LargeStruct

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Data type=benchmark.LargeStruct kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Data.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Data = append(uj.Data, tmp_uj__Data)
				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:
	return nil
}
