// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1/io.proto

package automl

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Input configuration for
// [AutoMl.ImportData][google.cloud.automl.v1.AutoMl.ImportData] action.
//
// The format of input depends on dataset_metadata the Dataset into which
// the import is happening has. As input source the
// [gcs_source][google.cloud.automl.v1.InputConfig.gcs_source]
// is expected, unless specified otherwise. Additionally any input .CSV file
// by itself must be 100MB or smaller, unless specified otherwise.
// If an "example" file (that is, image, video etc.) with identical content
// (even if it had different `GCS_FILE_PATH`) is mentioned multiple times, then
// its label, bounding boxes etc. are appended. The same file should be always
// provided with the same `ML_USE` and `GCS_FILE_PATH`, if it is not, then
// these values are nondeterministically selected from the given ones.
//
// The formats are represented in EBNF with commas being literal and with
// non-terminal symbols defined near the end of this comment. The formats are:
//
// <h4>AutoML Vision</h4>
//
//
// <div class="ds-selector-tabs"><section><h5>Classification</h5>
//
// See [Preparing your training
// data](https://cloud.google.com/vision/automl/docs/prepare) for more
// information.
//
// CSV file(s) with each line in format:
//
//     ML_USE,GCS_FILE_PATH,LABEL,LABEL,...
//
// *   `ML_USE` - Identifies the data set that the current row (file) applies
// to.
//     This value can be one of the following:
//     * `TRAIN` - Rows in this file are used to train the model.
//     * `TEST` - Rows in this file are used to test the model during training.
//     * `UNASSIGNED` - Rows in this file are not categorized. They are
//        Automatically divided into train and test data. 80% for training and
//        20% for testing.
//
// *   `GCS_FILE_PATH` - The Google Cloud Storage location of an image of up to
//      30MB in size. Supported extensions: .JPEG, .GIF, .PNG, .WEBP, .BMP,
//      .TIFF, .ICO.
//
// *   `LABEL` - A label that identifies the object in the image.
//
// For the `MULTICLASS` classification type, at most one `LABEL` is allowed
// per image. If an image has not yet been labeled, then it should be
// mentioned just once with no `LABEL`.
//
// Some sample rows:
//
//     TRAIN,gs://folder/image1.jpg,daisy
//     TEST,gs://folder/image2.jpg,dandelion,tulip,rose
//     UNASSIGNED,gs://folder/image3.jpg,daisy
//     UNASSIGNED,gs://folder/image4.jpg
//
//
// </section><section><h5>Object Detection</h5>
// See [Preparing your training
// data](https://cloud.google.com/vision/automl/object-detection/docs/prepare)
// for more information.
//
// A CSV file(s) with each line in format:
//
//     ML_USE,GCS_FILE_PATH,[LABEL],(BOUNDING_BOX | ,,,,,,,)
//
// *   `ML_USE` - Identifies the data set that the current row (file) applies
// to.
//     This value can be one of the following:
//     * `TRAIN` - Rows in this file are used to train the model.
//     * `TEST` - Rows in this file are used to test the model during training.
//     * `UNASSIGNED` - Rows in this file are not categorized. They are
//        Automatically divided into train and test data. 80% for training and
//        20% for testing.
//
// *  `GCS_FILE_PATH` - The Google Cloud Storage location of an image of up to
//     30MB in size. Supported extensions: .JPEG, .GIF, .PNG. Each image
//     is assumed to be exhaustively labeled.
//
// *  `LABEL` - A label that identifies the object in the image specified by the
//    `BOUNDING_BOX`.
//
// *  `BOUNDING BOX` - The vertices of an object in the example image.
//    The minimum allowed `BOUNDING_BOX` edge length is 0.01, and no more than
//    500 `BOUNDING_BOX` instances per image are allowed (one `BOUNDING_BOX`
//    per line). If an image has no looked for objects then it should be
//    mentioned just once with no LABEL and the ",,,,,,," in place of the
//   `BOUNDING_BOX`.
//
// **Four sample rows:**
//
//     TRAIN,gs://folder/image1.png,car,0.1,0.1,,,0.3,0.3,,
//     TRAIN,gs://folder/image1.png,bike,.7,.6,,,.8,.9,,
//     UNASSIGNED,gs://folder/im2.png,car,0.1,0.1,0.2,0.1,0.2,0.3,0.1,0.3
//     TEST,gs://folder/im3.png,,,,,,,,,
//   </section>
// </div>
//
//
// <h4>AutoML Natural Language</h4>
//
//
// <div class="ds-selector-tabs"><section><h5>Entity Extraction</h5>
//
// See [Preparing your training
// data](/natural-language/automl/entity-analysis/docs/prepare) for more
// information.
//
// One or more CSV file(s) with each line in the following format:
//
//     ML_USE,GCS_FILE_PATH
//
// *   `ML_USE` - Identifies the data set that the current row (file) applies
// to.
//     This value can be one of the following:
//     * `TRAIN` - Rows in this file are used to train the model.
//     * `TEST` - Rows in this file are used to test the model during training.
//     * `UNASSIGNED` - Rows in this file are not categorized. They are
//        Automatically divided into train and test data. 80% for training and
//        20% for testing..
//
// *   `GCS_FILE_PATH` - a Identifies JSON Lines (.JSONL) file stored in
//      Google Cloud Storage that contains in-line text in-line as documents
//      for model training.
//
// After the training data set has been determined from the `TRAIN` and
// `UNASSIGNED` CSV files, the training data is divided into train and
// validation data sets. 70% for training and 30% for validation.
//
// For example:
//
//     TRAIN,gs://folder/file1.jsonl
//     VALIDATE,gs://folder/file2.jsonl
//     TEST,gs://folder/file3.jsonl
//
// **In-line JSONL files**
//
// In-line .JSONL files contain, per line, a JSON document that wraps a
// [`text_snippet`][google.cloud.automl.v1.TextSnippet] field followed by
// one or more [`annotations`][google.cloud.automl.v1.AnnotationPayload]
// fields, which have `display_name` and `text_extraction` fields to describe
// the entity from the text snippet. Multiple JSON documents can be separated
// using line breaks (\n).
//
// The supplied text must be annotated exhaustively. For example, if you
// include the text "horse", but do not label it as "animal",
// then "horse" is assumed to not be an "animal".
//
// Any given text snippet content must have 30,000 characters or
// less, and also be UTF-8 NFC encoded. ASCII is accepted as it is
// UTF-8 NFC encoded.
//
// For example:
//
//     {
//       "text_snippet": {
//         "content": "dog car cat"
//       },
//       "annotations": [
//          {
//            "display_name": "animal",
//            "text_extraction": {
//              "text_segment": {"start_offset": 0, "end_offset": 2}
//           }
//          },
//          {
//           "display_name": "vehicle",
//            "text_extraction": {
//              "text_segment": {"start_offset": 4, "end_offset": 6}
//            }
//          },
//          {
//            "display_name": "animal",
//            "text_extraction": {
//              "text_segment": {"start_offset": 8, "end_offset": 10}
//            }
//          }
//      ]
//     }\n
//     {
//        "text_snippet": {
//          "content": "This dog is good."
//        },
//        "annotations": [
//           {
//             "display_name": "animal",
//             "text_extraction": {
//               "text_segment": {"start_offset": 5, "end_offset": 7}
//             }
//           }
//        ]
//     }
//
// **JSONL files that reference documents**
//
// .JSONL files contain, per line, a JSON document that wraps a
// `input_config` that contains the path to a source PDF document.
// Multiple JSON documents can be separated using line breaks (\n).
//
// For example:
//
//     {
//       "document": {
//         "input_config": {
//           "gcs_source": { "input_uris": [ "gs://folder/document1.pdf" ]
//           }
//         }
//       }
//     }\n
//     {
//       "document": {
//         "input_config": {
//           "gcs_source": { "input_uris": [ "gs://folder/document2.pdf" ]
//           }
//         }
//       }
//     }
//
// **In-line JSONL files with PDF layout information**
//
// **Note:** You can only annotate PDF files using the UI. The format described
// below applies to annotated PDF files exported using the UI or `exportData`.
//
// In-line .JSONL files for PDF documents contain, per line, a JSON document
// that wraps a `document` field that provides the textual content of the PDF
// document and the layout information.
//
// For example:
//
//     {
//       "document": {
//               "document_text": {
//                 "content": "dog car cat"
//               }
//               "layout": [
//                 {
//                   "text_segment": {
//                     "start_offset": 0,
//                     "end_offset": 11,
//                    },
//                    "page_number": 1,
//                    "bounding_poly": {
//                       "normalized_vertices": [
//                         {"x": 0.1, "y": 0.1},
//                         {"x": 0.1, "y": 0.3},
//                         {"x": 0.3, "y": 0.3},
//                         {"x": 0.3, "y": 0.1},
//                       ],
//                     },
//                     "text_segment_type": TOKEN,
//                 }
//               ],
//               "document_dimensions": {
//                 "width": 8.27,
//                 "height": 11.69,
//                 "unit": INCH,
//               }
//               "page_count": 3,
//             },
//             "annotations": [
//               {
//                 "display_name": "animal",
//                 "text_extraction": {
//                   "text_segment": {"start_offset": 0, "end_offset": 3}
//                 }
//               },
//               {
//                 "display_name": "vehicle",
//                 "text_extraction": {
//                   "text_segment": {"start_offset": 4, "end_offset": 7}
//                 }
//               },
//               {
//                 "display_name": "animal",
//                 "text_extraction": {
//                   "text_segment": {"start_offset": 8, "end_offset": 11}
//                 }
//               },
//             ],
//
//
//
//
// </section><section><h5>Classification</h5>
//
// See [Preparing your training
// data](https://cloud.google.com/natural-language/automl/docs/prepare) for more
// information.
//
// One or more CSV file(s) with each line in the following format:
//
//     ML_USE,(TEXT_SNIPPET | GCS_FILE_PATH),LABEL,LABEL,...
//
// *   `ML_USE` - Identifies the data set that the current row (file) applies
// to.
//     This value can be one of the following:
//     * `TRAIN` - Rows in this file are used to train the model.
//     * `TEST` - Rows in this file are used to test the model during training.
//     * `UNASSIGNED` - Rows in this file are not categorized. They are
//        Automatically divided into train and test data. 80% for training and
//        20% for testing.
//
// *   `TEXT_SNIPPET` and `GCS_FILE_PATH` are distinguished by a pattern. If
//     the column content is a valid Google Cloud Storage file path, that is,
//     prefixed by "gs://", it is treated as a `GCS_FILE_PATH`. Otherwise, if
//     the content is enclosed in double quotes (""), it is treated as a
//     `TEXT_SNIPPET`. For `GCS_FILE_PATH`, the path must lead to a
//     file with supported extension and UTF-8 encoding, for example,
//     "gs://folder/content.txt" AutoML imports the file content
//     as a text snippet. For `TEXT_SNIPPET`, AutoML imports the column content
//     excluding quotes. In both cases, size of the content must be 10MB or
//     less in size. For zip files, the size of each file inside the zip must be
//     10MB or less in size.
//
//     For the `MULTICLASS` classification type, at most one `LABEL` is allowed.
//     The `ML_USE` and `LABEL` columns are optional.
//     Supported file extensions: .TXT, .PDF, .ZIP
//
// A maximum of 100 unique labels are allowed per CSV row.
//
// Sample rows:
//
//     TRAIN,"They have bad food and very rude",RudeService,BadFood
//     gs://folder/content.txt,SlowService
//     TEST,gs://folder/document.pdf
//     VALIDATE,gs://folder/text_files.zip,BadFood
//
//
//
// </section><section><h5>Sentiment Analysis</h5>
//
// See [Preparing your training
// data](https://cloud.google.com/natural-language/automl/docs/prepare) for more
// information.
//
// CSV file(s) with each line in format:
//
//     ML_USE,(TEXT_SNIPPET | GCS_FILE_PATH),SENTIMENT
//
// *   `ML_USE` - Identifies the data set that the current row (file) applies
// to.
//     This value can be one of the following:
//     * `TRAIN` - Rows in this file are used to train the model.
//     * `TEST` - Rows in this file are used to test the model during training.
//     * `UNASSIGNED` - Rows in this file are not categorized. They are
//        Automatically divided into train and test data. 80% for training and
//        20% for testing.
//
// *   `TEXT_SNIPPET` and `GCS_FILE_PATH` are distinguished by a pattern. If
//     the column content is a valid  Google Cloud Storage file path, that is,
//     prefixed by "gs://", it is treated as a `GCS_FILE_PATH`. Otherwise, if
//     the content is enclosed in double quotes (""), it is treated as a
//     `TEXT_SNIPPET`. For `GCS_FILE_PATH`, the path must lead to a
//     file with supported extension and UTF-8 encoding, for example,
//     "gs://folder/content.txt" AutoML imports the file content
//     as a text snippet. For `TEXT_SNIPPET`, AutoML imports the column content
//     excluding quotes. In both cases, size of the content must be 128kB or
//     less in size. For zip files, the size of each file inside the zip must be
//     128kB or less in size.
//
//     The `ML_USE` and `SENTIMENT` columns are optional.
//     Supported file extensions: .TXT, .PDF, .ZIP
//
// *  `SENTIMENT` - An integer between 0 and
//     Dataset.text_sentiment_dataset_metadata.sentiment_max
//     (inclusive). Describes the ordinal of the sentiment - higher
//     value means a more positive sentiment. All the values are
//     completely relative, i.e. neither 0 needs to mean a negative or
//     neutral sentiment nor sentiment_max needs to mean a positive one -
//     it is just required that 0 is the least positive sentiment
//     in the data, and sentiment_max is the  most positive one.
//     The SENTIMENT shouldn't be confused with "score" or "magnitude"
//     from the previous Natural Language Sentiment Analysis API.
//     All SENTIMENT values between 0 and sentiment_max must be
//     represented in the imported data. On prediction the same 0 to
//     sentiment_max range will be used. The difference between
//     neighboring sentiment values needs not to be uniform, e.g. 1 and
//     2 may be similar whereas the difference between 2 and 3 may be
//     large.
//
// Sample rows:
//
//     TRAIN,"@freewrytin this is way too good for your product",2
//     gs://folder/content.txt,3
//     TEST,gs://folder/document.pdf
//     VALIDATE,gs://folder/text_files.zip,2
//   </section>
// </div>
//
//
// **Input field definitions:**
//
// `ML_USE`
// : ("TRAIN" | "VALIDATE" | "TEST" | "UNASSIGNED")
//   Describes how the given example (file) should be used for model
//   training. "UNASSIGNED" can be used when user has no preference.
//
// `GCS_FILE_PATH`
// : The path to a file on Google Cloud Storage. For example,
//   "gs://folder/image1.png".
//
// `LABEL`
// : A display name of an object on an image, video etc., e.g. "dog".
//   Must be up to 32 characters long and can consist only of ASCII
//   Latin letters A-Z and a-z, underscores(_), and ASCII digits 0-9.
//   For each label an AnnotationSpec is created which display_name
//   becomes the label; AnnotationSpecs are given back in predictions.
//
// `BOUNDING_BOX`
// : (`VERTEX,VERTEX,VERTEX,VERTEX` | `VERTEX,,,VERTEX,,`)
//   A rectangle parallel to the frame of the example (image,
//   video). If 4 vertices are given they are connected by edges
//   in the order provided, if 2 are given they are recognized
//   as diagonally opposite vertices of the rectangle.
//
// `VERTEX`
// : (`COORDINATE,COORDINATE`)
//   First coordinate is horizontal (x), the second is vertical (y).
//
// `COORDINATE`
// : A float in 0 to 1 range, relative to total length of
//   image or video in given dimension. For fractions the
//   leading non-decimal 0 can be omitted (i.e. 0.3 = .3).
//   Point 0,0 is in top left.
//
// `TEXT_SNIPPET`
// : The content of a text snippet, UTF-8 encoded, enclosed within
//   double quotes ("").
//
// `DOCUMENT`
// : A field that provides the textual content with document and the layout
//   information.
//
//
//  **Errors:**
//
//  If any of the provided CSV files can't be parsed or if more than certain
//  percent of CSV rows cannot be processed then the operation fails and
//  nothing is imported. Regardless of overall success or failure the per-row
//  failures, up to a certain count cap, is listed in
//  Operation.metadata.partial_failures.
//
type InputConfig struct {
	// The source of the input.
	//
	// Types that are valid to be assigned to Source:
	//	*InputConfig_GcsSource
	Source isInputConfig_Source `protobuf_oneof:"source"`
	// Additional domain-specific parameters describing the semantic of the
	// imported data, any string must be up to 25000
	// characters long.
	Params               map[string]string `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_929966d18309cd53, []int{0}
}

func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (m *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(m, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (m *InputConfig) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InputConfig_GcsSource)(nil),
	}
}

// Input configuration for BatchPredict Action.
//
// The format of input depends on the ML problem of the model used for
// prediction. As input source the
// [gcs_source][google.cloud.automl.v1.InputConfig.gcs_source]
// is expected, unless specified otherwise.
//
// The formats are represented in EBNF with commas being literal and with
// non-terminal symbols defined near the end of this comment. The formats
// are:
//
// <h4>AutoML Natural Language</h4>
// <div class="ds-selector-tabs"><section><h5>Classification</h5>
//
// One or more CSV files where each line is a single column:
//
//     GCS_FILE_PATH
//
// `GCS_FILE_PATH` is the Google Cloud Storage location of a text file.
// Supported file extensions: .TXT, .PDF
// Text files can be no larger than 10MB in size.
//
// Sample rows:
//
//     gs://folder/text1.txt
//     gs://folder/text2.pdf
//
// </section><section><h5>Sentiment Analysis</h5>
// One or more CSV files where each line is a single column:
//
//     GCS_FILE_PATH
//
// `GCS_FILE_PATH` is the Google Cloud Storage location of a text file.
// Supported file extensions: .TXT, .PDF
// Text files can be no larger than 128kB in size.
//
// Sample rows:
//
//     gs://folder/text1.txt
//     gs://folder/text2.pdf
//
// </section><section><h5>Entity Extraction</h5>
//
// One or more JSONL (JSON Lines) files that either provide inline text or
// documents. You can only use one format, either inline text or documents,
// for a single call to [AutoMl.BatchPredict].
//
// Each JSONL file contains a per line a proto that
// wraps a temporary user-assigned TextSnippet ID (string up to 2000
// characters long) called "id", a TextSnippet proto (in
// JSON representation) and zero or more TextFeature protos. Any given
// text snippet content must have 30,000 characters or less, and also
// be UTF-8 NFC encoded (ASCII already is). The IDs provided should be
// unique.
//
// Each document JSONL file contains, per line, a proto that wraps a
// Document proto with `input_config` set. Only PDF documents are
// currently supported, and each PDF document cannot exceed 2MB in size.
//
// Each JSONL file must not exceed 100MB in size, and no more than 20
// JSONL files may be passed.
//
// Sample inline JSONL file (Shown with artificial line
// breaks. Actual line breaks are denoted by "\n".):
//
//     {
//        "id": "my_first_id",
//        "text_snippet": { "content": "dog car cat"},
//        "text_features": [
//          {
//            "text_segment": {"start_offset": 4, "end_offset": 6},
//            "structural_type": PARAGRAPH,
//            "bounding_poly": {
//              "normalized_vertices": [
//                {"x": 0.1, "y": 0.1},
//                {"x": 0.1, "y": 0.3},
//                {"x": 0.3, "y": 0.3},
//                {"x": 0.3, "y": 0.1},
//              ]
//            },
//          }
//        ],
//      }\n
//      {
//        "id": "2",
//        "text_snippet": {
//          "content": "Extended sample content",
//          "mime_type": "text/plain"
//        }
//      }
//
// Sample document JSONL file (Shown with artificial line
// breaks. Actual line breaks are denoted by "\n".):
//
//      {
//        "document": {
//          "input_config": {
//            "gcs_source": { "input_uris": [ "gs://folder/document1.pdf" ]
//            }
//          }
//        }
//      }\n
//      {
//        "document": {
//          "input_config": {
//            "gcs_source": { "input_uris": [ "gs://folder/document2.pdf" ]
//            }
//          }
//        }
//      }
//   </section>
// </div>
//
// **Input field definitions:**
//
// `GCS_FILE_PATH`
// : The path to a file on Google Cloud Storage. For example,
//   "gs://folder/video.avi".
//
//  **Errors:**
//
//  If any of the provided CSV files can't be parsed or if more than certain
//  percent of CSV rows cannot be processed then the operation fails and
//  prediction does not happen. Regardless of overall success or failure the
//  per-row failures, up to a certain count cap, will be listed in
//  Operation.metadata.partial_failures.
type BatchPredictInputConfig struct {
	// The source of the input.
	//
	// Types that are valid to be assigned to Source:
	//	*BatchPredictInputConfig_GcsSource
	Source               isBatchPredictInputConfig_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *BatchPredictInputConfig) Reset()         { *m = BatchPredictInputConfig{} }
func (m *BatchPredictInputConfig) String() string { return proto.CompactTextString(m) }
func (*BatchPredictInputConfig) ProtoMessage()    {}
func (*BatchPredictInputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_929966d18309cd53, []int{1}
}

func (m *BatchPredictInputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchPredictInputConfig.Unmarshal(m, b)
}
func (m *BatchPredictInputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchPredictInputConfig.Marshal(b, m, deterministic)
}
func (m *BatchPredictInputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchPredictInputConfig.Merge(m, src)
}
func (m *BatchPredictInputConfig) XXX_Size() int {
	return xxx_messageInfo_BatchPredictInputConfig.Size(m)
}
func (m *BatchPredictInputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchPredictInputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_BatchPredictInputConfig proto.InternalMessageInfo

type isBatchPredictInputConfig_Source interface {
	isBatchPredictInputConfig_Source()
}

type BatchPredictInputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*BatchPredictInputConfig_GcsSource) isBatchPredictInputConfig_Source() {}

func (m *BatchPredictInputConfig) GetSource() isBatchPredictInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *BatchPredictInputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*BatchPredictInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BatchPredictInputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BatchPredictInputConfig_GcsSource)(nil),
	}
}

// Input configuration of a [Document][google.cloud.automl.v1.Document].
type DocumentInputConfig struct {
	// The Google Cloud Storage location of the document file. Only a single path
	// should be given.
	//
	// Max supported size: 512MB.
	//
	// Supported extensions: .PDF.
	GcsSource            *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3" json:"gcs_source,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *DocumentInputConfig) Reset()         { *m = DocumentInputConfig{} }
func (m *DocumentInputConfig) String() string { return proto.CompactTextString(m) }
func (*DocumentInputConfig) ProtoMessage()    {}
func (*DocumentInputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_929966d18309cd53, []int{2}
}

func (m *DocumentInputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DocumentInputConfig.Unmarshal(m, b)
}
func (m *DocumentInputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DocumentInputConfig.Marshal(b, m, deterministic)
}
func (m *DocumentInputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DocumentInputConfig.Merge(m, src)
}
func (m *DocumentInputConfig) XXX_Size() int {
	return xxx_messageInfo_DocumentInputConfig.Size(m)
}
func (m *DocumentInputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DocumentInputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DocumentInputConfig proto.InternalMessageInfo

func (m *DocumentInputConfig) GetGcsSource() *GcsSource {
	if m != nil {
		return m.GcsSource
	}
	return nil
}

// Output configuration for ExportData.
//
// As destination the
// [gcs_destination][google.cloud.automl.v1.OutputConfig.gcs_destination]
// must be set unless specified otherwise for a domain. If gcs_destination is
// set then in the given directory a new directory is created. Its name
// will be "export_data-<dataset-display-name>-<timestamp-of-export-call>",
// where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
// Only ground truth annotations are exported (not approved annotations are
// not exported).
//
// The outputs correspond to how the data was imported, and may be used as
// input to import data. The output formats are represented as EBNF with literal
// commas and same non-terminal symbols definitions are these in import data's
// [InputConfig][google.cloud.automl.v1.InputConfig]:
//
//  *  For Image Classification:
//         CSV file(s) `image_classification_1.csv`,
//         `image_classification_2.csv`,...,`image_classification_N.csv`with
//         each line in format:
//         ML_USE,GCS_FILE_PATH,LABEL,LABEL,...
//         where GCS_FILE_PATHs point at the original, source locations of the
//         imported images.
//         For MULTICLASS classification type, there can be at most one LABEL
//         per example.
//
//  *  For Image Object Detection:
//         CSV file(s) `image_object_detection_1.csv`,
//         `image_object_detection_2.csv`,...,`image_object_detection_N.csv`
//         with each line in format:
//         ML_USE,GCS_FILE_PATH,[LABEL],(BOUNDING_BOX | ,,,,,,,)
//         where GCS_FILE_PATHs point at the original, source locations of the
//         imported images.
//
//  *  For Text Classification:
//         In the created directory CSV file(s) `text_classification_1.csv`,
//         `text_classification_2.csv`, ...,`text_classification_N.csv` will be
//         created where N depends on the total number of examples exported.
//         Each line in the CSV is of the format:
//         ML_USE,GCS_FILE_PATH,LABEL,LABEL,...
//         where GCS_FILE_PATHs point at the exported .txt files containing
//         the text content of the imported example. For MULTICLASS
//         classification type, there will be at most one LABEL per example.
//
//  *  For Text Sentiment:
//         In the created directory CSV file(s) `text_sentiment_1.csv`,
//         `text_sentiment_2.csv`, ...,`text_sentiment_N.csv` will be
//         created where N depends on the total number of examples exported.
//         Each line in the CSV is of the format:
//         ML_USE,GCS_FILE_PATH,SENTIMENT
//         where GCS_FILE_PATHs point at the exported .txt files containing
//         the text content of the imported example.
//
//  *  For Text Extraction:
//         CSV file `text_extraction.csv`, with each line in format:
//         ML_USE,GCS_FILE_PATH
//         GCS_FILE_PATH leads to a .JSONL (i.e. JSON Lines) file which
//         contains, per line, a proto that wraps a TextSnippet proto (in json
//         representation) followed by AnnotationPayload protos (called
//         annotations). If initially documents had been imported, the JSONL
//         will point at the original, source locations of the imported
//         documents.
//
//  *  For Translation:
//         CSV file `translation.csv`, with each line in format:
//         ML_USE,GCS_FILE_PATH
//         GCS_FILE_PATH leads to a .TSV file which describes examples that have
//         given ML_USE, using the following row format per line:
//         TEXT_SNIPPET (in source language) \t TEXT_SNIPPET (in target
//         language)
type OutputConfig struct {
	// The destination of the output.
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_929966d18309cd53, []int{3}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
}

// Output configuration for BatchPredict Action.
//
// As destination the
//
// [gcs_destination][google.cloud.automl.v1.BatchPredictOutputConfig.gcs_destination]
// must be set unless specified otherwise for a domain. If gcs_destination is
// set then in the given directory a new directory is created. Its name
// will be
// "prediction-<model-display-name>-<timestamp-of-prediction-call>",
// where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. The contents
// of it depends on the ML problem the predictions are made for.
//
//  *  For Text Classification:
//         In the created directory files `text_classification_1.jsonl`,
//         `text_classification_2.jsonl`,...,`text_classification_N.jsonl`
//         will be created, where N may be 1, and depends on the
//         total number of inputs and annotations found.
//
//         Each .JSONL file will contain, per line, a JSON representation of a
//         proto that wraps input text (or pdf) file in
//         the text snippet (or document) proto and a list of
//         zero or more AnnotationPayload protos (called annotations), which
//         have classification detail populated. A single text (or pdf) file
//         will be listed only once with all its annotations, and its
//         annotations will never be split across files.
//
//         If prediction for any text (or pdf) file failed (partially or
//         completely), then additional `errors_1.jsonl`, `errors_2.jsonl`,...,
//         `errors_N.jsonl` files will be created (N depends on total number of
//         failed predictions). These files will have a JSON representation of a
//         proto that wraps input text (or pdf) file followed by exactly one
//
// [`google.rpc.Status`](https:
// //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
//         containing only `code` and `message`.
//
//  *  For Text Sentiment:
//         In the created directory files `text_sentiment_1.jsonl`,
//         `text_sentiment_2.jsonl`,...,`text_sentiment_N.jsonl`
//         will be created, where N may be 1, and depends on the
//         total number of inputs and annotations found.
//
//         Each .JSONL file will contain, per line, a JSON representation of a
//         proto that wraps input text (or pdf) file in
//         the text snippet (or document) proto and a list of
//         zero or more AnnotationPayload protos (called annotations), which
//         have text_sentiment detail populated. A single text (or pdf) file
//         will be listed only once with all its annotations, and its
//         annotations will never be split across files.
//
//         If prediction for any text (or pdf) file failed (partially or
//         completely), then additional `errors_1.jsonl`, `errors_2.jsonl`,...,
//         `errors_N.jsonl` files will be created (N depends on total number of
//         failed predictions). These files will have a JSON representation of a
//         proto that wraps input text (or pdf) file followed by exactly one
//
// [`google.rpc.Status`](https:
// //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
//         containing only `code` and `message`.
//
//   *  For Text Extraction:
//         In the created directory files `text_extraction_1.jsonl`,
//         `text_extraction_2.jsonl`,...,`text_extraction_N.jsonl`
//         will be created, where N may be 1, and depends on the
//         total number of inputs and annotations found.
//         The contents of these .JSONL file(s) depend on whether the input
//         used inline text, or documents.
//         If input was inline, then each .JSONL file will contain, per line,
//           a JSON representation of a proto that wraps given in request text
//           snippet's "id" (if specified), followed by input text snippet,
//           and a list of zero or more
//           AnnotationPayload protos (called annotations), which have
//           text_extraction detail populated. A single text snippet will be
//           listed only once with all its annotations, and its annotations will
//           never be split across files.
//         If input used documents, then each .JSONL file will contain, per
//           line, a JSON representation of a proto that wraps given in request
//           document proto, followed by its OCR-ed representation in the form
//           of a text snippet, finally followed by a list of zero or more
//           AnnotationPayload protos (called annotations), which have
//           text_extraction detail populated and refer, via their indices, to
//           the OCR-ed text snippet. A single document (and its text snippet)
//           will be listed only once with all its annotations, and its
//           annotations will never be split across files.
//         If prediction for any text snippet failed (partially or completely),
//         then additional `errors_1.jsonl`, `errors_2.jsonl`,...,
//         `errors_N.jsonl` files will be created (N depends on total number of
//         failed predictions). These files will have a JSON representation of a
//         proto that wraps either the "id" : "<id_value>" (in case of inline)
//         or the document proto (in case of document) but here followed by
//         exactly one [`google.rpc.Status`](https:
// //github.com/googleapis/googleapis/blob/master/google/rpc/status.proto)
//         containing only `code` and `message`.
type BatchPredictOutputConfig struct {
	// The destination of the output.
	//
	// Types that are valid to be assigned to Destination:
	//	*BatchPredictOutputConfig_GcsDestination
	Destination          isBatchPredictOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *BatchPredictOutputConfig) Reset()         { *m = BatchPredictOutputConfig{} }
func (m *BatchPredictOutputConfig) String() string { return proto.CompactTextString(m) }
func (*BatchPredictOutputConfig) ProtoMessage()    {}
func (*BatchPredictOutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_929966d18309cd53, []int{4}
}

func (m *BatchPredictOutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchPredictOutputConfig.Unmarshal(m, b)
}
func (m *BatchPredictOutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchPredictOutputConfig.Marshal(b, m, deterministic)
}
func (m *BatchPredictOutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchPredictOutputConfig.Merge(m, src)
}
func (m *BatchPredictOutputConfig) XXX_Size() int {
	return xxx_messageInfo_BatchPredictOutputConfig.Size(m)
}
func (m *BatchPredictOutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchPredictOutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_BatchPredictOutputConfig proto.InternalMessageInfo

type isBatchPredictOutputConfig_Destination interface {
	isBatchPredictOutputConfig_Destination()
}

type BatchPredictOutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*BatchPredictOutputConfig_GcsDestination) isBatchPredictOutputConfig_Destination() {}

func (m *BatchPredictOutputConfig) GetDestination() isBatchPredictOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *BatchPredictOutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*BatchPredictOutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BatchPredictOutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BatchPredictOutputConfig_GcsDestination)(nil),
	}
}

// Output configuration for ModelExport Action.
type ModelExportOutputConfig struct {
	// The destination of the output.
	//
	// Types that are valid to be assigned to Destination:
	//	*ModelExportOutputConfig_GcsDestination
	Destination isModelExportOutputConfig_Destination `protobuf_oneof:"destination"`
	// The format in which the model must be exported. The available, and default,
	// formats depend on the problem and model type (if given problem and type
	// combination doesn't have a format listed, it means its models are not
	// exportable):
	//
	// *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
	//        mobile-high-accuracy-1:
	//      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "tf_js".
	//
	// *  For Image Classification mobile-core-ml-low-latency-1,
	//        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
	//      "core_ml" (default).
	//
	// *  For Image Object Detection mobile-low-latency-1, mobile-versatile-1,
	//        mobile-high-accuracy-1:
	//      "tflite", "tf_saved_model", "tf_js".
	// Formats description:
	//
	// * tflite - Used for Android mobile devices.
	// * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
	//                    devices.
	// * tf_saved_model - A tensorflow model in SavedModel format.
	// * tf_js - A [TensorFlow.js](https://www.tensorflow.org/js) model that can
	//           be used in the browser and in Node.js using JavaScript.x`
	// * core_ml - Used for iOS mobile devices.
	ModelFormat string `protobuf:"bytes,4,opt,name=model_format,json=modelFormat,proto3" json:"model_format,omitempty"`
	// Additional model-type and format specific parameters describing the
	// requirements for the to be exported model files, any string must be up to
	// 25000 characters long.
	Params               map[string]string `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ModelExportOutputConfig) Reset()         { *m = ModelExportOutputConfig{} }
func (m *ModelExportOutputConfig) String() string { return proto.CompactTextString(m) }
func (*ModelExportOutputConfig) ProtoMessage()    {}
func (*ModelExportOutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_929966d18309cd53, []int{5}
}

func (m *ModelExportOutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModelExportOutputConfig.Unmarshal(m, b)
}
func (m *ModelExportOutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModelExportOutputConfig.Marshal(b, m, deterministic)
}
func (m *ModelExportOutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModelExportOutputConfig.Merge(m, src)
}
func (m *ModelExportOutputConfig) XXX_Size() int {
	return xxx_messageInfo_ModelExportOutputConfig.Size(m)
}
func (m *ModelExportOutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ModelExportOutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ModelExportOutputConfig proto.InternalMessageInfo

type isModelExportOutputConfig_Destination interface {
	isModelExportOutputConfig_Destination()
}

type ModelExportOutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*ModelExportOutputConfig_GcsDestination) isModelExportOutputConfig_Destination() {}

func (m *ModelExportOutputConfig) GetDestination() isModelExportOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *ModelExportOutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*ModelExportOutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (m *ModelExportOutputConfig) GetModelFormat() string {
	if m != nil {
		return m.ModelFormat
	}
	return ""
}

func (m *ModelExportOutputConfig) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ModelExportOutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ModelExportOutputConfig_GcsDestination)(nil),
	}
}

// The Google Cloud Storage location for the input content.
type GcsSource struct {
	// Required. Google Cloud Storage URIs to input files, up to 2000
	// characters long. Accepted forms:
	// * Full object path, e.g. gs://bucket/directory/object.csv
	InputUris            []string `protobuf:"bytes,1,rep,name=input_uris,json=inputUris,proto3" json:"input_uris,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_929966d18309cd53, []int{6}
}

func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (m *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(m, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetInputUris() []string {
	if m != nil {
		return m.InputUris
	}
	return nil
}

// The Google Cloud Storage location where the output is to be written to.
type GcsDestination struct {
	// Required. Google Cloud Storage URI to output directory, up to 2000
	// characters long.
	// Accepted forms:
	// * Prefix path: gs://bucket/directory
	// The requesting user must have write permission to the bucket.
	// The directory is created if it doesn't exist.
	OutputUriPrefix      string   `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_929966d18309cd53, []int{7}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

func (m *GcsDestination) GetOutputUriPrefix() string {
	if m != nil {
		return m.OutputUriPrefix
	}
	return ""
}

func init() {
	proto.RegisterType((*InputConfig)(nil), "google.cloud.automl.v1.InputConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.InputConfig.ParamsEntry")
	proto.RegisterType((*BatchPredictInputConfig)(nil), "google.cloud.automl.v1.BatchPredictInputConfig")
	proto.RegisterType((*DocumentInputConfig)(nil), "google.cloud.automl.v1.DocumentInputConfig")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.automl.v1.OutputConfig")
	proto.RegisterType((*BatchPredictOutputConfig)(nil), "google.cloud.automl.v1.BatchPredictOutputConfig")
	proto.RegisterType((*ModelExportOutputConfig)(nil), "google.cloud.automl.v1.ModelExportOutputConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.ModelExportOutputConfig.ParamsEntry")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.automl.v1.GcsSource")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.automl.v1.GcsDestination")
}

func init() { proto.RegisterFile("google/cloud/automl/v1/io.proto", fileDescriptor_929966d18309cd53) }

var fileDescriptor_929966d18309cd53 = []byte{
	// 541 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x54, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0xc5, 0x0e, 0x54, 0x64, 0x5c, 0x5a, 0x30, 0xa8, 0x35, 0x11, 0x52, 0x53, 0x1f, 0x50, 0x4e,
	0xb6, 0x52, 0x2e, 0xe0, 0x72, 0x20, 0x69, 0x4b, 0x40, 0xa2, 0x22, 0x4a, 0xd5, 0x20, 0xa1, 0x48,
	0xd1, 0xd6, 0xd9, 0xb8, 0x2b, 0xec, 0x1d, 0x6b, 0xbd, 0x1b, 0xb5, 0x47, 0x7e, 0xa7, 0x57, 0xfe,
	0x82, 0x9f, 0x80, 0x33, 0x5f, 0x81, 0xb2, 0x9b, 0x50, 0x27, 0x22, 0x1c, 0x2a, 0x04, 0xb7, 0xdd,
	0x79, 0xf3, 0xe6, 0xcd, 0x9b, 0x1d, 0x2d, 0xec, 0x24, 0x88, 0x49, 0x4a, 0xc3, 0x38, 0x45, 0x35,
	0x0a, 0x89, 0x92, 0x98, 0xa5, 0xe1, 0xa4, 0x19, 0x32, 0x0c, 0x72, 0x81, 0x12, 0xdd, 0x2d, 0x93,
	0x10, 0xe8, 0x84, 0xc0, 0x24, 0x04, 0x93, 0x66, 0xed, 0xc9, 0x8c, 0x48, 0x72, 0x16, 0x12, 0xce,
	0x51, 0x12, 0xc9, 0x90, 0x17, 0x86, 0x55, 0xdb, 0x29, 0xa1, 0x63, 0x46, 0xd3, 0xd1, 0xf0, 0x8c,
	0x9e, 0x93, 0x09, 0x43, 0x61, 0x12, 0xfc, 0x6f, 0x16, 0x38, 0x6f, 0x79, 0xae, 0xe4, 0x01, 0xf2,
	0x31, 0x4b, 0xdc, 0x36, 0x40, 0x12, 0x17, 0xc3, 0x02, 0x95, 0x88, 0xa9, 0x67, 0xd5, 0xad, 0x86,
	0xb3, 0xb7, 0x1b, 0xfc, 0x5e, 0x3b, 0xe8, 0xc4, 0xc5, 0x89, 0x4e, 0x7c, 0x73, 0xab, 0x57, 0x4d,
	0xe6, 0x17, 0xb7, 0x03, 0x6b, 0x39, 0x11, 0x24, 0x2b, 0x3c, 0xbb, 0x5e, 0x69, 0x38, 0x7b, 0xe1,
	0x2a, 0x7e, 0x49, 0x38, 0xe8, 0x6a, 0xc6, 0x11, 0x97, 0xe2, 0xb2, 0x37, 0xa3, 0xd7, 0x5e, 0x80,
	0x53, 0x0a, 0xbb, 0xf7, 0xa1, 0xf2, 0x89, 0x5e, 0xea, 0xa6, 0xaa, 0xbd, 0xe9, 0xd1, 0x7d, 0x04,
	0x77, 0x26, 0x24, 0x55, 0xd4, 0xb3, 0x75, 0xcc, 0x5c, 0x22, 0xfb, 0xb9, 0xd5, 0xbe, 0x0b, 0x6b,
	0xc6, 0x83, 0x9f, 0xc2, 0x76, 0x9b, 0xc8, 0xf8, 0xbc, 0x2b, 0xe8, 0x88, 0xc5, 0xb2, 0x6c, 0xb6,
	0x73, 0x23, 0xb3, 0xed, 0xca, 0xf7, 0x96, 0xbd, 0xe0, 0xb8, 0xa4, 0xf6, 0x01, 0x1e, 0x1e, 0x62,
	0xac, 0x32, 0xca, 0x17, 0x94, 0x5e, 0xdd, 0x48, 0xa9, 0x24, 0xe1, 0x2b, 0x58, 0x7f, 0xaf, 0xe4,
	0x75, 0xc5, 0x3e, 0x6c, 0x4e, 0x2b, 0x8e, 0x68, 0x21, 0x19, 0xd7, 0x6f, 0x3e, 0x2b, 0xfb, 0xf4,
	0x0f, 0x65, 0x0f, 0xaf, 0xb3, 0xe7, 0x2e, 0x36, 0x92, 0xc5, 0xf0, 0x3d, 0x70, 0x4a, 0x35, 0xfd,
	0xcf, 0x16, 0x78, 0xe5, 0xf1, 0xfd, 0x8f, 0x1e, 0xbe, 0xd8, 0xb0, 0x7d, 0x8c, 0x23, 0x9a, 0x1e,
	0x5d, 0xe4, 0x28, 0xfe, 0x49, 0x0b, 0xee, 0x2e, 0xac, 0x67, 0x53, 0xc9, 0xe1, 0x18, 0x45, 0x46,
	0xa4, 0x77, 0x5b, 0x2f, 0x98, 0xa3, 0x63, 0xaf, 0x75, 0xc8, 0x3d, 0x59, 0x5a, 0xf3, 0xfd, 0x55,
	0x8a, 0x2b, 0x7a, 0xff, 0xdb, 0x2b, 0xbf, 0x34, 0xb5, 0x10, 0xaa, 0xbf, 0x16, 0xc9, 0xf5, 0x01,
	0xd8, 0x74, 0x1d, 0x87, 0x4a, 0xb0, 0xc2, 0xb3, 0xea, 0x95, 0x46, 0x55, 0x3b, 0xef, 0x55, 0x75,
	0xf8, 0x54, 0xb0, 0xc2, 0x6f, 0xc1, 0xc6, 0xe2, 0x6c, 0xdc, 0x10, 0x1e, 0xa0, 0x6e, 0x78, 0x4a,
	0x1b, 0xe6, 0x82, 0x8e, 0xd9, 0x85, 0xe9, 0xc5, 0x90, 0x37, 0x0d, 0x7a, 0x2a, 0x58, 0x57, 0x63,
	0xed, 0x2b, 0x0b, 0x6a, 0x31, 0x66, 0x2b, 0x06, 0xd1, 0xb5, 0x3e, 0xbe, 0x9c, 0x21, 0x09, 0xa6,
	0x84, 0x27, 0x01, 0x8a, 0x24, 0x4c, 0x28, 0xd7, 0x5f, 0x51, 0x68, 0x20, 0x92, 0xb3, 0x62, 0xf9,
	0x17, 0xdc, 0x37, 0xa7, 0x2b, 0x7b, 0xab, 0x63, 0xe8, 0x07, 0xba, 0x70, 0x4b, 0x49, 0x3c, 0x7e,
	0x17, 0xf4, 0x9b, 0x5f, 0xe7, 0xc0, 0x40, 0x03, 0x03, 0x03, 0x0c, 0xfa, 0xcd, 0x1f, 0xf6, 0x63,
	0x03, 0x44, 0x91, 0x46, 0xa2, 0xc8, 0x40, 0x51, 0xd4, 0x6f, 0x9e, 0xad, 0x69, 0xd9, 0x67, 0x3f,
	0x03, 0x00, 0x00, 0xff, 0xff, 0x88, 0x5f, 0x35, 0x4e, 0x7b, 0x05, 0x00, 0x00,
}
