import { RetryValue, RetryDelayValue } from '../core/retryer';
import { InfiniteQueryObserverOptions, InfiniteQueryObserverResult, MutateOptions, MutationStatus, MutationKey, QueryObserverOptions, QueryObserverResult, QueryKey, MutationFunction } from '../core/types';
export interface UseBaseQueryOptions<TQueryFnData = unknown, TError = unknown, TData = TQueryFnData, TQueryData = TQueryFnData, TQueryKey extends QueryKey = QueryKey> extends QueryObserverOptions<TQueryFnData, TError, TData, TQueryData, TQueryKey> {
}
export interface UseQueryOptions<TQueryFnData = unknown, TError = unknown, TData = TQueryFnData, TQueryKey extends QueryKey = QueryKey> extends UseBaseQueryOptions<TQueryFnData, TError, TData, TQueryFnData, TQueryKey> {
}
export interface UseInfiniteQueryOptions<TQueryFnData = unknown, TError = unknown, TData = TQueryFnData, TQueryData = TQueryFnData, TQueryKey extends QueryKey = QueryKey> extends InfiniteQueryObserverOptions<TQueryFnData, TError, TData, TQueryData, TQueryKey> {
}
export declare type UseBaseQueryResult<TData = unknown, TError = unknown> = QueryObserverResult<TData, TError>;
export declare type UseQueryResult<TData = unknown, TError = unknown> = UseBaseQueryResult<TData, TError>;
export declare type UseInfiniteQueryResult<TData = unknown, TError = unknown> = InfiniteQueryObserverResult<TData, TError>;
export interface UseMutationOptions<TData = unknown, TError = unknown, TVariables = void, TContext = unknown> {
    mutationFn?: MutationFunction<TData, TVariables>;
    mutationKey?: MutationKey;
    onMutate?: (variables: TVariables) => Promise<TContext> | Promise<undefined> | TContext | undefined;
    onSuccess?: (data: TData, variables: TVariables, context: TContext | undefined) => Promise<unknown> | void;
    onError?: (error: TError, variables: TVariables, context: TContext | undefined) => Promise<unknown> | void;
    onSettled?: (data: TData | undefined, error: TError | null, variables: TVariables, context: TContext | undefined) => Promise<unknown> | void;
    retry?: RetryValue<TError>;
    retryDelay?: RetryDelayValue<TError>;
    useErrorBoundary?: boolean;
}
export declare type UseMutateFunction<TData = unknown, TError = unknown, TVariables = void, TContext = unknown> = (variables: TVariables, options?: MutateOptions<TData, TError, TVariables, TContext>) => void;
export declare type UseMutateAsyncFunction<TData = unknown, TError = unknown, TVariables = void, TContext = unknown> = (variables: TVariables, options?: MutateOptions<TData, TError, TVariables, TContext>) => Promise<TData>;
export interface UseMutationResult<TData = unknown, TError = unknown, TVariables = unknown, TContext = unknown> {
    context: TContext | undefined;
    data: TData | undefined;
    error: TError | null;
    failureCount: number;
    isError: boolean;
    isIdle: boolean;
    isLoading: boolean;
    isPaused: boolean;
    isSuccess: boolean;
    mutate: UseMutateFunction<TData, TError, TVariables, TContext>;
    mutateAsync: UseMutateAsyncFunction<TData, TError, TVariables, TContext>;
    reset: () => void;
    status: MutationStatus;
    variables: TVariables | undefined;
}
